A loose catalog of resources for casual game development with Flutter.

## Game engines and tools

- [Flame Engine (2D game engine)](https://flame-engine.org/)
- [Bonfire (RPG games)](https://pub.dev/packages/bonfire)
- [SpriteWidget](https://github.com/spritewidget/spritewidget)
- [Flutter Processing](https://github.com/matthew-carroll/flutter_processing)
- [Rive (animation designer)](https://rive.app/)
- [StageXl (Dart+Web, but not Flutter)](http://www.stagexl.org/)

## Games built with Flutter / developer experiences
- [4 Pics 1 Word](https://play.google.com/store/apps/details?id=de.lotum.whatsinthefoto.us)
- [Tomb Toad](http://www.missionctrlgames.com/) | [tweet](https://twitter.com/missionctrlgame/status/1329149448971280385)
- [Flame Game Jam entries](https://itch.io/jam/1st-flame-game-jam/entries)
- [A list of Flutter games built on top of Flame](https://flame-engine-store.web.app/#/)
- [Porting an iOS game to Flutter](https://twitter.com/drcoderz/status/1458449373424062474)
- [Space Empire](https://github.com/SatyamX64/space_empires)
- [Sunnyplace](https://play.google.com/store/apps/details?id=br.com.sunnyplace)
- [Tap Hero](https://github.com/mkiisoft/taphero)
- [Pop, Pop, Win!](https://dart-lang.github.io/sample-pop_pop_win/) (Mine Sweeper w/ balloons and darts) – OG Dart+Web game w/ StageXL (not Flutter)
- [Flutter Slide Puzzle](https://flutter.github.io/samples/web/slide_puzzle/) - Created for original Flutter web launch
- [Community-submitted games](https://flutterawesome.com/tag/games/)
- [Flutter Backgammon](https://github.com/csells/fibscli)

## Tutorials
- [Building a snake game with Flutter](https://www.raywenderlich.com/19430602-how-to-create-a-2d-snake-game-in-flutter)
- [Flappy Bird with Flutter Processing](https://www.youtube.com/watch?v=l2LO_pBEP5Y)
- [Create a game with Flame Engine](https://blog.devowl.de/flutter-flame-step-1-create-your-game-b3b6ee387d77)
- [Flutter games from scratch](https://www.youtube.com/playlist?list=PLlvRDpXh1Se6kipeBLiF1xByAEmxYie6J)

## Communities
- [FlameCon](https://www.meetup.com/FlameCon/)

## Other useful resources
- [Monetization](https://flutter.dev/ads)
- [Firebase (auth, storage, hosting, testing, analytics, cloud functions)](https://firebase.flutter.dev/docs/overview)