This wiki is primarily aimed at engineers building or making contributions to Flutter.

If you are new to Flutter, then you will find more general information on the Flutter project, including tutorials and samples, on our Web site at [flutter.dev](https://flutter.dev). For specific information about Flutter's APIs, consider our API reference which can be found at the [api.flutter.dev](https://api.flutter.dev/).

If you want to know what we're likely to do in the future, our [[roadmap]] may be of interest.

If you intend to contribute to Flutter, welcome! You are encouraged to start with [our contributor guide](https://github.com/flutter/flutter/blob/master/CONTRIBUTING.md), which helps onboard new team members. It points to the most relevant pages on this wiki. You are also invited to join our [Discord](https://github.com/flutter/flutter/wiki/Chat) server.

## Search

[Search this wiki on Google](https://www.google.com/search?q=site%3Ahttps%3A%2F%2Fgithub.com%2Fflutter%2Fflutter%2Fwiki%2F).

## Index of notable sections

* [Actionable bugs](https://github.com/flutter/flutter/wiki/Triage#what-makes-an-issue-actionable), and the closing of unactionable bugs
* [Breaking changes](https://github.com/flutter/flutter/wiki/Tree-hygiene#handling-breaking-changes)
* [Cherrypick process](https://github.com/flutter/flutter/wiki/Flutter-Cherrypick-Process)
* [Closing issues](https://github.com/flutter/flutter/wiki/Issue-hygiene#closing-issues)
* [[Dashboards]]
* [Debugging a broken engine autoroll](https://github.com/flutter/flutter/wiki/Debugging-the-engine#bisecting-a-roll-failure)
* [Deprecations](https://github.com/flutter/flutter/wiki/Tree-hygiene#deprecations)
* [[Design documents]]
* [Discord](https://github.com/flutter/flutter/wiki/Chat)
* [Engineering Philosophy](https://github.com/flutter/flutter/wiki/Style-guide-for-Flutter-repo#philosophy)
* [Flaky tests](https://github.com/flutter/flutter/wiki/Issue-hygiene#flaky-tests)
* [[flutter.dev is down|In case of emergency]]
* [Issue prioritization](https://github.com/flutter/flutter/wiki/Issue-hygiene#priorities)
* [Labels](https://github.com/flutter/flutter/wiki/Issue-hygiene#labels)
* [Milestones](https://github.com/flutter/flutter/wiki/Issue-hygiene#milestones)
* [Plugin compatibility policy](https://github.com/flutter/flutter/wiki/Style-guide-for-Flutter-repo#plugin-compatibility)
* [Reviewing code](https://github.com/flutter/flutter/wiki/Tree-hygiene#how-to-review-code)
* [RFC process](https://github.com/flutter/flutter/wiki/Issue-hygiene#how-to-propose-a-specific-change)
* [Status of popular issues](https://github.com/flutter/flutter/wiki/Popular-issues)
* [Submitting code, process for](https://github.com/flutter/flutter/wiki/Tree-hygiene#overview)
* [Support levels, definitions of](https://github.com/flutter/flutter/wiki/Values#support)
* [Symbolicating stack traces](https://github.com/flutter/flutter/wiki/Crashes)
* [Threading in the Engine](https://github.com/flutter/flutter/wiki/The-Engine-architecture#threading)
* [When will my bug be fixed?](https://github.com/flutter/flutter/wiki/Issue-hygiene#when-will-my-bug-be-fixed)
* [Security best practices](https://github.com/flutter/flutter/wiki/security#Best-practices)