<!-- Don't add user documentation to the wiki. User documentation belongs on the web site. -->
<!-- We only have these pages for historical reasons. -->

Flutter's user-facing documentation should all be on the Flutter web site and the API documentation site:

- https://docs.flutter.dev/
  - [Release notes](https://flutter.dev/docs/development/tools/sdk/release-notes)
- https://api.flutter.dev/

Historically, experimental documentation was sometimes first written on this wiki and later moved to the web site. This is
now discouraged but some of the content created in this way still exists and is listed below.

_Contributors: please consider moving this content to the web site or deleting it if it is no longer applicable!_

## Old documentation

## General

<!-- don't add things here; if you have a new feature, it should be documented on the web site not the wiki -->
- [Apple Silicon support](https://github.com/flutter/flutter/wiki/Developing-with-Flutter-on-Apple-Silicon)
- [[Bad Builds]]
- [[Binding to native code via FFI]] (moved to website)
- [[Code generation in Flutter]]
- [[Codelabs]]
- [[Data-driven Fixes]]
- [[Desktop shells]]
- [[Deferred Components]]
- [[Flutter CLI crash reporting]]
- [Flutter CLI custom embedder support](https://github.com/flutter/flutter/wiki/Using-custom-embedders-with-the-Flutter-CLI)
- [[Flutter Test Fonts]]
- [[Game development with Flutter]]
- [[Hybrid Composition]]
- [[IntelliJ - Flutter Setup Tips and Tricks]]
- [JIT release builds](https://github.com/flutter/flutter/wiki/JIT-Release-Modes)
- [[Making animated GIFs of Flutter apps]]
- [[Multi-device debugging in VS Code]]
- [Null safety package migration status](https://github.com/dart-lang/sdk/wiki/Null-safety-migration-status)
- [[Obfuscating Dart Code]]
- [[Reduce shader compilation jank using SkSL warm up]] (moved to website)
- [[Upgrading Flutter projects from using PlatformMessages to using channels]]
- [[Writing Effective Tests]]

### Android
<!-- don't add things here; user documentation belongs on the web site not the wiki -->
- [Android Fast Start](https://github.com/flutter/flutter/wiki/Fast-Start)
- [[Android Platform Views]]
- [[Experimental: Add Flutter Activity]] (moved to website)
- [[Experimental: Add Flutter Fragment]]
- [[Experimental: Add Flutter Fragment ViewPager]]
- [[Experimental: Add Flutter View]]
- [[Experimental: Create Flutter Plugin]] (moved to website)
- [[Experimental: Launch Flutter with non main entrypoint]]
- [[Experimental: Reuse FlutterEngine across screens]]
- [[Experimental: Use old plugins with new embedding]]
- [[How Flutter apps are compiled with Gradle for Android]]
- [[Hybrid Composition|Hybrid Composition#Android]]
- [Multidex](https://github.com/flutter/flutter/wiki/Android-Multidex-support)
- [[Texture Layer Hybrid Composition]]
- [[Upgrading Flutter projects to build with gradle]]
- [[Upgrading Flutter projects to Gradle 4.1 and Android Studio Gradle plugin 3.0.1]]
- [[Upgrading pre 1.12 Android projects]]

### iOS
<!-- don't add things here; user documentation belongs on the web site not the wiki -->
- [[Creating an iOS Bitcode enabled app]]
- [[Hybrid Composition|Hybrid Composition#iOS]]
- [[Hybrid Composition iOS]]
- [[PID leak in iOS development workflow]]
- [[State of Catalina Support]] in Flutter 1.9.
- [[Upgrading Flutter added to existing iOS Xcode project]]

### Web
<!-- don't add things here; user documentation belongs on the web site not the wiki -->
- [[Debugging issues on the Web]]
- [[Running Flutter Driver tests with Web]]
- [[Upgrading from package:flutter_web to the Flutter SDK]]

### Release notes
<!-- don't add things here; user documentation belongs on the web site not the wiki -->
- [[Hotfixes to the Stable Channel]]
- [[Release Notes - Changes in 1.2.1]]
- [[Release Notes - Flutter 1.2.1]]
- [[Commits Between 1.2.1 and 1.5.4]]
- [[Release Notes Flutter 1.5.4]]
- [[PRs addressed between 1.5.4 and 1.7.8]]
- [[Release Notes Flutter 1.7.8]]
- [[PRs merged between 1.7.8 and 1.9.1]]
- [[Release Notes Flutter 1.9.1]]
