import 'package:analyzer/dart/analysis/results.dart';
import 'package:analyzer/file_system/overlay_file_system.dart';
import 'package:analyzer/file_system/physical_file_system.dart';
import 'package:analyzer/src/dart/analysis/analysis_context_collection.dart';
import 'package:analyzer/src/dart/analysis/byte_store.dart';

void main() async {
  {
    var byteStore = MemoryByteStore();

    var resourceProvider = OverlayResourceProvider(
      PhysicalResourceProvider.INSTANCE,
    );

    var analysisOptionsPath =
        '/Users/scheglov/Source/Dart/analysis_options.yaml';
    resourceProvider.setOverlay(
      analysisOptionsPath,
      content: r'''
analyzer:
  enable-experiment:
    - macros
''',
      modificationStamp: -1,
    );

    var collection = AnalysisContextCollectionImpl(
      resourceProvider: resourceProvider,
      includedPaths: [
        '/Users/scheglov/Source/Dart/sdk.git/sdk/tests/co19/src/LanguageFeatures/Augmentation-libraries/applying_augmentation_library_A03_t02.dart',
      ],
      byteStore: byteStore,
      optionsFile: analysisOptionsPath,
    );

    var timer = Stopwatch()..start();
    for (var analysisContext in collection.contexts) {
      print(analysisContext.contextRoot.root.path);
      var analysisSession = analysisContext.currentSession;
      for (var path in analysisContext.contextRoot.analyzedFiles()) {
        if (path.endsWith('.dart')) {
          var unitResult = await analysisSession.getResolvedUnit(path);
          if (unitResult is ResolvedUnitResult) {
            // for (final unitResult in libResult.units) {
            print('    ${unitResult.path}');
            var ep = '\n        ';
            print('      errors:$ep${unitResult.errors.join(ep)}');
            print('---');
            print(unitResult.content);
            print('---');
            // }
          }
        }
      }
    }
    print('[time: ${timer.elapsedMilliseconds} ms]');

    await collection.dispose();
  }
}
