// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v18.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#import "messages.g.h"

#if TARGET_OS_OSX
#import <FlutterMacOS/FlutterMacOS.h>
#else
#import <Flutter/Flutter.h>
#endif

#if !__has_feature(objc_arc)
#error File requires ARC to be enabled.
#endif

static NSArray *wrapResult(id result, FlutterError *error) {
  if (error) {
    return @[
      error.code ?: [NSNull null], error.message ?: [NSNull null], error.details ?: [NSNull null]
    ];
  }
  return @[ result ?: [NSNull null] ];
}

static FlutterError *createConnectionError(NSString *channelName) {
  return [FlutterError
      errorWithCode:@"channel-error"
            message:[NSString stringWithFormat:@"%@/%@/%@",
                                               @"Unable to establish connection on channel: '",
                                               channelName, @"'."]
            details:@""];
}

static id GetNullableObjectAtIndex(NSArray *array, NSInteger key) {
  id result = array[key];
  return (result == [NSNull null]) ? nil : result;
}

@implementation FCPPlatformCameraLensDirectionBox
- (instancetype)initWithValue:(FCPPlatformCameraLensDirection)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformDeviceOrientationBox
- (instancetype)initWithValue:(FCPPlatformDeviceOrientation)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformExposureModeBox
- (instancetype)initWithValue:(FCPPlatformExposureMode)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformFlashModeBox
- (instancetype)initWithValue:(FCPPlatformFlashMode)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformFocusModeBox
- (instancetype)initWithValue:(FCPPlatformFocusMode)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

/// Pigeon version of ImageFileFormat.
@implementation FCPPlatformImageFileFormatBox
- (instancetype)initWithValue:(FCPPlatformImageFileFormat)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformImageFormatGroupBox
- (instancetype)initWithValue:(FCPPlatformImageFormatGroup)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@implementation FCPPlatformResolutionPresetBox
- (instancetype)initWithValue:(FCPPlatformResolutionPreset)value {
  self = [super init];
  if (self) {
    _value = value;
  }
  return self;
}
@end

@interface FCPPlatformCameraDescription ()
+ (FCPPlatformCameraDescription *)fromList:(NSArray *)list;
+ (nullable FCPPlatformCameraDescription *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface FCPPlatformCameraState ()
+ (FCPPlatformCameraState *)fromList:(NSArray *)list;
+ (nullable FCPPlatformCameraState *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface FCPPlatformMediaSettings ()
+ (FCPPlatformMediaSettings *)fromList:(NSArray *)list;
+ (nullable FCPPlatformMediaSettings *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface FCPPlatformPoint ()
+ (FCPPlatformPoint *)fromList:(NSArray *)list;
+ (nullable FCPPlatformPoint *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface FCPPlatformSize ()
+ (FCPPlatformSize *)fromList:(NSArray *)list;
+ (nullable FCPPlatformSize *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@implementation FCPPlatformCameraDescription
+ (instancetype)makeWithName:(NSString *)name
               lensDirection:(FCPPlatformCameraLensDirection)lensDirection {
  FCPPlatformCameraDescription *pigeonResult = [[FCPPlatformCameraDescription alloc] init];
  pigeonResult.name = name;
  pigeonResult.lensDirection = lensDirection;
  return pigeonResult;
}
+ (FCPPlatformCameraDescription *)fromList:(NSArray *)list {
  FCPPlatformCameraDescription *pigeonResult = [[FCPPlatformCameraDescription alloc] init];
  pigeonResult.name = GetNullableObjectAtIndex(list, 0);
  pigeonResult.lensDirection = [GetNullableObjectAtIndex(list, 1) integerValue];
  return pigeonResult;
}
+ (nullable FCPPlatformCameraDescription *)nullableFromList:(NSArray *)list {
  return (list) ? [FCPPlatformCameraDescription fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    self.name ?: [NSNull null],
    @(self.lensDirection),
  ];
}
@end

@implementation FCPPlatformCameraState
+ (instancetype)makeWithPreviewSize:(FCPPlatformSize *)previewSize
                       exposureMode:(FCPPlatformExposureMode)exposureMode
                          focusMode:(FCPPlatformFocusMode)focusMode
             exposurePointSupported:(BOOL)exposurePointSupported
                focusPointSupported:(BOOL)focusPointSupported {
  FCPPlatformCameraState *pigeonResult = [[FCPPlatformCameraState alloc] init];
  pigeonResult.previewSize = previewSize;
  pigeonResult.exposureMode = exposureMode;
  pigeonResult.focusMode = focusMode;
  pigeonResult.exposurePointSupported = exposurePointSupported;
  pigeonResult.focusPointSupported = focusPointSupported;
  return pigeonResult;
}
+ (FCPPlatformCameraState *)fromList:(NSArray *)list {
  FCPPlatformCameraState *pigeonResult = [[FCPPlatformCameraState alloc] init];
  pigeonResult.previewSize = [FCPPlatformSize nullableFromList:(GetNullableObjectAtIndex(list, 0))];
  pigeonResult.exposureMode = [GetNullableObjectAtIndex(list, 1) integerValue];
  pigeonResult.focusMode = [GetNullableObjectAtIndex(list, 2) integerValue];
  pigeonResult.exposurePointSupported = [GetNullableObjectAtIndex(list, 3) boolValue];
  pigeonResult.focusPointSupported = [GetNullableObjectAtIndex(list, 4) boolValue];
  return pigeonResult;
}
+ (nullable FCPPlatformCameraState *)nullableFromList:(NSArray *)list {
  return (list) ? [FCPPlatformCameraState fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.previewSize ? [self.previewSize toList] : [NSNull null]),
    @(self.exposureMode),
    @(self.focusMode),
    @(self.exposurePointSupported),
    @(self.focusPointSupported),
  ];
}
@end

@implementation FCPPlatformMediaSettings
+ (instancetype)makeWithResolutionPreset:(FCPPlatformResolutionPreset)resolutionPreset
                         framesPerSecond:(nullable NSNumber *)framesPerSecond
                            videoBitrate:(nullable NSNumber *)videoBitrate
                            audioBitrate:(nullable NSNumber *)audioBitrate
                             enableAudio:(BOOL)enableAudio {
  FCPPlatformMediaSettings *pigeonResult = [[FCPPlatformMediaSettings alloc] init];
  pigeonResult.resolutionPreset = resolutionPreset;
  pigeonResult.framesPerSecond = framesPerSecond;
  pigeonResult.videoBitrate = videoBitrate;
  pigeonResult.audioBitrate = audioBitrate;
  pigeonResult.enableAudio = enableAudio;
  return pigeonResult;
}
+ (FCPPlatformMediaSettings *)fromList:(NSArray *)list {
  FCPPlatformMediaSettings *pigeonResult = [[FCPPlatformMediaSettings alloc] init];
  pigeonResult.resolutionPreset = [GetNullableObjectAtIndex(list, 0) integerValue];
  pigeonResult.framesPerSecond = GetNullableObjectAtIndex(list, 1);
  pigeonResult.videoBitrate = GetNullableObjectAtIndex(list, 2);
  pigeonResult.audioBitrate = GetNullableObjectAtIndex(list, 3);
  pigeonResult.enableAudio = [GetNullableObjectAtIndex(list, 4) boolValue];
  return pigeonResult;
}
+ (nullable FCPPlatformMediaSettings *)nullableFromList:(NSArray *)list {
  return (list) ? [FCPPlatformMediaSettings fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    @(self.resolutionPreset),
    self.framesPerSecond ?: [NSNull null],
    self.videoBitrate ?: [NSNull null],
    self.audioBitrate ?: [NSNull null],
    @(self.enableAudio),
  ];
}
@end

@implementation FCPPlatformPoint
+ (instancetype)makeWithX:(double)x y:(double)y {
  FCPPlatformPoint *pigeonResult = [[FCPPlatformPoint alloc] init];
  pigeonResult.x = x;
  pigeonResult.y = y;
  return pigeonResult;
}
+ (FCPPlatformPoint *)fromList:(NSArray *)list {
  FCPPlatformPoint *pigeonResult = [[FCPPlatformPoint alloc] init];
  pigeonResult.x = [GetNullableObjectAtIndex(list, 0) doubleValue];
  pigeonResult.y = [GetNullableObjectAtIndex(list, 1) doubleValue];
  return pigeonResult;
}
+ (nullable FCPPlatformPoint *)nullableFromList:(NSArray *)list {
  return (list) ? [FCPPlatformPoint fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    @(self.x),
    @(self.y),
  ];
}
@end

@implementation FCPPlatformSize
+ (instancetype)makeWithWidth:(double)width height:(double)height {
  FCPPlatformSize *pigeonResult = [[FCPPlatformSize alloc] init];
  pigeonResult.width = width;
  pigeonResult.height = height;
  return pigeonResult;
}
+ (FCPPlatformSize *)fromList:(NSArray *)list {
  FCPPlatformSize *pigeonResult = [[FCPPlatformSize alloc] init];
  pigeonResult.width = [GetNullableObjectAtIndex(list, 0) doubleValue];
  pigeonResult.height = [GetNullableObjectAtIndex(list, 1) doubleValue];
  return pigeonResult;
}
+ (nullable FCPPlatformSize *)nullableFromList:(NSArray *)list {
  return (list) ? [FCPPlatformSize fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    @(self.width),
    @(self.height),
  ];
}
@end

@interface FCPCameraApiCodecReader : FlutterStandardReader
@end
@implementation FCPCameraApiCodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 128:
      return [FCPPlatformCameraDescription fromList:[self readValue]];
    case 129:
      return [FCPPlatformMediaSettings fromList:[self readValue]];
    case 130:
      return [FCPPlatformPoint fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface FCPCameraApiCodecWriter : FlutterStandardWriter
@end
@implementation FCPCameraApiCodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[FCPPlatformCameraDescription class]]) {
    [self writeByte:128];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FCPPlatformMediaSettings class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FCPPlatformPoint class]]) {
    [self writeByte:130];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface FCPCameraApiCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation FCPCameraApiCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[FCPCameraApiCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[FCPCameraApiCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *FCPCameraApiGetCodec(void) {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    FCPCameraApiCodecReaderWriter *readerWriter = [[FCPCameraApiCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}

void SetUpFCPCameraApi(id<FlutterBinaryMessenger> binaryMessenger, NSObject<FCPCameraApi> *api) {
  SetUpFCPCameraApiWithSuffix(binaryMessenger, api, @"");
}

void SetUpFCPCameraApiWithSuffix(id<FlutterBinaryMessenger> binaryMessenger,
                                 NSObject<FCPCameraApi> *api, NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0
                             ? [NSString stringWithFormat:@".%@", messageChannelSuffix]
                             : @"";
  /// Returns the list of available cameras.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.getAvailableCameras",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(availableCamerasWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(availableCamerasWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api availableCamerasWithCompletion:^(
                 NSArray<FCPPlatformCameraDescription *> *_Nullable output,
                 FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Create a new camera with the given settings, and returns its ID.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:
                                      @"%@%@",
                                      @"dev.flutter.pigeon.camera_avfoundation.CameraApi.create",
                                      messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(createCameraWithName:settings:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(createCameraWithName:settings:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        NSString *arg_cameraName = GetNullableObjectAtIndex(args, 0);
        FCPPlatformMediaSettings *arg_settings = GetNullableObjectAtIndex(args, 1);
        [api createCameraWithName:arg_cameraName
                         settings:arg_settings
                       completion:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
                         callback(wrapResult(output, error));
                       }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Initializes the camera with the given ID.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:
               [NSString
                   stringWithFormat:@"%@%@",
                                    @"dev.flutter.pigeon.camera_avfoundation.CameraApi.initialize",
                                    messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initializeCamera:withImageFormat:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(initializeCamera:withImageFormat:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        NSInteger arg_cameraId = [GetNullableObjectAtIndex(args, 0) integerValue];
        FCPPlatformImageFormatGroup arg_imageFormat =
            [GetNullableObjectAtIndex(args, 1) integerValue];
        [api initializeCamera:arg_cameraId
              withImageFormat:arg_imageFormat
                   completion:^(FlutterError *_Nullable error) {
                     callback(wrapResult(nil, error));
                   }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Begins streaming frames from the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.startImageStream",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(startImageStreamWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(startImageStreamWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api startImageStreamWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Stops streaming frames from the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.stopImageStream",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(stopImageStreamWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(stopImageStreamWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api stopImageStreamWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Called by the Dart side of the plugin when it has received the last image
  /// frame sent.
  ///
  /// This is used to throttle sending frames across the channel.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.receivedImageStreamData",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(receivedImageStreamDataWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(receivedImageStreamDataWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api receivedImageStreamDataWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Indicates that the given camera is no longer being used on the Dart side,
  /// and any associated resources can be cleaned up.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:
                                      @"%@%@",
                                      @"dev.flutter.pigeon.camera_avfoundation.CameraApi.dispose",
                                      messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(disposeCamera:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(disposeCamera:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        NSInteger arg_cameraId = [GetNullableObjectAtIndex(args, 0) integerValue];
        [api disposeCamera:arg_cameraId
                completion:^(FlutterError *_Nullable error) {
                  callback(wrapResult(nil, error));
                }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Locks the camera capture to the current device orientation.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.lockCaptureOrientation",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(lockCaptureOrientation:completion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(lockCaptureOrientation:completion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FCPPlatformDeviceOrientation arg_orientation =
            [GetNullableObjectAtIndex(args, 0) integerValue];
        [api lockCaptureOrientation:arg_orientation
                         completion:^(FlutterError *_Nullable error) {
                           callback(wrapResult(nil, error));
                         }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Unlocks camera capture orientation, allowing it to automatically adapt to
  /// device orientation.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.unlockCaptureOrientation",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(unlockCaptureOrientationWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(unlockCaptureOrientationWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api unlockCaptureOrientationWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Takes a picture with the current settings, and returns the path to the
  /// resulting file.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:
               [NSString
                   stringWithFormat:@"%@%@",
                                    @"dev.flutter.pigeon.camera_avfoundation.CameraApi.takePicture",
                                    messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(takePictureWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(takePictureWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api
            takePictureWithCompletion:^(NSString *_Nullable output, FlutterError *_Nullable error) {
              callback(wrapResult(output, error));
            }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Does any preprocessing necessary before beginning to record video.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.prepareForVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(prepareForVideoRecordingWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(prepareForVideoRecordingWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api prepareForVideoRecordingWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Begins recording video, optionally enabling streaming to Dart at the same
  /// time.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.startVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startVideoRecordingWithStreaming:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(startVideoRecordingWithStreaming:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BOOL arg_enableStream = [GetNullableObjectAtIndex(args, 0) boolValue];
        [api startVideoRecordingWithStreaming:arg_enableStream
                                   completion:^(FlutterError *_Nullable error) {
                                     callback(wrapResult(nil, error));
                                   }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Stops recording video, and results the path to the resulting file.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.stopVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(stopVideoRecordingWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(stopVideoRecordingWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api stopVideoRecordingWithCompletion:^(NSString *_Nullable output,
                                                FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Pauses video recording.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.pauseVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(pauseVideoRecordingWithCompletion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(pauseVideoRecordingWithCompletion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api pauseVideoRecordingWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Resumes a previously paused video recording.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.resumeVideoRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumeVideoRecordingWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(resumeVideoRecordingWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api resumeVideoRecordingWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Switches the camera to the given flash mode.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setFlashMode",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setFlashMode:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setFlashMode:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FCPPlatformFlashMode arg_mode = [GetNullableObjectAtIndex(args, 0) integerValue];
        [api setFlashMode:arg_mode
               completion:^(FlutterError *_Nullable error) {
                 callback(wrapResult(nil, error));
               }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Switches the camera to the given exposure mode.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setExposureMode",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setExposureMode:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setExposureMode:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FCPPlatformExposureMode arg_mode = [GetNullableObjectAtIndex(args, 0) integerValue];
        [api setExposureMode:arg_mode
                  completion:^(FlutterError *_Nullable error) {
                    callback(wrapResult(nil, error));
                  }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Anchors auto-exposure to the given point in (0,1) coordinate space.
  ///
  /// A null value resets to the default exposure point.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.setExposurePoint",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setExposurePoint:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setExposurePoint:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FCPPlatformPoint *arg_point = GetNullableObjectAtIndex(args, 0);
        [api setExposurePoint:arg_point
                   completion:^(FlutterError *_Nullable error) {
                     callback(wrapResult(nil, error));
                   }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Returns the minimum exposure offset supported by the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.getMinExposureOffset",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getMinimumExposureOffset:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(getMinimumExposureOffset:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api getMinimumExposureOffset:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Returns the maximum exposure offset supported by the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.getMaxExposureOffset",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getMaximumExposureOffset:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(getMaximumExposureOffset:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api getMaximumExposureOffset:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Sets the exposure offset manually to the given value.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.setExposureOffset",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(setExposureOffset:completion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(setExposureOffset:completion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        double arg_offset = [GetNullableObjectAtIndex(args, 0) doubleValue];
        [api setExposureOffset:arg_offset
                    completion:^(FlutterError *_Nullable error) {
                      callback(wrapResult(nil, error));
                    }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Switches the camera to the given focus mode.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setFocusMode",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setFocusMode:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setFocusMode:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FCPPlatformFocusMode arg_mode = [GetNullableObjectAtIndex(args, 0) integerValue];
        [api setFocusMode:arg_mode
               completion:^(FlutterError *_Nullable error) {
                 callback(wrapResult(nil, error));
               }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Anchors auto-focus to the given point in (0,1) coordinate space.
  ///
  /// A null value resets to the default focus point.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setFocusPoint",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setFocusPoint:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setFocusPoint:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FCPPlatformPoint *arg_point = GetNullableObjectAtIndex(args, 0);
        [api setFocusPoint:arg_point
                completion:^(FlutterError *_Nullable error) {
                  callback(wrapResult(nil, error));
                }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Returns the minimum zoom level supported by the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.getMinZoomLevel",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getMinimumZoomLevel:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(getMinimumZoomLevel:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api getMinimumZoomLevel:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Returns the maximum zoom level supported by the camera.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.getMaxZoomLevel",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getMaximumZoomLevel:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(getMaximumZoomLevel:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api getMaximumZoomLevel:^(NSNumber *_Nullable output, FlutterError *_Nullable error) {
          callback(wrapResult(output, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Sets the zoom factor.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.setZoomLevel",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setZoomLevel:completion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(setZoomLevel:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        double arg_zoom = [GetNullableObjectAtIndex(args, 0) doubleValue];
        [api setZoomLevel:arg_zoom
               completion:^(FlutterError *_Nullable error) {
                 callback(wrapResult(nil, error));
               }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Pauses streaming of preview frames.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.pausePreview",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(pausePreviewWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(pausePreviewWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api pausePreviewWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Resumes a previously paused preview stream.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString
                            stringWithFormat:
                                @"%@%@",
                                @"dev.flutter.pigeon.camera_avfoundation.CameraApi.resumePreview",
                                messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumePreviewWithCompletion:)],
                @"FCPCameraApi api (%@) doesn't respond to @selector(resumePreviewWithCompletion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        [api resumePreviewWithCompletion:^(FlutterError *_Nullable error) {
          callback(wrapResult(nil, error));
        }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Changes the camera used while recording video.
  ///
  /// This should only be called while video recording is active.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.updateDescriptionWhileRecording",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(updateDescriptionWhileRecordingCameraName:
                                                                                 completion:)],
                @"FCPCameraApi api (%@) doesn't respond to "
                @"@selector(updateDescriptionWhileRecordingCameraName:completion:)",
                api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        NSString *arg_cameraName = GetNullableObjectAtIndex(args, 0);
        [api updateDescriptionWhileRecordingCameraName:arg_cameraName
                                            completion:^(FlutterError *_Nullable error) {
                                              callback(wrapResult(nil, error));
                                            }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// Sets the file format used for taking pictures.
  {
    FlutterBasicMessageChannel *channel = [[FlutterBasicMessageChannel alloc]
           initWithName:[NSString stringWithFormat:@"%@%@",
                                                   @"dev.flutter.pigeon.camera_avfoundation."
                                                   @"CameraApi.setImageFileFormat",
                                                   messageChannelSuffix]
        binaryMessenger:binaryMessenger
                  codec:FCPCameraApiGetCodec()];
    if (api) {
      NSCAssert(
          [api respondsToSelector:@selector(setImageFileFormat:completion:)],
          @"FCPCameraApi api (%@) doesn't respond to @selector(setImageFileFormat:completion:)",
          api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FCPPlatformImageFileFormat arg_format = [GetNullableObjectAtIndex(args, 0) integerValue];
        [api setImageFileFormat:arg_format
                     completion:^(FlutterError *_Nullable error) {
                       callback(wrapResult(nil, error));
                     }];
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
NSObject<FlutterMessageCodec> *FCPCameraGlobalEventApiGetCodec(void) {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  sSharedObject = [FlutterStandardMessageCodec sharedInstance];
  return sSharedObject;
}

@interface FCPCameraGlobalEventApi ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation FCPCameraGlobalEventApi

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger
                   messageChannelSuffix:(nullable NSString *)messageChannelSuffix {
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0
                                ? @""
                                : [NSString stringWithFormat:@".%@", messageChannelSuffix];
  }
  return self;
}
- (void)deviceOrientationChangedOrientation:(FCPPlatformDeviceOrientation)arg_orientation
                                 completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString
      stringWithFormat:
          @"%@%@",
          @"dev.flutter.pigeon.camera_avfoundation.CameraGlobalEventApi.deviceOrientationChanged",
          _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
      [FlutterBasicMessageChannel messageChannelWithName:channelName
                                         binaryMessenger:self.binaryMessenger
                                                   codec:FCPCameraGlobalEventApiGetCodec()];
  [channel sendMessage:@[ [NSNumber numberWithInteger:arg_orientation] ]
                 reply:^(NSArray<id> *reply) {
                   if (reply != nil) {
                     if (reply.count > 1) {
                       completion([FlutterError errorWithCode:reply[0]
                                                      message:reply[1]
                                                      details:reply[2]]);
                     } else {
                       completion(nil);
                     }
                   } else {
                     completion(createConnectionError(channelName));
                   }
                 }];
}
@end

@interface FCPCameraEventApiCodecReader : FlutterStandardReader
@end
@implementation FCPCameraEventApiCodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 128:
      return [FCPPlatformCameraState fromList:[self readValue]];
    case 129:
      return [FCPPlatformSize fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface FCPCameraEventApiCodecWriter : FlutterStandardWriter
@end
@implementation FCPCameraEventApiCodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[FCPPlatformCameraState class]]) {
    [self writeByte:128];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FCPPlatformSize class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface FCPCameraEventApiCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation FCPCameraEventApiCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[FCPCameraEventApiCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[FCPCameraEventApiCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *FCPCameraEventApiGetCodec(void) {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    FCPCameraEventApiCodecReaderWriter *readerWriter =
        [[FCPCameraEventApiCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}

@interface FCPCameraEventApi ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation FCPCameraEventApi

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger
                   messageChannelSuffix:(nullable NSString *)messageChannelSuffix {
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0
                                ? @""
                                : [NSString stringWithFormat:@".%@", messageChannelSuffix];
  }
  return self;
}
- (void)initializedWithState:(FCPPlatformCameraState *)arg_initialState
                  completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString
      stringWithFormat:@"%@%@",
                       @"dev.flutter.pigeon.camera_avfoundation.CameraEventApi.initialized",
                       _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
      [FlutterBasicMessageChannel messageChannelWithName:channelName
                                         binaryMessenger:self.binaryMessenger
                                                   codec:FCPCameraEventApiGetCodec()];
  [channel sendMessage:@[ arg_initialState ?: [NSNull null] ]
                 reply:^(NSArray<id> *reply) {
                   if (reply != nil) {
                     if (reply.count > 1) {
                       completion([FlutterError errorWithCode:reply[0]
                                                      message:reply[1]
                                                      details:reply[2]]);
                     } else {
                       completion(nil);
                     }
                   } else {
                     completion(createConnectionError(channelName));
                   }
                 }];
}
- (void)reportError:(NSString *)arg_message
         completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString
      stringWithFormat:@"%@%@", @"dev.flutter.pigeon.camera_avfoundation.CameraEventApi.error",
                       _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
      [FlutterBasicMessageChannel messageChannelWithName:channelName
                                         binaryMessenger:self.binaryMessenger
                                                   codec:FCPCameraEventApiGetCodec()];
  [channel sendMessage:@[ arg_message ?: [NSNull null] ]
                 reply:^(NSArray<id> *reply) {
                   if (reply != nil) {
                     if (reply.count > 1) {
                       completion([FlutterError errorWithCode:reply[0]
                                                      message:reply[1]
                                                      details:reply[2]]);
                     } else {
                       completion(nil);
                     }
                   } else {
                     completion(createConnectionError(channelName));
                   }
                 }];
}
@end
