// Copyright (c) 2024, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// ignore_for_file: camel_case_types, non_constant_identifier_names
// ignore_for_file: unused_element, unused_field, return_of_invalid_type
// ignore_for_file: void_checks, annotate_overrides
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: library_private_types_in_public_api

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'package:ffi/ffi.dart' as pkg_ffi;
import 'package:objective_c/objective_c.dart' as objc;
import 'dart:ffi' as ffi;

abstract class NSBinarySearchingOptions {
  static const int NSBinarySearchingFirstEqual = 256;
  static const int NSBinarySearchingLastEqual = 512;
  static const int NSBinarySearchingInsertionIndex = 1024;
}

abstract class NSStringEnumerationOptions {
  static const int NSStringEnumerationByLines = 0;
  static const int NSStringEnumerationByParagraphs = 1;
  static const int NSStringEnumerationByComposedCharacterSequences = 2;
  static const int NSStringEnumerationByWords = 3;
  static const int NSStringEnumerationBySentences = 4;
  static const int NSStringEnumerationByCaretPositions = 5;
  static const int NSStringEnumerationByDeletionClusters = 6;
  static const int NSStringEnumerationReverse = 256;
  static const int NSStringEnumerationSubstringNotRequired = 512;
  static const int NSStringEnumerationLocalized = 1024;
}

class NSBundle extends objc.NSObject {
  NSBundle._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSBundle] that points to the same underlying object as [other].
  NSBundle.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSBundle] that wraps the given raw object pointer.
  NSBundle.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSBundle].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSBundle);
  }

  static NSBundle getMainBundle() {
    final _ret = _objc_msgSend_1(_class_NSBundle, _sel_mainBundle);
    return NSBundle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSBundle? bundleWithPath_(objc.NSString path) {
    final _ret =
        _objc_msgSend_2(_class_NSBundle, _sel_bundleWithPath_, path.pointer);
    return _ret.address == 0
        ? null
        : NSBundle.castFromPointer(_ret, retain: true, release: true);
  }

  NSBundle? initWithPath_(objc.NSString path) {
    final _ret =
        _objc_msgSend_2(this.pointer, _sel_initWithPath_, path.pointer);
    return _ret.address == 0
        ? null
        : NSBundle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSBundle? bundleWithURL_(objc.NSURL url) {
    final _ret =
        _objc_msgSend_3(_class_NSBundle, _sel_bundleWithURL_, url.pointer);
    return _ret.address == 0
        ? null
        : NSBundle.castFromPointer(_ret, retain: true, release: true);
  }

  NSBundle? initWithURL_(objc.NSURL url) {
    final _ret = _objc_msgSend_3(this.pointer, _sel_initWithURL_, url.pointer);
    return _ret.address == 0
        ? null
        : NSBundle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSBundle bundleForClass_(objc.NSObject aClass) {
    final _ret =
        _objc_msgSend_4(_class_NSBundle, _sel_bundleForClass_, aClass.pointer);
    return NSBundle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSBundle? bundleWithIdentifier_(objc.NSString identifier) {
    final _ret = _objc_msgSend_5(
        _class_NSBundle, _sel_bundleWithIdentifier_, identifier.pointer);
    return _ret.address == 0
        ? null
        : NSBundle.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray getAllBundles() {
    final _ret = _objc_msgSend_6(_class_NSBundle, _sel_allBundles);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray getAllFrameworks() {
    final _ret = _objc_msgSend_6(_class_NSBundle, _sel_allFrameworks);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  bool load() {
    return _objc_msgSend_7(this.pointer, _sel_load);
  }

  bool get loaded {
    return _objc_msgSend_7(this.pointer, _sel_isLoaded);
  }

  bool unload() {
    return _objc_msgSend_7(this.pointer, _sel_unload);
  }

  bool preflightAndReturnError_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_8(this.pointer, _sel_preflightAndReturnError_, error);
  }

  bool loadAndReturnError_(ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_8(this.pointer, _sel_loadAndReturnError_, error);
  }

  objc.NSURL get bundleURL {
    final _ret = _objc_msgSend_9(this.pointer, _sel_bundleURL);
    return objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get resourceURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_resourceURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get executableURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_executableURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? URLForAuxiliaryExecutable_(objc.NSString executableName) {
    final _ret = _objc_msgSend_11(
        this.pointer, _sel_URLForAuxiliaryExecutable_, executableName.pointer);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get privateFrameworksURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_privateFrameworksURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get sharedFrameworksURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_sharedFrameworksURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get sharedSupportURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_sharedSupportURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get builtInPlugInsURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_builtInPlugInsURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get appStoreReceiptURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_appStoreReceiptURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get bundlePath {
    final _ret = _objc_msgSend_12(this.pointer, _sel_bundlePath);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get resourcePath {
    final _ret = _objc_msgSend_13(this.pointer, _sel_resourcePath);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get executablePath {
    final _ret = _objc_msgSend_13(this.pointer, _sel_executablePath);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? pathForAuxiliaryExecutable_(objc.NSString executableName) {
    final _ret = _objc_msgSend_14(
        this.pointer, _sel_pathForAuxiliaryExecutable_, executableName.pointer);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get privateFrameworksPath {
    final _ret = _objc_msgSend_13(this.pointer, _sel_privateFrameworksPath);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get sharedFrameworksPath {
    final _ret = _objc_msgSend_13(this.pointer, _sel_sharedFrameworksPath);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get sharedSupportPath {
    final _ret = _objc_msgSend_13(this.pointer, _sel_sharedSupportPath);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get builtInPlugInsPath {
    final _ret = _objc_msgSend_13(this.pointer, _sel_builtInPlugInsPath);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSURL? URLForResource_withExtension_subdirectory_inBundleWithURL_(
      objc.NSString? name,
      objc.NSString? ext,
      objc.NSString? subpath,
      objc.NSURL bundleURL) {
    final _ret = _objc_msgSend_15(
        _class_NSBundle,
        _sel_URLForResource_withExtension_subdirectory_inBundleWithURL_,
        name?.pointer ?? ffi.nullptr,
        ext?.pointer ?? ffi.nullptr,
        subpath?.pointer ?? ffi.nullptr,
        bundleURL.pointer);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray?
      URLsForResourcesWithExtension_subdirectory_inBundleWithURL_(
          objc.NSString? ext, objc.NSString? subpath, objc.NSURL bundleURL) {
    final _ret = _objc_msgSend_16(
        _class_NSBundle,
        _sel_URLsForResourcesWithExtension_subdirectory_inBundleWithURL_,
        ext?.pointer ?? ffi.nullptr,
        subpath?.pointer ?? ffi.nullptr,
        bundleURL.pointer);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? URLForResource_withExtension_(
      objc.NSString? name, objc.NSString? ext) {
    final _ret = _objc_msgSend_17(
        this.pointer,
        _sel_URLForResource_withExtension_,
        name?.pointer ?? ffi.nullptr,
        ext?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? URLForResource_withExtension_subdirectory_(
      objc.NSString? name, objc.NSString? ext, objc.NSString? subpath) {
    final _ret = _objc_msgSend_18(
        this.pointer,
        _sel_URLForResource_withExtension_subdirectory_,
        name?.pointer ?? ffi.nullptr,
        ext?.pointer ?? ffi.nullptr,
        subpath?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? URLForResource_withExtension_subdirectory_localization_(
      objc.NSString? name,
      objc.NSString? ext,
      objc.NSString? subpath,
      objc.NSString? localizationName) {
    final _ret = _objc_msgSend_19(
        this.pointer,
        _sel_URLForResource_withExtension_subdirectory_localization_,
        name?.pointer ?? ffi.nullptr,
        ext?.pointer ?? ffi.nullptr,
        subpath?.pointer ?? ffi.nullptr,
        localizationName?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? URLsForResourcesWithExtension_subdirectory_(
      objc.NSString? ext, objc.NSString? subpath) {
    final _ret = _objc_msgSend_20(
        this.pointer,
        _sel_URLsForResourcesWithExtension_subdirectory_,
        ext?.pointer ?? ffi.nullptr,
        subpath?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? URLsForResourcesWithExtension_subdirectory_localization_(
      objc.NSString? ext,
      objc.NSString? subpath,
      objc.NSString? localizationName) {
    final _ret = _objc_msgSend_21(
        this.pointer,
        _sel_URLsForResourcesWithExtension_subdirectory_localization_,
        ext?.pointer ?? ffi.nullptr,
        subpath?.pointer ?? ffi.nullptr,
        localizationName?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSString? pathForResource_ofType_inDirectory_(
      objc.NSString? name, objc.NSString? ext, objc.NSString bundlePath) {
    final _ret = _objc_msgSend_22(
        _class_NSBundle,
        _sel_pathForResource_ofType_inDirectory_,
        name?.pointer ?? ffi.nullptr,
        ext?.pointer ?? ffi.nullptr,
        bundlePath.pointer);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray pathsForResourcesOfType_inDirectory_(
      objc.NSString? ext, objc.NSString bundlePath) {
    final _ret = _objc_msgSend_23(
        _class_NSBundle,
        _sel_pathsForResourcesOfType_inDirectory_,
        ext?.pointer ?? ffi.nullptr,
        bundlePath.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? pathForResource_ofType_(
      objc.NSString? name, objc.NSString? ext) {
    final _ret = _objc_msgSend_24(this.pointer, _sel_pathForResource_ofType_,
        name?.pointer ?? ffi.nullptr, ext?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? pathForResource_ofType_inDirectory_forLocalization_(
      objc.NSString? name,
      objc.NSString? ext,
      objc.NSString? subpath,
      objc.NSString? localizationName) {
    final _ret = _objc_msgSend_25(
        this.pointer,
        _sel_pathForResource_ofType_inDirectory_forLocalization_,
        name?.pointer ?? ffi.nullptr,
        ext?.pointer ?? ffi.nullptr,
        subpath?.pointer ?? ffi.nullptr,
        localizationName?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray pathsForResourcesOfType_inDirectory_forLocalization_(
      objc.NSString? ext,
      objc.NSString? subpath,
      objc.NSString? localizationName) {
    final _ret = _objc_msgSend_26(
        this.pointer,
        _sel_pathsForResourcesOfType_inDirectory_forLocalization_,
        ext?.pointer ?? ffi.nullptr,
        subpath?.pointer ?? ffi.nullptr,
        localizationName?.pointer ?? ffi.nullptr);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString localizedStringForKey_value_table_(
      objc.NSString key, objc.NSString? value, objc.NSString? tableName) {
    final _ret = _objc_msgSend_27(
        this.pointer,
        _sel_localizedStringForKey_value_table_,
        key.pointer,
        value?.pointer ?? ffi.nullptr,
        tableName?.pointer ?? ffi.nullptr);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  NSAttributedString localizedAttributedStringForKey_value_table_(
      objc.NSString key, objc.NSString? value, objc.NSString? tableName) {
    final _ret = _objc_msgSend_64(
        this.pointer,
        _sel_localizedAttributedStringForKey_value_table_,
        key.pointer,
        value?.pointer ?? ffi.nullptr,
        tableName?.pointer ?? ffi.nullptr);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  objc.NSString? get bundleIdentifier {
    final _ret = _objc_msgSend_13(this.pointer, _sel_bundleIdentifier);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? get infoDictionary {
    final _ret = _objc_msgSend_65(this.pointer, _sel_infoDictionary);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? get localizedInfoDictionary {
    final _ret = _objc_msgSend_65(this.pointer, _sel_localizedInfoDictionary);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? objectForInfoDictionaryKey_(objc.NSString key) {
    final _ret = _objc_msgSend_2(
        this.pointer, _sel_objectForInfoDictionaryKey_, key.pointer);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? classNamed_(objc.NSString className) {
    final _ret =
        _objc_msgSend_2(this.pointer, _sel_classNamed_, className.pointer);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? get principalClass {
    final _ret = _objc_msgSend_66(this.pointer, _sel_principalClass);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get preferredLocalizations {
    final _ret = _objc_msgSend_6(this.pointer, _sel_preferredLocalizations);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get localizations {
    final _ret = _objc_msgSend_6(this.pointer, _sel_localizations);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get developmentLocalization {
    final _ret = _objc_msgSend_13(this.pointer, _sel_developmentLocalization);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray preferredLocalizationsFromArray_(
      objc.NSArray localizationsArray) {
    final _ret = _objc_msgSend_67(_class_NSBundle,
        _sel_preferredLocalizationsFromArray_, localizationsArray.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray preferredLocalizationsFromArray_forPreferences_(
      objc.NSArray localizationsArray, objc.NSArray? preferencesArray) {
    final _ret = _objc_msgSend_68(
        _class_NSBundle,
        _sel_preferredLocalizationsFromArray_forPreferences_,
        localizationsArray.pointer,
        preferencesArray?.pointer ?? ffi.nullptr);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? get executableArchitectures {
    final _ret = _objc_msgSend_69(this.pointer, _sel_executableArchitectures);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  void setPreservationPriority_forTags_(double priority, objc.NSSet tags) {
    _objc_msgSend_70(this.pointer, _sel_setPreservationPriority_forTags_,
        priority, tags.pointer);
  }

  double preservationPriorityForTag_(objc.NSString tag) {
    return objc.useMsgSendVariants
        ? _objc_msgSend_71Fpret(
            this.pointer, _sel_preservationPriorityForTag_, tag.pointer)
        : _objc_msgSend_71(
            this.pointer, _sel_preservationPriorityForTag_, tag.pointer);
  }

  @override
  NSBundle init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSBundle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSBundle new1() {
    final _ret = _objc_msgSend_40(_class_NSBundle, _sel_new);
    return NSBundle.castFromPointer(_ret, retain: false, release: true);
  }

  static NSBundle allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSBundle, _sel_allocWithZone_, zone);
    return NSBundle.castFromPointer(_ret, retain: false, release: true);
  }

  static NSBundle alloc() {
    final _ret = _objc_msgSend_40(_class_NSBundle, _sel_alloc);
    return NSBundle.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSBundle,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSBundle,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSBundle, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSBundle, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSBundle,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSBundle,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSBundle,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSBundle, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSBundle, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSBundle = objc.getClass("NSBundle");
late final _sel_mainBundle = objc.registerName("mainBundle");
final _objc_msgSend_1 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
typedef instancetype = ffi.Pointer<objc.ObjCObject>;
typedef Dartinstancetype = objc.NSObject;
late final _sel_bundleWithPath_ = objc.registerName("bundleWithPath:");
final _objc_msgSend_2 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithPath_ = objc.registerName("initWithPath:");
late final _sel_bundleWithURL_ = objc.registerName("bundleWithURL:");
final _objc_msgSend_3 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithURL_ = objc.registerName("initWithURL:");
late final _sel_bundleForClass_ = objc.registerName("bundleForClass:");
final _objc_msgSend_4 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_bundleWithIdentifier_ =
    objc.registerName("bundleWithIdentifier:");
final _objc_msgSend_5 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_allBundles = objc.registerName("allBundles");
final _objc_msgSend_6 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_allFrameworks = objc.registerName("allFrameworks");
late final _sel_load = objc.registerName("load");
final _objc_msgSend_7 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_isLoaded = objc.registerName("isLoaded");
late final _sel_unload = objc.registerName("unload");
late final _sel_preflightAndReturnError_ =
    objc.registerName("preflightAndReturnError:");
final _objc_msgSend_8 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_loadAndReturnError_ = objc.registerName("loadAndReturnError:");
late final _sel_bundleURL = objc.registerName("bundleURL");
final _objc_msgSend_9 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_resourceURL = objc.registerName("resourceURL");
final _objc_msgSend_10 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_executableURL = objc.registerName("executableURL");
late final _sel_URLForAuxiliaryExecutable_ =
    objc.registerName("URLForAuxiliaryExecutable:");
final _objc_msgSend_11 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_privateFrameworksURL =
    objc.registerName("privateFrameworksURL");
late final _sel_sharedFrameworksURL = objc.registerName("sharedFrameworksURL");
late final _sel_sharedSupportURL = objc.registerName("sharedSupportURL");
late final _sel_builtInPlugInsURL = objc.registerName("builtInPlugInsURL");
late final _sel_appStoreReceiptURL = objc.registerName("appStoreReceiptURL");
late final _sel_bundlePath = objc.registerName("bundlePath");
final _objc_msgSend_12 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_resourcePath = objc.registerName("resourcePath");
final _objc_msgSend_13 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_executablePath = objc.registerName("executablePath");
late final _sel_pathForAuxiliaryExecutable_ =
    objc.registerName("pathForAuxiliaryExecutable:");
final _objc_msgSend_14 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_privateFrameworksPath =
    objc.registerName("privateFrameworksPath");
late final _sel_sharedFrameworksPath =
    objc.registerName("sharedFrameworksPath");
late final _sel_sharedSupportPath = objc.registerName("sharedSupportPath");
late final _sel_builtInPlugInsPath = objc.registerName("builtInPlugInsPath");
late final _sel_URLForResource_withExtension_subdirectory_inBundleWithURL_ =
    objc.registerName(
        "URLForResource:withExtension:subdirectory:inBundleWithURL:");
final _objc_msgSend_15 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_URLsForResourcesWithExtension_subdirectory_inBundleWithURL_ =
    objc.registerName(
        "URLsForResourcesWithExtension:subdirectory:inBundleWithURL:");
final _objc_msgSend_16 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_URLForResource_withExtension_ =
    objc.registerName("URLForResource:withExtension:");
final _objc_msgSend_17 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_URLForResource_withExtension_subdirectory_ =
    objc.registerName("URLForResource:withExtension:subdirectory:");
final _objc_msgSend_18 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_URLForResource_withExtension_subdirectory_localization_ = objc
    .registerName("URLForResource:withExtension:subdirectory:localization:");
final _objc_msgSend_19 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_URLsForResourcesWithExtension_subdirectory_ =
    objc.registerName("URLsForResourcesWithExtension:subdirectory:");
final _objc_msgSend_20 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_URLsForResourcesWithExtension_subdirectory_localization_ = objc
    .registerName("URLsForResourcesWithExtension:subdirectory:localization:");
final _objc_msgSend_21 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_pathForResource_ofType_inDirectory_ =
    objc.registerName("pathForResource:ofType:inDirectory:");
final _objc_msgSend_22 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_pathsForResourcesOfType_inDirectory_ =
    objc.registerName("pathsForResourcesOfType:inDirectory:");
final _objc_msgSend_23 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_pathForResource_ofType_ =
    objc.registerName("pathForResource:ofType:");
final _objc_msgSend_24 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_pathForResource_ofType_inDirectory_forLocalization_ =
    objc.registerName("pathForResource:ofType:inDirectory:forLocalization:");
final _objc_msgSend_25 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_pathsForResourcesOfType_inDirectory_forLocalization_ =
    objc.registerName("pathsForResourcesOfType:inDirectory:forLocalization:");
final _objc_msgSend_26 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_localizedStringForKey_value_table_ =
    objc.registerName("localizedStringForKey:value:table:");
final _objc_msgSend_27 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

class NSAttributedString extends objc.NSObject {
  NSAttributedString._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSAttributedString] that points to the same underlying object as [other].
  NSAttributedString.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSAttributedString] that wraps the given raw object pointer.
  NSAttributedString.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSAttributedString].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSAttributedString);
  }

  objc.NSString get string {
    final _ret = _objc_msgSend_12(this.pointer, _sel_string);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary attributesAtIndex_effectiveRange_(
      int location, ffi.Pointer<_NSRange> range) {
    final _ret = _objc_msgSend_28(
        this.pointer, _sel_attributesAtIndex_effectiveRange_, location, range);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  int get length {
    return _objc_msgSend_29(this.pointer, _sel_length);
  }

  objc.NSObject? attribute_atIndex_effectiveRange_(
      objc.NSString attrName, int location, ffi.Pointer<_NSRange> range) {
    final _ret = _objc_msgSend_30(
        this.pointer,
        _sel_attribute_atIndex_effectiveRange_,
        attrName.pointer,
        location,
        range);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  NSAttributedString attributedSubstringFromRange_(_NSRange range) {
    final _ret = _objc_msgSend_31(
        this.pointer, _sel_attributedSubstringFromRange_, range);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  objc.NSDictionary attributesAtIndex_longestEffectiveRange_inRange_(
      int location, ffi.Pointer<_NSRange> range, _NSRange rangeLimit) {
    final _ret = _objc_msgSend_32(
        this.pointer,
        _sel_attributesAtIndex_longestEffectiveRange_inRange_,
        location,
        range,
        rangeLimit);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? attribute_atIndex_longestEffectiveRange_inRange_(
      objc.NSString attrName,
      int location,
      ffi.Pointer<_NSRange> range,
      _NSRange rangeLimit) {
    final _ret = _objc_msgSend_33(
        this.pointer,
        _sel_attribute_atIndex_longestEffectiveRange_inRange_,
        attrName.pointer,
        location,
        range,
        rangeLimit);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  bool isEqualToAttributedString_(NSAttributedString other) {
    return _objc_msgSend_34(
        this.pointer, _sel_isEqualToAttributedString_, other.pointer);
  }

  NSAttributedString initWithString_(objc.NSString str) {
    final _ret =
        _objc_msgSend_35(this.pointer, _sel_initWithString_, str.pointer);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSAttributedString initWithString_attributes_(
      objc.NSString str, objc.NSDictionary? attrs) {
    final _ret = _objc_msgSend_36(this.pointer, _sel_initWithString_attributes_,
        str.pointer, attrs?.pointer ?? ffi.nullptr);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSAttributedString initWithAttributedString_(NSAttributedString attrStr) {
    final _ret = _objc_msgSend_37(
        this.pointer, _sel_initWithAttributedString_, attrStr.pointer);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  void enumerateAttributesInRange_options_usingBlock_(_NSRange enumerationRange,
      int opts, ObjCBlock_ffiVoid_NSDictionary_NSRange_bool block) {
    _objc_msgSend_38(
        this.pointer,
        _sel_enumerateAttributesInRange_options_usingBlock_,
        enumerationRange,
        opts,
        block.pointer);
  }

  void enumerateAttribute_inRange_options_usingBlock_(
      objc.NSString attrName,
      _NSRange enumerationRange,
      int opts,
      ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool block) {
    _objc_msgSend_39(
        this.pointer,
        _sel_enumerateAttribute_inRange_options_usingBlock_,
        attrName.pointer,
        enumerationRange,
        opts,
        block.pointer);
  }

  NSAttributedString?
      initWithContentsOfMarkdownFileAtURL_options_baseURL_error_(
          objc.NSURL markdownFile,
          NSAttributedStringMarkdownParsingOptions? options,
          objc.NSURL? baseURL,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_53(
        this.pointer,
        _sel_initWithContentsOfMarkdownFileAtURL_options_baseURL_error_,
        markdownFile.pointer,
        options?.pointer ?? ffi.nullptr,
        baseURL?.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSAttributedString.castFromPointer(_ret, retain: true, release: true);
  }

  NSAttributedString? initWithMarkdown_options_baseURL_error_(
      objc.NSData markdown,
      NSAttributedStringMarkdownParsingOptions? options,
      objc.NSURL? baseURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_54(
        this.pointer,
        _sel_initWithMarkdown_options_baseURL_error_,
        markdown.pointer,
        options?.pointer ?? ffi.nullptr,
        baseURL?.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSAttributedString.castFromPointer(_ret, retain: true, release: true);
  }

  NSAttributedString? initWithMarkdownString_options_baseURL_error_(
      objc.NSString markdownString,
      NSAttributedStringMarkdownParsingOptions? options,
      objc.NSURL? baseURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_55(
        this.pointer,
        _sel_initWithMarkdownString_options_baseURL_error_,
        markdownString.pointer,
        options?.pointer ?? ffi.nullptr,
        baseURL?.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSAttributedString.castFromPointer(_ret, retain: true, release: true);
  }

  NSAttributedString initWithFormat_options_locale_(
      NSAttributedString format, int options, objc.NSLocale? locale) {
    final _ret = _objc_msgSend_56(
        this.pointer,
        _sel_initWithFormat_options_locale_,
        format.pointer,
        options,
        locale?.pointer ?? ffi.nullptr);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSAttributedString initWithFormat_options_locale_arguments_(
      NSAttributedString format,
      int options,
      objc.NSLocale? locale,
      ffi.Pointer<__va_list_tag> arguments) {
    final _ret = _objc_msgSend_57(
        this.pointer,
        _sel_initWithFormat_options_locale_arguments_,
        format.pointer,
        options,
        locale?.pointer ?? ffi.nullptr,
        arguments);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSAttributedString localizedAttributedStringWithFormat_(
      NSAttributedString format) {
    final _ret = _objc_msgSend_37(_class_NSAttributedString,
        _sel_localizedAttributedStringWithFormat_, format.pointer);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSAttributedString localizedAttributedStringWithFormat_options_(
      NSAttributedString format, int options) {
    final _ret = _objc_msgSend_58(
        _class_NSAttributedString,
        _sel_localizedAttributedStringWithFormat_options_,
        format.pointer,
        options);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSAttributedString initWithFormat_options_locale_context_(
      NSAttributedString format,
      int options,
      objc.NSLocale? locale,
      objc.NSDictionary context) {
    final _ret = _objc_msgSend_59(
        this.pointer,
        _sel_initWithFormat_options_locale_context_,
        format.pointer,
        options,
        locale?.pointer ?? ffi.nullptr,
        context.pointer);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSAttributedString initWithFormat_options_locale_context_arguments_(
      NSAttributedString format,
      int options,
      objc.NSLocale? locale,
      objc.NSDictionary context,
      ffi.Pointer<__va_list_tag> arguments) {
    final _ret = _objc_msgSend_60(
        this.pointer,
        _sel_initWithFormat_options_locale_context_arguments_,
        format.pointer,
        options,
        locale?.pointer ?? ffi.nullptr,
        context.pointer,
        arguments);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSAttributedString localizedAttributedStringWithFormat_context_(
      NSAttributedString format, objc.NSDictionary context) {
    final _ret = _objc_msgSend_61(
        _class_NSAttributedString,
        _sel_localizedAttributedStringWithFormat_context_,
        format.pointer,
        context.pointer);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSAttributedString
      localizedAttributedStringWithFormat_options_context_(
          NSAttributedString format, int options, objc.NSDictionary context) {
    final _ret = _objc_msgSend_62(
        _class_NSAttributedString,
        _sel_localizedAttributedStringWithFormat_options_context_,
        format.pointer,
        options,
        context.pointer);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSAttributedString attributedStringByInflectingString() {
    final _ret =
        _objc_msgSend_63(this.pointer, _sel_attributedStringByInflectingString);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSAttributedString init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSAttributedString new1() {
    final _ret = _objc_msgSend_40(_class_NSAttributedString, _sel_new);
    return NSAttributedString.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSAttributedString allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSAttributedString, _sel_allocWithZone_, zone);
    return NSAttributedString.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSAttributedString alloc() {
    final _ret = _objc_msgSend_40(_class_NSAttributedString, _sel_alloc);
    return NSAttributedString.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSAttributedString,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSAttributedString,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSAttributedString, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSAttributedString, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSAttributedString,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSAttributedString,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSAttributedString,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSAttributedString, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSAttributedString, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSAttributedString = objc.getClass("NSAttributedString");
late final _sel_string = objc.registerName("string");

final class _NSRange extends ffi.Struct {
  @ffi.UnsignedLong()
  external int location;

  @ffi.UnsignedLong()
  external int length;
}

late final _sel_attributesAtIndex_effectiveRange_ =
    objc.registerName("attributesAtIndex:effectiveRange:");
final _objc_msgSend_28 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<_NSRange>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, ffi.Pointer<_NSRange>)>();
late final _sel_length = objc.registerName("length");
final _objc_msgSend_29 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_attribute_atIndex_effectiveRange_ =
    objc.registerName("attribute:atIndex:effectiveRange:");
final _objc_msgSend_30 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<_NSRange>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<_NSRange>)>();
late final _sel_attributedSubstringFromRange_ =
    objc.registerName("attributedSubstringFromRange:");
final _objc_msgSend_31 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, _NSRange)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, _NSRange)>();
late final _sel_attributesAtIndex_longestEffectiveRange_inRange_ =
    objc.registerName("attributesAtIndex:longestEffectiveRange:inRange:");
final _objc_msgSend_32 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<_NSRange>,
                _NSRange)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<_NSRange>,
            _NSRange)>();
late final _sel_attribute_atIndex_longestEffectiveRange_inRange_ =
    objc.registerName("attribute:atIndex:longestEffectiveRange:inRange:");
final _objc_msgSend_33 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<_NSRange>,
                _NSRange)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<_NSRange>,
            _NSRange)>();
late final _sel_isEqualToAttributedString_ =
    objc.registerName("isEqualToAttributedString:");
final _objc_msgSend_34 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithString_ = objc.registerName("initWithString:");
final _objc_msgSend_35 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithString_attributes_ =
    objc.registerName("initWithString:attributes:");
final _objc_msgSend_36 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithAttributedString_ =
    objc.registerName("initWithAttributedString:");
final _objc_msgSend_37 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

abstract class NSAttributedStringEnumerationOptions {
  static const int NSAttributedStringEnumerationReverse = 2;
  static const int
      NSAttributedStringEnumerationLongestEffectiveRangeNotRequired = 1048576;
}

void _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        _NSRange arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                    _NSRange arg1, ffi.Pointer<ffi.Bool> arg2)>>()
        .asFunction<
            void Function(ffi.Pointer<objc.ObjCObject>, _NSRange,
                ffi.Pointer<ffi.Bool>)>()(arg0, arg1, arg2);
final _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_closureRegistry = <int,
    void Function(
        ffi.Pointer<objc.ObjCObject>, _NSRange, ffi.Pointer<ffi.Bool>)>{};
int _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_registerClosure(
        void Function(
                ffi.Pointer<objc.ObjCObject>, _NSRange, ffi.Pointer<ffi.Bool>)
            fn) {
  final id =
      ++_ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        _NSRange arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_closureRegistry[
        block.ref.target.address]!(arg0, arg1, arg2);

class ObjCBlock_ffiVoid_NSDictionary_NSRange_bool extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSDictionary_NSRange_bool._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSDictionary_NSRange_bool castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSDictionary_NSRange_bool._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSDictionary_NSRange_bool.fromFunctionPointer(
      ffi.Pointer<
              ffi
              .NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                      _NSRange arg1, ffi.Pointer<ffi.Bool> arg2)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            _NSRange,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSDictionary_NSRange_bool.fromFunction(
      void Function(objc.NSDictionary, _NSRange, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            _NSRange,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, _NSRange arg1,
                        ffi.Pointer<ffi.Bool> arg2) =>
                    fn(objc.NSDictionary.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSDictionary_NSRange_bool.listener(
      void Function(objc.NSDictionary, _NSRange, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            _NSRange,
                            ffi.Pointer<ffi.Bool>)>.listener(
                    _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSDictionary_NSRange_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, _NSRange arg1,
                        ffi.Pointer<ffi.Bool> arg2) =>
                    fn(objc.NSDictionary.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.NativeCallable<
      ffi.Void Function(
          ffi.Pointer<objc.ObjCBlock>,
          ffi.Pointer<objc.ObjCObject>,
          _NSRange,
          ffi.Pointer<ffi.Bool>)>? _dartFuncListenerTrampoline;

  void call(
          objc.NSDictionary arg0, _NSRange arg1, ffi.Pointer<ffi.Bool> arg2) =>
      pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      _NSRange arg1,
                      ffi.Pointer<ffi.Bool> arg2)>>()
          .asFunction<
              void Function(
                  ffi.Pointer<objc.ObjCBlock>,
                  ffi.Pointer<objc.ObjCObject>,
                  _NSRange,
                  ffi.Pointer<ffi.Bool>)>()(pointer, arg0.pointer, arg1, arg2);
}

late final _sel_enumerateAttributesInRange_options_usingBlock_ =
    objc.registerName("enumerateAttributesInRange:options:usingBlock:");
final _objc_msgSend_38 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
void _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        _NSRange arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                    _NSRange arg1, ffi.Pointer<ffi.Bool> arg2)>>()
        .asFunction<
            void Function(ffi.Pointer<objc.ObjCObject>, _NSRange,
                ffi.Pointer<ffi.Bool>)>()(arg0, arg1, arg2);
final _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_closureRegistry = <int,
    void Function(
        ffi.Pointer<objc.ObjCObject>, _NSRange, ffi.Pointer<ffi.Bool>)>{};
int _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_registerClosure(
        void Function(
                ffi.Pointer<objc.ObjCObject>, _NSRange, ffi.Pointer<ffi.Bool>)
            fn) {
  final id =
      ++_ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_closureRegistryIndex;
  _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        _NSRange arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_closureRegistry[
        block.ref.target.address]!(arg0, arg1, arg2);

class ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                      _NSRange arg1, ffi.Pointer<ffi.Bool> arg2)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            _NSRange,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool.fromFunction(
      void Function(objc.NSObject?, _NSRange, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            _NSRange,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, _NSRange arg1,
                        ffi.Pointer<ffi.Bool> arg2) =>
                    fn(arg0.address == 0 ? null : objc.NSObject.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool.listener(
      void Function(objc.NSObject?, _NSRange, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            _NSRange,
                            ffi.Pointer<ffi.Bool>)>.listener(
                    _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_objcObjCObject_NSRange_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, _NSRange arg1, ffi.Pointer<ffi.Bool> arg2) =>
                    fn(arg0.address == 0 ? null : objc.NSObject.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.NativeCallable<
      ffi.Void Function(
          ffi.Pointer<objc.ObjCBlock>,
          ffi.Pointer<objc.ObjCObject>,
          _NSRange,
          ffi.Pointer<ffi.Bool>)>? _dartFuncListenerTrampoline;

  void call(objc.NSObject? arg0, _NSRange arg1, ffi.Pointer<ffi.Bool> arg2) =>
      pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<objc.ObjCBlock> block,
                          ffi.Pointer<objc.ObjCObject> arg0,
                          _NSRange arg1,
                          ffi.Pointer<ffi.Bool> arg2)>>()
              .asFunction<
                  void Function(
                      ffi.Pointer<objc.ObjCBlock>,
                      ffi.Pointer<objc.ObjCObject>,
                      _NSRange,
                      ffi.Pointer<ffi.Bool>)>()(
          pointer, arg0?.pointer ?? ffi.nullptr, arg1, arg2);
}

late final _sel_enumerateAttribute_inRange_options_usingBlock_ =
    objc.registerName("enumerateAttribute:inRange:options:usingBlock:");
final _objc_msgSend_39 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();

class NSAttributedStringMarkdownParsingOptions extends objc.NSObject {
  NSAttributedStringMarkdownParsingOptions._(
      ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false,
      bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSAttributedStringMarkdownParsingOptions] that points to the same underlying object as [other].
  NSAttributedStringMarkdownParsingOptions.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSAttributedStringMarkdownParsingOptions] that wraps the given raw object pointer.
  NSAttributedStringMarkdownParsingOptions.castFromPointer(
      ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false,
      bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSAttributedStringMarkdownParsingOptions].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_,
        _class_NSAttributedStringMarkdownParsingOptions);
  }

  @override
  NSAttributedStringMarkdownParsingOptions init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSAttributedStringMarkdownParsingOptions.castFromPointer(_ret,
        retain: true, release: true);
  }

  bool get allowsExtendedAttributes {
    return _objc_msgSend_7(this.pointer, _sel_allowsExtendedAttributes);
  }

  set allowsExtendedAttributes(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setAllowsExtendedAttributes_, value);
  }

  int get interpretedSyntax {
    return _objc_msgSend_42(this.pointer, _sel_interpretedSyntax);
  }

  set interpretedSyntax(int value) {
    return _objc_msgSend_43(this.pointer, _sel_setInterpretedSyntax_, value);
  }

  int get failurePolicy {
    return _objc_msgSend_44(this.pointer, _sel_failurePolicy);
  }

  set failurePolicy(int value) {
    return _objc_msgSend_45(this.pointer, _sel_setFailurePolicy_, value);
  }

  objc.NSString? get languageCode {
    final _ret = _objc_msgSend_13(this.pointer, _sel_languageCode);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set languageCode(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setLanguageCode_, value?.pointer ?? ffi.nullptr);
  }

  bool get appliesSourcePositionAttributes {
    return _objc_msgSend_7(this.pointer, _sel_appliesSourcePositionAttributes);
  }

  set appliesSourcePositionAttributes(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setAppliesSourcePositionAttributes_, value);
  }

  static NSAttributedStringMarkdownParsingOptions new1() {
    final _ret = _objc_msgSend_40(
        _class_NSAttributedStringMarkdownParsingOptions, _sel_new);
    return NSAttributedStringMarkdownParsingOptions.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSAttributedStringMarkdownParsingOptions allocWithZone_(
      ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(
        _class_NSAttributedStringMarkdownParsingOptions,
        _sel_allocWithZone_,
        zone);
    return NSAttributedStringMarkdownParsingOptions.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSAttributedStringMarkdownParsingOptions alloc() {
    final _ret = _objc_msgSend_40(
        _class_NSAttributedStringMarkdownParsingOptions, _sel_alloc);
    return NSAttributedStringMarkdownParsingOptions.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSAttributedStringMarkdownParsingOptions,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSAttributedStringMarkdownParsingOptions,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(_class_NSAttributedStringMarkdownParsingOptions,
        _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSAttributedStringMarkdownParsingOptions,
        _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(
        _class_NSAttributedStringMarkdownParsingOptions,
        _sel_keyPathsForValuesAffectingValueForKey_,
        key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSAttributedStringMarkdownParsingOptions,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSAttributedStringMarkdownParsingOptions,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSAttributedStringMarkdownParsingOptions,
        _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSAttributedStringMarkdownParsingOptions,
        _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSAttributedStringMarkdownParsingOptions =
    objc.getClass("NSAttributedStringMarkdownParsingOptions");
late final _sel_init = objc.registerName("init");
final _objc_msgSend_40 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_allowsExtendedAttributes =
    objc.registerName("allowsExtendedAttributes");
late final _sel_setAllowsExtendedAttributes_ =
    objc.registerName("setAllowsExtendedAttributes:");
final _objc_msgSend_41 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Bool)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, bool)>();

abstract class NSAttributedStringMarkdownInterpretedSyntax {
  static const int NSAttributedStringMarkdownInterpretedSyntaxFull = 0;
  static const int NSAttributedStringMarkdownInterpretedSyntaxInlineOnly = 1;
  static const int
      NSAttributedStringMarkdownInterpretedSyntaxInlineOnlyPreservingWhitespace =
      2;
}

late final _sel_interpretedSyntax = objc.registerName("interpretedSyntax");
final _objc_msgSend_42 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setInterpretedSyntax_ =
    objc.registerName("setInterpretedSyntax:");
final _objc_msgSend_43 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSAttributedStringMarkdownParsingFailurePolicy {
  static const int NSAttributedStringMarkdownParsingFailureReturnError = 0;
  static const int
      NSAttributedStringMarkdownParsingFailureReturnPartiallyParsedIfPossible =
      1;
}

late final _sel_failurePolicy = objc.registerName("failurePolicy");
final _objc_msgSend_44 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setFailurePolicy_ = objc.registerName("setFailurePolicy:");
final _objc_msgSend_45 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_languageCode = objc.registerName("languageCode");
late final _sel_setLanguageCode_ = objc.registerName("setLanguageCode:");
final _objc_msgSend_46 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_appliesSourcePositionAttributes =
    objc.registerName("appliesSourcePositionAttributes");
late final _sel_setAppliesSourcePositionAttributes_ =
    objc.registerName("setAppliesSourcePositionAttributes:");
late final _sel_new = objc.registerName("new");

final class _NSZone extends ffi.Opaque {}

late final _sel_allocWithZone_ = objc.registerName("allocWithZone:");
final _objc_msgSend_47 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<_NSZone>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<_NSZone>)>();
late final _sel_alloc = objc.registerName("alloc");
late final _sel_cancelPreviousPerformRequestsWithTarget_selector_object_ = objc
    .registerName("cancelPreviousPerformRequestsWithTarget:selector:object:");
final _objc_msgSend_48 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_cancelPreviousPerformRequestsWithTarget_ =
    objc.registerName("cancelPreviousPerformRequestsWithTarget:");
final _objc_msgSend_49 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_accessInstanceVariablesDirectly =
    objc.registerName("accessInstanceVariablesDirectly");
late final _sel_useStoredAccessor = objc.registerName("useStoredAccessor");
late final _sel_keyPathsForValuesAffectingValueForKey_ =
    objc.registerName("keyPathsForValuesAffectingValueForKey:");
final _objc_msgSend_50 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_automaticallyNotifiesObserversForKey_ =
    objc.registerName("automaticallyNotifiesObserversForKey:");
final _objc_msgSend_51 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_setKeys_triggerChangeNotificationsForDependentKey_ =
    objc.registerName("setKeys:triggerChangeNotificationsForDependentKey:");
final _objc_msgSend_52 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_classFallbacksForKeyedArchiver =
    objc.registerName("classFallbacksForKeyedArchiver");
late final _sel_classForKeyedUnarchiver =
    objc.registerName("classForKeyedUnarchiver");
final _objc_msgSend_0 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_isKindOfClass_ = objc.registerName("isKindOfClass:");
late final _sel_initWithContentsOfMarkdownFileAtURL_options_baseURL_error_ =
    objc.registerName(
        "initWithContentsOfMarkdownFileAtURL:options:baseURL:error:");
final _objc_msgSend_53 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_initWithMarkdown_options_baseURL_error_ =
    objc.registerName("initWithMarkdown:options:baseURL:error:");
final _objc_msgSend_54 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_initWithMarkdownString_options_baseURL_error_ =
    objc.registerName("initWithMarkdownString:options:baseURL:error:");
final _objc_msgSend_55 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();

abstract class NSAttributedStringFormattingOptions {
  static const int
      NSAttributedStringFormattingInsertArgumentAttributesWithoutMerging = 1;
  static const int NSAttributedStringFormattingApplyReplacementIndexAttribute =
      2;
}

late final _sel_initWithFormat_options_locale_ =
    objc.registerName("initWithFormat:options:locale:");
final _objc_msgSend_56 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();

final class __va_list_tag extends ffi.Struct {
  @ffi.UnsignedInt()
  external int gp_offset;

  @ffi.UnsignedInt()
  external int fp_offset;

  external ffi.Pointer<ffi.Void> overflow_arg_area;

  external ffi.Pointer<ffi.Void> reg_save_area;
}

late final _sel_initWithFormat_options_locale_arguments_ =
    objc.registerName("initWithFormat:options:locale:arguments:");
final _objc_msgSend_57 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<__va_list_tag>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<__va_list_tag>)>();
late final _sel_localizedAttributedStringWithFormat_ =
    objc.registerName("localizedAttributedStringWithFormat:");
late final _sel_localizedAttributedStringWithFormat_options_ =
    objc.registerName("localizedAttributedStringWithFormat:options:");
final _objc_msgSend_58 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_initWithFormat_options_locale_context_ =
    objc.registerName("initWithFormat:options:locale:context:");
final _objc_msgSend_59 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithFormat_options_locale_context_arguments_ =
    objc.registerName("initWithFormat:options:locale:context:arguments:");
final _objc_msgSend_60 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<__va_list_tag>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<__va_list_tag>)>();
late final _sel_localizedAttributedStringWithFormat_context_ =
    objc.registerName("localizedAttributedStringWithFormat:context:");
final _objc_msgSend_61 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_localizedAttributedStringWithFormat_options_context_ =
    objc.registerName("localizedAttributedStringWithFormat:options:context:");
final _objc_msgSend_62 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_attributedStringByInflectingString =
    objc.registerName("attributedStringByInflectingString");
final _objc_msgSend_63 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_localizedAttributedStringForKey_value_table_ =
    objc.registerName("localizedAttributedStringForKey:value:table:");
final _objc_msgSend_64 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_bundleIdentifier = objc.registerName("bundleIdentifier");
late final _sel_infoDictionary = objc.registerName("infoDictionary");
final _objc_msgSend_65 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_localizedInfoDictionary =
    objc.registerName("localizedInfoDictionary");
late final _sel_objectForInfoDictionaryKey_ =
    objc.registerName("objectForInfoDictionaryKey:");
late final _sel_classNamed_ = objc.registerName("classNamed:");
late final _sel_principalClass = objc.registerName("principalClass");
final _objc_msgSend_66 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_preferredLocalizations =
    objc.registerName("preferredLocalizations");
late final _sel_localizations = objc.registerName("localizations");
late final _sel_developmentLocalization =
    objc.registerName("developmentLocalization");
late final _sel_preferredLocalizationsFromArray_ =
    objc.registerName("preferredLocalizationsFromArray:");
final _objc_msgSend_67 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_preferredLocalizationsFromArray_forPreferences_ =
    objc.registerName("preferredLocalizationsFromArray:forPreferences:");
final _objc_msgSend_68 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_executableArchitectures =
    objc.registerName("executableArchitectures");
final _objc_msgSend_69 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setPreservationPriority_forTags_ =
    objc.registerName("setPreservationPriority:forTags:");
final _objc_msgSend_70 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Double,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            double,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_preservationPriorityForTag_ =
    objc.registerName("preservationPriorityForTag:");
final _objc_msgSend_71 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        double Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_71Fpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        double Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

class NSMutableAttributedString extends NSAttributedString {
  NSMutableAttributedString._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableAttributedString] that points to the same underlying object as [other].
  NSMutableAttributedString.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSMutableAttributedString] that wraps the given raw object pointer.
  NSMutableAttributedString.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableAttributedString].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSMutableAttributedString);
  }

  void replaceCharactersInRange_withString_(_NSRange range, objc.NSString str) {
    _objc_msgSend_72(this.pointer, _sel_replaceCharactersInRange_withString_,
        range, str.pointer);
  }

  void setAttributes_range_(objc.NSDictionary? attrs, _NSRange range) {
    _objc_msgSend_73(this.pointer, _sel_setAttributes_range_,
        attrs?.pointer ?? ffi.nullptr, range);
  }

  objc.NSMutableString get mutableString {
    final _ret = _objc_msgSend_74(this.pointer, _sel_mutableString);
    return objc.NSMutableString.castFromPointer(_ret,
        retain: true, release: true);
  }

  void addAttribute_value_range_(
      objc.NSString name, objc.NSObject value, _NSRange range) {
    _objc_msgSend_75(this.pointer, _sel_addAttribute_value_range_, name.pointer,
        value.pointer, range);
  }

  void addAttributes_range_(objc.NSDictionary attrs, _NSRange range) {
    _objc_msgSend_76(
        this.pointer, _sel_addAttributes_range_, attrs.pointer, range);
  }

  void removeAttribute_range_(objc.NSString name, _NSRange range) {
    _objc_msgSend_77(
        this.pointer, _sel_removeAttribute_range_, name.pointer, range);
  }

  void replaceCharactersInRange_withAttributedString_(
      _NSRange range, NSAttributedString attrString) {
    _objc_msgSend_78(
        this.pointer,
        _sel_replaceCharactersInRange_withAttributedString_,
        range,
        attrString.pointer);
  }

  void insertAttributedString_atIndex_(NSAttributedString attrString, int loc) {
    _objc_msgSend_79(this.pointer, _sel_insertAttributedString_atIndex_,
        attrString.pointer, loc);
  }

  void appendAttributedString_(NSAttributedString attrString) {
    _objc_msgSend_80(
        this.pointer, _sel_appendAttributedString_, attrString.pointer);
  }

  void deleteCharactersInRange_(_NSRange range) {
    _objc_msgSend_81(this.pointer, _sel_deleteCharactersInRange_, range);
  }

  void setAttributedString_(NSAttributedString attrString) {
    _objc_msgSend_80(
        this.pointer, _sel_setAttributedString_, attrString.pointer);
  }

  void beginEditing() {
    _objc_msgSend_82(this.pointer, _sel_beginEditing);
  }

  void endEditing() {
    _objc_msgSend_82(this.pointer, _sel_endEditing);
  }

  void appendLocalizedFormat_(NSAttributedString format) {
    _objc_msgSend_80(this.pointer, _sel_appendLocalizedFormat_, format.pointer);
  }

  @override
  NSMutableAttributedString initWithString_(objc.NSString str) {
    final _ret =
        _objc_msgSend_35(this.pointer, _sel_initWithString_, str.pointer);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableAttributedString initWithString_attributes_(
      objc.NSString str, objc.NSDictionary? attrs) {
    final _ret = _objc_msgSend_36(this.pointer, _sel_initWithString_attributes_,
        str.pointer, attrs?.pointer ?? ffi.nullptr);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableAttributedString initWithAttributedString_(
      NSAttributedString attrStr) {
    final _ret = _objc_msgSend_37(
        this.pointer, _sel_initWithAttributedString_, attrStr.pointer);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableAttributedString?
      initWithContentsOfMarkdownFileAtURL_options_baseURL_error_(
          objc.NSURL markdownFile,
          NSAttributedStringMarkdownParsingOptions? options,
          objc.NSURL? baseURL,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_53(
        this.pointer,
        _sel_initWithContentsOfMarkdownFileAtURL_options_baseURL_error_,
        markdownFile.pointer,
        options?.pointer ?? ffi.nullptr,
        baseURL?.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSMutableAttributedString.castFromPointer(_ret,
            retain: true, release: true);
  }

  @override
  NSMutableAttributedString? initWithMarkdown_options_baseURL_error_(
      objc.NSData markdown,
      NSAttributedStringMarkdownParsingOptions? options,
      objc.NSURL? baseURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_54(
        this.pointer,
        _sel_initWithMarkdown_options_baseURL_error_,
        markdown.pointer,
        options?.pointer ?? ffi.nullptr,
        baseURL?.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSMutableAttributedString.castFromPointer(_ret,
            retain: true, release: true);
  }

  @override
  NSMutableAttributedString? initWithMarkdownString_options_baseURL_error_(
      objc.NSString markdownString,
      NSAttributedStringMarkdownParsingOptions? options,
      objc.NSURL? baseURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_55(
        this.pointer,
        _sel_initWithMarkdownString_options_baseURL_error_,
        markdownString.pointer,
        options?.pointer ?? ffi.nullptr,
        baseURL?.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSMutableAttributedString.castFromPointer(_ret,
            retain: true, release: true);
  }

  @override
  NSMutableAttributedString initWithFormat_options_locale_(
      NSAttributedString format, int options, objc.NSLocale? locale) {
    final _ret = _objc_msgSend_56(
        this.pointer,
        _sel_initWithFormat_options_locale_,
        format.pointer,
        options,
        locale?.pointer ?? ffi.nullptr);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableAttributedString initWithFormat_options_locale_arguments_(
      NSAttributedString format,
      int options,
      objc.NSLocale? locale,
      ffi.Pointer<__va_list_tag> arguments) {
    final _ret = _objc_msgSend_57(
        this.pointer,
        _sel_initWithFormat_options_locale_arguments_,
        format.pointer,
        options,
        locale?.pointer ?? ffi.nullptr,
        arguments);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableAttributedString localizedAttributedStringWithFormat_(
      NSAttributedString format) {
    final _ret = _objc_msgSend_37(_class_NSMutableAttributedString,
        _sel_localizedAttributedStringWithFormat_, format.pointer);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableAttributedString localizedAttributedStringWithFormat_options_(
      NSAttributedString format, int options) {
    final _ret = _objc_msgSend_58(
        _class_NSMutableAttributedString,
        _sel_localizedAttributedStringWithFormat_options_,
        format.pointer,
        options);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableAttributedString initWithFormat_options_locale_context_(
      NSAttributedString format,
      int options,
      objc.NSLocale? locale,
      objc.NSDictionary context) {
    final _ret = _objc_msgSend_59(
        this.pointer,
        _sel_initWithFormat_options_locale_context_,
        format.pointer,
        options,
        locale?.pointer ?? ffi.nullptr,
        context.pointer);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableAttributedString initWithFormat_options_locale_context_arguments_(
      NSAttributedString format,
      int options,
      objc.NSLocale? locale,
      objc.NSDictionary context,
      ffi.Pointer<__va_list_tag> arguments) {
    final _ret = _objc_msgSend_60(
        this.pointer,
        _sel_initWithFormat_options_locale_context_arguments_,
        format.pointer,
        options,
        locale?.pointer ?? ffi.nullptr,
        context.pointer,
        arguments);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableAttributedString localizedAttributedStringWithFormat_context_(
      NSAttributedString format, objc.NSDictionary context) {
    final _ret = _objc_msgSend_61(
        _class_NSMutableAttributedString,
        _sel_localizedAttributedStringWithFormat_context_,
        format.pointer,
        context.pointer);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableAttributedString
      localizedAttributedStringWithFormat_options_context_(
          NSAttributedString format, int options, objc.NSDictionary context) {
    final _ret = _objc_msgSend_62(
        _class_NSMutableAttributedString,
        _sel_localizedAttributedStringWithFormat_options_context_,
        format.pointer,
        options,
        context.pointer);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableAttributedString init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableAttributedString new1() {
    final _ret = _objc_msgSend_40(_class_NSMutableAttributedString, _sel_new);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMutableAttributedString allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(
        _class_NSMutableAttributedString, _sel_allocWithZone_, zone);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMutableAttributedString alloc() {
    final _ret = _objc_msgSend_40(_class_NSMutableAttributedString, _sel_alloc);
    return NSMutableAttributedString.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSMutableAttributedString,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSMutableAttributedString,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSMutableAttributedString, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(
        _class_NSMutableAttributedString, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSMutableAttributedString,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSMutableAttributedString,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSMutableAttributedString,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSMutableAttributedString, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSMutableAttributedString, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSMutableAttributedString =
    objc.getClass("NSMutableAttributedString");
late final _sel_replaceCharactersInRange_withString_ =
    objc.registerName("replaceCharactersInRange:withString:");
final _objc_msgSend_72 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_setAttributes_range_ =
    objc.registerName("setAttributes:range:");
final _objc_msgSend_73 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange)>();
late final _sel_mutableString = objc.registerName("mutableString");
final _objc_msgSend_74 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_addAttribute_value_range_ =
    objc.registerName("addAttribute:value:range:");
final _objc_msgSend_75 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange)>();
late final _sel_addAttributes_range_ =
    objc.registerName("addAttributes:range:");
final _objc_msgSend_76 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange)>();
late final _sel_removeAttribute_range_ =
    objc.registerName("removeAttribute:range:");
final _objc_msgSend_77 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange)>();
late final _sel_replaceCharactersInRange_withAttributedString_ =
    objc.registerName("replaceCharactersInRange:withAttributedString:");
final _objc_msgSend_78 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_insertAttributedString_atIndex_ =
    objc.registerName("insertAttributedString:atIndex:");
final _objc_msgSend_79 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_appendAttributedString_ =
    objc.registerName("appendAttributedString:");
final _objc_msgSend_80 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_deleteCharactersInRange_ =
    objc.registerName("deleteCharactersInRange:");
final _objc_msgSend_81 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, _NSRange)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, _NSRange)>();
late final _sel_setAttributedString_ =
    objc.registerName("setAttributedString:");
late final _sel_beginEditing = objc.registerName("beginEditing");
final _objc_msgSend_82 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_endEditing = objc.registerName("endEditing");
late final _sel_appendLocalizedFormat_ =
    objc.registerName("appendLocalizedFormat:");

class NSDateFormatter extends NSFormatter {
  NSDateFormatter._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSDateFormatter] that points to the same underlying object as [other].
  NSDateFormatter.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSDateFormatter] that wraps the given raw object pointer.
  NSDateFormatter.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSDateFormatter].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSDateFormatter);
  }

  int get formattingContext {
    return _objc_msgSend_89(this.pointer, _sel_formattingContext);
  }

  set formattingContext(int value) {
    return _objc_msgSend_90(this.pointer, _sel_setFormattingContext_, value);
  }

  bool getObjectValue_forString_range_error_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> obj,
      objc.NSString string,
      ffi.Pointer<_NSRange> rangep,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_91(
        this.pointer,
        _sel_getObjectValue_forString_range_error_,
        obj,
        string.pointer,
        rangep,
        error);
  }

  objc.NSString stringFromDate_(objc.NSDate date) {
    final _ret =
        _objc_msgSend_92(this.pointer, _sel_stringFromDate_, date.pointer);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? dateFromString_(objc.NSString string) {
    final _ret =
        _objc_msgSend_93(this.pointer, _sel_dateFromString_, string.pointer);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSString localizedStringFromDate_dateStyle_timeStyle_(
      objc.NSDate date, int dstyle, int tstyle) {
    final _ret = _objc_msgSend_94(
        _class_NSDateFormatter,
        _sel_localizedStringFromDate_dateStyle_timeStyle_,
        date.pointer,
        dstyle,
        tstyle);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSString? dateFormatFromTemplate_options_locale_(
      objc.NSString tmplate, int opts, objc.NSLocale? locale) {
    final _ret = _objc_msgSend_95(
        _class_NSDateFormatter,
        _sel_dateFormatFromTemplate_options_locale_,
        tmplate.pointer,
        opts,
        locale?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static int getDefaultFormatterBehavior() {
    return _objc_msgSend_96(
        _class_NSDateFormatter, _sel_defaultFormatterBehavior);
  }

  static void setDefaultFormatterBehavior(int value) {
    return _objc_msgSend_97(
        _class_NSDateFormatter, _sel_setDefaultFormatterBehavior_, value);
  }

  void setLocalizedDateFormatFromTemplate_(objc.NSString dateFormatTemplate) {
    _objc_msgSend_98(this.pointer, _sel_setLocalizedDateFormatFromTemplate_,
        dateFormatTemplate.pointer);
  }

  objc.NSString get dateFormat {
    final _ret = _objc_msgSend_12(this.pointer, _sel_dateFormat);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set dateFormat(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setDateFormat_, value.pointer);
  }

  int get dateStyle {
    return _objc_msgSend_100(this.pointer, _sel_dateStyle);
  }

  set dateStyle(int value) {
    return _objc_msgSend_101(this.pointer, _sel_setDateStyle_, value);
  }

  int get timeStyle {
    return _objc_msgSend_100(this.pointer, _sel_timeStyle);
  }

  set timeStyle(int value) {
    return _objc_msgSend_101(this.pointer, _sel_setTimeStyle_, value);
  }

  objc.NSLocale get locale {
    final _ret = _objc_msgSend_102(this.pointer, _sel_locale);
    return objc.NSLocale.castFromPointer(_ret, retain: true, release: true);
  }

  set locale(objc.NSLocale value) {
    return _objc_msgSend_103(this.pointer, _sel_setLocale_, value.pointer);
  }

  bool get generatesCalendarDates {
    return _objc_msgSend_7(this.pointer, _sel_generatesCalendarDates);
  }

  set generatesCalendarDates(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setGeneratesCalendarDates_, value);
  }

  int get formatterBehavior {
    return _objc_msgSend_96(this.pointer, _sel_formatterBehavior);
  }

  set formatterBehavior(int value) {
    return _objc_msgSend_97(this.pointer, _sel_setFormatterBehavior_, value);
  }

  NSTimeZone get timeZone {
    final _ret = _objc_msgSend_110(this.pointer, _sel_timeZone);
    return NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  set timeZone(NSTimeZone value) {
    return _objc_msgSend_111(this.pointer, _sel_setTimeZone_, value.pointer);
  }

  NSCalendar get calendar {
    final _ret = _objc_msgSend_121(this.pointer, _sel_calendar);
    return NSCalendar.castFromPointer(_ret, retain: true, release: true);
  }

  set calendar(NSCalendar value) {
    return _objc_msgSend_161(this.pointer, _sel_setCalendar_, value.pointer);
  }

  bool get lenient {
    return _objc_msgSend_7(this.pointer, _sel_isLenient);
  }

  set lenient(bool value) {
    return _objc_msgSend_41(this.pointer, _sel_setLenient_, value);
  }

  objc.NSDate? get twoDigitStartDate {
    final _ret = _objc_msgSend_116(this.pointer, _sel_twoDigitStartDate);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  set twoDigitStartDate(objc.NSDate? value) {
    return _objc_msgSend_162(this.pointer, _sel_setTwoDigitStartDate_,
        value?.pointer ?? ffi.nullptr);
  }

  objc.NSDate? get defaultDate {
    final _ret = _objc_msgSend_116(this.pointer, _sel_defaultDate);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  set defaultDate(objc.NSDate? value) {
    return _objc_msgSend_162(
        this.pointer, _sel_setDefaultDate_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSArray get eraSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_eraSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set eraSymbols(objc.NSArray value) {
    return _objc_msgSend_163(this.pointer, _sel_setEraSymbols_, value.pointer);
  }

  objc.NSArray get monthSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_monthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set monthSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setMonthSymbols_, value.pointer);
  }

  objc.NSArray get shortMonthSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_shortMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set shortMonthSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setShortMonthSymbols_, value.pointer);
  }

  objc.NSArray get weekdaySymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_weekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set weekdaySymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setWeekdaySymbols_, value.pointer);
  }

  objc.NSArray get shortWeekdaySymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_shortWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set shortWeekdaySymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setShortWeekdaySymbols_, value.pointer);
  }

  objc.NSString get AMSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_AMSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set AMSymbol(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setAMSymbol_, value.pointer);
  }

  objc.NSString get PMSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_PMSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set PMSymbol(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setPMSymbol_, value.pointer);
  }

  objc.NSArray get longEraSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_longEraSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set longEraSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setLongEraSymbols_, value.pointer);
  }

  objc.NSArray get veryShortMonthSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_veryShortMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set veryShortMonthSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setVeryShortMonthSymbols_, value.pointer);
  }

  objc.NSArray get standaloneMonthSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_standaloneMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set standaloneMonthSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setStandaloneMonthSymbols_, value.pointer);
  }

  objc.NSArray get shortStandaloneMonthSymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_shortStandaloneMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set shortStandaloneMonthSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setShortStandaloneMonthSymbols_, value.pointer);
  }

  objc.NSArray get veryShortStandaloneMonthSymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_veryShortStandaloneMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set veryShortStandaloneMonthSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setVeryShortStandaloneMonthSymbols_, value.pointer);
  }

  objc.NSArray get veryShortWeekdaySymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_veryShortWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set veryShortWeekdaySymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setVeryShortWeekdaySymbols_, value.pointer);
  }

  objc.NSArray get standaloneWeekdaySymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_standaloneWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set standaloneWeekdaySymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setStandaloneWeekdaySymbols_, value.pointer);
  }

  objc.NSArray get shortStandaloneWeekdaySymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_shortStandaloneWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set shortStandaloneWeekdaySymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setShortStandaloneWeekdaySymbols_, value.pointer);
  }

  objc.NSArray get veryShortStandaloneWeekdaySymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_veryShortStandaloneWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set veryShortStandaloneWeekdaySymbols(objc.NSArray value) {
    return _objc_msgSend_163(this.pointer,
        _sel_setVeryShortStandaloneWeekdaySymbols_, value.pointer);
  }

  objc.NSArray get quarterSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_quarterSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set quarterSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setQuarterSymbols_, value.pointer);
  }

  objc.NSArray get shortQuarterSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_shortQuarterSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set shortQuarterSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setShortQuarterSymbols_, value.pointer);
  }

  objc.NSArray get standaloneQuarterSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_standaloneQuarterSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set standaloneQuarterSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setStandaloneQuarterSymbols_, value.pointer);
  }

  objc.NSArray get shortStandaloneQuarterSymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_shortStandaloneQuarterSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  set shortStandaloneQuarterSymbols(objc.NSArray value) {
    return _objc_msgSend_163(
        this.pointer, _sel_setShortStandaloneQuarterSymbols_, value.pointer);
  }

  objc.NSDate? get gregorianStartDate {
    final _ret = _objc_msgSend_116(this.pointer, _sel_gregorianStartDate);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  set gregorianStartDate(objc.NSDate? value) {
    return _objc_msgSend_162(this.pointer, _sel_setGregorianStartDate_,
        value?.pointer ?? ffi.nullptr);
  }

  bool get doesRelativeDateFormatting {
    return _objc_msgSend_7(this.pointer, _sel_doesRelativeDateFormatting);
  }

  set doesRelativeDateFormatting(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setDoesRelativeDateFormatting_, value);
  }

  objc.NSObject initWithDateFormat_allowNaturalLanguage_(
      objc.NSString format, bool flag) {
    final _ret = _objc_msgSend_164(this.pointer,
        _sel_initWithDateFormat_allowNaturalLanguage_, format.pointer, flag);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  bool allowsNaturalLanguage() {
    return _objc_msgSend_7(this.pointer, _sel_allowsNaturalLanguage);
  }

  @override
  NSDateFormatter init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSDateFormatter.castFromPointer(_ret, retain: true, release: true);
  }

  static NSDateFormatter new1() {
    final _ret = _objc_msgSend_40(_class_NSDateFormatter, _sel_new);
    return NSDateFormatter.castFromPointer(_ret, retain: false, release: true);
  }

  static NSDateFormatter allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSDateFormatter, _sel_allocWithZone_, zone);
    return NSDateFormatter.castFromPointer(_ret, retain: false, release: true);
  }

  static NSDateFormatter alloc() {
    final _ret = _objc_msgSend_40(_class_NSDateFormatter, _sel_alloc);
    return NSDateFormatter.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSDateFormatter,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSDateFormatter,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSDateFormatter, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSDateFormatter, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSDateFormatter,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSDateFormatter,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSDateFormatter,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSDateFormatter, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSDateFormatter, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSDateFormatter = objc.getClass("NSDateFormatter");

class NSFormatter extends objc.NSObject {
  NSFormatter._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSFormatter] that points to the same underlying object as [other].
  NSFormatter.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSFormatter] that wraps the given raw object pointer.
  NSFormatter.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSFormatter].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSFormatter);
  }

  objc.NSString? stringForObjectValue_(objc.NSObject? obj) {
    final _ret = _objc_msgSend_83(
        this.pointer, _sel_stringForObjectValue_, obj?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  NSAttributedString? attributedStringForObjectValue_withDefaultAttributes_(
      objc.NSObject obj, objc.NSDictionary? attrs) {
    final _ret = _objc_msgSend_84(
        this.pointer,
        _sel_attributedStringForObjectValue_withDefaultAttributes_,
        obj.pointer,
        attrs?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSAttributedString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? editingStringForObjectValue_(objc.NSObject obj) {
    final _ret = _objc_msgSend_85(
        this.pointer, _sel_editingStringForObjectValue_, obj.pointer);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool getObjectValue_forString_errorDescription_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> obj,
      objc.NSString string,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_86(
        this.pointer,
        _sel_getObjectValue_forString_errorDescription_,
        obj,
        string.pointer,
        error);
  }

  bool isPartialStringValid_newEditingString_errorDescription_(
      objc.NSString partialString,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> newString,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_87(
        this.pointer,
        _sel_isPartialStringValid_newEditingString_errorDescription_,
        partialString.pointer,
        newString,
        error);
  }

  bool
      isPartialStringValid_proposedSelectedRange_originalString_originalSelectedRange_errorDescription_(
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> partialStringPtr,
          ffi.Pointer<_NSRange> proposedSelRangePtr,
          objc.NSString origString,
          _NSRange origSelRange,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_88(
        this.pointer,
        _sel_isPartialStringValid_proposedSelectedRange_originalString_originalSelectedRange_errorDescription_,
        partialStringPtr,
        proposedSelRangePtr,
        origString.pointer,
        origSelRange,
        error);
  }

  @override
  NSFormatter init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSFormatter.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFormatter new1() {
    final _ret = _objc_msgSend_40(_class_NSFormatter, _sel_new);
    return NSFormatter.castFromPointer(_ret, retain: false, release: true);
  }

  static NSFormatter allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSFormatter, _sel_allocWithZone_, zone);
    return NSFormatter.castFromPointer(_ret, retain: false, release: true);
  }

  static NSFormatter alloc() {
    final _ret = _objc_msgSend_40(_class_NSFormatter, _sel_alloc);
    return NSFormatter.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSFormatter,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSFormatter,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSFormatter, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSFormatter, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSFormatter,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSFormatter,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSFormatter,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSFormatter, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSFormatter, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSFormatter = objc.getClass("NSFormatter");
late final _sel_stringForObjectValue_ =
    objc.registerName("stringForObjectValue:");
final _objc_msgSend_83 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_attributedStringForObjectValue_withDefaultAttributes_ =
    objc.registerName("attributedStringForObjectValue:withDefaultAttributes:");
final _objc_msgSend_84 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_editingStringForObjectValue_ =
    objc.registerName("editingStringForObjectValue:");
final _objc_msgSend_85 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_getObjectValue_forString_errorDescription_ =
    objc.registerName("getObjectValue:forString:errorDescription:");
final _objc_msgSend_86 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_isPartialStringValid_newEditingString_errorDescription_ = objc
    .registerName("isPartialStringValid:newEditingString:errorDescription:");
final _objc_msgSend_87 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_isPartialStringValid_proposedSelectedRange_originalString_originalSelectedRange_errorDescription_ =
    objc.registerName(
        "isPartialStringValid:proposedSelectedRange:originalString:originalSelectedRange:errorDescription:");
final _objc_msgSend_88 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<_NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<_NSRange>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();

abstract class NSFormattingContext {
  static const int NSFormattingContextUnknown = 0;
  static const int NSFormattingContextDynamic = 1;
  static const int NSFormattingContextStandalone = 2;
  static const int NSFormattingContextListItem = 3;
  static const int NSFormattingContextBeginningOfSentence = 4;
  static const int NSFormattingContextMiddleOfSentence = 5;
}

late final _sel_formattingContext = objc.registerName("formattingContext");
final _objc_msgSend_89 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setFormattingContext_ =
    objc.registerName("setFormattingContext:");
final _objc_msgSend_90 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_getObjectValue_forString_range_error_ =
    objc.registerName("getObjectValue:forString:range:error:");
final _objc_msgSend_91 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<_NSRange>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<_NSRange>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_stringFromDate_ = objc.registerName("stringFromDate:");
final _objc_msgSend_92 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_dateFromString_ = objc.registerName("dateFromString:");
final _objc_msgSend_93 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

abstract class NSDateFormatterStyle {
  static const int NSDateFormatterNoStyle = 0;
  static const int NSDateFormatterShortStyle = 1;
  static const int NSDateFormatterMediumStyle = 2;
  static const int NSDateFormatterLongStyle = 3;
  static const int NSDateFormatterFullStyle = 4;
}

late final _sel_localizedStringFromDate_dateStyle_timeStyle_ =
    objc.registerName("localizedStringFromDate:dateStyle:timeStyle:");
final _objc_msgSend_94 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            int)>();
late final _sel_dateFormatFromTemplate_options_locale_ =
    objc.registerName("dateFormatFromTemplate:options:locale:");
final _objc_msgSend_95 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();

abstract class NSDateFormatterBehavior {
  static const int NSDateFormatterBehaviorDefault = 0;
  static const int NSDateFormatterBehavior10_0 = 1000;
  static const int NSDateFormatterBehavior10_4 = 1040;
}

late final _sel_defaultFormatterBehavior =
    objc.registerName("defaultFormatterBehavior");
final _objc_msgSend_96 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setDefaultFormatterBehavior_ =
    objc.registerName("setDefaultFormatterBehavior:");
final _objc_msgSend_97 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_setLocalizedDateFormatFromTemplate_ =
    objc.registerName("setLocalizedDateFormatFromTemplate:");
final _objc_msgSend_98 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_dateFormat = objc.registerName("dateFormat");
late final _sel_setDateFormat_ = objc.registerName("setDateFormat:");
final _objc_msgSend_99 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_dateStyle = objc.registerName("dateStyle");
final _objc_msgSend_100 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setDateStyle_ = objc.registerName("setDateStyle:");
final _objc_msgSend_101 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_timeStyle = objc.registerName("timeStyle");
late final _sel_setTimeStyle_ = objc.registerName("setTimeStyle:");
late final _sel_locale = objc.registerName("locale");
final _objc_msgSend_102 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setLocale_ = objc.registerName("setLocale:");
final _objc_msgSend_103 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_generatesCalendarDates =
    objc.registerName("generatesCalendarDates");
late final _sel_setGeneratesCalendarDates_ =
    objc.registerName("setGeneratesCalendarDates:");
late final _sel_formatterBehavior = objc.registerName("formatterBehavior");
late final _sel_setFormatterBehavior_ =
    objc.registerName("setFormatterBehavior:");

class NSTimeZone extends objc.NSObject {
  NSTimeZone._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSTimeZone] that points to the same underlying object as [other].
  NSTimeZone.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSTimeZone] that wraps the given raw object pointer.
  NSTimeZone.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSTimeZone].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSTimeZone);
  }

  objc.NSString get name {
    final _ret = _objc_msgSend_12(this.pointer, _sel_name);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSData get data {
    final _ret = _objc_msgSend_104(this.pointer, _sel_data);
    return objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  int secondsFromGMTForDate_(objc.NSDate aDate) {
    return _objc_msgSend_105(
        this.pointer, _sel_secondsFromGMTForDate_, aDate.pointer);
  }

  objc.NSString? abbreviationForDate_(objc.NSDate aDate) {
    final _ret = _objc_msgSend_106(
        this.pointer, _sel_abbreviationForDate_, aDate.pointer);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool isDaylightSavingTimeForDate_(objc.NSDate aDate) {
    return _objc_msgSend_107(
        this.pointer, _sel_isDaylightSavingTimeForDate_, aDate.pointer);
  }

  double daylightSavingTimeOffsetForDate_(objc.NSDate aDate) {
    return objc.useMsgSendVariants
        ? _objc_msgSend_108Fpret(
            this.pointer, _sel_daylightSavingTimeOffsetForDate_, aDate.pointer)
        : _objc_msgSend_108(
            this.pointer, _sel_daylightSavingTimeOffsetForDate_, aDate.pointer);
  }

  objc.NSDate? nextDaylightSavingTimeTransitionAfterDate_(objc.NSDate aDate) {
    final _ret = _objc_msgSend_109(this.pointer,
        _sel_nextDaylightSavingTimeTransitionAfterDate_, aDate.pointer);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimeZone getSystemTimeZone() {
    final _ret = _objc_msgSend_110(_class_NSTimeZone, _sel_systemTimeZone);
    return NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  static void resetSystemTimeZone() {
    _objc_msgSend_82(_class_NSTimeZone, _sel_resetSystemTimeZone);
  }

  static NSTimeZone getDefaultTimeZone() {
    final _ret = _objc_msgSend_110(_class_NSTimeZone, _sel_defaultTimeZone);
    return NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  static void setDefaultTimeZone(NSTimeZone value) {
    return _objc_msgSend_111(
        _class_NSTimeZone, _sel_setDefaultTimeZone_, value.pointer);
  }

  static NSTimeZone getLocalTimeZone() {
    final _ret = _objc_msgSend_110(_class_NSTimeZone, _sel_localTimeZone);
    return NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray getKnownTimeZoneNames() {
    final _ret = _objc_msgSend_6(_class_NSTimeZone, _sel_knownTimeZoneNames);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSDictionary getAbbreviationDictionary() {
    final _ret =
        _objc_msgSend_112(_class_NSTimeZone, _sel_abbreviationDictionary);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  static void setAbbreviationDictionary(objc.NSDictionary value) {
    return _objc_msgSend_113(
        _class_NSTimeZone, _sel_setAbbreviationDictionary_, value.pointer);
  }

  static objc.NSString getTimeZoneDataVersion() {
    final _ret = _objc_msgSend_12(_class_NSTimeZone, _sel_timeZoneDataVersion);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int get secondsFromGMT {
    return _objc_msgSend_114(this.pointer, _sel_secondsFromGMT);
  }

  objc.NSString? get abbreviation {
    final _ret = _objc_msgSend_13(this.pointer, _sel_abbreviation);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool get daylightSavingTime {
    return _objc_msgSend_7(this.pointer, _sel_isDaylightSavingTime);
  }

  double get daylightSavingTimeOffset {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_daylightSavingTimeOffset)
        : _objc_msgSend_115(this.pointer, _sel_daylightSavingTimeOffset);
  }

  objc.NSDate? get nextDaylightSavingTimeTransition {
    final _ret =
        _objc_msgSend_116(this.pointer, _sel_nextDaylightSavingTimeTransition);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get description {
    final _ret = _objc_msgSend_12(this.pointer, _sel_description);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool isEqualToTimeZone_(NSTimeZone aTimeZone) {
    return _objc_msgSend_117(
        this.pointer, _sel_isEqualToTimeZone_, aTimeZone.pointer);
  }

  objc.NSString? localizedName_locale_(int style, objc.NSLocale? locale) {
    final _ret = _objc_msgSend_118(this.pointer, _sel_localizedName_locale_,
        style, locale?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimeZone? timeZoneWithName_(objc.NSString tzName) {
    final _ret = _objc_msgSend_2(
        _class_NSTimeZone, _sel_timeZoneWithName_, tzName.pointer);
    return _ret.address == 0
        ? null
        : NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimeZone? timeZoneWithName_data_(
      objc.NSString tzName, objc.NSData? aData) {
    final _ret = _objc_msgSend_119(
        _class_NSTimeZone,
        _sel_timeZoneWithName_data_,
        tzName.pointer,
        aData?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  NSTimeZone? initWithName_(objc.NSString tzName) {
    final _ret =
        _objc_msgSend_2(this.pointer, _sel_initWithName_, tzName.pointer);
    return _ret.address == 0
        ? null
        : NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  NSTimeZone? initWithName_data_(objc.NSString tzName, objc.NSData? aData) {
    final _ret = _objc_msgSend_119(this.pointer, _sel_initWithName_data_,
        tzName.pointer, aData?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimeZone timeZoneForSecondsFromGMT_(int seconds) {
    final _ret = _objc_msgSend_120(
        _class_NSTimeZone, _sel_timeZoneForSecondsFromGMT_, seconds);
    return NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimeZone? timeZoneWithAbbreviation_(objc.NSString abbreviation) {
    final _ret = _objc_msgSend_2(_class_NSTimeZone,
        _sel_timeZoneWithAbbreviation_, abbreviation.pointer);
    return _ret.address == 0
        ? null
        : NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSTimeZone init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimeZone new1() {
    final _ret = _objc_msgSend_40(_class_NSTimeZone, _sel_new);
    return NSTimeZone.castFromPointer(_ret, retain: false, release: true);
  }

  static NSTimeZone allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSTimeZone, _sel_allocWithZone_, zone);
    return NSTimeZone.castFromPointer(_ret, retain: false, release: true);
  }

  static NSTimeZone alloc() {
    final _ret = _objc_msgSend_40(_class_NSTimeZone, _sel_alloc);
    return NSTimeZone.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSTimeZone,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSTimeZone,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSTimeZone, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSTimeZone, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSTimeZone,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSTimeZone,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSTimeZone,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSTimeZone, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSTimeZone, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSTimeZone = objc.getClass("NSTimeZone");
late final _sel_name = objc.registerName("name");
late final _sel_data = objc.registerName("data");
final _objc_msgSend_104 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_secondsFromGMTForDate_ =
    objc.registerName("secondsFromGMTForDate:");
final _objc_msgSend_105 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_abbreviationForDate_ =
    objc.registerName("abbreviationForDate:");
final _objc_msgSend_106 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_isDaylightSavingTimeForDate_ =
    objc.registerName("isDaylightSavingTimeForDate:");
final _objc_msgSend_107 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_daylightSavingTimeOffsetForDate_ =
    objc.registerName("daylightSavingTimeOffsetForDate:");
final _objc_msgSend_108 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        double Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_108Fpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        double Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_nextDaylightSavingTimeTransitionAfterDate_ =
    objc.registerName("nextDaylightSavingTimeTransitionAfterDate:");
final _objc_msgSend_109 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_systemTimeZone = objc.registerName("systemTimeZone");
final _objc_msgSend_110 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_resetSystemTimeZone = objc.registerName("resetSystemTimeZone");
late final _sel_defaultTimeZone = objc.registerName("defaultTimeZone");
late final _sel_setDefaultTimeZone_ = objc.registerName("setDefaultTimeZone:");
final _objc_msgSend_111 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_localTimeZone = objc.registerName("localTimeZone");
late final _sel_knownTimeZoneNames = objc.registerName("knownTimeZoneNames");
late final _sel_abbreviationDictionary =
    objc.registerName("abbreviationDictionary");
final _objc_msgSend_112 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setAbbreviationDictionary_ =
    objc.registerName("setAbbreviationDictionary:");
final _objc_msgSend_113 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_timeZoneDataVersion = objc.registerName("timeZoneDataVersion");
late final _sel_secondsFromGMT = objc.registerName("secondsFromGMT");
final _objc_msgSend_114 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_abbreviation = objc.registerName("abbreviation");
late final _sel_isDaylightSavingTime =
    objc.registerName("isDaylightSavingTime");
late final _sel_daylightSavingTimeOffset =
    objc.registerName("daylightSavingTimeOffset");
final _objc_msgSend_115 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_115Fpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_nextDaylightSavingTimeTransition =
    objc.registerName("nextDaylightSavingTimeTransition");
final _objc_msgSend_116 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_description = objc.registerName("description");
late final _sel_isEqualToTimeZone_ = objc.registerName("isEqualToTimeZone:");
final _objc_msgSend_117 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

abstract class NSTimeZoneNameStyle {
  static const int NSTimeZoneNameStyleStandard = 0;
  static const int NSTimeZoneNameStyleShortStandard = 1;
  static const int NSTimeZoneNameStyleDaylightSaving = 2;
  static const int NSTimeZoneNameStyleShortDaylightSaving = 3;
  static const int NSTimeZoneNameStyleGeneric = 4;
  static const int NSTimeZoneNameStyleShortGeneric = 5;
}

late final _sel_localizedName_locale_ =
    objc.registerName("localizedName:locale:");
final _objc_msgSend_118 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_timeZoneWithName_ = objc.registerName("timeZoneWithName:");
late final _sel_timeZoneWithName_data_ =
    objc.registerName("timeZoneWithName:data:");
final _objc_msgSend_119 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithName_ = objc.registerName("initWithName:");
late final _sel_initWithName_data_ = objc.registerName("initWithName:data:");
late final _sel_timeZoneForSecondsFromGMT_ =
    objc.registerName("timeZoneForSecondsFromGMT:");
final _objc_msgSend_120 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Long)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_timeZoneWithAbbreviation_ =
    objc.registerName("timeZoneWithAbbreviation:");
late final _sel_timeZone = objc.registerName("timeZone");
late final _sel_setTimeZone_ = objc.registerName("setTimeZone:");

class NSCalendar extends objc.NSObject {
  NSCalendar._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSCalendar] that points to the same underlying object as [other].
  NSCalendar.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSCalendar] that wraps the given raw object pointer.
  NSCalendar.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSCalendar].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSCalendar);
  }

  static NSCalendar getCurrentCalendar() {
    final _ret = _objc_msgSend_121(_class_NSCalendar, _sel_currentCalendar);
    return NSCalendar.castFromPointer(_ret, retain: true, release: true);
  }

  static NSCalendar getAutoupdatingCurrentCalendar() {
    final _ret =
        _objc_msgSend_121(_class_NSCalendar, _sel_autoupdatingCurrentCalendar);
    return NSCalendar.castFromPointer(_ret, retain: true, release: true);
  }

  static NSCalendar? calendarWithIdentifier_(
      objc.NSString calendarIdentifierConstant) {
    final _ret = _objc_msgSend_122(_class_NSCalendar,
        _sel_calendarWithIdentifier_, calendarIdentifierConstant.pointer);
    return _ret.address == 0
        ? null
        : NSCalendar.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSCalendar init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSCalendar.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? initWithCalendarIdentifier_(objc.NSString ident) {
    final _ret = _objc_msgSend_2(
        this.pointer, _sel_initWithCalendarIdentifier_, ident.pointer);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get calendarIdentifier {
    final _ret = _objc_msgSend_12(this.pointer, _sel_calendarIdentifier);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSLocale? get locale {
    final _ret = _objc_msgSend_123(this.pointer, _sel_locale);
    return _ret.address == 0
        ? null
        : objc.NSLocale.castFromPointer(_ret, retain: true, release: true);
  }

  set locale(objc.NSLocale? value) {
    return _objc_msgSend_124(
        this.pointer, _sel_setLocale_, value?.pointer ?? ffi.nullptr);
  }

  NSTimeZone get timeZone {
    final _ret = _objc_msgSend_110(this.pointer, _sel_timeZone);
    return NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  set timeZone(NSTimeZone value) {
    return _objc_msgSend_111(this.pointer, _sel_setTimeZone_, value.pointer);
  }

  int get firstWeekday {
    return _objc_msgSend_29(this.pointer, _sel_firstWeekday);
  }

  set firstWeekday(int value) {
    return _objc_msgSend_125(this.pointer, _sel_setFirstWeekday_, value);
  }

  int get minimumDaysInFirstWeek {
    return _objc_msgSend_29(this.pointer, _sel_minimumDaysInFirstWeek);
  }

  set minimumDaysInFirstWeek(int value) {
    return _objc_msgSend_125(
        this.pointer, _sel_setMinimumDaysInFirstWeek_, value);
  }

  objc.NSArray get eraSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_eraSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get longEraSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_longEraSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get monthSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_monthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get shortMonthSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_shortMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get veryShortMonthSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_veryShortMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get standaloneMonthSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_standaloneMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get shortStandaloneMonthSymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_shortStandaloneMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get veryShortStandaloneMonthSymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_veryShortStandaloneMonthSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get weekdaySymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_weekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get shortWeekdaySymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_shortWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get veryShortWeekdaySymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_veryShortWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get standaloneWeekdaySymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_standaloneWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get shortStandaloneWeekdaySymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_shortStandaloneWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get veryShortStandaloneWeekdaySymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_veryShortStandaloneWeekdaySymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get quarterSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_quarterSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get shortQuarterSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_shortQuarterSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get standaloneQuarterSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_standaloneQuarterSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get shortStandaloneQuarterSymbols {
    final _ret =
        _objc_msgSend_6(this.pointer, _sel_shortStandaloneQuarterSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get AMSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_AMSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get PMSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_PMSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  void minimumRangeOfUnit_(ffi.Pointer<_NSRange> stret, int unit) {
    objc.useMsgSendVariants
        ? _objc_msgSend_126Stret(
            stret, this.pointer, _sel_minimumRangeOfUnit_, unit)
        : stret.ref =
            _objc_msgSend_126(this.pointer, _sel_minimumRangeOfUnit_, unit);
  }

  void maximumRangeOfUnit_(ffi.Pointer<_NSRange> stret, int unit) {
    objc.useMsgSendVariants
        ? _objc_msgSend_126Stret(
            stret, this.pointer, _sel_maximumRangeOfUnit_, unit)
        : stret.ref =
            _objc_msgSend_126(this.pointer, _sel_maximumRangeOfUnit_, unit);
  }

  void rangeOfUnit_inUnit_forDate_(
      ffi.Pointer<_NSRange> stret, int smaller, int larger, objc.NSDate date) {
    objc.useMsgSendVariants
        ? _objc_msgSend_127Stret(stret, this.pointer,
            _sel_rangeOfUnit_inUnit_forDate_, smaller, larger, date.pointer)
        : stret.ref = _objc_msgSend_127(this.pointer,
            _sel_rangeOfUnit_inUnit_forDate_, smaller, larger, date.pointer);
  }

  int ordinalityOfUnit_inUnit_forDate_(
      int smaller, int larger, objc.NSDate date) {
    return _objc_msgSend_128(this.pointer,
        _sel_ordinalityOfUnit_inUnit_forDate_, smaller, larger, date.pointer);
  }

  bool rangeOfUnit_startDate_interval_forDate_(
      int unit,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> datep,
      ffi.Pointer<ffi.Double> tip,
      objc.NSDate date) {
    return _objc_msgSend_129(
        this.pointer,
        _sel_rangeOfUnit_startDate_interval_forDate_,
        unit,
        datep,
        tip,
        date.pointer);
  }

  objc.NSDate? dateFromComponents_(NSDateComponents comps) {
    final _ret = _objc_msgSend_139(
        this.pointer, _sel_dateFromComponents_, comps.pointer);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  NSDateComponents components_fromDate_(int unitFlags, objc.NSDate date) {
    final _ret = _objc_msgSend_140(
        this.pointer, _sel_components_fromDate_, unitFlags, date.pointer);
    return NSDateComponents.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? dateByAddingComponents_toDate_options_(
      NSDateComponents comps, objc.NSDate date, int opts) {
    final _ret = _objc_msgSend_141(
        this.pointer,
        _sel_dateByAddingComponents_toDate_options_,
        comps.pointer,
        date.pointer,
        opts);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  NSDateComponents components_fromDate_toDate_options_(int unitFlags,
      objc.NSDate startingDate, objc.NSDate resultDate, int opts) {
    final _ret = _objc_msgSend_142(
        this.pointer,
        _sel_components_fromDate_toDate_options_,
        unitFlags,
        startingDate.pointer,
        resultDate.pointer,
        opts);
    return NSDateComponents.castFromPointer(_ret, retain: true, release: true);
  }

  void getEra_year_month_day_fromDate_(
      ffi.Pointer<ffi.Long> eraValuePointer,
      ffi.Pointer<ffi.Long> yearValuePointer,
      ffi.Pointer<ffi.Long> monthValuePointer,
      ffi.Pointer<ffi.Long> dayValuePointer,
      objc.NSDate date) {
    _objc_msgSend_143(
        this.pointer,
        _sel_getEra_year_month_day_fromDate_,
        eraValuePointer,
        yearValuePointer,
        monthValuePointer,
        dayValuePointer,
        date.pointer);
  }

  void getEra_yearForWeekOfYear_weekOfYear_weekday_fromDate_(
      ffi.Pointer<ffi.Long> eraValuePointer,
      ffi.Pointer<ffi.Long> yearValuePointer,
      ffi.Pointer<ffi.Long> weekValuePointer,
      ffi.Pointer<ffi.Long> weekdayValuePointer,
      objc.NSDate date) {
    _objc_msgSend_143(
        this.pointer,
        _sel_getEra_yearForWeekOfYear_weekOfYear_weekday_fromDate_,
        eraValuePointer,
        yearValuePointer,
        weekValuePointer,
        weekdayValuePointer,
        date.pointer);
  }

  void getHour_minute_second_nanosecond_fromDate_(
      ffi.Pointer<ffi.Long> hourValuePointer,
      ffi.Pointer<ffi.Long> minuteValuePointer,
      ffi.Pointer<ffi.Long> secondValuePointer,
      ffi.Pointer<ffi.Long> nanosecondValuePointer,
      objc.NSDate date) {
    _objc_msgSend_143(
        this.pointer,
        _sel_getHour_minute_second_nanosecond_fromDate_,
        hourValuePointer,
        minuteValuePointer,
        secondValuePointer,
        nanosecondValuePointer,
        date.pointer);
  }

  int component_fromDate_(int unit, objc.NSDate date) {
    return _objc_msgSend_144(
        this.pointer, _sel_component_fromDate_, unit, date.pointer);
  }

  objc.NSDate? dateWithEra_year_month_day_hour_minute_second_nanosecond_(
      int eraValue,
      int yearValue,
      int monthValue,
      int dayValue,
      int hourValue,
      int minuteValue,
      int secondValue,
      int nanosecondValue) {
    final _ret = _objc_msgSend_145(
        this.pointer,
        _sel_dateWithEra_year_month_day_hour_minute_second_nanosecond_,
        eraValue,
        yearValue,
        monthValue,
        dayValue,
        hourValue,
        minuteValue,
        secondValue,
        nanosecondValue);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate?
      dateWithEra_yearForWeekOfYear_weekOfYear_weekday_hour_minute_second_nanosecond_(
          int eraValue,
          int yearValue,
          int weekValue,
          int weekdayValue,
          int hourValue,
          int minuteValue,
          int secondValue,
          int nanosecondValue) {
    final _ret = _objc_msgSend_145(
        this.pointer,
        _sel_dateWithEra_yearForWeekOfYear_weekOfYear_weekday_hour_minute_second_nanosecond_,
        eraValue,
        yearValue,
        weekValue,
        weekdayValue,
        hourValue,
        minuteValue,
        secondValue,
        nanosecondValue);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate startOfDayForDate_(objc.NSDate date) {
    final _ret =
        _objc_msgSend_146(this.pointer, _sel_startOfDayForDate_, date.pointer);
    return objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  NSDateComponents componentsInTimeZone_fromDate_(
      NSTimeZone timezone, objc.NSDate date) {
    final _ret = _objc_msgSend_147(this.pointer,
        _sel_componentsInTimeZone_fromDate_, timezone.pointer, date.pointer);
    return NSDateComponents.castFromPointer(_ret, retain: true, release: true);
  }

  int compareDate_toDate_toUnitGranularity_(
      objc.NSDate date1, objc.NSDate date2, int unit) {
    return _objc_msgSend_148(
        this.pointer,
        _sel_compareDate_toDate_toUnitGranularity_,
        date1.pointer,
        date2.pointer,
        unit);
  }

  bool isDate_equalToDate_toUnitGranularity_(
      objc.NSDate date1, objc.NSDate date2, int unit) {
    return _objc_msgSend_149(
        this.pointer,
        _sel_isDate_equalToDate_toUnitGranularity_,
        date1.pointer,
        date2.pointer,
        unit);
  }

  bool isDate_inSameDayAsDate_(objc.NSDate date1, objc.NSDate date2) {
    return _objc_msgSend_150(this.pointer, _sel_isDate_inSameDayAsDate_,
        date1.pointer, date2.pointer);
  }

  bool isDateInToday_(objc.NSDate date) {
    return _objc_msgSend_107(this.pointer, _sel_isDateInToday_, date.pointer);
  }

  bool isDateInYesterday_(objc.NSDate date) {
    return _objc_msgSend_107(
        this.pointer, _sel_isDateInYesterday_, date.pointer);
  }

  bool isDateInTomorrow_(objc.NSDate date) {
    return _objc_msgSend_107(
        this.pointer, _sel_isDateInTomorrow_, date.pointer);
  }

  bool isDateInWeekend_(objc.NSDate date) {
    return _objc_msgSend_107(this.pointer, _sel_isDateInWeekend_, date.pointer);
  }

  bool rangeOfWeekendStartDate_interval_containingDate_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> datep,
      ffi.Pointer<ffi.Double> tip,
      objc.NSDate date) {
    return _objc_msgSend_151(
        this.pointer,
        _sel_rangeOfWeekendStartDate_interval_containingDate_,
        datep,
        tip,
        date.pointer);
  }

  bool nextWeekendStartDate_interval_options_afterDate_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> datep,
      ffi.Pointer<ffi.Double> tip,
      int options,
      objc.NSDate date) {
    return _objc_msgSend_152(
        this.pointer,
        _sel_nextWeekendStartDate_interval_options_afterDate_,
        datep,
        tip,
        options,
        date.pointer);
  }

  NSDateComponents components_fromDateComponents_toDateComponents_options_(
      int unitFlags,
      NSDateComponents startingDateComp,
      NSDateComponents resultDateComp,
      int options) {
    final _ret = _objc_msgSend_153(
        this.pointer,
        _sel_components_fromDateComponents_toDateComponents_options_,
        unitFlags,
        startingDateComp.pointer,
        resultDateComp.pointer,
        options);
    return NSDateComponents.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? dateByAddingUnit_value_toDate_options_(
      int unit, int value, objc.NSDate date, int options) {
    final _ret = _objc_msgSend_154(
        this.pointer,
        _sel_dateByAddingUnit_value_toDate_options_,
        unit,
        value,
        date.pointer,
        options);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  void enumerateDatesStartingAfterDate_matchingComponents_options_usingBlock_(
      objc.NSDate start,
      NSDateComponents comps,
      int opts,
      ObjCBlock_ffiVoid_NSDate_bool_bool block) {
    _objc_msgSend_155(
        this.pointer,
        _sel_enumerateDatesStartingAfterDate_matchingComponents_options_usingBlock_,
        start.pointer,
        comps.pointer,
        opts,
        block.pointer);
  }

  objc.NSDate? nextDateAfterDate_matchingComponents_options_(
      objc.NSDate date, NSDateComponents comps, int options) {
    final _ret = _objc_msgSend_156(
        this.pointer,
        _sel_nextDateAfterDate_matchingComponents_options_,
        date.pointer,
        comps.pointer,
        options);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? nextDateAfterDate_matchingUnit_value_options_(
      objc.NSDate date, int unit, int value, int options) {
    final _ret = _objc_msgSend_157(
        this.pointer,
        _sel_nextDateAfterDate_matchingUnit_value_options_,
        date.pointer,
        unit,
        value,
        options);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? nextDateAfterDate_matchingHour_minute_second_options_(
      objc.NSDate date,
      int hourValue,
      int minuteValue,
      int secondValue,
      int options) {
    final _ret = _objc_msgSend_158(
        this.pointer,
        _sel_nextDateAfterDate_matchingHour_minute_second_options_,
        date.pointer,
        hourValue,
        minuteValue,
        secondValue,
        options);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? dateBySettingUnit_value_ofDate_options_(
      int unit, int v, objc.NSDate date, int opts) {
    final _ret = _objc_msgSend_154(
        this.pointer,
        _sel_dateBySettingUnit_value_ofDate_options_,
        unit,
        v,
        date.pointer,
        opts);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? dateBySettingHour_minute_second_ofDate_options_(
      int h, int m, int s, objc.NSDate date, int opts) {
    final _ret = _objc_msgSend_159(
        this.pointer,
        _sel_dateBySettingHour_minute_second_ofDate_options_,
        h,
        m,
        s,
        date.pointer,
        opts);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  bool date_matchesComponents_(objc.NSDate date, NSDateComponents components) {
    return _objc_msgSend_160(this.pointer, _sel_date_matchesComponents_,
        date.pointer, components.pointer);
  }

  static NSCalendar new1() {
    final _ret = _objc_msgSend_40(_class_NSCalendar, _sel_new);
    return NSCalendar.castFromPointer(_ret, retain: false, release: true);
  }

  static NSCalendar allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSCalendar, _sel_allocWithZone_, zone);
    return NSCalendar.castFromPointer(_ret, retain: false, release: true);
  }

  static NSCalendar alloc() {
    final _ret = _objc_msgSend_40(_class_NSCalendar, _sel_alloc);
    return NSCalendar.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSCalendar,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSCalendar,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSCalendar, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSCalendar, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSCalendar,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSCalendar,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSCalendar,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSCalendar, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSCalendar, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSCalendar = objc.getClass("NSCalendar");
late final _sel_currentCalendar = objc.registerName("currentCalendar");
final _objc_msgSend_121 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_autoupdatingCurrentCalendar =
    objc.registerName("autoupdatingCurrentCalendar");
late final _sel_calendarWithIdentifier_ =
    objc.registerName("calendarWithIdentifier:");
final _objc_msgSend_122 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithCalendarIdentifier_ =
    objc.registerName("initWithCalendarIdentifier:");
late final _sel_calendarIdentifier = objc.registerName("calendarIdentifier");
final _objc_msgSend_123 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_124 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_firstWeekday = objc.registerName("firstWeekday");
late final _sel_setFirstWeekday_ = objc.registerName("setFirstWeekday:");
final _objc_msgSend_125 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_minimumDaysInFirstWeek =
    objc.registerName("minimumDaysInFirstWeek");
late final _sel_setMinimumDaysInFirstWeek_ =
    objc.registerName("setMinimumDaysInFirstWeek:");
late final _sel_eraSymbols = objc.registerName("eraSymbols");
late final _sel_longEraSymbols = objc.registerName("longEraSymbols");
late final _sel_monthSymbols = objc.registerName("monthSymbols");
late final _sel_shortMonthSymbols = objc.registerName("shortMonthSymbols");
late final _sel_veryShortMonthSymbols =
    objc.registerName("veryShortMonthSymbols");
late final _sel_standaloneMonthSymbols =
    objc.registerName("standaloneMonthSymbols");
late final _sel_shortStandaloneMonthSymbols =
    objc.registerName("shortStandaloneMonthSymbols");
late final _sel_veryShortStandaloneMonthSymbols =
    objc.registerName("veryShortStandaloneMonthSymbols");
late final _sel_weekdaySymbols = objc.registerName("weekdaySymbols");
late final _sel_shortWeekdaySymbols = objc.registerName("shortWeekdaySymbols");
late final _sel_veryShortWeekdaySymbols =
    objc.registerName("veryShortWeekdaySymbols");
late final _sel_standaloneWeekdaySymbols =
    objc.registerName("standaloneWeekdaySymbols");
late final _sel_shortStandaloneWeekdaySymbols =
    objc.registerName("shortStandaloneWeekdaySymbols");
late final _sel_veryShortStandaloneWeekdaySymbols =
    objc.registerName("veryShortStandaloneWeekdaySymbols");
late final _sel_quarterSymbols = objc.registerName("quarterSymbols");
late final _sel_shortQuarterSymbols = objc.registerName("shortQuarterSymbols");
late final _sel_standaloneQuarterSymbols =
    objc.registerName("standaloneQuarterSymbols");
late final _sel_shortStandaloneQuarterSymbols =
    objc.registerName("shortStandaloneQuarterSymbols");
late final _sel_AMSymbol = objc.registerName("AMSymbol");
late final _sel_PMSymbol = objc.registerName("PMSymbol");

abstract class NSCalendarUnit {
  static const int NSCalendarUnitEra = 2;
  static const int NSCalendarUnitYear = 4;
  static const int NSCalendarUnitMonth = 8;
  static const int NSCalendarUnitDay = 16;
  static const int NSCalendarUnitHour = 32;
  static const int NSCalendarUnitMinute = 64;
  static const int NSCalendarUnitSecond = 128;
  static const int NSCalendarUnitWeekday = 512;
  static const int NSCalendarUnitWeekdayOrdinal = 1024;
  static const int NSCalendarUnitQuarter = 2048;
  static const int NSCalendarUnitWeekOfMonth = 4096;
  static const int NSCalendarUnitWeekOfYear = 8192;
  static const int NSCalendarUnitYearForWeekOfYear = 16384;
  static const int NSCalendarUnitNanosecond = 32768;
  static const int NSCalendarUnitCalendar = 1048576;
  static const int NSCalendarUnitTimeZone = 2097152;
  static const int NSEraCalendarUnit = 2;
  static const int NSYearCalendarUnit = 4;
  static const int NSMonthCalendarUnit = 8;
  static const int NSDayCalendarUnit = 16;
  static const int NSHourCalendarUnit = 32;
  static const int NSMinuteCalendarUnit = 64;
  static const int NSSecondCalendarUnit = 128;
  static const int NSWeekCalendarUnit = 256;
  static const int NSWeekdayCalendarUnit = 512;
  static const int NSWeekdayOrdinalCalendarUnit = 1024;
  static const int NSQuarterCalendarUnit = 2048;
  static const int NSWeekOfMonthCalendarUnit = 4096;
  static const int NSWeekOfYearCalendarUnit = 8192;
  static const int NSYearForWeekOfYearCalendarUnit = 16384;
  static const int NSCalendarCalendarUnit = 1048576;
  static const int NSTimeZoneCalendarUnit = 2097152;
}

late final _sel_minimumRangeOfUnit_ = objc.registerName("minimumRangeOfUnit:");
final _objc_msgSend_126 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            _NSRange Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        _NSRange Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_126Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<_NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<_NSRange>, ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_maximumRangeOfUnit_ = objc.registerName("maximumRangeOfUnit:");
late final _sel_rangeOfUnit_inUnit_forDate_ =
    objc.registerName("rangeOfUnit:inUnit:forDate:");
final _objc_msgSend_127 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            _NSRange Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        _NSRange Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_127Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<_NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<_NSRange>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_ordinalityOfUnit_inUnit_forDate_ =
    objc.registerName("ordinalityOfUnit:inUnit:forDate:");
final _objc_msgSend_128 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_rangeOfUnit_startDate_interval_forDate_ =
    objc.registerName("rangeOfUnit:startDate:interval:forDate:");
final _objc_msgSend_129 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Double>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Double>,
            ffi.Pointer<objc.ObjCObject>)>();

class NSDateComponents extends objc.NSObject {
  NSDateComponents._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSDateComponents] that points to the same underlying object as [other].
  NSDateComponents.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSDateComponents] that wraps the given raw object pointer.
  NSDateComponents.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSDateComponents].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSDateComponents);
  }

  NSCalendar? get calendar {
    final _ret = _objc_msgSend_130(this.pointer, _sel_calendar);
    return _ret.address == 0
        ? null
        : NSCalendar.castFromPointer(_ret, retain: true, release: true);
  }

  set calendar(NSCalendar? value) {
    return _objc_msgSend_131(
        this.pointer, _sel_setCalendar_, value?.pointer ?? ffi.nullptr);
  }

  NSTimeZone? get timeZone {
    final _ret = _objc_msgSend_132(this.pointer, _sel_timeZone);
    return _ret.address == 0
        ? null
        : NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  set timeZone(NSTimeZone? value) {
    return _objc_msgSend_133(
        this.pointer, _sel_setTimeZone_, value?.pointer ?? ffi.nullptr);
  }

  int get era {
    return _objc_msgSend_114(this.pointer, _sel_era);
  }

  set era(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setEra_, value);
  }

  int get year {
    return _objc_msgSend_114(this.pointer, _sel_year);
  }

  set year(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setYear_, value);
  }

  int get month {
    return _objc_msgSend_114(this.pointer, _sel_month);
  }

  set month(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setMonth_, value);
  }

  int get day {
    return _objc_msgSend_114(this.pointer, _sel_day);
  }

  set day(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setDay_, value);
  }

  int get hour {
    return _objc_msgSend_114(this.pointer, _sel_hour);
  }

  set hour(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setHour_, value);
  }

  int get minute {
    return _objc_msgSend_114(this.pointer, _sel_minute);
  }

  set minute(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setMinute_, value);
  }

  int get second {
    return _objc_msgSend_114(this.pointer, _sel_second);
  }

  set second(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setSecond_, value);
  }

  int get nanosecond {
    return _objc_msgSend_114(this.pointer, _sel_nanosecond);
  }

  set nanosecond(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setNanosecond_, value);
  }

  int get weekday {
    return _objc_msgSend_114(this.pointer, _sel_weekday);
  }

  set weekday(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setWeekday_, value);
  }

  int get weekdayOrdinal {
    return _objc_msgSend_114(this.pointer, _sel_weekdayOrdinal);
  }

  set weekdayOrdinal(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setWeekdayOrdinal_, value);
  }

  int get quarter {
    return _objc_msgSend_114(this.pointer, _sel_quarter);
  }

  set quarter(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setQuarter_, value);
  }

  int get weekOfMonth {
    return _objc_msgSend_114(this.pointer, _sel_weekOfMonth);
  }

  set weekOfMonth(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setWeekOfMonth_, value);
  }

  int get weekOfYear {
    return _objc_msgSend_114(this.pointer, _sel_weekOfYear);
  }

  set weekOfYear(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setWeekOfYear_, value);
  }

  int get yearForWeekOfYear {
    return _objc_msgSend_114(this.pointer, _sel_yearForWeekOfYear);
  }

  set yearForWeekOfYear(int value) {
    return _objc_msgSend_134(this.pointer, _sel_setYearForWeekOfYear_, value);
  }

  bool get leapMonth {
    return _objc_msgSend_7(this.pointer, _sel_isLeapMonth);
  }

  set leapMonth(bool value) {
    return _objc_msgSend_41(this.pointer, _sel_setLeapMonth_, value);
  }

  objc.NSDate? get date {
    final _ret = _objc_msgSend_116(this.pointer, _sel_date);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  int week() {
    return _objc_msgSend_114(this.pointer, _sel_week);
  }

  void setWeek_(int v) {
    _objc_msgSend_135(this.pointer, _sel_setWeek_, v);
  }

  void setValue_forComponent_(int value, int unit) {
    _objc_msgSend_136(this.pointer, _sel_setValue_forComponent_, value, unit);
  }

  int valueForComponent_(int unit) {
    return _objc_msgSend_137(this.pointer, _sel_valueForComponent_, unit);
  }

  bool get validDate {
    return _objc_msgSend_7(this.pointer, _sel_isValidDate);
  }

  bool isValidDateInCalendar_(NSCalendar calendar) {
    return _objc_msgSend_138(
        this.pointer, _sel_isValidDateInCalendar_, calendar.pointer);
  }

  @override
  NSDateComponents init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSDateComponents.castFromPointer(_ret, retain: true, release: true);
  }

  static NSDateComponents new1() {
    final _ret = _objc_msgSend_40(_class_NSDateComponents, _sel_new);
    return NSDateComponents.castFromPointer(_ret, retain: false, release: true);
  }

  static NSDateComponents allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSDateComponents, _sel_allocWithZone_, zone);
    return NSDateComponents.castFromPointer(_ret, retain: false, release: true);
  }

  static NSDateComponents alloc() {
    final _ret = _objc_msgSend_40(_class_NSDateComponents, _sel_alloc);
    return NSDateComponents.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSDateComponents,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSDateComponents,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSDateComponents, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSDateComponents, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSDateComponents,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSDateComponents,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSDateComponents,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSDateComponents, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSDateComponents, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSDateComponents = objc.getClass("NSDateComponents");
late final _sel_calendar = objc.registerName("calendar");
final _objc_msgSend_130 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setCalendar_ = objc.registerName("setCalendar:");
final _objc_msgSend_131 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_132 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_133 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_era = objc.registerName("era");
late final _sel_setEra_ = objc.registerName("setEra:");
final _objc_msgSend_134 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Long)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_year = objc.registerName("year");
late final _sel_setYear_ = objc.registerName("setYear:");
late final _sel_month = objc.registerName("month");
late final _sel_setMonth_ = objc.registerName("setMonth:");
late final _sel_day = objc.registerName("day");
late final _sel_setDay_ = objc.registerName("setDay:");
late final _sel_hour = objc.registerName("hour");
late final _sel_setHour_ = objc.registerName("setHour:");
late final _sel_minute = objc.registerName("minute");
late final _sel_setMinute_ = objc.registerName("setMinute:");
late final _sel_second = objc.registerName("second");
late final _sel_setSecond_ = objc.registerName("setSecond:");
late final _sel_nanosecond = objc.registerName("nanosecond");
late final _sel_setNanosecond_ = objc.registerName("setNanosecond:");
late final _sel_weekday = objc.registerName("weekday");
late final _sel_setWeekday_ = objc.registerName("setWeekday:");
late final _sel_weekdayOrdinal = objc.registerName("weekdayOrdinal");
late final _sel_setWeekdayOrdinal_ = objc.registerName("setWeekdayOrdinal:");
late final _sel_quarter = objc.registerName("quarter");
late final _sel_setQuarter_ = objc.registerName("setQuarter:");
late final _sel_weekOfMonth = objc.registerName("weekOfMonth");
late final _sel_setWeekOfMonth_ = objc.registerName("setWeekOfMonth:");
late final _sel_weekOfYear = objc.registerName("weekOfYear");
late final _sel_setWeekOfYear_ = objc.registerName("setWeekOfYear:");
late final _sel_yearForWeekOfYear = objc.registerName("yearForWeekOfYear");
late final _sel_setYearForWeekOfYear_ =
    objc.registerName("setYearForWeekOfYear:");
late final _sel_isLeapMonth = objc.registerName("isLeapMonth");
late final _sel_setLeapMonth_ = objc.registerName("setLeapMonth:");
late final _sel_date = objc.registerName("date");
late final _sel_week = objc.registerName("week");
late final _sel_setWeek_ = objc.registerName("setWeek:");
final _objc_msgSend_135 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Long)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_setValue_forComponent_ =
    objc.registerName("setValue:forComponent:");
final _objc_msgSend_136 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Long, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, int)>();
late final _sel_valueForComponent_ = objc.registerName("valueForComponent:");
final _objc_msgSend_137 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_isValidDate = objc.registerName("isValidDate");
late final _sel_isValidDateInCalendar_ =
    objc.registerName("isValidDateInCalendar:");
final _objc_msgSend_138 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_dateFromComponents_ = objc.registerName("dateFromComponents:");
final _objc_msgSend_139 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_components_fromDate_ =
    objc.registerName("components:fromDate:");
final _objc_msgSend_140 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();

abstract class NSCalendarOptions {
  static const int NSCalendarWrapComponents = 1;
  static const int NSCalendarMatchStrictly = 2;
  static const int NSCalendarSearchBackwards = 4;
  static const int NSCalendarMatchPreviousTimePreservingSmallerUnits = 256;
  static const int NSCalendarMatchNextTimePreservingSmallerUnits = 512;
  static const int NSCalendarMatchNextTime = 1024;
  static const int NSCalendarMatchFirst = 4096;
  static const int NSCalendarMatchLast = 8192;
}

late final _sel_dateByAddingComponents_toDate_options_ =
    objc.registerName("dateByAddingComponents:toDate:options:");
final _objc_msgSend_141 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_components_fromDate_toDate_options_ =
    objc.registerName("components:fromDate:toDate:options:");
final _objc_msgSend_142 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_getEra_year_month_day_fromDate_ =
    objc.registerName("getEra:year:month:day:fromDate:");
final _objc_msgSend_143 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Long>,
                ffi.Pointer<ffi.Long>,
                ffi.Pointer<ffi.Long>,
                ffi.Pointer<ffi.Long>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Long>,
            ffi.Pointer<ffi.Long>,
            ffi.Pointer<ffi.Long>,
            ffi.Pointer<ffi.Long>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_getEra_yearForWeekOfYear_weekOfYear_weekday_fromDate_ =
    objc.registerName("getEra:yearForWeekOfYear:weekOfYear:weekday:fromDate:");
late final _sel_getHour_minute_second_nanosecond_fromDate_ =
    objc.registerName("getHour:minute:second:nanosecond:fromDate:");
late final _sel_component_fromDate_ = objc.registerName("component:fromDate:");
final _objc_msgSend_144 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_dateWithEra_year_month_day_hour_minute_second_nanosecond_ = objc
    .registerName("dateWithEra:year:month:day:hour:minute:second:nanosecond:");
final _objc_msgSend_145 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Long,
                ffi.Long,
                ffi.Long,
                ffi.Long,
                ffi.Long,
                ffi.Long,
                ffi.Long,
                ffi.Long)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            int,
            int,
            int,
            int,
            int,
            int)>();
late final _sel_dateWithEra_yearForWeekOfYear_weekOfYear_weekday_hour_minute_second_nanosecond_ =
    objc.registerName(
        "dateWithEra:yearForWeekOfYear:weekOfYear:weekday:hour:minute:second:nanosecond:");
late final _sel_startOfDayForDate_ = objc.registerName("startOfDayForDate:");
final _objc_msgSend_146 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_componentsInTimeZone_fromDate_ =
    objc.registerName("componentsInTimeZone:fromDate:");
final _objc_msgSend_147 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

abstract class NSComparisonResult {
  static const int NSOrderedAscending = -1;
  static const int NSOrderedSame = 0;
  static const int NSOrderedDescending = 1;
}

late final _sel_compareDate_toDate_toUnitGranularity_ =
    objc.registerName("compareDate:toDate:toUnitGranularity:");
final _objc_msgSend_148 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_isDate_equalToDate_toUnitGranularity_ =
    objc.registerName("isDate:equalToDate:toUnitGranularity:");
final _objc_msgSend_149 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_isDate_inSameDayAsDate_ =
    objc.registerName("isDate:inSameDayAsDate:");
final _objc_msgSend_150 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_isDateInToday_ = objc.registerName("isDateInToday:");
late final _sel_isDateInYesterday_ = objc.registerName("isDateInYesterday:");
late final _sel_isDateInTomorrow_ = objc.registerName("isDateInTomorrow:");
late final _sel_isDateInWeekend_ = objc.registerName("isDateInWeekend:");
late final _sel_rangeOfWeekendStartDate_interval_containingDate_ =
    objc.registerName("rangeOfWeekendStartDate:interval:containingDate:");
final _objc_msgSend_151 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Double>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Double>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_nextWeekendStartDate_interval_options_afterDate_ =
    objc.registerName("nextWeekendStartDate:interval:options:afterDate:");
final _objc_msgSend_152 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Double>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Double>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_components_fromDateComponents_toDateComponents_options_ = objc
    .registerName("components:fromDateComponents:toDateComponents:options:");
final _objc_msgSend_153 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_dateByAddingUnit_value_toDate_options_ =
    objc.registerName("dateByAddingUnit:value:toDate:options:");
final _objc_msgSend_154 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Long,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
void _ObjCBlock_ffiVoid_NSDate_bool_bool_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        bool arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.Bool arg1, ffi.Pointer<ffi.Bool> arg2)>>()
        .asFunction<
            void Function(ffi.Pointer<objc.ObjCObject>, bool,
                ffi.Pointer<ffi.Bool>)>()(arg0, arg1, arg2);
final _ObjCBlock_ffiVoid_NSDate_bool_bool_closureRegistry = <int,
    void Function(ffi.Pointer<objc.ObjCObject>, bool, ffi.Pointer<ffi.Bool>)>{};
int _ObjCBlock_ffiVoid_NSDate_bool_bool_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_NSDate_bool_bool_registerClosure(
    void Function(ffi.Pointer<objc.ObjCObject>, bool, ffi.Pointer<ffi.Bool>)
        fn) {
  final id = ++_ObjCBlock_ffiVoid_NSDate_bool_bool_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSDate_bool_bool_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSDate_bool_bool_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        bool arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    _ObjCBlock_ffiVoid_NSDate_bool_bool_closureRegistry[
        block.ref.target.address]!(arg0, arg1, arg2);

class ObjCBlock_ffiVoid_NSDate_bool_bool extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSDate_bool_bool._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSDate_bool_bool castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSDate_bool_bool._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSDate_bool_bool.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Bool arg1, ffi.Pointer<ffi.Bool> arg2)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Bool,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_NSDate_bool_bool_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSDate_bool_bool.fromFunction(
      void Function(objc.NSDate?, bool, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Bool,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_NSDate_bool_bool_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_NSDate_bool_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, bool arg1,
                        ffi.Pointer<ffi.Bool> arg2) =>
                    fn(arg0.address == 0 ? null : objc.NSDate.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSDate_bool_bool.listener(
      void Function(objc.NSDate?, bool, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Bool,
                            ffi.Pointer<ffi.Bool>)>.listener(
                    _ObjCBlock_ffiVoid_NSDate_bool_bool_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSDate_bool_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, bool arg1, ffi.Pointer<ffi.Bool> arg2) =>
                    fn(arg0.address == 0 ? null : objc.NSDate.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.NativeCallable<
      ffi.Void Function(
          ffi.Pointer<objc.ObjCBlock>,
          ffi.Pointer<objc.ObjCObject>,
          ffi.Bool,
          ffi.Pointer<ffi.Bool>)>? _dartFuncListenerTrampoline;

  void call(objc.NSDate? arg0, bool arg1, ffi.Pointer<ffi.Bool> arg2) =>
      pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<objc.ObjCBlock> block,
                          ffi.Pointer<objc.ObjCObject> arg0,
                          ffi.Bool arg1,
                          ffi.Pointer<ffi.Bool> arg2)>>()
              .asFunction<
                  void Function(
                      ffi.Pointer<objc.ObjCBlock>,
                      ffi.Pointer<objc.ObjCObject>,
                      bool,
                      ffi.Pointer<ffi.Bool>)>()(
          pointer, arg0?.pointer ?? ffi.nullptr, arg1, arg2);
}

late final _sel_enumerateDatesStartingAfterDate_matchingComponents_options_usingBlock_ =
    objc.registerName(
        "enumerateDatesStartingAfterDate:matchingComponents:options:usingBlock:");
final _objc_msgSend_155 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_nextDateAfterDate_matchingComponents_options_ =
    objc.registerName("nextDateAfterDate:matchingComponents:options:");
final _objc_msgSend_156 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_nextDateAfterDate_matchingUnit_value_options_ =
    objc.registerName("nextDateAfterDate:matchingUnit:value:options:");
final _objc_msgSend_157 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Long,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            int,
            int)>();
late final _sel_nextDateAfterDate_matchingHour_minute_second_options_ =
    objc.registerName("nextDateAfterDate:matchingHour:minute:second:options:");
final _objc_msgSend_158 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long,
                ffi.Long,
                ffi.Long,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            int,
            int,
            int)>();
late final _sel_dateBySettingUnit_value_ofDate_options_ =
    objc.registerName("dateBySettingUnit:value:ofDate:options:");
late final _sel_dateBySettingHour_minute_second_ofDate_options_ =
    objc.registerName("dateBySettingHour:minute:second:ofDate:options:");
final _objc_msgSend_159 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Long,
                ffi.Long,
                ffi.Long,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_date_matchesComponents_ =
    objc.registerName("date:matchesComponents:");
final _objc_msgSend_160 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_161 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_isLenient = objc.registerName("isLenient");
late final _sel_setLenient_ = objc.registerName("setLenient:");
late final _sel_twoDigitStartDate = objc.registerName("twoDigitStartDate");
late final _sel_setTwoDigitStartDate_ =
    objc.registerName("setTwoDigitStartDate:");
final _objc_msgSend_162 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_defaultDate = objc.registerName("defaultDate");
late final _sel_setDefaultDate_ = objc.registerName("setDefaultDate:");
late final _sel_setEraSymbols_ = objc.registerName("setEraSymbols:");
final _objc_msgSend_163 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_setMonthSymbols_ = objc.registerName("setMonthSymbols:");
late final _sel_setShortMonthSymbols_ =
    objc.registerName("setShortMonthSymbols:");
late final _sel_setWeekdaySymbols_ = objc.registerName("setWeekdaySymbols:");
late final _sel_setShortWeekdaySymbols_ =
    objc.registerName("setShortWeekdaySymbols:");
late final _sel_setAMSymbol_ = objc.registerName("setAMSymbol:");
late final _sel_setPMSymbol_ = objc.registerName("setPMSymbol:");
late final _sel_setLongEraSymbols_ = objc.registerName("setLongEraSymbols:");
late final _sel_setVeryShortMonthSymbols_ =
    objc.registerName("setVeryShortMonthSymbols:");
late final _sel_setStandaloneMonthSymbols_ =
    objc.registerName("setStandaloneMonthSymbols:");
late final _sel_setShortStandaloneMonthSymbols_ =
    objc.registerName("setShortStandaloneMonthSymbols:");
late final _sel_setVeryShortStandaloneMonthSymbols_ =
    objc.registerName("setVeryShortStandaloneMonthSymbols:");
late final _sel_setVeryShortWeekdaySymbols_ =
    objc.registerName("setVeryShortWeekdaySymbols:");
late final _sel_setStandaloneWeekdaySymbols_ =
    objc.registerName("setStandaloneWeekdaySymbols:");
late final _sel_setShortStandaloneWeekdaySymbols_ =
    objc.registerName("setShortStandaloneWeekdaySymbols:");
late final _sel_setVeryShortStandaloneWeekdaySymbols_ =
    objc.registerName("setVeryShortStandaloneWeekdaySymbols:");
late final _sel_setQuarterSymbols_ = objc.registerName("setQuarterSymbols:");
late final _sel_setShortQuarterSymbols_ =
    objc.registerName("setShortQuarterSymbols:");
late final _sel_setStandaloneQuarterSymbols_ =
    objc.registerName("setStandaloneQuarterSymbols:");
late final _sel_setShortStandaloneQuarterSymbols_ =
    objc.registerName("setShortStandaloneQuarterSymbols:");
late final _sel_gregorianStartDate = objc.registerName("gregorianStartDate");
late final _sel_setGregorianStartDate_ =
    objc.registerName("setGregorianStartDate:");
late final _sel_doesRelativeDateFormatting =
    objc.registerName("doesRelativeDateFormatting");
late final _sel_setDoesRelativeDateFormatting_ =
    objc.registerName("setDoesRelativeDateFormatting:");
late final _sel_initWithDateFormat_allowNaturalLanguage_ =
    objc.registerName("initWithDateFormat:allowNaturalLanguage:");
final _objc_msgSend_164 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_allowsNaturalLanguage =
    objc.registerName("allowsNaturalLanguage");

class NSNumberFormatter extends NSFormatter {
  NSNumberFormatter._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSNumberFormatter] that points to the same underlying object as [other].
  NSNumberFormatter.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSNumberFormatter] that wraps the given raw object pointer.
  NSNumberFormatter.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSNumberFormatter].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSNumberFormatter);
  }

  int get formattingContext {
    return _objc_msgSend_89(this.pointer, _sel_formattingContext);
  }

  set formattingContext(int value) {
    return _objc_msgSend_90(this.pointer, _sel_setFormattingContext_, value);
  }

  bool getObjectValue_forString_range_error_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> obj,
      objc.NSString string,
      ffi.Pointer<_NSRange> rangep,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_91(
        this.pointer,
        _sel_getObjectValue_forString_range_error_,
        obj,
        string.pointer,
        rangep,
        error);
  }

  objc.NSString? stringFromNumber_(objc.NSNumber number) {
    final _ret =
        _objc_msgSend_165(this.pointer, _sel_stringFromNumber_, number.pointer);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSNumber? numberFromString_(objc.NSString string) {
    final _ret =
        _objc_msgSend_166(this.pointer, _sel_numberFromString_, string.pointer);
    return _ret.address == 0
        ? null
        : objc.NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSString localizedStringFromNumber_numberStyle_(
      objc.NSNumber num, int nstyle) {
    final _ret = _objc_msgSend_167(_class_NSNumberFormatter,
        _sel_localizedStringFromNumber_numberStyle_, num.pointer, nstyle);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static int defaultFormatterBehavior() {
    return _objc_msgSend_168(
        _class_NSNumberFormatter, _sel_defaultFormatterBehavior);
  }

  static void setDefaultFormatterBehavior_(int behavior) {
    _objc_msgSend_169(
        _class_NSNumberFormatter, _sel_setDefaultFormatterBehavior_, behavior);
  }

  int get numberStyle {
    return _objc_msgSend_170(this.pointer, _sel_numberStyle);
  }

  set numberStyle(int value) {
    return _objc_msgSend_171(this.pointer, _sel_setNumberStyle_, value);
  }

  objc.NSLocale get locale {
    final _ret = _objc_msgSend_102(this.pointer, _sel_locale);
    return objc.NSLocale.castFromPointer(_ret, retain: true, release: true);
  }

  set locale(objc.NSLocale value) {
    return _objc_msgSend_103(this.pointer, _sel_setLocale_, value.pointer);
  }

  bool get generatesDecimalNumbers {
    return _objc_msgSend_7(this.pointer, _sel_generatesDecimalNumbers);
  }

  set generatesDecimalNumbers(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setGeneratesDecimalNumbers_, value);
  }

  int get formatterBehavior {
    return _objc_msgSend_168(this.pointer, _sel_formatterBehavior);
  }

  set formatterBehavior(int value) {
    return _objc_msgSend_172(this.pointer, _sel_setFormatterBehavior_, value);
  }

  objc.NSString get negativeFormat {
    final _ret = _objc_msgSend_12(this.pointer, _sel_negativeFormat);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set negativeFormat(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setNegativeFormat_, value.pointer);
  }

  objc.NSDictionary? get textAttributesForNegativeValues {
    final _ret =
        _objc_msgSend_65(this.pointer, _sel_textAttributesForNegativeValues);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  set textAttributesForNegativeValues(objc.NSDictionary? value) {
    return _objc_msgSend_173(
        this.pointer,
        _sel_setTextAttributesForNegativeValues_,
        value?.pointer ?? ffi.nullptr);
  }

  objc.NSString get positiveFormat {
    final _ret = _objc_msgSend_12(this.pointer, _sel_positiveFormat);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set positiveFormat(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setPositiveFormat_, value.pointer);
  }

  objc.NSDictionary? get textAttributesForPositiveValues {
    final _ret =
        _objc_msgSend_65(this.pointer, _sel_textAttributesForPositiveValues);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  set textAttributesForPositiveValues(objc.NSDictionary? value) {
    return _objc_msgSend_173(
        this.pointer,
        _sel_setTextAttributesForPositiveValues_,
        value?.pointer ?? ffi.nullptr);
  }

  bool get allowsFloats {
    return _objc_msgSend_7(this.pointer, _sel_allowsFloats);
  }

  set allowsFloats(bool value) {
    return _objc_msgSend_41(this.pointer, _sel_setAllowsFloats_, value);
  }

  objc.NSString get decimalSeparator {
    final _ret = _objc_msgSend_12(this.pointer, _sel_decimalSeparator);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set decimalSeparator(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setDecimalSeparator_, value.pointer);
  }

  bool get alwaysShowsDecimalSeparator {
    return _objc_msgSend_7(this.pointer, _sel_alwaysShowsDecimalSeparator);
  }

  set alwaysShowsDecimalSeparator(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setAlwaysShowsDecimalSeparator_, value);
  }

  objc.NSString get currencyDecimalSeparator {
    final _ret = _objc_msgSend_12(this.pointer, _sel_currencyDecimalSeparator);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set currencyDecimalSeparator(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setCurrencyDecimalSeparator_, value.pointer);
  }

  bool get usesGroupingSeparator {
    return _objc_msgSend_7(this.pointer, _sel_usesGroupingSeparator);
  }

  set usesGroupingSeparator(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setUsesGroupingSeparator_, value);
  }

  objc.NSString get groupingSeparator {
    final _ret = _objc_msgSend_12(this.pointer, _sel_groupingSeparator);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set groupingSeparator(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setGroupingSeparator_, value.pointer);
  }

  objc.NSString? get zeroSymbol {
    final _ret = _objc_msgSend_13(this.pointer, _sel_zeroSymbol);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set zeroSymbol(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setZeroSymbol_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSDictionary? get textAttributesForZero {
    final _ret = _objc_msgSend_65(this.pointer, _sel_textAttributesForZero);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  set textAttributesForZero(objc.NSDictionary? value) {
    return _objc_msgSend_173(this.pointer, _sel_setTextAttributesForZero_,
        value?.pointer ?? ffi.nullptr);
  }

  objc.NSString get nilSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_nilSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set nilSymbol(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setNilSymbol_, value.pointer);
  }

  objc.NSDictionary? get textAttributesForNil {
    final _ret = _objc_msgSend_65(this.pointer, _sel_textAttributesForNil);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  set textAttributesForNil(objc.NSDictionary? value) {
    return _objc_msgSend_173(this.pointer, _sel_setTextAttributesForNil_,
        value?.pointer ?? ffi.nullptr);
  }

  objc.NSString get notANumberSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_notANumberSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set notANumberSymbol(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setNotANumberSymbol_, value.pointer);
  }

  objc.NSDictionary? get textAttributesForNotANumber {
    final _ret =
        _objc_msgSend_65(this.pointer, _sel_textAttributesForNotANumber);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  set textAttributesForNotANumber(objc.NSDictionary? value) {
    return _objc_msgSend_173(this.pointer, _sel_setTextAttributesForNotANumber_,
        value?.pointer ?? ffi.nullptr);
  }

  objc.NSString get positiveInfinitySymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_positiveInfinitySymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set positiveInfinitySymbol(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setPositiveInfinitySymbol_, value.pointer);
  }

  objc.NSDictionary? get textAttributesForPositiveInfinity {
    final _ret =
        _objc_msgSend_65(this.pointer, _sel_textAttributesForPositiveInfinity);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  set textAttributesForPositiveInfinity(objc.NSDictionary? value) {
    return _objc_msgSend_173(
        this.pointer,
        _sel_setTextAttributesForPositiveInfinity_,
        value?.pointer ?? ffi.nullptr);
  }

  objc.NSString get negativeInfinitySymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_negativeInfinitySymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set negativeInfinitySymbol(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setNegativeInfinitySymbol_, value.pointer);
  }

  objc.NSDictionary? get textAttributesForNegativeInfinity {
    final _ret =
        _objc_msgSend_65(this.pointer, _sel_textAttributesForNegativeInfinity);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  set textAttributesForNegativeInfinity(objc.NSDictionary? value) {
    return _objc_msgSend_173(
        this.pointer,
        _sel_setTextAttributesForNegativeInfinity_,
        value?.pointer ?? ffi.nullptr);
  }

  objc.NSString get positivePrefix {
    final _ret = _objc_msgSend_12(this.pointer, _sel_positivePrefix);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set positivePrefix(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setPositivePrefix_, value.pointer);
  }

  objc.NSString get positiveSuffix {
    final _ret = _objc_msgSend_12(this.pointer, _sel_positiveSuffix);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set positiveSuffix(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setPositiveSuffix_, value.pointer);
  }

  objc.NSString get negativePrefix {
    final _ret = _objc_msgSend_12(this.pointer, _sel_negativePrefix);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set negativePrefix(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setNegativePrefix_, value.pointer);
  }

  objc.NSString get negativeSuffix {
    final _ret = _objc_msgSend_12(this.pointer, _sel_negativeSuffix);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set negativeSuffix(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setNegativeSuffix_, value.pointer);
  }

  objc.NSString get currencyCode {
    final _ret = _objc_msgSend_12(this.pointer, _sel_currencyCode);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set currencyCode(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setCurrencyCode_, value.pointer);
  }

  objc.NSString get currencySymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_currencySymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set currencySymbol(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setCurrencySymbol_, value.pointer);
  }

  objc.NSString get internationalCurrencySymbol {
    final _ret =
        _objc_msgSend_12(this.pointer, _sel_internationalCurrencySymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set internationalCurrencySymbol(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setInternationalCurrencySymbol_, value.pointer);
  }

  objc.NSString get percentSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_percentSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set percentSymbol(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setPercentSymbol_, value.pointer);
  }

  objc.NSString get perMillSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_perMillSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set perMillSymbol(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setPerMillSymbol_, value.pointer);
  }

  objc.NSString get minusSign {
    final _ret = _objc_msgSend_12(this.pointer, _sel_minusSign);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set minusSign(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setMinusSign_, value.pointer);
  }

  objc.NSString get plusSign {
    final _ret = _objc_msgSend_12(this.pointer, _sel_plusSign);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set plusSign(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setPlusSign_, value.pointer);
  }

  objc.NSString get exponentSymbol {
    final _ret = _objc_msgSend_12(this.pointer, _sel_exponentSymbol);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set exponentSymbol(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setExponentSymbol_, value.pointer);
  }

  int get groupingSize {
    return _objc_msgSend_29(this.pointer, _sel_groupingSize);
  }

  set groupingSize(int value) {
    return _objc_msgSend_125(this.pointer, _sel_setGroupingSize_, value);
  }

  int get secondaryGroupingSize {
    return _objc_msgSend_29(this.pointer, _sel_secondaryGroupingSize);
  }

  set secondaryGroupingSize(int value) {
    return _objc_msgSend_125(
        this.pointer, _sel_setSecondaryGroupingSize_, value);
  }

  objc.NSNumber? get multiplier {
    final _ret = _objc_msgSend_174(this.pointer, _sel_multiplier);
    return _ret.address == 0
        ? null
        : objc.NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  set multiplier(objc.NSNumber? value) {
    return _objc_msgSend_175(
        this.pointer, _sel_setMultiplier_, value?.pointer ?? ffi.nullptr);
  }

  int get formatWidth {
    return _objc_msgSend_29(this.pointer, _sel_formatWidth);
  }

  set formatWidth(int value) {
    return _objc_msgSend_125(this.pointer, _sel_setFormatWidth_, value);
  }

  objc.NSString get paddingCharacter {
    final _ret = _objc_msgSend_12(this.pointer, _sel_paddingCharacter);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set paddingCharacter(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setPaddingCharacter_, value.pointer);
  }

  int get paddingPosition {
    return _objc_msgSend_176(this.pointer, _sel_paddingPosition);
  }

  set paddingPosition(int value) {
    return _objc_msgSend_177(this.pointer, _sel_setPaddingPosition_, value);
  }

  int get roundingMode {
    return _objc_msgSend_178(this.pointer, _sel_roundingMode);
  }

  set roundingMode(int value) {
    return _objc_msgSend_179(this.pointer, _sel_setRoundingMode_, value);
  }

  objc.NSNumber get roundingIncrement {
    final _ret = _objc_msgSend_180(this.pointer, _sel_roundingIncrement);
    return objc.NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  set roundingIncrement(objc.NSNumber value) {
    return _objc_msgSend_181(
        this.pointer, _sel_setRoundingIncrement_, value.pointer);
  }

  int get minimumIntegerDigits {
    return _objc_msgSend_29(this.pointer, _sel_minimumIntegerDigits);
  }

  set minimumIntegerDigits(int value) {
    return _objc_msgSend_125(
        this.pointer, _sel_setMinimumIntegerDigits_, value);
  }

  int get maximumIntegerDigits {
    return _objc_msgSend_29(this.pointer, _sel_maximumIntegerDigits);
  }

  set maximumIntegerDigits(int value) {
    return _objc_msgSend_125(
        this.pointer, _sel_setMaximumIntegerDigits_, value);
  }

  int get minimumFractionDigits {
    return _objc_msgSend_29(this.pointer, _sel_minimumFractionDigits);
  }

  set minimumFractionDigits(int value) {
    return _objc_msgSend_125(
        this.pointer, _sel_setMinimumFractionDigits_, value);
  }

  int get maximumFractionDigits {
    return _objc_msgSend_29(this.pointer, _sel_maximumFractionDigits);
  }

  set maximumFractionDigits(int value) {
    return _objc_msgSend_125(
        this.pointer, _sel_setMaximumFractionDigits_, value);
  }

  objc.NSNumber? get minimum {
    final _ret = _objc_msgSend_174(this.pointer, _sel_minimum);
    return _ret.address == 0
        ? null
        : objc.NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  set minimum(objc.NSNumber? value) {
    return _objc_msgSend_175(
        this.pointer, _sel_setMinimum_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSNumber? get maximum {
    final _ret = _objc_msgSend_174(this.pointer, _sel_maximum);
    return _ret.address == 0
        ? null
        : objc.NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  set maximum(objc.NSNumber? value) {
    return _objc_msgSend_175(
        this.pointer, _sel_setMaximum_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSString get currencyGroupingSeparator {
    final _ret = _objc_msgSend_12(this.pointer, _sel_currencyGroupingSeparator);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set currencyGroupingSeparator(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setCurrencyGroupingSeparator_, value.pointer);
  }

  bool get lenient {
    return _objc_msgSend_7(this.pointer, _sel_isLenient);
  }

  set lenient(bool value) {
    return _objc_msgSend_41(this.pointer, _sel_setLenient_, value);
  }

  bool get usesSignificantDigits {
    return _objc_msgSend_7(this.pointer, _sel_usesSignificantDigits);
  }

  set usesSignificantDigits(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setUsesSignificantDigits_, value);
  }

  int get minimumSignificantDigits {
    return _objc_msgSend_29(this.pointer, _sel_minimumSignificantDigits);
  }

  set minimumSignificantDigits(int value) {
    return _objc_msgSend_125(
        this.pointer, _sel_setMinimumSignificantDigits_, value);
  }

  int get maximumSignificantDigits {
    return _objc_msgSend_29(this.pointer, _sel_maximumSignificantDigits);
  }

  set maximumSignificantDigits(int value) {
    return _objc_msgSend_125(
        this.pointer, _sel_setMaximumSignificantDigits_, value);
  }

  bool get partialStringValidationEnabled {
    return _objc_msgSend_7(this.pointer, _sel_isPartialStringValidationEnabled);
  }

  set partialStringValidationEnabled(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setPartialStringValidationEnabled_, value);
  }

  bool get hasThousandSeparators {
    return _objc_msgSend_7(this.pointer, _sel_hasThousandSeparators);
  }

  set hasThousandSeparators(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setHasThousandSeparators_, value);
  }

  objc.NSString get thousandSeparator {
    final _ret = _objc_msgSend_12(this.pointer, _sel_thousandSeparator);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set thousandSeparator(objc.NSString value) {
    return _objc_msgSend_99(
        this.pointer, _sel_setThousandSeparator_, value.pointer);
  }

  bool get localizesFormat {
    return _objc_msgSend_7(this.pointer, _sel_localizesFormat);
  }

  set localizesFormat(bool value) {
    return _objc_msgSend_41(this.pointer, _sel_setLocalizesFormat_, value);
  }

  objc.NSString get format {
    final _ret = _objc_msgSend_12(this.pointer, _sel_format);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set format(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setFormat_, value.pointer);
  }

  NSAttributedString get attributedStringForZero {
    final _ret = _objc_msgSend_63(this.pointer, _sel_attributedStringForZero);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  set attributedStringForZero(NSAttributedString value) {
    return _objc_msgSend_182(
        this.pointer, _sel_setAttributedStringForZero_, value.pointer);
  }

  NSAttributedString get attributedStringForNil {
    final _ret = _objc_msgSend_63(this.pointer, _sel_attributedStringForNil);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  set attributedStringForNil(NSAttributedString value) {
    return _objc_msgSend_182(
        this.pointer, _sel_setAttributedStringForNil_, value.pointer);
  }

  NSAttributedString get attributedStringForNotANumber {
    final _ret =
        _objc_msgSend_63(this.pointer, _sel_attributedStringForNotANumber);
    return NSAttributedString.castFromPointer(_ret,
        retain: true, release: true);
  }

  set attributedStringForNotANumber(NSAttributedString value) {
    return _objc_msgSend_182(
        this.pointer, _sel_setAttributedStringForNotANumber_, value.pointer);
  }

  NSDecimalNumberHandler get roundingBehavior {
    final _ret = _objc_msgSend_183(this.pointer, _sel_roundingBehavior);
    return NSDecimalNumberHandler.castFromPointer(_ret,
        retain: true, release: true);
  }

  set roundingBehavior(NSDecimalNumberHandler value) {
    return _objc_msgSend_185(
        this.pointer, _sel_setRoundingBehavior_, value.pointer);
  }

  @override
  NSNumberFormatter init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSNumberFormatter.castFromPointer(_ret, retain: true, release: true);
  }

  static NSNumberFormatter new1() {
    final _ret = _objc_msgSend_40(_class_NSNumberFormatter, _sel_new);
    return NSNumberFormatter.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSNumberFormatter allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSNumberFormatter, _sel_allocWithZone_, zone);
    return NSNumberFormatter.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSNumberFormatter alloc() {
    final _ret = _objc_msgSend_40(_class_NSNumberFormatter, _sel_alloc);
    return NSNumberFormatter.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSNumberFormatter,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSNumberFormatter,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSNumberFormatter, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSNumberFormatter, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSNumberFormatter,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSNumberFormatter,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSNumberFormatter,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSNumberFormatter, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSNumberFormatter, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSNumberFormatter = objc.getClass("NSNumberFormatter");
late final _sel_stringFromNumber_ = objc.registerName("stringFromNumber:");
final _objc_msgSend_165 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_numberFromString_ = objc.registerName("numberFromString:");
final _objc_msgSend_166 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

abstract class NSNumberFormatterStyle {
  static const int NSNumberFormatterNoStyle = 0;
  static const int NSNumberFormatterDecimalStyle = 1;
  static const int NSNumberFormatterCurrencyStyle = 2;
  static const int NSNumberFormatterPercentStyle = 3;
  static const int NSNumberFormatterScientificStyle = 4;
  static const int NSNumberFormatterSpellOutStyle = 5;
  static const int NSNumberFormatterOrdinalStyle = 6;
  static const int NSNumberFormatterCurrencyISOCodeStyle = 8;
  static const int NSNumberFormatterCurrencyPluralStyle = 9;
  static const int NSNumberFormatterCurrencyAccountingStyle = 10;
}

late final _sel_localizedStringFromNumber_numberStyle_ =
    objc.registerName("localizedStringFromNumber:numberStyle:");
final _objc_msgSend_167 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();

abstract class NSNumberFormatterBehavior {
  static const int NSNumberFormatterBehaviorDefault = 0;
  static const int NSNumberFormatterBehavior10_0 = 1000;
  static const int NSNumberFormatterBehavior10_4 = 1040;
}

final _objc_msgSend_168 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_169 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_numberStyle = objc.registerName("numberStyle");
final _objc_msgSend_170 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setNumberStyle_ = objc.registerName("setNumberStyle:");
final _objc_msgSend_171 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_generatesDecimalNumbers =
    objc.registerName("generatesDecimalNumbers");
late final _sel_setGeneratesDecimalNumbers_ =
    objc.registerName("setGeneratesDecimalNumbers:");
final _objc_msgSend_172 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_negativeFormat = objc.registerName("negativeFormat");
late final _sel_setNegativeFormat_ = objc.registerName("setNegativeFormat:");
late final _sel_textAttributesForNegativeValues =
    objc.registerName("textAttributesForNegativeValues");
late final _sel_setTextAttributesForNegativeValues_ =
    objc.registerName("setTextAttributesForNegativeValues:");
final _objc_msgSend_173 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_positiveFormat = objc.registerName("positiveFormat");
late final _sel_setPositiveFormat_ = objc.registerName("setPositiveFormat:");
late final _sel_textAttributesForPositiveValues =
    objc.registerName("textAttributesForPositiveValues");
late final _sel_setTextAttributesForPositiveValues_ =
    objc.registerName("setTextAttributesForPositiveValues:");
late final _sel_allowsFloats = objc.registerName("allowsFloats");
late final _sel_setAllowsFloats_ = objc.registerName("setAllowsFloats:");
late final _sel_decimalSeparator = objc.registerName("decimalSeparator");
late final _sel_setDecimalSeparator_ =
    objc.registerName("setDecimalSeparator:");
late final _sel_alwaysShowsDecimalSeparator =
    objc.registerName("alwaysShowsDecimalSeparator");
late final _sel_setAlwaysShowsDecimalSeparator_ =
    objc.registerName("setAlwaysShowsDecimalSeparator:");
late final _sel_currencyDecimalSeparator =
    objc.registerName("currencyDecimalSeparator");
late final _sel_setCurrencyDecimalSeparator_ =
    objc.registerName("setCurrencyDecimalSeparator:");
late final _sel_usesGroupingSeparator =
    objc.registerName("usesGroupingSeparator");
late final _sel_setUsesGroupingSeparator_ =
    objc.registerName("setUsesGroupingSeparator:");
late final _sel_groupingSeparator = objc.registerName("groupingSeparator");
late final _sel_setGroupingSeparator_ =
    objc.registerName("setGroupingSeparator:");
late final _sel_zeroSymbol = objc.registerName("zeroSymbol");
late final _sel_setZeroSymbol_ = objc.registerName("setZeroSymbol:");
late final _sel_textAttributesForZero =
    objc.registerName("textAttributesForZero");
late final _sel_setTextAttributesForZero_ =
    objc.registerName("setTextAttributesForZero:");
late final _sel_nilSymbol = objc.registerName("nilSymbol");
late final _sel_setNilSymbol_ = objc.registerName("setNilSymbol:");
late final _sel_textAttributesForNil =
    objc.registerName("textAttributesForNil");
late final _sel_setTextAttributesForNil_ =
    objc.registerName("setTextAttributesForNil:");
late final _sel_notANumberSymbol = objc.registerName("notANumberSymbol");
late final _sel_setNotANumberSymbol_ =
    objc.registerName("setNotANumberSymbol:");
late final _sel_textAttributesForNotANumber =
    objc.registerName("textAttributesForNotANumber");
late final _sel_setTextAttributesForNotANumber_ =
    objc.registerName("setTextAttributesForNotANumber:");
late final _sel_positiveInfinitySymbol =
    objc.registerName("positiveInfinitySymbol");
late final _sel_setPositiveInfinitySymbol_ =
    objc.registerName("setPositiveInfinitySymbol:");
late final _sel_textAttributesForPositiveInfinity =
    objc.registerName("textAttributesForPositiveInfinity");
late final _sel_setTextAttributesForPositiveInfinity_ =
    objc.registerName("setTextAttributesForPositiveInfinity:");
late final _sel_negativeInfinitySymbol =
    objc.registerName("negativeInfinitySymbol");
late final _sel_setNegativeInfinitySymbol_ =
    objc.registerName("setNegativeInfinitySymbol:");
late final _sel_textAttributesForNegativeInfinity =
    objc.registerName("textAttributesForNegativeInfinity");
late final _sel_setTextAttributesForNegativeInfinity_ =
    objc.registerName("setTextAttributesForNegativeInfinity:");
late final _sel_positivePrefix = objc.registerName("positivePrefix");
late final _sel_setPositivePrefix_ = objc.registerName("setPositivePrefix:");
late final _sel_positiveSuffix = objc.registerName("positiveSuffix");
late final _sel_setPositiveSuffix_ = objc.registerName("setPositiveSuffix:");
late final _sel_negativePrefix = objc.registerName("negativePrefix");
late final _sel_setNegativePrefix_ = objc.registerName("setNegativePrefix:");
late final _sel_negativeSuffix = objc.registerName("negativeSuffix");
late final _sel_setNegativeSuffix_ = objc.registerName("setNegativeSuffix:");
late final _sel_currencyCode = objc.registerName("currencyCode");
late final _sel_setCurrencyCode_ = objc.registerName("setCurrencyCode:");
late final _sel_currencySymbol = objc.registerName("currencySymbol");
late final _sel_setCurrencySymbol_ = objc.registerName("setCurrencySymbol:");
late final _sel_internationalCurrencySymbol =
    objc.registerName("internationalCurrencySymbol");
late final _sel_setInternationalCurrencySymbol_ =
    objc.registerName("setInternationalCurrencySymbol:");
late final _sel_percentSymbol = objc.registerName("percentSymbol");
late final _sel_setPercentSymbol_ = objc.registerName("setPercentSymbol:");
late final _sel_perMillSymbol = objc.registerName("perMillSymbol");
late final _sel_setPerMillSymbol_ = objc.registerName("setPerMillSymbol:");
late final _sel_minusSign = objc.registerName("minusSign");
late final _sel_setMinusSign_ = objc.registerName("setMinusSign:");
late final _sel_plusSign = objc.registerName("plusSign");
late final _sel_setPlusSign_ = objc.registerName("setPlusSign:");
late final _sel_exponentSymbol = objc.registerName("exponentSymbol");
late final _sel_setExponentSymbol_ = objc.registerName("setExponentSymbol:");
late final _sel_groupingSize = objc.registerName("groupingSize");
late final _sel_setGroupingSize_ = objc.registerName("setGroupingSize:");
late final _sel_secondaryGroupingSize =
    objc.registerName("secondaryGroupingSize");
late final _sel_setSecondaryGroupingSize_ =
    objc.registerName("setSecondaryGroupingSize:");
late final _sel_multiplier = objc.registerName("multiplier");
final _objc_msgSend_174 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setMultiplier_ = objc.registerName("setMultiplier:");
final _objc_msgSend_175 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_formatWidth = objc.registerName("formatWidth");
late final _sel_setFormatWidth_ = objc.registerName("setFormatWidth:");
late final _sel_paddingCharacter = objc.registerName("paddingCharacter");
late final _sel_setPaddingCharacter_ =
    objc.registerName("setPaddingCharacter:");

abstract class NSNumberFormatterPadPosition {
  static const int NSNumberFormatterPadBeforePrefix = 0;
  static const int NSNumberFormatterPadAfterPrefix = 1;
  static const int NSNumberFormatterPadBeforeSuffix = 2;
  static const int NSNumberFormatterPadAfterSuffix = 3;
}

late final _sel_paddingPosition = objc.registerName("paddingPosition");
final _objc_msgSend_176 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setPaddingPosition_ = objc.registerName("setPaddingPosition:");
final _objc_msgSend_177 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSNumberFormatterRoundingMode {
  static const int NSNumberFormatterRoundCeiling = 0;
  static const int NSNumberFormatterRoundFloor = 1;
  static const int NSNumberFormatterRoundDown = 2;
  static const int NSNumberFormatterRoundUp = 3;
  static const int NSNumberFormatterRoundHalfEven = 4;
  static const int NSNumberFormatterRoundHalfDown = 5;
  static const int NSNumberFormatterRoundHalfUp = 6;
}

late final _sel_roundingMode = objc.registerName("roundingMode");
final _objc_msgSend_178 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setRoundingMode_ = objc.registerName("setRoundingMode:");
final _objc_msgSend_179 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_roundingIncrement = objc.registerName("roundingIncrement");
final _objc_msgSend_180 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setRoundingIncrement_ =
    objc.registerName("setRoundingIncrement:");
final _objc_msgSend_181 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_minimumIntegerDigits =
    objc.registerName("minimumIntegerDigits");
late final _sel_setMinimumIntegerDigits_ =
    objc.registerName("setMinimumIntegerDigits:");
late final _sel_maximumIntegerDigits =
    objc.registerName("maximumIntegerDigits");
late final _sel_setMaximumIntegerDigits_ =
    objc.registerName("setMaximumIntegerDigits:");
late final _sel_minimumFractionDigits =
    objc.registerName("minimumFractionDigits");
late final _sel_setMinimumFractionDigits_ =
    objc.registerName("setMinimumFractionDigits:");
late final _sel_maximumFractionDigits =
    objc.registerName("maximumFractionDigits");
late final _sel_setMaximumFractionDigits_ =
    objc.registerName("setMaximumFractionDigits:");
late final _sel_minimum = objc.registerName("minimum");
late final _sel_setMinimum_ = objc.registerName("setMinimum:");
late final _sel_maximum = objc.registerName("maximum");
late final _sel_setMaximum_ = objc.registerName("setMaximum:");
late final _sel_currencyGroupingSeparator =
    objc.registerName("currencyGroupingSeparator");
late final _sel_setCurrencyGroupingSeparator_ =
    objc.registerName("setCurrencyGroupingSeparator:");
late final _sel_usesSignificantDigits =
    objc.registerName("usesSignificantDigits");
late final _sel_setUsesSignificantDigits_ =
    objc.registerName("setUsesSignificantDigits:");
late final _sel_minimumSignificantDigits =
    objc.registerName("minimumSignificantDigits");
late final _sel_setMinimumSignificantDigits_ =
    objc.registerName("setMinimumSignificantDigits:");
late final _sel_maximumSignificantDigits =
    objc.registerName("maximumSignificantDigits");
late final _sel_setMaximumSignificantDigits_ =
    objc.registerName("setMaximumSignificantDigits:");
late final _sel_isPartialStringValidationEnabled =
    objc.registerName("isPartialStringValidationEnabled");
late final _sel_setPartialStringValidationEnabled_ =
    objc.registerName("setPartialStringValidationEnabled:");
late final _sel_hasThousandSeparators =
    objc.registerName("hasThousandSeparators");
late final _sel_setHasThousandSeparators_ =
    objc.registerName("setHasThousandSeparators:");
late final _sel_thousandSeparator = objc.registerName("thousandSeparator");
late final _sel_setThousandSeparator_ =
    objc.registerName("setThousandSeparator:");
late final _sel_localizesFormat = objc.registerName("localizesFormat");
late final _sel_setLocalizesFormat_ = objc.registerName("setLocalizesFormat:");
late final _sel_format = objc.registerName("format");
late final _sel_setFormat_ = objc.registerName("setFormat:");
late final _sel_attributedStringForZero =
    objc.registerName("attributedStringForZero");
late final _sel_setAttributedStringForZero_ =
    objc.registerName("setAttributedStringForZero:");
final _objc_msgSend_182 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_attributedStringForNil =
    objc.registerName("attributedStringForNil");
late final _sel_setAttributedStringForNil_ =
    objc.registerName("setAttributedStringForNil:");
late final _sel_attributedStringForNotANumber =
    objc.registerName("attributedStringForNotANumber");
late final _sel_setAttributedStringForNotANumber_ =
    objc.registerName("setAttributedStringForNotANumber:");

class NSDecimalNumberHandler extends objc.NSObject {
  NSDecimalNumberHandler._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSDecimalNumberHandler] that points to the same underlying object as [other].
  NSDecimalNumberHandler.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSDecimalNumberHandler] that wraps the given raw object pointer.
  NSDecimalNumberHandler.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSDecimalNumberHandler].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSDecimalNumberHandler);
  }

  static NSDecimalNumberHandler getDefaultDecimalNumberHandler() {
    final _ret = _objc_msgSend_183(
        _class_NSDecimalNumberHandler, _sel_defaultDecimalNumberHandler);
    return NSDecimalNumberHandler.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSDecimalNumberHandler
      initWithRoundingMode_scale_raiseOnExactness_raiseOnOverflow_raiseOnUnderflow_raiseOnDivideByZero_(
          int roundingMode,
          int scale,
          bool exact,
          bool overflow,
          bool underflow,
          bool divideByZero) {
    final _ret = _objc_msgSend_184(
        this.pointer,
        _sel_initWithRoundingMode_scale_raiseOnExactness_raiseOnOverflow_raiseOnUnderflow_raiseOnDivideByZero_,
        roundingMode,
        scale,
        exact,
        overflow,
        underflow,
        divideByZero);
    return NSDecimalNumberHandler.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSDecimalNumberHandler
      decimalNumberHandlerWithRoundingMode_scale_raiseOnExactness_raiseOnOverflow_raiseOnUnderflow_raiseOnDivideByZero_(
          int roundingMode,
          int scale,
          bool exact,
          bool overflow,
          bool underflow,
          bool divideByZero) {
    final _ret = _objc_msgSend_184(
        _class_NSDecimalNumberHandler,
        _sel_decimalNumberHandlerWithRoundingMode_scale_raiseOnExactness_raiseOnOverflow_raiseOnUnderflow_raiseOnDivideByZero_,
        roundingMode,
        scale,
        exact,
        overflow,
        underflow,
        divideByZero);
    return NSDecimalNumberHandler.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSDecimalNumberHandler init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSDecimalNumberHandler.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSDecimalNumberHandler new1() {
    final _ret = _objc_msgSend_40(_class_NSDecimalNumberHandler, _sel_new);
    return NSDecimalNumberHandler.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSDecimalNumberHandler allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(
        _class_NSDecimalNumberHandler, _sel_allocWithZone_, zone);
    return NSDecimalNumberHandler.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSDecimalNumberHandler alloc() {
    final _ret = _objc_msgSend_40(_class_NSDecimalNumberHandler, _sel_alloc);
    return NSDecimalNumberHandler.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSDecimalNumberHandler,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSDecimalNumberHandler,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSDecimalNumberHandler, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(
        _class_NSDecimalNumberHandler, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSDecimalNumberHandler,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSDecimalNumberHandler,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSDecimalNumberHandler,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSDecimalNumberHandler, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSDecimalNumberHandler, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSDecimalNumberHandler =
    objc.getClass("NSDecimalNumberHandler");
late final _sel_defaultDecimalNumberHandler =
    objc.registerName("defaultDecimalNumberHandler");
final _objc_msgSend_183 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();

abstract class NSRoundingMode {
  static const int NSRoundPlain = 0;
  static const int NSRoundDown = 1;
  static const int NSRoundUp = 2;
  static const int NSRoundBankers = 3;
}

late final _sel_initWithRoundingMode_scale_raiseOnExactness_raiseOnOverflow_raiseOnUnderflow_raiseOnDivideByZero_ =
    objc.registerName(
        "initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:");
final _objc_msgSend_184 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Short,
                ffi.Bool,
                ffi.Bool,
                ffi.Bool,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            bool,
            bool,
            bool,
            bool)>();
late final _sel_decimalNumberHandlerWithRoundingMode_scale_raiseOnExactness_raiseOnOverflow_raiseOnUnderflow_raiseOnDivideByZero_ =
    objc.registerName(
        "decimalNumberHandlerWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:");
late final _sel_roundingBehavior = objc.registerName("roundingBehavior");
late final _sel_setRoundingBehavior_ =
    objc.registerName("setRoundingBehavior:");
final _objc_msgSend_185 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

abstract class NSLocaleLanguageDirection {
  static const int NSLocaleLanguageDirectionUnknown = 0;
  static const int NSLocaleLanguageDirectionLeftToRight = 1;
  static const int NSLocaleLanguageDirectionRightToLeft = 2;
  static const int NSLocaleLanguageDirectionTopToBottom = 3;
  static const int NSLocaleLanguageDirectionBottomToTop = 4;
}

class NSScanner extends objc.NSObject {
  NSScanner._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSScanner] that points to the same underlying object as [other].
  NSScanner.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSScanner] that wraps the given raw object pointer.
  NSScanner.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSScanner].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSScanner);
  }

  objc.NSString get string {
    final _ret = _objc_msgSend_12(this.pointer, _sel_string);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int get scanLocation {
    return _objc_msgSend_29(this.pointer, _sel_scanLocation);
  }

  set scanLocation(int value) {
    return _objc_msgSend_125(this.pointer, _sel_setScanLocation_, value);
  }

  objc.NSCharacterSet? get charactersToBeSkipped {
    final _ret = _objc_msgSend_186(this.pointer, _sel_charactersToBeSkipped);
    return _ret.address == 0
        ? null
        : objc.NSCharacterSet.castFromPointer(_ret,
            retain: true, release: true);
  }

  set charactersToBeSkipped(objc.NSCharacterSet? value) {
    return _objc_msgSend_187(this.pointer, _sel_setCharactersToBeSkipped_,
        value?.pointer ?? ffi.nullptr);
  }

  bool get caseSensitive {
    return _objc_msgSend_7(this.pointer, _sel_caseSensitive);
  }

  set caseSensitive(bool value) {
    return _objc_msgSend_41(this.pointer, _sel_setCaseSensitive_, value);
  }

  objc.NSObject? get locale {
    final _ret = _objc_msgSend_66(this.pointer, _sel_locale);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  set locale(objc.NSObject? value) {
    return _objc_msgSend_188(
        this.pointer, _sel_setLocale_, value?.pointer ?? ffi.nullptr);
  }

  NSScanner initWithString_(objc.NSString string) {
    final _ret =
        _objc_msgSend_35(this.pointer, _sel_initWithString_, string.pointer);
    return NSScanner.castFromPointer(_ret, retain: true, release: true);
  }

  bool scanInt_(ffi.Pointer<ffi.Int> result) {
    return _objc_msgSend_189(this.pointer, _sel_scanInt_, result);
  }

  bool scanInteger_(ffi.Pointer<ffi.Long> result) {
    return _objc_msgSend_190(this.pointer, _sel_scanInteger_, result);
  }

  bool scanLongLong_(ffi.Pointer<ffi.LongLong> result) {
    return _objc_msgSend_191(this.pointer, _sel_scanLongLong_, result);
  }

  bool scanUnsignedLongLong_(ffi.Pointer<ffi.UnsignedLongLong> result) {
    return _objc_msgSend_192(this.pointer, _sel_scanUnsignedLongLong_, result);
  }

  bool scanFloat_(ffi.Pointer<ffi.Float> result) {
    return _objc_msgSend_193(this.pointer, _sel_scanFloat_, result);
  }

  bool scanDouble_(ffi.Pointer<ffi.Double> result) {
    return _objc_msgSend_194(this.pointer, _sel_scanDouble_, result);
  }

  bool scanHexInt_(ffi.Pointer<ffi.UnsignedInt> result) {
    return _objc_msgSend_195(this.pointer, _sel_scanHexInt_, result);
  }

  bool scanHexLongLong_(ffi.Pointer<ffi.UnsignedLongLong> result) {
    return _objc_msgSend_192(this.pointer, _sel_scanHexLongLong_, result);
  }

  bool scanHexFloat_(ffi.Pointer<ffi.Float> result) {
    return _objc_msgSend_193(this.pointer, _sel_scanHexFloat_, result);
  }

  bool scanHexDouble_(ffi.Pointer<ffi.Double> result) {
    return _objc_msgSend_194(this.pointer, _sel_scanHexDouble_, result);
  }

  bool scanString_intoString_(
      objc.NSString string, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> result) {
    return _objc_msgSend_196(
        this.pointer, _sel_scanString_intoString_, string.pointer, result);
  }

  bool scanCharactersFromSet_intoString_(objc.NSCharacterSet set,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> result) {
    return _objc_msgSend_197(this.pointer,
        _sel_scanCharactersFromSet_intoString_, set.pointer, result);
  }

  bool scanUpToString_intoString_(
      objc.NSString string, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> result) {
    return _objc_msgSend_196(
        this.pointer, _sel_scanUpToString_intoString_, string.pointer, result);
  }

  bool scanUpToCharactersFromSet_intoString_(objc.NSCharacterSet set,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> result) {
    return _objc_msgSend_197(this.pointer,
        _sel_scanUpToCharactersFromSet_intoString_, set.pointer, result);
  }

  bool get atEnd {
    return _objc_msgSend_7(this.pointer, _sel_isAtEnd);
  }

  static NSScanner scannerWithString_(objc.NSString string) {
    final _ret = _objc_msgSend_35(
        _class_NSScanner, _sel_scannerWithString_, string.pointer);
    return NSScanner.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject localizedScannerWithString_(objc.NSString string) {
    final _ret = _objc_msgSend_35(
        _class_NSScanner, _sel_localizedScannerWithString_, string.pointer);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  bool scanDecimal_(ffi.Pointer<NSDecimal> dcm) {
    return _objc_msgSend_198(this.pointer, _sel_scanDecimal_, dcm);
  }

  @override
  NSScanner init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSScanner.castFromPointer(_ret, retain: true, release: true);
  }

  static NSScanner new1() {
    final _ret = _objc_msgSend_40(_class_NSScanner, _sel_new);
    return NSScanner.castFromPointer(_ret, retain: false, release: true);
  }

  static NSScanner allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSScanner, _sel_allocWithZone_, zone);
    return NSScanner.castFromPointer(_ret, retain: false, release: true);
  }

  static NSScanner alloc() {
    final _ret = _objc_msgSend_40(_class_NSScanner, _sel_alloc);
    return NSScanner.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSScanner,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSScanner,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSScanner, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSScanner, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSScanner,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSScanner,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSScanner,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSScanner, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSScanner, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSScanner = objc.getClass("NSScanner");
late final _sel_scanLocation = objc.registerName("scanLocation");
late final _sel_setScanLocation_ = objc.registerName("setScanLocation:");
late final _sel_charactersToBeSkipped =
    objc.registerName("charactersToBeSkipped");
final _objc_msgSend_186 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setCharactersToBeSkipped_ =
    objc.registerName("setCharactersToBeSkipped:");
final _objc_msgSend_187 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_caseSensitive = objc.registerName("caseSensitive");
late final _sel_setCaseSensitive_ = objc.registerName("setCaseSensitive:");
final _objc_msgSend_188 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_scanInt_ = objc.registerName("scanInt:");
final _objc_msgSend_189 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Int>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Int>)>();
late final _sel_scanInteger_ = objc.registerName("scanInteger:");
final _objc_msgSend_190 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Long>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Long>)>();
late final _sel_scanLongLong_ = objc.registerName("scanLongLong:");
final _objc_msgSend_191 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.LongLong>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.LongLong>)>();
late final _sel_scanUnsignedLongLong_ =
    objc.registerName("scanUnsignedLongLong:");
final _objc_msgSend_192 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedLongLong>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedLongLong>)>();
late final _sel_scanFloat_ = objc.registerName("scanFloat:");
final _objc_msgSend_193 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Float>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Float>)>();
late final _sel_scanDouble_ = objc.registerName("scanDouble:");
final _objc_msgSend_194 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Double>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Double>)>();
late final _sel_scanHexInt_ = objc.registerName("scanHexInt:");
final _objc_msgSend_195 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedInt>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.UnsignedInt>)>();
late final _sel_scanHexLongLong_ = objc.registerName("scanHexLongLong:");
late final _sel_scanHexFloat_ = objc.registerName("scanHexFloat:");
late final _sel_scanHexDouble_ = objc.registerName("scanHexDouble:");
late final _sel_scanString_intoString_ =
    objc.registerName("scanString:intoString:");
final _objc_msgSend_196 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_scanCharactersFromSet_intoString_ =
    objc.registerName("scanCharactersFromSet:intoString:");
final _objc_msgSend_197 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_scanUpToString_intoString_ =
    objc.registerName("scanUpToString:intoString:");
late final _sel_scanUpToCharactersFromSet_intoString_ =
    objc.registerName("scanUpToCharactersFromSet:intoString:");
late final _sel_isAtEnd = objc.registerName("isAtEnd");
late final _sel_scannerWithString_ = objc.registerName("scannerWithString:");
late final _sel_localizedScannerWithString_ =
    objc.registerName("localizedScannerWithString:");

final class NSDecimal extends ffi.Opaque {}

late final _sel_scanDecimal_ = objc.registerName("scanDecimal:");
final _objc_msgSend_198 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<NSDecimal>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<NSDecimal>)>();

class NSException extends objc.NSObject {
  NSException._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSException] that points to the same underlying object as [other].
  NSException.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSException] that wraps the given raw object pointer.
  NSException.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSException].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSException);
  }

  static NSException exceptionWithName_reason_userInfo_(
      objc.NSString name, objc.NSString? reason, objc.NSDictionary? userInfo) {
    final _ret = _objc_msgSend_199(
        _class_NSException,
        _sel_exceptionWithName_reason_userInfo_,
        name.pointer,
        reason?.pointer ?? ffi.nullptr,
        userInfo?.pointer ?? ffi.nullptr);
    return NSException.castFromPointer(_ret, retain: true, release: true);
  }

  NSException initWithName_reason_userInfo_(objc.NSString aName,
      objc.NSString? aReason, objc.NSDictionary? aUserInfo) {
    final _ret = _objc_msgSend_200(
        this.pointer,
        _sel_initWithName_reason_userInfo_,
        aName.pointer,
        aReason?.pointer ?? ffi.nullptr,
        aUserInfo?.pointer ?? ffi.nullptr);
    return NSException.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get name {
    final _ret = _objc_msgSend_12(this.pointer, _sel_name);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get reason {
    final _ret = _objc_msgSend_13(this.pointer, _sel_reason);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? get userInfo {
    final _ret = _objc_msgSend_65(this.pointer, _sel_userInfo);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get callStackReturnAddresses {
    final _ret = _objc_msgSend_6(this.pointer, _sel_callStackReturnAddresses);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get callStackSymbols {
    final _ret = _objc_msgSend_6(this.pointer, _sel_callStackSymbols);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  void raise() {
    _objc_msgSend_82(this.pointer, _sel_raise);
  }

  static void raise_format_(objc.NSString name, objc.NSString format) {
    _objc_msgSend_201(
        _class_NSException, _sel_raise_format_, name.pointer, format.pointer);
  }

  static void raise_format_arguments_(objc.NSString name, objc.NSString format,
      ffi.Pointer<__va_list_tag> argList) {
    _objc_msgSend_202(_class_NSException, _sel_raise_format_arguments_,
        name.pointer, format.pointer, argList);
  }

  @override
  NSException init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSException.castFromPointer(_ret, retain: true, release: true);
  }

  static NSException new1() {
    final _ret = _objc_msgSend_40(_class_NSException, _sel_new);
    return NSException.castFromPointer(_ret, retain: false, release: true);
  }

  static NSException allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSException, _sel_allocWithZone_, zone);
    return NSException.castFromPointer(_ret, retain: false, release: true);
  }

  static NSException alloc() {
    final _ret = _objc_msgSend_40(_class_NSException, _sel_alloc);
    return NSException.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSException,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSException,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSException, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSException, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSException,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSException,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSException,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSException, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSException, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSException = objc.getClass("NSException");
late final _sel_exceptionWithName_reason_userInfo_ =
    objc.registerName("exceptionWithName:reason:userInfo:");
final _objc_msgSend_199 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithName_reason_userInfo_ =
    objc.registerName("initWithName:reason:userInfo:");
final _objc_msgSend_200 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_reason = objc.registerName("reason");
late final _sel_userInfo = objc.registerName("userInfo");
late final _sel_callStackReturnAddresses =
    objc.registerName("callStackReturnAddresses");
late final _sel_callStackSymbols = objc.registerName("callStackSymbols");
late final _sel_raise = objc.registerName("raise");
late final _sel_raise_format_ = objc.registerName("raise:format:");
final _objc_msgSend_201 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_raise_format_arguments_ =
    objc.registerName("raise:format:arguments:");
final _objc_msgSend_202 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<__va_list_tag>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<__va_list_tag>)>();

class NSRunLoop extends objc.NSObject {
  NSRunLoop._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSRunLoop] that points to the same underlying object as [other].
  NSRunLoop.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSRunLoop] that wraps the given raw object pointer.
  NSRunLoop.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSRunLoop].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSRunLoop);
  }

  static NSRunLoop getCurrentRunLoop() {
    final _ret = _objc_msgSend_203(_class_NSRunLoop, _sel_currentRunLoop);
    return NSRunLoop.castFromPointer(_ret, retain: true, release: true);
  }

  static NSRunLoop getMainRunLoop() {
    final _ret = _objc_msgSend_203(_class_NSRunLoop, _sel_mainRunLoop);
    return NSRunLoop.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get currentMode {
    final _ret = _objc_msgSend_13(this.pointer, _sel_currentMode);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  ffi.Pointer<__CFRunLoop> getCFRunLoop() {
    return _objc_msgSend_204(this.pointer, _sel_getCFRunLoop);
  }

  void addTimer_forMode_(NSTimer timer, objc.NSString mode) {
    _objc_msgSend_213(
        this.pointer, _sel_addTimer_forMode_, timer.pointer, mode.pointer);
  }

  void addPort_forMode_(NSPort aPort, objc.NSString mode) {
    _objc_msgSend_244(
        this.pointer, _sel_addPort_forMode_, aPort.pointer, mode.pointer);
  }

  void removePort_forMode_(NSPort aPort, objc.NSString mode) {
    _objc_msgSend_244(
        this.pointer, _sel_removePort_forMode_, aPort.pointer, mode.pointer);
  }

  objc.NSDate? limitDateForMode_(objc.NSString mode) {
    final _ret =
        _objc_msgSend_93(this.pointer, _sel_limitDateForMode_, mode.pointer);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  void acceptInputForMode_beforeDate_(
      objc.NSString mode, objc.NSDate limitDate) {
    _objc_msgSend_245(this.pointer, _sel_acceptInputForMode_beforeDate_,
        mode.pointer, limitDate.pointer);
  }

  void run() {
    _objc_msgSend_82(this.pointer, _sel_run);
  }

  void runUntilDate_(objc.NSDate limitDate) {
    _objc_msgSend_246(this.pointer, _sel_runUntilDate_, limitDate.pointer);
  }

  bool runMode_beforeDate_(objc.NSString mode, objc.NSDate limitDate) {
    return _objc_msgSend_247(this.pointer, _sel_runMode_beforeDate_,
        mode.pointer, limitDate.pointer);
  }

  void configureAsServer() {
    _objc_msgSend_82(this.pointer, _sel_configureAsServer);
  }

  void performInModes_block_(objc.NSArray modes, ObjCBlock_ffiVoid block) {
    _objc_msgSend_248(
        this.pointer, _sel_performInModes_block_, modes.pointer, block.pointer);
  }

  void performBlock_(ObjCBlock_ffiVoid block) {
    _objc_msgSend_249(this.pointer, _sel_performBlock_, block.pointer);
  }

  void performSelector_target_argument_order_modes_(
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject target,
      objc.NSObject? arg,
      int order,
      objc.NSArray modes) {
    _objc_msgSend_250(
        this.pointer,
        _sel_performSelector_target_argument_order_modes_,
        aSelector,
        target.pointer,
        arg?.pointer ?? ffi.nullptr,
        order,
        modes.pointer);
  }

  void cancelPerformSelector_target_argument_(
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject target,
      objc.NSObject? arg) {
    _objc_msgSend_251(this.pointer, _sel_cancelPerformSelector_target_argument_,
        aSelector, target.pointer, arg?.pointer ?? ffi.nullptr);
  }

  void cancelPerformSelectorsWithTarget_(objc.NSObject target) {
    _objc_msgSend_49(
        this.pointer, _sel_cancelPerformSelectorsWithTarget_, target.pointer);
  }

  @override
  NSRunLoop init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSRunLoop.castFromPointer(_ret, retain: true, release: true);
  }

  static NSRunLoop new1() {
    final _ret = _objc_msgSend_40(_class_NSRunLoop, _sel_new);
    return NSRunLoop.castFromPointer(_ret, retain: false, release: true);
  }

  static NSRunLoop allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSRunLoop, _sel_allocWithZone_, zone);
    return NSRunLoop.castFromPointer(_ret, retain: false, release: true);
  }

  static NSRunLoop alloc() {
    final _ret = _objc_msgSend_40(_class_NSRunLoop, _sel_alloc);
    return NSRunLoop.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSRunLoop,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSRunLoop,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSRunLoop, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSRunLoop, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSRunLoop,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSRunLoop,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSRunLoop,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSRunLoop, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSRunLoop, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSRunLoop = objc.getClass("NSRunLoop");
late final _sel_currentRunLoop = objc.registerName("currentRunLoop");
final _objc_msgSend_203 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_mainRunLoop = objc.registerName("mainRunLoop");
late final _sel_currentMode = objc.registerName("currentMode");

final class __CFRunLoop extends ffi.Opaque {}

late final _sel_getCFRunLoop = objc.registerName("getCFRunLoop");
final _objc_msgSend_204 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<__CFRunLoop> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<__CFRunLoop> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();

class NSTimer extends objc.NSObject {
  NSTimer._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSTimer] that points to the same underlying object as [other].
  NSTimer.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSTimer] that wraps the given raw object pointer.
  NSTimer.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSTimer].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSTimer);
  }

  static NSTimer timerWithTimeInterval_invocation_repeats_(
      double ti, objc.NSInvocation invocation, bool yesOrNo) {
    final _ret = _objc_msgSend_205(
        _class_NSTimer,
        _sel_timerWithTimeInterval_invocation_repeats_,
        ti,
        invocation.pointer,
        yesOrNo);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimer scheduledTimerWithTimeInterval_invocation_repeats_(
      double ti, objc.NSInvocation invocation, bool yesOrNo) {
    final _ret = _objc_msgSend_205(
        _class_NSTimer,
        _sel_scheduledTimerWithTimeInterval_invocation_repeats_,
        ti,
        invocation.pointer,
        yesOrNo);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimer timerWithTimeInterval_target_selector_userInfo_repeats_(
      double ti,
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? userInfo,
      bool yesOrNo) {
    final _ret = _objc_msgSend_206(
        _class_NSTimer,
        _sel_timerWithTimeInterval_target_selector_userInfo_repeats_,
        ti,
        aTarget.pointer,
        aSelector,
        userInfo?.pointer ?? ffi.nullptr,
        yesOrNo);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimer
      scheduledTimerWithTimeInterval_target_selector_userInfo_repeats_(
          double ti,
          objc.NSObject aTarget,
          ffi.Pointer<objc.ObjCSelector> aSelector,
          objc.NSObject? userInfo,
          bool yesOrNo) {
    final _ret = _objc_msgSend_206(
        _class_NSTimer,
        _sel_scheduledTimerWithTimeInterval_target_selector_userInfo_repeats_,
        ti,
        aTarget.pointer,
        aSelector,
        userInfo?.pointer ?? ffi.nullptr,
        yesOrNo);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimer timerWithTimeInterval_repeats_block_(
      double interval, bool repeats, ObjCBlock_ffiVoid_NSTimer block) {
    final _ret = _objc_msgSend_207(
        _class_NSTimer,
        _sel_timerWithTimeInterval_repeats_block_,
        interval,
        repeats,
        block.pointer);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimer scheduledTimerWithTimeInterval_repeats_block_(
      double interval, bool repeats, ObjCBlock_ffiVoid_NSTimer block) {
    final _ret = _objc_msgSend_207(
        _class_NSTimer,
        _sel_scheduledTimerWithTimeInterval_repeats_block_,
        interval,
        repeats,
        block.pointer);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  NSTimer initWithFireDate_interval_repeats_block_(objc.NSDate date,
      double interval, bool repeats, ObjCBlock_ffiVoid_NSTimer block) {
    final _ret = _objc_msgSend_208(
        this.pointer,
        _sel_initWithFireDate_interval_repeats_block_,
        date.pointer,
        interval,
        repeats,
        block.pointer);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  NSTimer initWithFireDate_interval_target_selector_userInfo_repeats_(
      objc.NSDate date,
      double ti,
      objc.NSObject t,
      ffi.Pointer<objc.ObjCSelector> s,
      objc.NSObject? ui,
      bool rep) {
    final _ret = _objc_msgSend_209(
        this.pointer,
        _sel_initWithFireDate_interval_target_selector_userInfo_repeats_,
        date.pointer,
        ti,
        t.pointer,
        s,
        ui?.pointer ?? ffi.nullptr,
        rep);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  void fire() {
    _objc_msgSend_82(this.pointer, _sel_fire);
  }

  objc.NSDate get fireDate {
    final _ret = _objc_msgSend_210(this.pointer, _sel_fireDate);
    return objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  set fireDate(objc.NSDate value) {
    return _objc_msgSend_211(this.pointer, _sel_setFireDate_, value.pointer);
  }

  double get timeInterval {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_timeInterval)
        : _objc_msgSend_115(this.pointer, _sel_timeInterval);
  }

  double get tolerance {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_tolerance)
        : _objc_msgSend_115(this.pointer, _sel_tolerance);
  }

  set tolerance(double value) {
    return _objc_msgSend_212(this.pointer, _sel_setTolerance_, value);
  }

  void invalidate() {
    _objc_msgSend_82(this.pointer, _sel_invalidate);
  }

  bool get valid {
    return _objc_msgSend_7(this.pointer, _sel_isValid);
  }

  objc.NSObject? get userInfo {
    final _ret = _objc_msgSend_66(this.pointer, _sel_userInfo);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSTimer init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSTimer.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTimer new1() {
    final _ret = _objc_msgSend_40(_class_NSTimer, _sel_new);
    return NSTimer.castFromPointer(_ret, retain: false, release: true);
  }

  static NSTimer allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSTimer, _sel_allocWithZone_, zone);
    return NSTimer.castFromPointer(_ret, retain: false, release: true);
  }

  static NSTimer alloc() {
    final _ret = _objc_msgSend_40(_class_NSTimer, _sel_alloc);
    return NSTimer.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSTimer,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSTimer,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSTimer, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSTimer, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSTimer,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSTimer,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSTimer,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSTimer, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(_class_NSTimer, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSTimer = objc.getClass("NSTimer");
late final _sel_timerWithTimeInterval_invocation_repeats_ =
    objc.registerName("timerWithTimeInterval:invocation:repeats:");
final _objc_msgSend_205 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Double,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            double,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_scheduledTimerWithTimeInterval_invocation_repeats_ =
    objc.registerName("scheduledTimerWithTimeInterval:invocation:repeats:");
late final _sel_timerWithTimeInterval_target_selector_userInfo_repeats_ = objc
    .registerName("timerWithTimeInterval:target:selector:userInfo:repeats:");
final _objc_msgSend_206 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Double,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            double,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_scheduledTimerWithTimeInterval_target_selector_userInfo_repeats_ =
    objc.registerName(
        "scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:");
void _ObjCBlock_ffiVoid_NSTimer_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>()
        .asFunction<void Function(ffi.Pointer<objc.ObjCObject>)>()(arg0);
final _ObjCBlock_ffiVoid_NSTimer_closureRegistry =
    <int, void Function(ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_ffiVoid_NSTimer_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_NSTimer_registerClosure(
    void Function(ffi.Pointer<objc.ObjCObject>) fn) {
  final id = ++_ObjCBlock_ffiVoid_NSTimer_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSTimer_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSTimer_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    _ObjCBlock_ffiVoid_NSTimer_closureRegistry[block.ref.target.address]!(arg0);

class ObjCBlock_ffiVoid_NSTimer extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSTimer._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSTimer castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSTimer._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSTimer.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSTimer_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSTimer.fromFunction(void Function(NSTimer) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSTimer_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_NSTimer_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(
                    NSTimer.castFromPointer(arg0,
                        retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSTimer.listener(void Function(NSTimer) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>.listener(
                    _ObjCBlock_ffiVoid_NSTimer_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSTimer_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(
                    NSTimer.castFromPointer(arg0,
                        retain: true, release: true)))));
  static ffi.NativeCallable<
          ffi.Void Function(
              ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>?
      _dartFuncListenerTrampoline;

  void call(NSTimer arg0) => pointer.ref.invoke
      .cast<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<objc.ObjCBlock> block,
                  ffi.Pointer<objc.ObjCObject> arg0)>>()
      .asFunction<
          void Function(ffi.Pointer<objc.ObjCBlock>,
              ffi.Pointer<objc.ObjCObject>)>()(pointer, arg0.pointer);
}

late final _sel_timerWithTimeInterval_repeats_block_ =
    objc.registerName("timerWithTimeInterval:repeats:block:");
final _objc_msgSend_207 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Double,
                ffi.Bool,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            double,
            bool,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_scheduledTimerWithTimeInterval_repeats_block_ =
    objc.registerName("scheduledTimerWithTimeInterval:repeats:block:");
late final _sel_initWithFireDate_interval_repeats_block_ =
    objc.registerName("initWithFireDate:interval:repeats:block:");
final _objc_msgSend_208 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Double,
                ffi.Bool,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            double,
            bool,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_initWithFireDate_interval_target_selector_userInfo_repeats_ =
    objc.registerName(
        "initWithFireDate:interval:target:selector:userInfo:repeats:");
final _objc_msgSend_209 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Double,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            double,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_fire = objc.registerName("fire");
late final _sel_fireDate = objc.registerName("fireDate");
final _objc_msgSend_210 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setFireDate_ = objc.registerName("setFireDate:");
final _objc_msgSend_211 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_timeInterval = objc.registerName("timeInterval");
late final _sel_tolerance = objc.registerName("tolerance");
late final _sel_setTolerance_ = objc.registerName("setTolerance:");
final _objc_msgSend_212 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Double)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, double)>();
late final _sel_invalidate = objc.registerName("invalidate");
late final _sel_isValid = objc.registerName("isValid");
late final _sel_addTimer_forMode_ = objc.registerName("addTimer:forMode:");
final _objc_msgSend_213 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

class NSPort extends objc.NSObject {
  NSPort._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSPort] that points to the same underlying object as [other].
  NSPort.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSPort] that wraps the given raw object pointer.
  NSPort.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSPort].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSPort);
  }

  static NSPort port() {
    final _ret = _objc_msgSend_214(_class_NSPort, _sel_port);
    return NSPort.castFromPointer(_ret, retain: true, release: true);
  }

  void invalidate() {
    _objc_msgSend_82(this.pointer, _sel_invalidate);
  }

  bool get valid {
    return _objc_msgSend_7(this.pointer, _sel_isValid);
  }

  void setDelegate_(objc.NSObject? anObject) {
    _objc_msgSend_215(
        this.pointer, _sel_setDelegate_, anObject?.pointer ?? ffi.nullptr);
  }

  objc.NSObject? delegate() {
    final _ret = _objc_msgSend_66(this.pointer, _sel_delegate);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  void scheduleInRunLoop_forMode_(NSRunLoop runLoop, objc.NSString mode) {
    _objc_msgSend_216(this.pointer, _sel_scheduleInRunLoop_forMode_,
        runLoop.pointer, mode.pointer);
  }

  void removeFromRunLoop_forMode_(NSRunLoop runLoop, objc.NSString mode) {
    _objc_msgSend_216(this.pointer, _sel_removeFromRunLoop_forMode_,
        runLoop.pointer, mode.pointer);
  }

  int get reservedSpaceLength {
    return _objc_msgSend_29(this.pointer, _sel_reservedSpaceLength);
  }

  bool sendBeforeDate_components_from_reserved_(
      objc.NSDate limitDate,
      objc.NSMutableArray? components,
      NSPort? receivePort,
      int headerSpaceReserved) {
    return _objc_msgSend_217(
        this.pointer,
        _sel_sendBeforeDate_components_from_reserved_,
        limitDate.pointer,
        components?.pointer ?? ffi.nullptr,
        receivePort?.pointer ?? ffi.nullptr,
        headerSpaceReserved);
  }

  bool sendBeforeDate_msgid_components_from_reserved_(
      objc.NSDate limitDate,
      int msgID,
      objc.NSMutableArray? components,
      NSPort? receivePort,
      int headerSpaceReserved) {
    return _objc_msgSend_218(
        this.pointer,
        _sel_sendBeforeDate_msgid_components_from_reserved_,
        limitDate.pointer,
        msgID,
        components?.pointer ?? ffi.nullptr,
        receivePort?.pointer ?? ffi.nullptr,
        headerSpaceReserved);
  }

  void addConnection_toRunLoop_forMode_(
      NSConnection conn, NSRunLoop runLoop, objc.NSString mode) {
    _objc_msgSend_243(this.pointer, _sel_addConnection_toRunLoop_forMode_,
        conn.pointer, runLoop.pointer, mode.pointer);
  }

  void removeConnection_fromRunLoop_forMode_(
      NSConnection conn, NSRunLoop runLoop, objc.NSString mode) {
    _objc_msgSend_243(this.pointer, _sel_removeConnection_fromRunLoop_forMode_,
        conn.pointer, runLoop.pointer, mode.pointer);
  }

  @override
  NSPort init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSPort.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPort new1() {
    final _ret = _objc_msgSend_40(_class_NSPort, _sel_new);
    return NSPort.castFromPointer(_ret, retain: false, release: true);
  }

  static NSPort allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSPort, _sel_allocWithZone_, zone);
    return NSPort.castFromPointer(_ret, retain: false, release: true);
  }

  static NSPort alloc() {
    final _ret = _objc_msgSend_40(_class_NSPort, _sel_alloc);
    return NSPort.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSPort,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSPort,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(_class_NSPort, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSPort, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSPort,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(
        _class_NSPort, _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSPort,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSPort, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(_class_NSPort, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSPort = objc.getClass("NSPort");
late final _sel_port = objc.registerName("port");
final _objc_msgSend_214 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setDelegate_ = objc.registerName("setDelegate:");
final _objc_msgSend_215 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_delegate = objc.registerName("delegate");
late final _sel_scheduleInRunLoop_forMode_ =
    objc.registerName("scheduleInRunLoop:forMode:");
final _objc_msgSend_216 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removeFromRunLoop_forMode_ =
    objc.registerName("removeFromRunLoop:forMode:");
late final _sel_reservedSpaceLength = objc.registerName("reservedSpaceLength");
late final _sel_sendBeforeDate_components_from_reserved_ =
    objc.registerName("sendBeforeDate:components:from:reserved:");
final _objc_msgSend_217 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_sendBeforeDate_msgid_components_from_reserved_ =
    objc.registerName("sendBeforeDate:msgid:components:from:reserved:");
final _objc_msgSend_218 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();

class NSConnection extends objc.NSObject {
  NSConnection._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSConnection] that points to the same underlying object as [other].
  NSConnection.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSConnection] that wraps the given raw object pointer.
  NSConnection.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSConnection].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSConnection);
  }

  objc.NSDictionary get statistics {
    final _ret = _objc_msgSend_112(this.pointer, _sel_statistics);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray allConnections() {
    final _ret = _objc_msgSend_6(_class_NSConnection, _sel_allConnections);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static NSConnection defaultConnection() {
    final _ret = _objc_msgSend_219(_class_NSConnection, _sel_defaultConnection);
    return NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static NSConnection? connectionWithRegisteredName_host_(
      objc.NSString name, objc.NSString? hostName) {
    final _ret = _objc_msgSend_220(
        _class_NSConnection,
        _sel_connectionWithRegisteredName_host_,
        name.pointer,
        hostName?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static NSConnection? connectionWithRegisteredName_host_usingNameServer_(
      objc.NSString name, objc.NSString? hostName, NSPortNameServer server) {
    final _ret = _objc_msgSend_225(
        _class_NSConnection,
        _sel_connectionWithRegisteredName_host_usingNameServer_,
        name.pointer,
        hostName?.pointer ?? ffi.nullptr,
        server.pointer);
    return _ret.address == 0
        ? null
        : NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static NSDistantObject? rootProxyForConnectionWithRegisteredName_host_(
      objc.NSString name, objc.NSString? hostName) {
    final _ret = _objc_msgSend_233(
        _class_NSConnection,
        _sel_rootProxyForConnectionWithRegisteredName_host_,
        name.pointer,
        hostName?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSDistantObject.castFromPointer(_ret, retain: true, release: true);
  }

  static NSDistantObject?
      rootProxyForConnectionWithRegisteredName_host_usingNameServer_(
          objc.NSString name,
          objc.NSString? hostName,
          NSPortNameServer server) {
    final _ret = _objc_msgSend_234(
        _class_NSConnection,
        _sel_rootProxyForConnectionWithRegisteredName_host_usingNameServer_,
        name.pointer,
        hostName?.pointer ?? ffi.nullptr,
        server.pointer);
    return _ret.address == 0
        ? null
        : NSDistantObject.castFromPointer(_ret, retain: true, release: true);
  }

  static NSConnection? serviceConnectionWithName_rootObject_usingNameServer_(
      objc.NSString name, objc.NSObject root, NSPortNameServer server) {
    final _ret = _objc_msgSend_235(
        _class_NSConnection,
        _sel_serviceConnectionWithName_rootObject_usingNameServer_,
        name.pointer,
        root.pointer,
        server.pointer);
    return _ret.address == 0
        ? null
        : NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static NSConnection? serviceConnectionWithName_rootObject_(
      objc.NSString name, objc.NSObject root) {
    final _ret = _objc_msgSend_236(_class_NSConnection,
        _sel_serviceConnectionWithName_rootObject_, name.pointer, root.pointer);
    return _ret.address == 0
        ? null
        : NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  double get requestTimeout {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_requestTimeout)
        : _objc_msgSend_115(this.pointer, _sel_requestTimeout);
  }

  set requestTimeout(double value) {
    return _objc_msgSend_212(this.pointer, _sel_setRequestTimeout_, value);
  }

  double get replyTimeout {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_replyTimeout)
        : _objc_msgSend_115(this.pointer, _sel_replyTimeout);
  }

  set replyTimeout(double value) {
    return _objc_msgSend_212(this.pointer, _sel_setReplyTimeout_, value);
  }

  objc.NSObject? get rootObject {
    final _ret = _objc_msgSend_66(this.pointer, _sel_rootObject);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  set rootObject(objc.NSObject? value) {
    return _objc_msgSend_188(
        this.pointer, _sel_setRootObject_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSObject? get delegate {
    final _ret = _objc_msgSend_66(this.pointer, _sel_delegate);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  set delegate(objc.NSObject? value) {
    return _objc_msgSend_188(
        this.pointer, _sel_setDelegate_, value?.pointer ?? ffi.nullptr);
  }

  bool get independentConversationQueueing {
    return _objc_msgSend_7(this.pointer, _sel_independentConversationQueueing);
  }

  set independentConversationQueueing(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setIndependentConversationQueueing_, value);
  }

  bool get valid {
    return _objc_msgSend_7(this.pointer, _sel_isValid);
  }

  NSDistantObject get rootProxy {
    final _ret = _objc_msgSend_237(this.pointer, _sel_rootProxy);
    return NSDistantObject.castFromPointer(_ret, retain: true, release: true);
  }

  void invalidate() {
    _objc_msgSend_82(this.pointer, _sel_invalidate);
  }

  void addRequestMode_(objc.NSString rmode) {
    _objc_msgSend_98(this.pointer, _sel_addRequestMode_, rmode.pointer);
  }

  void removeRequestMode_(objc.NSString rmode) {
    _objc_msgSend_98(this.pointer, _sel_removeRequestMode_, rmode.pointer);
  }

  objc.NSArray get requestModes {
    final _ret = _objc_msgSend_6(this.pointer, _sel_requestModes);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  bool registerName_(objc.NSString? name) {
    return _objc_msgSend_238(
        this.pointer, _sel_registerName_, name?.pointer ?? ffi.nullptr);
  }

  bool registerName_withNameServer_(
      objc.NSString? name, NSPortNameServer server) {
    return _objc_msgSend_239(this.pointer, _sel_registerName_withNameServer_,
        name?.pointer ?? ffi.nullptr, server.pointer);
  }

  static NSConnection? connectionWithReceivePort_sendPort_(
      NSPort? receivePort, NSPort? sendPort) {
    final _ret = _objc_msgSend_240(
        _class_NSConnection,
        _sel_connectionWithReceivePort_sendPort_,
        receivePort?.pointer ?? ffi.nullptr,
        sendPort?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject? currentConversation() {
    final _ret =
        _objc_msgSend_66(_class_NSConnection, _sel_currentConversation);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  NSConnection? initWithReceivePort_sendPort_(
      NSPort? receivePort, NSPort? sendPort) {
    final _ret = _objc_msgSend_240(
        this.pointer,
        _sel_initWithReceivePort_sendPort_,
        receivePort?.pointer ?? ffi.nullptr,
        sendPort?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  NSPort get sendPort {
    final _ret = _objc_msgSend_214(this.pointer, _sel_sendPort);
    return NSPort.castFromPointer(_ret, retain: true, release: true);
  }

  NSPort get receivePort {
    final _ret = _objc_msgSend_214(this.pointer, _sel_receivePort);
    return NSPort.castFromPointer(_ret, retain: true, release: true);
  }

  void enableMultipleThreads() {
    _objc_msgSend_82(this.pointer, _sel_enableMultipleThreads);
  }

  bool get multipleThreadsEnabled {
    return _objc_msgSend_7(this.pointer, _sel_multipleThreadsEnabled);
  }

  void addRunLoop_(NSRunLoop runloop) {
    _objc_msgSend_241(this.pointer, _sel_addRunLoop_, runloop.pointer);
  }

  void removeRunLoop_(NSRunLoop runloop) {
    _objc_msgSend_241(this.pointer, _sel_removeRunLoop_, runloop.pointer);
  }

  void runInNewThread() {
    _objc_msgSend_82(this.pointer, _sel_runInNewThread);
  }

  objc.NSArray get remoteObjects {
    final _ret = _objc_msgSend_6(this.pointer, _sel_remoteObjects);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get localObjects {
    final _ret = _objc_msgSend_6(this.pointer, _sel_localObjects);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  void dispatchWithComponents_(objc.NSArray components) {
    _objc_msgSend_242(
        this.pointer, _sel_dispatchWithComponents_, components.pointer);
  }

  @override
  NSConnection init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static NSConnection new1() {
    final _ret = _objc_msgSend_40(_class_NSConnection, _sel_new);
    return NSConnection.castFromPointer(_ret, retain: false, release: true);
  }

  static NSConnection allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSConnection, _sel_allocWithZone_, zone);
    return NSConnection.castFromPointer(_ret, retain: false, release: true);
  }

  static NSConnection alloc() {
    final _ret = _objc_msgSend_40(_class_NSConnection, _sel_alloc);
    return NSConnection.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSConnection,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSConnection,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSConnection, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSConnection, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSConnection,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSConnection,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSConnection,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSConnection, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSConnection, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSConnection = objc.getClass("NSConnection");
late final _sel_statistics = objc.registerName("statistics");
late final _sel_allConnections = objc.registerName("allConnections");
late final _sel_defaultConnection = objc.registerName("defaultConnection");
final _objc_msgSend_219 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_connectionWithRegisteredName_host_ =
    objc.registerName("connectionWithRegisteredName:host:");
final _objc_msgSend_220 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

class NSPortNameServer extends objc.NSObject {
  NSPortNameServer._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSPortNameServer] that points to the same underlying object as [other].
  NSPortNameServer.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSPortNameServer] that wraps the given raw object pointer.
  NSPortNameServer.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSPortNameServer].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSPortNameServer);
  }

  static NSPortNameServer systemDefaultPortNameServer() {
    final _ret = _objc_msgSend_221(
        _class_NSPortNameServer, _sel_systemDefaultPortNameServer);
    return NSPortNameServer.castFromPointer(_ret, retain: true, release: true);
  }

  NSPort? portForName_(objc.NSString name) {
    final _ret =
        _objc_msgSend_222(this.pointer, _sel_portForName_, name.pointer);
    return _ret.address == 0
        ? null
        : NSPort.castFromPointer(_ret, retain: true, release: true);
  }

  NSPort? portForName_host_(objc.NSString name, objc.NSString? host) {
    final _ret = _objc_msgSend_223(this.pointer, _sel_portForName_host_,
        name.pointer, host?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSPort.castFromPointer(_ret, retain: true, release: true);
  }

  bool registerPort_name_(NSPort port, objc.NSString name) {
    return _objc_msgSend_224(
        this.pointer, _sel_registerPort_name_, port.pointer, name.pointer);
  }

  bool removePortForName_(objc.NSString name) {
    return _objc_msgSend_51(
        this.pointer, _sel_removePortForName_, name.pointer);
  }

  @override
  NSPortNameServer init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSPortNameServer.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPortNameServer new1() {
    final _ret = _objc_msgSend_40(_class_NSPortNameServer, _sel_new);
    return NSPortNameServer.castFromPointer(_ret, retain: false, release: true);
  }

  static NSPortNameServer allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSPortNameServer, _sel_allocWithZone_, zone);
    return NSPortNameServer.castFromPointer(_ret, retain: false, release: true);
  }

  static NSPortNameServer alloc() {
    final _ret = _objc_msgSend_40(_class_NSPortNameServer, _sel_alloc);
    return NSPortNameServer.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSPortNameServer,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSPortNameServer,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSPortNameServer, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSPortNameServer, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSPortNameServer,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSPortNameServer,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSPortNameServer,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSPortNameServer, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSPortNameServer, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSPortNameServer = objc.getClass("NSPortNameServer");
late final _sel_systemDefaultPortNameServer =
    objc.registerName("systemDefaultPortNameServer");
final _objc_msgSend_221 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_portForName_ = objc.registerName("portForName:");
final _objc_msgSend_222 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_portForName_host_ = objc.registerName("portForName:host:");
final _objc_msgSend_223 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_registerPort_name_ = objc.registerName("registerPort:name:");
final _objc_msgSend_224 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removePortForName_ = objc.registerName("removePortForName:");
late final _sel_connectionWithRegisteredName_host_usingNameServer_ =
    objc.registerName("connectionWithRegisteredName:host:usingNameServer:");
final _objc_msgSend_225 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

class NSDistantObject extends NSProxy {
  NSDistantObject._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSDistantObject] that points to the same underlying object as [other].
  NSDistantObject.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSDistantObject] that wraps the given raw object pointer.
  NSDistantObject.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSDistantObject].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSDistantObject);
  }

  static objc.NSObject? proxyWithTarget_connection_(
      objc.NSObject target, NSConnection connection) {
    final _ret = _objc_msgSend_229(_class_NSDistantObject,
        _sel_proxyWithTarget_connection_, target.pointer, connection.pointer);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  NSDistantObject? initWithTarget_connection_(
      objc.NSObject target, NSConnection connection) {
    final _ret = _objc_msgSend_229(this.pointer,
        _sel_initWithTarget_connection_, target.pointer, connection.pointer);
    return _ret.address == 0
        ? null
        : NSDistantObject.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject proxyWithLocal_connection_(
      objc.NSObject target, NSConnection connection) {
    final _ret = _objc_msgSend_230(_class_NSDistantObject,
        _sel_proxyWithLocal_connection_, target.pointer, connection.pointer);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  NSDistantObject initWithLocal_connection_(
      objc.NSObject target, NSConnection connection) {
    final _ret = _objc_msgSend_230(this.pointer, _sel_initWithLocal_connection_,
        target.pointer, connection.pointer);
    return NSDistantObject.castFromPointer(_ret, retain: true, release: true);
  }

  NSDistantObject? initWithCoder_(objc.NSCoder inCoder) {
    final _ret =
        _objc_msgSend_231(this.pointer, _sel_initWithCoder_, inCoder.pointer);
    return _ret.address == 0
        ? null
        : NSDistantObject.castFromPointer(_ret, retain: true, release: true);
  }

  void setProtocolForProxy_(objc.Protocol? proto) {
    _objc_msgSend_232(
        this.pointer, _sel_setProtocolForProxy_, proto?.pointer ?? ffi.nullptr);
  }

  NSConnection get connectionForProxy {
    final _ret = _objc_msgSend_219(this.pointer, _sel_connectionForProxy);
    return NSConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject alloc() {
    final _ret = _objc_msgSend_40(_class_NSDistantObject, _sel_alloc);
    return objc.NSObject.castFromPointer(_ret, retain: false, release: true);
  }

  static bool respondsToSelector_(ffi.Pointer<objc.ObjCSelector> aSelector) {
    return _objc_msgSend_228(
        _class_NSDistantObject, _sel_respondsToSelector_, aSelector);
  }
}

late final _class_NSDistantObject = objc.getClass("NSDistantObject");

class NSProxy extends objc.ObjCObjectBase {
  NSProxy._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSProxy] that points to the same underlying object as [other].
  NSProxy.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSProxy] that wraps the given raw object pointer.
  NSProxy.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSProxy].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSProxy);
  }

  static objc.NSObject alloc() {
    final _ret = _objc_msgSend_40(_class_NSProxy, _sel_alloc);
    return objc.NSObject.castFromPointer(_ret, retain: false, release: true);
  }

  static objc.NSObject allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSProxy, _sel_allocWithZone_, zone);
    return objc.NSObject.castFromPointer(_ret, retain: false, release: true);
  }

  static objc.NSObject class1() {
    final _ret = _objc_msgSend_40(_class_NSProxy, _sel_class);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  void forwardInvocation_(objc.NSInvocation invocation) {
    _objc_msgSend_226(
        this.pointer, _sel_forwardInvocation_, invocation.pointer);
  }

  objc.NSMethodSignature? methodSignatureForSelector_(
      ffi.Pointer<objc.ObjCSelector> sel) {
    final _ret =
        _objc_msgSend_227(this.pointer, _sel_methodSignatureForSelector_, sel);
    return _ret.address == 0
        ? null
        : objc.NSMethodSignature.castFromPointer(_ret,
            retain: true, release: true);
  }

  void dealloc() {
    _objc_msgSend_82(this.pointer, _sel_dealloc);
  }

  void finalize() {
    _objc_msgSend_82(this.pointer, _sel_finalize);
  }

  objc.NSString get description {
    final _ret = _objc_msgSend_12(this.pointer, _sel_description);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get debugDescription {
    final _ret = _objc_msgSend_12(this.pointer, _sel_debugDescription);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static bool respondsToSelector_(ffi.Pointer<objc.ObjCSelector> aSelector) {
    return _objc_msgSend_228(
        _class_NSProxy, _sel_respondsToSelector_, aSelector);
  }

  bool allowsWeakReference() {
    return _objc_msgSend_7(this.pointer, _sel_allowsWeakReference);
  }

  bool retainWeakReference() {
    return _objc_msgSend_7(this.pointer, _sel_retainWeakReference);
  }
}

late final _class_NSProxy = objc.getClass("NSProxy");
late final _sel_class = objc.registerName("class");
late final _sel_forwardInvocation_ = objc.registerName("forwardInvocation:");
final _objc_msgSend_226 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_methodSignatureForSelector_ =
    objc.registerName("methodSignatureForSelector:");
final _objc_msgSend_227 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_dealloc = objc.registerName("dealloc");
late final _sel_finalize = objc.registerName("finalize");
late final _sel_debugDescription = objc.registerName("debugDescription");
late final _sel_respondsToSelector_ = objc.registerName("respondsToSelector:");
final _objc_msgSend_228 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_allowsWeakReference = objc.registerName("allowsWeakReference");
late final _sel_retainWeakReference = objc.registerName("retainWeakReference");
late final _sel_proxyWithTarget_connection_ =
    objc.registerName("proxyWithTarget:connection:");
final _objc_msgSend_229 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithTarget_connection_ =
    objc.registerName("initWithTarget:connection:");
late final _sel_proxyWithLocal_connection_ =
    objc.registerName("proxyWithLocal:connection:");
final _objc_msgSend_230 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithLocal_connection_ =
    objc.registerName("initWithLocal:connection:");
late final _sel_initWithCoder_ = objc.registerName("initWithCoder:");
final _objc_msgSend_231 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_setProtocolForProxy_ =
    objc.registerName("setProtocolForProxy:");
final _objc_msgSend_232 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_connectionForProxy = objc.registerName("connectionForProxy");
late final _sel_rootProxyForConnectionWithRegisteredName_host_ =
    objc.registerName("rootProxyForConnectionWithRegisteredName:host:");
final _objc_msgSend_233 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_rootProxyForConnectionWithRegisteredName_host_usingNameServer_ =
    objc.registerName(
        "rootProxyForConnectionWithRegisteredName:host:usingNameServer:");
final _objc_msgSend_234 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_serviceConnectionWithName_rootObject_usingNameServer_ =
    objc.registerName("serviceConnectionWithName:rootObject:usingNameServer:");
final _objc_msgSend_235 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_serviceConnectionWithName_rootObject_ =
    objc.registerName("serviceConnectionWithName:rootObject:");
final _objc_msgSend_236 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_requestTimeout = objc.registerName("requestTimeout");
late final _sel_setRequestTimeout_ = objc.registerName("setRequestTimeout:");
late final _sel_replyTimeout = objc.registerName("replyTimeout");
late final _sel_setReplyTimeout_ = objc.registerName("setReplyTimeout:");
late final _sel_rootObject = objc.registerName("rootObject");
late final _sel_setRootObject_ = objc.registerName("setRootObject:");
late final _sel_independentConversationQueueing =
    objc.registerName("independentConversationQueueing");
late final _sel_setIndependentConversationQueueing_ =
    objc.registerName("setIndependentConversationQueueing:");
late final _sel_rootProxy = objc.registerName("rootProxy");
final _objc_msgSend_237 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_addRequestMode_ = objc.registerName("addRequestMode:");
late final _sel_removeRequestMode_ = objc.registerName("removeRequestMode:");
late final _sel_requestModes = objc.registerName("requestModes");
late final _sel_registerName_ = objc.registerName("registerName:");
final _objc_msgSend_238 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_registerName_withNameServer_ =
    objc.registerName("registerName:withNameServer:");
final _objc_msgSend_239 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_connectionWithReceivePort_sendPort_ =
    objc.registerName("connectionWithReceivePort:sendPort:");
final _objc_msgSend_240 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_currentConversation = objc.registerName("currentConversation");
late final _sel_initWithReceivePort_sendPort_ =
    objc.registerName("initWithReceivePort:sendPort:");
late final _sel_sendPort = objc.registerName("sendPort");
late final _sel_receivePort = objc.registerName("receivePort");
late final _sel_enableMultipleThreads =
    objc.registerName("enableMultipleThreads");
late final _sel_multipleThreadsEnabled =
    objc.registerName("multipleThreadsEnabled");
late final _sel_addRunLoop_ = objc.registerName("addRunLoop:");
final _objc_msgSend_241 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removeRunLoop_ = objc.registerName("removeRunLoop:");
late final _sel_runInNewThread = objc.registerName("runInNewThread");
late final _sel_remoteObjects = objc.registerName("remoteObjects");
late final _sel_localObjects = objc.registerName("localObjects");
late final _sel_dispatchWithComponents_ =
    objc.registerName("dispatchWithComponents:");
final _objc_msgSend_242 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_addConnection_toRunLoop_forMode_ =
    objc.registerName("addConnection:toRunLoop:forMode:");
final _objc_msgSend_243 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removeConnection_fromRunLoop_forMode_ =
    objc.registerName("removeConnection:fromRunLoop:forMode:");
late final _sel_addPort_forMode_ = objc.registerName("addPort:forMode:");
final _objc_msgSend_244 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removePort_forMode_ = objc.registerName("removePort:forMode:");
late final _sel_limitDateForMode_ = objc.registerName("limitDateForMode:");
late final _sel_acceptInputForMode_beforeDate_ =
    objc.registerName("acceptInputForMode:beforeDate:");
final _objc_msgSend_245 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_run = objc.registerName("run");
late final _sel_runUntilDate_ = objc.registerName("runUntilDate:");
final _objc_msgSend_246 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_runMode_beforeDate_ = objc.registerName("runMode:beforeDate:");
final _objc_msgSend_247 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_configureAsServer = objc.registerName("configureAsServer");
void _ObjCBlock_ffiVoid_fnPtrTrampoline(
  ffi.Pointer<objc.ObjCBlock> block,
) =>
    block.ref.target
        .cast<ffi.NativeFunction<ffi.Void Function()>>()
        .asFunction<void Function()>()();
final _ObjCBlock_ffiVoid_closureRegistry = <int, void Function()>{};
int _ObjCBlock_ffiVoid_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_registerClosure(void Function() fn) {
  final id = ++_ObjCBlock_ffiVoid_closureRegistryIndex;
  _ObjCBlock_ffiVoid_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_closureTrampoline(
  ffi.Pointer<objc.ObjCBlock> block,
) =>
    _ObjCBlock_ffiVoid_closureRegistry[block.ref.target.address]!();

class ObjCBlock_ffiVoid extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid castFromPointer(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = false}) {
    return ObjCBlock_ffiVoid._(pointer, retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid.fromFunctionPointer(
      ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>> ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>)>(
                    _ObjCBlock_ffiVoid_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid.fromFunction(void Function() fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>)>(
                    _ObjCBlock_ffiVoid_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_registerClosure(() => fn())));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid.listener(void Function() fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>)>.listener(
                    _ObjCBlock_ffiVoid_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_registerClosure(() => fn())));
  static ffi.NativeCallable<ffi.Void Function(ffi.Pointer<objc.ObjCBlock>)>?
      _dartFuncListenerTrampoline;

  void call() => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCBlock> block)>>()
          .asFunction<void Function(ffi.Pointer<objc.ObjCBlock>)>()(
        pointer,
      );
}

late final _sel_performInModes_block_ =
    objc.registerName("performInModes:block:");
final _objc_msgSend_248 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_performBlock_ = objc.registerName("performBlock:");
final _objc_msgSend_249 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_performSelector_target_argument_order_modes_ =
    objc.registerName("performSelector:target:argument:order:modes:");
final _objc_msgSend_250 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_cancelPerformSelector_target_argument_ =
    objc.registerName("cancelPerformSelector:target:argument:");
final _objc_msgSend_251 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_cancelPerformSelectorsWithTarget_ =
    objc.registerName("cancelPerformSelectorsWithTarget:");

class NSFileHandle extends objc.NSObject {
  NSFileHandle._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSFileHandle] that points to the same underlying object as [other].
  NSFileHandle.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSFileHandle] that wraps the given raw object pointer.
  NSFileHandle.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSFileHandle].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSFileHandle);
  }

  objc.NSData get availableData {
    final _ret = _objc_msgSend_104(this.pointer, _sel_availableData);
    return objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  NSFileHandle initWithFileDescriptor_closeOnDealloc_(int fd, bool closeopt) {
    final _ret = _objc_msgSend_252(this.pointer,
        _sel_initWithFileDescriptor_closeOnDealloc_, fd, closeopt);
    return NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  NSFileHandle? initWithCoder_(objc.NSCoder coder) {
    final _ret =
        _objc_msgSend_231(this.pointer, _sel_initWithCoder_, coder.pointer);
    return _ret.address == 0
        ? null
        : NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSData? readDataToEndOfFileAndReturnError_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_253(
        this.pointer, _sel_readDataToEndOfFileAndReturnError_, error);
    return _ret.address == 0
        ? null
        : objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSData? readDataUpToLength_error_(
      int length, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_254(
        this.pointer, _sel_readDataUpToLength_error_, length, error);
    return _ret.address == 0
        ? null
        : objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  bool writeData_error_(
      objc.NSData data, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_255(
        this.pointer, _sel_writeData_error_, data.pointer, error);
  }

  bool getOffset_error_(ffi.Pointer<ffi.UnsignedLongLong> offsetInFile,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_256(
        this.pointer, _sel_getOffset_error_, offsetInFile, error);
  }

  bool seekToEndReturningOffset_error_(
      ffi.Pointer<ffi.UnsignedLongLong> offsetInFile,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_256(this.pointer, _sel_seekToEndReturningOffset_error_,
        offsetInFile, error);
  }

  bool seekToOffset_error_(
      int offset, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_257(
        this.pointer, _sel_seekToOffset_error_, offset, error);
  }

  bool truncateAtOffset_error_(
      int offset, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_257(
        this.pointer, _sel_truncateAtOffset_error_, offset, error);
  }

  bool synchronizeAndReturnError_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_8(
        this.pointer, _sel_synchronizeAndReturnError_, error);
  }

  bool closeAndReturnError_(ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_8(this.pointer, _sel_closeAndReturnError_, error);
  }

  static NSFileHandle getFileHandleWithStandardInput() {
    final _ret = _objc_msgSend_258(
        _class_NSFileHandle, _sel_fileHandleWithStandardInput);
    return NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle getFileHandleWithStandardOutput() {
    final _ret = _objc_msgSend_258(
        _class_NSFileHandle, _sel_fileHandleWithStandardOutput);
    return NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle getFileHandleWithStandardError() {
    final _ret = _objc_msgSend_258(
        _class_NSFileHandle, _sel_fileHandleWithStandardError);
    return NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle getFileHandleWithNullDevice() {
    final _ret =
        _objc_msgSend_258(_class_NSFileHandle, _sel_fileHandleWithNullDevice);
    return NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle? fileHandleForReadingAtPath_(objc.NSString path) {
    final _ret = _objc_msgSend_2(
        _class_NSFileHandle, _sel_fileHandleForReadingAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle? fileHandleForWritingAtPath_(objc.NSString path) {
    final _ret = _objc_msgSend_2(
        _class_NSFileHandle, _sel_fileHandleForWritingAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle? fileHandleForUpdatingAtPath_(objc.NSString path) {
    final _ret = _objc_msgSend_2(
        _class_NSFileHandle, _sel_fileHandleForUpdatingAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle? fileHandleForReadingFromURL_error_(
      objc.NSURL url, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_259(_class_NSFileHandle,
        _sel_fileHandleForReadingFromURL_error_, url.pointer, error);
    return _ret.address == 0
        ? null
        : NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle? fileHandleForWritingToURL_error_(
      objc.NSURL url, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_259(_class_NSFileHandle,
        _sel_fileHandleForWritingToURL_error_, url.pointer, error);
    return _ret.address == 0
        ? null
        : NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle? fileHandleForUpdatingURL_error_(
      objc.NSURL url, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_259(_class_NSFileHandle,
        _sel_fileHandleForUpdatingURL_error_, url.pointer, error);
    return _ret.address == 0
        ? null
        : NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  void readInBackgroundAndNotifyForModes_(objc.NSArray? modes) {
    _objc_msgSend_260(this.pointer, _sel_readInBackgroundAndNotifyForModes_,
        modes?.pointer ?? ffi.nullptr);
  }

  void readInBackgroundAndNotify() {
    _objc_msgSend_82(this.pointer, _sel_readInBackgroundAndNotify);
  }

  void readToEndOfFileInBackgroundAndNotifyForModes_(objc.NSArray? modes) {
    _objc_msgSend_260(
        this.pointer,
        _sel_readToEndOfFileInBackgroundAndNotifyForModes_,
        modes?.pointer ?? ffi.nullptr);
  }

  void readToEndOfFileInBackgroundAndNotify() {
    _objc_msgSend_82(this.pointer, _sel_readToEndOfFileInBackgroundAndNotify);
  }

  void acceptConnectionInBackgroundAndNotifyForModes_(objc.NSArray? modes) {
    _objc_msgSend_260(
        this.pointer,
        _sel_acceptConnectionInBackgroundAndNotifyForModes_,
        modes?.pointer ?? ffi.nullptr);
  }

  void acceptConnectionInBackgroundAndNotify() {
    _objc_msgSend_82(this.pointer, _sel_acceptConnectionInBackgroundAndNotify);
  }

  void waitForDataInBackgroundAndNotifyForModes_(objc.NSArray? modes) {
    _objc_msgSend_260(
        this.pointer,
        _sel_waitForDataInBackgroundAndNotifyForModes_,
        modes?.pointer ?? ffi.nullptr);
  }

  void waitForDataInBackgroundAndNotify() {
    _objc_msgSend_82(this.pointer, _sel_waitForDataInBackgroundAndNotify);
  }

  ObjCBlock_ffiVoid_NSFileHandle? get readabilityHandler {
    final _ret = _objc_msgSend_261(this.pointer, _sel_readabilityHandler);
    return _ret.address == 0
        ? null
        : ObjCBlock_ffiVoid_NSFileHandle.castFromPointer(_ret,
            retain: true, release: true);
  }

  set readabilityHandler(ObjCBlock_ffiVoid_NSFileHandle? value) {
    return _objc_msgSend_262(this.pointer, _sel_setReadabilityHandler_,
        value?.pointer ?? ffi.nullptr);
  }

  ObjCBlock_ffiVoid_NSFileHandle? get writeabilityHandler {
    final _ret = _objc_msgSend_261(this.pointer, _sel_writeabilityHandler);
    return _ret.address == 0
        ? null
        : ObjCBlock_ffiVoid_NSFileHandle.castFromPointer(_ret,
            retain: true, release: true);
  }

  set writeabilityHandler(ObjCBlock_ffiVoid_NSFileHandle? value) {
    return _objc_msgSend_262(this.pointer, _sel_setWriteabilityHandler_,
        value?.pointer ?? ffi.nullptr);
  }

  NSFileHandle initWithFileDescriptor_(int fd) {
    final _ret =
        _objc_msgSend_263(this.pointer, _sel_initWithFileDescriptor_, fd);
    return NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  int get fileDescriptor {
    return _objc_msgSend_264(this.pointer, _sel_fileDescriptor);
  }

  objc.NSData readDataToEndOfFile() {
    final _ret = _objc_msgSend_104(this.pointer, _sel_readDataToEndOfFile);
    return objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSData readDataOfLength_(int length) {
    final _ret =
        _objc_msgSend_265(this.pointer, _sel_readDataOfLength_, length);
    return objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  void writeData_(objc.NSData data) {
    _objc_msgSend_266(this.pointer, _sel_writeData_, data.pointer);
  }

  int get offsetInFile {
    return _objc_msgSend_267(this.pointer, _sel_offsetInFile);
  }

  int seekToEndOfFile() {
    return _objc_msgSend_267(this.pointer, _sel_seekToEndOfFile);
  }

  void seekToFileOffset_(int offset) {
    _objc_msgSend_268(this.pointer, _sel_seekToFileOffset_, offset);
  }

  void truncateFileAtOffset_(int offset) {
    _objc_msgSend_268(this.pointer, _sel_truncateFileAtOffset_, offset);
  }

  void synchronizeFile() {
    _objc_msgSend_82(this.pointer, _sel_synchronizeFile);
  }

  void closeFile() {
    _objc_msgSend_82(this.pointer, _sel_closeFile);
  }

  @override
  NSFileHandle init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSFileHandle.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileHandle new1() {
    final _ret = _objc_msgSend_40(_class_NSFileHandle, _sel_new);
    return NSFileHandle.castFromPointer(_ret, retain: false, release: true);
  }

  static NSFileHandle allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSFileHandle, _sel_allocWithZone_, zone);
    return NSFileHandle.castFromPointer(_ret, retain: false, release: true);
  }

  static NSFileHandle alloc() {
    final _ret = _objc_msgSend_40(_class_NSFileHandle, _sel_alloc);
    return NSFileHandle.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSFileHandle,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSFileHandle,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSFileHandle, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSFileHandle, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSFileHandle,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSFileHandle,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSFileHandle,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSFileHandle, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSFileHandle, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSFileHandle = objc.getClass("NSFileHandle");
late final _sel_availableData = objc.registerName("availableData");
late final _sel_initWithFileDescriptor_closeOnDealloc_ =
    objc.registerName("initWithFileDescriptor:closeOnDealloc:");
final _objc_msgSend_252 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int, ffi.Bool)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, bool)>();
late final _sel_readDataToEndOfFileAndReturnError_ =
    objc.registerName("readDataToEndOfFileAndReturnError:");
final _objc_msgSend_253 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_readDataUpToLength_error_ =
    objc.registerName("readDataUpToLength:error:");
final _objc_msgSend_254 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_writeData_error_ = objc.registerName("writeData:error:");
final _objc_msgSend_255 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_getOffset_error_ = objc.registerName("getOffset:error:");
final _objc_msgSend_256 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedLongLong>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedLongLong>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_seekToEndReturningOffset_error_ =
    objc.registerName("seekToEndReturningOffset:error:");
late final _sel_seekToOffset_error_ = objc.registerName("seekToOffset:error:");
final _objc_msgSend_257 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLongLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_truncateAtOffset_error_ =
    objc.registerName("truncateAtOffset:error:");
late final _sel_synchronizeAndReturnError_ =
    objc.registerName("synchronizeAndReturnError:");
late final _sel_closeAndReturnError_ =
    objc.registerName("closeAndReturnError:");
late final _sel_fileHandleWithStandardInput =
    objc.registerName("fileHandleWithStandardInput");
final _objc_msgSend_258 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_fileHandleWithStandardOutput =
    objc.registerName("fileHandleWithStandardOutput");
late final _sel_fileHandleWithStandardError =
    objc.registerName("fileHandleWithStandardError");
late final _sel_fileHandleWithNullDevice =
    objc.registerName("fileHandleWithNullDevice");
late final _sel_fileHandleForReadingAtPath_ =
    objc.registerName("fileHandleForReadingAtPath:");
late final _sel_fileHandleForWritingAtPath_ =
    objc.registerName("fileHandleForWritingAtPath:");
late final _sel_fileHandleForUpdatingAtPath_ =
    objc.registerName("fileHandleForUpdatingAtPath:");
late final _sel_fileHandleForReadingFromURL_error_ =
    objc.registerName("fileHandleForReadingFromURL:error:");
final _objc_msgSend_259 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_fileHandleForWritingToURL_error_ =
    objc.registerName("fileHandleForWritingToURL:error:");
late final _sel_fileHandleForUpdatingURL_error_ =
    objc.registerName("fileHandleForUpdatingURL:error:");
late final _sel_readInBackgroundAndNotifyForModes_ =
    objc.registerName("readInBackgroundAndNotifyForModes:");
final _objc_msgSend_260 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_readInBackgroundAndNotify =
    objc.registerName("readInBackgroundAndNotify");
late final _sel_readToEndOfFileInBackgroundAndNotifyForModes_ =
    objc.registerName("readToEndOfFileInBackgroundAndNotifyForModes:");
late final _sel_readToEndOfFileInBackgroundAndNotify =
    objc.registerName("readToEndOfFileInBackgroundAndNotify");
late final _sel_acceptConnectionInBackgroundAndNotifyForModes_ =
    objc.registerName("acceptConnectionInBackgroundAndNotifyForModes:");
late final _sel_acceptConnectionInBackgroundAndNotify =
    objc.registerName("acceptConnectionInBackgroundAndNotify");
late final _sel_waitForDataInBackgroundAndNotifyForModes_ =
    objc.registerName("waitForDataInBackgroundAndNotifyForModes:");
late final _sel_waitForDataInBackgroundAndNotify =
    objc.registerName("waitForDataInBackgroundAndNotify");
void _ObjCBlock_ffiVoid_NSFileHandle_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>()
        .asFunction<void Function(ffi.Pointer<objc.ObjCObject>)>()(arg0);
final _ObjCBlock_ffiVoid_NSFileHandle_closureRegistry =
    <int, void Function(ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_ffiVoid_NSFileHandle_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_NSFileHandle_registerClosure(
    void Function(ffi.Pointer<objc.ObjCObject>) fn) {
  final id = ++_ObjCBlock_ffiVoid_NSFileHandle_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSFileHandle_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSFileHandle_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    _ObjCBlock_ffiVoid_NSFileHandle_closureRegistry[block.ref.target.address]!(
        arg0);

class ObjCBlock_ffiVoid_NSFileHandle extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSFileHandle._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSFileHandle castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSFileHandle._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSFileHandle.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSFileHandle_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSFileHandle.fromFunction(void Function(NSFileHandle) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSFileHandle_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_NSFileHandle_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(
                    NSFileHandle.castFromPointer(arg0,
                        retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSFileHandle.listener(void Function(NSFileHandle) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>.listener(
                    _ObjCBlock_ffiVoid_NSFileHandle_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSFileHandle_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(
                    NSFileHandle.castFromPointer(arg0,
                        retain: true, release: true)))));
  static ffi.NativeCallable<
          ffi.Void Function(
              ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>?
      _dartFuncListenerTrampoline;

  void call(NSFileHandle arg0) => pointer.ref.invoke
      .cast<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<objc.ObjCBlock> block,
                  ffi.Pointer<objc.ObjCObject> arg0)>>()
      .asFunction<
          void Function(ffi.Pointer<objc.ObjCBlock>,
              ffi.Pointer<objc.ObjCObject>)>()(pointer, arg0.pointer);
}

late final _sel_readabilityHandler = objc.registerName("readabilityHandler");
final _objc_msgSend_261 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCBlock> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCBlock> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setReadabilityHandler_ =
    objc.registerName("setReadabilityHandler:");
final _objc_msgSend_262 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_writeabilityHandler = objc.registerName("writeabilityHandler");
late final _sel_setWriteabilityHandler_ =
    objc.registerName("setWriteabilityHandler:");
late final _sel_initWithFileDescriptor_ =
    objc.registerName("initWithFileDescriptor:");
final _objc_msgSend_263 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_fileDescriptor = objc.registerName("fileDescriptor");
final _objc_msgSend_264 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_readDataToEndOfFile = objc.registerName("readDataToEndOfFile");
late final _sel_readDataOfLength_ = objc.registerName("readDataOfLength:");
final _objc_msgSend_265 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_writeData_ = objc.registerName("writeData:");
final _objc_msgSend_266 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_offsetInFile = objc.registerName("offsetInFile");
final _objc_msgSend_267 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLongLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_seekToEndOfFile = objc.registerName("seekToEndOfFile");
late final _sel_seekToFileOffset_ = objc.registerName("seekToFileOffset:");
final _objc_msgSend_268 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLongLong)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_truncateFileAtOffset_ =
    objc.registerName("truncateFileAtOffset:");
late final _sel_synchronizeFile = objc.registerName("synchronizeFile");
late final _sel_closeFile = objc.registerName("closeFile");

abstract class NSURLBookmarkCreationOptions {
  static const int NSURLBookmarkCreationPreferFileIDResolution = 256;
  static const int NSURLBookmarkCreationMinimalBookmark = 512;
  static const int NSURLBookmarkCreationSuitableForBookmarkFile = 1024;
  static const int NSURLBookmarkCreationWithSecurityScope = 2048;
  static const int NSURLBookmarkCreationSecurityScopeAllowOnlyReadAccess = 4096;
  static const int NSURLBookmarkCreationWithoutImplicitSecurityScope =
      536870912;
}

abstract class NSURLBookmarkResolutionOptions {
  static const int NSURLBookmarkResolutionWithoutUI = 256;
  static const int NSURLBookmarkResolutionWithoutMounting = 512;
  static const int NSURLBookmarkResolutionWithSecurityScope = 1024;
  static const int NSURLBookmarkResolutionWithoutImplicitStartAccessing = 32768;
}

class NSFileManager extends objc.NSObject {
  NSFileManager._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSFileManager] that points to the same underlying object as [other].
  NSFileManager.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSFileManager] that wraps the given raw object pointer.
  NSFileManager.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSFileManager].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSFileManager);
  }

  static NSFileManager getDefaultManager() {
    final _ret = _objc_msgSend_269(_class_NSFileManager, _sel_defaultManager);
    return NSFileManager.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? mountedVolumeURLsIncludingResourceValuesForKeys_options_(
      objc.NSArray? propertyKeys, int options) {
    final _ret = _objc_msgSend_270(
        this.pointer,
        _sel_mountedVolumeURLsIncludingResourceValuesForKeys_options_,
        propertyKeys?.pointer ?? ffi.nullptr,
        options);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  void unmountVolumeAtURL_options_completionHandler_(
      objc.NSURL url, int mask, ObjCBlock_ffiVoid_NSError completionHandler) {
    _objc_msgSend_271(
        this.pointer,
        _sel_unmountVolumeAtURL_options_completionHandler_,
        url.pointer,
        mask,
        completionHandler.pointer);
  }

  objc.NSArray?
      contentsOfDirectoryAtURL_includingPropertiesForKeys_options_error_(
          objc.NSURL url,
          objc.NSArray? keys,
          int mask,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_272(
        this.pointer,
        _sel_contentsOfDirectoryAtURL_includingPropertiesForKeys_options_error_,
        url.pointer,
        keys?.pointer ?? ffi.nullptr,
        mask,
        error);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray URLsForDirectory_inDomains_(int directory, int domainMask) {
    final _ret = _objc_msgSend_273(
        this.pointer, _sel_URLsForDirectory_inDomains_, directory, domainMask);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? URLForDirectory_inDomain_appropriateForURL_create_error_(
      int directory,
      int domain,
      objc.NSURL? url,
      bool shouldCreate,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_274(
        this.pointer,
        _sel_URLForDirectory_inDomain_appropriateForURL_create_error_,
        directory,
        domain,
        url?.pointer ?? ffi.nullptr,
        shouldCreate,
        error);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  bool getRelationship_ofDirectoryAtURL_toItemAtURL_error_(
      ffi.Pointer<ffi.Int32> outRelationship,
      objc.NSURL directoryURL,
      objc.NSURL otherURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_275(
        this.pointer,
        _sel_getRelationship_ofDirectoryAtURL_toItemAtURL_error_,
        outRelationship,
        directoryURL.pointer,
        otherURL.pointer,
        error);
  }

  bool getRelationship_ofDirectory_inDomain_toItemAtURL_error_(
      ffi.Pointer<ffi.Int32> outRelationship,
      int directory,
      int domainMask,
      objc.NSURL url,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_276(
        this.pointer,
        _sel_getRelationship_ofDirectory_inDomain_toItemAtURL_error_,
        outRelationship,
        directory,
        domainMask,
        url.pointer,
        error);
  }

  bool createDirectoryAtURL_withIntermediateDirectories_attributes_error_(
      objc.NSURL url,
      bool createIntermediates,
      objc.NSDictionary? attributes,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_277(
        this.pointer,
        _sel_createDirectoryAtURL_withIntermediateDirectories_attributes_error_,
        url.pointer,
        createIntermediates,
        attributes?.pointer ?? ffi.nullptr,
        error);
  }

  bool createSymbolicLinkAtURL_withDestinationURL_error_(objc.NSURL url,
      objc.NSURL destURL, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_278(
        this.pointer,
        _sel_createSymbolicLinkAtURL_withDestinationURL_error_,
        url.pointer,
        destURL.pointer,
        error);
  }

  objc.NSObject? get delegate {
    final _ret = _objc_msgSend_66(this.pointer, _sel_delegate);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  set delegate(objc.NSObject? value) {
    return _objc_msgSend_188(
        this.pointer, _sel_setDelegate_, value?.pointer ?? ffi.nullptr);
  }

  bool setAttributes_ofItemAtPath_error_(objc.NSDictionary attributes,
      objc.NSString path, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_279(
        this.pointer,
        _sel_setAttributes_ofItemAtPath_error_,
        attributes.pointer,
        path.pointer,
        error);
  }

  bool createDirectoryAtPath_withIntermediateDirectories_attributes_error_(
      objc.NSString path,
      bool createIntermediates,
      objc.NSDictionary? attributes,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_280(
        this.pointer,
        _sel_createDirectoryAtPath_withIntermediateDirectories_attributes_error_,
        path.pointer,
        createIntermediates,
        attributes?.pointer ?? ffi.nullptr,
        error);
  }

  objc.NSArray? contentsOfDirectoryAtPath_error_(
      objc.NSString path, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_281(this.pointer,
        _sel_contentsOfDirectoryAtPath_error_, path.pointer, error);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? subpathsOfDirectoryAtPath_error_(
      objc.NSString path, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_281(this.pointer,
        _sel_subpathsOfDirectoryAtPath_error_, path.pointer, error);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? attributesOfItemAtPath_error_(
      objc.NSString path, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_282(
        this.pointer, _sel_attributesOfItemAtPath_error_, path.pointer, error);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? attributesOfFileSystemForPath_error_(
      objc.NSString path, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_282(this.pointer,
        _sel_attributesOfFileSystemForPath_error_, path.pointer, error);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  bool createSymbolicLinkAtPath_withDestinationPath_error_(objc.NSString path,
      objc.NSString destPath, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_283(
        this.pointer,
        _sel_createSymbolicLinkAtPath_withDestinationPath_error_,
        path.pointer,
        destPath.pointer,
        error);
  }

  objc.NSString? destinationOfSymbolicLinkAtPath_error_(
      objc.NSString path, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_284(this.pointer,
        _sel_destinationOfSymbolicLinkAtPath_error_, path.pointer, error);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool copyItemAtPath_toPath_error_(objc.NSString srcPath,
      objc.NSString dstPath, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_283(this.pointer, _sel_copyItemAtPath_toPath_error_,
        srcPath.pointer, dstPath.pointer, error);
  }

  bool moveItemAtPath_toPath_error_(objc.NSString srcPath,
      objc.NSString dstPath, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_283(this.pointer, _sel_moveItemAtPath_toPath_error_,
        srcPath.pointer, dstPath.pointer, error);
  }

  bool linkItemAtPath_toPath_error_(objc.NSString srcPath,
      objc.NSString dstPath, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_283(this.pointer, _sel_linkItemAtPath_toPath_error_,
        srcPath.pointer, dstPath.pointer, error);
  }

  bool removeItemAtPath_error_(
      objc.NSString path, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_285(
        this.pointer, _sel_removeItemAtPath_error_, path.pointer, error);
  }

  bool copyItemAtURL_toURL_error_(objc.NSURL srcURL, objc.NSURL dstURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_278(this.pointer, _sel_copyItemAtURL_toURL_error_,
        srcURL.pointer, dstURL.pointer, error);
  }

  bool moveItemAtURL_toURL_error_(objc.NSURL srcURL, objc.NSURL dstURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_278(this.pointer, _sel_moveItemAtURL_toURL_error_,
        srcURL.pointer, dstURL.pointer, error);
  }

  bool linkItemAtURL_toURL_error_(objc.NSURL srcURL, objc.NSURL dstURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_278(this.pointer, _sel_linkItemAtURL_toURL_error_,
        srcURL.pointer, dstURL.pointer, error);
  }

  bool removeItemAtURL_error_(
      objc.NSURL URL, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_286(
        this.pointer, _sel_removeItemAtURL_error_, URL.pointer, error);
  }

  bool trashItemAtURL_resultingItemURL_error_(
      objc.NSURL url,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outResultingURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_287(
        this.pointer,
        _sel_trashItemAtURL_resultingItemURL_error_,
        url.pointer,
        outResultingURL,
        error);
  }

  objc.NSDictionary? fileAttributesAtPath_traverseLink_(
      objc.NSString path, bool yorn) {
    final _ret = _objc_msgSend_288(this.pointer,
        _sel_fileAttributesAtPath_traverseLink_, path.pointer, yorn);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  bool changeFileAttributes_atPath_(
      objc.NSDictionary attributes, objc.NSString path) {
    return _objc_msgSend_289(this.pointer, _sel_changeFileAttributes_atPath_,
        attributes.pointer, path.pointer);
  }

  objc.NSArray? directoryContentsAtPath_(objc.NSString path) {
    final _ret = _objc_msgSend_290(
        this.pointer, _sel_directoryContentsAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? fileSystemAttributesAtPath_(objc.NSString path) {
    final _ret = _objc_msgSend_291(
        this.pointer, _sel_fileSystemAttributesAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? pathContentOfSymbolicLinkAtPath_(objc.NSString path) {
    final _ret = _objc_msgSend_14(
        this.pointer, _sel_pathContentOfSymbolicLinkAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool createSymbolicLinkAtPath_pathContent_(
      objc.NSString path, objc.NSString otherpath) {
    return _objc_msgSend_292(
        this.pointer,
        _sel_createSymbolicLinkAtPath_pathContent_,
        path.pointer,
        otherpath.pointer);
  }

  bool createDirectoryAtPath_attributes_(
      objc.NSString path, objc.NSDictionary attributes) {
    return _objc_msgSend_293(
        this.pointer,
        _sel_createDirectoryAtPath_attributes_,
        path.pointer,
        attributes.pointer);
  }

  bool linkPath_toPath_handler_(
      objc.NSString src, objc.NSString dest, objc.NSObject? handler) {
    return _objc_msgSend_294(this.pointer, _sel_linkPath_toPath_handler_,
        src.pointer, dest.pointer, handler?.pointer ?? ffi.nullptr);
  }

  bool copyPath_toPath_handler_(
      objc.NSString src, objc.NSString dest, objc.NSObject? handler) {
    return _objc_msgSend_294(this.pointer, _sel_copyPath_toPath_handler_,
        src.pointer, dest.pointer, handler?.pointer ?? ffi.nullptr);
  }

  bool movePath_toPath_handler_(
      objc.NSString src, objc.NSString dest, objc.NSObject? handler) {
    return _objc_msgSend_294(this.pointer, _sel_movePath_toPath_handler_,
        src.pointer, dest.pointer, handler?.pointer ?? ffi.nullptr);
  }

  bool removeFileAtPath_handler_(objc.NSString path, objc.NSObject? handler) {
    return _objc_msgSend_295(this.pointer, _sel_removeFileAtPath_handler_,
        path.pointer, handler?.pointer ?? ffi.nullptr);
  }

  objc.NSString get currentDirectoryPath {
    final _ret = _objc_msgSend_12(this.pointer, _sel_currentDirectoryPath);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool changeCurrentDirectoryPath_(objc.NSString path) {
    return _objc_msgSend_51(
        this.pointer, _sel_changeCurrentDirectoryPath_, path.pointer);
  }

  bool fileExistsAtPath_(objc.NSString path) {
    return _objc_msgSend_51(this.pointer, _sel_fileExistsAtPath_, path.pointer);
  }

  bool fileExistsAtPath_isDirectory_(
      objc.NSString path, ffi.Pointer<ffi.Bool> isDirectory) {
    return _objc_msgSend_296(this.pointer, _sel_fileExistsAtPath_isDirectory_,
        path.pointer, isDirectory);
  }

  bool isReadableFileAtPath_(objc.NSString path) {
    return _objc_msgSend_51(
        this.pointer, _sel_isReadableFileAtPath_, path.pointer);
  }

  bool isWritableFileAtPath_(objc.NSString path) {
    return _objc_msgSend_51(
        this.pointer, _sel_isWritableFileAtPath_, path.pointer);
  }

  bool isExecutableFileAtPath_(objc.NSString path) {
    return _objc_msgSend_51(
        this.pointer, _sel_isExecutableFileAtPath_, path.pointer);
  }

  bool isDeletableFileAtPath_(objc.NSString path) {
    return _objc_msgSend_51(
        this.pointer, _sel_isDeletableFileAtPath_, path.pointer);
  }

  bool contentsEqualAtPath_andPath_(objc.NSString path1, objc.NSString path2) {
    return _objc_msgSend_292(this.pointer, _sel_contentsEqualAtPath_andPath_,
        path1.pointer, path2.pointer);
  }

  objc.NSString displayNameAtPath_(objc.NSString path) {
    final _ret =
        _objc_msgSend_297(this.pointer, _sel_displayNameAtPath_, path.pointer);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? componentsToDisplayForPath_(objc.NSString path) {
    final _ret = _objc_msgSend_290(
        this.pointer, _sel_componentsToDisplayForPath_, path.pointer);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? enumeratorAtPath_(objc.NSString path) {
    final _ret =
        _objc_msgSend_2(this.pointer, _sel_enumeratorAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject?
      enumeratorAtURL_includingPropertiesForKeys_options_errorHandler_(
          objc.NSURL url,
          objc.NSArray? keys,
          int mask,
          ObjCBlock_bool_NSURL_NSError? handler) {
    final _ret = _objc_msgSend_298(
        this.pointer,
        _sel_enumeratorAtURL_includingPropertiesForKeys_options_errorHandler_,
        url.pointer,
        keys?.pointer ?? ffi.nullptr,
        mask,
        handler?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? subpathsAtPath_(objc.NSString path) {
    final _ret =
        _objc_msgSend_290(this.pointer, _sel_subpathsAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSData? contentsAtPath_(objc.NSString path) {
    final _ret =
        _objc_msgSend_299(this.pointer, _sel_contentsAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  bool createFileAtPath_contents_attributes_(
      objc.NSString path, objc.NSData? data, objc.NSDictionary? attr) {
    return _objc_msgSend_300(
        this.pointer,
        _sel_createFileAtPath_contents_attributes_,
        path.pointer,
        data?.pointer ?? ffi.nullptr,
        attr?.pointer ?? ffi.nullptr);
  }

  ffi.Pointer<ffi.Char> fileSystemRepresentationWithPath_(objc.NSString path) {
    return _objc_msgSend_301(
        this.pointer, _sel_fileSystemRepresentationWithPath_, path.pointer);
  }

  objc.NSString stringWithFileSystemRepresentation_length_(
      ffi.Pointer<ffi.Char> str, int len) {
    final _ret = _objc_msgSend_302(this.pointer,
        _sel_stringWithFileSystemRepresentation_length_, str, len);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool
      replaceItemAtURL_withItemAtURL_backupItemName_options_resultingItemURL_error_(
          objc.NSURL originalItemURL,
          objc.NSURL newItemURL,
          objc.NSString? backupItemName,
          int options,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> resultingURL,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_303(
        this.pointer,
        _sel_replaceItemAtURL_withItemAtURL_backupItemName_options_resultingItemURL_error_,
        originalItemURL.pointer,
        newItemURL.pointer,
        backupItemName?.pointer ?? ffi.nullptr,
        options,
        resultingURL,
        error);
  }

  bool setUbiquitous_itemAtURL_destinationURL_error_(
      bool flag,
      objc.NSURL url,
      objc.NSURL destinationURL,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_304(
        this.pointer,
        _sel_setUbiquitous_itemAtURL_destinationURL_error_,
        flag,
        url.pointer,
        destinationURL.pointer,
        error);
  }

  bool isUbiquitousItemAtURL_(objc.NSURL url) {
    return _objc_msgSend_305(
        this.pointer, _sel_isUbiquitousItemAtURL_, url.pointer);
  }

  bool startDownloadingUbiquitousItemAtURL_error_(
      objc.NSURL url, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_286(this.pointer,
        _sel_startDownloadingUbiquitousItemAtURL_error_, url.pointer, error);
  }

  bool evictUbiquitousItemAtURL_error_(
      objc.NSURL url, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_286(
        this.pointer, _sel_evictUbiquitousItemAtURL_error_, url.pointer, error);
  }

  objc.NSURL? URLForUbiquityContainerIdentifier_(
      objc.NSString? containerIdentifier) {
    final _ret = _objc_msgSend_306(
        this.pointer,
        _sel_URLForUbiquityContainerIdentifier_,
        containerIdentifier?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? URLForPublishingUbiquitousItemAtURL_expirationDate_error_(
      objc.NSURL url,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outDate,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_307(
        this.pointer,
        _sel_URLForPublishingUbiquitousItemAtURL_expirationDate_error_,
        url.pointer,
        outDate,
        error);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? get ubiquityIdentityToken {
    final _ret = _objc_msgSend_66(this.pointer, _sel_ubiquityIdentityToken);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  void getFileProviderServicesForItemAtURL_completionHandler_(objc.NSURL url,
      ObjCBlock_ffiVoid_NSDictionary_NSError completionHandler) {
    _objc_msgSend_308(
        this.pointer,
        _sel_getFileProviderServicesForItemAtURL_completionHandler_,
        url.pointer,
        completionHandler.pointer);
  }

  objc.NSURL? containerURLForSecurityApplicationGroupIdentifier_(
      objc.NSString groupIdentifier) {
    final _ret = _objc_msgSend_11(
        this.pointer,
        _sel_containerURLForSecurityApplicationGroupIdentifier_,
        groupIdentifier.pointer);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL get homeDirectoryForCurrentUser {
    final _ret =
        _objc_msgSend_9(this.pointer, _sel_homeDirectoryForCurrentUser);
    return objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL get temporaryDirectory {
    final _ret = _objc_msgSend_9(this.pointer, _sel_temporaryDirectory);
    return objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? homeDirectoryForUser_(objc.NSString userName) {
    final _ret = _objc_msgSend_11(
        this.pointer, _sel_homeDirectoryForUser_, userName.pointer);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSFileManager init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSFileManager.castFromPointer(_ret, retain: true, release: true);
  }

  static NSFileManager new1() {
    final _ret = _objc_msgSend_40(_class_NSFileManager, _sel_new);
    return NSFileManager.castFromPointer(_ret, retain: false, release: true);
  }

  static NSFileManager allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSFileManager, _sel_allocWithZone_, zone);
    return NSFileManager.castFromPointer(_ret, retain: false, release: true);
  }

  static NSFileManager alloc() {
    final _ret = _objc_msgSend_40(_class_NSFileManager, _sel_alloc);
    return NSFileManager.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSFileManager,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSFileManager,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSFileManager, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSFileManager, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSFileManager,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSFileManager,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSFileManager,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSFileManager, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSFileManager, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSFileManager = objc.getClass("NSFileManager");
late final _sel_defaultManager = objc.registerName("defaultManager");
final _objc_msgSend_269 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();

abstract class NSVolumeEnumerationOptions {
  static const int NSVolumeEnumerationSkipHiddenVolumes = 2;
  static const int NSVolumeEnumerationProduceFileReferenceURLs = 4;
}

late final _sel_mountedVolumeURLsIncludingResourceValuesForKeys_options_ = objc
    .registerName("mountedVolumeURLsIncludingResourceValuesForKeys:options:");
final _objc_msgSend_270 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();

abstract class NSFileManagerUnmountOptions {
  static const int NSFileManagerUnmountAllPartitionsAndEjectDisk = 1;
  static const int NSFileManagerUnmountWithoutUI = 2;
}

void _ObjCBlock_ffiVoid_NSError_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>()
        .asFunction<void Function(ffi.Pointer<objc.ObjCObject>)>()(arg0);
final _ObjCBlock_ffiVoid_NSError_closureRegistry =
    <int, void Function(ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_ffiVoid_NSError_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_NSError_registerClosure(
    void Function(ffi.Pointer<objc.ObjCObject>) fn) {
  final id = ++_ObjCBlock_ffiVoid_NSError_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSError_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSError_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    _ObjCBlock_ffiVoid_NSError_closureRegistry[block.ref.target.address]!(arg0);

class ObjCBlock_ffiVoid_NSError extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSError._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSError castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSError._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSError.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSError_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSError.fromFunction(void Function(objc.NSError?) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSError_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_NSError_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(arg0.address == 0
                    ? null
                    : objc.NSError.castFromPointer(arg0,
                        retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSError.listener(void Function(objc.NSError?) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>.listener(
                    _ObjCBlock_ffiVoid_NSError_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSError_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(arg0.address == 0
                    ? null
                    : objc.NSError.castFromPointer(arg0, retain: true, release: true)))));
  static ffi.NativeCallable<
          ffi.Void Function(
              ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>?
      _dartFuncListenerTrampoline;

  void call(objc.NSError? arg0) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0)>>()
          .asFunction<
              void Function(
                  ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>()(
      pointer, arg0?.pointer ?? ffi.nullptr);
}

late final _sel_unmountVolumeAtURL_options_completionHandler_ =
    objc.registerName("unmountVolumeAtURL:options:completionHandler:");
final _objc_msgSend_271 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();

abstract class NSDirectoryEnumerationOptions {
  static const int NSDirectoryEnumerationSkipsSubdirectoryDescendants = 1;
  static const int NSDirectoryEnumerationSkipsPackageDescendants = 2;
  static const int NSDirectoryEnumerationSkipsHiddenFiles = 4;
  static const int NSDirectoryEnumerationIncludesDirectoriesPostOrder = 8;
  static const int NSDirectoryEnumerationProducesRelativePathURLs = 16;
}

late final _sel_contentsOfDirectoryAtURL_includingPropertiesForKeys_options_error_ =
    objc.registerName(
        "contentsOfDirectoryAtURL:includingPropertiesForKeys:options:error:");
final _objc_msgSend_272 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();

abstract class NSSearchPathDirectory {
  static const int NSApplicationDirectory = 1;
  static const int NSDemoApplicationDirectory = 2;
  static const int NSDeveloperApplicationDirectory = 3;
  static const int NSAdminApplicationDirectory = 4;
  static const int NSLibraryDirectory = 5;
  static const int NSDeveloperDirectory = 6;
  static const int NSUserDirectory = 7;
  static const int NSDocumentationDirectory = 8;
  static const int NSDocumentDirectory = 9;
  static const int NSCoreServiceDirectory = 10;
  static const int NSAutosavedInformationDirectory = 11;
  static const int NSDesktopDirectory = 12;
  static const int NSCachesDirectory = 13;
  static const int NSApplicationSupportDirectory = 14;
  static const int NSDownloadsDirectory = 15;
  static const int NSInputMethodsDirectory = 16;
  static const int NSMoviesDirectory = 17;
  static const int NSMusicDirectory = 18;
  static const int NSPicturesDirectory = 19;
  static const int NSPrinterDescriptionDirectory = 20;
  static const int NSSharedPublicDirectory = 21;
  static const int NSPreferencePanesDirectory = 22;
  static const int NSApplicationScriptsDirectory = 23;
  static const int NSItemReplacementDirectory = 99;
  static const int NSAllApplicationsDirectory = 100;
  static const int NSAllLibrariesDirectory = 101;
  static const int NSTrashDirectory = 102;
}

abstract class NSSearchPathDomainMask {
  static const int NSUserDomainMask = 1;
  static const int NSLocalDomainMask = 2;
  static const int NSNetworkDomainMask = 4;
  static const int NSSystemDomainMask = 8;
  static const int NSAllDomainsMask = 65535;
}

late final _sel_URLsForDirectory_inDomains_ =
    objc.registerName("URLsForDirectory:inDomains:");
final _objc_msgSend_273 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32, ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, int)>();
late final _sel_URLForDirectory_inDomain_appropriateForURL_create_error_ = objc
    .registerName("URLForDirectory:inDomain:appropriateForURL:create:error:");
final _objc_msgSend_274 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>,
            bool,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();

abstract class NSURLRelationship {
  static const int NSURLRelationshipContains = 0;
  static const int NSURLRelationshipSame = 1;
  static const int NSURLRelationshipOther = 2;
}

late final _sel_getRelationship_ofDirectoryAtURL_toItemAtURL_error_ =
    objc.registerName("getRelationship:ofDirectoryAtURL:toItemAtURL:error:");
final _objc_msgSend_275 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Int32>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Int32>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_getRelationship_ofDirectory_inDomain_toItemAtURL_error_ = objc
    .registerName("getRelationship:ofDirectory:inDomain:toItemAtURL:error:");
final _objc_msgSend_276 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Int32>,
                ffi.Int32,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Int32>,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_createDirectoryAtURL_withIntermediateDirectories_attributes_error_ =
    objc.registerName(
        "createDirectoryAtURL:withIntermediateDirectories:attributes:error:");
final _objc_msgSend_277 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_createSymbolicLinkAtURL_withDestinationURL_error_ =
    objc.registerName("createSymbolicLinkAtURL:withDestinationURL:error:");
final _objc_msgSend_278 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_setAttributes_ofItemAtPath_error_ =
    objc.registerName("setAttributes:ofItemAtPath:error:");
final _objc_msgSend_279 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_createDirectoryAtPath_withIntermediateDirectories_attributes_error_ =
    objc.registerName(
        "createDirectoryAtPath:withIntermediateDirectories:attributes:error:");
final _objc_msgSend_280 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_contentsOfDirectoryAtPath_error_ =
    objc.registerName("contentsOfDirectoryAtPath:error:");
final _objc_msgSend_281 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_subpathsOfDirectoryAtPath_error_ =
    objc.registerName("subpathsOfDirectoryAtPath:error:");
late final _sel_attributesOfItemAtPath_error_ =
    objc.registerName("attributesOfItemAtPath:error:");
final _objc_msgSend_282 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_attributesOfFileSystemForPath_error_ =
    objc.registerName("attributesOfFileSystemForPath:error:");
late final _sel_createSymbolicLinkAtPath_withDestinationPath_error_ =
    objc.registerName("createSymbolicLinkAtPath:withDestinationPath:error:");
final _objc_msgSend_283 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_destinationOfSymbolicLinkAtPath_error_ =
    objc.registerName("destinationOfSymbolicLinkAtPath:error:");
final _objc_msgSend_284 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_copyItemAtPath_toPath_error_ =
    objc.registerName("copyItemAtPath:toPath:error:");
late final _sel_moveItemAtPath_toPath_error_ =
    objc.registerName("moveItemAtPath:toPath:error:");
late final _sel_linkItemAtPath_toPath_error_ =
    objc.registerName("linkItemAtPath:toPath:error:");
late final _sel_removeItemAtPath_error_ =
    objc.registerName("removeItemAtPath:error:");
final _objc_msgSend_285 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_copyItemAtURL_toURL_error_ =
    objc.registerName("copyItemAtURL:toURL:error:");
late final _sel_moveItemAtURL_toURL_error_ =
    objc.registerName("moveItemAtURL:toURL:error:");
late final _sel_linkItemAtURL_toURL_error_ =
    objc.registerName("linkItemAtURL:toURL:error:");
late final _sel_removeItemAtURL_error_ =
    objc.registerName("removeItemAtURL:error:");
final _objc_msgSend_286 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_trashItemAtURL_resultingItemURL_error_ =
    objc.registerName("trashItemAtURL:resultingItemURL:error:");
final _objc_msgSend_287 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_fileAttributesAtPath_traverseLink_ =
    objc.registerName("fileAttributesAtPath:traverseLink:");
final _objc_msgSend_288 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_changeFileAttributes_atPath_ =
    objc.registerName("changeFileAttributes:atPath:");
final _objc_msgSend_289 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_directoryContentsAtPath_ =
    objc.registerName("directoryContentsAtPath:");
final _objc_msgSend_290 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_fileSystemAttributesAtPath_ =
    objc.registerName("fileSystemAttributesAtPath:");
final _objc_msgSend_291 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_pathContentOfSymbolicLinkAtPath_ =
    objc.registerName("pathContentOfSymbolicLinkAtPath:");
late final _sel_createSymbolicLinkAtPath_pathContent_ =
    objc.registerName("createSymbolicLinkAtPath:pathContent:");
final _objc_msgSend_292 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_createDirectoryAtPath_attributes_ =
    objc.registerName("createDirectoryAtPath:attributes:");
final _objc_msgSend_293 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_linkPath_toPath_handler_ =
    objc.registerName("linkPath:toPath:handler:");
final _objc_msgSend_294 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_copyPath_toPath_handler_ =
    objc.registerName("copyPath:toPath:handler:");
late final _sel_movePath_toPath_handler_ =
    objc.registerName("movePath:toPath:handler:");
late final _sel_removeFileAtPath_handler_ =
    objc.registerName("removeFileAtPath:handler:");
final _objc_msgSend_295 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_currentDirectoryPath =
    objc.registerName("currentDirectoryPath");
late final _sel_changeCurrentDirectoryPath_ =
    objc.registerName("changeCurrentDirectoryPath:");
late final _sel_fileExistsAtPath_ = objc.registerName("fileExistsAtPath:");
late final _sel_fileExistsAtPath_isDirectory_ =
    objc.registerName("fileExistsAtPath:isDirectory:");
final _objc_msgSend_296 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Bool>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Bool>)>();
late final _sel_isReadableFileAtPath_ =
    objc.registerName("isReadableFileAtPath:");
late final _sel_isWritableFileAtPath_ =
    objc.registerName("isWritableFileAtPath:");
late final _sel_isExecutableFileAtPath_ =
    objc.registerName("isExecutableFileAtPath:");
late final _sel_isDeletableFileAtPath_ =
    objc.registerName("isDeletableFileAtPath:");
late final _sel_contentsEqualAtPath_andPath_ =
    objc.registerName("contentsEqualAtPath:andPath:");
late final _sel_displayNameAtPath_ = objc.registerName("displayNameAtPath:");
final _objc_msgSend_297 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_componentsToDisplayForPath_ =
    objc.registerName("componentsToDisplayForPath:");
late final _sel_enumeratorAtPath_ = objc.registerName("enumeratorAtPath:");
bool _ObjCBlock_bool_NSURL_NSError_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
final _ObjCBlock_bool_NSURL_NSError_closureRegistry = <int,
    bool Function(
        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_bool_NSURL_NSError_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_bool_NSURL_NSError_registerClosure(
    bool Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)
        fn) {
  final id = ++_ObjCBlock_bool_NSURL_NSError_closureRegistryIndex;
  _ObjCBlock_bool_NSURL_NSError_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

bool _ObjCBlock_bool_NSURL_NSError_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    _ObjCBlock_bool_NSURL_NSError_closureRegistry[block.ref.target.address]!(
        arg0, arg1);

class ObjCBlock_bool_NSURL_NSError extends objc.ObjCBlockBase {
  ObjCBlock_bool_NSURL_NSError._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_bool_NSURL_NSError castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_bool_NSURL_NSError._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_bool_NSURL_NSError.fromFunctionPointer(
      ffi.Pointer<ffi.NativeFunction<ffi.Bool Function(ffi.Pointer<objc.ObjCObject> arg0, ffi.Pointer<objc.ObjCObject> arg1)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Bool Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_bool_NSURL_NSError_fnPtrTrampoline, false)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_bool_NSURL_NSError.fromFunction(bool Function(objc.NSURL, objc.NSError) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Bool Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_bool_NSURL_NSError_closureTrampoline, false)
                .cast(),
            _ObjCBlock_bool_NSURL_NSError_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0,
                        ffi.Pointer<objc.ObjCObject> arg1) =>
                    fn(objc.NSURL.castFromPointer(arg0, retain: true, release: true), objc.NSError.castFromPointer(arg1, retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  bool call(objc.NSURL arg0, objc.NSError arg1) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Bool Function(
                      ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>()
          .asFunction<
              bool Function(
                  ffi.Pointer<objc.ObjCBlock>,
                  ffi.Pointer<objc.ObjCObject>,
                  ffi.Pointer<objc.ObjCObject>)>()(
      pointer, arg0.pointer, arg1.pointer);
}

late final _sel_enumeratorAtURL_includingPropertiesForKeys_options_errorHandler_ =
    objc.registerName(
        "enumeratorAtURL:includingPropertiesForKeys:options:errorHandler:");
final _objc_msgSend_298 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_subpathsAtPath_ = objc.registerName("subpathsAtPath:");
late final _sel_contentsAtPath_ = objc.registerName("contentsAtPath:");
final _objc_msgSend_299 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_createFileAtPath_contents_attributes_ =
    objc.registerName("createFileAtPath:contents:attributes:");
final _objc_msgSend_300 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_fileSystemRepresentationWithPath_ =
    objc.registerName("fileSystemRepresentationWithPath:");
final _objc_msgSend_301 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.Char> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<ffi.Char> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_stringWithFileSystemRepresentation_length_ =
    objc.registerName("stringWithFileSystemRepresentation:length:");
final _objc_msgSend_302 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Char>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Char>, int)>();

abstract class NSFileManagerItemReplacementOptions {
  static const int NSFileManagerItemReplacementUsingNewMetadataOnly = 1;
  static const int NSFileManagerItemReplacementWithoutDeletingBackupItem = 2;
}

late final _sel_replaceItemAtURL_withItemAtURL_backupItemName_options_resultingItemURL_error_ =
    objc.registerName(
        "replaceItemAtURL:withItemAtURL:backupItemName:options:resultingItemURL:error:");
final _objc_msgSend_303 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_setUbiquitous_itemAtURL_destinationURL_error_ =
    objc.registerName("setUbiquitous:itemAtURL:destinationURL:error:");
final _objc_msgSend_304 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Bool,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            bool,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_isUbiquitousItemAtURL_ =
    objc.registerName("isUbiquitousItemAtURL:");
final _objc_msgSend_305 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_startDownloadingUbiquitousItemAtURL_error_ =
    objc.registerName("startDownloadingUbiquitousItemAtURL:error:");
late final _sel_evictUbiquitousItemAtURL_error_ =
    objc.registerName("evictUbiquitousItemAtURL:error:");
late final _sel_URLForUbiquityContainerIdentifier_ =
    objc.registerName("URLForUbiquityContainerIdentifier:");
final _objc_msgSend_306 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_URLForPublishingUbiquitousItemAtURL_expirationDate_error_ = objc
    .registerName("URLForPublishingUbiquitousItemAtURL:expirationDate:error:");
final _objc_msgSend_307 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_ubiquityIdentityToken =
    objc.registerName("ubiquityIdentityToken");
void _ObjCBlock_ffiVoid_NSDictionary_NSError_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
final _ObjCBlock_ffiVoid_NSDictionary_NSError_closureRegistry = <int,
    void Function(
        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_ffiVoid_NSDictionary_NSError_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_NSDictionary_NSError_registerClosure(
    void Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)
        fn) {
  final id = ++_ObjCBlock_ffiVoid_NSDictionary_NSError_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSDictionary_NSError_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSDictionary_NSError_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    _ObjCBlock_ffiVoid_NSDictionary_NSError_closureRegistry[
        block.ref.target.address]!(arg0, arg1);

class ObjCBlock_ffiVoid_NSDictionary_NSError extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSDictionary_NSError._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSDictionary_NSError castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSDictionary_NSError._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSDictionary_NSError.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSDictionary_NSError_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSDictionary_NSError.fromFunction(
      void Function(objc.NSDictionary?, objc.NSError?) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??=
                ffi.Pointer.fromFunction<ffi.Void Function(ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>(
                        _ObjCBlock_ffiVoid_NSDictionary_NSError_closureTrampoline)
                    .cast(),
            _ObjCBlock_ffiVoid_NSDictionary_NSError_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, ffi.Pointer<objc.ObjCObject> arg1) => fn(
                    arg0.address == 0
                        ? null
                        : objc.NSDictionary.castFromPointer(arg0, retain: true, release: true),
                    arg1.address == 0 ? null : objc.NSError.castFromPointer(arg1, retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSDictionary_NSError.listener(
      void Function(objc.NSDictionary?, objc.NSError?) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??=
                    ffi.NativeCallable<ffi.Void Function(ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>.listener(
                        _ObjCBlock_ffiVoid_NSDictionary_NSError_closureTrampoline)
                      ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSDictionary_NSError_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, ffi.Pointer<objc.ObjCObject> arg1) => fn(
                    arg0.address == 0
                        ? null
                        : objc.NSDictionary.castFromPointer(arg0,
                            retain: true, release: true),
                    arg1.address == 0 ? null : objc.NSError.castFromPointer(arg1, retain: true, release: true)))));
  static ffi.NativeCallable<
      ffi.Void Function(
          ffi.Pointer<objc.ObjCBlock>,
          ffi.Pointer<objc.ObjCObject>,
          ffi.Pointer<objc.ObjCObject>)>? _dartFuncListenerTrampoline;

  void call(objc.NSDictionary? arg0, objc.NSError? arg1) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>()
          .asFunction<
              void Function(
                  ffi.Pointer<objc.ObjCBlock>,
                  ffi.Pointer<objc.ObjCObject>,
                  ffi.Pointer<objc.ObjCObject>)>()(
      pointer, arg0?.pointer ?? ffi.nullptr, arg1?.pointer ?? ffi.nullptr);
}

late final _sel_getFileProviderServicesForItemAtURL_completionHandler_ =
    objc.registerName("getFileProviderServicesForItemAtURL:completionHandler:");
final _objc_msgSend_308 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_containerURLForSecurityApplicationGroupIdentifier_ =
    objc.registerName("containerURLForSecurityApplicationGroupIdentifier:");
late final _sel_homeDirectoryForCurrentUser =
    objc.registerName("homeDirectoryForCurrentUser");
late final _sel_temporaryDirectory = objc.registerName("temporaryDirectory");
late final _sel_homeDirectoryForUser_ =
    objc.registerName("homeDirectoryForUser:");

class NSHTTPCookieStorage extends objc.NSObject {
  NSHTTPCookieStorage._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSHTTPCookieStorage] that points to the same underlying object as [other].
  NSHTTPCookieStorage.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSHTTPCookieStorage] that wraps the given raw object pointer.
  NSHTTPCookieStorage.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSHTTPCookieStorage].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSHTTPCookieStorage);
  }

  static NSHTTPCookieStorage getSharedHTTPCookieStorage() {
    final _ret = _objc_msgSend_309(
        _class_NSHTTPCookieStorage, _sel_sharedHTTPCookieStorage);
    return NSHTTPCookieStorage.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSHTTPCookieStorage sharedCookieStorageForGroupContainerIdentifier_(
      objc.NSString identifier) {
    final _ret = _objc_msgSend_310(
        _class_NSHTTPCookieStorage,
        _sel_sharedCookieStorageForGroupContainerIdentifier_,
        identifier.pointer);
    return NSHTTPCookieStorage.castFromPointer(_ret,
        retain: true, release: true);
  }

  objc.NSArray? get cookies {
    final _ret = _objc_msgSend_69(this.pointer, _sel_cookies);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  void setCookie_(NSHTTPCookie cookie) {
    _objc_msgSend_315(this.pointer, _sel_setCookie_, cookie.pointer);
  }

  void deleteCookie_(NSHTTPCookie cookie) {
    _objc_msgSend_315(this.pointer, _sel_deleteCookie_, cookie.pointer);
  }

  void removeCookiesSinceDate_(objc.NSDate date) {
    _objc_msgSend_246(this.pointer, _sel_removeCookiesSinceDate_, date.pointer);
  }

  objc.NSArray? cookiesForURL_(objc.NSURL URL) {
    final _ret =
        _objc_msgSend_316(this.pointer, _sel_cookiesForURL_, URL.pointer);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  void setCookies_forURL_mainDocumentURL_(
      objc.NSArray cookies, objc.NSURL? URL, objc.NSURL? mainDocumentURL) {
    _objc_msgSend_317(
        this.pointer,
        _sel_setCookies_forURL_mainDocumentURL_,
        cookies.pointer,
        URL?.pointer ?? ffi.nullptr,
        mainDocumentURL?.pointer ?? ffi.nullptr);
  }

  int get cookieAcceptPolicy {
    return _objc_msgSend_318(this.pointer, _sel_cookieAcceptPolicy);
  }

  set cookieAcceptPolicy(int value) {
    return _objc_msgSend_319(this.pointer, _sel_setCookieAcceptPolicy_, value);
  }

  objc.NSArray sortedCookiesUsingDescriptors_(objc.NSArray sortOrder) {
    final _ret = _objc_msgSend_67(
        this.pointer, _sel_sortedCookiesUsingDescriptors_, sortOrder.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  void storeCookies_forTask_(objc.NSArray cookies, NSURLSessionTask task) {
    _objc_msgSend_353(this.pointer, _sel_storeCookies_forTask_, cookies.pointer,
        task.pointer);
  }

  void getCookiesForTask_completionHandler_(
      NSURLSessionTask task, ObjCBlock_ffiVoid_NSArray completionHandler) {
    _objc_msgSend_354(this.pointer, _sel_getCookiesForTask_completionHandler_,
        task.pointer, completionHandler.pointer);
  }

  @override
  NSHTTPCookieStorage init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSHTTPCookieStorage.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSHTTPCookieStorage new1() {
    final _ret = _objc_msgSend_40(_class_NSHTTPCookieStorage, _sel_new);
    return NSHTTPCookieStorage.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSHTTPCookieStorage allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSHTTPCookieStorage, _sel_allocWithZone_, zone);
    return NSHTTPCookieStorage.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSHTTPCookieStorage alloc() {
    final _ret = _objc_msgSend_40(_class_NSHTTPCookieStorage, _sel_alloc);
    return NSHTTPCookieStorage.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSHTTPCookieStorage,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSHTTPCookieStorage,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSHTTPCookieStorage, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSHTTPCookieStorage, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSHTTPCookieStorage,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSHTTPCookieStorage,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSHTTPCookieStorage,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSHTTPCookieStorage, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSHTTPCookieStorage, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSHTTPCookieStorage = objc.getClass("NSHTTPCookieStorage");
late final _sel_sharedHTTPCookieStorage =
    objc.registerName("sharedHTTPCookieStorage");
final _objc_msgSend_309 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_sharedCookieStorageForGroupContainerIdentifier_ =
    objc.registerName("sharedCookieStorageForGroupContainerIdentifier:");
final _objc_msgSend_310 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_cookies = objc.registerName("cookies");

class NSHTTPCookie extends objc.NSObject {
  NSHTTPCookie._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSHTTPCookie] that points to the same underlying object as [other].
  NSHTTPCookie.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSHTTPCookie] that wraps the given raw object pointer.
  NSHTTPCookie.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSHTTPCookie].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSHTTPCookie);
  }

  NSHTTPCookie? initWithProperties_(objc.NSDictionary properties) {
    final _ret = _objc_msgSend_311(
        this.pointer, _sel_initWithProperties_, properties.pointer);
    return _ret.address == 0
        ? null
        : NSHTTPCookie.castFromPointer(_ret, retain: true, release: true);
  }

  static NSHTTPCookie? cookieWithProperties_(objc.NSDictionary properties) {
    final _ret = _objc_msgSend_312(
        _class_NSHTTPCookie, _sel_cookieWithProperties_, properties.pointer);
    return _ret.address == 0
        ? null
        : NSHTTPCookie.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSDictionary requestHeaderFieldsWithCookies_(
      objc.NSArray cookies) {
    final _ret = _objc_msgSend_313(_class_NSHTTPCookie,
        _sel_requestHeaderFieldsWithCookies_, cookies.pointer);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSArray cookiesWithResponseHeaderFields_forURL_(
      objc.NSDictionary headerFields, objc.NSURL URL) {
    final _ret = _objc_msgSend_314(
        _class_NSHTTPCookie,
        _sel_cookiesWithResponseHeaderFields_forURL_,
        headerFields.pointer,
        URL.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? get properties {
    final _ret = _objc_msgSend_65(this.pointer, _sel_properties);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  int get version {
    return _objc_msgSend_29(this.pointer, _sel_version);
  }

  objc.NSString get name {
    final _ret = _objc_msgSend_12(this.pointer, _sel_name);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get value {
    final _ret = _objc_msgSend_12(this.pointer, _sel_value);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? get expiresDate {
    final _ret = _objc_msgSend_116(this.pointer, _sel_expiresDate);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  bool get sessionOnly {
    return _objc_msgSend_7(this.pointer, _sel_isSessionOnly);
  }

  objc.NSString get domain {
    final _ret = _objc_msgSend_12(this.pointer, _sel_domain);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get path {
    final _ret = _objc_msgSend_12(this.pointer, _sel_path);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool get secure {
    return _objc_msgSend_7(this.pointer, _sel_isSecure);
  }

  bool get HTTPOnly {
    return _objc_msgSend_7(this.pointer, _sel_isHTTPOnly);
  }

  objc.NSString? get comment {
    final _ret = _objc_msgSend_13(this.pointer, _sel_comment);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get commentURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_commentURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? get portList {
    final _ret = _objc_msgSend_69(this.pointer, _sel_portList);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get sameSitePolicy {
    final _ret = _objc_msgSend_13(this.pointer, _sel_sameSitePolicy);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSHTTPCookie init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSHTTPCookie.castFromPointer(_ret, retain: true, release: true);
  }

  static NSHTTPCookie new1() {
    final _ret = _objc_msgSend_40(_class_NSHTTPCookie, _sel_new);
    return NSHTTPCookie.castFromPointer(_ret, retain: false, release: true);
  }

  static NSHTTPCookie allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSHTTPCookie, _sel_allocWithZone_, zone);
    return NSHTTPCookie.castFromPointer(_ret, retain: false, release: true);
  }

  static NSHTTPCookie alloc() {
    final _ret = _objc_msgSend_40(_class_NSHTTPCookie, _sel_alloc);
    return NSHTTPCookie.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSHTTPCookie,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSHTTPCookie,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSHTTPCookie, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSHTTPCookie, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSHTTPCookie,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSHTTPCookie,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSHTTPCookie,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSHTTPCookie, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSHTTPCookie, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSHTTPCookie = objc.getClass("NSHTTPCookie");
late final _sel_initWithProperties_ = objc.registerName("initWithProperties:");
final _objc_msgSend_311 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_cookieWithProperties_ =
    objc.registerName("cookieWithProperties:");
final _objc_msgSend_312 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_requestHeaderFieldsWithCookies_ =
    objc.registerName("requestHeaderFieldsWithCookies:");
final _objc_msgSend_313 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_cookiesWithResponseHeaderFields_forURL_ =
    objc.registerName("cookiesWithResponseHeaderFields:forURL:");
final _objc_msgSend_314 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_properties = objc.registerName("properties");
late final _sel_version = objc.registerName("version");
late final _sel_value = objc.registerName("value");
late final _sel_expiresDate = objc.registerName("expiresDate");
late final _sel_isSessionOnly = objc.registerName("isSessionOnly");
late final _sel_domain = objc.registerName("domain");
late final _sel_path = objc.registerName("path");
late final _sel_isSecure = objc.registerName("isSecure");
late final _sel_isHTTPOnly = objc.registerName("isHTTPOnly");
late final _sel_comment = objc.registerName("comment");
late final _sel_commentURL = objc.registerName("commentURL");
late final _sel_portList = objc.registerName("portList");
late final _sel_sameSitePolicy = objc.registerName("sameSitePolicy");
late final _sel_setCookie_ = objc.registerName("setCookie:");
final _objc_msgSend_315 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_deleteCookie_ = objc.registerName("deleteCookie:");
late final _sel_removeCookiesSinceDate_ =
    objc.registerName("removeCookiesSinceDate:");
late final _sel_cookiesForURL_ = objc.registerName("cookiesForURL:");
final _objc_msgSend_316 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_setCookies_forURL_mainDocumentURL_ =
    objc.registerName("setCookies:forURL:mainDocumentURL:");
final _objc_msgSend_317 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

abstract class NSHTTPCookieAcceptPolicy {
  static const int NSHTTPCookieAcceptPolicyAlways = 0;
  static const int NSHTTPCookieAcceptPolicyNever = 1;
  static const int NSHTTPCookieAcceptPolicyOnlyFromMainDocumentDomain = 2;
}

late final _sel_cookieAcceptPolicy = objc.registerName("cookieAcceptPolicy");
final _objc_msgSend_318 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setCookieAcceptPolicy_ =
    objc.registerName("setCookieAcceptPolicy:");
final _objc_msgSend_319 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_sortedCookiesUsingDescriptors_ =
    objc.registerName("sortedCookiesUsingDescriptors:");

class NSURLSessionTask extends objc.NSObject {
  NSURLSessionTask._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLSessionTask] that points to the same underlying object as [other].
  NSURLSessionTask.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLSessionTask] that wraps the given raw object pointer.
  NSURLSessionTask.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLSessionTask].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSURLSessionTask);
  }

  int get taskIdentifier {
    return _objc_msgSend_29(this.pointer, _sel_taskIdentifier);
  }

  NSURLRequest? get originalRequest {
    final _ret = _objc_msgSend_343(this.pointer, _sel_originalRequest);
    return _ret.address == 0
        ? null
        : NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLRequest? get currentRequest {
    final _ret = _objc_msgSend_343(this.pointer, _sel_currentRequest);
    return _ret.address == 0
        ? null
        : NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLResponse? get response {
    final _ret = _objc_msgSend_346(this.pointer, _sel_response);
    return _ret.address == 0
        ? null
        : NSURLResponse.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? get delegate {
    final _ret = _objc_msgSend_66(this.pointer, _sel_delegate);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  set delegate(objc.NSObject? value) {
    return _objc_msgSend_188(
        this.pointer, _sel_setDelegate_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSProgress get progress {
    final _ret = _objc_msgSend_347(this.pointer, _sel_progress);
    return objc.NSProgress.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? get earliestBeginDate {
    final _ret = _objc_msgSend_116(this.pointer, _sel_earliestBeginDate);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  set earliestBeginDate(objc.NSDate? value) {
    return _objc_msgSend_162(this.pointer, _sel_setEarliestBeginDate_,
        value?.pointer ?? ffi.nullptr);
  }

  int get countOfBytesClientExpectsToSend {
    return _objc_msgSend_348(
        this.pointer, _sel_countOfBytesClientExpectsToSend);
  }

  set countOfBytesClientExpectsToSend(int value) {
    return _objc_msgSend_349(
        this.pointer, _sel_setCountOfBytesClientExpectsToSend_, value);
  }

  int get countOfBytesClientExpectsToReceive {
    return _objc_msgSend_348(
        this.pointer, _sel_countOfBytesClientExpectsToReceive);
  }

  set countOfBytesClientExpectsToReceive(int value) {
    return _objc_msgSend_349(
        this.pointer, _sel_setCountOfBytesClientExpectsToReceive_, value);
  }

  int get countOfBytesSent {
    return _objc_msgSend_348(this.pointer, _sel_countOfBytesSent);
  }

  int get countOfBytesReceived {
    return _objc_msgSend_348(this.pointer, _sel_countOfBytesReceived);
  }

  int get countOfBytesExpectedToSend {
    return _objc_msgSend_348(this.pointer, _sel_countOfBytesExpectedToSend);
  }

  int get countOfBytesExpectedToReceive {
    return _objc_msgSend_348(this.pointer, _sel_countOfBytesExpectedToReceive);
  }

  objc.NSString? get taskDescription {
    final _ret = _objc_msgSend_13(this.pointer, _sel_taskDescription);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set taskDescription(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setTaskDescription_, value?.pointer ?? ffi.nullptr);
  }

  void cancel() {
    _objc_msgSend_82(this.pointer, _sel_cancel);
  }

  int get state {
    return _objc_msgSend_350(this.pointer, _sel_state);
  }

  objc.NSError? get error {
    final _ret = _objc_msgSend_328(this.pointer, _sel_error);
    return _ret.address == 0
        ? null
        : objc.NSError.castFromPointer(_ret, retain: true, release: true);
  }

  void suspend() {
    _objc_msgSend_82(this.pointer, _sel_suspend);
  }

  void resume() {
    _objc_msgSend_82(this.pointer, _sel_resume);
  }

  double get priority {
    return objc.useMsgSendVariants
        ? _objc_msgSend_351Fpret(this.pointer, _sel_priority)
        : _objc_msgSend_351(this.pointer, _sel_priority);
  }

  set priority(double value) {
    return _objc_msgSend_352(this.pointer, _sel_setPriority_, value);
  }

  bool get prefersIncrementalDelivery {
    return _objc_msgSend_7(this.pointer, _sel_prefersIncrementalDelivery);
  }

  set prefersIncrementalDelivery(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setPrefersIncrementalDelivery_, value);
  }

  @override
  NSURLSessionTask init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLSessionTask.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLSessionTask new1() {
    final _ret = _objc_msgSend_40(_class_NSURLSessionTask, _sel_new);
    return NSURLSessionTask.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLSessionTask allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSURLSessionTask, _sel_allocWithZone_, zone);
    return NSURLSessionTask.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLSessionTask alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLSessionTask, _sel_alloc);
    return NSURLSessionTask.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLSessionTask,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLSessionTask,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSURLSessionTask, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSURLSessionTask, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSURLSessionTask,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSURLSessionTask,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSURLSessionTask,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSURLSessionTask, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSURLSessionTask, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSURLSessionTask = objc.getClass("NSURLSessionTask");
late final _sel_taskIdentifier = objc.registerName("taskIdentifier");

class NSURLRequest extends objc.NSObject {
  NSURLRequest._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLRequest] that points to the same underlying object as [other].
  NSURLRequest.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLRequest] that wraps the given raw object pointer.
  NSURLRequest.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLRequest].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSURLRequest);
  }

  static NSURLRequest requestWithURL_(objc.NSURL URL) {
    final _ret = _objc_msgSend_320(
        _class_NSURLRequest, _sel_requestWithURL_, URL.pointer);
    return NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  static bool getSupportsSecureCoding() {
    return _objc_msgSend_7(_class_NSURLRequest, _sel_supportsSecureCoding);
  }

  static NSURLRequest requestWithURL_cachePolicy_timeoutInterval_(
      objc.NSURL URL, int cachePolicy, double timeoutInterval) {
    final _ret = _objc_msgSend_321(
        _class_NSURLRequest,
        _sel_requestWithURL_cachePolicy_timeoutInterval_,
        URL.pointer,
        cachePolicy,
        timeoutInterval);
    return NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLRequest initWithURL_(objc.NSURL URL) {
    final _ret =
        _objc_msgSend_320(this.pointer, _sel_initWithURL_, URL.pointer);
    return NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLRequest initWithURL_cachePolicy_timeoutInterval_(
      objc.NSURL URL, int cachePolicy, double timeoutInterval) {
    final _ret = _objc_msgSend_321(
        this.pointer,
        _sel_initWithURL_cachePolicy_timeoutInterval_,
        URL.pointer,
        cachePolicy,
        timeoutInterval);
    return NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get URL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_URL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  int get cachePolicy {
    return _objc_msgSend_322(this.pointer, _sel_cachePolicy);
  }

  double get timeoutInterval {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_timeoutInterval)
        : _objc_msgSend_115(this.pointer, _sel_timeoutInterval);
  }

  objc.NSURL? get mainDocumentURL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_mainDocumentURL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  int get networkServiceType {
    return _objc_msgSend_323(this.pointer, _sel_networkServiceType);
  }

  bool get allowsCellularAccess {
    return _objc_msgSend_7(this.pointer, _sel_allowsCellularAccess);
  }

  bool get allowsExpensiveNetworkAccess {
    return _objc_msgSend_7(this.pointer, _sel_allowsExpensiveNetworkAccess);
  }

  bool get allowsConstrainedNetworkAccess {
    return _objc_msgSend_7(this.pointer, _sel_allowsConstrainedNetworkAccess);
  }

  bool get assumesHTTP3Capable {
    return _objc_msgSend_7(this.pointer, _sel_assumesHTTP3Capable);
  }

  int get attribution {
    return _objc_msgSend_324(this.pointer, _sel_attribution);
  }

  bool get requiresDNSSECValidation {
    return _objc_msgSend_7(this.pointer, _sel_requiresDNSSECValidation);
  }

  objc.NSString? get HTTPMethod {
    final _ret = _objc_msgSend_13(this.pointer, _sel_HTTPMethod);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? get allHTTPHeaderFields {
    final _ret = _objc_msgSend_65(this.pointer, _sel_allHTTPHeaderFields);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? valueForHTTPHeaderField_(objc.NSString field) {
    final _ret = _objc_msgSend_14(
        this.pointer, _sel_valueForHTTPHeaderField_, field.pointer);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSData? get HTTPBody {
    final _ret = _objc_msgSend_325(this.pointer, _sel_HTTPBody);
    return _ret.address == 0
        ? null
        : objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  NSInputStream? get HTTPBodyStream {
    final _ret = _objc_msgSend_342(this.pointer, _sel_HTTPBodyStream);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  bool get HTTPShouldHandleCookies {
    return _objc_msgSend_7(this.pointer, _sel_HTTPShouldHandleCookies);
  }

  bool get HTTPShouldUsePipelining {
    return _objc_msgSend_7(this.pointer, _sel_HTTPShouldUsePipelining);
  }

  @override
  NSURLRequest init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLRequest new1() {
    final _ret = _objc_msgSend_40(_class_NSURLRequest, _sel_new);
    return NSURLRequest.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLRequest allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSURLRequest, _sel_allocWithZone_, zone);
    return NSURLRequest.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLRequest alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLRequest, _sel_alloc);
    return NSURLRequest.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLRequest,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLRequest,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSURLRequest, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSURLRequest, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSURLRequest,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSURLRequest,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSURLRequest,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSURLRequest, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSURLRequest, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSURLRequest = objc.getClass("NSURLRequest");
late final _sel_requestWithURL_ = objc.registerName("requestWithURL:");
final _objc_msgSend_320 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_supportsSecureCoding =
    objc.registerName("supportsSecureCoding");

abstract class NSURLRequestCachePolicy {
  static const int NSURLRequestUseProtocolCachePolicy = 0;
  static const int NSURLRequestReloadIgnoringLocalCacheData = 1;
  static const int NSURLRequestReloadIgnoringLocalAndRemoteCacheData = 4;
  static const int NSURLRequestReloadIgnoringCacheData = 1;
  static const int NSURLRequestReturnCacheDataElseLoad = 2;
  static const int NSURLRequestReturnCacheDataDontLoad = 3;
  static const int NSURLRequestReloadRevalidatingCacheData = 5;
}

late final _sel_requestWithURL_cachePolicy_timeoutInterval_ =
    objc.registerName("requestWithURL:cachePolicy:timeoutInterval:");
final _objc_msgSend_321 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Double)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            double)>();
late final _sel_initWithURL_cachePolicy_timeoutInterval_ =
    objc.registerName("initWithURL:cachePolicy:timeoutInterval:");
late final _sel_URL = objc.registerName("URL");
late final _sel_cachePolicy = objc.registerName("cachePolicy");
final _objc_msgSend_322 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_timeoutInterval = objc.registerName("timeoutInterval");
late final _sel_mainDocumentURL = objc.registerName("mainDocumentURL");

abstract class NSURLRequestNetworkServiceType {
  static const int NSURLNetworkServiceTypeDefault = 0;
  static const int NSURLNetworkServiceTypeVoIP = 1;
  static const int NSURLNetworkServiceTypeVideo = 2;
  static const int NSURLNetworkServiceTypeBackground = 3;
  static const int NSURLNetworkServiceTypeVoice = 4;
  static const int NSURLNetworkServiceTypeResponsiveData = 6;
  static const int NSURLNetworkServiceTypeAVStreaming = 8;
  static const int NSURLNetworkServiceTypeResponsiveAV = 9;
  static const int NSURLNetworkServiceTypeCallSignaling = 11;
}

late final _sel_networkServiceType = objc.registerName("networkServiceType");
final _objc_msgSend_323 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_allowsCellularAccess =
    objc.registerName("allowsCellularAccess");
late final _sel_allowsExpensiveNetworkAccess =
    objc.registerName("allowsExpensiveNetworkAccess");
late final _sel_allowsConstrainedNetworkAccess =
    objc.registerName("allowsConstrainedNetworkAccess");
late final _sel_assumesHTTP3Capable = objc.registerName("assumesHTTP3Capable");

abstract class NSURLRequestAttribution {
  static const int NSURLRequestAttributionDeveloper = 0;
  static const int NSURLRequestAttributionUser = 1;
}

late final _sel_attribution = objc.registerName("attribution");
final _objc_msgSend_324 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_requiresDNSSECValidation =
    objc.registerName("requiresDNSSECValidation");
late final _sel_HTTPMethod = objc.registerName("HTTPMethod");
late final _sel_allHTTPHeaderFields = objc.registerName("allHTTPHeaderFields");
late final _sel_valueForHTTPHeaderField_ =
    objc.registerName("valueForHTTPHeaderField:");
late final _sel_HTTPBody = objc.registerName("HTTPBody");
final _objc_msgSend_325 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();

class NSInputStream extends NSStream {
  NSInputStream._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSInputStream] that points to the same underlying object as [other].
  NSInputStream.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSInputStream] that wraps the given raw object pointer.
  NSInputStream.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSInputStream].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSInputStream);
  }

  int read_maxLength_(ffi.Pointer<ffi.Uint8> buffer, int len) {
    return _objc_msgSend_329(this.pointer, _sel_read_maxLength_, buffer, len);
  }

  bool getBuffer_length_(ffi.Pointer<ffi.Pointer<ffi.Uint8>> buffer,
      ffi.Pointer<ffi.UnsignedLong> len) {
    return _objc_msgSend_339(this.pointer, _sel_getBuffer_length_, buffer, len);
  }

  bool get hasBytesAvailable {
    return _objc_msgSend_7(this.pointer, _sel_hasBytesAvailable);
  }

  NSInputStream initWithData_(objc.NSData data) {
    final _ret =
        _objc_msgSend_340(this.pointer, _sel_initWithData_, data.pointer);
    return NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  NSInputStream? initWithURL_(objc.NSURL url) {
    final _ret = _objc_msgSend_3(this.pointer, _sel_initWithURL_, url.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  NSInputStream? initWithFileAtPath_(objc.NSString path) {
    final _ret =
        _objc_msgSend_2(this.pointer, _sel_initWithFileAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSInputStream? inputStreamWithData_(objc.NSData data) {
    final _ret = _objc_msgSend_341(
        _class_NSInputStream, _sel_inputStreamWithData_, data.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSInputStream? inputStreamWithFileAtPath_(objc.NSString path) {
    final _ret = _objc_msgSend_2(
        _class_NSInputStream, _sel_inputStreamWithFileAtPath_, path.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSInputStream? inputStreamWithURL_(objc.NSURL url) {
    final _ret = _objc_msgSend_3(
        _class_NSInputStream, _sel_inputStreamWithURL_, url.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static void getStreamsToHostWithName_port_inputStream_outputStream_(
      objc.NSString hostname,
      int port,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_333(
        _class_NSInputStream,
        _sel_getStreamsToHostWithName_port_inputStream_outputStream_,
        hostname.pointer,
        port,
        inputStream,
        outputStream);
  }

  static void getStreamsToHost_port_inputStream_outputStream_(
      NSHost host,
      int port,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_337(
        _class_NSInputStream,
        _sel_getStreamsToHost_port_inputStream_outputStream_,
        host.pointer,
        port,
        inputStream,
        outputStream);
  }

  static void getBoundStreamsWithBufferSize_inputStream_outputStream_(
      int bufferSize,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_338(
        _class_NSInputStream,
        _sel_getBoundStreamsWithBufferSize_inputStream_outputStream_,
        bufferSize,
        inputStream,
        outputStream);
  }

  @override
  NSInputStream init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSInputStream new1() {
    final _ret = _objc_msgSend_40(_class_NSInputStream, _sel_new);
    return NSInputStream.castFromPointer(_ret, retain: false, release: true);
  }

  static NSInputStream allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSInputStream, _sel_allocWithZone_, zone);
    return NSInputStream.castFromPointer(_ret, retain: false, release: true);
  }

  static NSInputStream alloc() {
    final _ret = _objc_msgSend_40(_class_NSInputStream, _sel_alloc);
    return NSInputStream.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSInputStream,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSInputStream,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSInputStream, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSInputStream, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSInputStream,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSInputStream,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSInputStream,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSInputStream, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSInputStream, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSInputStream = objc.getClass("NSInputStream");

class NSStream extends objc.NSObject {
  NSStream._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSStream] that points to the same underlying object as [other].
  NSStream.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSStream] that wraps the given raw object pointer.
  NSStream.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSStream].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSStream);
  }

  void open() {
    _objc_msgSend_82(this.pointer, _sel_open);
  }

  void close() {
    _objc_msgSend_82(this.pointer, _sel_close);
  }

  objc.NSObject? get delegate {
    final _ret = _objc_msgSend_66(this.pointer, _sel_delegate);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  set delegate(objc.NSObject? value) {
    return _objc_msgSend_188(
        this.pointer, _sel_setDelegate_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSObject? propertyForKey_(objc.NSString key) {
    final _ret =
        _objc_msgSend_2(this.pointer, _sel_propertyForKey_, key.pointer);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  bool setProperty_forKey_(objc.NSObject? property, objc.NSString key) {
    return _objc_msgSend_326(this.pointer, _sel_setProperty_forKey_,
        property?.pointer ?? ffi.nullptr, key.pointer);
  }

  void scheduleInRunLoop_forMode_(NSRunLoop aRunLoop, objc.NSString mode) {
    _objc_msgSend_216(this.pointer, _sel_scheduleInRunLoop_forMode_,
        aRunLoop.pointer, mode.pointer);
  }

  void removeFromRunLoop_forMode_(NSRunLoop aRunLoop, objc.NSString mode) {
    _objc_msgSend_216(this.pointer, _sel_removeFromRunLoop_forMode_,
        aRunLoop.pointer, mode.pointer);
  }

  int get streamStatus {
    return _objc_msgSend_327(this.pointer, _sel_streamStatus);
  }

  objc.NSError? get streamError {
    final _ret = _objc_msgSend_328(this.pointer, _sel_streamError);
    return _ret.address == 0
        ? null
        : objc.NSError.castFromPointer(_ret, retain: true, release: true);
  }

  static void getStreamsToHostWithName_port_inputStream_outputStream_(
      objc.NSString hostname,
      int port,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_333(
        _class_NSStream,
        _sel_getStreamsToHostWithName_port_inputStream_outputStream_,
        hostname.pointer,
        port,
        inputStream,
        outputStream);
  }

  static void getStreamsToHost_port_inputStream_outputStream_(
      NSHost host,
      int port,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_337(
        _class_NSStream,
        _sel_getStreamsToHost_port_inputStream_outputStream_,
        host.pointer,
        port,
        inputStream,
        outputStream);
  }

  static void getBoundStreamsWithBufferSize_inputStream_outputStream_(
      int bufferSize,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_338(
        _class_NSStream,
        _sel_getBoundStreamsWithBufferSize_inputStream_outputStream_,
        bufferSize,
        inputStream,
        outputStream);
  }

  @override
  NSStream init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSStream new1() {
    final _ret = _objc_msgSend_40(_class_NSStream, _sel_new);
    return NSStream.castFromPointer(_ret, retain: false, release: true);
  }

  static NSStream allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSStream, _sel_allocWithZone_, zone);
    return NSStream.castFromPointer(_ret, retain: false, release: true);
  }

  static NSStream alloc() {
    final _ret = _objc_msgSend_40(_class_NSStream, _sel_alloc);
    return NSStream.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSStream,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSStream,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSStream, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSStream, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSStream,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSStream,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSStream,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSStream, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSStream, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSStream = objc.getClass("NSStream");
late final _sel_open = objc.registerName("open");
late final _sel_close = objc.registerName("close");
late final _sel_propertyForKey_ = objc.registerName("propertyForKey:");
late final _sel_setProperty_forKey_ = objc.registerName("setProperty:forKey:");
final _objc_msgSend_326 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

abstract class NSStreamStatus {
  static const int NSStreamStatusNotOpen = 0;
  static const int NSStreamStatusOpening = 1;
  static const int NSStreamStatusOpen = 2;
  static const int NSStreamStatusReading = 3;
  static const int NSStreamStatusWriting = 4;
  static const int NSStreamStatusAtEnd = 5;
  static const int NSStreamStatusClosed = 6;
  static const int NSStreamStatusError = 7;
}

late final _sel_streamStatus = objc.registerName("streamStatus");
final _objc_msgSend_327 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_streamError = objc.registerName("streamError");
final _objc_msgSend_328 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();

class NSOutputStream extends NSStream {
  NSOutputStream._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSOutputStream] that points to the same underlying object as [other].
  NSOutputStream.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSOutputStream] that wraps the given raw object pointer.
  NSOutputStream.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSOutputStream].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSOutputStream);
  }

  int write_maxLength_(ffi.Pointer<ffi.Uint8> buffer, int len) {
    return _objc_msgSend_329(this.pointer, _sel_write_maxLength_, buffer, len);
  }

  bool get hasSpaceAvailable {
    return _objc_msgSend_7(this.pointer, _sel_hasSpaceAvailable);
  }

  NSOutputStream initToMemory() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_initToMemory);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  NSOutputStream initToBuffer_capacity_(
      ffi.Pointer<ffi.Uint8> buffer, int capacity) {
    final _ret = _objc_msgSend_330(
        this.pointer, _sel_initToBuffer_capacity_, buffer, capacity);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  NSOutputStream? initWithURL_append_(objc.NSURL url, bool shouldAppend) {
    final _ret = _objc_msgSend_331(
        this.pointer, _sel_initWithURL_append_, url.pointer, shouldAppend);
    return _ret.address == 0
        ? null
        : NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  NSOutputStream? initToFileAtPath_append_(
      objc.NSString path, bool shouldAppend) {
    final _ret = _objc_msgSend_332(this.pointer, _sel_initToFileAtPath_append_,
        path.pointer, shouldAppend);
    return _ret.address == 0
        ? null
        : NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOutputStream outputStreamToMemory() {
    final _ret =
        _objc_msgSend_40(_class_NSOutputStream, _sel_outputStreamToMemory);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOutputStream outputStreamToBuffer_capacity_(
      ffi.Pointer<ffi.Uint8> buffer, int capacity) {
    final _ret = _objc_msgSend_330(_class_NSOutputStream,
        _sel_outputStreamToBuffer_capacity_, buffer, capacity);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOutputStream outputStreamToFileAtPath_append_(
      objc.NSString path, bool shouldAppend) {
    final _ret = _objc_msgSend_164(_class_NSOutputStream,
        _sel_outputStreamToFileAtPath_append_, path.pointer, shouldAppend);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOutputStream? outputStreamWithURL_append_(
      objc.NSURL url, bool shouldAppend) {
    final _ret = _objc_msgSend_331(_class_NSOutputStream,
        _sel_outputStreamWithURL_append_, url.pointer, shouldAppend);
    return _ret.address == 0
        ? null
        : NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static void getStreamsToHostWithName_port_inputStream_outputStream_(
      objc.NSString hostname,
      int port,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_333(
        _class_NSOutputStream,
        _sel_getStreamsToHostWithName_port_inputStream_outputStream_,
        hostname.pointer,
        port,
        inputStream,
        outputStream);
  }

  static void getStreamsToHost_port_inputStream_outputStream_(
      NSHost host,
      int port,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_337(
        _class_NSOutputStream,
        _sel_getStreamsToHost_port_inputStream_outputStream_,
        host.pointer,
        port,
        inputStream,
        outputStream);
  }

  static void getBoundStreamsWithBufferSize_inputStream_outputStream_(
      int bufferSize,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> inputStream,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outputStream) {
    _objc_msgSend_338(
        _class_NSOutputStream,
        _sel_getBoundStreamsWithBufferSize_inputStream_outputStream_,
        bufferSize,
        inputStream,
        outputStream);
  }

  @override
  NSOutputStream init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOutputStream new1() {
    final _ret = _objc_msgSend_40(_class_NSOutputStream, _sel_new);
    return NSOutputStream.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOutputStream allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSOutputStream, _sel_allocWithZone_, zone);
    return NSOutputStream.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOutputStream alloc() {
    final _ret = _objc_msgSend_40(_class_NSOutputStream, _sel_alloc);
    return NSOutputStream.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSOutputStream,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSOutputStream,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSOutputStream, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSOutputStream, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSOutputStream,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSOutputStream,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSOutputStream,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSOutputStream, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSOutputStream, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSOutputStream = objc.getClass("NSOutputStream");
late final _sel_write_maxLength_ = objc.registerName("write:maxLength:");
final _objc_msgSend_329 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Uint8>,
                ffi.UnsignedLong)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Uint8>, int)>();
late final _sel_hasSpaceAvailable = objc.registerName("hasSpaceAvailable");
late final _sel_initToMemory = objc.registerName("initToMemory");
late final _sel_initToBuffer_capacity_ =
    objc.registerName("initToBuffer:capacity:");
final _objc_msgSend_330 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Uint8>,
                ffi.UnsignedLong)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Uint8>, int)>();
late final _sel_initWithURL_append_ = objc.registerName("initWithURL:append:");
final _objc_msgSend_331 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_initToFileAtPath_append_ =
    objc.registerName("initToFileAtPath:append:");
final _objc_msgSend_332 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_outputStreamToMemory =
    objc.registerName("outputStreamToMemory");
late final _sel_outputStreamToBuffer_capacity_ =
    objc.registerName("outputStreamToBuffer:capacity:");
late final _sel_outputStreamToFileAtPath_append_ =
    objc.registerName("outputStreamToFileAtPath:append:");
late final _sel_outputStreamWithURL_append_ =
    objc.registerName("outputStreamWithURL:append:");
late final _sel_getStreamsToHostWithName_port_inputStream_outputStream_ = objc
    .registerName("getStreamsToHostWithName:port:inputStream:outputStream:");
final _objc_msgSend_333 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();

class NSHost extends objc.NSObject {
  NSHost._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSHost] that points to the same underlying object as [other].
  NSHost.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSHost] that wraps the given raw object pointer.
  NSHost.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSHost].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSHost);
  }

  static NSHost currentHost() {
    final _ret = _objc_msgSend_40(_class_NSHost, _sel_currentHost);
    return NSHost.castFromPointer(_ret, retain: true, release: true);
  }

  static NSHost hostWithName_(objc.NSString? name) {
    final _ret = _objc_msgSend_334(
        _class_NSHost, _sel_hostWithName_, name?.pointer ?? ffi.nullptr);
    return NSHost.castFromPointer(_ret, retain: true, release: true);
  }

  static NSHost hostWithAddress_(objc.NSString address) {
    final _ret =
        _objc_msgSend_35(_class_NSHost, _sel_hostWithAddress_, address.pointer);
    return NSHost.castFromPointer(_ret, retain: true, release: true);
  }

  bool isEqualToHost_(NSHost aHost) {
    return _objc_msgSend_335(this.pointer, _sel_isEqualToHost_, aHost.pointer);
  }

  objc.NSString? get name {
    final _ret = _objc_msgSend_13(this.pointer, _sel_name);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get names {
    final _ret = _objc_msgSend_6(this.pointer, _sel_names);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get address {
    final _ret = _objc_msgSend_13(this.pointer, _sel_address);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get addresses {
    final _ret = _objc_msgSend_6(this.pointer, _sel_addresses);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get localizedName {
    final _ret = _objc_msgSend_13(this.pointer, _sel_localizedName);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static void setHostCacheEnabled_(bool flag) {
    _objc_msgSend_336(_class_NSHost, _sel_setHostCacheEnabled_, flag);
  }

  static bool isHostCacheEnabled() {
    return _objc_msgSend_7(_class_NSHost, _sel_isHostCacheEnabled);
  }

  static void flushHostCache() {
    _objc_msgSend_82(_class_NSHost, _sel_flushHostCache);
  }

  @override
  NSHost init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSHost.castFromPointer(_ret, retain: true, release: true);
  }

  static NSHost new1() {
    final _ret = _objc_msgSend_40(_class_NSHost, _sel_new);
    return NSHost.castFromPointer(_ret, retain: false, release: true);
  }

  static NSHost allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSHost, _sel_allocWithZone_, zone);
    return NSHost.castFromPointer(_ret, retain: false, release: true);
  }

  static NSHost alloc() {
    final _ret = _objc_msgSend_40(_class_NSHost, _sel_alloc);
    return NSHost.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSHost,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSHost,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(_class_NSHost, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSHost, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSHost,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(
        _class_NSHost, _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSHost,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSHost, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(_class_NSHost, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSHost = objc.getClass("NSHost");
late final _sel_currentHost = objc.registerName("currentHost");
late final _sel_hostWithName_ = objc.registerName("hostWithName:");
final _objc_msgSend_334 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_hostWithAddress_ = objc.registerName("hostWithAddress:");
late final _sel_isEqualToHost_ = objc.registerName("isEqualToHost:");
final _objc_msgSend_335 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_names = objc.registerName("names");
late final _sel_address = objc.registerName("address");
late final _sel_addresses = objc.registerName("addresses");
late final _sel_localizedName = objc.registerName("localizedName");
late final _sel_setHostCacheEnabled_ =
    objc.registerName("setHostCacheEnabled:");
final _objc_msgSend_336 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Bool)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, bool)>();
late final _sel_isHostCacheEnabled = objc.registerName("isHostCacheEnabled");
late final _sel_flushHostCache = objc.registerName("flushHostCache");
late final _sel_getStreamsToHost_port_inputStream_outputStream_ =
    objc.registerName("getStreamsToHost:port:inputStream:outputStream:");
final _objc_msgSend_337 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_getBoundStreamsWithBufferSize_inputStream_outputStream_ = objc
    .registerName("getBoundStreamsWithBufferSize:inputStream:outputStream:");
final _objc_msgSend_338 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_read_maxLength_ = objc.registerName("read:maxLength:");
late final _sel_getBuffer_length_ = objc.registerName("getBuffer:length:");
final _objc_msgSend_339 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<ffi.Uint8>>,
                ffi.Pointer<ffi.UnsignedLong>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<ffi.Uint8>>,
            ffi.Pointer<ffi.UnsignedLong>)>();
late final _sel_hasBytesAvailable = objc.registerName("hasBytesAvailable");
late final _sel_initWithData_ = objc.registerName("initWithData:");
final _objc_msgSend_340 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithFileAtPath_ = objc.registerName("initWithFileAtPath:");
late final _sel_inputStreamWithData_ =
    objc.registerName("inputStreamWithData:");
final _objc_msgSend_341 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_inputStreamWithFileAtPath_ =
    objc.registerName("inputStreamWithFileAtPath:");
late final _sel_inputStreamWithURL_ = objc.registerName("inputStreamWithURL:");
late final _sel_HTTPBodyStream = objc.registerName("HTTPBodyStream");
final _objc_msgSend_342 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_HTTPShouldHandleCookies =
    objc.registerName("HTTPShouldHandleCookies");
late final _sel_HTTPShouldUsePipelining =
    objc.registerName("HTTPShouldUsePipelining");
late final _sel_originalRequest = objc.registerName("originalRequest");
final _objc_msgSend_343 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_currentRequest = objc.registerName("currentRequest");

class NSURLResponse extends objc.NSObject {
  NSURLResponse._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLResponse] that points to the same underlying object as [other].
  NSURLResponse.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLResponse] that wraps the given raw object pointer.
  NSURLResponse.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLResponse].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSURLResponse);
  }

  NSURLResponse initWithURL_MIMEType_expectedContentLength_textEncodingName_(
      objc.NSURL URL,
      objc.NSString? MIMEType,
      int length,
      objc.NSString? name) {
    final _ret = _objc_msgSend_344(
        this.pointer,
        _sel_initWithURL_MIMEType_expectedContentLength_textEncodingName_,
        URL.pointer,
        MIMEType?.pointer ?? ffi.nullptr,
        length,
        name?.pointer ?? ffi.nullptr);
    return NSURLResponse.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get URL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_URL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get MIMEType {
    final _ret = _objc_msgSend_13(this.pointer, _sel_MIMEType);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int get expectedContentLength {
    return _objc_msgSend_345(this.pointer, _sel_expectedContentLength);
  }

  objc.NSString? get textEncodingName {
    final _ret = _objc_msgSend_13(this.pointer, _sel_textEncodingName);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get suggestedFilename {
    final _ret = _objc_msgSend_13(this.pointer, _sel_suggestedFilename);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSURLResponse init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLResponse.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLResponse new1() {
    final _ret = _objc_msgSend_40(_class_NSURLResponse, _sel_new);
    return NSURLResponse.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLResponse allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSURLResponse, _sel_allocWithZone_, zone);
    return NSURLResponse.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLResponse alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLResponse, _sel_alloc);
    return NSURLResponse.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLResponse,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLResponse,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSURLResponse, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSURLResponse, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSURLResponse,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSURLResponse,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSURLResponse,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSURLResponse, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSURLResponse, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSURLResponse = objc.getClass("NSURLResponse");
late final _sel_initWithURL_MIMEType_expectedContentLength_textEncodingName_ =
    objc.registerName(
        "initWithURL:MIMEType:expectedContentLength:textEncodingName:");
final _objc_msgSend_344 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_MIMEType = objc.registerName("MIMEType");
late final _sel_expectedContentLength =
    objc.registerName("expectedContentLength");
final _objc_msgSend_345 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.LongLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_textEncodingName = objc.registerName("textEncodingName");
late final _sel_suggestedFilename = objc.registerName("suggestedFilename");
late final _sel_response = objc.registerName("response");
final _objc_msgSend_346 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_progress = objc.registerName("progress");
final _objc_msgSend_347 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_earliestBeginDate = objc.registerName("earliestBeginDate");
late final _sel_setEarliestBeginDate_ =
    objc.registerName("setEarliestBeginDate:");
late final _sel_countOfBytesClientExpectsToSend =
    objc.registerName("countOfBytesClientExpectsToSend");
final _objc_msgSend_348 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int64 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setCountOfBytesClientExpectsToSend_ =
    objc.registerName("setCountOfBytesClientExpectsToSend:");
final _objc_msgSend_349 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int64)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_countOfBytesClientExpectsToReceive =
    objc.registerName("countOfBytesClientExpectsToReceive");
late final _sel_setCountOfBytesClientExpectsToReceive_ =
    objc.registerName("setCountOfBytesClientExpectsToReceive:");
late final _sel_countOfBytesSent = objc.registerName("countOfBytesSent");
late final _sel_countOfBytesReceived =
    objc.registerName("countOfBytesReceived");
late final _sel_countOfBytesExpectedToSend =
    objc.registerName("countOfBytesExpectedToSend");
late final _sel_countOfBytesExpectedToReceive =
    objc.registerName("countOfBytesExpectedToReceive");
late final _sel_taskDescription = objc.registerName("taskDescription");
late final _sel_setTaskDescription_ = objc.registerName("setTaskDescription:");
late final _sel_cancel = objc.registerName("cancel");

abstract class NSURLSessionTaskState {
  static const int NSURLSessionTaskStateRunning = 0;
  static const int NSURLSessionTaskStateSuspended = 1;
  static const int NSURLSessionTaskStateCanceling = 2;
  static const int NSURLSessionTaskStateCompleted = 3;
}

late final _sel_state = objc.registerName("state");
final _objc_msgSend_350 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_error = objc.registerName("error");
late final _sel_suspend = objc.registerName("suspend");
late final _sel_resume = objc.registerName("resume");
late final _sel_priority = objc.registerName("priority");
final _objc_msgSend_351 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Float Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_351Fpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Float Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setPriority_ = objc.registerName("setPriority:");
final _objc_msgSend_352 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Float)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, double)>();
late final _sel_prefersIncrementalDelivery =
    objc.registerName("prefersIncrementalDelivery");
late final _sel_setPrefersIncrementalDelivery_ =
    objc.registerName("setPrefersIncrementalDelivery:");
late final _sel_storeCookies_forTask_ =
    objc.registerName("storeCookies:forTask:");
final _objc_msgSend_353 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
void _ObjCBlock_ffiVoid_NSArray_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>()
        .asFunction<void Function(ffi.Pointer<objc.ObjCObject>)>()(arg0);
final _ObjCBlock_ffiVoid_NSArray_closureRegistry =
    <int, void Function(ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_ffiVoid_NSArray_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_NSArray_registerClosure(
    void Function(ffi.Pointer<objc.ObjCObject>) fn) {
  final id = ++_ObjCBlock_ffiVoid_NSArray_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSArray_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSArray_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    _ObjCBlock_ffiVoid_NSArray_closureRegistry[block.ref.target.address]!(arg0);

class ObjCBlock_ffiVoid_NSArray extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSArray._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSArray castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSArray._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSArray.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSArray_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSArray.fromFunction(void Function(objc.NSArray?) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSArray_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_NSArray_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(arg0.address == 0
                    ? null
                    : objc.NSArray.castFromPointer(arg0,
                        retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSArray.listener(void Function(objc.NSArray?) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>.listener(
                    _ObjCBlock_ffiVoid_NSArray_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSArray_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(arg0.address == 0
                    ? null
                    : objc.NSArray.castFromPointer(arg0, retain: true, release: true)))));
  static ffi.NativeCallable<
          ffi.Void Function(
              ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>?
      _dartFuncListenerTrampoline;

  void call(objc.NSArray? arg0) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0)>>()
          .asFunction<
              void Function(
                  ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>()(
      pointer, arg0?.pointer ?? ffi.nullptr);
}

late final _sel_getCookiesForTask_completionHandler_ =
    objc.registerName("getCookiesForTask:completionHandler:");
final _objc_msgSend_354 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCBlock>)>();

class NSIndexPath extends objc.NSObject {
  NSIndexPath._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSIndexPath] that points to the same underlying object as [other].
  NSIndexPath.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSIndexPath] that wraps the given raw object pointer.
  NSIndexPath.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSIndexPath].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSIndexPath);
  }

  static NSIndexPath indexPathWithIndex_(int index) {
    final _ret =
        _objc_msgSend_355(_class_NSIndexPath, _sel_indexPathWithIndex_, index);
    return NSIndexPath.castFromPointer(_ret, retain: true, release: true);
  }

  static NSIndexPath indexPathWithIndexes_length_(
      ffi.Pointer<ffi.UnsignedLong> indexes, int length) {
    final _ret = _objc_msgSend_356(
        _class_NSIndexPath, _sel_indexPathWithIndexes_length_, indexes, length);
    return NSIndexPath.castFromPointer(_ret, retain: true, release: true);
  }

  NSIndexPath initWithIndexes_length_(
      ffi.Pointer<ffi.UnsignedLong> indexes, int length) {
    final _ret = _objc_msgSend_356(
        this.pointer, _sel_initWithIndexes_length_, indexes, length);
    return NSIndexPath.castFromPointer(_ret, retain: true, release: true);
  }

  NSIndexPath initWithIndex_(int index) {
    final _ret = _objc_msgSend_355(this.pointer, _sel_initWithIndex_, index);
    return NSIndexPath.castFromPointer(_ret, retain: true, release: true);
  }

  NSIndexPath indexPathByAddingIndex_(int index) {
    final _ret =
        _objc_msgSend_357(this.pointer, _sel_indexPathByAddingIndex_, index);
    return NSIndexPath.castFromPointer(_ret, retain: true, release: true);
  }

  NSIndexPath indexPathByRemovingLastIndex() {
    final _ret =
        _objc_msgSend_358(this.pointer, _sel_indexPathByRemovingLastIndex);
    return NSIndexPath.castFromPointer(_ret, retain: true, release: true);
  }

  int indexAtPosition_(int position) {
    return _objc_msgSend_359(this.pointer, _sel_indexAtPosition_, position);
  }

  int get length {
    return _objc_msgSend_29(this.pointer, _sel_length);
  }

  void getIndexes_range_(
      ffi.Pointer<ffi.UnsignedLong> indexes, _NSRange positionRange) {
    _objc_msgSend_360(
        this.pointer, _sel_getIndexes_range_, indexes, positionRange);
  }

  int compare_(NSIndexPath otherObject) {
    return _objc_msgSend_361(this.pointer, _sel_compare_, otherObject.pointer);
  }

  void getIndexes_(ffi.Pointer<ffi.UnsignedLong> indexes) {
    _objc_msgSend_362(this.pointer, _sel_getIndexes_, indexes);
  }

  @override
  NSIndexPath init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSIndexPath.castFromPointer(_ret, retain: true, release: true);
  }

  static NSIndexPath new1() {
    final _ret = _objc_msgSend_40(_class_NSIndexPath, _sel_new);
    return NSIndexPath.castFromPointer(_ret, retain: false, release: true);
  }

  static NSIndexPath allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSIndexPath, _sel_allocWithZone_, zone);
    return NSIndexPath.castFromPointer(_ret, retain: false, release: true);
  }

  static NSIndexPath alloc() {
    final _ret = _objc_msgSend_40(_class_NSIndexPath, _sel_alloc);
    return NSIndexPath.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSIndexPath,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSIndexPath,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSIndexPath, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSIndexPath, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSIndexPath,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSIndexPath,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSIndexPath,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSIndexPath, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSIndexPath, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSIndexPath = objc.getClass("NSIndexPath");
late final _sel_indexPathWithIndex_ = objc.registerName("indexPathWithIndex:");
final _objc_msgSend_355 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_indexPathWithIndexes_length_ =
    objc.registerName("indexPathWithIndexes:length:");
final _objc_msgSend_356 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedLong>,
                ffi.UnsignedLong)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedLong>,
            int)>();
late final _sel_initWithIndexes_length_ =
    objc.registerName("initWithIndexes:length:");
late final _sel_initWithIndex_ = objc.registerName("initWithIndex:");
late final _sel_indexPathByAddingIndex_ =
    objc.registerName("indexPathByAddingIndex:");
final _objc_msgSend_357 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_indexPathByRemovingLastIndex =
    objc.registerName("indexPathByRemovingLastIndex");
final _objc_msgSend_358 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_indexAtPosition_ = objc.registerName("indexAtPosition:");
final _objc_msgSend_359 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_getIndexes_range_ = objc.registerName("getIndexes:range:");
final _objc_msgSend_360 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedLong>,
                _NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedLong>,
            _NSRange)>();
late final _sel_compare_ = objc.registerName("compare:");
final _objc_msgSend_361 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_getIndexes_ = objc.registerName("getIndexes:");
final _objc_msgSend_362 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedLong>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.UnsignedLong>)>();

class NSInflectionRule extends objc.NSObject {
  NSInflectionRule._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSInflectionRule] that points to the same underlying object as [other].
  NSInflectionRule.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSInflectionRule] that wraps the given raw object pointer.
  NSInflectionRule.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSInflectionRule].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSInflectionRule);
  }

  @override
  objc.NSObject init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  static NSInflectionRule getAutomaticRule() {
    final _ret = _objc_msgSend_363(_class_NSInflectionRule, _sel_automaticRule);
    return NSInflectionRule.castFromPointer(_ret, retain: true, release: true);
  }

  static bool canInflectLanguage_(objc.NSString language) {
    return _objc_msgSend_51(
        _class_NSInflectionRule, _sel_canInflectLanguage_, language.pointer);
  }

  static bool getCanInflectPreferredLocalization() {
    return _objc_msgSend_7(
        _class_NSInflectionRule, _sel_canInflectPreferredLocalization);
  }

  static NSInflectionRule new1() {
    final _ret = _objc_msgSend_40(_class_NSInflectionRule, _sel_new);
    return NSInflectionRule.castFromPointer(_ret, retain: false, release: true);
  }

  static NSInflectionRule allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSInflectionRule, _sel_allocWithZone_, zone);
    return NSInflectionRule.castFromPointer(_ret, retain: false, release: true);
  }

  static NSInflectionRule alloc() {
    final _ret = _objc_msgSend_40(_class_NSInflectionRule, _sel_alloc);
    return NSInflectionRule.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSInflectionRule,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSInflectionRule,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSInflectionRule, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSInflectionRule, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSInflectionRule,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSInflectionRule,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSInflectionRule,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSInflectionRule, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSInflectionRule, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSInflectionRule = objc.getClass("NSInflectionRule");
late final _sel_automaticRule = objc.registerName("automaticRule");
final _objc_msgSend_363 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_canInflectLanguage_ = objc.registerName("canInflectLanguage:");
late final _sel_canInflectPreferredLocalization =
    objc.registerName("canInflectPreferredLocalization");

class NSOrderedSet extends objc.NSObject {
  NSOrderedSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSOrderedSet] that points to the same underlying object as [other].
  NSOrderedSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSOrderedSet] that wraps the given raw object pointer.
  NSOrderedSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSOrderedSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSOrderedSet);
  }

  int get count {
    return _objc_msgSend_29(this.pointer, _sel_count);
  }

  objc.NSObject objectAtIndex_(int idx) {
    final _ret = _objc_msgSend_355(this.pointer, _sel_objectAtIndex_, idx);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  int indexOfObject_(objc.NSObject object) {
    return _objc_msgSend_364(this.pointer, _sel_indexOfObject_, object.pointer);
  }

  @override
  NSOrderedSet init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet initWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_365(
        this.pointer, _sel_initWithObjects_count_, objects, cnt);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet? initWithCoder_(objc.NSCoder coder) {
    final _ret =
        _objc_msgSend_231(this.pointer, _sel_initWithCoder_, coder.pointer);
    return _ret.address == 0
        ? null
        : NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  void getObjects_range_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, _NSRange range) {
    _objc_msgSend_366(this.pointer, _sel_getObjects_range_, objects, range);
  }

  objc.NSArray objectsAtIndexes_(objc.NSIndexSet indexes) {
    final _ret = _objc_msgSend_367(
        this.pointer, _sel_objectsAtIndexes_, indexes.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? get firstObject {
    final _ret = _objc_msgSend_66(this.pointer, _sel_firstObject);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject? get lastObject {
    final _ret = _objc_msgSend_66(this.pointer, _sel_lastObject);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  bool isEqualToOrderedSet_(NSOrderedSet other) {
    return _objc_msgSend_368(
        this.pointer, _sel_isEqualToOrderedSet_, other.pointer);
  }

  bool containsObject_(objc.NSObject object) {
    return _objc_msgSend_0(this.pointer, _sel_containsObject_, object.pointer);
  }

  bool intersectsOrderedSet_(NSOrderedSet other) {
    return _objc_msgSend_368(
        this.pointer, _sel_intersectsOrderedSet_, other.pointer);
  }

  bool intersectsSet_(objc.NSSet set) {
    return _objc_msgSend_369(this.pointer, _sel_intersectsSet_, set.pointer);
  }

  bool isSubsetOfOrderedSet_(NSOrderedSet other) {
    return _objc_msgSend_368(
        this.pointer, _sel_isSubsetOfOrderedSet_, other.pointer);
  }

  bool isSubsetOfSet_(objc.NSSet set) {
    return _objc_msgSend_369(this.pointer, _sel_isSubsetOfSet_, set.pointer);
  }

  objc.NSObject objectAtIndexedSubscript_(int idx) {
    final _ret =
        _objc_msgSend_355(this.pointer, _sel_objectAtIndexedSubscript_, idx);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSEnumerator objectEnumerator() {
    final _ret = _objc_msgSend_370(this.pointer, _sel_objectEnumerator);
    return objc.NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSEnumerator reverseObjectEnumerator() {
    final _ret = _objc_msgSend_370(this.pointer, _sel_reverseObjectEnumerator);
    return objc.NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet get reversedOrderedSet {
    final _ret = _objc_msgSend_371(this.pointer, _sel_reversedOrderedSet);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get array {
    final _ret = _objc_msgSend_6(this.pointer, _sel_array);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSSet get set1 {
    final _ret = _objc_msgSend_372(this.pointer, _sel_set);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  void enumerateObjectsUsingBlock_(
      ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool block) {
    _objc_msgSend_373(
        this.pointer, _sel_enumerateObjectsUsingBlock_, block.pointer);
  }

  void enumerateObjectsWithOptions_usingBlock_(
      int opts, ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool block) {
    _objc_msgSend_374(this.pointer,
        _sel_enumerateObjectsWithOptions_usingBlock_, opts, block.pointer);
  }

  void enumerateObjectsAtIndexes_options_usingBlock_(objc.NSIndexSet s,
      int opts, ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool block) {
    _objc_msgSend_375(
        this.pointer,
        _sel_enumerateObjectsAtIndexes_options_usingBlock_,
        s.pointer,
        opts,
        block.pointer);
  }

  int indexOfObjectPassingTest_(
      ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool predicate) {
    return _objc_msgSend_376(
        this.pointer, _sel_indexOfObjectPassingTest_, predicate.pointer);
  }

  int indexOfObjectWithOptions_passingTest_(
      int opts, ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool predicate) {
    return _objc_msgSend_377(this.pointer,
        _sel_indexOfObjectWithOptions_passingTest_, opts, predicate.pointer);
  }

  int indexOfObjectAtIndexes_options_passingTest_(objc.NSIndexSet s, int opts,
      ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool predicate) {
    return _objc_msgSend_378(
        this.pointer,
        _sel_indexOfObjectAtIndexes_options_passingTest_,
        s.pointer,
        opts,
        predicate.pointer);
  }

  objc.NSIndexSet indexesOfObjectsPassingTest_(
      ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool predicate) {
    final _ret = _objc_msgSend_379(
        this.pointer, _sel_indexesOfObjectsPassingTest_, predicate.pointer);
    return objc.NSIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSIndexSet indexesOfObjectsWithOptions_passingTest_(
      int opts, ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool predicate) {
    final _ret = _objc_msgSend_380(this.pointer,
        _sel_indexesOfObjectsWithOptions_passingTest_, opts, predicate.pointer);
    return objc.NSIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSIndexSet indexesOfObjectsAtIndexes_options_passingTest_(
      objc.NSIndexSet s,
      int opts,
      ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool predicate) {
    final _ret = _objc_msgSend_381(
        this.pointer,
        _sel_indexesOfObjectsAtIndexes_options_passingTest_,
        s.pointer,
        opts,
        predicate.pointer);
    return objc.NSIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  int indexOfObject_inSortedRange_options_usingComparator_(
      objc.NSObject object,
      _NSRange range,
      int opts,
      ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject cmp) {
    return _objc_msgSend_382(
        this.pointer,
        _sel_indexOfObject_inSortedRange_options_usingComparator_,
        object.pointer,
        range,
        opts,
        cmp.pointer);
  }

  objc.NSArray sortedArrayUsingComparator_(
      ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject cmptr) {
    final _ret = _objc_msgSend_383(
        this.pointer, _sel_sortedArrayUsingComparator_, cmptr.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray sortedArrayWithOptions_usingComparator_(int opts,
      ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject cmptr) {
    final _ret = _objc_msgSend_384(this.pointer,
        _sel_sortedArrayWithOptions_usingComparator_, opts, cmptr.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get description {
    final _ret = _objc_msgSend_12(this.pointer, _sel_description);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString descriptionWithLocale_(objc.NSObject? locale) {
    final _ret = _objc_msgSend_385(this.pointer, _sel_descriptionWithLocale_,
        locale?.pointer ?? ffi.nullptr);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString descriptionWithLocale_indent_(
      objc.NSObject? locale, int level) {
    final _ret = _objc_msgSend_386(
        this.pointer,
        _sel_descriptionWithLocale_indent_,
        locale?.pointer ?? ffi.nullptr,
        level);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet orderedSet() {
    final _ret = _objc_msgSend_40(_class_NSOrderedSet, _sel_orderedSet);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet orderedSetWithObject_(objc.NSObject object) {
    final _ret = _objc_msgSend_387(
        _class_NSOrderedSet, _sel_orderedSetWithObject_, object.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet orderedSetWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_365(
        _class_NSOrderedSet, _sel_orderedSetWithObjects_count_, objects, cnt);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet orderedSetWithObjects_(objc.NSObject firstObj) {
    final _ret = _objc_msgSend_387(
        _class_NSOrderedSet, _sel_orderedSetWithObjects_, firstObj.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet orderedSetWithOrderedSet_(NSOrderedSet set) {
    final _ret = _objc_msgSend_388(
        _class_NSOrderedSet, _sel_orderedSetWithOrderedSet_, set.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet orderedSetWithOrderedSet_range_copyItems_(
      NSOrderedSet set, _NSRange range, bool flag) {
    final _ret = _objc_msgSend_389(
        _class_NSOrderedSet,
        _sel_orderedSetWithOrderedSet_range_copyItems_,
        set.pointer,
        range,
        flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOrderedSet orderedSetWithArray_(objc.NSArray array) {
    final _ret = _objc_msgSend_390(
        _class_NSOrderedSet, _sel_orderedSetWithArray_, array.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet orderedSetWithArray_range_copyItems_(
      objc.NSArray array, _NSRange range, bool flag) {
    final _ret = _objc_msgSend_391(_class_NSOrderedSet,
        _sel_orderedSetWithArray_range_copyItems_, array.pointer, range, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOrderedSet orderedSetWithSet_(objc.NSSet set) {
    final _ret = _objc_msgSend_392(
        _class_NSOrderedSet, _sel_orderedSetWithSet_, set.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet orderedSetWithSet_copyItems_(objc.NSSet set, bool flag) {
    final _ret = _objc_msgSend_393(_class_NSOrderedSet,
        _sel_orderedSetWithSet_copyItems_, set.pointer, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  NSOrderedSet initWithObject_(objc.NSObject object) {
    final _ret =
        _objc_msgSend_387(this.pointer, _sel_initWithObject_, object.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet initWithObjects_(objc.NSObject firstObj) {
    final _ret = _objc_msgSend_387(
        this.pointer, _sel_initWithObjects_, firstObj.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet initWithOrderedSet_(NSOrderedSet set) {
    final _ret =
        _objc_msgSend_388(this.pointer, _sel_initWithOrderedSet_, set.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet initWithOrderedSet_copyItems_(NSOrderedSet set, bool flag) {
    final _ret = _objc_msgSend_394(
        this.pointer, _sel_initWithOrderedSet_copyItems_, set.pointer, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  NSOrderedSet initWithOrderedSet_range_copyItems_(
      NSOrderedSet set, _NSRange range, bool flag) {
    final _ret = _objc_msgSend_389(this.pointer,
        _sel_initWithOrderedSet_range_copyItems_, set.pointer, range, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  NSOrderedSet initWithArray_(objc.NSArray array) {
    final _ret =
        _objc_msgSend_390(this.pointer, _sel_initWithArray_, array.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet initWithArray_copyItems_(objc.NSArray set, bool flag) {
    final _ret = _objc_msgSend_395(
        this.pointer, _sel_initWithArray_copyItems_, set.pointer, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  NSOrderedSet initWithArray_range_copyItems_(
      objc.NSArray set, _NSRange range, bool flag) {
    final _ret = _objc_msgSend_391(this.pointer,
        _sel_initWithArray_range_copyItems_, set.pointer, range, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  NSOrderedSet initWithSet_(objc.NSSet set) {
    final _ret =
        _objc_msgSend_392(this.pointer, _sel_initWithSet_, set.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet initWithSet_copyItems_(objc.NSSet set, bool flag) {
    final _ret = _objc_msgSend_393(
        this.pointer, _sel_initWithSet_copyItems_, set.pointer, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  objc.NSObject differenceFromOrderedSet_withOptions_usingEquivalenceTest_(
      NSOrderedSet other,
      int options,
      ObjCBlock_bool_objcObjCObject_objcObjCObject block) {
    final _ret = _objc_msgSend_396(
        this.pointer,
        _sel_differenceFromOrderedSet_withOptions_usingEquivalenceTest_,
        other.pointer,
        options,
        block.pointer);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject differenceFromOrderedSet_withOptions_(
      NSOrderedSet other, int options) {
    final _ret = _objc_msgSend_397(this.pointer,
        _sel_differenceFromOrderedSet_withOptions_, other.pointer, options);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject differenceFromOrderedSet_(NSOrderedSet other) {
    final _ret = _objc_msgSend_388(
        this.pointer, _sel_differenceFromOrderedSet_, other.pointer);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet? orderedSetByApplyingDifference_(objc.NSObject difference) {
    final _ret = _objc_msgSend_398(
        this.pointer, _sel_orderedSetByApplyingDifference_, difference.pointer);
    return _ret.address == 0
        ? null
        : NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSObject valueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_35(this.pointer, _sel_valueForKey_, key.pointer);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  void setValue_forKey_(objc.NSObject? value, objc.NSString key) {
    _objc_msgSend_399(this.pointer, _sel_setValue_forKey_,
        value?.pointer ?? ffi.nullptr, key.pointer);
  }

  void addObserver_forKeyPath_options_context_(objc.NSObject observer,
      objc.NSString keyPath, int options, ffi.Pointer<ffi.Void> context) {
    _objc_msgSend_400(
        this.pointer,
        _sel_addObserver_forKeyPath_options_context_,
        observer.pointer,
        keyPath.pointer,
        options,
        context);
  }

  void removeObserver_forKeyPath_context_(objc.NSObject observer,
      objc.NSString keyPath, ffi.Pointer<ffi.Void> context) {
    _objc_msgSend_401(this.pointer, _sel_removeObserver_forKeyPath_context_,
        observer.pointer, keyPath.pointer, context);
  }

  void removeObserver_forKeyPath_(
      objc.NSObject observer, objc.NSString keyPath) {
    _objc_msgSend_402(this.pointer, _sel_removeObserver_forKeyPath_,
        observer.pointer, keyPath.pointer);
  }

  objc.NSArray sortedArrayUsingDescriptors_(objc.NSArray sortDescriptors) {
    final _ret = _objc_msgSend_67(this.pointer,
        _sel_sortedArrayUsingDescriptors_, sortDescriptors.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrderedSet filteredOrderedSetUsingPredicate_(NSPredicate p) {
    final _ret = _objc_msgSend_412(
        this.pointer, _sel_filteredOrderedSetUsingPredicate_, p.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrderedSet new1() {
    final _ret = _objc_msgSend_40(_class_NSOrderedSet, _sel_new);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOrderedSet allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSOrderedSet, _sel_allocWithZone_, zone);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOrderedSet alloc() {
    final _ret = _objc_msgSend_40(_class_NSOrderedSet, _sel_alloc);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSOrderedSet,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSOrderedSet,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSOrderedSet, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSOrderedSet, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSOrderedSet,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSOrderedSet,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSOrderedSet,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSOrderedSet, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSOrderedSet, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSOrderedSet = objc.getClass("NSOrderedSet");
late final _sel_count = objc.registerName("count");
late final _sel_objectAtIndex_ = objc.registerName("objectAtIndex:");
late final _sel_indexOfObject_ = objc.registerName("indexOfObject:");
final _objc_msgSend_364 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithObjects_count_ =
    objc.registerName("initWithObjects:count:");
final _objc_msgSend_365 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
late final _sel_getObjects_range_ = objc.registerName("getObjects:range:");
final _objc_msgSend_366 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                _NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            _NSRange)>();
late final _sel_objectsAtIndexes_ = objc.registerName("objectsAtIndexes:");
final _objc_msgSend_367 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_firstObject = objc.registerName("firstObject");
late final _sel_lastObject = objc.registerName("lastObject");
late final _sel_isEqualToOrderedSet_ =
    objc.registerName("isEqualToOrderedSet:");
final _objc_msgSend_368 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_containsObject_ = objc.registerName("containsObject:");
late final _sel_intersectsOrderedSet_ =
    objc.registerName("intersectsOrderedSet:");
late final _sel_intersectsSet_ = objc.registerName("intersectsSet:");
final _objc_msgSend_369 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_isSubsetOfOrderedSet_ =
    objc.registerName("isSubsetOfOrderedSet:");
late final _sel_isSubsetOfSet_ = objc.registerName("isSubsetOfSet:");
late final _sel_objectAtIndexedSubscript_ =
    objc.registerName("objectAtIndexedSubscript:");
late final _sel_objectEnumerator = objc.registerName("objectEnumerator");
final _objc_msgSend_370 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_reverseObjectEnumerator =
    objc.registerName("reverseObjectEnumerator");
late final _sel_reversedOrderedSet = objc.registerName("reversedOrderedSet");
final _objc_msgSend_371 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_array = objc.registerName("array");
late final _sel_set = objc.registerName("set");
final _objc_msgSend_372 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
void _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        int arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.UnsignedLong arg1, ffi.Pointer<ffi.Bool> arg2)>>()
        .asFunction<
            void Function(ffi.Pointer<objc.ObjCObject>, int,
                ffi.Pointer<ffi.Bool>)>()(arg0, arg1, arg2);
final _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_closureRegistry =
    <int,
        void Function(
            ffi.Pointer<objc.ObjCObject>, int, ffi.Pointer<ffi.Bool>)>{};
int _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_closureRegistryIndex =
    0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_registerClosure(
        void Function(ffi.Pointer<objc.ObjCObject>, int, ffi.Pointer<ffi.Bool>)
            fn) {
  final id =
      ++_ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_closureRegistryIndex;
  _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_closureRegistry[id] =
      fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        int arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_closureRegistry[
        block.ref.target.address]!(arg0, arg1, arg2);

class ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool
    extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.UnsignedLong arg1, ffi.Pointer<ffi.Bool> arg2)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.UnsignedLong,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool.fromFunction(
      void Function(objc.NSObject, int, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.UnsignedLong,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, int arg1,
                        ffi.Pointer<ffi.Bool> arg2) =>
                    fn(objc.NSObject.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool.listener(
      void Function(objc.NSObject, int, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.UnsignedLong,
                            ffi.Pointer<ffi.Bool>)>.listener(
                    _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_objcObjCObject_ffiUnsignedLong_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, int arg1,
                        ffi.Pointer<ffi.Bool> arg2) =>
                    fn(objc.NSObject.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.NativeCallable<
      ffi.Void Function(
          ffi.Pointer<objc.ObjCBlock>,
          ffi.Pointer<objc.ObjCObject>,
          ffi.UnsignedLong,
          ffi.Pointer<ffi.Bool>)>? _dartFuncListenerTrampoline;

  void call(objc.NSObject arg0, int arg1, ffi.Pointer<ffi.Bool> arg2) =>
      pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.UnsignedLong arg1,
                      ffi.Pointer<ffi.Bool> arg2)>>()
          .asFunction<
              void Function(
                  ffi.Pointer<objc.ObjCBlock>,
                  ffi.Pointer<objc.ObjCObject>,
                  int,
                  ffi.Pointer<ffi.Bool>)>()(pointer, arg0.pointer, arg1, arg2);
}

late final _sel_enumerateObjectsUsingBlock_ =
    objc.registerName("enumerateObjectsUsingBlock:");
final _objc_msgSend_373 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();

abstract class NSEnumerationOptions {
  static const int NSEnumerationConcurrent = 1;
  static const int NSEnumerationReverse = 2;
}

late final _sel_enumerateObjectsWithOptions_usingBlock_ =
    objc.registerName("enumerateObjectsWithOptions:usingBlock:");
final _objc_msgSend_374 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_enumerateObjectsAtIndexes_options_usingBlock_ =
    objc.registerName("enumerateObjectsAtIndexes:options:usingBlock:");
final _objc_msgSend_375 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
bool _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        int arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.UnsignedLong arg1, ffi.Pointer<ffi.Bool> arg2)>>()
        .asFunction<
            bool Function(ffi.Pointer<objc.ObjCObject>, int,
                ffi.Pointer<ffi.Bool>)>()(arg0, arg1, arg2);
final _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_closureRegistry =
    <int,
        bool Function(
            ffi.Pointer<objc.ObjCObject>, int, ffi.Pointer<ffi.Bool>)>{};
int _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_closureRegistryIndex =
    0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_registerClosure(
        bool Function(ffi.Pointer<objc.ObjCObject>, int, ffi.Pointer<ffi.Bool>)
            fn) {
  final id =
      ++_ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_closureRegistryIndex;
  _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

bool _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        int arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_closureRegistry[
        block.ref.target.address]!(arg0, arg1, arg2);

class ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool
    extends objc.ObjCBlockBase {
  ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Bool Function(ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.UnsignedLong arg1, ffi.Pointer<ffi.Bool> arg2)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Bool Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.UnsignedLong,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_fnPtrTrampoline,
                    false)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool.fromFunction(
      bool Function(objc.NSObject, int, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Bool Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.UnsignedLong,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_closureTrampoline, false)
                .cast(),
            _ObjCBlock_bool_objcObjCObject_ffiUnsignedLong_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, int arg1, ffi.Pointer<ffi.Bool> arg2) =>
                    fn(objc.NSObject.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  bool call(objc.NSObject arg0, int arg1, ffi.Pointer<ffi.Bool> arg2) =>
      pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Bool Function(
                      ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.UnsignedLong arg1,
                      ffi.Pointer<ffi.Bool> arg2)>>()
          .asFunction<
              bool Function(
                  ffi.Pointer<objc.ObjCBlock>,
                  ffi.Pointer<objc.ObjCObject>,
                  int,
                  ffi.Pointer<ffi.Bool>)>()(pointer, arg0.pointer, arg1, arg2);
}

late final _sel_indexOfObjectPassingTest_ =
    objc.registerName("indexOfObjectPassingTest:");
final _objc_msgSend_376 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_indexOfObjectWithOptions_passingTest_ =
    objc.registerName("indexOfObjectWithOptions:passingTest:");
final _objc_msgSend_377 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_indexOfObjectAtIndexes_options_passingTest_ =
    objc.registerName("indexOfObjectAtIndexes:options:passingTest:");
final _objc_msgSend_378 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_indexesOfObjectsPassingTest_ =
    objc.registerName("indexesOfObjectsPassingTest:");
final _objc_msgSend_379 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_indexesOfObjectsWithOptions_passingTest_ =
    objc.registerName("indexesOfObjectsWithOptions:passingTest:");
final _objc_msgSend_380 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_indexesOfObjectsAtIndexes_options_passingTest_ =
    objc.registerName("indexesOfObjectsAtIndexes:options:passingTest:");
final _objc_msgSend_381 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
int _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Int32 Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            int Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
final _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_closureRegistry =
    <int,
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_closureRegistryIndex =
    0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_registerClosure(
        int Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)
            fn) {
  final id =
      ++_ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_closureRegistryIndex;
  _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_closureRegistry[
      id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

int _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_closureRegistry[
        block.ref.target.address]!(arg0, arg1);

class ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject
    extends objc.ObjCBlockBase {
  ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject
      castFromPointer(ffi.Pointer<objc.ObjCBlock> pointer,
          {bool retain = false, bool release = false}) {
    return ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Int32 Function(ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Int32 Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_fnPtrTrampoline,
                    0)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject.fromFunction(
      int Function(objc.NSObject, objc.NSObject) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Int32 Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_closureTrampoline, 0)
                .cast(),
            _ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, ffi.Pointer<objc.ObjCObject> arg1) =>
                    fn(objc.NSObject.castFromPointer(arg0, retain: true, release: true), objc.NSObject.castFromPointer(arg1, retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  int call(objc.NSObject arg0, objc.NSObject arg1) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Int32 Function(
                      ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>()
          .asFunction<
              int Function(
                  ffi.Pointer<objc.ObjCBlock>,
                  ffi.Pointer<objc.ObjCObject>,
                  ffi.Pointer<objc.ObjCObject>)>()(
      pointer, arg0.pointer, arg1.pointer);
}

late final _sel_indexOfObject_inSortedRange_options_usingComparator_ =
    objc.registerName("indexOfObject:inSortedRange:options:usingComparator:");
final _objc_msgSend_382 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_sortedArrayUsingComparator_ =
    objc.registerName("sortedArrayUsingComparator:");
final _objc_msgSend_383 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();

abstract class NSSortOptions {
  static const int NSSortConcurrent = 1;
  static const int NSSortStable = 16;
}

late final _sel_sortedArrayWithOptions_usingComparator_ =
    objc.registerName("sortedArrayWithOptions:usingComparator:");
final _objc_msgSend_384 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_descriptionWithLocale_ =
    objc.registerName("descriptionWithLocale:");
final _objc_msgSend_385 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_descriptionWithLocale_indent_ =
    objc.registerName("descriptionWithLocale:indent:");
final _objc_msgSend_386 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_orderedSet = objc.registerName("orderedSet");
late final _sel_orderedSetWithObject_ =
    objc.registerName("orderedSetWithObject:");
final _objc_msgSend_387 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_orderedSetWithObjects_count_ =
    objc.registerName("orderedSetWithObjects:count:");
late final _sel_orderedSetWithObjects_ =
    objc.registerName("orderedSetWithObjects:");
late final _sel_orderedSetWithOrderedSet_ =
    objc.registerName("orderedSetWithOrderedSet:");
final _objc_msgSend_388 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_orderedSetWithOrderedSet_range_copyItems_ =
    objc.registerName("orderedSetWithOrderedSet:range:copyItems:");
final _objc_msgSend_389 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange,
            bool)>();
late final _sel_orderedSetWithArray_ =
    objc.registerName("orderedSetWithArray:");
final _objc_msgSend_390 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_orderedSetWithArray_range_copyItems_ =
    objc.registerName("orderedSetWithArray:range:copyItems:");
final _objc_msgSend_391 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                _NSRange,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            _NSRange,
            bool)>();
late final _sel_orderedSetWithSet_ = objc.registerName("orderedSetWithSet:");
final _objc_msgSend_392 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_orderedSetWithSet_copyItems_ =
    objc.registerName("orderedSetWithSet:copyItems:");
final _objc_msgSend_393 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_initWithObject_ = objc.registerName("initWithObject:");
late final _sel_initWithObjects_ = objc.registerName("initWithObjects:");
late final _sel_initWithOrderedSet_ = objc.registerName("initWithOrderedSet:");
late final _sel_initWithOrderedSet_copyItems_ =
    objc.registerName("initWithOrderedSet:copyItems:");
final _objc_msgSend_394 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_initWithOrderedSet_range_copyItems_ =
    objc.registerName("initWithOrderedSet:range:copyItems:");
late final _sel_initWithArray_ = objc.registerName("initWithArray:");
late final _sel_initWithArray_copyItems_ =
    objc.registerName("initWithArray:copyItems:");
final _objc_msgSend_395 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_initWithArray_range_copyItems_ =
    objc.registerName("initWithArray:range:copyItems:");
late final _sel_initWithSet_ = objc.registerName("initWithSet:");
late final _sel_initWithSet_copyItems_ =
    objc.registerName("initWithSet:copyItems:");

abstract class NSOrderedCollectionDifferenceCalculationOptions {
  static const int NSOrderedCollectionDifferenceCalculationOmitInsertedObjects =
      1;
  static const int NSOrderedCollectionDifferenceCalculationOmitRemovedObjects =
      2;
  static const int NSOrderedCollectionDifferenceCalculationInferMoves = 4;
}

bool _ObjCBlock_bool_objcObjCObject_objcObjCObject_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
final _ObjCBlock_bool_objcObjCObject_objcObjCObject_closureRegistry = <int,
    bool Function(
        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_bool_objcObjCObject_objcObjCObject_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_bool_objcObjCObject_objcObjCObject_registerClosure(
        bool Function(
                ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)
            fn) {
  final id =
      ++_ObjCBlock_bool_objcObjCObject_objcObjCObject_closureRegistryIndex;
  _ObjCBlock_bool_objcObjCObject_objcObjCObject_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

bool _ObjCBlock_bool_objcObjCObject_objcObjCObject_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    _ObjCBlock_bool_objcObjCObject_objcObjCObject_closureRegistry[
        block.ref.target.address]!(arg0, arg1);

class ObjCBlock_bool_objcObjCObject_objcObjCObject extends objc.ObjCBlockBase {
  ObjCBlock_bool_objcObjCObject_objcObjCObject._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_bool_objcObjCObject_objcObjCObject castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_bool_objcObjCObject_objcObjCObject._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_bool_objcObjCObject_objcObjCObject.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Bool Function(ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Bool Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_bool_objcObjCObject_objcObjCObject_fnPtrTrampoline,
                    false)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_bool_objcObjCObject_objcObjCObject.fromFunction(
      bool Function(objc.NSObject, objc.NSObject) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Bool Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_bool_objcObjCObject_objcObjCObject_closureTrampoline, false)
                .cast(),
            _ObjCBlock_bool_objcObjCObject_objcObjCObject_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, ffi.Pointer<objc.ObjCObject> arg1) =>
                    fn(objc.NSObject.castFromPointer(arg0, retain: true, release: true), objc.NSObject.castFromPointer(arg1, retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  bool call(objc.NSObject arg0, objc.NSObject arg1) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Bool Function(
                      ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>()
          .asFunction<
              bool Function(
                  ffi.Pointer<objc.ObjCBlock>,
                  ffi.Pointer<objc.ObjCObject>,
                  ffi.Pointer<objc.ObjCObject>)>()(
      pointer, arg0.pointer, arg1.pointer);
}

late final _sel_differenceFromOrderedSet_withOptions_usingEquivalenceTest_ =
    objc.registerName(
        "differenceFromOrderedSet:withOptions:usingEquivalenceTest:");
final _objc_msgSend_396 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_differenceFromOrderedSet_withOptions_ =
    objc.registerName("differenceFromOrderedSet:withOptions:");
final _objc_msgSend_397 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_differenceFromOrderedSet_ =
    objc.registerName("differenceFromOrderedSet:");
late final _sel_orderedSetByApplyingDifference_ =
    objc.registerName("orderedSetByApplyingDifference:");
final _objc_msgSend_398 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_valueForKey_ = objc.registerName("valueForKey:");
late final _sel_setValue_forKey_ = objc.registerName("setValue:forKey:");
final _objc_msgSend_399 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

abstract class NSKeyValueObservingOptions {
  static const int NSKeyValueObservingOptionNew = 1;
  static const int NSKeyValueObservingOptionOld = 2;
  static const int NSKeyValueObservingOptionInitial = 4;
  static const int NSKeyValueObservingOptionPrior = 8;
}

late final _sel_addObserver_forKeyPath_options_context_ =
    objc.registerName("addObserver:forKeyPath:options:context:");
final _objc_msgSend_400 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<ffi.Void>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Void>)>();
late final _sel_removeObserver_forKeyPath_context_ =
    objc.registerName("removeObserver:forKeyPath:context:");
final _objc_msgSend_401 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Void>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Void>)>();
late final _sel_removeObserver_forKeyPath_ =
    objc.registerName("removeObserver:forKeyPath:");
final _objc_msgSend_402 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_sortedArrayUsingDescriptors_ =
    objc.registerName("sortedArrayUsingDescriptors:");

class NSPredicate extends objc.NSObject {
  NSPredicate._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSPredicate] that points to the same underlying object as [other].
  NSPredicate.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSPredicate] that wraps the given raw object pointer.
  NSPredicate.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSPredicate].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSPredicate);
  }

  static NSPredicate predicateWithFormat_argumentArray_(
      objc.NSString predicateFormat, objc.NSArray? arguments) {
    final _ret = _objc_msgSend_403(
        _class_NSPredicate,
        _sel_predicateWithFormat_argumentArray_,
        predicateFormat.pointer,
        arguments?.pointer ?? ffi.nullptr);
    return NSPredicate.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPredicate predicateWithFormat_(objc.NSString predicateFormat) {
    final _ret = _objc_msgSend_404(
        _class_NSPredicate, _sel_predicateWithFormat_, predicateFormat.pointer);
    return NSPredicate.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPredicate predicateWithFormat_arguments_(
      objc.NSString predicateFormat, ffi.Pointer<__va_list_tag> argList) {
    final _ret = _objc_msgSend_405(_class_NSPredicate,
        _sel_predicateWithFormat_arguments_, predicateFormat.pointer, argList);
    return NSPredicate.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPredicate? predicateFromMetadataQueryString_(
      objc.NSString queryString) {
    final _ret = _objc_msgSend_406(_class_NSPredicate,
        _sel_predicateFromMetadataQueryString_, queryString.pointer);
    return _ret.address == 0
        ? null
        : NSPredicate.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPredicate predicateWithValue_(bool value) {
    final _ret =
        _objc_msgSend_407(_class_NSPredicate, _sel_predicateWithValue_, value);
    return NSPredicate.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPredicate predicateWithBlock_(
      ObjCBlock_bool_objcObjCObject_NSDictionary block) {
    final _ret = _objc_msgSend_408(
        _class_NSPredicate, _sel_predicateWithBlock_, block.pointer);
    return NSPredicate.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get predicateFormat {
    final _ret = _objc_msgSend_12(this.pointer, _sel_predicateFormat);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  NSPredicate predicateWithSubstitutionVariables_(objc.NSDictionary variables) {
    final _ret = _objc_msgSend_409(this.pointer,
        _sel_predicateWithSubstitutionVariables_, variables.pointer);
    return NSPredicate.castFromPointer(_ret, retain: true, release: true);
  }

  bool evaluateWithObject_(objc.NSObject? object) {
    return _objc_msgSend_410(
        this.pointer, _sel_evaluateWithObject_, object?.pointer ?? ffi.nullptr);
  }

  bool evaluateWithObject_substitutionVariables_(
      objc.NSObject? object, objc.NSDictionary? bindings) {
    return _objc_msgSend_411(
        this.pointer,
        _sel_evaluateWithObject_substitutionVariables_,
        object?.pointer ?? ffi.nullptr,
        bindings?.pointer ?? ffi.nullptr);
  }

  void allowEvaluation() {
    _objc_msgSend_82(this.pointer, _sel_allowEvaluation);
  }

  @override
  NSPredicate init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSPredicate.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPredicate new1() {
    final _ret = _objc_msgSend_40(_class_NSPredicate, _sel_new);
    return NSPredicate.castFromPointer(_ret, retain: false, release: true);
  }

  static NSPredicate allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSPredicate, _sel_allocWithZone_, zone);
    return NSPredicate.castFromPointer(_ret, retain: false, release: true);
  }

  static NSPredicate alloc() {
    final _ret = _objc_msgSend_40(_class_NSPredicate, _sel_alloc);
    return NSPredicate.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSPredicate,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSPredicate,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSPredicate, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSPredicate, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSPredicate,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSPredicate,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSPredicate,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSPredicate, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSPredicate, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSPredicate = objc.getClass("NSPredicate");
late final _sel_predicateWithFormat_argumentArray_ =
    objc.registerName("predicateWithFormat:argumentArray:");
final _objc_msgSend_403 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_predicateWithFormat_ =
    objc.registerName("predicateWithFormat:");
final _objc_msgSend_404 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_predicateWithFormat_arguments_ =
    objc.registerName("predicateWithFormat:arguments:");
final _objc_msgSend_405 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<__va_list_tag>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<__va_list_tag>)>();
late final _sel_predicateFromMetadataQueryString_ =
    objc.registerName("predicateFromMetadataQueryString:");
final _objc_msgSend_406 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_predicateWithValue_ = objc.registerName("predicateWithValue:");
final _objc_msgSend_407 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, bool)>();
bool _ObjCBlock_bool_objcObjCObject_NSDictionary_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
final _ObjCBlock_bool_objcObjCObject_NSDictionary_closureRegistry = <int,
    bool Function(
        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_bool_objcObjCObject_NSDictionary_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_bool_objcObjCObject_NSDictionary_registerClosure(
        bool Function(
                ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)
            fn) {
  final id = ++_ObjCBlock_bool_objcObjCObject_NSDictionary_closureRegistryIndex;
  _ObjCBlock_bool_objcObjCObject_NSDictionary_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

bool _ObjCBlock_bool_objcObjCObject_NSDictionary_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    _ObjCBlock_bool_objcObjCObject_NSDictionary_closureRegistry[
        block.ref.target.address]!(arg0, arg1);

class ObjCBlock_bool_objcObjCObject_NSDictionary extends objc.ObjCBlockBase {
  ObjCBlock_bool_objcObjCObject_NSDictionary._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_bool_objcObjCObject_NSDictionary castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_bool_objcObjCObject_NSDictionary._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_bool_objcObjCObject_NSDictionary.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Bool Function(ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Bool Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_bool_objcObjCObject_NSDictionary_fnPtrTrampoline,
                    false)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_bool_objcObjCObject_NSDictionary.fromFunction(
      bool Function(objc.NSObject?, objc.NSDictionary?) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??=
                ffi.Pointer.fromFunction<ffi.Bool Function(ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>(
                        _ObjCBlock_bool_objcObjCObject_NSDictionary_closureTrampoline, false)
                    .cast(),
            _ObjCBlock_bool_objcObjCObject_NSDictionary_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, ffi.Pointer<objc.ObjCObject> arg1) => fn(
                    arg0.address == 0
                        ? null
                        : objc.NSObject.castFromPointer(arg0, retain: true, release: true),
                    arg1.address == 0 ? null : objc.NSDictionary.castFromPointer(arg1, retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  bool call(objc.NSObject? arg0, objc.NSDictionary? arg1) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Bool Function(
                      ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>()
          .asFunction<
              bool Function(
                  ffi.Pointer<objc.ObjCBlock>,
                  ffi.Pointer<objc.ObjCObject>,
                  ffi.Pointer<objc.ObjCObject>)>()(
      pointer, arg0?.pointer ?? ffi.nullptr, arg1?.pointer ?? ffi.nullptr);
}

late final _sel_predicateWithBlock_ = objc.registerName("predicateWithBlock:");
final _objc_msgSend_408 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_predicateFormat = objc.registerName("predicateFormat");
late final _sel_predicateWithSubstitutionVariables_ =
    objc.registerName("predicateWithSubstitutionVariables:");
final _objc_msgSend_409 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_evaluateWithObject_ = objc.registerName("evaluateWithObject:");
final _objc_msgSend_410 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_evaluateWithObject_substitutionVariables_ =
    objc.registerName("evaluateWithObject:substitutionVariables:");
final _objc_msgSend_411 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_allowEvaluation = objc.registerName("allowEvaluation");
late final _sel_filteredOrderedSetUsingPredicate_ =
    objc.registerName("filteredOrderedSetUsingPredicate:");
final _objc_msgSend_412 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

class NSMutableOrderedSet extends NSOrderedSet {
  NSMutableOrderedSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableOrderedSet] that points to the same underlying object as [other].
  NSMutableOrderedSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSMutableOrderedSet] that wraps the given raw object pointer.
  NSMutableOrderedSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableOrderedSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSMutableOrderedSet);
  }

  void insertObject_atIndex_(objc.NSObject object, int idx) {
    _objc_msgSend_413(
        this.pointer, _sel_insertObject_atIndex_, object.pointer, idx);
  }

  void removeObjectAtIndex_(int idx) {
    _objc_msgSend_414(this.pointer, _sel_removeObjectAtIndex_, idx);
  }

  void replaceObjectAtIndex_withObject_(int idx, objc.NSObject object) {
    _objc_msgSend_415(this.pointer, _sel_replaceObjectAtIndex_withObject_, idx,
        object.pointer);
  }

  @override
  NSMutableOrderedSet? initWithCoder_(objc.NSCoder coder) {
    final _ret =
        _objc_msgSend_231(this.pointer, _sel_initWithCoder_, coder.pointer);
    return _ret.address == 0
        ? null
        : NSMutableOrderedSet.castFromPointer(_ret,
            retain: true, release: true);
  }

  @override
  NSMutableOrderedSet init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSMutableOrderedSet initWithCapacity_(int numItems) {
    final _ret =
        _objc_msgSend_355(this.pointer, _sel_initWithCapacity_, numItems);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  void addObject_(objc.NSObject object) {
    _objc_msgSend_49(this.pointer, _sel_addObject_, object.pointer);
  }

  void addObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int count) {
    _objc_msgSend_416(this.pointer, _sel_addObjects_count_, objects, count);
  }

  void addObjectsFromArray_(objc.NSArray array) {
    _objc_msgSend_242(this.pointer, _sel_addObjectsFromArray_, array.pointer);
  }

  void exchangeObjectAtIndex_withObjectAtIndex_(int idx1, int idx2) {
    _objc_msgSend_417(this.pointer,
        _sel_exchangeObjectAtIndex_withObjectAtIndex_, idx1, idx2);
  }

  void moveObjectsAtIndexes_toIndex_(objc.NSIndexSet indexes, int idx) {
    _objc_msgSend_418(
        this.pointer, _sel_moveObjectsAtIndexes_toIndex_, indexes.pointer, idx);
  }

  void insertObjects_atIndexes_(objc.NSArray objects, objc.NSIndexSet indexes) {
    _objc_msgSend_419(this.pointer, _sel_insertObjects_atIndexes_,
        objects.pointer, indexes.pointer);
  }

  void setObject_atIndex_(objc.NSObject obj, int idx) {
    _objc_msgSend_413(this.pointer, _sel_setObject_atIndex_, obj.pointer, idx);
  }

  void setObject_atIndexedSubscript_(objc.NSObject obj, int idx) {
    _objc_msgSend_413(
        this.pointer, _sel_setObject_atIndexedSubscript_, obj.pointer, idx);
  }

  void replaceObjectsInRange_withObjects_count_(_NSRange range,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int count) {
    _objc_msgSend_420(this.pointer,
        _sel_replaceObjectsInRange_withObjects_count_, range, objects, count);
  }

  void replaceObjectsAtIndexes_withObjects_(
      objc.NSIndexSet indexes, objc.NSArray objects) {
    _objc_msgSend_421(this.pointer, _sel_replaceObjectsAtIndexes_withObjects_,
        indexes.pointer, objects.pointer);
  }

  void removeObjectsInRange_(_NSRange range) {
    _objc_msgSend_81(this.pointer, _sel_removeObjectsInRange_, range);
  }

  void removeObjectsAtIndexes_(objc.NSIndexSet indexes) {
    _objc_msgSend_422(
        this.pointer, _sel_removeObjectsAtIndexes_, indexes.pointer);
  }

  void removeAllObjects() {
    _objc_msgSend_82(this.pointer, _sel_removeAllObjects);
  }

  void removeObject_(objc.NSObject object) {
    _objc_msgSend_49(this.pointer, _sel_removeObject_, object.pointer);
  }

  void removeObjectsInArray_(objc.NSArray array) {
    _objc_msgSend_242(this.pointer, _sel_removeObjectsInArray_, array.pointer);
  }

  void intersectOrderedSet_(NSOrderedSet other) {
    _objc_msgSend_423(this.pointer, _sel_intersectOrderedSet_, other.pointer);
  }

  void minusOrderedSet_(NSOrderedSet other) {
    _objc_msgSend_423(this.pointer, _sel_minusOrderedSet_, other.pointer);
  }

  void unionOrderedSet_(NSOrderedSet other) {
    _objc_msgSend_423(this.pointer, _sel_unionOrderedSet_, other.pointer);
  }

  void intersectSet_(objc.NSSet other) {
    _objc_msgSend_424(this.pointer, _sel_intersectSet_, other.pointer);
  }

  void minusSet_(objc.NSSet other) {
    _objc_msgSend_424(this.pointer, _sel_minusSet_, other.pointer);
  }

  void unionSet_(objc.NSSet other) {
    _objc_msgSend_424(this.pointer, _sel_unionSet_, other.pointer);
  }

  void sortUsingComparator_(
      ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject cmptr) {
    _objc_msgSend_425(this.pointer, _sel_sortUsingComparator_, cmptr.pointer);
  }

  void sortWithOptions_usingComparator_(int opts,
      ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject cmptr) {
    _objc_msgSend_426(this.pointer, _sel_sortWithOptions_usingComparator_, opts,
        cmptr.pointer);
  }

  void sortRange_options_usingComparator_(_NSRange range, int opts,
      ObjCBlock_NSComparisonResult_objcObjCObject_objcObjCObject cmptr) {
    _objc_msgSend_427(this.pointer, _sel_sortRange_options_usingComparator_,
        range, opts, cmptr.pointer);
  }

  static NSMutableOrderedSet orderedSetWithCapacity_(int numItems) {
    final _ret = _objc_msgSend_355(
        _class_NSMutableOrderedSet, _sel_orderedSetWithCapacity_, numItems);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  void applyDifference_(objc.NSObject difference) {
    _objc_msgSend_49(this.pointer, _sel_applyDifference_, difference.pointer);
  }

  void sortUsingDescriptors_(objc.NSArray sortDescriptors) {
    _objc_msgSend_242(
        this.pointer, _sel_sortUsingDescriptors_, sortDescriptors.pointer);
  }

  void filterUsingPredicate_(NSPredicate p) {
    _objc_msgSend_428(this.pointer, _sel_filterUsingPredicate_, p.pointer);
  }

  @override
  NSMutableOrderedSet initWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_365(
        this.pointer, _sel_initWithObjects_count_, objects, cnt);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableOrderedSet orderedSet() {
    final _ret = _objc_msgSend_40(_class_NSMutableOrderedSet, _sel_orderedSet);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableOrderedSet orderedSetWithObject_(objc.NSObject object) {
    final _ret = _objc_msgSend_387(
        _class_NSMutableOrderedSet, _sel_orderedSetWithObject_, object.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableOrderedSet orderedSetWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_365(_class_NSMutableOrderedSet,
        _sel_orderedSetWithObjects_count_, objects, cnt);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableOrderedSet orderedSetWithObjects_(objc.NSObject firstObj) {
    final _ret = _objc_msgSend_387(_class_NSMutableOrderedSet,
        _sel_orderedSetWithObjects_, firstObj.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableOrderedSet orderedSetWithOrderedSet_(NSOrderedSet set) {
    final _ret = _objc_msgSend_388(_class_NSMutableOrderedSet,
        _sel_orderedSetWithOrderedSet_, set.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableOrderedSet orderedSetWithOrderedSet_range_copyItems_(
      NSOrderedSet set, _NSRange range, bool flag) {
    final _ret = _objc_msgSend_389(
        _class_NSMutableOrderedSet,
        _sel_orderedSetWithOrderedSet_range_copyItems_,
        set.pointer,
        range,
        flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMutableOrderedSet orderedSetWithArray_(objc.NSArray array) {
    final _ret = _objc_msgSend_390(
        _class_NSMutableOrderedSet, _sel_orderedSetWithArray_, array.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableOrderedSet orderedSetWithArray_range_copyItems_(
      objc.NSArray array, _NSRange range, bool flag) {
    final _ret = _objc_msgSend_391(_class_NSMutableOrderedSet,
        _sel_orderedSetWithArray_range_copyItems_, array.pointer, range, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMutableOrderedSet orderedSetWithSet_(objc.NSSet set) {
    final _ret = _objc_msgSend_392(
        _class_NSMutableOrderedSet, _sel_orderedSetWithSet_, set.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMutableOrderedSet orderedSetWithSet_copyItems_(
      objc.NSSet set, bool flag) {
    final _ret = _objc_msgSend_393(_class_NSMutableOrderedSet,
        _sel_orderedSetWithSet_copyItems_, set.pointer, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  @override
  NSMutableOrderedSet initWithObject_(objc.NSObject object) {
    final _ret =
        _objc_msgSend_387(this.pointer, _sel_initWithObject_, object.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableOrderedSet initWithObjects_(objc.NSObject firstObj) {
    final _ret = _objc_msgSend_387(
        this.pointer, _sel_initWithObjects_, firstObj.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableOrderedSet initWithOrderedSet_(NSOrderedSet set) {
    final _ret =
        _objc_msgSend_388(this.pointer, _sel_initWithOrderedSet_, set.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableOrderedSet initWithOrderedSet_copyItems_(
      NSOrderedSet set, bool flag) {
    final _ret = _objc_msgSend_394(
        this.pointer, _sel_initWithOrderedSet_copyItems_, set.pointer, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  @override
  NSMutableOrderedSet initWithOrderedSet_range_copyItems_(
      NSOrderedSet set, _NSRange range, bool flag) {
    final _ret = _objc_msgSend_389(this.pointer,
        _sel_initWithOrderedSet_range_copyItems_, set.pointer, range, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  @override
  NSMutableOrderedSet initWithArray_(objc.NSArray array) {
    final _ret =
        _objc_msgSend_390(this.pointer, _sel_initWithArray_, array.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableOrderedSet initWithArray_copyItems_(objc.NSArray set, bool flag) {
    final _ret = _objc_msgSend_395(
        this.pointer, _sel_initWithArray_copyItems_, set.pointer, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  @override
  NSMutableOrderedSet initWithArray_range_copyItems_(
      objc.NSArray set, _NSRange range, bool flag) {
    final _ret = _objc_msgSend_391(this.pointer,
        _sel_initWithArray_range_copyItems_, set.pointer, range, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  @override
  NSMutableOrderedSet initWithSet_(objc.NSSet set) {
    final _ret =
        _objc_msgSend_392(this.pointer, _sel_initWithSet_, set.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSMutableOrderedSet initWithSet_copyItems_(objc.NSSet set, bool flag) {
    final _ret = _objc_msgSend_393(
        this.pointer, _sel_initWithSet_copyItems_, set.pointer, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMutableOrderedSet new1() {
    final _ret = _objc_msgSend_40(_class_NSMutableOrderedSet, _sel_new);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMutableOrderedSet allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSMutableOrderedSet, _sel_allocWithZone_, zone);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMutableOrderedSet alloc() {
    final _ret = _objc_msgSend_40(_class_NSMutableOrderedSet, _sel_alloc);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSMutableOrderedSet,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSMutableOrderedSet,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSMutableOrderedSet, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSMutableOrderedSet, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSMutableOrderedSet,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSMutableOrderedSet,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSMutableOrderedSet,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSMutableOrderedSet, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSMutableOrderedSet, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSMutableOrderedSet = objc.getClass("NSMutableOrderedSet");
late final _sel_insertObject_atIndex_ =
    objc.registerName("insertObject:atIndex:");
final _objc_msgSend_413 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_removeObjectAtIndex_ =
    objc.registerName("removeObjectAtIndex:");
final _objc_msgSend_414 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_replaceObjectAtIndex_withObject_ =
    objc.registerName("replaceObjectAtIndex:withObject:");
final _objc_msgSend_415 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithCapacity_ = objc.registerName("initWithCapacity:");
late final _sel_addObject_ = objc.registerName("addObject:");
late final _sel_addObjects_count_ = objc.registerName("addObjects:count:");
final _objc_msgSend_416 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
late final _sel_addObjectsFromArray_ =
    objc.registerName("addObjectsFromArray:");
late final _sel_exchangeObjectAtIndex_withObjectAtIndex_ =
    objc.registerName("exchangeObjectAtIndex:withObjectAtIndex:");
final _objc_msgSend_417 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, int)>();
late final _sel_moveObjectsAtIndexes_toIndex_ =
    objc.registerName("moveObjectsAtIndexes:toIndex:");
final _objc_msgSend_418 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_insertObjects_atIndexes_ =
    objc.registerName("insertObjects:atIndexes:");
final _objc_msgSend_419 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_setObject_atIndex_ = objc.registerName("setObject:atIndex:");
late final _sel_setObject_atIndexedSubscript_ =
    objc.registerName("setObject:atIndexedSubscript:");
late final _sel_replaceObjectsInRange_withObjects_count_ =
    objc.registerName("replaceObjectsInRange:withObjects:count:");
final _objc_msgSend_420 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
late final _sel_replaceObjectsAtIndexes_withObjects_ =
    objc.registerName("replaceObjectsAtIndexes:withObjects:");
final _objc_msgSend_421 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removeObjectsInRange_ =
    objc.registerName("removeObjectsInRange:");
late final _sel_removeObjectsAtIndexes_ =
    objc.registerName("removeObjectsAtIndexes:");
final _objc_msgSend_422 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removeAllObjects = objc.registerName("removeAllObjects");
late final _sel_removeObject_ = objc.registerName("removeObject:");
late final _sel_removeObjectsInArray_ =
    objc.registerName("removeObjectsInArray:");
late final _sel_intersectOrderedSet_ =
    objc.registerName("intersectOrderedSet:");
final _objc_msgSend_423 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_minusOrderedSet_ = objc.registerName("minusOrderedSet:");
late final _sel_unionOrderedSet_ = objc.registerName("unionOrderedSet:");
late final _sel_intersectSet_ = objc.registerName("intersectSet:");
final _objc_msgSend_424 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_minusSet_ = objc.registerName("minusSet:");
late final _sel_unionSet_ = objc.registerName("unionSet:");
late final _sel_sortUsingComparator_ =
    objc.registerName("sortUsingComparator:");
final _objc_msgSend_425 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_sortWithOptions_usingComparator_ =
    objc.registerName("sortWithOptions:usingComparator:");
final _objc_msgSend_426 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_sortRange_options_usingComparator_ =
    objc.registerName("sortRange:options:usingComparator:");
final _objc_msgSend_427 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Int32,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            int,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_orderedSetWithCapacity_ =
    objc.registerName("orderedSetWithCapacity:");
late final _sel_applyDifference_ = objc.registerName("applyDifference:");
late final _sel_sortUsingDescriptors_ =
    objc.registerName("sortUsingDescriptors:");
late final _sel_filterUsingPredicate_ =
    objc.registerName("filterUsingPredicate:");
final _objc_msgSend_428 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

class NSMorphology extends objc.NSObject {
  NSMorphology._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMorphology] that points to the same underlying object as [other].
  NSMorphology.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSMorphology] that wraps the given raw object pointer.
  NSMorphology.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMorphology].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSMorphology);
  }

  int get grammaticalGender {
    return _objc_msgSend_429(this.pointer, _sel_grammaticalGender);
  }

  set grammaticalGender(int value) {
    return _objc_msgSend_430(this.pointer, _sel_setGrammaticalGender_, value);
  }

  int get partOfSpeech {
    return _objc_msgSend_431(this.pointer, _sel_partOfSpeech);
  }

  set partOfSpeech(int value) {
    return _objc_msgSend_432(this.pointer, _sel_setPartOfSpeech_, value);
  }

  int get number {
    return _objc_msgSend_433(this.pointer, _sel_number);
  }

  set number(int value) {
    return _objc_msgSend_434(this.pointer, _sel_setNumber_, value);
  }

  int get grammaticalCase {
    return _objc_msgSend_435(this.pointer, _sel_grammaticalCase);
  }

  set grammaticalCase(int value) {
    return _objc_msgSend_436(this.pointer, _sel_setGrammaticalCase_, value);
  }

  int get determination {
    return _objc_msgSend_437(this.pointer, _sel_determination);
  }

  set determination(int value) {
    return _objc_msgSend_438(this.pointer, _sel_setDetermination_, value);
  }

  int get grammaticalPerson {
    return _objc_msgSend_439(this.pointer, _sel_grammaticalPerson);
  }

  set grammaticalPerson(int value) {
    return _objc_msgSend_440(this.pointer, _sel_setGrammaticalPerson_, value);
  }

  int get pronounType {
    return _objc_msgSend_441(this.pointer, _sel_pronounType);
  }

  set pronounType(int value) {
    return _objc_msgSend_442(this.pointer, _sel_setPronounType_, value);
  }

  int get definiteness {
    return _objc_msgSend_443(this.pointer, _sel_definiteness);
  }

  set definiteness(int value) {
    return _objc_msgSend_444(this.pointer, _sel_setDefiniteness_, value);
  }

  NSMorphologyCustomPronoun? customPronounForLanguage_(objc.NSString language) {
    final _ret = _objc_msgSend_446(
        this.pointer, _sel_customPronounForLanguage_, language.pointer);
    return _ret.address == 0
        ? null
        : NSMorphologyCustomPronoun.castFromPointer(_ret,
            retain: true, release: true);
  }

  bool setCustomPronoun_forLanguage_error_(NSMorphologyCustomPronoun? features,
      objc.NSString language, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_447(
        this.pointer,
        _sel_setCustomPronoun_forLanguage_error_,
        features?.pointer ?? ffi.nullptr,
        language.pointer,
        error);
  }

  bool get unspecified {
    return _objc_msgSend_7(this.pointer, _sel_isUnspecified);
  }

  static NSMorphology getUserMorphology() {
    final _ret = _objc_msgSend_448(_class_NSMorphology, _sel_userMorphology);
    return NSMorphology.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSMorphology init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSMorphology.castFromPointer(_ret, retain: true, release: true);
  }

  static NSMorphology new1() {
    final _ret = _objc_msgSend_40(_class_NSMorphology, _sel_new);
    return NSMorphology.castFromPointer(_ret, retain: false, release: true);
  }

  static NSMorphology allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSMorphology, _sel_allocWithZone_, zone);
    return NSMorphology.castFromPointer(_ret, retain: false, release: true);
  }

  static NSMorphology alloc() {
    final _ret = _objc_msgSend_40(_class_NSMorphology, _sel_alloc);
    return NSMorphology.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSMorphology,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSMorphology,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSMorphology, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSMorphology, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSMorphology,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSMorphology,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSMorphology,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSMorphology, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSMorphology, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSMorphology = objc.getClass("NSMorphology");

abstract class NSGrammaticalGender {
  static const int NSGrammaticalGenderNotSet = 0;
  static const int NSGrammaticalGenderFeminine = 1;
  static const int NSGrammaticalGenderMasculine = 2;
  static const int NSGrammaticalGenderNeuter = 3;
}

late final _sel_grammaticalGender = objc.registerName("grammaticalGender");
final _objc_msgSend_429 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setGrammaticalGender_ =
    objc.registerName("setGrammaticalGender:");
final _objc_msgSend_430 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSGrammaticalPartOfSpeech {
  static const int NSGrammaticalPartOfSpeechNotSet = 0;
  static const int NSGrammaticalPartOfSpeechDeterminer = 1;
  static const int NSGrammaticalPartOfSpeechPronoun = 2;
  static const int NSGrammaticalPartOfSpeechLetter = 3;
  static const int NSGrammaticalPartOfSpeechAdverb = 4;
  static const int NSGrammaticalPartOfSpeechParticle = 5;
  static const int NSGrammaticalPartOfSpeechAdjective = 6;
  static const int NSGrammaticalPartOfSpeechAdposition = 7;
  static const int NSGrammaticalPartOfSpeechVerb = 8;
  static const int NSGrammaticalPartOfSpeechNoun = 9;
  static const int NSGrammaticalPartOfSpeechConjunction = 10;
  static const int NSGrammaticalPartOfSpeechNumeral = 11;
  static const int NSGrammaticalPartOfSpeechInterjection = 12;
  static const int NSGrammaticalPartOfSpeechPreposition = 13;
  static const int NSGrammaticalPartOfSpeechAbbreviation = 14;
}

late final _sel_partOfSpeech = objc.registerName("partOfSpeech");
final _objc_msgSend_431 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setPartOfSpeech_ = objc.registerName("setPartOfSpeech:");
final _objc_msgSend_432 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSGrammaticalNumber {
  static const int NSGrammaticalNumberNotSet = 0;
  static const int NSGrammaticalNumberSingular = 1;
  static const int NSGrammaticalNumberZero = 2;
  static const int NSGrammaticalNumberPlural = 3;
  static const int NSGrammaticalNumberPluralTwo = 4;
  static const int NSGrammaticalNumberPluralFew = 5;
  static const int NSGrammaticalNumberPluralMany = 6;
}

late final _sel_number = objc.registerName("number");
final _objc_msgSend_433 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setNumber_ = objc.registerName("setNumber:");
final _objc_msgSend_434 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSGrammaticalCase {
  static const int NSGrammaticalCaseNotSet = 0;
  static const int NSGrammaticalCaseNominative = 1;
  static const int NSGrammaticalCaseAccusative = 2;
  static const int NSGrammaticalCaseDative = 3;
  static const int NSGrammaticalCaseGenitive = 4;
  static const int NSGrammaticalCasePrepositional = 5;
  static const int NSGrammaticalCaseAblative = 6;
  static const int NSGrammaticalCaseAdessive = 7;
  static const int NSGrammaticalCaseAllative = 8;
  static const int NSGrammaticalCaseElative = 9;
  static const int NSGrammaticalCaseIllative = 10;
  static const int NSGrammaticalCaseEssive = 11;
  static const int NSGrammaticalCaseInessive = 12;
  static const int NSGrammaticalCaseLocative = 13;
  static const int NSGrammaticalCaseTranslative = 14;
}

late final _sel_grammaticalCase = objc.registerName("grammaticalCase");
final _objc_msgSend_435 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setGrammaticalCase_ = objc.registerName("setGrammaticalCase:");
final _objc_msgSend_436 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSGrammaticalDetermination {
  static const int NSGrammaticalDeterminationNotSet = 0;
  static const int NSGrammaticalDeterminationIndependent = 1;
  static const int NSGrammaticalDeterminationDependent = 2;
}

late final _sel_determination = objc.registerName("determination");
final _objc_msgSend_437 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setDetermination_ = objc.registerName("setDetermination:");
final _objc_msgSend_438 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSGrammaticalPerson {
  static const int NSGrammaticalPersonNotSet = 0;
  static const int NSGrammaticalPersonFirst = 1;
  static const int NSGrammaticalPersonSecond = 2;
  static const int NSGrammaticalPersonThird = 3;
}

late final _sel_grammaticalPerson = objc.registerName("grammaticalPerson");
final _objc_msgSend_439 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setGrammaticalPerson_ =
    objc.registerName("setGrammaticalPerson:");
final _objc_msgSend_440 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSGrammaticalPronounType {
  static const int NSGrammaticalPronounTypeNotSet = 0;
  static const int NSGrammaticalPronounTypePersonal = 1;
  static const int NSGrammaticalPronounTypeReflexive = 2;
  static const int NSGrammaticalPronounTypePossessive = 3;
}

late final _sel_pronounType = objc.registerName("pronounType");
final _objc_msgSend_441 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setPronounType_ = objc.registerName("setPronounType:");
final _objc_msgSend_442 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

abstract class NSGrammaticalDefiniteness {
  static const int NSGrammaticalDefinitenessNotSet = 0;
  static const int NSGrammaticalDefinitenessIndefinite = 1;
  static const int NSGrammaticalDefinitenessDefinite = 2;
}

late final _sel_definiteness = objc.registerName("definiteness");
final _objc_msgSend_443 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setDefiniteness_ = objc.registerName("setDefiniteness:");
final _objc_msgSend_444 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

class NSMorphologyCustomPronoun extends objc.NSObject {
  NSMorphologyCustomPronoun._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMorphologyCustomPronoun] that points to the same underlying object as [other].
  NSMorphologyCustomPronoun.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSMorphologyCustomPronoun] that wraps the given raw object pointer.
  NSMorphologyCustomPronoun.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMorphologyCustomPronoun].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSMorphologyCustomPronoun);
  }

  static bool isSupportedForLanguage_(objc.NSString language) {
    return _objc_msgSend_51(_class_NSMorphologyCustomPronoun,
        _sel_isSupportedForLanguage_, language.pointer);
  }

  static objc.NSArray requiredKeysForLanguage_(objc.NSString language) {
    final _ret = _objc_msgSend_445(_class_NSMorphologyCustomPronoun,
        _sel_requiredKeysForLanguage_, language.pointer);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get subjectForm {
    final _ret = _objc_msgSend_13(this.pointer, _sel_subjectForm);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set subjectForm(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setSubjectForm_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSString? get objectForm {
    final _ret = _objc_msgSend_13(this.pointer, _sel_objectForm);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set objectForm(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setObjectForm_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSString? get possessiveForm {
    final _ret = _objc_msgSend_13(this.pointer, _sel_possessiveForm);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set possessiveForm(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setPossessiveForm_, value?.pointer ?? ffi.nullptr);
  }

  objc.NSString? get possessiveAdjectiveForm {
    final _ret = _objc_msgSend_13(this.pointer, _sel_possessiveAdjectiveForm);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set possessiveAdjectiveForm(objc.NSString? value) {
    return _objc_msgSend_46(this.pointer, _sel_setPossessiveAdjectiveForm_,
        value?.pointer ?? ffi.nullptr);
  }

  objc.NSString? get reflexiveForm {
    final _ret = _objc_msgSend_13(this.pointer, _sel_reflexiveForm);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set reflexiveForm(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setReflexiveForm_, value?.pointer ?? ffi.nullptr);
  }

  @override
  NSMorphologyCustomPronoun init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSMorphologyCustomPronoun.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSMorphologyCustomPronoun new1() {
    final _ret = _objc_msgSend_40(_class_NSMorphologyCustomPronoun, _sel_new);
    return NSMorphologyCustomPronoun.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMorphologyCustomPronoun allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(
        _class_NSMorphologyCustomPronoun, _sel_allocWithZone_, zone);
    return NSMorphologyCustomPronoun.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSMorphologyCustomPronoun alloc() {
    final _ret = _objc_msgSend_40(_class_NSMorphologyCustomPronoun, _sel_alloc);
    return NSMorphologyCustomPronoun.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSMorphologyCustomPronoun,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSMorphologyCustomPronoun,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSMorphologyCustomPronoun, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(
        _class_NSMorphologyCustomPronoun, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSMorphologyCustomPronoun,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSMorphologyCustomPronoun,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSMorphologyCustomPronoun,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSMorphologyCustomPronoun, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSMorphologyCustomPronoun, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSMorphologyCustomPronoun =
    objc.getClass("NSMorphologyCustomPronoun");
late final _sel_isSupportedForLanguage_ =
    objc.registerName("isSupportedForLanguage:");
late final _sel_requiredKeysForLanguage_ =
    objc.registerName("requiredKeysForLanguage:");
final _objc_msgSend_445 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_subjectForm = objc.registerName("subjectForm");
late final _sel_setSubjectForm_ = objc.registerName("setSubjectForm:");
late final _sel_objectForm = objc.registerName("objectForm");
late final _sel_setObjectForm_ = objc.registerName("setObjectForm:");
late final _sel_possessiveForm = objc.registerName("possessiveForm");
late final _sel_setPossessiveForm_ = objc.registerName("setPossessiveForm:");
late final _sel_possessiveAdjectiveForm =
    objc.registerName("possessiveAdjectiveForm");
late final _sel_setPossessiveAdjectiveForm_ =
    objc.registerName("setPossessiveAdjectiveForm:");
late final _sel_reflexiveForm = objc.registerName("reflexiveForm");
late final _sel_setReflexiveForm_ = objc.registerName("setReflexiveForm:");
late final _sel_customPronounForLanguage_ =
    objc.registerName("customPronounForLanguage:");
final _objc_msgSend_446 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_setCustomPronoun_forLanguage_error_ =
    objc.registerName("setCustomPronoun:forLanguage:error:");
final _objc_msgSend_447 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_isUnspecified = objc.registerName("isUnspecified");
late final _sel_userMorphology = objc.registerName("userMorphology");
final _objc_msgSend_448 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();

class NSOperationQueue extends objc.NSObject {
  NSOperationQueue._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSOperationQueue] that points to the same underlying object as [other].
  NSOperationQueue.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSOperationQueue] that wraps the given raw object pointer.
  NSOperationQueue.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSOperationQueue].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSOperationQueue);
  }

  objc.NSProgress get progress {
    final _ret = _objc_msgSend_347(this.pointer, _sel_progress);
    return objc.NSProgress.castFromPointer(_ret, retain: true, release: true);
  }

  void addOperation_(NSOperation op) {
    _objc_msgSend_449(this.pointer, _sel_addOperation_, op.pointer);
  }

  void addOperations_waitUntilFinished_(objc.NSArray ops, bool wait) {
    _objc_msgSend_456(
        this.pointer, _sel_addOperations_waitUntilFinished_, ops.pointer, wait);
  }

  void addOperationWithBlock_(ObjCBlock_ffiVoid block) {
    _objc_msgSend_249(this.pointer, _sel_addOperationWithBlock_, block.pointer);
  }

  void addBarrierBlock_(ObjCBlock_ffiVoid barrier) {
    _objc_msgSend_249(this.pointer, _sel_addBarrierBlock_, barrier.pointer);
  }

  int get maxConcurrentOperationCount {
    return _objc_msgSend_114(this.pointer, _sel_maxConcurrentOperationCount);
  }

  set maxConcurrentOperationCount(int value) {
    return _objc_msgSend_134(
        this.pointer, _sel_setMaxConcurrentOperationCount_, value);
  }

  bool get suspended {
    return _objc_msgSend_7(this.pointer, _sel_isSuspended);
  }

  set suspended(bool value) {
    return _objc_msgSend_41(this.pointer, _sel_setSuspended_, value);
  }

  objc.NSString? get name {
    final _ret = _objc_msgSend_13(this.pointer, _sel_name);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set name(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setName_, value?.pointer ?? ffi.nullptr);
  }

  int get qualityOfService {
    return _objc_msgSend_454(this.pointer, _sel_qualityOfService);
  }

  set qualityOfService(int value) {
    return _objc_msgSend_455(this.pointer, _sel_setQualityOfService_, value);
  }

  objc.NSObject? get underlyingQueue {
    final _ret = _objc_msgSend_457(this.pointer, _sel_underlyingQueue);
    return _ret.address == 0
        ? null
        : objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  set underlyingQueue(objc.NSObject? value) {
    return _objc_msgSend_458(
        this.pointer, _sel_setUnderlyingQueue_, value?.pointer ?? ffi.nullptr);
  }

  void cancelAllOperations() {
    _objc_msgSend_82(this.pointer, _sel_cancelAllOperations);
  }

  void waitUntilAllOperationsAreFinished() {
    _objc_msgSend_82(this.pointer, _sel_waitUntilAllOperationsAreFinished);
  }

  static NSOperationQueue? getCurrentQueue() {
    final _ret = _objc_msgSend_459(_class_NSOperationQueue, _sel_currentQueue);
    return _ret.address == 0
        ? null
        : NSOperationQueue.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOperationQueue getMainQueue() {
    final _ret = _objc_msgSend_460(_class_NSOperationQueue, _sel_mainQueue);
    return NSOperationQueue.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get operations {
    final _ret = _objc_msgSend_6(this.pointer, _sel_operations);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  int get operationCount {
    return _objc_msgSend_29(this.pointer, _sel_operationCount);
  }

  @override
  NSOperationQueue init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSOperationQueue.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOperationQueue new1() {
    final _ret = _objc_msgSend_40(_class_NSOperationQueue, _sel_new);
    return NSOperationQueue.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOperationQueue allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSOperationQueue, _sel_allocWithZone_, zone);
    return NSOperationQueue.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOperationQueue alloc() {
    final _ret = _objc_msgSend_40(_class_NSOperationQueue, _sel_alloc);
    return NSOperationQueue.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSOperationQueue,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSOperationQueue,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSOperationQueue, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSOperationQueue, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSOperationQueue,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSOperationQueue,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSOperationQueue,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSOperationQueue, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSOperationQueue, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSOperationQueue = objc.getClass("NSOperationQueue");

class NSOperation extends objc.NSObject {
  NSOperation._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSOperation] that points to the same underlying object as [other].
  NSOperation.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSOperation] that wraps the given raw object pointer.
  NSOperation.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSOperation].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSOperation);
  }

  void start() {
    _objc_msgSend_82(this.pointer, _sel_start);
  }

  void main() {
    _objc_msgSend_82(this.pointer, _sel_main);
  }

  bool get cancelled {
    return _objc_msgSend_7(this.pointer, _sel_isCancelled);
  }

  void cancel() {
    _objc_msgSend_82(this.pointer, _sel_cancel);
  }

  bool get executing {
    return _objc_msgSend_7(this.pointer, _sel_isExecuting);
  }

  bool get finished {
    return _objc_msgSend_7(this.pointer, _sel_isFinished);
  }

  bool get concurrent {
    return _objc_msgSend_7(this.pointer, _sel_isConcurrent);
  }

  bool get asynchronous {
    return _objc_msgSend_7(this.pointer, _sel_isAsynchronous);
  }

  bool get ready {
    return _objc_msgSend_7(this.pointer, _sel_isReady);
  }

  void addDependency_(NSOperation op) {
    _objc_msgSend_449(this.pointer, _sel_addDependency_, op.pointer);
  }

  void removeDependency_(NSOperation op) {
    _objc_msgSend_449(this.pointer, _sel_removeDependency_, op.pointer);
  }

  objc.NSArray get dependencies {
    final _ret = _objc_msgSend_6(this.pointer, _sel_dependencies);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  int get queuePriority {
    return _objc_msgSend_450(this.pointer, _sel_queuePriority);
  }

  set queuePriority(int value) {
    return _objc_msgSend_451(this.pointer, _sel_setQueuePriority_, value);
  }

  ObjCBlock_ffiVoid? get completionBlock {
    final _ret = _objc_msgSend_452(this.pointer, _sel_completionBlock);
    return _ret.address == 0
        ? null
        : ObjCBlock_ffiVoid.castFromPointer(_ret, retain: true, release: true);
  }

  set completionBlock(ObjCBlock_ffiVoid? value) {
    return _objc_msgSend_453(
        this.pointer, _sel_setCompletionBlock_, value?.pointer ?? ffi.nullptr);
  }

  void waitUntilFinished() {
    _objc_msgSend_82(this.pointer, _sel_waitUntilFinished);
  }

  double get threadPriority {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_threadPriority)
        : _objc_msgSend_115(this.pointer, _sel_threadPriority);
  }

  set threadPriority(double value) {
    return _objc_msgSend_212(this.pointer, _sel_setThreadPriority_, value);
  }

  int get qualityOfService {
    return _objc_msgSend_454(this.pointer, _sel_qualityOfService);
  }

  set qualityOfService(int value) {
    return _objc_msgSend_455(this.pointer, _sel_setQualityOfService_, value);
  }

  objc.NSString? get name {
    final _ret = _objc_msgSend_13(this.pointer, _sel_name);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set name(objc.NSString? value) {
    return _objc_msgSend_46(
        this.pointer, _sel_setName_, value?.pointer ?? ffi.nullptr);
  }

  @override
  NSOperation init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSOperation.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOperation new1() {
    final _ret = _objc_msgSend_40(_class_NSOperation, _sel_new);
    return NSOperation.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOperation allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSOperation, _sel_allocWithZone_, zone);
    return NSOperation.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOperation alloc() {
    final _ret = _objc_msgSend_40(_class_NSOperation, _sel_alloc);
    return NSOperation.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSOperation,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSOperation,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSOperation, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSOperation, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSOperation,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSOperation,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSOperation,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSOperation, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSOperation, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSOperation = objc.getClass("NSOperation");
late final _sel_start = objc.registerName("start");
late final _sel_main = objc.registerName("main");
late final _sel_isCancelled = objc.registerName("isCancelled");
late final _sel_isExecuting = objc.registerName("isExecuting");
late final _sel_isFinished = objc.registerName("isFinished");
late final _sel_isConcurrent = objc.registerName("isConcurrent");
late final _sel_isAsynchronous = objc.registerName("isAsynchronous");
late final _sel_isReady = objc.registerName("isReady");
late final _sel_addDependency_ = objc.registerName("addDependency:");
final _objc_msgSend_449 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removeDependency_ = objc.registerName("removeDependency:");
late final _sel_dependencies = objc.registerName("dependencies");

abstract class NSOperationQueuePriority {
  static const int NSOperationQueuePriorityVeryLow = -8;
  static const int NSOperationQueuePriorityLow = -4;
  static const int NSOperationQueuePriorityNormal = 0;
  static const int NSOperationQueuePriorityHigh = 4;
  static const int NSOperationQueuePriorityVeryHigh = 8;
}

late final _sel_queuePriority = objc.registerName("queuePriority");
final _objc_msgSend_450 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setQueuePriority_ = objc.registerName("setQueuePriority:");
final _objc_msgSend_451 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_completionBlock = objc.registerName("completionBlock");
final _objc_msgSend_452 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCBlock> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCBlock> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setCompletionBlock_ = objc.registerName("setCompletionBlock:");
final _objc_msgSend_453 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_waitUntilFinished = objc.registerName("waitUntilFinished");
late final _sel_threadPriority = objc.registerName("threadPriority");
late final _sel_setThreadPriority_ = objc.registerName("setThreadPriority:");

abstract class NSQualityOfService {
  static const int NSQualityOfServiceUserInteractive = 33;
  static const int NSQualityOfServiceUserInitiated = 25;
  static const int NSQualityOfServiceUtility = 17;
  static const int NSQualityOfServiceBackground = 9;
  static const int NSQualityOfServiceDefault = -1;
}

late final _sel_qualityOfService = objc.registerName("qualityOfService");
final _objc_msgSend_454 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setQualityOfService_ =
    objc.registerName("setQualityOfService:");
final _objc_msgSend_455 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_setName_ = objc.registerName("setName:");
late final _sel_addOperation_ = objc.registerName("addOperation:");
late final _sel_addOperations_waitUntilFinished_ =
    objc.registerName("addOperations:waitUntilFinished:");
final _objc_msgSend_456 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_addOperationWithBlock_ =
    objc.registerName("addOperationWithBlock:");
late final _sel_addBarrierBlock_ = objc.registerName("addBarrierBlock:");
late final _sel_maxConcurrentOperationCount =
    objc.registerName("maxConcurrentOperationCount");
late final _sel_setMaxConcurrentOperationCount_ =
    objc.registerName("setMaxConcurrentOperationCount:");
late final _sel_isSuspended = objc.registerName("isSuspended");
late final _sel_setSuspended_ = objc.registerName("setSuspended:");
late final _sel_underlyingQueue = objc.registerName("underlyingQueue");
final _objc_msgSend_457 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setUnderlyingQueue_ = objc.registerName("setUnderlyingQueue:");
final _objc_msgSend_458 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_cancelAllOperations = objc.registerName("cancelAllOperations");
late final _sel_waitUntilAllOperationsAreFinished =
    objc.registerName("waitUntilAllOperationsAreFinished");
late final _sel_currentQueue = objc.registerName("currentQueue");
final _objc_msgSend_459 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_mainQueue = objc.registerName("mainQueue");
final _objc_msgSend_460 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_operations = objc.registerName("operations");
late final _sel_operationCount = objc.registerName("operationCount");

class NSOrthography extends objc.NSObject {
  NSOrthography._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSOrthography] that points to the same underlying object as [other].
  NSOrthography.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSOrthography] that wraps the given raw object pointer.
  NSOrthography.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSOrthography].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSOrthography);
  }

  objc.NSString get dominantScript {
    final _ret = _objc_msgSend_12(this.pointer, _sel_dominantScript);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary get languageMap {
    final _ret = _objc_msgSend_112(this.pointer, _sel_languageMap);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrthography initWithDominantScript_languageMap_(
      objc.NSString script, objc.NSDictionary map) {
    final _ret = _objc_msgSend_461(this.pointer,
        _sel_initWithDominantScript_languageMap_, script.pointer, map.pointer);
    return NSOrthography.castFromPointer(_ret, retain: true, release: true);
  }

  NSOrthography? initWithCoder_(objc.NSCoder coder) {
    final _ret =
        _objc_msgSend_231(this.pointer, _sel_initWithCoder_, coder.pointer);
    return _ret.address == 0
        ? null
        : NSOrthography.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? languagesForScript_(objc.NSString script) {
    final _ret = _objc_msgSend_290(
        this.pointer, _sel_languagesForScript_, script.pointer);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? dominantLanguageForScript_(objc.NSString script) {
    final _ret = _objc_msgSend_14(
        this.pointer, _sel_dominantLanguageForScript_, script.pointer);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get dominantLanguage {
    final _ret = _objc_msgSend_12(this.pointer, _sel_dominantLanguage);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get allScripts {
    final _ret = _objc_msgSend_6(this.pointer, _sel_allScripts);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get allLanguages {
    final _ret = _objc_msgSend_6(this.pointer, _sel_allLanguages);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrthography defaultOrthographyForLanguage_(objc.NSString language) {
    final _ret = _objc_msgSend_35(_class_NSOrthography,
        _sel_defaultOrthographyForLanguage_, language.pointer);
    return NSOrthography.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrthography orthographyWithDominantScript_languageMap_(
      objc.NSString script, objc.NSDictionary map) {
    final _ret = _objc_msgSend_461(
        _class_NSOrthography,
        _sel_orthographyWithDominantScript_languageMap_,
        script.pointer,
        map.pointer);
    return NSOrthography.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSOrthography init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSOrthography.castFromPointer(_ret, retain: true, release: true);
  }

  static NSOrthography new1() {
    final _ret = _objc_msgSend_40(_class_NSOrthography, _sel_new);
    return NSOrthography.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOrthography allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSOrthography, _sel_allocWithZone_, zone);
    return NSOrthography.castFromPointer(_ret, retain: false, release: true);
  }

  static NSOrthography alloc() {
    final _ret = _objc_msgSend_40(_class_NSOrthography, _sel_alloc);
    return NSOrthography.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSOrthography,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSOrthography,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSOrthography, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSOrthography, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSOrthography,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSOrthography,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSOrthography,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSOrthography, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSOrthography, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSOrthography = objc.getClass("NSOrthography");
late final _sel_dominantScript = objc.registerName("dominantScript");
late final _sel_languageMap = objc.registerName("languageMap");
late final _sel_initWithDominantScript_languageMap_ =
    objc.registerName("initWithDominantScript:languageMap:");
final _objc_msgSend_461 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_languagesForScript_ = objc.registerName("languagesForScript:");
late final _sel_dominantLanguageForScript_ =
    objc.registerName("dominantLanguageForScript:");
late final _sel_dominantLanguage = objc.registerName("dominantLanguage");
late final _sel_allScripts = objc.registerName("allScripts");
late final _sel_allLanguages = objc.registerName("allLanguages");
late final _sel_defaultOrthographyForLanguage_ =
    objc.registerName("defaultOrthographyForLanguage:");
late final _sel_orthographyWithDominantScript_languageMap_ =
    objc.registerName("orthographyWithDominantScript:languageMap:");

class NSPointerArray extends objc.NSObject {
  NSPointerArray._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSPointerArray] that points to the same underlying object as [other].
  NSPointerArray.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSPointerArray] that wraps the given raw object pointer.
  NSPointerArray.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSPointerArray].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSPointerArray);
  }

  NSPointerArray initWithOptions_(int options) {
    final _ret =
        _objc_msgSend_462(this.pointer, _sel_initWithOptions_, options);
    return NSPointerArray.castFromPointer(_ret, retain: true, release: true);
  }

  NSPointerArray initWithPointerFunctions_(NSPointerFunctions functions) {
    final _ret = _objc_msgSend_476(
        this.pointer, _sel_initWithPointerFunctions_, functions.pointer);
    return NSPointerArray.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPointerArray pointerArrayWithOptions_(int options) {
    final _ret = _objc_msgSend_477(
        _class_NSPointerArray, _sel_pointerArrayWithOptions_, options);
    return NSPointerArray.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPointerArray pointerArrayWithPointerFunctions_(
      NSPointerFunctions functions) {
    final _ret = _objc_msgSend_478(_class_NSPointerArray,
        _sel_pointerArrayWithPointerFunctions_, functions.pointer);
    return NSPointerArray.castFromPointer(_ret, retain: true, release: true);
  }

  NSPointerFunctions get pointerFunctions {
    final _ret = _objc_msgSend_479(this.pointer, _sel_pointerFunctions);
    return NSPointerFunctions.castFromPointer(_ret,
        retain: true, release: true);
  }

  ffi.Pointer<ffi.Void> pointerAtIndex_(int index) {
    return _objc_msgSend_480(this.pointer, _sel_pointerAtIndex_, index);
  }

  void addPointer_(ffi.Pointer<ffi.Void> pointer) {
    _objc_msgSend_481(this.pointer, _sel_addPointer_, pointer);
  }

  void removePointerAtIndex_(int index) {
    _objc_msgSend_414(this.pointer, _sel_removePointerAtIndex_, index);
  }

  void insertPointer_atIndex_(ffi.Pointer<ffi.Void> item, int index) {
    _objc_msgSend_482(this.pointer, _sel_insertPointer_atIndex_, item, index);
  }

  void replacePointerAtIndex_withPointer_(
      int index, ffi.Pointer<ffi.Void> item) {
    _objc_msgSend_483(
        this.pointer, _sel_replacePointerAtIndex_withPointer_, index, item);
  }

  void compact() {
    _objc_msgSend_82(this.pointer, _sel_compact);
  }

  int get count {
    return _objc_msgSend_29(this.pointer, _sel_count);
  }

  set count(int value) {
    return _objc_msgSend_125(this.pointer, _sel_setCount_, value);
  }

  static objc.NSObject pointerArrayWithStrongObjects() {
    final _ret = _objc_msgSend_40(
        _class_NSPointerArray, _sel_pointerArrayWithStrongObjects);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject pointerArrayWithWeakObjects() {
    final _ret = _objc_msgSend_40(
        _class_NSPointerArray, _sel_pointerArrayWithWeakObjects);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPointerArray strongObjectsPointerArray() {
    final _ret = _objc_msgSend_484(
        _class_NSPointerArray, _sel_strongObjectsPointerArray);
    return NSPointerArray.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPointerArray weakObjectsPointerArray() {
    final _ret =
        _objc_msgSend_484(_class_NSPointerArray, _sel_weakObjectsPointerArray);
    return NSPointerArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get allObjects {
    final _ret = _objc_msgSend_6(this.pointer, _sel_allObjects);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSPointerArray init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSPointerArray.castFromPointer(_ret, retain: true, release: true);
  }

  static NSPointerArray new1() {
    final _ret = _objc_msgSend_40(_class_NSPointerArray, _sel_new);
    return NSPointerArray.castFromPointer(_ret, retain: false, release: true);
  }

  static NSPointerArray allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSPointerArray, _sel_allocWithZone_, zone);
    return NSPointerArray.castFromPointer(_ret, retain: false, release: true);
  }

  static NSPointerArray alloc() {
    final _ret = _objc_msgSend_40(_class_NSPointerArray, _sel_alloc);
    return NSPointerArray.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSPointerArray,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSPointerArray,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSPointerArray, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSPointerArray, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSPointerArray,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSPointerArray,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSPointerArray,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSPointerArray, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSPointerArray, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSPointerArray = objc.getClass("NSPointerArray");

abstract class NSPointerFunctionsOptions {
  static const int NSPointerFunctionsStrongMemory = 0;
  static const int NSPointerFunctionsZeroingWeakMemory = 1;
  static const int NSPointerFunctionsOpaqueMemory = 2;
  static const int NSPointerFunctionsMallocMemory = 3;
  static const int NSPointerFunctionsMachVirtualMemory = 4;
  static const int NSPointerFunctionsWeakMemory = 5;
  static const int NSPointerFunctionsObjectPersonality = 0;
  static const int NSPointerFunctionsOpaquePersonality = 256;
  static const int NSPointerFunctionsObjectPointerPersonality = 512;
  static const int NSPointerFunctionsCStringPersonality = 768;
  static const int NSPointerFunctionsStructPersonality = 1024;
  static const int NSPointerFunctionsIntegerPersonality = 1280;
  static const int NSPointerFunctionsCopyIn = 65536;
}

late final _sel_initWithOptions_ = objc.registerName("initWithOptions:");
final _objc_msgSend_462 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();

class NSPointerFunctions extends objc.NSObject {
  NSPointerFunctions._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSPointerFunctions] that points to the same underlying object as [other].
  NSPointerFunctions.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSPointerFunctions] that wraps the given raw object pointer.
  NSPointerFunctions.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSPointerFunctions].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSPointerFunctions);
  }

  NSPointerFunctions initWithOptions_(int options) {
    final _ret =
        _objc_msgSend_462(this.pointer, _sel_initWithOptions_, options);
    return NSPointerFunctions.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSPointerFunctions pointerFunctionsWithOptions_(int options) {
    final _ret = _objc_msgSend_463(
        _class_NSPointerFunctions, _sel_pointerFunctionsWithOptions_, options);
    return NSPointerFunctions.castFromPointer(_ret,
        retain: true, release: true);
  }

  ffi.Pointer<
          ffi.NativeFunction<
              ffi.UnsignedLong Function(
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>>
      get hashFunction {
    return _objc_msgSend_464(this.pointer, _sel_hashFunction);
  }

  set hashFunction(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.UnsignedLong Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.UnsignedLong Function(
                                  ffi.Pointer<ffi.Void>)>>)>>
          value) {
    return _objc_msgSend_465(this.pointer, _sel_setHashFunction_, value);
  }

  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Bool Function(
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>>
      get isEqualFunction {
    return _objc_msgSend_466(this.pointer, _sel_isEqualFunction);
  }

  set isEqualFunction(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Bool Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.UnsignedLong Function(
                                  ffi.Pointer<ffi.Void>)>>)>>
          value) {
    return _objc_msgSend_467(this.pointer, _sel_setIsEqualFunction_, value);
  }

  ffi.Pointer<
          ffi.NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>
      get sizeFunction {
    return _objc_msgSend_468(this.pointer, _sel_sizeFunction);
  }

  set sizeFunction(
      ffi.Pointer<
              ffi
              .NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>
          value) {
    return _objc_msgSend_469(this.pointer, _sel_setSizeFunction_, value);
  }

  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>>
      get descriptionFunction {
    return _objc_msgSend_470(this.pointer, _sel_descriptionFunction);
  }

  set descriptionFunction(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>>
          value) {
    return _objc_msgSend_471(this.pointer, _sel_setDescriptionFunction_, value);
  }

  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Void Function(
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>>
      get relinquishFunction {
    return _objc_msgSend_472(this.pointer, _sel_relinquishFunction);
  }

  set relinquishFunction(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.UnsignedLong Function(
                                  ffi.Pointer<ffi.Void>)>>)>>
          value) {
    return _objc_msgSend_473(this.pointer, _sel_setRelinquishFunction_, value);
  }

  ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>,
              ffi.Bool)>> get acquireFunction {
    return _objc_msgSend_474(this.pointer, _sel_acquireFunction);
  }

  set acquireFunction(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Pointer<ffi.Void> Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.UnsignedLong Function(
                                  ffi.Pointer<ffi.Void>)>>,
                      ffi.Bool)>>
          value) {
    return _objc_msgSend_475(this.pointer, _sel_setAcquireFunction_, value);
  }

  bool get usesStrongWriteBarrier {
    return _objc_msgSend_7(this.pointer, _sel_usesStrongWriteBarrier);
  }

  set usesStrongWriteBarrier(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setUsesStrongWriteBarrier_, value);
  }

  bool get usesWeakReadAndWriteBarriers {
    return _objc_msgSend_7(this.pointer, _sel_usesWeakReadAndWriteBarriers);
  }

  set usesWeakReadAndWriteBarriers(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setUsesWeakReadAndWriteBarriers_, value);
  }

  @override
  NSPointerFunctions init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSPointerFunctions.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSPointerFunctions new1() {
    final _ret = _objc_msgSend_40(_class_NSPointerFunctions, _sel_new);
    return NSPointerFunctions.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSPointerFunctions allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSPointerFunctions, _sel_allocWithZone_, zone);
    return NSPointerFunctions.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSPointerFunctions alloc() {
    final _ret = _objc_msgSend_40(_class_NSPointerFunctions, _sel_alloc);
    return NSPointerFunctions.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSPointerFunctions,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSPointerFunctions,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSPointerFunctions, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSPointerFunctions, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSPointerFunctions,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSPointerFunctions,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSPointerFunctions,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSPointerFunctions, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSPointerFunctions, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSPointerFunctions = objc.getClass("NSPointerFunctions");
late final _sel_pointerFunctionsWithOptions_ =
    objc.registerName("pointerFunctionsWithOptions:");
final _objc_msgSend_463 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_hashFunction = objc.registerName("hashFunction");
final _objc_msgSend_464 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<
                ffi.NativeFunction<
                    ffi.UnsignedLong Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<
                            ffi.NativeFunction<
                                ffi.UnsignedLong Function(
                                    ffi.Pointer<ffi.Void>)>>)>>
            Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setHashFunction_ = objc.registerName("setHashFunction:");
final _objc_msgSend_465 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.UnsignedLong Function(
                            ffi.Pointer<ffi.Void>,
                            ffi.Pointer<
                                ffi.NativeFunction<
                                    ffi.UnsignedLong Function(
                                        ffi.Pointer<ffi.Void>)>>)>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.UnsignedLong Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<
                            ffi.NativeFunction<
                                ffi.UnsignedLong Function(
                                    ffi.Pointer<ffi.Void>)>>)>>)>();
late final _sel_isEqualFunction = objc.registerName("isEqualFunction");
final _objc_msgSend_466 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.NativeFunction<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Bool Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<
                            ffi.NativeFunction<
                                ffi.UnsignedLong Function(
                                    ffi.Pointer<ffi.Void>)>>)>>
            Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setIsEqualFunction_ = objc.registerName("setIsEqualFunction:");
final _objc_msgSend_467 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.Bool Function(
                            ffi.Pointer<ffi.Void>,
                            ffi.Pointer<ffi.Void>,
                            ffi.Pointer<
                                ffi.NativeFunction<
                                    ffi.UnsignedLong Function(
                                        ffi.Pointer<ffi.Void>)>>)>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Bool Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<
                            ffi.NativeFunction<
                                ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>>)>();
late final _sel_sizeFunction = objc.registerName("sizeFunction");
final _objc_msgSend_468 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<
                ffi.NativeFunction<
                    ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>
            Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setSizeFunction_ = objc.registerName("setSizeFunction:");
final _objc_msgSend_469 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>();
late final _sel_descriptionFunction = objc.registerName("descriptionFunction");
final _objc_msgSend_470 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.NativeFunction<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<ffi.Void>)>>
            Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setDescriptionFunction_ =
    objc.registerName("setDescriptionFunction:");
final _objc_msgSend_471 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.Pointer<objc.ObjCObject> Function(
                            ffi.Pointer<ffi.Void>)>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<ffi.Void>)>>)>();
late final _sel_relinquishFunction = objc.registerName("relinquishFunction");
final _objc_msgSend_472 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>)>> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Void Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<
                            ffi.NativeFunction<
                                ffi.UnsignedLong Function(
                                    ffi.Pointer<ffi.Void>)>>)>>
            Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setRelinquishFunction_ =
    objc.registerName("setRelinquishFunction:");
final _objc_msgSend_473 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.Void Function(
                            ffi.Pointer<ffi.Void>,
                            ffi.Pointer<
                                ffi.NativeFunction<
                                    ffi.UnsignedLong Function(
                                        ffi.Pointer<ffi.Void>)>>)>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Void Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<
                            ffi.NativeFunction<
                                ffi.UnsignedLong Function(
                                    ffi.Pointer<ffi.Void>)>>)>>)>();
late final _sel_acquireFunction = objc.registerName("acquireFunction");
final _objc_msgSend_474 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.NativeFunction<ffi.Pointer<ffi.Void> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>, ffi.Bool)>> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Pointer<ffi.Void> Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<
                            ffi.NativeFunction<
                                ffi.UnsignedLong Function(
                                    ffi.Pointer<ffi.Void>)>>,
                        ffi.Bool)>>
            Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setAcquireFunction_ = objc.registerName("setAcquireFunction:");
final _objc_msgSend_475 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.Pointer<ffi.Void> Function(
                            ffi.Pointer<ffi.Void>,
                            ffi.Pointer<
                                ffi.NativeFunction<
                                    ffi.UnsignedLong Function(
                                        ffi.Pointer<ffi.Void>)>>,
                            ffi.Bool)>>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Pointer<ffi.Void> Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<
                            ffi
                            .NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>>,
                        ffi.Bool)>>)>();
late final _sel_usesStrongWriteBarrier =
    objc.registerName("usesStrongWriteBarrier");
late final _sel_setUsesStrongWriteBarrier_ =
    objc.registerName("setUsesStrongWriteBarrier:");
late final _sel_usesWeakReadAndWriteBarriers =
    objc.registerName("usesWeakReadAndWriteBarriers");
late final _sel_setUsesWeakReadAndWriteBarriers_ =
    objc.registerName("setUsesWeakReadAndWriteBarriers:");
late final _sel_initWithPointerFunctions_ =
    objc.registerName("initWithPointerFunctions:");
final _objc_msgSend_476 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_pointerArrayWithOptions_ =
    objc.registerName("pointerArrayWithOptions:");
final _objc_msgSend_477 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_pointerArrayWithPointerFunctions_ =
    objc.registerName("pointerArrayWithPointerFunctions:");
final _objc_msgSend_478 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_pointerFunctions = objc.registerName("pointerFunctions");
final _objc_msgSend_479 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_pointerAtIndex_ = objc.registerName("pointerAtIndex:");
final _objc_msgSend_480 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.Void> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<ffi.Void> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_addPointer_ = objc.registerName("addPointer:");
final _objc_msgSend_481 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Void>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Void>)>();
late final _sel_removePointerAtIndex_ =
    objc.registerName("removePointerAtIndex:");
late final _sel_insertPointer_atIndex_ =
    objc.registerName("insertPointer:atIndex:");
final _objc_msgSend_482 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Void>, int)>();
late final _sel_replacePointerAtIndex_withPointer_ =
    objc.registerName("replacePointerAtIndex:withPointer:");
final _objc_msgSend_483 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Void>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, ffi.Pointer<ffi.Void>)>();
late final _sel_compact = objc.registerName("compact");
late final _sel_setCount_ = objc.registerName("setCount:");
late final _sel_pointerArrayWithStrongObjects =
    objc.registerName("pointerArrayWithStrongObjects");
late final _sel_pointerArrayWithWeakObjects =
    objc.registerName("pointerArrayWithWeakObjects");
late final _sel_strongObjectsPointerArray =
    objc.registerName("strongObjectsPointerArray");
final _objc_msgSend_484 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_weakObjectsPointerArray =
    objc.registerName("weakObjectsPointerArray");
late final _sel_allObjects = objc.registerName("allObjects");

class NSProcessInfo extends objc.NSObject {
  NSProcessInfo._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSProcessInfo] that points to the same underlying object as [other].
  NSProcessInfo.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSProcessInfo] that wraps the given raw object pointer.
  NSProcessInfo.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSProcessInfo].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSProcessInfo);
  }

  static NSProcessInfo getProcessInfo() {
    final _ret = _objc_msgSend_485(_class_NSProcessInfo, _sel_processInfo);
    return NSProcessInfo.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary get environment {
    final _ret = _objc_msgSend_112(this.pointer, _sel_environment);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray get arguments {
    final _ret = _objc_msgSend_6(this.pointer, _sel_arguments);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get hostName {
    final _ret = _objc_msgSend_12(this.pointer, _sel_hostName);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get processName {
    final _ret = _objc_msgSend_12(this.pointer, _sel_processName);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  set processName(objc.NSString value) {
    return _objc_msgSend_99(this.pointer, _sel_setProcessName_, value.pointer);
  }

  int get processIdentifier {
    return _objc_msgSend_264(this.pointer, _sel_processIdentifier);
  }

  objc.NSString get globallyUniqueString {
    final _ret = _objc_msgSend_12(this.pointer, _sel_globallyUniqueString);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int operatingSystem() {
    return _objc_msgSend_29(this.pointer, _sel_operatingSystem);
  }

  objc.NSString operatingSystemName() {
    final _ret = _objc_msgSend_12(this.pointer, _sel_operatingSystemName);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get operatingSystemVersionString {
    final _ret =
        _objc_msgSend_12(this.pointer, _sel_operatingSystemVersionString);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  void getOperatingSystemVersion(ffi.Pointer<NSOperatingSystemVersion> stret) {
    objc.useMsgSendVariants
        ? _objc_msgSend_486Stret(
            stret, this.pointer, _sel_operatingSystemVersion)
        : stret.ref =
            _objc_msgSend_486(this.pointer, _sel_operatingSystemVersion);
  }

  int get processorCount {
    return _objc_msgSend_29(this.pointer, _sel_processorCount);
  }

  int get activeProcessorCount {
    return _objc_msgSend_29(this.pointer, _sel_activeProcessorCount);
  }

  int get physicalMemory {
    return _objc_msgSend_267(this.pointer, _sel_physicalMemory);
  }

  bool isOperatingSystemAtLeastVersion_(NSOperatingSystemVersion version) {
    return _objc_msgSend_487(
        this.pointer, _sel_isOperatingSystemAtLeastVersion_, version);
  }

  double get systemUptime {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_systemUptime)
        : _objc_msgSend_115(this.pointer, _sel_systemUptime);
  }

  void disableSuddenTermination() {
    _objc_msgSend_82(this.pointer, _sel_disableSuddenTermination);
  }

  void enableSuddenTermination() {
    _objc_msgSend_82(this.pointer, _sel_enableSuddenTermination);
  }

  void disableAutomaticTermination_(objc.NSString reason) {
    _objc_msgSend_98(
        this.pointer, _sel_disableAutomaticTermination_, reason.pointer);
  }

  void enableAutomaticTermination_(objc.NSString reason) {
    _objc_msgSend_98(
        this.pointer, _sel_enableAutomaticTermination_, reason.pointer);
  }

  bool get automaticTerminationSupportEnabled {
    return _objc_msgSend_7(
        this.pointer, _sel_automaticTerminationSupportEnabled);
  }

  set automaticTerminationSupportEnabled(bool value) {
    return _objc_msgSend_41(
        this.pointer, _sel_setAutomaticTerminationSupportEnabled_, value);
  }

  objc.NSObject beginActivityWithOptions_reason_(
      int options, objc.NSString reason) {
    final _ret = _objc_msgSend_488(this.pointer,
        _sel_beginActivityWithOptions_reason_, options, reason.pointer);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  void endActivity_(objc.NSObject activity) {
    _objc_msgSend_49(this.pointer, _sel_endActivity_, activity.pointer);
  }

  void performActivityWithOptions_reason_usingBlock_(
      int options, objc.NSString reason, ObjCBlock_ffiVoid block) {
    _objc_msgSend_489(
        this.pointer,
        _sel_performActivityWithOptions_reason_usingBlock_,
        options,
        reason.pointer,
        block.pointer);
  }

  void performExpiringActivityWithReason_usingBlock_(
      objc.NSString reason, ObjCBlock_ffiVoid_bool block) {
    _objc_msgSend_490(
        this.pointer,
        _sel_performExpiringActivityWithReason_usingBlock_,
        reason.pointer,
        block.pointer);
  }

  objc.NSString get userName {
    final _ret = _objc_msgSend_12(this.pointer, _sel_userName);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get fullUserName {
    final _ret = _objc_msgSend_12(this.pointer, _sel_fullUserName);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int get thermalState {
    return _objc_msgSend_491(this.pointer, _sel_thermalState);
  }

  bool get lowPowerModeEnabled {
    return _objc_msgSend_7(this.pointer, _sel_isLowPowerModeEnabled);
  }

  bool get macCatalystApp {
    return _objc_msgSend_7(this.pointer, _sel_isMacCatalystApp);
  }

  bool get iOSAppOnMac {
    return _objc_msgSend_7(this.pointer, _sel_isiOSAppOnMac);
  }

  @override
  NSProcessInfo init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSProcessInfo.castFromPointer(_ret, retain: true, release: true);
  }

  static NSProcessInfo new1() {
    final _ret = _objc_msgSend_40(_class_NSProcessInfo, _sel_new);
    return NSProcessInfo.castFromPointer(_ret, retain: false, release: true);
  }

  static NSProcessInfo allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSProcessInfo, _sel_allocWithZone_, zone);
    return NSProcessInfo.castFromPointer(_ret, retain: false, release: true);
  }

  static NSProcessInfo alloc() {
    final _ret = _objc_msgSend_40(_class_NSProcessInfo, _sel_alloc);
    return NSProcessInfo.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSProcessInfo,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSProcessInfo,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSProcessInfo, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSProcessInfo, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSProcessInfo,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSProcessInfo,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSProcessInfo,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSProcessInfo, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSProcessInfo, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSProcessInfo = objc.getClass("NSProcessInfo");
late final _sel_processInfo = objc.registerName("processInfo");
final _objc_msgSend_485 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_environment = objc.registerName("environment");
late final _sel_arguments = objc.registerName("arguments");
late final _sel_hostName = objc.registerName("hostName");
late final _sel_processName = objc.registerName("processName");
late final _sel_setProcessName_ = objc.registerName("setProcessName:");
late final _sel_processIdentifier = objc.registerName("processIdentifier");
late final _sel_globallyUniqueString =
    objc.registerName("globallyUniqueString");
late final _sel_operatingSystem = objc.registerName("operatingSystem");
late final _sel_operatingSystemName = objc.registerName("operatingSystemName");
late final _sel_operatingSystemVersionString =
    objc.registerName("operatingSystemVersionString");

final class NSOperatingSystemVersion extends ffi.Struct {
  @ffi.Long()
  external int majorVersion;

  @ffi.Long()
  external int minorVersion;

  @ffi.Long()
  external int patchVersion;
}

late final _sel_operatingSystemVersion =
    objc.registerName("operatingSystemVersion");
final _objc_msgSend_486 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            NSOperatingSystemVersion Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        NSOperatingSystemVersion Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_486Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<NSOperatingSystemVersion>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        void Function(ffi.Pointer<NSOperatingSystemVersion>,
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_processorCount = objc.registerName("processorCount");
late final _sel_activeProcessorCount =
    objc.registerName("activeProcessorCount");
late final _sel_physicalMemory = objc.registerName("physicalMemory");
late final _sel_isOperatingSystemAtLeastVersion_ =
    objc.registerName("isOperatingSystemAtLeastVersion:");
final _objc_msgSend_487 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, NSOperatingSystemVersion)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, NSOperatingSystemVersion)>();
late final _sel_systemUptime = objc.registerName("systemUptime");
late final _sel_disableSuddenTermination =
    objc.registerName("disableSuddenTermination");
late final _sel_enableSuddenTermination =
    objc.registerName("enableSuddenTermination");
late final _sel_disableAutomaticTermination_ =
    objc.registerName("disableAutomaticTermination:");
late final _sel_enableAutomaticTermination_ =
    objc.registerName("enableAutomaticTermination:");
late final _sel_automaticTerminationSupportEnabled =
    objc.registerName("automaticTerminationSupportEnabled");
late final _sel_setAutomaticTerminationSupportEnabled_ =
    objc.registerName("setAutomaticTerminationSupportEnabled:");

abstract class NSActivityOptions {
  static const int NSActivityIdleDisplaySleepDisabled = 1099511627776;
  static const int NSActivityIdleSystemSleepDisabled = 1048576;
  static const int NSActivitySuddenTerminationDisabled = 16384;
  static const int NSActivityAutomaticTerminationDisabled = 32768;
  static const int NSActivityAnimationTrackingEnabled = 35184372088832;
  static const int NSActivityTrackingEnabled = 70368744177664;
  static const int NSActivityUserInitiated = 16777215;
  static const int NSActivityUserInitiatedAllowingIdleSystemSleep = 15728639;
  static const int NSActivityBackground = 255;
  static const int NSActivityLatencyCritical = 1095216660480;
  static const int NSActivityUserInteractive = 1095233437695;
}

late final _sel_beginActivityWithOptions_reason_ =
    objc.registerName("beginActivityWithOptions:reason:");
final _objc_msgSend_488 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_endActivity_ = objc.registerName("endActivity:");
late final _sel_performActivityWithOptions_reason_usingBlock_ =
    objc.registerName("performActivityWithOptions:reason:usingBlock:");
final _objc_msgSend_489 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Int32,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCBlock>)>();
void _ObjCBlock_ffiVoid_bool_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, bool arg0) =>
    block.ref.target
        .cast<ffi.NativeFunction<ffi.Void Function(ffi.Bool arg0)>>()
        .asFunction<void Function(bool)>()(arg0);
final _ObjCBlock_ffiVoid_bool_closureRegistry = <int, void Function(bool)>{};
int _ObjCBlock_ffiVoid_bool_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_bool_registerClosure(
    void Function(bool) fn) {
  final id = ++_ObjCBlock_ffiVoid_bool_closureRegistryIndex;
  _ObjCBlock_ffiVoid_bool_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_bool_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, bool arg0) =>
    _ObjCBlock_ffiVoid_bool_closureRegistry[block.ref.target.address]!(arg0);

class ObjCBlock_ffiVoid_bool extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_bool._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_bool castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_bool._(pointer, retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_bool.fromFunctionPointer(
      ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Bool arg0)>> ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                    ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                        ffi.Bool)>(_ObjCBlock_ffiVoid_bool_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_bool.fromFunction(void Function(bool) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                    ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                        ffi.Bool)>(_ObjCBlock_ffiVoid_bool_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_bool_registerClosure((bool arg0) => fn(arg0))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_bool.listener(void Function(bool) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>, ffi.Bool)>.listener(
                    _ObjCBlock_ffiVoid_bool_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_bool_registerClosure((bool arg0) => fn(arg0))));
  static ffi
      .NativeCallable<ffi.Void Function(ffi.Pointer<objc.ObjCBlock>, ffi.Bool)>?
      _dartFuncListenerTrampoline;

  void call(bool arg0) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<objc.ObjCBlock> block, ffi.Bool arg0)>>()
          .asFunction<void Function(ffi.Pointer<objc.ObjCBlock>, bool)>()(
      pointer, arg0);
}

late final _sel_performExpiringActivityWithReason_usingBlock_ =
    objc.registerName("performExpiringActivityWithReason:usingBlock:");
final _objc_msgSend_490 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_userName = objc.registerName("userName");
late final _sel_fullUserName = objc.registerName("fullUserName");

abstract class NSProcessInfoThermalState {
  static const int NSProcessInfoThermalStateNominal = 0;
  static const int NSProcessInfoThermalStateFair = 1;
  static const int NSProcessInfoThermalStateSerious = 2;
  static const int NSProcessInfoThermalStateCritical = 3;
}

late final _sel_thermalState = objc.registerName("thermalState");
final _objc_msgSend_491 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_isLowPowerModeEnabled =
    objc.registerName("isLowPowerModeEnabled");
late final _sel_isMacCatalystApp = objc.registerName("isMacCatalystApp");
late final _sel_isiOSAppOnMac = objc.registerName("isiOSAppOnMac");

class NSTextCheckingResult extends objc.NSObject {
  NSTextCheckingResult._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSTextCheckingResult] that points to the same underlying object as [other].
  NSTextCheckingResult.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSTextCheckingResult] that wraps the given raw object pointer.
  NSTextCheckingResult.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSTextCheckingResult].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSTextCheckingResult);
  }

  int get resultType {
    return _objc_msgSend_492(this.pointer, _sel_resultType);
  }

  void getRange(ffi.Pointer<_NSRange> stret) {
    objc.useMsgSendVariants
        ? _objc_msgSend_493Stret(stret, this.pointer, _sel_range)
        : stret.ref = _objc_msgSend_493(this.pointer, _sel_range);
  }

  NSOrthography? get orthography {
    final _ret = _objc_msgSend_494(this.pointer, _sel_orthography);
    return _ret.address == 0
        ? null
        : NSOrthography.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? get grammarDetails {
    final _ret = _objc_msgSend_69(this.pointer, _sel_grammarDetails);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDate? get date {
    final _ret = _objc_msgSend_116(this.pointer, _sel_date);
    return _ret.address == 0
        ? null
        : objc.NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  NSTimeZone? get timeZone {
    final _ret = _objc_msgSend_132(this.pointer, _sel_timeZone);
    return _ret.address == 0
        ? null
        : NSTimeZone.castFromPointer(_ret, retain: true, release: true);
  }

  double get duration {
    return objc.useMsgSendVariants
        ? _objc_msgSend_115Fpret(this.pointer, _sel_duration)
        : _objc_msgSend_115(this.pointer, _sel_duration);
  }

  objc.NSDictionary? get components {
    final _ret = _objc_msgSend_65(this.pointer, _sel_components);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSURL? get URL {
    final _ret = _objc_msgSend_10(this.pointer, _sel_URL);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get replacementString {
    final _ret = _objc_msgSend_13(this.pointer, _sel_replacementString);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? get alternativeStrings {
    final _ret = _objc_msgSend_69(this.pointer, _sel_alternativeStrings);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  NSRegularExpression? get regularExpression {
    final _ret = _objc_msgSend_506(this.pointer, _sel_regularExpression);
    return _ret.address == 0
        ? null
        : NSRegularExpression.castFromPointer(_ret,
            retain: true, release: true);
  }

  objc.NSString? get phoneNumber {
    final _ret = _objc_msgSend_13(this.pointer, _sel_phoneNumber);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int get numberOfRanges {
    return _objc_msgSend_29(this.pointer, _sel_numberOfRanges);
  }

  void rangeAtIndex_(ffi.Pointer<_NSRange> stret, int idx) {
    objc.useMsgSendVariants
        ? _objc_msgSend_507Stret(stret, this.pointer, _sel_rangeAtIndex_, idx)
        : stret.ref = _objc_msgSend_507(this.pointer, _sel_rangeAtIndex_, idx);
  }

  void rangeWithName_(ffi.Pointer<_NSRange> stret, objc.NSString name) {
    objc.useMsgSendVariants
        ? _objc_msgSend_508Stret(
            stret, this.pointer, _sel_rangeWithName_, name.pointer)
        : stret.ref =
            _objc_msgSend_508(this.pointer, _sel_rangeWithName_, name.pointer);
  }

  NSTextCheckingResult resultByAdjustingRangesWithOffset_(int offset) {
    final _ret = _objc_msgSend_509(
        this.pointer, _sel_resultByAdjustingRangesWithOffset_, offset);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  objc.NSDictionary? get addressComponents {
    final _ret = _objc_msgSend_65(this.pointer, _sel_addressComponents);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  static NSTextCheckingResult orthographyCheckingResultWithRange_orthography_(
      _NSRange range, NSOrthography orthography) {
    final _ret = _objc_msgSend_510(
        _class_NSTextCheckingResult,
        _sel_orthographyCheckingResultWithRange_orthography_,
        range,
        orthography.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult spellCheckingResultWithRange_(_NSRange range) {
    final _ret = _objc_msgSend_511(
        _class_NSTextCheckingResult, _sel_spellCheckingResultWithRange_, range);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult grammarCheckingResultWithRange_details_(
      _NSRange range, objc.NSArray details) {
    final _ret = _objc_msgSend_512(_class_NSTextCheckingResult,
        _sel_grammarCheckingResultWithRange_details_, range, details.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult dateCheckingResultWithRange_date_(
      _NSRange range, objc.NSDate date) {
    final _ret = _objc_msgSend_513(_class_NSTextCheckingResult,
        _sel_dateCheckingResultWithRange_date_, range, date.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult
      dateCheckingResultWithRange_date_timeZone_duration_(_NSRange range,
          objc.NSDate date, NSTimeZone timeZone, double duration) {
    final _ret = _objc_msgSend_514(
        _class_NSTextCheckingResult,
        _sel_dateCheckingResultWithRange_date_timeZone_duration_,
        range,
        date.pointer,
        timeZone.pointer,
        duration);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult addressCheckingResultWithRange_components_(
      _NSRange range, objc.NSDictionary components) {
    final _ret = _objc_msgSend_515(
        _class_NSTextCheckingResult,
        _sel_addressCheckingResultWithRange_components_,
        range,
        components.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult linkCheckingResultWithRange_URL_(
      _NSRange range, objc.NSURL url) {
    final _ret = _objc_msgSend_516(_class_NSTextCheckingResult,
        _sel_linkCheckingResultWithRange_URL_, range, url.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult quoteCheckingResultWithRange_replacementString_(
      _NSRange range, objc.NSString replacementString) {
    final _ret = _objc_msgSend_517(
        _class_NSTextCheckingResult,
        _sel_quoteCheckingResultWithRange_replacementString_,
        range,
        replacementString.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult dashCheckingResultWithRange_replacementString_(
      _NSRange range, objc.NSString replacementString) {
    final _ret = _objc_msgSend_517(
        _class_NSTextCheckingResult,
        _sel_dashCheckingResultWithRange_replacementString_,
        range,
        replacementString.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult
      replacementCheckingResultWithRange_replacementString_(
          _NSRange range, objc.NSString replacementString) {
    final _ret = _objc_msgSend_517(
        _class_NSTextCheckingResult,
        _sel_replacementCheckingResultWithRange_replacementString_,
        range,
        replacementString.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult
      correctionCheckingResultWithRange_replacementString_(
          _NSRange range, objc.NSString replacementString) {
    final _ret = _objc_msgSend_517(
        _class_NSTextCheckingResult,
        _sel_correctionCheckingResultWithRange_replacementString_,
        range,
        replacementString.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult
      correctionCheckingResultWithRange_replacementString_alternativeStrings_(
          _NSRange range,
          objc.NSString replacementString,
          objc.NSArray alternativeStrings) {
    final _ret = _objc_msgSend_518(
        _class_NSTextCheckingResult,
        _sel_correctionCheckingResultWithRange_replacementString_alternativeStrings_,
        range,
        replacementString.pointer,
        alternativeStrings.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult
      regularExpressionCheckingResultWithRanges_count_regularExpression_(
          ffi.Pointer<_NSRange> ranges,
          int count,
          NSRegularExpression regularExpression) {
    final _ret = _objc_msgSend_519(
        _class_NSTextCheckingResult,
        _sel_regularExpressionCheckingResultWithRanges_count_regularExpression_,
        ranges,
        count,
        regularExpression.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult phoneNumberCheckingResultWithRange_phoneNumber_(
      _NSRange range, objc.NSString phoneNumber) {
    final _ret = _objc_msgSend_517(
        _class_NSTextCheckingResult,
        _sel_phoneNumberCheckingResultWithRange_phoneNumber_,
        range,
        phoneNumber.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult
      transitInformationCheckingResultWithRange_components_(
          _NSRange range, objc.NSDictionary components) {
    final _ret = _objc_msgSend_515(
        _class_NSTextCheckingResult,
        _sel_transitInformationCheckingResultWithRange_components_,
        range,
        components.pointer);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  @override
  NSTextCheckingResult init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSTextCheckingResult new1() {
    final _ret = _objc_msgSend_40(_class_NSTextCheckingResult, _sel_new);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSTextCheckingResult allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(
        _class_NSTextCheckingResult, _sel_allocWithZone_, zone);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSTextCheckingResult alloc() {
    final _ret = _objc_msgSend_40(_class_NSTextCheckingResult, _sel_alloc);
    return NSTextCheckingResult.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSTextCheckingResult,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSTextCheckingResult,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSTextCheckingResult, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSTextCheckingResult, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSTextCheckingResult,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSTextCheckingResult,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSTextCheckingResult,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSTextCheckingResult, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSTextCheckingResult, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSTextCheckingResult = objc.getClass("NSTextCheckingResult");

abstract class NSTextCheckingType {
  static const int NSTextCheckingTypeOrthography = 1;
  static const int NSTextCheckingTypeSpelling = 2;
  static const int NSTextCheckingTypeGrammar = 4;
  static const int NSTextCheckingTypeDate = 8;
  static const int NSTextCheckingTypeAddress = 16;
  static const int NSTextCheckingTypeLink = 32;
  static const int NSTextCheckingTypeQuote = 64;
  static const int NSTextCheckingTypeDash = 128;
  static const int NSTextCheckingTypeReplacement = 256;
  static const int NSTextCheckingTypeCorrection = 512;
  static const int NSTextCheckingTypeRegularExpression = 1024;
  static const int NSTextCheckingTypePhoneNumber = 2048;
  static const int NSTextCheckingTypeTransitInformation = 4096;
}

late final _sel_resultType = objc.registerName("resultType");
final _objc_msgSend_492 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_range = objc.registerName("range");
final _objc_msgSend_493 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            _NSRange Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        _NSRange Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_493Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<_NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        void Function(ffi.Pointer<_NSRange>, ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_orthography = objc.registerName("orthography");
final _objc_msgSend_494 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_grammarDetails = objc.registerName("grammarDetails");
late final _sel_duration = objc.registerName("duration");
late final _sel_components = objc.registerName("components");
late final _sel_replacementString = objc.registerName("replacementString");
late final _sel_alternativeStrings = objc.registerName("alternativeStrings");

class NSRegularExpression extends objc.NSObject {
  NSRegularExpression._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSRegularExpression] that points to the same underlying object as [other].
  NSRegularExpression.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSRegularExpression] that wraps the given raw object pointer.
  NSRegularExpression.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSRegularExpression].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSRegularExpression);
  }

  static NSRegularExpression? regularExpressionWithPattern_options_error_(
      objc.NSString pattern,
      int options,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_495(
        _class_NSRegularExpression,
        _sel_regularExpressionWithPattern_options_error_,
        pattern.pointer,
        options,
        error);
    return _ret.address == 0
        ? null
        : NSRegularExpression.castFromPointer(_ret,
            retain: true, release: true);
  }

  NSRegularExpression? initWithPattern_options_error_(objc.NSString pattern,
      int options, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_496(this.pointer,
        _sel_initWithPattern_options_error_, pattern.pointer, options, error);
    return _ret.address == 0
        ? null
        : NSRegularExpression.castFromPointer(_ret,
            retain: true, release: true);
  }

  objc.NSString get pattern {
    final _ret = _objc_msgSend_12(this.pointer, _sel_pattern);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int get options {
    return _objc_msgSend_497(this.pointer, _sel_options);
  }

  int get numberOfCaptureGroups {
    return _objc_msgSend_29(this.pointer, _sel_numberOfCaptureGroups);
  }

  static objc.NSString escapedPatternForString_(objc.NSString string) {
    final _ret = _objc_msgSend_297(_class_NSRegularExpression,
        _sel_escapedPatternForString_, string.pointer);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  void enumerateMatchesInString_options_range_usingBlock_(
      objc.NSString string,
      int options,
      _NSRange range,
      ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool block) {
    _objc_msgSend_498(
        this.pointer,
        _sel_enumerateMatchesInString_options_range_usingBlock_,
        string.pointer,
        options,
        range,
        block.pointer);
  }

  objc.NSArray matchesInString_options_range_(
      objc.NSString string, int options, _NSRange range) {
    final _ret = _objc_msgSend_499(this.pointer,
        _sel_matchesInString_options_range_, string.pointer, options, range);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  int numberOfMatchesInString_options_range_(
      objc.NSString string, int options, _NSRange range) {
    return _objc_msgSend_500(
        this.pointer,
        _sel_numberOfMatchesInString_options_range_,
        string.pointer,
        options,
        range);
  }

  NSTextCheckingResult? firstMatchInString_options_range_(
      objc.NSString string, int options, _NSRange range) {
    final _ret = _objc_msgSend_501(this.pointer,
        _sel_firstMatchInString_options_range_, string.pointer, options, range);
    return _ret.address == 0
        ? null
        : NSTextCheckingResult.castFromPointer(_ret,
            retain: true, release: true);
  }

  void rangeOfFirstMatchInString_options_range_(ffi.Pointer<_NSRange> stret,
      objc.NSString string, int options, _NSRange range) {
    objc.useMsgSendVariants
        ? _objc_msgSend_502Stret(
            stret,
            this.pointer,
            _sel_rangeOfFirstMatchInString_options_range_,
            string.pointer,
            options,
            range)
        : stret.ref = _objc_msgSend_502(
            this.pointer,
            _sel_rangeOfFirstMatchInString_options_range_,
            string.pointer,
            options,
            range);
  }

  objc.NSString stringByReplacingMatchesInString_options_range_withTemplate_(
      objc.NSString string, int options, _NSRange range, objc.NSString templ) {
    final _ret = _objc_msgSend_503(
        this.pointer,
        _sel_stringByReplacingMatchesInString_options_range_withTemplate_,
        string.pointer,
        options,
        range,
        templ.pointer);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int replaceMatchesInString_options_range_withTemplate_(
      objc.NSMutableString string,
      int options,
      _NSRange range,
      objc.NSString templ) {
    return _objc_msgSend_504(
        this.pointer,
        _sel_replaceMatchesInString_options_range_withTemplate_,
        string.pointer,
        options,
        range,
        templ.pointer);
  }

  objc.NSString replacementStringForResult_inString_offset_template_(
      NSTextCheckingResult result,
      objc.NSString string,
      int offset,
      objc.NSString templ) {
    final _ret = _objc_msgSend_505(
        this.pointer,
        _sel_replacementStringForResult_inString_offset_template_,
        result.pointer,
        string.pointer,
        offset,
        templ.pointer);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSString escapedTemplateForString_(objc.NSString string) {
    final _ret = _objc_msgSend_297(_class_NSRegularExpression,
        _sel_escapedTemplateForString_, string.pointer);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSRegularExpression init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSRegularExpression.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSRegularExpression new1() {
    final _ret = _objc_msgSend_40(_class_NSRegularExpression, _sel_new);
    return NSRegularExpression.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSRegularExpression allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSRegularExpression, _sel_allocWithZone_, zone);
    return NSRegularExpression.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSRegularExpression alloc() {
    final _ret = _objc_msgSend_40(_class_NSRegularExpression, _sel_alloc);
    return NSRegularExpression.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSRegularExpression,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSRegularExpression,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSRegularExpression, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSRegularExpression, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSRegularExpression,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSRegularExpression,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSRegularExpression,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSRegularExpression, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSRegularExpression, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSRegularExpression = objc.getClass("NSRegularExpression");

abstract class NSRegularExpressionOptions {
  static const int NSRegularExpressionCaseInsensitive = 1;
  static const int NSRegularExpressionAllowCommentsAndWhitespace = 2;
  static const int NSRegularExpressionIgnoreMetacharacters = 4;
  static const int NSRegularExpressionDotMatchesLineSeparators = 8;
  static const int NSRegularExpressionAnchorsMatchLines = 16;
  static const int NSRegularExpressionUseUnixLineSeparators = 32;
  static const int NSRegularExpressionUseUnicodeWordBoundaries = 64;
}

late final _sel_regularExpressionWithPattern_options_error_ =
    objc.registerName("regularExpressionWithPattern:options:error:");
final _objc_msgSend_495 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_initWithPattern_options_error_ =
    objc.registerName("initWithPattern:options:error:");
final _objc_msgSend_496 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_pattern = objc.registerName("pattern");
late final _sel_options = objc.registerName("options");
final _objc_msgSend_497 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_numberOfCaptureGroups =
    objc.registerName("numberOfCaptureGroups");
late final _sel_escapedPatternForString_ =
    objc.registerName("escapedPatternForString:");

abstract class NSMatchingOptions {
  static const int NSMatchingReportProgress = 1;
  static const int NSMatchingReportCompletion = 2;
  static const int NSMatchingAnchored = 4;
  static const int NSMatchingWithTransparentBounds = 8;
  static const int NSMatchingWithoutAnchoringBounds = 16;
}

void
    _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_fnPtrTrampoline(
            ffi.Pointer<objc.ObjCBlock> block,
            ffi.Pointer<objc.ObjCObject> arg0,
            int arg1,
            ffi.Pointer<ffi.Bool> arg2) =>
        block.ref.target
            .cast<
                ffi.NativeFunction<
                    ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                        ffi.Int32 arg1, ffi.Pointer<ffi.Bool> arg2)>>()
            .asFunction<
                void Function(ffi.Pointer<objc.ObjCObject>, int,
                    ffi.Pointer<ffi.Bool>)>()(arg0, arg1, arg2);
final _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_closureRegistry =
    <int,
        void Function(
            ffi.Pointer<objc.ObjCObject>, int, ffi.Pointer<ffi.Bool>)>{};
int _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_closureRegistryIndex =
    0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_registerClosure(
        void Function(ffi.Pointer<objc.ObjCObject>, int, ffi.Pointer<ffi.Bool>)
            fn) {
  final id =
      ++_ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_closureRegistry[
      id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        int arg1,
        ffi.Pointer<ffi.Bool> arg2) =>
    _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_closureRegistry[
        block.ref.target.address]!(arg0, arg1, arg2);

class ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool
    extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool
      castFromPointer(ffi.Pointer<objc.ObjCBlock> pointer,
          {bool retain = false, bool release = false}) {
    return ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool._(
        pointer,
        retain: retain,
        release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Int32 arg1, ffi.Pointer<ffi.Bool> arg2)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Int32,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool.fromFunction(
      void Function(NSTextCheckingResult?, int, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Int32,
                            ffi.Pointer<ffi.Bool>)>(
                    _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, int arg1,
                        ffi.Pointer<ffi.Bool> arg2) =>
                    fn(arg0.address == 0 ? null : NSTextCheckingResult.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool.listener(
      void Function(NSTextCheckingResult?, int, ffi.Pointer<ffi.Bool>) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Int32,
                            ffi.Pointer<ffi.Bool>)>.listener(
                    _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSTextCheckingResult_NSMatchingFlags_bool_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0, int arg1, ffi.Pointer<ffi.Bool> arg2) =>
                    fn(arg0.address == 0 ? null : NSTextCheckingResult.castFromPointer(arg0, retain: true, release: true), arg1, arg2))));
  static ffi.NativeCallable<
      ffi.Void Function(
          ffi.Pointer<objc.ObjCBlock>,
          ffi.Pointer<objc.ObjCObject>,
          ffi.Int32,
          ffi.Pointer<ffi.Bool>)>? _dartFuncListenerTrampoline;

  void call(NSTextCheckingResult? arg0, int arg1, ffi.Pointer<ffi.Bool> arg2) =>
      pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<objc.ObjCBlock> block,
                          ffi.Pointer<objc.ObjCObject> arg0,
                          ffi.Int32 arg1,
                          ffi.Pointer<ffi.Bool> arg2)>>()
              .asFunction<
                  void Function(
                      ffi.Pointer<objc.ObjCBlock>,
                      ffi.Pointer<objc.ObjCObject>,
                      int,
                      ffi.Pointer<ffi.Bool>)>()(
          pointer, arg0?.pointer ?? ffi.nullptr, arg1, arg2);
}

abstract class NSMatchingFlags {
  static const int NSMatchingProgress = 1;
  static const int NSMatchingCompleted = 2;
  static const int NSMatchingHitEnd = 4;
  static const int NSMatchingRequiredEnd = 8;
  static const int NSMatchingInternalError = 16;
}

late final _sel_enumerateMatchesInString_options_range_usingBlock_ =
    objc.registerName("enumerateMatchesInString:options:range:usingBlock:");
final _objc_msgSend_498 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                _NSRange,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            _NSRange,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_matchesInString_options_range_ =
    objc.registerName("matchesInString:options:range:");
final _objc_msgSend_499 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                _NSRange)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            _NSRange)>();
late final _sel_numberOfMatchesInString_options_range_ =
    objc.registerName("numberOfMatchesInString:options:range:");
final _objc_msgSend_500 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                _NSRange)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            _NSRange)>();
late final _sel_firstMatchInString_options_range_ =
    objc.registerName("firstMatchInString:options:range:");
final _objc_msgSend_501 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                _NSRange)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            _NSRange)>();
late final _sel_rangeOfFirstMatchInString_options_range_ =
    objc.registerName("rangeOfFirstMatchInString:options:range:");
final _objc_msgSend_502 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            _NSRange Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                _NSRange)>>()
    .asFunction<
        _NSRange Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            _NSRange)>();
final _objc_msgSend_502Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<_NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                _NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<_NSRange>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            _NSRange)>();
late final _sel_stringByReplacingMatchesInString_options_range_withTemplate_ =
    objc.registerName(
        "stringByReplacingMatchesInString:options:range:withTemplate:");
final _objc_msgSend_503 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_replaceMatchesInString_options_range_withTemplate_ =
    objc.registerName("replaceMatchesInString:options:range:withTemplate:");
final _objc_msgSend_504 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_replacementStringForResult_inString_offset_template_ =
    objc.registerName("replacementStringForResult:inString:offset:template:");
final _objc_msgSend_505 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_escapedTemplateForString_ =
    objc.registerName("escapedTemplateForString:");
late final _sel_regularExpression = objc.registerName("regularExpression");
final _objc_msgSend_506 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_phoneNumber = objc.registerName("phoneNumber");
late final _sel_numberOfRanges = objc.registerName("numberOfRanges");
late final _sel_rangeAtIndex_ = objc.registerName("rangeAtIndex:");
final _objc_msgSend_507 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            _NSRange Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        _NSRange Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_507Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<_NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<_NSRange>, ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_rangeWithName_ = objc.registerName("rangeWithName:");
final _objc_msgSend_508 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            _NSRange Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        _NSRange Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_508Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<_NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<_NSRange>, ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_resultByAdjustingRangesWithOffset_ =
    objc.registerName("resultByAdjustingRangesWithOffset:");
final _objc_msgSend_509 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Long)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_addressComponents = objc.registerName("addressComponents");
late final _sel_orthographyCheckingResultWithRange_orthography_ =
    objc.registerName("orthographyCheckingResultWithRange:orthography:");
final _objc_msgSend_510 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_spellCheckingResultWithRange_ =
    objc.registerName("spellCheckingResultWithRange:");
final _objc_msgSend_511 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, _NSRange)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, _NSRange)>();
late final _sel_grammarCheckingResultWithRange_details_ =
    objc.registerName("grammarCheckingResultWithRange:details:");
final _objc_msgSend_512 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_dateCheckingResultWithRange_date_ =
    objc.registerName("dateCheckingResultWithRange:date:");
final _objc_msgSend_513 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_dateCheckingResultWithRange_date_timeZone_duration_ =
    objc.registerName("dateCheckingResultWithRange:date:timeZone:duration:");
final _objc_msgSend_514 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Double)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            double)>();
late final _sel_addressCheckingResultWithRange_components_ =
    objc.registerName("addressCheckingResultWithRange:components:");
final _objc_msgSend_515 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_linkCheckingResultWithRange_URL_ =
    objc.registerName("linkCheckingResultWithRange:URL:");
final _objc_msgSend_516 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_quoteCheckingResultWithRange_replacementString_ =
    objc.registerName("quoteCheckingResultWithRange:replacementString:");
final _objc_msgSend_517 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_dashCheckingResultWithRange_replacementString_ =
    objc.registerName("dashCheckingResultWithRange:replacementString:");
late final _sel_replacementCheckingResultWithRange_replacementString_ =
    objc.registerName("replacementCheckingResultWithRange:replacementString:");
late final _sel_correctionCheckingResultWithRange_replacementString_ =
    objc.registerName("correctionCheckingResultWithRange:replacementString:");
late final _sel_correctionCheckingResultWithRange_replacementString_alternativeStrings_ =
    objc.registerName(
        "correctionCheckingResultWithRange:replacementString:alternativeStrings:");
final _objc_msgSend_518 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                _NSRange,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            _NSRange,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_regularExpressionCheckingResultWithRanges_count_regularExpression_ =
    objc.registerName(
        "regularExpressionCheckingResultWithRanges:count:regularExpression:");
final _objc_msgSend_519 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<_NSRange>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<_NSRange>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_phoneNumberCheckingResultWithRange_phoneNumber_ =
    objc.registerName("phoneNumberCheckingResultWithRange:phoneNumber:");
late final _sel_transitInformationCheckingResultWithRange_components_ =
    objc.registerName("transitInformationCheckingResultWithRange:components:");

class NSURLCache extends objc.NSObject {
  NSURLCache._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLCache] that points to the same underlying object as [other].
  NSURLCache.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLCache] that wraps the given raw object pointer.
  NSURLCache.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLCache].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(obj.pointer, _sel_isKindOfClass_, _class_NSURLCache);
  }

  static NSURLCache getSharedURLCache() {
    final _ret = _objc_msgSend_520(_class_NSURLCache, _sel_sharedURLCache);
    return NSURLCache.castFromPointer(_ret, retain: true, release: true);
  }

  static void setSharedURLCache(NSURLCache value) {
    return _objc_msgSend_521(
        _class_NSURLCache, _sel_setSharedURLCache_, value.pointer);
  }

  NSURLCache initWithMemoryCapacity_diskCapacity_diskPath_(
      int memoryCapacity, int diskCapacity, objc.NSString? path) {
    final _ret = _objc_msgSend_522(
        this.pointer,
        _sel_initWithMemoryCapacity_diskCapacity_diskPath_,
        memoryCapacity,
        diskCapacity,
        path?.pointer ?? ffi.nullptr);
    return NSURLCache.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLCache initWithMemoryCapacity_diskCapacity_directoryURL_(
      int memoryCapacity, int diskCapacity, objc.NSURL? directoryURL) {
    final _ret = _objc_msgSend_523(
        this.pointer,
        _sel_initWithMemoryCapacity_diskCapacity_directoryURL_,
        memoryCapacity,
        diskCapacity,
        directoryURL?.pointer ?? ffi.nullptr);
    return NSURLCache.castFromPointer(_ret, retain: true, release: true);
  }

  NSCachedURLResponse? cachedResponseForRequest_(NSURLRequest request) {
    final _ret = _objc_msgSend_528(
        this.pointer, _sel_cachedResponseForRequest_, request.pointer);
    return _ret.address == 0
        ? null
        : NSCachedURLResponse.castFromPointer(_ret,
            retain: true, release: true);
  }

  void storeCachedResponse_forRequest_(
      NSCachedURLResponse cachedResponse, NSURLRequest request) {
    _objc_msgSend_529(this.pointer, _sel_storeCachedResponse_forRequest_,
        cachedResponse.pointer, request.pointer);
  }

  void removeCachedResponseForRequest_(NSURLRequest request) {
    _objc_msgSend_530(
        this.pointer, _sel_removeCachedResponseForRequest_, request.pointer);
  }

  void removeAllCachedResponses() {
    _objc_msgSend_82(this.pointer, _sel_removeAllCachedResponses);
  }

  void removeCachedResponsesSinceDate_(objc.NSDate date) {
    _objc_msgSend_246(
        this.pointer, _sel_removeCachedResponsesSinceDate_, date.pointer);
  }

  int get memoryCapacity {
    return _objc_msgSend_29(this.pointer, _sel_memoryCapacity);
  }

  set memoryCapacity(int value) {
    return _objc_msgSend_125(this.pointer, _sel_setMemoryCapacity_, value);
  }

  int get diskCapacity {
    return _objc_msgSend_29(this.pointer, _sel_diskCapacity);
  }

  set diskCapacity(int value) {
    return _objc_msgSend_125(this.pointer, _sel_setDiskCapacity_, value);
  }

  int get currentMemoryUsage {
    return _objc_msgSend_29(this.pointer, _sel_currentMemoryUsage);
  }

  int get currentDiskUsage {
    return _objc_msgSend_29(this.pointer, _sel_currentDiskUsage);
  }

  void storeCachedResponse_forDataTask_(
      NSCachedURLResponse cachedResponse, NSURLSessionDataTask dataTask) {
    _objc_msgSend_531(this.pointer, _sel_storeCachedResponse_forDataTask_,
        cachedResponse.pointer, dataTask.pointer);
  }

  void getCachedResponseForDataTask_completionHandler_(
      NSURLSessionDataTask dataTask,
      ObjCBlock_ffiVoid_NSCachedURLResponse completionHandler) {
    _objc_msgSend_532(
        this.pointer,
        _sel_getCachedResponseForDataTask_completionHandler_,
        dataTask.pointer,
        completionHandler.pointer);
  }

  void removeCachedResponseForDataTask_(NSURLSessionDataTask dataTask) {
    _objc_msgSend_533(
        this.pointer, _sel_removeCachedResponseForDataTask_, dataTask.pointer);
  }

  @override
  NSURLCache init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLCache.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLCache new1() {
    final _ret = _objc_msgSend_40(_class_NSURLCache, _sel_new);
    return NSURLCache.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLCache allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(_class_NSURLCache, _sel_allocWithZone_, zone);
    return NSURLCache.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLCache alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLCache, _sel_alloc);
    return NSURLCache.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLCache,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLCache,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSURLCache, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSURLCache, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSURLCache,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSURLCache,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSURLCache,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret =
        _objc_msgSend_6(_class_NSURLCache, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSURLCache, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSURLCache = objc.getClass("NSURLCache");
late final _sel_sharedURLCache = objc.registerName("sharedURLCache");
final _objc_msgSend_520 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setSharedURLCache_ = objc.registerName("setSharedURLCache:");
final _objc_msgSend_521 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithMemoryCapacity_diskCapacity_diskPath_ =
    objc.registerName("initWithMemoryCapacity:diskCapacity:diskPath:");
final _objc_msgSend_522 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithMemoryCapacity_diskCapacity_directoryURL_ =
    objc.registerName("initWithMemoryCapacity:diskCapacity:directoryURL:");
final _objc_msgSend_523 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            int,
            ffi.Pointer<objc.ObjCObject>)>();

class NSCachedURLResponse extends objc.NSObject {
  NSCachedURLResponse._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSCachedURLResponse] that points to the same underlying object as [other].
  NSCachedURLResponse.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSCachedURLResponse] that wraps the given raw object pointer.
  NSCachedURLResponse.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSCachedURLResponse].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSCachedURLResponse);
  }

  NSCachedURLResponse initWithResponse_data_(
      NSURLResponse response, objc.NSData data) {
    final _ret = _objc_msgSend_524(this.pointer, _sel_initWithResponse_data_,
        response.pointer, data.pointer);
    return NSCachedURLResponse.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSCachedURLResponse initWithResponse_data_userInfo_storagePolicy_(
      NSURLResponse response,
      objc.NSData data,
      objc.NSDictionary? userInfo,
      int storagePolicy) {
    final _ret = _objc_msgSend_525(
        this.pointer,
        _sel_initWithResponse_data_userInfo_storagePolicy_,
        response.pointer,
        data.pointer,
        userInfo?.pointer ?? ffi.nullptr,
        storagePolicy);
    return NSCachedURLResponse.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSURLResponse get response {
    final _ret = _objc_msgSend_526(this.pointer, _sel_response);
    return NSURLResponse.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSData get data {
    final _ret = _objc_msgSend_104(this.pointer, _sel_data);
    return objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary? get userInfo {
    final _ret = _objc_msgSend_65(this.pointer, _sel_userInfo);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  int get storagePolicy {
    return _objc_msgSend_527(this.pointer, _sel_storagePolicy);
  }

  @override
  NSCachedURLResponse init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSCachedURLResponse.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSCachedURLResponse new1() {
    final _ret = _objc_msgSend_40(_class_NSCachedURLResponse, _sel_new);
    return NSCachedURLResponse.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSCachedURLResponse allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSCachedURLResponse, _sel_allocWithZone_, zone);
    return NSCachedURLResponse.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSCachedURLResponse alloc() {
    final _ret = _objc_msgSend_40(_class_NSCachedURLResponse, _sel_alloc);
    return NSCachedURLResponse.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSCachedURLResponse,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSCachedURLResponse,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSCachedURLResponse, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSCachedURLResponse, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSCachedURLResponse,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSCachedURLResponse,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSCachedURLResponse,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSCachedURLResponse, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSCachedURLResponse, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSCachedURLResponse = objc.getClass("NSCachedURLResponse");
late final _sel_initWithResponse_data_ =
    objc.registerName("initWithResponse:data:");
final _objc_msgSend_524 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();

abstract class NSURLCacheStoragePolicy {
  static const int NSURLCacheStorageAllowed = 0;
  static const int NSURLCacheStorageAllowedInMemoryOnly = 1;
  static const int NSURLCacheStorageNotAllowed = 2;
}

late final _sel_initWithResponse_data_userInfo_storagePolicy_ =
    objc.registerName("initWithResponse:data:userInfo:storagePolicy:");
final _objc_msgSend_525 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_526 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_storagePolicy = objc.registerName("storagePolicy");
final _objc_msgSend_527 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_cachedResponseForRequest_ =
    objc.registerName("cachedResponseForRequest:");
final _objc_msgSend_528 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_storeCachedResponse_forRequest_ =
    objc.registerName("storeCachedResponse:forRequest:");
final _objc_msgSend_529 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removeCachedResponseForRequest_ =
    objc.registerName("removeCachedResponseForRequest:");
final _objc_msgSend_530 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_removeAllCachedResponses =
    objc.registerName("removeAllCachedResponses");
late final _sel_removeCachedResponsesSinceDate_ =
    objc.registerName("removeCachedResponsesSinceDate:");
late final _sel_memoryCapacity = objc.registerName("memoryCapacity");
late final _sel_setMemoryCapacity_ = objc.registerName("setMemoryCapacity:");
late final _sel_diskCapacity = objc.registerName("diskCapacity");
late final _sel_setDiskCapacity_ = objc.registerName("setDiskCapacity:");
late final _sel_currentMemoryUsage = objc.registerName("currentMemoryUsage");
late final _sel_currentDiskUsage = objc.registerName("currentDiskUsage");

class NSURLSessionDataTask extends NSURLSessionTask {
  NSURLSessionDataTask._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLSessionDataTask] that points to the same underlying object as [other].
  NSURLSessionDataTask.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLSessionDataTask] that wraps the given raw object pointer.
  NSURLSessionDataTask.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLSessionDataTask].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSURLSessionDataTask);
  }

  @override
  NSURLSessionDataTask init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLSessionDataTask.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSURLSessionDataTask new1() {
    final _ret = _objc_msgSend_40(_class_NSURLSessionDataTask, _sel_new);
    return NSURLSessionDataTask.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSURLSessionDataTask allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(
        _class_NSURLSessionDataTask, _sel_allocWithZone_, zone);
    return NSURLSessionDataTask.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSURLSessionDataTask alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLSessionDataTask, _sel_alloc);
    return NSURLSessionDataTask.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLSessionDataTask,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLSessionDataTask,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSURLSessionDataTask, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSURLSessionDataTask, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSURLSessionDataTask,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSURLSessionDataTask,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSURLSessionDataTask,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSURLSessionDataTask, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSURLSessionDataTask, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSURLSessionDataTask = objc.getClass("NSURLSessionDataTask");
late final _sel_storeCachedResponse_forDataTask_ =
    objc.registerName("storeCachedResponse:forDataTask:");
final _objc_msgSend_531 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
void _ObjCBlock_ffiVoid_NSCachedURLResponse_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>()
        .asFunction<void Function(ffi.Pointer<objc.ObjCObject>)>()(arg0);
final _ObjCBlock_ffiVoid_NSCachedURLResponse_closureRegistry =
    <int, void Function(ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_ffiVoid_NSCachedURLResponse_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_NSCachedURLResponse_registerClosure(
    void Function(ffi.Pointer<objc.ObjCObject>) fn) {
  final id = ++_ObjCBlock_ffiVoid_NSCachedURLResponse_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSCachedURLResponse_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSCachedURLResponse_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block, ffi.Pointer<objc.ObjCObject> arg0) =>
    _ObjCBlock_ffiVoid_NSCachedURLResponse_closureRegistry[
        block.ref.target.address]!(arg0);

class ObjCBlock_ffiVoid_NSCachedURLResponse extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSCachedURLResponse._(ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false, bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSCachedURLResponse castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSCachedURLResponse._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSCachedURLResponse.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSCachedURLResponse_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSCachedURLResponse.fromFunction(
      void Function(NSCachedURLResponse?) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSCachedURLResponse_closureTrampoline)
                .cast(),
            _ObjCBlock_ffiVoid_NSCachedURLResponse_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(arg0.address == 0
                    ? null
                    : NSCachedURLResponse.castFromPointer(arg0, retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSCachedURLResponse.listener(void Function(NSCachedURLResponse?) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??= ffi.NativeCallable<
                        ffi.Void Function(ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>)>.listener(
                    _ObjCBlock_ffiVoid_NSCachedURLResponse_closureTrampoline)
                  ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSCachedURLResponse_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0) => fn(arg0.address == 0
                    ? null
                    : NSCachedURLResponse.castFromPointer(arg0, retain: true, release: true)))));
  static ffi.NativeCallable<
          ffi.Void Function(
              ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>?
      _dartFuncListenerTrampoline;

  void call(NSCachedURLResponse? arg0) => pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<objc.ObjCBlock> block,
                      ffi.Pointer<objc.ObjCObject> arg0)>>()
          .asFunction<
              void Function(
                  ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>)>()(
      pointer, arg0?.pointer ?? ffi.nullptr);
}

late final _sel_getCachedResponseForDataTask_completionHandler_ =
    objc.registerName("getCachedResponseForDataTask:completionHandler:");
final _objc_msgSend_532 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCBlock>)>();
late final _sel_removeCachedResponseForDataTask_ =
    objc.registerName("removeCachedResponseForDataTask:");
final _objc_msgSend_533 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();

class NSURLConnection extends objc.NSObject {
  NSURLConnection._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLConnection] that points to the same underlying object as [other].
  NSURLConnection.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLConnection] that wraps the given raw object pointer.
  NSURLConnection.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLConnection].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSURLConnection);
  }

  NSURLConnection? initWithRequest_delegate_startImmediately_(
      NSURLRequest request, objc.NSObject? delegate, bool startImmediately) {
    final _ret = _objc_msgSend_534(
        this.pointer,
        _sel_initWithRequest_delegate_startImmediately_,
        request.pointer,
        delegate?.pointer ?? ffi.nullptr,
        startImmediately);
    return _ret.address == 0
        ? null
        : NSURLConnection.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLConnection? initWithRequest_delegate_(
      NSURLRequest request, objc.NSObject? delegate) {
    final _ret = _objc_msgSend_535(this.pointer, _sel_initWithRequest_delegate_,
        request.pointer, delegate?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSURLConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLConnection? connectionWithRequest_delegate_(
      NSURLRequest request, objc.NSObject? delegate) {
    final _ret = _objc_msgSend_536(
        _class_NSURLConnection,
        _sel_connectionWithRequest_delegate_,
        request.pointer,
        delegate?.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSURLConnection.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLRequest get originalRequest {
    final _ret = _objc_msgSend_537(this.pointer, _sel_originalRequest);
    return NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLRequest get currentRequest {
    final _ret = _objc_msgSend_537(this.pointer, _sel_currentRequest);
    return NSURLRequest.castFromPointer(_ret, retain: true, release: true);
  }

  void start() {
    _objc_msgSend_82(this.pointer, _sel_start);
  }

  void cancel() {
    _objc_msgSend_82(this.pointer, _sel_cancel);
  }

  void scheduleInRunLoop_forMode_(NSRunLoop aRunLoop, objc.NSString mode) {
    _objc_msgSend_216(this.pointer, _sel_scheduleInRunLoop_forMode_,
        aRunLoop.pointer, mode.pointer);
  }

  void unscheduleFromRunLoop_forMode_(NSRunLoop aRunLoop, objc.NSString mode) {
    _objc_msgSend_216(this.pointer, _sel_unscheduleFromRunLoop_forMode_,
        aRunLoop.pointer, mode.pointer);
  }

  void setDelegateQueue_(NSOperationQueue? queue) {
    _objc_msgSend_538(
        this.pointer, _sel_setDelegateQueue_, queue?.pointer ?? ffi.nullptr);
  }

  static bool canHandleRequest_(NSURLRequest request) {
    return _objc_msgSend_539(
        _class_NSURLConnection, _sel_canHandleRequest_, request.pointer);
  }

  static objc.NSData? sendSynchronousRequest_returningResponse_error_(
      NSURLRequest request,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> response,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_540(
        _class_NSURLConnection,
        _sel_sendSynchronousRequest_returningResponse_error_,
        request.pointer,
        response,
        error);
    return _ret.address == 0
        ? null
        : objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  static void sendAsynchronousRequest_queue_completionHandler_(
      NSURLRequest request,
      NSOperationQueue queue,
      ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError handler) {
    _objc_msgSend_541(
        _class_NSURLConnection,
        _sel_sendAsynchronousRequest_queue_completionHandler_,
        request.pointer,
        queue.pointer,
        handler.pointer);
  }

  @override
  NSURLConnection init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLConnection.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLConnection new1() {
    final _ret = _objc_msgSend_40(_class_NSURLConnection, _sel_new);
    return NSURLConnection.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLConnection allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSURLConnection, _sel_allocWithZone_, zone);
    return NSURLConnection.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLConnection alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLConnection, _sel_alloc);
    return NSURLConnection.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLConnection,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLConnection,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSURLConnection, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSURLConnection, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSURLConnection,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSURLConnection,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSURLConnection,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSURLConnection, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSURLConnection, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSURLConnection = objc.getClass("NSURLConnection");
late final _sel_initWithRequest_delegate_startImmediately_ =
    objc.registerName("initWithRequest:delegate:startImmediately:");
final _objc_msgSend_534 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
late final _sel_initWithRequest_delegate_ =
    objc.registerName("initWithRequest:delegate:");
final _objc_msgSend_535 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_connectionWithRequest_delegate_ =
    objc.registerName("connectionWithRequest:delegate:");
final _objc_msgSend_536 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_537 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_unscheduleFromRunLoop_forMode_ =
    objc.registerName("unscheduleFromRunLoop:forMode:");
late final _sel_setDelegateQueue_ = objc.registerName("setDelegateQueue:");
final _objc_msgSend_538 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_canHandleRequest_ = objc.registerName("canHandleRequest:");
final _objc_msgSend_539 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_sendSynchronousRequest_returningResponse_error_ =
    objc.registerName("sendSynchronousRequest:returningResponse:error:");
final _objc_msgSend_540 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
void _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1,
        ffi.Pointer<objc.ObjCObject> arg2) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1,
                    ffi.Pointer<objc.ObjCObject> arg2)>>()
        .asFunction<
            void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1, arg2);
final _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_closureRegistry = <int,
    void Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<objc.ObjCObject>)>{};
int _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_closureRegistryIndex = 0;
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_registerClosure(
        void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)
            fn) {
  final id =
      ++_ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_closureRegistryIndex;
  _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_closureRegistry[id] = fn;
  return ffi.Pointer<ffi.Void>.fromAddress(id);
}

void _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_closureTrampoline(
        ffi.Pointer<objc.ObjCBlock> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1,
        ffi.Pointer<objc.ObjCObject> arg2) =>
    _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_closureRegistry[
        block.ref.target.address]!(arg0, arg1, arg2);

class ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError
    extends objc.ObjCBlockBase {
  ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError._(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = true})
      : super(pointer, retain: retain, release: release);

  /// Returns a block that wraps the given raw block pointer.
  static ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError castFromPointer(
      ffi.Pointer<objc.ObjCBlock> pointer,
      {bool retain = false,
      bool release = false}) {
    return ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError._(pointer,
        retain: retain, release: release);
  }

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError.fromFunctionPointer(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1,
                      ffi.Pointer<objc.ObjCObject> arg2)>>
          ptr)
      : this._(objc.newBlock(
            _cFuncTrampoline ??= ffi.Pointer.fromFunction<
                        ffi.Void Function(
                            ffi.Pointer<objc.ObjCBlock>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>)>(
                    _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_fnPtrTrampoline)
                .cast(),
            ptr.cast()));
  static ffi.Pointer<ffi.Void>? _cFuncTrampoline;

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError.fromFunction(
      void Function(NSURLResponse?, objc.NSData?, objc.NSError?) fn)
      : this._(objc.newBlock(
            _dartFuncTrampoline ??=
                ffi.Pointer.fromFunction<ffi.Void Function(ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>(
                        _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_closureTrampoline)
                    .cast(),
            _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0,
                        ffi.Pointer<objc.ObjCObject> arg1,
                        ffi.Pointer<objc.ObjCObject> arg2) =>
                    fn(
                        arg0.address == 0 ? null : NSURLResponse.castFromPointer(arg0, retain: true, release: true),
                        arg1.address == 0 ? null : objc.NSData.castFromPointer(arg1, retain: true, release: true),
                        arg2.address == 0 ? null : objc.NSError.castFromPointer(arg2, retain: true, release: true)))));
  static ffi.Pointer<ffi.Void>? _dartFuncTrampoline;

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// Note that unlike the default behavior of NativeCallable.listener, listener
  /// blocks do not keep the isolate alive.
  ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError.listener(
      void Function(NSURLResponse?, objc.NSData?, objc.NSError?) fn)
      : this._(objc.newBlock(
            (_dartFuncListenerTrampoline ??=
                    ffi.NativeCallable<ffi.Void Function(ffi.Pointer<objc.ObjCBlock>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>.listener(
                        _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_closureTrampoline)
                      ..keepIsolateAlive = false)
                .nativeFunction
                .cast(),
            _ObjCBlock_ffiVoid_NSURLResponse_NSData_NSError_registerClosure(
                (ffi.Pointer<objc.ObjCObject> arg0,
                        ffi.Pointer<objc.ObjCObject> arg1,
                        ffi.Pointer<objc.ObjCObject> arg2) =>
                    fn(
                        arg0.address == 0
                            ? null
                            : NSURLResponse.castFromPointer(arg0, retain: true, release: true),
                        arg1.address == 0 ? null : objc.NSData.castFromPointer(arg1, retain: true, release: true),
                        arg2.address == 0 ? null : objc.NSError.castFromPointer(arg2, retain: true, release: true)))));
  static ffi.NativeCallable<
      ffi.Void Function(
          ffi.Pointer<objc.ObjCBlock>,
          ffi.Pointer<objc.ObjCObject>,
          ffi.Pointer<objc.ObjCObject>,
          ffi.Pointer<objc.ObjCObject>)>? _dartFuncListenerTrampoline;

  void call(NSURLResponse? arg0, objc.NSData? arg1, objc.NSError? arg2) =>
      pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<objc.ObjCBlock> block,
                          ffi.Pointer<objc.ObjCObject> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1,
                          ffi.Pointer<objc.ObjCObject> arg2)>>()
              .asFunction<
                  void Function(
                      ffi.Pointer<objc.ObjCBlock>,
                      ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>)>()(
          pointer,
          arg0?.pointer ?? ffi.nullptr,
          arg1?.pointer ?? ffi.nullptr,
          arg2?.pointer ?? ffi.nullptr);
}

late final _sel_sendAsynchronousRequest_queue_completionHandler_ =
    objc.registerName("sendAsynchronousRequest:queue:completionHandler:");
final _objc_msgSend_541 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCBlock>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCBlock>)>();

class NSURLCredential extends objc.NSObject {
  NSURLCredential._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLCredential] that points to the same underlying object as [other].
  NSURLCredential.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLCredential] that wraps the given raw object pointer.
  NSURLCredential.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLCredential].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSURLCredential);
  }

  int get persistence {
    return _objc_msgSend_542(this.pointer, _sel_persistence);
  }

  NSURLCredential initWithUser_password_persistence_(
      objc.NSString user, objc.NSString password, int persistence) {
    final _ret = _objc_msgSend_543(
        this.pointer,
        _sel_initWithUser_password_persistence_,
        user.pointer,
        password.pointer,
        persistence);
    return NSURLCredential.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLCredential credentialWithUser_password_persistence_(
      objc.NSString user, objc.NSString password, int persistence) {
    final _ret = _objc_msgSend_544(
        _class_NSURLCredential,
        _sel_credentialWithUser_password_persistence_,
        user.pointer,
        password.pointer,
        persistence);
    return NSURLCredential.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get user {
    final _ret = _objc_msgSend_13(this.pointer, _sel_user);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get password {
    final _ret = _objc_msgSend_13(this.pointer, _sel_password);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool get hasPassword {
    return _objc_msgSend_7(this.pointer, _sel_hasPassword);
  }

  NSURLCredential initWithIdentity_certificates_persistence_(
      ffi.Pointer<__SecIdentity> identity,
      objc.NSArray? certArray,
      int persistence) {
    final _ret = _objc_msgSend_545(
        this.pointer,
        _sel_initWithIdentity_certificates_persistence_,
        identity,
        certArray?.pointer ?? ffi.nullptr,
        persistence);
    return NSURLCredential.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLCredential credentialWithIdentity_certificates_persistence_(
      ffi.Pointer<__SecIdentity> identity,
      objc.NSArray? certArray,
      int persistence) {
    final _ret = _objc_msgSend_546(
        _class_NSURLCredential,
        _sel_credentialWithIdentity_certificates_persistence_,
        identity,
        certArray?.pointer ?? ffi.nullptr,
        persistence);
    return NSURLCredential.castFromPointer(_ret, retain: true, release: true);
  }

  ffi.Pointer<__SecIdentity> get identity {
    return _objc_msgSend_547(this.pointer, _sel_identity);
  }

  objc.NSArray get certificates {
    final _ret = _objc_msgSend_6(this.pointer, _sel_certificates);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  NSURLCredential initWithTrust_(ffi.Pointer<__SecTrust> trust) {
    final _ret = _objc_msgSend_548(this.pointer, _sel_initWithTrust_, trust);
    return NSURLCredential.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLCredential credentialForTrust_(ffi.Pointer<__SecTrust> trust) {
    final _ret = _objc_msgSend_549(
        _class_NSURLCredential, _sel_credentialForTrust_, trust);
    return NSURLCredential.castFromPointer(_ret, retain: true, release: true);
  }

  @override
  NSURLCredential init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLCredential.castFromPointer(_ret, retain: true, release: true);
  }

  static NSURLCredential new1() {
    final _ret = _objc_msgSend_40(_class_NSURLCredential, _sel_new);
    return NSURLCredential.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLCredential allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_47(_class_NSURLCredential, _sel_allocWithZone_, zone);
    return NSURLCredential.castFromPointer(_ret, retain: false, release: true);
  }

  static NSURLCredential alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLCredential, _sel_alloc);
    return NSURLCredential.castFromPointer(_ret, retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLCredential,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLCredential,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSURLCredential, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSURLCredential, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSURLCredential,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSURLCredential,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSURLCredential,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSURLCredential, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret =
        _objc_msgSend_40(_class_NSURLCredential, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSURLCredential = objc.getClass("NSURLCredential");

abstract class NSURLCredentialPersistence {
  static const int NSURLCredentialPersistenceNone = 0;
  static const int NSURLCredentialPersistenceForSession = 1;
  static const int NSURLCredentialPersistencePermanent = 2;
  static const int NSURLCredentialPersistenceSynchronizable = 3;
}

late final _sel_persistence = objc.registerName("persistence");
final _objc_msgSend_542 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int32 Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_initWithUser_password_persistence_ =
    objc.registerName("initWithUser:password:persistence:");
final _objc_msgSend_543 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_credentialWithUser_password_persistence_ =
    objc.registerName("credentialWithUser:password:persistence:");
final _objc_msgSend_544 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_user = objc.registerName("user");
late final _sel_password = objc.registerName("password");
late final _sel_hasPassword = objc.registerName("hasPassword");

final class __SecIdentity extends ffi.Opaque {}

late final _sel_initWithIdentity_certificates_persistence_ =
    objc.registerName("initWithIdentity:certificates:persistence:");
final _objc_msgSend_545 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<__SecIdentity>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<__SecIdentity>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_credentialWithIdentity_certificates_persistence_ =
    objc.registerName("credentialWithIdentity:certificates:persistence:");
final _objc_msgSend_546 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<__SecIdentity>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int32)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<__SecIdentity>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
late final _sel_identity = objc.registerName("identity");
final _objc_msgSend_547 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<__SecIdentity> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<__SecIdentity> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_certificates = objc.registerName("certificates");

final class __SecTrust extends ffi.Opaque {}

late final _sel_initWithTrust_ = objc.registerName("initWithTrust:");
final _objc_msgSend_548 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<__SecTrust>)>>()
    .asFunction<
        instancetype Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<__SecTrust>)>();
late final _sel_credentialForTrust_ = objc.registerName("credentialForTrust:");
final _objc_msgSend_549 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<__SecTrust>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<__SecTrust>)>();

class NSURLProtectionSpace extends objc.NSObject {
  NSURLProtectionSpace._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLProtectionSpace] that points to the same underlying object as [other].
  NSURLProtectionSpace.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLProtectionSpace] that wraps the given raw object pointer.
  NSURLProtectionSpace.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLProtectionSpace].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSURLProtectionSpace);
  }

  NSURLProtectionSpace initWithHost_port_protocol_realm_authenticationMethod_(
      objc.NSString host,
      int port,
      objc.NSString? protocol,
      objc.NSString? realm,
      objc.NSString? authenticationMethod) {
    final _ret = _objc_msgSend_550(
        this.pointer,
        _sel_initWithHost_port_protocol_realm_authenticationMethod_,
        host.pointer,
        port,
        protocol?.pointer ?? ffi.nullptr,
        realm?.pointer ?? ffi.nullptr,
        authenticationMethod?.pointer ?? ffi.nullptr);
    return NSURLProtectionSpace.castFromPointer(_ret,
        retain: true, release: true);
  }

  NSURLProtectionSpace initWithProxyHost_port_type_realm_authenticationMethod_(
      objc.NSString host,
      int port,
      objc.NSString? type,
      objc.NSString? realm,
      objc.NSString? authenticationMethod) {
    final _ret = _objc_msgSend_550(
        this.pointer,
        _sel_initWithProxyHost_port_type_realm_authenticationMethod_,
        host.pointer,
        port,
        type?.pointer ?? ffi.nullptr,
        realm?.pointer ?? ffi.nullptr,
        authenticationMethod?.pointer ?? ffi.nullptr);
    return NSURLProtectionSpace.castFromPointer(_ret,
        retain: true, release: true);
  }

  objc.NSString? get realm {
    final _ret = _objc_msgSend_13(this.pointer, _sel_realm);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  bool get receivesCredentialSecurely {
    return _objc_msgSend_7(this.pointer, _sel_receivesCredentialSecurely);
  }

  bool get isProxy {
    return _objc_msgSend_7(this.pointer, _sel_isProxy);
  }

  objc.NSString get host {
    final _ret = _objc_msgSend_12(this.pointer, _sel_host);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  int get port {
    return _objc_msgSend_114(this.pointer, _sel_port);
  }

  objc.NSString? get proxyType {
    final _ret = _objc_msgSend_13(this.pointer, _sel_proxyType);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString? get protocol {
    final _ret = _objc_msgSend_13(this.pointer, _sel_protocol);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSString get authenticationMethod {
    final _ret = _objc_msgSend_12(this.pointer, _sel_authenticationMethod);
    return objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSArray? get distinguishedNames {
    final _ret = _objc_msgSend_69(this.pointer, _sel_distinguishedNames);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  ffi.Pointer<__SecTrust> get serverTrust {
    return _objc_msgSend_551(this.pointer, _sel_serverTrust);
  }

  @override
  NSURLProtectionSpace init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLProtectionSpace.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSURLProtectionSpace new1() {
    final _ret = _objc_msgSend_40(_class_NSURLProtectionSpace, _sel_new);
    return NSURLProtectionSpace.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSURLProtectionSpace allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(
        _class_NSURLProtectionSpace, _sel_allocWithZone_, zone);
    return NSURLProtectionSpace.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSURLProtectionSpace alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLProtectionSpace, _sel_alloc);
    return NSURLProtectionSpace.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLProtectionSpace,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLProtectionSpace,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_msgSend_7(
        _class_NSURLProtectionSpace, _sel_accessInstanceVariablesDirectly);
  }

  static bool useStoredAccessor() {
    return _objc_msgSend_7(_class_NSURLProtectionSpace, _sel_useStoredAccessor);
  }

  static objc.NSSet keyPathsForValuesAffectingValueForKey_(objc.NSString key) {
    final _ret = _objc_msgSend_50(_class_NSURLProtectionSpace,
        _sel_keyPathsForValuesAffectingValueForKey_, key.pointer);
    return objc.NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  static bool automaticallyNotifiesObserversForKey_(objc.NSString key) {
    return _objc_msgSend_51(_class_NSURLProtectionSpace,
        _sel_automaticallyNotifiesObserversForKey_, key.pointer);
  }

  static void setKeys_triggerChangeNotificationsForDependentKey_(
      objc.NSArray keys, objc.NSString dependentKey) {
    _objc_msgSend_52(
        _class_NSURLProtectionSpace,
        _sel_setKeys_triggerChangeNotificationsForDependentKey_,
        keys.pointer,
        dependentKey.pointer);
  }

  static objc.NSArray classFallbacksForKeyedArchiver() {
    final _ret = _objc_msgSend_6(
        _class_NSURLProtectionSpace, _sel_classFallbacksForKeyedArchiver);
    return objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  static objc.NSObject classForKeyedUnarchiver() {
    final _ret = _objc_msgSend_40(
        _class_NSURLProtectionSpace, _sel_classForKeyedUnarchiver);
    return objc.NSObject.castFromPointer(_ret, retain: true, release: true);
  }
}

late final _class_NSURLProtectionSpace = objc.getClass("NSURLProtectionSpace");
late final _sel_initWithHost_port_protocol_realm_authenticationMethod_ =
    objc.registerName("initWithHost:port:protocol:realm:authenticationMethod:");
final _objc_msgSend_550 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            instancetype Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        instancetype Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
late final _sel_initWithProxyHost_port_type_realm_authenticationMethod_ = objc
    .registerName("initWithProxyHost:port:type:realm:authenticationMethod:");
late final _sel_realm = objc.registerName("realm");
late final _sel_receivesCredentialSecurely =
    objc.registerName("receivesCredentialSecurely");
late final _sel_isProxy = objc.registerName("isProxy");
late final _sel_host = objc.registerName("host");
late final _sel_proxyType = objc.registerName("proxyType");
late final _sel_protocol = objc.registerName("protocol");
late final _sel_authenticationMethod =
    objc.registerName("authenticationMethod");
late final _sel_distinguishedNames = objc.registerName("distinguishedNames");
late final _sel_serverTrust = objc.registerName("serverTrust");
final _objc_msgSend_551 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<__SecTrust> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<__SecTrust> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();

class NSURLCredentialStorage extends objc.NSObject {
  NSURLCredentialStorage._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLCredentialStorage] that points to the same underlying object as [other].
  NSURLCredentialStorage.castFrom(objc.ObjCObjectBase other)
      : this._(other.pointer, retain: true, release: true);

  /// Constructs a [NSURLCredentialStorage] that wraps the given raw object pointer.
  NSURLCredentialStorage.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLCredentialStorage].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_0(
        obj.pointer, _sel_isKindOfClass_, _class_NSURLCredentialStorage);
  }

  static NSURLCredentialStorage getSharedCredentialStorage() {
    final _ret = _objc_msgSend_552(
        _class_NSURLCredentialStorage, _sel_sharedCredentialStorage);
    return NSURLCredentialStorage.castFromPointer(_ret,
        retain: true, release: true);
  }

  objc.NSDictionary? credentialsForProtectionSpace_(
      NSURLProtectionSpace space) {
    final _ret = _objc_msgSend_553(
        this.pointer, _sel_credentialsForProtectionSpace_, space.pointer);
    return _ret.address == 0
        ? null
        : objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  objc.NSDictionary get allCredentials {
    final _ret = _objc_msgSend_112(this.pointer, _sel_allCredentials);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  void setCredential_forProtectionSpace_(
      NSURLCredential credential, NSURLProtectionSpace space) {
    _objc_msgSend_554(this.pointer, _sel_setCredential_forProtectionSpace_,
        credential.pointer, space.pointer);
  }

  void removeCredential_forProtectionSpace_(
      NSURLCredential credential, NSURLProtectionSpace space) {
    _objc_msgSend_554(this.pointer, _sel_removeCredential_forProtectionSpace_,
        credential.pointer, space.pointer);
  }

  void removeCredential_forProtectionSpace_options_(NSURLCredential credential,
      NSURLProtectionSpace space, objc.NSDictionary? options) {
    _objc_msgSend_555(
        this.pointer,
        _sel_removeCredential_forProtectionSpace_options_,
        credential.pointer,
        space.pointer,
        options?.pointer ?? ffi.nullptr);
  }

  NSURLCredential? defaultCredentialForProtectionSpace_(
      NSURLProtectionSpace space) {
    final _ret = _objc_msgSend_556(
        this.pointer, _sel_defaultCredentialForProtectionSpace_, space.pointer);
    return _ret.address == 0
        ? null
        : NSURLCredential.castFromPointer(_ret, retain: true, release: true);
  }

  void setDefaultCredential_forProtectionSpace_(
      NSURLCredential credential, NSURLProtectionSpace space) {
    _objc_msgSend_554(
        this.pointer,
        _sel_setDefaultCredential_forProtectionSpace_,
        credential.pointer,
        space.pointer);
  }

  void getCredentialsForProtectionSpace_task_completionHandler_(
      NSURLProtectionSpace protectionSpace,
      NSURLSessionTask task,
      ObjCBlock_ffiVoid_NSDictionary completionHandler) {
    _objc_msgSend_557(
        this.pointer,
        _sel_getCredentialsForProtectionSpace_task_completionHandler_,
        protectionSpace.pointer,
        task.pointer,
        completionHandler.pointer);
  }

  void setCredential_forProtectionSpace_task_(NSURLCredential credential,
      NSURLProtectionSpace protectionSpace, NSURLSessionTask task) {
    _objc_msgSend_558(this.pointer, _sel_setCredential_forProtectionSpace_task_,
        credential.pointer, protectionSpace.pointer, task.pointer);
  }

  void removeCredential_forProtectionSpace_options_task_(
      NSURLCredential credential,
      NSURLProtectionSpace protectionSpace,
      objc.NSDictionary? options,
      NSURLSessionTask task) {
    _objc_msgSend_559(
        this.pointer,
        _sel_removeCredential_forProtectionSpace_options_task_,
        credential.pointer,
        protectionSpace.pointer,
        options?.pointer ?? ffi.nullptr,
        task.pointer);
  }

  void getDefaultCredentialForProtectionSpace_task_completionHandler_(
      NSURLProtectionSpace space,
      NSURLSessionTask task,
      ObjCBlock_ffiVoid_NSURLCredential completionHandler) {
    _objc_msgSend_560(
        this.pointer,
        _sel_getDefaultCredentialForProtectionSpace_task_completionHandler_,
        space.pointer,
        task.pointer,
        completionHandler.pointer);
  }

  void setDefaultCredential_forProtectionSpace_task_(NSURLCredential credential,
      NSURLProtectionSpace protectionSpace, NSURLSessionTask task) {
    _objc_msgSend_558(
        this.pointer,
        _sel_setDefaultCredential_forProtectionSpace_task_,
        credential.pointer,
        protectionSpace.pointer,
        task.pointer);
  }

  @override
  NSURLCredentialStorage init() {
    final _ret = _objc_msgSend_40(this.pointer, _sel_init);
    return NSURLCredentialStorage.castFromPointer(_ret,
        retain: true, release: true);
  }

  static NSURLCredentialStorage new1() {
    final _ret = _objc_msgSend_40(_class_NSURLCredentialStorage, _sel_new);
    return NSURLCredentialStorage.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSURLCredentialStorage allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret = _objc_msgSend_47(
        _class_NSURLCredentialStorage, _sel_allocWithZone_, zone);
    return NSURLCredentialStorage.castFromPointer(_ret,
        retain: false, release: true);
  }

  static NSURLCredentialStorage alloc() {
    final _ret = _objc_msgSend_40(_class_NSURLCredentialStorage, _sel_alloc);
    return NSURLCredentialStorage.castFromPointer(_ret,
        retain: false, release: true);
  }

  static void cancelPreviousPerformRequestsWithTarget_selector_object_(
      objc.NSObject aTarget,
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.NSObject? anArgument) {
    _objc_msgSend_48(
        _class_NSURLCredentialStorage,
        _sel_cancelPreviousPerformRequestsWithTarget_selector_object_,
        aTarget.pointer,
        aSelector,
        anArgument?.pointer ?? ffi.nullptr);
  }

  static void cancelPreviousPerformRequestsWithTarget_(objc.NSObject aTarget) {
    _objc_msgSend_49(_class_NSURLCredentialStorage,
        _sel_cancelPreviousPerformRequestsWithTarget_, aTarget.pointer);
  }

  static bool getAccessInstanceVariablesDirectly() {
    return _objc_