import 'package:analyzer/dart/analysis/results.dart';
import 'package:analyzer/file_system/overlay_file_system.dart';
import 'package:analyzer/file_system/physical_file_system.dart';
import 'package:analyzer/src/dart/analysis/analysis_context_collection.dart';

void main() async {
  var co19 = '/Users/scheglov/Source/Dart/sdk.git/sdk/tests/co19';
  var resourceProvider = OverlayResourceProvider(
    PhysicalResourceProvider.INSTANCE,
  );
  resourceProvider.setOverlay(
    '$co19/src/LanguageFeatures/Augmentation-libraries/analysis_options.yaml',
    content: r'''
analyzer:
  enable-experiment:
    - macros
''',
    modificationStamp: 0,
  );

  var collection = AnalysisContextCollectionImpl(
    resourceProvider: resourceProvider,
    includedPaths: [
      '/Users/scheglov/dart/issue55931/scratchpad/macros_playground',
      // '/Users/scheglov/tmp/2024-06-12/scratchpad/macros_playground/lib/main.dart',
      // '$co19/src/LanguageFeatures/Augmentation-libraries/augmenting_types_A07_t08.dart',
    ],
  );

  var timer = Stopwatch()..start();
  for (var analysisContext in collection.contexts) {
    print(analysisContext.contextRoot.root.path);
    var analysisSession = analysisContext.currentSession;
    for (var path in analysisContext.contextRoot.analyzedFiles()) {
      if (path.endsWith('.dart')) {
        var libResult = await analysisSession.getResolvedLibrary(path);
        if (libResult is ResolvedLibraryResult) {
          for (var unitResult in libResult.units) {
            print('    ${unitResult.path}');
            var ep = '\n        ';
            print('      errors:$ep${unitResult.errors.join(ep)}');
            print('---');
            print(unitResult.content);
            print('---');
          }
        }
      }
    }
  }
  print('[time: ${timer.elapsedMilliseconds} ms]');

  await collection.dispose();
}
