// Copyright (c) 2016, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
// VMOptions=--verbose_debug

// TODO(bkonyi): consider deleting now that DBC is no more.
// This test was mostly interesting for DBC, which needed to patch two bytecodes
// to create a breakpoint for fast Smi ops.

import 'dart:developer';

import 'package:test/test.dart';
import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 35;
const LINE_B = 37;
const LINE_C = 38;
const LINE_D = 39;
// AUTOGENERATED END

class NotGeneric {}

void testeeMain() {
  final x = List<dynamic>.filled(1, null);
  final y = 7;
  debugger(); // LINE_A
  print('Statement');
  x[0] = 3; // LINE_B
  x is NotGeneric; // LINE_C
  y & 4; // LINE_D
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),

// Add breakpoints.
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    final isolate = await service.getIsolate(isolateId);
    final Library rootLib =
        await service.getObject(isolateId, isolate.rootLib!.id!) as Library;

    final script =
        await service.getObject(isolateId, rootLib.scripts![0].id!) as Script;
    final scriptId = script.id!;

    final bpt1 = await service.addBreakpoint(isolateId, scriptId, LINE_B);
    print(bpt1);
    expect(bpt1.resolved, isTrue);
    expect(
      script.getLineNumberFromTokenPos(bpt1.location!.tokenPos),
      equals(LINE_B),
    );

    final bpt2 = await service.addBreakpoint(isolateId, scriptId, LINE_C);
    print(bpt2);
    expect(bpt2.resolved, isTrue);
    expect(
      script.getLineNumberFromTokenPos(bpt2.location!.tokenPos),
      equals(LINE_C),
    );

    final bpt3 = await service.addBreakpoint(isolateId, scriptId, LINE_D);
    print(bpt3);
    expect(bpt3.resolved, isTrue);
    expect(
      script.getLineNumberFromTokenPos(bpt3.location!.tokenPos),
      equals(LINE_D),
    );
  },

  resumeIsolate,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  resumeIsolate,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_C),
  resumeIsolate,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_D),
  resumeIsolate,
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'breakpoint_two_args_checked_test.dart',
      testeeConcurrent: testeeMain,
    );
