// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
// VMOptions=--verbose_debug

import 'dart:async';
import 'dart:developer';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_0 = 27;
const LINE_A = 28;
const LINE_B = 31;
const LINE_C = 32;
const LINE_D = 34;
const LINE_E = 35;
// AUTOGENERATED END

Future<void> testMain() async {
  debugger(); // LINE_0.
  final future1 = Future.value(); // LINE_A.
  final future2 = Future.value();

  await future1; // LINE_B.
  await future2; // LINE_C.

  print('foo1'); // LINE_D.
  print('foo2'); // LINE_E.
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_0),
  stepOver,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  smartNext,
  hasStoppedAtBreakpoint,
  smartNext,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  smartNext,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_C),
  smartNext,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_D),
  resumeIsolate,
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'issue_27238_test.dart',
      testeeConcurrent: testMain,
    );
