var controller = (function () {
'use strict';

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function createCommonjsModule(fn, basedir, module) {
	return module = {
	  path: basedir,
	  exports: {},
	  require: function (path, base) {
      return commonjsRequire(path, (base === undefined || base === null) ? module.path : base);
    }
	}, fn(module, module.exports), module.exports;
}

function getCjsExportFromNamespace (n) {
	return n && n['default'] || n;
}

function commonjsRequire () {
	throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
}

var tslib = createCommonjsModule(function (module) {
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global global, define, System, Reflect, Promise */
var __extends;
var __assign;
var __rest;
var __decorate;
var __param;
var __metadata;
var __awaiter;
var __generator;
var __exportStar;
var __values;
var __read;
var __spread;
var __spreadArrays;
var __spreadArray;
var __await;
var __asyncGenerator;
var __asyncDelegator;
var __asyncValues;
var __makeTemplateObject;
var __importStar;
var __importDefault;
var __classPrivateFieldGet;
var __classPrivateFieldSet;
var __createBinding;
(function (factory) {
    var root = typeof commonjsGlobal === "object" ? commonjsGlobal : typeof self === "object" ? self : typeof this === "object" ? this : {};
    {
        factory(createExporter(root, createExporter(module.exports)));
    }
    function createExporter(exports, previous) {
        if (exports !== root) {
            if (typeof Object.create === "function") {
                Object.defineProperty(exports, "__esModule", { value: true });
            }
            else {
                exports.__esModule = true;
            }
        }
        return function (id, v) { return exports[id] = previous ? previous(id, v) : v; };
    }
})
(function (exporter) {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };

    __extends = function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };

    __assign = Object.assign || function (t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };

    __rest = function (s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    };

    __decorate = function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };

    __param = function (paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); }
    };

    __metadata = function (metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
    };

    __awaiter = function (thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    };

    __generator = function (thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    };

    __exportStar = function(m, o) {
        for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
    };

    __createBinding = Object.create ? (function(o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
    }) : (function(o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        o[k2] = m[k];
    });

    __values = function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };

    __read = function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    };

    /** @deprecated */
    __spread = function () {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    };

    /** @deprecated */
    __spreadArrays = function () {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };

    __spreadArray = function (to, from) {
        for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
            to[j] = from[i];
        return to;
    };

    __await = function (v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    };

    __asyncGenerator = function (thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);  }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
    };

    __asyncDelegator = function (o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    };

    __asyncValues = function (o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
    };

    __makeTemplateObject = function (cooked, raw) {
        if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
        return cooked;
    };

    var __setModuleDefault = Object.create ? (function(o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
        o["default"] = v;
    };

    __importStar = function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };

    __importDefault = function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };

    __classPrivateFieldGet = function (receiver, state, kind, f) {
        if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    };

    __classPrivateFieldSet = function (receiver, state, value, kind, f) {
        if (kind === "m") throw new TypeError("Private method is not writable");
        if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    };

    exporter("__extends", __extends);
    exporter("__assign", __assign);
    exporter("__rest", __rest);
    exporter("__decorate", __decorate);
    exporter("__param", __param);
    exporter("__metadata", __metadata);
    exporter("__awaiter", __awaiter);
    exporter("__generator", __generator);
    exporter("__exportStar", __exportStar);
    exporter("__createBinding", __createBinding);
    exporter("__values", __values);
    exporter("__read", __read);
    exporter("__spread", __spread);
    exporter("__spreadArrays", __spreadArrays);
    exporter("__spreadArray", __spreadArray);
    exporter("__await", __await);
    exporter("__asyncGenerator", __asyncGenerator);
    exporter("__asyncDelegator", __asyncDelegator);
    exporter("__asyncValues", __asyncValues);
    exporter("__makeTemplateObject", __makeTemplateObject);
    exporter("__importStar", __importStar);
    exporter("__importDefault", __importDefault);
    exporter("__classPrivateFieldGet", __classPrivateFieldGet);
    exporter("__classPrivateFieldSet", __classPrivateFieldSet);
});
});

var perfetto_version = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.SCM_REVISION = exports.VERSION = void 0;
exports.VERSION = "v29.0-3a9f96aec";
exports.SCM_REVISION = "3a9f96aecc5ffe0b5a9d6d540653468f0b215842";

});

var logging = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportError = exports.setErrorHandler = exports.assertFalse = exports.assertTrue = exports.assertExists = void 0;

let errorHandler = (_) => { };
function assertExists(value) {
    if (value === null || value === undefined) {
        throw new Error('Value doesn\'t exist');
    }
    return value;
}
exports.assertExists = assertExists;
function assertTrue(value, optMsg) {
    if (value !== true) {
        throw new Error(optMsg ? optMsg : 'Failed assertion');
    }
}
exports.assertTrue = assertTrue;
function assertFalse(value, optMsg) {
    assertTrue(!value, optMsg);
}
exports.assertFalse = assertFalse;
function setErrorHandler(handler) {
    errorHandler = handler;
}
exports.setErrorHandler = setErrorHandler;
function reportError(err) {
    let errLog = '';
    let errorObj = undefined;
    if (err instanceof ErrorEvent) {
        errLog = err.message;
        errorObj = err.error;
    }
    else if (err instanceof PromiseRejectionEvent) {
        errLog = `${err.reason}`;
        errorObj = err.reason;
    }
    else {
        errLog = `${err}`;
    }
    if (errorObj !== undefined && errorObj !== null) {
        const errStack = errorObj.stack;
        errLog += '\n';
        errLog += errStack !== undefined ? errStack : JSON.stringify(errorObj);
    }
    errLog += '\n\n';
    errLog += `${perfetto_version.VERSION} ${perfetto_version.SCM_REVISION}\n`;
    errLog += `UA: ${navigator.userAgent}\n`;
    console.error(errLog, err);
    errorHandler(errLog);
}
exports.reportError = reportError;

});

var registry = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Registry = void 0;
class Registry {
    constructor(key) {
        this.registry = new Map();
        this.key = key;
    }
    static kindRegistry() {
        return new Registry((t) => t.kind);
    }
    register(registrant) {
        const kind = this.key(registrant);
        if (this.registry.has(kind)) {
            throw new Error(`Registrant ${kind} already exists in the registry`);
        }
        this.registry.set(kind, registrant);
    }
    has(kind) {
        return this.registry.has(kind);
    }
    get(kind) {
        const registrant = this.registry.get(kind);
        if (registrant === undefined) {
            throw new Error(`${kind} has not been registered.`);
        }
        return registrant;
    }
    // Support iteration: for (const foo of fooRegistry.values()) { ... }
    *values() {
        yield* this.registry.values();
    }
    unregisterAllForTesting() {
        this.registry.clear();
    }
}
exports.Registry = Registry;

});

var time = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeSpan = exports.currentDateHourAndMinute = exports.timeToCode = exports.formatTimestamp = exports.toNs = exports.toNsCeil = exports.toNsFloor = exports.fromNs = exports.timeToString = void 0;

const EPSILON = 0.0000000001;
// TODO(hjd): Combine with timeToCode.
function timeToString(sec) {
    const units = ['s', 'ms', 'us', 'ns'];
    const sign = Math.sign(sec);
    let n = Math.abs(sec);
    let u = 0;
    while (n < 1 && n !== 0 && u < units.length - 1) {
        n *= 1000;
        u++;
    }
    return `${sign < 0 ? '-' : ''}${Math.round(n * 10) / 10} ${units[u]}`;
}
exports.timeToString = timeToString;
function fromNs(ns) {
    return ns / 1e9;
}
exports.fromNs = fromNs;
function toNsFloor(seconds) {
    return Math.floor(seconds * 1e9);
}
exports.toNsFloor = toNsFloor;
function toNsCeil(seconds) {
    return Math.ceil(seconds * 1e9);
}
exports.toNsCeil = toNsCeil;
function toNs(seconds) {
    return Math.round(seconds * 1e9);
}
exports.toNs = toNs;
// 1000000023ns -> "1.000 000 023"
function formatTimestamp(sec) {
    const parts = sec.toFixed(9).split('.');
    parts[1] = parts[1].replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
    return parts.join('.');
}
exports.formatTimestamp = formatTimestamp;
// TODO(hjd): Rename to formatTimestampWithUnits
// 1000000023ns -> "1s 23ns"
function timeToCode(sec) {
    let result = '';
    let ns = Math.round(sec * 1e9);
    if (ns < 1)
        return '0s';
    const unitAndValue = [
        ['m', 60000000000],
        ['s', 1000000000],
        ['ms', 1000000],
        ['us', 1000],
        ['ns', 1],
    ];
    unitAndValue.forEach((pair) => {
        const unit = pair[0];
        const val = pair[1];
        if (ns >= val) {
            const i = Math.floor(ns / val);
            ns -= i * val;
            result += i.toLocaleString() + unit + ' ';
        }
    });
    return result.slice(0, -1);
}
exports.timeToCode = timeToCode;
function currentDateHourAndMinute() {
    const date = new Date();
    return `${date.toISOString().substr(0, 10)}-${date.getHours()}-${date.getMinutes()}`;
}
exports.currentDateHourAndMinute = currentDateHourAndMinute;
class TimeSpan {
    constructor(start, end) {
        (0, logging.assertTrue)(start <= end);
        this.start = start;
        this.end = end;
    }
    clone() {
        return new TimeSpan(this.start, this.end);
    }
    equals(other) {
        return Math.abs(this.start - other.start) < EPSILON &&
            Math.abs(this.end - other.end) < EPSILON;
    }
    get duration() {
        return this.end - this.start;
    }
    isInBounds(sec) {
        return this.start <= sec && sec <= this.end;
    }
    add(sec) {
        return new TimeSpan(this.start + sec, this.end + sec);
    }
    contains(other) {
        return this.start <= other.start && other.end <= this.end;
    }
}
exports.TimeSpan = TimeSpan;

});

var track_data = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LIMIT = void 0;
// TODO(hjd): Refactor into method on TrackController
exports.LIMIT = 10000;

});

var conversion_jobs = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversionJobStatus = void 0;
(function (ConversionJobStatus) {
    ConversionJobStatus["InProgress"] = "InProgress";
    ConversionJobStatus["NotRunning"] = "NotRunning";
})(exports.ConversionJobStatus || (exports.ConversionJobStatus = {}));

});

var validators = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.arrayOf = exports.oneOf = exports.record = exports.bool = exports.num = exports.requiredStr = exports.str = exports.runValidator = exports.ValidationError = void 0;
// Helper function to flatten array of path chunks into a single string
// Example: ["config", "androidLogBuffers", "1"] is mapped to
// "config.androidLogBuffers[1]".
function renderPath(path) {
    let result = '';
    for (let i = 0; i < path.length; i++) {
        if (i > 0 && !path[i].startsWith('[')) {
            result += '.';
        }
        result += path[i];
    }
    return result;
}
class ValidationError extends Error {
}
exports.ValidationError = ValidationError;
// Abstract class for validating simple values, such as strings and booleans.
// Allows to avoid repetition of most of the code related to validation of
// these.
class PrimitiveValidator {
    constructor(defaultValue, required) {
        this.defaultValue = defaultValue;
        this.required = required;
    }
    validate(input, context) {
        if (this.predicate(input)) {
            return input;
        }
        if (this.required) {
            throw new ValidationError(renderPath(context.path));
        }
        if (input !== undefined) {
            // The value is defined, but does not conform to the expected type;
            // proceed with returning the default value but report the key.
            context.invalidKeys.push(renderPath(context.path));
        }
        return this.defaultValue;
    }
}
class StringValidator extends PrimitiveValidator {
    predicate(input) {
        return typeof input === 'string';
    }
}
class NumberValidator extends PrimitiveValidator {
    predicate(input) {
        return typeof input === 'number';
    }
}
class BooleanValidator extends PrimitiveValidator {
    predicate(input) {
        return typeof input === 'boolean';
    }
}
// Combinator for validators: takes a record of validators, and returns a
// validator for a record where record's fields passed to validator with the
// same name.
//
// Generic parameter T is instantiated to type of record of validators, and
// should be provided implicitly by type inference due to verbosity of its
// instantiations.
class RecordValidator {
    constructor(validators) {
        this.validators = validators;
    }
    validate(input, context) {
        // If value is missing or of incorrect type, empty record is still processed
        // in the loop below to initialize default fields of the nested object.
        let o = {};
        if (typeof input === 'object' && input !== null) {
            o = input;
        }
        else if (input !== undefined) {
            context.invalidKeys.push(renderPath(context.path));
        }
        const result = {};
        // Separate declaration is required to avoid assigning `string` type to `k`.
        for (const k in this.validators) {
            if (this.validators.hasOwnProperty(k)) {
                context.path.push(k);
                const validator = this.validators[k];
                // Accessing value of `k` of `o` is safe because `undefined` values are
                // considered to indicate a missing value and handled appropriately by
                // every provided validator.
                const valid = validator.validate(o[k], context);
                result[k] = valid;
                context.path.pop();
            }
        }
        // Check if passed object has any extra keys to be reported as such.
        for (const key of Object.keys(o)) {
            if (!this.validators.hasOwnProperty(key)) {
                context.path.push(key);
                context.extraKeys.push(renderPath(context.path));
                context.path.pop();
            }
        }
        return result;
    }
}
// Validator checking whether a value is one of preset values. Used in order to
// provide easy validation for union of literal types.
class OneOfValidator {
    constructor(validValues, defaultValue) {
        this.defaultValue = defaultValue;
        this.validValues = validValues;
    }
    validate(input, context) {
        if (this.validValues.includes(input)) {
            return input;
        }
        else if (input !== undefined) {
            context.invalidKeys.push(renderPath(context.path));
        }
        return this.defaultValue;
    }
}
// Validator for an array of elements, applying the same element validator for
// each element of an array. Uses empty array as a default value.
class ArrayValidator {
    constructor(elementValidator) {
        this.elementValidator = elementValidator;
    }
    validate(input, context) {
        const result = [];
        if (Array.isArray(input)) {
            for (let i = 0; i < input.length; i++) {
                context.path.push(`[${i}]`);
                result.push(this.elementValidator.validate(input[i], context));
                context.path.pop();
            }
        }
        else if (input !== undefined) {
            context.invalidKeys.push(renderPath(context.path));
        }
        return result;
    }
}
// Wrapper for running a validator initializing the context.
function runValidator(validator, input) {
    const context = {
        path: [],
        invalidKeys: [],
        extraKeys: [],
    };
    const result = validator.validate(input, context);
    return {
        result,
        invalidKeys: context.invalidKeys,
        extraKeys: context.extraKeys,
    };
}
exports.runValidator = runValidator;
// Shorthands for the validator classes above enabling concise notation.
function str(defaultValue = '') {
    return new StringValidator(defaultValue, false);
}
exports.str = str;
exports.requiredStr = new StringValidator('', true);
function num(defaultValue = 0) {
    return new NumberValidator(defaultValue, false);
}
exports.num = num;
function bool(defaultValue = false) {
    return new BooleanValidator(defaultValue, false);
}
exports.bool = bool;
function record(validators) {
    return new RecordValidator(validators);
}
exports.record = record;
function oneOf(values, defaultValue) {
    return new OneOfValidator(values, defaultValue);
}
exports.oneOf = oneOf;
function arrayOf(elementValidator) {
    return new ArrayValidator(elementValidator);
}
exports.arrayOf = arrayOf;

});

var record_config_types = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEmptyRecordConfig = exports.namedRecordConfigValidator = exports.recordConfigValidator = void 0;

const recordModes = ['STOP_WHEN_FULL', 'RING_BUFFER', 'LONG_TRACE'];
exports.recordConfigValidator = (0, validators.record)({
    mode: (0, validators.oneOf)(recordModes, 'STOP_WHEN_FULL'),
    durationMs: (0, validators.num)(10000.0),
    maxFileSizeMb: (0, validators.num)(100),
    fileWritePeriodMs: (0, validators.num)(2500),
    bufferSizeMb: (0, validators.num)(64.0),
    cpuSched: (0, validators.bool)(),
    cpuFreq: (0, validators.bool)(),
    cpuSyscall: (0, validators.bool)(),
    gpuFreq: (0, validators.bool)(),
    gpuMemTotal: (0, validators.bool)(),
    ftrace: (0, validators.bool)(),
    atrace: (0, validators.bool)(),
    ftraceEvents: (0, validators.arrayOf)((0, validators.str)()),
    ftraceExtraEvents: (0, validators.str)(),
    atraceCats: (0, validators.arrayOf)((0, validators.str)()),
    allAtraceApps: (0, validators.bool)(true),
    atraceApps: (0, validators.str)(),
    ftraceBufferSizeKb: (0, validators.num)(0),
    ftraceDrainPeriodMs: (0, validators.num)(0),
    androidLogs: (0, validators.bool)(),
    androidLogBuffers: (0, validators.arrayOf)((0, validators.str)()),
    androidFrameTimeline: (0, validators.bool)(),
    androidGameInterventionList: (0, validators.bool)(),
    cpuCoarse: (0, validators.bool)(),
    cpuCoarsePollMs: (0, validators.num)(1000),
    batteryDrain: (0, validators.bool)(),
    batteryDrainPollMs: (0, validators.num)(1000),
    boardSensors: (0, validators.bool)(),
    memHiFreq: (0, validators.bool)(),
    meminfo: (0, validators.bool)(),
    meminfoPeriodMs: (0, validators.num)(1000),
    meminfoCounters: (0, validators.arrayOf)((0, validators.str)()),
    vmstat: (0, validators.bool)(),
    vmstatPeriodMs: (0, validators.num)(1000),
    vmstatCounters: (0, validators.arrayOf)((0, validators.str)()),
    heapProfiling: (0, validators.bool)(),
    hpSamplingIntervalBytes: (0, validators.num)(4096),
    hpProcesses: (0, validators.str)(),
    hpContinuousDumpsPhase: (0, validators.num)(),
    hpContinuousDumpsInterval: (0, validators.num)(),
    hpSharedMemoryBuffer: (0, validators.num)(8 * 1048576),
    hpBlockClient: (0, validators.bool)(true),
    hpAllHeaps: (0, validators.bool)(),
    javaHeapDump: (0, validators.bool)(),
    jpProcesses: (0, validators.str)(),
    jpContinuousDumpsPhase: (0, validators.num)(),
    jpContinuousDumpsInterval: (0, validators.num)(),
    memLmk: (0, validators.bool)(),
    procStats: (0, validators.bool)(),
    procStatsPeriodMs: (0, validators.num)(1000),
    chromeCategoriesSelected: (0, validators.arrayOf)((0, validators.str)()),
    chromeHighOverheadCategoriesSelected: (0, validators.arrayOf)((0, validators.str)()),
    chromeLogs: (0, validators.bool)(),
    taskScheduling: (0, validators.bool)(),
    ipcFlows: (0, validators.bool)(),
    jsExecution: (0, validators.bool)(),
    webContentRendering: (0, validators.bool)(),
    uiRendering: (0, validators.bool)(),
    inputEvents: (0, validators.bool)(),
    navigationAndLoading: (0, validators.bool)(),
    symbolizeKsyms: (0, validators.bool)(),
});
exports.namedRecordConfigValidator = (0, validators.record)({ title: validators.requiredStr, key: validators.requiredStr, config: exports.recordConfigValidator });
function createEmptyRecordConfig() {
    return (0, validators.runValidator)(exports.recordConfigValidator, {}).result;
}
exports.createEmptyRecordConfig = createEmptyRecordConfig;

});

var state = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.getContainingTrackId = exports.getBuiltinChromeCategoryList = exports.getDefaultRecordingTargets = exports.hasActiveProbes = exports.isAdbTarget = exports.isLinuxTarget = exports.isCrOSTarget = exports.isChromeTarget = exports.isAndroidTarget = exports.isAndroidP = exports.defaultTraceTime = exports.ProfileType = exports.InThreadTrackSortKey = exports.PrimaryTrackSortKey = exports.SCROLLING_TRACK_GROUP = exports.STATE_VERSION = exports.MAX_TIME = void 0;
exports.MAX_TIME = 180;
// 3: TrackKindPriority and related sorting changes.
// 5: Move a large number of items off frontendLocalState and onto state.
// 6: Common PivotTableConfig and pivot table specific PivotTableState.
// 7: Split Chrome categories in two and add 'symbolize ksyms' flag.
// 8: Rename several variables
// "[...]HeapProfileFlamegraph[...]" -> "[...]Flamegraph[...]".
// 9: Add a field to track last loaded recording profile name
// 10: Change last loaded profile tracking type to accommodate auto-save.
// 11: Rename updateChromeCategories to fetchChromeCategories.
// 12: Add a field to cache mapping from UI track ID to trace track ID in order
//     to speed up flow arrows rendering.
// 13: FlamegraphState changed to support area selection.
// 14: Changed the type of uiTrackIdByTraceTrackId from `Map` to an object with
// typed key/value because a `Map` does not preserve type during
// serialisation+deserialisation.
// 15: Added state for Pivot Table V2
// 16: Added boolean tracking if the flamegraph modal was dismissed
// 17:
// - add currentEngineId to track the id of the current engine
// - remove nextNoteId, nextAreaId and use nextId as a unique counter for all
//   indexing except the indexing of the engines
// 18: areaSelection change see b/235869542
// 19: Added visualisedArgs state.
// 20: Refactored thread sorting order.
// 21: Updated perf sample selection to include a ts range instead of single ts
// 22: Add log selection kind.
exports.STATE_VERSION = 22;
exports.SCROLLING_TRACK_GROUP = 'ScrollingTracks';
(function (PrimaryTrackSortKey) {
    PrimaryTrackSortKey[PrimaryTrackSortKey["DEBUG_SLICE_TRACK"] = 0] = "DEBUG_SLICE_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["NULL_TRACK"] = 1] = "NULL_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["PROCESS_SCHEDULING_TRACK"] = 2] = "PROCESS_SCHEDULING_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["PROCESS_SUMMARY_TRACK"] = 3] = "PROCESS_SUMMARY_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["EXPECTED_FRAMES_SLICE_TRACK"] = 4] = "EXPECTED_FRAMES_SLICE_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["ACTUAL_FRAMES_SLICE_TRACK"] = 5] = "ACTUAL_FRAMES_SLICE_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["PERF_SAMPLES_PROFILE_TRACK"] = 6] = "PERF_SAMPLES_PROFILE_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["HEAP_PROFILE_TRACK"] = 7] = "HEAP_PROFILE_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["MAIN_THREAD"] = 8] = "MAIN_THREAD";
    PrimaryTrackSortKey[PrimaryTrackSortKey["RENDER_THREAD"] = 9] = "RENDER_THREAD";
    PrimaryTrackSortKey[PrimaryTrackSortKey["GPU_COMPLETION_THREAD"] = 10] = "GPU_COMPLETION_THREAD";
    PrimaryTrackSortKey[PrimaryTrackSortKey["CHROME_IO_THREAD"] = 11] = "CHROME_IO_THREAD";
    PrimaryTrackSortKey[PrimaryTrackSortKey["CHROME_COMPOSITOR_THREAD"] = 12] = "CHROME_COMPOSITOR_THREAD";
    PrimaryTrackSortKey[PrimaryTrackSortKey["ORDINARY_THREAD"] = 13] = "ORDINARY_THREAD";
    PrimaryTrackSortKey[PrimaryTrackSortKey["COUNTER_TRACK"] = 14] = "COUNTER_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["ASYNC_SLICE_TRACK"] = 15] = "ASYNC_SLICE_TRACK";
    PrimaryTrackSortKey[PrimaryTrackSortKey["ORDINARY_TRACK"] = 16] = "ORDINARY_TRACK";
})(exports.PrimaryTrackSortKey || (exports.PrimaryTrackSortKey = {}));
(function (InThreadTrackSortKey) {
    InThreadTrackSortKey[InThreadTrackSortKey["THREAD_COUNTER_TRACK"] = 0] = "THREAD_COUNTER_TRACK";
    InThreadTrackSortKey[InThreadTrackSortKey["THREAD_SCHEDULING_STATE_TRACK"] = 1] = "THREAD_SCHEDULING_STATE_TRACK";
    InThreadTrackSortKey[InThreadTrackSortKey["CPU_STACK_SAMPLES_TRACK"] = 2] = "CPU_STACK_SAMPLES_TRACK";
    InThreadTrackSortKey[InThreadTrackSortKey["VISUALISED_ARGS_TRACK"] = 3] = "VISUALISED_ARGS_TRACK";
    InThreadTrackSortKey[InThreadTrackSortKey["ORDINARY"] = 4] = "ORDINARY";
    InThreadTrackSortKey[InThreadTrackSortKey["DEFAULT_TRACK"] = 5] = "DEFAULT_TRACK";
})(exports.InThreadTrackSortKey || (exports.InThreadTrackSortKey = {}));
(function (ProfileType) {
    ProfileType["HEAP_PROFILE"] = "heap_profile";
    ProfileType["NATIVE_HEAP_PROFILE"] = "heap_profile:libc.malloc";
    ProfileType["JAVA_HEAP_PROFILE"] = "heap_profile:com.android.art";
    ProfileType["JAVA_HEAP_GRAPH"] = "graph";
    ProfileType["PERF_SAMPLE"] = "perf";
})(exports.ProfileType || (exports.ProfileType = {}));
exports.defaultTraceTime = {
    startSec: 0,
    endSec: 10,
};
function isAndroidP(target) {
    return target.os === 'P';
}
exports.isAndroidP = isAndroidP;
function isAndroidTarget(target) {
    return ['Q', 'P', 'O'].includes(target.os);
}
exports.isAndroidTarget = isAndroidTarget;
function isChromeTarget(target) {
    return ['C', 'CrOS'].includes(target.os);
}
exports.isChromeTarget = isChromeTarget;
function isCrOSTarget(target) {
    return target.os === 'CrOS';
}
exports.isCrOSTarget = isCrOSTarget;
function isLinuxTarget(target) {
    return target.os === 'L';
}
exports.isLinuxTarget = isLinuxTarget;
function isAdbTarget(target) {
    return !!target.serial;
}
exports.isAdbTarget = isAdbTarget;
function hasActiveProbes(config) {
    const fieldsWithEmptyResult = new Set(['hpBlockClient', 'allAtraceApps']);
    let key;
    for (key in config) {
        if (typeof (config[key]) === 'boolean' && config[key] === true &&
            !fieldsWithEmptyResult.has(key)) {
            return true;
        }
    }
    if (config.chromeCategoriesSelected.length > 0) {
        return true;
    }
    return config.chromeHighOverheadCategoriesSelected.length > 0;
}
exports.hasActiveProbes = hasActiveProbes;
function getDefaultRecordingTargets() {
    return [
        { os: 'Q', name: 'Android Q+' },
        { os: 'P', name: 'Android P' },
        { os: 'O', name: 'Android O-' },
        { os: 'C', name: 'Chrome' },
        { os: 'CrOS', name: 'Chrome OS (system trace)' },
        { os: 'L', name: 'Linux desktop' },
    ];
}
exports.getDefaultRecordingTargets = getDefaultRecordingTargets;
function getBuiltinChromeCategoryList() {
    // List of static Chrome categories, last updated at 2021-09-09 from HEAD of
    // Chromium's //base/trace_event/builtin_categories.h.
    return [
        'accessibility',
        'AccountFetcherService',
        'android_webview',
        'aogh',
        'audio',
        'base',
        'benchmark',
        'blink',
        'blink.animations',
        'blink.bindings',
        'blink.console',
        'blink.net',
        'blink.resource',
        'blink.user_timing',
        'blink.worker',
        'blink_gc',
        'blink_style',
        'Blob',
        'browser',
        'browsing_data',
        'CacheStorage',
        'Calculators',
        'CameraStream',
        'camera',
        'cast_app',
        'cast_perf_test',
        'cast.mdns',
        'cast.mdns.socket',
        'cast.stream',
        'cc',
        'cc.debug',
        'cdp.perf',
        'chromeos',
        'cma',
        'compositor',
        'content',
        'content_capture',
        'device',
        'devtools',
        'devtools.contrast',
        'devtools.timeline',
        'disk_cache',
        'download',
        'download_service',
        'drm',
        'drmcursor',
        'dwrite',
        'DXVA_Decoding',
        'evdev',
        'event',
        'exo',
        'extensions',
        'explore_sites',
        'FileSystem',
        'file_system_provider',
        'fonts',
        'GAMEPAD',
        'gpu',
        'gpu.angle',
        'gpu.capture',
        'headless',
        'hwoverlays',
        'identity',
        'ime',
        'IndexedDB',
        'input',
        'io',
        'ipc',
        'Java',
        'jni',
        'jpeg',
        'latency',
        'latencyInfo',
        'leveldb',
        'loading',
        'log',
        'login',
        'media',
        'media_router',
        'memory',
        'midi',
        'mojom',
        'mus',
        'native',
        'navigation',
        'net',
        'netlog',
        'offline_pages',
        'omnibox',
        'oobe',
        'ozone',
        'partition_alloc',
        'passwords',
        'p2p',
        'page-serialization',
        'paint_preview',
        'pepper',
        'PlatformMalloc',
        'power',
        'ppapi',
        'ppapi_proxy',
        'print',
        'rail',
        'renderer',
        'renderer_host',
        'renderer.scheduler',
        'RLZ',
        'safe_browsing',
        'screenlock_monitor',
        'segmentation_platform',
        'sequence_manager',
        'service_manager',
        'ServiceWorker',
        'sharing',
        'shell',
        'shortcut_viewer',
        'shutdown',
        'SiteEngagement',
        'skia',
        'sql',
        'stadia_media',
        'stadia_rtc',
        'startup',
        'sync',
        'system_apps',
        'test_gpu',
        'thread_pool',
        'toplevel',
        'toplevel.flow',
        'ui',
        'v8',
        'v8.execute',
        'v8.wasm',
        'ValueStoreFrontend::Backend',
        'views',
        'views.frame',
        'viz',
        'vk',
        'wayland',
        'webaudio',
        'weblayer',
        'WebCore',
        'webrtc',
        'xr',
        'disabled-by-default-animation-worklet',
        'disabled-by-default-audio',
        'disabled-by-default-audio-worklet',
        'disabled-by-default-base',
        'disabled-by-default-blink.debug',
        'disabled-by-default-blink.debug.display_lock',
        'disabled-by-default-blink.debug.layout',
        'disabled-by-default-blink.debug.layout.trees',
        'disabled-by-default-blink.feature_usage',
        'disabled-by-default-blink_gc',
        'disabled-by-default-blink.image_decoding',
        'disabled-by-default-blink.invalidation',
        'disabled-by-default-cc',
        'disabled-by-default-cc.debug',
        'disabled-by-default-cc.debug.cdp-perf',
        'disabled-by-default-cc.debug.display_items',
        'disabled-by-default-cc.debug.picture',
        'disabled-by-default-cc.debug.scheduler',
        'disabled-by-default-cc.debug.scheduler.frames',
        'disabled-by-default-cc.debug.scheduler.now',
        'disabled-by-default-content.verbose',
        'disabled-by-default-cpu_profiler',
        'disabled-by-default-cpu_profiler.debug',
        'disabled-by-default-devtools.screenshot',
        'disabled-by-default-devtools.timeline',
        'disabled-by-default-devtools.timeline.frame',
        'disabled-by-default-devtools.timeline.inputs',
        'disabled-by-default-devtools.timeline.invalidationTracking',
        'disabled-by-default-devtools.timeline.layers',
        'disabled-by-default-devtools.timeline.picture',
        'disabled-by-default-file',
        'disabled-by-default-fonts',
        'disabled-by-default-gpu_cmd_queue',
        'disabled-by-default-gpu.dawn',
        'disabled-by-default-gpu.debug',
        'disabled-by-default-gpu.decoder',
        'disabled-by-default-gpu.device',
        'disabled-by-default-gpu.service',
        'disabled-by-default-gpu.vulkan.vma',
        'disabled-by-default-histogram_samples',
        'disabled-by-default-java-heap-profiler',
        'disabled-by-default-layer-element',
        'disabled-by-default-layout_shift.debug',
        'disabled-by-default-lifecycles',
        'disabled-by-default-loading',
        'disabled-by-default-mediastream',
        'disabled-by-default-memory-infra',
        'disabled-by-default-memory-infra.v8.code_stats',
        'disabled-by-default-mojom',
        'disabled-by-default-net',
        'disabled-by-default-network',
        'disabled-by-default-paint-worklet',
        'disabled-by-default-power',
        'disabled-by-default-renderer.scheduler',
        'disabled-by-default-renderer.scheduler.debug',
        'disabled-by-default-sandbox',
        'disabled-by-default-sequence_manager',
        'disabled-by-default-sequence_manager.debug',
        'disabled-by-default-sequence_manager.verbose_snapshots',
        'disabled-by-default-skia',
        'disabled-by-default-skia.gpu',
        'disabled-by-default-skia.gpu.cache',
        'disabled-by-default-skia.shaders',
        'disabled-by-default-SyncFileSystem',
        'disabled-by-default-system_stats',
        'disabled-by-default-thread_pool_diagnostics',
        'disabled-by-default-toplevel.ipc',
        'disabled-by-default-user_action_samples',
        'disabled-by-default-v8.compile',
        'disabled-by-default-v8.cpu_profiler',
        'disabled-by-default-v8.gc',
        'disabled-by-default-v8.gc_stats',
        'disabled-by-default-v8.ic_stats',
        'disabled-by-default-v8.runtime',
        'disabled-by-default-v8.runtime_stats',
        'disabled-by-default-v8.runtime_stats_sampling',
        'disabled-by-default-v8.stack_trace',
        'disabled-by-default-v8.turbofan',
        'disabled-by-default-v8.wasm.detailed',
        'disabled-by-default-v8.wasm.turbofan',
        'disabled-by-default-video_and_image_capture',
        'disabled-by-default-viz.gpu_composite_time',
        'disabled-by-default-viz.debug.overlay_planes',
        'disabled-by-default-viz.hit_testing_flow',
        'disabled-by-default-viz.overdraw',
        'disabled-by-default-viz.quads',
        'disabled-by-default-viz.surface_id_flow',
        'disabled-by-default-viz.surface_lifetime',
        'disabled-by-default-viz.triangles',
        'disabled-by-default-webaudio.audionode',
        'disabled-by-default-webrtc',
        'disabled-by-default-worker.scheduler',
        'disabled-by-default-xr.debug',
    ];
}
exports.getBuiltinChromeCategoryList = getBuiltinChromeCategoryList;
function getContainingTrackId(state, trackId) {
    const track = state.tracks[trackId];
    if (!track) {
        return null;
    }
    const parentId = track.trackGroup;
    if (!parentId) {
        return null;
    }
    return parentId;
}
exports.getContainingTrackId = getContainingTrackId;

});

var record_config = createCommonjsModule(function (module, exports) {
// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.recordTargetStore = exports.RecordTargetStore = exports.autosaveConfigStore = exports.AutosaveConfigStore = exports.recordConfigStore = exports.RecordConfigStore = void 0;



const LOCAL_STORAGE_RECORD_CONFIGS_KEY = 'recordConfigs';
const LOCAL_STORAGE_AUTOSAVE_CONFIG_KEY = 'autosaveConfig';
const LOCAL_STORAGE_RECORD_TARGET_OS_KEY = 'recordTargetOS';
class RecordConfigStore {
    constructor() {
        this.recordConfigs = [];
        this.recordConfigNames = new Set();
        this.reloadFromLocalStorage();
    }
    _save() {
        window.localStorage.setItem(LOCAL_STORAGE_RECORD_CONFIGS_KEY, JSON.stringify(this.recordConfigs.map((x) => x.result)));
    }
    save(recordConfig, title) {
        // We reload from local storage in case of concurrent
        // modifications of local storage from a different tab.
        this.reloadFromLocalStorage();
        const savedTitle = title ? title : new Date().toJSON();
        const config = {
            title: savedTitle,
            config: recordConfig,
            key: new Date().toJSON(),
        };
        this.recordConfigs.push({ result: config, invalidKeys: [], extraKeys: [] });
        this.recordConfigNames.add(savedTitle);
        this._save();
    }
    overwrite(recordConfig, key) {
        // We reload from local storage in case of concurrent
        // modifications of local storage from a different tab.
        this.reloadFromLocalStorage();
        const found = this.recordConfigs.find((e) => e.result.key === key);
        if (found === undefined) {
            throw new Error('trying to overwrite non-existing config');
        }
        found.result.config = recordConfig;
        this._save();
    }
    delete(key) {
        // We reload from local storage in case of concurrent
        // modifications of local storage from a different tab.
        this.reloadFromLocalStorage();
        let idx = -1;
        for (let i = 0; i < this.recordConfigs.length; ++i) {
            if (this.recordConfigs[i].result.key === key) {
                idx = i;
                break;
            }
        }
        if (idx !== -1) {
            this.recordConfigNames.delete(this.recordConfigs[idx].result.title);
            this.recordConfigs.splice(idx, 1);
            this._save();
        }
        else {
            // TODO(bsebastien): Show a warning message to the user in the UI.
            console.warn('The config selected doesn\'t exist any more');
        }
    }
    clearRecordConfigs() {
        this.recordConfigs = [];
        this.recordConfigNames.clear();
        this._save();
    }
    reloadFromLocalStorage() {
        const configsLocalStorage = window.localStorage.getItem(LOCAL_STORAGE_RECORD_CONFIGS_KEY);
        if (configsLocalStorage) {
            this.recordConfigNames.clear();
            try {
                const validConfigLocalStorage = [];
                const parsedConfigsLocalStorage = JSON.parse(configsLocalStorage);
                // Check if it's an array.
                if (!Array.isArray(parsedConfigsLocalStorage)) {
                    this.clearRecordConfigs();
                    return;
                }
                for (let i = 0; i < parsedConfigsLocalStorage.length; ++i) {
                    try {
                        validConfigLocalStorage.push((0, validators.runValidator)(record_config_types.namedRecordConfigValidator, parsedConfigsLocalStorage[i]));
                    }
                    catch (_a) {
                        // Parsing failed with unrecoverable error (e.g. title or key are
                        // missing), ignore the result.
                        console.log('Validation of saved record config has failed: ' +
                            JSON.stringify(parsedConfigsLocalStorage[i]));
                    }
                }
                this.recordConfigs = validConfigLocalStorage;
                this._save();
            }
            catch (e) {
                this.clearRecordConfigs();
            }
        }
        else {
            this.clearRecordConfigs();
        }
    }
    canSave(title) {
        return !this.recordConfigNames.has(title);
    }
}
exports.RecordConfigStore = RecordConfigStore;
// This class is a singleton to avoid many instances
// conflicting as they attempt to edit localStorage.
exports.recordConfigStore = new RecordConfigStore();
class AutosaveConfigStore {
    constructor() {
        this.hasSavedConfig = false;
        this.config = (0, record_config_types.createEmptyRecordConfig)();
        const savedItem = window.localStorage.getItem(LOCAL_STORAGE_AUTOSAVE_CONFIG_KEY);
        if (savedItem === null) {
            return;
        }
        const parsed = JSON.parse(savedItem);
        if (parsed !== null && typeof parsed === 'object') {
            this.config = (0, validators.runValidator)(record_config_types.recordConfigValidator, parsed).result;
            this.hasSavedConfig = true;
        }
    }
    get() {
        return this.config;
    }
    save(newConfig) {
        window.localStorage.setItem(LOCAL_STORAGE_AUTOSAVE_CONFIG_KEY, JSON.stringify(newConfig));
        this.config = newConfig;
        this.hasSavedConfig = true;
    }
}
exports.AutosaveConfigStore = AutosaveConfigStore;
exports.autosaveConfigStore = new AutosaveConfigStore();
class RecordTargetStore {
    constructor() {
        this.recordTargetOS =
            window.localStorage.getItem(LOCAL_STORAGE_RECORD_TARGET_OS_KEY);
    }
    get() {
        return this.recordTargetOS;
    }
    getValidTarget() {
        const validTargets = (0, state.getDefaultRecordingTargets)();
        const savedOS = this.get();
        const validSavedTarget = validTargets.find((el) => el.os === savedOS);
        return validSavedTarget || validTargets[0];
    }
    save(newTargetOS) {
        window.localStorage.setItem(LOCAL_STORAGE_RECORD_TARGET_OS_KEY, newTargetOS);
        this.recordTargetOS = newTargetOS;
    }
}
exports.RecordTargetStore = RecordTargetStore;
exports.recordTargetStore = new RecordTargetStore();

});

var feature_flags = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.RECORDING_V2_FLAG = exports.PERF_SAMPLE_FLAG = exports.featureFlags = exports.FlagsForTesting = exports.OverrideState = void 0;
var OverrideState;
(function (OverrideState) {
    OverrideState["DEFAULT"] = "DEFAULT";
    OverrideState["TRUE"] = "OVERRIDE_TRUE";
    OverrideState["FALSE"] = "OVERRIDE_FALSE";
})(OverrideState = exports.OverrideState || (exports.OverrideState = {}));
// Check if the given object is a valid FlagOverrides.
// This is necessary since someone could modify the persisted flags
// behind our backs.
function isFlagOverrides(o) {
    const states = [OverrideState.TRUE.toString(), OverrideState.FALSE.toString()];
    for (const v of Object.values(o)) {
        if (typeof v !== 'string' || !states.includes(v)) {
            return false;
        }
    }
    return true;
}
class Flags {
    constructor(store) {
        this.store = store;
        this.flags = new Map();
        this.overrides = {};
        this.load();
    }
    register(settings) {
        const id = settings.id;
        if (this.flags.has(id)) {
            throw new Error(`Flag with id "${id}" is already registered.`);
        }
        const saved = this.overrides[id];
        const state = saved === undefined ? OverrideState.DEFAULT : saved;
        const flag = new FlagImpl(this, state, settings);
        this.flags.set(id, flag);
        return flag;
    }
    allFlags() {
        const includeDevFlags = ['127.0.0.1', '::1', 'localhost'].includes(window.location.hostname);
        return [...this.flags.values()].filter((flag) => includeDevFlags || !flag.devOnly);
    }
    resetAll() {
        for (const flag of this.flags.values()) {
            flag.state = OverrideState.DEFAULT;
        }
        this.save();
    }
    load() {
        const o = this.store.load();
        if (isFlagOverrides(o)) {
            this.overrides = o;
        }
    }
    save() {
        for (const flag of this.flags.values()) {
            if (flag.isOverridden()) {
                this.overrides[flag.id] = flag.state;
            }
            else {
                delete this.overrides[flag.id];
            }
        }
        this.store.save(this.overrides);
    }
}
class FlagImpl {
    constructor(registry, state, settings) {
        this.registry = registry;
        this.id = settings.id;
        this.state = state;
        this.description = settings.description;
        this.defaultValue = settings.defaultValue;
        this.name = settings.name || settings.id;
        this.devOnly = settings.devOnly || false;
    }
    get() {
        switch (this.state) {
            case OverrideState.TRUE:
                return true;
            case OverrideState.FALSE:
                return false;
            case OverrideState.DEFAULT:
            default:
                return this.defaultValue;
        }
    }
    set(value) {
        const next = value ? OverrideState.TRUE : OverrideState.FALSE;
        if (this.state === next) {
            return;
        }
        this.state = next;
        this.registry.save();
    }
    overriddenState() {
        return this.state;
    }
    reset() {
        this.state = OverrideState.DEFAULT;
        this.registry.save();
    }
    isOverridden() {
        return this.state !== OverrideState.DEFAULT;
    }
}
class LocalStorageStore {
    load() {
        const s = localStorage.getItem(LocalStorageStore.KEY);
        let parsed;
        try {
            parsed = JSON.parse(s || '{}');
        }
        catch (e) {
            return {};
        }
        if (typeof parsed !== 'object' || parsed === null) {
            return {};
        }
        return parsed;
    }
    save(o) {
        const s = JSON.stringify(o);
        localStorage.setItem(LocalStorageStore.KEY, s);
    }
}
LocalStorageStore.KEY = 'perfettoFeatureFlags';
exports.FlagsForTesting = Flags;
exports.featureFlags = new Flags(new LocalStorageStore());
exports.PERF_SAMPLE_FLAG = exports.featureFlags.register({
    id: 'perfSampleFlamegraph',
    name: 'Perf Sample Flamegraph',
    description: 'Show flamegraph generated by a perf sample.',
    defaultValue: true,
});
exports.RECORDING_V2_FLAG = exports.featureFlags.register({
    id: 'recordingv2',
    name: 'Recording V2',
    description: 'Record using V2 interface',
    defaultValue: false,
});

});

var empty_state = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEmptyState = exports.createEmptyNonSerializableState = exports.COUNT_AGGREGATION = exports.keyedMap = void 0;




const AUTOLOAD_STARTED_CONFIG_FLAG = feature_flags.featureFlags.register({
    id: 'autoloadStartedConfig',
    name: 'Auto-load last used recording config',
    description: 'Starting a recording automatically saves its configuration. ' +
        'This flag controls whether this config is automatically loaded.',
    defaultValue: true,
});
function keyedMap(keyFn, ...values) {
    const result = new Map();
    for (const value of values) {
        result.set(keyFn(value), value);
    }
    return result;
}
exports.keyedMap = keyedMap;
exports.COUNT_AGGREGATION = {
    aggregationFunction: 'COUNT',
    // Exact column is ignored for count aggregation because it does not matter
    // what to count, use empty strings.
    column: { kind: 'regular', table: '', column: '' },
};
function createEmptyNonSerializableState() {
    return {
        pivotTableRedux: {
            queryResult: null,
            selectedSlicePivots: [{ kind: 'regular', table: 'slice', column: 'name' }],
            selectedPivots: [],
            selectedAggregations: [
                {
                    aggregationFunction: 'SUM',
                    column: { kind: 'regular', table: 'slice', column: 'dur' },
                },
                {
                    aggregationFunction: 'SUM',
                    column: { kind: 'regular', table: 'slice', column: 'thread_dur' },
                },
                exports.COUNT_AGGREGATION,
            ],
            constrainToArea: true,
            queryRequested: false,
            argumentNames: [],
            sortCriteria: {
                column: { kind: 'regular', table: 'slice', column: 'dur' },
                order: 'DESC',
            },
        },
    };
}
exports.createEmptyNonSerializableState = createEmptyNonSerializableState;
function createEmptyState() {
    return {
        version: state.STATE_VERSION,
        currentEngineId: undefined,
        nextId: '-1',
        newEngineMode: 'USE_HTTP_RPC_IF_AVAILABLE',
        engines: {},
        traceTime: Object.assign({}, state.defaultTraceTime),
        tracks: {},
        uiTrackIdByTraceTrackId: {},
        utidToThreadSortKey: {},
        aggregatePreferences: {},
        trackGroups: {},
        visibleTracks: [],
        pinnedTracks: [],
        scrollingTracks: [],
        areas: {},
        queries: {},
        metrics: {},
        permalink: {},
        notes: {},
        visualisedArgs: [],
        recordConfig: AUTOLOAD_STARTED_CONFIG_FLAG.get() ?
            record_config.autosaveConfigStore.get() :
            (0, record_config_types.createEmptyRecordConfig)(),
        displayConfigAsPbtxt: false,
        lastLoadedConfig: { type: 'NONE' },
        frontendLocalState: {
            omniboxState: {
                lastUpdate: 0,
                omnibox: '',
                mode: 'SEARCH',
            },
            visibleState: Object.assign(Object.assign({}, state.defaultTraceTime), { lastUpdate: 0, resolution: 0 }),
        },
        logsPagination: {
            offset: 0,
            count: 0,
        },
        status: { msg: '', timestamp: 0 },
        currentSelection: null,
        currentFlamegraphState: null,
        traceConversionInProgress: false,
        perfDebug: false,
        sidebarVisible: true,
        hoveredUtid: -1,
        hoveredPid: -1,
        hoveredLogsTimestamp: -1,
        hoveredNoteTimestamp: -1,
        highlightedSliceId: -1,
        focusedFlowIdLeft: -1,
        focusedFlowIdRight: -1,
        searchIndex: -1,
        recordingInProgress: false,
        recordingCancelled: false,
        extensionInstalled: false,
        flamegraphModalDismissed: false,
        recordingTarget: record_config.recordTargetStore.getValidTarget(),
        availableAdbDevices: [],
        fetchChromeCategories: false,
        chromeCategories: undefined,
        nonSerializableState: createEmptyNonSerializableState(),
    };
}
exports.createEmptyState = createEmptyState;

});

var channels = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.setChannel = exports.channelChanged = exports.getNextChannel = exports.getCurrentChannel = exports.DEFAULT_CHANNEL = void 0;

exports.DEFAULT_CHANNEL = 'stable';
const CHANNEL_KEY = 'perfettoUiChannel';
let currentChannel = undefined;
let nextChannel = undefined;
// This is the channel the UI is currently running. It doesn't change once the
// UI has been loaded.
function getCurrentChannel() {
    if (currentChannel === undefined) {
        currentChannel = localStorage.getItem(CHANNEL_KEY) || exports.DEFAULT_CHANNEL;
    }
    return currentChannel;
}
exports.getCurrentChannel = getCurrentChannel;
// This is the channel that will be applied on reload.
function getNextChannel() {
    if (nextChannel !== undefined) {
        return nextChannel;
    }
    return getCurrentChannel();
}
exports.getNextChannel = getNextChannel;
function channelChanged() {
    return getCurrentChannel() !== getNextChannel();
}
exports.channelChanged = channelChanged;
function setChannel(channel) {
    getCurrentChannel(); // Cache the current channel before mangling next one.
    nextChannel = channel;
    localStorage.setItem(CHANNEL_KEY, channel);
    globals.globals.rafScheduler.scheduleFullRedraw();
}
exports.setChannel = setChannel;

});

function Vnode(tag, key, attrs, children, text, dom) {
	return {tag: tag, key: key, attrs: attrs, children: children, text: text, dom: dom, domSize: undefined, state: undefined, events: undefined, instance: undefined}
}
Vnode.normalize = function(node) {
	if (Array.isArray(node)) return Vnode("[", undefined, undefined, Vnode.normalizeChildren(node), undefined, undefined)
	if (node == null || typeof node === "boolean") return null
	if (typeof node === "object") return node
	return Vnode("#", undefined, undefined, String(node), undefined, undefined)
};
Vnode.normalizeChildren = function(input) {
	var children = [];
	if (input.length) {
		var isKeyed = input[0] != null && input[0].key != null;
		// Note: this is a *very* perf-sensitive check.
		// Fun fact: merging the loop like this is somehow faster than splitting
		// it, noticeably so.
		for (var i = 1; i < input.length; i++) {
			if ((input[i] != null && input[i].key != null) !== isKeyed) {
				throw new TypeError(
					isKeyed && (input[i] != null || typeof input[i] === "boolean")
						? "In fragments, vnodes must either all have keys or none have keys. You may wish to consider using an explicit keyed empty fragment, m.fragment({key: ...}), instead of a hole."
						: "In fragments, vnodes must either all have keys or none have keys."
				)
			}
		}
		for (var i = 0; i < input.length; i++) {
			children[i] = Vnode.normalize(input[i]);
		}
	}
	return children
};

var vnode = Vnode;

// Call via `hyperscriptVnode.apply(startOffset, arguments)`
//
// The reason I do it this way, forwarding the arguments and passing the start
// offset in `this`, is so I don't have to create a temporary array in a
// performance-critical path.
//
// In native ES6, I'd instead add a final `...args` parameter to the
// `hyperscript` and `fragment` factories and define this as
// `hyperscriptVnode(...args)`, since modern engines do optimize that away. But
// ES5 (what Mithril.js requires thanks to IE support) doesn't give me that luxury,
// and engines aren't nearly intelligent enough to do either of these:
//
// 1. Elide the allocation for `[].slice.call(arguments, 1)` when it's passed to
//    another function only to be indexed.
// 2. Elide an `arguments` allocation when it's passed to any function other
//    than `Function.prototype.apply` or `Reflect.apply`.
//
// In ES6, it'd probably look closer to this (I'd need to profile it, though):
// module.exports = function(attrs, ...children) {
//     if (attrs == null || typeof attrs === "object" && attrs.tag == null && !Array.isArray(attrs)) {
//         if (children.length === 1 && Array.isArray(children[0])) children = children[0]
//     } else {
//         children = children.length === 0 && Array.isArray(attrs) ? attrs : [attrs, ...children]
//         attrs = undefined
//     }
//
//     if (attrs == null) attrs = {}
//     return Vnode("", attrs.key, attrs, children)
// }
var hyperscriptVnode = function() {
	var attrs = arguments[this], start = this + 1, children;

	if (attrs == null) {
		attrs = {};
	} else if (typeof attrs !== "object" || attrs.tag != null || Array.isArray(attrs)) {
		attrs = {};
		start = this;
	}

	if (arguments.length === start + 1) {
		children = arguments[start];
		if (!Array.isArray(children)) children = [children];
	} else {
		children = [];
		while (start < arguments.length) children.push(arguments[start++]);
	}

	return vnode("", attrs.key, attrs, children)
};

// This exists so I'm only saving it once.

var hasOwn = {}.hasOwnProperty;

var selectorParser = /(?:(^|#|\.)([^#\.\[\]]+))|(\[(.+?)(?:\s*=\s*("|'|)((?:\\["'\]]|.)*?)\5)?\])/g;
var selectorCache = {};

function isEmpty(object) {
	for (var key in object) if (hasOwn.call(object, key)) return false
	return true
}

function compileSelector(selector) {
	var match, tag = "div", classes = [], attrs = {};
	while (match = selectorParser.exec(selector)) {
		var type = match[1], value = match[2];
		if (type === "" && value !== "") tag = value;
		else if (type === "#") attrs.id = value;
		else if (type === ".") classes.push(value);
		else if (match[3][0] === "[") {
			var attrValue = match[6];
			if (attrValue) attrValue = attrValue.replace(/\\(["'])/g, "$1").replace(/\\\\/g, "\\");
			if (match[4] === "class") classes.push(attrValue);
			else attrs[match[4]] = attrValue === "" ? attrValue : attrValue || true;
		}
	}
	if (classes.length > 0) attrs.className = classes.join(" ");
	return selectorCache[selector] = {tag: tag, attrs: attrs}
}

function execSelector(state, vnode) {
	var attrs = vnode.attrs;
	var hasClass = hasOwn.call(attrs, "class");
	var className = hasClass ? attrs.class : attrs.className;

	vnode.tag = state.tag;
	vnode.attrs = {};

	if (!isEmpty(state.attrs) && !isEmpty(attrs)) {
		var newAttrs = {};

		for (var key in attrs) {
			if (hasOwn.call(attrs, key)) newAttrs[key] = attrs[key];
		}

		attrs = newAttrs;
	}

	for (var key in state.attrs) {
		if (hasOwn.call(state.attrs, key) && key !== "className" && !hasOwn.call(attrs, key)){
			attrs[key] = state.attrs[key];
		}
	}
	if (className != null || state.attrs.className != null) attrs.className =
		className != null
			? state.attrs.className != null
				? String(state.attrs.className) + " " + String(className)
				: className
			: state.attrs.className != null
				? state.attrs.className
				: null;

	if (hasClass) attrs.class = null;

	for (var key in attrs) {
		if (hasOwn.call(attrs, key) && key !== "key") {
			vnode.attrs = attrs;
			break
		}
	}

	return vnode
}

function hyperscript(selector) {
	if (selector == null || typeof selector !== "string" && typeof selector !== "function" && typeof selector.view !== "function") {
		throw Error("The selector must be either a string or a component.");
	}

	var vnode$1 = hyperscriptVnode.apply(1, arguments);

	if (typeof selector === "string") {
		vnode$1.children = vnode.normalizeChildren(vnode$1.children);
		if (selector !== "[") return execSelector(selectorCache[selector] || compileSelector(selector), vnode$1)
	}

	vnode$1.tag = selector;
	return vnode$1
}

var hyperscript_1 = hyperscript;

var trust = function(html) {
	if (html == null) html = "";
	return vnode("<", undefined, undefined, html, undefined, undefined)
};

var fragment = function() {
	var vnode$1 = hyperscriptVnode.apply(0, arguments);

	vnode$1.tag = "[";
	vnode$1.children = vnode.normalizeChildren(vnode$1.children);
	return vnode$1
};

hyperscript_1.trust = trust;
hyperscript_1.fragment = fragment;

var hyperscript_1$1 = hyperscript_1;

/** @constructor */
var PromisePolyfill = function(executor) {
	if (!(this instanceof PromisePolyfill)) throw new Error("Promise must be called with 'new'.")
	if (typeof executor !== "function") throw new TypeError("executor must be a function.")

	var self = this, resolvers = [], rejectors = [], resolveCurrent = handler(resolvers, true), rejectCurrent = handler(rejectors, false);
	var instance = self._instance = {resolvers: resolvers, rejectors: rejectors};
	var callAsync = typeof setImmediate === "function" ? setImmediate : setTimeout;
	function handler(list, shouldAbsorb) {
		return function execute(value) {
			var then;
			try {
				if (shouldAbsorb && value != null && (typeof value === "object" || typeof value === "function") && typeof (then = value.then) === "function") {
					if (value === self) throw new TypeError("Promise can't be resolved with itself.")
					executeOnce(then.bind(value));
				}
				else {
					callAsync(function() {
						if (!shouldAbsorb && list.length === 0) console.error("Possible unhandled promise rejection:", value);
						for (var i = 0; i < list.length; i++) list[i](value);
						resolvers.length = 0, rejectors.length = 0;
						instance.state = shouldAbsorb;
						instance.retry = function() {execute(value);};
					});
				}
			}
			catch (e) {
				rejectCurrent(e);
			}
		}
	}
	function executeOnce(then) {
		var runs = 0;
		function run(fn) {
			return function(value) {
				if (runs++ > 0) return
				fn(value);
			}
		}
		var onerror = run(rejectCurrent);
		try {then(run(resolveCurrent), onerror);} catch (e) {onerror(e);}
	}

	executeOnce(executor);
};
PromisePolyfill.prototype.then = function(onFulfilled, onRejection) {
	var self = this, instance = self._instance;
	function handle(callback, list, next, state) {
		list.push(function(value) {
			if (typeof callback !== "function") next(value);
			else try {resolveNext(callback(value));} catch (e) {if (rejectNext) rejectNext(e);}
		});
		if (typeof instance.retry === "function" && state === instance.state) instance.retry();
	}
	var resolveNext, rejectNext;
	var promise = new PromisePolyfill(function(resolve, reject) {resolveNext = resolve, rejectNext = reject;});
	handle(onFulfilled, instance.resolvers, resolveNext, true), handle(onRejection, instance.rejectors, rejectNext, false);
	return promise
};
PromisePolyfill.prototype.catch = function(onRejection) {
	return this.then(null, onRejection)
};
PromisePolyfill.prototype.finally = function(callback) {
	return this.then(
		function(value) {
			return PromisePolyfill.resolve(callback()).then(function() {
				return value
			})
		},
		function(reason) {
			return PromisePolyfill.resolve(callback()).then(function() {
				return PromisePolyfill.reject(reason);
			})
		}
	)
};
PromisePolyfill.resolve = function(value) {
	if (value instanceof PromisePolyfill) return value
	return new PromisePolyfill(function(resolve) {resolve(value);})
};
PromisePolyfill.reject = function(value) {
	return new PromisePolyfill(function(resolve, reject) {reject(value);})
};
PromisePolyfill.all = function(list) {
	return new PromisePolyfill(function(resolve, reject) {
		var total = list.length, count = 0, values = [];
		if (list.length === 0) resolve([]);
		else for (var i = 0; i < list.length; i++) {
			(function(i) {
				function consume(value) {
					count++;
					values[i] = value;
					if (count === total) resolve(values);
				}
				if (list[i] != null && (typeof list[i] === "object" || typeof list[i] === "function") && typeof list[i].then === "function") {
					list[i].then(consume, reject);
				}
				else consume(list[i]);
			})(i);
		}
	})
};
PromisePolyfill.race = function(list) {
	return new PromisePolyfill(function(resolve, reject) {
		for (var i = 0; i < list.length; i++) {
			list[i].then(resolve, reject);
		}
	})
};

var polyfill = PromisePolyfill;

var promise = createCommonjsModule(function (module) {



if (typeof window !== "undefined") {
	if (typeof window.Promise === "undefined") {
		window.Promise = polyfill;
	} else if (!window.Promise.prototype.finally) {
		window.Promise.prototype.finally = polyfill.prototype.finally;
	}
	module.exports = window.Promise;
} else if (typeof commonjsGlobal !== "undefined") {
	if (typeof commonjsGlobal.Promise === "undefined") {
		commonjsGlobal.Promise = polyfill;
	} else if (!commonjsGlobal.Promise.prototype.finally) {
		commonjsGlobal.Promise.prototype.finally = polyfill.prototype.finally;
	}
	module.exports = commonjsGlobal.Promise;
} else {
	module.exports = polyfill;
}
});

var render = function($window) {
	var $doc = $window && $window.document;
	var currentRedraw;

	var nameSpace = {
		svg: "http://www.w3.org/2000/svg",
		math: "http://www.w3.org/1998/Math/MathML"
	};

	function getNameSpace(vnode) {
		return vnode.attrs && vnode.attrs.xmlns || nameSpace[vnode.tag]
	}

	//sanity check to discourage people from doing `vnode.state = ...`
	function checkState(vnode, original) {
		if (vnode.state !== original) throw new Error("'vnode.state' must not be modified.")
	}

	//Note: the hook is passed as the `this` argument to allow proxying the
	//arguments without requiring a full array allocation to do so. It also
	//takes advantage of the fact the current `vnode` is the first argument in
	//all lifecycle methods.
	function callHook(vnode) {
		var original = vnode.state;
		try {
			return this.apply(original, arguments)
		} finally {
			checkState(vnode, original);
		}
	}

	// IE11 (at least) throws an UnspecifiedError when accessing document.activeElement when
	// inside an iframe. Catch and swallow this error, and heavy-handidly return null.
	function activeElement() {
		try {
			return $doc.activeElement
		} catch (e) {
			return null
		}
	}
	//create
	function createNodes(parent, vnodes, start, end, hooks, nextSibling, ns) {
		for (var i = start; i < end; i++) {
			var vnode = vnodes[i];
			if (vnode != null) {
				createNode(parent, vnode, hooks, ns, nextSibling);
			}
		}
	}
	function createNode(parent, vnode, hooks, ns, nextSibling) {
		var tag = vnode.tag;
		if (typeof tag === "string") {
			vnode.state = {};
			if (vnode.attrs != null) initLifecycle(vnode.attrs, vnode, hooks);
			switch (tag) {
				case "#": createText(parent, vnode, nextSibling); break
				case "<": createHTML(parent, vnode, ns, nextSibling); break
				case "[": createFragment(parent, vnode, hooks, ns, nextSibling); break
				default: createElement(parent, vnode, hooks, ns, nextSibling);
			}
		}
		else createComponent(parent, vnode, hooks, ns, nextSibling);
	}
	function createText(parent, vnode, nextSibling) {
		vnode.dom = $doc.createTextNode(vnode.children);
		insertNode(parent, vnode.dom, nextSibling);
	}
	var possibleParents = {caption: "table", thead: "table", tbody: "table", tfoot: "table", tr: "tbody", th: "tr", td: "tr", colgroup: "table", col: "colgroup"};
	function createHTML(parent, vnode, ns, nextSibling) {
		var match = vnode.children.match(/^\s*?<(\w+)/im) || [];
		// not using the proper parent makes the child element(s) vanish.
		//     var div = document.createElement("div")
		//     div.innerHTML = "<td>i</td><td>j</td>"
		//     console.log(div.innerHTML)
		// --> "ij", no <td> in sight.
		var temp = $doc.createElement(possibleParents[match[1]] || "div");
		if (ns === "http://www.w3.org/2000/svg") {
			temp.innerHTML = "<svg xmlns=\"http://www.w3.org/2000/svg\">" + vnode.children + "</svg>";
			temp = temp.firstChild;
		} else {
			temp.innerHTML = vnode.children;
		}
		vnode.dom = temp.firstChild;
		vnode.domSize = temp.childNodes.length;
		// Capture nodes to remove, so we don't confuse them.
		vnode.instance = [];
		var fragment = $doc.createDocumentFragment();
		var child;
		while (child = temp.firstChild) {
			vnode.instance.push(child);
			fragment.appendChild(child);
		}
		insertNode(parent, fragment, nextSibling);
	}
	function createFragment(parent, vnode, hooks, ns, nextSibling) {
		var fragment = $doc.createDocumentFragment();
		if (vnode.children != null) {
			var children = vnode.children;
			createNodes(fragment, children, 0, children.length, hooks, null, ns);
		}
		vnode.dom = fragment.firstChild;
		vnode.domSize = fragment.childNodes.length;
		insertNode(parent, fragment, nextSibling);
	}
	function createElement(parent, vnode, hooks, ns, nextSibling) {
		var tag = vnode.tag;
		var attrs = vnode.attrs;
		var is = attrs && attrs.is;

		ns = getNameSpace(vnode) || ns;

		var element = ns ?
			is ? $doc.createElementNS(ns, tag, {is: is}) : $doc.createElementNS(ns, tag) :
			is ? $doc.createElement(tag, {is: is}) : $doc.createElement(tag);
		vnode.dom = element;

		if (attrs != null) {
			setAttrs(vnode, attrs, ns);
		}

		insertNode(parent, element, nextSibling);

		if (!maybeSetContentEditable(vnode)) {
			if (vnode.children != null) {
				var children = vnode.children;
				createNodes(element, children, 0, children.length, hooks, null, ns);
				if (vnode.tag === "select" && attrs != null) setLateSelectAttrs(vnode, attrs);
			}
		}
	}
	function initComponent(vnode$1, hooks) {
		var sentinel;
		if (typeof vnode$1.tag.view === "function") {
			vnode$1.state = Object.create(vnode$1.tag);
			sentinel = vnode$1.state.view;
			if (sentinel.$$reentrantLock$$ != null) return
			sentinel.$$reentrantLock$$ = true;
		} else {
			vnode$1.state = void 0;
			sentinel = vnode$1.tag;
			if (sentinel.$$reentrantLock$$ != null) return
			sentinel.$$reentrantLock$$ = true;
			vnode$1.state = (vnode$1.tag.prototype != null && typeof vnode$1.tag.prototype.view === "function") ? new vnode$1.tag(vnode$1) : vnode$1.tag(vnode$1);
		}
		initLifecycle(vnode$1.state, vnode$1, hooks);
		if (vnode$1.attrs != null) initLifecycle(vnode$1.attrs, vnode$1, hooks);
		vnode$1.instance = vnode.normalize(callHook.call(vnode$1.state.view, vnode$1));
		if (vnode$1.instance === vnode$1) throw Error("A view cannot return the vnode it received as argument")
		sentinel.$$reentrantLock$$ = null;
	}
	function createComponent(parent, vnode, hooks, ns, nextSibling) {
		initComponent(vnode, hooks);
		if (vnode.instance != null) {
			createNode(parent, vnode.instance, hooks, ns, nextSibling);
			vnode.dom = vnode.instance.dom;
			vnode.domSize = vnode.dom != null ? vnode.instance.domSize : 0;
		}
		else {
			vnode.domSize = 0;
		}
	}

	//update
	/**
	 * @param {Element|Fragment} parent - the parent element
	 * @param {Vnode[] | null} old - the list of vnodes of the last `render()` call for
	 *                               this part of the tree
	 * @param {Vnode[] | null} vnodes - as above, but for the current `render()` call.
	 * @param {Function[]} hooks - an accumulator of post-render hooks (oncreate/onupdate)
	 * @param {Element | null} nextSibling - the next DOM node if we're dealing with a
	 *                                       fragment that is not the last item in its
	 *                                       parent
	 * @param {'svg' | 'math' | String | null} ns) - the current XML namespace, if any
	 * @returns void
	 */
	// This function diffs and patches lists of vnodes, both keyed and unkeyed.
	//
	// We will:
	//
	// 1. describe its general structure
	// 2. focus on the diff algorithm optimizations
	// 3. discuss DOM node operations.

	// ## Overview:
	//
	// The updateNodes() function:
	// - deals with trivial cases
	// - determines whether the lists are keyed or unkeyed based on the first non-null node
	//   of each list.
	// - diffs them and patches the DOM if needed (that's the brunt of the code)
	// - manages the leftovers: after diffing, are there:
	//   - old nodes left to remove?
	// 	 - new nodes to insert?
	// 	 deal with them!
	//
	// The lists are only iterated over once, with an exception for the nodes in `old` that
	// are visited in the fourth part of the diff and in the `removeNodes` loop.

	// ## Diffing
	//
	// Reading https://github.com/localvoid/ivi/blob/ddc09d06abaef45248e6133f7040d00d3c6be853/packages/ivi/src/vdom/implementation.ts#L617-L837
	// may be good for context on longest increasing subsequence-based logic for moving nodes.
	//
	// In order to diff keyed lists, one has to
	//
	// 1) match nodes in both lists, per key, and update them accordingly
	// 2) create the nodes present in the new list, but absent in the old one
	// 3) remove the nodes present in the old list, but absent in the new one
	// 4) figure out what nodes in 1) to move in order to minimize the DOM operations.
	//
	// To achieve 1) one can create a dictionary of keys => index (for the old list), then iterate
	// over the new list and for each new vnode, find the corresponding vnode in the old list using
	// the map.
	// 2) is achieved in the same step: if a new node has no corresponding entry in the map, it is new
	// and must be created.
	// For the removals, we actually remove the nodes that have been updated from the old list.
	// The nodes that remain in that list after 1) and 2) have been performed can be safely removed.
	// The fourth step is a bit more complex and relies on the longest increasing subsequence (LIS)
	// algorithm.
	//
	// the longest increasing subsequence is the list of nodes that can remain in place. Imagine going
	// from `1,2,3,4,5` to `4,5,1,2,3` where the numbers are not necessarily the keys, but the indices
	// corresponding to the keyed nodes in the old list (keyed nodes `e,d,c,b,a` => `b,a,e,d,c` would
	//  match the above lists, for example).
	//
	// In there are two increasing subsequences: `4,5` and `1,2,3`, the latter being the longest. We
	// can update those nodes without moving them, and only call `insertNode` on `4` and `5`.
	//
	// @localvoid adapted the algo to also support node deletions and insertions (the `lis` is actually
	// the longest increasing subsequence *of old nodes still present in the new list*).
	//
	// It is a general algorithm that is fireproof in all circumstances, but it requires the allocation
	// and the construction of a `key => oldIndex` map, and three arrays (one with `newIndex => oldIndex`,
	// the `LIS` and a temporary one to create the LIS).
	//
	// So we cheat where we can: if the tails of the lists are identical, they are guaranteed to be part of
	// the LIS and can be updated without moving them.
	//
	// If two nodes are swapped, they are guaranteed not to be part of the LIS, and must be moved (with
	// the exception of the last node if the list is fully reversed).
	//
	// ## Finding the next sibling.
	//
	// `updateNode()` and `createNode()` expect a nextSibling parameter to perform DOM operations.
	// When the list is being traversed top-down, at any index, the DOM nodes up to the previous
	// vnode reflect the content of the new list, whereas the rest of the DOM nodes reflect the old
	// list. The next sibling must be looked for in the old list using `getNextSibling(... oldStart + 1 ...)`.
	//
	// In the other scenarios (swaps, upwards traversal, map-based diff),
	// the new vnodes list is traversed upwards. The DOM nodes at the bottom of the list reflect the
	// bottom part of the new vnodes list, and we can use the `v.dom`  value of the previous node
	// as the next sibling (cached in the `nextSibling` variable).


	// ## DOM node moves
	//
	// In most scenarios `updateNode()` and `createNode()` perform the DOM operations. However,
	// this is not the case if the node moved (second and fourth part of the diff algo). We move
	// the old DOM nodes before updateNode runs because it enables us to use the cached `nextSibling`
	// variable rather than fetching it using `getNextSibling()`.
	//
	// The fourth part of the diff currently inserts nodes unconditionally, leading to issues
	// like #1791 and #1999. We need to be smarter about those situations where adjascent old
	// nodes remain together in the new list in a way that isn't covered by parts one and
	// three of the diff algo.

	function updateNodes(parent, old, vnodes, hooks, nextSibling, ns) {
		if (old === vnodes || old == null && vnodes == null) return
		else if (old == null || old.length === 0) createNodes(parent, vnodes, 0, vnodes.length, hooks, nextSibling, ns);
		else if (vnodes == null || vnodes.length === 0) removeNodes(parent, old, 0, old.length);
		else {
			var isOldKeyed = old[0] != null && old[0].key != null;
			var isKeyed = vnodes[0] != null && vnodes[0].key != null;
			var start = 0, oldStart = 0;
			if (!isOldKeyed) while (oldStart < old.length && old[oldStart] == null) oldStart++;
			if (!isKeyed) while (start < vnodes.length && vnodes[start] == null) start++;
			if (isOldKeyed !== isKeyed) {
				removeNodes(parent, old, oldStart, old.length);
				createNodes(parent, vnodes, start, vnodes.length, hooks, nextSibling, ns);
			} else if (!isKeyed) {
				// Don't index past the end of either list (causes deopts).
				var commonLength = old.length < vnodes.length ? old.length : vnodes.length;
				// Rewind if necessary to the first non-null index on either side.
				// We could alternatively either explicitly create or remove nodes when `start !== oldStart`
				// but that would be optimizing for sparse lists which are more rare than dense ones.
				start = start < oldStart ? start : oldStart;
				for (; start < commonLength; start++) {
					o = old[start];
					v = vnodes[start];
					if (o === v || o == null && v == null) continue
					else if (o == null) createNode(parent, v, hooks, ns, getNextSibling(old, start + 1, nextSibling));
					else if (v == null) removeNode(parent, o);
					else updateNode(parent, o, v, hooks, getNextSibling(old, start + 1, nextSibling), ns);
				}
				if (old.length > commonLength) removeNodes(parent, old, start, old.length);
				if (vnodes.length > commonLength) createNodes(parent, vnodes, start, vnodes.length, hooks, nextSibling, ns);
			} else {
				// keyed diff
				var oldEnd = old.length - 1, end = vnodes.length - 1, map, o, v, oe, ve, topSibling;

				// bottom-up
				while (oldEnd >= oldStart && end >= start) {
					oe = old[oldEnd];
					ve = vnodes[end];
					if (oe.key !== ve.key) break
					if (oe !== ve) updateNode(parent, oe, ve, hooks, nextSibling, ns);
					if (ve.dom != null) nextSibling = ve.dom;
					oldEnd--, end--;
				}
				// top-down
				while (oldEnd >= oldStart && end >= start) {
					o = old[oldStart];
					v = vnodes[start];
					if (o.key !== v.key) break
					oldStart++, start++;
					if (o !== v) updateNode(parent, o, v, hooks, getNextSibling(old, oldStart, nextSibling), ns);
				}
				// swaps and list reversals
				while (oldEnd >= oldStart && end >= start) {
					if (start === end) break
					if (o.key !== ve.key || oe.key !== v.key) break
					topSibling = getNextSibling(old, oldStart, nextSibling);
					moveNodes(parent, oe, topSibling);
					if (oe !== v) updateNode(parent, oe, v, hooks, topSibling, ns);
					if (++start <= --end) moveNodes(parent, o, nextSibling);
					if (o !== ve) updateNode(parent, o, ve, hooks, nextSibling, ns);
					if (ve.dom != null) nextSibling = ve.dom;
					oldStart++; oldEnd--;
					oe = old[oldEnd];
					ve = vnodes[end];
					o = old[oldStart];
					v = vnodes[start];
				}
				// bottom up once again
				while (oldEnd >= oldStart && end >= start) {
					if (oe.key !== ve.key) break
					if (oe !== ve) updateNode(parent, oe, ve, hooks, nextSibling, ns);
					if (ve.dom != null) nextSibling = ve.dom;
					oldEnd--, end--;
					oe = old[oldEnd];
					ve = vnodes[end];
				}
				if (start > end) removeNodes(parent, old, oldStart, oldEnd + 1);
				else if (oldStart > oldEnd) createNodes(parent, vnodes, start, end + 1, hooks, nextSibling, ns);
				else {
					// inspired by ivi https://github.com/ivijs/ivi/ by Boris Kaul
					var originalNextSibling = nextSibling, vnodesLength = end - start + 1, oldIndices = new Array(vnodesLength), li=0, i=0, pos = 2147483647, matched = 0, map, lisIndices;
					for (i = 0; i < vnodesLength; i++) oldIndices[i] = -1;
					for (i = end; i >= start; i--) {
						if (map == null) map = getKeyMap(old, oldStart, oldEnd + 1);
						ve = vnodes[i];
						var oldIndex = map[ve.key];
						if (oldIndex != null) {
							pos = (oldIndex < pos) ? oldIndex : -1; // becomes -1 if nodes were re-ordered
							oldIndices[i-start] = oldIndex;
							oe = old[oldIndex];
							old[oldIndex] = null;
							if (oe !== ve) updateNode(parent, oe, ve, hooks, nextSibling, ns);
							if (ve.dom != null) nextSibling = ve.dom;
							matched++;
						}
					}
					nextSibling = originalNextSibling;
					if (matched !== oldEnd - oldStart + 1) removeNodes(parent, old, oldStart, oldEnd + 1);
					if (matched === 0) createNodes(parent, vnodes, start, end + 1, hooks, nextSibling, ns);
					else {
						if (pos === -1) {
							// the indices of the indices of the items that are part of the
							// longest increasing subsequence in the oldIndices list
							lisIndices = makeLisIndices(oldIndices);
							li = lisIndices.length - 1;
							for (i = end; i >= start; i--) {
								v = vnodes[i];
								if (oldIndices[i-start] === -1) createNode(parent, v, hooks, ns, nextSibling);
								else {
									if (lisIndices[li] === i - start) li--;
									else moveNodes(parent, v, nextSibling);
								}
								if (v.dom != null) nextSibling = vnodes[i].dom;
							}
						} else {
							for (i = end; i >= start; i--) {
								v = vnodes[i];
								if (oldIndices[i-start] === -1) createNode(parent, v, hooks, ns, nextSibling);
								if (v.dom != null) nextSibling = vnodes[i].dom;
							}
						}
					}
				}
			}
		}
	}
	function updateNode(parent, old, vnode, hooks, nextSibling, ns) {
		var oldTag = old.tag, tag = vnode.tag;
		if (oldTag === tag) {
			vnode.state = old.state;
			vnode.events = old.events;
			if (shouldNotUpdate(vnode, old)) return
			if (typeof oldTag === "string") {
				if (vnode.attrs != null) {
					updateLifecycle(vnode.attrs, vnode, hooks);
				}
				switch (oldTag) {
					case "#": updateText(old, vnode); break
					case "<": updateHTML(parent, old, vnode, ns, nextSibling); break
					case "[": updateFragment(parent, old, vnode, hooks, nextSibling, ns); break
					default: updateElement(old, vnode, hooks, ns);
				}
			}
			else updateComponent(parent, old, vnode, hooks, nextSibling, ns);
		}
		else {
			removeNode(parent, old);
			createNode(parent, vnode, hooks, ns, nextSibling);
		}
	}
	function updateText(old, vnode) {
		if (old.children.toString() !== vnode.children.toString()) {
			old.dom.nodeValue = vnode.children;
		}
		vnode.dom = old.dom;
	}
	function updateHTML(parent, old, vnode, ns, nextSibling) {
		if (old.children !== vnode.children) {
			removeHTML(parent, old);
			createHTML(parent, vnode, ns, nextSibling);
		}
		else {
			vnode.dom = old.dom;
			vnode.domSize = old.domSize;
			vnode.instance = old.instance;
		}
	}
	function updateFragment(parent, old, vnode, hooks, nextSibling, ns) {
		updateNodes(parent, old.children, vnode.children, hooks, nextSibling, ns);
		var domSize = 0, children = vnode.children;
		vnode.dom = null;
		if (children != null) {
			for (var i = 0; i < children.length; i++) {
				var child = children[i];
				if (child != null && child.dom != null) {
					if (vnode.dom == null) vnode.dom = child.dom;
					domSize += child.domSize || 1;
				}
			}
			if (domSize !== 1) vnode.domSize = domSize;
		}
	}
	function updateElement(old, vnode, hooks, ns) {
		var element = vnode.dom = old.dom;
		ns = getNameSpace(vnode) || ns;

		if (vnode.tag === "textarea") {
			if (vnode.attrs == null) vnode.attrs = {};
		}
		updateAttrs(vnode, old.attrs, vnode.attrs, ns);
		if (!maybeSetContentEditable(vnode)) {
			updateNodes(element, old.children, vnode.children, hooks, null, ns);
		}
	}
	function updateComponent(parent, old, vnode$1, hooks, nextSibling, ns) {
		vnode$1.instance = vnode.normalize(callHook.call(vnode$1.state.view, vnode$1));
		if (vnode$1.instance === vnode$1) throw Error("A view cannot return the vnode it received as argument")
		updateLifecycle(vnode$1.state, vnode$1, hooks);
		if (vnode$1.attrs != null) updateLifecycle(vnode$1.attrs, vnode$1, hooks);
		if (vnode$1.instance != null) {
			if (old.instance == null) createNode(parent, vnode$1.instance, hooks, ns, nextSibling);
			else updateNode(parent, old.instance, vnode$1.instance, hooks, nextSibling, ns);
			vnode$1.dom = vnode$1.instance.dom;
			vnode$1.domSize = vnode$1.instance.domSize;
		}
		else if (old.instance != null) {
			removeNode(parent, old.instance);
			vnode$1.dom = undefined;
			vnode$1.domSize = 0;
		}
		else {
			vnode$1.dom = old.dom;
			vnode$1.domSize = old.domSize;
		}
	}
	function getKeyMap(vnodes, start, end) {
		var map = Object.create(null);
		for (; start < end; start++) {
			var vnode = vnodes[start];
			if (vnode != null) {
				var key = vnode.key;
				if (key != null) map[key] = start;
			}
		}
		return map
	}
	// Lifted from ivi https://github.com/ivijs/ivi/
	// takes a list of unique numbers (-1 is special and can
	// occur multiple times) and returns an array with the indices
	// of the items that are part of the longest increasing
	// subsequence
	var lisTemp = [];
	function makeLisIndices(a) {
		var result = [0];
		var u = 0, v = 0, i = 0;
		var il = lisTemp.length = a.length;
		for (var i = 0; i < il; i++) lisTemp[i] = a[i];
		for (var i = 0; i < il; ++i) {
			if (a[i] === -1) continue
			var j = result[result.length - 1];
			if (a[j] < a[i]) {
				lisTemp[i] = j;
				result.push(i);
				continue
			}
			u = 0;
			v = result.length - 1;
			while (u < v) {
				// Fast integer average without overflow.
				// eslint-disable-next-line no-bitwise
				var c = (u >>> 1) + (v >>> 1) + (u & v & 1);
				if (a[result[c]] < a[i]) {
					u = c + 1;
				}
				else {
					v = c;
				}
			}
			if (a[i] < a[result[u]]) {
				if (u > 0) lisTemp[i] = result[u - 1];
				result[u] = i;
			}
		}
		u = result.length;
		v = result[u - 1];
		while (u-- > 0) {
			result[u] = v;
			v = lisTemp[v];
		}
		lisTemp.length = 0;
		return result
	}

	function getNextSibling(vnodes, i, nextSibling) {
		for (; i < vnodes.length; i++) {
			if (vnodes[i] != null && vnodes[i].dom != null) return vnodes[i].dom
		}
		return nextSibling
	}

	// This covers a really specific edge case:
	// - Parent node is keyed and contains child
	// - Child is removed, returns unresolved promise in `onbeforeremove`
	// - Parent node is moved in keyed diff
	// - Remaining children still need moved appropriately
	//
	// Ideally, I'd track removed nodes as well, but that introduces a lot more
	// complexity and I'm not exactly interested in doing that.
	function moveNodes(parent, vnode, nextSibling) {
		var frag = $doc.createDocumentFragment();
		moveChildToFrag(parent, frag, vnode);
		insertNode(parent, frag, nextSibling);
	}
	function moveChildToFrag(parent, frag, vnode) {
		// Dodge the recursion overhead in a few of the most common cases.
		while (vnode.dom != null && vnode.dom.parentNode === parent) {
			if (typeof vnode.tag !== "string") {
				vnode = vnode.instance;
				if (vnode != null) continue
			} else if (vnode.tag === "<") {
				for (var i = 0; i < vnode.instance.length; i++) {
					frag.appendChild(vnode.instance[i]);
				}
			} else if (vnode.tag !== "[") {
				// Don't recurse for text nodes *or* elements, just fragments
				frag.appendChild(vnode.dom);
			} else if (vnode.children.length === 1) {
				vnode = vnode.children[0];
				if (vnode != null) continue
			} else {
				for (var i = 0; i < vnode.children.length; i++) {
					var child = vnode.children[i];
					if (child != null) moveChildToFrag(parent, frag, child);
				}
			}
			break
		}
	}

	function insertNode(parent, dom, nextSibling) {
		if (nextSibling != null) parent.insertBefore(dom, nextSibling);
		else parent.appendChild(dom);
	}

	function maybeSetContentEditable(vnode) {
		if (vnode.attrs == null || (
			vnode.attrs.contenteditable == null && // attribute
			vnode.attrs.contentEditable == null // property
		)) return false
		var children = vnode.children;
		if (children != null && children.length === 1 && children[0].tag === "<") {
			var content = children[0].children;
			if (vnode.dom.innerHTML !== content) vnode.dom.innerHTML = content;
		}
		else if (children != null && children.length !== 0) throw new Error("Child node of a contenteditable must be trusted.")
		return true
	}

	//remove
	function removeNodes(parent, vnodes, start, end) {
		for (var i = start; i < end; i++) {
			var vnode = vnodes[i];
			if (vnode != null) removeNode(parent, vnode);
		}
	}
	function removeNode(parent, vnode) {
		var mask = 0;
		var original = vnode.state;
		var stateResult, attrsResult;
		if (typeof vnode.tag !== "string" && typeof vnode.state.onbeforeremove === "function") {
			var result = callHook.call(vnode.state.onbeforeremove, vnode);
			if (result != null && typeof result.then === "function") {
				mask = 1;
				stateResult = result;
			}
		}
		if (vnode.attrs && typeof vnode.attrs.onbeforeremove === "function") {
			var result = callHook.call(vnode.attrs.onbeforeremove, vnode);
			if (result != null && typeof result.then === "function") {
				// eslint-disable-next-line no-bitwise
				mask |= 2;
				attrsResult = result;
			}
		}
		checkState(vnode, original);

		// If we can, try to fast-path it and avoid all the overhead of awaiting
		if (!mask) {
			onremove(vnode);
			removeChild(parent, vnode);
		} else {
			if (stateResult != null) {
				var next = function () {
					// eslint-disable-next-line no-bitwise
					if (mask & 1) { mask &= 2; if (!mask) reallyRemove(); }
				};
				stateResult.then(next, next);
			}
			if (attrsResult != null) {
				var next = function () {
					// eslint-disable-next-line no-bitwise
					if (mask & 2) { mask &= 1; if (!mask) reallyRemove(); }
				};
				attrsResult.then(next, next);
			}
		}

		function reallyRemove() {
			checkState(vnode, original);
			onremove(vnode);
			removeChild(parent, vnode);
		}
	}
	function removeHTML(parent, vnode) {
		for (var i = 0; i < vnode.instance.length; i++) {
			parent.removeChild(vnode.instance[i]);
		}
	}
	function removeChild(parent, vnode) {
		// Dodge the recursion overhead in a few of the most common cases.
		while (vnode.dom != null && vnode.dom.parentNode === parent) {
			if (typeof vnode.tag !== "string") {
				vnode = vnode.instance;
				if (vnode != null) continue
			} else if (vnode.tag === "<") {
				removeHTML(parent, vnode);
			} else {
				if (vnode.tag !== "[") {
					parent.removeChild(vnode.dom);
					if (!Array.isArray(vnode.children)) break
				}
				if (vnode.children.length === 1) {
					vnode = vnode.children[0];
					if (vnode != null) continue
				} else {
					for (var i = 0; i < vnode.children.length; i++) {
						var child = vnode.children[i];
						if (child != null) removeChild(parent, child);
					}
				}
			}
			break
		}
	}
	function onremove(vnode) {
		if (typeof vnode.tag !== "string" && typeof vnode.state.onremove === "function") callHook.call(vnode.state.onremove, vnode);
		if (vnode.attrs && typeof vnode.attrs.onremove === "function") callHook.call(vnode.attrs.onremove, vnode);
		if (typeof vnode.tag !== "string") {
			if (vnode.instance != null) onremove(vnode.instance);
		} else {
			var children = vnode.children;
			if (Array.isArray(children)) {
				for (var i = 0; i < children.length; i++) {
					var child = children[i];
					if (child != null) onremove(child);
				}
			}
		}
	}

	//attrs
	function setAttrs(vnode, attrs, ns) {
		// If you assign an input type that is not supported by IE 11 with an assignment expression, an error will occur.
		//
		// Also, the DOM does things to inputs based on the value, so it needs set first.
		// See: https://github.com/MithrilJS/mithril.js/issues/2622
		if (vnode.tag === "input" && attrs.type != null) vnode.dom.setAttribute("type", attrs.type);
		var isFileInput = attrs != null && vnode.tag === "input" && attrs.type === "file";
		for (var key in attrs) {
			setAttr(vnode, key, null, attrs[key], ns, isFileInput);
		}
	}
	function setAttr(vnode, key, old, value, ns, isFileInput) {
		if (key === "key" || key === "is" || value == null || isLifecycleMethod(key) || (old === value && !isFormAttribute(vnode, key)) && typeof value !== "object" || key === "type" && vnode.tag === "input") return
		if (key[0] === "o" && key[1] === "n") return updateEvent(vnode, key, value)
		if (key.slice(0, 6) === "xlink:") vnode.dom.setAttributeNS("http://www.w3.org/1999/xlink", key.slice(6), value);
		else if (key === "style") updateStyle(vnode.dom, old, value);
		else if (hasPropertyKey(vnode, key, ns)) {
			if (key === "value") {
				// Only do the coercion if we're actually going to check the value.
				/* eslint-disable no-implicit-coercion */
				//setting input[value] to same value by typing on focused element moves cursor to end in Chrome
				//setting input[type=file][value] to same value causes an error to be generated if it's non-empty
				if ((vnode.tag === "input" || vnode.tag === "textarea") && vnode.dom.value === "" + value && (isFileInput || vnode.dom === activeElement())) return
				//setting select[value] to same value while having select open blinks select dropdown in Chrome
				if (vnode.tag === "select" && old !== null && vnode.dom.value === "" + value) return
				//setting option[value] to same value while having select open blinks select dropdown in Chrome
				if (vnode.tag === "option" && old !== null && vnode.dom.value === "" + value) return
				//setting input[type=file][value] to different value is an error if it's non-empty
				// Not ideal, but it at least works around the most common source of uncaught exceptions for now.
				if (isFileInput && "" + value !== "") { console.error("`value` is read-only on file inputs!"); return }
				/* eslint-enable no-implicit-coercion */
			}
			vnode.dom[key] = value;
		} else {
			if (typeof value === "boolean") {
				if (value) vnode.dom.setAttribute(key, "");
				else vnode.dom.removeAttribute(key);
			}
			else vnode.dom.setAttribute(key === "className" ? "class" : key, value);
		}
	}
	function removeAttr(vnode, key, old, ns) {
		if (key === "key" || key === "is" || old == null || isLifecycleMethod(key)) return
		if (key[0] === "o" && key[1] === "n") updateEvent(vnode, key, undefined);
		else if (key === "style") updateStyle(vnode.dom, old, null);
		else if (
			hasPropertyKey(vnode, key, ns)
			&& key !== "className"
			&& key !== "title" // creates "null" as title
			&& !(key === "value" && (
				vnode.tag === "option"
				|| vnode.tag === "select" && vnode.dom.selectedIndex === -1 && vnode.dom === activeElement()
			))
			&& !(vnode.tag === "input" && key === "type")
		) {
			vnode.dom[key] = null;
		} else {
			var nsLastIndex = key.indexOf(":");
			if (nsLastIndex !== -1) key = key.slice(nsLastIndex + 1);
			if (old !== false) vnode.dom.removeAttribute(key === "className" ? "class" : key);
		}
	}
	function setLateSelectAttrs(vnode, attrs) {
		if ("value" in attrs) {
			if(attrs.value === null) {
				if (vnode.dom.selectedIndex !== -1) vnode.dom.value = null;
			} else {
				var normalized = "" + attrs.value; // eslint-disable-line no-implicit-coercion
				if (vnode.dom.value !== normalized || vnode.dom.selectedIndex === -1) {
					vnode.dom.value = normalized;
				}
			}
		}
		if ("selectedIndex" in attrs) setAttr(vnode, "selectedIndex", null, attrs.selectedIndex, undefined);
	}
	function updateAttrs(vnode, old, attrs, ns) {
		if (old && old === attrs) {
			console.warn("Don't reuse attrs object, use new object for every redraw, this will throw in next major");
		}
		if (attrs != null) {
			// If you assign an input type that is not supported by IE 11 with an assignment expression, an error will occur.
			//
			// Also, the DOM does things to inputs based on the value, so it needs set first.
			// See: https://github.com/MithrilJS/mithril.js/issues/2622
			if (vnode.tag === "input" && attrs.type != null) vnode.dom.setAttribute("type", attrs.type);
			var isFileInput = vnode.tag === "input" && attrs.type === "file";
			for (var key in attrs) {
				setAttr(vnode, key, old && old[key], attrs[key], ns, isFileInput);
			}
		}
		var val;
		if (old != null) {
			for (var key in old) {
				if (((val = old[key]) != null) && (attrs == null || attrs[key] == null)) {
					removeAttr(vnode, key, val, ns);
				}
			}
		}
	}
	function isFormAttribute(vnode, attr) {
		return attr === "value" || attr === "checked" || attr === "selectedIndex" || attr === "selected" && vnode.dom === activeElement() || vnode.tag === "option" && vnode.dom.parentNode === $doc.activeElement
	}
	function isLifecycleMethod(attr) {
		return attr === "oninit" || attr === "oncreate" || attr === "onupdate" || attr === "onremove" || attr === "onbeforeremove" || attr === "onbeforeupdate"
	}
	function hasPropertyKey(vnode, key, ns) {
		// Filter out namespaced keys
		return ns === undefined && (
			// If it's a custom element, just keep it.
			vnode.tag.indexOf("-") > -1 || vnode.attrs != null && vnode.attrs.is ||
			// If it's a normal element, let's try to avoid a few browser bugs.
			key !== "href" && key !== "list" && key !== "form" && key !== "width" && key !== "height"// && key !== "type"
			// Defer the property check until *after* we check everything.
		) && key in vnode.dom
	}

	//style
	var uppercaseRegex = /[A-Z]/g;
	function toLowerCase(capital) { return "-" + capital.toLowerCase() }
	function normalizeKey(key) {
		return key[0] === "-" && key[1] === "-" ? key :
			key === "cssFloat" ? "float" :
				key.replace(uppercaseRegex, toLowerCase)
	}
	function updateStyle(element, old, style) {
		if (old === style) ; else if (style == null) {
			// New style is missing, just clear it.
			element.style.cssText = "";
		} else if (typeof style !== "object") {
			// New style is a string, let engine deal with patching.
			element.style.cssText = style;
		} else if (old == null || typeof old !== "object") {
			// `old` is missing or a string, `style` is an object.
			element.style.cssText = "";
			// Add new style properties
			for (var key in style) {
				var value = style[key];
				if (value != null) element.style.setProperty(normalizeKey(key), String(value));
			}
		} else {
			// Both old & new are (different) objects.
			// Update style properties that have changed
			for (var key in style) {
				var value = style[key];
				if (value != null && (value = String(value)) !== String(old[key])) {
					element.style.setProperty(normalizeKey(key), value);
				}
			}
			// Remove style properties that no longer exist
			for (var key in old) {
				if (old[key] != null && style[key] == null) {
					element.style.removeProperty(normalizeKey(key));
				}
			}
		}
	}

	// Here's an explanation of how this works:
	// 1. The event names are always (by design) prefixed by `on`.
	// 2. The EventListener interface accepts either a function or an object
	//    with a `handleEvent` method.
	// 3. The object does not inherit from `Object.prototype`, to avoid
	//    any potential interference with that (e.g. setters).
	// 4. The event name is remapped to the handler before calling it.
	// 5. In function-based event handlers, `ev.target === this`. We replicate
	//    that below.
	// 6. In function-based event handlers, `return false` prevents the default
	//    action and stops event propagation. We replicate that below.
	function EventDict() {
		// Save this, so the current redraw is correctly tracked.
		this._ = currentRedraw;
	}
	EventDict.prototype = Object.create(null);
	EventDict.prototype.handleEvent = function (ev) {
		var handler = this["on" + ev.type];
		var result;
		if (typeof handler === "function") result = handler.call(ev.currentTarget, ev);
		else if (typeof handler.handleEvent === "function") handler.handleEvent(ev);
		if (this._ && ev.redraw !== false) (0, this._)();
		if (result === false) {
			ev.preventDefault();
			ev.stopPropagation();
		}
	};

	//event
	function updateEvent(vnode, key, value) {
		if (vnode.events != null) {
			vnode.events._ = currentRedraw;
			if (vnode.events[key] === value) return
			if (value != null && (typeof value === "function" || typeof value === "object")) {
				if (vnode.events[key] == null) vnode.dom.addEventListener(key.slice(2), vnode.events, false);
				vnode.events[key] = value;
			} else {
				if (vnode.events[key] != null) vnode.dom.removeEventListener(key.slice(2), vnode.events, false);
				vnode.events[key] = undefined;
			}
		} else if (value != null && (typeof value === "function" || typeof value === "object")) {
			vnode.events = new EventDict();
			vnode.dom.addEventListener(key.slice(2), vnode.events, false);
			vnode.events[key] = value;
		}
	}

	//lifecycle
	function initLifecycle(source, vnode, hooks) {
		if (typeof source.oninit === "function") callHook.call(source.oninit, vnode);
		if (typeof source.oncreate === "function") hooks.push(callHook.bind(source.oncreate, vnode));
	}
	function updateLifecycle(source, vnode, hooks) {
		if (typeof source.onupdate === "function") hooks.push(callHook.bind(source.onupdate, vnode));
	}
	function shouldNotUpdate(vnode, old) {
		do {
			if (vnode.attrs != null && typeof vnode.attrs.onbeforeupdate === "function") {
				var force = callHook.call(vnode.attrs.onbeforeupdate, vnode, old);
				if (force !== undefined && !force) break
			}
			if (typeof vnode.tag !== "string" && typeof vnode.state.onbeforeupdate === "function") {
				var force = callHook.call(vnode.state.onbeforeupdate, vnode, old);
				if (force !== undefined && !force) break
			}
			return false
		} while (false); // eslint-disable-line no-constant-condition
		vnode.dom = old.dom;
		vnode.domSize = old.domSize;
		vnode.instance = old.instance;
		// One would think having the actual latest attributes would be ideal,
		// but it doesn't let us properly diff based on our current internal
		// representation. We have to save not only the old DOM info, but also
		// the attributes used to create it, as we diff *that*, not against the
		// DOM directly (with a few exceptions in `setAttr`). And, of course, we
		// need to save the children and text as they are conceptually not
		// unlike special "attributes" internally.
		vnode.attrs = old.attrs;
		vnode.children = old.children;
		vnode.text = old.text;
		return true
	}

	var currentDOM;

	return function(dom, vnodes, redraw) {
		if (!dom) throw new TypeError("DOM element being rendered to does not exist.")
		if (currentDOM != null && dom.contains(currentDOM)) {
			throw new TypeError("Node is currently being rendered to and thus is locked.")
		}
		var prevRedraw = currentRedraw;
		var prevDOM = currentDOM;
		var hooks = [];
		var active = activeElement();
		var namespace = dom.namespaceURI;

		currentDOM = dom;
		currentRedraw = typeof redraw === "function" ? redraw : undefined;
		try {
			// First time rendering into a node clears it out
			if (dom.vnodes == null) dom.textContent = "";
			vnodes = vnode.normalizeChildren(Array.isArray(vnodes) ? vnodes : [vnodes]);
			updateNodes(dom, dom.vnodes, vnodes, hooks, null, namespace === "http://www.w3.org/1999/xhtml" ? undefined : namespace);
			dom.vnodes = vnodes;
			// `document.activeElement` can return null: https://html.spec.whatwg.org/multipage/interaction.html#dom-document-activeelement
			if (active != null && activeElement() !== active && typeof active.focus === "function") active.focus();
			for (var i = 0; i < hooks.length; i++) hooks[i]();
		} finally {
			currentRedraw = prevRedraw;
			currentDOM = prevDOM;
		}
	}
};

var render$1 = render(typeof window !== "undefined" ? window : null);

var mountRedraw = function(render, schedule, console) {
	var subscriptions = [];
	var pending = false;
	var offset = -1;

	function sync() {
		for (offset = 0; offset < subscriptions.length; offset += 2) {
			try { render(subscriptions[offset], vnode(subscriptions[offset + 1]), redraw); }
			catch (e) { console.error(e); }
		}
		offset = -1;
	}

	function redraw() {
		if (!pending) {
			pending = true;
			schedule(function() {
				pending = false;
				sync();
			});
		}
	}

	redraw.sync = sync;

	function mount(root, component) {
		if (component != null && component.view == null && typeof component !== "function") {
			throw new TypeError("m.mount expects a component, not a vnode.")
		}

		var index = subscriptions.indexOf(root);
		if (index >= 0) {
			subscriptions.splice(index, 2);
			if (index <= offset) offset -= 2;
			render(root, []);
		}

		if (component != null) {
			subscriptions.push(root, component);
			render(root, vnode(component), redraw);
		}
	}

	return {mount: mount, redraw: redraw}
};

var mountRedraw$1 = mountRedraw(render$1, typeof requestAnimationFrame !== "undefined" ? requestAnimationFrame : null, typeof console !== "undefined" ? console : null);

var build = function(object) {
	if (Object.prototype.toString.call(object) !== "[object Object]") return ""

	var args = [];
	for (var key in object) {
		destructure(key, object[key]);
	}

	return args.join("&")

	function destructure(key, value) {
		if (Array.isArray(value)) {
			for (var i = 0; i < value.length; i++) {
				destructure(key + "[" + i + "]", value[i]);
			}
		}
		else if (Object.prototype.toString.call(value) === "[object Object]") {
			for (var i in value) {
				destructure(key + "[" + i + "]", value[i]);
			}
		}
		else args.push(encodeURIComponent(key) + (value != null && value !== "" ? "=" + encodeURIComponent(value) : ""));
	}
};

var assign = Object.assign || function(target, source) {
	for (var key in source) {
		if (hasOwn.call(source, key)) target[key] = source[key];
	}
};

// Returns `path` from `template` + `params`
var build$1 = function(template, params) {
	if ((/:([^\/\.-]+)(\.{3})?:/).test(template)) {
		throw new SyntaxError("Template parameter names must be separated by either a '/', '-', or '.'.")
	}
	if (params == null) return template
	var queryIndex = template.indexOf("?");
	var hashIndex = template.indexOf("#");
	var queryEnd = hashIndex < 0 ? template.length : hashIndex;
	var pathEnd = queryIndex < 0 ? queryEnd : queryIndex;
	var path = template.slice(0, pathEnd);
	var query = {};

	assign(query, params);

	var resolved = path.replace(/:([^\/\.-]+)(\.{3})?/g, function(m, key, variadic) {
		delete query[key];
		// If no such parameter exists, don't interpolate it.
		if (params[key] == null) return m
		// Escape normal parameters, but not variadic ones.
		return variadic ? params[key] : encodeURIComponent(String(params[key]))
	});

	// In case the template substitution adds new query/hash parameters.
	var newQueryIndex = resolved.indexOf("?");
	var newHashIndex = resolved.indexOf("#");
	var newQueryEnd = newHashIndex < 0 ? resolved.length : newHashIndex;
	var newPathEnd = newQueryIndex < 0 ? newQueryEnd : newQueryIndex;
	var result = resolved.slice(0, newPathEnd);

	if (queryIndex >= 0) result += template.slice(queryIndex, queryEnd);
	if (newQueryIndex >= 0) result += (queryIndex < 0 ? "?" : "&") + resolved.slice(newQueryIndex, newQueryEnd);
	var querystring = build(query);
	if (querystring) result += (queryIndex < 0 && newQueryIndex < 0 ? "?" : "&") + querystring;
	if (hashIndex >= 0) result += template.slice(hashIndex);
	if (newHashIndex >= 0) result += (hashIndex < 0 ? "" : "&") + resolved.slice(newHashIndex);
	return result
};

var request = function($window, Promise, oncompletion) {
	var callbackCount = 0;

	function PromiseProxy(executor) {
		return new Promise(executor)
	}

	// In case the global Promise is some userland library's where they rely on
	// `foo instanceof this.constructor`, `this.constructor.resolve(value)`, or
	// similar. Let's *not* break them.
	PromiseProxy.prototype = Promise.prototype;
	PromiseProxy.__proto__ = Promise; // eslint-disable-line no-proto

	function makeRequest(factory) {
		return function(url, args) {
			if (typeof url !== "string") { args = url; url = url.url; }
			else if (args == null) args = {};
			var promise = new Promise(function(resolve, reject) {
				factory(build$1(url, args.params), args, function (data) {
					if (typeof args.type === "function") {
						if (Array.isArray(data)) {
							for (var i = 0; i < data.length; i++) {
								data[i] = new args.type(data[i]);
							}
						}
						else data = new args.type(data);
					}
					resolve(data);
				}, reject);
			});
			if (args.background === true) return promise
			var count = 0;
			function complete() {
				if (--count === 0 && typeof oncompletion === "function") oncompletion();
			}

			return wrap(promise)

			function wrap(promise) {
				var then = promise.then;
				// Set the constructor, so engines know to not await or resolve
				// this as a native promise. At the time of writing, this is
				// only necessary for V8, but their behavior is the correct
				// behavior per spec. See this spec issue for more details:
				// https://github.com/tc39/ecma262/issues/1577. Also, see the
				// corresponding comment in `request/tests/test-request.js` for
				// a bit more background on the issue at hand.
				promise.constructor = PromiseProxy;
				promise.then = function() {
					count++;
					var next = then.apply(promise, arguments);
					next.then(complete, function(e) {
						complete();
						if (count === 0) throw e
					});
					return wrap(next)
				};
				return promise
			}
		}
	}

	function hasHeader(args, name) {
		for (var key in args.headers) {
			if (hasOwn.call(args.headers, key) && key.toLowerCase() === name) return true
		}
		return false
	}

	return {
		request: makeRequest(function(url, args, resolve, reject) {
			var method = args.method != null ? args.method.toUpperCase() : "GET";
			var body = args.body;
			var assumeJSON = (args.serialize == null || args.serialize === JSON.serialize) && !(body instanceof $window.FormData || body instanceof $window.URLSearchParams);
			var responseType = args.responseType || (typeof args.extract === "function" ? "" : "json");

			var xhr = new $window.XMLHttpRequest(), aborted = false, isTimeout = false;
			var original = xhr, replacedAbort;
			var abort = xhr.abort;

			xhr.abort = function() {
				aborted = true;
				abort.call(this);
			};

			xhr.open(method, url, args.async !== false, typeof args.user === "string" ? args.user : undefined, typeof args.password === "string" ? args.password : undefined);

			if (assumeJSON && body != null && !hasHeader(args, "content-type")) {
				xhr.setRequestHeader("Content-Type", "application/json; charset=utf-8");
			}
			if (typeof args.deserialize !== "function" && !hasHeader(args, "accept")) {
				xhr.setRequestHeader("Accept", "application/json, text/*");
			}
			if (args.withCredentials) xhr.withCredentials = args.withCredentials;
			if (args.timeout) xhr.timeout = args.timeout;
			xhr.responseType = responseType;

			for (var key in args.headers) {
				if (hasOwn.call(args.headers, key)) {
					xhr.setRequestHeader(key, args.headers[key]);
				}
			}

			xhr.onreadystatechange = function(ev) {
				// Don't throw errors on xhr.abort().
				if (aborted) return

				if (ev.target.readyState === 4) {
					try {
						var success = (ev.target.status >= 200 && ev.target.status < 300) || ev.target.status === 304 || (/^file:\/\//i).test(url);
						// When the response type isn't "" or "text",
						// `xhr.responseText` is the wrong thing to use.
						// Browsers do the right thing and throw here, and we
						// should honor that and do the right thing by
						// preferring `xhr.response` where possible/practical.
						var response = ev.target.response, message;

						if (responseType === "json") {
							// For IE and Edge, which don't implement
							// `responseType: "json"`.
							if (!ev.target.responseType && typeof args.extract !== "function") {
								// Handle no-content which will not parse.
								try { response = JSON.parse(ev.target.responseText); }
								catch (e) { response = null; }
							}
						} else if (!responseType || responseType === "text") {
							// Only use this default if it's text. If a parsed
							// document is needed on old IE and friends (all
							// unsupported), the user should use a custom
							// `config` instead. They're already using this at
							// their own risk.
							if (response == null) response = ev.target.responseText;
						}

						if (typeof args.extract === "function") {
							response = args.extract(ev.target, args);
							success = true;
						} else if (typeof args.deserialize === "function") {
							response = args.deserialize(response);
						}
						if (success) resolve(response);
						else {
							var completeErrorResponse = function() {
								try { message = ev.target.responseText; }
								catch (e) { message = response; }
								var error = new Error(message);
								error.code = ev.target.status;
								error.response = response;
								reject(error);
							};

							if (xhr.status === 0) {
								// Use setTimeout to push this code block onto the event queue
								// This allows `xhr.ontimeout` to run in the case that there is a timeout
								// Without this setTimeout, `xhr.ontimeout` doesn't have a chance to reject
								// as `xhr.onreadystatechange` will run before it
								setTimeout(function() {
									if (isTimeout) return
									completeErrorResponse();
								});
							} else completeErrorResponse();
						}
					}
					catch (e) {
						reject(e);
					}
				}
			};

			xhr.ontimeout = function (ev) {
				isTimeout = true;
				var error = new Error("Request timed out");
				error.code = ev.target.status;
				reject(error);
			};

			if (typeof args.config === "function") {
				xhr = args.config(xhr, args, url) || xhr;

				// Propagate the `abort` to any replacement XHR as well.
				if (xhr !== original) {
					replacedAbort = xhr.abort;
					xhr.abort = function() {
						aborted = true;
						replacedAbort.call(this);
					};
				}
			}

			if (body == null) xhr.send();
			else if (typeof args.serialize === "function") xhr.send(args.serialize(body));
			else if (body instanceof $window.FormData || body instanceof $window.URLSearchParams) xhr.send(body);
			else xhr.send(JSON.stringify(body));
		}),
		jsonp: makeRequest(function(url, args, resolve, reject) {
			var callbackName = args.callbackName || "_mithril_" + Math.round(Math.random() * 1e16) + "_" + callbackCount++;
			var script = $window.document.createElement("script");
			$window[callbackName] = function(data) {
				delete $window[callbackName];
				script.parentNode.removeChild(script);
				resolve(data);
			};
			script.onerror = function() {
				delete $window[callbackName];
				script.parentNode.removeChild(script);
				reject(new Error("JSONP request failed"));
			};
			script.src = url + (url.indexOf("?") < 0 ? "?" : "&") +
				encodeURIComponent(args.callbackKey || "callback") + "=" +
				encodeURIComponent(callbackName);
			$window.document.documentElement.appendChild(script);
		}),
	}
};

var request$1 = request(typeof window !== "undefined" ? window : null, promise, mountRedraw$1.redraw);

function decodeURIComponentSave(str) {
	try {
		return decodeURIComponent(str)
	} catch(err) {
		return str
	}
}

var parse = function(string) {
	if (string === "" || string == null) return {}
	if (string.charAt(0) === "?") string = string.slice(1);

	var entries = string.split("&"), counters = {}, data = {};
	for (var i = 0; i < entries.length; i++) {
		var entry = entries[i].split("=");
		var key = decodeURIComponentSave(entry[0]);
		var value = entry.length === 2 ? decodeURIComponentSave(entry[1]) : "";

		if (value === "true") value = true;
		else if (value === "false") value = false;

		var levels = key.split(/\]\[?|\[/);
		var cursor = data;
		if (key.indexOf("[") > -1) levels.pop();
		for (var j = 0; j < levels.length; j++) {
			var level = levels[j], nextLevel = levels[j + 1];
			var isNumber = nextLevel == "" || !isNaN(parseInt(nextLevel, 10));
			if (level === "") {
				var key = levels.slice(0, j).join();
				if (counters[key] == null) {
					counters[key] = Array.isArray(cursor) ? cursor.length : 0;
				}
				level = counters[key]++;
			}
			// Disallow direct prototype pollution
			else if (level === "__proto__") break
			if (j === levels.length - 1) cursor[level] = value;
			else {
				// Read own properties exclusively to disallow indirect
				// prototype pollution
				var desc = Object.getOwnPropertyDescriptor(cursor, level);
				if (desc != null) desc = desc.value;
				if (desc == null) cursor[level] = desc = isNumber ? [] : {};
				cursor = desc;
			}
		}
	}
	return data
};

// Returns `{path, params}` from `url`
var parse$1 = function(url) {
	var queryIndex = url.indexOf("?");
	var hashIndex = url.indexOf("#");
	var queryEnd = hashIndex < 0 ? url.length : hashIndex;
	var pathEnd = queryIndex < 0 ? queryEnd : queryIndex;
	var path = url.slice(0, pathEnd).replace(/\/{2,}/g, "/");

	if (!path) path = "/";
	else {
		if (path[0] !== "/") path = "/" + path;
		if (path.length > 1 && path[path.length - 1] === "/") path = path.slice(0, -1);
	}
	return {
		path: path,
		params: queryIndex < 0
			? {}
			: parse(url.slice(queryIndex + 1, queryEnd)),
	}
};

// Compiles a template into a function that takes a resolved path (without query
// strings) and returns an object containing the template parameters with their
// parsed values. This expects the input of the compiled template to be the
// output of `parsePathname`. Note that it does *not* remove query parameters
// specified in the template.
var compileTemplate = function(template) {
	var templateData = parse$1(template);
	var templateKeys = Object.keys(templateData.params);
	var keys = [];
	var regexp = new RegExp("^" + templateData.path.replace(
		// I escape literal text so people can use things like `:file.:ext` or
		// `:lang-:locale` in routes. This is all merged into one pass so I
		// don't also accidentally escape `-` and make it harder to detect it to
		// ban it from template parameters.
		/:([^\/.-]+)(\.{3}|\.(?!\.)|-)?|[\\^$*+.()|\[\]{}]/g,
		function(m, key, extra) {
			if (key == null) return "\\" + m
			keys.push({k: key, r: extra === "..."});
			if (extra === "...") return "(.*)"
			if (extra === ".") return "([^/]+)\\."
			return "([^/]+)" + (extra || "")
		}
	) + "$");
	return function(data) {
		// First, check the params. Usually, there isn't any, and it's just
		// checking a static set.
		for (var i = 0; i < templateKeys.length; i++) {
			if (templateData.params[templateKeys[i]] !== data.params[templateKeys[i]]) return false
		}
		// If no interpolations exist, let's skip all the ceremony
		if (!keys.length) return regexp.test(data.path)
		var values = regexp.exec(data.path);
		if (values == null) return false
		for (var i = 0; i < keys.length; i++) {
			data.params[keys[i].k] = keys[i].r ? values[i + 1] : decodeURIComponent(values[i + 1]);
		}
		return true
	}
};

// Note: this is mildly perf-sensitive.
//
// It does *not* use `delete` - dynamic `delete`s usually cause objects to bail
// out into dictionary mode and just generally cause a bunch of optimization
// issues within engines.
//
// Ideally, I would've preferred to do this, if it weren't for the optimization
// issues:
//
// ```js
// const hasOwn = require("./hasOwn")
// const magic = [
//     "key", "oninit", "oncreate", "onbeforeupdate", "onupdate",
//     "onbeforeremove", "onremove",
// ]
// module.exports = (attrs, extras) => {
//     const result = Object.assign(Object.create(null), attrs)
//     for (const key of magic) delete result[key]
//     if (extras != null) for (const key of extras) delete result[key]
//     return result
// }
// ```


// Words in RegExp literals are sometimes mangled incorrectly by the internal bundler, so use RegExp().
var magic = new RegExp("^(?:key|oninit|oncreate|onbeforeupdate|onupdate|onbeforeremove|onremove)$");

var censor = function(attrs, extras) {
	var result = {};

	if (extras != null) {
		for (var key in attrs) {
			if (hasOwn.call(attrs, key) && !magic.test(key) && extras.indexOf(key) < 0) {
				result[key] = attrs[key];
			}
		}
	} else {
		for (var key in attrs) {
			if (hasOwn.call(attrs, key) && !magic.test(key)) {
				result[key] = attrs[key];
			}
		}
	}

	return result
};

var sentinel = {};

function decodeURIComponentSave$1(component) {
	try {
		return decodeURIComponent(component)
	} catch(e) {
		return component
	}
}

var router = function($window, mountRedraw) {
	var callAsync = $window == null
		// In case Mithril.js' loaded globally without the DOM, let's not break
		? null
		: typeof $window.setImmediate === "function" ? $window.setImmediate : $window.setTimeout;
	var p = promise.resolve();

	var scheduled = false;

	// state === 0: init
	// state === 1: scheduled
	// state === 2: done
	var ready = false;
	var state = 0;

	var compiled, fallbackRoute;

	var currentResolver = sentinel, component, attrs, currentPath, lastUpdate;

	var RouterRoot = {
		onbeforeupdate: function() {
			state = state ? 2 : 1;
			return !(!state || sentinel === currentResolver)
		},
		onremove: function() {
			$window.removeEventListener("popstate", fireAsync, false);
			$window.removeEventListener("hashchange", resolveRoute, false);
		},
		view: function() {
			if (!state || sentinel === currentResolver) return
			// Wrap in a fragment to preserve existing key semantics
			var vnode$1 = [vnode(component, attrs.key, attrs)];
			if (currentResolver) vnode$1 = currentResolver.render(vnode$1[0]);
			return vnode$1
		},
	};

	var SKIP = route.SKIP = {};

	function resolveRoute() {
		scheduled = false;
		// Consider the pathname holistically. The prefix might even be invalid,
		// but that's not our problem.
		var prefix = $window.location.hash;
		if (route.prefix[0] !== "#") {
			prefix = $window.location.search + prefix;
			if (route.prefix[0] !== "?") {
				prefix = $window.location.pathname + prefix;
				if (prefix[0] !== "/") prefix = "/" + prefix;
			}
		}
		// This seemingly useless `.concat()` speeds up the tests quite a bit,
		// since the representation is consistently a relatively poorly
		// optimized cons string.
		var path = prefix.concat()
			.replace(/(?:%[a-f89][a-f0-9])+/gim, decodeURIComponentSave$1)
			.slice(route.prefix.length);
		var data = parse$1(path);

		assign(data.params, $window.history.state);

		function reject(e) {
			console.error(e);
			setPath(fallbackRoute, null, {replace: true});
		}

		loop(0);
		function loop(i) {
			// state === 0: init
			// state === 1: scheduled
			// state === 2: done
			for (; i < compiled.length; i++) {
				if (compiled[i].check(data)) {
					var payload = compiled[i].component;
					var matchedRoute = compiled[i].route;
					var localComp = payload;
					var update = lastUpdate = function(comp) {
						if (update !== lastUpdate) return
						if (comp === SKIP) return loop(i + 1)
						component = comp != null && (typeof comp.view === "function" || typeof comp === "function")? comp : "div";
						attrs = data.params, currentPath = path, lastUpdate = null;
						currentResolver = payload.render ? payload : null;
						if (state === 2) mountRedraw.redraw();
						else {
							state = 2;
							mountRedraw.redraw.sync();
						}
					};
					// There's no understating how much I *wish* I could
					// use `async`/`await` here...
					if (payload.view || typeof payload === "function") {
						payload = {};
						update(localComp);
					}
					else if (payload.onmatch) {
						p.then(function () {
							return payload.onmatch(data.params, path, matchedRoute)
						}).then(update, path === fallbackRoute ? null : reject);
					}
					else update("div");
					return
				}
			}

			if (path === fallbackRoute) {
				throw new Error("Could not resolve default route " + fallbackRoute + ".")
			}
			setPath(fallbackRoute, null, {replace: true});
		}
	}

	// Set it unconditionally so `m.route.set` and `m.route.Link` both work,
	// even if neither `pushState` nor `hashchange` are supported. It's
	// cleared if `hashchange` is used, since that makes it automatically
	// async.
	function fireAsync() {
		if (!scheduled) {
			scheduled = true;
			// TODO: just do `mountRedraw.redraw()` here and elide the timer
			// dependency. Note that this will muck with tests a *lot*, so it's
			// not as easy of a change as it sounds.
			callAsync(resolveRoute);
		}
	}

	function setPath(path, data, options) {
		path = build$1(path, data);
		if (ready) {
			fireAsync();
			var state = options ? options.state : null;
			var title = options ? options.title : null;
			if (options && options.replace) $window.history.replaceState(state, title, route.prefix + path);
			else $window.history.pushState(state, title, route.prefix + path);
		}
		else {
			$window.location.href = route.prefix + path;
		}
	}

	function route(root, defaultRoute, routes) {
		if (!root) throw new TypeError("DOM element being rendered to does not exist.")

		compiled = Object.keys(routes).map(function(route) {
			if (route[0] !== "/") throw new SyntaxError("Routes must start with a '/'.")
			if ((/:([^\/\.-]+)(\.{3})?:/).test(route)) {
				throw new SyntaxError("Route parameter names must be separated with either '/', '.', or '-'.")
			}
			return {
				route: route,
				component: routes[route],
				check: compileTemplate(route),
			}
		});
		fallbackRoute = defaultRoute;
		if (defaultRoute != null) {
			var defaultData = parse$1(defaultRoute);

			if (!compiled.some(function (i) { return i.check(defaultData) })) {
				throw new ReferenceError("Default route doesn't match any known routes.")
			}
		}

		if (typeof $window.history.pushState === "function") {
			$window.addEventListener("popstate", fireAsync, false);
		} else if (route.prefix[0] === "#") {
			$window.addEventListener("hashchange", resolveRoute, false);
		}

		ready = true;
		mountRedraw.mount(root, RouterRoot);
		resolveRoute();
	}
	route.set = function(path, data, options) {
		if (lastUpdate != null) {
			options = options || {};
			options.replace = true;
		}
		lastUpdate = null;
		setPath(path, data, options);
	};
	route.get = function() {return currentPath};
	route.prefix = "#!";
	route.Link = {
		view: function(vnode) {
			// Omit the used parameters from the rendered element - they are
			// internal. Also, censor the various lifecycle methods.
			//
			// We don't strip the other parameters because for convenience we
			// let them be specified in the selector as well.
			var child = hyperscript_1(
				vnode.attrs.selector || "a",
				censor(vnode.attrs, ["options", "params", "selector", "onclick"]),
				vnode.children
			);
			var options, onclick, href;

			// Let's provide a *right* way to disable a route link, rather than
			// letting people screw up accessibility on accident.
			//
			// The attribute is coerced so users don't get surprised over
			// `disabled: 0` resulting in a button that's somehow routable
			// despite being visibly disabled.
			if (child.attrs.disabled = Boolean(child.attrs.disabled)) {
				child.attrs.href = null;
				child.attrs["aria-disabled"] = "true";
				// If you *really* do want add `onclick` on a disabled link, use
				// an `oncreate` hook to add it.
			} else {
				options = vnode.attrs.options;
				onclick = vnode.attrs.onclick;
				// Easier to build it now to keep it isomorphic.
				href = build$1(child.attrs.href, vnode.attrs.params);
				child.attrs.href = route.prefix + href;
				child.attrs.onclick = function(e) {
					var result;
					if (typeof onclick === "function") {
						result = onclick.call(e.currentTarget, e);
					} else if (onclick == null || typeof onclick !== "object") ; else if (typeof onclick.handleEvent === "function") {
						onclick.handleEvent(e);
					}

					// Adapted from React Router's implementation:
					// https://github.com/ReactTraining/react-router/blob/520a0acd48ae1b066eb0b07d6d4d1790a1d02482/packages/react-router-dom/modules/Link.js
					//
					// Try to be flexible and intuitive in how we handle links.
					// Fun fact: links aren't as obvious to get right as you
					// would expect. There's a lot more valid ways to click a
					// link than this, and one might want to not simply click a
					// link, but right click or command-click it to copy the
					// link target, etc. Nope, this isn't just for blind people.
					if (
						// Skip if `onclick` prevented default
						result !== false && !e.defaultPrevented &&
						// Ignore everything but left clicks
						(e.button === 0 || e.which === 0 || e.which === 1) &&
						// Let the browser handle `target=_blank`, etc.
						(!e.currentTarget.target || e.currentTarget.target === "_self") &&
						// No modifier keys
						!e.ctrlKey && !e.metaKey && !e.shiftKey && !e.altKey
					) {
						e.preventDefault();
						e.redraw = false;
						route.set(href, null, options);
					}
				};
			}
			return child
		},
	};
	route.param = function(key) {
		return attrs && key != null ? attrs[key] : attrs
	};

	return route
};

var route = router(typeof window !== "undefined" ? window : null, mountRedraw$1);

var m = function m() { return hyperscript_1$1.apply(this, arguments) };
m.m = hyperscript_1$1;
m.trust = hyperscript_1$1.trust;
m.fragment = hyperscript_1$1.fragment;
m.Fragment = "[";
m.mount = mountRedraw$1.mount;
m.route = route;
m.render = render$1;
m.redraw = mountRedraw$1.redraw;
m.request = request$1.request;
m.jsonp = request$1.jsonp;
m.parseQueryString = parse;
m.buildQueryString = build;
m.parsePathname = parse$1;
m.buildPathname = build$1;
m.vnode = vnode;
m.PromisePolyfill = polyfill;
m.censor = censor;

var mithril = m;

var router$1 = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Router = exports.ROUTE_PREFIX = void 0;


exports.ROUTE_PREFIX = '#!';
const DEFAULT_ROUTE = '/';
// This router does two things:
// 1) Maps fragment paths (#!/page/subpage) to Mithril components.
// The route map is passed to the ctor and is later used when calling the
// resolve() method.
//
// 2) Handles the (optional) args, e.g. #!/page?arg=1&arg2=2.
// Route args are carry information that is orthogonal to the page (e.g. the
// trace id).
// local_cache_key has some special treatment: once a URL has a local_cache_key,
// it gets automatically appended to further navigations that don't have one.
// For instance if the current url is #!/viewer?local_cache_key=1234 and a later
// action (either user-initiated or code-initited) navigates to #!/info, the
// rotuer will automatically replace the history entry with
// #!/info?local_cache_key=1234.
// This is to keep propagating the trace id across page changes, for handling
// tab discards (b/175041881).
//
// This class does NOT deal with the "load a trace when the url contains ?url=
// or ?local_cache_key=". That logic lives in trace_url_handler.ts, which is
// triggered by Router.onRouteChanged().
class Router {
    constructor(routes) {
        this.recentChanges = [];
        // frontend/index.ts calls maybeOpenTraceFromRoute() + redraw here.
        // This event is decoupled for testing and to avoid circular deps.
        this.onRouteChanged = () => { };
        (0, logging.assertExists)(routes[DEFAULT_ROUTE]);
        this.routes = routes;
        window.onhashchange = (e) => this.onHashChange(e);
    }
    onHashChange(e) {
        this.crashIfLivelock();
        const oldRoute = Router.parseUrl(e.oldURL);
        const newRoute = Router.parseUrl(e.newURL);
        if (newRoute.args.local_cache_key === undefined &&
            oldRoute.args.local_cache_key) {
            // Propagate `local_cache_key across` navigations. When a trace is loaded,
            // the URL becomes #!/viewer?local_cache_key=123. `local_cache_key` allows
            // reopening the trace from cache in the case of a reload or discard.
            // When using the UI we can hit "bare" links (e.g. just '#!/info') which
            // don't have the trace_uuid:
            // - When clicking on an <a> element from the sidebar.
            // - When the code calls Router.navigate().
            // - When the user pastes a URL from docs page.
            // In all these cases we want to keep propagating the `local_cache_key`.
            // We do so by re-setting the `local_cache_key` and doing a
            // location.replace which overwrites the history entry (note
            // location.replace is NOT just a String.replace operation).
            newRoute.args.local_cache_key = oldRoute.args.local_cache_key;
        }
        const args = mithril.buildQueryString(newRoute.args);
        let normalizedFragment = `#!${newRoute.page}${newRoute.subpage}`;
        normalizedFragment += args.length > 0 ? '?' + args : '';
        if (!e.newURL.endsWith(normalizedFragment)) {
            location.replace(normalizedFragment);
            return;
        }
        this.onRouteChanged(newRoute);
    }
    // Returns the component for the current route in the URL.
    // If no route matches the URL, returns a component corresponding to
    // |this.defaultRoute|.
    resolve() {
        const route = Router.parseFragment(location.hash);
        let component = this.routes[route.page];
        if (component === undefined) {
            component = (0, logging.assertExists)(this.routes[DEFAULT_ROUTE]);
        }
        return mithril(component, { subpage: route.subpage });
    }
    static navigate(newHash) {
        (0, logging.assertTrue)(newHash.startsWith(exports.ROUTE_PREFIX));
        window.location.hash = newHash;
    }
    // Breaks down a fragment into a Route object.
    // Sample input:
    // '#!/record/gpu?local_cache_key=abcd-1234'
    // Sample output:
    // {page: '/record', subpage: '/gpu', args: {local_cache_key: 'abcd-1234'}}
    static parseFragment(hash) {
        const prefixLength = exports.ROUTE_PREFIX.length;
        let route = '';
        if (hash.startsWith(exports.ROUTE_PREFIX)) {
            route = hash.substr(prefixLength).split('?')[0];
        }
        let page = route;
        let subpage = '';
        const splittingPoint = route.indexOf('/', 1);
        if (splittingPoint > 0) {
            page = route.substr(0, splittingPoint);
            subpage = route.substr(splittingPoint);
        }
        const argsStart = hash.indexOf('?');
        const argsStr = argsStart < 0 ? '' : hash.substr(argsStart + 1);
        const args = argsStr ? mithril.parseQueryString(hash.substr(argsStart)) : {};
        // TODO(primiano): remove this in mid-2022. trace_id is the same concept of
        // local_cache_key. Just at some point we renamed it to make it more obvious
        // to people that those URLs cannot be copy-pasted in bugs. For now this
        // handles cases of reloading pages from old version.
        if ('trace_id' in args) {
            if (!('local_cache_key' in args)) {
                args['local_cache_key'] = args['trace_id'];
            }
            delete args['trace_id'];
        }
        return { page, subpage, args };
    }
    // Like parseFragment() but takes a full URL.
    static parseUrl(url) {
        const hashPos = url.indexOf('#');
        const fragment = hashPos < 0 ? '' : url.substr(hashPos);
        return Router.parseFragment(fragment);
    }
    // Throws if EVENT_LIMIT onhashchange events occur within WINDOW_MS.
    crashIfLivelock() {
        const WINDOW_MS = 1000;
        const EVENT_LIMIT = 20;
        const now = Date.now();
        while (this.recentChanges.length > 0 &&
            now - this.recentChanges[0] > WINDOW_MS) {
            this.recentChanges.shift();
        }
        this.recentChanges.push(now);
        if (this.recentChanges.length > EVENT_LIMIT) {
            throw new Error('History rewriting livelock');
        }
    }
}
exports.Router = Router;

});

var analytics = createCommonjsModule(function (module, exports) {
// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.NullAnalytics = exports.initAnalytics = void 0;




const ANALYTICS_ID = 'UA-137828855-1';
const PAGE_TITLE = 'no-page-title';
function initAnalytics() {
    // Only initialize logging on the official site and on localhost (to catch
    // analytics bugs when testing locally).
    // Skip analytics is the fragment has "testing=1", this is used by UI tests.
    if ((window.location.origin.startsWith('http://localhost:') ||
        window.location.origin.endsWith('.perfetto.dev')) &&
        !globals.globals.testing) {
        return new AnalyticsImpl();
    }
    return new NullAnalytics();
}
exports.initAnalytics = initAnalytics;
const gtagGlobals = window;
class NullAnalytics {
    initialize() { }
    updatePath(_) { }
    logEvent(_x, _y) { }
    logError(_x) { }
    isEnabled() {
        return false;
    }
}
exports.NullAnalytics = NullAnalytics;
class AnalyticsImpl {
    constructor() {
        this.initialized_ = false;
        // The code below is taken from the official Google Analytics docs [1] and
        // adapted to TypeScript. We have it here rather than as an inline script
        // in index.html (as suggested by GA's docs) because inline scripts don't
        // play nicely with the CSP policy, at least in Firefox (Firefox doesn't
        // support all CSP 3 features we use).
        // [1] https://developers.google.com/analytics/devguides/collection/gtagjs .
        gtagGlobals.dataLayer = gtagGlobals.dataLayer || [];
        function gtagFunction(..._) {
            // This needs to be a function and not a lambda. |arguments| behaves
            // slightly differently in a lambda and breaks GA.
            gtagGlobals.dataLayer.push(arguments);
        }
        gtagGlobals.gtag = gtagFunction;
        gtagGlobals.gtag('js', new Date());
    }
    // This is callled only after the script that sets isInternalUser loads.
    // It is fine to call updatePath() and log*() functions before initialize().
    // The gtag() function internally enqueues all requests into |dataLayer|.
    initialize() {
        if (this.initialized_)
            return;
        this.initialized_ = true;
        const script = document.createElement('script');
        script.src = 'https://www.googletagmanager.com/gtag/js?id=' + ANALYTICS_ID;
        script.defer = true;
        document.head.appendChild(script);
        const route = router$1.Router.parseUrl(window.location.href).page || '/';
        console.log(`GA initialized. route=${route}`, `isInternalUser=${globals.globals.isInternalUser}`);
        // GA's reccomendation for SPAs is to disable automatic page views and
        // manually send page_view events. See:
        // https://developers.google.com/analytics/devguides/collection/gtagjs/pages#manual_pageviews
        gtagGlobals.gtag('config', ANALYTICS_ID, {
            allow_google_signals: false,
            anonymize_ip: true,
            page_path: route,
            referrer: document.referrer.split('?')[0],
            send_page_view: false,
            page_title: PAGE_TITLE,
            dimension1: globals.globals.isInternalUser ? '1' : '0',
            dimension2: perfetto_version.VERSION,
            dimension3: (0, channels.getCurrentChannel)(),
        });
        this.updatePath(route);
    }
    updatePath(path) {
        gtagGlobals.gtag('event', 'page_view', { page_path: path, page_title: PAGE_TITLE });
    }
    logEvent(category, event) {
        gtagGlobals.gtag('event', event, { event_category: category });
    }
    logError(description, fatal = true) {
        gtagGlobals.gtag('event', 'exception', { description, fatal });
    }
    isEnabled() {
        return true;
    }
}

});

var rate_limiters = createCommonjsModule(function (module, exports) {
// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.debounce = exports.ratelimit = void 0;
// Returns a wrapper around |f| which calls f at most once every |ms|ms.
function ratelimit(f, ms) {
    let inProgess = false;
    return () => {
        if (inProgess) {
            return;
        }
        inProgess = true;
        window.setTimeout(() => {
            f();
            inProgess = false;
        }, ms);
    };
}
exports.ratelimit = ratelimit;
// Returns a wrapper around |f| which waits for a |ms|ms pause in calls
// before calling |f|.
function debounce(f, ms) {
    let timerId;
    return () => {
        if (timerId) {
            window.clearTimeout(timerId);
        }
        timerId = window.setTimeout(() => {
            f();
            timerId = undefined;
        }, ms);
    };
}
exports.debounce = debounce;

});

var time_scale = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeZoom = exports.TimeScale = void 0;


const MAX_ZOOM_SPAN_SEC = 1e-8; // 10 ns.
/**
 * Defines a mapping between number and seconds for the entire application.
 * Linearly scales time values from boundsMs to pixel values in boundsPx and
 * back.
 */
class TimeScale {
    constructor(timeBounds, boundsPx) {
        this.secPerPx = 0;
        this.timeBounds = timeBounds;
        this._startPx = boundsPx[0];
        this._endPx = boundsPx[1];
        this.updateSlope();
    }
    updateSlope() {
        this.secPerPx = this.timeBounds.duration / (this._endPx - this._startPx);
    }
    deltaTimeToPx(time) {
        return Math.round(time / this.secPerPx);
    }
    timeToPx(time) {
        return this._startPx + (time - this.timeBounds.start) / this.secPerPx;
    }
    pxToTime(px) {
        return this.timeBounds.start + (px - this._startPx) * this.secPerPx;
    }
    deltaPxToDuration(px) {
        return px * this.secPerPx;
    }
    setTimeBounds(timeBounds) {
        this.timeBounds = timeBounds;
        this.updateSlope();
    }
    setLimitsPx(pxStart, pxEnd) {
        (0, logging.assertFalse)(pxStart === pxEnd);
        (0, logging.assertTrue)(pxStart >= 0 && pxEnd >= 0);
        this._startPx = pxStart;
        this._endPx = pxEnd;
        this.updateSlope();
    }
    timeInBounds(time) {
        return this.timeBounds.isInBounds(time);
    }
    get startPx() {
        return this._startPx;
    }
    get endPx() {
        return this._endPx;
    }
}
exports.TimeScale = TimeScale;
function computeZoom(scale, span, zoomFactor, zoomPx) {
    const startPx = scale.startPx;
    const endPx = scale.endPx;
    const deltaPx = endPx - startPx;
    const deltaTime = span.end - span.start;
    const newDeltaTime = Math.max(deltaTime * zoomFactor, MAX_ZOOM_SPAN_SEC);
    const clampedZoomPx = Math.max(startPx, Math.min(endPx, zoomPx));
    const zoomTime = scale.pxToTime(clampedZoomPx);
    const r = (clampedZoomPx - startPx) / deltaPx;
    const newStartTime = zoomTime - newDeltaTime * r;
    const newEndTime = newStartTime + newDeltaTime;
    return new time.TimeSpan(newStartTime, newEndTime);
}
exports.computeZoom = computeZoom;

});

var frontend_local_state = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontendLocalState = void 0;






function chooseLatest(current, next) {
    if (next !== current && next.lastUpdate > current.lastUpdate) {
        // |next| is from state. Callers may mutate the return value of
        // this function so we need to clone |next| to prevent bad mutations
        // of state:
        return Object.assign({}, next);
    }
    return current;
}
function capBetween(t, start, end) {
    return Math.min(Math.max(t, start), end);
}
// Calculate the space a scrollbar takes up so that we can subtract it from
// the canvas width.
function calculateScrollbarWidth() {
    const outer = document.createElement('div');
    outer.style.overflowY = 'scroll';
    const inner = document.createElement('div');
    outer.appendChild(inner);
    document.body.appendChild(outer);
    const width = outer.getBoundingClientRect().width - inner.getBoundingClientRect().width;
    document.body.removeChild(outer);
    return width;
}
/**
 * State that is shared between several frontend components, but not the
 * controller. This state is updated at 60fps.
 */
class FrontendLocalState {
    constructor() {
        this.visibleWindowTime = new time.TimeSpan(0, 10);
        this.timeScale = new time_scale.TimeScale(this.visibleWindowTime, [0, 0]);
        this.showPanningHint = false;
        this.showCookieConsent = false;
        this.visibleTracks = new Set();
        this.prevVisibleTracks = new Set();
        this.httpRpcState = { connected: false };
        this.newVersionAvailable = false;
        this.showPivotTable = false;
        // This is used to calculate the tracks within a Y range for area selection.
        this.areaY = {};
        this._omniboxState = {
            lastUpdate: 0,
            omnibox: '',
            mode: 'SEARCH',
        };
        this._visibleState = {
            lastUpdate: 0,
            startSec: 0,
            endSec: 10,
            resolution: 1,
        };
        this.setOmniboxDebounced = (0, rate_limiters.debounce)(() => {
            globals.globals.dispatch(actions.Actions.setOmnibox(Object.assign({}, this._omniboxState)));
        }, 20);
        this.ratelimitedUpdateVisible = (0, rate_limiters.ratelimit)(() => {
            globals.globals.dispatch(actions.Actions.setVisibleTraceTime(this._visibleState));
        }, 50);
    }
    // TODO: there is some redundancy in the fact that both |visibleWindowTime|
    // and a |timeScale| have a notion of time range. That should live in one
    // place only.
    getScrollbarWidth() {
        if (this.scrollBarWidth === undefined) {
            this.scrollBarWidth = calculateScrollbarWidth();
        }
        return this.scrollBarWidth;
    }
    setHttpRpcState(httpRpcState) {
        this.httpRpcState = httpRpcState;
        globals.globals.rafScheduler.scheduleFullRedraw();
    }
    addVisibleTrack(trackId) {
        this.visibleTracks.add(trackId);
    }
    // Called when beginning a canvas redraw.
    clearVisibleTracks() {
        this.visibleTracks.clear();
    }
    // Called when the canvas redraw is complete.
    sendVisibleTracks() {
        if (this.prevVisibleTracks.size !== this.visibleTracks.size ||
            ![...this.prevVisibleTracks].every((value) => this.visibleTracks.has(value))) {
            globals.globals.dispatch(actions.Actions.setVisibleTracks({ tracks: Array.from(this.visibleTracks) }));
            this.prevVisibleTracks = new Set(this.visibleTracks);
        }
    }
    togglePivotTable() {
        this.showPivotTable = !this.showPivotTable;
        globals.globals.rafScheduler.scheduleFullRedraw();
    }
    mergeState(state) {
        // This is unfortunately subtle. This class mutates this._visibleState.
        // Since we may not mutate |state| (in order to make immer's immutable
        // updates work) this means that we have to make a copy of the visibleState.
        // when updating it. We don't want to have to do that unnecessarily so
        // chooseLatest returns a shallow clone of state.visibleState *only* when
        // that is the newer state. All of these complications should vanish when
        // we remove this class.
        const previousVisibleState = this._visibleState;
        this._omniboxState = chooseLatest(this._omniboxState, state.omniboxState);
        this._visibleState = chooseLatest(this._visibleState, state.visibleState);
        const visibleStateWasUpdated = previousVisibleState !== this._visibleState;
        if (visibleStateWasUpdated) {
            this.updateLocalTime(new time.TimeSpan(this._visibleState.startSec, this._visibleState.endSec));
        }
    }
    selectArea(startSec, endSec, tracks = this._selectedArea ? this._selectedArea.tracks : []) {
        (0, logging.assertTrue)(endSec >= startSec);
        this.showPanningHint = true;
        this._selectedArea = { startSec, endSec, tracks },
            globals.globals.rafScheduler.scheduleFullRedraw();
    }
    deselectArea() {
        this._selectedArea = undefined;
        globals.globals.rafScheduler.scheduleRedraw();
    }
    get selectedArea() {
        return this._selectedArea;
    }
    setOmnibox(value, mode) {
        this._omniboxState.omnibox = value;
        this._omniboxState.mode = mode;
        this._omniboxState.lastUpdate = Date.now() / 1000;
        this.setOmniboxDebounced();
    }
    get omnibox() {
        return this._omniboxState.omnibox;
    }
    updateLocalTime(ts) {
        const traceTime = globals.globals.state.traceTime;
        const startSec = capBetween(ts.start, traceTime.startSec, traceTime.endSec);
        const endSec = capBetween(ts.end, traceTime.startSec, traceTime.endSec);
        this.visibleWindowTime = new time.TimeSpan(startSec, endSec);
        this.timeScale.setTimeBounds(this.visibleWindowTime);
        this.updateResolution();
    }
    updateResolution() {
        this._visibleState.lastUpdate = Date.now() / 1000;
        this._visibleState.resolution = globals.globals.getCurResolution();
        this.ratelimitedUpdateVisible();
    }
    updateVisibleTime(ts) {
        this.updateLocalTime(ts);
        this._visibleState.lastUpdate = Date.now() / 1000;
        this._visibleState.startSec = this.visibleWindowTime.start;
        this._visibleState.endSec = this.visibleWindowTime.end;
        this._visibleState.resolution = globals.globals.getCurResolution();
        this.ratelimitedUpdateVisible();
    }
    getVisibleStateBounds() {
        return [this.visibleWindowTime.start, this.visibleWindowTime.end];
    }
    // Whenever start/end px of the timeScale is changed, update
    // the resolution.
    updateLocalLimits(pxStart, pxEnd) {
        // Numbers received here can be negative or equal, but we should fix that
        // before updating the timescale.
        pxStart = Math.max(0, pxStart);
        pxEnd = Math.max(0, pxEnd);
        if (pxStart === pxEnd)
            pxEnd = pxStart + 1;
        this.timeScale.setLimitsPx(pxStart, pxEnd);
        this.updateResolution();
    }
}
exports.FrontendLocalState = FrontendLocalState;

});

var perf = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.perfDisplay = exports.runningStatStr = exports.RunningStatistics = exports.measure = exports.debugNow = exports.perfDebug = void 0;



// Shorthand for if globals perf debug mode is on.
const perfDebug = () => globals.globals.state.perfDebug;
exports.perfDebug = perfDebug;
// Returns performance.now() if perfDebug is enabled, otherwise 0.
// This is needed because calling performance.now is generally expensive
// and should not be done for every frame.
const debugNow = () => (0, exports.perfDebug)() ? performance.now() : 0;
exports.debugNow = debugNow;
// Returns execution time of |fn| if perf debug mode is on. Returns 0 otherwise.
function measure(fn) {
    const start = (0, exports.debugNow)();
    fn();
    return (0, exports.debugNow)() - start;
}
exports.measure = measure;
// Stores statistics about samples, and keeps a fixed size buffer of most recent
// samples.
class RunningStatistics {
    constructor(_maxBufferSize = 10) {
        this._maxBufferSize = _maxBufferSize;
        this._count = 0;
        this._mean = 0;
        this._lastValue = 0;
        this.buffer = [];
    }
    addValue(value) {
        this._lastValue = value;
        this.buffer.push(value);
        if (this.buffer.length > this._maxBufferSize) {
            this.buffer.shift();
        }
        this._mean = (this._mean * this._count + value) / (this._count + 1);
        this._count++;
    }
    get mean() {
        return this._mean;
    }
    get count() {
        return this._count;
    }
    get bufferMean() {
        return this.buffer.reduce((sum, v) => sum + v, 0) / this.buffer.length;
    }
    get bufferSize() {
        return this.buffer.length;
    }
    get maxBufferSize() {
        return this._maxBufferSize;
    }
    get last() {
        return this._lastValue;
    }
}
exports.RunningStatistics = RunningStatistics;
// Returns a summary string representation of a RunningStatistics object.
function runningStatStr(stat) {
    return `Last: ${stat.last.toFixed(2)}ms | ` +
        `Avg: ${stat.mean.toFixed(2)}ms | ` +
        `Avg${stat.maxBufferSize}: ${stat.bufferMean.toFixed(2)}ms`;
}
exports.runningStatStr = runningStatStr;
// Globals singleton class that renders performance stats for the whole app.
class PerfDisplay {
    constructor() {
        this.containers = [];
    }
    addContainer(container) {
        this.containers.push(container);
    }
    removeContainer(container) {
        const i = this.containers.indexOf(container);
        this.containers.splice(i, 1);
    }
    renderPerfStats() {
        if (!(0, exports.perfDebug)())
            return;
        const perfDisplayEl = document.querySelector('.perf-stats');
        if (!perfDisplayEl)
            return;
        mithril.render(perfDisplayEl, [
            mithril('section', globals.globals.rafScheduler.renderPerfStats()),
            mithril('button.close-button', {
                onclick: () => globals.globals.dispatch(actions.Actions.togglePerfDebug({})),
            }, mithril('i.material-icons', 'close')),
            this.containers.map((c, i) => mithril('section', c.renderPerfStats(i))),
        ]);
    }
}
exports.perfDisplay = new PerfDisplay();

});

var raf_scheduler = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.RafScheduler = void 0;




function statTableHeader() {
    return mithril('tr', mithril('th', ''), mithril('th', 'Last (ms)'), mithril('th', 'Avg (ms)'), mithril('th', 'Avg-10 (ms)'));
}
function statTableRow(title, stat) {
    return mithril('tr', mithril('td', title), mithril('td', stat.last.toFixed(2)), mithril('td', stat.mean.toFixed(2)), mithril('td', stat.bufferMean.toFixed(2)));
}
// This class orchestrates all RAFs in the UI. It ensures that there is only
// one animation frame handler overall and that callbacks are called in
// predictable order. There are two types of callbacks here:
// - actions (e.g. pan/zoon animations), which will alter the "fast"
//  (main-thread-only) state (e.g. update visible time bounds @ 60 fps).
// - redraw callbacks that will repaint canvases.
// This class guarantees that, on each frame, redraw callbacks are called after
// all action callbacks.
class RafScheduler {
    constructor() {
        this.actionCallbacks = new Set();
        this.canvasRedrawCallbacks = new Set();
        this._syncDomRedraw = (_) => { };
        this.hasScheduledNextFrame = false;
        this.requestedFullRedraw = false;
        this.isRedrawing = false;
        this._shutdown = false;
        this.perfStats = {
            rafActions: new perf.RunningStatistics(),
            rafCanvas: new perf.RunningStatistics(),
            rafDom: new perf.RunningStatistics(),
            rafTotal: new perf.RunningStatistics(),
            domRedraw: new perf.RunningStatistics(),
        };
    }
    start(cb) {
        this.actionCallbacks.add(cb);
        this.maybeScheduleAnimationFrame();
    }
    stop(cb) {
        this.actionCallbacks.delete(cb);
    }
    addRedrawCallback(cb) {
        this.canvasRedrawCallbacks.add(cb);
    }
    removeRedrawCallback(cb) {
        this.canvasRedrawCallbacks.delete(cb);
    }
    scheduleRedraw() {
        this.maybeScheduleAnimationFrame(true);
    }
    shutdown() {
        this._shutdown = true;
    }
    set domRedraw(cb) {
        this._syncDomRedraw = cb || ((_) => { });
    }
    scheduleFullRedraw() {
        this.requestedFullRedraw = true;
        this.maybeScheduleAnimationFrame(true);
    }
    syncDomRedraw(nowMs) {
        const redrawStart = (0, perf.debugNow)();
        this._syncDomRedraw(nowMs);
        if ((0, perf.perfDebug)()) {
            this.perfStats.domRedraw.addValue((0, perf.debugNow)() - redrawStart);
        }
    }
    get hasPendingRedraws() {
        return this.isRedrawing || this.hasScheduledNextFrame;
    }
    syncCanvasRedraw(nowMs) {
        const redrawStart = (0, perf.debugNow)();
        if (this.isRedrawing)
            return;
        globals.globals.frontendLocalState.clearVisibleTracks();
        this.isRedrawing = true;
        for (const redraw of this.canvasRedrawCallbacks)
            redraw(nowMs);
        this.isRedrawing = false;
        globals.globals.frontendLocalState.sendVisibleTracks();
        if ((0, perf.perfDebug)()) {
            this.perfStats.rafCanvas.addValue((0, perf.debugNow)() - redrawStart);
        }
    }
    maybeScheduleAnimationFrame(force = false) {
        if (this.hasScheduledNextFrame)
            return;
        if (this.actionCallbacks.size !== 0 || force) {
            this.hasScheduledNextFrame = true;
            window.requestAnimationFrame(this.onAnimationFrame.bind(this));
        }
    }
    onAnimationFrame(nowMs) {
        if (this._shutdown)
            return;
        const rafStart = (0, perf.debugNow)();
        this.hasScheduledNextFrame = false;
        const doFullRedraw = this.requestedFullRedraw;
        this.requestedFullRedraw = false;
        const actionTime = (0, perf.measure)(() => {
            for (const action of this.actionCallbacks)
                action(nowMs);
        });
        const domTime = (0, perf.measure)(() => {
            if (doFullRedraw)
                this.syncDomRedraw(nowMs);
        });
        const canvasTime = (0, perf.measure)(() => this.syncCanvasRedraw(nowMs));
        const totalRafTime = (0, perf.debugNow)() - rafStart;
        this.updatePerfStats(actionTime, domTime, canvasTime, totalRafTime);
        perf.perfDisplay.renderPerfStats();
        this.maybeScheduleAnimationFrame();
    }
    updatePerfStats(actionsTime, domTime, canvasTime, totalRafTime) {
        if (!(0, perf.perfDebug)())
            return;
        this.perfStats.rafActions.addValue(actionsTime);
        this.perfStats.rafDom.addValue(domTime);
        this.perfStats.rafCanvas.addValue(canvasTime);
        this.perfStats.rafTotal.addValue(totalRafTime);
    }
    renderPerfStats() {
        (0, logging.assertTrue)((0, perf.perfDebug)());
        return mithril('div', mithril('div', [
            mithril('button', { onclick: () => this.scheduleRedraw() }, 'Do Canvas Redraw'),
            '   |   ',
            mithril('button', { onclick: () => this.scheduleFullRedraw() }, 'Do Full Redraw'),
        ]), mithril('div', 'Raf Timing ' +
            '(Total may not add up due to imprecision)'), mithril('table', statTableHeader(), statTableRow('Actions', this.perfStats.rafActions), statTableRow('Dom', this.perfStats.rafDom), statTableRow('Canvas', this.perfStats.rafCanvas), statTableRow('Total', this.perfStats.rafTotal)), mithril('div', 'Dom redraw: ' +
            `Count: ${this.perfStats.domRedraw.count} | ` +
            (0, perf.runningStatStr)(this.perfStats.domRedraw)));
    }
}
exports.RafScheduler = RafScheduler;

});

var service_worker_controller = createCommonjsModule(function (module, exports) {
// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceWorkerController = void 0;

// Handles registration, unregistration and lifecycle of the service worker.
// This class contains only the controlling logic, all the code in here runs in
// the main thread, not in the service worker thread.
// The actual service worker code is in src/service_worker.
// Design doc: http://go/perfetto-offline.


// We use a dedicated |caches| object to share a global boolean beween the main
// thread and the SW. SW cannot use local-storage or anything else other than
// IndexedDB (which would be overkill).
const BYPASS_ID = 'BYPASS_SERVICE_WORKER';
class ServiceWorkerController {
    constructor() {
        this._initialWorker = null;
        this._bypassed = false;
        this._installing = false;
    }
    // Caller should reload().
    setBypass(bypass) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            if (!('serviceWorker' in navigator))
                return; // Not supported.
            this._bypassed = bypass;
            if (bypass) {
                yield caches.open(BYPASS_ID); // Create the entry.
                for (const reg of yield navigator.serviceWorker.getRegistrations()) {
                    yield reg.unregister();
                }
            }
            else {
                yield caches.delete(BYPASS_ID);
                if (window.localStorage) {
                    window.localStorage.setItem('bypassDisabled', '1');
                }
                this.install();
            }
            globals.globals.rafScheduler.scheduleFullRedraw();
        });
    }
    onStateChange(sw) {
        globals.globals.rafScheduler.scheduleFullRedraw();
        if (sw.state === 'installing') {
            this._installing = true;
        }
        else if (sw.state === 'activated') {
            this._installing = false;
            // Don't show the notification if the site was served straight
            // from the network (e.g., on the very first visit or after
            // Ctrl+Shift+R). In these cases, we are already at the last
            // version.
            if (sw !== this._initialWorker && this._initialWorker) {
                globals.globals.frontendLocalState.newVersionAvailable = true;
            }
        }
    }
    monitorWorker(sw) {
        if (!sw)
            return;
        sw.addEventListener('error', (e) => (0, logging.reportError)(e));
        sw.addEventListener('statechange', () => this.onStateChange(sw));
        this.onStateChange(sw); // Trigger updates for the current state.
    }
    install() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            if (!('serviceWorker' in navigator))
                return; // Not supported.
            if (location.pathname !== '/') {
                // Disable the service worker when the UI is loaded from a non-root URL
                // (e.g. from the CI artifacts GCS bucket). Supporting the case of a
                // nested index.html is too cumbersome and has no benefits.
                return;
            }
            // If this is localhost disable the service worker by default, unless the
            // user manually re-enabled it (in which case bypassDisabled = '1').
            const hostname = location.hostname;
            const isLocalhost = ['127.0.0.1', '::1', 'localhost'].includes(hostname);
            const bypassDisabled = window.localStorage &&
                window.localStorage.getItem('bypassDisabled') === '1';
            if (isLocalhost && !bypassDisabled) {
                yield this.setBypass(true); // Will cause the check below to bail out.
            }
            if (yield caches.has(BYPASS_ID)) {
                this._bypassed = true;
                console.log('Skipping service worker registration, disabled by the user');
                return;
            }
            // In production cases versionDir == VERSION. We use this here for ease of
            // testing (so we can have /v1.0.0a/ /v1.0.0b/ even if they have the same
            // version code).
            const versionDir = globals.globals.root.split('/').slice(-2)[0];
            const swUri = `/service_worker.js?v=${versionDir}`;
            navigator.serviceWorker.register(swUri).then((registration) => {
                this._initialWorker = registration.active;
                // At this point there are two options:
                // 1. This is the first time we visit the site (or cache was cleared) and
                //    no SW is installed yet. In this case |installing| will be set.
                // 2. A SW is already installed (though it might be obsolete). In this
                //    case |active| will be set.
                this.monitorWorker(registration.installing);
                this.monitorWorker(registration.active);
                // Setup the event that shows the "Updated to v1.2.3" notification.
                registration.addEventListener('updatefound', () => {
                    this.monitorWorker(registration.installing);
                });
            });
        });
    }
    get bypassed() {
        return this._bypassed;
    }
    get installing() {
        return this._installing;
    }
}
exports.ServiceWorkerController = ServiceWorkerController;

});

var globals = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.globals = void 0;









function getRoot() {
    // Works out the root directory where the content should be served from
    // e.g. `http://origin/v1.2.3/`.
    const script = document.currentScript;
    // Needed for DOM tests, that do not have script element.
    if (script === null) {
        return '';
    }
    let root = script.src;
    root = root.substr(0, root.lastIndexOf('/') + 1);
    return root;
}
/**
 * Global accessors for state/dispatch in the frontend.
 */
class Globals {
    constructor() {
        this.root = getRoot();
        this._testing = false;
        this._dispatch = undefined;
        this._state = undefined;
        this._frontendLocalState = undefined;
        this._rafScheduler = undefined;
        this._serviceWorkerController = undefined;
        this._logging = undefined;
        this._isInternalUser = undefined;
        // TODO(hjd): Unify trackDataStore, queryResults, overviewStore, threads.
        this._trackDataStore = undefined;
        this._queryResults = undefined;
        this._overviewStore = undefined;
        this._aggregateDataStore = undefined;
        this._threadMap = undefined;
        this._sliceDetails = undefined;
        this._threadStateDetails = undefined;
        this._connectedFlows = undefined;
        this._selectedFlows = undefined;
        this._visibleFlowCategories = undefined;
        this._counterDetails = undefined;
        this._flamegraphDetails = undefined;
        this._cpuProfileDetails = undefined;
        this._numQueriesQueued = 0;
        this._bufferUsage = undefined;
        this._recordingLog = undefined;
        this._traceErrors = undefined;
        this._metricError = undefined;
        this._metricResult = undefined;
        this._hasFtrace = undefined;
        this._jobStatus = undefined;
        this._router = undefined;
        this._embeddedMode = undefined;
        this._hideSidebar = undefined;
        // TODO(hjd): Remove once we no longer need to update UUID on redraw.
        this._publishRedraw = undefined;
        this._currentSearchResults = {
            sliceIds: new Float64Array(0),
            tsStarts: new Float64Array(0),
            utids: new Float64Array(0),
            trackIds: [],
            sources: [],
            totalResults: 0,
        };
        this.searchSummary = {
            tsStarts: new Float64Array(0),
            tsEnds: new Float64Array(0),
            count: new Uint8Array(0),
        };
        this.engines = new Map();
    }
    initialize(dispatch, router) {
        this._dispatch = dispatch;
        this._router = router;
        this._state = (0, empty_state.createEmptyState)();
        this._frontendLocalState = new frontend_local_state.FrontendLocalState();
        this._rafScheduler = new raf_scheduler.RafScheduler();
        this._serviceWorkerController = new service_worker_controller.ServiceWorkerController();
        this._testing =
            self.location && self.location.search.indexOf('testing=1') >= 0;
        this._logging = (0, analytics.initAnalytics)();
        // TODO(hjd): Unify trackDataStore, queryResults, overviewStore, threads.
        this._trackDataStore = new Map();
        this._queryResults = new Map();
        this._overviewStore = new Map();
        this._aggregateDataStore = new Map();
        this._threadMap = new Map();
        this._sliceDetails = {};
        this._connectedFlows = [];
        this._selectedFlows = [];
        this._visibleFlowCategories = new Map();
        this._counterDetails = {};
        this._threadStateDetails = {};
        this._flamegraphDetails = {};
        this._cpuProfileDetails = {};
        this.engines.clear();
    }
    get router() {
        return (0, logging.assertExists)(this._router);
    }
    get publishRedraw() {
        return this._publishRedraw || (() => { });
    }
    set publishRedraw(f) {
        this._publishRedraw = f;
    }
    get state() {
        return (0, logging.assertExists)(this._state);
    }
    set state(state) {
        this._state = (0, logging.assertExists)(state);
    }
    get dispatch() {
        return (0, logging.assertExists)(this._dispatch);
    }
    get frontendLocalState() {
        return (0, logging.assertExists)(this._frontendLocalState);
    }
    get rafScheduler() {
        return (0, logging.assertExists)(this._rafScheduler);
    }
    get logging() {
        return (0, logging.assertExists)(this._logging);
    }
    get serviceWorkerController() {
        return (0, logging.assertExists)(this._serviceWorkerController);
    }
    // TODO(hjd): Unify trackDataStore, queryResults, overviewStore, threads.
    get overviewStore() {
        return (0, logging.assertExists)(this._overviewStore);
    }
    get trackDataStore() {
        return (0, logging.assertExists)(this._trackDataStore);
    }
    get queryResults() {
        return (0, logging.assertExists)(this._queryResults);
    }
    get threads() {
        return (0, logging.assertExists)(this._threadMap);
    }
    get sliceDetails() {
        return (0, logging.assertExists)(this._sliceDetails);
    }
    set sliceDetails(click) {
        this._sliceDetails = (0, logging.assertExists)(click);
    }
    get threadStateDetails() {
        return (0, logging.assertExists)(this._threadStateDetails);
    }
    set threadStateDetails(click) {
        this._threadStateDetails = (0, logging.assertExists)(click);
    }
    get connectedFlows() {
        return (0, logging.assertExists)(this._connectedFlows);
    }
    set connectedFlows(connectedFlows) {
        this._connectedFlows = (0, logging.assertExists)(connectedFlows);
    }
    get selectedFlows() {
        return (0, logging.assertExists)(this._selectedFlows);
    }
    set selectedFlows(selectedFlows) {
        this._selectedFlows = (0, logging.assertExists)(selectedFlows);
    }
    get visibleFlowCategories() {
        return (0, logging.assertExists)(this._visibleFlowCategories);
    }
    set visibleFlowCategories(visibleFlowCategories) {
        this._visibleFlowCategories = (0, logging.assertExists)(visibleFlowCategories);
    }
    get counterDetails() {
        return (0, logging.assertExists)(this._counterDetails);
    }
    set counterDetails(click) {
        this._counterDetails = (0, logging.assertExists)(click);
    }
    get aggregateDataStore() {
        return (0, logging.assertExists)(this._aggregateDataStore);
    }
    get flamegraphDetails() {
        return (0, logging.assertExists)(this._flamegraphDetails);
    }
    set flamegraphDetails(click) {
        this._flamegraphDetails = (0, logging.assertExists)(click);
    }
    get traceErrors() {
        return this._traceErrors;
    }
    setTraceErrors(arg) {
        this._traceErrors = arg;
    }
    get metricError() {
        return this._metricError;
    }
    setMetricError(arg) {
        this._metricError = arg;
    }
    get metricResult() {
        return this._metricResult;
    }
    setMetricResult(result) {
        this._metricResult = result;
    }
    get cpuProfileDetails() {
        return (0, logging.assertExists)(this._cpuProfileDetails);
    }
    set cpuProfileDetails(click) {
        this._cpuProfileDetails = (0, logging.assertExists)(click);
    }
    set numQueuedQueries(value) {
        this._numQueriesQueued = value;
    }
    get numQueuedQueries() {
        return this._numQueriesQueued;
    }
    get bufferUsage() {
        return this._bufferUsage;
    }
    get recordingLog() {
        return this._recordingLog;
    }
    get currentSearchResults() {
        return this._currentSearchResults;
    }
    set currentSearchResults(results) {
        this._currentSearchResults = results;
    }
    get hasFtrace() {
        return !!this._hasFtrace;
    }
    set hasFtrace(value) {
        this._hasFtrace = value;
    }
    getConversionJobStatus(name) {
        return this.getJobStatusMap().get(name) || conversion_jobs.ConversionJobStatus.NotRunning;
    }
    setConversionJobStatus(name, status) {
        const map = this.getJobStatusMap();
        if (status === conversion_jobs.ConversionJobStatus.NotRunning) {
            map.delete(name);
        }
        else {
            map.set(name, status);
        }
    }
    getJobStatusMap() {
        if (!this._jobStatus) {
            this._jobStatus = new Map();
        }
        return this._jobStatus;
    }
    get embeddedMode() {
        return !!this._embeddedMode;
    }
    set embeddedMode(value) {
        this._embeddedMode = value;
    }
    get hideSidebar() {
        return !!this._hideSidebar;
    }
    set hideSidebar(value) {
        this._hideSidebar = value;
    }
    setBufferUsage(bufferUsage) {
        this._bufferUsage = bufferUsage;
    }
    setTrackData(id, data) {
        this.trackDataStore.set(id, data);
    }
    setRecordingLog(recordingLog) {
        this._recordingLog = recordingLog;
    }
    setAggregateData(kind, data) {
        this.aggregateDataStore.set(kind, data);
    }
    getCurResolution() {
        // Truncate the resolution to the closest power of 2 (in nanosecond space).
        // We choose to work in ns space because resolution is consumed be track
        // controllers for quantization and they rely on resolution to be a power
        // of 2 in nanosecond form. This is property does not hold if we work in
        // second space.
        //
        // This effectively means the resolution changes approximately every 6 zoom
        // levels. Logic: each zoom level represents a delta of 0.1 * (visible
        // window span). Therefore, zooming out by six levels is 1.1^6 ~= 2.
        // Similarily, zooming in six levels is 0.9^6 ~= 0.5.
        const pxToSec = this.frontendLocalState.timeScale.deltaPxToDuration(1);
        // TODO(b/186265930): Remove once fixed:
        if (!isFinite(pxToSec)) {
            // Resolution is in pixels per second so 1000 means 1px = 1ms.
            console.error(`b/186265930: Bad pxToSec suppressed ${pxToSec}`);
            return (0, time.fromNs)(Math.pow(2, Math.floor(Math.log2((0, time.toNs)(1000)))));
        }
        const pxToNs = Math.max((0, time.toNs)(pxToSec), 1);
        const resolution = (0, time.fromNs)(Math.pow(2, Math.floor(Math.log2(pxToNs))));
        const log2 = Math.log2((0, time.toNs)(resolution));
        if (log2 % 1 !== 0) {
            throw new Error(`Resolution should be a power of two.
        pxToSec: ${pxToSec},
        pxToNs: ${pxToNs},
        resolution: ${resolution},
        log2: ${Math.log2((0, time.toNs)(resolution))}`);
        }
        return resolution;
    }
    getCurrentEngine() {
        if (!this.state.currentEngineId) {
            return undefined;
        }
        return this.state.engines[this.state.currentEngineId];
    }
    makeSelection(action, tabToOpen = 'current_selection') {
        // A new selection should cancel the current search selection.
        exports.globals.dispatch(actions.Actions.setSearchIndex({ index: -1 }));
        const tab = action.type === 'deselect' ? undefined : tabToOpen;
        exports.globals.dispatch(actions.Actions.setCurrentTab({ tab }));
        exports.globals.dispatch(action);
    }
    resetForTesting() {
        this._dispatch = undefined;
        this._state = undefined;
        this._frontendLocalState = undefined;
        this._rafScheduler = undefined;
        this._serviceWorkerController = undefined;
        // TODO(hjd): Unify trackDataStore, queryResults, overviewStore, threads.
        this._trackDataStore = undefined;
        this._queryResults = undefined;
        this._overviewStore = undefined;
        this._threadMap = undefined;
        this._sliceDetails = undefined;
        this._threadStateDetails = undefined;
        this._aggregateDataStore = undefined;
        this._numQueriesQueued = 0;
        this._metricResult = undefined;
        this._currentSearchResults = {
            sliceIds: new Float64Array(0),
            tsStarts: new Float64Array(0),
            utids: new Float64Array(0),
            trackIds: [],
            sources: [],
            totalResults: 0,
        };
    }
    // This variable is set by the is_internal_user.js script if the user is a
    // googler. This is used to avoid exposing features that are not ready yet
    // for public consumption. The gated features themselves are not secret.
    // If a user has been detected as a Googler once, make that sticky in
    // localStorage, so that we keep treating them as such when they connect over
    // public networks.
    get isInternalUser() {
        if (this._isInternalUser === undefined) {
            this._isInternalUser = localStorage.getItem('isInternalUser') === '1';
        }
        return this._isInternalUser;
    }
    set isInternalUser(value) {
        localStorage.setItem('isInternalUser', value ? '1' : '0');
        this._isInternalUser = value;
    }
    get testing() {
        return this._testing;
    }
    // Used when switching to the legacy TraceViewer UI.
    // Most resources are cleaned up by replacing the current |window| object,
    // however pending RAFs and workers seem to outlive the |window| and need to
    // be cleaned up explicitly.
    shutdown() {
        this._rafScheduler.shutdown();
    }
}
exports.globals = new Globals();

});

var comparator_builder = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.EqualsBuilder = void 0;
// Simple builder-style class to implement object equality more succinctly.
class EqualsBuilder {
    constructor(first, second) {
        this.result = true;
        this.first = first;
        this.second = second;
    }
    comparePrimitive(getter) {
        if (this.result) {
            this.result = getter(this.first) === getter(this.second);
        }
        return this;
    }
    compare(comparator, getter) {
        if (this.result) {
            this.result = comparator(getter(this.first), getter(this.second));
        }
        return this;
    }
    equals() {
        return this.result;
    }
}
exports.EqualsBuilder = EqualsBuilder;

});

var pivot_table_redux_types = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.aggregationKey = exports.columnKey = exports.aggregationEquals = exports.toggleEnabled = exports.tableColumnEquals = void 0;

function tableColumnEquals(t1, t2) {
    switch (t1.kind) {
        case 'argument': {
            return t2.kind === 'argument' && t1.argument === t2.argument;
        }
        case 'regular': {
            return t2.kind === 'regular' && t1.table === t2.table &&
                t1.column === t2.column;
        }
    }
}
exports.tableColumnEquals = tableColumnEquals;
function toggleEnabled(compare, arr, column, enabled) {
    if (enabled && arr.find((value) => compare(column, value)) === undefined) {
        arr.push(column);
    }
    if (!enabled) {
        const index = arr.findIndex((value) => compare(column, value));
        if (index !== -1) {
            arr.splice(index, 1);
        }
    }
}
exports.toggleEnabled = toggleEnabled;
function aggregationEquals(agg1, agg2) {
    return new comparator_builder.EqualsBuilder(agg1, agg2)
        .comparePrimitive((agg) => agg.aggregationFunction)
        .compare(tableColumnEquals, (agg) => agg.column)
        .equals();
}
exports.aggregationEquals = aggregationEquals;
// Used to convert TableColumn to a string in order to store it in a Map, as
// ES6 does not support compound Set/Map keys. This function should only be used
// for interning keys, and does not have any requirements beyond different
// TableColumn objects mapping to different strings.
function columnKey(tableColumn) {
    switch (tableColumn.kind) {
        case 'argument': {
            return `argument:${tableColumn.argument}`;
        }
        case 'regular': {
            return `${tableColumn.table}.${tableColumn.column}`;
        }
    }
}
exports.columnKey = columnKey;
function aggregationKey(aggregation) {
    return `${aggregation.aggregationFunction}:${columnKey(aggregation.column)}`;
}
exports.aggregationKey = aggregationKey;

});

var colorName = {
	"aliceblue": [240, 248, 255],
	"antiquewhite": [250, 235, 215],
	"aqua": [0, 255, 255],
	"aquamarine": [127, 255, 212],
	"azure": [240, 255, 255],
	"beige": [245, 245, 220],
	"bisque": [255, 228, 196],
	"black": [0, 0, 0],
	"blanchedalmond": [255, 235, 205],
	"blue": [0, 0, 255],
	"blueviolet": [138, 43, 226],
	"brown": [165, 42, 42],
	"burlywood": [222, 184, 135],
	"cadetblue": [95, 158, 160],
	"chartreuse": [127, 255, 0],
	"chocolate": [210, 105, 30],
	"coral": [255, 127, 80],
	"cornflowerblue": [100, 149, 237],
	"cornsilk": [255, 248, 220],
	"crimson": [220, 20, 60],
	"cyan": [0, 255, 255],
	"darkblue": [0, 0, 139],
	"darkcyan": [0, 139, 139],
	"darkgoldenrod": [184, 134, 11],
	"darkgray": [169, 169, 169],
	"darkgreen": [0, 100, 0],
	"darkgrey": [169, 169, 169],
	"darkkhaki": [189, 183, 107],
	"darkmagenta": [139, 0, 139],
	"darkolivegreen": [85, 107, 47],
	"darkorange": [255, 140, 0],
	"darkorchid": [153, 50, 204],
	"darkred": [139, 0, 0],
	"darksalmon": [233, 150, 122],
	"darkseagreen": [143, 188, 143],
	"darkslateblue": [72, 61, 139],
	"darkslategray": [47, 79, 79],
	"darkslategrey": [47, 79, 79],
	"darkturquoise": [0, 206, 209],
	"darkviolet": [148, 0, 211],
	"deeppink": [255, 20, 147],
	"deepskyblue": [0, 191, 255],
	"dimgray": [105, 105, 105],
	"dimgrey": [105, 105, 105],
	"dodgerblue": [30, 144, 255],
	"firebrick": [178, 34, 34],
	"floralwhite": [255, 250, 240],
	"forestgreen": [34, 139, 34],
	"fuchsia": [255, 0, 255],
	"gainsboro": [220, 220, 220],
	"ghostwhite": [248, 248, 255],
	"gold": [255, 215, 0],
	"goldenrod": [218, 165, 32],
	"gray": [128, 128, 128],
	"green": [0, 128, 0],
	"greenyellow": [173, 255, 47],
	"grey": [128, 128, 128],
	"honeydew": [240, 255, 240],
	"hotpink": [255, 105, 180],
	"indianred": [205, 92, 92],
	"indigo": [75, 0, 130],
	"ivory": [255, 255, 240],
	"khaki": [240, 230, 140],
	"lavender": [230, 230, 250],
	"lavenderblush": [255, 240, 245],
	"lawngreen": [124, 252, 0],
	"lemonchiffon": [255, 250, 205],
	"lightblue": [173, 216, 230],
	"lightcoral": [240, 128, 128],
	"lightcyan": [224, 255, 255],
	"lightgoldenrodyellow": [250, 250, 210],
	"lightgray": [211, 211, 211],
	"lightgreen": [144, 238, 144],
	"lightgrey": [211, 211, 211],
	"lightpink": [255, 182, 193],
	"lightsalmon": [255, 160, 122],
	"lightseagreen": [32, 178, 170],
	"lightskyblue": [135, 206, 250],
	"lightslategray": [119, 136, 153],
	"lightslategrey": [119, 136, 153],
	"lightsteelblue": [176, 196, 222],
	"lightyellow": [255, 255, 224],
	"lime": [0, 255, 0],
	"limegreen": [50, 205, 50],
	"linen": [250, 240, 230],
	"magenta": [255, 0, 255],
	"maroon": [128, 0, 0],
	"mediumaquamarine": [102, 205, 170],
	"mediumblue": [0, 0, 205],
	"mediumorchid": [186, 85, 211],
	"mediumpurple": [147, 112, 219],
	"mediumseagreen": [60, 179, 113],
	"mediumslateblue": [123, 104, 238],
	"mediumspringgreen": [0, 250, 154],
	"mediumturquoise": [72, 209, 204],
	"mediumvioletred": [199, 21, 133],
	"midnightblue": [25, 25, 112],
	"mintcream": [245, 255, 250],
	"mistyrose": [255, 228, 225],
	"moccasin": [255, 228, 181],
	"navajowhite": [255, 222, 173],
	"navy": [0, 0, 128],
	"oldlace": [253, 245, 230],
	"olive": [128, 128, 0],
	"olivedrab": [107, 142, 35],
	"orange": [255, 165, 0],
	"orangered": [255, 69, 0],
	"orchid": [218, 112, 214],
	"palegoldenrod": [238, 232, 170],
	"palegreen": [152, 251, 152],
	"paleturquoise": [175, 238, 238],
	"palevioletred": [219, 112, 147],
	"papayawhip": [255, 239, 213],
	"peachpuff": [255, 218, 185],
	"peru": [205, 133, 63],
	"pink": [255, 192, 203],
	"plum": [221, 160, 221],
	"powderblue": [176, 224, 230],
	"purple": [128, 0, 128],
	"rebeccapurple": [102, 51, 153],
	"red": [255, 0, 0],
	"rosybrown": [188, 143, 143],
	"royalblue": [65, 105, 225],
	"saddlebrown": [139, 69, 19],
	"salmon": [250, 128, 114],
	"sandybrown": [244, 164, 96],
	"seagreen": [46, 139, 87],
	"seashell": [255, 245, 238],
	"sienna": [160, 82, 45],
	"silver": [192, 192, 192],
	"skyblue": [135, 206, 235],
	"slateblue": [106, 90, 205],
	"slategray": [112, 128, 144],
	"slategrey": [112, 128, 144],
	"snow": [255, 250, 250],
	"springgreen": [0, 255, 127],
	"steelblue": [70, 130, 180],
	"tan": [210, 180, 140],
	"teal": [0, 128, 128],
	"thistle": [216, 191, 216],
	"tomato": [255, 99, 71],
	"turquoise": [64, 224, 208],
	"violet": [238, 130, 238],
	"wheat": [245, 222, 179],
	"white": [255, 255, 255],
	"whitesmoke": [245, 245, 245],
	"yellow": [255, 255, 0],
	"yellowgreen": [154, 205, 50]
};

/* MIT license */
/* eslint-disable no-mixed-operators */


// NOTE: conversions should only return primitive values (i.e. arrays, or
//       values that give correct `typeof` results).
//       do not use box values types (i.e. Number(), String(), etc.)

const reverseKeywords = {};
for (const key of Object.keys(colorName)) {
	reverseKeywords[colorName[key]] = key;
}

const convert = {
	rgb: {channels: 3, labels: 'rgb'},
	hsl: {channels: 3, labels: 'hsl'},
	hsv: {channels: 3, labels: 'hsv'},
	hwb: {channels: 3, labels: 'hwb'},
	cmyk: {channels: 4, labels: 'cmyk'},
	xyz: {channels: 3, labels: 'xyz'},
	lab: {channels: 3, labels: 'lab'},
	lch: {channels: 3, labels: 'lch'},
	hex: {channels: 1, labels: ['hex']},
	keyword: {channels: 1, labels: ['keyword']},
	ansi16: {channels: 1, labels: ['ansi16']},
	ansi256: {channels: 1, labels: ['ansi256']},
	hcg: {channels: 3, labels: ['h', 'c', 'g']},
	apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
	gray: {channels: 1, labels: ['gray']}
};

var conversions = convert;

// Hide .channels and .labels properties
for (const model of Object.keys(convert)) {
	if (!('channels' in convert[model])) {
		throw new Error('missing channels property: ' + model);
	}

	if (!('labels' in convert[model])) {
		throw new Error('missing channel labels property: ' + model);
	}

	if (convert[model].labels.length !== convert[model].channels) {
		throw new Error('channel and label counts mismatch: ' + model);
	}

	const {channels, labels} = convert[model];
	delete convert[model].channels;
	delete convert[model].labels;
	Object.defineProperty(convert[model], 'channels', {value: channels});
	Object.defineProperty(convert[model], 'labels', {value: labels});
}

convert.rgb.hsl = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const min = Math.min(r, g, b);
	const max = Math.max(r, g, b);
	const delta = max - min;
	let h;
	let s;

	if (max === min) {
		h = 0;
	} else if (r === max) {
		h = (g - b) / delta;
	} else if (g === max) {
		h = 2 + (b - r) / delta;
	} else if (b === max) {
		h = 4 + (r - g) / delta;
	}

	h = Math.min(h * 60, 360);

	if (h < 0) {
		h += 360;
	}

	const l = (min + max) / 2;

	if (max === min) {
		s = 0;
	} else if (l <= 0.5) {
		s = delta / (max + min);
	} else {
		s = delta / (2 - max - min);
	}

	return [h, s * 100, l * 100];
};

convert.rgb.hsv = function (rgb) {
	let rdif;
	let gdif;
	let bdif;
	let h;
	let s;

	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const v = Math.max(r, g, b);
	const diff = v - Math.min(r, g, b);
	const diffc = function (c) {
		return (v - c) / 6 / diff + 1 / 2;
	};

	if (diff === 0) {
		h = 0;
		s = 0;
	} else {
		s = diff / v;
		rdif = diffc(r);
		gdif = diffc(g);
		bdif = diffc(b);

		if (r === v) {
			h = bdif - gdif;
		} else if (g === v) {
			h = (1 / 3) + rdif - bdif;
		} else if (b === v) {
			h = (2 / 3) + gdif - rdif;
		}

		if (h < 0) {
			h += 1;
		} else if (h > 1) {
			h -= 1;
		}
	}

	return [
		h * 360,
		s * 100,
		v * 100
	];
};

convert.rgb.hwb = function (rgb) {
	const r = rgb[0];
	const g = rgb[1];
	let b = rgb[2];
	const h = convert.rgb.hsl(rgb)[0];
	const w = 1 / 255 * Math.min(r, Math.min(g, b));

	b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

	return [h, w * 100, b * 100];
};

convert.rgb.cmyk = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;

	const k = Math.min(1 - r, 1 - g, 1 - b);
	const c = (1 - r - k) / (1 - k) || 0;
	const m = (1 - g - k) / (1 - k) || 0;
	const y = (1 - b - k) / (1 - k) || 0;

	return [c * 100, m * 100, y * 100, k * 100];
};

function comparativeDistance(x, y) {
	/*
		See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
	*/
	return (
		((x[0] - y[0]) ** 2) +
		((x[1] - y[1]) ** 2) +
		((x[2] - y[2]) ** 2)
	);
}

convert.rgb.keyword = function (rgb) {
	const reversed = reverseKeywords[rgb];
	if (reversed) {
		return reversed;
	}

	let currentClosestDistance = Infinity;
	let currentClosestKeyword;

	for (const keyword of Object.keys(colorName)) {
		const value = colorName[keyword];

		// Compute comparative distance
		const distance = comparativeDistance(rgb, value);

		// Check if its less, if so set as closest
		if (distance < currentClosestDistance) {
			currentClosestDistance = distance;
			currentClosestKeyword = keyword;
		}
	}

	return currentClosestKeyword;
};

convert.keyword.rgb = function (keyword) {
	return colorName[keyword];
};

convert.rgb.xyz = function (rgb) {
	let r = rgb[0] / 255;
	let g = rgb[1] / 255;
	let b = rgb[2] / 255;

	// Assume sRGB
	r = r > 0.04045 ? (((r + 0.055) / 1.055) ** 2.4) : (r / 12.92);
	g = g > 0.04045 ? (((g + 0.055) / 1.055) ** 2.4) : (g / 12.92);
	b = b > 0.04045 ? (((b + 0.055) / 1.055) ** 2.4) : (b / 12.92);

	const x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
	const y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
	const z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

	return [x * 100, y * 100, z * 100];
};

convert.rgb.lab = function (rgb) {
	const xyz = convert.rgb.xyz(rgb);
	let x = xyz[0];
	let y = xyz[1];
	let z = xyz[2];

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

	const l = (116 * y) - 16;
	const a = 500 * (x - y);
	const b = 200 * (y - z);

	return [l, a, b];
};

convert.hsl.rgb = function (hsl) {
	const h = hsl[0] / 360;
	const s = hsl[1] / 100;
	const l = hsl[2] / 100;
	let t2;
	let t3;
	let val;

	if (s === 0) {
		val = l * 255;
		return [val, val, val];
	}

	if (l < 0.5) {
		t2 = l * (1 + s);
	} else {
		t2 = l + s - l * s;
	}

	const t1 = 2 * l - t2;

	const rgb = [0, 0, 0];
	for (let i = 0; i < 3; i++) {
		t3 = h + 1 / 3 * -(i - 1);
		if (t3 < 0) {
			t3++;
		}

		if (t3 > 1) {
			t3--;
		}

		if (6 * t3 < 1) {
			val = t1 + (t2 - t1) * 6 * t3;
		} else if (2 * t3 < 1) {
			val = t2;
		} else if (3 * t3 < 2) {
			val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
		} else {
			val = t1;
		}

		rgb[i] = val * 255;
	}

	return rgb;
};

convert.hsl.hsv = function (hsl) {
	const h = hsl[0];
	let s = hsl[1] / 100;
	let l = hsl[2] / 100;
	let smin = s;
	const lmin = Math.max(l, 0.01);

	l *= 2;
	s *= (l <= 1) ? l : 2 - l;
	smin *= lmin <= 1 ? lmin : 2 - lmin;
	const v = (l + s) / 2;
	const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

	return [h, sv * 100, v * 100];
};

convert.hsv.rgb = function (hsv) {
	const h = hsv[0] / 60;
	const s = hsv[1] / 100;
	let v = hsv[2] / 100;
	const hi = Math.floor(h) % 6;

	const f = h - Math.floor(h);
	const p = 255 * v * (1 - s);
	const q = 255 * v * (1 - (s * f));
	const t = 255 * v * (1 - (s * (1 - f)));
	v *= 255;

	switch (hi) {
		case 0:
			return [v, t, p];
		case 1:
			return [q, v, p];
		case 2:
			return [p, v, t];
		case 3:
			return [p, q, v];
		case 4:
			return [t, p, v];
		case 5:
			return [v, p, q];
	}
};

convert.hsv.hsl = function (hsv) {
	const h = hsv[0];
	const s = hsv[1] / 100;
	const v = hsv[2] / 100;
	const vmin = Math.max(v, 0.01);
	let sl;
	let l;

	l = (2 - s) * v;
	const lmin = (2 - s) * vmin;
	sl = s * vmin;
	sl /= (lmin <= 1) ? lmin : 2 - lmin;
	sl = sl || 0;
	l /= 2;

	return [h, sl * 100, l * 100];
};

// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
convert.hwb.rgb = function (hwb) {
	const h = hwb[0] / 360;
	let wh = hwb[1] / 100;
	let bl = hwb[2] / 100;
	const ratio = wh + bl;
	let f;

	// Wh + bl cant be > 1
	if (ratio > 1) {
		wh /= ratio;
		bl /= ratio;
	}

	const i = Math.floor(6 * h);
	const v = 1 - bl;
	f = 6 * h - i;

	if ((i & 0x01) !== 0) {
		f = 1 - f;
	}

	const n = wh + f * (v - wh); // Linear interpolation

	let r;
	let g;
	let b;
	/* eslint-disable max-statements-per-line,no-multi-spaces */
	switch (i) {
		default:
		case 6:
		case 0: r = v;  g = n;  b = wh; break;
		case 1: r = n;  g = v;  b = wh; break;
		case 2: r = wh; g = v;  b = n; break;
		case 3: r = wh; g = n;  b = v; break;
		case 4: r = n;  g = wh; b = v; break;
		case 5: r = v;  g = wh; b = n; break;
	}
	/* eslint-enable max-statements-per-line,no-multi-spaces */

	return [r * 255, g * 255, b * 255];
};

convert.cmyk.rgb = function (cmyk) {
	const c = cmyk[0] / 100;
	const m = cmyk[1] / 100;
	const y = cmyk[2] / 100;
	const k = cmyk[3] / 100;

	const r = 1 - Math.min(1, c * (1 - k) + k);
	const g = 1 - Math.min(1, m * (1 - k) + k);
	const b = 1 - Math.min(1, y * (1 - k) + k);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.rgb = function (xyz) {
	const x = xyz[0] / 100;
	const y = xyz[1] / 100;
	const z = xyz[2] / 100;
	let r;
	let g;
	let b;

	r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
	g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
	b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

	// Assume sRGB
	r = r > 0.0031308
		? ((1.055 * (r ** (1.0 / 2.4))) - 0.055)
		: r * 12.92;

	g = g > 0.0031308
		? ((1.055 * (g ** (1.0 / 2.4))) - 0.055)
		: g * 12.92;

	b = b > 0.0031308
		? ((1.055 * (b ** (1.0 / 2.4))) - 0.055)
		: b * 12.92;

	r = Math.min(Math.max(0, r), 1);
	g = Math.min(Math.max(0, g), 1);
	b = Math.min(Math.max(0, b), 1);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.lab = function (xyz) {
	let x = xyz[0];
	let y = xyz[1];
	let z = xyz[2];

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

	const l = (116 * y) - 16;
	const a = 500 * (x - y);
	const b = 200 * (y - z);

	return [l, a, b];
};

convert.lab.xyz = function (lab) {
	const l = lab[0];
	const a = lab[1];
	const b = lab[2];
	let x;
	let y;
	let z;

	y = (l + 16) / 116;
	x = a / 500 + y;
	z = y - b / 200;

	const y2 = y ** 3;
	const x2 = x ** 3;
	const z2 = z ** 3;
	y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
	x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
	z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

	x *= 95.047;
	y *= 100;
	z *= 108.883;

	return [x, y, z];
};

convert.lab.lch = function (lab) {
	const l = lab[0];
	const a = lab[1];
	const b = lab[2];
	let h;

	const hr = Math.atan2(b, a);
	h = hr * 360 / 2 / Math.PI;

	if (h < 0) {
		h += 360;
	}

	const c = Math.sqrt(a * a + b * b);

	return [l, c, h];
};

convert.lch.lab = function (lch) {
	const l = lch[0];
	const c = lch[1];
	const h = lch[2];

	const hr = h / 360 * 2 * Math.PI;
	const a = c * Math.cos(hr);
	const b = c * Math.sin(hr);

	return [l, a, b];
};

convert.rgb.ansi16 = function (args, saturation = null) {
	const [r, g, b] = args;
	let value = saturation === null ? convert.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization

	value = Math.round(value / 50);

	if (value === 0) {
		return 30;
	}

	let ansi = 30
		+ ((Math.round(b / 255) << 2)
		| (Math.round(g / 255) << 1)
		| Math.round(r / 255));

	if (value === 2) {
		ansi += 60;
	}

	return ansi;
};

convert.hsv.ansi16 = function (args) {
	// Optimization here; we already know the value and don't need to get
	// it converted for us.
	return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
};

convert.rgb.ansi256 = function (args) {
	const r = args[0];
	const g = args[1];
	const b = args[2];

	// We use the extended greyscale palette here, with the exception of
	// black and white. normal palette only has 4 greyscale shades.
	if (r === g && g === b) {
		if (r < 8) {
			return 16;
		}

		if (r > 248) {
			return 231;
		}

		return Math.round(((r - 8) / 247) * 24) + 232;
	}

	const ansi = 16
		+ (36 * Math.round(r / 255 * 5))
		+ (6 * Math.round(g / 255 * 5))
		+ Math.round(b / 255 * 5);

	return ansi;
};

convert.ansi16.rgb = function (args) {
	let color = args % 10;

	// Handle greyscale
	if (color === 0 || color === 7) {
		if (args > 50) {
			color += 3.5;
		}

		color = color / 10.5 * 255;

		return [color, color, color];
	}

	const mult = (~~(args > 50) + 1) * 0.5;
	const r = ((color & 1) * mult) * 255;
	const g = (((color >> 1) & 1) * mult) * 255;
	const b = (((color >> 2) & 1) * mult) * 255;

	return [r, g, b];
};

convert.ansi256.rgb = function (args) {
	// Handle greyscale
	if (args >= 232) {
		const c = (args - 232) * 10 + 8;
		return [c, c, c];
	}

	args -= 16;

	let rem;
	const r = Math.floor(args / 36) / 5 * 255;
	const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
	const b = (rem % 6) / 5 * 255;

	return [r, g, b];
};

convert.rgb.hex = function (args) {
	const integer = ((Math.round(args[0]) & 0xFF) << 16)
		+ ((Math.round(args[1]) & 0xFF) << 8)
		+ (Math.round(args[2]) & 0xFF);

	const string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.hex.rgb = function (args) {
	const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
	if (!match) {
		return [0, 0, 0];
	}

	let colorString = match[0];

	if (match[0].length === 3) {
		colorString = colorString.split('').map(char => {
			return char + char;
		}).join('');
	}

	const integer = parseInt(colorString, 16);
	const r = (integer >> 16) & 0xFF;
	const g = (integer >> 8) & 0xFF;
	const b = integer & 0xFF;

	return [r, g, b];
};

convert.rgb.hcg = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const max = Math.max(Math.max(r, g), b);
	const min = Math.min(Math.min(r, g), b);
	const chroma = (max - min);
	let grayscale;
	let hue;

	if (chroma < 1) {
		grayscale = min / (1 - chroma);
	} else {
		grayscale = 0;
	}

	if (chroma <= 0) {
		hue = 0;
	} else
	if (max === r) {
		hue = ((g - b) / chroma) % 6;
	} else
	if (max === g) {
		hue = 2 + (b - r) / chroma;
	} else {
		hue = 4 + (r - g) / chroma;
	}

	hue /= 6;
	hue %= 1;

	return [hue * 360, chroma * 100, grayscale * 100];
};

convert.hsl.hcg = function (hsl) {
	const s = hsl[1] / 100;
	const l = hsl[2] / 100;

	const c = l < 0.5 ? (2.0 * s * l) : (2.0 * s * (1.0 - l));

	let f = 0;
	if (c < 1.0) {
		f = (l - 0.5 * c) / (1.0 - c);
	}

	return [hsl[0], c * 100, f * 100];
};

convert.hsv.hcg = function (hsv) {
	const s = hsv[1] / 100;
	const v = hsv[2] / 100;

	const c = s * v;
	let f = 0;

	if (c < 1.0) {
		f = (v - c) / (1 - c);
	}

	return [hsv[0], c * 100, f * 100];
};

convert.hcg.rgb = function (hcg) {
	const h = hcg[0] / 360;
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	if (c === 0.0) {
		return [g * 255, g * 255, g * 255];
	}

	const pure = [0, 0, 0];
	const hi = (h % 1) * 6;
	const v = hi % 1;
	const w = 1 - v;
	let mg = 0;

	/* eslint-disable max-statements-per-line */
	switch (Math.floor(hi)) {
		case 0:
			pure[0] = 1; pure[1] = v; pure[2] = 0; break;
		case 1:
			pure[0] = w; pure[1] = 1; pure[2] = 0; break;
		case 2:
			pure[0] = 0; pure[1] = 1; pure[2] = v; break;
		case 3:
			pure[0] = 0; pure[1] = w; pure[2] = 1; break;
		case 4:
			pure[0] = v; pure[1] = 0; pure[2] = 1; break;
		default:
			pure[0] = 1; pure[1] = 0; pure[2] = w;
	}
	/* eslint-enable max-statements-per-line */

	mg = (1.0 - c) * g;

	return [
		(c * pure[0] + mg) * 255,
		(c * pure[1] + mg) * 255,
		(c * pure[2] + mg) * 255
	];
};

convert.hcg.hsv = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	const v = c + g * (1.0 - c);
	let f = 0;

	if (v > 0.0) {
		f = c / v;
	}

	return [hcg[0], f * 100, v * 100];
};

convert.hcg.hsl = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	const l = g * (1.0 - c) + 0.5 * c;
	let s = 0;

	if (l > 0.0 && l < 0.5) {
		s = c / (2 * l);
	} else
	if (l >= 0.5 && l < 1.0) {
		s = c / (2 * (1 - l));
	}

	return [hcg[0], s * 100, l * 100];
};

convert.hcg.hwb = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;
	const v = c + g * (1.0 - c);
	return [hcg[0], (v - c) * 100, (1 - v) * 100];
};

convert.hwb.hcg = function (hwb) {
	const w = hwb[1] / 100;
	const b = hwb[2] / 100;
	const v = 1 - b;
	const c = v - w;
	let g = 0;

	if (c < 1) {
		g = (v - c) / (1 - c);
	}

	return [hwb[0], c * 100, g * 100];
};

convert.apple.rgb = function (apple) {
	return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
};

convert.rgb.apple = function (rgb) {
	return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
};

convert.gray.rgb = function (args) {
	return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
};

convert.gray.hsl = function (args) {
	return [0, 0, args[0]];
};

convert.gray.hsv = convert.gray.hsl;

convert.gray.hwb = function (gray) {
	return [0, 100, gray[0]];
};

convert.gray.cmyk = function (gray) {
	return [0, 0, 0, gray[0]];
};

convert.gray.lab = function (gray) {
	return [gray[0], 0, 0];
};

convert.gray.hex = function (gray) {
	const val = Math.round(gray[0] / 100 * 255) & 0xFF;
	const integer = (val << 16) + (val << 8) + val;

	const string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.rgb.gray = function (rgb) {
	const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
	return [val / 255 * 100];
};

/*
	This function routes a model to all other models.

	all functions that are routed have a property `.conversion` attached
	to the returned synthetic function. This property is an array
	of strings, each with the steps in between the 'from' and 'to'
	color models (inclusive).

	conversions that are not possible simply are not included.
*/

function buildGraph() {
	const graph = {};
	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
	const models = Object.keys(conversions);

	for (let len = models.length, i = 0; i < len; i++) {
		graph[models[i]] = {
			// http://jsperf.com/1-vs-infinity
			// micro-opt, but this is simple.
			distance: -1,
			parent: null
		};
	}

	return graph;
}

// https://en.wikipedia.org/wiki/Breadth-first_search
function deriveBFS(fromModel) {
	const graph = buildGraph();
	const queue = [fromModel]; // Unshift -> queue -> pop

	graph[fromModel].distance = 0;

	while (queue.length) {
		const current = queue.pop();
		const adjacents = Object.keys(conversions[current]);

		for (let len = adjacents.length, i = 0; i < len; i++) {
			const adjacent = adjacents[i];
			const node = graph[adjacent];

			if (node.distance === -1) {
				node.distance = graph[current].distance + 1;
				node.parent = current;
				queue.unshift(adjacent);
			}
		}
	}

	return graph;
}

function link(from, to) {
	return function (args) {
		return to(from(args));
	};
}

function wrapConversion(toModel, graph) {
	const path = [graph[toModel].parent, toModel];
	let fn = conversions[graph[toModel].parent][toModel];

	let cur = graph[toModel].parent;
	while (graph[cur].parent) {
		path.unshift(graph[cur].parent);
		fn = link(conversions[graph[cur].parent][cur], fn);
		cur = graph[cur].parent;
	}

	fn.conversion = path;
	return fn;
}

var route$1 = function (fromModel) {
	const graph = deriveBFS(fromModel);
	const conversion = {};

	const models = Object.keys(graph);
	for (let len = models.length, i = 0; i < len; i++) {
		const toModel = models[i];
		const node = graph[toModel];

		if (node.parent === null) {
			// No possible conversion, or this node is the source model.
			continue;
		}

		conversion[toModel] = wrapConversion(toModel, graph);
	}

	return conversion;
};

const convert$1 = {};

const models = Object.keys(conversions);

function wrapRaw(fn) {
	const wrappedFn = function (...args) {
		const arg0 = args[0];
		if (arg0 === undefined || arg0 === null) {
			return arg0;
		}

		if (arg0.length > 1) {
			args = arg0;
		}

		return fn(args);
	};

	// Preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

function wrapRounded(fn) {
	const wrappedFn = function (...args) {
		const arg0 = args[0];

		if (arg0 === undefined || arg0 === null) {
			return arg0;
		}

		if (arg0.length > 1) {
			args = arg0;
		}

		const result = fn(args);

		// We're assuming the result is an array here.
		// see notice in conversions.js; don't use box types
		// in conversion functions.
		if (typeof result === 'object') {
			for (let len = result.length, i = 0; i < len; i++) {
				result[i] = Math.round(result[i]);
			}
		}

		return result;
	};

	// Preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

models.forEach(fromModel => {
	convert$1[fromModel] = {};

	Object.defineProperty(convert$1[fromModel], 'channels', {value: conversions[fromModel].channels});
	Object.defineProperty(convert$1[fromModel], 'labels', {value: conversions[fromModel].labels});

	const routes = route$1(fromModel);
	const routeModels = Object.keys(routes);

	routeModels.forEach(toModel => {
		const fn = routes[toModel];

		convert$1[fromModel][toModel] = wrapRounded(fn);
		convert$1[fromModel][toModel].raw = wrapRaw(fn);
	});
});

var colorConvert = convert$1;

// Generated by Haxe 3.4.4
var hsluv = hsluv || {};
hsluv.Geometry = function() { };
hsluv.Geometry.intersectLineLine = function(a,b) {
	var x = (a.intercept - b.intercept) / (b.slope - a.slope);
	var y = a.slope * x + a.intercept;
	return { x : x, y : y};
};
hsluv.Geometry.distanceFromOrigin = function(point) {
	return Math.sqrt(Math.pow(point.x,2) + Math.pow(point.y,2));
};
hsluv.Geometry.distanceLineFromOrigin = function(line) {
	return Math.abs(line.intercept) / Math.sqrt(Math.pow(line.slope,2) + 1);
};
hsluv.Geometry.perpendicularThroughPoint = function(line,point) {
	var slope = -1 / line.slope;
	var intercept = point.y - slope * point.x;
	return { slope : slope, intercept : intercept};
};
hsluv.Geometry.angleFromOrigin = function(point) {
	return Math.atan2(point.y,point.x);
};
hsluv.Geometry.normalizeAngle = function(angle) {
	var m = 2 * Math.PI;
	return (angle % m + m) % m;
};
hsluv.Geometry.lengthOfRayUntilIntersect = function(theta,line) {
	return line.intercept / (Math.sin(theta) - line.slope * Math.cos(theta));
};
hsluv.Hsluv = function() { };
hsluv.Hsluv.getBounds = function(L) {
	var result = [];
	var sub1 = Math.pow(L + 16,3) / 1560896;
	var sub2 = sub1 > hsluv.Hsluv.epsilon ? sub1 : L / hsluv.Hsluv.kappa;
	var _g = 0;
	while(_g < 3) {
		var c = _g++;
		var m1 = hsluv.Hsluv.m[c][0];
		var m2 = hsluv.Hsluv.m[c][1];
		var m3 = hsluv.Hsluv.m[c][2];
		var _g1 = 0;
		while(_g1 < 2) {
			var t = _g1++;
			var top1 = (284517 * m1 - 94839 * m3) * sub2;
			var top2 = (838422 * m3 + 769860 * m2 + 731718 * m1) * L * sub2 - 769860 * t * L;
			var bottom = (632260 * m3 - 126452 * m2) * sub2 + 126452 * t;
			result.push({ slope : top1 / bottom, intercept : top2 / bottom});
		}
	}
	return result;
};
hsluv.Hsluv.maxSafeChromaForL = function(L) {
	var bounds = hsluv.Hsluv.getBounds(L);
	var min = Infinity;
	var _g = 0;
	while(_g < bounds.length) {
		var bound = bounds[_g];
		++_g;
		var length = hsluv.Geometry.distanceLineFromOrigin(bound);
		min = Math.min(min,length);
	}
	return min;
};
hsluv.Hsluv.maxChromaForLH = function(L,H) {
	var hrad = H / 360 * Math.PI * 2;
	var bounds = hsluv.Hsluv.getBounds(L);
	var min = Infinity;
	var _g = 0;
	while(_g < bounds.length) {
		var bound = bounds[_g];
		++_g;
		var length = hsluv.Geometry.lengthOfRayUntilIntersect(hrad,bound);
		if(length >= 0) {
			min = Math.min(min,length);
		}
	}
	return min;
};
hsluv.Hsluv.dotProduct = function(a,b) {
	var sum = 0;
	var _g1 = 0;
	var _g = a.length;
	while(_g1 < _g) {
		var i = _g1++;
		sum += a[i] * b[i];
	}
	return sum;
};
hsluv.Hsluv.fromLinear = function(c) {
	if(c <= 0.0031308) {
		return 12.92 * c;
	} else {
		return 1.055 * Math.pow(c,0.416666666666666685) - 0.055;
	}
};
hsluv.Hsluv.toLinear = function(c) {
	if(c > 0.04045) {
		return Math.pow((c + 0.055) / 1.055,2.4);
	} else {
		return c / 12.92;
	}
};
hsluv.Hsluv.xyzToRgb = function(tuple) {
	return [hsluv.Hsluv.fromLinear(hsluv.Hsluv.dotProduct(hsluv.Hsluv.m[0],tuple)),hsluv.Hsluv.fromLinear(hsluv.Hsluv.dotProduct(hsluv.Hsluv.m[1],tuple)),hsluv.Hsluv.fromLinear(hsluv.Hsluv.dotProduct(hsluv.Hsluv.m[2],tuple))];
};
hsluv.Hsluv.rgbToXyz = function(tuple) {
	var rgbl = [hsluv.Hsluv.toLinear(tuple[0]),hsluv.Hsluv.toLinear(tuple[1]),hsluv.Hsluv.toLinear(tuple[2])];
	return [hsluv.Hsluv.dotProduct(hsluv.Hsluv.minv[0],rgbl),hsluv.Hsluv.dotProduct(hsluv.Hsluv.minv[1],rgbl),hsluv.Hsluv.dotProduct(hsluv.Hsluv.minv[2],rgbl)];
};
hsluv.Hsluv.yToL = function(Y) {
	if(Y <= hsluv.Hsluv.epsilon) {
		return Y / hsluv.Hsluv.refY * hsluv.Hsluv.kappa;
	} else {
		return 116 * Math.pow(Y / hsluv.Hsluv.refY,0.333333333333333315) - 16;
	}
};
hsluv.Hsluv.lToY = function(L) {
	if(L <= 8) {
		return hsluv.Hsluv.refY * L / hsluv.Hsluv.kappa;
	} else {
		return hsluv.Hsluv.refY * Math.pow((L + 16) / 116,3);
	}
};
hsluv.Hsluv.xyzToLuv = function(tuple) {
	var X = tuple[0];
	var Y = tuple[1];
	var Z = tuple[2];
	var divider = X + 15 * Y + 3 * Z;
	var varU = 4 * X;
	var varV = 9 * Y;
	if(divider != 0) {
		varU /= divider;
		varV /= divider;
	} else {
		varU = NaN;
		varV = NaN;
	}
	var L = hsluv.Hsluv.yToL(Y);
	if(L == 0) {
		return [0,0,0];
	}
	var U = 13 * L * (varU - hsluv.Hsluv.refU);
	var V = 13 * L * (varV - hsluv.Hsluv.refV);
	return [L,U,V];
};
hsluv.Hsluv.luvToXyz = function(tuple) {
	var L = tuple[0];
	var U = tuple[1];
	var V = tuple[2];
	if(L == 0) {
		return [0,0,0];
	}
	var varU = U / (13 * L) + hsluv.Hsluv.refU;
	var varV = V / (13 * L) + hsluv.Hsluv.refV;
	var Y = hsluv.Hsluv.lToY(L);
	var X = 0 - 9 * Y * varU / ((varU - 4) * varV - varU * varV);
	var Z = (9 * Y - 15 * varV * Y - varV * X) / (3 * varV);
	return [X,Y,Z];
};
hsluv.Hsluv.luvToLch = function(tuple) {
	var L = tuple[0];
	var U = tuple[1];
	var V = tuple[2];
	var C = Math.sqrt(U * U + V * V);
	var H;
	if(C < 0.00000001) {
		H = 0;
	} else {
		var Hrad = Math.atan2(V,U);
		H = Hrad * 180.0 / Math.PI;
		if(H < 0) {
			H = 360 + H;
		}
	}
	return [L,C,H];
};
hsluv.Hsluv.lchToLuv = function(tuple) {
	var L = tuple[0];
	var C = tuple[1];
	var H = tuple[2];
	var Hrad = H / 360.0 * 2 * Math.PI;
	var U = Math.cos(Hrad) * C;
	var V = Math.sin(Hrad) * C;
	return [L,U,V];
};
hsluv.Hsluv.hsluvToLch = function(tuple) {
	var H = tuple[0];
	var S = tuple[1];
	var L = tuple[2];
	if(L > 99.9999999) {
		return [100,0,H];
	}
	if(L < 0.00000001) {
		return [0,0,H];
	}
	var max = hsluv.Hsluv.maxChromaForLH(L,H);
	var C = max / 100 * S;
	return [L,C,H];
};
hsluv.Hsluv.lchToHsluv = function(tuple) {
	var L = tuple[0];
	var C = tuple[1];
	var H = tuple[2];
	if(L > 99.9999999) {
		return [H,0,100];
	}
	if(L < 0.00000001) {
		return [H,0,0];
	}
	var max = hsluv.Hsluv.maxChromaForLH(L,H);
	var S = C / max * 100;
	return [H,S,L];
};
hsluv.Hsluv.hpluvToLch = function(tuple) {
	var H = tuple[0];
	var S = tuple[1];
	var L = tuple[2];
	if(L > 99.9999999) {
		return [100,0,H];
	}
	if(L < 0.00000001) {
		return [0,0,H];
	}
	var max = hsluv.Hsluv.maxSafeChromaForL(L);
	var C = max / 100 * S;
	return [L,C,H];
};
hsluv.Hsluv.lchToHpluv = function(tuple) {
	var L = tuple[0];
	var C = tuple[1];
	var H = tuple[2];
	if(L > 99.9999999) {
		return [H,0,100];
	}
	if(L < 0.00000001) {
		return [H,0,0];
	}
	var max = hsluv.Hsluv.maxSafeChromaForL(L);
	var S = C / max * 100;
	return [H,S,L];
};
hsluv.Hsluv.rgbToHex = function(tuple) {
	var h = "#";
	var _g = 0;
	while(_g < 3) {
		var i = _g++;
		var chan = tuple[i];
		var c = Math.round(chan * 255);
		var digit2 = c % 16;
		var digit1 = (c - digit2) / 16 | 0;
		h += hsluv.Hsluv.hexChars.charAt(digit1) + hsluv.Hsluv.hexChars.charAt(digit2);
	}
	return h;
};
hsluv.Hsluv.hexToRgb = function(hex) {
	hex = hex.toLowerCase();
	var ret = [];
	var _g = 0;
	while(_g < 3) {
		var i = _g++;
		var digit1 = hsluv.Hsluv.hexChars.indexOf(hex.charAt(i * 2 + 1));
		var digit2 = hsluv.Hsluv.hexChars.indexOf(hex.charAt(i * 2 + 2));
		var n = digit1 * 16 + digit2;
		ret.push(n / 255.0);
	}
	return ret;
};
hsluv.Hsluv.lchToRgb = function(tuple) {
	return hsluv.Hsluv.xyzToRgb(hsluv.Hsluv.luvToXyz(hsluv.Hsluv.lchToLuv(tuple)));
};
hsluv.Hsluv.rgbToLch = function(tuple) {
	return hsluv.Hsluv.luvToLch(hsluv.Hsluv.xyzToLuv(hsluv.Hsluv.rgbToXyz(tuple)));
};
hsluv.Hsluv.hsluvToRgb = function(tuple) {
	return hsluv.Hsluv.lchToRgb(hsluv.Hsluv.hsluvToLch(tuple));
};
hsluv.Hsluv.rgbToHsluv = function(tuple) {
	return hsluv.Hsluv.lchToHsluv(hsluv.Hsluv.rgbToLch(tuple));
};
hsluv.Hsluv.hpluvToRgb = function(tuple) {
	return hsluv.Hsluv.lchToRgb(hsluv.Hsluv.hpluvToLch(tuple));
};
hsluv.Hsluv.rgbToHpluv = function(tuple) {
	return hsluv.Hsluv.lchToHpluv(hsluv.Hsluv.rgbToLch(tuple));
};
hsluv.Hsluv.hsluvToHex = function(tuple) {
	return hsluv.Hsluv.rgbToHex(hsluv.Hsluv.hsluvToRgb(tuple));
};
hsluv.Hsluv.hpluvToHex = function(tuple) {
	return hsluv.Hsluv.rgbToHex(hsluv.Hsluv.hpluvToRgb(tuple));
};
hsluv.Hsluv.hexToHsluv = function(s) {
	return hsluv.Hsluv.rgbToHsluv(hsluv.Hsluv.hexToRgb(s));
};
hsluv.Hsluv.hexToHpluv = function(s) {
	return hsluv.Hsluv.rgbToHpluv(hsluv.Hsluv.hexToRgb(s));
};
hsluv.Hsluv.m = [[3.240969941904521,-1.537383177570093,-0.498610760293],[-0.96924363628087,1.87596750150772,0.041555057407175],[0.055630079696993,-0.20397695888897,1.056971514242878]];
hsluv.Hsluv.minv = [[0.41239079926595,0.35758433938387,0.18048078840183],[0.21263900587151,0.71516867876775,0.072192315360733],[0.019330818715591,0.11919477979462,0.95053215224966]];
hsluv.Hsluv.refY = 1.0;
hsluv.Hsluv.refU = 0.19783000664283;
hsluv.Hsluv.refV = 0.46831999493879;
hsluv.Hsluv.kappa = 903.2962962;
hsluv.Hsluv.epsilon = 0.0088564516;
hsluv.Hsluv.hexChars = "0123456789abcdef";
var root = {
    "hsluvToRgb": hsluv.Hsluv.hsluvToRgb,
    "rgbToHsluv": hsluv.Hsluv.rgbToHsluv,
    "hpluvToRgb": hsluv.Hsluv.hpluvToRgb,
    "rgbToHpluv": hsluv.Hsluv.rgbToHpluv,
    "hsluvToHex": hsluv.Hsluv.hsluvToHex,
    "hexToHsluv": hsluv.Hsluv.hexToHsluv,
    "hpluvToHex": hsluv.Hsluv.hpluvToHex,
    "hexToHpluv": hsluv.Hsluv.hexToHpluv,
    "lchToHpluv": hsluv.Hsluv.lchToHpluv,
    "hpluvToLch": hsluv.Hsluv.hpluvToLch,
    "lchToHsluv": hsluv.Hsluv.lchToHsluv,
    "hsluvToLch": hsluv.Hsluv.hsluvToLch,
    "lchToLuv": hsluv.Hsluv.lchToLuv,
    "luvToLch": hsluv.Hsluv.luvToLch,
    "xyzToLuv": hsluv.Hsluv.xyzToLuv,
    "luvToXyz": hsluv.Hsluv.luvToXyz,
    "xyzToRgb": hsluv.Hsluv.xyzToRgb,
    "rgbToXyz": hsluv.Hsluv.rgbToXyz,
    "lchToRgb": hsluv.Hsluv.lchToRgb,
    "rgbToLch": hsluv.Hsluv.rgbToLch
};

var hsluv_1 = root;

var hsluv_cache = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.cachedHsluvToHex = void 0;

class HsluvCache {
    constructor() {
        this.storage = new Map();
    }
    get(hue, saturation, lightness) {
        const key = hue * 1e6 + saturation * 1e3 + lightness;
        const value = this.storage.get(key);
        if (value === undefined) {
            const computed = (0, hsluv_1.hsluvToHex)([hue, saturation, lightness]);
            this.storage.set(key, computed);
            return computed;
        }
        return value;
    }
}
const cache = new HsluvCache();
function cachedHsluvToHex(hue, saturation, lightness) {
    return cache.get(hue, saturation, lightness);
}
exports.cachedHsluvToHex = cachedHsluvToHex;

});

var colorizer = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.colorCompare = exports.colorToStr = exports.colorForThreadIdleSlice = exports.hslForSlice = exports.randomColor = exports.colorForThread = exports.colorForTid = exports.textColorForState = exports.colorForState = exports.hueForCpu = exports.GRAY_COLOR = void 0;


const MD_PALETTE = [
    { c: 'red', h: 4, s: 90, l: 58 },
    { c: 'pink', h: 340, s: 82, l: 52 },
    { c: 'purple', h: 291, s: 64, l: 42 },
    { c: 'deep purple', h: 262, s: 52, l: 47 },
    { c: 'indigo', h: 231, s: 48, l: 48 },
    { c: 'blue', h: 207, s: 90, l: 54 },
    { c: 'light blue', h: 199, s: 98, l: 48 },
    { c: 'cyan', h: 187, s: 100, l: 42 },
    { c: 'teal', h: 174, s: 100, l: 29 },
    { c: 'green', h: 122, s: 39, l: 49 },
    { c: 'light green', h: 88, s: 50, l: 53 },
    { c: 'lime', h: 66, s: 70, l: 54 },
    { c: 'amber', h: 45, s: 100, l: 51 },
    { c: 'orange', h: 36, s: 100, l: 50 },
    { c: 'deep orange', h: 14, s: 100, l: 57 },
    { c: 'brown', h: 16, s: 25, l: 38 },
    { c: 'blue gray', h: 200, s: 18, l: 46 },
    { c: 'yellow', h: 54, s: 100, l: 62 },
];
exports.GRAY_COLOR = {
    c: 'grey',
    h: 0,
    s: 0,
    l: 62,
};
function hash(s, max) {
    let hash = 0x811c9dc5 & 0xfffffff;
    for (let i = 0; i < s.length; i++) {
        hash ^= s.charCodeAt(i);
        hash = (hash * 16777619) & 0xffffffff;
    }
    return Math.abs(hash) % max;
}
function hueForCpu(cpu) {
    return (128 + (32 * cpu)) % 256;
}
exports.hueForCpu = hueForCpu;
const DESAT_RED = {
    c: 'desat red',
    h: 3,
    s: 30,
    l: 49,
};
const DARK_GREEN = {
    c: 'dark green',
    h: 120,
    s: 44,
    l: 34,
};
const LIME_GREEN = {
    c: 'lime green',
    h: 75,
    s: 55,
    l: 47,
};
const TRANSPARENT_WHITE = {
    c: 'white',
    h: 0,
    s: 1,
    l: 97,
    a: 0.55,
};
const ORANGE = {
    c: 'orange',
    h: 36,
    s: 100,
    l: 50,
};
const INDIGO = {
    c: 'indigo',
    h: 231,
    s: 48,
    l: 48,
};
function colorForState(state) {
    if (state === 'Running') {
        return DARK_GREEN;
    }
    else if (state.startsWith('Runnable')) {
        return LIME_GREEN;
    }
    else if (state.includes('Uninterruptible Sleep')) {
        if (state.includes('non-IO')) {
            return DESAT_RED;
        }
        return ORANGE;
    }
    else if (state.includes('Sleeping')) {
        return TRANSPARENT_WHITE;
    }
    return INDIGO;
}
exports.colorForState = colorForState;
function textColorForState(stateCode) {
    const background = colorForState(stateCode);
    return background.l > 80 ? '#404040' : '#fff';
}
exports.textColorForState = textColorForState;
function colorForTid(tid) {
    const colorIdx = hash(tid.toString(), MD_PALETTE.length);
    return Object.assign({}, MD_PALETTE[colorIdx]);
}
exports.colorForTid = colorForTid;
function colorForThread(thread) {
    if (thread === undefined) {
        return Object.assign({}, exports.GRAY_COLOR);
    }
    const tid = thread.pid ? thread.pid : thread.tid;
    return colorForTid(tid);
}
exports.colorForThread = colorForThread;
// 40 different random hues 9 degrees apart.
function randomColor() {
    const hue = Math.floor(Math.random() * 40) * 9;
    return '#' + colorConvert.hsl.hex([hue, 90, 30]);
}
exports.randomColor = randomColor;
// Chooses a color uniform at random based on hash(sliceName).  Returns [hue,
// saturation, lightness].
//
// Prefer converting this to an RGB color using hsluv, not the browser's
// built-in vanilla HSL handling.  This is because this function chooses
// hue/lightness uniform at random, but HSL is not perceptually uniform.  See
// https://www.boronine.com/2012/03/26/Color-Spaces-for-Human-Beings/.
//
// If isSelected, the color will be particularly dark, making it stand out.
function hslForSlice(sliceName, isSelected) {
    const hue = hash(sliceName, 360);
    // Saturation 100 would give the most differentiation between colors, but it's
    // garish.
    const saturation = 80;
    const lightness = isSelected ? 30 : hash(sliceName + 'x', 40) + 40;
    return [hue, saturation, lightness];
}
exports.hslForSlice = hslForSlice;
// Lightens the color for thread slices to represent wall time.
function colorForThreadIdleSlice(hue, saturation, lightness, isSelected) {
    // Increase lightness by 80% when selected and 40% otherwise,
    // without exceeding 88.
    let newLightness = isSelected ? lightness * 1.8 : lightness * 1.4;
    newLightness = Math.min(newLightness, 88);
    return (0, hsluv_cache.cachedHsluvToHex)(hue, saturation, newLightness);
}
exports.colorForThreadIdleSlice = colorForThreadIdleSlice;
function colorToStr(color) {
    if (color.a !== undefined) {
        return `hsla(${color.h}, ${color.s}%, ${color.l}%, ${color.a})`;
    }
    return `hsl(${color.h}, ${color.s}%, ${color.l}%)`;
}
exports.colorToStr = colorToStr;
function colorCompare(x, y) {
    return (x.h - y.h) || (x.s - y.s) || (x.l - y.l);
}
exports.colorCompare = colorCompare;

});

var flamegraph_util = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.findRootSize = exports.mergeCallsites = exports.expandCallsites = exports.DEFAULT_VIEWING_OPTION = exports.PERF_SAMPLES_KEY = exports.OBJECTS_ALLOCATED_KEY = exports.OBJECTS_ALLOCATED_NOT_FREED_KEY = exports.ALLOC_SPACE_MEMORY_ALLOCATED_KEY = exports.SPACE_MEMORY_ALLOCATED_NOT_FREED_KEY = void 0;
exports.SPACE_MEMORY_ALLOCATED_NOT_FREED_KEY = 'SPACE';
exports.ALLOC_SPACE_MEMORY_ALLOCATED_KEY = 'ALLOC_SPACE';
exports.OBJECTS_ALLOCATED_NOT_FREED_KEY = 'OBJECTS';
exports.OBJECTS_ALLOCATED_KEY = 'ALLOC_OBJECTS';
exports.PERF_SAMPLES_KEY = 'PERF_SAMPLES';
exports.DEFAULT_VIEWING_OPTION = exports.SPACE_MEMORY_ALLOCATED_NOT_FREED_KEY;
function expandCallsites(data, clickedCallsiteIndex) {
    if (clickedCallsiteIndex === -1)
        return data;
    const expandedCallsites = [];
    if (clickedCallsiteIndex >= data.length || clickedCallsiteIndex < -1) {
        return expandedCallsites;
    }
    const clickedCallsite = data[clickedCallsiteIndex];
    expandedCallsites.unshift(clickedCallsite);
    // Adding parents
    let parentId = clickedCallsite.parentId;
    while (parentId > -1) {
        expandedCallsites.unshift(data[parentId]);
        parentId = data[parentId].parentId;
    }
    // Adding children
    const parents = [];
    parents.push(clickedCallsiteIndex);
    for (let i = clickedCallsiteIndex + 1; i < data.length; i++) {
        const element = data[i];
        if (parents.includes(element.parentId)) {
            expandedCallsites.push(element);
            parents.push(element.id);
        }
    }
    return expandedCallsites;
}
exports.expandCallsites = expandCallsites;
// Merge callsites that have approximately width less than
// MIN_PIXEL_DISPLAYED. All small callsites in the same depth and with same
// parent will be merged to one with total size of all merged callsites.
function mergeCallsites(data, minSizeDisplayed) {
    const mergedData = [];
    const mergedCallsites = new Map();
    for (let i = 0; i < data.length; i++) {
        // When a small callsite is found, it will be merged with other small
        // callsites of the same depth. So if the current callsite has already been
        // merged we can skip it.
        if (mergedCallsites.has(data[i].id)) {
            continue;
        }
        const copiedCallsite = copyCallsite(data[i]);
        copiedCallsite.parentId =
            getCallsitesParentHash(copiedCallsite, mergedCallsites);
        let mergedAny = false;
        // If current callsite is small, find other small callsites with same depth
        // and parent and merge them into the current one, marking them as merged.
        if (copiedCallsite.totalSize <= minSizeDisplayed && i + 1 < data.length) {
            let j = i + 1;
            let nextCallsite = data[j];
            while (j < data.length && copiedCallsite.depth === nextCallsite.depth) {
                if (copiedCallsite.parentId ===
                    getCallsitesParentHash(nextCallsite, mergedCallsites) &&
                    nextCallsite.totalSize <= minSizeDisplayed) {
                    copiedCallsite.totalSize += nextCallsite.totalSize;
                    mergedCallsites.set(nextCallsite.id, copiedCallsite.id);
                    mergedAny = true;
                }
                j++;
                nextCallsite = data[j];
            }
            if (mergedAny) {
                copiedCallsite.name = '[merged]';
                copiedCallsite.merged = true;
            }
        }
        mergedData.push(copiedCallsite);
    }
    return mergedData;
}
exports.mergeCallsites = mergeCallsites;
function copyCallsite(callsite) {
    return {
        id: callsite.id,
        parentId: callsite.parentId,
        depth: callsite.depth,
        name: callsite.name,
        totalSize: callsite.totalSize,
        mapping: callsite.mapping,
        selfSize: callsite.selfSize,
        merged: callsite.merged,
        highlighted: callsite.highlighted,
        location: callsite.location,
    };
}
function getCallsitesParentHash(callsite, map) {
    return map.has(callsite.parentId) ? +map.get(callsite.parentId) :
        callsite.parentId;
}
function findRootSize(data) {
    let totalSize = 0;
    let i = 0;
    while (i < data.length && data[i].depth === 0) {
        totalSize += data[i].totalSize;
        i++;
    }
    return totalSize;
}
exports.findRootSize = findRootSize;

});

var actions = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Actions = exports.StateActions = void 0;








const DEBUG_SLICE_TRACK_KIND = 'DebugSliceTrack';
// export interface PostedScrollToRange {
//   timeStartMicros: string;
//   timeEndMicros: string;
// }
function clearTraceState(state) {
    const nextId = state.nextId;
    const recordConfig = state.recordConfig;
    const recordingTarget = state.recordingTarget;
    const fetchChromeCategories = state.fetchChromeCategories;
    const extensionInstalled = state.extensionInstalled;
    const availableAdbDevices = state.availableAdbDevices;
    const chromeCategories = state.chromeCategories;
    const newEngineMode = state.newEngineMode;
    Object.assign(state, (0, empty_state.createEmptyState)());
    state.nextId = nextId;
    state.recordConfig = recordConfig;
    state.recordingTarget = recordingTarget;
    state.fetchChromeCategories = fetchChromeCategories;
    state.extensionInstalled = extensionInstalled;
    state.availableAdbDevices = availableAdbDevices;
    state.chromeCategories = chromeCategories;
    state.newEngineMode = newEngineMode;
}
function generateNextId(draft) {
    const nextId = String(Number(draft.nextId) + 1);
    draft.nextId = nextId;
    return nextId;
}
// A helper to clean the state for a given removeable track.
// This is not exported as action to make it clear that not all
// tracks are removeable.
function removeTrack(state$1, trackId) {
    const track = state$1.tracks[trackId];
    delete state$1.tracks[trackId];
    const removeTrackId = (arr) => {
        const index = arr.indexOf(trackId);
        if (index !== -1)
            arr.splice(index, 1);
    };
    if (track.trackGroup === state.SCROLLING_TRACK_GROUP) {
        removeTrackId(state$1.scrollingTracks);
    }
    else if (track.trackGroup !== undefined) {
        removeTrackId(state$1.trackGroups[track.trackGroup].tracks);
    }
    state$1.pinnedTracks = state$1.pinnedTracks.filter((id) => id !== trackId);
}
exports.StateActions = {
    openTraceFromFile(state, args) {
        clearTraceState(state);
        const id = generateNextId(state);
        state.currentEngineId = id;
        state.engines[id] = {
            id,
            ready: false,
            source: { type: 'FILE', file: args.file },
        };
    },
    openTraceFromBuffer(state, args) {
        clearTraceState(state);
        const id = generateNextId(state);
        state.currentEngineId = id;
        state.engines[id] = {
            id,
            ready: false,
            source: Object.assign({ type: 'ARRAY_BUFFER' }, args),
        };
    },
    openTraceFromUrl(state, args) {
        clearTraceState(state);
        const id = generateNextId(state);
        state.currentEngineId = id;
        state.engines[id] = {
            id,
            ready: false,
            source: { type: 'URL', url: args.url },
        };
    },
    openTraceFromHttpRpc(state, _args) {
        clearTraceState(state);
        const id = generateNextId(state);
        state.currentEngineId = id;
        state.engines[id] = {
            id,
            ready: false,
            source: { type: 'HTTP_RPC' },
        };
    },
    setTraceUuid(state, args) {
        state.traceUuid = args.traceUuid;
    },
    fillUiTrackIdByTraceTrackId(state, trackState, uiTrackId) {
        const namespace = trackState.config.namespace;
        if (namespace !== undefined)
            return;
        const setUiTrackId = (trackId, uiTrackId) => {
            if (state.uiTrackIdByTraceTrackId[trackId] !== undefined &&
                state.uiTrackIdByTraceTrackId[trackId] !== uiTrackId) {
                throw new Error(`Trying to map track id ${trackId} to UI track ${uiTrackId}, already mapped to ${state.uiTrackIdByTraceTrackId[trackId]}`);
            }
            state.uiTrackIdByTraceTrackId[trackId] = uiTrackId;
        };
        const config = trackState.config;
        if (config.trackId !== undefined) {
            setUiTrackId(config.trackId, uiTrackId);
            return;
        }
        const multiple = trackState.config;
        if (multiple.trackIds !== undefined) {
            for (const trackId of multiple.trackIds) {
                setUiTrackId(trackId, uiTrackId);
            }
        }
    },
    addTracks(state$1, args) {
        args.tracks.forEach((track) => {
            const id = track.id === undefined ? generateNextId(state$1) : track.id;
            track.id = id;
            state$1.tracks[id] = track;
            this.fillUiTrackIdByTraceTrackId(state$1, track, id);
            if (track.trackGroup === state.SCROLLING_TRACK_GROUP) {
                state$1.scrollingTracks.push(id);
            }
            else if (track.trackGroup !== undefined) {
                (0, logging.assertExists)(state$1.trackGroups[track.trackGroup]).tracks.push(id);
            }
        });
    },
    setUtidToTrackSortKey(state, args) {
        state.utidToThreadSortKey = args.threadOrderingMetadata;
    },
    addTrack(state$1, args) {
        const id = args.id !== undefined ? args.id : generateNextId(state$1);
        state$1.tracks[id] = {
            id,
            engineId: args.engineId,
            kind: args.kind,
            name: args.name,
            trackSortKey: args.trackSortKey,
            trackGroup: args.trackGroup,
            config: args.config,
        };
        this.fillUiTrackIdByTraceTrackId(state$1, state$1.tracks[id], id);
        if (args.trackGroup === state.SCROLLING_TRACK_GROUP) {
            state$1.scrollingTracks.push(id);
        }
        else if (args.trackGroup !== undefined) {
            (0, logging.assertExists)(state$1.trackGroups[args.trackGroup]).tracks.push(id);
        }
    },
    addTrackGroup(state, 
    // Define ID in action so a track group can be referred to without running
    // the reducer.
    args) {
        state.trackGroups[args.id] = {
            engineId: args.engineId,
            name: args.name,
            id: args.id,
            collapsed: args.collapsed,
            tracks: [args.summaryTrackId],
        };
    },
    addDebugTrack(state$1, args) {
        if (state$1.debugTrackId !== undefined)
            return;
        const trackId = generateNextId(state$1);
        state$1.debugTrackId = trackId;
        this.addTrack(state$1, {
            id: trackId,
            engineId: args.engineId,
            kind: DEBUG_SLICE_TRACK_KIND,
            name: args.name,
            trackSortKey: state.PrimaryTrackSortKey.DEBUG_SLICE_TRACK,
            trackGroup: state.SCROLLING_TRACK_GROUP,
            config: {
                maxDepth: 1,
            },
        });
        this.toggleTrackPinned(state$1, { trackId });
    },
    removeDebugTrack(state, _) {
        const { debugTrackId } = state;
        if (debugTrackId === undefined)
            return;
        removeTrack(state, debugTrackId);
        state.debugTrackId = undefined;
    },
    removeVisualisedArgTracks(state, args) {
        for (const trackId of args.trackIds) {
            const track = state.tracks[trackId];
            const namespace = track.config.namespace;
            if (namespace === undefined) {
                throw new Error('All visualised arg tracks should have non-empty namespace');
            }
            removeTrack(state, trackId);
        }
    },
    maybeExpandOnlyTrackGroup(state, _) {
        const trackGroups = Object.values(state.trackGroups);
        if (trackGroups.length === 1) {
            trackGroups[0].collapsed = false;
        }
    },
    sortThreadTracks(state$1, _) {
        const getFullKey = (a) => {
            const track = state$1.tracks[a];
            const threadTrackSortKey = track.trackSortKey;
            if (threadTrackSortKey.utid === undefined) {
                const sortKey = track.trackSortKey;
                return [
                    sortKey,
                    0,
                    0,
                    0,
                ];
            }
            const threadSortKey = state$1.utidToThreadSortKey[threadTrackSortKey.utid];
            return [
                threadSortKey ? threadSortKey.sortKey :
                    state.PrimaryTrackSortKey.ORDINARY_THREAD,
                threadSortKey && threadSortKey.tid !== undefined ? threadSortKey.tid :
                    Number.MAX_VALUE,
                threadTrackSortKey.utid,
                threadTrackSortKey.priority,
            ];
        };
        // Use a numeric collator so threads are sorted as T1, T2, ..., T10, T11,
        // rather than T1, T10, T11, ..., T2, T20, T21 .
        const coll = new Intl.Collator([], { sensitivity: 'base', numeric: true });
        for (const group of Object.values(state$1.trackGroups)) {
            group.tracks.sort((a, b) => {
                const aRank = getFullKey(a);
                const bRank = getFullKey(b);
                for (let i = 0; i < aRank.length; i++) {
                    if (aRank[i] !== bRank[i])
                        return aRank[i] - bRank[i];
                }
                const aName = state$1.tracks[a].name.toLocaleLowerCase();
                const bName = state$1.tracks[b].name.toLocaleLowerCase();
                return coll.compare(aName, bName);
            });
        }
    },
    updateAggregateSorting(state, args) {
        let prefs = state.aggregatePreferences[args.id];
        if (!prefs) {
            prefs = { id: args.id };
            state.aggregatePreferences[args.id] = prefs;
        }
        if (!prefs.sorting || prefs.sorting.column !== args.column) {
            // No sorting set for current column.
            state.aggregatePreferences[args.id].sorting = {
                column: args.column,
                direction: 'DESC',
            };
        }
        else if (prefs.sorting.direction === 'DESC') {
            // Toggle the direction if the column is currently sorted.
            state.aggregatePreferences[args.id].sorting = {
                column: args.column,
                direction: 'ASC',
            };
        }
        else {
            // If direction is currently 'ASC' toggle to no sorting.
            state.aggregatePreferences[args.id].sorting = undefined;
        }
    },
    setVisibleTracks(state, args) {
        state.visibleTracks = args.tracks;
    },
    updateTrackConfig(state, args) {
        if (state.tracks[args.id] === undefined)
            return;
        state.tracks[args.id].config = args.config;
    },
    executeQuery(state, args) {
        state.queries[args.queryId] = {
            id: args.queryId,
            query: args.query,
            engineId: args.engineId,
        };
    },
    deleteQuery(state, args) {
        delete state.queries[args.queryId];
    },
    moveTrack(state, args) {
        const moveWithinTrackList = (trackList) => {
            const newList = [];
            for (let i = 0; i < trackList.length; i++) {
                const curTrackId = trackList[i];
                if (curTrackId === args.dstId && args.op === 'before') {
                    newList.push(args.srcId);
                }
                if (curTrackId !== args.srcId) {
                    newList.push(curTrackId);
                }
                if (curTrackId === args.dstId && args.op === 'after') {
                    newList.push(args.srcId);
                }
            }
            trackList.splice(0);
            newList.forEach((x) => {
                trackList.push(x);
            });
        };
        moveWithinTrackList(state.pinnedTracks);
        moveWithinTrackList(state.scrollingTracks);
    },
    toggleTrackPinned(state$1, args) {
        const id = args.trackId;
        const isPinned = state$1.pinnedTracks.includes(id);
        const trackGroup = (0, logging.assertExists)(state$1.tracks[id]).trackGroup;
        if (isPinned) {
            state$1.pinnedTracks.splice(state$1.pinnedTracks.indexOf(id), 1);
            if (trackGroup === state.SCROLLING_TRACK_GROUP) {
                state$1.scrollingTracks.unshift(id);
            }
        }
        else {
            if (trackGroup === state.SCROLLING_TRACK_GROUP) {
                state$1.scrollingTracks.splice(state$1.scrollingTracks.indexOf(id), 1);
            }
            state$1.pinnedTracks.push(id);
        }
    },
    toggleTrackGroupCollapsed(state, args) {
        const id = args.trackGroupId;
        const trackGroup = (0, logging.assertExists)(state.trackGroups[id]);
        trackGroup.collapsed = !trackGroup.collapsed;
    },
    requestTrackReload(state, _) {
        if (state.lastTrackReloadRequest) {
            state.lastTrackReloadRequest++;
        }
        else {
            state.lastTrackReloadRequest = 1;
        }
    },
    // TODO(hjd): engine.ready should be a published thing. If it's part
    // of the state it interacts badly with permalinks.
    setEngineReady(state, args) {
        const engine = state.engines[args.engineId];
        if (engine === undefined) {
            return;
        }
        engine.ready = args.ready;
        engine.mode = args.mode;
    },
    setNewEngineMode(state, args) {
        state.newEngineMode = args.mode;
    },
    // Marks all engines matching the given |mode| as failed.
    setEngineFailed(state, args) {
        for (const engine of Object.values(state.engines)) {
            if (engine.mode === args.mode)
                engine.failed = args.failure;
        }
    },
    createPermalink(state, args) {
        state.permalink = {
            requestId: generateNextId(state),
            hash: undefined,
            isRecordingConfig: args.isRecordingConfig,
        };
    },
    setPermalink(state, args) {
        // Drop any links for old requests.
        if (state.permalink.requestId !== args.requestId)
            return;
        state.permalink = args;
    },
    loadPermalink(state, args) {
        state.permalink = { requestId: generateNextId(state), hash: args.hash };
    },
    clearPermalink(state, _) {
        state.permalink = {};
    },
    setTraceTime(state, args) {
        state.traceTime = args;
    },
    updateStatus(state, args) {
        state.status = args;
    },
    // TODO(hjd): Remove setState - it causes problems due to reuse of ids.
    setState(state, args) {
        for (const key of Object.keys(state)) {
            delete state[key];
        }
        for (const key of Object.keys(args.newState)) {
            state[key] = args.newState[key];
        }
        // If we're loading from a permalink then none of the engines can
        // possibly be ready:
        for (const engine of Object.values(state.engines)) {
            engine.ready = false;
        }
    },
    setRecordConfig(state, args) {
        state.recordConfig = args.config;
        state.lastLoadedConfig = args.configType || { type: 'NONE' };
    },
    selectNote(state, args) {
        if (args.id) {
            state.currentSelection = {
                kind: 'NOTE',
                id: args.id,
            };
        }
    },
    addNote(state, args) {
        const id = generateNextId(state);
        state.notes[id] = {
            noteType: 'DEFAULT',
            id,
            timestamp: args.timestamp,
            color: args.color,
            text: '',
        };
        this.selectNote(state, { id });
    },
    markCurrentArea(state, args) {
        if (state.currentSelection === null ||
            state.currentSelection.kind !== 'AREA') {
            return;
        }
        const id = args.persistent ? generateNextId(state) : '0';
        const color = args.persistent ? args.color : '#344596';
        state.notes[id] = {
            noteType: 'AREA',
            id,
            areaId: state.currentSelection.areaId,
            color,
            text: '',
        };
        state.currentSelection.noteId = id;
    },
    toggleMarkCurrentArea(state, args) {
        const selection = state.currentSelection;
        if (selection != null && selection.kind === 'AREA' &&
            selection.noteId !== undefined) {
            this.removeNote(state, { id: selection.noteId });
        }
        else {
            const color = (0, colorizer.randomColor)();
            this.markCurrentArea(state, { color, persistent: args.persistent });
        }
    },
    markArea(state, args) {
        const areaId = generateNextId(state);
        (0, logging.assertTrue)(args.area.endSec >= args.area.startSec);
        state.areas[areaId] = {
            id: areaId,
            startSec: args.area.startSec,
            endSec: args.area.endSec,
            tracks: args.area.tracks,
        };
        const noteId = args.persistent ? generateNextId(state) : '0';
        const color = args.persistent ? (0, colorizer.randomColor)() : '#344596';
        state.notes[noteId] = {
            noteType: 'AREA',
            id: noteId,
            areaId,
            color,
            text: '',
        };
    },
    changeNoteColor(state, args) {
        const note = state.notes[args.id];
        if (note === undefined)
            return;
        note.color = args.newColor;
    },
    changeNoteText(state, args) {
        const note = state.notes[args.id];
        if (note === undefined)
            return;
        note.text = args.newText;
    },
    removeNote(state, args) {
        if (state.notes[args.id] === undefined)
            return;
        delete state.notes[args.id];
        // For regular notes, we clear the current selection but for an area note
        // we only want to clear the note/marking and leave the area selected.
        if (state.currentSelection === null)
            return;
        if (state.currentSelection.kind === 'NOTE' &&
            state.currentSelection.id === args.id) {
            state.currentSelection = null;
        }
        else if (state.currentSelection.kind === 'AREA' &&
            state.currentSelection.noteId === args.id) {
            state.currentSelection.noteId = undefined;
        }
    },
    selectSlice(state, args) {
        state.currentSelection = {
            kind: 'SLICE',
            id: args.id,
            trackId: args.trackId,
        };
        state.pendingScrollId = args.scroll ? args.id : undefined;
    },
    selectCounter(state, args) {
        state.currentSelection = {
            kind: 'COUNTER',
            leftTs: args.leftTs,
            rightTs: args.rightTs,
            id: args.id,
            trackId: args.trackId,
        };
    },
    selectHeapProfile(state, args) {
        state.currentSelection = {
            kind: 'HEAP_PROFILE',
            id: args.id,
            upid: args.upid,
            ts: args.ts,
            type: args.type,
        };
        this.openFlamegraph(state, {
            type: args.type,
            startNs: (0, time.toNs)(state.traceTime.startSec),
            endNs: args.ts,
            upids: [args.upid],
            viewingOption: flamegraph_util.DEFAULT_VIEWING_OPTION,
        });
    },
    selectPerfSamples(state, args) {
        state.currentSelection = {
            kind: 'PERF_SAMPLES',
            id: args.id,
            upid: args.upid,
            leftTs: args.leftTs,
            rightTs: args.rightTs,
            type: args.type,
        };
        this.openFlamegraph(state, {
            type: args.type,
            startNs: args.leftTs,
            endNs: args.rightTs,
            upids: [args.upid],
            viewingOption: flamegraph_util.PERF_SAMPLES_KEY,
        });
    },
    openFlamegraph(state, args) {
        state.currentFlamegraphState = {
            kind: 'FLAMEGRAPH_STATE',
            upids: args.upids,
            startNs: args.startNs,
            endNs: args.endNs,
            type: args.type,
            viewingOption: args.viewingOption,
            focusRegex: '',
        };
    },
    selectCpuProfileSample(state, args) {
        state.currentSelection = {
            kind: 'CPU_PROFILE_SAMPLE',
            id: args.id,
            utid: args.utid,
            ts: args.ts,
        };
    },
    expandFlamegraphState(state, args) {
        if (state.currentFlamegraphState === null)
            return;
        state.currentFlamegraphState.expandedCallsite = args.expandedCallsite;
    },
    changeViewFlamegraphState(state, args) {
        if (state.currentFlamegraphState === null)
            return;
        state.currentFlamegraphState.viewingOption = args.viewingOption;
    },
    changeFocusFlamegraphState(state, args) {
        if (state.currentFlamegraphState === null)
            return;
        state.currentFlamegraphState.focusRegex = args.focusRegex;
    },
    selectChromeSlice(state, args) {
        state.currentSelection = {
            kind: 'CHROME_SLICE',
            id: args.id,
            trackId: args.trackId,
            table: args.table,
        };
        state.pendingScrollId = args.scroll ? args.id : undefined;
    },
    clearPendingScrollId(state, _) {
        state.pendingScrollId = undefined;
    },
    selectThreadState(state, args) {
        state.currentSelection = {
            kind: 'THREAD_STATE',
            id: args.id,
            trackId: args.trackId,
        };
    },
    selectLog(state, args) {
        state.currentSelection = {
            kind: 'LOG',
            id: args.id,
            trackId: args.trackId,
        };
        state.pendingScrollId = args.scroll ? args.id : undefined;
    },
    deselect(state, _) {
        state.currentSelection = null;
    },
    updateLogsPagination(state, args) {
        state.logsPagination = args;
    },
    startRecording(state, _) {
        state.recordingInProgress = true;
        state.lastRecordingError = undefined;
        state.recordingCancelled = false;
    },
    stopRecording(state, _) {
        state.recordingInProgress = false;
    },
    cancelRecording(state, _) {
        state.recordingInProgress = false;
        state.recordingCancelled = true;
    },
    setExtensionAvailable(state, args) {
        state.extensionInstalled = args.available;
    },
    setRecordingTarget(state, args) {
        state.recordingTarget = args.target;
    },
    setFetchChromeCategories(state, args) {
        state.fetchChromeCategories = args.fetch;
    },
    setAvailableAdbDevices(state, args) {
        state.availableAdbDevices = args.devices;
    },
    setOmnibox(state, args) {
        state.frontendLocalState.omniboxState = args;
    },
    selectArea(state, args) {
        const areaId = generateNextId(state);
        (0, logging.assertTrue)(args.area.endSec >= args.area.startSec);
        state.areas[areaId] = {
            id: areaId,
            startSec: args.area.startSec,
            endSec: args.area.endSec,
            tracks: args.area.tracks,
        };
        state.currentSelection = { kind: 'AREA', areaId };
    },
    editArea(state, args) {
        (0, logging.assertTrue)(args.area.endSec >= args.area.startSec);
        state.areas[args.areaId] = {
            id: args.areaId,
            startSec: args.area.startSec,
            endSec: args.area.endSec,
            tracks: args.area.tracks,
        };
    },
    reSelectArea(state, args) {
        state.currentSelection = {
            kind: 'AREA',
            areaId: args.areaId,
            noteId: args.noteId,
        };
    },
    toggleTrackSelection(state, args) {
        const selection = state.currentSelection;
        if (selection === null || selection.kind !== 'AREA')
            return;
        const areaId = selection.areaId;
        const index = state.areas[areaId].tracks.indexOf(args.id);
        if (index > -1) {
            state.areas[areaId].tracks.splice(index, 1);
            if (args.isTrackGroup) { // Also remove all child tracks.
                for (const childTrack of state.trackGroups[args.id].tracks) {
                    const childIndex = state.areas[areaId].tracks.indexOf(childTrack);
                    if (childIndex > -1) {
                        state.areas[areaId].tracks.splice(childIndex, 1);
                    }
                }
            }
        }
        else {
            state.areas[areaId].tracks.push(args.id);
            if (args.isTrackGroup) { // Also add all child tracks.
                for (const childTrack of state.trackGroups[args.id].tracks) {
                    if (!state.areas[areaId].tracks.includes(childTrack)) {
                        state.areas[areaId].tracks.push(childTrack);
                    }
                }
            }
        }
    },
    setVisibleTraceTime(state, args) {
        state.frontendLocalState.visibleState = Object.assign({}, args);
    },
    setChromeCategories(state, args) {
        state.chromeCategories = args.categories;
    },
    setLastRecordingError(state, args) {
        state.lastRecordingError = args.error;
        state.recordingStatus = undefined;
    },
    setRecordingStatus(state, args) {
        state.recordingStatus = args.status;
        state.lastRecordingError = undefined;
    },
    setAnalyzePageQuery(state, args) {
        state.analyzePageQuery = args.query;
    },
    requestSelectedMetric(state, _) {
        if (!state.metrics.availableMetrics)
            throw Error('No metrics available');
        if (state.metrics.selectedIndex === undefined) {
            throw Error('No metric selected');
        }
        state.metrics.requestedMetric =
            state.metrics.availableMetrics[state.metrics.selectedIndex];
    },
    resetMetricRequest(state, args) {
        if (state.metrics.requestedMetric !== args.name)
            return;
        state.metrics.requestedMetric = undefined;
    },
    setAvailableMetrics(state, args) {
        state.metrics.availableMetrics = args.availableMetrics;
        if (args.availableMetrics.length > 0)
            state.metrics.selectedIndex = 0;
    },
    setMetricSelectedIndex(state, args) {
        if (!state.metrics.availableMetrics ||
            args.index >= state.metrics.availableMetrics.length) {
            throw Error('metric selection out of bounds');
        }
        state.metrics.selectedIndex = args.index;
    },
    togglePerfDebug(state, _) {
        state.perfDebug = !state.perfDebug;
    },
    toggleSidebar(state, _) {
        state.sidebarVisible = !state.sidebarVisible;
    },
    setHoveredUtidAndPid(state, args) {
        state.hoveredPid = args.pid;
        state.hoveredUtid = args.utid;
    },
    setHighlightedSliceId(state, args) {
        state.highlightedSliceId = args.sliceId;
    },
    setHighlightedFlowLeftId(state, args) {
        state.focusedFlowIdLeft = args.flowId;
    },
    setHighlightedFlowRightId(state, args) {
        state.focusedFlowIdRight = args.flowId;
    },
    setSearchIndex(state, args) {
        state.searchIndex = args.index;
    },
    setHoveredLogsTimestamp(state, args) {
        state.hoveredLogsTimestamp = args.ts;
    },
    setHoveredNoteTimestamp(state, args) {
        state.hoveredNoteTimestamp = args.ts;
    },
    setCurrentTab(state, args) {
        state.currentTab = args.tab;
    },
    toggleAllTrackGroups(state, args) {
        for (const group of Object.values(state.trackGroups)) {
            group.collapsed = args.collapsed;
        }
    },
    togglePivotTableRedux(state, args) {
        var _a;
        state.nonSerializableState.pivotTableRedux.selectionArea =
            args.areaId === null ?
                undefined :
                { areaId: args.areaId, tracks: globals.globals.state.areas[args.areaId].tracks };
        if (args.areaId !==
            ((_a = state.nonSerializableState.pivotTableRedux.selectionArea) === null || _a === void 0 ? void 0 : _a.areaId)) {
            state.nonSerializableState.pivotTableRedux.queryResult = null;
        }
    },
    setPivotStateQueryResult(state, args) {
        state.nonSerializableState.pivotTableRedux.queryResult = args.queryResult;
    },
    setPivotTableReduxConstrainToArea(state, args) {
        state.nonSerializableState.pivotTableRedux.constrainToArea = args.constrain;
    },
    dismissFlamegraphModal(state, _) {
        state.flamegraphModalDismissed = true;
    },
    setPivotTableQueryRequested(state, args) {
        state.nonSerializableState.pivotTableRedux.queryRequested =
            args.queryRequested;
    },
    setPivotTablePivotSelected(state, args) {
        if (args.column.kind === 'argument' || args.column.table === 'slice') {
            (0, pivot_table_redux_types.toggleEnabled)(pivot_table_redux_types.tableColumnEquals, state.nonSerializableState.pivotTableRedux.selectedSlicePivots, args.column, args.selected);
        }
        else {
            (0, pivot_table_redux_types.toggleEnabled)(pivot_table_redux_types.tableColumnEquals, state.nonSerializableState.pivotTableRedux.selectedPivots, args.column, args.selected);
        }
    },
    setPivotTableAggregationSelected(state, args) {
        (0, pivot_table_redux_types.toggleEnabled)(pivot_table_redux_types.aggregationEquals, state.nonSerializableState.pivotTableRedux.selectedAggregations, args.column, args.selected);
    },
    setPivotTableAggregationFunction(state, args) {
        state.nonSerializableState.pivotTableRedux.selectedAggregations[args.index]
            .aggregationFunction = args.function;
    },
    setPivotTableSortColumn(state, args) {
        state.nonSerializableState.pivotTableRedux.sortCriteria = {
            column: args.column,
            order: args.order,
        };
    },
    addVisualisedArg(state, args) {
        if (!state.visualisedArgs.includes(args.argName)) {
            state.visualisedArgs.push(args.argName);
        }
    },
    removeVisualisedArg(state, args) {
        state.visualisedArgs =
            state.visualisedArgs.filter((val) => val !== args.argName);
    },
    setPivotTableArgumentNames(state, args) {
        state.nonSerializableState.pivotTableRedux.argumentNames =
            args.argumentNames;
    },
    changePivotTablePivotOrder(state, args) {
        moveElement(state.nonSerializableState.pivotTableRedux.selectedPivots, args.from, args.to, args.direction);
    },
    changePivotTableSlicePivotOrder(state, args) {
        moveElement(state.nonSerializableState.pivotTableRedux.selectedSlicePivots, args.from, args.to, args.direction);
    },
    changePivotTableAggregationOrder(state, args) {
        moveElement(state.nonSerializableState.pivotTableRedux.selectedAggregations, args.from, args.to, args.direction);
    },
};
// Move element at `from` index to `direction` of `to` element.
// Implements logic for reordering table columns via drag'n'drop.
function moveElement(array, from, to, direction) {
    // New location of the "to" element: would be shifted by minus one if "from"
    // element comes before it.
    const newTo = to - ((from < to) ? 1 : 0);
    // The resulting index where the "from" element has to be spliced in to.
    const insertionPoint = newTo + ((direction === 'right') ? 1 : 0);
    const fromElement = array[from];
    array.splice(from, 1);
    array.splice(insertionPoint, 0, fromElement);
}
// Actions is an implementation of DeferredActions<typeof StateActions>.
// (since StateActions is a variable not a type we have to do
// 'typeof StateActions' to access the (unnamed) type of StateActions).
// It's a Proxy such that any attribute access returns a function:
// (args) => {return {type: ATTRIBUTE_NAME, args};}
exports.Actions = new Proxy({}, {
    get(_, prop, _2) {
        return (args) => {
            return {
                type: prop,
                args,
            };
        };
    },
});

});

var aggregation_data = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEmptyData = void 0;
function isEmptyData(data) {
    return data.columns.length === 0 || data.columns[0].data.length === 0;
}
exports.isEmptyData = isEmptyData;

});

var logs = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogEntriesKey = exports.LogBoundsKey = exports.LogExistsKey = void 0;
exports.LogExistsKey = 'log-exists';
exports.LogBoundsKey = 'log-bounds';
exports.LogEntriesKey = 'log-entries';

});

var deferred = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.defer = void 0;
// Create a promise with exposed resolve and reject callbacks.
function defer() {
    let resolve = null;
    let reject = null;
    const p = new Promise((res, rej) => [resolve, reject] = [res, rej]);
    return Object.assign(p, { resolve, reject });
}
exports.defer = defer;

});

var modal = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.showModal = exports.fullscreenModalContainer = exports.ModalContainer = exports.Modal = void 0;

// This module deals with modal dialogs. Unlike most components, here we want to
// render the DOM elements outside of the corresponding vdom tree. For instance
// we might want to instantiate a modal dialog all the way down from a nested
// Mithril sub-component, but we want the result dom element to be nested under
// the root <body>.
//
// This is achieved by splitting:
// 1. ModalContainer: it's the placeholder (e.g., the thing that should be added
//    under <body>) where the DOM elements will be rendered into. This is NOT
//    a mithril component itself.
// 2. Modal: is the Mithril component with the actual VDOM->DOM handling.
//    This can be used directly in the cases where the modal DOM should be
//    placed presicely where the corresponding Mithril VDOM is.
//    In turn this is split into Modal and ModalImpl, to deal with fade-out, see
//    comments around onbeforeremove.
// Usage (in the case of DOM not matching VDOM):
// - Create a ModalContainer instance somewhere (e.g. a singleton for the case
//   of the full-screen modal dialog).
// - In the view() method of the component that should host the DOM elements
//   (e.g. in the root pages.ts) do the following:
//   view() {
//     return m('main',
//        m('h2', ...)
//        modalContainerInstance.render();
//   }
//
// - In the view() method of the nested component that wants to show the modal
//   dialog do the following:
//   view() {
//     if (shouldShowModalDialog) {
//       modalContainerInstance.update({title: 'Foo', content, buttons: ...});
//     }
//     return m('.nested-widget',
//       m('div', ...));
//   }
//
// For one-show use-cases it's still possible to just use:
// showModal({title: 'Foo', content, buttons: ...});




// The component that handles the actual modal dialog. Note that this uses
// position: absolute, so the modal dialog will be relative to the surrounding
// DOM.
// We need to split this into two components (Modal and ModalImpl) so that we
// can handle the fade-out animation via onbeforeremove. The problem here is
// that onbeforeremove is emitted only when the *parent* component removes the
// children from the vdom hierarchy. So we need a parent/child in our control to
// trigger this.
class Modal {
    constructor() {
        this.requestClose = false;
    }
    close() {
        // The next view pass will kick-off the modalFadeOut CSS animation by
        // appending the .modal-hidden CSS class.
        this.requestClose = true;
        globals.globals.rafScheduler.scheduleFullRedraw();
    }
    view(vnode) {
        if (this.requestClose || vnode.attrs.close) {
            return null;
        }
        return mithril(ModalImpl, Object.assign(Object.assign({}, vnode.attrs), { parent: this }));
    }
}
exports.Modal = Modal;
// The component that handles the actual modal dialog. Note that this uses
// position: absolute, so the modal dialog will be relative to the surrounding
// DOM.
class ModalImpl {
    view({ attrs }) {
        this.onClose = attrs.onClose;
        this.parent = attrs.parent;
        const buttons = [];
        for (const button of attrs.buttons || []) {
            buttons.push(mithril('button.modal-btn', {
                class: button.primary ? 'modal-btn-primary' : '',
                id: button.id,
                onclick: () => {
                    attrs.parent.close();
                    if (button.action !== undefined)
                        button.action();
                },
            }, button.text));
        }
        const aria = '[aria-labelledby=mm-title][aria-model][role=dialog]';
        const align = attrs.vAlign === 'TOP' ? '.modal-dialog-valign-top' : '';
        return mithril('.modal-backdrop', {
            onclick: this.onclick.bind(this),
            onkeyup: this.onkeyupdown.bind(this),
            onkeydown: this.onkeyupdown.bind(this),
            // onanimationend: this.onanimationend.bind(this),
            tabIndex: 0,
        }, mithril(`.modal-dialog${align}${aria}`, mithril('header', mithril('h2', { id: 'mm-title' }, attrs.title), mithril('button[aria-label=Close Modal]', { onclick: () => attrs.parent.close() }, mithril.trust('&#x2715'))), mithril('main', attrs.content), mithril('footer', buttons)));
    }
    oncreate(vnode) {
        if (vnode.dom instanceof HTMLElement) {
            // Focus the newly created dialog, so that we react to Escape keydown
            // even if the user has not clicked yet on any element.
            // If there is a primary button, focus that, so Enter does the default
            // action. If not just focus the whole dialog.
            const primaryBtn = vnode.dom.querySelector('.modal-btn-primary');
            if (primaryBtn) {
                primaryBtn.focus();
            }
            else {
                vnode.dom.focus();
            }
            // If the modal dialog is instantiated in a tall scrollable container,
            // make sure to scroll it into the view.
            vnode.dom.scrollIntoView({ 'block': 'center' });
        }
    }
    onbeforeremove(vnode) {
        const removePromise = (0, deferred.defer)();
        vnode.dom.addEventListener('animationend', () => removePromise.resolve());
        vnode.dom.classList.add('modal-fadeout');
        // Retuning `removePromise` will cause Mithril to defer the actual component
        // removal until the fade-out animation is done.
        return removePromise;
    }
    onremove() {
        if (this.onClose !== undefined) {
            this.onClose();
            globals.globals.rafScheduler.scheduleFullRedraw();
        }
    }
    onclick(e) {
        e.stopPropagation();
        // Only react when clicking on the backdrop. Don't close if the user clicks
        // on the dialog itself.
        const t = e.target;
        if (t instanceof Element && t.classList.contains('modal-backdrop')) {
            (0, logging.assertExists)(this.parent).close();
        }
    }
    onkeyupdown(e) {
        e.stopPropagation();
        if (e.key === 'Escape' && e.type !== 'keyup') {
            (0, logging.assertExists)(this.parent).close();
        }
    }
}
// This is deliberately NOT a Mithril component. We want to manage the lifetime
// independently (outside of Mithril), so we can render from outside the current
// vdom sub-tree. ModalContainer instances should be singletons / globals.
class ModalContainer {
    constructor() {
        this.generation = 1; // Start with a generation > `closeGeneration`.
        this.closeGeneration = 0;
    }
    // This should be called to show a new modal dialog. The modal dialog will
    // be shown the next time something calls render() in a Mithril draw pass.
    // This enforces the creation of a new dialog.
    createNew(attrs) {
        this.generation++;
        this.updateVdom(attrs);
    }
    // Updates the current dialog or creates a new one if not existing. If a
    // dialog exists already, this will update the DOM of the existing dialog.
    // This should be called in at view() time by a nested Mithril component which
    // wants to display a modal dialog (but wants it to render outside).
    updateVdom(attrs) {
        this.attrs = attrs;
    }
    close() {
        this.closeGeneration = this.generation;
        globals.globals.rafScheduler.scheduleFullRedraw();
    }
    // This method should be called in the view() method of the Mithril component
    // that will host the DOM elements. For instance, in the case of the
    // full-screen dialog, that is `fullscreenModal` used by pages.ts.
    // e.g.: view() {
    //  return m('main',
    //      ...,
    //      modalContainerInstance.render(),
    //    );
    // }
    render() {
        if (this.attrs === undefined)
            return null;
        // Here we return an array so that Mithril's diff engine destroys and
        // recreates the component when the generation changes, rather than updating
        // the same component. `key` works only when returning arrays.
        return [mithril(Modal, Object.assign(Object.assign({}, this.attrs), { onClose: () => {
                    var _a;
                    // Remember the fact that the dialog was dismissed, in case the whole
                    // ModalContainer gets instantiated from a different page (which would
                    // cause the Modal to be destroyed and recreated).
                    this.closeGeneration = this.generation;
                    if (((_a = this.attrs) === null || _a === void 0 ? void 0 : _a.onClose) !== undefined) {
                        this.attrs.onClose();
                        globals.globals.rafScheduler.scheduleFullRedraw();
                    }
                }, close: this.closeGeneration === this.generation ? true : this.attrs.close, key: this.generation }))];
    }
}
exports.ModalContainer = ModalContainer;
// This is the default instance used for full-screen modal dialogs.
// page.ts calls `fullscreenModalContainer.render()` in its view() pass.
exports.fullscreenModalContainer = new ModalContainer();
function showModal(attrs) {
    return tslib.__awaiter(this, void 0, void 0, function* () {
        // When using showModal, the caller cannot pass an onClose promise. It should
        // use the returned promised instead. onClose is only for clients using the
        // Mithril component directly.
        (0, logging.assertTrue)(attrs.onClose === undefined);
        const promise = (0, deferred.defer)();
        exports.fullscreenModalContainer.createNew(Object.assign(Object.assign({}, attrs), { onClose: () => promise.resolve() }));
        globals.globals.rafScheduler.scheduleFullRedraw();
        return promise;
    });
}
exports.showModal = showModal;

});

var help_modal = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.toggleHelp = void 0;



function toggleHelp() {
    globals.globals.logging.logEvent('User Actions', 'Show help');
    showHelp();
}
exports.toggleHelp = toggleHelp;
function keycap(key) {
    return mithril('.keycap', key);
}
function showHelp() {
    const ctrlOrCmd = window.navigator.platform.indexOf('Mac') !== -1 ? 'Cmd' : 'Ctrl';
    (0, modal.showModal)({
        title: 'Perfetto Help',
        content: mithril('.help', mithril('h2', 'Navigation'), mithril('table', mithril('tr', mithril('td', keycap('w'), '/', keycap('s')), mithril('td', 'Zoom in/out')), mithril('tr', mithril('td', keycap('a'), '/', keycap('d')), mithril('td', 'Pan left/right'))), mithril('h2', 'Mouse Controls'), mithril('table', mithril('tr', mithril('td', 'Click'), mithril('td', 'Select event')), mithril('tr', mithril('td', 'Ctrl + Scroll wheel'), mithril('td', 'Zoom in/out')), mithril('tr', mithril('td', 'Click + Drag'), mithril('td', 'Select area')), mithril('tr', mithril('td', 'Shift + Click + Drag'), mithril('td', 'Pan left/right'))), mithril('h2', 'Making SQL queries from the viewer page'), mithril('table', mithril('tr', mithril('td', keycap(':'), ' in the (empty) search box'), mithril('td', 'Switch to query input')), mithril('tr', mithril('td', keycap('Enter')), mithril('td', 'Execute query')), mithril('tr', mithril('td', keycap('Ctrl'), ' + ', keycap('Enter')), mithril('td', 'Execute query and pin output ' +
            '(output will not be replaced by regular query input)'))), mithril('h2', 'Making SQL queries from the query page'), mithril('table', mithril('tr', mithril('td', keycap('Ctrl'), ' + ', keycap('Enter')), mithril('td', 'Execute query')), mithril('tr', mithril('td', keycap('Ctrl'), ' + ', keycap('Enter'), ' (with selection)'), mithril('td', 'Execute selection'))), mithril('h2', 'Other'), mithril('table', mithril('tr', mithril('td', keycap('f'), ' (with event selected)'), mithril('td', 'Scroll + zoom to current selection')), mithril('tr', mithril('td', keycap('['), '/', keycap(']'), ' (with event selected)'), mithril('td', 'Select next/previous slice that is connected by a flow.', mithril('br'), 'If there are multiple flows,' +
            'the one that is in focus (bold) is selected')), mithril('tr', mithril('td', keycap(ctrlOrCmd), ' + ', keycap('['), '/', keycap(']'), ' (with event selected)'), mithril('td', 'Switch focus to another flow')), mithril('tr', mithril('td', keycap('m'), ' (with event or area selected)'), mithril('td', 'Mark the area (temporarily)')), mithril('tr', mithril('td', keycap('Shift'), ' + ', keycap('m'), ' (with event or area selected)'), mithril('td', 'Mark the area (persistently)')), mithril('tr', mithril('td', keycap(ctrlOrCmd), ' + ', keycap('a')), mithril('td', 'Select all')), mithril('tr', mithril('td', keycap(ctrlOrCmd), ' + ', keycap('b')), mithril('td', 'Toggle display of sidebar')), mithril('tr', mithril('td', keycap('?')), mithril('td', 'Show help')))),
        buttons: [],
    });
}

});

var scroll_helper = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.scrollToTrackAndTs = exports.verticalScrollToTrack = exports.focusHorizontalRange = exports.horizontalScrollToTs = void 0;




const INCOMPLETE_SLICE_TIME_S = 0.00003;
// Given a timestamp, if |ts| is not currently in view move the view to
// center |ts|, keeping the same zoom level.
function horizontalScrollToTs(ts) {
    const startNs = (0, time.toNs)(globals.globals.frontendLocalState.visibleWindowTime.start);
    const endNs = (0, time.toNs)(globals.globals.frontendLocalState.visibleWindowTime.end);
    const currentViewNs = endNs - startNs;
    if (ts < startNs || ts > endNs) {
        // TODO(hjd): This is an ugly jump, we should do a smooth pan instead.
        globals.globals.frontendLocalState.updateVisibleTime(new time.TimeSpan((0, time.fromNs)(ts - currentViewNs / 2), (0, time.fromNs)(ts + currentViewNs / 2)));
    }
}
exports.horizontalScrollToTs = horizontalScrollToTs;
// Given a start and end timestamp (in ns), move the viewport to center this
// range and zoom if necessary:
// - If the new range is more than 50% of the viewport, zoom out to a level
// where
//   the range is 1/5 of the viewport.
// - If the new range is already centered, update the zoom level for the
// viewport
//   to cover 1/5 of the viewport.
// - Otherwise, preserve the zoom range.
function focusHorizontalRange(startTs, endTs) {
    const visibleDur = globals.globals.frontendLocalState.visibleWindowTime.end -
        globals.globals.frontendLocalState.visibleWindowTime.start;
    let selectDur = endTs - startTs;
    // TODO(altimin): We go from `ts` and `dur` to `startTs` and `endTs` and back
    // to `dur`. We should fix that.
    if ((0, time.toNs)(selectDur) === -1) { // Unfinished slice
        selectDur = INCOMPLETE_SLICE_TIME_S;
        endTs = startTs;
    }
    // If the range is too large to fit on the current zoom level, resize.
    if (selectDur > 0.5 * visibleDur) {
        globals.globals.frontendLocalState.updateVisibleTime(new time.TimeSpan(startTs - (selectDur * 2), endTs + (selectDur * 2)));
        return;
    }
    const midpointTs = (endTs + startTs) / 2;
    // Calculate the new visible window preserving the zoom level.
    let newStartTs = midpointTs - visibleDur / 2;
    let newEndTs = midpointTs + visibleDur / 2;
    // Adjust the new visible window if it intersects with the trace boundaries.
    // It's needed to make the "update the zoom level if visible window doesn't
    // change" logic reliable.
    if (newEndTs > globals.globals.state.traceTime.endSec) {
        newStartTs = globals.globals.state.traceTime.endSec - visibleDur;
        newEndTs = globals.globals.state.traceTime.endSec;
    }
    if (newStartTs < globals.globals.state.traceTime.startSec) {
        newStartTs = globals.globals.state.traceTime.startSec;
        newEndTs = globals.globals.state.traceTime.startSec + visibleDur;
    }
    const newStartNs = (0, time.toNs)(newStartTs);
    const newEndNs = (0, time.toNs)(newEndTs);
    const viewStartNs = (0, time.toNs)(globals.globals.frontendLocalState.visibleWindowTime.start);
    const viewEndNs = (0, time.toNs)(globals.globals.frontendLocalState.visibleWindowTime.end);
    // If preserving the zoom doesn't change the visible window, update the zoom
    // level.
    if (newStartNs === viewStartNs && newEndNs === viewEndNs) {
        globals.globals.frontendLocalState.updateVisibleTime(new time.TimeSpan(startTs - (selectDur * 2), endTs + (selectDur * 2)));
        return;
    }
    globals.globals.frontendLocalState.updateVisibleTime(new time.TimeSpan(newStartTs, newEndTs));
}
exports.focusHorizontalRange = focusHorizontalRange;
// Given a track id, find a track with that id and scroll it into view. If the
// track is nested inside a track group, scroll to that track group instead.
// If |openGroup| then open the track group and scroll to the track.
function verticalScrollToTrack(trackId, openGroup = false) {
    const trackIdString = `${trackId}`;
    const track = document.querySelector('#track_' + trackIdString);
    if (track) {
        // block: 'nearest' means that it will only scroll if the track is not
        // currently in view.
        track.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
        return;
    }
    let trackGroup = null;
    const trackGroupId = (0, state.getContainingTrackId)(globals.globals.state, trackIdString);
    if (trackGroupId) {
        trackGroup = document.querySelector('#track_' + trackGroupId);
    }
    if (!trackGroupId || !trackGroup) {
        console.error(`Can't scroll, track (${trackIdString}) not found.`);
        return;
    }
    // The requested track is inside a closed track group, either open the track
    // group and scroll to the track or just scroll to the track group.
    if (openGroup) {
        // After the track exists in the dom, it will be scrolled to.
        globals.globals.frontendLocalState.scrollToTrackId = trackId;
        globals.globals.dispatch(actions.Actions.toggleTrackGroupCollapsed({ trackGroupId }));
        return;
    }
    else {
        trackGroup.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
    }
}
exports.verticalScrollToTrack = verticalScrollToTrack;
// Scroll vertically and horizontally to reach track (|trackId|) at |ts|.
function scrollToTrackAndTs(trackId, ts, openGroup = false) {
    if (trackId !== undefined) {
        verticalScrollToTrack(trackId, openGroup);
    }
    horizontalScrollToTs(ts);
}
exports.scrollToTrackAndTs = scrollToTrackAndTs;

});

var binary_search = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.searchSegment = exports.searchRange = exports.searchEq = exports.search = void 0;
function searchImpl(haystack, needle, i, j) {
    if (i === j)
        return -1;
    if (i + 1 === j) {
        return (needle >= haystack[i]) ? i : -1;
    }
    const mid = Math.floor((j - i) / 2) + i;
    const midValue = haystack[mid];
    if (needle < midValue) {
        return searchImpl(haystack, needle, i, mid);
    }
    else {
        return searchImpl(haystack, needle, mid, j);
    }
}
function searchRangeImpl(haystack, needle, i, j) {
    if (i === j)
        return [i, j];
    if (i + 1 === j) {
        if (haystack[i] <= needle) {
            return [i, j];
        }
        else {
            return [i, i];
        }
    }
    const mid = Math.floor((j - i) / 2) + i;
    const midValue = haystack[mid];
    if (needle < midValue) {
        return searchRangeImpl(haystack, needle, i, mid);
    }
    else if (needle > midValue) {
        return searchRangeImpl(haystack, needle, mid, j);
    }
    else {
        while (haystack[i] !== needle)
            i++;
        while (haystack[j - 1] !== needle)
            j--;
        return [i, j];
    }
}
function search(haystack, needle) {
    return searchImpl(haystack, needle, 0, haystack.length);
}
exports.search = search;
// Given a sorted array of numbers (|haystack|) and a |needle| return the
// half open range [i, j) of indexes where |haystack| is equal to needle.
function searchEq(haystack, needle, optRange) {
    const range = searchRange(haystack, needle, optRange);
    const [i, j] = range;
    if (haystack[i] === needle)
        return range;
    return [j, j];
}
exports.searchEq = searchEq;
// Given a sorted array of numbers (|haystack|) and a |needle| return the
// smallest half open range [i, j) of indexes which contains |needle|.
function searchRange(haystack, needle, optRange) {
    const [left, right] = optRange ? optRange : [0, haystack.length];
    return searchRangeImpl(haystack, needle, left, right);
}
exports.searchRange = searchRange;
// Given a sorted array of numbers (|haystack|) and a |needle| return a
// pair of indexes [i, j] such that:
// If there is at least one element in |haystack| smaller than |needle|
// i is the index of the largest such number otherwise -1;
// If there is at least one element in |haystack| larger than |needle|
// j is the index of the smallest such element otherwise -1.
//
// So we try to get the indexes of the two data points around needle
// or -1 if there is no such datapoint.
function searchSegment(haystack, needle) {
    if (!haystack.length)
        return [-1, -1];
    const left = search(haystack, needle);
    if (left === -1) {
        return [left, 0];
    }
    else if (left + 1 === haystack.length) {
        return [left, -1];
    }
    else {
        return [left, left + 1];
    }
}
exports.searchSegment = searchSegment;

});

var search_handler = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.executeSearch = void 0;




function setToPrevious(current) {
    const index = Math.max(current - 1, 0);
    globals.globals.dispatch(actions.Actions.setSearchIndex({ index }));
}
function setToNext(current) {
    const index = Math.min(current + 1, globals.globals.currentSearchResults.totalResults - 1);
    globals.globals.dispatch(actions.Actions.setSearchIndex({ index }));
}
function executeSearch(reverse = false) {
    const index = globals.globals.state.searchIndex;
    const startNs = (0, time.toNs)(globals.globals.frontendLocalState.visibleWindowTime.start);
    const endNs = (0, time.toNs)(globals.globals.frontendLocalState.visibleWindowTime.end);
    const currentTs = globals.globals.currentSearchResults.tsStarts[index];
    // If this is a new search or the currentTs is not in the viewport,
    // select the first/last item in the viewport.
    if (index === -1 || currentTs < startNs || currentTs > endNs) {
        if (reverse) {
            const [smaller] = (0, binary_search.searchSegment)(globals.globals.currentSearchResults.tsStarts, endNs);
            // If there is no item in the viewport just go to the previous.
            if (smaller === -1) {
                setToPrevious(index);
            }
            else {
                globals.globals.dispatch(actions.Actions.setSearchIndex({ index: smaller }));
            }
        }
        else {
            const [, larger] = (0, binary_search.searchSegment)(globals.globals.currentSearchResults.tsStarts, startNs);
            // If there is no item in the viewport just go to the next.
            if (larger === -1) {
                setToNext(index);
            }
            else {
                globals.globals.dispatch(actions.Actions.setSearchIndex({ index: larger }));
            }
        }
    }
    else {
        // If the currentTs is in the viewport, increment the index.
        if (reverse) {
            setToPrevious(index);
        }
        else {
            setToNext(index);
        }
    }
    selectCurrentSearchResult();
}
exports.executeSearch = executeSearch;
function selectCurrentSearchResult() {
    const searchIndex = globals.globals.state.searchIndex;
    const source = globals.globals.currentSearchResults.sources[searchIndex];
    const currentId = globals.globals.currentSearchResults.sliceIds[searchIndex];
    const trackId = globals.globals.currentSearchResults.trackIds[searchIndex];
    if (currentId === undefined)
        return;
    if (source === 'cpu') {
        globals.globals.dispatch(actions.Actions.selectSlice({ id: currentId, trackId, scroll: true }));
    }
    else if (source === 'log') {
        globals.globals.dispatch(actions.Actions.selectLog({ id: currentId, trackId, scroll: true }));
    }
    else {
        // Search results only include slices from the slice table for now.
        // When we include annotations we need to pass the correct table.
        globals.globals.dispatch(actions.Actions.selectChromeSlice({ id: currentId, trackId, table: 'slice', scroll: true }));
    }
}

});

var keyboard_event_handler = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.findCurrentSelection = exports.handleKey = void 0;





const INSTANT_FOCUS_DURATION_S = 1 / 1e9; // 1 ns.
// Handles all key events than are not handled by the
// pan and zoom handler. Returns true if the event was handled.
function handleKey(e, down) {
    const key = e.key.toLowerCase();
    const selection = globals.globals.state.currentSelection;
    const noModifiers = !(e.ctrlKey || e.metaKey || e.altKey || e.shiftKey);
    const ctrlOrMeta = (e.ctrlKey || e.metaKey) && !(e.altKey || e.shiftKey);
    // No other modifiers other than possibly Shift.
    const maybeShift = !(e.ctrlKey || e.metaKey || e.altKey);
    if (down && 'm' === key && maybeShift) {
        if (selection && selection.kind === 'AREA') {
            globals.globals.dispatch(actions.Actions.toggleMarkCurrentArea({ persistent: e.shiftKey }));
        }
        else if (selection) {
            lockSliceSpan(e.shiftKey);
        }
        return true;
    }
    if (down && 'f' === key && noModifiers) {
        findCurrentSelection();
        return true;
    }
    if (down && 'a' === key && ctrlOrMeta) {
        let tracksToSelect = [];
        const selection = globals.globals.state.currentSelection;
        if (selection !== null && selection.kind === 'AREA') {
            const area = globals.globals.state.areas[selection.areaId];
            const coversEntireTimeRange = globals.globals.state.traceTime.startSec === area.startSec &&
                globals.globals.state.traceTime.endSec === area.endSec;
            if (!coversEntireTimeRange) {
                // If the current selection is an area which does not cover the entire
                // time range, preserve the list of selected tracks and expand the time
                // range.
                tracksToSelect = area.tracks;
            }
            else {
                // If the entire time range is already covered, update the selection to
                // cover all tracks.
                tracksToSelect = Object.keys(globals.globals.state.tracks);
            }
        }
        else {
            // If the current selection is not an area, select all.
            tracksToSelect = Object.keys(globals.globals.state.tracks);
        }
        globals.globals.dispatch(actions.Actions.selectArea({
            area: {
                startSec: globals.globals.state.traceTime.startSec,
                endSec: globals.globals.state.traceTime.endSec,
                tracks: tracksToSelect,
            },
        }));
        e.preventDefault();
        return true;
    }
    if (down && 'b' === key && ctrlOrMeta) {
        globals.globals.dispatch(actions.Actions.toggleSidebar({}));
        return true;
    }
    if (down && '?' === key && maybeShift) {
        (0, help_modal.toggleHelp)();
        return true;
    }
    if (down && 'enter' === key && maybeShift) {
        e.preventDefault();
        (0, search_handler.executeSearch)(e.shiftKey);
        return true;
    }
    if (down && 'escape' === key) {
        globals.globals.frontendLocalState.deselectArea();
        globals.globals.makeSelection(actions.Actions.deselect({}));
        globals.globals.dispatch(actions.Actions.removeNote({ id: '0' }));
        return true;
    }
    if (down && ']' === key && ctrlOrMeta) {
        focusOtherFlow('Forward');
        return true;
    }
    if (down && ']' === key && noModifiers) {
        moveByFocusedFlow('Forward');
        return true;
    }
    if (down && '[' === key && ctrlOrMeta) {
        focusOtherFlow('Backward');
        return true;
    }
    if (down && '[' === key && noModifiers) {
        moveByFocusedFlow('Backward');
        return true;
    }
    return false;
}
exports.handleKey = handleKey;
// Search |boundFlows| for |flowId| and return the id following it.
// Returns the first flow id if nothing was found or |flowId| was the last flow
// in |boundFlows|, and -1 if |boundFlows| is empty
function findAnotherFlowExcept(boundFlows, flowId) {
    let selectedFlowFound = false;
    if (boundFlows.length === 0) {
        return -1;
    }
    for (const flow of boundFlows) {
        if (selectedFlowFound) {
            return flow.id;
        }
        if (flow.id === flowId) {
            selectedFlowFound = true;
        }
    }
    return boundFlows[0].id;
}
// Change focus to the next flow event (matching the direction)
function focusOtherFlow(direction) {
    if (!globals.globals.state.currentSelection ||
        globals.globals.state.currentSelection.kind !== 'CHROME_SLICE') {
        return;
    }
    const sliceId = globals.globals.state.currentSelection.id;
    if (sliceId === -1) {
        return;
    }
    const boundFlows = globals.globals.connectedFlows.filter((flow) => flow.begin.sliceId === sliceId && direction === 'Forward' ||
        flow.end.sliceId === sliceId && direction === 'Backward');
    if (direction === 'Backward') {
        const nextFlowId = findAnotherFlowExcept(boundFlows, globals.globals.state.focusedFlowIdLeft);
        globals.globals.dispatch(actions.Actions.setHighlightedFlowLeftId({ flowId: nextFlowId }));
    }
    else {
        const nextFlowId = findAnotherFlowExcept(boundFlows, globals.globals.state.focusedFlowIdRight);
        globals.globals.dispatch(actions.Actions.setHighlightedFlowRightId({ flowId: nextFlowId }));
    }
}
// Select the slice connected to the flow in focus
function moveByFocusedFlow(direction) {
    if (!globals.globals.state.currentSelection ||
        globals.globals.state.currentSelection.kind !== 'CHROME_SLICE') {
        return;
    }
    const sliceId = globals.globals.state.currentSelection.id;
    const flowId = (direction === 'Backward' ? globals.globals.state.focusedFlowIdLeft :
        globals.globals.state.focusedFlowIdRight);
    if (sliceId === -1 || flowId === -1) {
        return;
    }
    // Find flow that is in focus and select corresponding slice
    for (const flow of globals.globals.connectedFlows) {
        if (flow.id === flowId) {
            const flowPoint = (direction === 'Backward' ? flow.begin : flow.end);
            const uiTrackId = globals.globals.state.uiTrackIdByTraceTrackId[flowPoint.trackId];
            if (uiTrackId) {
                globals.globals.makeSelection(actions.Actions.selectChromeSlice({
                    id: flowPoint.sliceId,
                    trackId: uiTrackId,
                    table: 'slice',
                    scroll: true,
                }));
            }
        }
    }
}
function findTimeRangeOfSelection() {
    const selection = globals.globals.state.currentSelection;
    let startTs = -1;
    let endTs = -1;
    if (selection === null) {
        return { startTs, endTs };
    }
    else if (selection.kind === 'SLICE' || selection.kind === 'CHROME_SLICE') {
        const slice = globals.globals.sliceDetails;
        if (slice.ts && slice.dur !== undefined && slice.dur > 0) {
            startTs = slice.ts + globals.globals.state.traceTime.startSec;
            endTs = startTs + slice.dur;
        }
        else if (slice.ts) {
            startTs = slice.ts + globals.globals.state.traceTime.startSec;
            // This will handle either:
            // a)slice.dur === -1 -> unfinished slice
            // b)slice.dur === 0  -> instant event
            endTs = slice.dur === -1 ? globals.globals.state.traceTime.endSec :
                startTs + INSTANT_FOCUS_DURATION_S;
        }
    }
    else if (selection.kind === 'THREAD_STATE') {
        const threadState = globals.globals.threadStateDetails;
        if (threadState.ts && threadState.dur) {
            startTs = threadState.ts + globals.globals.state.traceTime.startSec;
            endTs = startTs + threadState.dur;
        }
    }
    else if (selection.kind === 'COUNTER') {
        startTs = selection.leftTs;
        endTs = selection.rightTs;
    }
    else if (selection.kind === 'AREA') {
        const selectedArea = globals.globals.state.areas[selection.areaId];
        if (selectedArea) {
            startTs = selectedArea.startSec;
            endTs = selectedArea.endSec;
        }
    }
    else if (selection.kind === 'NOTE') {
        const selectedNote = globals.globals.state.notes[selection.id];
        // Notes can either be default or area notes. Area notes are handled
        // above in the AREA case.
        if (selectedNote && selectedNote.noteType === 'DEFAULT') {
            startTs = selectedNote.timestamp;
            endTs = selectedNote.timestamp + INSTANT_FOCUS_DURATION_S;
        }
    }
    else if (selection.kind === 'LOG') ;
    return { startTs, endTs };
}
function lockSliceSpan(persistent = false) {
    const range = findTimeRangeOfSelection();
    if (range.startTs !== -1 && range.endTs !== -1 &&
        globals.globals.state.currentSelection !== null) {
        const tracks = globals.globals.state.currentSelection.trackId ?
            [globals.globals.state.currentSelection.trackId] :
            [];
        const area = { startSec: range.startTs, endSec: range.endTs, tracks };
        globals.globals.dispatch(actions.Actions.markArea({ area, persistent }));
    }
}
function findCurrentSelection() {
    const selection = globals.globals.state.currentSelection;
    if (selection === null)
        return;
    const range = findTimeRangeOfSelection();
    if (range.startTs !== -1 && range.endTs !== -1) {
        (0, scroll_helper.focusHorizontalRange)(range.startTs, range.endTs);
    }
    if (selection.trackId) {
        (0, scroll_helper.verticalScrollToTrack)(selection.trackId, true);
    }
}
exports.findCurrentSelection = findCurrentSelection;

});

var publish = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.publishConnectedFlows = exports.publishThreadStateDetails = exports.publishSliceDetails = exports.publishThreads = exports.publishQueryResult = exports.publishAggregateData = exports.publishMetricError = exports.publishTraceErrors = exports.publishRecordingLog = exports.publishSearchResult = exports.publishSearch = exports.publishBufferUsage = exports.publishLoading = exports.publishConversionJobStatusUpdate = exports.publishHasFtrace = exports.publishCpuProfileDetails = exports.publishFlamegraphDetails = exports.publishCounterDetails = exports.publishSelectedFlows = exports.publishMetricResult = exports.publishTrackData = exports.publishOverviewData = void 0;





function publishOverviewData(data) {
    for (const [key, value] of Object.entries(data)) {
        if (!globals.globals.overviewStore.has(key)) {
            globals.globals.overviewStore.set(key, []);
        }
        if (value instanceof Array) {
            globals.globals.overviewStore.get(key).push(...value);
        }
        else {
            globals.globals.overviewStore.get(key).push(value);
        }
    }
    globals.globals.rafScheduler.scheduleRedraw();
}
exports.publishOverviewData = publishOverviewData;
function publishTrackData(args) {
    globals.globals.setTrackData(args.id, args.data);
    if ([logs.LogExistsKey, logs.LogBoundsKey, logs.LogEntriesKey].includes(args.id)) {
        const data = globals.globals.trackDataStore.get(logs.LogExistsKey);
        if (data && data.exists)
            globals.globals.rafScheduler.scheduleFullRedraw();
    }
    else {
        globals.globals.rafScheduler.scheduleRedraw();
    }
}
exports.publishTrackData = publishTrackData;
function publishMetricResult(metricResult) {
    globals.globals.setMetricResult(metricResult);
    globals.globals.publishRedraw();
}
exports.publishMetricResult = publishMetricResult;
function publishSelectedFlows(selectedFlows) {
    globals.globals.selectedFlows = selectedFlows;
    globals.globals.publishRedraw();
}
exports.publishSelectedFlows = publishSelectedFlows;
function publishCounterDetails(click) {
    globals.globals.counterDetails = click;
    globals.globals.publishRedraw();
}
exports.publishCounterDetails = publishCounterDetails;
function publishFlamegraphDetails(click) {
    globals.globals.flamegraphDetails = click;
    globals.globals.publishRedraw();
}
exports.publishFlamegraphDetails = publishFlamegraphDetails;
function publishCpuProfileDetails(details) {
    globals.globals.cpuProfileDetails = details;
    globals.globals.publishRedraw();
}
exports.publishCpuProfileDetails = publishCpuProfileDetails;
function publishHasFtrace(hasFtrace) {
    globals.globals.hasFtrace = hasFtrace;
    globals.globals.publishRedraw();
}
exports.publishHasFtrace = publishHasFtrace;
function publishConversionJobStatusUpdate(job) {
    globals.globals.setConversionJobStatus(job.jobName, job.jobStatus);
    globals.globals.publishRedraw();
}
exports.publishConversionJobStatusUpdate = publishConversionJobStatusUpdate;
function publishLoading(numQueuedQueries) {
    globals.globals.numQueuedQueries = numQueuedQueries;
    // TODO(hjd): Clean up loadingAnimation given that this now causes a full
    // redraw anyways. Also this should probably just go via the global state.
    globals.globals.rafScheduler.scheduleFullRedraw();
}
exports.publishLoading = publishLoading;
function publishBufferUsage(args) {
    globals.globals.setBufferUsage(args.percentage);
    globals.globals.publishRedraw();
}
exports.publishBufferUsage = publishBufferUsage;
function publishSearch(args) {
    globals.globals.searchSummary = args;
    globals.globals.publishRedraw();
}
exports.publishSearch = publishSearch;
function publishSearchResult(args) {
    globals.globals.currentSearchResults = args;
    globals.globals.publishRedraw();
}
exports.publishSearchResult = publishSearchResult;
function publishRecordingLog(args) {
    globals.globals.setRecordingLog(args.logs);
    globals.globals.publishRedraw();
}
exports.publishRecordingLog = publishRecordingLog;
function publishTraceErrors(numErrors) {
    globals.globals.setTraceErrors(numErrors);
    globals.globals.publishRedraw();
}
exports.publishTraceErrors = publishTraceErrors;
function publishMetricError(error) {
    globals.globals.setMetricError(error);
    globals.globals.logging.logError(error, false);
    globals.globals.publishRedraw();
}
exports.publishMetricError = publishMetricError;
function publishAggregateData(args) {
    globals.globals.setAggregateData(args.kind, args.data);
    if (!(0, aggregation_data.isEmptyData)(args.data)) {
        globals.globals.dispatch(actions.Actions.setCurrentTab({ tab: args.data.tabName }));
    }
    globals.globals.publishRedraw();
}
exports.publishAggregateData = publishAggregateData;
function publishQueryResult(args) {
    globals.globals.queryResults.set(args.id, args.data);
    globals.globals.dispatch(actions.Actions.setCurrentTab({ tab: `query_result_${args.id}` }));
    globals.globals.publishRedraw();
}
exports.publishQueryResult = publishQueryResult;
function publishThreads(data) {
    globals.globals.threads.clear();
    data.forEach((thread) => {
        globals.globals.threads.set(thread.utid, thread);
    });
    globals.globals.publishRedraw();
}
exports.publishThreads = publishThreads;
function publishSliceDetails(click) {
    globals.globals.sliceDetails = click;
    const id = click.id;
    if (id !== undefined && id === globals.globals.state.pendingScrollId) {
        (0, keyboard_event_handler.findCurrentSelection)();
        globals.globals.dispatch(actions.Actions.setCurrentTab({ tab: 'slice' }));
        globals.globals.dispatch(actions.Actions.clearPendingScrollId({ id: undefined }));
    }
    globals.globals.publishRedraw();
}
exports.publishSliceDetails = publishSliceDetails;
function publishThreadStateDetails(click) {
    globals.globals.threadStateDetails = click;
    globals.globals.publishRedraw();
}
exports.publishThreadStateDetails = publishThreadStateDetails;
function publishConnectedFlows(connectedFlows) {
    var _a;
    globals.globals.connectedFlows = connectedFlows;
    // If a chrome slice is selected and we have any flows in connectedFlows
    // we will find the flows on the right and left of that slice to set a default
    // focus. In all other cases the focusedFlowId(Left|Right) will be set to -1.
    globals.globals.dispatch(actions.Actions.setHighlightedFlowLeftId({ flowId: -1 }));
    globals.globals.dispatch(actions.Actions.setHighlightedFlowRightId({ flowId: -1 }));
    if (((_a = globals.globals.state.currentSelection) === null || _a === void 0 ? void 0 : _a.kind) === 'CHROME_SLICE') {
        const sliceId = globals.globals.state.currentSelection.id;
        for (const flow of globals.globals.connectedFlows) {
            if (flow.begin.sliceId === sliceId) {
                globals.globals.dispatch(actions.Actions.setHighlightedFlowRightId({ flowId: flow.id }));
            }
            if (flow.end.sliceId === sliceId) {
                globals.globals.dispatch(actions.Actions.setHighlightedFlowLeftId({ flowId: flow.id }));
            }
        }
    }
    globals.globals.publishRedraw();
}
exports.publishConnectedFlows = publishConnectedFlows;

});

var controller = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Controller = exports.Child = void 0;
function Child(id, factory, args) {
    return { id, factory, args };
}
exports.Child = Child;
class Controller {
    constructor(initialState) {
        // This is about the local FSM state, has nothing to do with the global
        // app state.
        this._stateChanged = false;
        this._inRunner = false;
        this._children = new Map();
        this._state = initialState;
    }
    onDestroy() { }
    // Invokes the current controller subtree, recursing into children.
    // While doing so handles lifecycle of child controllers.
    // This method should be called only by the runControllers() method in
    // globals.ts. Exposed publicly for testing.
    invoke() {
        if (this._inRunner)
            throw new Error('Reentrancy in Controller');
        this._stateChanged = false;
        this._inRunner = true;
        const resArray = this.run();
        let triggerAnotherRun = this._stateChanged;
        this._stateChanged = false;
        const nextChildren = new Map();
        if (resArray !== undefined) {
            for (const childConfig of resArray) {
                if (nextChildren.has(childConfig.id)) {
                    throw new Error(`Duplicate children controller ${childConfig.id}`);
                }
                nextChildren.set(childConfig.id, childConfig);
            }
        }
        const dtors = new Array();
        const runners = new Array();
        for (const key of this._children.keys()) {
            if (nextChildren.has(key))
                continue;
            const instance = this._children.get(key);
            this._children.delete(key);
            dtors.push(() => instance.onDestroy());
        }
        for (const nextChild of nextChildren.values()) {
            if (!this._children.has(nextChild.id)) {
                const instance = new nextChild.factory(nextChild.args);
                this._children.set(nextChild.id, instance);
            }
            const instance = this._children.get(nextChild.id);
            runners.push(() => instance.invoke());
        }
        for (const dtor of dtors)
            dtor(); // Invoke all onDestroy()s.
        // Invoke all runner()s.
        for (const runner of runners) {
            const recursiveRes = runner();
            triggerAnotherRun = triggerAnotherRun || recursiveRes;
        }
        this._inRunner = false;
        return triggerAnotherRun;
    }
    setState(state) {
        if (!this._inRunner) {
            throw new Error('Cannot setState() outside of the run() method');
        }
        this._stateChanged = state !== this._state;
        this._state = state;
    }
    get state() {
        return this._state;
    }
}
exports.Controller = Controller;

});

var immer_cjs_production_min = createCommonjsModule(function (module, exports) {
function n(n){for(var t=arguments.length,r=Array(t>1?t-1:0),e=1;e<t;e++)r[e-1]=arguments[e];throw Error("[Immer] minified error nr: "+n+(r.length?" "+r.map((function(n){return "'"+n+"'"})).join(","):"")+". Find the full error at: https://bit.ly/3cXEKWf")}function t(n){return !!n&&!!n[H]}function r(n){return !!n&&(function(n){if(!n||"object"!=typeof n)return !1;var t=Object.getPrototypeOf(n);if(null===t)return !0;var r=Object.hasOwnProperty.call(t,"constructor")&&t.constructor;return r===Object||"function"==typeof r&&Function.toString.call(r)===Q}(n)||Array.isArray(n)||!!n[G]||!!n.constructor[G]||c(n)||v(n))}function e(n,t,r){void 0===r&&(r=!1),0===i(n)?(r?Object.keys:T)(n).forEach((function(e){r&&"symbol"==typeof e||t(e,n[e],n);})):n.forEach((function(r,e){return t(e,r,n)}));}function i(n){var t=n[H];return t?t.t>3?t.t-4:t.t:Array.isArray(n)?1:c(n)?2:v(n)?3:0}function u(n,t){return 2===i(n)?n.has(t):Object.prototype.hasOwnProperty.call(n,t)}function o(n,t){return 2===i(n)?n.get(t):n[t]}function f(n,t,r){var e=i(n);2===e?n.set(t,r):3===e?(n.delete(t),n.add(r)):n[t]=r;}function a(n,t){return n===t?0!==n||1/n==1/t:n!=n&&t!=t}function c(n){return W&&n instanceof Map}function v(n){return X&&n instanceof Set}function s(n){return n.i||n.u}function p(n){if(Array.isArray(n))return Array.prototype.slice.call(n);var t=U(n);delete t[H];for(var r=T(t),e=0;e<r.length;e++){var i=r[e],u=t[i];!1===u.writable&&(u.writable=!0,u.configurable=!0),(u.get||u.set)&&(t[i]={configurable:!0,writable:!0,enumerable:u.enumerable,value:n[i]});}return Object.create(Object.getPrototypeOf(n),t)}function l(n,u){return void 0===u&&(u=!1),h(n)||t(n)||!r(n)?n:(i(n)>1&&(n.set=n.add=n.clear=n.delete=d),Object.freeze(n),u&&e(n,(function(n,t){return l(t,!0)}),!0),n)}function d(){n(2);}function h(n){return null==n||"object"!=typeof n||Object.isFrozen(n)}function y(t){var r=V[t];return r||n(18,t),r}function _(n,t){V[n]||(V[n]=t);}function b(){return J}function m(n,t){t&&(y("Patches"),n.o=[],n.v=[],n.s=t);}function j(n){O(n),n.p.forEach(w),n.p=null;}function O(n){n===J&&(J=n.l);}function x(n){return J={p:[],l:J,h:n,_:!0,m:0}}function w(n){var t=n[H];0===t.t||1===t.t?t.j():t.O=!0;}function S(t,e){e.m=e.p.length;var i=e.p[0],u=void 0!==t&&t!==i;return e.h.S||y("ES5").P(e,t,u),u?(i[H].M&&(j(e),n(4)),r(t)&&(t=P(e,t),e.l||g(e,t)),e.o&&y("Patches").g(i[H].u,t,e.o,e.v)):t=P(e,i,[]),j(e),e.o&&e.s(e.o,e.v),t!==B?t:void 0}function P(n,t,r){if(h(t))return t;var i=t[H];if(!i)return e(t,(function(e,u){return M(n,i,t,e,u,r)}),!0),t;if(i.A!==n)return t;if(!i.M)return g(n,i.u,!0),i.u;if(!i.R){i.R=!0,i.A.m--;var u=4===i.t||5===i.t?i.i=p(i.k):i.i;e(3===i.t?new Set(u):u,(function(t,e){return M(n,i,u,t,e,r)})),g(n,u,!1),r&&n.o&&y("Patches").F(i,r,n.o,n.v);}return i.i}function M(n,e,i,o,a,c){if(t(a)){var v=P(n,a,c&&e&&3!==e.t&&!u(e.D,o)?c.concat(o):void 0);if(f(i,o,v),!t(v))return;n._=!1;}if(r(a)&&!h(a)){if(!n.h.K&&n.m<1)return;P(n,a),e&&e.A.l||g(n,a);}}function g(n,t,r){void 0===r&&(r=!1),n.h.K&&n._&&l(t,r);}function A(n,t){var r=n[H];return (r?s(r):n)[t]}function z(n,t){if(t in n)for(var r=Object.getPrototypeOf(n);r;){var e=Object.getOwnPropertyDescriptor(r,t);if(e)return e;r=Object.getPrototypeOf(r);}}function E(n){n.M||(n.M=!0,n.l&&E(n.l));}function R(n){n.i||(n.i=p(n.u));}function k(n,t,r){var e=c(t)?y("MapSet").$(t,r):v(t)?y("MapSet").C(t,r):n.S?function(n,t){var r=Array.isArray(n),e={t:r?1:0,A:t?t.A:b(),M:!1,R:!1,D:{},l:t,u:n,k:null,i:null,j:null,I:!1},i=e,u=Y;r&&(i=[e],u=Z);var o=Proxy.revocable(i,u),f=o.revoke,a=o.proxy;return e.k=a,e.j=f,a}(t,r):y("ES5").J(t,r);return (r?r.A:b()).p.push(e),e}function F(u){return t(u)||n(22,u),function n(t){if(!r(t))return t;var u,a=t[H],c=i(t);if(a){if(!a.M&&(a.t<4||!y("ES5").N(a)))return a.u;a.R=!0,u=D(t,c),a.R=!1;}else u=D(t,c);return e(u,(function(t,r){a&&o(a.u,t)===r||f(u,t,n(r));})),3===c?new Set(u):u}(u)}function D(n,t){switch(t){case 2:return new Map(n);case 3:return Array.from(n)}return p(n)}function K(){function n(n,t){var r=f[n];return r?r.enumerable=t:f[n]=r={configurable:!0,enumerable:t,get:function(){return Y.get(this[H],n)},set:function(t){Y.set(this[H],n,t);}},r}function r(n){for(var t=n.length-1;t>=0;t--){var r=n[t][H];if(!r.M)switch(r.t){case 5:o(r)&&E(r);break;case 4:i(r)&&E(r);}}}function i(n){for(var t=n.u,r=n.k,e=T(r),i=e.length-1;i>=0;i--){var o=e[i];if(o!==H){var f=t[o];if(void 0===f&&!u(t,o))return !0;var c=r[o],v=c&&c[H];if(v?v.u!==f:!a(c,f))return !0}}var s=!!t[H];return e.length!==T(t).length+(s?0:1)}function o(n){var t=n.k;if(t.length!==n.u.length)return !0;var r=Object.getOwnPropertyDescriptor(t,t.length-1);if(r&&!r.get)return !0;for(var e=0;e<t.length;e++)if(!t.hasOwnProperty(e))return !0;return !1}var f={};_("ES5",{J:function(t,r){var e=Array.isArray(t),i=function(t,r){if(t){for(var e=Array(r.length),i=0;i<r.length;i++)Object.defineProperty(e,""+i,n(i,!0));return e}var u=U(r);delete u[H];for(var o=T(u),f=0;f<o.length;f++){var a=o[f];u[a]=n(a,t||!!u[a].enumerable);}return Object.create(Object.getPrototypeOf(r),u)}(e,t),u={t:e?5:4,A:r?r.A:b(),M:!1,R:!1,D:{},l:r,u:t,k:i,i:null,O:!1,I:!1};return Object.defineProperty(i,H,{value:u,writable:!0}),i},P:function(n,i,f){f?t(i)&&i[H].A===n&&r(n.p):(n.o&&function n(t){if(t&&"object"==typeof t){var r=t[H];if(r){var i=r.u,f=r.k,a=r.D,c=r.t;if(4===c)e(f,(function(t){t!==H&&(void 0!==i[t]||u(i,t)?a[t]||n(f[t]):(a[t]=!0,E(r)));})),e(i,(function(n){void 0!==f[n]||u(f,n)||(a[n]=!1,E(r));}));else if(5===c){if(o(r)&&(E(r),a.length=!0),f.length<i.length)for(var v=f.length;v<i.length;v++)a[v]=!1;else for(var s=i.length;s<f.length;s++)a[s]=!0;for(var p=Math.min(f.length,i.length),l=0;l<p;l++)f.hasOwnProperty(l)||(a[l]=!0),void 0===a[l]&&n(f[l]);}}}}(n.p[0]),r(n.p));},N:function(n){return 4===n.t?i(n):o(n)}});}function $(){function f(n){if(!r(n))return n;if(Array.isArray(n))return n.map(f);if(c(n))return new Map(Array.from(n.entries()).map((function(n){return [n[0],f(n[1])]})));if(v(n))return new Set(Array.from(n).map(f));var t=Object.create(Object.getPrototypeOf(n));for(var e in n)t[e]=f(n[e]);return u(n,G)&&(t[G]=n[G]),t}function a(n){return t(n)?f(n):n}var s="add";_("Patches",{W:function(t,r){return r.forEach((function(r){for(var e=r.path,u=r.op,a=t,c=0;c<e.length-1;c++){var v=i(a),p=""+e[c];0!==v&&1!==v||"__proto__"!==p&&"constructor"!==p||n(24),"function"==typeof a&&"prototype"===p&&n(24),"object"!=typeof(a=o(a,p))&&n(15,e.join("/"));}var l=i(a),d=f(r.value),h=e[e.length-1];switch(u){case"replace":switch(l){case 2:return a.set(h,d);case 3:n(16);default:return a[h]=d}case s:switch(l){case 1:return "-"===h?a.push(d):a.splice(h,0,d);case 2:return a.set(h,d);case 3:return a.add(d);default:return a[h]=d}case"remove":switch(l){case 1:return a.splice(h,1);case 2:return a.delete(h);case 3:return a.delete(r.value);default:return delete a[h]}default:n(17,u);}})),t},F:function(n,t,r,i){switch(n.t){case 0:case 4:case 2:return function(n,t,r,i){var f=n.u,c=n.i;e(n.D,(function(n,e){var v=o(f,n),p=o(c,n),l=e?u(f,n)?"replace":s:"remove";if(v!==p||"replace"!==l){var d=t.concat(n);r.push("remove"===l?{op:l,path:d}:{op:l,path:d,value:p}),i.push(l===s?{op:"remove",path:d}:"remove"===l?{op:s,path:d,value:a(v)}:{op:"replace",path:d,value:a(v)});}}));}(n,t,r,i);case 5:case 1:return function(n,t,r,e){var i=n.u,u=n.D,o=n.i;if(o.length<i.length){var f=[o,i];i=f[0],o=f[1];var c=[e,r];r=c[0],e=c[1];}for(var v=0;v<i.length;v++)if(u[v]&&o[v]!==i[v]){var p=t.concat([v]);r.push({op:"replace",path:p,value:a(o[v])}),e.push({op:"replace",path:p,value:a(i[v])});}for(var l=i.length;l<o.length;l++){var d=t.concat([l]);r.push({op:s,path:d,value:a(o[l])});}i.length<o.length&&e.push({op:"replace",path:t.concat(["length"]),value:i.length});}(n,t,r,i);case 3:return function(n,t,r,e){var i=n.u,u=n.i,o=0;i.forEach((function(n){if(!u.has(n)){var i=t.concat([o]);r.push({op:"remove",path:i,value:n}),e.unshift({op:s,path:i,value:n});}o++;})),o=0,u.forEach((function(n){if(!i.has(n)){var u=t.concat([o]);r.push({op:s,path:u,value:n}),e.unshift({op:"remove",path:u,value:n});}o++;}));}(n,t,r,i)}},g:function(n,t,r,e){r.push({op:"replace",path:[],value:t===B?void 0:t}),e.push({op:"replace",path:[],value:n});}});}function C(){function t(n,t){function r(){this.constructor=n;}f(n,t),n.prototype=(r.prototype=t.prototype,new r);}function i(n){n.i||(n.D=new Map,n.i=new Map(n.u));}function u(n){n.i||(n.i=new Set,n.u.forEach((function(t){if(r(t)){var e=k(n.A.h,t,n);n.p.set(t,e),n.i.add(e);}else n.i.add(t);})));}function o(t){t.O&&n(3,JSON.stringify(s(t)));}var f=function(n,t){return (f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,t){n.__proto__=t;}||function(n,t){for(var r in t)t.hasOwnProperty(r)&&(n[r]=t[r]);})(n,t)},a=function(){function n(n,t){return this[H]={t:2,l:t,A:t?t.A:b(),M:!1,R:!1,i:void 0,D:void 0,u:n,k:this,I:!1,O:!1},this}t(n,Map);var u=n.prototype;return Object.defineProperty(u,"size",{get:function(){return s(this[H]).size}}),u.has=function(n){return s(this[H]).has(n)},u.set=function(n,t){var r=this[H];return o(r),s(r).has(n)&&s(r).get(n)===t||(i(r),E(r),r.D.set(n,!0),r.i.set(n,t),r.D.set(n,!0)),this},u.delete=function(n){if(!this.has(n))return !1;var t=this[H];return o(t),i(t),E(t),t.u.has(n)?t.D.set(n,!1):t.D.delete(n),t.i.delete(n),!0},u.clear=function(){var n=this[H];o(n),s(n).size&&(i(n),E(n),n.D=new Map,e(n.u,(function(t){n.D.set(t,!1);})),n.i.clear());},u.forEach=function(n,t){var r=this;s(this[H]).forEach((function(e,i){n.call(t,r.get(i),i,r);}));},u.get=function(n){var t=this[H];o(t);var e=s(t).get(n);if(t.R||!r(e))return e;if(e!==t.u.get(n))return e;var u=k(t.A.h,e,t);return i(t),t.i.set(n,u),u},u.keys=function(){return s(this[H]).keys()},u.values=function(){var n,t=this,r=this.keys();return (n={})[L]=function(){return t.values()},n.next=function(){var n=r.next();return n.done?n:{done:!1,value:t.get(n.value)}},n},u.entries=function(){var n,t=this,r=this.keys();return (n={})[L]=function(){return t.entries()},n.next=function(){var n=r.next();if(n.done)return n;var e=t.get(n.value);return {done:!1,value:[n.value,e]}},n},u[L]=function(){return this.entries()},n}(),c=function(){function n(n,t){return this[H]={t:3,l:t,A:t?t.A:b(),M:!1,R:!1,i:void 0,u:n,k:this,p:new Map,O:!1,I:!1},this}t(n,Set);var r=n.prototype;return Object.defineProperty(r,"size",{get:function(){return s(this[H]).size}}),r.has=function(n){var t=this[H];return o(t),t.i?!!t.i.has(n)||!(!t.p.has(n)||!t.i.has(t.p.get(n))):t.u.has(n)},r.add=function(n){var t=this[H];return o(t),this.has(n)||(u(t),E(t),t.i.add(n)),this},r.delete=function(n){if(!this.has(n))return !1;var t=this[H];return o(t),u(t),E(t),t.i.delete(n)||!!t.p.has(n)&&t.i.delete(t.p.get(n))},r.clear=function(){var n=this[H];o(n),s(n).size&&(u(n),E(n),n.i.clear());},r.values=function(){var n=this[H];return o(n),u(n),n.i.values()},r.entries=function(){var n=this[H];return o(n),u(n),n.i.entries()},r.keys=function(){return this.values()},r[L]=function(){return this.values()},r.forEach=function(n,t){for(var r=this.values(),e=r.next();!e.done;)n.call(t,e.value,e.value,this),e=r.next();},n}();_("MapSet",{$:function(n,t){return new a(n,t)},C:function(n,t){return new c(n,t)}});}var I;Object.defineProperty(exports,"__esModule",{value:!0});var J,N="undefined"!=typeof Symbol&&"symbol"==typeof Symbol("x"),W="undefined"!=typeof Map,X="undefined"!=typeof Set,q="undefined"!=typeof Proxy&&void 0!==Proxy.revocable&&"undefined"!=typeof Reflect,B=N?Symbol.for("immer-nothing"):((I={})["immer-nothing"]=!0,I),G=N?Symbol.for("immer-draftable"):"__$immer_draftable",H=N?Symbol.for("immer-state"):"__$immer_state",L="undefined"!=typeof Symbol&&Symbol.iterator||"@@iterator",Q=""+Object.prototype.constructor,T="undefined"!=typeof Reflect&&Reflect.ownKeys?Reflect.ownKeys:void 0!==Object.getOwnPropertySymbols?function(n){return Object.getOwnPropertyNames(n).concat(Object.getOwnPropertySymbols(n))}:Object.getOwnPropertyNames,U=Object.getOwnPropertyDescriptors||function(n){var t={};return T(n).forEach((function(r){t[r]=Object.getOwnPropertyDescriptor(n,r);})),t},V={},Y={get:function(n,t){if(t===H)return n;var e=s(n);if(!u(e,t))return function(n,t,r){var e,i=z(t,r);return i?"value"in i?i.value:null===(e=i.get)||void 0===e?void 0:e.call(n.k):void 0}(n,e,t);var i=e[t];return n.R||!r(i)?i:i===A(n.u,t)?(R(n),n.i[t]=k(n.A.h,i,n)):i},has:function(n,t){return t in s(n)},ownKeys:function(n){return Reflect.ownKeys(s(n))},set:function(n,t,r){var e=z(s(n),t);if(null==e?void 0:e.set)return e.set.call(n.k,r),!0;if(!n.M){var i=A(s(n),t),o=null==i?void 0:i[H];if(o&&o.u===r)return n.i[t]=r,n.D[t]=!1,!0;if(a(r,i)&&(void 0!==r||u(n.u,t)))return !0;R(n),E(n);}return n.i[t]===r&&"number"!=typeof r&&(void 0!==r||t in n.i)||(n.i[t]=r,n.D[t]=!0,!0)},deleteProperty:function(n,t){return void 0!==A(n.u,t)||t in n.u?(n.D[t]=!1,R(n),E(n)):delete n.D[t],n.i&&delete n.i[t],!0},getOwnPropertyDescriptor:function(n,t){var r=s(n),e=Reflect.getOwnPropertyDescriptor(r,t);return e?{writable:!0,configurable:1!==n.t||"length"!==t,enumerable:e.enumerable,value:r[t]}:e},defineProperty:function(){n(11);},getPrototypeOf:function(n){return Object.getPrototypeOf(n.u)},setPrototypeOf:function(){n(12);}},Z={};e(Y,(function(n,t){Z[n]=function(){return arguments[0]=arguments[0][0],t.apply(this,arguments)};})),Z.deleteProperty=function(n,t){return Z.set.call(this,n,t,void 0)},Z.set=function(n,t,r){return Y.set.call(this,n[0],t,r,n[0])};var nn=function(){function e(t){var e=this;this.S=q,this.K=!0,this.produce=function(t,i,u){if("function"==typeof t&&"function"!=typeof i){var o=i;i=t;var f=e;return function(n){var t=this;void 0===n&&(n=o);for(var r=arguments.length,e=Array(r>1?r-1:0),u=1;u<r;u++)e[u-1]=arguments[u];return f.produce(n,(function(n){var r;return (r=i).call.apply(r,[t,n].concat(e))}))}}var a;if("function"!=typeof i&&n(6),void 0!==u&&"function"!=typeof u&&n(7),r(t)){var c=x(e),v=k(e,t,void 0),s=!0;try{a=i(v),s=!1;}finally{s?j(c):O(c);}return "undefined"!=typeof Promise&&a instanceof Promise?a.then((function(n){return m(c,u),S(n,c)}),(function(n){throw j(c),n})):(m(c,u),S(a,c))}if(!t||"object"!=typeof t){if(void 0===(a=i(t))&&(a=t),a===B&&(a=void 0),e.K&&l(a,!0),u){var p=[],d=[];y("Patches").g(t,a,p,d),u(p,d);}return a}n(21,t);},this.produceWithPatches=function(n,t){if("function"==typeof n)return function(t){for(var r=arguments.length,i=Array(r>1?r-1:0),u=1;u<r;u++)i[u-1]=arguments[u];return e.produceWithPatches(t,(function(t){return n.apply(void 0,[t].concat(i))}))};var r,i,u=e.produce(n,t,(function(n,t){r=n,i=t;}));return "undefined"!=typeof Promise&&u instanceof Promise?u.then((function(n){return [n,r,i]})):[u,r,i]},"boolean"==typeof(null==t?void 0:t.useProxies)&&this.setUseProxies(t.useProxies),"boolean"==typeof(null==t?void 0:t.autoFreeze)&&this.setAutoFreeze(t.autoFreeze);}var i=e.prototype;return i.createDraft=function(e){r(e)||n(8),t(e)&&(e=F(e));var i=x(this),u=k(this,e,void 0);return u[H].I=!0,O(i),u},i.finishDraft=function(n,t){var r=(n&&n[H]).A;return m(r,t),S(void 0,r)},i.setAutoFreeze=function(n){this.K=n;},i.setUseProxies=function(t){t&&!q&&n(20),this.S=t;},i.applyPatches=function(n,r){var e;for(e=r.length-1;e>=0;e--){var i=r[e];if(0===i.path.length&&"replace"===i.op){n=i.value;break}}e>-1&&(r=r.slice(e+1));var u=y("Patches").W;return t(n)?u(n,r):this.produce(n,(function(n){return u(n,r)}))},e}(),tn=new nn,rn=tn.produce,en=tn.produceWithPatches.bind(tn),un=tn.setAutoFreeze.bind(tn),on=tn.setUseProxies.bind(tn),fn=tn.applyPatches.bind(tn),an=tn.createDraft.bind(tn),cn=tn.finishDraft.bind(tn);exports.Immer=nn,exports.applyPatches=fn,exports.castDraft=function(n){return n},exports.castImmutable=function(n){return n},exports.createDraft=an,exports.current=F,exports.default=rn,exports.enableAllPlugins=function(){K(),C(),$();},exports.enableES5=K,exports.enableMapSet=C,exports.enablePatches=$,exports.finishDraft=cn,exports.freeze=l,exports.immerable=G,exports.isDraft=t,exports.isDraftable=r,exports.nothing=B,exports.original=function(r){return t(r)||n(23,r),r[H].u},exports.produce=rn,exports.produceWithPatches=en,exports.setAutoFreeze=un,exports.setUseProxies=on;

});

var dist = createCommonjsModule(function (module) {

{
  module.exports = immer_cjs_production_min;
}
});

var globals$1 = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.globals = void 0;




/**
 * Global accessors for state/dispatch in the controller.
 */
class Globals {
    constructor() {
        this._runningControllers = false;
    }
    initialize(rootController) {
        this._rootController = rootController;
        this._state = (0, empty_state.createEmptyState)();
    }
    dispatch(action) {
        globals.globals.dispatch(action);
    }
    // Send the passed dispatch actions to the frontend. The frontend logic
    // will run the actions, compute the new state and invoke patchState() so
    // our copy is updated.
    dispatchMultiple(actions) {
        for (const action of actions) {
            this.dispatch(action);
        }
    }
    // This is called by the frontend logic which now owns and handle the
    // source-of-truth state, to give us an update on the newer state updates.
    patchState(patches) {
        this._state = (0, dist.applyPatches)((0, logging.assertExists)(this._state), patches);
        this.runControllers();
    }
    runControllers() {
        if (this._runningControllers)
            throw new Error('Re-entrant call detected');
        // Run controllers locally until all state machines reach quiescence.
        let runAgain = true;
        for (let iter = 0; runAgain; iter++) {
            if (iter > 100)
                throw new Error('Controllers are stuck in a livelock');
            this._runningControllers = true;
            try {
                runAgain = (0, logging.assertExists)(this._rootController).invoke();
            }
            finally {
                this._runningControllers = false;
            }
        }
    }
    get state() {
        return (0, logging.assertExists)(this._state);
    }
    resetForTesting() {
        this._state = undefined;
        this._rootController = undefined;
    }
}
exports.globals = new Globals();

});

var track_controller = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.trackControllerRegistry = exports.TrackController = void 0;








// Allow to override via devtools for testing (note, needs to be done in the
// controller-thread).
self.quantPx = 1;
// TrackController is a base class overridden by track implementations (e.g.,
// sched slices, nestable slices, counters).
class TrackController extends controller.Controller {
    constructor(args) {
        super('main');
        this.requestingData = false;
        this.queuedRequest = false;
        this.isSetup = false;
        this.lastReloadHandled = 0;
        this.trackId = args.trackId;
        this.engine = args.engine;
    }
    pxSize() {
        return self.quantPx;
    }
    // Can be overriden by the track implementation to allow one time setup work
    // to be performed before the first onBoundsChange invcation.
    onSetup() {
        return tslib.__awaiter(this, void 0, void 0, function* () { });
    }
    // Can be overriden by the track implementation to allow some one-off work
    // when requested reload (e.g. recalculating height).
    onReload() {
        return tslib.__awaiter(this, void 0, void 0, function* () { });
    }
    get trackState() {
        return (0, logging.assertExists)(globals$1.globals.state.tracks[this.trackId]);
    }
    get config() {
        return this.trackState.config;
    }
    configHasNamespace(config) {
        return 'namespace' in config;
    }
    namespaceTable(tableName) {
        if (this.configHasNamespace(this.config)) {
            return this.config.namespace + '_' + tableName;
        }
        else {
            return tableName;
        }
    }
    publish(data) {
        this.data = data;
        (0, publish.publishTrackData)({ id: this.trackId, data });
    }
    // Returns a valid SQL table name with the given prefix that should be unique
    // for each track.
    tableName(prefix) {
        // Derive table name from, since that is unique for each track.
        // Track ID can be UUID but '-' is not valid for sql table name.
        const idSuffix = this.trackId.split('-').join('_');
        return `${prefix}_${idSuffix}`;
    }
    shouldSummarize(resolution) {
        // |resolution| is in s/px (to nearest power of 10) assuming a display
        // of ~1000px 0.0008 is 0.8s.
        return resolution >= 0.0008;
    }
    query(query) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const result = yield this.engine.query(query);
            return result;
        });
    }
    shouldReload() {
        const { lastTrackReloadRequest } = globals$1.globals.state;
        return !!lastTrackReloadRequest &&
            this.lastReloadHandled < lastTrackReloadRequest;
    }
    markReloadHandled() {
        this.lastReloadHandled = globals$1.globals.state.lastTrackReloadRequest || 0;
    }
    shouldRequestData(traceTime) {
        if (this.data === undefined)
            return true;
        if (this.shouldReload())
            return true;
        // If at the limit only request more data if the view has moved.
        const atLimit = this.data.length === track_data.LIMIT;
        if (atLimit) {
            // We request more data than the window, so add window duration to find
            // the previous window.
            const prevWindowStart = this.data.start + (traceTime.startSec - traceTime.endSec);
            return traceTime.startSec !== prevWindowStart;
        }
        // Otherwise request more data only when out of range of current data or
        // resolution has changed.
        const inRange = traceTime.startSec >= this.data.start &&
            traceTime.endSec <= this.data.end;
        return !inRange ||
            this.data.resolution !==
                globals$1.globals.state.frontendLocalState.visibleState.resolution;
    }
    // Decides, based on the length of the trace and the number of rows
    // provided whether a TrackController subclass should cache its quantized
    // data. Returns the bucket size (in ns) if caching should happen and
    // undefined otherwise.
    // Subclasses should call this in their setup function
    cachedBucketSizeNs(numRows) {
        // Ensure that we're not caching when the table size isn't even that big.
        if (numRows < TrackController.MIN_TABLE_SIZE_TO_CACHE) {
            return undefined;
        }
        const bounds = globals$1.globals.state.traceTime;
        const traceDurNs = (0, time.toNs)(bounds.endSec - bounds.startSec);
        // For large traces, going through the raw table in the most zoomed-out
        // states can be very expensive as this can involve going through O(millions
        // of rows). The cost of this becomes high even for just iteration but is
        // especially slow as quantization involves a SQLite sort on the quantized
        // timestamp (for the group by).
        //
        // To get around this, we can cache a pre-quantized table which we can then
        // in zoomed-out situations and fall back to the real table when zoomed in
        // (which naturally constrains the amount of data by virtue of the window
        // covering a smaller timespan)
        //
        // This method computes that cached table by computing an approximation for
        // the bucket size we would use when totally zoomed out and then going a few
        // resolution levels down which ensures that our cached table works for more
        // than the literally most zoomed out state. Moving down a resolution level
        // is defined as moving down a power of 2; this matches the logic in
        // |globals.getCurResolution|.
        //
        // TODO(lalitm): in the future, we should consider having a whole set of
        // quantized tables each of which cover some portion of resolution lvel
        // range. As each table covers a large number of resolution levels, even 3-4
        // tables should really cover the all concievable trace sizes. This set
        // could be computed by looking at the number of events being processed one
        // level below the cached table and computing another layer of caching if
        // that count is too high (with respect to MIN_TABLE_SIZE_TO_CACHE).
        // 4k monitors have 3840 horizontal pixels so use that for a worst case
        // approximation of the window width.
        const approxWidthPx = 3840;
        // Compute the outermost bucket size. This acts as a starting point for
        // computing the cached size.
        const outermostResolutionLevel = Math.ceil(Math.log2(traceDurNs / approxWidthPx));
        const outermostBucketNs = Math.pow(2, outermostResolutionLevel);
        // This constant decides how many resolution levels down from our outermost
        // bucket computation we want to be able to use the cached table.
        // We've chosen 7 as it seems to be empircally seems to be a good fit for
        // trace data.
        const resolutionLevelsCovered = 7;
        // If we've got less resolution levels in the trace than the number of
        // resolution levels we want to go down, bail out because this cached
        // table is really not going to be used enough.
        if (outermostResolutionLevel < resolutionLevelsCovered) {
            return Number.MAX_SAFE_INTEGER;
        }
        // Another way to look at moving down resolution levels is to consider how
        // many sub-intervals we are splitting the bucket into.
        const bucketSubIntervals = Math.pow(2, resolutionLevelsCovered);
        // Calculate the smallest bucket we want our table to be able to handle by
        // dividing the outermsot bucket by the number of subintervals we should
        // divide by.
        const cachedBucketSizeNs = outermostBucketNs / bucketSubIntervals;
        // Our logic above should make sure this is an integer but double check that
        // here as an assertion before returning.
        (0, logging.assertTrue)(Number.isInteger(cachedBucketSizeNs));
        return cachedBucketSizeNs;
    }
    run() {
        const visibleState = globals$1.globals.state.frontendLocalState.visibleState;
        if (visibleState === undefined || visibleState.resolution === undefined ||
            visibleState.resolution === Infinity) {
            return;
        }
        const dur = visibleState.endSec - visibleState.startSec;
        if (globals$1.globals.state.visibleTracks.includes(this.trackId) &&
            this.shouldRequestData(visibleState)) {
            if (this.requestingData) {
                this.queuedRequest = true;
            }
            else {
                this.requestingData = true;
                let promise = Promise.resolve();
                if (!this.isSetup) {
                    promise = this.onSetup();
                }
                else if (this.shouldReload()) {
                    promise = this.onReload().then(() => this.markReloadHandled());
                }
                promise
                    .then(() => {
                    this.isSetup = true;
                    let resolution = visibleState.resolution;
                    // TODO(hjd): We shouldn't have to be so defensive here.
                    if (Math.log2((0, time.toNs)(resolution)) % 1 !== 0) {
                        // resolution is in pixels per second so 1000 means
                        // 1px = 1ms.
                        resolution =
                            (0, time.fromNs)(Math.pow(2, Math.floor(Math.log2((0, time.toNs)(1000)))));
                    }
                    return this.onBoundsChange(visibleState.startSec - dur, visibleState.endSec + dur, resolution);
                })
                    .then((data) => {
                    this.publish(data);
                })
                    .finally(() => {
                    this.requestingData = false;
                    if (this.queuedRequest) {
                        this.queuedRequest = false;
                        this.run();
                    }
                });
            }
        }
    }
}
exports.TrackController = TrackController;
// We choose 100000 as the table size to cache as this is roughly the point
// where SQLite sorts start to become expensive.
TrackController.MIN_TABLE_SIZE_TO_CACHE = 100000;
exports.trackControllerRegistry = registry.Registry.kindRegistry();

});

var track_registry = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.trackRegistry = void 0;

/**
 * Global registry that maps types to TrackCreator.
 */
exports.trackRegistry = registry.Registry.kindRegistry();

});

var plugins = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.pluginRegistry = exports.PluginContextImpl = void 0;



// Every plugin gets its own PluginContext. This is how we keep track
// what each plugin is doing and how we can blame issues on particular
// plugins.
class PluginContextImpl {
    constructor(pluginName) {
        this.pluginName = pluginName;
    }
    registerTrackController(track) {
        track_controller.trackControllerRegistry.register(track);
    }
    registerTrack(track) {
        track_registry.trackRegistry.register(track);
    }
}
exports.PluginContextImpl = PluginContextImpl;
exports.pluginRegistry = new registry.Registry((info) => {
    return info.pluginId;
});

});

var aspromise = asPromise;

/**
 * Callback as used by {@link util.asPromise}.
 * @typedef asPromiseCallback
 * @type {function}
 * @param {Error|null} error Error, if any
 * @param {...*} params Additional arguments
 * @returns {undefined}
 */

/**
 * Returns a promise from a node-style callback function.
 * @memberof util
 * @param {asPromiseCallback} fn Function to call
 * @param {*} ctx Function context
 * @param {...*} params Function arguments
 * @returns {Promise<*>} Promisified function
 */
function asPromise(fn, ctx/*, varargs */) {
    var params  = new Array(arguments.length - 1),
        offset  = 0,
        index   = 2,
        pending = true;
    while (index < arguments.length)
        params[offset++] = arguments[index++];
    return new Promise(function executor(resolve, reject) {
        params[offset] = function callback(err/*, varargs */) {
            if (pending) {
                pending = false;
                if (err)
                    reject(err);
                else {
                    var params = new Array(arguments.length - 1),
                        offset = 0;
                    while (offset < params.length)
                        params[offset++] = arguments[offset];
                    resolve.apply(null, params);
                }
            }
        };
        try {
            fn.apply(ctx || null, params);
        } catch (err) {
            if (pending) {
                pending = false;
                reject(err);
            }
        }
    });
}

var base64_1 = createCommonjsModule(function (module, exports) {

/**
 * A minimal base64 implementation for number arrays.
 * @memberof util
 * @namespace
 */
var base64 = exports;

/**
 * Calculates the byte length of a base64 encoded string.
 * @param {string} string Base64 encoded string
 * @returns {number} Byte length
 */
base64.length = function length(string) {
    var p = string.length;
    if (!p)
        return 0;
    var n = 0;
    while (--p % 4 > 1 && string.charAt(p) === "=")
        ++n;
    return Math.ceil(string.length * 3) / 4 - n;
};

// Base64 encoding table
var b64 = new Array(64);

// Base64 decoding table
var s64 = new Array(123);

// 65..90, 97..122, 48..57, 43, 47
for (var i = 0; i < 64;)
    s64[b64[i] = i < 26 ? i + 65 : i < 52 ? i + 71 : i < 62 ? i - 4 : i - 59 | 43] = i++;

/**
 * Encodes a buffer to a base64 encoded string.
 * @param {Uint8Array} buffer Source buffer
 * @param {number} start Source start
 * @param {number} end Source end
 * @returns {string} Base64 encoded string
 */
base64.encode = function encode(buffer, start, end) {
    var parts = null,
        chunk = [];
    var i = 0, // output index
        j = 0, // goto index
        t;     // temporary
    while (start < end) {
        var b = buffer[start++];
        switch (j) {
            case 0:
                chunk[i++] = b64[b >> 2];
                t = (b & 3) << 4;
                j = 1;
                break;
            case 1:
                chunk[i++] = b64[t | b >> 4];
                t = (b & 15) << 2;
                j = 2;
                break;
            case 2:
                chunk[i++] = b64[t | b >> 6];
                chunk[i++] = b64[b & 63];
                j = 0;
                break;
        }
        if (i > 8191) {
            (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
            i = 0;
        }
    }
    if (j) {
        chunk[i++] = b64[t];
        chunk[i++] = 61;
        if (j === 1)
            chunk[i++] = 61;
    }
    if (parts) {
        if (i)
            parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
        return parts.join("");
    }
    return String.fromCharCode.apply(String, chunk.slice(0, i));
};

var invalidEncoding = "invalid encoding";

/**
 * Decodes a base64 encoded string to a buffer.
 * @param {string} string Source string
 * @param {Uint8Array} buffer Destination buffer
 * @param {number} offset Destination offset
 * @returns {number} Number of bytes written
 * @throws {Error} If encoding is invalid
 */
base64.decode = function decode(string, buffer, offset) {
    var start = offset;
    var j = 0, // goto index
        t;     // temporary
    for (var i = 0; i < string.length;) {
        var c = string.charCodeAt(i++);
        if (c === 61 && j > 1)
            break;
        if ((c = s64[c]) === undefined)
            throw Error(invalidEncoding);
        switch (j) {
            case 0:
                t = c;
                j = 1;
                break;
            case 1:
                buffer[offset++] = t << 2 | (c & 48) >> 4;
                t = c;
                j = 2;
                break;
            case 2:
                buffer[offset++] = (t & 15) << 4 | (c & 60) >> 2;
                t = c;
                j = 3;
                break;
            case 3:
                buffer[offset++] = (t & 3) << 6 | c;
                j = 0;
                break;
        }
    }
    if (j === 1)
        throw Error(invalidEncoding);
    return offset - start;
};

/**
 * Tests if the specified string appears to be base64 encoded.
 * @param {string} string String to test
 * @returns {boolean} `true` if probably base64 encoded, otherwise false
 */
base64.test = function test(string) {
    return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(string);
};
});

var eventemitter = EventEmitter;

/**
 * Constructs a new event emitter instance.
 * @classdesc A minimal event emitter.
 * @memberof util
 * @constructor
 */
function EventEmitter() {

    /**
     * Registered listeners.
     * @type {Object.<string,*>}
     * @private
     */
    this._listeners = {};
}

/**
 * Registers an event listener.
 * @param {string} evt Event name
 * @param {function} fn Listener
 * @param {*} [ctx] Listener context
 * @returns {util.EventEmitter} `this`
 */
EventEmitter.prototype.on = function on(evt, fn, ctx) {
    (this._listeners[evt] || (this._listeners[evt] = [])).push({
        fn  : fn,
        ctx : ctx || this
    });
    return this;
};

/**
 * Removes an event listener or any matching listeners if arguments are omitted.
 * @param {string} [evt] Event name. Removes all listeners if omitted.
 * @param {function} [fn] Listener to remove. Removes all listeners of `evt` if omitted.
 * @returns {util.EventEmitter} `this`
 */
EventEmitter.prototype.off = function off(evt, fn) {
    if (evt === undefined)
        this._listeners = {};
    else {
        if (fn === undefined)
            this._listeners[evt] = [];
        else {
            var listeners = this._listeners[evt];
            for (var i = 0; i < listeners.length;)
                if (listeners[i].fn === fn)
                    listeners.splice(i, 1);
                else
                    ++i;
        }
    }
    return this;
};

/**
 * Emits an event by calling its listeners with the specified arguments.
 * @param {string} evt Event name
 * @param {...*} args Arguments
 * @returns {util.EventEmitter} `this`
 */
EventEmitter.prototype.emit = function emit(evt) {
    var listeners = this._listeners[evt];
    if (listeners) {
        var args = [],
            i = 1;
        for (; i < arguments.length;)
            args.push(arguments[i++]);
        for (i = 0; i < listeners.length;)
            listeners[i].fn.apply(listeners[i++].ctx, args);
    }
    return this;
};

var float_1 = factory(factory);

/**
 * Reads / writes floats / doubles from / to buffers.
 * @name util.float
 * @namespace
 */

/**
 * Writes a 32 bit float to a buffer using little endian byte order.
 * @name util.float.writeFloatLE
 * @function
 * @param {number} val Value to write
 * @param {Uint8Array} buf Target buffer
 * @param {number} pos Target buffer offset
 * @returns {undefined}
 */

/**
 * Writes a 32 bit float to a buffer using big endian byte order.
 * @name util.float.writeFloatBE
 * @function
 * @param {number} val Value to write
 * @param {Uint8Array} buf Target buffer
 * @param {number} pos Target buffer offset
 * @returns {undefined}
 */

/**
 * Reads a 32 bit float from a buffer using little endian byte order.
 * @name util.float.readFloatLE
 * @function
 * @param {Uint8Array} buf Source buffer
 * @param {number} pos Source buffer offset
 * @returns {number} Value read
 */

/**
 * Reads a 32 bit float from a buffer using big endian byte order.
 * @name util.float.readFloatBE
 * @function
 * @param {Uint8Array} buf Source buffer
 * @param {number} pos Source buffer offset
 * @returns {number} Value read
 */

/**
 * Writes a 64 bit double to a buffer using little endian byte order.
 * @name util.float.writeDoubleLE
 * @function
 * @param {number} val Value to write
 * @param {Uint8Array} buf Target buffer
 * @param {number} pos Target buffer offset
 * @returns {undefined}
 */

/**
 * Writes a 64 bit double to a buffer using big endian byte order.
 * @name util.float.writeDoubleBE
 * @function
 * @param {number} val Value to write
 * @param {Uint8Array} buf Target buffer
 * @param {number} pos Target buffer offset
 * @returns {undefined}
 */

/**
 * Reads a 64 bit double from a buffer using little endian byte order.
 * @name util.float.readDoubleLE
 * @function
 * @param {Uint8Array} buf Source buffer
 * @param {number} pos Source buffer offset
 * @returns {number} Value read
 */

/**
 * Reads a 64 bit double from a buffer using big endian byte order.
 * @name util.float.readDoubleBE
 * @function
 * @param {Uint8Array} buf Source buffer
 * @param {number} pos Source buffer offset
 * @returns {number} Value read
 */

// Factory function for the purpose of node-based testing in modified global environments
function factory(exports) {

    // float: typed array
    if (typeof Float32Array !== "undefined") (function() {

        var f32 = new Float32Array([ -0 ]),
            f8b = new Uint8Array(f32.buffer),
            le  = f8b[3] === 128;

        function writeFloat_f32_cpy(val, buf, pos) {
            f32[0] = val;
            buf[pos    ] = f8b[0];
            buf[pos + 1] = f8b[1];
            buf[pos + 2] = f8b[2];
            buf[pos + 3] = f8b[3];
        }

        function writeFloat_f32_rev(val, buf, pos) {
            f32[0] = val;
            buf[pos    ] = f8b[3];
            buf[pos + 1] = f8b[2];
            buf[pos + 2] = f8b[1];
            buf[pos + 3] = f8b[0];
        }

        /* istanbul ignore next */
        exports.writeFloatLE = le ? writeFloat_f32_cpy : writeFloat_f32_rev;
        /* istanbul ignore next */
        exports.writeFloatBE = le ? writeFloat_f32_rev : writeFloat_f32_cpy;

        function readFloat_f32_cpy(buf, pos) {
            f8b[0] = buf[pos    ];
            f8b[1] = buf[pos + 1];
            f8b[2] = buf[pos + 2];
            f8b[3] = buf[pos + 3];
            return f32[0];
        }

        function readFloat_f32_rev(buf, pos) {
            f8b[3] = buf[pos    ];
            f8b[2] = buf[pos + 1];
            f8b[1] = buf[pos + 2];
            f8b[0] = buf[pos + 3];
            return f32[0];
        }

        /* istanbul ignore next */
        exports.readFloatLE = le ? readFloat_f32_cpy : readFloat_f32_rev;
        /* istanbul ignore next */
        exports.readFloatBE = le ? readFloat_f32_rev : readFloat_f32_cpy;

    // float: ieee754
    })(); else (function() {

        function writeFloat_ieee754(writeUint, val, buf, pos) {
            var sign = val < 0 ? 1 : 0;
            if (sign)
                val = -val;
            if (val === 0)
                writeUint(1 / val > 0 ? /* positive */ 0 : /* negative 0 */ 2147483648, buf, pos);
            else if (isNaN(val))
                writeUint(2143289344, buf, pos);
            else if (val > 3.4028234663852886e+38) // +-Infinity
                writeUint((sign << 31 | 2139095040) >>> 0, buf, pos);
            else if (val < 1.1754943508222875e-38) // denormal
                writeUint((sign << 31 | Math.round(val / 1.401298464324817e-45)) >>> 0, buf, pos);
            else {
                var exponent = Math.floor(Math.log(val) / Math.LN2),
                    mantissa = Math.round(val * Math.pow(2, -exponent) * 8388608) & 8388607;
                writeUint((sign << 31 | exponent + 127 << 23 | mantissa) >>> 0, buf, pos);
            }
        }

        exports.writeFloatLE = writeFloat_ieee754.bind(null, writeUintLE);
        exports.writeFloatBE = writeFloat_ieee754.bind(null, writeUintBE);

        function readFloat_ieee754(readUint, buf, pos) {
            var uint = readUint(buf, pos),
                sign = (uint >> 31) * 2 + 1,
                exponent = uint >>> 23 & 255,
                mantissa = uint & 8388607;
            return exponent === 255
                ? mantissa
                ? NaN
                : sign * Infinity
                : exponent === 0 // denormal
                ? sign * 1.401298464324817e-45 * mantissa
                : sign * Math.pow(2, exponent - 150) * (mantissa + 8388608);
        }

        exports.readFloatLE = readFloat_ieee754.bind(null, readUintLE);
        exports.readFloatBE = readFloat_ieee754.bind(null, readUintBE);

    })();

    // double: typed array
    if (typeof Float64Array !== "undefined") (function() {

        var f64 = new Float64Array([-0]),
            f8b = new Uint8Array(f64.buffer),
            le  = f8b[7] === 128;

        function writeDouble_f64_cpy(val, buf, pos) {
            f64[0] = val;
            buf[pos    ] = f8b[0];
            buf[pos + 1] = f8b[1];
            buf[pos + 2] = f8b[2];
            buf[pos + 3] = f8b[3];
            buf[pos + 4] = f8b[4];
            buf[pos + 5] = f8b[5];
            buf[pos + 6] = f8b[6];
            buf[pos + 7] = f8b[7];
        }

        function writeDouble_f64_rev(val, buf, pos) {
            f64[0] = val;
            buf[pos    ] = f8b[7];
            buf[pos + 1] = f8b[6];
            buf[pos + 2] = f8b[5];
            buf[pos + 3] = f8b[4];
            buf[pos + 4] = f8b[3];
            buf[pos + 5] = f8b[2];
            buf[pos + 6] = f8b[1];
            buf[pos + 7] = f8b[0];
        }

        /* istanbul ignore next */
        exports.writeDoubleLE = le ? writeDouble_f64_cpy : writeDouble_f64_rev;
        /* istanbul ignore next */
        exports.writeDoubleBE = le ? writeDouble_f64_rev : writeDouble_f64_cpy;

        function readDouble_f64_cpy(buf, pos) {
            f8b[0] = buf[pos    ];
            f8b[1] = buf[pos + 1];
            f8b[2] = buf[pos + 2];
            f8b[3] = buf[pos + 3];
            f8b[4] = buf[pos + 4];
            f8b[5] = buf[pos + 5];
            f8b[6] = buf[pos + 6];
            f8b[7] = buf[pos + 7];
            return f64[0];
        }

        function readDouble_f64_rev(buf, pos) {
            f8b[7] = buf[pos    ];
            f8b[6] = buf[pos + 1];
            f8b[5] = buf[pos + 2];
            f8b[4] = buf[pos + 3];
            f8b[3] = buf[pos + 4];
            f8b[2] = buf[pos + 5];
            f8b[1] = buf[pos + 6];
            f8b[0] = buf[pos + 7];
            return f64[0];
        }

        /* istanbul ignore next */
        exports.readDoubleLE = le ? readDouble_f64_cpy : readDouble_f64_rev;
        /* istanbul ignore next */
        exports.readDoubleBE = le ? readDouble_f64_rev : readDouble_f64_cpy;

    // double: ieee754
    })(); else (function() {

        function writeDouble_ieee754(writeUint, off0, off1, val, buf, pos) {
            var sign = val < 0 ? 1 : 0;
            if (sign)
                val = -val;
            if (val === 0) {
                writeUint(0, buf, pos + off0);
                writeUint(1 / val > 0 ? /* positive */ 0 : /* negative 0 */ 2147483648, buf, pos + off1);
            } else if (isNaN(val)) {
                writeUint(0, buf, pos + off0);
                writeUint(2146959360, buf, pos + off1);
            } else if (val > 1.7976931348623157e+308) { // +-Infinity
                writeUint(0, buf, pos + off0);
                writeUint((sign << 31 | 2146435072) >>> 0, buf, pos + off1);
            } else {
                var mantissa;
                if (val < 2.2250738585072014e-308) { // denormal
                    mantissa = val / 5e-324;
                    writeUint(mantissa >>> 0, buf, pos + off0);
                    writeUint((sign << 31 | mantissa / 4294967296) >>> 0, buf, pos + off1);
                } else {
                    var exponent = Math.floor(Math.log(val) / Math.LN2);
                    if (exponent === 1024)
                        exponent = 1023;
                    mantissa = val * Math.pow(2, -exponent);
                    writeUint(mantissa * 4503599627370496 >>> 0, buf, pos + off0);
                    writeUint((sign << 31 | exponent + 1023 << 20 | mantissa * 1048576 & 1048575) >>> 0, buf, pos + off1);
                }
            }
        }

        exports.writeDoubleLE = writeDouble_ieee754.bind(null, writeUintLE, 0, 4);
        exports.writeDoubleBE = writeDouble_ieee754.bind(null, writeUintBE, 4, 0);

        function readDouble_ieee754(readUint, off0, off1, buf, pos) {
            var lo = readUint(buf, pos + off0),
                hi = readUint(buf, pos + off1);
            var sign = (hi >> 31) * 2 + 1,
                exponent = hi >>> 20 & 2047,
                mantissa = 4294967296 * (hi & 1048575) + lo;
            return exponent === 2047
                ? mantissa
                ? NaN
                : sign * Infinity
                : exponent === 0 // denormal
                ? sign * 5e-324 * mantissa
                : sign * Math.pow(2, exponent - 1075) * (mantissa + 4503599627370496);
        }

        exports.readDoubleLE = readDouble_ieee754.bind(null, readUintLE, 0, 4);
        exports.readDoubleBE = readDouble_ieee754.bind(null, readUintBE, 4, 0);

    })();

    return exports;
}

// uint helpers

function writeUintLE(val, buf, pos) {
    buf[pos    ] =  val        & 255;
    buf[pos + 1] =  val >>> 8  & 255;
    buf[pos + 2] =  val >>> 16 & 255;
    buf[pos + 3] =  val >>> 24;
}

function writeUintBE(val, buf, pos) {
    buf[pos    ] =  val >>> 24;
    buf[pos + 1] =  val >>> 16 & 255;
    buf[pos + 2] =  val >>> 8  & 255;
    buf[pos + 3] =  val        & 255;
}

function readUintLE(buf, pos) {
    return (buf[pos    ]
          | buf[pos + 1] << 8
          | buf[pos + 2] << 16
          | buf[pos + 3] << 24) >>> 0;
}

function readUintBE(buf, pos) {
    return (buf[pos    ] << 24
          | buf[pos + 1] << 16
          | buf[pos + 2] << 8
          | buf[pos + 3]) >>> 0;
}

var inquire_1 = inquire;

/**
 * Requires a module only if available.
 * @memberof util
 * @param {string} moduleName Module to require
 * @returns {?Object} Required module if available and not empty, otherwise `null`
 */
function inquire(moduleName) {
    try {
        var mod = undefined; // eslint-disable-line no-eval
        if (mod && (mod.length || Object.keys(mod).length))
            return mod;
    } catch (e) {} // eslint-disable-line no-empty
    return null;
}

var utf8_1 = createCommonjsModule(function (module, exports) {

/**
 * A minimal UTF8 implementation for number arrays.
 * @memberof util
 * @namespace
 */
var utf8 = exports;

/**
 * Calculates the UTF8 byte length of a string.
 * @param {string} string String
 * @returns {number} Byte length
 */
utf8.length = function utf8_length(string) {
    var len = 0,
        c = 0;
    for (var i = 0; i < string.length; ++i) {
        c = string.charCodeAt(i);
        if (c < 128)
            len += 1;
        else if (c < 2048)
            len += 2;
        else if ((c & 0xFC00) === 0xD800 && (string.charCodeAt(i + 1) & 0xFC00) === 0xDC00) {
            ++i;
            len += 4;
        } else
            len += 3;
    }
    return len;
};

/**
 * Reads UTF8 bytes as a string.
 * @param {Uint8Array} buffer Source buffer
 * @param {number} start Source start
 * @param {number} end Source end
 * @returns {string} String read
 */
utf8.read = function utf8_read(buffer, start, end) {
    var len = end - start;
    if (len < 1)
        return "";
    var parts = null,
        chunk = [],
        i = 0, // char offset
        t;     // temporary
    while (start < end) {
        t = buffer[start++];
        if (t < 128)
            chunk[i++] = t;
        else if (t > 191 && t < 224)
            chunk[i++] = (t & 31) << 6 | buffer[start++] & 63;
        else if (t > 239 && t < 365) {
            t = ((t & 7) << 18 | (buffer[start++] & 63) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63) - 0x10000;
            chunk[i++] = 0xD800 + (t >> 10);
            chunk[i++] = 0xDC00 + (t & 1023);
        } else
            chunk[i++] = (t & 15) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63;
        if (i > 8191) {
            (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
            i = 0;
        }
    }
    if (parts) {
        if (i)
            parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
        return parts.join("");
    }
    return String.fromCharCode.apply(String, chunk.slice(0, i));
};

/**
 * Writes a string as UTF8 bytes.
 * @param {string} string Source string
 * @param {Uint8Array} buffer Destination buffer
 * @param {number} offset Destination offset
 * @returns {number} Bytes written
 */
utf8.write = function utf8_write(string, buffer, offset) {
    var start = offset,
        c1, // character 1
        c2; // character 2
    for (var i = 0; i < string.length; ++i) {
        c1 = string.charCodeAt(i);
        if (c1 < 128) {
            buffer[offset++] = c1;
        } else if (c1 < 2048) {
            buffer[offset++] = c1 >> 6       | 192;
            buffer[offset++] = c1       & 63 | 128;
        } else if ((c1 & 0xFC00) === 0xD800 && ((c2 = string.charCodeAt(i + 1)) & 0xFC00) === 0xDC00) {
            c1 = 0x10000 + ((c1 & 0x03FF) << 10) + (c2 & 0x03FF);
            ++i;
            buffer[offset++] = c1 >> 18      | 240;
            buffer[offset++] = c1 >> 12 & 63 | 128;
            buffer[offset++] = c1 >> 6  & 63 | 128;
            buffer[offset++] = c1       & 63 | 128;
        } else {
            buffer[offset++] = c1 >> 12      | 224;
            buffer[offset++] = c1 >> 6  & 63 | 128;
            buffer[offset++] = c1       & 63 | 128;
        }
    }
    return offset - start;
};
});

var pool_1 = pool;

/**
 * An allocator as used by {@link util.pool}.
 * @typedef PoolAllocator
 * @type {function}
 * @param {number} size Buffer size
 * @returns {Uint8Array} Buffer
 */

/**
 * A slicer as used by {@link util.pool}.
 * @typedef PoolSlicer
 * @type {function}
 * @param {number} start Start offset
 * @param {number} end End offset
 * @returns {Uint8Array} Buffer slice
 * @this {Uint8Array}
 */

/**
 * A general purpose buffer pool.
 * @memberof util
 * @function
 * @param {PoolAllocator} alloc Allocator
 * @param {PoolSlicer} slice Slicer
 * @param {number} [size=8192] Slab size
 * @returns {PoolAllocator} Pooled allocator
 */
function pool(alloc, slice, size) {
    var SIZE   = size || 8192;
    var MAX    = SIZE >>> 1;
    var slab   = null;
    var offset = SIZE;
    return function pool_alloc(size) {
        if (size < 1 || size > MAX)
            return alloc(size);
        if (offset + size > SIZE) {
            slab = alloc(SIZE);
            offset = 0;
        }
        var buf = slice.call(slab, offset, offset += size);
        if (offset & 7) // align to 32 bit
            offset = (offset | 7) + 1;
        return buf;
    };
}

var longbits = LongBits;



/**
 * Constructs new long bits.
 * @classdesc Helper class for working with the low and high bits of a 64 bit value.
 * @memberof util
 * @constructor
 * @param {number} lo Low 32 bits, unsigned
 * @param {number} hi High 32 bits, unsigned
 */
function LongBits(lo, hi) {

    // note that the casts below are theoretically unnecessary as of today, but older statically
    // generated converter code might still call the ctor with signed 32bits. kept for compat.

    /**
     * Low bits.
     * @type {number}
     */
    this.lo = lo >>> 0;

    /**
     * High bits.
     * @type {number}
     */
    this.hi = hi >>> 0;
}

/**
 * Zero bits.
 * @memberof util.LongBits
 * @type {util.LongBits}
 */
var zero = LongBits.zero = new LongBits(0, 0);

zero.toNumber = function() { return 0; };
zero.zzEncode = zero.zzDecode = function() { return this; };
zero.length = function() { return 1; };

/**
 * Zero hash.
 * @memberof util.LongBits
 * @type {string}
 */
var zeroHash = LongBits.zeroHash = "\0\0\0\0\0\0\0\0";

/**
 * Constructs new long bits from the specified number.
 * @param {number} value Value
 * @returns {util.LongBits} Instance
 */
LongBits.fromNumber = function fromNumber(value) {
    if (value === 0)
        return zero;
    var sign = value < 0;
    if (sign)
        value = -value;
    var lo = value >>> 0,
        hi = (value - lo) / 4294967296 >>> 0;
    if (sign) {
        hi = ~hi >>> 0;
        lo = ~lo >>> 0;
        if (++lo > 4294967295) {
            lo = 0;
            if (++hi > 4294967295)
                hi = 0;
        }
    }
    return new LongBits(lo, hi);
};

/**
 * Constructs new long bits from a number, long or string.
 * @param {Long|number|string} value Value
 * @returns {util.LongBits} Instance
 */
LongBits.from = function from(value) {
    if (typeof value === "number")
        return LongBits.fromNumber(value);
    if (minimal.isString(value)) {
        /* istanbul ignore else */
        if (minimal.Long)
            value = minimal.Long.fromString(value);
        else
            return LongBits.fromNumber(parseInt(value, 10));
    }
    return value.low || value.high ? new LongBits(value.low >>> 0, value.high >>> 0) : zero;
};

/**
 * Converts this long bits to a possibly unsafe JavaScript number.
 * @param {boolean} [unsigned=false] Whether unsigned or not
 * @returns {number} Possibly unsafe number
 */
LongBits.prototype.toNumber = function toNumber(unsigned) {
    if (!unsigned && this.hi >>> 31) {
        var lo = ~this.lo + 1 >>> 0,
            hi = ~this.hi     >>> 0;
        if (!lo)
            hi = hi + 1 >>> 0;
        return -(lo + hi * 4294967296);
    }
    return this.lo + this.hi * 4294967296;
};

/**
 * Converts this long bits to a long.
 * @param {boolean} [unsigned=false] Whether unsigned or not
 * @returns {Long} Long
 */
LongBits.prototype.toLong = function toLong(unsigned) {
    return minimal.Long
        ? new minimal.Long(this.lo | 0, this.hi | 0, Boolean(unsigned))
        /* istanbul ignore next */
        : { low: this.lo | 0, high: this.hi | 0, unsigned: Boolean(unsigned) };
};

var charCodeAt = String.prototype.charCodeAt;

/**
 * Constructs new long bits from the specified 8 characters long hash.
 * @param {string} hash Hash
 * @returns {util.LongBits} Bits
 */
LongBits.fromHash = function fromHash(hash) {
    if (hash === zeroHash)
        return zero;
    return new LongBits(
        ( charCodeAt.call(hash, 0)
        | charCodeAt.call(hash, 1) << 8
        | charCodeAt.call(hash, 2) << 16
        | charCodeAt.call(hash, 3) << 24) >>> 0
    ,
        ( charCodeAt.call(hash, 4)
        | charCodeAt.call(hash, 5) << 8
        | charCodeAt.call(hash, 6) << 16
        | charCodeAt.call(hash, 7) << 24) >>> 0
    );
};

/**
 * Converts this long bits to a 8 characters long hash.
 * @returns {string} Hash
 */
LongBits.prototype.toHash = function toHash() {
    return String.fromCharCode(
        this.lo        & 255,
        this.lo >>> 8  & 255,
        this.lo >>> 16 & 255,
        this.lo >>> 24      ,
        this.hi        & 255,
        this.hi >>> 8  & 255,
        this.hi >>> 16 & 255,
        this.hi >>> 24
    );
};

/**
 * Zig-zag encodes this long bits.
 * @returns {util.LongBits} `this`
 */
LongBits.prototype.zzEncode = function zzEncode() {
    var mask =   this.hi >> 31;
    this.hi  = ((this.hi << 1 | this.lo >>> 31) ^ mask) >>> 0;
    this.lo  = ( this.lo << 1                   ^ mask) >>> 0;
    return this;
};

/**
 * Zig-zag decodes this long bits.
 * @returns {util.LongBits} `this`
 */
LongBits.prototype.zzDecode = function zzDecode() {
    var mask = -(this.lo & 1);
    this.lo  = ((this.lo >>> 1 | this.hi << 31) ^ mask) >>> 0;
    this.hi  = ( this.hi >>> 1                  ^ mask) >>> 0;
    return this;
};

/**
 * Calculates the length of this longbits when encoded as a varint.
 * @returns {number} Length
 */
LongBits.prototype.length = function length() {
    var part0 =  this.lo,
        part1 = (this.lo >>> 28 | this.hi << 4) >>> 0,
        part2 =  this.hi >>> 24;
    return part2 === 0
         ? part1 === 0
           ? part0 < 16384
             ? part0 < 128 ? 1 : 2
             : part0 < 2097152 ? 3 : 4
           : part1 < 16384
             ? part1 < 128 ? 5 : 6
             : part1 < 2097152 ? 7 : 8
         : part2 < 128 ? 9 : 10;
};

var minimal = createCommonjsModule(function (module, exports) {
var util = exports;

// used to return a Promise where callback is omitted
util.asPromise = aspromise;

// converts to / from base64 encoded strings
util.base64 = base64_1;

// base class of rpc.Service
util.EventEmitter = eventemitter;

// float handling accross browsers
util.float = float_1;

// requires modules optionally and hides the call from bundlers
util.inquire = inquire_1;

// converts to / from utf8 encoded strings
util.utf8 = utf8_1;

// provides a node-like buffer pool in the browser
util.pool = pool_1;

// utility to work with the low and high bits of a 64 bit value
util.LongBits = longbits;

/**
 * Whether running within node or not.
 * @memberof util
 * @type {boolean}
 */
util.isNode = Boolean(typeof commonjsGlobal !== "undefined"
                   && commonjsGlobal
                   && commonjsGlobal.process
                   && commonjsGlobal.process.versions
                   && commonjsGlobal.process.versions.node);

/**
 * Global object reference.
 * @memberof util
 * @type {Object}
 */
util.global = util.isNode && commonjsGlobal
           || typeof window !== "undefined" && window
           || typeof self   !== "undefined" && self
           || commonjsGlobal; // eslint-disable-line no-invalid-this

/**
 * An immuable empty array.
 * @memberof util
 * @type {Array.<*>}
 * @const
 */
util.emptyArray = Object.freeze ? Object.freeze([]) : /* istanbul ignore next */ []; // used on prototypes

/**
 * An immutable empty object.
 * @type {Object}
 * @const
 */
util.emptyObject = Object.freeze ? Object.freeze({}) : /* istanbul ignore next */ {}; // used on prototypes

/**
 * Tests if the specified value is an integer.
 * @function
 * @param {*} value Value to test
 * @returns {boolean} `true` if the value is an integer
 */
util.isInteger = Number.isInteger || /* istanbul ignore next */ function isInteger(value) {
    return typeof value === "number" && isFinite(value) && Math.floor(value) === value;
};

/**
 * Tests if the specified value is a string.
 * @param {*} value Value to test
 * @returns {boolean} `true` if the value is a string
 */
util.isString = function isString(value) {
    return typeof value === "string" || value instanceof String;
};

/**
 * Tests if the specified value is a non-null object.
 * @param {*} value Value to test
 * @returns {boolean} `true` if the value is a non-null object
 */
util.isObject = function isObject(value) {
    return value && typeof value === "object";
};

/**
 * Checks if a property on a message is considered to be present.
 * This is an alias of {@link util.isSet}.
 * @function
 * @param {Object} obj Plain object or message instance
 * @param {string} prop Property name
 * @returns {boolean} `true` if considered to be present, otherwise `false`
 */
util.isset =

/**
 * Checks if a property on a message is considered to be present.
 * @param {Object} obj Plain object or message instance
 * @param {string} prop Property name
 * @returns {boolean} `true` if considered to be present, otherwise `false`
 */
util.isSet = function isSet(obj, prop) {
    var value = obj[prop];
    if (value != null && obj.hasOwnProperty(prop)) // eslint-disable-line eqeqeq, no-prototype-builtins
        return typeof value !== "object" || (Array.isArray(value) ? value.length : Object.keys(value).length) > 0;
    return false;
};

/**
 * Any compatible Buffer instance.
 * This is a minimal stand-alone definition of a Buffer instance. The actual type is that exported by node's typings.
 * @interface Buffer
 * @extends Uint8Array
 */

/**
 * Node's Buffer class if available.
 * @type {Constructor<Buffer>}
 */
util.Buffer = (function() {
    try {
        var Buffer = util.inquire("buffer").Buffer;
        // refuse to use non-node buffers if not explicitly assigned (perf reasons):
        return Buffer.prototype.utf8Write ? Buffer : /* istanbul ignore next */ null;
    } catch (e) {
        /* istanbul ignore next */
        return null;
    }
})();

// Internal alias of or polyfull for Buffer.from.
util._Buffer_from = null;

// Internal alias of or polyfill for Buffer.allocUnsafe.
util._Buffer_allocUnsafe = null;

/**
 * Creates a new buffer of whatever type supported by the environment.
 * @param {number|number[]} [sizeOrArray=0] Buffer size or number array
 * @returns {Uint8Array|Buffer} Buffer
 */
util.newBuffer = function newBuffer(sizeOrArray) {
    /* istanbul ignore next */
    return typeof sizeOrArray === "number"
        ? util.Buffer
            ? util._Buffer_allocUnsafe(sizeOrArray)
            : new util.Array(sizeOrArray)
        : util.Buffer
            ? util._Buffer_from(sizeOrArray)
            : typeof Uint8Array === "undefined"
                ? sizeOrArray
                : new Uint8Array(sizeOrArray);
};

/**
 * Array implementation used in the browser. `Uint8Array` if supported, otherwise `Array`.
 * @type {Constructor<Uint8Array>}
 */
util.Array = typeof Uint8Array !== "undefined" ? Uint8Array /* istanbul ignore next */ : Array;

/**
 * Any compatible Long instance.
 * This is a minimal stand-alone definition of a Long instance. The actual type is that exported by long.js.
 * @interface Long
 * @property {number} low Low bits
 * @property {number} high High bits
 * @property {boolean} unsigned Whether unsigned or not
 */

/**
 * Long.js's Long class if available.
 * @type {Constructor<Long>}
 */
util.Long = /* istanbul ignore next */ util.global.dcodeIO && /* istanbul ignore next */ util.global.dcodeIO.Long
         || /* istanbul ignore next */ util.global.Long
         || util.inquire("long");

/**
 * Regular expression used to verify 2 bit (`bool`) map keys.
 * @type {RegExp}
 * @const
 */
util.key2Re = /^true|false|0|1$/;

/**
 * Regular expression used to verify 32 bit (`int32` etc.) map keys.
 * @type {RegExp}
 * @const
 */
util.key32Re = /^-?(?:0|[1-9][0-9]*)$/;

/**
 * Regular expression used to verify 64 bit (`int64` etc.) map keys.
 * @type {RegExp}
 * @const
 */
util.key64Re = /^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;

/**
 * Converts a number or long to an 8 characters long hash string.
 * @param {Long|number} value Value to convert
 * @returns {string} Hash
 */
util.longToHash = function longToHash(value) {
    return value
        ? util.LongBits.from(value).toHash()
        : util.LongBits.zeroHash;
};

/**
 * Converts an 8 characters long hash string to a long or number.
 * @param {string} hash Hash
 * @param {boolean} [unsigned=false] Whether unsigned or not
 * @returns {Long|number} Original value
 */
util.longFromHash = function longFromHash(hash, unsigned) {
    var bits = util.LongBits.fromHash(hash);
    if (util.Long)
        return util.Long.fromBits(bits.lo, bits.hi, unsigned);
    return bits.toNumber(Boolean(unsigned));
};

/**
 * Merges the properties of the source object into the destination object.
 * @memberof util
 * @param {Object.<string,*>} dst Destination object
 * @param {Object.<string,*>} src Source object
 * @param {boolean} [ifNotSet=false] Merges only if the key is not already set
 * @returns {Object.<string,*>} Destination object
 */
function merge(dst, src, ifNotSet) { // used by converters
    for (var keys = Object.keys(src), i = 0; i < keys.length; ++i)
        if (dst[keys[i]] === undefined || !ifNotSet)
            dst[keys[i]] = src[keys[i]];
    return dst;
}

util.merge = merge;

/**
 * Converts the first character of a string to lower case.
 * @param {string} str String to convert
 * @returns {string} Converted string
 */
util.lcFirst = function lcFirst(str) {
    return str.charAt(0).toLowerCase() + str.substring(1);
};

/**
 * Creates a custom error constructor.
 * @memberof util
 * @param {string} name Error name
 * @returns {Constructor<Error>} Custom error constructor
 */
function newError(name) {

    function CustomError(message, properties) {

        if (!(this instanceof CustomError))
            return new CustomError(message, properties);

        // Error.call(this, message);
        // ^ just returns a new error instance because the ctor can be called as a function

        Object.defineProperty(this, "message", { get: function() { return message; } });

        /* istanbul ignore next */
        if (Error.captureStackTrace) // node
            Error.captureStackTrace(this, CustomError);
        else
            Object.defineProperty(this, "stack", { value: new Error().stack || "" });

        if (properties)
            merge(this, properties);
    }

    (CustomError.prototype = Object.create(Error.prototype)).constructor = CustomError;

    Object.defineProperty(CustomError.prototype, "name", { get: function() { return name; } });

    CustomError.prototype.toString = function toString() {
        return this.name + ": " + this.message;
    };

    return CustomError;
}

util.newError = newError;

/**
 * Constructs a new protocol error.
 * @classdesc Error subclass indicating a protocol specifc error.
 * @memberof util
 * @extends Error
 * @template T extends Message<T>
 * @constructor
 * @param {string} message Error message
 * @param {Object.<string,*>} [properties] Additional properties
 * @example
 * try {
 *     MyMessage.decode(someBuffer); // throws if required fields are missing
 * } catch (e) {
 *     if (e instanceof ProtocolError && e.instance)
 *         console.log("decoded so far: " + JSON.stringify(e.instance));
 * }
 */
util.ProtocolError = newError("ProtocolError");

/**
 * So far decoded message instance.
 * @name util.ProtocolError#instance
 * @type {Message<T>}
 */

/**
 * A OneOf getter as returned by {@link util.oneOfGetter}.
 * @typedef OneOfGetter
 * @type {function}
 * @returns {string|undefined} Set field name, if any
 */

/**
 * Builds a getter for a oneof's present field name.
 * @param {string[]} fieldNames Field names
 * @returns {OneOfGetter} Unbound getter
 */
util.oneOfGetter = function getOneOf(fieldNames) {
    var fieldMap = {};
    for (var i = 0; i < fieldNames.length; ++i)
        fieldMap[fieldNames[i]] = 1;

    /**
     * @returns {string|undefined} Set field name, if any
     * @this Object
     * @ignore
     */
    return function() { // eslint-disable-line consistent-return
        for (var keys = Object.keys(this), i = keys.length - 1; i > -1; --i)
            if (fieldMap[keys[i]] === 1 && this[keys[i]] !== undefined && this[keys[i]] !== null)
                return keys[i];
    };
};

/**
 * A OneOf setter as returned by {@link util.oneOfSetter}.
 * @typedef OneOfSetter
 * @type {function}
 * @param {string|undefined} value Field name
 * @returns {undefined}
 */

/**
 * Builds a setter for a oneof's present field name.
 * @param {string[]} fieldNames Field names
 * @returns {OneOfSetter} Unbound setter
 */
util.oneOfSetter = function setOneOf(fieldNames) {

    /**
     * @param {string} name Field name
     * @returns {undefined}
     * @this Object
     * @ignore
     */
    return function(name) {
        for (var i = 0; i < fieldNames.length; ++i)
            if (fieldNames[i] !== name)
                delete this[fieldNames[i]];
    };
};

/**
 * Default conversion options used for {@link Message#toJSON} implementations.
 *
 * These options are close to proto3's JSON mapping with the exception that internal types like Any are handled just like messages. More precisely:
 *
 * - Longs become strings
 * - Enums become string keys
 * - Bytes become base64 encoded strings
 * - (Sub-)Messages become plain objects
 * - Maps become plain objects with all string keys
 * - Repeated fields become arrays
 * - NaN and Infinity for float and double fields become strings
 *
 * @type {IConversionOptions}
 * @see https://developers.google.com/protocol-buffers/docs/proto3?hl=en#json
 */
util.toJSONOptions = {
    longs: String,
    enums: String,
    bytes: String,
    json: true
};

// Sets up buffer utility according to the environment (called in index-minimal)
util._configure = function() {
    var Buffer = util.Buffer;
    /* istanbul ignore if */
    if (!Buffer) {
        util._Buffer_from = util._Buffer_allocUnsafe = null;
        return;
    }
    // because node 4.x buffers are incompatible & immutable
    // see: https://github.com/dcodeIO/protobuf.js/pull/665
    util._Buffer_from = Buffer.from !== Uint8Array.from && Buffer.from ||
        /* istanbul ignore next */
        function Buffer_from(value, encoding) {
            return new Buffer(value, encoding);
        };
    util._Buffer_allocUnsafe = Buffer.allocUnsafe ||
        /* istanbul ignore next */
        function Buffer_allocUnsafe(size) {
            return new Buffer(size);
        };
};
});

var writer = Writer;



var BufferWriter; // cyclic

var LongBits$1  = minimal.LongBits,
    base64    = minimal.base64,
    utf8      = minimal.utf8;

/**
 * Constructs a new writer operation instance.
 * @classdesc Scheduled writer operation.
 * @constructor
 * @param {function(*, Uint8Array, number)} fn Function to call
 * @param {number} len Value byte length
 * @param {*} val Value to write
 * @ignore
 */
function Op(fn, len, val) {

    /**
     * Function to call.
     * @type {function(Uint8Array, number, *)}
     */
    this.fn = fn;

    /**
     * Value byte length.
     * @type {number}
     */
    this.len = len;

    /**
     * Next operation.
     * @type {Writer.Op|undefined}
     */
    this.next = undefined;

    /**
     * Value to write.
     * @type {*}
     */
    this.val = val; // type varies
}

/* istanbul ignore next */
function noop() {} // eslint-disable-line no-empty-function

/**
 * Constructs a new writer state instance.
 * @classdesc Copied writer state.
 * @memberof Writer
 * @constructor
 * @param {Writer} writer Writer to copy state from
 * @ignore
 */
function State(writer) {

    /**
     * Current head.
     * @type {Writer.Op}
     */
    this.head = writer.head;

    /**
     * Current tail.
     * @type {Writer.Op}
     */
    this.tail = writer.tail;

    /**
     * Current buffer length.
     * @type {number}
     */
    this.len = writer.len;

    /**
     * Next state.
     * @type {State|null}
     */
    this.next = writer.states;
}

/**
 * Constructs a new writer instance.
 * @classdesc Wire format writer using `Uint8Array` if available, otherwise `Array`.
 * @constructor
 */
function Writer() {

    /**
     * Current length.
     * @type {number}
     */
    this.len = 0;

    /**
     * Operations head.
     * @type {Object}
     */
    this.head = new Op(noop, 0, 0);

    /**
     * Operations tail
     * @type {Object}
     */
    this.tail = this.head;

    /**
     * Linked forked states.
     * @type {Object|null}
     */
    this.states = null;

    // When a value is written, the writer calculates its byte length and puts it into a linked
    // list of operations to perform when finish() is called. This both allows us to allocate
    // buffers of the exact required size and reduces the amount of work we have to do compared
    // to first calculating over objects and then encoding over objects. In our case, the encoding
    // part is just a linked list walk calling operations with already prepared values.
}

var create = function create() {
    return minimal.Buffer
        ? function create_buffer_setup() {
            return (Writer.create = function create_buffer() {
                return new BufferWriter();
            })();
        }
        /* istanbul ignore next */
        : function create_array() {
            return new Writer();
        };
};

/**
 * Creates a new writer.
 * @function
 * @returns {BufferWriter|Writer} A {@link BufferWriter} when Buffers are supported, otherwise a {@link Writer}
 */
Writer.create = create();

/**
 * Allocates a buffer of the specified size.
 * @param {number} size Buffer size
 * @returns {Uint8Array} Buffer
 */
Writer.alloc = function alloc(size) {
    return new minimal.Array(size);
};

// Use Uint8Array buffer pool in the browser, just like node does with buffers
/* istanbul ignore else */
if (minimal.Array !== Array)
    Writer.alloc = minimal.pool(Writer.alloc, minimal.Array.prototype.subarray);

/**
 * Pushes a new operation to the queue.
 * @param {function(Uint8Array, number, *)} fn Function to call
 * @param {number} len Value byte length
 * @param {number} val Value to write
 * @returns {Writer} `this`
 * @private
 */
Writer.prototype._push = function push(fn, len, val) {
    this.tail = this.tail.next = new Op(fn, len, val);
    this.len += len;
    return this;
};

function writeByte(val, buf, pos) {
    buf[pos] = val & 255;
}

function writeVarint32(val, buf, pos) {
    while (val > 127) {
        buf[pos++] = val & 127 | 128;
        val >>>= 7;
    }
    buf[pos] = val;
}

/**
 * Constructs a new varint writer operation instance.
 * @classdesc Scheduled varint writer operation.
 * @extends Op
 * @constructor
 * @param {number} len Value byte length
 * @param {number} val Value to write
 * @ignore
 */
function VarintOp(len, val) {
    this.len = len;
    this.next = undefined;
    this.val = val;
}

VarintOp.prototype = Object.create(Op.prototype);
VarintOp.prototype.fn = writeVarint32;

/**
 * Writes an unsigned 32 bit value as a varint.
 * @param {number} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.uint32 = function write_uint32(value) {
    // here, the call to this.push has been inlined and a varint specific Op subclass is used.
    // uint32 is by far the most frequently used operation and benefits significantly from this.
    this.len += (this.tail = this.tail.next = new VarintOp(
        (value = value >>> 0)
                < 128       ? 1
        : value < 16384     ? 2
        : value < 2097152   ? 3
        : value < 268435456 ? 4
        :                     5,
    value)).len;
    return this;
};

/**
 * Writes a signed 32 bit value as a varint.
 * @function
 * @param {number} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.int32 = function write_int32(value) {
    return value < 0
        ? this._push(writeVarint64, 10, LongBits$1.fromNumber(value)) // 10 bytes per spec
        : this.uint32(value);
};

/**
 * Writes a 32 bit value as a varint, zig-zag encoded.
 * @param {number} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.sint32 = function write_sint32(value) {
    return this.uint32((value << 1 ^ value >> 31) >>> 0);
};

function writeVarint64(val, buf, pos) {
    while (val.hi) {
        buf[pos++] = val.lo & 127 | 128;
        val.lo = (val.lo >>> 7 | val.hi << 25) >>> 0;
        val.hi >>>= 7;
    }
    while (val.lo > 127) {
        buf[pos++] = val.lo & 127 | 128;
        val.lo = val.lo >>> 7;
    }
    buf[pos++] = val.lo;
}

/**
 * Writes an unsigned 64 bit value as a varint.
 * @param {Long|number|string} value Value to write
 * @returns {Writer} `this`
 * @throws {TypeError} If `value` is a string and no long library is present.
 */
Writer.prototype.uint64 = function write_uint64(value) {
    var bits = LongBits$1.from(value);
    return this._push(writeVarint64, bits.length(), bits);
};

/**
 * Writes a signed 64 bit value as a varint.
 * @function
 * @param {Long|number|string} value Value to write
 * @returns {Writer} `this`
 * @throws {TypeError} If `value` is a string and no long library is present.
 */
Writer.prototype.int64 = Writer.prototype.uint64;

/**
 * Writes a signed 64 bit value as a varint, zig-zag encoded.
 * @param {Long|number|string} value Value to write
 * @returns {Writer} `this`
 * @throws {TypeError} If `value` is a string and no long library is present.
 */
Writer.prototype.sint64 = function write_sint64(value) {
    var bits = LongBits$1.from(value).zzEncode();
    return this._push(writeVarint64, bits.length(), bits);
};

/**
 * Writes a boolish value as a varint.
 * @param {boolean} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.bool = function write_bool(value) {
    return this._push(writeByte, 1, value ? 1 : 0);
};

function writeFixed32(val, buf, pos) {
    buf[pos    ] =  val         & 255;
    buf[pos + 1] =  val >>> 8   & 255;
    buf[pos + 2] =  val >>> 16  & 255;
    buf[pos + 3] =  val >>> 24;
}

/**
 * Writes an unsigned 32 bit value as fixed 32 bits.
 * @param {number} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.fixed32 = function write_fixed32(value) {
    return this._push(writeFixed32, 4, value >>> 0);
};

/**
 * Writes a signed 32 bit value as fixed 32 bits.
 * @function
 * @param {number} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.sfixed32 = Writer.prototype.fixed32;

/**
 * Writes an unsigned 64 bit value as fixed 64 bits.
 * @param {Long|number|string} value Value to write
 * @returns {Writer} `this`
 * @throws {TypeError} If `value` is a string and no long library is present.
 */
Writer.prototype.fixed64 = function write_fixed64(value) {
    var bits = LongBits$1.from(value);
    return this._push(writeFixed32, 4, bits.lo)._push(writeFixed32, 4, bits.hi);
};

/**
 * Writes a signed 64 bit value as fixed 64 bits.
 * @function
 * @param {Long|number|string} value Value to write
 * @returns {Writer} `this`
 * @throws {TypeError} If `value` is a string and no long library is present.
 */
Writer.prototype.sfixed64 = Writer.prototype.fixed64;

/**
 * Writes a float (32 bit).
 * @function
 * @param {number} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.float = function write_float(value) {
    return this._push(minimal.float.writeFloatLE, 4, value);
};

/**
 * Writes a double (64 bit float).
 * @function
 * @param {number} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.double = function write_double(value) {
    return this._push(minimal.float.writeDoubleLE, 8, value);
};

var writeBytes = minimal.Array.prototype.set
    ? function writeBytes_set(val, buf, pos) {
        buf.set(val, pos); // also works for plain array values
    }
    /* istanbul ignore next */
    : function writeBytes_for(val, buf, pos) {
        for (var i = 0; i < val.length; ++i)
            buf[pos + i] = val[i];
    };

/**
 * Writes a sequence of bytes.
 * @param {Uint8Array|string} value Buffer or base64 encoded string to write
 * @returns {Writer} `this`
 */
Writer.prototype.bytes = function write_bytes(value) {
    var len = value.length >>> 0;
    if (!len)
        return this._push(writeByte, 1, 0);
    if (minimal.isString(value)) {
        var buf = Writer.alloc(len = base64.length(value));
        base64.decode(value, buf, 0);
        value = buf;
    }
    return this.uint32(len)._push(writeBytes, len, value);
};

/**
 * Writes a string.
 * @param {string} value Value to write
 * @returns {Writer} `this`
 */
Writer.prototype.string = function write_string(value) {
    var len = utf8.length(value);
    return len
        ? this.uint32(len)._push(utf8.write, len, value)
        : this._push(writeByte, 1, 0);
};

/**
 * Forks this writer's state by pushing it to a stack.
 * Calling {@link Writer#reset|reset} or {@link Writer#ldelim|ldelim} resets the writer to the previous state.
 * @returns {Writer} `this`
 */
Writer.prototype.fork = function fork() {
    this.states = new State(this);
    this.head = this.tail = new Op(noop, 0, 0);
    this.len = 0;
    return this;
};

/**
 * Resets this instance to the last state.
 * @returns {Writer} `this`
 */
Writer.prototype.reset = function reset() {
    if (this.states) {
        this.head   = this.states.head;
        this.tail   = this.states.tail;
        this.len    = this.states.len;
        this.states = this.states.next;
    } else {
        this.head = this.tail = new Op(noop, 0, 0);
        this.len  = 0;
    }
    return this;
};

/**
 * Resets to the last state and appends the fork state's current write length as a varint followed by its operations.
 * @returns {Writer} `this`
 */
Writer.prototype.ldelim = function ldelim() {
    var head = this.head,
        tail = this.tail,
        len  = this.len;
    this.reset().uint32(len);
    if (len) {
        this.tail.next = head.next; // skip noop
        this.tail = tail;
        this.len += len;
    }
    return this;
};

/**
 * Finishes the write operation.
 * @returns {Uint8Array} Finished buffer
 */
Writer.prototype.finish = function finish() {
    var head = this.head.next, // skip noop
        buf  = this.constructor.alloc(this.len),
        pos  = 0;
    while (head) {
        head.fn(head.val, buf, pos);
        pos += head.len;
        head = head.next;
    }
    // this.head = this.tail = null;
    return buf;
};

Writer._configure = function(BufferWriter_) {
    BufferWriter = BufferWriter_;
    Writer.create = create();
    BufferWriter._configure();
};

var writer_buffer = BufferWriter$1;

// extends Writer

(BufferWriter$1.prototype = Object.create(writer.prototype)).constructor = BufferWriter$1;



/**
 * Constructs a new buffer writer instance.
 * @classdesc Wire format writer using node buffers.
 * @extends Writer
 * @constructor
 */
function BufferWriter$1() {
    writer.call(this);
}

BufferWriter$1._configure = function () {
    /**
     * Allocates a buffer of the specified size.
     * @function
     * @param {number} size Buffer size
     * @returns {Buffer} Buffer
     */
    BufferWriter$1.alloc = minimal._Buffer_allocUnsafe;

    BufferWriter$1.writeBytesBuffer = minimal.Buffer && minimal.Buffer.prototype instanceof Uint8Array && minimal.Buffer.prototype.set.name === "set"
        ? function writeBytesBuffer_set(val, buf, pos) {
          buf.set(val, pos); // faster than copy (requires node >= 4 where Buffers extend Uint8Array and set is properly inherited)
          // also works for plain array values
        }
        /* istanbul ignore next */
        : function writeBytesBuffer_copy(val, buf, pos) {
          if (val.copy) // Buffer values
            val.copy(buf, pos, 0, val.length);
          else for (var i = 0; i < val.length;) // plain array values
            buf[pos++] = val[i++];
        };
};


/**
 * @override
 */
BufferWriter$1.prototype.bytes = function write_bytes_buffer(value) {
    if (minimal.isString(value))
        value = minimal._Buffer_from(value, "base64");
    var len = value.length >>> 0;
    this.uint32(len);
    if (len)
        this._push(BufferWriter$1.writeBytesBuffer, len, value);
    return this;
};

function writeStringBuffer(val, buf, pos) {
    if (val.length < 40) // plain js is faster for short strings (probably due to redundant assertions)
        minimal.utf8.write(val, buf, pos);
    else if (buf.utf8Write)
        buf.utf8Write(val, pos);
    else
        buf.write(val, pos);
}

/**
 * @override
 */
BufferWriter$1.prototype.string = function write_string_buffer(value) {
    var len = minimal.Buffer.byteLength(value);
    this.uint32(len);
    if (len)
        this._push(writeStringBuffer, len, value);
    return this;
};


/**
 * Finishes the write operation.
 * @name BufferWriter#finish
 * @function
 * @returns {Buffer} Finished buffer
 */

BufferWriter$1._configure();

var reader = Reader;



var BufferReader; // cyclic

var LongBits$2  = minimal.LongBits,
    utf8$1      = minimal.utf8;

/* istanbul ignore next */
function indexOutOfRange(reader, writeLength) {
    return RangeError("index out of range: " + reader.pos + " + " + (writeLength || 1) + " > " + reader.len);
}

/**
 * Constructs a new reader instance using the specified buffer.
 * @classdesc Wire format reader using `Uint8Array` if available, otherwise `Array`.
 * @constructor
 * @param {Uint8Array} buffer Buffer to read from
 */
function Reader(buffer) {

    /**
     * Read buffer.
     * @type {Uint8Array}
     */
    this.buf = buffer;

    /**
     * Read buffer position.
     * @type {number}
     */
    this.pos = 0;

    /**
     * Read buffer length.
     * @type {number}
     */
    this.len = buffer.length;
}

var create_array = typeof Uint8Array !== "undefined"
    ? function create_typed_array(buffer) {
        if (buffer instanceof Uint8Array || Array.isArray(buffer))
            return new Reader(buffer);
        throw Error("illegal buffer");
    }
    /* istanbul ignore next */
    : function create_array(buffer) {
        if (Array.isArray(buffer))
            return new Reader(buffer);
        throw Error("illegal buffer");
    };

var create$1 = function create() {
    return minimal.Buffer
        ? function create_buffer_setup(buffer) {
            return (Reader.create = function create_buffer(buffer) {
                return minimal.Buffer.isBuffer(buffer)
                    ? new BufferReader(buffer)
                    /* istanbul ignore next */
                    : create_array(buffer);
            })(buffer);
        }
        /* istanbul ignore next */
        : create_array;
};

/**
 * Creates a new reader using the specified buffer.
 * @function
 * @param {Uint8Array|Buffer} buffer Buffer to read from
 * @returns {Reader|BufferReader} A {@link BufferReader} if `buffer` is a Buffer, otherwise a {@link Reader}
 * @throws {Error} If `buffer` is not a valid buffer
 */
Reader.create = create$1();

Reader.prototype._slice = minimal.Array.prototype.subarray || /* istanbul ignore next */ minimal.Array.prototype.slice;

/**
 * Reads a varint as an unsigned 32 bit value.
 * @function
 * @returns {number} Value read
 */
Reader.prototype.uint32 = (function read_uint32_setup() {
    var value = 4294967295; // optimizer type-hint, tends to deopt otherwise (?!)
    return function read_uint32() {
        value = (         this.buf[this.pos] & 127       ) >>> 0; if (this.buf[this.pos++] < 128) return value;
        value = (value | (this.buf[this.pos] & 127) <<  7) >>> 0; if (this.buf[this.pos++] < 128) return value;
        value = (value | (this.buf[this.pos] & 127) << 14) >>> 0; if (this.buf[this.pos++] < 128) return value;
        value = (value | (this.buf[this.pos] & 127) << 21) >>> 0; if (this.buf[this.pos++] < 128) return value;
        value = (value | (this.buf[this.pos] &  15) << 28) >>> 0; if (this.buf[this.pos++] < 128) return value;

        /* istanbul ignore if */
        if ((this.pos += 5) > this.len) {
            this.pos = this.len;
            throw indexOutOfRange(this, 10);
        }
        return value;
    };
})();

/**
 * Reads a varint as a signed 32 bit value.
 * @returns {number} Value read
 */
Reader.prototype.int32 = function read_int32() {
    return this.uint32() | 0;
};

/**
 * Reads a zig-zag encoded varint as a signed 32 bit value.
 * @returns {number} Value read
 */
Reader.prototype.sint32 = function read_sint32() {
    var value = this.uint32();
    return value >>> 1 ^ -(value & 1) | 0;
};

/* eslint-disable no-invalid-this */

function readLongVarint() {
    // tends to deopt with local vars for octet etc.
    var bits = new LongBits$2(0, 0);
    var i = 0;
    if (this.len - this.pos > 4) { // fast route (lo)
        for (; i < 4; ++i) {
            // 1st..4th
            bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
            if (this.buf[this.pos++] < 128)
                return bits;
        }
        // 5th
        bits.lo = (bits.lo | (this.buf[this.pos] & 127) << 28) >>> 0;
        bits.hi = (bits.hi | (this.buf[this.pos] & 127) >>  4) >>> 0;
        if (this.buf[this.pos++] < 128)
            return bits;
        i = 0;
    } else {
        for (; i < 3; ++i) {
            /* istanbul ignore if */
            if (this.pos >= this.len)
                throw indexOutOfRange(this);
            // 1st..3th
            bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
            if (this.buf[this.pos++] < 128)
                return bits;
        }
        // 4th
        bits.lo = (bits.lo | (this.buf[this.pos++] & 127) << i * 7) >>> 0;
        return bits;
    }
    if (this.len - this.pos > 4) { // fast route (hi)
        for (; i < 5; ++i) {
            // 6th..10th
            bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
            if (this.buf[this.pos++] < 128)
                return bits;
        }
    } else {
        for (; i < 5; ++i) {
            /* istanbul ignore if */
            if (this.pos >= this.len)
                throw indexOutOfRange(this);
            // 6th..10th
            bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
            if (this.buf[this.pos++] < 128)
                return bits;
        }
    }
    /* istanbul ignore next */
    throw Error("invalid varint encoding");
}

/* eslint-enable no-invalid-this */

/**
 * Reads a varint as a signed 64 bit value.
 * @name Reader#int64
 * @function
 * @returns {Long} Value read
 */

/**
 * Reads a varint as an unsigned 64 bit value.
 * @name Reader#uint64
 * @function
 * @returns {Long} Value read
 */

/**
 * Reads a zig-zag encoded varint as a signed 64 bit value.
 * @name Reader#sint64
 * @function
 * @returns {Long} Value read
 */

/**
 * Reads a varint as a boolean.
 * @returns {boolean} Value read
 */
Reader.prototype.bool = function read_bool() {
    return this.uint32() !== 0;
};

function readFixed32_end(buf, end) { // note that this uses `end`, not `pos`
    return (buf[end - 4]
          | buf[end - 3] << 8
          | buf[end - 2] << 16
          | buf[end - 1] << 24) >>> 0;
}

/**
 * Reads fixed 32 bits as an unsigned 32 bit integer.
 * @returns {number} Value read
 */
Reader.prototype.fixed32 = function read_fixed32() {

    /* istanbul ignore if */
    if (this.pos + 4 > this.len)
        throw indexOutOfRange(this, 4);

    return readFixed32_end(this.buf, this.pos += 4);
};

/**
 * Reads fixed 32 bits as a signed 32 bit integer.
 * @returns {number} Value read
 */
Reader.prototype.sfixed32 = function read_sfixed32() {

    /* istanbul ignore if */
    if (this.pos + 4 > this.len)
        throw indexOutOfRange(this, 4);

    return readFixed32_end(this.buf, this.pos += 4) | 0;
};

/* eslint-disable no-invalid-this */

function readFixed64(/* this: Reader */) {

    /* istanbul ignore if */
    if (this.pos + 8 > this.len)
        throw indexOutOfRange(this, 8);

    return new LongBits$2(readFixed32_end(this.buf, this.pos += 4), readFixed32_end(this.buf, this.pos += 4));
}

/* eslint-enable no-invalid-this */

/**
 * Reads fixed 64 bits.
 * @name Reader#fixed64
 * @function
 * @returns {Long} Value read
 */

/**
 * Reads zig-zag encoded fixed 64 bits.
 * @name Reader#sfixed64
 * @function
 * @returns {Long} Value read
 */

/**
 * Reads a float (32 bit) as a number.
 * @function
 * @returns {number} Value read
 */
Reader.prototype.float = function read_float() {

    /* istanbul ignore if */
    if (this.pos + 4 > this.len)
        throw indexOutOfRange(this, 4);

    var value = minimal.float.readFloatLE(this.buf, this.pos);
    this.pos += 4;
    return value;
};

/**
 * Reads a double (64 bit float) as a number.
 * @function
 * @returns {number} Value read
 */
Reader.prototype.double = function read_double() {

    /* istanbul ignore if */
    if (this.pos + 8 > this.len)
        throw indexOutOfRange(this, 4);

    var value = minimal.float.readDoubleLE(this.buf, this.pos);
    this.pos += 8;
    return value;
};

/**
 * Reads a sequence of bytes preceeded by its length as a varint.
 * @returns {Uint8Array} Value read
 */
Reader.prototype.bytes = function read_bytes() {
    var length = this.uint32(),
        start  = this.pos,
        end    = this.pos + length;

    /* istanbul ignore if */
    if (end > this.len)
        throw indexOutOfRange(this, length);

    this.pos += length;
    if (Array.isArray(this.buf)) // plain array
        return this.buf.slice(start, end);
    return start === end // fix for IE 10/Win8 and others' subarray returning array of size 1
        ? new this.buf.constructor(0)
        : this._slice.call(this.buf, start, end);
};

/**
 * Reads a string preceeded by its byte length as a varint.
 * @returns {string} Value read
 */
Reader.prototype.string = function read_string() {
    var bytes = this.bytes();
    return utf8$1.read(bytes, 0, bytes.length);
};

/**
 * Skips the specified number of bytes if specified, otherwise skips a varint.
 * @param {number} [length] Length if known, otherwise a varint is assumed
 * @returns {Reader} `this`
 */
Reader.prototype.skip = function skip(length) {
    if (typeof length === "number") {
        /* istanbul ignore if */
        if (this.pos + length > this.len)
            throw indexOutOfRange(this, length);
        this.pos += length;
    } else {
        do {
            /* istanbul ignore if */
            if (this.pos >= this.len)
                throw indexOutOfRange(this);
        } while (this.buf[this.pos++] & 128);
    }
    return this;
};

/**
 * Skips the next element of the specified wire type.
 * @param {number} wireType Wire type received
 * @returns {Reader} `this`
 */
Reader.prototype.skipType = function(wireType) {
    switch (wireType) {
        case 0:
            this.skip();
            break;
        case 1:
            this.skip(8);
            break;
        case 2:
            this.skip(this.uint32());
            break;
        case 3:
            while ((wireType = this.uint32() & 7) !== 4) {
                this.skipType(wireType);
            }
            break;
        case 5:
            this.skip(4);
            break;

        /* istanbul ignore next */
        default:
            throw Error("invalid wire type " + wireType + " at offset " + this.pos);
    }
    return this;
};

Reader._configure = function(BufferReader_) {
    BufferReader = BufferReader_;
    Reader.create = create$1();
    BufferReader._configure();

    var fn = minimal.Long ? "toLong" : /* istanbul ignore next */ "toNumber";
    minimal.merge(Reader.prototype, {

        int64: function read_int64() {
            return readLongVarint.call(this)[fn](false);
        },

        uint64: function read_uint64() {
            return readLongVarint.call(this)[fn](true);
        },

        sint64: function read_sint64() {
            return readLongVarint.call(this).zzDecode()[fn](false);
        },

        fixed64: function read_fixed64() {
            return readFixed64.call(this)[fn](true);
        },

        sfixed64: function read_sfixed64() {
            return readFixed64.call(this)[fn](false);
        }

    });
};

var reader_buffer = BufferReader$1;

// extends Reader

(BufferReader$1.prototype = Object.create(reader.prototype)).constructor = BufferReader$1;



/**
 * Constructs a new buffer reader instance.
 * @classdesc Wire format reader using node buffers.
 * @extends Reader
 * @constructor
 * @param {Buffer} buffer Buffer to read from
 */
function BufferReader$1(buffer) {
    reader.call(this, buffer);

    /**
     * Read buffer.
     * @name BufferReader#buf
     * @type {Buffer}
     */
}

BufferReader$1._configure = function () {
    /* istanbul ignore else */
    if (minimal.Buffer)
        BufferReader$1.prototype._slice = minimal.Buffer.prototype.slice;
};


/**
 * @override
 */
BufferReader$1.prototype.string = function read_string_buffer() {
    var len = this.uint32(); // modifies pos
    return this.buf.utf8Slice
        ? this.buf.utf8Slice(this.pos, this.pos = Math.min(this.pos + len, this.len))
        : this.buf.toString("utf-8", this.pos, this.pos = Math.min(this.pos + len, this.len));
};

/**
 * Reads a sequence of bytes preceeded by its length as a varint.
 * @name BufferReader#bytes
 * @function
 * @returns {Buffer} Value read
 */

BufferReader$1._configure();

var service = Service;



// Extends EventEmitter
(Service.prototype = Object.create(minimal.EventEmitter.prototype)).constructor = Service;

/**
 * A service method callback as used by {@link rpc.ServiceMethod|ServiceMethod}.
 *
 * Differs from {@link RPCImplCallback} in that it is an actual callback of a service method which may not return `response = null`.
 * @typedef rpc.ServiceMethodCallback
 * @template TRes extends Message<TRes>
 * @type {function}
 * @param {Error|null} error Error, if any
 * @param {TRes} [response] Response message
 * @returns {undefined}
 */

/**
 * A service method part of a {@link rpc.Service} as created by {@link Service.create}.
 * @typedef rpc.ServiceMethod
 * @template TReq extends Message<TReq>
 * @template TRes extends Message<TRes>
 * @type {function}
 * @param {TReq|Properties<TReq>} request Request message or plain object
 * @param {rpc.ServiceMethodCallback<TRes>} [callback] Node-style callback called with the error, if any, and the response message
 * @returns {Promise<Message<TRes>>} Promise if `callback` has been omitted, otherwise `undefined`
 */

/**
 * Constructs a new RPC service instance.
 * @classdesc An RPC service as returned by {@link Service#create}.
 * @exports rpc.Service
 * @extends util.EventEmitter
 * @constructor
 * @param {RPCImpl} rpcImpl RPC implementation
 * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
 * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
 */
function Service(rpcImpl, requestDelimited, responseDelimited) {

    if (typeof rpcImpl !== "function")
        throw TypeError("rpcImpl must be a function");

    minimal.EventEmitter.call(this);

    /**
     * RPC implementation. Becomes `null` once the service is ended.
     * @type {RPCImpl|null}
     */
    this.rpcImpl = rpcImpl;

    /**
     * Whether requests are length-delimited.
     * @type {boolean}
     */
    this.requestDelimited = Boolean(requestDelimited);

    /**
     * Whether responses are length-delimited.
     * @type {boolean}
     */
    this.responseDelimited = Boolean(responseDelimited);
}

/**
 * Calls a service method through {@link rpc.Service#rpcImpl|rpcImpl}.
 * @param {Method|rpc.ServiceMethod<TReq,TRes>} method Reflected or static method
 * @param {Constructor<TReq>} requestCtor Request constructor
 * @param {Constructor<TRes>} responseCtor Response constructor
 * @param {TReq|Properties<TReq>} request Request message or plain object
 * @param {rpc.ServiceMethodCallback<TRes>} callback Service callback
 * @returns {undefined}
 * @template TReq extends Message<TReq>
 * @template TRes extends Message<TRes>
 */
Service.prototype.rpcCall = function rpcCall(method, requestCtor, responseCtor, request, callback) {

    if (!request)
        throw TypeError("request must be specified");

    var self = this;
    if (!callback)
        return minimal.asPromise(rpcCall, self, method, requestCtor, responseCtor, request);

    if (!self.rpcImpl) {
        setTimeout(function() { callback(Error("already ended")); }, 0);
        return undefined;
    }

    try {
        return self.rpcImpl(
            method,
            requestCtor[self.requestDelimited ? "encodeDelimited" : "encode"](request).finish(),
            function rpcCallback(err, response) {

                if (err) {
                    self.emit("error", err, method);
                    return callback(err);
                }

                if (response === null) {
                    self.end(/* endedByRPC */ true);
                    return undefined;
                }

                if (!(response instanceof responseCtor)) {
                    try {
                        response = responseCtor[self.responseDelimited ? "decodeDelimited" : "decode"](response);
                    } catch (err) {
                        self.emit("error", err, method);
                        return callback(err);
                    }
                }

                self.emit("data", response, method);
                return callback(null, response);
            }
        );
    } catch (err) {
        self.emit("error", err, method);
        setTimeout(function() { callback(err); }, 0);
        return undefined;
    }
};

/**
 * Ends this service and emits the `end` event.
 * @param {boolean} [endedByRPC=false] Whether the service has been ended by the RPC implementation.
 * @returns {rpc.Service} `this`
 */
Service.prototype.end = function end(endedByRPC) {
    if (this.rpcImpl) {
        if (!endedByRPC) // signal end to rpcImpl
            this.rpcImpl(null, null, null);
        this.rpcImpl = null;
        this.emit("end").off();
    }
    return this;
};

var rpc_1 = createCommonjsModule(function (module, exports) {

/**
 * Streaming RPC helpers.
 * @namespace
 */
var rpc = exports;

/**
 * RPC implementation passed to {@link Service#create} performing a service request on network level, i.e. by utilizing http requests or websockets.
 * @typedef RPCImpl
 * @type {function}
 * @param {Method|rpc.ServiceMethod<Message<{}>,Message<{}>>} method Reflected or static method being called
 * @param {Uint8Array} requestData Request data
 * @param {RPCImplCallback} callback Callback function
 * @returns {undefined}
 * @example
 * function rpcImpl(method, requestData, callback) {
 *     if (protobuf.util.lcFirst(method.name) !== "myMethod") // compatible with static code
 *         throw Error("no such method");
 *     asynchronouslyObtainAResponse(requestData, function(err, responseData) {
 *         callback(err, responseData);
 *     });
 * }
 */

/**
 * Node-style callback as used by {@link RPCImpl}.
 * @typedef RPCImplCallback
 * @type {function}
 * @param {Error|null} error Error, if any, otherwise `null`
 * @param {Uint8Array|null} [response] Response data or `null` to signal end of stream, if there hasn't been an error
 * @returns {undefined}
 */

rpc.Service = service;
});

var roots = {};

var indexMinimal = createCommonjsModule(function (module, exports) {
var protobuf = exports;

/**
 * Build type, one of `"full"`, `"light"` or `"minimal"`.
 * @name build
 * @type {string}
 * @const
 */
protobuf.build = "minimal";

// Serialization
protobuf.Writer       = writer;
protobuf.BufferWriter = writer_buffer;
protobuf.Reader       = reader;
protobuf.BufferReader = reader_buffer;

// Utility
protobuf.util         = minimal;
protobuf.rpc          = rpc_1;
protobuf.roots        = roots;
protobuf.configure    = configure;

/* istanbul ignore next */
/**
 * Reconfigures the library according to the environment.
 * @returns {undefined}
 */
function configure() {
    protobuf.util._configure();
    protobuf.Writer._configure(protobuf.BufferWriter);
    protobuf.Reader._configure(protobuf.BufferReader);
}

// Set up buffer utility according to the environment
configure();
});

var minimal$1 = indexMinimal;

var string_utils = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.sqliteString = exports.binaryDecode = exports.binaryEncode = exports.utf8Decode = exports.utf8Encode = exports.hexEncode = exports.base64Decode = exports.base64Encode = void 0;



// TextDecoder/Decoder requires the full DOM and isn't available in all types
// of tests. Use fallback implementation from protbufjs.
let Utf8Decoder;
let Utf8Encoder;
try {
    Utf8Decoder = new TextDecoder('utf-8');
    Utf8Encoder = new TextEncoder();
}
catch (_) {
    if (typeof process === 'undefined') {
        // Silence the warning when we know we are running under NodeJS.
        console.warn('Using fallback UTF8 Encoder/Decoder, This should happen only in ' +
            'tests and NodeJS-based environments, not in browsers.');
    }
    Utf8Decoder = { decode: (buf) => (0, utf8_1.read)(buf, 0, buf.length) };
    Utf8Encoder = {
        encode: (str) => {
            const arr = new Uint8Array((0, utf8_1.length)(str));
            const written = (0, utf8_1.write)(str, arr, 0);
            (0, logging.assertTrue)(written === arr.length);
            return arr;
        },
    };
}
function base64Encode(buffer) {
    return (0, base64_1.encode)(buffer, 0, buffer.length);
}
exports.base64Encode = base64Encode;
function base64Decode(str) {
    // if the string is in base64url format, convert to base64
    const b64 = str.replace(/-/g, '+').replace(/_/g, '/');
    const arr = new Uint8Array((0, base64_1.length)(b64));
    const written = (0, base64_1.decode)(b64, arr, 0);
    (0, logging.assertTrue)(written === arr.length);
    return arr;
}
exports.base64Decode = base64Decode;
// encode binary array to hex string
function hexEncode(bytes) {
    return bytes.reduce((prev, cur) => prev + ('0' + cur.toString(16)).slice(-2), '');
}
exports.hexEncode = hexEncode;
function utf8Encode(str) {
    return Utf8Encoder.encode(str);
}
exports.utf8Encode = utf8Encode;
// Note: not all byte sequences can be converted to<>from UTF8. This can be
// used only with valid unicode strings, not arbitrary byte buffers.
function utf8Decode(buffer) {
    return Utf8Decoder.decode(buffer);
}
exports.utf8Decode = utf8Decode;
// The binaryEncode/Decode functions below allow to encode an arbitrary binary
// buffer into a string that can be JSON-encoded. binaryEncode() applies
// UTF-16 encoding to each byte individually.
// Unlike utf8Encode/Decode, any arbitrary byte sequence can be converted into a
// valid string, and viceversa.
// This should be only used when a byte array needs to be transmitted over an
// interface that supports only JSON serialization (e.g., postmessage to a
// chrome extension).
function binaryEncode(buf) {
    let str = '';
    for (let i = 0; i < buf.length; i++) {
        str += String.fromCharCode(buf[i]);
    }
    return str;
}
exports.binaryEncode = binaryEncode;
function binaryDecode(str) {
    const buf = new Uint8Array(str.length);
    const strLen = str.length;
    for (let i = 0; i < strLen; i++) {
        buf[i] = str.charCodeAt(i);
    }
    return buf;
}
exports.binaryDecode = binaryDecode;
// A function used to interpolate strings into SQL query. The only replacement
// is done is that single quote replaced with two single quotes, according to
// SQLite documentation:
// https://www.sqlite.org/lang_expr.html#literal_values_constants_
//
// The purpose of this function is to use in simple comparisons, to escape
// strings used in GLOB clauses see escapeQuery function.
function sqliteString(str) {
    return `'${str.replace('\'', '\'\'')}'`;
}
exports.sqliteString = sqliteString;

});

var query_result = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.createQueryResult = exports.QueryError = exports.STR_NULL = exports.NUM_NULL = exports.STR = exports.NUM = void 0;
// This file deals with deserialization and iteration of the proto-encoded
// byte buffer that is returned by TraceProcessor when invoking the
// TPM_QUERY_STREAMING method. The returned |query_result| buffer is optimized
// for being moved cheaply across workers and decoded on-the-flight as we step
// through the iterator.
// See comments around QueryResult in trace_processor.proto for more details.
// The classes in this file are organized as follows:
//
// QueryResultImpl:
// The object returned by the Engine.query(sql) method.
// This object is a holder of row data. Batches of raw get appended
// incrementally as they are received by the remote TraceProcessor instance.
// QueryResultImpl also deals with asynchronicity of queries and allows callers
// to obtain a promise that waits for more (or all) rows.
// At any point in time the following objects hold a reference to QueryResult:
// - The Engine: for appending row batches.
// - UI code, typically controllers, who make queries.
//
// ResultBatch:
// Hold the data, returned by the remote TraceProcessor instance, for a number
// of rows (TP typically chunks the results in batches of 128KB).
// A QueryResultImpl holds exclusively ResultBatches for a given query.
// ResultBatch is not exposed externally, it's just an internal representation
// that helps with proto decoding. ResultBatch is immutable after it gets
// appended and decoded. The iteration state is held by the RowIteratorImpl.
//
// RowIteratorImpl:
// Decouples the data owned by QueryResultImpl (and its ResultBatch(es)) from
// the iteration state. The iterator effectively is the union of a ResultBatch
// and the row number in it. Rows within the batch are decoded as the user calls
// next(). When getting at the end of the batch, it takes care of switching to
// the next batch (if any) within the QueryResultImpl.
// This object is part of the API exposed to tracks / controllers.




exports.NUM = 0;
exports.STR = 'str';
exports.NUM_NULL = 1;
exports.STR_NULL = 'str_null';
class QueryError extends Error {
    constructor(message, info) {
        super(message);
        this.query = info.query;
    }
    toString() {
        return `Query: ${this.query}\n` + super.toString();
    }
}
exports.QueryError = QueryError;
function columnTypeToString(t) {
    switch (t) {
        case exports.NUM:
            return 'NUM';
        case exports.NUM_NULL:
            return 'NUM_NULL';
        case exports.STR:
            return 'STR';
        case exports.STR_NULL:
            return 'STR_NULL';
        default:
            return `INVALID(${t})`;
    }
}
// Disable Long.js support in protobuf. This seems to be enabled only in tests
// but not in production code. In any case, for now we want casting to number
// accepting the 2**53 limitation. This is consistent with passing
// --force-number in the protobuf.js codegen invocation in //ui/BUILD.gn .
// See also https://github.com/protobufjs/protobuf.js/issues/1253 .
minimal$1.util.Long = undefined;
minimal$1.configure();
// This has to match CellType in trace_processor.proto.
var CellType;
(function (CellType) {
    CellType[CellType["CELL_NULL"] = 1] = "CELL_NULL";
    CellType[CellType["CELL_VARINT"] = 2] = "CELL_VARINT";
    CellType[CellType["CELL_FLOAT64"] = 3] = "CELL_FLOAT64";
    CellType[CellType["CELL_STRING"] = 4] = "CELL_STRING";
    CellType[CellType["CELL_BLOB"] = 5] = "CELL_BLOB";
})(CellType || (CellType = {}));
const CELL_TYPE_NAMES = ['UNKNOWN', 'NULL', 'VARINT', 'FLOAT64', 'STRING', 'BLOB'];
const TAG_LEN_DELIM = 2;
// The actual implementation, which bridges together the reader side and the
// writer side (the one exposed to the Engine). This is the same object so that
// when the engine pumps new row batches we can resolve pending promises that
// readers (e.g. track code) are waiting for.
class QueryResultImpl {
    constructor(errorInfo) {
        this.columnNames = [];
        this._numRows = 0;
        this._isComplete = false;
        this._statementCount = 0;
        this._statementWithOutputCount = 0;
        // --- QueryResult implementation.
        // TODO(primiano): for the moment new batches are appended but old batches
        // are never removed. This won't work with abnormally large result sets, as
        // it will stash all rows in memory. We could switch to a model where the
        // iterator is destructive and deletes batch objects once iterating past the
        // end of each batch. If we do that, than we need to assign monotonic IDs to
        // batches. Also if we do that, we should prevent creating more than one
        // iterator for a QueryResult.
        this.batches = [];
        this._errorInfo = errorInfo;
    }
    isComplete() {
        return this._isComplete;
    }
    numRows() {
        return this._numRows;
    }
    error() {
        return this._error;
    }
    columns() {
        return this.columnNames;
    }
    statementCount() {
        return this._statementCount;
    }
    statementWithOutputCount() {
        return this._statementWithOutputCount;
    }
    iter(spec) {
        const impl = new RowIteratorImplWithRowData(spec, this);
        return impl;
    }
    firstRow(spec) {
        const impl = new RowIteratorImplWithRowData(spec, this);
        (0, logging.assertTrue)(impl.valid());
        return impl;
    }
    // Can be called only once.
    waitAllRows() {
        (0, logging.assertTrue)(this.allRowsPromise === undefined);
        this.allRowsPromise = (0, deferred.defer)();
        if (this._isComplete) {
            this.resolveOrReject(this.allRowsPromise, this);
        }
        return this.allRowsPromise;
    }
    // --- WritableQueryResult implementation.
    // Called by the engine when a new QueryResult is available. Note that a
    // single Query() call can yield >1 QueryResult due to result batching
    // if more than ~64K of data are returned, e.g. when returning O(M) rows.
    // |resBytes| is a proto-encoded trace_processor.QueryResult message.
    // It is fine to retain the resBytes without slicing a copy, because
    // ProtoRingBuffer does the slice() for us (or passes through the buffer
    // coming from postMessage() (Wasm case) of fetch() (HTTP+RPC case).
    appendResultBatch(resBytes) {
        const reader = minimal$1.Reader.create(resBytes);
        (0, logging.assertTrue)(reader.pos === 0);
        const columnNamesEmptyAtStartOfBatch = this.columnNames.length === 0;
        const columnNamesSet = new Set();
        while (reader.pos < reader.len) {
            const tag = reader.uint32();
            switch (tag >>> 3) {
                case 1: // column_names
                    // Only the first batch should contain the column names. If this fires
                    // something is going wrong in the handling of the batch stream.
                    (0, logging.assertTrue)(columnNamesEmptyAtStartOfBatch);
                    const origColName = reader.string();
                    let colName = origColName;
                    // In some rare cases two columns can have the same name (b/194891824)
                    // e.g. `select 1 as x, 2 as x`. These queries don't happen in the
                    // UI code, but they can happen when the user types a query (e.g.
                    // with a join). The most practical thing we can do here is renaming
                    // the columns with a suffix. Keeping the same name will break when
                    // iterating, because column names become iterator object keys.
                    for (let i = 1; columnNamesSet.has(colName); ++i) {
                        colName = `${origColName}_${i}`;
                        (0, logging.assertTrue)(i < 100); // Give up at some point;
                    }
                    columnNamesSet.add(colName);
                    this.columnNames.push(colName);
                    break;
                case 2: // error
                    // The query has errored only if the |error| field is non-empty.
                    // In protos, we don't distinguish between non-present and empty.
                    // Make sure we don't propagate ambiguous empty strings to JS.
                    const err = reader.string();
                    this._error = (err !== undefined && err.length) ? err : undefined;
                    break;
                case 3: // batch
                    const batchLen = reader.uint32();
                    const batchRaw = resBytes.subarray(reader.pos, reader.pos + batchLen);
                    reader.pos += batchLen;
                    // The ResultBatch ctor parses the CellsBatch submessage.
                    const parsedBatch = new ResultBatch(batchRaw);
                    this.batches.push(parsedBatch);
                    this._isComplete = parsedBatch.isLastBatch;
                    // In theory one could construct a valid proto serializing the column
                    // names after the cell batches. In practice the QueryResultSerializer
                    // doesn't do that so it's not worth complicating the code.
                    const numColumns = this.columnNames.length;
                    if (numColumns !== 0) {
                        (0, logging.assertTrue)(parsedBatch.numCells % numColumns === 0);
                        this._numRows += parsedBatch.numCells / numColumns;
                    }
                    else {
                        // numColumns == 0 is  plausible for queries like CREATE TABLE ... .
                        (0, logging.assertTrue)(parsedBatch.numCells === 0);
                    }
                    break;
                case 4:
                    this._statementCount = reader.uint32();
                    break;
                case 5:
                    this._statementWithOutputCount = reader.uint32();
                    break;
                default:
                    console.warn(`Unexpected QueryResult field ${tag >>> 3}`);
                    reader.skipType(tag & 7);
                    break;
            } // switch (tag)
        } // while (pos < end)
        if (this._isComplete && this.allRowsPromise !== undefined) {
            this.resolveOrReject(this.allRowsPromise, this);
        }
    }
    ensureAllRowsPromise() {
        if (this.allRowsPromise === undefined) {
            this.waitAllRows(); // Will populate |this.allRowsPromise|.
        }
        return (0, logging.assertExists)(this.allRowsPromise);
    }
    resolveOrReject(promise, arg) {
        if (this._error === undefined) {
            promise.resolve(arg);
        }
        else {
            promise.reject(new QueryError(this._error, this._errorInfo));
        }
    }
}
// This class holds onto a received result batch (a Uint8Array) and does some
// partial parsing to tokenize the various cell groups. This parsing mainly
// consists of identifying and caching the offsets of each cell group and
// initializing the varint decoders. This half parsing is done to keep the
// iterator's next() fast, without decoding everything into memory.
// This is an internal implementation detail and is not exposed outside. The
// RowIteratorImpl uses this class to iterate through batches (this class takes
// care of iterating within a batch, RowIteratorImpl takes care of switching
// batches when needed).
// Note: at any point in time there can be more than one ResultIterator
// referencing the same batch. The batch must be immutable.
class ResultBatch {
    // batchBytes is a trace_processor.QueryResult.CellsBatch proto.
    constructor(batchBytes) {
        this.isLastBatch = false;
        this.cellTypesOff = 0;
        this.cellTypesLen = 0;
        this.varintOff = 0;
        this.varintLen = 0;
        this.float64Cells = new Float64Array();
        this.blobCells = [];
        this.stringCells = [];
        this.batchBytes = batchBytes;
        const reader = minimal$1.Reader.create(batchBytes);
        (0, logging.assertTrue)(reader.pos === 0);
        const end = reader.len;
        // Here we deconstruct the proto by hand. The CellsBatch is carefully
        // designed to allow a very fast parsing from the TS side. We pack all cells
        // of the same types together, so we can do only one call (per batch) to
        // TextDecoder.decode(), we can overlay a memory-aligned typedarray for
        // float values and can quickly tell and type-check the cell types.
        // One row = N cells (we know the number upfront from the outer message).
        // Each bach contains always an integer multiple of N cells (i.e. rows are
        // never fragmented across different batches).
        while (reader.pos < end) {
            const tag = reader.uint32();
            switch (tag >>> 3) {
                case 1: // cell types, a packed array containing one CellType per cell.
                    (0, logging.assertTrue)((tag & 7) === TAG_LEN_DELIM); // Must be packed varint.
                    this.cellTypesLen = reader.uint32();
                    this.cellTypesOff = reader.pos;
                    reader.pos += this.cellTypesLen;
                    break;
                case 2: // varint_cells, a packed varint buffer.
                    (0, logging.assertTrue)((tag & 7) === TAG_LEN_DELIM); // Must be packed varint.
                    const packLen = reader.uint32();
                    this.varintOff = reader.pos;
                    this.varintLen = packLen;
                    (0, logging.assertTrue)(reader.buf === batchBytes);
                    (0, logging.assertTrue)(this.varintOff + this.varintLen <=
                        batchBytes.byteOffset + batchBytes.byteLength);
                    reader.pos += packLen;
                    break;
                case 3: // float64_cells, a 64-bit aligned packed fixed64 buffer.
                    (0, logging.assertTrue)((tag & 7) === TAG_LEN_DELIM); // Must be packed varint.
                    const f64Len = reader.uint32();
                    (0, logging.assertTrue)(f64Len % 8 === 0);
                    // Float64Array's constructor is evil: the offset is in bytes but the
                    // length is in 8-byte words.
                    const f64Words = f64Len / 8;
                    const f64Off = batchBytes.byteOffset + reader.pos;
                    if (f64Off % 8 === 0) {
                        this.float64Cells =
                            new Float64Array(batchBytes.buffer, f64Off, f64Words);
                    }
                    else {
                        // When using the production code in trace_processor's rpc.cc, the
                        // float64 should be 8-bytes aligned. The slow-path case is only for
                        // tests.
                        const slice = batchBytes.buffer.slice(f64Off, f64Off + f64Len);
                        this.float64Cells = new Float64Array(slice);
                    }
                    reader.pos += f64Len;
                    break;
                case 4: // blob_cells: one entry per blob.
                    (0, logging.assertTrue)((tag & 7) === TAG_LEN_DELIM);
                    // protobufjs's bytes() under the hoods calls slice() and creates
                    // a copy. Fine here as blobs are rare and not a fastpath.
                    this.blobCells.push(new Uint8Array(reader.bytes()));
                    break;
                case 5: // string_cells: all the string cells concatenated with \0s.
                    (0, logging.assertTrue)((tag & 7) === TAG_LEN_DELIM);
                    const strLen = reader.uint32();
                    (0, logging.assertTrue)(reader.pos + strLen <= end);
                    const subArr = batchBytes.subarray(reader.pos, reader.pos + strLen);
                    (0, logging.assertTrue)(subArr.length === strLen);
                    // The reason why we do this split rather than creating one string
                    // per entry is that utf8 decoding has some non-negligible cost. See
                    // go/postmessage-benchmark .
                    this.stringCells = (0, string_utils.utf8Decode)(subArr).split('\0');
                    reader.pos += strLen;
                    break;
                case 6: // is_last_batch (boolean).
                    this.isLastBatch = !!reader.bool();
                    break;
                case 7: // padding for realignment, skip silently.
                    reader.skipType(tag & 7);
                    break;
                default:
                    console.warn(`Unexpected QueryResult.CellsBatch field ${tag >>> 3}`);
                    reader.skipType(tag & 7);
                    break;
            } // switch(tag)
        } // while (pos < end)
    }
    get numCells() {
        return this.cellTypesLen;
    }
}
class RowIteratorImpl {
    constructor(querySpec, rowData, res) {
        // All the member variables in the group below point to the identically-named
        // members in result.batch[batchIdx]. This is to avoid indirection layers in
        // the next() hotpath, so we can do this.float64Cells vs
        // this.resultObj.batch[this.batchIdx].float64Cells.
        // These are re-set every time tryMoveToNextBatch() is called (and succeeds).
        this.batchIdx = -1; // The batch index within |result.batches[]|.
        this.batchBytes = new Uint8Array();
        this.columnNames = [];
        this.numColumns = 0;
        this.cellTypesEnd = -1; // -1 so the 1st next() hits tryMoveToNextBatch().
        this.float64Cells = new Float64Array();
        this.varIntReader = minimal$1.Reader.create(this.batchBytes);
        this.blobCells = [];
        this.stringCells = [];
        // These members instead are incremented as we read cells from next(). They
        // are the mutable state of the iterator.
        this.nextCellTypeOff = 0;
        this.nextFloat64Cell = 0;
        this.nextStringCell = 0;
        this.nextBlobCell = 0;
        this.isValid = false;
        Object.assign(this, querySpec);
        this.rowData = rowData;
        this.rowSpec = Object.assign({}, querySpec); // ... -> Copy all the key/value pairs.
        this.resultObj = res;
        this.next();
    }
    valid() {
        return this.isValid;
    }
    get(columnName) {
        const res = this.rowData[columnName];
        if (res === undefined) {
            throw new Error(`Column '${columnName}' doesn't exist. ` +
                `Actual columns: [${this.columnNames.join(',')}]`);
        }
        return res;
    }
    // Moves the cursor next by one row and updates |isValid|.
    // When this fails to move, two cases are possible:
    // 1. We reached the end of the result set (this is the case if
    //    QueryResult.isComplete() == true when this fails).
    // 2. We reached the end of the current batch, but more rows might come later
    //    (if QueryResult.isComplete() == false).
    next() {
        // At some point we might reach the end of the current batch, but the next
        // batch might be available already. In this case we want next() to
        // transparently move on to the next batch.
        while (this.nextCellTypeOff + this.numColumns > this.cellTypesEnd) {
            // If TraceProcessor is behaving well, we should never end up in a
            // situation where we have leftover cells. TP is expected to serialize
            // whole rows in each QueryResult batch and NOT truncate them midway.
            // If this assert fires the TP RPC logic has a bug.
            (0, logging.assertTrue)(this.nextCellTypeOff === this.cellTypesEnd ||
                this.cellTypesEnd === -1);
            if (!this.tryMoveToNextBatch()) {
                this.isValid = false;
                return;
            }
        }
        const rowData = this.rowData;
        const numColumns = this.numColumns;
        // Read the current row.
        for (let i = 0; i < numColumns; i++) {
            const cellType = this.batchBytes[this.nextCellTypeOff++];
            const colName = this.columnNames[i];
            switch (cellType) {
                case CellType.CELL_NULL:
                    rowData[colName] = null;
                    break;
                case CellType.CELL_VARINT:
                    const val = this.varIntReader.int64();
                    // This is very subtle. The return type of int64 can be either a
                    // number or a Long.js {high:number, low:number} if Long.js support is
                    // enabled. The default state seems different in node and browser.
                    // We force-disable Long.js support in the top of this source file.
                    rowData[colName] = val;
                    break;
                case CellType.CELL_FLOAT64:
                    rowData[colName] = this.float64Cells[this.nextFloat64Cell++];
                    break;
                case CellType.CELL_STRING:
                    rowData[colName] = this.stringCells[this.nextStringCell++];
                    break;
                case CellType.CELL_BLOB:
                    const blob = this.blobCells[this.nextBlobCell++];
                    throw new Error(`TODO implement BLOB support (${blob})`);
                default:
                    throw new Error(`Invalid cell type ${cellType}`);
            }
        } // For (cells)
        this.isValid = true;
    }
    tryMoveToNextBatch() {
        const nextBatchIdx = this.batchIdx + 1;
        if (nextBatchIdx >= this.resultObj.batches.length) {
            return false;
        }
        this.columnNames = this.resultObj.columnNames;
        this.numColumns = this.columnNames.length;
        this.batchIdx = nextBatchIdx;
        const batch = (0, logging.assertExists)(this.resultObj.batches[nextBatchIdx]);
        this.batchBytes = batch.batchBytes;
        this.nextCellTypeOff = batch.cellTypesOff;
        this.cellTypesEnd = batch.cellTypesOff + batch.cellTypesLen;
        this.float64Cells = batch.float64Cells;
        this.blobCells = batch.blobCells;
        this.stringCells = batch.stringCells;
        this.varIntReader = minimal$1.Reader.create(batch.batchBytes);
        this.varIntReader.pos = batch.varintOff;
        this.varIntReader.len = batch.varintOff + batch.varintLen;
        this.nextFloat64Cell = 0;
        this.nextStringCell = 0;
        this.nextBlobCell = 0;
        // Check that all the expected columns are present.
        for (const expectedCol of Object.keys(this.rowSpec)) {
            if (this.columnNames.indexOf(expectedCol) < 0) {
                throw new Error(`Column ${expectedCol} not found in the SQL result ` +
                    `set {${this.columnNames.join(' ')}}`);
            }
        }
        // Check that the cells types are consistent.
        const numColumns = this.numColumns;
        if (batch.numCells === 0) {
            // This can happen if the query result contains just an error. In this
            // an empty batch with isLastBatch=true is appended as an EOF marker.
            // In theory TraceProcessor could return an empty batch in the middle and
            // that would be fine from a protocol viewpoint. In practice, no code path
            // does that today so it doesn't make sense trying supporting it with a
            // recursive call to tryMoveToNextBatch().
            (0, logging.assertTrue)(batch.isLastBatch);
            return false;
        }
        (0, logging.assertTrue)(numColumns > 0);
        for (let i = this.nextCellTypeOff; i < this.cellTypesEnd; i++) {
            const col = (i - this.nextCellTypeOff) % numColumns;
            const colName = this.columnNames[col];
            const actualType = this.batchBytes[i];
            const expType = this.rowSpec[colName];
            // If undefined, the caller doesn't want to read this column at all, so
            // it can be whatever.
            if (expType === undefined)
                continue;
            let err = '';
            if (actualType === CellType.CELL_NULL &&
                (expType !== exports.STR_NULL && expType !== exports.NUM_NULL)) {
                err = 'SQL value is NULL but that was not expected' +
                    ` (expected type: ${columnTypeToString(expType)}). ` +
                    'Did you intend to use NUM_NULL or STR_NULL?';
            }
            else if (((actualType === CellType.CELL_VARINT ||
                actualType === CellType.CELL_FLOAT64) &&
                (expType !== exports.NUM && expType !== exports.NUM_NULL)) ||
                ((actualType === CellType.CELL_STRING) &&
                    (expType !== exports.STR && expType !== exports.STR_NULL))) {
                err = `Incompatible cell type. Expected: ${columnTypeToString(expType)} actual: ${CELL_TYPE_NAMES[actualType]}`;
            }
            if (err.length > 0) {
                throw new Error(`Error @ row: ${Math.floor(i / numColumns)} col: '` +
                    `${colName}': ${err}`);
            }
        }
        return true;
    }
}
// This is the object ultimately returned to the client when calling
// QueryResult.iter(...).
// The only reason why this is disjoint from RowIteratorImpl is to avoid
// naming collisions between the members variables required by RowIteratorImpl
// and the column names returned by the iterator.
class RowIteratorImplWithRowData {
    constructor(querySpec, res) {
        const thisAsRow = this;
        Object.assign(thisAsRow, querySpec);
        this._impl = new RowIteratorImpl(querySpec, thisAsRow, res);
        this.next = this._impl.next.bind(this._impl);
        this.valid = this._impl.valid.bind(this._impl);
        this.get = this._impl.get.bind(this._impl);
    }
}
// This is a proxy object that wraps QueryResultImpl, adding await-ability.
// This is so that:
// 1. Clients that just want to await for the full result set can just call
//    await engine.query('...') and will get a QueryResult that is guaranteed
//    to be complete.
// 2. Clients that know how to handle the streaming can use it straight away.
class WaitableQueryResultImpl {
    constructor(errorInfo) {
        this.thenCalled = false;
        this.impl = new QueryResultImpl(errorInfo);
    }
    // QueryResult implementation. Proxies all calls to the impl object.
    iter(spec) {
        return this.impl.iter(spec);
    }
    firstRow(spec) {
        return this.impl.firstRow(spec);
    }
    waitAllRows() {
        return this.impl.waitAllRows();
    }
    isComplete() {
        return this.impl.isComplete();
    }
    numRows() {
        return this.impl.numRows();
    }
    columns() {
        return this.impl.columns();
    }
    error() {
        return this.impl.error();
    }
    statementCount() {
        return this.impl.statementCount();
    }
    statementWithOutputCount() {
        return this.impl.statementWithOutputCount();
    }
    // WritableQueryResult implementation.
    appendResultBatch(resBytes) {
        return this.impl.appendResultBatch(resBytes);
    }
    // PromiseLike<QueryResult> implementaton.
    then(onfulfilled, onrejected) {
        (0, logging.assertFalse)(this.thenCalled);
        this.thenCalled = true;
        return this.impl.ensureAllRowsPromise().then(onfulfilled, onrejected);
    }
    catch(error) {
        return this.impl.ensureAllRowsPromise().catch(error);
    }
    finally(callback) {
        return this.impl.ensureAllRowsPromise().finally(callback);
    }
    // eslint and clang-format disagree on how to format get[foo](). Let
    // clang-format win:
    // eslint-disable-next-line keyword-spacing
    get [Symbol.toStringTag]() {
        return 'Promise<WaitableQueryResult>';
    }
}
function createQueryResult(errorInfo) {
    return new WaitableQueryResultImpl(errorInfo);
}
exports.createQueryResult = createQueryResult;

});

var canvas_utils = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.drawIncompleteSlice = exports.drawDoubleHeadedArrow = exports.cropText = void 0;
function cropText(str, charWidth, rectWidth) {
    let displayText = '';
    const maxLength = Math.floor(rectWidth / charWidth) - 1;
    if (str.length <= maxLength) {
        displayText = str;
    }
    else {
        let limit = maxLength;
        let maybeTripleDot = '';
        if (maxLength > 1) {
            limit = maxLength - 1;
            maybeTripleDot = '\u2026';
        }
        // Javascript strings are UTF-16. |limit| could point in the middle of a
        // 32-bit double-wchar codepoint (e.g., an emoji). Here we detect if the
        // |limit|-th wchar is a leading surrogate and attach the trailing one.
        const lastCharCode = str.charCodeAt(limit - 1);
        limit += (lastCharCode >= 0xD800 && lastCharCode < 0xDC00) ? 1 : 0;
        displayText = str.substring(0, limit) + maybeTripleDot;
    }
    return displayText;
}
exports.cropText = cropText;
function drawDoubleHeadedArrow(ctx, x, y, length, showArrowHeads, width = 2, color = 'black') {
    ctx.beginPath();
    ctx.lineWidth = width;
    ctx.lineCap = 'round';
    ctx.strokeStyle = color;
    ctx.moveTo(x, y);
    ctx.lineTo(x + length, y);
    ctx.stroke();
    ctx.closePath();
    // Arrowheads on the each end of the line.
    if (showArrowHeads) {
        ctx.beginPath();
        ctx.moveTo(x + length - 8, y - 4);
        ctx.lineTo(x + length, y);
        ctx.lineTo(x + length - 8, y + 4);
        ctx.stroke();
        ctx.closePath();
        ctx.beginPath();
        ctx.moveTo(x + 8, y - 4);
        ctx.lineTo(x, y);
        ctx.lineTo(x + 8, y + 4);
        ctx.stroke();
        ctx.closePath();
    }
}
exports.drawDoubleHeadedArrow = drawDoubleHeadedArrow;
function drawIncompleteSlice(ctx, x, y, width, height) {
    ctx.beginPath();
    const triangleSize = height / 4;
    ctx.moveTo(x, y);
    ctx.lineTo(x + width, y);
    ctx.lineTo(x + width - 3, y + triangleSize * 0.5);
    ctx.lineTo(x + width, y + triangleSize);
    ctx.lineTo(x + width - 3, y + (triangleSize * 1.5));
    ctx.lineTo(x + width, y + 2 * triangleSize);
    ctx.lineTo(x + width - 3, y + (triangleSize * 2.5));
    ctx.lineTo(x + width, y + 3 * triangleSize);
    ctx.lineTo(x + width - 3, y + (triangleSize * 3.5));
    ctx.lineTo(x + width, y + 4 * triangleSize);
    ctx.lineTo(x, y + height);
    ctx.fill();
}
exports.drawIncompleteSlice = drawIncompleteSlice;

});

var constants = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TRACE_MARGIN_TIME_S = exports.TRACE_SUFFIX = void 0;
exports.TRACE_SUFFIX = '.perfetto-trace';
exports.TRACE_MARGIN_TIME_S = 1 / 1e7;

});

var checkerboard_1 = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkerboardExcept = exports.checkerboard = void 0;
const LOADING_TEXT = 'Loading...';
let LOADING_TEXT_WIDTH = 0;
// Checker board the range [leftPx, rightPx].
function checkerboard(ctx, heightPx, leftPx, rightPx) {
    const widthPx = rightPx - leftPx;
    ctx.font = '12px Roboto Condensed';
    ctx.fillStyle = '#eee';
    ctx.fillRect(leftPx, 0, widthPx, heightPx);
    ctx.fillStyle = '#666';
    const oldBaseline = ctx.textBaseline;
    ctx.textBaseline = 'middle';
    if (LOADING_TEXT_WIDTH === 0) {
        LOADING_TEXT_WIDTH = ctx.measureText(LOADING_TEXT).width;
    }
    if (LOADING_TEXT_WIDTH <= widthPx) {
        ctx.fillText(LOADING_TEXT, leftPx + widthPx / 2 - LOADING_TEXT_WIDTH / 2, heightPx / 2);
    }
    ctx.textBaseline = oldBaseline;
}
exports.checkerboard = checkerboard;
// Checker board everything between [startPx, endPx] except [leftPx, rightPx].
function checkerboardExcept(ctx, heightPx, startPx, endPx, leftPx, rightPx) {
    // [leftPx, rightPx] doesn't overlap [startPx, endPx] at all:
    if (rightPx <= startPx || leftPx >= endPx) {
        checkerboard(ctx, heightPx, startPx, endPx);
        return;
    }
    // Checkerboard [startPx, leftPx]:
    if (leftPx > startPx) {
        checkerboard(ctx, heightPx, startPx, leftPx);
    }
    // Checkerboard [rightPx, endPx]:
    if (rightPx < endPx) {
        checkerboard(ctx, heightPx, rightPx, endPx);
    }
}
exports.checkerboardExcept = checkerboardExcept;

});

var track = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Track = void 0;



// The abstract class that needs to be implemented by all tracks.
class Track {
    constructor(args) {
        // When true this is a new controller-less track type.
        // TODO(hjd): eventually all tracks will be controller-less and this
        // should be removed then.
        this.frontendOnly = false;
        this.trackId = args.trackId;
        this.engine = args.engine;
        this.lastTrackState = (0, logging.assertExists)(globals.globals.state.tracks[this.trackId]);
    }
    // Last call the track will receive. Called just before the last reference to
    // this object is removed.
    onDestroy() { }
    get trackState() {
        // We can end up in a state where a Track is still in the mithril renderer
        // tree but its corresponding state has been deleted. This can happen in the
        // interval of time between a track being removed from the state and the
        // next animation frame that would remove the Track object. If a mouse event
        // is dispatched in the meanwhile (or a promise is resolved), we need to be
        // able to access the state. Hence the caching logic here.
        const trackState = globals.globals.state.tracks[this.trackId];
        if (trackState === undefined) {
            return this.lastTrackState;
        }
        this.lastTrackState = trackState;
        return trackState;
    }
    get config() {
        return this.trackState.config;
    }
    data() {
        if (this.frontendOnly) {
            return undefined;
        }
        return globals.globals.trackDataStore.get(this.trackId);
    }
    getHeight() {
        return 40;
    }
    getTrackShellButtons() {
        return [];
    }
    getContextMenu() {
        return null;
    }
    onMouseMove(_position) { }
    // Returns whether the mouse click has selected something.
    // Used to prevent further propagation if necessary.
    onMouseClick(_position) {
        return false;
    }
    onMouseOut() { }
    onFullRedraw() { }
    render(ctx) {
        globals.globals.frontendLocalState.addVisibleTrack(this.trackState.id);
        if (this.data() === undefined && !this.frontendOnly) {
            const { visibleWindowTime, timeScale } = globals.globals.frontendLocalState;
            const startPx = Math.floor(timeScale.timeToPx(visibleWindowTime.start));
            const endPx = Math.ceil(timeScale.timeToPx(visibleWindowTime.end));
            (0, checkerboard_1.checkerboard)(ctx, this.getHeight(), startPx, endPx);
        }
        else {
            this.renderCanvas(ctx);
        }
    }
    drawTrackHoverTooltip(ctx, pos, text, text2) {
        ctx.font = '10px Roboto Condensed';
        ctx.textBaseline = 'middle';
        ctx.textAlign = 'left';
        // TODO(hjd): Avoid measuring text all the time (just use monospace?)
        const textMetrics = ctx.measureText(text);
        const text2Metrics = ctx.measureText(text2 || '');
        // Padding on each side of the box containing the tooltip:
        const paddingPx = 4;
        // Figure out the width of the tool tip box:
        let width = Math.max(textMetrics.width, text2Metrics.width);
        width += paddingPx * 2;
        // and the height:
        let height = 0;
        height += textMetrics.fontBoundingBoxAscent;
        height += textMetrics.fontBoundingBoxDescent;
        if (text2 !== undefined) {
            height += text2Metrics.fontBoundingBoxAscent;
            height += text2Metrics.fontBoundingBoxDescent;
        }
        height += paddingPx * 2;
        let x = pos.x;
        let y = pos.y;
        // Move box to the top right of the mouse:
        x += 10;
        y -= 10;
        // Ensure the box is on screen:
        const endPx = globals.globals.frontendLocalState.timeScale.endPx;
        if (x + width > endPx) {
            x -= x + width - endPx;
        }
        if (y < 0) {
            y = 0;
        }
        if (y + height > this.getHeight()) {
            y -= y + height - this.getHeight();
        }
        // Draw everything:
        ctx.fillStyle = 'rgba(255, 255, 255, 0.9)';
        ctx.fillRect(x, y, width, height);
        ctx.fillStyle = 'hsl(200, 50%, 40%)';
        ctx.fillText(text, x + paddingPx, y + paddingPx + textMetrics.fontBoundingBoxAscent);
        if (text2 !== undefined) {
            const yOffsetPx = textMetrics.fontBoundingBoxAscent +
                textMetrics.fontBoundingBoxDescent +
                text2Metrics.fontBoundingBoxAscent;
            ctx.fillText(text2, x + paddingPx, y + paddingPx + yOffsetPx);
        }
    }
    // Returns a place where a given slice should be drawn. Should be implemented
    // only for track types that support slices e.g. chrome_slice, async_slices
    // tStart - slice start time in seconds, tEnd - slice end time in seconds,
    // depth - slice depth
    getSliceRect(_tStart, _tEnd, _depth) {
        return undefined;
    }
}
exports.Track = Track;

});

var chrome_slices = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.ChromeSliceTrack = exports.ChromeSliceTrackController = exports.SLICE_TRACK_KIND = void 0;












exports.SLICE_TRACK_KIND = 'ChromeSliceTrack';
const SLICE_HEIGHT = 18;
const TRACK_PADDING = 4;
const CHEVRON_WIDTH_PX = 10;
const HALF_CHEVRON_WIDTH_PX = CHEVRON_WIDTH_PX / 2;
const INNER_CHEVRON_OFFSET = -3;
const INNER_CHEVRON_SCALE = (SLICE_HEIGHT - 2 * INNER_CHEVRON_OFFSET) / SLICE_HEIGHT;
// the lowest bucketNs gets is 2, but add some room in case of fp error
const MIN_QUANT_NS = 3;
class ChromeSliceTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.maxDurNs = 0;
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            const pxSize = this.pxSize();
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolution * 1e9 * pxSize / 2) * 2, 1);
            const tableName = this.namespaceTable('slice');
            if (this.maxDurNs === 0) {
                const query = `
          SELECT max(iif(dur = -1, (SELECT end_ts FROM trace_bounds) - ts, dur))
          AS maxDur FROM ${tableName} WHERE track_id = ${this.config.trackId}`;
                const queryRes = yield this.query(query);
                this.maxDurNs = queryRes.firstRow({ maxDur: query_result.NUM_NULL }).maxDur || 0;
            }
            // Buckets are always even and positive, don't quantize once we zoom to
            // nanosecond-scale, so that we can see exact sizes.
            let tsq = `ts`;
            if (bucketNs > MIN_QUANT_NS) {
                tsq = `(ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs}`;
            }
            const query = `
      SELECT
        ${tsq} as tsq,
        ts,
        max(iif(dur = -1, (SELECT end_ts FROM trace_bounds) - ts, dur)) as dur,
        depth,
        id as sliceId,
        ifnull(name, '[null]') as name,
        dur = 0 as isInstant,
        dur = -1 as isIncomplete,
        thread_dur as threadDur
      FROM ${tableName}
      WHERE track_id = ${this.config.trackId} AND
        ts >= (${startNs - this.maxDurNs}) AND
        ts <= ${endNs}
      GROUP BY depth, tsq`;
            const queryRes = yield this.query(query);
            const numRows = queryRes.numRows();
            const slices = {
                start,
                end,
                resolution,
                length: numRows,
                strings: [],
                sliceIds: new Float64Array(numRows),
                starts: new Float64Array(numRows),
                ends: new Float64Array(numRows),
                depths: new Uint16Array(numRows),
                titles: new Uint16Array(numRows),
                isInstant: new Uint16Array(numRows),
                isIncomplete: new Uint16Array(numRows),
                cpuTimeRatio: new Float64Array(numRows),
            };
            const stringIndexes = new Map();
            function internString(str) {
                let idx = stringIndexes.get(str);
                if (idx !== undefined)
                    return idx;
                idx = slices.strings.length;
                slices.strings.push(str);
                stringIndexes.set(str, idx);
                return idx;
            }
            const it = queryRes.iter({
                tsq: query_result.NUM,
                ts: query_result.NUM,
                dur: query_result.NUM,
                depth: query_result.NUM,
                sliceId: query_result.NUM,
                name: query_result.STR,
                isInstant: query_result.NUM,
                isIncomplete: query_result.NUM,
                threadDur: query_result.NUM_NULL,
            });
            for (let row = 0; it.valid(); it.next(), row++) {
                const startNsQ = it.tsq;
                const startNs = it.ts;
                const durNs = it.dur;
                const endNs = startNs + durNs;
                let endNsQ = endNs;
                if (bucketNs > MIN_QUANT_NS) {
                    endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
                    endNsQ = Math.max(endNsQ, startNsQ + bucketNs);
                }
                let isInstant = it.isInstant;
                // Floating point rounding with large numbers of nanoseconds can mean
                // there isn't enough precision to distinguish the start and end of a very
                // short event so we just display the event as an instant when zoomed in
                // rather than fail completely if the start and end time are the same.
                if (startNsQ === endNsQ) {
                    isInstant = 1;
                }
                slices.starts[row] = (0, time.fromNs)(startNsQ);
                slices.ends[row] = (0, time.fromNs)(endNsQ);
                slices.depths[row] = it.depth;
                slices.sliceIds[row] = it.sliceId;
                slices.titles[row] = internString(it.name);
                slices.isInstant[row] = isInstant;
                slices.isIncomplete[row] = it.isIncomplete;
                let cpuTimeRatio = 1;
                if (!isInstant && !it.isIncomplete && it.threadDur !== null) {
                    // Rounding the CPU time ratio to two decimal places and ensuring
                    // it is less than or equal to one, incase the thread duration exceeds
                    // the total duration.
                    cpuTimeRatio =
                        Math.min(Math.round((it.threadDur / it.dur) * 100) / 100, 1);
                }
                slices.cpuTimeRatio[row] = cpuTimeRatio;
            }
            return slices;
        });
    }
}
exports.ChromeSliceTrackController = ChromeSliceTrackController;
ChromeSliceTrackController.kind = exports.SLICE_TRACK_KIND;
class ChromeSliceTrack extends track.Track {
    constructor(args) {
        super(args);
        this.hoveredTitleId = -1;
    }
    static create(args) {
        return new ChromeSliceTrack(args);
    }
    // Font used to render the slice name on the current track.
    getFont() {
        return '12px Roboto Condensed';
    }
    renderCanvas(ctx) {
        // TODO: fonts and colors should come from the CSS and not hardcoded here.
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined)
            return; // Can't possibly draw anything.
        // If the cached trace slices don't fully cover the visible time range,
        // show a gray rectangle with a "Loading..." label.
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), timeScale.timeToPx(visibleWindowTime.start), timeScale.timeToPx(visibleWindowTime.end), timeScale.timeToPx(data.start), timeScale.timeToPx(data.end));
        ctx.textAlign = 'center';
        // measuretext is expensive so we only use it once.
        const charWidth = ctx.measureText('ACBDLqsdfg').width / 10;
        // The draw of the rect on the selected slice must happen after the other
        // drawings, otherwise it would result under another rect.
        let drawRectOnSelected = () => { };
        for (let i = 0; i < data.starts.length; i++) {
            const tStart = data.starts[i];
            let tEnd = data.ends[i];
            const depth = data.depths[i];
            const titleId = data.titles[i];
            const sliceId = data.sliceIds[i];
            const isInstant = data.isInstant[i];
            const isIncomplete = data.isIncomplete[i];
            const title = data.strings[titleId];
            const colorOverride = data.colors && data.strings[data.colors[i]];
            if (isIncomplete) { // incomplete slice
                tEnd = visibleWindowTime.end;
            }
            const rect = this.getSliceRect(tStart, tEnd, depth);
            if (!rect || !rect.visible) {
                continue;
            }
            const currentSelection = globals.globals.state.currentSelection;
            const isSelected = currentSelection &&
                currentSelection.kind === 'CHROME_SLICE' &&
                currentSelection.id !== undefined && currentSelection.id === sliceId;
            const name = title.replace(/( )?\d+/g, '');
            const highlighted = titleId === this.hoveredTitleId ||
                globals.globals.state.highlightedSliceId === sliceId;
            const hasFocus = highlighted || isSelected;
            const [hue, saturation, lightness] = (0, colorizer.hslForSlice)(name, hasFocus);
            let color;
            if (colorOverride === undefined) {
                color = (0, hsluv_cache.cachedHsluvToHex)(hue, saturation, lightness);
            }
            else {
                color = colorOverride;
            }
            ctx.fillStyle = color;
            // We draw instant events as upward facing chevrons starting at A:
            //     A
            //    ###
            //   ##C##
            //  ##   ##
            // D       B
            // Then B, C, D and back to A:
            if (isInstant) {
                if (isSelected) {
                    drawRectOnSelected = () => {
                        ctx.save();
                        ctx.translate(rect.left, rect.top);
                        // Draw outer chevron as dark border
                        ctx.save();
                        ctx.translate(0, INNER_CHEVRON_OFFSET);
                        ctx.scale(INNER_CHEVRON_SCALE, INNER_CHEVRON_SCALE);
                        ctx.fillStyle = (0, hsluv_cache.cachedHsluvToHex)(hue, 100, 10);
                        this.drawChevron(ctx);
                        ctx.restore();
                        // Draw inner chevron as interior
                        ctx.fillStyle = color;
                        this.drawChevron(ctx);
                        ctx.restore();
                    };
                }
                else {
                    ctx.save();
                    ctx.translate(rect.left, rect.top);
                    this.drawChevron(ctx);
                    ctx.restore();
                }
                continue;
            }
            if (isIncomplete && rect.width > SLICE_HEIGHT / 4) {
                (0, canvas_utils.drawIncompleteSlice)(ctx, rect.left, rect.top, rect.width, SLICE_HEIGHT);
            }
            else if (data.cpuTimeRatio !== undefined && data.cpuTimeRatio[i] < 1 - 1e-9) {
                // We draw two rectangles, representing the ratio between wall time and
                // time spent on cpu.
                const cpuTimeRatio = data.cpuTimeRatio[i];
                const firstPartWidth = rect.width * cpuTimeRatio;
                const secondPartWidth = rect.width * (1 - cpuTimeRatio);
                ctx.fillRect(rect.left, rect.top, firstPartWidth, SLICE_HEIGHT);
                ctx.fillStyle =
                    (0, colorizer.colorForThreadIdleSlice)(hue, saturation, lightness, hasFocus);
                ctx.fillRect(rect.left + firstPartWidth, rect.top, secondPartWidth, SLICE_HEIGHT);
            }
            else {
                ctx.fillRect(rect.left, rect.top, rect.width, SLICE_HEIGHT);
            }
            // Selected case
            if (isSelected) {
                drawRectOnSelected = () => {
                    ctx.strokeStyle = (0, hsluv_cache.cachedHsluvToHex)(hue, 100, 10);
                    ctx.beginPath();
                    ctx.lineWidth = 3;
                    ctx.strokeRect(rect.left, rect.top - 1.5, rect.width, SLICE_HEIGHT + 3);
                    ctx.closePath();
                };
            }
            ctx.fillStyle = lightness > 65 ? '#404040' : 'white';
            const displayText = (0, canvas_utils.cropText)(title, charWidth, rect.width);
            const rectXCenter = rect.left + rect.width / 2;
            ctx.textBaseline = 'middle';
            ctx.font = this.getFont();
            ctx.fillText(displayText, rectXCenter, rect.top + SLICE_HEIGHT / 2);
        }
        drawRectOnSelected();
    }
    drawChevron(ctx) {
        // Draw a chevron at a fixed location and size. Should be used with
        // ctx.translate and ctx.scale to alter location and size.
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(HALF_CHEVRON_WIDTH_PX, SLICE_HEIGHT);
        ctx.lineTo(0, SLICE_HEIGHT - HALF_CHEVRON_WIDTH_PX);
        ctx.lineTo(-HALF_CHEVRON_WIDTH_PX, SLICE_HEIGHT);
        ctx.lineTo(0, 0);
        ctx.fill();
    }
    getSliceIndex({ x, y }) {
        const data = this.data();
        if (data === undefined)
            return;
        const { timeScale } = globals.globals.frontendLocalState;
        if (y < TRACK_PADDING)
            return;
        const instantWidthTime = timeScale.deltaPxToDuration(HALF_CHEVRON_WIDTH_PX);
        const t = timeScale.pxToTime(x);
        const depth = Math.floor((y - TRACK_PADDING) / SLICE_HEIGHT);
        for (let i = 0; i < data.starts.length; i++) {
            if (depth !== data.depths[i]) {
                continue;
            }
            const tStart = data.starts[i];
            if (data.isInstant[i]) {
                if (Math.abs(tStart - t) < instantWidthTime) {
                    return i;
                }
            }
            else {
                let tEnd = data.ends[i];
                if (data.isIncomplete[i]) {
                    tEnd = globals.globals.frontendLocalState.visibleWindowTime.end;
                }
                if (tStart <= t && t <= tEnd) {
                    return i;
                }
            }
        }
    }
    onMouseMove({ x, y }) {
        this.hoveredTitleId = -1;
        globals.globals.dispatch(actions.Actions.setHighlightedSliceId({ sliceId: -1 }));
        const sliceIndex = this.getSliceIndex({ x, y });
        if (sliceIndex === undefined)
            return;
        const data = this.data();
        if (data === undefined)
            return;
        this.hoveredTitleId = data.titles[sliceIndex];
        const sliceId = data.sliceIds[sliceIndex];
        globals.globals.dispatch(actions.Actions.setHighlightedSliceId({ sliceId }));
    }
    onMouseOut() {
        this.hoveredTitleId = -1;
        globals.globals.dispatch(actions.Actions.setHighlightedSliceId({ sliceId: -1 }));
    }
    onMouseClick({ x, y }) {
        const sliceIndex = this.getSliceIndex({ x, y });
        if (sliceIndex === undefined)
            return false;
        const data = this.data();
        if (data === undefined)
            return false;
        const sliceId = data.sliceIds[sliceIndex];
        if (sliceId !== undefined && sliceId !== -1) {
            globals.globals.makeSelection(actions.Actions.selectChromeSlice({
                id: sliceId,
                trackId: this.trackState.id,
                table: this.config.namespace,
            }));
            return true;
        }
        return false;
    }
    getHeight() {
        return SLICE_HEIGHT * (this.config.maxDepth + 1) + 2 * TRACK_PADDING;
    }
    getSliceRect(tStart, tEnd, depth) {
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const pxEnd = timeScale.timeToPx(visibleWindowTime.end);
        const left = Math.max(timeScale.timeToPx(tStart), -constants.TRACE_MARGIN_TIME_S);
        const right = Math.min(timeScale.timeToPx(tEnd), pxEnd);
        return {
            left,
            width: Math.max(right - left, 1),
            top: TRACK_PADDING + depth * SLICE_HEIGHT,
            height: SLICE_HEIGHT,
            visible: !(tEnd <= visibleWindowTime.start || tStart >= visibleWindowTime.end),
        };
    }
}
exports.ChromeSliceTrack = ChromeSliceTrack;
ChromeSliceTrack.kind = exports.SLICE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(ChromeSliceTrackController);
    ctx.registerTrack(ChromeSliceTrack);
}
exports.plugin = {
    pluginId: 'perfetto.ChromeSlices',
    activate,
};

});

var actual_frames = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.activate = exports.ActualFramesSliceTrack = exports.ACTUAL_FRAMES_SLICE_TRACK_KIND = void 0;





exports.ACTUAL_FRAMES_SLICE_TRACK_KIND = 'ActualFramesSliceTrack';
const BLUE_COLOR = '#03A9F4'; // Blue 500
const GREEN_COLOR = '#4CAF50'; // Green 500
const YELLOW_COLOR = '#FFEB3B'; // Yellow 500
const RED_COLOR = '#FF5722'; // Red 500
const LIGHT_GREEN_COLOR = '#C0D588'; // Light Green 500
const PINK_COLOR = '#F515E0'; // Pink 500
class ActualFramesSliceTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.maxDurNs = 0;
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            const pxSize = this.pxSize();
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolution * 1e9 * pxSize / 2) * 2, 1);
            if (this.maxDurNs === 0) {
                const maxDurResult = yield this.query(`
        select
          max(iif(dur = -1, (SELECT end_ts FROM trace_bounds) - ts, dur))
            as maxDur
        from experimental_slice_layout
        where filter_track_ids = '${this.config.trackIds.join(',')}'
      `);
                this.maxDurNs = maxDurResult.firstRow({ maxDur: query_result.NUM_NULL }).maxDur || 0;
            }
            const rawResult = yield this.query(`
      SELECT
        (s.ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as tsq,
        s.ts as ts,
        max(iif(s.dur = -1, (SELECT end_ts FROM trace_bounds) - s.ts, s.dur))
            as dur,
        s.layout_depth as layoutDepth,
        s.name as name,
        s.id as id,
        s.dur = 0 as isInstant,
        s.dur = -1 as isIncomplete,
        CASE afs.jank_tag
          WHEN 'Self Jank' THEN '${RED_COLOR}'
          WHEN 'Other Jank' THEN '${YELLOW_COLOR}'
          WHEN 'Dropped Frame' THEN '${BLUE_COLOR}'
          WHEN 'Buffer Stuffing' THEN '${LIGHT_GREEN_COLOR}'
          WHEN 'SurfaceFlinger Stuffing' THEN '${LIGHT_GREEN_COLOR}'
          WHEN 'No Jank' THEN '${GREEN_COLOR}'
          ELSE '${PINK_COLOR}'
        END as color
      from experimental_slice_layout s
      join actual_frame_timeline_slice afs using(id)
      where
        filter_track_ids = '${this.config.trackIds.join(',')}' and
        s.ts >= ${startNs - this.maxDurNs} and
        s.ts <= ${endNs}
      group by tsq, s.layout_depth
      order by tsq, s.layout_depth
    `);
            const numRows = rawResult.numRows();
            const slices = {
                start,
                end,
                resolution,
                length: numRows,
                strings: [],
                sliceIds: new Float64Array(numRows),
                starts: new Float64Array(numRows),
                ends: new Float64Array(numRows),
                depths: new Uint16Array(numRows),
                titles: new Uint16Array(numRows),
                colors: new Uint16Array(numRows),
                isInstant: new Uint16Array(numRows),
                isIncomplete: new Uint16Array(numRows),
            };
            const stringIndexes = new Map();
            function internString(str) {
                let idx = stringIndexes.get(str);
                if (idx !== undefined)
                    return idx;
                idx = slices.strings.length;
                slices.strings.push(str);
                stringIndexes.set(str, idx);
                return idx;
            }
            const it = rawResult.iter({
                'tsq': query_result.NUM,
                'ts': query_result.NUM,
                'dur': query_result.NUM,
                'layoutDepth': query_result.NUM,
                'id': query_result.NUM,
                'name': query_result.STR,
                'isInstant': query_result.NUM,
                'isIncomplete': query_result.NUM,
                'color': query_result.STR,
            });
            for (let i = 0; it.valid(); i++, it.next()) {
                const startNsQ = it.tsq;
                const startNs = it.ts;
                const durNs = it.dur;
                const endNs = startNs + durNs;
                let endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
                endNsQ = Math.max(endNsQ, startNsQ + bucketNs);
                slices.starts[i] = (0, time.fromNs)(startNsQ);
                slices.ends[i] = (0, time.fromNs)(endNsQ);
                slices.depths[i] = it.layoutDepth;
                slices.titles[i] = internString(it.name);
                slices.colors[i] = internString(it.color);
                slices.sliceIds[i] = it.id;
                slices.isInstant[i] = it.isInstant;
                slices.isIncomplete[i] = it.isIncomplete;
            }
            return slices;
        });
    }
}
ActualFramesSliceTrackController.kind = exports.ACTUAL_FRAMES_SLICE_TRACK_KIND;
class ActualFramesSliceTrack extends chrome_slices.ChromeSliceTrack {
    static create(args) {
        return new ActualFramesSliceTrack(args);
    }
}
exports.ActualFramesSliceTrack = ActualFramesSliceTrack;
ActualFramesSliceTrack.kind = exports.ACTUAL_FRAMES_SLICE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(ActualFramesSliceTrackController);
    ctx.registerTrack(ActualFramesSliceTrack);
}
exports.activate = activate;
exports.plugin = {
    pluginId: 'perfetto.ActualFrames',
    activate,
};

});

var android_log = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.ANDROID_LOGS_TRACK_KIND = void 0;








exports.ANDROID_LOGS_TRACK_KIND = 'AndroidLogTrack';
const LEVELS = [
    { color: 'hsl(122, 39%, 49%)', prios: [0, 1, 2, 3] },
    { color: 'hsl(0, 0%, 70%)', prios: [4] },
    { color: 'hsl(45, 100%, 51%)', prios: [5] },
    { color: 'hsl(4, 90%, 58%)', prios: [6] },
    { color: 'hsl(291, 64%, 42%)', prios: [7] }, // 7 (FATAL) -> Purple
];
const MARGIN_TOP = 2;
const RECT_HEIGHT = 35;
const EVT_PX = 2; // Width of an event tick in pixels.
class AndroidLogTrackController extends track_controller.TrackController {
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const startNs = (0, time.toNsFloor)(start);
            const endNs = (0, time.toNsCeil)(end);
            // |resolution| is in s/px the frontend wants.
            const quantNs = (0, time.toNsCeil)(resolution);
            const queryRes = yield this.query(`
      select
        cast(ts / ${quantNs} as integer) * ${quantNs} as tsQuant,
        prio,
        count(prio) as numEvents
      from android_logs
      where ts >= ${startNs} and ts <= ${endNs}
      group by tsQuant, prio
      order by tsQuant, prio limit ${track_data.LIMIT};`);
            const rowCount = queryRes.numRows();
            const result = {
                start,
                end,
                resolution,
                length: rowCount,
                numEvents: 0,
                timestamps: new Float64Array(rowCount),
                priorities: new Uint8Array(rowCount),
            };
            const it = queryRes.iter({ tsQuant: query_result.NUM, prio: query_result.NUM, numEvents: query_result.NUM });
            for (let row = 0; it.valid(); it.next(), row++) {
                result.timestamps[row] = (0, time.fromNs)(it.tsQuant);
                const prio = Math.min(it.prio, 7);
                result.priorities[row] |= (1 << prio);
                result.numEvents += it.numEvents;
            }
            return result;
        });
    }
}
AndroidLogTrackController.kind = exports.ANDROID_LOGS_TRACK_KIND;
class AndroidLogTrack extends track.Track {
    constructor(args) {
        super(args);
    }
    static create(args) {
        return new AndroidLogTrack(args);
    }
    renderCanvas(ctx) {
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined)
            return; // Can't possibly draw anything.
        const dataStartPx = timeScale.timeToPx(data.start);
        const dataEndPx = timeScale.timeToPx(data.end);
        const visibleStartPx = timeScale.timeToPx(visibleWindowTime.start);
        const visibleEndPx = timeScale.timeToPx(visibleWindowTime.end);
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), visibleStartPx, visibleEndPx, dataStartPx, dataEndPx);
        const quantWidth = Math.max(EVT_PX, timeScale.deltaTimeToPx(data.resolution));
        const blockH = RECT_HEIGHT / LEVELS.length;
        for (let i = 0; i < data.timestamps.length; i++) {
            for (let lev = 0; lev < LEVELS.length; lev++) {
                let hasEventsForCurColor = false;
                for (const prio of LEVELS[lev].prios) {
                    if (data.priorities[i] & (1 << prio))
                        hasEventsForCurColor = true;
                }
                if (!hasEventsForCurColor)
                    continue;
                ctx.fillStyle = LEVELS[lev].color;
                const px = Math.floor(timeScale.timeToPx(data.timestamps[i]));
                ctx.fillRect(px, MARGIN_TOP + blockH * lev, quantWidth, blockH);
            } // for(lev)
        } // for (timestamps)
    }
}
AndroidLogTrack.kind = exports.ANDROID_LOGS_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrack(AndroidLogTrack);
    ctx.registerTrackController(AndroidLogTrackController);
}
exports.plugin = {
    pluginId: 'perfetto.AndroidLog',
    activate,
};

});

var async_slices = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.AsyncSliceTrack = exports.ASYNC_SLICE_TRACK_KIND = void 0;





exports.ASYNC_SLICE_TRACK_KIND = 'AsyncSliceTrack';
class AsyncSliceTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.maxDurNs = 0;
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            const pxSize = this.pxSize();
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolution * 1e9 * pxSize / 2) * 2, 1);
            if (this.maxDurNs === 0) {
                const maxDurResult = yield this.query(`
        select max(iif(dur = -1, (SELECT end_ts FROM trace_bounds) - ts, dur))
        as maxDur from experimental_slice_layout
        where filter_track_ids = '${this.config.trackIds.join(',')}'
      `);
                this.maxDurNs = maxDurResult.firstRow({ maxDur: query_result.NUM_NULL }).maxDur || 0;
            }
            const queryRes = yield this.query(`
      SELECT
        (ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as tsq,
        ts,
        max(iif(dur = -1, (SELECT end_ts FROM trace_bounds) - ts, dur)) as dur,
        layout_depth as depth,
        ifnull(name, '[null]') as name,
        id,
        dur = 0 as isInstant,
        dur = -1 as isIncomplete
      from experimental_slice_layout
      where
        filter_track_ids = '${this.config.trackIds.join(',')}' and
        ts >= ${startNs - this.maxDurNs} and
        ts <= ${endNs}
      group by tsq, layout_depth
      order by tsq, layout_depth
    `);
            const numRows = queryRes.numRows();
            const slices = {
                start,
                end,
                resolution,
                length: numRows,
                strings: [],
                sliceIds: new Float64Array(numRows),
                starts: new Float64Array(numRows),
                ends: new Float64Array(numRows),
                depths: new Uint16Array(numRows),
                titles: new Uint16Array(numRows),
                isInstant: new Uint16Array(numRows),
                isIncomplete: new Uint16Array(numRows),
            };
            const stringIndexes = new Map();
            function internString(str) {
                let idx = stringIndexes.get(str);
                if (idx !== undefined)
                    return idx;
                idx = slices.strings.length;
                slices.strings.push(str);
                stringIndexes.set(str, idx);
                return idx;
            }
            const it = queryRes.iter({
                tsq: query_result.NUM,
                ts: query_result.NUM,
                dur: query_result.NUM,
                depth: query_result.NUM,
                name: query_result.STR,
                id: query_result.NUM,
                isInstant: query_result.NUM,
                isIncomplete: query_result.NUM,
            });
            for (let row = 0; it.valid(); it.next(), row++) {
                const startNsQ = it.tsq;
                const startNs = it.ts;
                const durNs = it.dur;
                const endNs = startNs + durNs;
                let endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
                endNsQ = Math.max(endNsQ, startNsQ + bucketNs);
                slices.starts[row] = (0, time.fromNs)(startNsQ);
                slices.ends[row] = (0, time.fromNs)(endNsQ);
                slices.depths[row] = it.depth;
                slices.titles[row] = internString(it.name);
                slices.sliceIds[row] = it.id;
                slices.isInstant[row] = it.isInstant;
                slices.isIncomplete[row] = it.isIncomplete;
            }
            return slices;
        });
    }
}
AsyncSliceTrackController.kind = exports.ASYNC_SLICE_TRACK_KIND;
class AsyncSliceTrack extends chrome_slices.ChromeSliceTrack {
    static create(args) {
        return new AsyncSliceTrack(args);
    }
}
exports.AsyncSliceTrack = AsyncSliceTrack;
AsyncSliceTrack.kind = exports.ASYNC_SLICE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(AsyncSliceTrackController);
    ctx.registerTrack(AsyncSliceTrack);
}
exports.plugin = {
    pluginId: 'perfetto.AsyncSlices',
    activate,
};

});

var rngBrowser = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = rng;
// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
let getRandomValues;
const rnds8 = new Uint8Array(16);

function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation. Also,
    // find the complete implementation of crypto (msCrypto) on IE11.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto !== 'undefined' && typeof msCrypto.getRandomValues === 'function' && msCrypto.getRandomValues.bind(msCrypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}
});

var regex = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;
exports.default = _default;
});

var validate_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regex = _interopRequireDefault(regex);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function validate(uuid) {
  return typeof uuid === 'string' && _regex.default.test(uuid);
}

var _default = validate;
exports.default = _default;
});

var stringify_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(validate_1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
const byteToHex = [];

for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).substr(1));
}

function stringify(arr, offset = 0) {
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  const uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase(); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

var _default = stringify;
exports.default = _default;
});

var v1_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _rng = _interopRequireDefault(rngBrowser);

var _stringify = _interopRequireDefault(stringify_1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html
let _nodeId;

let _clockseq; // Previous uuid creation time


let _lastMSecs = 0;
let _lastNSecs = 0; // See https://github.com/uuidjs/uuid for API details

function v1(options, buf, offset) {
  let i = buf && offset || 0;
  const b = buf || new Array(16);
  options = options || {};
  let node = options.node || _nodeId;
  let clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq; // node and clockseq need to be initialized to random values if they're not
  // specified.  We do this lazily to minimize issues related to insufficient
  // system entropy.  See #189

  if (node == null || clockseq == null) {
    const seedBytes = options.random || (options.rng || _rng.default)();

    if (node == null) {
      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
      node = _nodeId = [seedBytes[0] | 0x01, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];
    }

    if (clockseq == null) {
      // Per 4.2.2, randomize (14 bit) clockseq
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
    }
  } // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.


  let msecs = options.msecs !== undefined ? options.msecs : Date.now(); // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock

  let nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1; // Time since last uuid creation (in msecs)

  const dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000; // Per 4.2.1.2, Bump clockseq on clock regression

  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  } // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval


  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  } // Per 4.2.1.2 Throw error if too many uuids are requested


  if (nsecs >= 10000) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq; // Per 4.1.4 - Convert from unix epoch to Gregorian epoch

  msecs += 12219292800000; // `time_low`

  const tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff; // `time_mid`

  const tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff; // `time_high_and_version`

  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version

  b[i++] = tmh >>> 16 & 0xff; // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)

  b[i++] = clockseq >>> 8 | 0x80; // `clock_seq_low`

  b[i++] = clockseq & 0xff; // `node`

  for (let n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf || (0, _stringify.default)(b);
}

var _default = v1;
exports.default = _default;
});

var parse_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(validate_1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function parse(uuid) {
  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Invalid UUID');
  }

  let v;
  const arr = new Uint8Array(16); // Parse ########-....-....-....-............

  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
  arr[1] = v >>> 16 & 0xff;
  arr[2] = v >>> 8 & 0xff;
  arr[3] = v & 0xff; // Parse ........-####-....-....-............

  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
  arr[5] = v & 0xff; // Parse ........-....-####-....-............

  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
  arr[7] = v & 0xff; // Parse ........-....-....-####-............

  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
  arr[9] = v & 0xff; // Parse ........-....-....-....-############
  // (Use "/" to avoid 32-bit truncation when bit-shifting high-order bytes)

  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 0x10000000000 & 0xff;
  arr[11] = v / 0x100000000 & 0xff;
  arr[12] = v >>> 24 & 0xff;
  arr[13] = v >>> 16 & 0xff;
  arr[14] = v >>> 8 & 0xff;
  arr[15] = v & 0xff;
  return arr;
}

var _default = parse;
exports.default = _default;
});

var v35 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
exports.URL = exports.DNS = void 0;

var _stringify = _interopRequireDefault(stringify_1);

var _parse = _interopRequireDefault(parse_1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function stringToBytes(str) {
  str = unescape(encodeURIComponent(str)); // UTF8 escape

  const bytes = [];

  for (let i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }

  return bytes;
}

const DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';
exports.DNS = DNS;
const URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';
exports.URL = URL;

function _default(name, version, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    if (typeof value === 'string') {
      value = stringToBytes(value);
    }

    if (typeof namespace === 'string') {
      namespace = (0, _parse.default)(namespace);
    }

    if (namespace.length !== 16) {
      throw TypeError('Namespace must be array-like (16 iterable integer values, 0-255)');
    } // Compute hash of namespace and value, Per 4.3
    // Future: Use spread syntax when supported on all platforms, e.g. `bytes =
    // hashfunc([...namespace, ... value])`


    let bytes = new Uint8Array(16 + value.length);
    bytes.set(namespace);
    bytes.set(value, namespace.length);
    bytes = hashfunc(bytes);
    bytes[6] = bytes[6] & 0x0f | version;
    bytes[8] = bytes[8] & 0x3f | 0x80;

    if (buf) {
      offset = offset || 0;

      for (let i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }

      return buf;
    }

    return (0, _stringify.default)(bytes);
  } // Function#name is not settable on some platforms (#270)


  try {
    generateUUID.name = name; // eslint-disable-next-line no-empty
  } catch (err) {} // For CommonJS default export support


  generateUUID.DNS = DNS;
  generateUUID.URL = URL;
  return generateUUID;
}
});

var md5Browser = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Browser-compatible JavaScript MD5
 *
 * Modification of JavaScript MD5
 * https://github.com/blueimp/JavaScript-MD5
 *
 * Copyright 2011, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 *
 * Based on
 * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
 * Digest Algorithm, as defined in RFC 1321.
 * Version 2.2 Copyright (C) Paul Johnston 1999 - 2009
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for more info.
 */
function md5(bytes) {
  if (typeof bytes === 'string') {
    const msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = new Uint8Array(msg.length);

    for (let i = 0; i < msg.length; ++i) {
      bytes[i] = msg.charCodeAt(i);
    }
  }

  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));
}
/*
 * Convert an array of little-endian words to an array of bytes
 */


function md5ToHexEncodedArray(input) {
  const output = [];
  const length32 = input.length * 32;
  const hexTab = '0123456789abcdef';

  for (let i = 0; i < length32; i += 8) {
    const x = input[i >> 5] >>> i % 32 & 0xff;
    const hex = parseInt(hexTab.charAt(x >>> 4 & 0x0f) + hexTab.charAt(x & 0x0f), 16);
    output.push(hex);
  }

  return output;
}
/**
 * Calculate output length with padding and bit length
 */


function getOutputLength(inputLength8) {
  return (inputLength8 + 64 >>> 9 << 4) + 14 + 1;
}
/*
 * Calculate the MD5 of an array of little-endian words, and a bit length.
 */


function wordsToMd5(x, len) {
  /* append padding */
  x[len >> 5] |= 0x80 << len % 32;
  x[getOutputLength(len) - 1] = len;
  let a = 1732584193;
  let b = -271733879;
  let c = -1732584194;
  let d = 271733878;

  for (let i = 0; i < x.length; i += 16) {
    const olda = a;
    const oldb = b;
    const oldc = c;
    const oldd = d;
    a = md5ff(a, b, c, d, x[i], 7, -680876936);
    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
    b = md5gg(b, c, d, a, x[i], 20, -373897302);
    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
    d = md5hh(d, a, b, c, x[i], 11, -358537222);
    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
    a = md5ii(a, b, c, d, x[i], 6, -198630844);
    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
    a = safeAdd(a, olda);
    b = safeAdd(b, oldb);
    c = safeAdd(c, oldc);
    d = safeAdd(d, oldd);
  }

  return [a, b, c, d];
}
/*
 * Convert an array bytes to an array of little-endian words
 * Characters >255 have their high-byte silently ignored.
 */


function bytesToWords(input) {
  if (input.length === 0) {
    return [];
  }

  const length8 = input.length * 8;
  const output = new Uint32Array(getOutputLength(length8));

  for (let i = 0; i < length8; i += 8) {
    output[i >> 5] |= (input[i / 8] & 0xff) << i % 32;
  }

  return output;
}
/*
 * Add integers, wrapping at 2^32. This uses 16-bit operations internally
 * to work around bugs in some JS interpreters.
 */


function safeAdd(x, y) {
  const lsw = (x & 0xffff) + (y & 0xffff);
  const msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return msw << 16 | lsw & 0xffff;
}
/*
 * Bitwise rotate a 32-bit number to the left.
 */


function bitRotateLeft(num, cnt) {
  return num << cnt | num >>> 32 - cnt;
}
/*
 * These functions implement the four basic operations the algorithm uses.
 */


function md5cmn(q, a, b, x, s, t) {
  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
}

function md5ff(a, b, c, d, x, s, t) {
  return md5cmn(b & c | ~b & d, a, b, x, s, t);
}

function md5gg(a, b, c, d, x, s, t) {
  return md5cmn(b & d | c & ~d, a, b, x, s, t);
}

function md5hh(a, b, c, d, x, s, t) {
  return md5cmn(b ^ c ^ d, a, b, x, s, t);
}

function md5ii(a, b, c, d, x, s, t) {
  return md5cmn(c ^ (b | ~d), a, b, x, s, t);
}

var _default = md5;
exports.default = _default;
});

var v3_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _v = _interopRequireDefault(v35);

var _md = _interopRequireDefault(md5Browser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const v3 = (0, _v.default)('v3', 0x30, _md.default);
var _default = v3;
exports.default = _default;
});

var v4_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _rng = _interopRequireDefault(rngBrowser);

var _stringify = _interopRequireDefault(stringify_1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function v4(options, buf, offset) {
  options = options || {};

  const rnds = options.random || (options.rng || _rng.default)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`


  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return (0, _stringify.default)(rnds);
}

var _default = v4;
exports.default = _default;
});

var sha1Browser = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

// Adapted from Chris Veness' SHA1 code at
// http://www.movable-type.co.uk/scripts/sha1.html
function f(s, x, y, z) {
  switch (s) {
    case 0:
      return x & y ^ ~x & z;

    case 1:
      return x ^ y ^ z;

    case 2:
      return x & y ^ x & z ^ y & z;

    case 3:
      return x ^ y ^ z;
  }
}

function ROTL(x, n) {
  return x << n | x >>> 32 - n;
}

function sha1(bytes) {
  const K = [0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6];
  const H = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];

  if (typeof bytes === 'string') {
    const msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = [];

    for (let i = 0; i < msg.length; ++i) {
      bytes.push(msg.charCodeAt(i));
    }
  } else if (!Array.isArray(bytes)) {
    // Convert Array-like to Array
    bytes = Array.prototype.slice.call(bytes);
  }

  bytes.push(0x80);
  const l = bytes.length / 4 + 2;
  const N = Math.ceil(l / 16);
  const M = new Array(N);

  for (let i = 0; i < N; ++i) {
    const arr = new Uint32Array(16);

    for (let j = 0; j < 16; ++j) {
      arr[j] = bytes[i * 64 + j * 4] << 24 | bytes[i * 64 + j * 4 + 1] << 16 | bytes[i * 64 + j * 4 + 2] << 8 | bytes[i * 64 + j * 4 + 3];
    }

    M[i] = arr;
  }

  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);
  M[N - 1][14] = Math.floor(M[N - 1][14]);
  M[N - 1][15] = (bytes.length - 1) * 8 & 0xffffffff;

  for (let i = 0; i < N; ++i) {
    const W = new Uint32Array(80);

    for (let t = 0; t < 16; ++t) {
      W[t] = M[i][t];
    }

    for (let t = 16; t < 80; ++t) {
      W[t] = ROTL(W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16], 1);
    }

    let a = H[0];
    let b = H[1];
    let c = H[2];
    let d = H[3];
    let e = H[4];

    for (let t = 0; t < 80; ++t) {
      const s = Math.floor(t / 20);
      const T = ROTL(a, 5) + f(s, b, c, d) + e + K[s] + W[t] >>> 0;
      e = d;
      d = c;
      c = ROTL(b, 30) >>> 0;
      b = a;
      a = T;
    }

    H[0] = H[0] + a >>> 0;
    H[1] = H[1] + b >>> 0;
    H[2] = H[2] + c >>> 0;
    H[3] = H[3] + d >>> 0;
    H[4] = H[4] + e >>> 0;
  }

  return [H[0] >> 24 & 0xff, H[0] >> 16 & 0xff, H[0] >> 8 & 0xff, H[0] & 0xff, H[1] >> 24 & 0xff, H[1] >> 16 & 0xff, H[1] >> 8 & 0xff, H[1] & 0xff, H[2] >> 24 & 0xff, H[2] >> 16 & 0xff, H[2] >> 8 & 0xff, H[2] & 0xff, H[3] >> 24 & 0xff, H[3] >> 16 & 0xff, H[3] >> 8 & 0xff, H[3] & 0xff, H[4] >> 24 & 0xff, H[4] >> 16 & 0xff, H[4] >> 8 & 0xff, H[4] & 0xff];
}

var _default = sha1;
exports.default = _default;
});

var v5_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _v = _interopRequireDefault(v35);

var _sha = _interopRequireDefault(sha1Browser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const v5 = (0, _v.default)('v5', 0x50, _sha.default);
var _default = v5;
exports.default = _default;
});

var nil = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = '00000000-0000-0000-0000-000000000000';
exports.default = _default;
});

var version_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(validate_1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function version(uuid) {
  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Invalid UUID');
  }

  return parseInt(uuid.substr(14, 1), 16);
}

var _default = version;
exports.default = _default;
});

var dist$1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "v1", {
  enumerable: true,
  get: function () {
    return _v.default;
  }
});
Object.defineProperty(exports, "v3", {
  enumerable: true,
  get: function () {
    return _v2.default;
  }
});
Object.defineProperty(exports, "v4", {
  enumerable: true,
  get: function () {
    return _v3.default;
  }
});
Object.defineProperty(exports, "v5", {
  enumerable: true,
  get: function () {
    return _v4.default;
  }
});
Object.defineProperty(exports, "NIL", {
  enumerable: true,
  get: function () {
    return _nil.default;
  }
});
Object.defineProperty(exports, "version", {
  enumerable: true,
  get: function () {
    return _version.default;
  }
});
Object.defineProperty(exports, "validate", {
  enumerable: true,
  get: function () {
    return _validate.default;
  }
});
Object.defineProperty(exports, "stringify", {
  enumerable: true,
  get: function () {
    return _stringify.default;
  }
});
Object.defineProperty(exports, "parse", {
  enumerable: true,
  get: function () {
    return _parse.default;
  }
});

var _v = _interopRequireDefault(v1_1);

var _v2 = _interopRequireDefault(v3_1);

var _v3 = _interopRequireDefault(v4_1);

var _v4 = _interopRequireDefault(v5_1);

var _nil = _interopRequireDefault(nil);

var _version = _interopRequireDefault(version_1);

var _validate = _interopRequireDefault(validate_1);

var _stringify = _interopRequireDefault(stringify_1);

var _parse = _interopRequireDefault(parse_1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
});

var slice_layout = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_SLICE_LAYOUT = exports.SLICE_LAYOUT_FLAT_DEFAULTS = exports.SLICE_LAYOUT_FIT_CONTENT_DEFAULTS = exports.SLICE_LAYOUT_FIXED_DEFAULTS = exports.SLICE_LAYOUT_BASE_DEFAULTS = void 0;
exports.SLICE_LAYOUT_BASE_DEFAULTS = Object.freeze({
    padding: 3,
    rowSpacing: 0,
    minDepth: 0,
    // A realistic bound to avoid tracks with unlimited height. If somebody wants
    // extremely deep tracks they need to change this explicitly.
    maxDepth: 128,
});
exports.SLICE_LAYOUT_FIXED_DEFAULTS = Object.freeze(Object.assign(Object.assign({}, exports.SLICE_LAYOUT_BASE_DEFAULTS), { heightMode: 'FIXED', fixedHeight: 30 }));
exports.SLICE_LAYOUT_FIT_CONTENT_DEFAULTS = Object.freeze(Object.assign(Object.assign({}, exports.SLICE_LAYOUT_BASE_DEFAULTS), { heightMode: 'FIT_CONTENT', sliceHeight: 18 }));
exports.SLICE_LAYOUT_FLAT_DEFAULTS = Object.freeze(Object.assign(Object.assign({}, exports.SLICE_LAYOUT_BASE_DEFAULTS), { minDepth: 0, maxDepth: 1, heightMode: 'FIXED', fixedHeight: 30 }));
exports.DEFAULT_SLICE_LAYOUT = exports.SLICE_LAYOUT_FIT_CONTENT_DEFAULTS;

});

var base_slice_track = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseSliceTrack = exports.BASE_SLICE_ROW = exports.filterVisibleSlicesForTesting = exports.SLICE_FLAGS_INSTANT = exports.SLICE_FLAGS_INCOMPLETE = void 0;











// The common class that underpins all tracks drawing slices.
exports.SLICE_FLAGS_INCOMPLETE = 1;
exports.SLICE_FLAGS_INSTANT = 2;
// Slices smaller than this don't get any text:
const SLICE_MIN_WIDTH_FOR_TEXT_PX = 5;
// Slices smaller than this aren't rendered at all.
const SLICE_MIN_WIDTH_PX = 0.1;
const CHEVRON_WIDTH_PX = 10;
const DEFAULT_SLICE_COLOR = colorizer.GRAY_COLOR;
// TODO(hjd): Implement caching.
// Exposed and standalone to allow for testing without making this
// visible to subclasses.
function filterVisibleSlices(slices, startS, endS) {
    // Here we aim to reduce the number of slices we have to draw
    // by ignoring those that are not visible. A slice is visible iff:
    //   slice.start + slice.duration >= start && slice.start <= end
    // It's allowable to include slices which aren't visible but we
    // must not exclude visible slices.
    // We could filter this.slices using this condition but since most
    // often we should have the case where there are:
    // - First a bunch of non-visible slices to the left of the viewport
    // - Then a bunch of visible slices within the viewport
    // - Finally a second bunch of non-visible slices to the right of the
    //   viewport.
    // It seems more sensible to identify the left-most and right-most
    // visible slices then 'slice' to select these slices and everything
    // between.
    // We do not need to handle non-ending slices (where dur = -1
    // but the slice is drawn as 'infinite' length) as this is handled
    // by a special code path.
    // TODO(hjd): Implement special code path.
    // While the slices are guaranteed to be ordered by timestamp we must
    // consider async slices (which are not perfectly nested). This is to
    // say if we see slice A then B it is guaranteed the A.start <= B.start
    // but there is no guarantee that (A.end < B.start XOR A.end >= B.end).
    // Due to this is not possible to use binary search to find the first
    // visible slice. Consider the following situation:
    //         start V            V end
    //     AAA  CCC       DDD   EEEEEEE
    //      BBBBBBBBBBBB            GGG
    //                           FFFFFFF
    // B is visible but A and C are not. In general there could be
    // arbitrarily many slices between B and D which are not visible.
    // You could binary search to find D (i.e. the first slice which
    // starts after |start|) then work backwards to find B.
    // The last visible slice is simpler, since the slices are sorted
    // by timestamp you can binary search for the last slice such
    // that slice.start <= end.
    // One specific edge case that will come up often is when:
    // For all slice in slices: slice.startS > endS (e.g. all slices are to the
    // right). Since the slices are sorted by startS we can check this easily:
    const maybeFirstSlice = slices[0];
    if (maybeFirstSlice && maybeFirstSlice.startS > endS) {
        return [];
    }
    // It's not possible to easily check the analogous edge case where all slices
    // are to the left:
    // For all slice in slices: slice.startS + slice.durationS < startS
    // as the slices are not ordered by 'endS'.
    // As described above you could do some clever binary search combined with
    // iteration however that seems quite complicated and error prone so instead
    // the idea of the code below is that we iterate forward though the
    // array incrementing startIdx until we find the first visible slice
    // then backwards through the array decrementing endIdx until we find the
    // last visible slice. In the worst case we end up doing one full pass on
    // the array. This code is robust to slices not being sorted.
    let startIdx = 0;
    let endIdx = slices.length;
    for (; startIdx < endIdx; ++startIdx) {
        const slice = slices[startIdx];
        const sliceEndS = slice.startS + slice.durationS;
        if (sliceEndS >= startS && slice.startS <= endS) {
            break;
        }
    }
    for (; startIdx < endIdx; --endIdx) {
        const slice = slices[endIdx - 1];
        const sliceEndS = slice.startS + slice.durationS;
        if (sliceEndS >= startS && slice.startS <= endS) {
            break;
        }
    }
    return slices.slice(startIdx, endIdx);
}
exports.filterVisibleSlicesForTesting = filterVisibleSlices;
// The minimal set of columns that any table/view must expose to render tracks.
// Note: this class assumes that, at the SQL level, slices are:
// - Not temporally overlapping (unless they are nested at inner depth).
// - Strictly stacked (i.e. a slice at depth N+1 cannot be larger than any
//   slices at depth 0..N.
// If you need temporally overlapping slices, look at AsyncSliceTrack, which
// merges several tracks into one visual track.
exports.BASE_SLICE_ROW = {
    id: query_result.NUM,
    tsq: query_result.NUM,
    ts: query_result.NUM,
    dur: query_result.NUM,
    depth: query_result.NUM, // Vertical depth.
};
class BaseSliceTrack extends track.Track {
    constructor(args) {
        super(args);
        // This is the slice cache.
        this.slices = new Array();
        this.sliceLayout = Object.assign({}, slice_layout.DEFAULT_SLICE_LAYOUT);
        // These are the over-skirted cached bounds.
        this.slicesStartNs = -1;
        this.slicesEndNs = -1;
        this.slicesBucketNs = -1;
        this.maxDurNs = 0;
        this.sqlState = 'UNINITIALIZED';
        this.charWidth = -1;
        this.hoverTooltip = [];
        this.maxDataDepth = 0;
        // Computed layout.
        this.computedTrackHeight = 0;
        this.computedSliceHeight = 0;
        this.computedRowSpacing = 0;
        // True if this track (and any views tables it might have created) has been
        // destroyed. This is unfortunately error prone (since we must manually check
        // this between each query).
        // TODO(hjd): Replace once we have cancellable query sequences.
        this.isDestroyed = false;
        // TODO(hjd): Remove when updating selection.
        // We shouldn't know here about CHROME_SLICE. Maybe should be set by
        // whatever deals with that. Dunno the namespace of selection is weird. For
        // most cases in non-ambiguous (because most things are a 'slice'). But some
        // others (e.g. THREAD_SLICE) have their own ID namespace so we need this.
        this.selectionKinds = ['SLICE', 'CHROME_SLICE'];
        this.frontendOnly = true; // Disable auto checkerboarding.
        this.tableName = `track_${this.trackId}`.replace(/[^a-zA-Z0-9_]+/g, '_');
        // Work out the extra columns.
        // This is the union of the embedder-defined columns and the base columns
        // we know about (ts, dur, ...).
        const allCols = Object.keys(this.getRowSpec());
        const baseCols = Object.keys(exports.BASE_SLICE_ROW);
        this.extraSqlColumns = allCols.filter((key) => !baseCols.includes(key));
    }
    getRowSpec() {
        return exports.BASE_SLICE_ROW;
    }
    onSliceOver(_args) { }
    onSliceOut(_args) { }
    onSliceClick(_args) { }
    prepareSlices(slices) {
        this.highlightHovererdAndSameTitle(slices);
    }
    // TODO(hjd): Remove.
    drawSchedLatencyArrow(_, _selectedSlice) { }
    setSliceLayout(sliceLayout) {
        if (sliceLayout.minDepth > sliceLayout.maxDepth) {
            const { maxDepth, minDepth } = sliceLayout;
            throw new Error(`minDepth ${minDepth} must be <= maxDepth ${maxDepth}`);
        }
        this.sliceLayout = sliceLayout;
    }
    onFullRedraw() {
        // TODO(hjd): Call this only when cache changes. See discussion:
        // What we want to do here is give the Impl a chance to colour the slice,
        // e.g. depending on the currently selected thread or process.
        // Here's an interesting thought. We have two options here:
        //   A) We could pass only the vizSlices, but then we'd have to call this
        //      @ 60FPS (because vizSlices changes as we pan).
        //   B) We could call this only on full redraws (when the state changes),
        //      but then the track needs to process *all* cached slices, not just
        //      the visible ones. It's okay now (it's a 2x factor) but might get
        //      worse if we cache several layers of slices at various resolutions.
        // But there's an escape, I think. I think the right thing to do is:
        // - For now call it on the full slices, but only on full redraws.
        // - When we get caching, call it every time we switch "cached quantization
        //  level", which is a way in the middle between 60FPS and full redraws..
        // Overall the API contract of this prepareSlices() call is:
        //  - I am going to draw these slices in the near future.
        //  - I am not going to draw any slice that I haven't passed here first.
        //  - This is guaranteed to be called at least on every state change.
        //  - This is NOT guaranteed to be called on every frame. For instance you
        //    cannot use this to do some colour-based animation.
        // Give a chance to the embedder to change colors and other stuff.
        this.prepareSlices(this.slices);
    }
    renderCanvas(ctx) {
        // TODO(hjd): fonts and colors should come from the CSS and not hardcoded
        // here.
        const { timeScale } = globals.globals.frontendLocalState;
        const vizTime = globals.globals.frontendLocalState.visibleWindowTime;
        // If the visible time range is outside the cached area, requests
        // asynchronously new data from the SQL engine.
        this.maybeRequestData();
        // In any case, draw whatever we have (which might be stale/incomplete).
        // If the cached trace slices don't fully cover the visible time range,
        // show a gray rectangle with a "Loading..." label.
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), timeScale.timeToPx(vizTime.start), timeScale.timeToPx(vizTime.end), timeScale.timeToPx((0, time.fromNs)(this.slicesStartNs)), timeScale.timeToPx((0, time.fromNs)(this.slicesEndNs)));
        let charWidth = this.charWidth;
        if (charWidth < 0) {
            // TODO(hjd): Centralize font measurement/invalidation.
            ctx.font = '12px Roboto Condensed';
            charWidth = this.charWidth = ctx.measureText('dbpqaouk').width / 8;
        }
        // Filter only the visible slices. |this.slices| will have more slices than
        // needed because maybeRequestData() over-fetches to handle small pan/zooms.
        // We don't want to waste time drawing slices that are off screen.
        const vizSlices = this.getVisibleSlicesInternal(vizTime.start, vizTime.end);
        let selection = globals.globals.state.currentSelection;
        if (!selection || !this.selectionKinds.includes(selection.kind)) {
            selection = null;
        }
        // Believe it or not, doing 4xO(N) passes is ~2x faster than trying to draw
        // everything in one go. The key is that state changes operations on the
        // canvas (e.g., color, fonts) dominate any number crunching we do in JS.
        this.updateSliceAndTrackHeight();
        const sliceHeight = this.computedSliceHeight;
        const padding = this.sliceLayout.padding;
        const rowSpacing = this.computedRowSpacing;
        // First pass: compute geometry of slices.
        let selSlice;
        // pxEnd is the last visible pixel in the visible viewport. Drawing
        // anything < 0 or > pxEnd doesn't produce any visible effect as it goes
        // beyond the visible portion of the canvas.
        const pxEnd = Math.floor(timeScale.timeToPx(vizTime.end));
        for (const slice of vizSlices) {
            // Compute the basic geometry for any visible slice, even if only
            // partially visible. This might end up with a negative x if the
            // slice starts before the visible time or with a width that overflows
            // pxEnd.
            slice.x = timeScale.timeToPx(slice.startS);
            slice.w = timeScale.deltaTimeToPx(slice.durationS);
            if (slice.flags & exports.SLICE_FLAGS_INSTANT) {
                // In the case of an instant slice, set the slice geometry on the
                // bounding box that will contain the chevron.
                slice.x -= CHEVRON_WIDTH_PX / 2;
                slice.w = CHEVRON_WIDTH_PX;
            }
            else {
                // If the slice is an actual slice, intersect the slice geometry with
                // the visible viewport (this affects only the first and last slice).
                // This is so that text is always centered even if we are zoomed in.
                // Visually if we have
                //                   [    visible viewport   ]
                //  [         slice         ]
                // The resulting geometry will be:
                //                   [slice]
                // So that the slice title stays within the visible region.
                const sliceVizLimit = Math.min(slice.x + slice.w, pxEnd);
                slice.x = Math.max(slice.x, 0);
                slice.w = sliceVizLimit - slice.x;
            }
            if (selection && selection.id === slice.id) {
                selSlice = slice;
            }
        }
        // Second pass: fill slices by color.
        // The .slice() turned out to be an unintended pun.
        const vizSlicesByColor = vizSlices.slice();
        vizSlicesByColor.sort((a, b) => (0, colorizer.colorCompare)(a.color, b.color));
        let lastColor = undefined;
        for (const slice of vizSlicesByColor) {
            if (slice.color !== lastColor) {
                lastColor = slice.color;
                ctx.fillStyle = (0, colorizer.colorToStr)(slice.color);
            }
            const y = padding + slice.depth * (sliceHeight + rowSpacing);
            if (slice.flags & exports.SLICE_FLAGS_INSTANT) {
                this.drawChevron(ctx, slice.x, y, sliceHeight);
            }
            else if (slice.flags & exports.SLICE_FLAGS_INCOMPLETE) {
                const w = Math.max(slice.w - 2, 2);
                (0, canvas_utils.drawIncompleteSlice)(ctx, slice.x, y, w, sliceHeight);
            }
            else if (slice.w > SLICE_MIN_WIDTH_PX) {
                ctx.fillRect(slice.x, y, slice.w, sliceHeight);
            }
        }
        // Third pass, draw the titles (e.g., process name for sched slices).
        ctx.fillStyle = '#fff';
        ctx.textAlign = 'center';
        ctx.font = '12px Roboto Condensed';
        ctx.textBaseline = 'middle';
        for (const slice of vizSlices) {
            if ((slice.flags & exports.SLICE_FLAGS_INSTANT) || !slice.title ||
                slice.w < SLICE_MIN_WIDTH_FOR_TEXT_PX) {
                continue;
            }
            const title = (0, canvas_utils.cropText)(slice.title, charWidth, slice.w);
            const rectXCenter = slice.x + slice.w / 2;
            const y = padding + slice.depth * (sliceHeight + rowSpacing);
            const yDiv = slice.subTitle ? 3 : 2;
            const yMidPoint = Math.floor(y + sliceHeight / yDiv) - 0.5;
            ctx.fillText(title, rectXCenter, yMidPoint);
        }
        // Fourth pass, draw the subtitles (e.g., thread name for sched slices).
        ctx.fillStyle = 'rgba(255, 255, 255, 0.6)';
        ctx.font = '10px Roboto Condensed';
        for (const slice of vizSlices) {
            if (slice.w < SLICE_MIN_WIDTH_FOR_TEXT_PX || !slice.subTitle ||
                (slice.flags & exports.SLICE_FLAGS_INSTANT)) {
                continue;
            }
            const rectXCenter = slice.x + slice.w / 2;
            const subTitle = (0, canvas_utils.cropText)(slice.subTitle, charWidth, slice.w);
            const y = padding + slice.depth * (sliceHeight + rowSpacing);
            const yMidPoint = Math.ceil(y + sliceHeight * 2 / 3) + 1.5;
            ctx.fillText(subTitle, rectXCenter, yMidPoint);
        }
        // Draw a thicker border around the selected slice (or chevron).
        if (selSlice !== undefined) {
            const color = selSlice.color;
            const y = padding + selSlice.depth * (sliceHeight + rowSpacing);
            ctx.strokeStyle = `hsl(${color.h}, ${color.s}%, 30%)`;
            ctx.beginPath();
            const THICKNESS = 3;
            ctx.lineWidth = THICKNESS;
            ctx.strokeRect(selSlice.x, y - THICKNESS / 2, selSlice.w, sliceHeight + THICKNESS);
            ctx.closePath();
        }
        // TODO(hjd): Remove this.
        // The only thing this does is drawing the sched latency arrow. We should
        // have some abstraction for that arrow (ideally the same we'd use for
        // flows).
        this.drawSchedLatencyArrow(ctx, selSlice);
        // If a slice is hovered, draw the tooltip.
        const tooltip = this.hoverTooltip;
        if (this.hoveredSlice !== undefined && tooltip.length > 0 &&
            this.hoverPos !== undefined) {
            if (tooltip.length === 1) {
                this.drawTrackHoverTooltip(ctx, this.hoverPos, tooltip[0]);
            }
            else {
                this.drawTrackHoverTooltip(ctx, this.hoverPos, tooltip[0], tooltip[1]);
            }
        } // if (howSlice)
    }
    onDestroy() {
        super.onDestroy();
        this.isDestroyed = true;
        this.engine.query(`DROP VIEW IF EXISTS ${this.tableName}`);
    }
    // This method figures out if the visible window is outside the bounds of
    // the cached data and if so issues new queries (i.e. sorta subsumes the
    // onBoundsChange).
    maybeRequestData() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            // Important: this method is async and is invoked on every frame. Care
            // must be taken to avoid piling up queries on every frame, hence the FSM.
            if (this.sqlState === 'UNINITIALIZED') {
                this.sqlState = 'INITIALIZING';
                if (this.isDestroyed) {
                    return;
                }
                yield this.initSqlTable(this.tableName);
                if (this.isDestroyed) {
                    return;
                }
                const queryRes = yield this.engine.query(`select
          ifnull(max(dur), 0) as maxDur, count(1) as rowCount
          from ${this.tableName}`);
                const row = queryRes.firstRow({ maxDur: query_result.NUM, rowCount: query_result.NUM });
                this.maxDurNs = row.maxDur;
                this.sqlState = 'QUERY_DONE';
            }
            else if (this.sqlState === 'INITIALIZING' || this.sqlState === 'QUERY_PENDING') {
                return;
            }
            const resolutionNs = (0, time.toNs)(globals.globals.getCurResolution());
            const vizTime = globals.globals.frontendLocalState.visibleWindowTime;
            const startNs = (0, time.toNs)(vizTime.start);
            const endNs = (0, time.toNs)(vizTime.end);
            // TODO(hjd): figure out / centralize the resolution steps.
            // Will handle this at the same time as cacheing.
            const bucketNs = resolutionNs;
            if (startNs >= this.slicesStartNs && endNs <= this.slicesEndNs &&
                bucketNs === this.slicesBucketNs) {
                return; // We have the data already, no need to re-query
            }
            this.sqlState = 'QUERY_PENDING';
            const queryTsq = `(ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs}`;
            const extraCols = this.extraSqlColumns.join(',');
            let depthCol = 'depth';
            let maybeGroupByDepth = 'depth, ';
            const layout = this.sliceLayout;
            const isFlat = (layout.maxDepth - layout.minDepth) <= 1;
            // maxDepth === minDepth only makes sense if track is empty which on the
            // one hand isn't very useful (and so maybe should be an error) on the
            // other hand I can see it happening if someone does:
            // minDepth = min(slices.depth); maxDepth = max(slices.depth);
            // and slices is empty, so we treat that as flat.
            if (isFlat) {
                depthCol = `${this.sliceLayout.minDepth} as depth`;
                maybeGroupByDepth = '';
            }
            // TODO(hjd): Re-reason and improve this query:
            // - Materialize the unfinished slices one off.
            // - Avoid the union if we know we don't have any -1 slices.
            // - Maybe we don't need the union at all and can deal in TS?
            if (this.isDestroyed) {
                return;
            }
            const queryRes = yield this.engine.query(`
    with q1 as (
      select
        ${queryTsq} as tsq,
        ts,
        max(dur) as dur,
        id,
        ${depthCol}
        ${extraCols ? ',' + extraCols : ''}
      from ${this.tableName}
      where
        ts >= ${startNs - this.maxDurNs /* - durNs */} and
        ts <= ${endNs /* + durNs */}
      group by ${maybeGroupByDepth} tsq
      order by tsq),
    q2 as (
      select
        ${queryTsq} as tsq,
        ts,
        -1 as dur,
        id,
        ${depthCol}
        ${extraCols ? ',' + extraCols : ''}
      from ${this.tableName}
      where dur = -1
      group by ${maybeGroupByDepth} tsq
      )
      select min(dur) as _unused, * from
      (select * from q1 union all select * from q2)
      group by ${maybeGroupByDepth} tsq
      order by tsq
    `);
            this.convertQueryResultToSlices(queryRes, startNs, endNs, bucketNs);
            this.sqlState = 'QUERY_DONE';
            globals.globals.rafScheduler.scheduleRedraw();
        });
    }
    // Here convert each row to a Slice. We do what we can do generically
    // in the base class, and delegate the rest to the impl via that rowToSlice()
    // abstract call.
    convertQueryResultToSlices(queryRes, startNs, endNs, bucketNs) {
        const slices = new Array(queryRes.numRows());
        const it = queryRes.iter(this.getRowSpec());
        let maxDataDepth = this.maxDataDepth;
        this.slicesStartNs = startNs;
        this.slicesEndNs = endNs;
        this.slicesBucketNs = bucketNs;
        for (let i = 0; it.valid(); it.next(), ++i) {
            maxDataDepth = Math.max(maxDataDepth, it.depth);
            // Construct the base slice. The Impl will construct and return the full
            // derived T["slice"] (e.g. CpuSlice) in the rowToSlice() method.
            slices[i] = this.rowToSliceInternal(it);
        }
        this.maxDataDepth = maxDataDepth;
        this.slices = slices;
    }
    rowToSliceInternal(row) {
        const slice = this.rowToSlice(row);
        slice.x = -1;
        slice.w = -1;
        return slice;
    }
    rowToSlice(row) {
        const startNsQ = row.tsq;
        const startNs = row.ts;
        let flags = 0;
        let durNs;
        if (row.dur === -1) {
            durNs = (0, time.toNs)(globals.globals.state.traceTime.endSec) - startNs;
            flags |= exports.SLICE_FLAGS_INCOMPLETE;
        }
        else {
            flags |= (row.dur === 0) ? exports.SLICE_FLAGS_INSTANT : 0;
            durNs = row.dur;
        }
        const endNs = startNs + durNs;
        const bucketNs = this.slicesBucketNs;
        let endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
        endNsQ = Math.max(endNsQ, startNsQ + bucketNs);
        return {
            id: row.id,
            startS: (0, time.fromNs)(startNsQ),
            durationS: (0, time.fromNs)(endNsQ - startNsQ),
            flags,
            depth: row.depth,
            title: '',
            subTitle: '',
            // The derived class doesn't need to initialize these. They are
            // rewritten on every renderCanvas() call. We just need to initialize
            // them to something.
            baseColor: DEFAULT_SLICE_COLOR,
            color: DEFAULT_SLICE_COLOR,
        };
    }
    findSlice({ x, y }) {
        const trackHeight = this.computedTrackHeight;
        const sliceHeight = this.computedSliceHeight;
        const padding = this.sliceLayout.padding;
        const rowSpacing = this.computedRowSpacing;
        // Need at least a draw pass to resolve the slice layout.
        if (sliceHeight === 0) {
            return undefined;
        }
        if (y >= padding && y <= trackHeight - padding) {
            const depth = Math.floor((y - padding) / (sliceHeight + rowSpacing));
            for (const slice of this.slices) {
                if (slice.depth === depth && slice.x <= x && x <= slice.x + slice.w) {
                    return slice;
                }
            }
        }
        return undefined;
    }
    onMouseMove(position) {
        this.hoverPos = position;
        this.updateHoveredSlice(this.findSlice(position));
    }
    onMouseOut() {
        this.updateHoveredSlice(undefined);
    }
    updateHoveredSlice(slice) {
        const lastHoveredSlice = this.hoveredSlice;
        this.hoveredSlice = slice;
        // Only notify the Impl if the hovered slice changes:
        if (slice === lastHoveredSlice)
            return;
        if (this.hoveredSlice === undefined) {
            globals.globals.dispatch(actions.Actions.setHighlightedSliceId({ sliceId: -1 }));
            this.onSliceOut({ slice: (0, logging.assertExists)(lastHoveredSlice) });
            this.hoverTooltip = [];
            this.hoverPos = undefined;
        }
        else {
            const args = { slice: this.hoveredSlice };
            globals.globals.dispatch(actions.Actions.setHighlightedSliceId({ sliceId: this.hoveredSlice.id }));
            this.onSliceOver(args);
            this.hoverTooltip = args.tooltip || [];
        }
    }
    onMouseClick(position) {
        const slice = this.findSlice(position);
        if (slice === undefined) {
            return false;
        }
        const args = { slice };
        this.onSliceClick(args);
        return true;
    }
    getVisibleSlicesInternal(startS, endS) {
        return filterVisibleSlices(this.slices, startS, endS);
    }
    updateSliceAndTrackHeight() {
        const lay = this.sliceLayout;
        const rows = Math.min(Math.max(this.maxDataDepth + 1, lay.minDepth), lay.maxDepth);
        // Compute the track height.
        let trackHeight;
        if (lay.heightMode === 'FIXED') {
            trackHeight = lay.fixedHeight;
        }
        else {
            trackHeight = 2 * lay.padding + rows * (lay.sliceHeight + lay.rowSpacing);
        }
        // Compute the slice height.
        let sliceHeight;
        let rowSpacing = lay.rowSpacing;
        if (lay.heightMode === 'FIXED') {
            const rowHeight = (trackHeight - 2 * lay.padding) / rows;
            sliceHeight = Math.floor(Math.max(rowHeight - lay.rowSpacing, 0.5));
            rowSpacing = Math.max(lay.rowSpacing, rowHeight - sliceHeight);
            rowSpacing = Math.floor(rowSpacing * 2) / 2;
        }
        else {
            sliceHeight = lay.sliceHeight;
        }
        this.computedSliceHeight = sliceHeight;
        this.computedTrackHeight = trackHeight;
        this.computedRowSpacing = rowSpacing;
    }
    drawChevron(ctx, x, y, h) {
        // Draw an upward facing chevrons, in order: A, B, C, D, and back to A.
        // . (x, y)
        //      A
        //     ###
        //    ##C##
        //   ##   ##
        //  D       B
        //            . (x + CHEVRON_WIDTH_PX, y + h)
        const HALF_CHEVRON_WIDTH_PX = CHEVRON_WIDTH_PX / 2;
        const midX = x + HALF_CHEVRON_WIDTH_PX;
        ctx.beginPath();
        ctx.moveTo(midX, y); // A.
        ctx.lineTo(x + CHEVRON_WIDTH_PX, y + h); // B.
        ctx.lineTo(midX, y + h - HALF_CHEVRON_WIDTH_PX); // C.
        ctx.lineTo(x, y + h); // D.
        ctx.lineTo(midX, y); // Back to A.
        ctx.closePath();
        ctx.fill();
    }
    // This is a good default implemenation for highlighting slices. By default
    // prepareSlices() calls this. However, if the XxxSliceTrack impl overrides
    // prepareSlices() this gives them a chance to call the highlighting witout
    // having to reimplement it.
    highlightHovererdAndSameTitle(slices) {
        for (const slice of slices) {
            const isHovering = globals.globals.state.highlightedSliceId === slice.id ||
                (this.hoveredSlice && this.hoveredSlice.title === slice.title);
            if (isHovering) {
                slice.color = {
                    c: slice.baseColor.c,
                    h: slice.baseColor.h,
                    s: slice.baseColor.s,
                    l: 30,
                };
            }
            else {
                slice.color = slice.baseColor;
            }
        }
    }
    getHeight() {
        this.updateSliceAndTrackHeight();
        return this.computedTrackHeight;
    }
    getSliceRect(_tStart, _tEnd, _depth) {
        // TODO(hjd): Implement this as part of updating flow events.
        return undefined;
    }
}
exports.BaseSliceTrack = BaseSliceTrack;

});

var named_slice_track = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.NamedSliceTrack = exports.NAMED_SLICE_ROW = void 0;





exports.NAMED_SLICE_ROW = Object.assign(Object.assign({}, base_slice_track.BASE_SLICE_ROW), { 
    // Impl-specific columns.
    name: query_result.STR_NULL });
class NamedSliceTrack extends base_slice_track.BaseSliceTrack {
    constructor(args) {
        super(args);
    }
    // This is used by the base class to call iter().
    getRowSpec() {
        return exports.NAMED_SLICE_ROW;
    }
    // Converts a SQL result row to an "Impl" Slice.
    rowToSlice(row) {
        const baseSlice = super.rowToSlice(row);
        // Ignore PIDs or numeric arguments when hashing.
        const name = row.name || '';
        const nameForHashing = name.replace(/\s?\d+/g, '');
        const hsl = (0, colorizer.hslForSlice)(nameForHashing, /* isSelected=*/ false);
        // We cache the color so we hash only once per query.
        const baseColor = { c: '', h: hsl[0], s: hsl[1], l: hsl[2] };
        return Object.assign(Object.assign({}, baseSlice), { title: name, baseColor });
    }
    onSliceOver(args) {
        const name = args.slice.title;
        args.tooltip = [name];
    }
    onSliceClick(args) {
        globals.globals.makeSelection(actions.Actions.selectChromeSlice({
            id: args.slice.id,
            trackId: this.trackId,
            // |table| here can be either 'slice' or 'annotation'. The
            // AnnotationSliceTrack overrides the onSliceClick and sets this to
            // 'annotation'
            table: 'slice',
        }));
    }
}
exports.NamedSliceTrack = NamedSliceTrack;

});

var chrome_scroll_jank = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.decideTracks = void 0;








const ENABLE_CHROME_SCROLL_JANK_PLUGIN = feature_flags.featureFlags.register({
    id: 'enableChromeScrollJankPlugin',
    name: 'Enable Chrome Scroll Jank plugin',
    description: 'Adds new tracks for scroll jank in Chrome',
    defaultValue: false,
});
class ChromeScrollJankTrack extends named_slice_track.NamedSliceTrack {
    static create(args) {
        return new ChromeScrollJankTrack(args);
    }
    initSqlTable(tableName) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.engine.query(`
create view ${tableName} as
select s2.ts, s2.dur, s2.id, 0 as depth, s1.full_name as name
from chrome_tasks_delaying_input_processing s1
join slice s2 on s2.id=s1.slice_id
    `);
        });
    }
}
ChromeScrollJankTrack.kind = 'org.chromium.ScrollJank.BrowserUIThreadLongTasks';
function decideTracks(engine, getTrackGroupUuid) {
    return tslib.__awaiter(this, void 0, void 0, function* () {
        const result = {
            tracksToAdd: [],
        };
        if (!ENABLE_CHROME_SCROLL_JANK_PLUGIN.get()) {
            return result;
        }
        const queryResult = yield engine.query(`
    select utid, upid
    from thread
    where name='CrBrowserMain'
    `);
        const it = queryResult.iter({
            utid: query_result.NUM,
            upid: query_result.NUM,
        });
        if (!it.valid()) {
            return result;
        }
        result.tracksToAdd.push({
            id: (0, dist$1.v4)(),
            engineId: engine.id,
            kind: ChromeScrollJankTrack.kind,
            trackSortKey: {
                utid: it.utid,
                priority: state.InThreadTrackSortKey.ORDINARY,
            },
            name: 'Scroll Jank causes - long tasks',
            config: {},
            trackGroup: getTrackGroupUuid(it.utid, it.upid),
        });
        // Initialise the chrome_tasks_delaying_input_processing table. It will be
        // used in the sql table above.
        yield engine.query(`
select RUN_METRIC(
   'chrome/chrome_tasks_delaying_input_processing.sql',
   'duration_causing_jank_ms',
   /* duration_causing_jank_ms = */ '8');`);
        globals.globals.dispatch(actions.Actions.executeQuery({
            queryId: 'chrome_scroll_jank_long_tasks',
            query: `
     select
       s1.full_name,
       s1.duration_ms,
       s1.slice_id,
       s1.thread_dur_ms,
       s2.id,
       s2.ts,
       s2.dur,
       s2.track_id
     from chrome_tasks_delaying_input_processing s1
     join slice s2 on s1.slice_id=s2.id
     `,
        }));
        return result;
    });
}
exports.decideTracks = decideTracks;
function activate(ctx) {
    ctx.registerTrack(ChromeScrollJankTrack);
}
exports.plugin = {
    pluginId: 'perfetto.ChromeScrollJank',
    activate,
};

});

var popup_menu = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.PopupMenuButton = void 0;


// To ensure having at most one popup menu on the screen at a time, we need to
// listen to click events on the whole page and close currently opened popup, if
// there's any. This class, used as a singleton, does exactly that.
class PopupHolder {
    constructor() {
        // Invariant: global listener should be register if and only if this.popup is
        // not undefined.
        this.popup = undefined;
        this.initialized = false;
        this.listener = (e) => {
            // Only handle those events that are not part of dropdown menu themselves.
            const hasDropdown = e.composedPath().find(PopupHolder.isDropdownElement) !== undefined;
            if (!hasDropdown) {
                this.ensureHidden();
            }
        };
    }
    static isDropdownElement(target) {
        if (target instanceof HTMLElement) {
            return target.tagName === 'DIV' && target.classList.contains('dropdown');
        }
        return false;
    }
    ensureHidden() {
        if (this.popup !== undefined) {
            this.popup.setVisible(false);
        }
    }
    clear() {
        if (this.popup !== undefined) {
            this.popup = undefined;
            window.removeEventListener('click', this.listener);
        }
    }
    showPopup(popup) {
        this.ensureHidden();
        this.popup = popup;
        window.addEventListener('click', this.listener);
    }
}
// Singleton instance of PopupHolder
const popupHolder = new PopupHolder();
// Component that displays a button that shows a popup menu on click.
class PopupMenuButton {
    constructor() {
        this.popupShown = false;
        this.expandedGroups = new Set();
    }
    setVisible(visible) {
        this.popupShown = visible;
        if (this.popupShown) {
            popupHolder.showPopup(this);
        }
        else {
            popupHolder.clear();
        }
        globals.globals.rafScheduler.scheduleFullRedraw();
    }
    renderItem(item) {
        switch (item.itemType) {
            case 'regular':
                return mithril('button.open-menu', {
                    onclick: () => {
                        item.callback();
                        // Hide the menu item after the action has been invoked
                        this.setVisible(false);
                    },
                }, item.text);
            case 'group':
                const isExpanded = this.expandedGroups.has(item.itemId);
                return mithril('div', mithril('button.open-menu.disallow-selection', {
                    onclick: () => {
                        if (this.expandedGroups.has(item.itemId)) {
                            this.expandedGroups.delete(item.itemId);
                        }
                        else {
                            this.expandedGroups.add(item.itemId);
                        }
                        globals.globals.rafScheduler.scheduleFullRedraw();
                    },
                }, 
                // Show text with up/down arrow, depending on expanded state.
                item.text + (isExpanded ? ' \u25B2' : ' \u25BC')), isExpanded ? mithril('div.nested-menu', item.children.map((item) => this.renderItem(item))) :
                    null);
        }
    }
    view(vnode) {
        return mithril('.dropdown', mithril('i.material-icons', {
            onclick: () => {
                this.setVisible(!this.popupShown);
            },
        }, vnode.attrs.icon), mithril(this.popupShown ? '.popup-menu.opened' : '.popup-menu.closed', vnode.attrs.items.map((item) => this.renderItem(item))));
    }
}
exports.PopupMenuButton = PopupMenuButton;

});

var counter = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.activate = exports.COUNTER_TRACK_KIND = void 0;












exports.COUNTER_TRACK_KIND = 'CounterTrack';
class CounterTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.setup = false;
        this.maximumValueSeen = 0;
        this.minimumValueSeen = 0;
        this.maximumDeltaSeen = 0;
        this.minimumDeltaSeen = 0;
        this.maxDurNs = 0;
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            const pxSize = this.pxSize();
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolution * 1e9 * pxSize / 2) * 2, 1);
            if (!this.setup) {
                if (this.config.namespace === undefined) {
                    yield this.query(`
          create view ${this.tableName('counter_view')} as
          select
            id,
            ts,
            dur,
            value,
            delta
          from experimental_counter_dur
          where track_id = ${this.config.trackId};
        `);
                }
                else {
                    yield this.query(`
          create view ${this.tableName('counter_view')} as
          select
            id,
            ts,
            lead(ts, 1, ts) over (order by ts) - ts as dur,
            lead(value, 1, value) over (order by ts) - value as delta,
            value
          from ${this.namespaceTable('counter')}
          where track_id = ${this.config.trackId};
        `);
                }
                const maxDurResult = yield this.query(`
          select
            max(
              iif(dur != -1, dur, (select end_ts from trace_bounds) - ts)
            ) as maxDur
          from ${this.tableName('counter_view')}
      `);
                this.maxDurNs = maxDurResult.firstRow({ maxDur: query_result.NUM_NULL }).maxDur || 0;
                const queryRes = yield this.query(`
        select
          ifnull(max(value), 0) as maxValue,
          ifnull(min(value), 0) as minValue,
          ifnull(max(delta), 0) as maxDelta,
          ifnull(min(delta), 0) as minDelta
        from ${this.tableName('counter_view')}`);
                const row = queryRes.firstRow({ maxValue: query_result.NUM, minValue: query_result.NUM, maxDelta: query_result.NUM, minDelta: query_result.NUM });
                this.maximumValueSeen = row.maxValue;
                this.minimumValueSeen = row.minValue;
                this.maximumDeltaSeen = row.maxDelta;
                this.minimumDeltaSeen = row.minDelta;
                this.setup = true;
            }
            const queryRes = yield this.query(`
      select
        (ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as tsq,
        min(value) as minValue,
        max(value) as maxValue,
        sum(delta) as totalDelta,
        value_at_max_ts(ts, id) as lastId,
        value_at_max_ts(ts, value) as lastValue
      from ${this.tableName('counter_view')}
      where ts >= ${startNs - this.maxDurNs} and ts <= ${endNs}
      group by tsq
      order by tsq
    `);
            const numRows = queryRes.numRows();
            const data = {
                start,
                end,
                length: numRows,
                maximumValue: this.maximumValue(),
                minimumValue: this.minimumValue(),
                maximumDelta: this.maximumDeltaSeen,
                minimumDelta: this.minimumDeltaSeen,
                maximumRate: 0,
                minimumRate: 0,
                resolution,
                timestamps: new Float64Array(numRows),
                lastIds: new Float64Array(numRows),
                minValues: new Float64Array(numRows),
                maxValues: new Float64Array(numRows),
                lastValues: new Float64Array(numRows),
                totalDeltas: new Float64Array(numRows),
                rate: new Float64Array(numRows),
            };
            const it = queryRes.iter({
                'tsq': query_result.NUM,
                'lastId': query_result.NUM,
                'minValue': query_result.NUM,
                'maxValue': query_result.NUM,
                'lastValue': query_result.NUM,
                'totalDelta': query_result.NUM,
            });
            let lastValue = 0;
            let lastTs = 0;
            for (let row = 0; it.valid(); it.next(), row++) {
                const ts = (0, time.fromNs)(it.tsq);
                const value = it.lastValue;
                const rate = (value - lastValue) / (ts - lastTs);
                lastTs = ts;
                lastValue = value;
                data.timestamps[row] = ts;
                data.lastIds[row] = it.lastId;
                data.minValues[row] = it.minValue;
                data.maxValues[row] = it.maxValue;
                data.lastValues[row] = value;
                data.totalDeltas[row] = it.totalDelta;
                data.rate[row] = rate;
                if (row > 0) {
                    data.rate[row - 1] = rate;
                    data.maximumRate = Math.max(data.maximumRate, rate);
                    data.minimumRate = Math.min(data.minimumRate, rate);
                }
            }
            return data;
        });
    }
    maximumValue() {
        if (this.config.maximumValue === undefined) {
            return this.maximumValueSeen;
        }
        else {
            return this.config.maximumValue;
        }
    }
    minimumValue() {
        if (this.config.minimumValue === undefined) {
            return this.minimumValueSeen;
        }
        else {
            return this.config.minimumValue;
        }
    }
}
CounterTrackController.kind = exports.COUNTER_TRACK_KIND;
// 0.5 Makes the horizontal lines sharp.
const MARGIN_TOP = 3.5;
const RECT_HEIGHT = 24.5;
class CounterTrack extends track.Track {
    constructor(args) {
        super(args);
        this.mousePos = { x: 0, y: 0 };
        this.hoveredValue = undefined;
        this.hoveredTs = undefined;
        this.hoveredTsEnd = undefined;
    }
    static create(args) {
        return new CounterTrack(args);
    }
    getHeight() {
        return MARGIN_TOP + RECT_HEIGHT;
    }
    getContextMenu() {
        const currentScale = this.config.scale;
        const scales = [
            { name: 'ZERO_BASED', humanName: 'Zero based' },
            { name: 'MIN_MAX', humanName: 'Min/Max' },
            { name: 'DELTA_FROM_PREVIOUS', humanName: 'Delta' },
            { name: 'RATE', humanName: 'Rate' },
        ];
        const items = [];
        for (const scale of scales) {
            let text;
            if (currentScale === scale.name) {
                text = `*${scale.humanName}*`;
            }
            else {
                text = scale.humanName;
            }
            items.push({
                itemType: 'regular',
                text,
                callback: () => {
                    this.config.scale = scale.name;
                    actions.Actions.updateTrackConfig({
                        id: this.trackState.id,
                        config: this.config,
                    });
                },
            });
        }
        return mithril(popup_menu.PopupMenuButton, {
            icon: 'show_chart',
            items,
        });
    }
    renderCanvas(ctx) {
        // TODO: fonts and colors should come from the CSS and not hardcoded here.
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const data = this.data();
        // Can't possibly draw anything.
        if (data === undefined || data.timestamps.length === 0) {
            return;
        }
        (0, logging.assertTrue)(data.timestamps.length === data.minValues.length);
        (0, logging.assertTrue)(data.timestamps.length === data.maxValues.length);
        (0, logging.assertTrue)(data.timestamps.length === data.lastValues.length);
        (0, logging.assertTrue)(data.timestamps.length === data.totalDeltas.length);
        (0, logging.assertTrue)(data.timestamps.length === data.rate.length);
        const scale = this.config.scale || 'ZERO_BASED';
        let minValues = data.minValues;
        let maxValues = data.maxValues;
        let lastValues = data.lastValues;
        let maximumValue = data.maximumValue;
        let minimumValue = data.minimumValue;
        if (scale === 'DELTA_FROM_PREVIOUS') {
            lastValues = data.totalDeltas;
            minValues = data.totalDeltas;
            maxValues = data.totalDeltas;
            maximumValue = data.maximumDelta;
            minimumValue = data.minimumDelta;
        }
        if (scale === 'RATE') {
            lastValues = data.rate;
            minValues = data.rate;
            maxValues = data.rate;
            maximumValue = data.maximumRate;
            minimumValue = data.minimumRate;
        }
        const endPx = Math.floor(timeScale.timeToPx(visibleWindowTime.end));
        const zeroY = MARGIN_TOP + RECT_HEIGHT / (minimumValue < 0 ? 2 : 1);
        // Quantize the Y axis to quarters of powers of tens (7.5K, 10K, 12.5K).
        const maxValue = Math.max(maximumValue, 0);
        let yMax = Math.max(Math.abs(minimumValue), maxValue);
        const kUnits = ['', 'K', 'M', 'G', 'T', 'E'];
        const exp = Math.ceil(Math.log10(Math.max(yMax, 1)));
        const pow10 = Math.pow(10, exp);
        yMax = Math.ceil(yMax / (pow10 / 4)) * (pow10 / 4);
        let yRange = 0;
        const unitGroup = Math.floor(exp / 3);
        let yMin = 0;
        let yLabel = '';
        if (scale === 'MIN_MAX') {
            yRange = maximumValue - minimumValue;
            yMin = minimumValue;
            yLabel = 'min - max';
        }
        else {
            yRange = minimumValue < 0 ? yMax * 2 : yMax;
            yMin = minimumValue < 0 ? -yMax : 0;
            yLabel = `${yMax / Math.pow(10, unitGroup * 3)} ${kUnits[unitGroup]}`;
            if (scale === 'DELTA_FROM_PREVIOUS') {
                yLabel += '\u0394';
            }
            else if (scale === 'RATE') {
                yLabel += '\u0394/t';
            }
        }
        // There are 360deg of hue. We want a scale that starts at green with
        // exp <= 3 (<= 1KB), goes orange around exp = 6 (~1MB) and red/violet
        // around exp >= 9 (1GB).
        // The hue scale looks like this:
        // 0                              180                                 360
        // Red        orange         green | blue         purple          magenta
        // So we want to start @ 180deg with pow=0, go down to 0deg and then wrap
        // back from 360deg back to 180deg.
        const expCapped = Math.min(Math.max(exp - 3), 9);
        const hue = (180 - Math.floor(expCapped * (180 / 6)) + 360) % 360;
        ctx.fillStyle = `hsl(${hue}, 45%, 75%)`;
        ctx.strokeStyle = `hsl(${hue}, 45%, 45%)`;
        const calculateX = (ts) => {
            return Math.floor(timeScale.timeToPx(ts));
        };
        const calculateY = (value) => {
            return MARGIN_TOP + RECT_HEIGHT -
                Math.round(((value - yMin) / yRange) * RECT_HEIGHT);
        };
        ctx.beginPath();
        ctx.moveTo(calculateX(data.timestamps[0]), zeroY);
        let lastDrawnY = zeroY;
        for (let i = 0; i < data.timestamps.length; i++) {
            const x = calculateX(data.timestamps[i]);
            const minY = calculateY(minValues[i]);
            const maxY = calculateY(maxValues[i]);
            const lastY = calculateY(lastValues[i]);
            ctx.lineTo(x, lastDrawnY);
            if (minY === maxY) {
                (0, logging.assertTrue)(lastY === minY);
                ctx.lineTo(x, lastY);
            }
            else {
                ctx.lineTo(x, minY);
                ctx.lineTo(x, maxY);
                ctx.lineTo(x, lastY);
            }
            lastDrawnY = lastY;
        }
        ctx.lineTo(endPx, lastDrawnY);
        ctx.lineTo(endPx, zeroY);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        // Draw the Y=0 dashed line.
        ctx.strokeStyle = `hsl(${hue}, 10%, 71%)`;
        ctx.beginPath();
        ctx.setLineDash([2, 4]);
        ctx.moveTo(0, zeroY);
        ctx.lineTo(endPx, zeroY);
        ctx.closePath();
        ctx.stroke();
        ctx.setLineDash([]);
        ctx.font = '10px Roboto Condensed';
        if (this.hoveredValue !== undefined && this.hoveredTs !== undefined) {
            // TODO(hjd): Add units.
            let text;
            if (scale === 'DELTA_FROM_PREVIOUS') {
                text = 'delta: ';
            }
            else if (scale === 'RATE') {
                text = 'delta/t: ';
            }
            else {
                text = 'value: ';
            }
            text += `${this.hoveredValue.toLocaleString()}`;
            ctx.fillStyle = `hsl(${hue}, 45%, 75%)`;
            ctx.strokeStyle = `hsl(${hue}, 45%, 45%)`;
            const xStart = Math.floor(timeScale.timeToPx(this.hoveredTs));
            const xEnd = this.hoveredTsEnd === undefined ?
                endPx :
                Math.floor(timeScale.timeToPx(this.hoveredTsEnd));
            const y = MARGIN_TOP + RECT_HEIGHT -
                Math.round(((this.hoveredValue - yMin) / yRange) * RECT_HEIGHT);
            // Highlight line.
            ctx.beginPath();
            ctx.moveTo(xStart, y);
            ctx.lineTo(xEnd, y);
            ctx.lineWidth = 3;
            ctx.stroke();
            ctx.lineWidth = 1;
            // Draw change marker.
            ctx.beginPath();
            ctx.arc(xStart, y, 3 /* r*/, 0 /* start angle*/, 2 * Math.PI /* end angle*/);
            ctx.fill();
            ctx.stroke();
            // Draw the tooltip.
            this.drawTrackHoverTooltip(ctx, this.mousePos, text);
        }
        // Write the Y scale on the top left corner.
        ctx.fillStyle = 'rgba(255, 255, 255, 0.6)';
        ctx.fillRect(0, 0, 42, 16);
        ctx.fillStyle = '#666';
        ctx.textAlign = 'left';
        ctx.textBaseline = 'alphabetic';
        ctx.fillText(`${yLabel}`, 5, 14);
        // TODO(hjd): Refactor this into checkerboardExcept
        {
            const endPx = timeScale.timeToPx(visibleWindowTime.end);
            const counterEndPx = Math.min(timeScale.timeToPx(this.config.endTs || Infinity), endPx);
            // Grey out RHS.
            if (counterEndPx < endPx) {
                ctx.fillStyle = '#0000001f';
                ctx.fillRect(counterEndPx, 0, endPx - counterEndPx, this.getHeight());
            }
        }
        // If the cached trace slices don't fully cover the visible time range,
        // show a gray rectangle with a "Loading..." label.
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), timeScale.timeToPx(visibleWindowTime.start), timeScale.timeToPx(visibleWindowTime.end), timeScale.timeToPx(data.start), timeScale.timeToPx(data.end));
    }
    onMouseMove(pos) {
        const data = this.data();
        if (data === undefined)
            return;
        this.mousePos = pos;
        const { timeScale } = globals.globals.frontendLocalState;
        const time = timeScale.pxToTime(pos.x);
        const values = this.config.scale === 'DELTA_FROM_PREVIOUS' ?
            data.totalDeltas :
            data.lastValues;
        const [left, right] = (0, binary_search.searchSegment)(data.timestamps, time);
        this.hoveredTs = left === -1 ? undefined : data.timestamps[left];
        this.hoveredTsEnd = right === -1 ? undefined : data.timestamps[right];
        this.hoveredValue = left === -1 ? undefined : values[left];
    }
    onMouseOut() {
        this.hoveredValue = undefined;
        this.hoveredTs = undefined;
    }
    onMouseClick({ x }) {
        const data = this.data();
        if (data === undefined)
            return false;
        const { timeScale } = globals.globals.frontendLocalState;
        const time$1 = timeScale.pxToTime(x);
        const [left, right] = (0, binary_search.searchSegment)(data.timestamps, time$1);
        if (left === -1) {
            return false;
        }
        else {
            const counterId = data.lastIds[left];
            if (counterId === -1)
                return true;
            globals.globals.makeSelection(actions.Actions.selectCounter({
                leftTs: (0, time.toNs)(data.timestamps[left]),
                rightTs: right !== -1 ? (0, time.toNs)(data.timestamps[right]) : -1,
                id: counterId,
                trackId: this.trackState.id,
            }));
            return true;
        }
    }
}
CounterTrack.kind = exports.COUNTER_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(CounterTrackController);
    ctx.registerTrack(CounterTrack);
}
exports.activate = activate;
exports.plugin = {
    pluginId: 'perfetto.Counter',
    activate,
};

});

var cpu_freq = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.CPU_FREQ_TRACK_KIND = void 0;










exports.CPU_FREQ_TRACK_KIND = 'CpuFreqTrack';
class CpuFreqTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.maxDurNs = 0;
        this.maxTsEndNs = 0;
        this.maximumValueSeen = 0;
        this.cachedBucketNs = Number.MAX_SAFE_INTEGER;
    }
    onSetup() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.createFreqIdleViews();
            this.maximumValueSeen = yield this.queryMaxFrequency();
            this.maxDurNs = yield this.queryMaxSourceDur();
            const iter = (yield this.query(`
      select max(ts) as maxTs, dur, count(1) as rowCount
      from ${this.tableName('freq_idle')}
    `)).firstRow({ maxTs: query_result.NUM_NULL, dur: query_result.NUM_NULL, rowCount: query_result.NUM });
            if (iter.maxTs === null || iter.dur === null) {
                // We shoulnd't really hit this because trackDecider shouldn't create
                // the track in the first place if there are no entries. But could happen
                // if only one cpu has no cpufreq data.
                return;
            }
            this.maxTsEndNs = iter.maxTs + iter.dur;
            const rowCount = iter.rowCount;
            const bucketNs = this.cachedBucketSizeNs(rowCount);
            if (bucketNs === undefined) {
                return;
            }
            yield this.query(`
      create table ${this.tableName('freq_idle_cached')} as
      select
        (ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as cachedTsq,
        min(freqValue) as minFreq,
        max(freqValue) as maxFreq,
        value_at_max_ts(ts, freqValue) as lastFreq,
        value_at_max_ts(ts, idleValue) as lastIdleValue
      from ${this.tableName('freq_idle')}
      group by cachedTsq
      order by cachedTsq
    `);
            this.cachedBucketNs = bucketNs;
        });
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            // The resolution should always be a power of two for the logic of this
            // function to make sense.
            const resolutionNs = (0, time.toNs)(resolution);
            (0, logging.assertTrue)(Math.log2(resolutionNs) % 1 === 0);
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolutionNs * this.pxSize() / 2) * 2, 1);
            const freqResult = yield this.queryData(startNs, endNs, bucketNs);
            (0, logging.assertTrue)(freqResult.isComplete());
            const numRows = freqResult.numRows();
            const data = {
                start,
                end,
                resolution,
                length: numRows,
                maximumValue: this.maximumValue(),
                maxTsEnd: this.maxTsEndNs,
                timestamps: new Float64Array(numRows),
                minFreqKHz: new Uint32Array(numRows),
                maxFreqKHz: new Uint32Array(numRows),
                lastFreqKHz: new Uint32Array(numRows),
                lastIdleValues: new Int8Array(numRows),
            };
            const it = freqResult.iter({
                'tsq': query_result.NUM,
                'minFreq': query_result.NUM,
                'maxFreq': query_result.NUM,
                'lastFreq': query_result.NUM,
                'lastIdleValue': query_result.NUM,
            });
            for (let i = 0; it.valid(); ++i, it.next()) {
                data.timestamps[i] = (0, time.fromNs)(it.tsq);
                data.minFreqKHz[i] = it.minFreq;
                data.maxFreqKHz[i] = it.maxFreq;
                data.lastFreqKHz[i] = it.lastFreq;
                data.lastIdleValues[i] = it.lastIdleValue;
            }
            return data;
        });
    }
    queryData(startNs, endNs, bucketNs) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const isCached = this.cachedBucketNs <= bucketNs;
            if (isCached) {
                return this.query(`
        select
          cachedTsq / ${bucketNs} * ${bucketNs} as tsq,
          min(minFreq) as minFreq,
          max(maxFreq) as maxFreq,
          value_at_max_ts(cachedTsq, lastFreq) as lastFreq,
          value_at_max_ts(cachedTsq, lastIdleValue) as lastIdleValue
        from ${this.tableName('freq_idle_cached')}
        where
          cachedTsq >= ${startNs - this.maxDurNs} and
          cachedTsq <= ${endNs}
        group by tsq
        order by tsq
      `);
            }
            const minTsFreq = yield this.query(`
      select ifnull(max(ts), 0) as minTs from ${this.tableName('freq')}
      where ts < ${startNs}
    `);
            let minTs = minTsFreq.iter({ minTs: query_result.NUM }).minTs;
            if (this.config.idleTrackId !== undefined) {
                const minTsIdle = yield this.query(`
        select ifnull(max(ts), 0) as minTs from ${this.tableName('idle')}
        where ts < ${startNs}
      `);
                minTs = Math.min(minTsIdle.iter({ minTs: query_result.NUM }).minTs, minTs);
            }
            const geqConstraint = this.config.idleTrackId === undefined ?
                `ts >= ${minTs}` :
                `source_geq(ts, ${minTs})`;
            return this.query(`
      select
        (ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as tsq,
        min(freqValue) as minFreq,
        max(freqValue) as maxFreq,
        value_at_max_ts(ts, freqValue) as lastFreq,
        value_at_max_ts(ts, idleValue) as lastIdleValue
      from ${this.tableName('freq_idle')}
      where
        ${geqConstraint} and
        ts <= ${endNs}
      group by tsq
      order by tsq
    `);
        });
    }
    queryMaxFrequency() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const result = yield this.query(`
      select max(freqValue) as maxFreq
      from ${this.tableName('freq')}
    `);
            return result.firstRow({ 'maxFreq': query_result.NUM_NULL }).maxFreq || 0;
        });
    }
    queryMaxSourceDur() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const maxDurFreqResult = yield this.query(`select ifnull(max(dur), 0) as maxDur from ${this.tableName('freq')}`);
            const maxDurNs = maxDurFreqResult.firstRow({ 'maxDur': query_result.NUM }).maxDur;
            if (this.config.idleTrackId === undefined) {
                return maxDurNs;
            }
            const maxDurIdleResult = yield this.query(`select ifnull(max(dur), 0) as maxDur from ${this.tableName('idle')}`);
            return Math.max(maxDurNs, maxDurIdleResult.firstRow({ maxDur: query_result.NUM }).maxDur);
        });
    }
    createFreqIdleViews() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.query(`create view ${this.tableName('freq')} as
      select
        ts,
        dur,
        value as freqValue
      from experimental_counter_dur c
      where track_id = ${this.config.freqTrackId};
    `);
            if (this.config.idleTrackId === undefined) {
                yield this.query(`create view ${this.tableName('freq_idle')} as
        select
          ts,
          dur,
          -1 as idleValue,
          freqValue
        from ${this.tableName('freq')};
      `);
                return;
            }
            yield this.query(`
      create view ${this.tableName('idle')} as
      select
        ts,
        dur,
        iif(value = 4294967295, -1, cast(value as int)) as idleValue
      from experimental_counter_dur c
      where track_id = ${this.config.idleTrackId};
    `);
            yield this.query(`
      create virtual table ${this.tableName('freq_idle')}
      using span_join(${this.tableName('freq')}, ${this.tableName('idle')});
    `);
        });
    }
    maximumValue() {
        return Math.max(this.config.maximumValue || 0, this.maximumValueSeen);
    }
}
CpuFreqTrackController.kind = exports.CPU_FREQ_TRACK_KIND;
// 0.5 Makes the horizontal lines sharp.
const MARGIN_TOP = 4.5;
const RECT_HEIGHT = 20;
class CpuFreqTrack extends track.Track {
    constructor(args) {
        super(args);
        this.mousePos = { x: 0, y: 0 };
        this.hoveredValue = undefined;
        this.hoveredTs = undefined;
        this.hoveredTsEnd = undefined;
        this.hoveredIdle = undefined;
    }
    static create(args) {
        return new CpuFreqTrack(args);
    }
    getHeight() {
        return MARGIN_TOP + RECT_HEIGHT;
    }
    renderCanvas(ctx) {
        // TODO: fonts and colors should come from the CSS and not hardcoded here.
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined || data.timestamps.length === 0) {
            // Can't possibly draw anything.
            return;
        }
        (0, logging.assertTrue)(data.timestamps.length === data.lastFreqKHz.length);
        (0, logging.assertTrue)(data.timestamps.length === data.minFreqKHz.length);
        (0, logging.assertTrue)(data.timestamps.length === data.maxFreqKHz.length);
        (0, logging.assertTrue)(data.timestamps.length === data.lastIdleValues.length);
        const endPx = timeScale.timeToPx(visibleWindowTime.end);
        const zeroY = MARGIN_TOP + RECT_HEIGHT;
        // Quantize the Y axis to quarters of powers of tens (7.5K, 10K, 12.5K).
        let yMax = data.maximumValue;
        const kUnits = ['', 'K', 'M', 'G', 'T', 'E'];
        const exp = Math.ceil(Math.log10(Math.max(yMax, 1)));
        const pow10 = Math.pow(10, exp);
        yMax = Math.ceil(yMax / (pow10 / 4)) * (pow10 / 4);
        const unitGroup = Math.floor(exp / 3);
        const num = yMax / Math.pow(10, unitGroup * 3);
        // The values we have for cpufreq are in kHz so +1 to unitGroup.
        const yLabel = `${num} ${kUnits[unitGroup + 1]}Hz`;
        // Draw the CPU frequency graph.
        const hue = (0, colorizer.hueForCpu)(this.config.cpu);
        let saturation = 45;
        if (globals.globals.state.hoveredUtid !== -1) {
            saturation = 0;
        }
        ctx.fillStyle = `hsl(${hue}, ${saturation}%, 70%)`;
        ctx.strokeStyle = `hsl(${hue}, ${saturation}%, 55%)`;
        const calculateX = (timestamp) => {
            return Math.floor(timeScale.timeToPx(timestamp));
        };
        const calculateY = (value) => {
            return zeroY - Math.round((value / yMax) * RECT_HEIGHT);
        };
        const [rawStartIdx] = (0, binary_search.searchSegment)(data.timestamps, visibleWindowTime.start);
        const startIdx = rawStartIdx === -1 ? 0 : rawStartIdx;
        const [, rawEndIdx] = (0, binary_search.searchSegment)(data.timestamps, visibleWindowTime.end);
        const endIdx = rawEndIdx === -1 ? data.timestamps.length : rawEndIdx;
        ctx.beginPath();
        ctx.moveTo(Math.max(calculateX(data.timestamps[startIdx]), 0), zeroY);
        let lastDrawnY = zeroY;
        for (let i = startIdx; i < endIdx; i++) {
            const x = calculateX(data.timestamps[i]);
            const minY = calculateY(data.minFreqKHz[i]);
            const maxY = calculateY(data.maxFreqKHz[i]);
            const lastY = calculateY(data.lastFreqKHz[i]);
            ctx.lineTo(x, lastDrawnY);
            if (minY === maxY) {
                (0, logging.assertTrue)(lastY === minY);
                ctx.lineTo(x, lastY);
            }
            else {
                ctx.lineTo(x, minY);
                ctx.lineTo(x, maxY);
                ctx.lineTo(x, lastY);
            }
            lastDrawnY = lastY;
        }
        // Find the end time for the last frequency event and then draw
        // down to zero to show that we do not have data after that point.
        const finalX = Math.min(calculateX(data.maxTsEnd), endPx);
        ctx.lineTo(finalX, lastDrawnY);
        ctx.lineTo(finalX, zeroY);
        ctx.lineTo(endPx, zeroY);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
        // Draw CPU idle rectangles that overlay the CPU freq graph.
        ctx.fillStyle = `rgba(240, 240, 240, 1)`;
        for (let i = 0; i < data.lastIdleValues.length; i++) {
            if (data.lastIdleValues[i] < 0) {
                continue;
            }
            // We intentionally don't use the floor function here when computing x
            // coordinates. Instead we use floating point which prevents flickering as
            // we pan and zoom; this relies on the browser anti-aliasing pixels
            // correctly.
            const x = timeScale.timeToPx(data.timestamps[i]);
            const xEnd = i === data.lastIdleValues.length - 1 ?
                finalX :
                timeScale.timeToPx(data.timestamps[i + 1]);
            const width = xEnd - x;
            const height = calculateY(data.lastFreqKHz[i]) - zeroY;
            ctx.fillRect(x, zeroY, width, height);
        }
        ctx.font = '10px Roboto Condensed';
        if (this.hoveredValue !== undefined && this.hoveredTs !== undefined) {
            let text = `${this.hoveredValue.toLocaleString()}kHz`;
            ctx.fillStyle = `hsl(${hue}, 45%, 75%)`;
            ctx.strokeStyle = `hsl(${hue}, 45%, 45%)`;
            const xStart = Math.floor(timeScale.timeToPx(this.hoveredTs));
            const xEnd = this.hoveredTsEnd === undefined ?
                endPx :
                Math.floor(timeScale.timeToPx(this.hoveredTsEnd));
            const y = zeroY - Math.round((this.hoveredValue / yMax) * RECT_HEIGHT);
            // Highlight line.
            ctx.beginPath();
            ctx.moveTo(xStart, y);
            ctx.lineTo(xEnd, y);
            ctx.lineWidth = 3;
            ctx.stroke();
            ctx.lineWidth = 1;
            // Draw change marker.
            ctx.beginPath();
            ctx.arc(xStart, y, 3 /* r*/, 0 /* start angle*/, 2 * Math.PI /* end angle*/);
            ctx.fill();
            ctx.stroke();
            // Display idle value if current hover is idle.
            if (this.hoveredIdle !== undefined && this.hoveredIdle !== -1) {
                // Display the idle value +1 to be consistent with catapult.
                text += ` (Idle: ${(this.hoveredIdle + 1).toLocaleString()})`;
            }
            // Draw the tooltip.
            this.drawTrackHoverTooltip(ctx, this.mousePos, text);
        }
        // Write the Y scale on the top left corner.
        ctx.textBaseline = 'alphabetic';
        ctx.fillStyle = 'rgba(255, 255, 255, 0.6)';
        ctx.fillRect(0, 0, 42, 18);
        ctx.fillStyle = '#666';
        ctx.textAlign = 'left';
        ctx.fillText(`${yLabel}`, 4, 14);
        // If the cached trace slices don't fully cover the visible time range,
        // show a gray rectangle with a "Loading..." label.
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), timeScale.timeToPx(visibleWindowTime.start), timeScale.timeToPx(visibleWindowTime.end), timeScale.timeToPx(data.start), timeScale.timeToPx(data.end));
    }
    onMouseMove(pos) {
        const data = this.data();
        if (data === undefined)
            return;
        this.mousePos = pos;
        const { timeScale } = globals.globals.frontendLocalState;
        const time = timeScale.pxToTime(pos.x);
        const [left, right] = (0, binary_search.searchSegment)(data.timestamps, time);
        this.hoveredTs = left === -1 ? undefined : data.timestamps[left];
        this.hoveredTsEnd = right === -1 ? undefined : data.timestamps[right];
        this.hoveredValue = left === -1 ? undefined : data.lastFreqKHz[left];
        this.hoveredIdle = left === -1 ? undefined : data.lastIdleValues[left];
    }
    onMouseOut() {
        this.hoveredValue = undefined;
        this.hoveredTs = undefined;
        this.hoveredTsEnd = undefined;
        this.hoveredIdle = undefined;
    }
}
CpuFreqTrack.kind = exports.CPU_FREQ_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(CpuFreqTrackController);
    ctx.registerTrack(CpuFreqTrack);
}
exports.plugin = {
    pluginId: 'perfetto.CpuFreq',
    activate,
};

});

var cpu_profile = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.CPU_PROFILE_TRACK_KIND = void 0;










const BAR_HEIGHT = 3;
const MARGIN_TOP = 4.5;
const RECT_HEIGHT = 30.5;
exports.CPU_PROFILE_TRACK_KIND = 'CpuProfileTrack';
class CpuProfileTrackController extends track_controller.TrackController {
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const query = `select
        id,
        ts,
        callsite_id as callsiteId
      from cpu_profile_stack_sample
      where utid = ${this.config.utid}
      order by ts`;
            const result = yield this.query(query);
            const numRows = result.numRows();
            const data = {
                start,
                end,
                resolution,
                length: numRows,
                ids: new Float64Array(numRows),
                tsStarts: new Float64Array(numRows),
                callsiteId: new Uint32Array(numRows),
            };
            const it = result.iter({ id: query_result.NUM, ts: query_result.NUM, callsiteId: query_result.NUM });
            for (let row = 0; it.valid(); it.next(), ++row) {
                data.ids[row] = it.id;
                data.tsStarts[row] = it.ts;
                data.callsiteId[row] = it.callsiteId;
            }
            return data;
        });
    }
}
CpuProfileTrackController.kind = exports.CPU_PROFILE_TRACK_KIND;
function colorForSample(callsiteId, isHovered) {
    const [hue, saturation, lightness] = (0, colorizer.hslForSlice)(String(callsiteId), isHovered);
    return (0, hsluv_cache.cachedHsluvToHex)(hue, saturation, lightness);
}
class CpuProfileTrack extends track.Track {
    constructor(args) {
        super(args);
        this.centerY = this.getHeight() / 2 + BAR_HEIGHT;
        this.markerWidth = (this.getHeight() - MARGIN_TOP - BAR_HEIGHT) / 2;
        this.hoveredTs = undefined;
    }
    static create(args) {
        return new CpuProfileTrack(args);
    }
    getHeight() {
        return MARGIN_TOP + RECT_HEIGHT - 1;
    }
    renderCanvas(ctx) {
        const { timeScale, } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined)
            return;
        for (let i = 0; i < data.tsStarts.length; i++) {
            const centerX = data.tsStarts[i];
            const selection = globals.globals.state.currentSelection;
            const isHovered = this.hoveredTs === centerX;
            const isSelected = selection !== null &&
                selection.kind === 'CPU_PROFILE_SAMPLE' && selection.ts === centerX;
            const strokeWidth = isSelected ? 3 : 0;
            this.drawMarker(ctx, timeScale.timeToPx((0, time.fromNs)(centerX)), this.centerY, isHovered, strokeWidth, data.callsiteId[i]);
        }
        // Group together identical identical CPU profile samples by connecting them
        // with an horizontal bar.
        let clusterStartIndex = 0;
        while (clusterStartIndex < data.tsStarts.length) {
            const callsiteId = data.callsiteId[clusterStartIndex];
            // Find the end of the cluster by searching for the next different CPU
            // sample. The resulting range [clusterStartIndex, clusterEndIndex] is
            // inclusive and within array bounds.
            let clusterEndIndex = clusterStartIndex;
            while (clusterEndIndex + 1 < data.tsStarts.length &&
                data.callsiteId[clusterEndIndex] === callsiteId) {
                clusterEndIndex++;
            }
            // If there are multiple CPU samples in the cluster, draw a line.
            if (clusterStartIndex !== clusterEndIndex) {
                const startX = data.tsStarts[clusterStartIndex];
                const endX = data.tsStarts[clusterEndIndex];
                const leftPx = timeScale.timeToPx((0, time.fromNs)(startX)) - this.markerWidth;
                const rightPx = timeScale.timeToPx((0, time.fromNs)(endX)) + this.markerWidth;
                const width = rightPx - leftPx;
                ctx.fillStyle = colorForSample(callsiteId, false);
                ctx.fillRect(leftPx, MARGIN_TOP, width, BAR_HEIGHT);
            }
            // Move to the next cluster.
            clusterStartIndex = clusterEndIndex + 1;
        }
    }
    drawMarker(ctx, x, y, isHovered, strokeWidth, callsiteId) {
        ctx.beginPath();
        ctx.moveTo(x - this.markerWidth, y - this.markerWidth);
        ctx.lineTo(x, y + this.markerWidth);
        ctx.lineTo(x + this.markerWidth, y - this.markerWidth);
        ctx.lineTo(x - this.markerWidth, y - this.markerWidth);
        ctx.closePath();
        ctx.fillStyle = colorForSample(callsiteId, isHovered);
        ctx.fill();
        if (strokeWidth > 0) {
            ctx.strokeStyle = colorForSample(callsiteId, false);
            ctx.lineWidth = strokeWidth;
            ctx.stroke();
        }
    }
    onMouseMove({ x, y }) {
        const data = this.data();
        if (data === undefined)
            return;
        const { timeScale } = globals.globals.frontendLocalState;
        const time$1 = (0, time.toNs)(timeScale.pxToTime(x));
        const [left, right] = (0, binary_search.searchSegment)(data.tsStarts, time$1);
        const index = this.findTimestampIndex(left, timeScale, data, x, y, right);
        this.hoveredTs = index === -1 ? undefined : data.tsStarts[index];
    }
    onMouseOut() {
        this.hoveredTs = undefined;
    }
    onMouseClick({ x, y }) {
        const data = this.data();
        if (data === undefined)
            return false;
        const { timeScale } = globals.globals.frontendLocalState;
        const time$1 = (0, time.toNs)(timeScale.pxToTime(x));
        const [left, right] = (0, binary_search.searchSegment)(data.tsStarts, time$1);
        const index = this.findTimestampIndex(left, timeScale, data, x, y, right);
        if (index !== -1) {
            const id = data.ids[index];
            const ts = data.tsStarts[index];
            globals.globals.makeSelection(actions.Actions.selectCpuProfileSample({ id, utid: this.config.utid, ts }));
            return true;
        }
        return false;
    }
    // If the markers overlap the rightmost one will be selected.
    findTimestampIndex(left, timeScale, data, x, y, right) {
        let index = -1;
        if (left !== -1) {
            const centerX = timeScale.timeToPx((0, time.fromNs)(data.tsStarts[left]));
            if (this.isInMarker(x, y, centerX)) {
                index = left;
            }
        }
        if (right !== -1) {
            const centerX = timeScale.timeToPx((0, time.fromNs)(data.tsStarts[right]));
            if (this.isInMarker(x, y, centerX)) {
                index = right;
            }
        }
        return index;
    }
    isInMarker(x, y, centerX) {
        return Math.abs(x - centerX) + Math.abs(y - this.centerY) <=
            this.markerWidth;
    }
}
CpuProfileTrack.kind = exports.CPU_PROFILE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(CpuProfileTrackController);
    ctx.registerTrack(CpuProfileTrack);
}
exports.plugin = {
    pluginId: 'perfetto.CpuProfile',
    activate,
};

});

var cpu_slices = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.CPU_SLICE_TRACK_KIND = void 0;












exports.CPU_SLICE_TRACK_KIND = 'CpuSliceTrack';
class CpuSliceTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.cachedBucketNs = Number.MAX_SAFE_INTEGER;
        this.maxDurNs = 0;
        this.lastRowId = -1;
    }
    onSetup() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.query(`
      create view ${this.tableName('sched')} as
      select
        ts,
        dur,
        utid,
        id,
        dur = -1 as isIncomplete
      from sched
      where cpu = ${this.config.cpu} and utid != 0
    `);
            const queryRes = yield this.query(`
      select ifnull(max(dur), 0) as maxDur, count(1) as rowCount
      from ${this.tableName('sched')}
    `);
            const queryLastSlice = yield this.query(`
    select max(id) as lastSliceId from ${this.tableName('sched')}
    `);
            this.lastRowId = queryLastSlice.firstRow({ lastSliceId: query_result.NUM }).lastSliceId;
            const row = queryRes.firstRow({ maxDur: query_result.NUM, rowCount: query_result.NUM });
            this.maxDurNs = row.maxDur;
            const rowCount = row.rowCount;
            const bucketNs = this.cachedBucketSizeNs(rowCount);
            if (bucketNs === undefined) {
                return;
            }
            yield this.query(`
      create table ${this.tableName('sched_cached')} as
      select
        (ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as cached_tsq,
        ts,
        max(dur) as dur,
        utid,
        id,
        isIncomplete
      from ${this.tableName('sched')}
      group by cached_tsq, isIncomplete
      order by cached_tsq
    `);
            this.cachedBucketNs = bucketNs;
        });
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const resolutionNs = (0, time.toNs)(resolution);
            // The resolution should always be a power of two for the logic of this
            // function to make sense.
            (0, logging.assertTrue)(Math.log2(resolutionNs) % 1 === 0);
            const boundStartNs = (0, time.toNs)(start);
            const boundEndNs = (0, time.toNs)(end);
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolutionNs * this.pxSize() / 2) * 2, 1);
            const isCached = this.cachedBucketNs <= bucketNs;
            const queryTsq = isCached ?
                `cached_tsq / ${bucketNs} * ${bucketNs}` :
                `(ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs}`;
            const queryTable = isCached ? this.tableName('sched_cached') : this.tableName('sched');
            const constraintColumn = isCached ? 'cached_tsq' : 'ts';
            const queryRes = yield this.query(`
      select
        ${queryTsq} as tsq,
        ts,
        max(dur) as dur,
        utid,
        id,
        isIncomplete
      from ${queryTable}
      where
        ${constraintColumn} >= ${boundStartNs - this.maxDurNs} and
        ${constraintColumn} <= ${boundEndNs}
      group by tsq, isIncomplete
      order by tsq
    `);
            const numRows = queryRes.numRows();
            const slices = {
                start,
                end,
                resolution,
                length: numRows,
                lastRowId: this.lastRowId,
                ids: new Float64Array(numRows),
                starts: new Float64Array(numRows),
                ends: new Float64Array(numRows),
                utids: new Uint32Array(numRows),
                isIncomplete: new Uint8Array(numRows),
            };
            const it = queryRes.iter({ tsq: query_result.NUM, ts: query_result.NUM, dur: query_result.NUM, utid: query_result.NUM, id: query_result.NUM, isIncomplete: query_result.NUM });
            for (let row = 0; it.valid(); it.next(), row++) {
                const startNsQ = it.tsq;
                const startNs = it.ts;
                const durNs = it.dur;
                const endNs = startNs + durNs;
                // If the slice is incomplete, the end calculated later.
                if (!it.isIncomplete) {
                    let endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
                    endNsQ = Math.max(endNsQ, startNsQ + bucketNs);
                    slices.ends[row] = (0, time.fromNs)(endNsQ);
                }
                slices.starts[row] = (0, time.fromNs)(startNsQ);
                slices.utids[row] = it.utid;
                slices.ids[row] = it.id;
                slices.isIncomplete[row] = it.isIncomplete;
            }
            // If the slice is incomplete and it is the last slice in the track, the end
            // of the slice would be the end of the visible window. Otherwise we end the
            // slice with the beginning the next one.
            for (let row = 0; row < slices.length; row++) {
                if (!slices.isIncomplete[row]) {
                    continue;
                }
                const endNs = row === slices.length - 1 ? boundEndNs : (0, time.toNs)(slices.starts[row + 1]);
                let endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
                endNsQ = Math.max(endNsQ, (0, time.toNs)(slices.starts[row]) + bucketNs);
                slices.ends[row] = (0, time.fromNs)(endNsQ);
            }
            return slices;
        });
    }
    onDestroy() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.query(`drop table if exists ${this.tableName('sched_cached')}`);
        });
    }
}
CpuSliceTrackController.kind = exports.CPU_SLICE_TRACK_KIND;
const MARGIN_TOP = 3;
const RECT_HEIGHT = 24;
const TRACK_HEIGHT = MARGIN_TOP * 2 + RECT_HEIGHT;
class CpuSliceTrack extends track.Track {
    constructor(args) {
        super(args);
        this.utidHoveredInThisTrack = -1;
    }
    static create(args) {
        return new CpuSliceTrack(args);
    }
    getHeight() {
        return TRACK_HEIGHT;
    }
    renderCanvas(ctx) {
        // TODO: fonts and colors should come from the CSS and not hardcoded here.
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined)
            return; // Can't possibly draw anything.
        // If the cached trace slices don't fully cover the visible time range,
        // show a gray rectangle with a "Loading..." label.
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), timeScale.timeToPx(visibleWindowTime.start), timeScale.timeToPx(visibleWindowTime.end), timeScale.timeToPx(data.start), timeScale.timeToPx(data.end));
        this.renderSlices(ctx, data);
    }
    renderSlices(ctx, data) {
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        (0, logging.assertTrue)(data.starts.length === data.ends.length);
        (0, logging.assertTrue)(data.starts.length === data.utids.length);
        ctx.textAlign = 'center';
        ctx.font = '12px Roboto Condensed';
        const charWidth = ctx.measureText('dbpqaouk').width / 8;
        const rawStartIdx = data.ends.findIndex((end) => end >= visibleWindowTime.start);
        const startIdx = rawStartIdx === -1 ? 0 : rawStartIdx;
        const [, rawEndIdx] = (0, binary_search.searchSegment)(data.starts, visibleWindowTime.end);
        const endIdx = rawEndIdx === -1 ? data.starts.length : rawEndIdx;
        for (let i = startIdx; i < endIdx; i++) {
            const tStart = data.starts[i];
            let tEnd = data.ends[i];
            const utid = data.utids[i];
            // If the last slice is incomplete, it should end with the end of the
            // window, else it might spill over the window and the end would not be
            // visible as a zigzag line.
            if (data.ids[i] === data.lastRowId && data.isIncomplete[i]) {
                tEnd = visibleWindowTime.end;
            }
            const rectStart = timeScale.timeToPx(tStart);
            const rectEnd = timeScale.timeToPx(tEnd);
            const rectWidth = Math.max(1, rectEnd - rectStart);
            const threadInfo = globals.globals.threads.get(utid);
            const pid = threadInfo && threadInfo.pid ? threadInfo.pid : -1;
            const isHovering = globals.globals.state.hoveredUtid !== -1;
            const isThreadHovered = globals.globals.state.hoveredUtid === utid;
            const isProcessHovered = globals.globals.state.hoveredPid === pid;
            const color = (0, colorizer.colorForThread)(threadInfo);
            if (isHovering && !isThreadHovered) {
                if (!isProcessHovered) {
                    color.l = 90;
                    color.s = 0;
                }
                else {
                    color.l = Math.min(color.l + 30, 80);
                    color.s -= 20;
                }
            }
            else {
                color.l = Math.min(color.l + 10, 60);
                color.s -= 20;
            }
            ctx.fillStyle = `hsl(${color.h}, ${color.s}%, ${color.l}%)`;
            if (data.isIncomplete[i]) {
                (0, canvas_utils.drawIncompleteSlice)(ctx, rectStart, MARGIN_TOP, rectWidth, RECT_HEIGHT);
            }
            else {
                ctx.fillRect(rectStart, MARGIN_TOP, rectWidth, RECT_HEIGHT);
            }
            // Don't render text when we have less than 5px to play with.
            if (rectWidth < 5)
                continue;
            // TODO: consider de-duplicating this code with the copied one from
            // chrome_slices/frontend.ts.
            let title = `[utid:${utid}]`;
            let subTitle = '';
            if (threadInfo) {
                if (threadInfo.pid) {
                    let procName = threadInfo.procName || '';
                    if (procName.startsWith('/')) { // Remove folder paths from name
                        procName = procName.substring(procName.lastIndexOf('/') + 1);
                    }
                    title = `${procName} [${threadInfo.pid}]`;
                    subTitle = `${threadInfo.threadName} [${threadInfo.tid}]`;
                }
                else {
                    title = `${threadInfo.threadName} [${threadInfo.tid}]`;
                }
            }
            title = (0, canvas_utils.cropText)(title, charWidth, rectWidth);
            subTitle = (0, canvas_utils.cropText)(subTitle, charWidth, rectWidth);
            const rectXCenter = rectStart + rectWidth / 2;
            ctx.fillStyle = '#fff';
            ctx.font = '12px Roboto Condensed';
            ctx.fillText(title, rectXCenter, MARGIN_TOP + RECT_HEIGHT / 2 - 1);
            ctx.fillStyle = 'rgba(255, 255, 255, 0.6)';
            ctx.font = '10px Roboto Condensed';
            ctx.fillText(subTitle, rectXCenter, MARGIN_TOP + RECT_HEIGHT / 2 + 9);
        }
        const selection = globals.globals.state.currentSelection;
        const details = globals.globals.sliceDetails;
        if (selection !== null && selection.kind === 'SLICE') {
            const [startIndex, endIndex] = (0, binary_search.searchEq)(data.ids, selection.id);
            if (startIndex !== endIndex) {
                const tStart = data.starts[startIndex];
                const tEnd = data.ends[startIndex];
                const utid = data.utids[startIndex];
                const color = (0, colorizer.colorForThread)(globals.globals.threads.get(utid));
                const rectStart = timeScale.timeToPx(tStart);
                const rectEnd = timeScale.timeToPx(tEnd);
                const rectWidth = Math.max(1, rectEnd - rectStart);
                // Draw a rectangle around the slice that is currently selected.
                ctx.strokeStyle = `hsl(${color.h}, ${color.s}%, 30%)`;
                ctx.beginPath();
                ctx.lineWidth = 3;
                ctx.strokeRect(rectStart, MARGIN_TOP - 1.5, rectWidth, RECT_HEIGHT + 3);
                ctx.closePath();
                // Draw arrow from wakeup time of current slice.
                if (details.wakeupTs) {
                    const wakeupPos = timeScale.timeToPx(details.wakeupTs);
                    const latencyWidth = rectStart - wakeupPos;
                    (0, canvas_utils.drawDoubleHeadedArrow)(ctx, wakeupPos, MARGIN_TOP + RECT_HEIGHT, latencyWidth, latencyWidth >= 20);
                    // Latency time with a white semi-transparent background.
                    const displayText = (0, time.timeToString)(tStart - details.wakeupTs);
                    const measured = ctx.measureText(displayText);
                    if (latencyWidth >= measured.width + 2) {
                        ctx.fillStyle = 'rgba(255,255,255,0.7)';
                        ctx.fillRect(wakeupPos + latencyWidth / 2 - measured.width / 2 - 1, MARGIN_TOP + RECT_HEIGHT - 12, measured.width + 2, 11);
                        ctx.textBaseline = 'bottom';
                        ctx.fillStyle = 'black';
                        ctx.fillText(displayText, wakeupPos + (latencyWidth) / 2, MARGIN_TOP + RECT_HEIGHT - 1);
                    }
                }
            }
            // Draw diamond if the track being drawn is the cpu of the waker.
            if (this.config.cpu === details.wakerCpu && details.wakeupTs) {
                const wakeupPos = Math.floor(timeScale.timeToPx(details.wakeupTs));
                ctx.beginPath();
                ctx.moveTo(wakeupPos, MARGIN_TOP + RECT_HEIGHT / 2 + 8);
                ctx.fillStyle = 'black';
                ctx.lineTo(wakeupPos + 6, MARGIN_TOP + RECT_HEIGHT / 2);
                ctx.lineTo(wakeupPos, MARGIN_TOP + RECT_HEIGHT / 2 - 8);
                ctx.lineTo(wakeupPos - 6, MARGIN_TOP + RECT_HEIGHT / 2);
                ctx.fill();
                ctx.closePath();
            }
        }
        const hoveredThread = globals.globals.threads.get(this.utidHoveredInThisTrack);
        if (hoveredThread !== undefined && this.mousePos !== undefined) {
            const tidText = `T: ${hoveredThread.threadName} [${hoveredThread.tid}]`;
            if (hoveredThread.pid) {
                const pidText = `P: ${hoveredThread.procName} [${hoveredThread.pid}]`;
                this.drawTrackHoverTooltip(ctx, this.mousePos, pidText, tidText);
            }
            else {
                this.drawTrackHoverTooltip(ctx, this.mousePos, tidText);
            }
        }
    }
    onMouseMove(pos) {
        const data = this.data();
        this.mousePos = pos;
        if (data === undefined)
            return;
        const { timeScale } = globals.globals.frontendLocalState;
        if (pos.y < MARGIN_TOP || pos.y > MARGIN_TOP + RECT_HEIGHT) {
            this.utidHoveredInThisTrack = -1;
            globals.globals.dispatch(actions.Actions.setHoveredUtidAndPid({ utid: -1, pid: -1 }));
            return;
        }
        const t = timeScale.pxToTime(pos.x);
        let hoveredUtid = -1;
        for (let i = 0; i < data.starts.length; i++) {
            const tStart = data.starts[i];
            const tEnd = data.ends[i];
            const utid = data.utids[i];
            if (tStart <= t && t <= tEnd) {
                hoveredUtid = utid;
                break;
            }
        }
        this.utidHoveredInThisTrack = hoveredUtid;
        const threadInfo = globals.globals.threads.get(hoveredUtid);
        const hoveredPid = threadInfo ? (threadInfo.pid ? threadInfo.pid : -1) : -1;
        globals.globals.dispatch(actions.Actions.setHoveredUtidAndPid({ utid: hoveredUtid, pid: hoveredPid }));
    }
    onMouseOut() {
        this.utidHoveredInThisTrack = -1;
        globals.globals.dispatch(actions.Actions.setHoveredUtidAndPid({ utid: -1, pid: -1 }));
        this.mousePos = undefined;
    }
    onMouseClick({ x }) {
        const data = this.data();
        if (data === undefined)
            return false;
        const { timeScale } = globals.globals.frontendLocalState;
        const time = timeScale.pxToTime(x);
        const index = (0, binary_search.search)(data.starts, time);
        const id = index === -1 ? undefined : data.ids[index];
        if (!id || this.utidHoveredInThisTrack === -1)
            return false;
        globals.globals.makeSelection(actions.Actions.selectSlice({ id, trackId: this.trackState.id }));
        return true;
    }
}
CpuSliceTrack.kind = exports.CPU_SLICE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(CpuSliceTrackController);
    ctx.registerTrack(CpuSliceTrack);
}
exports.plugin = {
    pluginId: 'perfetto.CpuSlices',
    activate,
};

});

var css_constants = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.initCssConstants = exports.DEFAULT_DETAILS_CONTENT_HEIGHT = exports.OVERVIEW_TIMELINE_NON_VISIBLE_COLOR = exports.SELECTION_FILL_COLOR = exports.SELECTION_STROKE_COLOR = exports.TOPBAR_HEIGHT = exports.TRACK_BORDER_COLOR = exports.SIDEBAR_WIDTH = exports.TRACK_SHELL_WIDTH = void 0;
// This code can be used in unittests where we can't read CSS variables.
// Also we cannot have global constructors beacause when the javascript is
// loaded, the CSS might not be ready yet.
exports.TRACK_SHELL_WIDTH = 100;
exports.SIDEBAR_WIDTH = 100;
exports.TRACK_BORDER_COLOR = '#ffc0cb';
exports.TOPBAR_HEIGHT = 48;
exports.SELECTION_STROKE_COLOR = '#00344596';
exports.SELECTION_FILL_COLOR = '#8398e64d';
exports.OVERVIEW_TIMELINE_NON_VISIBLE_COLOR = '#c8c8c8cc';
exports.DEFAULT_DETAILS_CONTENT_HEIGHT = 280;
function initCssConstants() {
    exports.TRACK_SHELL_WIDTH = getCssNum('--track-shell-width') || exports.TRACK_SHELL_WIDTH;
    exports.SIDEBAR_WIDTH = getCssNum('--sidebar-width') || exports.SIDEBAR_WIDTH;
    exports.TRACK_BORDER_COLOR = getCssStr('--track-border-color') || exports.TRACK_BORDER_COLOR;
    exports.TOPBAR_HEIGHT = getCssNum('--topbar-height') || exports.TOPBAR_HEIGHT;
    exports.SELECTION_STROKE_COLOR =
        getCssStr('--selection-stroke-color') || exports.SELECTION_STROKE_COLOR;
    exports.SELECTION_FILL_COLOR =
        getCssStr('--selection-fill-color') || exports.SELECTION_FILL_COLOR;
    exports.OVERVIEW_TIMELINE_NON_VISIBLE_COLOR =
        getCssStr('--overview-timeline-non-visible-color') ||
            exports.OVERVIEW_TIMELINE_NON_VISIBLE_COLOR;
    exports.DEFAULT_DETAILS_CONTENT_HEIGHT =
        getCssNum('--details-content-height') || exports.DEFAULT_DETAILS_CONTENT_HEIGHT;
}
exports.initCssConstants = initCssConstants;
function getCssStr(prop) {
    if (typeof window === 'undefined')
        return undefined;
    const body = window.document.body;
    return window.getComputedStyle(body).getPropertyValue(prop);
}
function getCssNum(prop) {
    const str = getCssStr(prop);
    if (str === undefined)
        return undefined;
    const match = str.match(/^\W*(\d+)px(|\!important')$/);
    if (!match)
        throw Error(`Could not parse CSS property "${str}" as a number`);
    return Number(match[1]);
}

});

var gridline_helper = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.drawGridLines = exports.gridlines = exports.getGridStepSize = exports.DESIRED_PX_PER_STEP = void 0;

exports.DESIRED_PX_PER_STEP = 80;
// Returns the step size of a grid line in seconds.
// The returned step size has two properties:
// (1) It is 1, 2, or 5, multiplied by some integer power of 10.
// (2) The number steps in |range| produced by |stepSize| is as close as
//     possible to |desiredSteps|.
function getGridStepSize(range, desiredSteps) {
    // First, get the largest possible power of 10 that is smaller than the
    // desired step size, and set it to the current step size.
    // For example, if the range is 2345ms and the desired steps is 10, then the
    // desired step size is 234.5 and the step size will be set to 100.
    const desiredStepSize = range / desiredSteps;
    const zeros = Math.floor(Math.log10(desiredStepSize));
    const initialStepSize = Math.pow(10, zeros);
    // This function first calculates how many steps within the range a certain
    // stepSize will produce, and returns the difference between that and
    // desiredSteps.
    const distToDesired = (evaluatedStepSize) => Math.abs(range / evaluatedStepSize - desiredSteps);
    // We know that |initialStepSize| is a power of 10, and
    // initialStepSize <= desiredStepSize <= 10 * initialStepSize. There are four
    // possible candidates for final step size: 1, 2, 5 or 10 * initialStepSize.
    // We pick the candidate that minimizes distToDesired(stepSize).
    const stepSizeMultipliers = [2, 5, 10];
    let minimalDistance = distToDesired(initialStepSize);
    let minimizingStepSize = initialStepSize;
    for (const multiplier of stepSizeMultipliers) {
        const newStepSize = multiplier * initialStepSize;
        const newDistance = distToDesired(newStepSize);
        if (newDistance < minimalDistance) {
            minimalDistance = newDistance;
            minimizingStepSize = newStepSize;
        }
    }
    return minimizingStepSize;
}
exports.getGridStepSize = getGridStepSize;
// Generator that returns that (given a width im px, span, and scale) returns
// pairs of [xInPx, timestampInS] pairs describing where gridlines should be
// drawn.
function gridlines(width, span, timescale) {
    const desiredSteps = width / exports.DESIRED_PX_PER_STEP;
    const step = getGridStepSize(span.duration, desiredSteps);
    const actualSteps = Math.floor(span.duration / step);
    const start = Math.round(span.start / step) * step;
    const lines = [];
    let previousTimestamp = Number.NEGATIVE_INFINITY;
    // Iterating over the number of steps instead of
    // for (let s = start; s < span.end; s += step) because if start is very large
    // number and step very small, s will never reach end.
    for (let i = 0; i <= actualSteps; i++) {
        let xPos = css_constants.TRACK_SHELL_WIDTH;
        const timestamp = start + i * step;
        xPos += Math.floor(timescale.timeToPx(timestamp));
        if (xPos < css_constants.TRACK_SHELL_WIDTH)
            continue;
        if (xPos > width)
            break;
        if (Math.abs(timestamp - previousTimestamp) > Number.EPSILON) {
            previousTimestamp = timestamp;
            lines.push([xPos, timestamp]);
        }
    }
    return lines;
}
exports.gridlines = gridlines;
function drawGridLines(ctx, x, timeSpan, width, height) {
    ctx.strokeStyle = css_constants.TRACK_BORDER_COLOR;
    ctx.lineWidth = 1;
    for (const xAndTime of gridlines(width, timeSpan, x)) {
        ctx.beginPath();
        ctx.moveTo(xAndTime[0] + 0.5, 0);
        ctx.lineTo(xAndTime[0] + 0.5, height);
        ctx.stroke();
    }
}
exports.drawGridLines = drawGridLines;

});

var icons = createCommonjsModule(function (module, exports) {
// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.STAR_BORDER = exports.STAR = exports.EXPAND_UP = exports.EXPAND_DOWN = exports.INDETERMINATE_CHECKBOX = exports.CHECKBOX = exports.BLANK_CHECKBOX = void 0;
exports.BLANK_CHECKBOX = 'check_box_outline_blank';
exports.CHECKBOX = 'check_box';
exports.INDETERMINATE_CHECKBOX = 'indeterminate_check_box';
exports.EXPAND_DOWN = 'expand_more';
exports.EXPAND_UP = 'expand_less';
exports.STAR = 'star';
exports.STAR_BORDER = 'star_border';

});

var panel = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPanelVNode = exports.Panel = void 0;
class Panel {
}
exports.Panel = Panel;
function isPanelVNode(vnode) {
    const tag = vnode.tag;
    return (typeof tag === 'function' && 'prototype' in tag &&
        tag.prototype instanceof Panel);
}
exports.isPanelVNode = isPanelVNode;

});

var vertical_line_helper = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.drawVerticalLineAtTime = void 0;

function drawVerticalLineAtTime(ctx, timeScale, time, height, color, lineWidth = 2) {
    const xPos = css_constants.TRACK_SHELL_WIDTH + Math.floor(timeScale.timeToPx(time));
    drawVerticalLine(ctx, xPos, height, color, lineWidth);
}
exports.drawVerticalLineAtTime = drawVerticalLineAtTime;
function drawVerticalLine(ctx, xPos, height, color, lineWidth = 2) {
    ctx.beginPath();
    ctx.strokeStyle = color;
    const prevLineWidth = ctx.lineWidth;
    ctx.lineWidth = lineWidth;
    ctx.moveTo(xPos, 0);
    ctx.lineTo(xPos, height);
    ctx.stroke();
    ctx.closePath();
    ctx.lineWidth = prevLineWidth;
}

});

var track_panel = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrackPanel = exports.TrackButton = exports.TrackContent = void 0;











function isPinned(id) {
    return globals.globals.state.pinnedTracks.indexOf(id) !== -1;
}
function isSelected(id) {
    const selection = globals.globals.state.currentSelection;
    if (selection === null || selection.kind !== 'AREA')
        return false;
    const selectedArea = globals.globals.state.areas[selection.areaId];
    return selectedArea.tracks.includes(id);
}
class TrackShell {
    constructor() {
        // Set to true when we click down and drag the
        this.dragging = false;
        this.dropping = undefined;
    }
    oninit(vnode) {
        this.attrs = vnode.attrs;
    }
    view({ attrs }) {
        // The shell should be highlighted if the current search result is inside
        // this track.
        let highlightClass = '';
        const searchIndex = globals.globals.state.searchIndex;
        if (searchIndex !== -1) {
            const trackId = globals.globals.currentSearchResults.trackIds[searchIndex];
            if (trackId === attrs.trackState.id) {
                highlightClass = 'flash';
            }
        }
        const dragClass = this.dragging ? `drag` : '';
        const dropClass = this.dropping ? `drop-${this.dropping}` : '';
        return mithril(`.track-shell[draggable=true]`, {
            class: `${highlightClass} ${dragClass} ${dropClass}`,
            onmousedown: this.onmousedown.bind(this),
            ondragstart: this.ondragstart.bind(this),
            ondragend: this.ondragend.bind(this),
            ondragover: this.ondragover.bind(this),
            ondragleave: this.ondragleave.bind(this),
            ondrop: this.ondrop.bind(this),
        }, mithril('h1', {
            title: attrs.trackState.name,
        }, attrs.trackState.name, ('namespace' in attrs.trackState.config) &&
            mithril('span.chip', 'metric')), mithril('.track-buttons', attrs.track.getTrackShellButtons(), attrs.track.getContextMenu(), mithril(TrackButton, {
            action: () => {
                globals.globals.dispatch(actions.Actions.toggleTrackPinned({ trackId: attrs.trackState.id }));
            },
            i: isPinned(attrs.trackState.id) ? icons.STAR : icons.STAR_BORDER,
            tooltip: isPinned(attrs.trackState.id) ? 'Unpin' : 'Pin to top',
            showButton: isPinned(attrs.trackState.id),
            fullHeight: true,
        }), globals.globals.state.currentSelection !== null &&
            globals.globals.state.currentSelection.kind === 'AREA' ?
            mithril(TrackButton, {
                action: (e) => {
                    globals.globals.dispatch(actions.Actions.toggleTrackSelection({ id: attrs.trackState.id, isTrackGroup: false }));
                    e.stopPropagation();
                },
                i: isSelected(attrs.trackState.id) ? icons.CHECKBOX : icons.BLANK_CHECKBOX,
                tooltip: isSelected(attrs.trackState.id) ?
                    'Remove track' :
                    'Add track to selection',
                showButton: true,
            }) :
            ''));
    }
    onmousedown(e) {
        // Prevent that the click is intercepted by the PanAndZoomHandler and that
        // we start panning while dragging.
        e.stopPropagation();
    }
    ondragstart(e) {
        const dataTransfer = e.dataTransfer;
        if (dataTransfer === null)
            return;
        this.dragging = true;
        globals.globals.rafScheduler.scheduleFullRedraw();
        dataTransfer.setData('perfetto/track', `${this.attrs.trackState.id}`);
        dataTransfer.setDragImage(new Image(), 0, 0);
        e.stopImmediatePropagation();
    }
    ondragend() {
        this.dragging = false;
        globals.globals.rafScheduler.scheduleFullRedraw();
    }
    ondragover(e) {
        if (this.dragging)
            return;
        if (!(e.target instanceof HTMLElement))
            return;
        const dataTransfer = e.dataTransfer;
        if (dataTransfer === null)
            return;
        if (!dataTransfer.types.includes('perfetto/track'))
            return;
        dataTransfer.dropEffect = 'move';
        e.preventDefault();
        // Apply some hysteresis to the drop logic so that the lightened border
        // changes only when we get close enough to the border.
        if (e.offsetY < e.target.scrollHeight / 3) {
            this.dropping = 'before';
        }
        else if (e.offsetY > e.target.scrollHeight / 3 * 2) {
            this.dropping = 'after';
        }
        globals.globals.rafScheduler.scheduleFullRedraw();
    }
    ondragleave() {
        this.dropping = undefined;
        globals.globals.rafScheduler.scheduleFullRedraw();
    }
    ondrop(e) {
        if (this.dropping === undefined)
            return;
        const dataTransfer = e.dataTransfer;
        if (dataTransfer === null)
            return;
        globals.globals.rafScheduler.scheduleFullRedraw();
        const srcId = dataTransfer.getData('perfetto/track');
        const dstId = this.attrs.trackState.id;
        globals.globals.dispatch(actions.Actions.moveTrack({ srcId, op: this.dropping, dstId }));
        this.dropping = undefined;
    }
}
class TrackContent {
    constructor() {
        this.selectionOccurred = false;
    }
    view(node) {
        const attrs = node.attrs;
        return mithril('.track-content', {
            onmousemove: (e) => {
                attrs.track.onMouseMove({ x: e.layerX - css_constants.TRACK_SHELL_WIDTH, y: e.layerY });
                globals.globals.rafScheduler.scheduleRedraw();
            },
            onmouseout: () => {
                attrs.track.onMouseOut();
                globals.globals.rafScheduler.scheduleRedraw();
            },
            onmousedown: (e) => {
                this.mouseDownX = e.layerX;
                this.mouseDownY = e.layerY;
            },
            onmouseup: (e) => {
                if (this.mouseDownX === undefined ||
                    this.mouseDownY === undefined) {
                    return;
                }
                if (Math.abs(e.layerX - this.mouseDownX) > 1 ||
                    Math.abs(e.layerY - this.mouseDownY) > 1) {
                    this.selectionOccurred = true;
                }
                this.mouseDownX = undefined;
                this.mouseDownY = undefined;
            },
            onclick: (e) => {
                // This click event occurs after any selection mouse up/drag events
                // so we have to look if the mouse moved during this click to know
                // if a selection occurred.
                if (this.selectionOccurred) {
                    this.selectionOccurred = false;
                    return;
                }
                // Returns true if something was selected, so stop propagation.
                if (attrs.track.onMouseClick({ x: e.layerX - css_constants.TRACK_SHELL_WIDTH, y: e.layerY })) {
                    e.stopPropagation();
                }
                globals.globals.rafScheduler.scheduleRedraw();
            },
        }, node.children);
    }
}
exports.TrackContent = TrackContent;
class TrackComponent {
    view({ attrs }) {
        return mithril('.track', {
            style: {
                height: `${Math.max(24, attrs.track.getHeight())}px`,
            },
            id: 'track_' + attrs.trackState.id,
        }, [
            mithril(TrackShell, { track: attrs.track, trackState: attrs.trackState }),
            mithril(TrackContent, { track: attrs.track }),
        ]);
    }
    oncreate({ attrs }) {
        if (globals.globals.frontendLocalState.scrollToTrackId === attrs.trackState.id) {
            (0, scroll_helper.verticalScrollToTrack)(attrs.trackState.id);
            globals.globals.frontendLocalState.scrollToTrackId = undefined;
        }
    }
}
class TrackButton {
    view({ attrs }) {
        return mithril('i.material-icons.track-button', {
            class: [
                (attrs.showButton ? 'show' : ''),
                (attrs.fullHeight ? 'full-height' : ''),
            ].filter(Boolean)
                .join(' '),
            onclick: attrs.action,
            title: attrs.tooltip,
        }, attrs.i);
    }
}
exports.TrackButton = TrackButton;
class TrackPanel extends panel.Panel {
    constructor(vnode) {
        super();
        const trackId = vnode.attrs.id;
        const trackState = globals.globals.state.tracks[trackId];
        if (trackState === undefined) {
            return;
        }
        const engine = globals.globals.engines.get(trackState.engineId);
        if (engine === undefined) {
            return;
        }
        const trackCreator = track_registry.trackRegistry.get(trackState.kind);
        this.track = trackCreator.create({ trackId, engine });
        this.trackState = trackState;
    }
    view() {
        if (this.track === undefined || this.trackState === undefined) {
            return mithril('div', 'No such track');
        }
        return mithril(TrackComponent, { trackState: this.trackState, track: this.track });
    }
    oncreate() {
        if (this.track !== undefined) {
            this.track.onFullRedraw();
        }
    }
    onupdate() {
        if (this.track !== undefined) {
            this.track.onFullRedraw();
        }
    }
    onremove() {
        if (this.track !== undefined) {
            this.track.onDestroy();
            this.track = undefined;
        }
    }
    highlightIfTrackSelected(ctx, size) {
        const localState = globals.globals.frontendLocalState;
        const selection = globals.globals.state.currentSelection;
        const trackState = this.trackState;
        if (!selection || selection.kind !== 'AREA' || trackState === undefined) {
            return;
        }
        const selectedArea = globals.globals.state.areas[selection.areaId];
        if (selectedArea.tracks.includes(trackState.id)) {
            const timeScale = localState.timeScale;
            ctx.fillStyle = css_constants.SELECTION_FILL_COLOR;
            ctx.fillRect(timeScale.timeToPx(selectedArea.startSec) + css_constants.TRACK_SHELL_WIDTH, 0, timeScale.deltaTimeToPx(selectedArea.endSec - selectedArea.startSec), size.height);
        }
    }
    renderCanvas(ctx, size) {
        ctx.save();
        (0, gridline_helper.drawGridLines)(ctx, globals.globals.frontendLocalState.timeScale, globals.globals.frontendLocalState.visibleWindowTime, size.width, size.height);
        ctx.translate(css_constants.TRACK_SHELL_WIDTH, 0);
        if (this.track !== undefined) {
            this.track.render(ctx);
        }
        ctx.restore();
        this.highlightIfTrackSelected(ctx, size);
        const localState = globals.globals.frontendLocalState;
        // Draw vertical line when hovering on the notes panel.
        if (globals.globals.state.hoveredNoteTimestamp !== -1) {
            (0, vertical_line_helper.drawVerticalLineAtTime)(ctx, localState.timeScale, globals.globals.state.hoveredNoteTimestamp, size.height, `#aaa`);
        }
        if (globals.globals.state.hoveredLogsTimestamp !== -1) {
            (0, vertical_line_helper.drawVerticalLineAtTime)(ctx, localState.timeScale, globals.globals.state.hoveredLogsTimestamp, size.height, `#344596`);
        }
        if (globals.globals.state.currentSelection !== null) {
            if (globals.globals.state.currentSelection.kind === 'NOTE') {
                const note = globals.globals.state.notes[globals.globals.state.currentSelection.id];
                if (note.noteType === 'DEFAULT') {
                    (0, vertical_line_helper.drawVerticalLineAtTime)(ctx, localState.timeScale, note.timestamp, size.height, note.color);
                }
            }
            if (globals.globals.state.currentSelection.kind === 'SLICE' &&
                globals.globals.sliceDetails.wakeupTs !== undefined) {
                (0, vertical_line_helper.drawVerticalLineAtTime)(ctx, localState.timeScale, globals.globals.sliceDetails.wakeupTs, size.height, `black`);
            }
        }
        // All marked areas should have semi-transparent vertical lines
        // marking the start and end.
        for (const note of Object.values(globals.globals.state.notes)) {
            if (note.noteType === 'AREA') {
                const transparentNoteColor = 'rgba(' + colorConvert.hex.rgb(note.color.substr(1)).toString() + ', 0.65)';
                (0, vertical_line_helper.drawVerticalLineAtTime)(ctx, localState.timeScale, globals.globals.state.areas[note.areaId].startSec, size.height, transparentNoteColor, 1);
                (0, vertical_line_helper.drawVerticalLineAtTime)(ctx, localState.timeScale, globals.globals.state.areas[note.areaId].endSec, size.height, transparentNoteColor, 1);
            }
        }
    }
    getSliceRect(tStart, tDur, depth) {
        if (this.track === undefined) {
            return undefined;
        }
        return this.track.getSliceRect(tStart, tDur, depth);
    }
}
exports.TrackPanel = TrackPanel;

});

var debug_slices = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.DebugSliceTrack = exports.DEBUG_SLICE_TRACK_KIND = void 0;









exports.DEBUG_SLICE_TRACK_KIND = 'DebugSliceTrack';
class DebugSliceTrackController extends track_controller.TrackController {
    onReload() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const rawResult = yield this.query(`select ifnull(max(depth), 1) as maxDepth from debug_slices`);
            const maxDepth = rawResult.firstRow({ maxDepth: query_result.NUM }).maxDepth;
            globals.globals.dispatch(actions.Actions.updateTrackConfig({ id: this.trackId, config: { maxDepth } }));
        });
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const queryRes = yield this.query(`select
      ifnull(id, -1) as id,
      CAST(ifnull(name, '[null]') AS text) as name,
      ts,
      iif(dur = -1, (SELECT end_ts FROM trace_bounds) - ts, dur) as dur,
      ifnull(depth, 0) as depth
      from debug_slices
      where (ts + dur) >= ${(0, time.toNs)(start)} and ts <= ${(0, time.toNs)(end)}`);
            const numRows = queryRes.numRows();
            const slices = {
                start,
                end,
                resolution,
                length: numRows,
                strings: [],
                sliceIds: new Float64Array(numRows),
                starts: new Float64Array(numRows),
                ends: new Float64Array(numRows),
                depths: new Uint16Array(numRows),
                titles: new Uint16Array(numRows),
                isInstant: new Uint16Array(numRows),
                isIncomplete: new Uint16Array(numRows),
            };
            const stringIndexes = new Map();
            function internString(str) {
                let idx = stringIndexes.get(str);
                if (idx !== undefined)
                    return idx;
                idx = slices.strings.length;
                slices.strings.push(str);
                stringIndexes.set(str, idx);
                return idx;
            }
            const it = queryRes.iter({ id: query_result.NUM, name: query_result.STR, ts: query_result.NUM_NULL, dur: query_result.NUM_NULL, depth: query_result.NUM });
            for (let row = 0; it.valid(); it.next(), row++) {
                let sliceStart;
                let sliceEnd;
                if (it.ts === null || it.dur === null) {
                    sliceStart = sliceEnd = -1;
                }
                else {
                    sliceStart = it.ts;
                    sliceEnd = sliceStart + it.dur;
                }
                slices.sliceIds[row] = it.id;
                slices.starts[row] = (0, time.fromNs)(sliceStart);
                slices.ends[row] = (0, time.fromNs)(sliceEnd);
                slices.depths[row] = it.depth;
                const sliceName = it.name;
                slices.titles[row] = internString(sliceName);
                slices.isInstant[row] = 0;
                slices.isIncomplete[row] = 0;
            }
            return slices;
        });
    }
}
DebugSliceTrackController.kind = exports.DEBUG_SLICE_TRACK_KIND;
class DebugSliceTrack extends chrome_slices.ChromeSliceTrack {
    static create(args) {
        return new DebugSliceTrack(args);
    }
    getTrackShellButtons() {
        const buttons = [];
        buttons.push(mithril(track_panel.TrackButton, {
            action: () => {
                globals.globals.dispatch(actions.Actions.requestTrackReload({}));
            },
            i: 'refresh',
            tooltip: 'Refresh tracks',
            showButton: true,
        }));
        buttons.push(mithril(track_panel.TrackButton, {
            action: () => {
                globals.globals.dispatch(actions.Actions.removeDebugTrack({}));
            },
            i: 'close',
            tooltip: 'Close',
            showButton: true,
        }));
        return buttons;
    }
}
exports.DebugSliceTrack = DebugSliceTrack;
DebugSliceTrack.kind = exports.DEBUG_SLICE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrack(DebugSliceTrack);
    ctx.registerTrackController(DebugSliceTrackController);
}
exports.plugin = {
    pluginId: 'perfetto.DebugSlices',
    activate,
};

});

var expected_frames = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.ExpectedFramesSliceTrack = exports.EXPECTED_FRAMES_SLICE_TRACK_KIND = void 0;

exports.EXPECTED_FRAMES_SLICE_TRACK_KIND = 'ExpectedFramesSliceTrack';




class ExpectedFramesSliceTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.maxDurNs = 0;
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            const pxSize = this.pxSize();
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolution * 1e9 * pxSize / 2) * 2, 1);
            if (this.maxDurNs === 0) {
                const maxDurResult = yield this.query(`
        select max(iif(dur = -1, (SELECT end_ts FROM trace_bounds) - ts, dur))
          as maxDur
        from experimental_slice_layout
        where filter_track_ids = '${this.config.trackIds.join(',')}'
      `);
                this.maxDurNs = maxDurResult.firstRow({ maxDur: query_result.NUM_NULL }).maxDur || 0;
            }
            const queryRes = yield this.query(`
      SELECT
        (ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as tsq,
        ts,
        max(iif(dur = -1, (SELECT end_ts FROM trace_bounds) - ts, dur)) as dur,
        layout_depth as layoutDepth,
        name,
        id,
        dur = 0 as isInstant,
        dur = -1 as isIncomplete
      from experimental_slice_layout
      where
        filter_track_ids = '${this.config.trackIds.join(',')}' and
        ts >= ${startNs - this.maxDurNs} and
        ts <= ${endNs}
      group by tsq, layout_depth
      order by tsq, layout_depth
    `);
            const numRows = queryRes.numRows();
            const slices = {
                start,
                end,
                resolution,
                length: numRows,
                strings: [],
                sliceIds: new Float64Array(numRows),
                starts: new Float64Array(numRows),
                ends: new Float64Array(numRows),
                depths: new Uint16Array(numRows),
                titles: new Uint16Array(numRows),
                colors: new Uint16Array(numRows),
                isInstant: new Uint16Array(numRows),
                isIncomplete: new Uint16Array(numRows),
            };
            const stringIndexes = new Map();
            function internString(str) {
                let idx = stringIndexes.get(str);
                if (idx !== undefined)
                    return idx;
                idx = slices.strings.length;
                slices.strings.push(str);
                stringIndexes.set(str, idx);
                return idx;
            }
            const greenIndex = internString('#4CAF50');
            const it = queryRes.iter({
                tsq: query_result.NUM,
                ts: query_result.NUM,
                dur: query_result.NUM,
                layoutDepth: query_result.NUM,
                id: query_result.NUM,
                name: query_result.STR,
                isInstant: query_result.NUM,
                isIncomplete: query_result.NUM,
            });
            for (let row = 0; it.valid(); it.next(), ++row) {
                const startNsQ = it.tsq;
                const startNs = it.ts;
                const durNs = it.dur;
                const endNs = startNs + durNs;
                let endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
                endNsQ = Math.max(endNsQ, startNsQ + bucketNs);
                slices.starts[row] = (0, time.fromNs)(startNsQ);
                slices.ends[row] = (0, time.fromNs)(endNsQ);
                slices.depths[row] = it.layoutDepth;
                slices.titles[row] = internString(it.name);
                slices.sliceIds[row] = it.id;
                slices.isInstant[row] = it.isInstant;
                slices.isIncomplete[row] = it.isIncomplete;
                slices.colors[row] = greenIndex;
            }
            return slices;
        });
    }
}
ExpectedFramesSliceTrackController.kind = exports.EXPECTED_FRAMES_SLICE_TRACK_KIND;
class ExpectedFramesSliceTrack extends chrome_slices.ChromeSliceTrack {
    static create(args) {
        return new ExpectedFramesSliceTrack(args);
    }
}
exports.ExpectedFramesSliceTrack = ExpectedFramesSliceTrack;
ExpectedFramesSliceTrack.kind = exports.EXPECTED_FRAMES_SLICE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(ExpectedFramesSliceTrackController);
    ctx.registerTrack(ExpectedFramesSliceTrack);
}
exports.plugin = {
    pluginId: 'perfetto.ExpectedFrames',
    activate,
};

});

var generic_slice_track = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.GenericSliceTrack = void 0;


class GenericSliceTrack extends named_slice_track.NamedSliceTrack {
    constructor(args) {
        super(args);
    }
    static create(args) {
        return new GenericSliceTrack(args);
    }
    initSqlTable(tableName) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const sql = `create view ${tableName} as
    select ts, dur, id, depth, ifnull(name, '') as name
    from slice where track_id = ${this.config.sqlTrackId}`;
            yield this.engine.query(sql);
        });
    }
}
exports.GenericSliceTrack = GenericSliceTrack;
GenericSliceTrack.kind = 'GenericSliceTrack';
function activate(ctx) {
    ctx.registerTrack(GenericSliceTrack);
}
exports.plugin = {
    pluginId: 'perfetto.GenericSliceTrack',
    activate,
};

});

var flamegraph = createCommonjsModule(function (module, exports) {
// Copyright (C) 2018 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.splitIfTooBig = exports.Flamegraph = exports.findRootSize = exports.FLAMEGRAPH_HOVERED_COLOR = void 0;


// Height of one 'row' on the flame chart including 1px of whitespace
// below the box.
const NODE_HEIGHT = 18;
exports.FLAMEGRAPH_HOVERED_COLOR = 'hsl(224, 45%, 55%)';
function findRootSize(data) {
    let totalSize = 0;
    let i = 0;
    while (i < data.length && data[i].depth === 0) {
        totalSize += data[i].totalSize;
        i++;
    }
    return totalSize;
}
exports.findRootSize = findRootSize;
class Flamegraph {
    constructor(flamegraphData) {
        this.nodeRendering = {};
        this.highlightSomeNodes = false;
        this.maxDepth = -1;
        this.totalSize = -1;
        // Initialised on first draw() call
        this.labelCharWidth = 0;
        this.labelFontStyle = '12px Roboto Mono';
        this.rolloverFontStyle = '12px Roboto Condensed';
        // Key for the map is depth followed by x coordinate - `depth;x`
        this.graphData = new Map();
        this.xStartsPerDepth = new Map();
        this.hoveredX = -1;
        this.hoveredY = -1;
        this.startingY = 0;
        this.flamegraphData = flamegraphData;
        this.findMaxDepth();
    }
    findMaxDepth() {
        this.maxDepth =
            Math.max(...this.flamegraphData.map((value) => value.depth));
    }
    // Instead of highlighting the interesting nodes, we actually want to
    // de-emphasize the non-highlighted nodes. Returns true if there
    // are any highlighted nodes in the flamegraph.
    highlightingExists() {
        this.highlightSomeNodes = this.flamegraphData.some((e) => e.highlighted);
    }
    generateColor(name, isGreyedOut = false, highlighted) {
        if (isGreyedOut) {
            return '#d9d9d9';
        }
        if (name === 'unknown' || name === 'root') {
            return '#c0c0c0';
        }
        let x = 0;
        for (let i = 0; i < name.length; i += 1) {
            x += name.charCodeAt(i) % 64;
        }
        x = x % 360;
        let l = '76';
        // Make non-highlighted node lighter.
        if (this.highlightSomeNodes && !highlighted) {
            l = '90';
        }
        return `hsl(${x}deg, 45%, ${l}%)`;
    }
    // Caller will have to call draw method after updating data to have updated
    // graph.
    updateDataIfChanged(nodeRendering, flamegraphData, clickedCallsite) {
        this.nodeRendering = nodeRendering;
        this.clickedCallsite = clickedCallsite;
        if (this.flamegraphData === flamegraphData) {
            return;
        }
        this.flamegraphData = flamegraphData;
        this.clickedCallsite = clickedCallsite;
        this.findMaxDepth();
        this.highlightingExists();
        // Finding total size of roots.
        this.totalSize = findRootSize(flamegraphData);
    }
    draw(ctx, width, height, x = 0, y = 0, unit = 'B') {
        if (this.flamegraphData === undefined) {
            return;
        }
        ctx.font = this.labelFontStyle;
        ctx.textBaseline = 'middle';
        if (this.labelCharWidth === 0) {
            this.labelCharWidth = ctx.measureText('_').width;
        }
        this.startingY = y;
        // For each node, we use this map to get information about it's parent
        // (total size of it, width and where it starts in graph) so we can
        // calculate it's own position in graph.
        const nodesMap = new Map();
        let currentY = y;
        nodesMap.set(-1, { width, nextXForChildren: x, size: this.totalSize, x });
        // Initialize data needed for click/hover behavior.
        this.graphData = new Map();
        this.xStartsPerDepth = new Map();
        // Draw root node.
        ctx.fillStyle = this.generateColor('root', false, false);
        ctx.fillRect(x, currentY, width, NODE_HEIGHT - 1);
        const text = (0, canvas_utils.cropText)(`root: ${this.displaySize(this.totalSize, unit, unit === 'B' ? 1024 : 1000)}`, this.labelCharWidth, width - 2);
        ctx.fillStyle = 'black';
        ctx.fillText(text, x + 5, currentY + (NODE_HEIGHT - 1) / 2);
        currentY += NODE_HEIGHT;
        // Set style for borders.
        ctx.strokeStyle = 'white';
        ctx.lineWidth = 0.5;
        for (let i = 0; i < this.flamegraphData.length; i++) {
            if (currentY > height) {
                break;
            }
            const value = this.flamegraphData[i];
            const parentNode = nodesMap.get(value.parentId);
            if (parentNode === undefined) {
                continue;
            }
            const isClicked = this.clickedCallsite !== undefined;
            const isFullWidth = isClicked && value.depth <= this.clickedCallsite.depth;
            const isGreyedOut = isClicked && value.depth < this.clickedCallsite.depth;
            const parent = value.parentId;
            const parentSize = parent === -1 ? this.totalSize : parentNode.size;
            // Calculate node's width based on its proportion in parent.
            const width = (isFullWidth ? 1 : value.totalSize / parentSize) * parentNode.width;
            const currentX = parentNode.nextXForChildren;
            currentY = y + NODE_HEIGHT * (value.depth + 1);
            // Draw node.
            const name = this.getCallsiteName(value);
            ctx.fillStyle = this.generateColor(name, isGreyedOut, value.highlighted);
            ctx.fillRect(currentX, currentY, width, NODE_HEIGHT - 1);
            // Set current node's data in map for children to use.
            nodesMap.set(value.id, {
                width,
                nextXForChildren: currentX,
                size: value.totalSize,
                x: currentX,
            });
            // Update next x coordinate in parent.
            nodesMap.set(value.parentId, {
                width: parentNode.width,
                nextXForChildren: currentX + width,
                size: parentNode.size,
                x: parentNode.x,
            });
            // Draw name.
            const labelPaddingPx = 5;
            const maxLabelWidth = width - labelPaddingPx * 2;
            let text = (0, canvas_utils.cropText)(name, this.labelCharWidth, maxLabelWidth);
            // If cropped text and the original text are within 20% we keep the
            // original text and just squish it a bit.
            if (text.length * 1.2 > name.length) {
                text = name;
            }
            ctx.fillStyle = 'black';
            ctx.fillText(text, currentX + labelPaddingPx, currentY + (NODE_HEIGHT - 1) / 2, maxLabelWidth);
            // Draw border on the right of node.
            ctx.beginPath();
            ctx.moveTo(currentX + width, currentY);
            ctx.lineTo(currentX + width, currentY + NODE_HEIGHT);
            ctx.stroke();
            // Add this node for recognizing in click/hover.
            // Map graphData contains one callsite which is on that depth and X
            // start. Map xStartsPerDepth for each depth contains all X start
            // coordinates that callsites on that level have.
            this.graphData.set(`${value.depth};${currentX}`, { callsite: value, width });
            const xStarts = this.xStartsPerDepth.get(value.depth);
            if (xStarts === undefined) {
                this.xStartsPerDepth.set(value.depth, [currentX]);
            }
            else {
                xStarts.push(currentX);
            }
        }
        // Draw the tooltip.
        if (this.hoveredX > -1 && this.hoveredY > -1 && this.hoveredCallsite) {
            // Must set these before measureText below.
            ctx.font = this.rolloverFontStyle;
            ctx.textBaseline = 'top';
            // Size in px of the border around the text and the edge of the rollover
            // background.
            const paddingPx = 8;
            // Size in px of the x and y offset between the mouse and the top left
            // corner of the rollover box.
            const offsetPx = 4;
            const lines = [];
            let textWidth = this.addToTooltip(this.getCallsiteName(this.hoveredCallsite), width - paddingPx, ctx, lines);
            if (this.hoveredCallsite.location != null) {
                textWidth = Math.max(textWidth, this.addToTooltip(this.hoveredCallsite.location, width, ctx, lines));
            }
            textWidth = Math.max(textWidth, this.addToTooltip(this.hoveredCallsite.mapping, width, ctx, lines));
            if (this.nodeRendering.totalSize !== undefined) {
                const percentage = this.hoveredCallsite.totalSize / this.totalSize * 100;
                const totalSizeText = `${this.nodeRendering.totalSize}: ${this.displaySize(this.hoveredCallsite.totalSize, unit, unit === 'B' ? 1024 : 1000)} (${percentage.toFixed(2)}%)`;
                textWidth = Math.max(textWidth, this.addToTooltip(totalSizeText, width, ctx, lines));
            }
            if (this.nodeRendering.selfSize !== undefined &&
                this.hoveredCallsite.selfSize > 0) {
                const selfPercentage = this.hoveredCallsite.selfSize / this.totalSize * 100;
                const selfSizeText = `${this.nodeRendering.selfSize}: ${this.displaySize(this.hoveredCallsite.selfSize, unit, unit === 'B' ? 1024 : 1000)} (${selfPercentage.toFixed(2)}%)`;
                textWidth = Math.max(textWidth, this.addToTooltip(selfSizeText, width, ctx, lines));
            }
            // Compute a line height as the bounding box height + 50%:
            const heightSample = ctx.measureText('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
            const lineHeight = Math.round(heightSample.actualBoundingBoxDescent * 1.5);
            const rectWidth = textWidth + 2 * paddingPx;
            const rectHeight = lineHeight * lines.length + 2 * paddingPx;
            let rectXStart = this.hoveredX + offsetPx;
            let rectYStart = this.hoveredY + offsetPx;
            if (rectXStart + rectWidth > width) {
                rectXStart = width - rectWidth;
            }
            if (rectYStart + rectHeight > height) {
                rectYStart = height - rectHeight;
            }
            ctx.fillStyle = 'rgba(255, 255, 255, 0.9)';
            ctx.fillRect(rectXStart, rectYStart, rectWidth, rectHeight);
            ctx.fillStyle = 'hsl(200, 50%, 40%)';
            ctx.textAlign = 'left';
            for (let i = 0; i < lines.length; i++) {
                const line = lines[i];
                ctx.fillText(line, rectXStart + paddingPx, rectYStart + paddingPx + i * lineHeight);
            }
        }
    }
    addToTooltip(text, width, ctx, lines) {
        const lineSplitter = splitIfTooBig(text, width, ctx.measureText(text).width);
        lines.push(...lineSplitter.lines);
        return lineSplitter.lineWidth;
    }
    getCallsiteName(value) {
        return value.name === undefined || value.name === '' ? 'unknown' :
            value.name;
    }
    displaySize(totalSize, unit, step = 1024) {
        if (unit === '')
            return totalSize.toLocaleString();
        if (totalSize === 0)
            return `0 ${unit}`;
        const units = [
            ['', 1],
            ['K', step],
            ['M', Math.pow(step, 2)],
            ['G', Math.pow(step, 3)],
        ];
        let unitsIndex = Math.trunc(Math.log(totalSize) / Math.log(step));
        unitsIndex = unitsIndex > units.length - 1 ? units.length - 1 : unitsIndex;
        const result = totalSize / +units[unitsIndex][1];
        const resultString = totalSize % +units[unitsIndex][1] === 0 ?
            result.toString() :
            result.toFixed(2);
        return `${resultString} ${units[unitsIndex][0]}${unit}`;
    }
    onMouseMove({ x, y }) {
        this.hoveredX = x;
        this.hoveredY = y;
        this.hoveredCallsite = this.findSelectedCallsite(x, y);
        const isCallsiteSelected = this.hoveredCallsite !== undefined;
        if (!isCallsiteSelected) {
            this.onMouseOut();
        }
        return isCallsiteSelected;
    }
    onMouseOut() {
        this.hoveredX = -1;
        this.hoveredY = -1;
        this.hoveredCallsite = undefined;
    }
    onMouseClick({ x, y }) {
        const clickedCallsite = this.findSelectedCallsite(x, y);
        // TODO(b/148596659): Allow to expand [merged] callsites. Currently,
        // this expands to the biggest of the nodes that were merged, which
        // is confusing, so we disallow clicking on them.
        if (clickedCallsite === undefined || clickedCallsite.merged) {
            return undefined;
        }
        return clickedCallsite;
    }
    findSelectedCallsite(x, y) {
        const depth = Math.trunc((y - this.startingY) / NODE_HEIGHT) - 1; // at 0 is root
        if (depth >= 0 && this.xStartsPerDepth.has(depth)) {
            const startX = this.searchSmallest(this.xStartsPerDepth.get(depth), x);
            const result = this.graphData.get(`${depth};${startX}`);
            if (result !== undefined) {
                const width = result.width;
                return startX + width >= x ? result.callsite : undefined;
            }
        }
        return undefined;
    }
    searchSmallest(haystack, needle) {
        haystack = haystack.sort((n1, n2) => n1 - n2);
        const [left] = (0, binary_search.searchSegment)(haystack, needle);
        return left === -1 ? -1 : haystack[left];
    }
    getHeight() {
        return this.flamegraphData.length === 0 ? 0 :
            (this.maxDepth + 2) * NODE_HEIGHT;
    }
}
exports.Flamegraph = Flamegraph;
function splitIfTooBig(line, width, lineWidth) {
    if (line === '')
        return { lineWidth, lines: [] };
    const lines = [];
    const charWidth = lineWidth / line.length;
    const maxWidth = width - 32;
    const maxLineLen = Math.trunc(maxWidth / charWidth);
    while (line.length > 0) {
        lines.push(line.slice(0, maxLineLen));
        line = line.slice(maxLineLen);
    }
    lineWidth = Math.min(maxLineLen * charWidth, lineWidth);
    return { lineWidth, lines };
}
exports.splitIfTooBig = splitIfTooBig;

});

var perf_samples_profile = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.activate = exports.PERF_SAMPLES_PROFILE_TRACK_KIND = void 0;










exports.PERF_SAMPLES_PROFILE_TRACK_KIND = 'PerfSamplesProfileTrack';
class PerfSamplesProfileTrackController extends track_controller.TrackController {
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            if (this.config.upid === undefined) {
                return {
                    start,
                    end,
                    resolution,
                    length: 0,
                    tsStartsNs: new Float64Array(),
                };
            }
            const queryRes = yield this.query(`
     select ts, upid from perf_sample
     join thread using (utid)
     where upid = ${this.config.upid}
     and callsite_id is not null
     order by ts`);
            const numRows = queryRes.numRows();
            const data = {
                start,
                end,
                resolution,
                length: numRows,
                tsStartsNs: new Float64Array(numRows),
            };
            const it = queryRes.iter({ ts: query_result.NUM });
            for (let row = 0; it.valid(); it.next(), row++) {
                data.tsStartsNs[row] = it.ts;
            }
            return data;
        });
    }
}
PerfSamplesProfileTrackController.kind = exports.PERF_SAMPLES_PROFILE_TRACK_KIND;
const PERP_SAMPLE_COLOR = 'hsl(224, 45%, 70%)';
// 0.5 Makes the horizontal lines sharp.
const MARGIN_TOP = 4.5;
const RECT_HEIGHT = 30.5;
class PerfSamplesProfileTrack extends track.Track {
    constructor(args) {
        super(args);
        this.centerY = this.getHeight() / 2;
        this.markerWidth = (this.getHeight() - MARGIN_TOP) / 2;
        this.hoveredTs = undefined;
    }
    static create(args) {
        return new PerfSamplesProfileTrack(args);
    }
    getHeight() {
        return MARGIN_TOP + RECT_HEIGHT - 1;
    }
    renderCanvas(ctx) {
        const { timeScale, } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined)
            return;
        for (let i = 0; i < data.tsStartsNs.length; i++) {
            const centerX = data.tsStartsNs[i];
            const selection = globals.globals.state.currentSelection;
            const isHovered = this.hoveredTs === centerX;
            const isSelected = selection !== null &&
                selection.kind === 'PERF_SAMPLES' &&
                selection.leftTs <= centerX && selection.rightTs >= centerX;
            const strokeWidth = isSelected ? 3 : 0;
            this.drawMarker(ctx, timeScale.timeToPx((0, time.fromNs)(centerX)), this.centerY, isHovered, strokeWidth);
        }
    }
    drawMarker(ctx, x, y, isHovered, strokeWidth) {
        ctx.beginPath();
        ctx.moveTo(x, y - this.markerWidth);
        ctx.lineTo(x - this.markerWidth, y);
        ctx.lineTo(x, y + this.markerWidth);
        ctx.lineTo(x + this.markerWidth, y);
        ctx.lineTo(x, y - this.markerWidth);
        ctx.closePath();
        ctx.fillStyle = isHovered ? flamegraph.FLAMEGRAPH_HOVERED_COLOR : PERP_SAMPLE_COLOR;
        ctx.fill();
        if (strokeWidth > 0) {
            ctx.strokeStyle = flamegraph.FLAMEGRAPH_HOVERED_COLOR;
            ctx.lineWidth = strokeWidth;
            ctx.stroke();
        }
    }
    onMouseMove({ x, y }) {
        const data = this.data();
        if (data === undefined)
            return;
        const { timeScale } = globals.globals.frontendLocalState;
        const time$1 = (0, time.toNs)(timeScale.pxToTime(x));
        const [left, right] = (0, binary_search.searchSegment)(data.tsStartsNs, time$1);
        const index = this.findTimestampIndex(left, timeScale, data, x, y, right);
        this.hoveredTs = index === -1 ? undefined : data.tsStartsNs[index];
    }
    onMouseOut() {
        this.hoveredTs = undefined;
    }
    onMouseClick({ x, y }) {
        const data = this.data();
        if (data === undefined)
            return false;
        const { timeScale } = globals.globals.frontendLocalState;
        const time$1 = (0, time.toNs)(timeScale.pxToTime(x));
        const [left, right] = (0, binary_search.searchSegment)(data.tsStartsNs, time$1);
        const index = this.findTimestampIndex(left, timeScale, data, x, y, right);
        if (index !== -1) {
            const ts = data.tsStartsNs[index];
            globals.globals.makeSelection(actions.Actions.selectPerfSamples({
                id: index,
                upid: this.config.upid,
                leftTs: ts,
                rightTs: ts,
                type: state.ProfileType.PERF_SAMPLE,
            }));
            return true;
        }
        return false;
    }
    // If the markers overlap the rightmost one will be selected.
    findTimestampIndex(left, timeScale, data, x, y, right) {
        let index = -1;
        if (left !== -1) {
            const centerX = timeScale.timeToPx((0, time.fromNs)(data.tsStartsNs[left]));
            if (this.isInMarker(x, y, centerX)) {
                index = left;
            }
        }
        if (right !== -1) {
            const centerX = timeScale.timeToPx((0, time.fromNs)(data.tsStartsNs[right]));
            if (this.isInMarker(x, y, centerX)) {
                index = right;
            }
        }
        return index;
    }
    isInMarker(x, y, centerX) {
        return Math.abs(x - centerX) + Math.abs(y - this.centerY) <=
            this.markerWidth;
    }
}
PerfSamplesProfileTrack.kind = exports.PERF_SAMPLES_PROFILE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(PerfSamplesProfileTrackController);
    ctx.registerTrack(PerfSamplesProfileTrack);
}
exports.activate = activate;
exports.plugin = {
    pluginId: 'perfetto.PerfSamplesProfile',
    activate,
};

});

var area_selection_handler = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AreaSelectionHandler = void 0;

class AreaSelectionHandler {
    getAreaChange() {
        const currentSelection = globals.globals.state.currentSelection;
        if (currentSelection === null || currentSelection.kind !== 'AREA') {
            return [false, undefined];
        }
        const selectedArea = globals.globals.state.areas[currentSelection.areaId];
        // Area is considered changed if:
        // 1. The new area is defined and the old area undefined.
        // 2. The new area is undefined and the old area defined (viceversa from 1).
        // 3. Both areas are defined but their start or end times differ.
        // 4. Both areas are defined but their tracks differ.
        let hasAreaChanged = (!!this.previousArea !== !!selectedArea);
        if (selectedArea && this.previousArea) {
            // There seems to be an issue with clang-format http://shortn/_Pt98d5MCjG
            // where `a ||= b` is formatted to `a || = b`, by inserting a space which
            // breaks the operator.
            // Therefore, we are using the pattern `a = a || b` instead.
            hasAreaChanged = hasAreaChanged ||
                selectedArea.startSec !== this.previousArea.startSec;
            hasAreaChanged =
                hasAreaChanged || selectedArea.endSec !== this.previousArea.endSec;
            hasAreaChanged = hasAreaChanged ||
                selectedArea.tracks.length !== this.previousArea.tracks.length;
            for (let i = 0; i < selectedArea.tracks.length; ++i) {
                hasAreaChanged = hasAreaChanged ||
                    selectedArea.tracks[i] !== this.previousArea.tracks[i];
            }
        }
        if (hasAreaChanged) {
            this.previousArea = selectedArea;
        }
        return [hasAreaChanged, selectedArea];
    }
}
exports.AreaSelectionHandler = AreaSelectionHandler;

});

var flamegraph_controller = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlamegraphController = exports.profileType = void 0;












function profileType(s) {
    if (isProfileType(s)) {
        return s;
    }
    if (s.startsWith('heap_profile')) {
        return state.ProfileType.HEAP_PROFILE;
    }
    throw new Error('Unknown type ${s}');
}
exports.profileType = profileType;
function isProfileType(s) {
    return Object.values(state.ProfileType).includes(s);
}
function getFlamegraphType(type) {
    switch (type) {
        case state.ProfileType.HEAP_PROFILE:
        case state.ProfileType.NATIVE_HEAP_PROFILE:
        case state.ProfileType.JAVA_HEAP_PROFILE:
            return 'native';
        case state.ProfileType.JAVA_HEAP_GRAPH:
            return 'graph';
        case state.ProfileType.PERF_SAMPLE:
            return 'perf';
        default:
            throw new Error(`Unexpected profile type ${profileType}`);
    }
}
const MIN_PIXEL_DISPLAYED = 1;
class TablesCache {
    constructor(engine, prefix) {
        this.engine = engine;
        this.cache = new Map();
        this.prefix = prefix;
        this.tableId = 0;
        this.cacheSizeLimit = 10;
    }
    getTableName(query) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            let tableName = this.cache.get(query);
            if (tableName === undefined) {
                // TODO(hjd): This should be LRU.
                if (this.cache.size > this.cacheSizeLimit) {
                    for (const name of this.cache.values()) {
                        yield this.engine.query(`drop table ${name}`);
                    }
                    this.cache.clear();
                }
                tableName = `${this.prefix}_${this.tableId++}`;
                yield this.engine.query(`create temp table if not exists ${tableName} as ${query}`);
                this.cache.set(query, tableName);
            }
            return tableName;
        });
    }
}
class FlamegraphController extends controller.Controller {
    constructor(args) {
        super('main');
        this.args = args;
        this.flamegraphDatasets = new Map();
        this.requestingData = false;
        this.queuedRequest = false;
        this.flamegraphDetails = {};
        this.cache = new TablesCache(args.engine, 'grouped_callsites');
        this.areaSelectionHandler = new area_selection_handler.AreaSelectionHandler();
    }
    run() {
        const [hasAreaChanged, area] = this.areaSelectionHandler.getAreaChange();
        if (hasAreaChanged) {
            const upids = [];
            if (!area) {
                this.checkCompletionAndPublishFlamegraph(Object.assign(Object.assign({}, globals.globals.flamegraphDetails), { isInAreaSelection: false }));
                return;
            }
            for (const trackId of area.tracks) {
                const trackState = globals.globals.state.tracks[trackId];
                if (!trackState ||
                    trackState.kind !== perf_samples_profile.PERF_SAMPLES_PROFILE_TRACK_KIND) {
                    continue;
                }
                upids.push(trackState.config.upid);
            }
            if (upids.length === 0) {
                this.checkCompletionAndPublishFlamegraph(Object.assign(Object.assign({}, globals.globals.flamegraphDetails), { isInAreaSelection: false }));
                return;
            }
            globals.globals.dispatch(actions.Actions.openFlamegraph({
                upids,
                startNs: (0, time.toNs)(area.startSec),
                endNs: (0, time.toNs)(area.endSec),
                type: state.ProfileType.PERF_SAMPLE,
                viewingOption: flamegraph_util.PERF_SAMPLES_KEY,
            }));
        }
        const selection = globals.globals.state.currentFlamegraphState;
        if (!selection || !this.shouldRequestData(selection)) {
            return;
        }
        if (this.requestingData) {
            this.queuedRequest = true;
            return;
        }
        this.requestingData = true;
        this.assembleFlamegraphDetails(selection, area !== undefined);
    }
    assembleFlamegraphDetails(selection, isInAreaSelection) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const selectedFlamegraphState = Object.assign({}, selection);
            const flamegraphMetadata = yield this.getFlamegraphMetadata(selection.type, selectedFlamegraphState.startNs, selectedFlamegraphState.endNs, selectedFlamegraphState.upids);
            if (flamegraphMetadata !== undefined) {
                Object.assign(this.flamegraphDetails, flamegraphMetadata);
            }
            // TODO(hjd): Clean this up.
            if (this.lastSelectedFlamegraphState &&
                this.lastSelectedFlamegraphState.focusRegex !== selection.focusRegex) {
                this.flamegraphDatasets.clear();
            }
            this.lastSelectedFlamegraphState = Object.assign({}, selection);
            const expandedId = selectedFlamegraphState.expandedCallsite ?
                selectedFlamegraphState.expandedCallsite.id :
                -1;
            const rootSize = selectedFlamegraphState.expandedCallsite === undefined ?
                undefined :
                selectedFlamegraphState.expandedCallsite.totalSize;
            const key = `${selectedFlamegraphState.upids};${selectedFlamegraphState.startNs};${selectedFlamegraphState.endNs}`;
            try {
                const flamegraphData = yield this.getFlamegraphData(key, selectedFlamegraphState.viewingOption ?
                    selectedFlamegraphState.viewingOption :
                    flamegraph_util.DEFAULT_VIEWING_OPTION, selection.startNs, selection.endNs, selectedFlamegraphState.upids, selectedFlamegraphState.type, selectedFlamegraphState.focusRegex);
                if (flamegraphData !== undefined && selection &&
                    selection.kind === selectedFlamegraphState.kind &&
                    selection.startNs === selectedFlamegraphState.startNs &&
                    selection.endNs === selectedFlamegraphState.endNs) {
                    const expandedFlamegraphData = (0, flamegraph_util.expandCallsites)(flamegraphData, expandedId);
                    this.prepareAndMergeCallsites(expandedFlamegraphData, this.lastSelectedFlamegraphState.viewingOption, isInAreaSelection, rootSize, this.lastSelectedFlamegraphState.expandedCallsite);
                }
            }
            finally {
                this.requestingData = false;
                if (this.queuedRequest) {
                    this.queuedRequest = false;
                    this.run();
                }
            }
        });
    }
    shouldRequestData(selection) {
        return selection.kind === 'FLAMEGRAPH_STATE' &&
            (this.lastSelectedFlamegraphState === undefined ||
                (this.lastSelectedFlamegraphState.startNs !== selection.startNs ||
                    this.lastSelectedFlamegraphState.endNs !== selection.endNs ||
                    this.lastSelectedFlamegraphState.type !== selection.type ||
                    !FlamegraphController.areArraysEqual(this.lastSelectedFlamegraphState.upids, selection.upids) ||
                    this.lastSelectedFlamegraphState.viewingOption !==
                        selection.viewingOption ||
                    this.lastSelectedFlamegraphState.focusRegex !==
                        selection.focusRegex ||
                    this.lastSelectedFlamegraphState.expandedCallsite !==
                        selection.expandedCallsite));
    }
    prepareAndMergeCallsites(flamegraphData, viewingOption = flamegraph_util.DEFAULT_VIEWING_OPTION, isInAreaSelection, rootSize, expandedCallsite) {
        this.flamegraphDetails.flamegraph = (0, flamegraph_util.mergeCallsites)(flamegraphData, this.getMinSizeDisplayed(flamegraphData, rootSize));
        this.flamegraphDetails.expandedCallsite = expandedCallsite;
        this.flamegraphDetails.viewingOption = viewingOption;
        this.flamegraphDetails.isInAreaSelection = isInAreaSelection;
        this.checkCompletionAndPublishFlamegraph(this.flamegraphDetails);
    }
    checkCompletionAndPublishFlamegraph(flamegraphDetails) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            flamegraphDetails.graphIncomplete =
                (yield this.args.engine.query(`select value from stats
       where severity = 'error' and name = 'heap_graph_non_finalized_graph'`))
                    .firstRow({ value: query_result.NUM })
                    .value > 0;
            (0, publish.publishFlamegraphDetails)(flamegraphDetails);
        });
    }
    getFlamegraphData(baseKey, viewingOption, startNs, endNs, upids, type, focusRegex) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            let currentData;
            const key = `${baseKey}-${viewingOption}`;
            if (this.flamegraphDatasets.has(key)) {
                currentData = this.flamegraphDatasets.get(key);
            }
            else {
                // TODO(hjd): Show loading state.
                // Collecting data for drawing flamegraph for selected profile.
                // Data needs to be in following format:
                // id, name, parent_id, depth, total_size
                const tableName = yield this.prepareViewsAndTables(startNs, endNs, upids, type, focusRegex);
                currentData = yield this.getFlamegraphDataFromTables(tableName, viewingOption, focusRegex);
                this.flamegraphDatasets.set(key, currentData);
            }
            return currentData;
        });
    }
    getFlamegraphDataFromTables(tableName, viewingOption = flamegraph_util.DEFAULT_VIEWING_OPTION, focusRegex) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            let orderBy = '';
            let totalColumnName = 'cumulativeSize';
            let selfColumnName = 'size';
            // TODO(fmayer): Improve performance so this is no longer necessary.
            // Alternatively consider collapsing frames of the same label.
            const maxDepth = 100;
            switch (viewingOption) {
                case flamegraph_util.ALLOC_SPACE_MEMORY_ALLOCATED_KEY:
                    orderBy = `where cumulative_alloc_size > 0 and depth < ${maxDepth} order by depth, parent_id,
            cumulative_alloc_size desc, name`;
                    totalColumnName = 'cumulativeAllocSize';
                    selfColumnName = 'size';
                    break;
                case flamegraph_util.OBJECTS_ALLOCATED_NOT_FREED_KEY:
                    orderBy = `where cumulative_count > 0 and depth < ${maxDepth} order by depth, parent_id,
            cumulative_count desc, name`;
                    totalColumnName = 'cumulativeCount';
                    selfColumnName = 'count';
                    break;
                case flamegraph_util.OBJECTS_ALLOCATED_KEY:
                    orderBy = `where cumulative_alloc_count > 0 and depth < ${maxDepth} order by depth, parent_id,
            cumulative_alloc_count desc, name`;
                    totalColumnName = 'cumulativeAllocCount';
                    selfColumnName = 'count';
                    break;
                case flamegraph_util.PERF_SAMPLES_KEY:
                case flamegraph_util.SPACE_MEMORY_ALLOCATED_NOT_FREED_KEY:
                    orderBy = `where cumulative_size > 0 and depth < ${maxDepth} order by depth, parent_id,
            cumulative_size desc, name`;
                    totalColumnName = 'cumulativeSize';
                    selfColumnName = 'size';
                    break;
            }
            const callsites = yield this.args.engine.query(`
        SELECT
        id as hash,
        IFNULL(IFNULL(DEMANGLE(name), name), '[NULL]') as name,
        IFNULL(parent_id, -1) as parentHash,
        depth,
        cumulative_size as cumulativeSize,
        cumulative_alloc_size as cumulativeAllocSize,
        cumulative_count as cumulativeCount,
        cumulative_alloc_count as cumulativeAllocCount,
        map_name as mapping,
        size,
        count,
        IFNULL(source_file, '') as sourceFile,
        IFNULL(line_number, -1) as lineNumber
        from ${tableName} ${orderBy}`);
            const flamegraphData = [];
            const hashToindex = new Map();
            const it = callsites.iter({
                hash: query_result.NUM,
                name: query_result.STR,
                parentHash: query_result.NUM,
                depth: query_result.NUM,
                cumulativeSize: query_result.NUM,
                cumulativeAllocSize: query_result.NUM,
                cumulativeCount: query_result.NUM,
                cumulativeAllocCount: query_result.NUM,
                mapping: query_result.STR,
                sourceFile: query_result.STR,
                lineNumber: query_result.NUM,
                size: query_result.NUM,
                count: query_result.NUM,
            });
            for (let i = 0; it.valid(); ++i, it.next()) {
                const hash = it.hash;
                let name = it.name;
                const parentHash = it.parentHash;
                const depth = it.depth;
                const totalSize = it[totalColumnName];
                const selfSize = it[selfColumnName];
                const mapping = it.mapping;
                const highlighted = focusRegex !== '' &&
                    name.toLocaleLowerCase().includes(focusRegex.toLocaleLowerCase());
                const parentId = hashToindex.has(+parentHash) ? hashToindex.get(+parentHash) : -1;
                let location;
                if (/[a-zA-Z]/i.test(it.sourceFile)) {
                    location = it.sourceFile;
                    if (it.lineNumber !== -1) {
                        location += `:${it.lineNumber}`;
                    }
                }
                if (depth === maxDepth - 1) {
                    name += ' [tree truncated]';
                }
                // Instead of hash, we will store index of callsite in this original array
                // as an id of callsite. That way, we have quicker access to parent and it
                // will stay unique:
                hashToindex.set(hash, i);
                flamegraphData.push({
                    id: i,
                    totalSize,
                    depth,
                    parentId,
                    name,
                    selfSize,
                    mapping,
                    merged: false,
                    highlighted,
                    location,
                });
            }
            return flamegraphData;
        });
    }
    prepareViewsAndTables(startNs, endNs, upids, type, focusRegex) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            // Creating unique names for views so we can reuse and not delete them
            // for each marker.
            let focusRegexConditional = '';
            if (focusRegex !== '') {
                focusRegexConditional = `and focus_str = '${focusRegex}'`;
            }
            const flamegraphType = getFlamegraphType(type);
            /*
             * TODO(octaviant) this branching should be eliminated for simplicity.
             */
            if (type === state.ProfileType.PERF_SAMPLE) {
                let upidConditional = `upid = ${upids[0]}`;
                if (upids.length > 1) {
                    upidConditional =
                        `upid_group = '${FlamegraphController.serializeUpidGroup(upids)}'`;
                }
                return this.cache.getTableName(`select id, name, map_name, parent_id, depth, cumulative_size,
          cumulative_alloc_size, cumulative_count, cumulative_alloc_count,
          size, alloc_size, count, alloc_count, source_file, line_number
          from experimental_flamegraph
          where profile_type = '${flamegraphType}' and ${startNs} <= ts and
              ts <= ${endNs} and ${upidConditional}
          ${focusRegexConditional}`);
            }
            return this.cache.getTableName(`select id, name, map_name, parent_id, depth, cumulative_size,
          cumulative_alloc_size, cumulative_count, cumulative_alloc_count,
          size, alloc_size, count, alloc_count, source_file, line_number
          from experimental_flamegraph
          where profile_type = '${flamegraphType}'
            and ts = ${endNs}
            and upid = ${upids[0]}
            ${focusRegexConditional}`);
        });
    }
    getMinSizeDisplayed(flamegraphData, rootSize) {
        const timeState = globals$1.globals.state.frontendLocalState.visibleState;
        let width = (timeState.endSec - timeState.startSec) / timeState.resolution;
        // TODO(168048193): Remove screen size hack:
        width = Math.max(width, 800);
        if (rootSize === undefined) {
            rootSize = (0, flamegraph_util.findRootSize)(flamegraphData);
        }
        return MIN_PIXEL_DISPLAYED * rootSize / width;
    }
    getFlamegraphMetadata(type, startNs, endNs, upids) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            // Don't do anything if selection of the marker stayed the same.
            if ((this.lastSelectedFlamegraphState !== undefined &&
                ((this.lastSelectedFlamegraphState.startNs === startNs &&
                    this.lastSelectedFlamegraphState.endNs === endNs &&
                    FlamegraphController.areArraysEqual(this.lastSelectedFlamegraphState.upids, upids))))) {
                return undefined;
            }
            // Collecting data for more information about profile, such as:
            // total memory allocated, memory that is allocated and not freed.
            const upidGroup = FlamegraphController.serializeUpidGroup(upids);
            const result = yield this.args.engine.query(`select pid from process where upid in (${upidGroup})`);
            const it = result.iter({ pid: query_result.NUM });
            const pids = [];
            for (; it.valid(); it.next()) {
                pids.push(it.pid);
            }
            return { startNs, durNs: endNs - startNs, pids, upids, type };
        });
    }
    static areArraysEqual(a, b) {
        if (a.length !== b.length) {
            return false;
        }
        for (let i = 0; i < a.length; i++) {
            if (a[i] !== b[i]) {
                return false;
            }
        }
        return true;
    }
    static serializeUpidGroup(upids) {
        return new Array(upids).join();
    }
}
exports.FlamegraphController = FlamegraphController;

});

var heap_profile = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.HEAP_PROFILE_TRACK_KIND = void 0;










exports.HEAP_PROFILE_TRACK_KIND = 'HeapProfileTrack';
class HeapProfileTrackController extends track_controller.TrackController {
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            if (this.config.upid === undefined) {
                return {
                    start,
                    end,
                    resolution,
                    length: 0,
                    tsStarts: new Float64Array(),
                    types: new Array(),
                };
            }
            const queryRes = yield this.query(`
    select * from (
      select distinct
        ts,
        'heap_profile:' ||
          (select group_concat(distinct heap_name) from heap_profile_allocation
            where upid = ${this.config.upid}) AS type
      from heap_profile_allocation
      where upid = ${this.config.upid}
      union
      select distinct graph_sample_ts as ts, 'graph' as type
      from heap_graph_object
      where upid = ${this.config.upid}) order by ts`);
            const numRows = queryRes.numRows();
            const data = {
                start,
                end,
                resolution,
                length: numRows,
                tsStarts: new Float64Array(numRows),
                types: new Array(numRows),
            };
            const it = queryRes.iter({ ts: query_result.NUM, type: query_result.STR });
            for (let row = 0; it.valid(); it.next(), row++) {
                data.tsStarts[row] = it.ts;
                data.types[row] = (0, flamegraph_controller.profileType)(it.type);
            }
            return data;
        });
    }
}
HeapProfileTrackController.kind = exports.HEAP_PROFILE_TRACK_KIND;
const HEAP_PROFILE_COLOR = 'hsl(224, 45%, 70%)';
// 0.5 Makes the horizontal lines sharp.
const MARGIN_TOP = 4.5;
const RECT_HEIGHT = 30.5;
class HeapProfileTrack extends track.Track {
    constructor(args) {
        super(args);
        this.centerY = this.getHeight() / 2;
        this.markerWidth = (this.getHeight() - MARGIN_TOP) / 2;
        this.hoveredTs = undefined;
    }
    static create(args) {
        return new HeapProfileTrack(args);
    }
    getHeight() {
        return MARGIN_TOP + RECT_HEIGHT - 1;
    }
    renderCanvas(ctx) {
        const { timeScale, } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined)
            return;
        for (let i = 0; i < data.tsStarts.length; i++) {
            const centerX = data.tsStarts[i];
            const selection = globals.globals.state.currentSelection;
            const isHovered = this.hoveredTs === centerX;
            const isSelected = selection !== null &&
                selection.kind === 'HEAP_PROFILE' && selection.ts === centerX;
            const strokeWidth = isSelected ? 3 : 0;
            this.drawMarker(ctx, timeScale.timeToPx((0, time.fromNs)(centerX)), this.centerY, isHovered, strokeWidth);
        }
    }
    drawMarker(ctx, x, y, isHovered, strokeWidth) {
        ctx.beginPath();
        ctx.moveTo(x, y - this.markerWidth);
        ctx.lineTo(x - this.markerWidth, y);
        ctx.lineTo(x, y + this.markerWidth);
        ctx.lineTo(x + this.markerWidth, y);
        ctx.lineTo(x, y - this.markerWidth);
        ctx.closePath();
        ctx.fillStyle = isHovered ? flamegraph.FLAMEGRAPH_HOVERED_COLOR : HEAP_PROFILE_COLOR;
        ctx.fill();
        if (strokeWidth > 0) {
            ctx.strokeStyle = flamegraph.FLAMEGRAPH_HOVERED_COLOR;
            ctx.lineWidth = strokeWidth;
            ctx.stroke();
        }
    }
    onMouseMove({ x, y }) {
        const data = this.data();
        if (data === undefined)
            return;
        const { timeScale } = globals.globals.frontendLocalState;
        const time$1 = (0, time.toNs)(timeScale.pxToTime(x));
        const [left, right] = (0, binary_search.searchSegment)(data.tsStarts, time$1);
        const index = this.findTimestampIndex(left, timeScale, data, x, y, right);
        this.hoveredTs = index === -1 ? undefined : data.tsStarts[index];
    }
    onMouseOut() {
        this.hoveredTs = undefined;
    }
    onMouseClick({ x, y }) {
        const data = this.data();
        if (data === undefined)
            return false;
        const { timeScale } = globals.globals.frontendLocalState;
        const time$1 = (0, time.toNs)(timeScale.pxToTime(x));
        const [left, right] = (0, binary_search.searchSegment)(data.tsStarts, time$1);
        const index = this.findTimestampIndex(left, timeScale, data, x, y, right);
        if (index !== -1) {
            const ts = data.tsStarts[index];
            const type = data.types[index];
            globals.globals.makeSelection(actions.Actions.selectHeapProfile({ id: index, upid: this.config.upid, ts, type }));
            return true;
        }
        return false;
    }
    // If the markers overlap the rightmost one will be selected.
    findTimestampIndex(left, timeScale, data, x, y, right) {
        let index = -1;
        if (left !== -1) {
            const centerX = timeScale.timeToPx((0, time.fromNs)(data.tsStarts[left]));
            if (this.isInMarker(x, y, centerX)) {
                index = left;
            }
        }
        if (right !== -1) {
            const centerX = timeScale.timeToPx((0, time.fromNs)(data.tsStarts[right]));
            if (this.isInMarker(x, y, centerX)) {
                index = right;
            }
        }
        return index;
    }
    isInMarker(x, y, centerX) {
        return Math.abs(x - centerX) + Math.abs(y - this.centerY) <=
            this.markerWidth;
    }
}
HeapProfileTrack.kind = exports.HEAP_PROFILE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(HeapProfileTrackController);
    ctx.registerTrack(HeapProfileTrack);
}
exports.plugin = {
    pluginId: 'perfetto.HeapProfile',
    activate,
};

});

var null_track = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.NullTrack = exports.NULL_TRACK_KIND = void 0;

exports.NULL_TRACK_KIND = 'NullTrack';
class NullTrack extends track.Track {
    constructor(args) {
        super(args);
        this.frontendOnly = true;
    }
    static create(args) {
        return new NullTrack(args);
    }
    getHeight() {
        return 30;
    }
    renderCanvas(_) { }
}
exports.NullTrack = NullTrack;
NullTrack.kind = exports.NULL_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrack(NullTrack);
}
exports.plugin = {
    pluginId: 'perfetto.NullTrack',
    activate,
};

});

var process_scheduling = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.activate = exports.PROCESS_SCHEDULING_TRACK_KIND = void 0;











exports.PROCESS_SCHEDULING_TRACK_KIND = 'ProcessSchedulingTrack';
// This summary is displayed for any processes that have CPU scheduling activity
// associated with them.
class ProcessSchedulingTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.maxCpu = 0;
        this.maxDurNs = 0;
        this.cachedBucketNs = Number.MAX_SAFE_INTEGER;
    }
    onSetup() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.createSchedView();
            const cpus = yield this.engine.getCpus();
            // A process scheduling track should only exist in a trace that has cpus.
            (0, logging.assertTrue)(cpus.length > 0);
            this.maxCpu = Math.max(...cpus) + 1;
            const result = (yield this.query(`
      select ifnull(max(dur), 0) as maxDur, count(1) as count
      from ${this.tableName('process_sched')}
    `)).iter({ maxDur: query_result.NUM, count: query_result.NUM });
            (0, logging.assertTrue)(result.valid());
            this.maxDurNs = result.maxDur;
            const rowCount = result.count;
            const bucketNs = this.cachedBucketSizeNs(rowCount);
            if (bucketNs === undefined) {
                return;
            }
            yield this.query(`
      create table ${this.tableName('process_sched_cached')} as
      select
        (ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as cached_tsq,
        ts,
        max(dur) as dur,
        cpu,
        utid
      from ${this.tableName('process_sched')}
      group by cached_tsq, cpu
      order by cached_tsq, cpu
    `);
            this.cachedBucketNs = bucketNs;
        });
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            (0, logging.assertTrue)(this.config.upid !== null);
            // The resolution should always be a power of two for the logic of this
            // function to make sense.
            const resolutionNs = (0, time.toNs)(resolution);
            (0, logging.assertTrue)(Math.log2(resolutionNs) % 1 === 0);
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolutionNs * this.pxSize() / 2) * 2, 1);
            const queryRes = yield this.queryData(startNs, endNs, bucketNs);
            const numRows = queryRes.numRows();
            const slices = {
                kind: 'slice',
                start,
                end,
                resolution,
                length: numRows,
                maxCpu: this.maxCpu,
                starts: new Float64Array(numRows),
                ends: new Float64Array(numRows),
                cpus: new Uint32Array(numRows),
                utids: new Uint32Array(numRows),
            };
            const it = queryRes.iter({
                tsq: query_result.NUM,
                ts: query_result.NUM,
                dur: query_result.NUM,
                cpu: query_result.NUM,
                utid: query_result.NUM,
            });
            for (let row = 0; it.valid(); it.next(), row++) {
                const startNsQ = it.tsq;
                const startNs = it.ts;
                const durNs = it.dur;
                const endNs = startNs + durNs;
                let endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
                endNsQ = Math.max(endNsQ, startNsQ + bucketNs);
                slices.starts[row] = (0, time.fromNs)(startNsQ);
                slices.ends[row] = (0, time.fromNs)(endNsQ);
                slices.cpus[row] = it.cpu;
                slices.utids[row] = it.utid;
                slices.end = Math.max(slices.ends[row], slices.end);
            }
            return slices;
        });
    }
    queryData(startNs, endNs, bucketNs) {
        const isCached = this.cachedBucketNs <= bucketNs;
        const tsq = isCached ? `cached_tsq / ${bucketNs} * ${bucketNs}` :
            `(ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs}`;
        const queryTable = isCached ? this.tableName('process_sched_cached') :
            this.tableName('process_sched');
        const constraintColumn = isCached ? 'cached_tsq' : 'ts';
        return this.query(`
      select
        ${tsq} as tsq,
        ts,
        max(dur) as dur,
        cpu,
        utid
      from ${queryTable}
      where
        ${constraintColumn} >= ${startNs - this.maxDurNs} and
        ${constraintColumn} <= ${endNs}
      group by tsq, cpu
      order by tsq, cpu
    `);
    }
    createSchedView() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.query(`
      create view ${this.tableName('process_sched')} as
      select ts, dur, cpu, utid
      from experimental_sched_upid
      where
        utid != 0 and
        upid = ${this.config.upid}
    `);
        });
    }
}
ProcessSchedulingTrackController.kind = exports.PROCESS_SCHEDULING_TRACK_KIND;
const MARGIN_TOP = 5;
const RECT_HEIGHT = 30;
const TRACK_HEIGHT = MARGIN_TOP * 2 + RECT_HEIGHT;
class ProcessSchedulingTrack extends track.Track {
    constructor(args) {
        super(args);
        this.utidHoveredInThisTrack = -1;
    }
    static create(args) {
        return new ProcessSchedulingTrack(args);
    }
    getHeight() {
        return TRACK_HEIGHT;
    }
    renderCanvas(ctx) {
        // TODO: fonts and colors should come from the CSS and not hardcoded here.
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined)
            return; // Can't possibly draw anything.
        // If the cached trace slices don't fully cover the visible time range,
        // show a gray rectangle with a "Loading..." label.
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), timeScale.timeToPx(visibleWindowTime.start), timeScale.timeToPx(visibleWindowTime.end), timeScale.timeToPx(data.start), timeScale.timeToPx(data.end));
        (0, logging.assertTrue)(data.starts.length === data.ends.length);
        (0, logging.assertTrue)(data.starts.length === data.utids.length);
        const rawStartIdx = data.ends.findIndex((end) => end >= visibleWindowTime.start);
        const startIdx = rawStartIdx === -1 ? data.starts.length : rawStartIdx;
        const [, rawEndIdx] = (0, binary_search.searchSegment)(data.starts, visibleWindowTime.end);
        const endIdx = rawEndIdx === -1 ? data.starts.length : rawEndIdx;
        const cpuTrackHeight = Math.floor(RECT_HEIGHT / data.maxCpu);
        for (let i = startIdx; i < endIdx; i++) {
            const tStart = data.starts[i];
            const tEnd = data.ends[i];
            const utid = data.utids[i];
            const cpu = data.cpus[i];
            const rectStart = timeScale.timeToPx(tStart);
            const rectEnd = timeScale.timeToPx(tEnd);
            const rectWidth = rectEnd - rectStart;
            if (rectWidth < 0.3)
                continue;
            const threadInfo = globals.globals.threads.get(utid);
            const pid = (threadInfo ? threadInfo.pid : -1) || -1;
            const isHovering = globals.globals.state.hoveredUtid !== -1;
            const isThreadHovered = globals.globals.state.hoveredUtid === utid;
            const isProcessHovered = globals.globals.state.hoveredPid === pid;
            const color = (0, colorizer.colorForThread)(threadInfo);
            if (isHovering && !isThreadHovered) {
                if (!isProcessHovered) {
                    color.l = 90;
                    color.s = 0;
                }
                else {
                    color.l = Math.min(color.l + 30, 80);
                    color.s -= 20;
                }
            }
            else {
                color.l = Math.min(color.l + 10, 60);
                color.s -= 20;
            }
            ctx.fillStyle = `hsl(${color.h}, ${color.s}%, ${color.l}%)`;
            const y = MARGIN_TOP + cpuTrackHeight * cpu + cpu;
            ctx.fillRect(rectStart, y, rectEnd - rectStart, cpuTrackHeight);
        }
        const hoveredThread = globals.globals.threads.get(this.utidHoveredInThisTrack);
        if (hoveredThread !== undefined && this.mousePos !== undefined) {
            const tidText = `T: ${hoveredThread.threadName} [${hoveredThread.tid}]`;
            if (hoveredThread.pid) {
                const pidText = `P: ${hoveredThread.procName} [${hoveredThread.pid}]`;
                this.drawTrackHoverTooltip(ctx, this.mousePos, pidText, tidText);
            }
            else {
                this.drawTrackHoverTooltip(ctx, this.mousePos, tidText);
            }
        }
    }
    onMouseMove(pos) {
        const data = this.data();
        this.mousePos = pos;
        if (data === undefined)
            return;
        if (pos.y < MARGIN_TOP || pos.y > MARGIN_TOP + RECT_HEIGHT) {
            this.utidHoveredInThisTrack = -1;
            globals.globals.dispatch(actions.Actions.setHoveredUtidAndPid({ utid: -1, pid: -1 }));
            return;
        }
        const cpuTrackHeight = Math.floor(RECT_HEIGHT / data.maxCpu);
        const cpu = Math.floor((pos.y - MARGIN_TOP) / (cpuTrackHeight + 1));
        const { timeScale } = globals.globals.frontendLocalState;
        const t = timeScale.pxToTime(pos.x);
        const [i, j] = (0, binary_search.searchRange)(data.starts, t, (0, binary_search.searchEq)(data.cpus, cpu));
        if (i === j || i >= data.starts.length || t > data.ends[i]) {
            this.utidHoveredInThisTrack = -1;
            globals.globals.dispatch(actions.Actions.setHoveredUtidAndPid({ utid: -1, pid: -1 }));
            return;
        }
        const utid = data.utids[i];
        this.utidHoveredInThisTrack = utid;
        const threadInfo = globals.globals.threads.get(utid);
        const pid = threadInfo ? (threadInfo.pid ? threadInfo.pid : -1) : -1;
        globals.globals.dispatch(actions.Actions.setHoveredUtidAndPid({ utid, pid }));
    }
    onMouseOut() {
        this.utidHoveredInThisTrack = -1;
        globals.globals.dispatch(actions.Actions.setHoveredUtidAndPid({ utid: -1, pid: -1 }));
        this.mousePos = undefined;
    }
}
ProcessSchedulingTrack.kind = exports.PROCESS_SCHEDULING_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(ProcessSchedulingTrackController);
    ctx.registerTrack(ProcessSchedulingTrack);
}
exports.activate = activate;
exports.plugin = {
    pluginId: 'perfetto.ProcessScheduling',
    activate,
};

});

var process_summary = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.activate = exports.PROCESS_SUMMARY_TRACK = void 0;









exports.PROCESS_SUMMARY_TRACK = 'ProcessSummaryTrack';
// This is the summary displayed when a process only contains chrome slices
// and no cpu scheduling.
class ProcessSummaryTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.setup = false;
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            if (this.setup === false) {
                yield this.query(`create virtual table ${this.tableName('window')} using window;`);
                let utids = [this.config.utid];
                if (this.config.upid) {
                    const threadQuery = yield this.query(`select utid from thread where upid=${this.config.upid}`);
                    utids = [];
                    for (const it = threadQuery.iter({ utid: query_result.NUM }); it.valid(); it.next()) {
                        utids.push(it.utid);
                    }
                }
                const trackQuery = yield this.query(`select id from thread_track where utid in (${utids.join(',')})`);
                const tracks = [];
                for (const it = trackQuery.iter({ id: query_result.NUM }); it.valid(); it.next()) {
                    tracks.push(it.id);
                }
                const processSliceView = this.tableName('process_slice_view');
                yield this.query(`create view ${processSliceView} as ` +
                    // 0 as cpu is a dummy column to perform span join on.
                    `select ts, dur/${utids.length} as dur ` +
                    `from slice s ` +
                    `where depth = 0 and track_id in ` +
                    `(${tracks.join(',')})`);
                yield this.query(`create virtual table ${this.tableName('span')}
          using span_join(${processSliceView},
                          ${this.tableName('window')});`);
                this.setup = true;
            }
            // |resolution| is in s/px we want # ns for 10px window:
            // Max value with 1 so we don't end up with resolution 0.
            const bucketSizeNs = Math.max(1, Math.round(resolution * 10 * 1e9));
            const windowStartNs = Math.floor(startNs / bucketSizeNs) * bucketSizeNs;
            const windowDurNs = Math.max(1, endNs - windowStartNs);
            yield this.query(`update ${this.tableName('window')} set
      window_start=${windowStartNs},
      window_dur=${windowDurNs},
      quantum=${bucketSizeNs}
      where rowid = 0;`);
            return this.computeSummary((0, time.fromNs)(windowStartNs), end, resolution, bucketSizeNs);
        });
    }
    computeSummary(start, end, resolution, bucketSizeNs) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            const numBuckets = Math.min(Math.ceil((endNs - startNs) / bucketSizeNs), track_data.LIMIT);
            const query = `select
      quantum_ts as bucket,
      sum(dur)/cast(${bucketSizeNs} as float) as utilization
      from ${this.tableName('span')}
      group by quantum_ts
      limit ${track_data.LIMIT}`;
            const summary = {
                start,
                end,
                resolution,
                length: numBuckets,
                bucketSizeSeconds: (0, time.fromNs)(bucketSizeNs),
                utilizations: new Float64Array(numBuckets),
            };
            const queryRes = yield this.query(query);
            const it = queryRes.iter({ bucket: query_result.NUM, utilization: query_result.NUM });
            for (; it.valid(); it.next()) {
                const bucket = it.bucket;
                if (bucket > numBuckets) {
                    continue;
                }
                summary.utilizations[bucket] = it.utilization;
            }
            return summary;
        });
    }
    onDestroy() {
        if (this.setup) {
            this.query(`drop table ${this.tableName('window')}`);
            this.query(`drop table ${this.tableName('span')}`);
            this.setup = false;
        }
    }
}
ProcessSummaryTrackController.kind = exports.PROCESS_SUMMARY_TRACK;
const MARGIN_TOP = 5;
const RECT_HEIGHT = 30;
const TRACK_HEIGHT = MARGIN_TOP * 2 + RECT_HEIGHT;
const SUMMARY_HEIGHT = TRACK_HEIGHT - MARGIN_TOP;
class ProcessSummaryTrack extends track.Track {
    constructor(args) {
        super(args);
    }
    static create(args) {
        return new ProcessSummaryTrack(args);
    }
    getHeight() {
        return TRACK_HEIGHT;
    }
    renderCanvas(ctx) {
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const data = this.data();
        if (data === undefined)
            return; // Can't possibly draw anything.
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), timeScale.timeToPx(visibleWindowTime.start), timeScale.timeToPx(visibleWindowTime.end), timeScale.timeToPx(data.start), timeScale.timeToPx(data.end));
        this.renderSummary(ctx, data);
    }
    // TODO(dproy): Dedup with CPU slices.
    renderSummary(ctx, data) {
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const startPx = Math.floor(timeScale.timeToPx(visibleWindowTime.start));
        const bottomY = TRACK_HEIGHT;
        let lastX = startPx;
        let lastY = bottomY;
        // TODO(hjd): Dedupe this math.
        const color = (0, colorizer.colorForTid)(this.config.pidForColor);
        color.l = Math.min(color.l + 10, 60);
        color.s -= 20;
        ctx.fillStyle = `hsl(${color.h}, ${color.s}%, ${color.l}%)`;
        ctx.beginPath();
        ctx.moveTo(lastX, lastY);
        for (let i = 0; i < data.utilizations.length; i++) {
            // TODO(dproy): Investigate why utilization is > 1 sometimes.
            const utilization = Math.min(data.utilizations[i], 1);
            const startTime = i * data.bucketSizeSeconds + data.start;
            lastX = Math.floor(timeScale.timeToPx(startTime));
            ctx.lineTo(lastX, lastY);
            lastY = MARGIN_TOP + Math.round(SUMMARY_HEIGHT * (1 - utilization));
            ctx.lineTo(lastX, lastY);
        }
        ctx.lineTo(lastX, bottomY);
        ctx.closePath();
        ctx.fill();
    }
}
ProcessSummaryTrack.kind = exports.PROCESS_SUMMARY_TRACK;
function activate(ctx) {
    ctx.registerTrack(ProcessSummaryTrack);
    ctx.registerTrackController(ProcessSummaryTrackController);
}
exports.activate = activate;
exports.plugin = {
    pluginId: 'perfetto.ProcessSummary',
    activate,
};

});

var thread_state = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.translateState = void 0;
const states = {
    'R': 'Runnable',
    'S': 'Sleeping',
    'D': 'Uninterruptible Sleep',
    'T': 'Stopped',
    't': 'Traced',
    'X': 'Exit (Dead)',
    'Z': 'Exit (Zombie)',
    'x': 'Task Dead',
    'I': 'Task Dead',
    'K': 'Wake Kill',
    'W': 'Waking',
    'P': 'Parked',
    'N': 'No Load',
    '+': '(Preempted)',
};
function translateState(state, ioWait = undefined) {
    if (state === undefined)
        return '';
    if (state === 'Running') {
        return state;
    }
    if (state === null) {
        return 'Unknown';
    }
    let result = states[state[0]];
    if (ioWait === true) {
        result += ' (IO)';
    }
    else if (ioWait === false) {
        result += ' (non-IO)';
    }
    for (let i = 1; i < state.length; i++) {
        result += state[i] === '+' ? ' ' : ' + ';
        result += states[state[i]];
    }
    // state is some string we don't know how to translate.
    if (result === undefined)
        return state;
    return result;
}
exports.translateState = translateState;

});

var thread_state$1 = createCommonjsModule(function (module, exports) {
// Copyright (C) 2021 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.THREAD_STATE_TRACK_KIND = void 0;













exports.THREAD_STATE_TRACK_KIND = 'ThreadStateTrack';
class ThreadStateTrackController extends track_controller.TrackController {
    constructor() {
        super(...arguments);
        this.maxDurNs = 0;
    }
    onSetup() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.query(`
      create view ${this.tableName('thread_state')} as
      select
        id,
        ts,
        dur,
        cpu,
        state,
        io_wait as ioWait
      from thread_state
      where utid = ${this.config.utid} and utid != 0
    `);
            const queryRes = yield this.query(`
      select ifnull(max(dur), 0) as maxDur
      from ${this.tableName('thread_state')}
    `);
            this.maxDurNs = queryRes.firstRow({ maxDur: query_result.NUM }).maxDur;
        });
    }
    onBoundsChange(start, end, resolution) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const resolutionNs = (0, time.toNs)(resolution);
            const startNs = (0, time.toNs)(start);
            const endNs = (0, time.toNs)(end);
            // ns per quantization bucket (i.e. ns per pixel). /2 * 2 is to force it to
            // be an even number, so we can snap in the middle.
            const bucketNs = Math.max(Math.round(resolutionNs * this.pxSize() / 2) * 2, 1);
            const query = `
      select
        (ts + ${bucketNs / 2}) / ${bucketNs} * ${bucketNs} as tsq,
        ts,
        state = 'S' as is_sleep,
        max(dur) as dur,
        ifnull(cast(cpu as integer), -1) as cpu,
        state,
        ioWait,
        ifnull(id, -1) as id
      from ${this.tableName('thread_state')}
      where
        ts >= ${startNs - this.maxDurNs} and
        ts <= ${endNs}
      group by tsq, is_sleep
      order by tsq
    `;
            const queryRes = yield this.query(query);
            const numRows = queryRes.numRows();
            const data = {
                start,
                end,
                resolution,
                length: numRows,
                ids: new Float64Array(numRows),
                starts: new Float64Array(numRows),
                ends: new Float64Array(numRows),
                strings: [],
                state: new Uint16Array(numRows),
                cpu: new Int8Array(numRows),
            };
            const stringIndexes = new Map();
            function internState(shortState, ioWait) {
                let idx = stringIndexes.get({ shortState, ioWait });
                if (idx !== undefined)
                    return idx;
                idx = data.strings.length;
                data.strings.push((0, thread_state.translateState)(shortState, ioWait));
                stringIndexes.set({ shortState, ioWait }, idx);
                return idx;
            }
            const it = queryRes.iter({
                'tsq': query_result.NUM,
                'ts': query_result.NUM,
                'dur': query_result.NUM,
                'cpu': query_result.NUM,
                'state': query_result.STR_NULL,
                'ioWait': query_result.NUM_NULL,
                'id': query_result.NUM,
            });
            for (let row = 0; it.valid(); it.next(), row++) {
                const startNsQ = it.tsq;
                const startNs = it.ts;
                const durNs = it.dur;
                const endNs = startNs + durNs;
                let endNsQ = Math.floor((endNs + bucketNs / 2 - 1) / bucketNs) * bucketNs;
                endNsQ = Math.max(endNsQ, startNsQ + bucketNs);
                const cpu = it.cpu;
                const state = it.state || undefined;
                const ioWait = it.ioWait === null ? undefined : !!it.ioWait;
                const id = it.id;
                // We should never have the end timestamp being the same as the bucket
                // start.
                (0, logging.assertFalse)(startNsQ === endNsQ);
                data.starts[row] = (0, time.fromNs)(startNsQ);
                data.ends[row] = (0, time.fromNs)(endNsQ);
                data.state[row] = internState(state, ioWait);
                data.ids[row] = id;
                data.cpu[row] = cpu;
            }
            return data;
        });
    }
    onDestroy() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            yield this.query(`drop view if exists ${this.tableName('thread_state')}`);
        });
    }
}
ThreadStateTrackController.kind = exports.THREAD_STATE_TRACK_KIND;
const MARGIN_TOP = 4;
const RECT_HEIGHT = 14;
const EXCESS_WIDTH = 10;
class ThreadStateTrack extends track.Track {
    constructor(args) {
        super(args);
    }
    static create(args) {
        return new ThreadStateTrack(args);
    }
    getHeight() {
        return 2 * MARGIN_TOP + RECT_HEIGHT;
    }
    renderCanvas(ctx) {
        const { timeScale, visibleWindowTime } = globals.globals.frontendLocalState;
        const data = this.data();
        const charWidth = ctx.measureText('dbpqaouk').width / 8;
        if (data === undefined)
            return; // Can't possibly draw anything.
        // The draw of the rect on the selected slice must happen after the other
        // drawings, otherwise it would result under another rect.
        let drawRectOnSelected = () => { };
        (0, checkerboard_1.checkerboardExcept)(ctx, this.getHeight(), timeScale.timeToPx(visibleWindowTime.start), timeScale.timeToPx(visibleWindowTime.end), timeScale.timeToPx(data.start), timeScale.timeToPx(data.end));
        ctx.textAlign = 'center';
        ctx.font = '10px Roboto Condensed';
        for (let i = 0; i < data.starts.length; i++) {
            // NOTE: Unlike userspace and scheduling slices, thread state slices are
            // allowed to overlap; specifically, sleeping slices are allowed to
            // overlap with non-sleeping slices. We do this because otherwise
            // sleeping slices generally dominate traces making it seem like there are
            // no running/runnable etc. slices until you zoom in. By drawing both,
            // we get a more accurate representation of the trace and prevent weird
            // artifacts when zooming.
            // See b/201793731 for an example of why we do this.
            const tStart = data.starts[i];
            const tEnd = data.ends[i];
            const state = data.strings[data.state[i]];
            if (tEnd <= visibleWindowTime.start || tStart >= visibleWindowTime.end) {
                continue;
            }
            // Don't display a slice for Task Dead.
            if (state === 'x')
                continue;
            const rectStart = timeScale.timeToPx(tStart);
            const rectEnd = timeScale.timeToPx(tEnd);
            const rectWidth = rectEnd - rectStart;
            const currentSelection = globals.globals.state.currentSelection;
            const isSelected = currentSelection &&
                currentSelection.kind === 'THREAD_STATE' &&
                currentSelection.id === data.ids[i];
            const color = (0, colorizer.colorForState)(state);
            let colorStr = `hsl(${color.h},${color.s}%,${color.l}%)`;
            if (color.a) {
                colorStr = `hsla(${color.h},${color.s}%,${color.l}%, ${color.a})`;
            }
            ctx.fillStyle = colorStr;
            ctx.fillRect(rectStart, MARGIN_TOP, rectWidth, RECT_HEIGHT);
            // Don't render text when we have less than 10px to play with.
            if (rectWidth < 10 || state === 'Sleeping')
                continue;
            const title = (0, canvas_utils.cropText)(state, charWidth, rectWidth);
            const rectXCenter = rectStart + rectWidth / 2;
            ctx.fillStyle = color.l > 80 ? '#404040' : '#fff';
            ctx.fillText(title, rectXCenter, MARGIN_TOP + RECT_HEIGHT / 2 + 3);
            if (isSelected) {
                drawRectOnSelected = () => {
                    const rectStart = Math.max(0 - EXCESS_WIDTH, timeScale.timeToPx(tStart));
                    const rectEnd = Math.min(timeScale.timeToPx(visibleWindowTime.end) + EXCESS_WIDTH, timeScale.timeToPx(tEnd));
                    const color = (0, colorizer.colorForState)(state);
                    ctx.strokeStyle = `hsl(${color.h},${color.s}%,${color.l * 0.7}%)`;
                    ctx.beginPath();
                    ctx.lineWidth = 3;
                    ctx.strokeRect(rectStart, MARGIN_TOP - 1.5, rectEnd - rectStart, RECT_HEIGHT + 3);
                    ctx.closePath();
                };
            }
        }
        drawRectOnSelected();
    }
    onMouseClick({ x }) {
        const data = this.data();
        if (data === undefined)
            return false;
        const { timeScale } = globals.globals.frontendLocalState;
        const time = timeScale.pxToTime(x);
        const index = (0, binary_search.search)(data.starts, time);
        if (index === -1)
            return false;
        const id = data.ids[index];
        globals.globals.makeSelection(actions.Actions.selectThreadState({ id, trackId: this.trackState.id }));
        return true;
    }
}
ThreadStateTrack.kind = exports.THREAD_STATE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrack(ThreadStateTrack);
    ctx.registerTrackController(ThreadStateTrackController);
}
exports.plugin = {
    pluginId: 'perfetto.ThreadState',
    activate,
};

});

var visualised_args = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = exports.VisualisedArgsTrack = exports.VISUALISED_ARGS_SLICE_TRACK_KIND = void 0;





exports.VISUALISED_ARGS_SLICE_TRACK_KIND = 'VisualisedArgsTrack';
// The controller for arg visualisation is exactly the same as the controller
// for Chrome slices. All customisation is done on the frontend.
class VisualisedArgsTrackController extends chrome_slices.ChromeSliceTrackController {
}
VisualisedArgsTrackController.kind = exports.VISUALISED_ARGS_SLICE_TRACK_KIND;
class VisualisedArgsTrack extends chrome_slices.ChromeSliceTrack {
    static create(args) {
        return new VisualisedArgsTrack(args);
    }
    getFont() {
        return 'italic 11px Roboto';
    }
    getTrackShellButtons() {
        const config = this.config;
        const buttons = [];
        buttons.push(mithril(track_panel.TrackButton, {
            action: () => {
                globals.globals.dispatch(actions.Actions.removeVisualisedArg({ argName: config.argName }));
            },
            i: 'close',
            tooltip: 'Close',
            showButton: true,
        }));
        return buttons;
    }
}
exports.VisualisedArgsTrack = VisualisedArgsTrack;
VisualisedArgsTrack.kind = exports.VISUALISED_ARGS_SLICE_TRACK_KIND;
function activate(ctx) {
    ctx.registerTrackController(VisualisedArgsTrackController);
    ctx.registerTrack(VisualisedArgsTrack);
}
exports.plugin = {
    pluginId: 'perfetto.VisualisedArgs',
    activate,
};

});

createCommonjsModule(function (module, exports) {
Object.defineProperty(exports, "__esModule", { value: true });




















plugins.pluginRegistry.register(actual_frames.plugin);
plugins.pluginRegistry.register(android_log.plugin);
plugins.pluginRegistry.register(async_slices.plugin);
plugins.pluginRegistry.register(chrome_scroll_jank.plugin);
plugins.pluginRegistry.register(chrome_slices.plugin);
plugins.pluginRegistry.register(counter.plugin);
plugins.pluginRegistry.register(cpu_freq.plugin);
plugins.pluginRegistry.register(cpu_profile.plugin);
plugins.pluginRegistry.register(cpu_slices.plugin);
plugins.pluginRegistry.register(debug_slices.plugin);
plugins.pluginRegistry.register(expected_frames.plugin);
plugins.pluginRegistry.register(generic_slice_track.plugin);
plugins.pluginRegistry.register(heap_profile.plugin);
plugins.pluginRegistry.register(null_track.plugin);
plugins.pluginRegistry.register(perf_samples_profile.plugin);
plugins.pluginRegistry.register(process_scheduling.plugin);
plugins.pluginRegistry.register(process_summary.plugin);
plugins.pluginRegistry.register(thread_state$1.plugin);
plugins.pluginRegistry.register(visualised_args.plugin);

});

var adb_over_webusb_utils = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.findInterfaceAndEndpoint = exports.ADB_DEVICE_FILTER = void 0;
exports.ADB_DEVICE_FILTER = {
    classCode: 255,
    subclassCode: 66,
    protocolCode: 1, // Adb protocol
};
function findInterfaceAndEndpoint(device) {
    const adbDeviceFilter = exports.ADB_DEVICE_FILTER;
    for (const config of device.configurations) {
        for (const interface_ of config.interfaces) {
            for (const alt of interface_.alternates) {
                if (alt.interfaceClass === adbDeviceFilter.classCode &&
                    alt.interfaceSubclass === adbDeviceFilter.subclassCode &&
                    alt.interfaceProtocol === adbDeviceFilter.protocolCode) {
                    return {
                        configurationValue: config.configurationValue,
                        usbInterfaceNumber: interface_.interfaceNumber,
                        endpoints: alt.endpoints,
                    };
                } // if (alternate)
            } // for (interface.alternates)
        } // for (configuration.interfaces)
    } // for (configurations)
    return undefined;
}
exports.findInterfaceAndEndpoint = findInterfaceAndEndpoint;

});

var jsbn = createCommonjsModule(function (module, exports) {
(function() {

// Copyright (c) 2005  Tom Wu
// All Rights Reserved.
// See "LICENSE" for details.

// Basic JavaScript BN library - subset useful for RSA encryption.

var inBrowser =
    typeof navigator !== 'undefined' && typeof window !== 'undefined';

// Bits per digit
var dbits;

// JavaScript engine analysis
var canary = 0xdeadbeefcafe;
var j_lm = ((canary & 0xffffff) == 0xefcafe);

// (public) Constructor
function BigInteger(a, b, c) {
  if (a != null)
    if ('number' == typeof a)
      this.fromNumber(a, b, c);
    else if (b == null && 'string' != typeof a)
      this.fromString(a, 256);
    else
      this.fromString(a, b);
}

// return new, unset BigInteger
function nbi() {
  return new BigInteger(null);
}

// am: Compute w_j += (x*this_i), propagate carries,
// c is initial carry, returns final carry.
// c < 3*dvalue, x < 2*dvalue, this_i < dvalue
// We need to select the fastest one that works in this environment.

// am1: use a single mult and divide to get the high bits,
// max digit bits should be 26 because
// max internal value = 2*dvalue^2-2*dvalue (< 2^53)
function am1(i, x, w, j, c, n) {
  while (--n >= 0) {
    var v = x * this[i++] + w[j] + c;
    c = Math.floor(v / 0x4000000);
    w[j++] = v & 0x3ffffff;
  }
  return c;
}
// am2 avoids a big mult-and-extract completely.
// Max digit bits should be <= 30 because we do bitwise ops
// on values up to 2*hdvalue^2-hdvalue-1 (< 2^31)
function am2(i, x, w, j, c, n) {
  var xl = x & 0x7fff, xh = x >> 15;
  while (--n >= 0) {
    var l = this[i] & 0x7fff;
    var h = this[i++] >> 15;
    var m = xh * l + h * xl;
    l = xl * l + ((m & 0x7fff) << 15) + w[j] + (c & 0x3fffffff);
    c = (l >>> 30) + (m >>> 15) + xh * h + (c >>> 30);
    w[j++] = l & 0x3fffffff;
  }
  return c;
}
// Alternately, set max digit bits to 28 since some
// browsers slow down when dealing with 32-bit numbers.
function am3(i, x, w, j, c, n) {
  var xl = x & 0x3fff, xh = x >> 14;
  while (--n >= 0) {
    var l = this[i] & 0x3fff;
    var h = this[i++] >> 14;
    var m = xh * l + h * xl;
    l = xl * l + ((m & 0x3fff) << 14) + w[j] + c;
    c = (l >> 28) + (m >> 14) + xh * h;
    w[j++] = l & 0xfffffff;
  }
  return c;
}
if (inBrowser && j_lm && (navigator.appName == 'Microsoft Internet Explorer')) {
  BigInteger.prototype.am = am2;
  dbits = 30;
} else if (inBrowser && j_lm && (navigator.appName != 'Netscape')) {
  BigInteger.prototype.am = am1;
  dbits = 26;
} else {  // Mozilla/Netscape seems to prefer am3
  BigInteger.prototype.am = am3;
  dbits = 28;
}

BigInteger.prototype.DB = dbits;
BigInteger.prototype.DM = ((1 << dbits) - 1);
BigInteger.prototype.DV = (1 << dbits);

var BI_FP = 52;
BigInteger.prototype.FV = Math.pow(2, BI_FP);
BigInteger.prototype.F1 = BI_FP - dbits;
BigInteger.prototype.F2 = 2 * dbits - BI_FP;

// Digit conversions
var BI_RM = '0123456789abcdefghijklmnopqrstuvwxyz';
var BI_RC = new Array();
var rr, vv;
rr = '0'.charCodeAt(0);
for (vv = 0; vv <= 9; ++vv) BI_RC[rr++] = vv;
rr = 'a'.charCodeAt(0);
for (vv = 10; vv < 36; ++vv) BI_RC[rr++] = vv;
rr = 'A'.charCodeAt(0);
for (vv = 10; vv < 36; ++vv) BI_RC[rr++] = vv;

function int2char(n) {
  return BI_RM.charAt(n);
}
function intAt(s, i) {
  var c = BI_RC[s.charCodeAt(i)];
  return (c == null) ? -1 : c;
}

// (protected) copy this to r
function bnpCopyTo(r) {
  for (var i = this.t - 1; i >= 0; --i) r[i] = this[i];
  r.t = this.t;
  r.s = this.s;
}

// (protected) set from integer value x, -DV <= x < DV
function bnpFromInt(x) {
  this.t = 1;
  this.s = (x < 0) ? -1 : 0;
  if (x > 0)
    this[0] = x;
  else if (x < -1)
    this[0] = x + this.DV;
  else
    this.t = 0;
}

// return bigint initialized to value
function nbv(i) {
  var r = nbi();
  r.fromInt(i);
  return r;
}

// (protected) set from string and radix
function bnpFromString(s, b) {
  var k;
  if (b == 16)
    k = 4;
  else if (b == 8)
    k = 3;
  else if (b == 256)
    k = 8;  // byte array
  else if (b == 2)
    k = 1;
  else if (b == 32)
    k = 5;
  else if (b == 4)
    k = 2;
  else {
    this.fromRadix(s, b);
    return;
  }
  this.t = 0;
  this.s = 0;
  var i = s.length, mi = false, sh = 0;
  while (--i >= 0) {
    var x = (k == 8) ? s[i] & 0xff : intAt(s, i);
    if (x < 0) {
      if (s.charAt(i) == '-') mi = true;
      continue;
    }
    mi = false;
    if (sh == 0)
      this[this.t++] = x;
    else if (sh + k > this.DB) {
      this[this.t - 1] |= (x & ((1 << (this.DB - sh)) - 1)) << sh;
      this[this.t++] = (x >> (this.DB - sh));
    } else
      this[this.t - 1] |= x << sh;
    sh += k;
    if (sh >= this.DB) sh -= this.DB;
  }
  if (k == 8 && (s[0] & 0x80) != 0) {
    this.s = -1;
    if (sh > 0) this[this.t - 1] |= ((1 << (this.DB - sh)) - 1) << sh;
  }
  this.clamp();
  if (mi) BigInteger.ZERO.subTo(this, this);
}

// (protected) clamp off excess high words
function bnpClamp() {
  var c = this.s & this.DM;
  while (this.t > 0 && this[this.t - 1] == c) --this.t;
}

// (public) return string representation in given radix
function bnToString(b) {
  if (this.s < 0) return '-' + this.negate().toString(b);
  var k;
  if (b == 16)
    k = 4;
  else if (b == 8)
    k = 3;
  else if (b == 2)
    k = 1;
  else if (b == 32)
    k = 5;
  else if (b == 4)
    k = 2;
  else
    return this.toRadix(b);
  var km = (1 << k) - 1, d, m = false, r = '', i = this.t;
  var p = this.DB - (i * this.DB) % k;
  if (i-- > 0) {
    if (p < this.DB && (d = this[i] >> p) > 0) {
      m = true;
      r = int2char(d);
    }
    while (i >= 0) {
      if (p < k) {
        d = (this[i] & ((1 << p) - 1)) << (k - p);
        d |= this[--i] >> (p += this.DB - k);
      } else {
        d = (this[i] >> (p -= k)) & km;
        if (p <= 0) {
          p += this.DB;
          --i;
        }
      }
      if (d > 0) m = true;
      if (m) r += int2char(d);
    }
  }
  return m ? r : '0';
}

// (public) -this
function bnNegate() {
  var r = nbi();
  BigInteger.ZERO.subTo(this, r);
  return r;
}

// (public) |this|
function bnAbs() {
  return (this.s < 0) ? this.negate() : this;
}

// (public) return + if this > a, - if this < a, 0 if equal
function bnCompareTo(a) {
  var r = this.s - a.s;
  if (r != 0) return r;
  var i = this.t;
  r = i - a.t;
  if (r != 0) return (this.s < 0) ? -r : r;
  while (--i >= 0)
    if ((r = this[i] - a[i]) != 0) return r;
  return 0;
}

// returns bit length of the integer x
function nbits(x) {
  var r = 1, t;
  if ((t = x >>> 16) != 0) {
    x = t;
    r += 16;
  }
  if ((t = x >> 8) != 0) {
    x = t;
    r += 8;
  }
  if ((t = x >> 4) != 0) {
    x = t;
    r += 4;
  }
  if ((t = x >> 2) != 0) {
    x = t;
    r += 2;
  }
  if ((t = x >> 1) != 0) {
    x = t;
    r += 1;
  }
  return r;
}

// (public) return the number of bits in "this"
function bnBitLength() {
  if (this.t <= 0) return 0;
  return this.DB * (this.t - 1) + nbits(this[this.t - 1] ^ (this.s & this.DM));
}

// (protected) r = this << n*DB
function bnpDLShiftTo(n, r) {
  var i;
  for (i = this.t - 1; i >= 0; --i) r[i + n] = this[i];
  for (i = n - 1; i >= 0; --i) r[i] = 0;
  r.t = this.t + n;
  r.s = this.s;
}

// (protected) r = this >> n*DB
function bnpDRShiftTo(n, r) {
  for (var i = n; i < this.t; ++i) r[i - n] = this[i];
  r.t = Math.max(this.t - n, 0);
  r.s = this.s;
}

// (protected) r = this << n
function bnpLShiftTo(n, r) {
  var bs = n % this.DB;
  var cbs = this.DB - bs;
  var bm = (1 << cbs) - 1;
  var ds = Math.floor(n / this.DB), c = (this.s << bs) & this.DM, i;
  for (i = this.t - 1; i >= 0; --i) {
    r[i + ds + 1] = (this[i] >> cbs) | c;
    c = (this[i] & bm) << bs;
  }
  for (i = ds - 1; i >= 0; --i) r[i] = 0;
  r[ds] = c;
  r.t = this.t + ds + 1;
  r.s = this.s;
  r.clamp();
}

// (protected) r = this >> n
function bnpRShiftTo(n, r) {
  r.s = this.s;
  var ds = Math.floor(n / this.DB);
  if (ds >= this.t) {
    r.t = 0;
    return;
  }
  var bs = n % this.DB;
  var cbs = this.DB - bs;
  var bm = (1 << bs) - 1;
  r[0] = this[ds] >> bs;
  for (var i = ds + 1; i < this.t; ++i) {
    r[i - ds - 1] |= (this[i] & bm) << cbs;
    r[i - ds] = this[i] >> bs;
  }
  if (bs > 0) r[this.t - ds - 1] |= (this.s & bm) << cbs;
  r.t = this.t - ds;
  r.clamp();
}

// (protected) r = this - a
function bnpSubTo(a, r) {
  var i = 0, c = 0, m = Math.min(a.t, this.t);
  while (i < m) {
    c += this[i] - a[i];
    r[i++] = c & this.DM;
    c >>= this.DB;
  }
  if (a.t < this.t) {
    c -= a.s;
    while (i < this.t) {
      c += this[i];
      r[i++] = c & this.DM;
      c >>= this.DB;
    }
    c += this.s;
  } else {
    c += this.s;
    while (i < a.t) {
      c -= a[i];
      r[i++] = c & this.DM;
      c >>= this.DB;
    }
    c -= a.s;
  }
  r.s = (c < 0) ? -1 : 0;
  if (c < -1)
    r[i++] = this.DV + c;
  else if (c > 0)
    r[i++] = c;
  r.t = i;
  r.clamp();
}

// (protected) r = this * a, r != this,a (HAC 14.12)
// "this" should be the larger one if appropriate.
function bnpMultiplyTo(a, r) {
  var x = this.abs(), y = a.abs();
  var i = x.t;
  r.t = i + y.t;
  while (--i >= 0) r[i] = 0;
  for (i = 0; i < y.t; ++i) r[i + x.t] = x.am(0, y[i], r, i, 0, x.t);
  r.s = 0;
  r.clamp();
  if (this.s != a.s) BigInteger.ZERO.subTo(r, r);
}

// (protected) r = this^2, r != this (HAC 14.16)
function bnpSquareTo(r) {
  var x = this.abs();
  var i = r.t = 2 * x.t;
  while (--i >= 0) r[i] = 0;
  for (i = 0; i < x.t - 1; ++i) {
    var c = x.am(i, x[i], r, 2 * i, 0, 1);
    if ((r[i + x.t] += x.am(i + 1, 2 * x[i], r, 2 * i + 1, c, x.t - i - 1)) >=
        x.DV) {
      r[i + x.t] -= x.DV;
      r[i + x.t + 1] = 1;
    }
  }
  if (r.t > 0) r[r.t - 1] += x.am(i, x[i], r, 2 * i, 0, 1);
  r.s = 0;
  r.clamp();
}

// (protected) divide this by m, quotient and remainder to q, r (HAC 14.20)
// r != q, this != m.  q or r may be null.
function bnpDivRemTo(m, q, r) {
  var pm = m.abs();
  if (pm.t <= 0) return;
  var pt = this.abs();
  if (pt.t < pm.t) {
    if (q != null) q.fromInt(0);
    if (r != null) this.copyTo(r);
    return;
  }
  if (r == null) r = nbi();
  var y = nbi(), ts = this.s, ms = m.s;
  var nsh = this.DB - nbits(pm[pm.t - 1]);  // normalize modulus
  if (nsh > 0) {
    pm.lShiftTo(nsh, y);
    pt.lShiftTo(nsh, r);
  } else {
    pm.copyTo(y);
    pt.copyTo(r);
  }
  var ys = y.t;
  var y0 = y[ys - 1];
  if (y0 == 0) return;
  var yt = y0 * (1 << this.F1) + ((ys > 1) ? y[ys - 2] >> this.F2 : 0);
  var d1 = this.FV / yt, d2 = (1 << this.F1) / yt, e = 1 << this.F2;
  var i = r.t, j = i - ys, t = (q == null) ? nbi() : q;
  y.dlShiftTo(j, t);
  if (r.compareTo(t) >= 0) {
    r[r.t++] = 1;
    r.subTo(t, r);
  }
  BigInteger.ONE.dlShiftTo(ys, t);
  t.subTo(y, y);  // "negative" y so we can replace sub with am later
  while (y.t < ys) y[y.t++] = 0;
  while (--j >= 0) {
    // Estimate quotient digit
    var qd =
        (r[--i] == y0) ? this.DM : Math.floor(r[i] * d1 + (r[i - 1] + e) * d2);
    if ((r[i] += y.am(0, qd, r, j, 0, ys)) < qd) {  // Try it out
      y.dlShiftTo(j, t);
      r.subTo(t, r);
      while (r[i] < --qd) r.subTo(t, r);
    }
  }
  if (q != null) {
    r.drShiftTo(ys, q);
    if (ts != ms) BigInteger.ZERO.subTo(q, q);
  }
  r.t = ys;
  r.clamp();
  if (nsh > 0) r.rShiftTo(nsh, r);  // Denormalize remainder
  if (ts < 0) BigInteger.ZERO.subTo(r, r);
}

// (public) this mod a
function bnMod(a) {
  var r = nbi();
  this.abs().divRemTo(a, null, r);
  if (this.s < 0 && r.compareTo(BigInteger.ZERO) > 0) a.subTo(r, r);
  return r;
}

// Modular reduction using "classic" algorithm
function Classic(m) {
  this.m = m;
}
function cConvert(x) {
  if (x.s < 0 || x.compareTo(this.m) >= 0)
    return x.mod(this.m);
  else
    return x;
}
function cRevert(x) {
  return x;
}
function cReduce(x) {
  x.divRemTo(this.m, null, x);
}
function cMulTo(x, y, r) {
  x.multiplyTo(y, r);
  this.reduce(r);
}
function cSqrTo(x, r) {
  x.squareTo(r);
  this.reduce(r);
}

Classic.prototype.convert = cConvert;
Classic.prototype.revert = cRevert;
Classic.prototype.reduce = cReduce;
Classic.prototype.mulTo = cMulTo;
Classic.prototype.sqrTo = cSqrTo;

// (protected) return "-1/this % 2^DB"; useful for Mont. reduction
// justification:
//         xy == 1 (mod m)
//         xy =  1+km
//   xy(2-xy) = (1+km)(1-km)
// x[y(2-xy)] = 1-k^2m^2
// x[y(2-xy)] == 1 (mod m^2)
// if y is 1/x mod m, then y(2-xy) is 1/x mod m^2
// should reduce x and y(2-xy) by m^2 at each step to keep size bounded.
// JS multiply "overflows" differently from C/C++, so care is needed here.
function bnpInvDigit() {
  if (this.t < 1) return 0;
  var x = this[0];
  if ((x & 1) == 0) return 0;
  var y = x & 3;                                           // y == 1/x mod 2^2
  y = (y * (2 - (x & 0xf) * y)) & 0xf;                     // y == 1/x mod 2^4
  y = (y * (2 - (x & 0xff) * y)) & 0xff;                   // y == 1/x mod 2^8
  y = (y * (2 - (((x & 0xffff) * y) & 0xffff))) & 0xffff;  // y == 1/x mod 2^16
  // last step - calculate inverse mod DV directly;
  // assumes 16 < DB <= 32 and assumes ability to handle 48-bit ints
  y = (y * (2 - x * y % this.DV)) % this.DV;  // y == 1/x mod 2^dbits
  // we really want the negative inverse, and -DV < y < DV
  return (y > 0) ? this.DV - y : -y;
}

// Montgomery reduction
function Montgomery(m) {
  this.m = m;
  this.mp = m.invDigit();
  this.mpl = this.mp & 0x7fff;
  this.mph = this.mp >> 15;
  this.um = (1 << (m.DB - 15)) - 1;
  this.mt2 = 2 * m.t;
}

// xR mod m
function montConvert(x) {
  var r = nbi();
  x.abs().dlShiftTo(this.m.t, r);
  r.divRemTo(this.m, null, r);
  if (x.s < 0 && r.compareTo(BigInteger.ZERO) > 0) this.m.subTo(r, r);
  return r;
}

// x/R mod m
function montRevert(x) {
  var r = nbi();
  x.copyTo(r);
  this.reduce(r);
  return r;
}

// x = x/R mod m (HAC 14.32)
function montReduce(x) {
  while (x.t <= this.mt2)  // pad x so am has enough room later
    x[x.t++] = 0;
  for (var i = 0; i < this.m.t; ++i) {
    // faster way of calculating u0 = x[i]*mp mod DV
    var j = x[i] & 0x7fff;
    var u0 = (j * this.mpl +
              (((j * this.mph + (x[i] >> 15) * this.mpl) & this.um) << 15)) &
        x.DM;
    // use am to combine the multiply-shift-add into one call
    j = i + this.m.t;
    x[j] += this.m.am(0, u0, x, i, 0, this.m.t);
    // propagate carry
    while (x[j] >= x.DV) {
      x[j] -= x.DV;
      x[++j]++;
    }
  }
  x.clamp();
  x.drShiftTo(this.m.t, x);
  if (x.compareTo(this.m) >= 0) x.subTo(this.m, x);
}

// r = "x^2/R mod m"; x != r
function montSqrTo(x, r) {
  x.squareTo(r);
  this.reduce(r);
}

// r = "xy/R mod m"; x,y != r
function montMulTo(x, y, r) {
  x.multiplyTo(y, r);
  this.reduce(r);
}

Montgomery.prototype.convert = montConvert;
Montgomery.prototype.revert = montRevert;
Montgomery.prototype.reduce = montReduce;
Montgomery.prototype.mulTo = montMulTo;
Montgomery.prototype.sqrTo = montSqrTo;

// (protected) true iff this is even
function bnpIsEven() {
  return ((this.t > 0) ? (this[0] & 1) : this.s) == 0;
}

// (protected) this^e, e < 2^32, doing sqr and mul with "r" (HAC 14.79)
function bnpExp(e, z) {
  if (e > 0xffffffff || e < 1) return BigInteger.ONE;
  var r = nbi(), r2 = nbi(), g = z.convert(this), i = nbits(e) - 1;
  g.copyTo(r);
  while (--i >= 0) {
    z.sqrTo(r, r2);
    if ((e & (1 << i)) > 0)
      z.mulTo(r2, g, r);
    else {
      var t = r;
      r = r2;
      r2 = t;
    }
  }
  return z.revert(r);
}

// (public) this^e % m, 0 <= e < 2^32
function bnModPowInt(e, m) {
  var z;
  if (e < 256 || m.isEven())
    z = new Classic(m);
  else
    z = new Montgomery(m);
  return this.exp(e, z);
}

// protected
BigInteger.prototype.copyTo = bnpCopyTo;
BigInteger.prototype.fromInt = bnpFromInt;
BigInteger.prototype.fromString = bnpFromString;
BigInteger.prototype.clamp = bnpClamp;
BigInteger.prototype.dlShiftTo = bnpDLShiftTo;
BigInteger.prototype.drShiftTo = bnpDRShiftTo;
BigInteger.prototype.lShiftTo = bnpLShiftTo;
BigInteger.prototype.rShiftTo = bnpRShiftTo;
BigInteger.prototype.subTo = bnpSubTo;
BigInteger.prototype.multiplyTo = bnpMultiplyTo;
BigInteger.prototype.squareTo = bnpSquareTo;
BigInteger.prototype.divRemTo = bnpDivRemTo;
BigInteger.prototype.invDigit = bnpInvDigit;
BigInteger.prototype.isEven = bnpIsEven;
BigInteger.prototype.exp = bnpExp;

// public
BigInteger.prototype.toString = bnToString;
BigInteger.prototype.negate = bnNegate;
BigInteger.prototype.abs = bnAbs;
BigInteger.prototype.compareTo = bnCompareTo;
BigInteger.prototype.bitLength = bnBitLength;
BigInteger.prototype.mod = bnMod;
BigInteger.prototype.modPowInt = bnModPowInt;

// "constants"
BigInteger.ZERO = nbv(0);
BigInteger.ONE = nbv(1);

// Pool size must be a multiple of 4 and greater than 32.
// An array of bytes the size of the pool will be passed to init()
var rng_psize = 256;

{
  module.exports = {
    default: BigInteger,
    BigInteger: BigInteger,
  };
}

// Copyright (c) 2005-2009  Tom Wu
// All Rights Reserved.
// See "LICENSE" for details.

// Extended JavaScript BN functions, required for RSA private ops.

// Version 1.1: new BigInteger("0", 10) returns "proper" zero
// Version 1.2: square() API, isProbablePrime fix

// (public)
function bnClone() {
  var r = nbi();
  this.copyTo(r);
  return r;
}

// (public) return value as integer
function bnIntValue() {
  if (this.s < 0) {
    if (this.t == 1)
      return this[0] - this.DV;
    else if (this.t == 0)
      return -1;
  } else if (this.t == 1)
    return this[0];
  else if (this.t == 0)
    return 0;
  // assumes 16 < DB < 32
  return ((this[1] & ((1 << (32 - this.DB)) - 1)) << this.DB) | this[0];
}

// (public) return value as byte
function bnByteValue() {
  return (this.t == 0) ? this.s : (this[0] << 24) >> 24;
}

// (public) return value as short (assumes DB>=16)
function bnShortValue() {
  return (this.t == 0) ? this.s : (this[0] << 16) >> 16;
}

// (protected) return x s.t. r^x < DV
function bnpChunkSize(r) {
  return Math.floor(Math.LN2 * this.DB / Math.log(r));
}

// (public) 0 if this == 0, 1 if this > 0
function bnSigNum() {
  if (this.s < 0)
    return -1;
  else if (this.t <= 0 || (this.t == 1 && this[0] <= 0))
    return 0;
  else
    return 1;
}

// (protected) convert to radix string
function bnpToRadix(b) {
  if (b == null) b = 10;
  if (this.signum() == 0 || b < 2 || b > 36) return '0';
  var cs = this.chunkSize(b);
  var a = Math.pow(b, cs);
  var d = nbv(a), y = nbi(), z = nbi(), r = '';
  this.divRemTo(d, y, z);
  while (y.signum() > 0) {
    r = (a + z.intValue()).toString(b).substr(1) + r;
    y.divRemTo(d, y, z);
  }
  return z.intValue().toString(b) + r;
}

// (protected) convert from radix string
function bnpFromRadix(s, b) {
  this.fromInt(0);
  if (b == null) b = 10;
  var cs = this.chunkSize(b);
  var d = Math.pow(b, cs), mi = false, j = 0, w = 0;
  for (var i = 0; i < s.length; ++i) {
    var x = intAt(s, i);
    if (x < 0) {
      if (s.charAt(i) == '-' && this.signum() == 0) mi = true;
      continue;
    }
    w = b * w + x;
    if (++j >= cs) {
      this.dMultiply(d);
      this.dAddOffset(w, 0);
      j = 0;
      w = 0;
    }
  }
  if (j > 0) {
    this.dMultiply(Math.pow(b, j));
    this.dAddOffset(w, 0);
  }
  if (mi) BigInteger.ZERO.subTo(this, this);
}

// (protected) alternate constructor
function bnpFromNumber(a, b, c) {
  if ('number' == typeof b) {
    // new BigInteger(int,int,RNG)
    if (a < 2)
      this.fromInt(1);
    else {
      this.fromNumber(a, c);
      if (!this.testBit(a - 1))  // force MSB set
        this.bitwiseTo(BigInteger.ONE.shiftLeft(a - 1), op_or, this);
      if (this.isEven()) this.dAddOffset(1, 0);  // force odd
      while (!this.isProbablePrime(b)) {
        this.dAddOffset(2, 0);
        if (this.bitLength() > a)
          this.subTo(BigInteger.ONE.shiftLeft(a - 1), this);
      }
    }
  } else {
    // new BigInteger(int,RNG)
    var x = new Array(), t = a & 7;
    x.length = (a >> 3) + 1;
    b.nextBytes(x);
    if (t > 0)
      x[0] &= ((1 << t) - 1);
    else
      x[0] = 0;
    this.fromString(x, 256);
  }
}

// (public) convert to bigendian byte array
function bnToByteArray() {
  var i = this.t, r = new Array();
  r[0] = this.s;
  var p = this.DB - (i * this.DB) % 8, d, k = 0;
  if (i-- > 0) {
    if (p < this.DB && (d = this[i] >> p) != (this.s & this.DM) >> p)
      r[k++] = d | (this.s << (this.DB - p));
    while (i >= 0) {
      if (p < 8) {
        d = (this[i] & ((1 << p) - 1)) << (8 - p);
        d |= this[--i] >> (p += this.DB - 8);
      } else {
        d = (this[i] >> (p -= 8)) & 0xff;
        if (p <= 0) {
          p += this.DB;
          --i;
        }
      }
      if ((d & 0x80) != 0) d |= -256;
      if (k == 0 && (this.s & 0x80) != (d & 0x80)) ++k;
      if (k > 0 || d != this.s) r[k++] = d;
    }
  }
  return r;
}

function bnEquals(a) {
  return (this.compareTo(a) == 0);
}
function bnMin(a) {
  return (this.compareTo(a) < 0) ? this : a;
}
function bnMax(a) {
  return (this.compareTo(a) > 0) ? this : a;
}

// (protected) r = this op a (bitwise)
function bnpBitwiseTo(a, op, r) {
  var i, f, m = Math.min(a.t, this.t);
  for (i = 0; i < m; ++i) r[i] = op(this[i], a[i]);
  if (a.t < this.t) {
    f = a.s & this.DM;
    for (i = m; i < this.t; ++i) r[i] = op(this[i], f);
    r.t = this.t;
  } else {
    f = this.s & this.DM;
    for (i = m; i < a.t; ++i) r[i] = op(f, a[i]);
    r.t = a.t;
  }
  r.s = op(this.s, a.s);
  r.clamp();
}

// (public) this & a
function op_and(x, y) {
  return x & y;
}
function bnAnd(a) {
  var r = nbi();
  this.bitwiseTo(a, op_and, r);
  return r;
}

// (public) this | a
function op_or(x, y) {
  return x | y;
}
function bnOr(a) {
  var r = nbi();
  this.bitwiseTo(a, op_or, r);
  return r;
}

// (public) this ^ a
function op_xor(x, y) {
  return x ^ y;
}
function bnXor(a) {
  var r = nbi();
  this.bitwiseTo(a, op_xor, r);
  return r;
}

// (public) this & ~a
function op_andnot(x, y) {
  return x & ~y;
}
function bnAndNot(a) {
  var r = nbi();
  this.bitwiseTo(a, op_andnot, r);
  return r;
}

// (public) ~this
function bnNot() {
  var r = nbi();
  for (var i = 0; i < this.t; ++i) r[i] = this.DM & ~this[i];
  r.t = this.t;
  r.s = ~this.s;
  return r;
}

// (public) this << n
function bnShiftLeft(n) {
  var r = nbi();
  if (n < 0)
    this.rShiftTo(-n, r);
  else
    this.lShiftTo(n, r);
  return r;
}

// (public) this >> n
function bnShiftRight(n) {
  var r = nbi();
  if (n < 0)
    this.lShiftTo(-n, r);
  else
    this.rShiftTo(n, r);
  return r;
}

// return index of lowest 1-bit in x, x < 2^31
function lbit(x) {
  if (x == 0) return -1;
  var r = 0;
  if ((x & 0xffff) == 0) {
    x >>= 16;
    r += 16;
  }
  if ((x & 0xff) == 0) {
    x >>= 8;
    r += 8;
  }
  if ((x & 0xf) == 0) {
    x >>= 4;
    r += 4;
  }
  if ((x & 3) == 0) {
    x >>= 2;
    r += 2;
  }
  if ((x & 1) == 0) ++r;
  return r;
}

// (public) returns index of lowest 1-bit (or -1 if none)
function bnGetLowestSetBit() {
  for (var i = 0; i < this.t; ++i)
    if (this[i] != 0) return i * this.DB + lbit(this[i]);
  if (this.s < 0) return this.t * this.DB;
  return -1;
}

// return number of 1 bits in x
function cbit(x) {
  var r = 0;
  while (x != 0) {
    x &= x - 1;
    ++r;
  }
  return r;
}

// (public) return number of set bits
function bnBitCount() {
  var r = 0, x = this.s & this.DM;
  for (var i = 0; i < this.t; ++i) r += cbit(this[i] ^ x);
  return r;
}

// (public) true iff nth bit is set
function bnTestBit(n) {
  var j = Math.floor(n / this.DB);
  if (j >= this.t) return (this.s != 0);
  return ((this[j] & (1 << (n % this.DB))) != 0);
}

// (protected) this op (1<<n)
function bnpChangeBit(n, op) {
  var r = BigInteger.ONE.shiftLeft(n);
  this.bitwiseTo(r, op, r);
  return r;
}

// (public) this | (1<<n)
function bnSetBit(n) {
  return this.changeBit(n, op_or);
}

// (public) this & ~(1<<n)
function bnClearBit(n) {
  return this.changeBit(n, op_andnot);
}

// (public) this ^ (1<<n)
function bnFlipBit(n) {
  return this.changeBit(n, op_xor);
}

// (protected) r = this + a
function bnpAddTo(a, r) {
  var i = 0, c = 0, m = Math.min(a.t, this.t);
  while (i < m) {
    c += this[i] + a[i];
    r[i++] = c & this.DM;
    c >>= this.DB;
  }
  if (a.t < this.t) {
    c += a.s;
    while (i < this.t) {
      c += this[i];
      r[i++] = c & this.DM;
      c >>= this.DB;
    }
    c += this.s;
  } else {
    c += this.s;
    while (i < a.t) {
      c += a[i];
      r[i++] = c & this.DM;
      c >>= this.DB;
    }
    c += a.s;
  }
  r.s = (c < 0) ? -1 : 0;
  if (c > 0)
    r[i++] = c;
  else if (c < -1)
    r[i++] = this.DV + c;
  r.t = i;
  r.clamp();
}

// (public) this + a
function bnAdd(a) {
  var r = nbi();
  this.addTo(a, r);
  return r;
}

// (public) this - a
function bnSubtract(a) {
  var r = nbi();
  this.subTo(a, r);
  return r;
}

// (public) this * a
function bnMultiply(a) {
  var r = nbi();
  this.multiplyTo(a, r);
  return r;
}

// (public) this^2
function bnSquare() {
  var r = nbi();
  this.squareTo(r);
  return r;
}

// (public) this / a
function bnDivide(a) {
  var r = nbi();
  this.divRemTo(a, r, null);
  return r;
}

// (public) this % a
function bnRemainder(a) {
  var r = nbi();
  this.divRemTo(a, null, r);
  return r;
}

// (public) [this/a,this%a]
function bnDivideAndRemainder(a) {
  var q = nbi(), r = nbi();
  this.divRemTo(a, q, r);
  return new Array(q, r);
}

// (protected) this *= n, this >= 0, 1 < n < DV
function bnpDMultiply(n) {
  this[this.t] = this.am(0, n - 1, this, 0, 0, this.t);
  ++this.t;
  this.clamp();
}

// (protected) this += n << w words, this >= 0
function bnpDAddOffset(n, w) {
  if (n == 0) return;
  while (this.t <= w) this[this.t++] = 0;
  this[w] += n;
  while (this[w] >= this.DV) {
    this[w] -= this.DV;
    if (++w >= this.t) this[this.t++] = 0;
    ++this[w];
  }
}

// A "null" reducer
// tslint:disable-next-line
function NullExp() {}
function nNop(x) {
  return x;
}
function nMulTo(x, y, r) {
  x.multiplyTo(y, r);
}
function nSqrTo(x, r) {
  x.squareTo(r);
}

NullExp.prototype.convert = nNop;
NullExp.prototype.revert = nNop;
NullExp.prototype.mulTo = nMulTo;
NullExp.prototype.sqrTo = nSqrTo;

// (public) this^e
function bnPow(e) {
  return this.exp(e, new NullExp());
}

// (protected) r = lower n words of "this * a", a.t <= n
// "this" should be the larger one if appropriate.
function bnpMultiplyLowerTo(a, n, r) {
  var i = Math.min(this.t + a.t, n);
  r.s = 0;  // assumes a,this >= 0
  r.t = i;
  while (i > 0) r[--i] = 0;
  var j;
  for (j = r.t - this.t; i < j; ++i)
    r[i + this.t] = this.am(0, a[i], r, i, 0, this.t);
  for (j = Math.min(a.t, n); i < j; ++i) this.am(0, a[i], r, i, 0, n - i);
  r.clamp();
}

// (protected) r = "this * a" without lower n words, n > 0
// "this" should be the larger one if appropriate.
function bnpMultiplyUpperTo(a, n, r) {
  --n;
  var i = r.t = this.t + a.t - n;
  r.s = 0;  // assumes a,this >= 0
  while (--i >= 0) r[i] = 0;
  for (i = Math.max(n - this.t, 0); i < a.t; ++i)
    r[this.t + i - n] = this.am(n - i, a[i], r, 0, 0, this.t + i - n);
  r.clamp();
  r.drShiftTo(1, r);
}

// Barrett modular reduction
function Barrett(m) {
  // setup Barrett
  this.r2 = nbi();
  this.q3 = nbi();
  BigInteger.ONE.dlShiftTo(2 * m.t, this.r2);
  this.mu = this.r2.divide(m);
  this.m = m;
}

function barrettConvert(x) {
  if (x.s < 0 || x.t > 2 * this.m.t)
    return x.mod(this.m);
  else if (x.compareTo(this.m) < 0)
    return x;
  else {
    var r = nbi();
    x.copyTo(r);
    this.reduce(r);
    return r;
  }
}

function barrettRevert(x) {
  return x;
}

// x = x mod m (HAC 14.42)
function barrettReduce(x) {
  x.drShiftTo(this.m.t - 1, this.r2);
  if (x.t > this.m.t + 1) {
    x.t = this.m.t + 1;
    x.clamp();
  }
  this.mu.multiplyUpperTo(this.r2, this.m.t + 1, this.q3);
  this.m.multiplyLowerTo(this.q3, this.m.t + 1, this.r2);
  while (x.compareTo(this.r2) < 0) x.dAddOffset(1, this.m.t + 1);
  x.subTo(this.r2, x);
  while (x.compareTo(this.m) >= 0) x.subTo(this.m, x);
}

// r = x^2 mod m; x != r
function barrettSqrTo(x, r) {
  x.squareTo(r);
  this.reduce(r);
}

// r = x*y mod m; x,y != r
function barrettMulTo(x, y, r) {
  x.multiplyTo(y, r);
  this.reduce(r);
}

Barrett.prototype.convert = barrettConvert;
Barrett.prototype.revert = barrettRevert;
Barrett.prototype.reduce = barrettReduce;
Barrett.prototype.mulTo = barrettMulTo;
Barrett.prototype.sqrTo = barrettSqrTo;

// (public) this^e % m (HAC 14.85)
function bnModPow(e, m) {
  var i = e.bitLength(), k, r = nbv(1), z;
  if (i <= 0)
    return r;
  else if (i < 18)
    k = 1;
  else if (i < 48)
    k = 3;
  else if (i < 144)
    k = 4;
  else if (i < 768)
    k = 5;
  else
    k = 6;
  if (i < 8)
    z = new Classic(m);
  else if (m.isEven())
    z = new Barrett(m);
  else
    z = new Montgomery(m);

  // precomputation
  var g = new Array(), n = 3, k1 = k - 1, km = (1 << k) - 1;
  g[1] = z.convert(this);
  if (k > 1) {
    var g2 = nbi();
    z.sqrTo(g[1], g2);
    while (n <= km) {
      g[n] = nbi();
      z.mulTo(g2, g[n - 2], g[n]);
      n += 2;
    }
  }

  var j = e.t - 1, w, is1 = true, r2 = nbi(), t;
  i = nbits(e[j]) - 1;
  while (j >= 0) {
    if (i >= k1)
      w = (e[j] >> (i - k1)) & km;
    else {
      w = (e[j] & ((1 << (i + 1)) - 1)) << (k1 - i);
      if (j > 0) w |= e[j - 1] >> (this.DB + i - k1);
    }

    n = k;
    while ((w & 1) == 0) {
      w >>= 1;
      --n;
    }
    if ((i -= n) < 0) {
      i += this.DB;
      --j;
    }
    if (is1) {  // ret == 1, don't bother squaring or multiplying it
      g[w].copyTo(r);
      is1 = false;
    } else {
      while (n > 1) {
        z.sqrTo(r, r2);
        z.sqrTo(r2, r);
        n -= 2;
      }
      if (n > 0)
        z.sqrTo(r, r2);
      else {
        t = r;
        r = r2;
        r2 = t;
      }
      z.mulTo(r2, g[w], r);
    }

    while (j >= 0 && (e[j] & (1 << i)) == 0) {
      z.sqrTo(r, r2);
      t = r;
      r = r2;
      r2 = t;
      if (--i < 0) {
        i = this.DB - 1;
        --j;
      }
    }
  }
  return z.revert(r);
}

// (public) gcd(this,a) (HAC 14.54)
function bnGCD(a) {
  var x = (this.s < 0) ? this.negate() : this.clone();
  var y = (a.s < 0) ? a.negate() : a.clone();
  if (x.compareTo(y) < 0) {
    var t = x;
    x = y;
    y = t;
  }
  var i = x.getLowestSetBit(), g = y.getLowestSetBit();
  if (g < 0) return x;
  if (i < g) g = i;
  if (g > 0) {
    x.rShiftTo(g, x);
    y.rShiftTo(g, y);
  }
  while (x.signum() > 0) {
    if ((i = x.getLowestSetBit()) > 0) x.rShiftTo(i, x);
    if ((i = y.getLowestSetBit()) > 0) y.rShiftTo(i, y);
    if (x.compareTo(y) >= 0) {
      x.subTo(y, x);
      x.rShiftTo(1, x);
    } else {
      y.subTo(x, y);
      y.rShiftTo(1, y);
    }
  }
  if (g > 0) y.lShiftTo(g, y);
  return y;
}

// (protected) this % n, n < 2^26
function bnpModInt(n) {
  if (n <= 0) return 0;
  var d = this.DV % n, r = (this.s < 0) ? n - 1 : 0;
  if (this.t > 0)
    if (d == 0)
      r = this[0] % n;
    else
      for (var i = this.t - 1; i >= 0; --i) r = (d * r + this[i]) % n;
  return r;
}

// (public) 1/this % m (HAC 14.61)
function bnModInverse(m) {
  var ac = m.isEven();
  if ((this.isEven() && ac) || m.signum() == 0) return BigInteger.ZERO;
  var u = m.clone(), v = this.clone();
  var a = nbv(1), b = nbv(0), c = nbv(0), d = nbv(1);
  while (u.signum() != 0) {
    while (u.isEven()) {
      u.rShiftTo(1, u);
      if (ac) {
        if (!a.isEven() || !b.isEven()) {
          a.addTo(this, a);
          b.subTo(m, b);
        }
        a.rShiftTo(1, a);
      } else if (!b.isEven())
        b.subTo(m, b);
      b.rShiftTo(1, b);
    }
    while (v.isEven()) {
      v.rShiftTo(1, v);
      if (ac) {
        if (!c.isEven() || !d.isEven()) {
          c.addTo(this, c);
          d.subTo(m, d);
        }
        c.rShiftTo(1, c);
      } else if (!d.isEven())
        d.subTo(m, d);
      d.rShiftTo(1, d);
    }
    if (u.compareTo(v) >= 0) {
      u.subTo(v, u);
      if (ac) a.subTo(c, a);
      b.subTo(d, b);
    } else {
      v.subTo(u, v);
      if (ac) c.subTo(a, c);
      d.subTo(b, d);
    }
  }
  if (v.compareTo(BigInteger.ONE) != 0) return BigInteger.ZERO;
  if (d.compareTo(m) >= 0) return d.subtract(m);
  if (d.signum() < 0)
    d.addTo(m, d);
  else
    return d;
  if (d.signum() < 0)
    return d.add(m);
  else
    return d;
}

var lowprimes = [
  2,   3,   5,   7,   11,  13,  17,  19,  23,  29,  31,  37,  41,  43,
  47,  53,  59,  61,  67,  71,  73,  79,  83,  89,  97,  101, 103, 107,
  109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181,
  191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263,
  269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349,
  353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433,
  439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521,
  523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613,
  617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701,
  709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809,
  811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887,
  907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997
];
var lplim = (1 << 26) / lowprimes[lowprimes.length - 1];

// (public) test primality with certainty >= 1-.5^t
function bnIsProbablePrime(t) {
  var i, x = this.abs();
  if (x.t == 1 && x[0] <= lowprimes[lowprimes.length - 1]) {
    for (i = 0; i < lowprimes.length; ++i)
      if (x[0] == lowprimes[i]) return true;
    return false;
  }
  if (x.isEven()) return false;
  i = 1;
  while (i < lowprimes.length) {
    var m = lowprimes[i], j = i + 1;
    while (j < lowprimes.length && m < lplim) m *= lowprimes[j++];
    m = x.modInt(m);
    while (i < j)
      if (m % lowprimes[i++] == 0) return false;
  }
  return x.millerRabin(t);
}

// (protected) true if probably prime (HAC 4.24, Miller-Rabin)
function bnpMillerRabin(t) {
  var n1 = this.subtract(BigInteger.ONE);
  var k = n1.getLowestSetBit();
  if (k <= 0) return false;
  var r = n1.shiftRight(k);
  t = (t + 1) >> 1;
  if (t > lowprimes.length) t = lowprimes.length;
  var a = nbi();
  for (var i = 0; i < t; ++i) {
    // Pick bases at random, instead of starting at 2
    a.fromInt(lowprimes[Math.floor(Math.random() * lowprimes.length)]);
    var y = a.modPow(r, this);
    if (y.compareTo(BigInteger.ONE) != 0 && y.compareTo(n1) != 0) {
      var j = 1;
      while (j++ < k && y.compareTo(n1) != 0) {
        y = y.modPowInt(2, this);
        if (y.compareTo(BigInteger.ONE) == 0) return false;
      }
      if (y.compareTo(n1) != 0) return false;
    }
  }
  return true;
}

// protected
BigInteger.prototype.chunkSize = bnpChunkSize;
BigInteger.prototype.toRadix = bnpToRadix;
BigInteger.prototype.fromRadix = bnpFromRadix;
BigInteger.prototype.fromNumber = bnpFromNumber;
BigInteger.prototype.bitwiseTo = bnpBitwiseTo;
BigInteger.prototype.changeBit = bnpChangeBit;
BigInteger.prototype.addTo = bnpAddTo;
BigInteger.prototype.dMultiply = bnpDMultiply;
BigInteger.prototype.dAddOffset = bnpDAddOffset;
BigInteger.prototype.multiplyLowerTo = bnpMultiplyLowerTo;
BigInteger.prototype.multiplyUpperTo = bnpMultiplyUpperTo;
BigInteger.prototype.modInt = bnpModInt;
BigInteger.prototype.millerRabin = bnpMillerRabin;

// public
BigInteger.prototype.clone = bnClone;
BigInteger.prototype.intValue = bnIntValue;
BigInteger.prototype.byteValue = bnByteValue;
BigInteger.prototype.shortValue = bnShortValue;
BigInteger.prototype.signum = bnSigNum;
BigInteger.prototype.toByteArray = bnToByteArray;
BigInteger.prototype.equals = bnEquals;
BigInteger.prototype.min = bnMin;
BigInteger.prototype.max = bnMax;
BigInteger.prototype.and = bnAnd;
BigInteger.prototype.or = bnOr;
BigInteger.prototype.xor = bnXor;
BigInteger.prototype.andNot = bnAndNot;
BigInteger.prototype.not = bnNot;
BigInteger.prototype.shiftLeft = bnShiftLeft;
BigInteger.prototype.shiftRight = bnShiftRight;
BigInteger.prototype.getLowestSetBit = bnGetLowestSetBit;
BigInteger.prototype.bitCount = bnBitCount;
BigInteger.prototype.testBit = bnTestBit;
BigInteger.prototype.setBit = bnSetBit;
BigInteger.prototype.clearBit = bnClearBit;
BigInteger.prototype.flipBit = bnFlipBit;
BigInteger.prototype.add = bnAdd;
BigInteger.prototype.subtract = bnSubtract;
BigInteger.prototype.multiply = bnMultiply;
BigInteger.prototype.divide = bnDivide;
BigInteger.prototype.remainder = bnRemainder;
BigInteger.prototype.divideAndRemainder = bnDivideAndRemainder;
BigInteger.prototype.modPow = bnModPow;
BigInteger.prototype.modInverse = bnModInverse;
BigInteger.prototype.pow = bnPow;
BigInteger.prototype.gcd = bnGCD;
BigInteger.prototype.isProbablePrime = bnIsProbablePrime;

// JSBN-specific extension
BigInteger.prototype.square = bnSquare;

// BigInteger interfaces not implemented in jsbn:

// BigInteger(int signum, byte[] magnitude)
// double doubleValue()
// float floatValue()
// int hashCode()
// long longValue()
// static BigInteger valueOf(long val)

// Depends on jsbn.js and rng.js

// Version 1.1: support utf-8 encoding in pkcs1pad2

// convert a (hex) string to a bignum object
function parseBigInt(str, r) {
  return new BigInteger(str, r);
}

// PKCS#1 (type 2, random) pad input string s to n bytes, and return a bigint
function pkcs1pad2(s, n) {
  if (n < s.length + 11) {  // TODO: fix for utf-8
    alert('Message too long for RSA');
    return null;
  }
  var ba = new Array();
  var i = s.length - 1;
  while (i >= 0 && n > 0) {
    var c = s.charCodeAt(i--);
    if (c < 128) {  // encode using utf-8
      ba[--n] = c;
    } else if ((c > 127) && (c < 2048)) {
      ba[--n] = (c & 63) | 128;
      ba[--n] = (c >> 6) | 192;
    } else {
      ba[--n] = (c & 63) | 128;
      ba[--n] = ((c >> 6) & 63) | 128;
      ba[--n] = (c >> 12) | 224;
    }
  }
  ba[--n] = 0;
  var rng = new SecureRandom();
  var x = new Array();
  while (n > 2) {  // random non-zero pad
    x[0] = 0;
    while (x[0] == 0) rng.nextBytes(x);
    ba[--n] = x[0];
  }
  ba[--n] = 2;
  ba[--n] = 0;
  return new BigInteger(ba);
}

// "empty" RSA key constructor
function RSAKey() {
  this.n = null;
  this.e = 0;
  this.d = null;
  this.p = null;
  this.q = null;
  this.dmp1 = null;
  this.dmq1 = null;
  this.coeff = null;
}

// Set the public key fields N and e from hex strings
function RSASetPublic(N, E) {
  if (N != null && E != null && N.length > 0 && E.length > 0) {
    this.n = parseBigInt(N, 16);
    this.e = parseInt(E, 16);
  } else
    alert('Invalid RSA public key');
}

// Set the private key fields N, e, d and CRT params from hex strings
function RSASetPrivateEx(N,E,D,P,Q,DP,DQ,C) {
    if(N != null && E != null && N.length > 0 && E.length > 0) {
      this.n = parseBigInt(N,16);
      this.e = parseInt(E,16);
      this.d = parseBigInt(D,16);
      this.p = parseBigInt(P,16);
      this.q = parseBigInt(Q,16);
      this.dmp1 = parseBigInt(DP,16);
      this.dmq1 = parseBigInt(DQ,16);
      this.coeff = parseBigInt(C,16);
    }
    else
      alert("Invalid RSA private key");
  }

// Perform raw private operation on "x": return x^d (mod n)
function RSADoPrivate(x) {
  if(this.p == null || this.q == null)
    return x.modPow(this.d, this.n);

  // TODO: re-calculate any missing CRT params
  var xp = x.mod(this.p).modPow(this.dmp1, this.p);
  var xq = x.mod(this.q).modPow(this.dmq1, this.q);

  while(xp.compareTo(xq) < 0)
    xp = xp.add(this.p);
  return xp.subtract(xq).multiply(this.coeff).mod(this.p).multiply(this.q).add(xq);
}

// Perform raw public operation on "x": return x^e (mod n)
function RSADoPublic(x) {
  return x.modPowInt(this.e, this.n);
}

// Return the PKCS#1 RSA encryption of "text" as an even-length hex string
function RSAEncrypt(text) {
  var m = pkcs1pad2(text, (this.n.bitLength() + 7) >> 3);
  if (m == null) return null;
  var c = this.doPublic(m);
  if (c == null) return null;
  var h = c.toString(16);
  if ((h.length & 1) == 0)
    return h;
  else
    return '0' + h;
}

// Return the PKCS#1 RSA encryption of "text" as a Base64-encoded string
// function RSAEncryptB64(text) {
//  var h = this.encrypt(text);
//  if(h) return hex2b64(h); else return null;
//}

// protected
RSAKey.prototype.doPublic = RSADoPublic;

// public
RSAKey.prototype.doPrivate = RSADoPrivate;
RSAKey.prototype.setPublic = RSASetPublic;
RSAKey.prototype.setPrivateEx = RSASetPrivateEx;
RSAKey.prototype.encrypt = RSAEncrypt;
// RSAKey.prototype.encrypt_b64 = RSAEncryptB64;

// Random number generator - requires a PRNG backend, e.g. prng4.js

// For best results, put code like
// <body onClick='rng_seed_time();' onKeyPress='rng_seed_time();'>
// in your main HTML document.

var rng_state;
var rng_pool;
var rng_pptr;

// Mix in a 32-bit integer into the pool
function rng_seed_int(x) {
  rng_pool[rng_pptr++] ^= x & 255;
  rng_pool[rng_pptr++] ^= (x >> 8) & 255;
  rng_pool[rng_pptr++] ^= (x >> 16) & 255;
  rng_pool[rng_pptr++] ^= (x >> 24) & 255;
  if (rng_pptr >= rng_psize) rng_pptr -= rng_psize;
}

// Mix in the current time (w/milliseconds) into the pool
function rng_seed_time() {
  rng_seed_int(new Date().getTime());
}

// Initialize the pool with junk if needed.
if (rng_pool == null) {
  rng_pool = new Array();
  rng_pptr = 0;
  var t;
  if (inBrowser && window.crypto && window.crypto.getRandomValues) {
    // Use webcrypto if available
    var ua = new Uint8Array(32);
    window.crypto.getRandomValues(ua);
    for (t = 0; t < 32; ++t) rng_pool[rng_pptr++] = ua[t];
  }
  if (inBrowser && navigator.appName == 'Netscape' &&
      navigator.appVersion < '5' && window.crypto) {
    // Extract entropy (256 bits) from NS4 RNG if available
    var z = window.crypto.random(32);
    for (t = 0; t < z.length; ++t) rng_pool[rng_pptr++] = z.charCodeAt(t) & 255;
  }
  while (rng_pptr < rng_psize) {  // extract some randomness from Math.random()
    t = Math.floor(65536 * Math.random());
    rng_pool[rng_pptr++] = t >>> 8;
    rng_pool[rng_pptr++] = t & 255;
  }
  rng_pptr = 0;
  rng_seed_time();
  // rng_seed_int(window.screenX);
  // rng_seed_int(window.screenY);
}

function rng_get_byte() {
  if (rng_state == null) {
    rng_seed_time();
    rng_state = prng_newstate();
    rng_state.init(rng_pool);
    for (rng_pptr = 0; rng_pptr < rng_pool.length; ++rng_pptr)
      rng_pool[rng_pptr] = 0;
    rng_pptr = 0;
    // rng_pool = null;
  }
  // TODO: allow reseeding after first request
  return rng_state.next();
}

function rng_get_bytes(ba) {
  var i;
  for (i = 0; i < ba.length; ++i) ba[i] = rng_get_byte();
}

// tslint:disable-next-line
function SecureRandom() {}

SecureRandom.prototype.nextBytes = rng_get_bytes;

// prng4.js - uses Arcfour as a PRNG

function Arcfour() {
  this.i = 0;
  this.j = 0;
  this.S = new Array();
}

// Initialize arcfour context from key, an array of ints, each from [0..255]
function ARC4init(key) {
  var i, j, t;
  for (i = 0; i < 256; ++i) this.S[i] = i;
  j = 0;
  for (i = 0; i < 256; ++i) {
    j = (j + this.S[i] + key[i % key.length]) & 255;
    t = this.S[i];
    this.S[i] = this.S[j];
    this.S[j] = t;
  }
  this.i = 0;
  this.j = 0;
}

function ARC4next() {
  var t;
  this.i = (this.i + 1) & 255;
  this.j = (this.j + this.S[this.i]) & 255;
  t = this.S[this.i];
  this.S[this.i] = this.S[this.j];
  this.S[this.j] = t;
  return this.S[(t + this.S[this.i]) & 255];
}

Arcfour.prototype.init = ARC4init;
Arcfour.prototype.next = ARC4next;

// Plug in your RNG constructor here
function prng_newstate() {
  return new Arcfour();
}

// Pool size must be a multiple of 4 and greater than 32.
// An array of bytes the size of the pool will be passed to init()
var rng_psize = 256;

{
  module.exports = {
      default: BigInteger,
      BigInteger: BigInteger,
      RSAKey: RSAKey,
  };
}

}).call(commonjsGlobal);
});

var chrome_utils = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.BUFFER_USAGE_INCORRECT_FORMAT = exports.BUFFER_USAGE_NOT_ACCESSIBLE = exports.MALFORMED_EXTENSION_MESSAGE = exports.EXTENSION_NOT_INSTALLED = exports.EXTENSION_NAME = exports.EXTENSION_URL = exports.EXTENSION_ID = void 0;
exports.EXTENSION_ID = 'lfmkphfpdbjijhpomgecfikhfohaoine';
exports.EXTENSION_URL = `https://chrome.google.com/webstore/detail/perfetto-ui/${exports.EXTENSION_ID}`;
exports.EXTENSION_NAME = 'Chrome extension';
exports.EXTENSION_NOT_INSTALLED = `To trace Chrome from the Perfetto UI, you need to install our
    ${exports.EXTENSION_URL} and then reload this page.`;
exports.MALFORMED_EXTENSION_MESSAGE = 'Malformed extension message.';
exports.BUFFER_USAGE_NOT_ACCESSIBLE = 'Buffer usage not accessible';
exports.BUFFER_USAGE_INCORRECT_FORMAT = 'The buffer usage data has am incorrect format';

});

var upload_utils = createCommonjsModule(function (module, exports) {
// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.toSha256 = exports.saveState = exports.saveTrace = exports.BUCKET_NAME = void 0;

exports.BUCKET_NAME = 'perfetto-ui-data';

function saveTrace(trace) {
    return tslib.__awaiter(this, void 0, void 0, function* () {
        // TODO(hjd): This should probably also be a hash but that requires
        // trace processor support.
        const name = (0, dist$1.v4)();
        const url = 'https://www.googleapis.com/upload/storage/v1/b/' +
            `${exports.BUCKET_NAME}/o?uploadType=media` +
            `&name=${name}&predefinedAcl=publicRead`;
        const response = yield fetch(url, {
            method: 'post',
            headers: { 'Content-Type': 'application/octet-stream;' },
            body: trace,
        });
        yield response.json();
        return `https://storage.googleapis.com/${exports.BUCKET_NAME}/${name}`;
    });
}
exports.saveTrace = saveTrace;
function saveState(stateOrConfig) {
    return tslib.__awaiter(this, void 0, void 0, function* () {
        const text = JSON.stringify(stateOrConfig, (key, value) => {
            return key === 'nonSerializableState' ? undefined : value;
        });
        const hash = yield toSha256(text);
        const url = 'https://www.googleapis.com/upload/storage/v1/b/' +
            `${exports.BUCKET_NAME}/o?uploadType=media` +
            `&name=${hash}&predefinedAcl=publicRead`;
        const response = yield fetch(url, {
            method: 'post',
            headers: {
                'Content-Type': 'application/json; charset=utf-8',
            },
            body: text,
        });
        yield response.json();
        return hash;
    });
}
exports.saveState = saveState;
function toSha256(str) {
    return tslib.__awaiter(this, void 0, void 0, function* () {
        // TODO(hjd): TypeScript bug with definition of TextEncoder.
        const buffer = new TextEncoder('utf-8').encode(str);
        const digest = yield crypto.subtle.digest('SHA-256', buffer);
        return Array.from(new Uint8Array(digest)).map((x) => x.toString(16)).join('');
    });
}
exports.toSha256 = toSha256;

});

var trace_attrs = createCommonjsModule(function (module, exports) {
// Copyright (C) 2020 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDownloadable = exports.isShareable = void 0;

function isShareable() {
    return (globals.globals.isInternalUser && isDownloadable());
}
exports.isShareable = isShareable;
function isDownloadable() {
    const engine = globals.globals.getCurrentEngine();
    if (!engine) {
        return false;
    }
    if (engine.source.type === 'ARRAY_BUFFER' && engine.source.localOnly) {
        return false;
    }
    if (engine.source.type === 'HTTP_RPC') {
        return false;
    }
    return true;
}
exports.isDownloadable = isDownloadable;

});

var error_dialog = createCommonjsModule(function (module, exports) {
// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.showFailedToPushBinary = exports.showIssueParsingTheTracedResponse = exports.showWebsocketConnectionIssue = exports.showExtensionNotInstalled = exports.showNoDeviceSelected = exports.showAllowUSBDebugging = exports.showConnectionLostError = exports.showWebUSBErrorV2 = exports.maybeShowErrorDialog = void 0;








// Never show more than one dialog per minute.
const MIN_REPORT_PERIOD_MS = 60000;
let timeLastReport = 0;
// Keeps the last ERR_QUEUE_MAX_LEN errors while the dialog is throttled.
const queuedErrors = new Array();
const ERR_QUEUE_MAX_LEN = 10;
function maybeShowErrorDialog(errLog) {
    globals.globals.logging.logError(errLog);
    const now = performance.now();
    // Here we rely on the exception message from onCannotGrowMemory function
    if (errLog.includes('Cannot enlarge memory')) {
        showOutOfMemoryDialog();
        // Refresh timeLastReport to prevent a different error showing a dialog
        timeLastReport = now;
        return;
    }
    if (!feature_flags.RECORDING_V2_FLAG.get()) {
        if (errLog.includes('Unable to claim interface')) {
            showWebUSBError();
            timeLastReport = now;
            return;
        }
        if (errLog.includes('A transfer error has occurred') ||
            errLog.includes('The device was disconnected') ||
            errLog.includes('The transfer was cancelled')) {
            showConnectionLostError();
            timeLastReport = now;
            return;
        }
    }
    if (errLog.includes('(ERR:fmt)')) {
        showUnknownFileError();
        return;
    }
    if (errLog.includes('(ERR:rpc_seq)')) {
        showRpcSequencingError();
        return;
    }
    if (timeLastReport > 0 && now - timeLastReport <= MIN_REPORT_PERIOD_MS) {
        queuedErrors.unshift(errLog);
        if (queuedErrors.length > ERR_QUEUE_MAX_LEN)
            queuedErrors.pop();
        console.log('Suppressing crash dialog, last error notified too soon.');
        return;
    }
    timeLastReport = now;
    // Append queued errors.
    while (queuedErrors.length > 0) {
        const queuedErr = queuedErrors.shift();
        errLog += `\n\n---------------------------------------\n${queuedErr}`;
    }
    const errTitle = errLog.split('\n', 1)[0].substr(0, 80);
    const userDescription = '';
    let checked = false;
    const engine = globals.globals.getCurrentEngine();
    const shareTraceSection = [];
    if ((0, trace_attrs.isShareable)() && !urlExists()) {
        shareTraceSection.push(mithril(`input[type=checkbox]`, {
            checked,
            oninput: (ev) => {
                checked = ev.target.checked;
                if (checked && engine && engine.source.type === 'FILE') {
                    (0, upload_utils.saveTrace)(engine.source.file).then((url) => {
                        const errMessage = createErrorMessage(errLog, checked, url);
                        renderModal(errTitle, errMessage, userDescription, shareTraceSection);
                        return;
                    });
                }
                const errMessage = createErrorMessage(errLog, checked);
                renderModal(errTitle, errMessage, userDescription, shareTraceSection);
            },
        }), mithril('span', `Check this box to share the current trace for debugging
     purposes.`), mithril('div.modal-small', `This will create a permalink to this trace, you may
     leave it unchecked and attach the trace manually
     to the bug if preferred.`));
    }
    renderModal(errTitle, createErrorMessage(errLog, checked), userDescription, shareTraceSection);
}
exports.maybeShowErrorDialog = maybeShowErrorDialog;
function renderModal(errTitle, errMessage, userDescription, shareTraceSection) {
    (0, modal.showModal)({
        title: 'Oops, something went wrong. Please file a bug.',
        content: mithril('div', mithril('.modal-logs', errMessage), mithril('span', `Please provide any additional details describing
           how the crash occurred:`), mithril('textarea.modal-textarea', {
            rows: 3,
            maxlength: 1000,
            oninput: (ev) => {
                userDescription = ev.target.value;
            },
            onkeydown: (e) => {
                e.stopPropagation();
            },
            onkeyup: (e) => {
                e.stopPropagation();
            },
        }), shareTraceSection),
        buttons: [
            {
                text: 'File a bug (Googlers only)',
                primary: true,
                id: 'file_bug',
                action: () => {
                    window.open(createLink(errTitle, errMessage, userDescription), '_blank');
                },
            },
        ],
    });
}
// If there is a trace URL to share, we don't have to show the upload checkbox.
function urlExists() {
    const engine = globals.globals.getCurrentEngine();
    return engine !== undefined &&
        (engine.source.type === 'ARRAY_BUFFER' || engine.source.type === 'URL') &&
        engine.source.url !== undefined;
}
function createErrorMessage(errLog, checked, url) {
    let errMessage = '';
    const engine = globals.globals.getCurrentEngine();
    if (checked && url !== undefined) {
        errMessage += `Trace: ${url}`;
    }
    else if (urlExists()) {
        errMessage +=
            `Trace: ${(0, logging.assertExists)(engine).source.url}`;
    }
    else {
        errMessage += 'To assist with debugging please attach or link to the ' +
            'trace you were viewing.';
    }
    return errMessage + '\n\n' +
        'Viewed on: ' + self.location.origin + '\n\n' + errLog;
}
function createLink(errTitle, errMessage, userDescription) {
    let link = 'https://goto.google.com/perfetto-ui-bug';
    link += '?title=' + encodeURIComponent(`UI Error: ${errTitle}`);
    link += '&description=';
    if (userDescription !== '') {
        link +=
            encodeURIComponent('User description:\n' + userDescription + '\n\n');
    }
    link += encodeURIComponent(errMessage);
    // 8kb is common limit on request size so restrict links to that long:
    return link.substr(0, 8000);
}
function showOutOfMemoryDialog() {
    const url = 'https://perfetto.dev/docs/quickstart/trace-analysis#get-trace-processor';
    const tpCmd = 'curl -LO https://get.perfetto.dev/trace_processor\n' +
        'chmod +x ./trace_processor\n' +
        'trace_processor --httpd /path/to/trace.pftrace\n' +
        '# Reload the UI, it will prompt to use the HTTP+RPC interface';
    (0, modal.showModal)({
        title: 'Oops! Your WASM trace processor ran out of memory',
        content: mithril('div', mithril('span', 'The in-memory representation of the trace is too big ' +
            'for the browser memory limits (typically 2GB per tab).'), mithril('br'), mithril('span', 'You can work around this problem by using the trace_processor ' +
            'native binary as an accelerator for the UI as follows:'), mithril('br'), mithril('br'), mithril('.modal-bash', tpCmd), mithril('br'), mithril('span', 'For details see '), mithril('a', { href: url, target: '_blank' }, url)),
        buttons: [],
    });
}
function showUnknownFileError() {
    (0, modal.showModal)({
        title: 'Cannot open this file',
        content: mithril('div', mithril('p', 'The file opened doesn\'t look like a Perfetto trace or any ' +
            'other format recognized by the Perfetto TraceProcessor.'), mithril('p', 'Formats supported:'), mithril('ul', mithril('li', 'Perfetto protobuf trace'), mithril('li', 'chrome://tracing JSON'), mithril('li', 'Android systrace'), mithril('li', 'Fuchsia trace'), mithril('li', 'Ninja build log'))),
        buttons: [],
    });
}
function showWebUSBError() {
    (0, modal.showModal)({
        title: 'A WebUSB error occurred',
        content: mithril('div', mithril('span', `Is adb already running on the host? Run this command and
      try again.`), mithril('br'), mithril('.modal-bash', '> adb kill-server'), mithril('br'), mithril('span', 'For details see '), mithril('a', { href: 'http://b/159048331', target: '_blank' }, 'b/159048331')),
        buttons: [],
    });
}
function showWebUSBErrorV2() {
    (0, modal.showModal)({
        title: 'A WebUSB error occurred',
        content: mithril('div', mithril('span', `Is adb already running on the host? Run this command and
      try again.`), mithril('br'), mithril('.modal-bash', '> adb kill-server'), mithril('br'), 
        // The statement below covers the following edge case:
        // 1. 'adb server' is running on the device.
        // 2. The user selects the new Android target, so we try to fetch the
        // OS version and do QSS.
        // 3. The error modal is shown.
        // 4. The user runs 'adb kill-server'.
        // At this point we don't have a trigger to try fetching the OS version
        // + QSS again. Therefore, the user will need to refresh the page.
        mithril('span', 'If after running \'adb kill-server\', you don\'t see ' +
            'a \'Start Recording\' button on the page and you don\'t see ' +
            '\'Allow USB debugging\' on the device, ' +
            'you will need to reload this page.'), mithril('br'), mithril('br'), mithril('span', 'For details see '), mithril('a', { href: 'http://b/159048331', target: '_blank' }, 'b/159048331')),
        buttons: [],
    });
}
exports.showWebUSBErrorV2 = showWebUSBErrorV2;
function showConnectionLostError() {
    (0, modal.showModal)({
        title: 'Connection with the ADB device lost',
        content: mithril('div', mithril('span', `Please connect the device again to restart the recording.`), mithril('br')),
        buttons: [],
    });
}
exports.showConnectionLostError = showConnectionLostError;
function showAllowUSBDebugging() {
    (0, modal.showModal)({
        title: 'Could not connect to the device',
        content: mithril('div', mithril('span', 'Please allow USB debugging on the device.'), mithril('br')),
        buttons: [],
    });
}
exports.showAllowUSBDebugging = showAllowUSBDebugging;
function showNoDeviceSelected() {
    (0, modal.showModal)({
        title: 'No device was selected for recording',
        content: mithril('div', mithril('span', `If you want to connect to an ADB device,
           please select it from the list.`), mithril('br')),
        buttons: [],
    });
}
exports.showNoDeviceSelected = showNoDeviceSelected;
function showExtensionNotInstalled() {
    (0, modal.showModal)({
        title: 'Perfetto Chrome extension not installed',
        content: mithril('div', mithril('.note', `To trace Chrome from the Perfetto UI, you need to install our `, mithril('a', { href: chrome_utils.EXTENSION_URL, target: '_blank' }, 'Chrome extension'), ' and then reload this page.'), mithril('br')),
        buttons: [],
    });
}
exports.showExtensionNotInstalled = showExtensionNotInstalled;
function showWebsocketConnectionIssue(message) {
    (0, modal.showModal)({
        title: 'Unable to connect to the device via websocket',
        content: mithril('div', mithril('span', message), mithril('br')),
        buttons: [],
    });
}
exports.showWebsocketConnectionIssue = showWebsocketConnectionIssue;
function showIssueParsingTheTracedResponse(message) {
    (0, modal.showModal)({
        title: 'A problem was encountered while connecting to' +
            ' the Perfetto tracing service',
        content: mithril('div', mithril('span', message), mithril('br')),
        buttons: [],
    });
}
exports.showIssueParsingTheTracedResponse = showIssueParsingTheTracedResponse;
function showFailedToPushBinary(message) {
    (0, modal.showModal)({
        title: 'Failed to push a binary to the device',
        content: mithril('div', mithril('span', 'This can happen if your Android device has an OS version lower ' +
            'than Q. Perfetto tried to push the latest version of its ' +
            'embedded binary but failed.'), mithril('br'), mithril('br'), mithril('span', 'Error message:'), mithril('br'), mithril('span', message)),
        buttons: [],
    });
}
exports.showFailedToPushBinary = showFailedToPushBinary;
function showRpcSequencingError() {
    (0, modal.showModal)({
        title: 'A TraceProcessor RPC error occurred',
        content: mithril('div', mithril('p', 'The trace processor RPC sequence ID was broken'), mithril('p', `This can happen when using a HTTP trace processor instance and
either accidentally sharing this between multiple tabs or
restarting the trace processor while still in use by UI.`), mithril('p', `Please refresh this tab and ensure that trace processor is used
at most one tab at a time.`)),
        buttons: [],
    });
}

});

var errors = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.getErrorMessage = void 0;
// Attempt to coerce an error object into a string message.
// Sometimes an error message is wrapped in an Error object, sometimes not.
function getErrorMessage(e) {
    var _a;
    if (e && typeof e === 'object') {
        const errorObject = e;
        if (errorObject.message) { // regular Error Object
            return String(errorObject.message);
        }
        else if ((_a = errorObject.error) === null || _a === void 0 ? void 0 : _a.message) { // API result
            return String(errorObject.error.message);
        }
    }
    const asString = String(e);
    if (asString === '[object Object]') {
        try {
            return JSON.stringify(e);
        }
        catch (stringifyError) {
            // ignore failures and just fall through
        }
    }
    return asString;
}
exports.getErrorMessage = getErrorMessage;

});

// Copyright (C) 2019 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

const _TextDecoder = TextDecoder;
const _TextEncoder = TextEncoder;

var indexBrowser = /*#__PURE__*/Object.freeze({
__proto__: null,
_TextDecoder: _TextDecoder,
_TextEncoder: _TextEncoder
});

var array_buffer_builder = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArrayBufferBuilder = void 0;


// Return the length, in bytes, of a token to be inserted.
function tokenLength(token) {
    if (typeof token === 'string') {
        return (0, utf8_1.length)(token);
    }
    else if (token instanceof Uint8Array) {
        return token.byteLength;
    }
    else {
        (0, logging.assertTrue)(token >= 0 && token <= 0xffffffff);
        // 32-bit integers take 4 bytes
        return 4;
    }
}
// Insert a token into the buffer, at position `byteOffset`.
//
// @param dataView A DataView into the buffer to write into.
// @param typedArray A Uint8Array view into the buffer to write into.
// @param byteOffset Position to write at, in the buffer.
// @param token Token to insert into the buffer.
function insertToken(dataView, typedArray, byteOffset, token) {
    if (typeof token === 'string') {
        // Encode the string in UTF-8
        const written = (0, utf8_1.write)(token, typedArray, byteOffset);
        (0, logging.assertTrue)(written === (0, utf8_1.length)(token));
    }
    else if (token instanceof Uint8Array) {
        // Copy the bytes from the other array
        typedArray.set(token, byteOffset);
    }
    else {
        (0, logging.assertTrue)(token >= 0 && token <= 0xffffffff);
        // 32-bit little-endian value
        dataView.setUint32(byteOffset, token, true);
    }
}
// Like a string builder, but for an ArrayBuffer instead of a string. This
// allows us to assemble messages to send/receive over the wire. Data can be
// appended to the buffer using `append()`. The data we append can be of the
// following types:
//
// - string: the ASCII string is appended. Throws an error if there are
//           non-ASCII characters.
// - number: the number is appended as a 32-bit little-endian integer.
// - Uint8Array: the bytes are appended as-is to the buffer.
class ArrayBufferBuilder {
    constructor() {
        this.tokens = [];
    }
    // Return an `ArrayBuffer` that is the concatenation of all the tokens.
    toArrayBuffer() {
        // Calculate the size of the buffer we need.
        let byteLength = 0;
        for (const token of this.tokens) {
            byteLength += tokenLength(token);
        }
        // Allocate the buffer.
        const buffer = new ArrayBuffer(byteLength);
        const dataView = new DataView(buffer);
        const typedArray = new Uint8Array(buffer);
        // Fill the buffer with the tokens.
        let byteOffset = 0;
        for (const token of this.tokens) {
            insertToken(dataView, typedArray, byteOffset, token);
            byteOffset += tokenLength(token);
        }
        (0, logging.assertTrue)(byteOffset === byteLength);
        // Return the values.
        return buffer;
    }
    // Add one or more tokens to the value of this object.
    append(token) {
        this.tokens.push(token);
    }
}
exports.ArrayBufferBuilder = ArrayBufferBuilder;

});

var custom_utils_1 = getCjsExportFromNamespace(indexBrowser);

var adb_file_handler = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdbFileHandler = exports.BINARY_PUSH_UNKNOWN_RESPONSE = exports.BINARY_PUSH_FAILURE = void 0;






// https://cs.android.com/android/platform/superproject/+/master:packages/
// modules/adb/file_sync_protocol.h;l=144
const MAX_SYNC_SEND_CHUNK_SIZE = 64 * 1024;
// Adb does not accurately send some file permissions. If you need a special set
// of permissions, do not rely on this value. Rather, send a shell command which
// explicitly sets permissions, such as:
// 'shell:chmod ${permissions} ${path}'
const FILE_PERMISSIONS = Math.pow(2, 15) + 0o644;
const textDecoder = new custom_utils_1._TextDecoder();
exports.BINARY_PUSH_FAILURE = 'BinaryPushFailure';
exports.BINARY_PUSH_UNKNOWN_RESPONSE = 'BinaryPushUnknownResponse';
// For details about the protocol, see:
// https://cs.android.com/android/platform/superproject/+/master:packages/modules/adb/SYNC.TXT
class AdbFileHandler {
    constructor(byteStream) {
        this.byteStream = byteStream;
        this.sentByteCount = 0;
        this.isPushOngoing = false;
    }
    pushBinary(binary, path) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            // For a given byteStream, we only support pushing one binary at a time.
            (0, logging.assertFalse)(this.isPushOngoing);
            this.isPushOngoing = true;
            const transferFinished = (0, deferred.defer)();
            this.byteStream.addOnStreamData((data) => this.onStreamData(data, transferFinished));
            this.byteStream.addOnStreamClose(() => this.isPushOngoing = false);
            const sendMessage = new array_buffer_builder.ArrayBufferBuilder();
            // 'SEND' is the API method used to send a file to device.
            sendMessage.append('SEND');
            // The remote file name is split into two parts separated by the last
            // comma (","). The first part is the actual path, while the second is a
            // decimal encoded file mode containing the permissions of the file on
            // device.
            sendMessage.append(path.length + 6);
            sendMessage.append(path);
            sendMessage.append(',');
            sendMessage.append(FILE_PERMISSIONS.toString());
            this.byteStream.write(new Uint8Array(sendMessage.toArrayBuffer()));
            while (!(yield this.sendNextDataChunk(binary)))
                ;
            return transferFinished;
        });
    }
    onStreamData(data, transferFinished) {
        this.sentByteCount = 0;
        const response = textDecoder.decode(data);
        if (response.split('\n')[0].includes('FAIL')) {
            // Sample failure response (when the file is transferred successfully
            // but the date is not formatted correctly):
            // 'OKAYFAIL\npath too long'
            transferFinished.reject(new recording_error_handling.RecordingError(`${exports.BINARY_PUSH_FAILURE}: ${response}`));
        }
        else if (textDecoder.decode(data).substring(0, 4) === 'OKAY') {
            // In case of success, the server responds to the last request with
            // 'OKAY'.
            transferFinished.resolve();
        }
        else {
            throw new recording_error_handling.RecordingError(`${exports.BINARY_PUSH_UNKNOWN_RESPONSE}: ${response}`);
        }
    }
    sendNextDataChunk(binary) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const endPosition = Math.min(this.sentByteCount + MAX_SYNC_SEND_CHUNK_SIZE, binary.byteLength);
            const chunk = yield binary.slice(this.sentByteCount, endPosition);
            // The file is sent in chunks. Each chunk is prefixed with "DATA" and the
            // chunk length. This is repeated until the entire file is transferred. Each
            // chunk must not be larger than 64k.
            const chunkLength = chunk.byteLength;
            const dataMessage = new array_buffer_builder.ArrayBufferBuilder();
            dataMessage.append('DATA');
            dataMessage.append(chunkLength);
            dataMessage.append(new Uint8Array(chunk.buffer, chunk.byteOffset, chunkLength));
            this.sentByteCount += chunkLength;
            const isDone = this.sentByteCount === binary.byteLength;
            if (isDone) {
                // When the file is transferred a sync request "DONE" is sent, together
                // with a timestamp, representing the last modified time for the file. The
                // server responds to this last request.
                dataMessage.append('DONE');
                // We send the date in seconds.
                dataMessage.append(Math.floor(Date.now() / 1000));
            }
            this.byteStream.write(new Uint8Array(dataMessage.toArrayBuffer()));
            return isDone;
        });
    }
}
exports.AdbFileHandler = AdbFileHandler;

});

var adb_connection_impl = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdbConnectionImpl = void 0;





const textDecoder = new custom_utils_1._TextDecoder();
class AdbConnectionImpl {
    constructor() {
        // onStatus and onDisconnect are set to callbacks passed from the caller.
        // This happens for instance in the AndroidWebusbTarget, which instantiates
        // them with callbacks passed from the UI.
        this.onStatus = () => { };
        this.onDisconnect = (_) => { };
    }
    // Starts a shell command, and returns a promise resolved when the command
    // completes.
    shellAndWaitCompletion(cmd) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const adbStream = yield this.shell(cmd);
            const onStreamingEnded = (0, deferred.defer)();
            // We wait for the stream to be closed by the device, which happens
            // after the shell command is successfully received.
            adbStream.addOnStreamClose(() => {
                onStreamingEnded.resolve();
            });
            return onStreamingEnded;
        });
    }
    // Starts a shell command, then gathers all its output and returns it as
    // a string.
    shellAndGetOutput(cmd) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const adbStream = yield this.shell(cmd);
            const commandOutput = new array_buffer_builder.ArrayBufferBuilder();
            const onStreamingEnded = (0, deferred.defer)();
            adbStream.addOnStreamData((data) => {
                commandOutput.append(data);
            });
            adbStream.addOnStreamClose(() => {
                onStreamingEnded.resolve(textDecoder.decode(commandOutput.toArrayBuffer()));
            });
            return onStreamingEnded;
        });
    }
    push(binary, path) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const byteStream = yield this.openStream('sync:');
            yield (new adb_file_handler.AdbFileHandler(byteStream)).pushBinary(binary, path);
            // We need to wait until the bytestream is closed. Otherwise, we can have a
            // race condition:
            // If this is the last stream, it will try to disconnect the device. In the
            // meantime, the caller might create another stream which will try to open
            // the device.
            yield byteStream.closeAndWaitForTeardown();
        });
    }
}
exports.AdbConnectionImpl = AdbConnectionImpl;

});

var adb_over_websocket_utils = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildAbdWebsocketCommand = void 0;
// The messages read by the adb server have their length prepended in hex.
// This method adds the length at the beginning of the message.
// Example: 'host:track-devices' -> '0012host:track-devices'
// go/codesearch/aosp-android11/system/core/adb/SERVICES.TXT
function buildAbdWebsocketCommand(cmd) {
    const hdr = cmd.length.toString(16).padStart(4, '0');
    return hdr + cmd;
}
exports.buildAbdWebsocketCommand = buildAbdWebsocketCommand;

});

var adb_targets_utils = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.CUSTOM_TRACED_CONSUMER_SOCKET_PATH = exports.DEFAULT_TRACED_CONSUMER_SOCKET_PATH = exports.ALLOW_USB_DEBUGGING = exports.TRACEBOX_FETCH_TIMEOUT = exports.TRACEBOX_DEVICE_PATH = void 0;
// In case the device doesn't have the tracebox, we upload the latest version
// to this path.
exports.TRACEBOX_DEVICE_PATH = '/data/local/tmp/tracebox';
// Experimentally, this takes 900ms on the first fetch and 20-30ms after
// because of caching.
exports.TRACEBOX_FETCH_TIMEOUT = 30000;
// Message shown to the user when they need to allow authentication on the
// device in order to connect.
exports.ALLOW_USB_DEBUGGING = 'Please allow USB debugging on device and try again.';
// If the Android device has the tracing service on it (from API version 29),
// then we can connect to this consumer socket.
exports.DEFAULT_TRACED_CONSUMER_SOCKET_PATH = 'localfilesystem:/dev/socket/traced_consumer';
// If the Android device does not have the tracing service on it (before API
// version 29), we will have to push the tracebox on the device. Then, we
// can connect to this consumer socket (using it does not require system admin
// privileges).
exports.CUSTOM_TRACED_CONSUMER_SOCKET_PATH = 'localabstract:traced_consumer';

});

var adb_connection_over_websocket = createCommonjsModule(function (module, exports) {
// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdbOverWebsocketStream = exports.AdbConnectionOverWebsocket = exports.WEBSOCKET_UNABLE_TO_CONNECT = void 0;







const textDecoder = new custom_utils_1._TextDecoder();
exports.WEBSOCKET_UNABLE_TO_CONNECT = 'Unable to connect to device via websocket.';
class AdbConnectionOverWebsocket extends adb_connection_impl.AdbConnectionImpl {
    constructor(deviceSerialNumber, websocketUrl) {
        super();
        this.deviceSerialNumber = deviceSerialNumber;
        this.websocketUrl = websocketUrl;
        this.streams = new Set();
        this.onDisconnect = (_) => { };
    }
    shell(cmd) {
        return this.openStream('shell:' + cmd);
    }
    connectSocket(path) {
        return this.openStream(path);
    }
    openStream(destination) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            return AdbOverWebsocketStream.create(this.websocketUrl, destination, this.deviceSerialNumber, this.closeStream.bind(this));
        });
    }
    // The disconnection for AdbConnectionOverWebsocket is synchronous, but this
    // method is async to have a common interface with other types of connections
    // which are async.
    disconnect(disconnectMessage) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            for (const stream of this.streams) {
                stream.close();
            }
            this.onDisconnect(disconnectMessage);
        });
    }
    closeStream(stream) {
        if (this.streams.has(stream)) {
            this.streams.delete(stream);
        }
    }
    // There will be no contention for the websocket connection, because it will
    // communicate with the 'adb server' running on the computer which opened
    // Perfetto.
    canConnectWithoutContention() {
        return Promise.resolve(true);
    }
}
exports.AdbConnectionOverWebsocket = AdbConnectionOverWebsocket;
// An AdbOverWebsocketStream instantiates a websocket connection to the device.
// It exposes an API to write commands to this websocket and read its output.
class AdbOverWebsocketStream {
    constructor(websocketUrl, destination, deviceSerialNumber, removeFromConnection) {
        this.removeFromConnection = removeFromConnection;
        // commandSentSignal gets resolved if we successfully connect to the device
        // and send the command this socket wraps. commandSentSignal gets rejected if
        // we fail to connect to the device.
        this.commandSentSignal = (0, deferred.defer)();
        // We store a promise for each messge while the message is processed.
        // This way, if the websocket server closes the connection, we first process
        // all previously received messages and only afterwards disconnect.
        // An application is when the stream wraps a shell command. The websocket
        // server will reply and then immediately disconnect.
        this.messageProcessedSignals = new Set();
        this._isConnected = false;
        this.onStreamDataCallbacks = [];
        this.onStreamCloseCallbacks = [];
        this.websocket = new WebSocket(websocketUrl);
        this.websocket.onopen = this.onOpen.bind(this, deviceSerialNumber);
        this.websocket.onmessage = this.onMessage.bind(this, destination);
        // The websocket may be closed by the websocket server. This happens
        // for instance when we get the full result of a shell command.
        this.websocket.onclose = this.onClose.bind(this);
    }
    addOnStreamData(onStreamData) {
        this.onStreamDataCallbacks.push(onStreamData);
    }
    addOnStreamClose(onStreamClose) {
        this.onStreamCloseCallbacks.push(onStreamClose);
    }
    // Used by the connection object to signal newly received data, not exposed
    // in the interface.
    signalStreamData(data) {
        for (const onStreamData of this.onStreamDataCallbacks) {
            onStreamData(data);
        }
    }
    // Used by the connection object to signal the stream is closed, not exposed
    // in the interface.
    signalStreamClosed() {
        for (const onStreamClose of this.onStreamCloseCallbacks) {
            onStreamClose();
        }
        this.onStreamDataCallbacks = [];
        this.onStreamCloseCallbacks = [];
    }
    // We close the websocket and notify the AdbConnection to remove this stream.
    close() {
        // If the websocket connection is still open (ie. the close did not
        // originate from the server), we close the websocket connection.
        if (this.websocket.readyState === this.websocket.OPEN) {
            this.websocket.close();
            // We remove the 'onclose' callback so the 'close' method doesn't get
            // executed twice.
            this.websocket.onclose = null;
        }
        this._isConnected = false;
        this.removeFromConnection(this);
        this.signalStreamClosed();
    }
    // For websocket, the teardown happens synchronously.
    closeAndWaitForTeardown() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            this.close();
        });
    }
    write(msg) {
        this.websocket.send(msg);
    }
    isConnected() {
        return this._isConnected;
    }
    onOpen(deviceSerialNumber) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            this.websocket.send((0, adb_over_websocket_utils.buildAbdWebsocketCommand)(`host:transport:${deviceSerialNumber}`));
        });
    }
    onMessage(destination, evt) {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            const messageProcessed = (0, deferred.defer)();
            this.messageProcessedSignals.add(messageProcessed);
            try {
                if (!this._isConnected) {
                    const txt = yield evt.data.text();
                    const prefix = txt.substr(0, 4);
                    if (prefix === 'OKAY') {
                        this._isConnected = true;
                        this.websocket.send((0, adb_over_websocket_utils.buildAbdWebsocketCommand)(destination));
                        this.commandSentSignal.resolve(this);
                    }
                    else if (prefix === 'FAIL' && txt.includes('device unauthorized')) {
                        this.commandSentSignal.reject(new recording_error_handling.RecordingError(adb_targets_utils.ALLOW_USB_DEBUGGING));
                        this.close();
                    }
                    else {
                        this.commandSentSignal.reject(new recording_error_handling.RecordingError(exports.WEBSOCKET_UNABLE_TO_CONNECT));
                        this.close();
                    }
                }
                else {
                    // Upon a successful connection we first receive an 'OKAY' message.
                    // After that, we receive messages with traced binary payloads.
                    const arrayBufferResponse = yield evt.data.arrayBuffer();
                    if (textDecoder.decode(arrayBufferResponse) !== 'OKAY') {
                        this.signalStreamData(new Uint8Array(arrayBufferResponse));
                    }
                }
                messageProcessed.resolve();
            }
            finally {
                this.messageProcessedSignals.delete(messageProcessed);
            }
        });
    }
    onClose() {
        return tslib.__awaiter(this, void 0, void 0, function* () {
            // Wait for all messages to be processed before closing the connection.
            yield Promise.allSettled(this.messageProcessedSignals);
            this.close();
        });
    }
    static create(websocketUrl, destination, deviceSerialNumber, removeFromConnection) {
        return (new AdbOverWebsocketStream(websocketUrl, destination, deviceSerialNumber, removeFromConnection))
            .commandSentSignal;
    }
}
exports.AdbOverWebsocketStream = AdbOverWebsocketStream;

});

// Common aliases
var $Reader = minimal$1.Reader, $Writer = minimal$1.Writer, $util = minimal$1.util;

// Exported root namespace
var $root = minimal$1.roots["default"] || (minimal$1.roots["default"] = {});

$root.perfetto = (function() {

    /**
     * Namespace perfetto.
     * @exports perfetto
     * @namespace
     */
    var perfetto = {};

    perfetto.protos = (function() {

        /**
         * Namespace protos.
         * @memberof perfetto
         * @namespace
         */
        var protos = {};

        /**
         * TraceProcessorApiVersion enum.
         * @name perfetto.protos.TraceProcessorApiVersion
         * @enum {number}
         * @property {number} TRACE_PROCESSOR_CURRENT_API_VERSION=5 TRACE_PROCESSOR_CURRENT_API_VERSION value
         */
        protos.TraceProcessorApiVersion = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[5] = "TRACE_PROCESSOR_CURRENT_API_VERSION"] = 5;
            return values;
        })();

        protos.TraceProcessorRpcStream = (function() {

            /**
             * Properties of a TraceProcessorRpcStream.
             * @memberof perfetto.protos
             * @interface ITraceProcessorRpcStream
             * @property {Array.<perfetto.protos.ITraceProcessorRpc>|null} [msg] TraceProcessorRpcStream msg
             */

            /**
             * Constructs a new TraceProcessorRpcStream.
             * @memberof perfetto.protos
             * @classdesc Represents a TraceProcessorRpcStream.
             * @implements ITraceProcessorRpcStream
             * @constructor
             * @param {perfetto.protos.ITraceProcessorRpcStream=} [properties] Properties to set
             */
            function TraceProcessorRpcStream(properties) {
                this.msg = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TraceProcessorRpcStream msg.
             * @member {Array.<perfetto.protos.ITraceProcessorRpc>} msg
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @instance
             */
            TraceProcessorRpcStream.prototype.msg = $util.emptyArray;

            /**
             * Creates a new TraceProcessorRpcStream instance using the specified properties.
             * @function create
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @static
             * @param {perfetto.protos.ITraceProcessorRpcStream=} [properties] Properties to set
             * @returns {perfetto.protos.TraceProcessorRpcStream} TraceProcessorRpcStream instance
             */
            TraceProcessorRpcStream.create = function create(properties) {
                return new TraceProcessorRpcStream(properties);
            };

            /**
             * Encodes the specified TraceProcessorRpcStream message. Does not implicitly {@link perfetto.protos.TraceProcessorRpcStream.verify|verify} messages.
             * @function encode
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @static
             * @param {perfetto.protos.ITraceProcessorRpcStream} message TraceProcessorRpcStream message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TraceProcessorRpcStream.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.msg != null && message.msg.length)
                    for (var i = 0; i < message.msg.length; ++i)
                        $root.perfetto.protos.TraceProcessorRpc.encode(message.msg[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TraceProcessorRpcStream message, length delimited. Does not implicitly {@link perfetto.protos.TraceProcessorRpcStream.verify|verify} messages.
             * @function encodeDelimited
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @static
             * @param {perfetto.protos.ITraceProcessorRpcStream} message TraceProcessorRpcStream message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TraceProcessorRpcStream.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TraceProcessorRpcStream message from the specified reader or buffer.
             * @function decode
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {perfetto.protos.TraceProcessorRpcStream} TraceProcessorRpcStream
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TraceProcessorRpcStream.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.perfetto.protos.TraceProcessorRpcStream();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        if (!(message.msg && message.msg.length))
                            message.msg = [];
                        message.msg.push($root.perfetto.protos.TraceProcessorRpc.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TraceProcessorRpcStream message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {perfetto.protos.TraceProcessorRpcStream} TraceProcessorRpcStream
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TraceProcessorRpcStream.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TraceProcessorRpcStream message.
             * @function verify
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TraceProcessorRpcStream.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.msg != null && message.hasOwnProperty("msg")) {
                    if (!Array.isArray(message.msg))
                        return "msg: array expected";
                    for (var i = 0; i < message.msg.length; ++i) {
                        var error = $root.perfetto.protos.TraceProcessorRpc.verify(message.msg[i]);
                        if (error)
                            return "msg." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a TraceProcessorRpcStream message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {perfetto.protos.TraceProcessorRpcStream} TraceProcessorRpcStream
             */
            TraceProcessorRpcStream.fromObject = function fromObject(object) {
                if (object instanceof $root.perfetto.protos.TraceProcessorRpcStream)
                    return object;
                var message = new $root.perfetto.protos.TraceProcessorRpcStream();
                if (object.msg) {
                    if (!Array.isArray(object.msg))
                        throw TypeError(".perfetto.protos.TraceProcessorRpcStream.msg: array expected");
                    message.msg = [];
                    for (var i = 0; i < object.msg.length; ++i) {
                        if (typeof object.msg[i] !== "object")
                            throw TypeError(".perfetto.protos.TraceProcessorRpcStream.msg: object expected");
                        message.msg[i] = $root.perfetto.protos.TraceProcessorRpc.fromObject(object.msg[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a TraceProcessorRpcStream message. Also converts values to other types if specified.
             * @function toObject
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @static
             * @param {perfetto.protos.TraceProcessorRpcStream} message TraceProcessorRpcStream
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TraceProcessorRpcStream.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.msg = [];
                if (message.msg && message.msg.length) {
                    object.msg = [];
                    for (var j = 0; j < message.msg.length; ++j)
                        object.msg[j] = $root.perfetto.protos.TraceProcessorRpc.toObject(message.msg[j], options);
                }
                return object;
            };

            /**
             * Converts this TraceProcessorRpcStream to JSON.
             * @function toJSON
             * @memberof perfetto.protos.TraceProcessorRpcStream
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TraceProcessorRpcStream.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, minimal$1.util.toJSONOptions);
            };

            return TraceProcessorRpcStream;
        })();

        protos.TraceProcessorRpc = (function() {

            /**
             * Properties of a TraceProcessorRpc.
             * @memberof perfetto.protos
             * @interface ITraceProcessorRpc
             * @property {number|null} [seq] TraceProcessorRpc seq
             * @property {string|null} [fatalError] TraceProcessorRpc fatalError
             * @property {perfetto.protos.TraceProcessorRpc.TraceProcessorMethod|null} [request] TraceProcessorRpc request
             * @property {perfetto.protos.TraceProcessorRpc.TraceProcessorMethod|null} [response] TraceProcessorRpc response
             * @property {perfetto.protos.TraceProcessorRpc.TraceProcessorMethod|null} [invalidRequest] TraceProcessorRpc invalidRequest
             * @property {Uint8Array|null} [appendTraceData] TraceProcessorRpc appendTraceData
             * @property {perfetto.protos.IQueryArgs|null} [queryArgs] TraceProcessorRpc queryArgs
             * @property {perfetto.protos.IComputeMetricArgs|null} [computeMetricArgs] TraceProcessorRpc computeMetricArgs
             * @property {perfetto.protos.IAppendTraceDataResult|null} [appendResult] TraceProcessorRpc appendResult
             * @property {perfetto.protos.IQueryResult|null} [queryResult] TraceProcessorRpc queryResult
             * @property {perfetto.protos.IComputeMetricResult|null} [metricResult] TraceProcessorRpc metricResult
             * @property {perfetto.protos.IDescriptorSet|null} [metricDescriptors] TraceProcessorRpc metricDescriptors
             * @property {perfetto.protos.IDisableAndReadMetatraceResult|null} [metatrace] TraceProcessorRpc metatrace
             * @property {perfetto.protos.IStatusResult|null} [status] TraceProcessorRpc status
             */

            /**
             * Constructs a new TraceProcessorRpc.
             * @memberof perfetto.protos
             * @classdesc Represents a TraceProcessorRpc.
             * @implements ITraceProcessorRpc
             * @constructor
             * @param {perfetto.protos.ITraceProcessorRpc=} [properties] Properties to set
             */
            function TraceProcessorRpc(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * TraceProcessorRpc seq.
             * @member {number} seq
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.seq = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            /**
             * TraceProcessorRpc fatalError.
             * @member {string} fatalError
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.fatalError = "";

            /**
             * TraceProcessorRpc request.
             * @member {perfetto.protos.TraceProcessorRpc.TraceProcessorMethod} request
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.request = 0;

            /**
             * TraceProcessorRpc response.
             * @member {perfetto.protos.TraceProcessorRpc.TraceProcessorMethod} response
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.response = 0;

            /**
             * TraceProcessorRpc invalidRequest.
             * @member {perfetto.protos.TraceProcessorRpc.TraceProcessorMethod} invalidRequest
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.invalidRequest = 0;

            /**
             * TraceProcessorRpc appendTraceData.
             * @member {Uint8Array} appendTraceData
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.appendTraceData = $util.newBuffer([]);

            /**
             * TraceProcessorRpc queryArgs.
             * @member {perfetto.protos.IQueryArgs|null|undefined} queryArgs
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.queryArgs = null;

            /**
             * TraceProcessorRpc computeMetricArgs.
             * @member {perfetto.protos.IComputeMetricArgs|null|undefined} computeMetricArgs
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.computeMetricArgs = null;

            /**
             * TraceProcessorRpc appendResult.
             * @member {perfetto.protos.IAppendTraceDataResult|null|undefined} appendResult
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.appendResult = null;

            /**
             * TraceProcessorRpc queryResult.
             * @member {perfetto.protos.IQueryResult|null|undefined} queryResult
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.queryResult = null;

            /**
             * TraceProcessorRpc metricResult.
             * @member {perfetto.protos.IComputeMetricResult|null|undefined} metricResult
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.metricResult = null;

            /**
             * TraceProcessorRpc metricDescriptors.
             * @member {perfetto.protos.IDescriptorSet|null|undefined} metricDescriptors
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.metricDescriptors = null;

            /**
             * TraceProcessorRpc metatrace.
             * @member {perfetto.protos.IDisableAndReadMetatraceResult|null|undefined} metatrace
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.metatrace = null;

            /**
             * TraceProcessorRpc status.
             * @member {perfetto.protos.IStatusResult|null|undefined} status
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            TraceProcessorRpc.prototype.status = null;

            // OneOf field names bound to virtual getters and setters
            var $oneOfFields;

            /**
             * TraceProcessorRpc type.
             * @member {"request"|"response"|"invalidRequest"|undefined} type
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            Object.defineProperty(TraceProcessorRpc.prototype, "type", {
                get: $util.oneOfGetter($oneOfFields = ["request", "response", "invalidRequest"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * TraceProcessorRpc args.
             * @member {"appendTraceData"|"queryArgs"|"computeMetricArgs"|"appendResult"|"queryResult"|"metricResult"|"metricDescriptors"|"metatrace"|"status"|undefined} args
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             */
            Object.defineProperty(TraceProcessorRpc.prototype, "args", {
                get: $util.oneOfGetter($oneOfFields = ["appendTraceData", "queryArgs", "computeMetricArgs", "appendResult", "queryResult", "metricResult", "metricDescriptors", "metatrace", "status"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new TraceProcessorRpc instance using the specified properties.
             * @function create
             * @memberof perfetto.protos.TraceProcessorRpc
             * @static
             * @param {perfetto.protos.ITraceProcessorRpc=} [properties] Properties to set
             * @returns {perfetto.protos.TraceProcessorRpc} TraceProcessorRpc instance
             */
            TraceProcessorRpc.create = function create(properties) {
                return new TraceProcessorRpc(properties);
            };

            /**
             * Encodes the specified TraceProcessorRpc message. Does not implicitly {@link perfetto.protos.TraceProcessorRpc.verify|verify} messages.
             * @function encode
             * @memberof perfetto.protos.TraceProcessorRpc
             * @static
             * @param {perfetto.protos.ITraceProcessorRpc} message TraceProcessorRpc message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TraceProcessorRpc.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.seq != null && Object.hasOwnProperty.call(message, "seq"))
                    writer.uint32(/* id 1, wireType 0 =*/8).int64(message.seq);
                if (message.request != null && Object.hasOwnProperty.call(message, "request"))
                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.request);
                if (message.response != null && Object.hasOwnProperty.call(message, "response"))
                    writer.uint32(/* id 3, wireType 0 =*/24).int32(message.response);
                if (message.invalidRequest != null && Object.hasOwnProperty.call(message, "invalidRequest"))
                    writer.uint32(/* id 4, wireType 0 =*/32).int32(message.invalidRequest);
                if (message.fatalError != null && Object.hasOwnProperty.call(message, "fatalError"))
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.fatalError);
                if (message.appendTraceData != null && Object.hasOwnProperty.call(message, "appendTraceData"))
                    writer.uint32(/* id 101, wireType 2 =*/810).bytes(message.appendTraceData);
                if (message.queryArgs != null && Object.hasOwnProperty.call(message, "queryArgs"))
                    $root.perfetto.protos.QueryArgs.encode(message.queryArgs, writer.uint32(/* id 103, wireType 2 =*/826).fork()).ldelim();
                if (message.computeMetricArgs != null && Object.hasOwnProperty.call(message, "computeMetricArgs"))
                    $root.perfetto.protos.ComputeMetricArgs.encode(message.computeMetricArgs, writer.uint32(/* id 105, wireType 2 =*/842).fork()).ldelim();
                if (message.appendResult != null && Object.hasOwnProperty.call(message, "appendResult"))
                    $root.perfetto.protos.AppendTraceDataResult.encode(message.appendResult, writer.uint32(/* id 201, wireType 2 =*/1610).fork()).ldelim();
                if (message.queryResult != null && Object.hasOwnProperty.call(message, "queryResult"))
                    $root.perfetto.protos.QueryResult.encode(message.queryResult, writer.uint32(/* id 203, wireType 2 =*/1626).fork()).ldelim();
                if (message.metricResult != null && Object.hasOwnProperty.call(message, "metricResult"))
                    $root.perfetto.protos.ComputeMetricResult.encode(message.metricResult, writer.uint32(/* id 205, wireType 2 =*/1642).fork()).ldelim();
                if (message.metricDescriptors != null && Object.hasOwnProperty.call(message, "metricDescriptors"))
                    $root.perfetto.protos.DescriptorSet.encode(message.metricDescriptors, writer.uint32(/* id 206, wireType 2 =*/1650).fork()).ldelim();
                if (message.metatrace != null && Object.hasOwnProperty.call(message, "metatrace"))
                    $root.perfetto.protos.DisableAndReadMetatraceResult.encode(message.metatrace, writer.uint32(/* id 209, wireType 2 =*/1674).fork()).ldelim();
                if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                    $root.perfetto.protos.StatusResult.encode(message.status, writer.uint32(/* id 210, wireType 2 =*/1682).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified TraceProcessorRpc message, length delimited. Does not implicitly {@link perfetto.protos.TraceProcessorRpc.verify|verify} messages.
             * @function encodeDelimited
             * @memberof perfetto.protos.TraceProcessorRpc
             * @static
             * @param {perfetto.protos.ITraceProcessorRpc} message TraceProcessorRpc message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            TraceProcessorRpc.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a TraceProcessorRpc message from the specified reader or buffer.
             * @function decode
             * @memberof perfetto.protos.TraceProcessorRpc
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {perfetto.protos.TraceProcessorRpc} TraceProcessorRpc
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TraceProcessorRpc.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.perfetto.protos.TraceProcessorRpc();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.seq = reader.int64();
                        break;
                    case 5:
                        message.fatalError = reader.string();
                        break;
                    case 2:
                        message.request = reader.int32();
                        break;
                    case 3:
                        message.response = reader.int32();
                        break;
                    case 4:
                        message.invalidRequest = reader.int32();
                        break;
                    case 101:
                        message.appendTraceData = reader.bytes();
                        break;
                    case 103:
                        message.queryArgs = $root.perfetto.protos.QueryArgs.decode(reader, reader.uint32());
                        break;
                    case 105:
                        message.computeMetricArgs = $root.perfetto.protos.ComputeMetricArgs.decode(reader, reader.uint32());
                        break;
                    case 201:
                        message.appendResult = $root.perfetto.protos.AppendTraceDataResult.decode(reader, reader.uint32());
                        break;
                    case 203:
                        message.queryResult = $root.perfetto.protos.QueryResult.decode(reader, reader.uint32());
                        break;
                    case 205:
                        message.metricResult = $root.perfetto.protos.ComputeMetricResult.decode(reader, reader.uint32());
                        break;
                    case 206:
                        message.metricDescriptors = $root.perfetto.protos.DescriptorSet.decode(reader, reader.uint32());
                        break;
                    case 209:
                        message.metatrace = $root.perfetto.protos.DisableAndReadMetatraceResult.decode(reader, reader.uint32());
                        break;
                    case 210:
                        message.status = $root.perfetto.protos.StatusResult.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a TraceProcessorRpc message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof perfetto.protos.TraceProcessorRpc
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {perfetto.protos.TraceProcessorRpc} TraceProcessorRpc
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            TraceProcessorRpc.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a TraceProcessorRpc message.
             * @function verify
             * @memberof perfetto.protos.TraceProcessorRpc
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            TraceProcessorRpc.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                var properties = {};
                if (message.seq != null && message.hasOwnProperty("seq"))
                    if (!$util.isInteger(message.seq) && !(message.seq && $util.isInteger(message.seq.low) && $util.isInteger(message.seq.high)))
                        return "seq: integer|Long expected";
                if (message.fatalError != null && message.hasOwnProperty("fatalError"))
                    if (!$util.isString(message.fatalError))
                        return "fatalError: string expected";
                if (message.request != null && message.hasOwnProperty("request")) {
                    properties.type = 1;
                    switch (message.request) {
                    default:
                        return "request: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                        break;
                    }
                }
                if (message.response != null && message.hasOwnProperty("response")) {
                    if (properties.type === 1)
                        return "type: multiple values";
                    properties.type = 1;
                    switch (message.response) {
                    default:
                        return "response: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                        break;
                    }
                }
                if (message.invalidRequest != null && message.hasOwnProperty("invalidRequest")) {
                    if (properties.type === 1)
                        return "type: multiple values";
                    properties.type = 1;
                    switch (message.invalidRequest) {
                    default:
                        return "invalidRequest: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                        break;
                    }
                }
                if (message.appendTraceData != null && message.hasOwnProperty("appendTraceData")) {
                    properties.args = 1;
                    if (!(message.appendTraceData && typeof message.appendTraceData.length === "number" || $util.isString(message.appendTraceData)))
                        return "appendTraceData: buffer expected";
                }
                if (message.queryArgs != null && message.hasOwnProperty("queryArgs")) {
                    if (properties.args === 1)
                        return "args: multiple values";
                    properties.args = 1;
                    {
                        var error = $root.perfetto.protos.QueryArgs.verify(message.queryArgs);
                        if (error)
                            return "queryArgs." + error;
                    }
                }
                if (message.computeMetricArgs != null && message.hasOwnProperty("computeMetricArgs")) {
                    if (properties.args === 1)
                        return "args: multiple values";
                    properties.args = 1;
                    {
                        var error = $root.perfetto.protos.ComputeMetricArgs.verify(message.computeMetricArgs);
                        if (error)
                            return "computeMetricArgs." + error;
                    }
                }
                if (message.appendResult != null && message.hasOwnProperty("appendResult")) {
                    if (properties.args === 1)
                        return "args: multiple values";
                    properties.args = 1;
                    {
                        var error = $root.perfetto.protos.AppendTraceDataResult.verify(message.appendResult);
                        if (error)
                            return "appendResult." + error;
                    }
                }
                if (message.queryResult != null && message.hasOwnProperty("queryResult")) {
                    if (properties.args === 1)
                        return "args: multiple values";
                    properties.args = 1;
                    {
                        var error = $root.perfetto.protos.QueryResult.verify(message.queryResult);
                        if (error)
                            return "queryResult." + error;
                    }
                }
                if (message.metricResult != null && message.hasOwnProperty("metricResult")) {
                    if (properties.args === 1)
                        return "args: multiple values";
                    properties.args = 1;
                    {
                        var error = $root.perfetto.protos.ComputeMetricResult.verify(message.metricResult);
                        if (error)
                            return "metricResult." + error;
                    }
                }
                if (message.metricDescriptors != null && message.hasOwnProperty("metricDescriptors")) {
                    if (properties.args === 1)
                        return "args: multiple values";
                    properties.args = 1;
                    {
                        var error = $root.perfetto.protos.DescriptorSet.verify(message.metricDescriptors);
                        if (error)
                            return "metricDescriptors." + error;
                    }
                }
                if (message.metatrace != null && message.hasOwnProperty("metatrace")) {
                    if (properties.args === 1)
                        return "args: multiple values";
                    properties.args = 1;
                    {
                        var error = $root.perfetto.protos.DisableAndReadMetatraceResult.verify(message.metatrace);
                        if (error)
                            return "metatrace." + error;
                    }
                }
                if (message.status != null && message.hasOwnProperty("status")) {
                    if (properties.args === 1)
                        return "args: multiple values";
                    properties.args = 1;
                    {
                        var error = $root.perfetto.protos.StatusResult.verify(message.status);
                        if (error)
                            return "status." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a TraceProcessorRpc message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof perfetto.protos.TraceProcessorRpc
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {perfetto.protos.TraceProcessorRpc} TraceProcessorRpc
             */
            TraceProcessorRpc.fromObject = function fromObject(object) {
                if (object instanceof $root.perfetto.protos.TraceProcessorRpc)
                    return object;
                var message = new $root.perfetto.protos.TraceProcessorRpc();
                if (object.seq != null)
                    if ($util.Long)
                        (message.seq = $util.Long.fromValue(object.seq)).unsigned = false;
                    else if (typeof object.seq === "string")
                        message.seq = parseInt(object.seq, 10);
                    else if (typeof object.seq === "number")
                        message.seq = object.seq;
                    else if (typeof object.seq === "object")
                        message.seq = new $util.LongBits(object.seq.low >>> 0, object.seq.high >>> 0).toNumber();
                if (object.fatalError != null)
                    message.fatalError = String(object.fatalError);
                switch (object.request) {
                case "TPM_UNSPECIFIED":
                case 0:
                    message.request = 0;
                    break;
                case "TPM_APPEND_TRACE_DATA":
                case 1:
                    message.request = 1;
                    break;
                case "TPM_FINALIZE_TRACE_DATA":
                case 2:
                    message.request = 2;
                    break;
                case "TPM_QUERY_STREAMING":
                case 3:
                    message.request = 3;
                    break;
                case "TPM_COMPUTE_METRIC":
                case 5:
                    message.request = 5;
                    break;
                case "TPM_GET_METRIC_DESCRIPTORS":
                case 6:
                    message.request = 6;
                    break;
                case "TPM_RESTORE_INITIAL_TABLES":
                case 7:
                    message.request = 7;
                    break;
                case "TPM_ENABLE_METATRACE":
                case 8:
                    message.request = 8;
                    break;
                case "TPM_DISABLE_AND_READ_METATRACE":
                case 9:
                    message.request = 9;
                    break;
                case "TPM_GET_STATUS":
                case 10:
                    message.request = 10;
                    break;
                }
                switch (object.response) {
                case "TPM_UNSPECIFIED":
                case 0:
                    message.response = 0;
                    break;
                case "TPM_APPEND_TRACE_DATA":
                case 1:
                    message.response = 1;
                    break;
                case "TPM_FINALIZE_TRACE_DATA":
                case 2:
                    message.response = 2;
                    break;
                case "TPM_QUERY_STREAMING":
                case 3:
                    message.response = 3;
                    break;
                case "TPM_COMPUTE_METRIC":
                case 5:
                    message.response = 5;
                    break;
                case "TPM_GET_METRIC_DESCRIPTORS":
                case 6:
                    message.response = 6;
                    break;
                case "TPM_RESTORE_INITIAL_TABLES":
                case 7:
                    message.response = 7;
                    break;
                case "TPM_ENABLE_METATRACE":
                case 8:
                    message.response = 8;
                    break;
                case "TPM_DISABLE_AND_READ_METATRACE":
                case 9:
                    message.response = 9;
                    break;
                case "TPM_GET_STATUS":
                case 10:
                    message.response = 10;
                    break;
                }
                switch (object.invalidRequest) {
                case "TPM_UNSPECIFIED":
                case 0:
                    message.invalidRequest = 0;
                    break;
                case "TPM_APPEND_TRACE_DATA":
                case 1:
                    message.invalidRequest = 1;
                    break;
                case "TPM_FINALIZE_TRACE_DATA":
                case 2:
                    message.invalidRequest = 2;
                    break;
                case "TPM_QUERY_STREAMING":
                case 3:
                    message.invalidRequest = 3;
                    break;
                case "TPM_COMPUTE_METRIC":
                case 5:
                    message.invalidRequest = 5;
                    break;
                case "TPM_GET_METRIC_DESCRIPTORS":
                case 6:
                    message.invalidRequest = 6;
                    break;
                case "TPM_RESTORE_INITIAL_TABLES":
                case 7:
                    message.invalidRequest = 7;
                    break;
                case "TPM_ENABLE_METATRACE":
                case 8:
                    message.invalidRequest = 8;
                    break;
                case "TPM_DISABLE_AND_READ_METATRACE":
                case 9:
                    message.invalidRequest = 9;
                    break;
                case "TPM_GET_STATUS":
                case 10:
                    message.invalidRequest = 10;
                    break;
                }
                if (object.appendTraceData != null)
                    if (typeof object.appendTraceData === "string")
                        $util.base64.decode(object.appendTraceData, message.appendTraceData = $util.newBuffer($util.base64.length(object.appendTraceData)), 0);
                    else if (object.appendTraceData.length)
                        message.appendTraceData = object.appendTraceData;
                if (object.queryArgs != null) {
                    if (typeof object.queryArgs !== "object")
                        throw TypeError(".perfetto.protos.TraceProcessorRpc.queryArgs: object expected");
                    message.queryArgs = $root.perfetto.protos.QueryArgs.fromObject(object.queryArgs);
                }
                if (object.computeMetricArgs != null) {
                    if (typeof object.computeMetricArgs !== "object")
                        throw TypeError(".perfetto.protos.TraceProcessorRpc.computeMetricArgs: object expected");
                    message.computeMetricArgs = $root.perfetto.protos.ComputeMetricArgs.fromObject(object.computeMetricArgs);
                }
                if (object.appendResult != null) {
                    if (typeof object.appendResult !== "object")
                        throw TypeError(".perfetto.protos.TraceProcessorRpc.appendResult: object expected");
                    message.appendResult = $root.perfetto.protos.AppendTraceDataResult.fromObject(object.appendResult);
                }
                if (object.queryResult != null) {
                    if (typeof object.queryResult !== "object")
                        throw TypeError(".perfetto.protos.TraceProcessorRpc.queryResult: object expected");
                    message.queryResult = $root.perfetto.protos.QueryResult.fromObject(object.queryResult);
                }
                if (object.metricResult != null) {
                    if (typeof object.metricResult !== "object")
                        throw TypeError(".perfetto.protos.TraceProcessorRpc.metricResult: object expected");
                    message.metricResult = $root.perfetto.protos.ComputeMetricResult.fromObject(object.metricResult);
                }
                if (object.metricDescriptors != null) {
                    if (typeof object.metricDescriptors !== "object")
                        throw TypeError(".perfetto.protos.TraceProcessorRpc.metricDescriptors: object expected");
                    message.metricDescriptors = $root.perfetto.protos.DescriptorSet.fromObject(object.metricDescriptors);
                }
                if (object.metatrace != null) {
                    if (typeof object.metatrace !== "object")
                        throw TypeError(".perfetto.protos.TraceProcessorRpc.metatrace: object expected");
                    message.metatrace = $root.perfetto.protos.DisableAndReadMetatraceResult.fromObject(object.metatrace);
                }
                if (object.status != null) {
                    if (typeof object.status !== "object")
                        throw TypeError(".perfetto.protos.TraceProcessorRpc.status: object expected");
                    message.status = $root.perfetto.protos.StatusResult.fromObject(object.status);
                }
                return message;
            };

            /**
             * Creates a plain object from a TraceProcessorRpc message. Also converts values to other types if specified.
             * @function toObject
             * @memberof perfetto.protos.TraceProcessorRpc
             * @static
             * @param {perfetto.protos.TraceProcessorRpc} message TraceProcessorRpc
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            TraceProcessorRpc.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    if ($util.Long) {
                        var long = new $util.Long(0, 0, false);
                        object.seq = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                    } else
                        object.seq = options.longs === String ? "0" : 0;
                    object.fatalError = "";
                }
                if (message.seq != null && message.hasOwnProperty("seq"))
                    if (typeof message.seq === "number")
                        object.seq = options.longs === String ? String(message.seq) : message.seq;
                    else
                        object.seq = options.longs === String ? $util.Long.prototype.toString.call(message.seq) : options.longs === Number ? new $util.LongBits(message.seq.low >>> 0, message.seq.high >>> 0).toNumber() : message.seq;
                if (message.request != null && message.hasOwnProperty("request")) {
                    object.request = options.enums === String ? $root.perfetto.protos.TraceProcessorRpc.TraceProcessorMethod[message.request] : message.request;
                    if (options.oneofs)
                        object.type = "request";
                }
                if (message.response != null && message.hasOwnProperty("response")) {
                    object.response = options.enums === String ? $root.perfetto.protos.TraceProcessorRpc.TraceProcessorMethod[message.response] : message.response;
                    if (options.oneofs)
                        object.type = "response";
                }
                if (message.invalidRequest != null && message.hasOwnProperty("invalidRequest")) {
                    object.invalidRequest = options.enums === String ? $root.perfetto.protos.TraceProcessorRpc.TraceProcessorMethod[message.invalidRequest] : message.invalidRequest;
                    if (options.oneofs)
                        object.type = "invalidRequest";
                }
                if (message.fatalError != null && message.hasOwnProperty("fatalError"))
                    object.fatalError = message.fatalError;
                if (message.appendTraceData != null && message.hasOwnProperty("appendTraceData")) {
                    object.appendTraceData = options.bytes === String ? $util.base64.encode(message.appendTraceData, 0, message.appendTraceData.length) : options.bytes === Array ? Array.prototype.slice.call(message.appendTraceData) : message.appendTraceData;
                    if (options.oneofs)
                        object.args = "appendTraceData";
                }
                if (message.queryArgs != null && message.hasOwnProperty("queryArgs")) {
                    object.queryArgs = $root.perfetto.protos.QueryArgs.toObject(message.queryArgs, options);
                    if (options.oneofs)
                        object.args = "queryArgs";
                }
                if (message.computeMetricArgs != null && message.hasOwnProperty("computeMetricArgs")) {
                    object.computeMetricArgs = $root.perfetto.protos.ComputeMetricArgs.toObject(message.computeMetricArgs, options);
                    if (options.oneofs)
                        object.args = "computeMetricArgs";
                }
                if (message.appendResult != null && message.hasOwnProperty("appendResult")) {
                    object.appendResult = $root.perfetto.protos.AppendTraceDataResult.toObject(message.appendResult, options);
                    if (options.oneofs)
                        object.args = "appendResult";
                }
                if (message.queryResult != null && message.hasOwnProperty("queryResult")) {
                    object.queryResult = $root.perfetto.protos.QueryResult.toObject(message.queryResult, options);
                    if (options.oneofs)
                        object.args = "queryResult";
                }
                if (message.metricResult != null && message.hasOwnProperty("metricResult")) {
                    object.metricResult = $root.perfetto.protos.ComputeMetricResult.toObject(message.metricResult, options);
                    if (options.oneofs)
                        object.args = "metricResult";
                }
                if (message.metricDescriptors != null && message.hasOwnProperty("metricDescriptors")) {
                    object.metricDescriptors = $root.perfetto.protos.DescriptorSet.toObject(message.metricDescriptors, options);
                    if (options.oneofs)
                        object.args = "metricDescriptors";
                }
                if (message.metatrace != null && message.hasOwnProperty("metatrace")) {
                    object.metatrace = $root.perfetto.protos.DisableAndReadMetatraceResult.toObject(message.metatrace, options);
                    if (options.oneofs)
                        object.args = "metatrace";
                }
                if (message.status != null && message.hasOwnProperty("status")) {
                    object.status = $root.perfetto.protos.StatusResult.toObject(message.status, options);
                    if (options.oneofs)
                        object.args = "status";
                }
                return object;
            };

            /**
             * Converts this TraceProcessorRpc to JSON.
             * @function toJSON
             * @memberof perfetto.protos.TraceProcessorRpc
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            TraceProcessorRpc.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, minimal$1.util.toJSONOptions);
            };

            /**
             * TraceProcessorMethod enum.
             * @name perfetto.protos.TraceProcessorRpc.TraceProcessorMethod
             * @enum {number}
             * @property {number} TPM_UNSPECIFIED=0 TPM_UNSPECIFIED value
             * @property {number} TPM_APPEND_TRACE_DATA=1 TPM_APPEND_TRACE_DATA value
             * @property {number} TPM_FINALIZE_TRACE_DATA=2 TPM_FINALIZE_TRACE_DATA value
             * @property {number} TPM_QUERY_STREAMING=3 TPM_QUERY_STREAMING value
             * @property {number} TPM_COMPUTE_METRIC=5 TPM_COMPUTE_METRIC value
             * @property {number} TPM_GET_METRIC_DESCRIPTORS=6 TPM_GET_METRIC_DESCRIPTORS value
             * @property {number} TPM_RESTORE_INITIAL_TABLES=7 TPM_RESTORE_INITIAL_TABLES value
             * @property {number} TPM_ENABLE_METATRACE=8 TPM_ENABLE_METATRACE value
             * @property {number} TPM_DISABLE_AND_READ_METATRACE=9 TPM_DISABLE_AND_READ_METATRACE value
             * @property {number} TPM_GET_STATUS=10 TPM_GET_STATUS value
             */
            TraceProcessorRpc.TraceProcessorMethod = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "TPM_UNSPECIFIED"] = 0;
                values[valuesById[1] = "TPM_APPEND_TRACE_DATA"] = 1;
                values[valuesById[2] = "TPM_FINALIZE_TRACE_DATA"] = 2;
                values[valuesById[3] = "TPM_QUERY_STREAMING"] = 3;
                values[valuesById[5] = "TPM_COMPUTE_METRIC"] = 5;
                values[valuesById[6] = "TPM_GET_METRIC_DESCRIPTORS"] = 6;
                values[valuesById[7] = "TPM_RESTORE_INITIAL_TABLES"] = 7;
                values[valuesById[8] = "TPM_ENABLE_METATRACE"] = 8;
                values[valuesById[9] = "TPM_DISABLE_AND_READ_METATRACE"] = 9;
                values[valuesById[10] = "TPM_GET_STATUS"] = 10;
                return values;
            })();

            return TraceProcessorRpc;
        })();

        protos.AppendTraceDataResult = (function() {

            /**
             * Properties of an AppendTraceDataResult.
             * @memberof perfetto.protos
             * @interface IAppendTraceDataResult
             * @property {number|null} [totalBytesParsed] AppendTraceDataResult totalBytesParsed
             * @property {string|null} [error] AppendTraceDataResult error
             */

            /**
             * Constructs a new AppendTraceDataResult.
             * @memberof perfetto.protos
             * @classdesc Represents an AppendTraceDataResult.
             * @implements IAppendTraceDataResult
             * @constructor
             * @param {perfetto.protos.IAppendTraceDataResult=} [properties] Properties to set
             */
            function AppendTraceDataResult(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AppendTraceDataResult totalBytesParsed.
             * @member {number} totalBytesParsed
             * @memberof perfetto.protos.AppendTraceDataResult
             * @instance
             */
            AppendTraceDataResult.prototype.totalBytesParsed = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            /**
             * AppendTraceDataResult error.
             * @member {string} error
             * @memberof perfetto.protos.AppendTraceDataResult
             * @instance
             */
            AppendTraceDataResult.prototype.error = "";

            /**
             * Creates a new AppendTraceDataResult instance using the specified properties.
             * @function create
             * @memberof perfetto.protos.AppendTraceDataResult
             * @static
             * @param {perfetto.protos.IAppendTraceDataResult=} [properties] Properties to set
             * @returns {perfetto.protos.AppendTraceDataResult} AppendTraceDataResult instance
             */
            AppendTraceDataResult.create = function create(properties) {
                return new AppendTraceDataResult(properties);
            };

            /**
             * Encodes the specified AppendTraceDataResult message. Does not implicitly {@link perfetto.protos.AppendTraceDataResult.verify|verify} messages.
             * @function encode
             * @memberof perfetto.protos.AppendTraceDataResult
             * @static
             * @param {perfetto.protos.IAppendTraceDataResult} message AppendTraceDataResult message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AppendTraceDataResult.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.totalBytesParsed != null && Object.hasOwnProperty.call(message, "totalBytesParsed"))
                    writer.uint32(/* id 1, wireType 0 =*/8).int64(message.totalBytesParsed);
                if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.error);
                return writer;
            };

            /**
             * Encodes the specified AppendTraceDataResult message, length delimited. Does not implicitly {@link perfetto.protos.AppendTraceDataResult.verify|verify} messages.
             * @function encodeDelimited
             * @memberof perfetto.protos.AppendTraceDataResult
             * @static
             * @param {perfetto.protos.IAppendTraceDataResult} message AppendTraceDataResult message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AppendTraceDataResult.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an AppendTraceDataResult message from the specified reader or buffer.
             * @function decode
             * @memberof perfetto.protos.AppendTraceDataResult
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {perfetto.protos.AppendTraceDataResult} AppendTraceDataResult
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AppendTraceDataResult.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.perfetto.protos.AppendTraceDataResult();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.totalBytesParsed = reader.int64();
                        break;
                    case 2:
                        message.error = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an AppendTraceDataResult message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof perfetto.protos.AppendTraceDataResult
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {perfetto.protos.AppendTraceDataResult} AppendTraceDataResult
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AppendTraceDataResult.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an AppendTraceDataResult message.
             * @function verify
             * @memberof perfetto.protos.AppendTraceDataResult
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AppendTraceDataResult.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.totalBytesParsed != null && message.hasOwnProperty("totalBytesParsed"))
                    if (!$util.isInteger(message.totalBytesParsed) && !(message.totalBytesParsed && $util.isInteger(message.totalBytesParsed.low) && $util.isInteger(message.totalBytesParsed.high)))
                        return "totalBytesParsed: integer|Long expected";
                if (message.error != null && message.hasOwnProperty("error"))
                    if (!$util.isString(message.error))
                        return "error: string expected";
                return null;
            };

            /**
             * Creates an AppendTraceDataResult message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof perfetto.protos.AppendTraceDataResult
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {perfetto.protos.AppendTraceDataResult} AppendTraceDataResult
             */
            AppendTraceDataResult.fromObject = function fromObject(object) {
                if (object instanceof $root.perfetto.protos.AppendTraceDataResult)
                    return object;
                var message = new $root.perfetto.protos.AppendTraceDataResult();
                if (object.totalBytesParsed != null)
                    if ($util.Long)
                        (message.totalBytesParsed = $util.Long.fromValue(object.totalBytesParsed)).unsigned = false;
                    else if (typeof object.totalBytesParsed === "string")
                        message.totalBytesParsed = parseInt(object.totalBytesParsed, 10);
                    else if (typeof object.totalBytesParsed === "number")
                        message.totalBytesParsed = object.totalBytesParsed;
                    else if (typeof object.totalBytesParsed === "object")
                        message.totalBytesParsed = new $util.LongBits(object.totalBytesParsed.low >>> 0, object.totalBytesParsed.high >>> 0).toNumber();
                if (object.error != null)
                    message.error = String(object.error);
                return message;
            };

            /**
             * Creates a plain object from an AppendTraceDataResult message. Also converts values to other types if specified.
             * @function toObject
             * @memberof perfetto.protos.AppendTraceDataResult
             * @static
             * @param {perfetto.protos.AppendTraceDataResult} message AppendTraceDataResult
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AppendTraceDataResult.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    if ($util.Long) {
                        var long = new $util.Long(0, 0, false);
                        object.totalBytesParsed = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                    } else
                        object.totalBytesParsed = options.longs === String ? "0" : 0;
                    object.error = "";
                }
                if (message.totalBytesParsed != null && message.hasOwnProperty("totalBytesParsed"))
                    if (typeof message.totalBytesParsed === "number")
                        object.totalBytesParsed = options.longs === String ? String(message.totalBytesParsed) : message.totalBytesParsed;
                    else
                        object.totalBytesParsed = options.longs === String ? $util.Long.prototype.toString.call(message.totalBytesParsed) : options.longs === Number ? new $util.LongBits(message.totalBytesParsed.low >>> 0, message.totalBytesParsed.high >>> 0).toNumber() : message.totalBytesParsed;
                if (message.error != null && message.hasOwnProperty("error"))
                    object.error = message.error;
                return object;
            };

            /**
             * Converts this AppendTraceDataResult to JSON.
             * @function toJSON
             * @memberof perfetto.protos.AppendTraceDataResult
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AppendTraceDataResult.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, minimal$1.util.toJSONOptions);
            };

            return AppendTraceDataResult;
        })();

        protos.QueryArgs = (function() {

            /**
             * Properties of a QueryArgs.
             * @memberof perfetto.protos
             * @interface IQueryArgs
             * @property {string|null} [sqlQuery] QueryArgs sqlQuery
             */

            /**
             * Constructs a new QueryArgs.
             * @memberof perfetto.protos
             * @classdesc Represents a QueryArgs.
             * @implements IQueryArgs
             * @constructor
             * @param {perfetto.protos.IQueryArgs=} [properties] Properties to set
             */
            function QueryArgs(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * QueryArgs sqlQuery.
             * @member {string} sqlQuery
             * @memberof perfetto.protos.QueryArgs
             * @instance
             */
            QueryArgs.prototype.sqlQuery = "";

            /**
             * Creates a new QueryArgs instance using the specified properties.
             * @function create
             * @memberof perfetto.protos.QueryArgs
             * @static
             * @param {perfetto.protos.IQueryArgs=} [properties] Properties to set
             * @returns {perfetto.protos.QueryArgs} QueryArgs instance
             */
            QueryArgs.create = function create(properties) {
                return new QueryArgs(properties);
            };

            /**
             * Encodes the specified QueryArgs message. Does not implicitly {@link perfetto.protos.QueryArgs.verify|verify} messages.
             * @function encode
             * @memberof perfetto.protos.QueryArgs
             * @static
             * @param {perfetto.protos.IQueryArgs} message QueryArgs message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            QueryArgs.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.sqlQuery != null && Object.hasOwnProperty.call(message, "sqlQuery"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.sqlQuery);
                return writer;
            };

            /**
             * Encodes the specified QueryArgs message, length delimited. Does not implicitly {@link perfetto.protos.QueryArgs.verify|verify} messages.
             * @function encodeDelimited
             * @memberof perfetto.protos.QueryArgs
             * @static
             * @param {perfetto.protos.IQueryArgs} message QueryArgs message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            QueryArgs.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a QueryArgs message from the specified reader or buffer.
             * @function decode
             * @memberof perfetto.protos.QueryArgs
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {perfetto.protos.QueryArgs} QueryArgs
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            QueryArgs.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.perfetto.protos.QueryArgs();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.sqlQuery = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a QueryArgs message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof perfetto.protos.QueryArgs
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {perfetto.protos.QueryArgs} QueryArgs
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            QueryArgs.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a QueryArgs message.
             * @function verify
             * @memberof perfetto.protos.QueryArgs
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            QueryArgs.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.sqlQuery != null && message.hasOwnProperty("sqlQuery"))
                    if (!$util.isString(message.sqlQuery))
                        return "sqlQuery: string expected";
                return null;
            };

            /**
             * Creates a QueryArgs message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof perfetto.protos.QueryArgs
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {perfetto.protos.QueryArgs} QueryArgs
             */
            QueryArgs.fromObject = function fromObject(object) {
                if (object instanceof $root.perfetto.protos.QueryArgs)
                    return object;
                var message = new $root.perfetto.protos.QueryArgs();
                if (object.sqlQuery != null)
                    message.sqlQuery = String(object.sqlQuery);
                return message;
            };

            /**
             * Creates a plain object from a QueryArgs message. Also converts values to other types if specified.
             * @function toObject
             * @memberof perfetto.protos.QueryArgs
             * @static
             * @param {perfetto.protos.QueryArgs} message QueryArgs
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            QueryArgs.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults)
                    object.sqlQuery = "";
                if (message.sqlQuery != null && message.hasOwnProperty("sqlQuery"))
                    object.sqlQuery = message.sqlQuery;
                return object;
            };

            /**
             * Converts this QueryArgs to JSON.
             * @function toJSON
             * @memberof perfetto.protos.QueryArgs
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            QueryArgs.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, minimal$1.util.toJSONOptions);
            };

            return QueryArgs;
        })();

        protos.QueryResult = (function() {

            /**
             * Properties of a QueryResult.
             * @memberof perfetto.protos
             * @interface IQueryResult
             * @property {Array.<string>|null} [columnNames] QueryResult columnNames
             * @property {string|null} [error] QueryResult error
             * @property {Array.<perfetto.protos.QueryResult.ICellsBatch>|null} [batch] QueryResult batch
             * @property {number|null} [statementCount] QueryResult statementCount
             * @property {number|null} [statementWithOutputCount] QueryResult statementWithOutputCount
             */

            /**
             * Constructs a new QueryResult.
             * @memberof perfetto.protos
             * @classdesc Represents a QueryResult.
             * @implements IQueryResult
             * @constructor
             * @param {perfetto.protos.IQueryResult=} [properties] Properties to set
             */
            function QueryResult(properties) {
                this.columnNames = [];
                this.batch = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * QueryResult columnNames.
             * @member {Array.<string>} columnNames
             * @memberof perfetto.protos.QueryResult
             * @instance
             */
            QueryResult.prototype.columnNames = $util.emptyArray;

            /**
             * QueryResult error.
             * @member {string} error
             * @memberof perfetto.protos.QueryResult
             * @instance
             */
            QueryResult.prototype.error = "";

            /**
             * QueryResult batch.
             * @member {Array.<perfetto.protos.QueryResult.ICellsBatch>} batch
             * @memberof perfetto.protos.QueryResult
             * @instance
             */
            QueryResult.prototype.batch = $util.emptyArray;

            /**
             * QueryResult statementCount.
             * @member {number} statementCount
             * @memberof perfetto.protos.QueryResult
             * @instance
             */
            QueryResult.prototype.statementCount = 0;

            /**
             * QueryResult statementWithOutputCount.
             * @member {number} statementWithOutputCount
             * @memberof perfetto.protos.QueryResult
             * @instance
             */
            QueryResult.prototype.statementWithOutputCount = 0;

            /**
             * Creates a new QueryResult instance using the specified properties.
             * @function create
             * @memberof perfetto.protos.QueryResult
             * @static
             * @param {perfetto.protos.IQueryResult=} [properties] Properties to set
             * @returns {perfetto.protos.QueryResult} QueryResult instance
             */
            QueryResult.create = function create(properties) {
                return new QueryResult(properties);
            };

            /**
             * Encodes the specified QueryResult message. Does not implicitly {@link perfetto.protos.QueryResult.verify|verify} messages.
             * @function encode
             * @memberof perfetto.protos.QueryResult
             * @static
             * @param {perfetto.protos.IQueryResult} message QueryResult message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            QueryResult.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.columnNames != null && message.columnNames.length)
                    for (var i = 0; i < message.columnNames.length; ++i)
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.columnNames[i]);
                if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.error);
                if (message.batch != null && message.batch.length)
                    for (var i = 0; i < message.batch.length; ++i)
                        $root.perfetto.protos.QueryResult.CellsBatch.encode(message.batch[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                if (message.statementCount != null && Object.hasOwnProperty.call(message, "statementCount"))
                    writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.statementCount);
                if (message.statementWithOutputCount != null && Object.hasOwnProperty.call(message, "statementWithOutputCount"))
                    writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.statementWithOutputCount);
                return writer;
            };

            /**
             * Encodes the specified QueryResult message, length delimited. Does not implicitly {@link perfetto.protos.QueryResult.verify|verify} messages.
             * @function encodeDelimited
             * @memberof perfetto.protos.QueryResult
             * @static
             * @param {perfetto.protos.IQueryResult} message QueryResult message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            QueryResult.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a QueryResult message from the specified reader or buffer.
             * @function decode
             * @memberof perfetto.protos.QueryResult
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {perfetto.protos.QueryResult} QueryResult
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            QueryResult.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.perfetto.protos.QueryResult();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        if (!(message.columnNames && message.columnNames.length))
                            message.columnNames = [];
                        message.columnNames.push(reader.string());
                        break;
                    case 2:
                        message.error = reader.string();
                        break;
                    case 3:
                        if (!(message.batch && message.batch.length))
                            message.batch = [];
                        message.batch.push($root.perfetto.protos.QueryResult.CellsBatch.decode(reader, reader.uint32()));
                        break;
                    case 4:
                        message.statementCount = reader.uint32();
                        break;
                    case 5:
                        message.statementWithOutputCount = reader.uint32();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a QueryResult message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof perfetto.protos.QueryResult
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {perfetto.protos.QueryResult} QueryResult
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            QueryResult.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a QueryResult message.
             * @function verify
             * @memberof perfetto.protos.QueryResult
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            QueryResult.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.columnNames != null && message.hasOwnProperty("columnNames")) {
                    if (!Array.isArray(message.columnNames))
                        return "columnNames: array expected";
                    for (var i = 0; i < message.columnNames.length; ++i)
                        if (!$util.isString(message.columnNames[i]))
                            return "columnNames: string[] expected";
                }
                if (message.error != null && message.hasOwnProperty("error"))
                    if (!$util.isString(message.error))
                        return "error: string expected";
                if (message.batch != null && message.hasOwnProperty("batch")) {
                    if (!Array.isArray(message.batch))
                        return "batch: array expected";
                    for (var i = 0; i < message.batch.length; ++i) {
                        var error = $root.perfetto.protos.QueryResult.CellsBatch.verify(message.batch[i]);
                        if (error)
                            return "batch." + error;
                    }
                }
                if (message.statementCount != null && message.hasOwnProperty("statementCount"))
                    if (!$util.isInteger(message.statementCount))
                        return "statementCount: integer expected";
                if (message.statementWithOutputCount != null && message.hasOwnProperty("statementWithOutputCount"))
                    if (!$util.isInteger(message.statementWithOutputCount))
                        return "statementWithOutputCount: integer expected";
                return null;
            };

            /**
             * Creates a QueryResult message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof perfetto.protos.QueryResult
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {perfetto.protos.QueryResult} QueryResult
             */
            QueryResult.fromObject = function fromObject(object) {
                if (object instanceof $root.perfetto.protos.QueryResult)
                    return object;
                var message = new $root.perfetto.protos.QueryResult();
                if (object.columnNames) {
                    if (!Array.isArray(object.columnNames))
                        throw TypeError(".perfetto.protos.QueryResult.columnNames: array expected");
                    message.columnNames = [];
                    for (var i = 0; i < object.columnNames.length; ++i)
                        message.columnNames[i] = String(object.columnNames[i]);
                }
                if (object.error != null)
                    message.error = String(object.error);
                if (object.batch) {
                    if (!Array.isArray(object.batch))
                        throw TypeError(".perfetto.protos.QueryResult.batch: array expected");
                    message.batch = [];
                    for (var i = 0; i < object.batch.length; ++i) {
                        if (typeof object.batch[i] !== "object")
                            throw TypeError(".perfetto.protos.QueryResult.batch: object expected");
                        message.batch[i] = $root.perfetto.protos.QueryResult.CellsBatch.fromObject(object.batch[i]);
                    }
                }
                if (object.statementCount != null)
                    message.statementCount = object.statementCount >>> 0;
                if (object.statementWithOutputCount != null)
                    message.statementWithOutputCount = object.statementWithOutputCount >>> 0;
                return message;
            };

            /**
             * Creates a plain object from a QueryResult message. Also converts values to other types if specified.
             * @function toObject
             * @memberof perfetto.protos.QueryResult
             * @static
             * @param {perfetto.protos.QueryResult} message QueryResult
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            QueryResult.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults) {
                    object.columnNames = [];
                    object.batch = [];
                }
                if (options.defaults) {
                    object.error = "";
                    object.statementCount = 0;
                    object.statementWithOutputCount = 0;
                }
                if (message.columnNames && message.columnNames.length) {
                    object.columnNames = [];
                    for (var j = 0; j < message.columnNames.length; ++j)
                        object.columnNames[j] = message.columnNames[j];
                }
                if (message.error != null && message.hasOwnProperty("error"))
                    object.error = message.error;
                if (message.batch && message.batch.length) {
                    object.batch = [];
                    for (var j = 0; j < message.batch.length; ++j)
                        object.batch[j] = $root.perfetto.protos.QueryResult.CellsBatch.toObject(message.batch[j], options);
                }
                if (message.statementCount != null && message.hasOwnProperty("statementCount"))
                    object.statementCount = message.statementCount;
                if (message.statementWithOutputCount != null && message.hasOwnProperty("statementWithOutputCount"))
                    object.statementWithOutputCount = message.statementWithOutputCount;
                return object;
            };

            /**
             * Converts this QueryResult to JSON.
             * @function toJSON
             * @memberof perfetto.protos.QueryResult
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            QueryResult.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, minimal$1.util.toJSONOptions);
            };

            QueryResult.CellsBatch = (function() {

                /**
                 * Properties of a CellsBatch.
                 * @memberof perfetto.protos.QueryResult
                 * @interface ICellsBatch
                 * @property {Array.<perfetto.protos.QueryResult.CellsBatch.CellType>|null} [cells] CellsBatch cells
                 * @property {Array.<number>|null} [varintCells] CellsBatch varintCells
                 * @property {Array.<number>|null} [float64Cells] CellsBatch float64Cells
                 * @property {Array.<Uint8Array>|null} [blobCells] CellsBatch blobCells
                 * @property {string|null} [stringCells] CellsBatch stringCells
                 * @property {boolean|null} [isLastBatch] CellsBatch isLastBatch
                 */

                /**
                 * Constructs a new CellsBatch.
                 * @memberof perfetto.protos.QueryResult
                 * @classdesc Represents a CellsBatch.
                 * @implements ICellsBatch
                 * @constructor
                 * @param {perfetto.protos.QueryResult.ICellsBatch=} [properties] Properties to set
                 */
                function CellsBatch(properties) {
                    this.cells = [];
                    this.varintCells = [];
                    this.float64Cells = [];
                    this.blobCells = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * CellsBatch cells.
                 * @member {Array.<perfetto.protos.QueryResult.CellsBatch.CellType>} cells
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @instance
                 */
                CellsBatch.prototype.cells = $util.emptyArray;

                /**
                 * CellsBatch varintCells.
                 * @member {Array.<number>} varintCells
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @instance
                 */
                CellsBatch.prototype.varintCells = $util.emptyArray;

                /**
                 * CellsBatch float64Cells.
                 * @member {Array.<number>} float64Cells
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @instance
                 */
                CellsBatch.prototype.float64Cells = $util.emptyArray;

                /**
                 * CellsBatch blobCells.
                 * @member {Array.<Uint8Array>} blobCells
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @instance
                 */
                CellsBatch.prototype.blobCells = $util.emptyArray;

                /**
                 * CellsBatch stringCells.
                 * @member {string} stringCells
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @instance
                 */
                CellsBatch.prototype.stringCells = "";

                /**
                 * CellsBatch isLastBatch.
                 * @member {boolean} isLastBatch
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @instance
                 */
                CellsBatch.prototype.isLastBatch = false;

                /**
                 * Creates a new CellsBatch instance using the specified properties.
                 * @function create
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @static
                 * @param {perfetto.protos.QueryResult.ICellsBatch=} [properties] Properties to set
                 * @returns {perfetto.protos.QueryResult.CellsBatch} CellsBatch instance
                 */
                CellsBatch.create = function create(properties) {
                    return new CellsBatch(properties);
                };

                /**
                 * Encodes the specified CellsBatch message. Does not implicitly {@link perfetto.protos.QueryResult.CellsBatch.verify|verify} messages.
                 * @function encode
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @static
                 * @param {perfetto.protos.QueryResult.ICellsBatch} message CellsBatch message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CellsBatch.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.cells != null && message.cells.length) {
                        writer.uint32(/* id 1, wireType 2 =*/10).fork();
                        for (var i = 0; i < message.cells.length; ++i)
                            writer.int32(message.cells[i]);
                        writer.ldelim();
                    }
                    if (message.varintCells != null && message.varintCells.length) {
                        writer.uint32(/* id 2, wireType 2 =*/18).fork();
                        for (var i = 0; i < message.varintCells.length; ++i)
                            writer.int64(message.varintCells[i]);
                        writer.ldelim();
                    }
                    if (message.float64Cells != null && message.float64Cells.length) {
                        writer.uint32(/* id 3, wireType 2 =*/26).fork();
                        for (var i = 0; i < message.float64Cells.length; ++i)
                            writer.double(message.float64Cells[i]);
                        writer.ldelim();
                    }
                    if (message.blobCells != null && message.blobCells.length)
                        for (var i = 0; i < message.blobCells.length; ++i)
                            writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.blobCells[i]);
                    if (message.stringCells != null && Object.hasOwnProperty.call(message, "stringCells"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.stringCells);
                    if (message.isLastBatch != null && Object.hasOwnProperty.call(message, "isLastBatch"))
                        writer.uint32(/* id 6, wireType 0 =*/48).bool(message.isLastBatch);
                    return writer;
                };

                /**
                 * Encodes the specified CellsBatch message, length delimited. Does not implicitly {@link perfetto.protos.QueryResult.CellsBatch.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @static
                 * @param {perfetto.protos.QueryResult.ICellsBatch} message CellsBatch message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CellsBatch.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a CellsBatch message from the specified reader or buffer.
                 * @function decode
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {perfetto.protos.QueryResult.CellsBatch} CellsBatch
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CellsBatch.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.perfetto.protos.QueryResult.CellsBatch();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.cells && message.cells.length))
                                message.cells = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.cells.push(reader.int32());
                            } else
                                message.cells.push(reader.int32());
                            break;
                        case 2:
                            if (!(message.varintCells && message.varintCells.length))
                                message.varintCells = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.varintCells.push(reader.int64());
                            } else
                                message.varintCells.push(reader.int64());
                            break;
                        case 3:
                            if (!(message.float64Cells && message.float64Cells.length))
                                message.float64Cells = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.float64Cells.push(reader.double());
                            } else
                                message.float64Cells.push(reader.double());
                            break;
                        case 4:
                            if (!(message.blobCells && message.blobCells.length))
                                message.blobCells = [];
                            message.blobCells.push(reader.bytes());
                            break;
                        case 5:
                            message.stringCells = reader.string();
                            break;
                        case 6:
                            message.isLastBatch = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a CellsBatch message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {perfetto.protos.QueryResult.CellsBatch} CellsBatch
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CellsBatch.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a CellsBatch message.
                 * @function verify
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CellsBatch.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.cells != null && message.hasOwnProperty("cells")) {
                        if (!Array.isArray(message.cells))
                            return "cells: array expected";
                        for (var i = 0; i < message.cells.length; ++i)
                            switch (message.cells[i]) {
                            default:
                                return "cells: enum value[] expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                            case 5:
                                break;
                            }
                    }
                    if (message.varintCells != null && message.hasOwnProperty("varintCells")) {
                        if (!Array.isArray(message.varintCells))
                            return "varintCells: array expected";
                        for (var i = 0; i < message.varintCells.length; ++i)
                            if (!$util.isInteger(message.varintCells[i]) && !(message.varintCells[i] && $util.isInteger(message.varintCells[i].low) && $util.isInteger(message.varintCells[i].high)))
                                return "varintCells: integer|Long[] expected";
                    }
                    if (message.float64Cells != null && message.hasOwnProperty("float64Cells")) {
                        if (!Array.isArray(message.float64Cells))
                            return "float64Cells: array expected";
                        for (var i = 0; i < message.float64Cells.length; ++i)
                            if (typeof message.float64Cells[i] !== "number")
                                return "float64Cells: number[] expected";
                    }
                    if (message.blobCells != null && message.hasOwnProperty("blobCells")) {
                        if (!Array.isArray(message.blobCells))
                            return "blobCells: array expected";
                        for (var i = 0; i < message.blobCells.length; ++i)
                            if (!(message.blobCells[i] && typeof message.blobCells[i].length === "number" || $util.isString(message.blobCells[i])))
                                return "blobCells: buffer[] expected";
                    }
                    if (message.stringCells != null && message.hasOwnProperty("stringCells"))
                        if (!$util.isString(message.stringCells))
                            return "stringCells: string expected";
                    if (message.isLastBatch != null && message.hasOwnProperty("isLastBatch"))
                        if (typeof message.isLastBatch !== "boolean")
                            return "isLastBatch: boolean expected";
                    return null;
                };

                /**
                 * Creates a CellsBatch message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {perfetto.protos.QueryResult.CellsBatch} CellsBatch
                 */
                CellsBatch.fromObject = function fromObject(object) {
                    if (object instanceof $root.perfetto.protos.QueryResult.CellsBatch)
                        return object;
                    var message = new $root.perfetto.protos.QueryResult.CellsBatch();
                    if (object.cells) {
                        if (!Array.isArray(object.cells))
                            throw TypeError(".perfetto.protos.QueryResult.CellsBatch.cells: array expected");
                        message.cells = [];
                        for (var i = 0; i < object.cells.length; ++i)
                            switch (object.cells[i]) {
                            default:
                            case "CELL_INVALID":
                            case 0:
                                message.cells[i] = 0;
                                break;
                            case "CELL_NULL":
                            case 1:
                                message.cells[i] = 1;
                                break;
                            case "CELL_VARINT":
                            case 2:
                                message.cells[i] = 2;
                                break;
                            case "CELL_FLOAT64":
                            case 3:
                                message.cells[i] = 3;
                                break;
                            case "CELL_STRING":
                            case 4:
                                message.cells[i] = 4;
                                break;
                            case "CELL_BLOB":
                            case 5:
                                message.cells[i] = 5;
                                break;
                            }
                    }
                    if (object.varintCells) {
                        if (!Array.isArray(object.varintCells))
                            throw TypeError(".perfetto.protos.QueryResult.CellsBatch.varintCells: array expected");
                        message.varintCells = [];
                        for (var i = 0; i < object.varintCells.length; ++i)
                            if ($util.Long)
                                (message.varintCells[i] = $util.Long.fromValue(object.varintCells[i])).unsigned = false;
                            else if (typeof object.varintCells[i] === "string")
                                message.varintCells[i] = parseInt(object.varintCells[i], 10);
                            else if (typeof object.varintCells[i] === "number")
                                message.varintCells[i] = object.varintCells[i];
                            else if (typeof object.varintCells[i] === "object")
                                message.varintCells[i] = new $util.LongBits(object.varintCells[i].low >>> 0, object.varintCells[i].high >>> 0).toNumber();
                    }
                    if (object.float64Cells) {
                        if (!Array.isArray(object.float64Cells))
                            throw TypeError(".perfetto.protos.QueryResult.CellsBatch.float64Cells: array expected");
                        message.float64Cells = [];
                        for (var i = 0; i < object.float64Cells.length; ++i)
                            message.float64Cells[i] = Number(object.float64Cells[i]);
                    }
                    if (object.blobCells) {
                        if (!Array.isArray(object.blobCells))
                            throw TypeError(".perfetto.protos.QueryResult.CellsBatch.blobCells: array expected");
                        message.blobCells = [];
                        for (var i = 0; i < object.blobCells.length; ++i)
                            if (typeof object.blobCells[i] === "string")
                                $util.base64.decode(object.blobCells[i], message.blobCells[i] = $util.newBuffer($util.base64.length(object.blobCells[i])), 0);
                            else if (object.blobCells[i].length)
                                message.blobCells[i] = object.blobCells[i];
                    }
                    if (object.stringCells != null)
                        message.stringCells = String(object.stringCells);
                    if (object.isLastBatch != null)
                        message.isLastBatch = Boolean(object.isLastBatch);
                    return message;
                };

                /**
                 * Creates a plain object from a CellsBatch message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @static
                 * @param {perfetto.protos.QueryResult.CellsBatch} message CellsBatch
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                CellsBatch.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults) {
                        object.cells = [];
                        object.varintCells = [];
                        object.float64Cells = [];
                        object.blobCells = [];
                    }
                    if (options.defaults) {
                        object.stringCells = "";
                        object.isLastBatch = false;
                    }
                    if (message.cells && message.cells.length) {
                        object.cells = [];
                        for (var j = 0; j < message.cells.length; ++j)
                            object.cells[j] = options.enums === String ? $root.perfetto.protos.QueryResult.CellsBatch.CellType[message.cells[j]] : message.cells[j];
                    }
                    if (message.varintCells && message.varintCells.length) {
                        object.varintCells = [];
                        for (var j = 0; j < message.varintCells.length; ++j)
                            if (typeof message.varintCells[j] === "number")
                                object.varintCells[j] = options.longs === String ? String(message.varintCells[j]) : message.varintCells[j];
                            else
                                object.varintCells[j] = options.longs === String ? $util.Long.prototype.toString.call(message.varintCells[j]) : options.longs === Number ? new $util.LongBits(message.varintCells[j].low >>> 0, message.varintCells[j].high >>> 0).toNumber() : message.varintCells[j];
                    }
                    if (message.float64Cells && message.float64Cells.length) {
                        object.float64Cells = [];
                        for (var j = 0; j < message.float64Cells.length; ++j)
                            object.float64Cells[j] = options.json && !isFinite(message.float64Cells[j]) ? String(message.float64Cells[j]) : message.float64Cells[j];
                    }
                    if (message.blobCells && message.blobCells.length) {
                        object.blobCells = [];
                        for (var j = 0; j < message.blobCells.length; ++j)
                            object.blobCells[j] = options.bytes === String ? $util.base64.encode(message.blobCells[j], 0, message.blobCells[j].length) : options.bytes === Array ? Array.prototype.slice.call(message.blobCells[j]) : message.blobCells[j];
                    }
                    if (message.stringCells != null && message.hasOwnProperty("stringCells"))
                        object.stringCells = message.stringCells;
                    if (message.isLastBatch != null && message.hasOwnProperty("isLastBatch"))
                        object.isLastBatch = message.isLastBatch;
                    return object;
                };

                /**
                 * Converts this CellsBatch to JSON.
                 * @function toJSON
                 * @memberof perfetto.protos.QueryResult.CellsBatch
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                CellsBatch.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, minimal$1.util.toJSONOptions);
                };

                /**
                 * CellType enum.
                 * @name perfetto.protos.QueryResult.CellsBatch.CellType
                 * @enum {number}
                 * @property {number} CELL_INVALID=0 CELL_INVALID value
                 * @property {number} CELL_NULL=1 CELL_NULL value
                 * @property {number} CELL_VARINT=2 CELL_VARINT value
                 * @property {number} CELL_FLOAT64=3 CELL_FLOAT64 value
                 * @property {number} CELL_STRING=4 CELL_STRING value
                 * @property {number} CELL_BLOB=5 CELL_BLOB value
                 */
                CellsBatch.CellType = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "CELL_INVALID"] = 0;
                    values[valuesById[1] = "CELL_NULL"] = 1;
                    values[valuesById[2] = "CELL_VARINT"] = 2;
                    values[valuesById[3] = "CELL_FLOAT64"] = 3;
                    values[valuesById[4] = "CELL_STRING"] = 4;
                    values[valuesById[5] = "CELL_BLOB"] = 5;
                    return values;
                })();

                return CellsBatch;
            })();

            return QueryResult;
        })();

        protos.StatusArgs = (function() {

            /**
             * Properties of a StatusArgs.
             * @memberof perfetto.protos
             * @interface IStatusArgs
             */

            /**
             * Constructs a new StatusArgs.
             * @memberof perfetto.protos
             * @classdesc Represents a StatusArgs.
             * @implements IStatusArgs
             * @constructor
             * @param {perfetto.protos.IStatusArgs=} [properties] Properties to set
             */
            function StatusArgs(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * Creates a new StatusArgs instance using the specified properties.
             * @function create
             * @memberof perfetto.protos.StatusArgs
             * @static
             * @param {perfetto.protos.IStatusArgs=} [properties] Properties to set
             * @returns {perfetto.protos.StatusArgs} StatusArgs instance
             */
            StatusArgs.create = function create(properties) {
                return new StatusArgs(properties);
            };

            /**
             * Encodes the specified StatusArgs message. Does not implicitly {@link perfetto.protos.StatusArgs.verify|verify} messages.
             * @function encode
             * @memberof perfetto.protos.StatusArgs
             * @static
             * @param {perfetto.protos.IStatusArgs} message StatusArgs message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            StatusArgs.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                return writer;
            };

            /**
             * Encodes the specified StatusArgs message, length delimited. Does not implicitly {@link perfetto.protos.StatusArgs.verify|verify} messages.
             * @function encodeDelimited
             * @memberof perfetto.protos.StatusArgs
             * @static
             * @param {perfetto.protos.IStatusArgs} message StatusArgs message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            StatusArgs.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a StatusArgs message from the specified reader or buffer.
             * @function decode
             * @memberof perfetto.protos.StatusArgs
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {perfetto.protos.StatusArgs} StatusArgs
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            StatusArgs.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.perfetto.protos.StatusArgs();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a StatusArgs message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof perfetto.protos.StatusArgs
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {perfetto.protos.StatusArgs} StatusArgs
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            StatusArgs.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a StatusArgs message.
             * @function verify
             * @memberof perfetto.protos.StatusArgs
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            StatusArgs.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                return null;
            };

            /**
             * Creates a StatusArgs message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof perfetto.protos.StatusArgs
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {perfetto.protos.StatusArgs} StatusArgs
             */
            StatusArgs.fromObject = function fromObject(object) {
                if (object instanceof $root.perfetto.protos.StatusArgs)
                    return object;
                return new $root.perfetto.protos.StatusArgs();
            };

            /**
             * Creates a plain object from a StatusArgs message. Also converts values to other types if specified.
             * @function toObject
             * @memberof perfetto.protos.StatusArgs
             * @static
             * @param {perfetto.protos.StatusArgs} message StatusArgs
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            StatusArgs.toObject = function toObject() {
                return {};
            };

            /**
             * Converts this StatusArgs to JSON.
             * @function toJSON
             * @memberof perfetto.protos.StatusArgs
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            StatusArgs.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, minimal$1.util.toJSONOptions);
            };

            return StatusArgs;
        })();

        protos.StatusResult = (function() {

            /**
             * Properties of a StatusResult.
             * @memberof perfetto.protos
             * @interface IStatusResult
             * @property {string|null} [loadedTraceName] StatusResult loadedTraceName
             * @property {string|null} [humanReadableVersion] StatusResult humanReadableVersion
             * @property {number|null} [apiVersion] StatusResult apiVersion
             */

            /**
             * Constructs a new StatusResult.
             * @memberof perfetto.protos
             * @classdesc Represents a StatusResult.
             * @implements IStatusResult
             * @constructor
             * @param {perfetto.protos.IStatusResult=} [properties] Properties to set
             */
            function StatusResult(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * StatusResult loadedTraceName.
             * @member {string} loadedTraceName
             * @memberof perfetto.protos.StatusResult
             * @instance
             */
            StatusResult.prototype.loadedTraceName = "";

            /**
             * StatusResult humanReadableVersion.
             * @member {string} humanReadableVersion
             * @memberof perfetto.protos.StatusResult
             * @instance
             */
            StatusResult.prototype.humanReadableVersion = "";

            /**
             * StatusResult apiVersion.
             * @member {number} apiVersion
             * @memberof perfetto.protos.StatusResult
             * @instance
             */
            StatusResult.prototype.apiVersion = 0;

            /**
             * Creates a new StatusResult instance using the specified properties.
             * @function create
             * @memberof perfetto.protos.StatusResult
             * @static
             * @param {perfetto.protos.IStatusResult=} [properties] Properties to set
             * @returns {perfetto.protos.StatusResult} StatusResult instance
             */
            StatusResult.create = function create(properties) {
                return new StatusResult(properties);
            };

            /**
             * Encodes the specified StatusResult message. Does not implicitly {@link perfetto.protos.StatusResult.verify|verify} messages.
             * @function encode
             * @memberof perfetto.protos.StatusResult
             * @static
             * @param {perfetto.protos.IStatusResult} message StatusResult message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            StatusResult.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.loadedTraceName != null && Object.hasOwnProperty.call(message, "loadedTraceName"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.loadedTraceName);
                if (message.humanReadableVersion != null && Object.hasOwnProperty.call(message, "humanReadableVersion"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.humanReadableVersion);
                if (message.apiVersion != null && Object.hasOwnProperty.call(message, "apiVersion"))
                    writer.uint32(/* id 3, wireType 0 =*/24).int32(message.apiVersion);
                return writer;
            };

            /**
             * Encodes the specified StatusResult message, length delimited. Does not implicitly {@link perfetto.protos.StatusResult.verify|verify} messages.
             * @function encodeDelimited
             * @memberof perfetto.protos.StatusResult
             * @static
             * @param {perfetto.protos.IStatusResult} message StatusResult message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            StatusResult.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a StatusResult message from the specified reader or buffer.
             * @function decode
             * @memberof perfetto.protos.StatusResult
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {perfetto.protos.StatusResult} StatusResult
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            StatusResult.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.perfetto.protos.StatusResult();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.loadedTraceName = reader.string();
                        break;
                    case 2:
                        message.humanReadableVersion = reader.string();
                        break;
                    case 3:
                        message.apiVersion = reader.int32();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a StatusResult message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof perfetto.protos.StatusResult
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {perfetto.protos.StatusResult} StatusResult
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            StatusResult.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a StatusResult message.
             * @function verify
             * @memberof perfetto.protos.StatusResult
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            StatusResult.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.loadedTraceName != null && message.hasOwnProperty("loadedTraceName"))
                    if (!$util.isString(message.loadedTraceName))
                        return "loadedTraceName: string expected";
                if (message.humanReadableVersion != null && message.hasOwnProperty("humanReadableVersion"))
                    if (!$util.isString(message.humanReadableVersion))
                        return "humanReadableVersion: string expected";
                if (message.apiVersion != null && message.hasOwnProperty("apiVersion"))
                    if (!$util.isInteger(message.apiVersion))
                        return "apiVersion: integer expected";
                return null;
            };

            /**
             * Creates a StatusResult message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof perfetto.protos.StatusResult
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {perfetto.protos.StatusResult} StatusResult
             */
            StatusResult.fromObject = function fromObject(object) {
                if (object instanceof $root.perfetto.protos.StatusResult)
                    return object;
                var message = new $root.perfetto.protos.StatusResult();
                if (object.loadedTraceName != null)
                    message.loadedTraceName = String(object.loadedTraceName);
                if (object.humanReadableVersion != null)
                    message.humanReadableVersion = String(object.humanReadableVersion);
                if (object.apiVersion != null)
                    message.apiVersion = object.apiVersion | 0;
                return message;
            };

            /**
             * Creates a plain object from a StatusResult message. Also converts values to other types if specified.
             * @function toObject
             * @memberof perfetto.protos.StatusResult
             * @static
             * @param {perfetto.protos.StatusResult} message StatusResult
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            StatusResult.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.loadedTraceName = "";
                    object.humanReadableVersion = "";
                    object.apiVersion = 0;
                }
                if (message.loadedTraceName != null && message.hasOwnProperty("loadedTraceName"))
                    object.loadedTraceName = message.loadedTraceName;
                if (message.humanReadableVersion != null && message.hasOwnProperty("humanReadableVersion"))
                    object.humanReadableVersion = message.humanReadableVersion;
                if (message.apiVersion != null && message.hasOwnProperty("apiVersion"))
                    object.apiVersion = message.apiVersion;
                return object;
            };

            /**
             * Converts this StatusResult to JSON.
             * @function toJSON
             * @memberof perfetto.protos.StatusResult
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            StatusResult.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, minimal$1.util.toJSONOptions);
            };

            return StatusResult;
        })();

        protos.ComputeMetricArgs = (function() {

            /**
             * Properties of a ComputeMetricArgs.
             * @memberof perfetto.protos
             * @interface IComputeMetricArgs
             * @property {Array.<string>|null} [metricNames] ComputeMetricArgs metricNames
             * @property {perfetto.protos.ComputeMetricArgs.ResultFormat|null} [format] ComputeMetricArgs format
             */

            /**
             * Constructs a new ComputeMetricArgs.
             * @memberof perfetto.protos
             * @classdesc Represents a ComputeMetricArgs.
             * @implements IComputeMetricArgs
             * @constructor
             * @param {perfetto.protos.IComputeMetricArgs=} [properties] Properties to set
             */
            function ComputeMetricArgs(properties) {
                this.metricNames = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * ComputeMetricArgs metricNames.
             * @member {Array.<string>} metricNames
             * @memberof perfetto.protos.ComputeMetricArgs
             * @instance
             */
            ComputeMetricArgs.prototype.metricNames = $util.emptyArray;

            /**
             * ComputeMetricArgs format.
             * @member {perfetto.protos.ComputeMetricArgs.ResultFormat} format
             * @memberof perfetto.protos.ComputeMetricArgs
             * @instance
             */
            ComputeMetricArgs.prototype.format = 0;

            /**
             * Creates a new ComputeMetricArgs instance using the specified properties.
             * @function create
             * @memberof perfetto.protos.ComputeMetricArgs
             * @static
             * @param {perfetto.protos.IComputeMetricArgs=} [properties] Properties to set
             * @returns {perfetto.protos.ComputeMetricArgs} ComputeMetricArgs instance
             */
            ComputeMetricArgs.create = function create(properties) {
                return new ComputeMetricArgs(properties);
            };

            /**
             * Encodes the specified ComputeMetricArgs message. Does not implicitly {@link perfetto.protos.ComputeMetricArgs.verify|verify} messages.
             * @function encode
             * @memberof perfetto.protos.ComputeMetricArgs
             * @static
             * @param {perfetto.protos.IComputeMetricArgs} message ComputeMetricArgs message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ComputeMetricArgs.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.metricNames != null && message.metricNames.length)
                    for (var i = 0; i < message.metricNames.length; ++i)
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.metricNames[i]);
                if (message.format != null && Object.hasOwnProperty.call(message, "format"))
                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.format);
                return writer;
            };

            /**
             * Encodes the specified ComputeMetricArgs message, length delimited. Does not implicitly {@link perfetto.protos.ComputeMetricArgs.verify|verify} messages.
             * @function encodeDelimited
             * @memberof perfetto.protos.ComputeMetricArgs
             * @static
             * @param {perfetto.protos.IComputeMetricArgs} message Compute