// Copyright (c) 2022, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Result of [identityHashCode].
typedef IdentityHashCode = int;

typedef ObjectGcCallback = void Function(Object code);

/// Finilizer builder to mock finalizer.
typedef FinalizerBuilder = Finalizer<Object> Function(
  ObjectGcCallback onObjectGc,
);

Finalizer<Object> buildFinalizer(ObjectGcCallback onObjectGc) =>
    Finalizer<Object>(onObjectGc);

String fullClassName({
  required String library,
  required String shortClassName,
}) =>
    '$library/$shortClassName';

class ObjectRef<T> {
  ObjectRef(this.value);
  T value;
}

const _gitHubLink = 'https://github.com/dart-lang/leak_tracker';

const leakTrackerYamlHeader = '''
# The text is generated by leak_tracker.
# For leak troubleshooting tips open:
# $_gitHubLink
''';
