// Copyright (c) 2018, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Don't modify this file by hand! It's generated by tool/generate.dart.

import '../../term_glyph.dart' as glyph;

/// A bullet point.
///
/// If [glyph.ascii] is `false`, this is "•". If it's `true`, this is
/// "*" instead.
String get bullet => glyph.glyphs.bullet;

/// A left-pointing arrow.
///
/// Note that the Unicode arrow glyphs may overlap with adjacent characters in some
/// terminal fonts, and should generally be surrounding by spaces.
///
/// If [glyph.ascii] is `false`, this is "←". If it's `true`, this is
/// "<" instead.
String get leftArrow => glyph.glyphs.leftArrow;

/// A right-pointing arrow.
///
/// Note that the Unicode arrow glyphs may overlap with adjacent characters in some
/// terminal fonts, and should generally be surrounding by spaces.
///
/// If [glyph.ascii] is `false`, this is "→". If it's `true`, this is
/// ">" instead.
String get rightArrow => glyph.glyphs.rightArrow;

/// An upwards-pointing arrow.
///
/// If [glyph.ascii] is `false`, this is "↑". If it's `true`, this is
/// "^" instead.
String get upArrow => glyph.glyphs.upArrow;

/// A downwards-pointing arrow.
///
/// If [glyph.ascii] is `false`, this is "↓". If it's `true`, this is
/// "v" instead.
String get downArrow => glyph.glyphs.downArrow;

/// A two-character left-pointing arrow.
///
/// If [glyph.ascii] is `false`, this is "◀━". If it's `true`, this is
/// "<=" instead.
String get longLeftArrow => glyph.glyphs.longLeftArrow;

/// A two-character right-pointing arrow.
///
/// If [glyph.ascii] is `false`, this is "━▶". If it's `true`, this is
/// "=>" instead.
String get longRightArrow => glyph.glyphs.longRightArrow;

/// A horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "─". If it's `true`, this is
/// "-" instead.
String get horizontalLine => glyph.glyphs.horizontalLine;

/// A vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "│". If it's `true`, this is
/// "|" instead.
String get verticalLine => glyph.glyphs.verticalLine;

/// The upper left-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "┌". If it's `true`, this is
/// "," instead.
String get topLeftCorner => glyph.glyphs.topLeftCorner;

/// The upper right-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "┐". If it's `true`, this is
/// "," instead.
String get topRightCorner => glyph.glyphs.topRightCorner;

/// The lower left-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "└". If it's `true`, this is
/// "'" instead.
String get bottomLeftCorner => glyph.glyphs.bottomLeftCorner;

/// The lower right-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "┘". If it's `true`, this is
/// "'" instead.
String get bottomRightCorner => glyph.glyphs.bottomRightCorner;

/// An intersection of vertical and horizontal box lines.
///
/// If [glyph.ascii] is `false`, this is "┼". If it's `true`, this is
/// "+" instead.
String get cross => glyph.glyphs.cross;

/// A horizontal box line with a vertical line going up from the middle.
///
/// If [glyph.ascii] is `false`, this is "┴". If it's `true`, this is
/// "+" instead.
String get teeUp => glyph.glyphs.teeUp;

/// A horizontal box line with a vertical line going down from the middle.
///
/// If [glyph.ascii] is `false`, this is "┬". If it's `true`, this is
/// "+" instead.
String get teeDown => glyph.glyphs.teeDown;

/// A vertical box line with a horizontal line going left from the middle.
///
/// If [glyph.ascii] is `false`, this is "┤". If it's `true`, this is
/// "+" instead.
String get teeLeft => glyph.glyphs.teeLeft;

/// A vertical box line with a horizontal line going right from the middle.
///
/// If [glyph.ascii] is `false`, this is "├". If it's `true`, this is
/// "+" instead.
String get teeRight => glyph.glyphs.teeRight;

/// The top half of a vertical box line.
///
/// If [glyph.ascii] is `false`, this is "╵". If it's `true`, this is
/// "'" instead.
String get upEnd => glyph.glyphs.upEnd;

/// The bottom half of a vertical box line.
///
/// If [glyph.ascii] is `false`, this is "╷". If it's `true`, this is
/// "," instead.
String get downEnd => glyph.glyphs.downEnd;

/// The left half of a horizontal box line.
///
/// If [glyph.ascii] is `false`, this is "╴". If it's `true`, this is
/// "-" instead.
String get leftEnd => glyph.glyphs.leftEnd;

/// The right half of a horizontal box line.
///
/// If [glyph.ascii] is `false`, this is "╶". If it's `true`, this is
/// "-" instead.
String get rightEnd => glyph.glyphs.rightEnd;

/// A bold horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "━". If it's `true`, this is
/// "=" instead.
String get horizontalLineBold => glyph.glyphs.horizontalLineBold;

/// A bold vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┃". If it's `true`, this is
/// "|" instead.
String get verticalLineBold => glyph.glyphs.verticalLineBold;

/// The bold upper left-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "┏". If it's `true`, this is
/// "," instead.
String get topLeftCornerBold => glyph.glyphs.topLeftCornerBold;

/// The bold upper right-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "┓". If it's `true`, this is
/// "," instead.
String get topRightCornerBold => glyph.glyphs.topRightCornerBold;

/// The bold lower left-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "┗". If it's `true`, this is
/// "'" instead.
String get bottomLeftCornerBold => glyph.glyphs.bottomLeftCornerBold;

/// The bold lower right-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "┛". If it's `true`, this is
/// "'" instead.
String get bottomRightCornerBold => glyph.glyphs.bottomRightCornerBold;

/// An intersection of bold vertical and horizontal box lines.
///
/// If [glyph.ascii] is `false`, this is "╋". If it's `true`, this is
/// "+" instead.
String get crossBold => glyph.glyphs.crossBold;

/// A bold horizontal box line with a vertical line going up from the middle.
///
/// If [glyph.ascii] is `false`, this is "┻". If it's `true`, this is
/// "+" instead.
String get teeUpBold => glyph.glyphs.teeUpBold;

/// A bold horizontal box line with a vertical line going down from the middle.
///
/// If [glyph.ascii] is `false`, this is "┳". If it's `true`, this is
/// "+" instead.
String get teeDownBold => glyph.glyphs.teeDownBold;

/// A bold vertical box line with a horizontal line going left from the middle.
///
/// If [glyph.ascii] is `false`, this is "┫". If it's `true`, this is
/// "+" instead.
String get teeLeftBold => glyph.glyphs.teeLeftBold;

/// A bold vertical box line with a horizontal line going right from the middle.
///
/// If [glyph.ascii] is `false`, this is "┣". If it's `true`, this is
/// "+" instead.
String get teeRightBold => glyph.glyphs.teeRightBold;

/// The top half of a bold vertical box line.
///
/// If [glyph.ascii] is `false`, this is "╹". If it's `true`, this is
/// "'" instead.
String get upEndBold => glyph.glyphs.upEndBold;

/// The bottom half of a bold vertical box line.
///
/// If [glyph.ascii] is `false`, this is "╻". If it's `true`, this is
/// "," instead.
String get downEndBold => glyph.glyphs.downEndBold;

/// The left half of a bold horizontal box line.
///
/// If [glyph.ascii] is `false`, this is "╸". If it's `true`, this is
/// "-" instead.
String get leftEndBold => glyph.glyphs.leftEndBold;

/// The right half of a bold horizontal box line.
///
/// If [glyph.ascii] is `false`, this is "╺". If it's `true`, this is
/// "-" instead.
String get rightEndBold => glyph.glyphs.rightEndBold;

/// A double horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "═". If it's `true`, this is
/// "=" instead.
String get horizontalLineDouble => glyph.glyphs.horizontalLineDouble;

/// A double vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "║". If it's `true`, this is
/// "|" instead.
String get verticalLineDouble => glyph.glyphs.verticalLineDouble;

/// The double upper left-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "╔". If it's `true`, this is
/// "," instead.
String get topLeftCornerDouble => glyph.glyphs.topLeftCornerDouble;

/// The double upper right-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "╗". If it's `true`, this is
/// "," instead.
String get topRightCornerDouble => glyph.glyphs.topRightCornerDouble;

/// The double lower left-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "╚". If it's `true`, this is
/// """ instead.
String get bottomLeftCornerDouble => glyph.glyphs.bottomLeftCornerDouble;

/// The double lower right-hand corner of a box.
///
/// If [glyph.ascii] is `false`, this is "╝". If it's `true`, this is
/// """ instead.
String get bottomRightCornerDouble => glyph.glyphs.bottomRightCornerDouble;

/// An intersection of double vertical and horizontal box lines.
///
/// If [glyph.ascii] is `false`, this is "╬". If it's `true`, this is
/// "+" instead.
String get crossDouble => glyph.glyphs.crossDouble;

/// A double horizontal box line with a vertical line going up from the middle.
///
/// If [glyph.ascii] is `false`, this is "╩". If it's `true`, this is
/// "+" instead.
String get teeUpDouble => glyph.glyphs.teeUpDouble;

/// A double horizontal box line with a vertical line going down from the middle.
///
/// If [glyph.ascii] is `false`, this is "╦". If it's `true`, this is
/// "+" instead.
String get teeDownDouble => glyph.glyphs.teeDownDouble;

/// A double vertical box line with a horizontal line going left from the middle.
///
/// If [glyph.ascii] is `false`, this is "╣". If it's `true`, this is
/// "+" instead.
String get teeLeftDouble => glyph.glyphs.teeLeftDouble;

/// A double vertical box line with a horizontal line going right from the middle.
///
/// If [glyph.ascii] is `false`, this is "╠". If it's `true`, this is
/// "+" instead.
String get teeRightDouble => glyph.glyphs.teeRightDouble;

/// A dashed horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "╌". If it's `true`, this is
/// "-" instead.
String get horizontalLineDoubleDash => glyph.glyphs.horizontalLineDoubleDash;

/// A bold dashed horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "╍". If it's `true`, this is
/// "-" instead.
String get horizontalLineDoubleDashBold =>
    glyph.glyphs.horizontalLineDoubleDashBold;

/// A dashed vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "╎". If it's `true`, this is
/// "|" instead.
String get verticalLineDoubleDash => glyph.glyphs.verticalLineDoubleDash;

/// A bold dashed vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "╏". If it's `true`, this is
/// "|" instead.
String get verticalLineDoubleDashBold =>
    glyph.glyphs.verticalLineDoubleDashBold;

/// A dashed horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┄". If it's `true`, this is
/// "-" instead.
String get horizontalLineTripleDash => glyph.glyphs.horizontalLineTripleDash;

/// A bold dashed horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┅". If it's `true`, this is
/// "-" instead.
String get horizontalLineTripleDashBold =>
    glyph.glyphs.horizontalLineTripleDashBold;

/// A dashed vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┆". If it's `true`, this is
/// "|" instead.
String get verticalLineTripleDash => glyph.glyphs.verticalLineTripleDash;

/// A bold dashed vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┇". If it's `true`, this is
/// "|" instead.
String get verticalLineTripleDashBold =>
    glyph.glyphs.verticalLineTripleDashBold;

/// A dashed horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┈". If it's `true`, this is
/// "-" instead.
String get horizontalLineQuadrupleDash =>
    glyph.glyphs.horizontalLineQuadrupleDash;

/// A bold dashed horizontal line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┉". If it's `true`, this is
/// "-" instead.
String get horizontalLineQuadrupleDashBold =>
    glyph.glyphs.horizontalLineQuadrupleDashBold;

/// A dashed vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┊". If it's `true`, this is
/// "|" instead.
String get verticalLineQuadrupleDash => glyph.glyphs.verticalLineQuadrupleDash;

/// A bold dashed vertical line that can be used to draw a box.
///
/// If [glyph.ascii] is `false`, this is "┋". If it's `true`, this is
/// "|" instead.
String get verticalLineQuadrupleDashBold =>
    glyph.glyphs.verticalLineQuadrupleDashBold;
