/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import io.flutter.plugin.common.FlutterException;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class StandardMethodCodec
implements MethodCodec {
    public static final StandardMethodCodec INSTANCE = new StandardMethodCodec();

    private StandardMethodCodec() {
    }

    @Override
    public ByteBuffer encodeMethodCall(MethodCall methodCall) {
        StandardMessageCodec.ExposedByteArrayOutputStream stream = new StandardMessageCodec.ExposedByteArrayOutputStream();
        StandardMessageCodec.writeValue(stream, methodCall.method);
        StandardMessageCodec.writeValue(stream, methodCall.arguments);
        ByteBuffer buffer = ByteBuffer.allocateDirect(stream.size());
        buffer.put(stream.buffer(), 0, stream.size());
        return buffer;
    }

    @Override
    public MethodCall decodeMethodCall(ByteBuffer methodCall) {
        methodCall.order(ByteOrder.nativeOrder());
        Object method = StandardMessageCodec.readValue(methodCall);
        Object arguments = StandardMessageCodec.readValue(methodCall);
        if (method instanceof String && !methodCall.hasRemaining()) {
            return new MethodCall((String)method, arguments);
        }
        throw new IllegalArgumentException("Method call corrupted");
    }

    @Override
    public ByteBuffer encodeSuccessEnvelope(Object result) {
        StandardMessageCodec.ExposedByteArrayOutputStream stream = new StandardMessageCodec.ExposedByteArrayOutputStream();
        stream.write(0);
        StandardMessageCodec.writeValue(stream, result);
        ByteBuffer buffer = ByteBuffer.allocateDirect(stream.size());
        buffer.put(stream.buffer(), 0, stream.size());
        return buffer;
    }

    @Override
    public ByteBuffer encodeErrorEnvelope(String errorCode, String errorMessage, Object errorDetails) {
        StandardMessageCodec.ExposedByteArrayOutputStream stream = new StandardMessageCodec.ExposedByteArrayOutputStream();
        stream.write(1);
        StandardMessageCodec.writeValue(stream, errorCode);
        StandardMessageCodec.writeValue(stream, errorMessage);
        StandardMessageCodec.writeValue(stream, errorDetails);
        ByteBuffer buffer = ByteBuffer.allocateDirect(stream.size());
        buffer.put(stream.buffer(), 0, stream.size());
        return buffer;
    }

    @Override
    public Object decodeEnvelope(ByteBuffer envelope) {
        envelope.order(ByteOrder.nativeOrder());
        byte flag = envelope.get();
        switch (flag) {
            case 0: {
                Object result = StandardMessageCodec.readValue(envelope);
                if (!envelope.hasRemaining()) {
                    return result;
                }
            }
            case 1: {
                Object code = StandardMessageCodec.readValue(envelope);
                Object message = StandardMessageCodec.readValue(envelope);
                Object details = StandardMessageCodec.readValue(envelope);
                if (!(code instanceof String) || message != null && !(message instanceof String) || envelope.hasRemaining()) break;
                throw new FlutterException((String)code, (String)message, details);
            }
        }
        throw new IllegalArgumentException("Envelope corrupted");
    }
}

