/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import io.flutter.app.FlutterPluginRegistry;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.view.FlutterView;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FlutterNativeView
implements BinaryMessenger {
    private static final String TAG = "FlutterNativeView";
    private final Map<String, BinaryMessenger.BinaryMessageHandler> mMessageHandlers;
    private int mNextReplyId = 1;
    private final Map<Integer, BinaryMessenger.BinaryReply> mPendingReplies = new HashMap<Integer, BinaryMessenger.BinaryReply>();
    private final FlutterPluginRegistry mPluginRegistry;
    private long mNativePlatformView;
    private FlutterView mFlutterView;

    public FlutterNativeView(Context context) {
        this.mPluginRegistry = new FlutterPluginRegistry(this, context);
        this.attach(this);
        this.assertAttached();
        this.mMessageHandlers = new HashMap<String, BinaryMessenger.BinaryMessageHandler>();
    }

    public void detach() {
        this.mPluginRegistry.detach();
        this.mFlutterView = null;
        FlutterNativeView.nativeDetach(this.mNativePlatformView);
    }

    public void destroy() {
        this.mFlutterView = null;
        FlutterNativeView.nativeDestroy(this.mNativePlatformView);
        this.mNativePlatformView = 0L;
    }

    public FlutterPluginRegistry getPluginRegistry() {
        return this.mPluginRegistry;
    }

    public void attachViewAndActivity(FlutterView flutterView, Activity activity) {
        this.mFlutterView = flutterView;
        this.mPluginRegistry.attach(flutterView, activity);
    }

    public boolean isAttached() {
        return this.mNativePlatformView != 0L;
    }

    public long get() {
        return this.mNativePlatformView;
    }

    public void assertAttached() {
        if (!this.isAttached()) {
            throw new AssertionError((Object)"Platform view is not attached");
        }
    }

    public void runFromBundle(String bundlePath, String snapshotOverride, String entrypoint, boolean reuseRuntimeController) {
        this.assertAttached();
        FlutterNativeView.nativeRunBundleAndSnapshot(this.mNativePlatformView, bundlePath, snapshotOverride, entrypoint, reuseRuntimeController);
    }

    public void runFromSource(String assetsDirectory, String main, String packages) {
        this.assertAttached();
        FlutterNativeView.nativeRunBundleAndSource(this.mNativePlatformView, assetsDirectory, main, packages);
    }

    public void setAssetBundlePathOnUI(String assetsDirectory) {
        this.assertAttached();
        FlutterNativeView.nativeSetAssetBundlePathOnUI(this.mNativePlatformView, assetsDirectory);
    }

    public static String getObservatoryUri() {
        return FlutterNativeView.nativeGetObservatoryUri();
    }

    @Override
    public void send(String channel, ByteBuffer message) {
        this.send(channel, message, null);
    }

    @Override
    public void send(String channel, ByteBuffer message, BinaryMessenger.BinaryReply callback) {
        if (!this.isAttached()) {
            Log.d((String)TAG, (String)("FlutterView.send called on a detached view, channel=" + channel));
            return;
        }
        int replyId = 0;
        if (callback != null) {
            replyId = this.mNextReplyId++;
            this.mPendingReplies.put(replyId, callback);
        }
        if (message == null) {
            FlutterNativeView.nativeDispatchEmptyPlatformMessage(this.mNativePlatformView, channel, replyId);
        } else {
            FlutterNativeView.nativeDispatchPlatformMessage(this.mNativePlatformView, channel, message, message.position(), replyId);
        }
    }

    @Override
    public void setMessageHandler(String channel, BinaryMessenger.BinaryMessageHandler handler) {
        if (handler == null) {
            this.mMessageHandlers.remove(channel);
        } else {
            this.mMessageHandlers.put(channel, handler);
        }
    }

    private void attach(FlutterNativeView view) {
        this.mNativePlatformView = FlutterNativeView.nativeAttach(view);
    }

    private void handlePlatformMessage(final String channel, byte[] message, final int replyId) {
        this.assertAttached();
        BinaryMessenger.BinaryMessageHandler handler = this.mMessageHandlers.get(channel);
        if (handler != null) {
            try {
                ByteBuffer buffer = message == null ? null : ByteBuffer.wrap(message);
                handler.onMessage(buffer, new BinaryMessenger.BinaryReply(){
                    private final AtomicBoolean done = new AtomicBoolean(false);

                    @Override
                    public void reply(ByteBuffer reply) {
                        if (!FlutterNativeView.this.isAttached()) {
                            Log.d((String)FlutterNativeView.TAG, (String)("handlePlatformMessage replying to a detached view, channel=" + channel));
                            return;
                        }
                        if (this.done.getAndSet(true)) {
                            throw new IllegalStateException("Reply already submitted");
                        }
                        if (reply == null) {
                            FlutterNativeView.nativeInvokePlatformMessageEmptyResponseCallback(FlutterNativeView.this.mNativePlatformView, replyId);
                        } else {
                            FlutterNativeView.nativeInvokePlatformMessageResponseCallback(FlutterNativeView.this.mNativePlatformView, replyId, reply, reply.position());
                        }
                    }
                });
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Uncaught exception in binary message listener", (Throwable)ex);
                FlutterNativeView.nativeInvokePlatformMessageEmptyResponseCallback(this.mNativePlatformView, replyId);
            }
            return;
        }
        FlutterNativeView.nativeInvokePlatformMessageEmptyResponseCallback(this.mNativePlatformView, replyId);
    }

    private void handlePlatformMessageResponse(int replyId, byte[] reply) {
        BinaryMessenger.BinaryReply callback = this.mPendingReplies.remove(replyId);
        if (callback != null) {
            try {
                callback.reply(reply == null ? null : ByteBuffer.wrap(reply));
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Uncaught exception in binary message reply handler", (Throwable)ex);
            }
        }
    }

    private void updateSemantics(ByteBuffer buffer, String[] strings) {
        if (this.mFlutterView == null) {
            return;
        }
        this.mFlutterView.updateSemantics(buffer, strings);
    }

    private void onFirstFrame() {
        if (this.mFlutterView == null) {
            return;
        }
        this.mFlutterView.onFirstFrame();
    }

    private static native long nativeAttach(FlutterNativeView var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeDetach(long var0);

    private static native void nativeRunBundleAndSnapshot(long var0, String var2, String var3, String var4, boolean var5);

    private static native void nativeRunBundleAndSource(long var0, String var2, String var3, String var4);

    private static native void nativeSetAssetBundlePathOnUI(long var0, String var2);

    private static native String nativeGetObservatoryUri();

    private static native void nativeDispatchEmptyPlatformMessage(long var0, String var2, int var3);

    private static native void nativeDispatchPlatformMessage(long var0, String var2, ByteBuffer var3, int var4, int var5);

    private static native void nativeInvokePlatformMessageEmptyResponseCallback(long var0, int var2);

    private static native void nativeInvokePlatformMessageResponseCallback(long var0, int var2, ByteBuffer var3, int var4);
}

