/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.util.Log;
import io.flutter.util.PathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

class ResourceExtractor {
    private static final String TAG = "ResourceExtractor";
    private static final String TIMESTAMP_PREFIX = "res_timestamp-";
    private final Context mContext;
    private final HashSet<String> mResources;
    private ExtractTask mExtractTask;

    ResourceExtractor(Context context) {
        this.mContext = context;
        this.mResources = new HashSet();
    }

    ResourceExtractor addResource(String resource) {
        this.mResources.add(resource);
        return this;
    }

    ResourceExtractor addResources(Collection<String> resources) {
        this.mResources.addAll(resources);
        return this;
    }

    ResourceExtractor start() {
        assert (this.mExtractTask == null);
        this.mExtractTask = new ExtractTask();
        this.mExtractTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return this;
    }

    void waitForCompletion() {
        assert (this.mExtractTask != null);
        try {
            this.mExtractTask.get();
        }
        catch (CancellationException e) {
            this.deleteFiles();
        }
        catch (ExecutionException e2) {
            this.deleteFiles();
        }
        catch (InterruptedException e3) {
            this.deleteFiles();
        }
    }

    private String[] getExistingTimestamps(File dataDir) {
        return dataDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(ResourceExtractor.TIMESTAMP_PREFIX);
            }
        });
    }

    private void deleteFiles() {
        File dataDir = new File(PathUtils.getDataDirectory(this.mContext));
        LinkedList<String> files = new LinkedList<String>(this.mResources);
        while (!files.isEmpty()) {
            String resource = files.pop();
            File file = new File(dataDir, resource);
            if (!file.exists()) continue;
            if (file.isFile()) {
                file.delete();
                continue;
            }
            for (String f : file.list()) {
                files.add(resource + File.separator + f);
            }
        }
        for (String timestamp : this.getExistingTimestamps(dataDir)) {
            new File(dataDir, timestamp).delete();
        }
    }

    private class ExtractTask
    extends AsyncTask<Void, Void, Void> {
        private static final int BUFFER_SIZE = 16384;

        ExtractTask() {
        }

        private void extractResources() {
            File dataDir = new File(PathUtils.getDataDirectory(ResourceExtractor.this.mContext));
            String timestamp = this.checkTimestamp(dataDir);
            if (timestamp != null) {
                ResourceExtractor.this.deleteFiles();
            }
            AssetManager manager = ResourceExtractor.this.mContext.getResources().getAssets();
            try {
                byte[] buffer = null;
                String[] assets = manager.list("");
                LinkedList<String> assetList = new LinkedList<String>(Arrays.asList(assets));
                while (!assetList.isEmpty()) {
                    String asset = assetList.pop();
                    if (!ResourceExtractor.this.mResources.contains(asset)) continue;
                    if (manager.list(asset).length > 0) {
                        for (String a : manager.list(asset)) {
                            assetList.add(asset + File.separator + a);
                            ResourceExtractor.this.mResources.add(asset + File.separator + a);
                        }
                        continue;
                    }
                    File output = new File(dataDir, asset);
                    if (output.exists()) continue;
                    if (output.getParentFile() != null) {
                        output.getParentFile().mkdirs();
                    }
                    InputStream is = manager.open(asset);
                    Throwable throwable = null;
                    try {
                        FileOutputStream os = new FileOutputStream(output);
                        Throwable throwable2 = null;
                        try {
                            if (buffer == null) {
                                buffer = new byte[16384];
                            }
                            int count = 0;
                            while ((count = is.read(buffer, 0, 16384)) != -1) {
                                ((OutputStream)os).write(buffer, 0, count);
                            }
                            os.flush();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (os == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ((OutputStream)os).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ((OutputStream)os).close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                Log.w((String)ResourceExtractor.TAG, (String)("Exception unpacking resources: " + e.getMessage()));
                ResourceExtractor.this.deleteFiles();
                return;
            }
            if (timestamp != null) {
                try {
                    new File(dataDir, timestamp).createNewFile();
                }
                catch (IOException e) {
                    Log.w((String)ResourceExtractor.TAG, (String)"Failed to write resource timestamp");
                }
            }
        }

        private String checkTimestamp(File dataDir) {
            PackageManager packageManager = ResourceExtractor.this.mContext.getPackageManager();
            PackageInfo packageInfo = null;
            try {
                packageInfo = packageManager.getPackageInfo(ResourceExtractor.this.mContext.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                return ResourceExtractor.TIMESTAMP_PREFIX;
            }
            if (packageInfo == null) {
                return ResourceExtractor.TIMESTAMP_PREFIX;
            }
            String expectedTimestamp = ResourceExtractor.TIMESTAMP_PREFIX + packageInfo.versionCode + "-" + packageInfo.lastUpdateTime;
            String[] existingTimestamps = ResourceExtractor.this.getExistingTimestamps(dataDir);
            if (existingTimestamps.length != 1 || !expectedTimestamp.equals(existingTimestamps[0])) {
                return expectedTimestamp;
            }
            return null;
        }

        protected Void doInBackground(Void ... unused) {
            this.extractResources();
            return null;
        }
    }
}

