// Copyright (c) 2018, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// This library exports all API from Kernel's ast.dart that can be used
/// throughout fasta.
library fasta.kernel_ast_api;

export 'package:kernel/ast.dart'
    show
        Arguments,
        AssertStatement,
        AsyncMarker,
        Block,
        BreakStatement,
        Catch,
        CheckLibraryIsLoaded,
        Class,
        ConditionalExpression,
        Constructor,
        ConstructorInvocation,
        ContinueSwitchStatement,
        DartType,
        DynamicType,
        EmptyStatement,
        Expression,
        ExpressionStatement,
        Field,
        FunctionDeclaration,
        FunctionNode,
        FunctionType,
        Initializer,
        InvalidType,
        LabeledStatement,
        Let,
        Library,
        Location,
        MapEntry,
        Member,
        MethodInvocation,
        Name,
        NamedExpression,
        NamedType,
        NullLiteral,
        Procedure,
        ProcedureKind,
        Rethrow,
        ReturnStatement,
        Statement,
        StaticGet,
        StringConcatenation,
        StringLiteral,
        SuperInitializer,
        SwitchCase,
        ThisExpression,
        Throw,
        TreeNode,
        TypeParameter,
        TypeParameterType,
        VariableDeclaration,
        VariableGet,
        VoidType,
        setParents;

export 'kernel_shadow_ast.dart'
    show
        ShadowArguments,
        ShadowAsExpression,
        ShadowAssertInitializer,
        ShadowAssertStatement,
        ShadowAwaitExpression,
        ShadowBlock,
        ShadowBoolLiteral,
        ShadowBreakStatement,
        ShadowCascadeExpression,
        ShadowComplexAssignment,
        ShadowConditionalExpression,
        ShadowConstructorInvocation,
        ShadowContinueSwitchStatement,
        ShadowDeferredCheck,
        ShadowDoStatement,
        ShadowDoubleLiteral,
        ShadowExpressionStatement,
        ShadowFactoryConstructorInvocation,
        ShadowFieldInitializer,
        ShadowForInStatement,
        ShadowForStatement,
        ShadowFunctionDeclaration,
        ShadowFunctionExpression,
        ShadowIfNullExpression,
        ShadowIfStatement,
        ShadowIllegalAssignment,
        ShadowIndexAssign,
        ShadowInvalidInitializer,
        ShadowIsExpression,
        ShadowIsNotExpression,
        ShadowLabeledStatement,
        ShadowListLiteral,
        ShadowLogicalExpression,
        ShadowLoopAssignmentStatement,
        ShadowMapLiteral,
        ShadowMethodInvocation,
        ShadowNamedFunctionExpression,
        ShadowNot,
        ShadowNullAwareMethodInvocation,
        ShadowNullLiteral,
        ShadowPropertyAssign,
        ShadowRedirectingInitializer,
        ShadowRethrow,
        ShadowReturnStatement,
        ShadowStaticAssignment,
        ShadowStaticGet,
        ShadowStaticInvocation,
        ShadowStringConcatenation,
        ShadowStringLiteral,
        ShadowSuperInitializer,
        ShadowSuperMethodInvocation,
        ShadowSuperPropertyGet,
        ShadowSwitchStatement,
        ShadowSymbolLiteral,
        ShadowSyntheticExpression,
        ShadowThisExpression,
        ShadowThrow,
        ShadowTryCatch,
        ShadowTryFinally,
        ShadowTypeLiteral,
        ShadowVariableAssignment,
        ShadowVariableDeclaration,
        ShadowVariableGet,
        ShadowWhileStatement,
        ShadowYieldStatement;
