/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import android.util.Log;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import java.nio.ByteBuffer;

public final class BasicMessageChannel<T> {
    private static final String TAG = "BasicMessageChannel#";
    private final BinaryMessenger messenger;
    private final String name;
    private final MessageCodec<T> codec;

    public BasicMessageChannel(BinaryMessenger messenger, String name, MessageCodec<T> codec) {
        assert (messenger != null);
        assert (name != null);
        assert (codec != null);
        this.messenger = messenger;
        this.name = name;
        this.codec = codec;
    }

    public void send(T message) {
        this.send(message, null);
    }

    public void send(T message, Reply<T> callback) {
        this.messenger.send(this.name, this.codec.encodeMessage(message), callback == null ? null : new IncomingReplyHandler(callback));
    }

    public void setMessageHandler(MessageHandler<T> handler) {
        this.messenger.setMessageHandler(this.name, handler == null ? null : new IncomingMessageHandler(handler));
    }

    private final class IncomingMessageHandler
    implements BinaryMessenger.BinaryMessageHandler {
        private final MessageHandler<T> handler;

        private IncomingMessageHandler(MessageHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void onMessage(ByteBuffer message, final BinaryMessenger.BinaryReply callback) {
            try {
                this.handler.onMessage(BasicMessageChannel.this.codec.decodeMessage(message), new Reply<T>(){

                    @Override
                    public void reply(T reply) {
                        callback.reply(BasicMessageChannel.this.codec.encodeMessage(reply));
                    }
                });
            }
            catch (RuntimeException e) {
                Log.e((String)(BasicMessageChannel.TAG + BasicMessageChannel.this.name), (String)"Failed to handle message", (Throwable)e);
                callback.reply(null);
            }
        }
    }

    private final class IncomingReplyHandler
    implements BinaryMessenger.BinaryReply {
        private final Reply<T> callback;

        private IncomingReplyHandler(Reply<T> callback) {
            this.callback = callback;
        }

        @Override
        public void reply(ByteBuffer reply) {
            try {
                this.callback.reply(BasicMessageChannel.this.codec.decodeMessage(reply));
            }
            catch (RuntimeException e) {
                Log.e((String)(BasicMessageChannel.TAG + BasicMessageChannel.this.name), (String)"Failed to handle message reply", (Throwable)e);
            }
        }
    }

    public static interface Reply<T> {
        public void reply(T var1);
    }

    public static interface MessageHandler<T> {
        public void onMessage(T var1, Reply<T> var2);
    }
}

