/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import io.flutter.app.FlutterPluginRegistry;
import io.flutter.plugin.common.ActivityLifecycleListener;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.JSONMessageCodec;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugin.common.StringCodec;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.FlutterMain;
import io.flutter.view.FlutterNativeView;
import io.flutter.view.FlutterRunArguments;
import io.flutter.view.TextureRegistry;
import io.flutter.view.VsyncWaiter;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class FlutterView
extends SurfaceView
implements BinaryMessenger,
TextureRegistry,
AccessibilityManager.AccessibilityStateChangeListener {
    private static final String TAG = "FlutterView";
    private final InputMethodManager mImm;
    private final TextInputPlugin mTextInputPlugin;
    private final SurfaceHolder.Callback mSurfaceCallback;
    private final ViewportMetrics mMetrics;
    private final AccessibilityManager mAccessibilityManager;
    private final MethodChannel mFlutterLocalizationChannel;
    private final MethodChannel mFlutterNavigationChannel;
    private final BasicMessageChannel<Object> mFlutterKeyEventChannel;
    private final BasicMessageChannel<String> mFlutterLifecycleChannel;
    private final BasicMessageChannel<Object> mFlutterSystemChannel;
    private final BasicMessageChannel<Object> mFlutterSettingsChannel;
    private final List<ActivityLifecycleListener> mActivityLifecycleListeners;
    private final List<FirstFrameListener> mFirstFrameListeners;
    private final AtomicLong nextTextureId = new AtomicLong(0L);
    private FlutterNativeView mNativeView;
    private final AnimationScaleObserver mAnimationScaleObserver;
    private boolean mIsSoftwareRenderingEnabled = FlutterView.nativeGetIsSoftwareRenderingEnabled();
    private InputConnection mLastInputConnection;
    private static final int kPointerChangeCancel = 0;
    private static final int kPointerChangeAdd = 1;
    private static final int kPointerChangeRemove = 2;
    private static final int kPointerChangeHover = 3;
    private static final int kPointerChangeDown = 4;
    private static final int kPointerChangeMove = 5;
    private static final int kPointerChangeUp = 6;
    private static final int kPointerDeviceKindTouch = 0;
    private static final int kPointerDeviceKindMouse = 1;
    private static final int kPointerDeviceKindStylus = 2;
    private static final int kPointerDeviceKindInvertedStylus = 3;
    private static final int kPointerDeviceKindUnknown = 4;
    private boolean mAccessibilityEnabled = false;
    private boolean mTouchExplorationEnabled = false;
    private int mAccessibilityFeatureFlags = 0;
    private TouchExplorationListener mTouchExplorationListener;
    private AccessibilityBridge mAccessibilityNodeProvider;

    public FlutterView(Context context) {
        this(context, null);
    }

    public FlutterView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public FlutterView(Context context, AttributeSet attrs, FlutterNativeView nativeView) {
        super(context, attrs);
        this.mAnimationScaleObserver = new AnimationScaleObserver(new Handler());
        this.mMetrics = new ViewportMetrics();
        this.mMetrics.devicePixelRatio = context.getResources().getDisplayMetrics().density;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        Activity activity = (Activity)this.getContext();
        this.mNativeView = nativeView == null ? new FlutterNativeView(activity.getApplicationContext()) : nativeView;
        this.mNativeView.attachViewAndActivity(this, activity);
        this.mSurfaceCallback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                FlutterView.this.assertAttached();
                FlutterView.nativeSurfaceCreated(FlutterView.this.mNativeView.get(), holder.getSurface());
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                FlutterView.this.assertAttached();
                FlutterView.nativeSurfaceChanged(FlutterView.this.mNativeView.get(), width, height);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                FlutterView.this.assertAttached();
                FlutterView.nativeSurfaceDestroyed(FlutterView.this.mNativeView.get());
            }
        };
        this.getHolder().addCallback(this.mSurfaceCallback);
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.mActivityLifecycleListeners = new ArrayList<ActivityLifecycleListener>();
        this.mFirstFrameListeners = new ArrayList<FirstFrameListener>();
        this.mFlutterLocalizationChannel = new MethodChannel(this, "flutter/localization", JSONMethodCodec.INSTANCE);
        this.mFlutterNavigationChannel = new MethodChannel(this, "flutter/navigation", JSONMethodCodec.INSTANCE);
        this.mFlutterKeyEventChannel = new BasicMessageChannel<Object>(this, "flutter/keyevent", JSONMessageCodec.INSTANCE);
        this.mFlutterLifecycleChannel = new BasicMessageChannel<String>(this, "flutter/lifecycle", StringCodec.INSTANCE);
        this.mFlutterSystemChannel = new BasicMessageChannel<Object>(this, "flutter/system", JSONMessageCodec.INSTANCE);
        this.mFlutterSettingsChannel = new BasicMessageChannel<Object>(this, "flutter/settings", JSONMessageCodec.INSTANCE);
        PlatformPlugin platformPlugin = new PlatformPlugin(activity);
        MethodChannel flutterPlatformChannel = new MethodChannel(this, "flutter/platform", JSONMethodCodec.INSTANCE);
        flutterPlatformChannel.setMethodCallHandler(platformPlugin);
        this.addActivityLifecycleListener(platformPlugin);
        this.mImm = (InputMethodManager)this.getContext().getSystemService("input_method");
        this.mTextInputPlugin = new TextInputPlugin(this);
        this.setLocales(this.getResources().getConfiguration());
        this.setUserSettings();
    }

    private void encodeKeyEvent(KeyEvent event, Map<String, Object> message) {
        message.put("flags", event.getFlags());
        message.put("codePoint", event.getUnicodeChar());
        message.put("keyCode", event.getKeyCode());
        message.put("scanCode", event.getScanCode());
        message.put("metaState", event.getMetaState());
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!this.isAttached()) {
            return super.onKeyUp(keyCode, event);
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", "keyup");
        message.put("keymap", "android");
        this.encodeKeyEvent(event, message);
        this.mFlutterKeyEventChannel.send(message);
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (!this.isAttached()) {
            return super.onKeyDown(keyCode, event);
        }
        if (event.getDeviceId() != -1 && this.mLastInputConnection != null && this.mImm.isAcceptingText()) {
            this.mLastInputConnection.sendKeyEvent(event);
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", "keydown");
        message.put("keymap", "android");
        this.encodeKeyEvent(event, message);
        this.mFlutterKeyEventChannel.send(message);
        return super.onKeyDown(keyCode, event);
    }

    public FlutterNativeView getFlutterNativeView() {
        return this.mNativeView;
    }

    public FlutterPluginRegistry getPluginRegistry() {
        return this.mNativeView.getPluginRegistry();
    }

    public String getLookupKeyForAsset(String asset) {
        return FlutterMain.getLookupKeyForAsset(asset);
    }

    public String getLookupKeyForAsset(String asset, String packageName) {
        return FlutterMain.getLookupKeyForAsset(asset, packageName);
    }

    public void addActivityLifecycleListener(ActivityLifecycleListener listener) {
        this.mActivityLifecycleListeners.add(listener);
    }

    public void onStart() {
        this.mFlutterLifecycleChannel.send("AppLifecycleState.inactive");
    }

    public void onPause() {
        this.mFlutterLifecycleChannel.send("AppLifecycleState.inactive");
    }

    public void onPostResume() {
        this.updateAccessibilityFeatures();
        for (ActivityLifecycleListener listener : this.mActivityLifecycleListeners) {
            listener.onPostResume();
        }
        this.mFlutterLifecycleChannel.send("AppLifecycleState.resumed");
    }

    public void onStop() {
        this.mFlutterLifecycleChannel.send("AppLifecycleState.paused");
    }

    public void onMemoryPressure() {
        HashMap<String, String> message = new HashMap<String, String>(1);
        message.put("type", "memoryPressure");
        this.mFlutterSystemChannel.send(message);
    }

    public void addFirstFrameListener(FirstFrameListener listener) {
        this.mFirstFrameListeners.add(listener);
    }

    public void removeFirstFrameListener(FirstFrameListener listener) {
        this.mFirstFrameListeners.remove(listener);
    }

    public void enableTransparentBackground() {
        this.setZOrderOnTop(true);
        this.getHolder().setFormat(-2);
    }

    public void disableTransparentBackground() {
        this.setZOrderOnTop(false);
        this.getHolder().setFormat(-1);
    }

    public void setInitialRoute(String route) {
        this.mFlutterNavigationChannel.invokeMethod("setInitialRoute", route);
    }

    public void pushRoute(String route) {
        this.mFlutterNavigationChannel.invokeMethod("pushRoute", route);
    }

    public void popRoute() {
        this.mFlutterNavigationChannel.invokeMethod("popRoute", null);
    }

    private void setUserSettings() {
        HashMap<String, Constable> message = new HashMap<String, Constable>();
        message.put("textScaleFactor", Float.valueOf(this.getResources().getConfiguration().fontScale));
        message.put("alwaysUse24HourFormat", Boolean.valueOf(DateFormat.is24HourFormat((Context)this.getContext())));
        this.mFlutterSettingsChannel.send(message);
    }

    private void setLocales(Configuration config) {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                Object localeList = config.getClass().getDeclaredMethod("getLocales", new Class[0]).invoke((Object)config, new Object[0]);
                Method localeListGet = localeList.getClass().getDeclaredMethod("get", Integer.TYPE);
                Method localeListSize = localeList.getClass().getDeclaredMethod("size", new Class[0]);
                int localeCount = (Integer)localeListSize.invoke(localeList, new Object[0]);
                ArrayList<String> data = new ArrayList<String>();
                for (int index = 0; index < localeCount; ++index) {
                    Locale locale = (Locale)localeListGet.invoke(localeList, index);
                    data.add(locale.getLanguage());
                    data.add(locale.getCountry());
                    data.add(locale.getScript());
                    data.add(locale.getVariant());
                }
                this.mFlutterLocalizationChannel.invokeMethod("setLocale", data);
                return;
            }
            catch (Exception localeList) {
                // empty catch block
            }
        }
        Locale locale = config.locale;
        this.mFlutterLocalizationChannel.invokeMethod("setLocale", Arrays.asList(locale.getLanguage(), locale.getCountry(), Build.VERSION.SDK_INT >= 21 ? locale.getScript() : "", locale.getVariant()));
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setLocales(newConfig);
        this.setUserSettings();
    }

    float getDevicePixelRatio() {
        return this.mMetrics.devicePixelRatio;
    }

    public FlutterNativeView detach() {
        if (!this.isAttached()) {
            return null;
        }
        this.getHolder().removeCallback(this.mSurfaceCallback);
        this.mNativeView.detach();
        FlutterNativeView view = this.mNativeView;
        this.mNativeView = null;
        return view;
    }

    public void destroy() {
        if (!this.isAttached()) {
            return;
        }
        this.getHolder().removeCallback(this.mSurfaceCallback);
        this.mNativeView.destroy();
        this.mNativeView = null;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        try {
            this.mLastInputConnection = this.mTextInputPlugin.createInputConnection(this, outAttrs);
            return this.mLastInputConnection;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to create input connection", (Throwable)e);
            return null;
        }
    }

    private int getPointerChangeForAction(int maskedAction) {
        if (maskedAction == 0) {
            return 4;
        }
        if (maskedAction == 1) {
            return 6;
        }
        if (maskedAction == 5) {
            return 4;
        }
        if (maskedAction == 6) {
            return 6;
        }
        if (maskedAction == 2) {
            return 5;
        }
        if (maskedAction == 3) {
            return 0;
        }
        return -1;
    }

    private int getPointerDeviceTypeForToolType(int toolType) {
        switch (toolType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    private void addPointerForIndex(MotionEvent event, int pointerIndex, int pointerChange, int pointerData, ByteBuffer packet) {
        if (pointerChange == -1) {
            return;
        }
        int pointerKind = this.getPointerDeviceTypeForToolType(event.getToolType(pointerIndex));
        long timeStamp = event.getEventTime() * 1000L;
        packet.putLong(timeStamp);
        packet.putLong(pointerChange);
        packet.putLong(pointerKind);
        packet.putLong(event.getPointerId(pointerIndex));
        packet.putDouble(event.getX(pointerIndex));
        packet.putDouble(event.getY(pointerIndex));
        if (pointerKind == 1) {
            packet.putLong(event.getButtonState() & 0x1F);
        } else if (pointerKind == 2) {
            packet.putLong(event.getButtonState() >> 4 & 0xF);
        } else {
            packet.putLong(0L);
        }
        packet.putLong(0L);
        packet.putDouble(event.getPressure(pointerIndex));
        packet.putDouble(0.0);
        packet.putDouble(1.0);
        if (pointerKind == 2) {
            packet.putDouble(event.getAxisValue(24, pointerIndex));
            packet.putDouble(0.0);
        } else {
            packet.putDouble(0.0);
            packet.putDouble(0.0);
        }
        packet.putDouble(event.getSize(pointerIndex));
        packet.putDouble(event.getToolMajor(pointerIndex));
        packet.putDouble(event.getToolMinor(pointerIndex));
        packet.putDouble(0.0);
        packet.putDouble(0.0);
        packet.putDouble(event.getAxisValue(8, pointerIndex));
        if (pointerKind == 2) {
            packet.putDouble(event.getAxisValue(25, pointerIndex));
        } else {
            packet.putDouble(0.0);
        }
        packet.putLong(pointerData);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isAttached()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.requestUnbufferedDispatch(event);
        }
        int kPointerDataFieldCount = 21;
        int kBytePerField = 8;
        boolean kPointerDataFlagBatched = true;
        int pointerCount = event.getPointerCount();
        ByteBuffer packet = ByteBuffer.allocateDirect(pointerCount * 21 * 8);
        packet.order(ByteOrder.LITTLE_ENDIAN);
        int maskedAction = event.getActionMasked();
        int pointerChange = this.getPointerChangeForAction(event.getActionMasked());
        if (maskedAction == 0 || maskedAction == 5) {
            this.addPointerForIndex(event, event.getActionIndex(), pointerChange, 0, packet);
        } else if (maskedAction == 1 || maskedAction == 6) {
            for (int p = 0; p < pointerCount; ++p) {
                if (p == event.getActionIndex() || event.getToolType(p) != 1) continue;
                this.addPointerForIndex(event, p, 5, 1, packet);
            }
            this.addPointerForIndex(event, event.getActionIndex(), pointerChange, 0, packet);
        } else {
            for (int p = 0; p < pointerCount; ++p) {
                this.addPointerForIndex(event, p, pointerChange, 0, packet);
            }
        }
        assert (packet.position() % 168 == 0);
        FlutterView.nativeDispatchPointerDataPacket(this.mNativeView.get(), packet, packet.position());
        return true;
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (!this.isAttached()) {
            return false;
        }
        boolean handled = this.handleAccessibilityHoverEvent(event);
        if (!handled) {
            // empty if block
        }
        return handled;
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.mMetrics.physicalWidth = width;
        this.mMetrics.physicalHeight = height;
        this.updateViewportMetrics();
        super.onSizeChanged(width, height, oldWidth, oldHeight);
    }

    ZeroSides calculateShouldZeroSides() {
        Activity activity = (Activity)this.getContext();
        int orientation = activity.getResources().getConfiguration().orientation;
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        if (orientation == 2) {
            if (rotation == 1) {
                return ZeroSides.RIGHT;
            }
            if (rotation == 3) {
                return Build.VERSION.SDK_INT >= 23 ? ZeroSides.LEFT : ZeroSides.RIGHT;
            }
            if (rotation == 0 || rotation == 2) {
                return ZeroSides.BOTH;
            }
        }
        return ZeroSides.NONE;
    }

    int calculateBottomKeyboardInset(WindowInsets insets) {
        int screenHeight = this.getRootView().getHeight();
        double keyboardHeightRatioHeuristic = 0.18;
        if ((double)insets.getSystemWindowInsetBottom() < (double)screenHeight * 0.18) {
            return 0;
        }
        return insets.getSystemWindowInsetBottom();
    }

    public final WindowInsets onApplyWindowInsets(WindowInsets insets) {
        boolean statusBarHidden = (4 & this.getWindowSystemUiVisibility()) != 0;
        boolean navigationBarHidden = (2 & this.getWindowSystemUiVisibility()) != 0;
        ZeroSides zeroSides = ZeroSides.NONE;
        if (navigationBarHidden) {
            zeroSides = this.calculateShouldZeroSides();
        }
        this.mMetrics.physicalPaddingTop = statusBarHidden ? 0 : insets.getSystemWindowInsetTop();
        this.mMetrics.physicalPaddingRight = zeroSides == ZeroSides.RIGHT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetRight();
        this.mMetrics.physicalPaddingBottom = 0;
        this.mMetrics.physicalPaddingLeft = zeroSides == ZeroSides.LEFT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetLeft();
        this.mMetrics.physicalViewInsetTop = 0;
        this.mMetrics.physicalViewInsetRight = 0;
        this.mMetrics.physicalViewInsetBottom = navigationBarHidden ? this.calculateBottomKeyboardInset(insets) : insets.getSystemWindowInsetBottom();
        this.mMetrics.physicalViewInsetLeft = 0;
        this.updateViewportMetrics();
        return super.onApplyWindowInsets(insets);
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.mMetrics.physicalPaddingTop = insets.top;
            this.mMetrics.physicalPaddingRight = insets.right;
            this.mMetrics.physicalPaddingBottom = 0;
            this.mMetrics.physicalPaddingLeft = insets.left;
            this.mMetrics.physicalViewInsetTop = 0;
            this.mMetrics.physicalViewInsetRight = 0;
            this.mMetrics.physicalViewInsetBottom = insets.bottom;
            this.mMetrics.physicalViewInsetLeft = 0;
            this.updateViewportMetrics();
            return true;
        }
        return super.fitSystemWindows(insets);
    }

    private boolean isAttached() {
        return this.mNativeView != null && this.mNativeView.isAttached();
    }

    void assertAttached() {
        if (!this.isAttached()) {
            throw new AssertionError((Object)"Platform view is not attached");
        }
    }

    private void preRun() {
        this.resetAccessibilityTree();
    }

    private void postRun() {
    }

    public void runFromBundle(FlutterRunArguments args) {
        this.assertAttached();
        this.preRun();
        this.mNativeView.runFromBundle(args);
        this.postRun();
    }

    @Deprecated
    public void runFromBundle(String bundlePath, String defaultPath) {
        this.runFromBundle(bundlePath, defaultPath, "main", false);
    }

    @Deprecated
    public void runFromBundle(String bundlePath, String defaultPath, String entrypoint) {
        this.runFromBundle(bundlePath, defaultPath, entrypoint, false);
    }

    @Deprecated
    public void runFromBundle(String bundlePath, String defaultPath, String entrypoint, boolean reuseRuntimeController) {
        FlutterRunArguments args = new FlutterRunArguments();
        args.bundlePath = bundlePath;
        args.entrypoint = entrypoint;
        args.defaultPath = defaultPath;
        this.runFromBundle(args);
    }

    public Bitmap getBitmap() {
        this.assertAttached();
        return FlutterView.nativeGetBitmap(this.mNativeView.get());
    }

    private static native void nativeSurfaceCreated(long var0, Surface var2);

    private static native void nativeSurfaceChanged(long var0, int var2, int var3);

    private static native void nativeSurfaceDestroyed(long var0);

    private static native void nativeSetViewportMetrics(long var0, float var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native Bitmap nativeGetBitmap(long var0);

    private static native void nativeDispatchPointerDataPacket(long var0, ByteBuffer var2, int var3);

    private static native void nativeDispatchSemanticsAction(long var0, int var2, int var3, ByteBuffer var4, int var5);

    private static native void nativeSetSemanticsEnabled(long var0, boolean var2);

    private static native void nativeSetAccessibilityFeatures(long var0, int var2);

    private static native boolean nativeGetIsSoftwareRenderingEnabled();

    private static native void nativeRegisterTexture(long var0, long var2, SurfaceTexture var4);

    private static native void nativeMarkTextureFrameAvailable(long var0, long var2);

    private static native void nativeUnregisterTexture(long var0, long var2);

    private void updateViewportMetrics() {
        if (!this.isAttached()) {
            return;
        }
        FlutterView.nativeSetViewportMetrics(this.mNativeView.get(), this.mMetrics.devicePixelRatio, this.mMetrics.physicalWidth, this.mMetrics.physicalHeight, this.mMetrics.physicalPaddingTop, this.mMetrics.physicalPaddingRight, this.mMetrics.physicalPaddingBottom, this.mMetrics.physicalPaddingLeft, this.mMetrics.physicalViewInsetTop, this.mMetrics.physicalViewInsetRight, this.mMetrics.physicalViewInsetBottom, this.mMetrics.physicalViewInsetLeft);
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        float fps = wm.getDefaultDisplay().getRefreshRate();
        VsyncWaiter.refreshPeriodNanos = (long)(1.0E9 / (double)fps);
    }

    public void updateSemantics(ByteBuffer buffer, String[] strings) {
        try {
            if (this.mAccessibilityNodeProvider != null) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mAccessibilityNodeProvider.updateSemantics(buffer, strings);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Uncaught exception while updating semantics", (Throwable)ex);
        }
    }

    public void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
        try {
            if (this.mAccessibilityNodeProvider != null) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mAccessibilityNodeProvider.updateCustomAccessibilityActions(buffer, strings);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Uncaught exception while updating local context actions", (Throwable)ex);
        }
    }

    public void onFirstFrame() {
        ArrayList<FirstFrameListener> listeners = new ArrayList<FirstFrameListener>(this.mFirstFrameListeners);
        for (FirstFrameListener listener : listeners) {
            listener.onFirstFrame();
        }
    }

    protected void dispatchSemanticsAction(int id, AccessibilityBridge.Action action) {
        this.dispatchSemanticsAction(id, action, null);
    }

    protected void dispatchSemanticsAction(int id, AccessibilityBridge.Action action, Object args) {
        if (!this.isAttached()) {
            return;
        }
        ByteBuffer encodedArgs = null;
        int position = 0;
        if (args != null) {
            encodedArgs = StandardMessageCodec.INSTANCE.encodeMessage(args);
            position = encodedArgs.position();
        }
        FlutterView.nativeDispatchSemanticsAction(this.mNativeView.get(), id, action.value, encodedArgs, position);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAccessibilityEnabled = this.mAccessibilityManager.isEnabled();
        this.mTouchExplorationEnabled = this.mAccessibilityManager.isTouchExplorationEnabled();
        if (Build.VERSION.SDK_INT >= 17) {
            Uri transitionUri = Settings.Global.getUriFor((String)"transition_animation_scale");
            this.getContext().getContentResolver().registerContentObserver(transitionUri, false, (ContentObserver)this.mAnimationScaleObserver);
        }
        if (this.mAccessibilityEnabled || this.mTouchExplorationEnabled) {
            this.ensureAccessibilityEnabled();
        }
        if (this.mTouchExplorationEnabled) {
            this.mAccessibilityFeatureFlags ^= AccessibilityFeature.ACCESSIBLE_NAVIGATION.value;
        }
        this.updateAccessibilityFeatures();
        this.resetWillNotDraw();
        this.mAccessibilityManager.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
        if (Build.VERSION.SDK_INT >= 19) {
            if (this.mTouchExplorationListener == null) {
                this.mTouchExplorationListener = new TouchExplorationListener();
            }
            this.mAccessibilityManager.addTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.mTouchExplorationListener);
        }
    }

    private void updateAccessibilityFeatures() {
        if (Build.VERSION.SDK_INT >= 17) {
            String transitionAnimationScale = Settings.Global.getString((ContentResolver)this.getContext().getContentResolver(), (String)"transition_animation_scale");
            this.mAccessibilityFeatureFlags = transitionAnimationScale != null && transitionAnimationScale.equals("0") ? (this.mAccessibilityFeatureFlags ^= AccessibilityFeature.DISABLE_ANIMATIONS.value) : (this.mAccessibilityFeatureFlags &= ~AccessibilityFeature.DISABLE_ANIMATIONS.value);
        }
        FlutterView.nativeSetAccessibilityFeatures(this.mNativeView.get(), this.mAccessibilityFeatureFlags);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getContext().getContentResolver().unregisterContentObserver((ContentObserver)this.mAnimationScaleObserver);
        this.mAccessibilityManager.removeAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
        if (Build.VERSION.SDK_INT >= 19) {
            this.mAccessibilityManager.removeTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.mTouchExplorationListener);
        }
    }

    private void resetWillNotDraw() {
        if (!this.mIsSoftwareRenderingEnabled) {
            this.setWillNotDraw(!this.mAccessibilityEnabled && !this.mTouchExplorationEnabled);
        } else {
            this.setWillNotDraw(false);
        }
    }

    public void onAccessibilityStateChanged(boolean enabled) {
        if (enabled) {
            this.ensureAccessibilityEnabled();
        } else {
            this.mAccessibilityEnabled = false;
            if (this.mAccessibilityNodeProvider != null) {
                this.mAccessibilityNodeProvider.setAccessibilityEnabled(false);
            }
            FlutterView.nativeSetSemanticsEnabled(this.mNativeView.get(), false);
        }
        this.resetWillNotDraw();
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mAccessibilityEnabled) {
            return this.mAccessibilityNodeProvider;
        }
        return null;
    }

    void ensureAccessibilityEnabled() {
        if (!this.isAttached()) {
            return;
        }
        this.mAccessibilityEnabled = true;
        if (this.mAccessibilityNodeProvider == null) {
            this.mAccessibilityNodeProvider = new AccessibilityBridge(this);
        }
        FlutterView.nativeSetSemanticsEnabled(this.mNativeView.get(), true);
        this.mAccessibilityNodeProvider.setAccessibilityEnabled(true);
    }

    void resetAccessibilityTree() {
        if (this.mAccessibilityNodeProvider != null) {
            this.mAccessibilityNodeProvider.reset();
        }
    }

    private boolean handleAccessibilityHoverEvent(MotionEvent event) {
        if (!this.mTouchExplorationEnabled) {
            return false;
        }
        if (event.getAction() == 9 || event.getAction() == 7) {
            this.mAccessibilityNodeProvider.handleTouchExploration(event.getX(), event.getY());
        } else if (event.getAction() == 10) {
            this.mAccessibilityNodeProvider.handleTouchExplorationExit();
        } else {
            Log.d((String)"flutter", (String)("unexpected accessibility hover event: " + event));
            return false;
        }
        return true;
    }

    @Override
    public void send(String channel, ByteBuffer message) {
        this.send(channel, message, null);
    }

    @Override
    public void send(String channel, ByteBuffer message, BinaryMessenger.BinaryReply callback) {
        if (!this.isAttached()) {
            Log.d((String)TAG, (String)("FlutterView.send called on a detached view, channel=" + channel));
            return;
        }
        this.mNativeView.send(channel, message, callback);
    }

    @Override
    public void setMessageHandler(String channel, BinaryMessenger.BinaryMessageHandler handler) {
        this.mNativeView.setMessageHandler(channel, handler);
    }

    @Override
    public TextureRegistry.SurfaceTextureEntry createSurfaceTexture() {
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.detachFromGLContext();
        SurfaceTextureRegistryEntry entry = new SurfaceTextureRegistryEntry(this.nextTextureId.getAndIncrement(), surfaceTexture);
        FlutterView.nativeRegisterTexture(this.mNativeView.get(), entry.id(), surfaceTexture);
        return entry;
    }

    final class SurfaceTextureRegistryEntry
    implements TextureRegistry.SurfaceTextureEntry {
        private final long id;
        private final SurfaceTexture surfaceTexture;
        private boolean released;
        private SurfaceTexture.OnFrameAvailableListener onFrameListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture texture) {
                if (SurfaceTextureRegistryEntry.this.released) {
                    return;
                }
                FlutterView.nativeMarkTextureFrameAvailable(FlutterView.this.mNativeView.get(), SurfaceTextureRegistryEntry.this.id);
            }
        };

        SurfaceTextureRegistryEntry(long id, SurfaceTexture surfaceTexture) {
            this.id = id;
            this.surfaceTexture = surfaceTexture;
            if (Build.VERSION.SDK_INT >= 21) {
                this.surfaceTexture.setOnFrameAvailableListener(this.onFrameListener, new Handler());
            } else {
                this.surfaceTexture.setOnFrameAvailableListener(this.onFrameListener);
            }
        }

        @Override
        public SurfaceTexture surfaceTexture() {
            return this.surfaceTexture;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            FlutterView.nativeUnregisterTexture(FlutterView.this.mNativeView.get(), this.id);
            this.surfaceTexture.setOnFrameAvailableListener(null);
            this.surfaceTexture.release();
        }
    }

    public static interface FirstFrameListener {
        public void onFirstFrame();
    }

    class TouchExplorationListener
    implements AccessibilityManager.TouchExplorationStateChangeListener {
        TouchExplorationListener() {
        }

        public void onTouchExplorationStateChanged(boolean enabled) {
            if (enabled) {
                FlutterView.this.mTouchExplorationEnabled = true;
                FlutterView.this.ensureAccessibilityEnabled();
                FlutterView.this.mAccessibilityFeatureFlags = FlutterView.this.mAccessibilityFeatureFlags ^ AccessibilityFeature.ACCESSIBLE_NAVIGATION.value;
                FlutterView.nativeSetAccessibilityFeatures(FlutterView.this.mNativeView.get(), FlutterView.this.mAccessibilityFeatureFlags);
            } else {
                FlutterView.this.mTouchExplorationEnabled = false;
                if (FlutterView.this.mAccessibilityNodeProvider != null) {
                    FlutterView.this.mAccessibilityNodeProvider.handleTouchExplorationExit();
                }
                FlutterView.this.mAccessibilityFeatureFlags = FlutterView.this.mAccessibilityFeatureFlags & ~AccessibilityFeature.ACCESSIBLE_NAVIGATION.value;
                FlutterView.nativeSetAccessibilityFeatures(FlutterView.this.mNativeView.get(), FlutterView.this.mAccessibilityFeatureFlags);
            }
            FlutterView.this.resetWillNotDraw();
        }
    }

    private class AnimationScaleObserver
    extends ContentObserver {
        public AnimationScaleObserver(Handler handler) {
            super(handler);
        }

        public void onChange(boolean selfChange) {
            this.onChange(selfChange, null);
        }

        public void onChange(boolean selfChange, Uri uri) {
            String value = Settings.Global.getString((ContentResolver)FlutterView.this.getContext().getContentResolver(), (String)"transition_animation_scale");
            if (value != null && value.equals("0")) {
                FlutterView.this.mAccessibilityFeatureFlags = FlutterView.this.mAccessibilityFeatureFlags ^ AccessibilityFeature.DISABLE_ANIMATIONS.value;
            } else {
                FlutterView.this.mAccessibilityFeatureFlags = FlutterView.this.mAccessibilityFeatureFlags & ~AccessibilityFeature.DISABLE_ANIMATIONS.value;
            }
            FlutterView.nativeSetAccessibilityFeatures(FlutterView.this.mNativeView.get(), FlutterView.this.mAccessibilityFeatureFlags);
        }
    }

    private static enum AccessibilityFeature {
        ACCESSIBLE_NAVIGATION(1),
        INVERT_COLORS(2),
        DISABLE_ANIMATIONS(4);

        final int value;

        private AccessibilityFeature(int value) {
            this.value = value;
        }
    }

    static enum ZeroSides {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }

    static final class ViewportMetrics {
        float devicePixelRatio = 1.0f;
        int physicalWidth = 0;
        int physicalHeight = 0;
        int physicalPaddingTop = 0;
        int physicalPaddingRight = 0;
        int physicalPaddingBottom = 0;
        int physicalPaddingLeft = 0;
        int physicalViewInsetTop = 0;
        int physicalViewInsetRight = 0;
        int physicalViewInsetBottom = 0;
        int physicalViewInsetLeft = 0;

        ViewportMetrics() {
        }
    }

    public static interface Provider {
        public FlutterView getFlutterView();
    }
}

