// Copyright (c) 2018, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:typed_data' as typed_data;

abstract class Endianness {
  static const big = typed_data.Endian.big;
  static const little = typed_data.Endian.little;
}

abstract class Int8List {
  static const bytesPerElement = typed_data.Int8List.bytesPerElement;
}

abstract class Uint8List {
  static const bytesPerElement = typed_data.Uint8List.bytesPerElement;
}

abstract class Uint8ClampedList {
  static const bytesPerElement = typed_data.Uint8ClampedList.bytesPerElement;
}

abstract class Int16List {
  static const bytesPerElement = typed_data.Int16List.bytesPerElement;
}

abstract class Uint16List {
  static const bytesPerElement = typed_data.Uint16List.bytesPerElement;
}

abstract class Int32List {
  static const bytesPerElement = typed_data.Int32List.bytesPerElement;
}

abstract class Uint32List {
  static const bytesPerElement = typed_data.Uint32List.bytesPerElement;
}

abstract class Int64List {
  static const bytesPerElement = typed_data.Int64List.bytesPerElement;
}

abstract class Uint64List {
  static const bytesPerElement = typed_data.Uint64List.bytesPerElement;
}

abstract class Float32List {
  static const bytesPerElement = typed_data.Float32List.bytesPerElement;
}

abstract class Float64List {
  static const bytesPerElement = typed_data.Float64List.bytesPerElement;
}

abstract class Float32x4List {
  static const bytesPerElement = typed_data.Float32x4List.bytesPerElement;
}

abstract class Int32x4List {
  static const bytesPerElement = typed_data.Int32x4List.bytesPerElement;
}

abstract class Float64x2List {
  static const bytesPerElement = typed_data.Float64x2List.bytesPerElement;
}

abstract class Float32x4 {
  static const xxxx = typed_data.Float32x4.xxxx;
  static const xxxy = typed_data.Float32x4.xxxy;
  static const xxxz = typed_data.Float32x4.xxxz;
  static const xxxw = typed_data.Float32x4.xxxw;
  static const xxyx = typed_data.Float32x4.xxyx;
  static const xxyy = typed_data.Float32x4.xxyy;
  static const xxyz = typed_data.Float32x4.xxyz;
  static const xxyw = typed_data.Float32x4.xxyw;
  static const xxzx = typed_data.Float32x4.xxzx;
  static const xxzy = typed_data.Float32x4.xxzy;
  static const xxzz = typed_data.Float32x4.xxzz;
  static const xxzw = typed_data.Float32x4.xxzw;
  static const xxwx = typed_data.Float32x4.xxwx;
  static const xxwy = typed_data.Float32x4.xxwy;
  static const xxwz = typed_data.Float32x4.xxwz;
  static const xxww = typed_data.Float32x4.xxww;
  static const xyxx = typed_data.Float32x4.xyxx;
  static const xyxy = typed_data.Float32x4.xyxy;
  static const xyxz = typed_data.Float32x4.xyxz;
  static const xyxw = typed_data.Float32x4.xyxw;
  static const xyyx = typed_data.Float32x4.xyyx;
  static const xyyy = typed_data.Float32x4.xyyy;
  static const xyyz = typed_data.Float32x4.xyyz;
  static const xyyw = typed_data.Float32x4.xyyw;
  static const xyzx = typed_data.Float32x4.xyzx;
  static const xyzy = typed_data.Float32x4.xyzy;
  static const xyzz = typed_data.Float32x4.xyzz;
  static const xyzw = typed_data.Float32x4.xyzw;
  static const xywx = typed_data.Float32x4.xywx;
  static const xywy = typed_data.Float32x4.xywy;
  static const xywz = typed_data.Float32x4.xywz;
  static const xyww = typed_data.Float32x4.xyww;
  static const xzxx = typed_data.Float32x4.xzxx;
  static const xzxy = typed_data.Float32x4.xzxy;
  static const xzxz = typed_data.Float32x4.xzxz;
  static const xzxw = typed_data.Float32x4.xzxw;
  static const xzyx = typed_data.Float32x4.xzyx;
  static const xzyy = typed_data.Float32x4.xzyy;
  static const xzyz = typed_data.Float32x4.xzyz;
  static const xzyw = typed_data.Float32x4.xzyw;
  static const xzzx = typed_data.Float32x4.xzzx;
  static const xzzy = typed_data.Float32x4.xzzy;
  static const xzzz = typed_data.Float32x4.xzzz;
  static const xzzw = typed_data.Float32x4.xzzw;
  static const xzwx = typed_data.Float32x4.xzwx;
  static const xzwy = typed_data.Float32x4.xzwy;
  static const xzwz = typed_data.Float32x4.xzwz;
  static const xzww = typed_data.Float32x4.xzww;
  static const xwxx = typed_data.Float32x4.xwxx;
  static const xwxy = typed_data.Float32x4.xwxy;
  static const xwxz = typed_data.Float32x4.xwxz;
  static const xwxw = typed_data.Float32x4.xwxw;
  static const xwyx = typed_data.Float32x4.xwyx;
  static const xwyy = typed_data.Float32x4.xwyy;
  static const xwyz = typed_data.Float32x4.xwyz;
  static const xwyw = typed_data.Float32x4.xwyw;
  static const xwzx = typed_data.Float32x4.xwzx;
  static const xwzy = typed_data.Float32x4.xwzy;
  static const xwzz = typed_data.Float32x4.xwzz;
  static const xwzw = typed_data.Float32x4.xwzw;
  static const xwwx = typed_data.Float32x4.xwwx;
  static const xwwy = typed_data.Float32x4.xwwy;
  static const xwwz = typed_data.Float32x4.xwwz;
  static const xwww = typed_data.Float32x4.xwww;
  static const yxxx = typed_data.Float32x4.yxxx;
  static const yxxy = typed_data.Float32x4.yxxy;
  static const yxxz = typed_data.Float32x4.yxxz;
  static const yxxw = typed_data.Float32x4.yxxw;
  static const yxyx = typed_data.Float32x4.yxyx;
  static const yxyy = typed_data.Float32x4.yxyy;
  static const yxyz = typed_data.Float32x4.yxyz;
  static const yxyw = typed_data.Float32x4.yxyw;
  static const yxzx = typed_data.Float32x4.yxzx;
  static const yxzy = typed_data.Float32x4.yxzy;
  static const yxzz = typed_data.Float32x4.yxzz;
  static const yxzw = typed_data.Float32x4.yxzw;
  static const yxwx = typed_data.Float32x4.yxwx;
  static const yxwy = typed_data.Float32x4.yxwy;
  static const yxwz = typed_data.Float32x4.yxwz;
  static const yxww = typed_data.Float32x4.yxww;
  static const yyxx = typed_data.Float32x4.yyxx;
  static const yyxy = typed_data.Float32x4.yyxy;
  static const yyxz = typed_data.Float32x4.yyxz;
  static const yyxw = typed_data.Float32x4.yyxw;
  static const yyyx = typed_data.Float32x4.yyyx;
  static const yyyy = typed_data.Float32x4.yyyy;
  static const yyyz = typed_data.Float32x4.yyyz;
  static const yyyw = typed_data.Float32x4.yyyw;
  static const yyzx = typed_data.Float32x4.yyzx;
  static const yyzy = typed_data.Float32x4.yyzy;
  static const yyzz = typed_data.Float32x4.yyzz;
  static const yyzw = typed_data.Float32x4.yyzw;
  static const yywx = typed_data.Float32x4.yywx;
  static const yywy = typed_data.Float32x4.yywy;
  static const yywz = typed_data.Float32x4.yywz;
  static const yyww = typed_data.Float32x4.yyww;
  static const yzxx = typed_data.Float32x4.yzxx;
  static const yzxy = typed_data.Float32x4.yzxy;
  static const yzxz = typed_data.Float32x4.yzxz;
  static const yzxw = typed_data.Float32x4.yzxw;
  static const yzyx = typed_data.Float32x4.yzyx;
  static const yzyy = typed_data.Float32x4.yzyy;
  static const yzyz = typed_data.Float32x4.yzyz;
  static const yzyw = typed_data.Float32x4.yzyw;
  static const yzzx = typed_data.Float32x4.yzzx;
  static const yzzy = typed_data.Float32x4.yzzy;
  static const yzzz = typed_data.Float32x4.yzzz;
  static const yzzw = typed_data.Float32x4.yzzw;
  static const yzwx = typed_data.Float32x4.yzwx;
  static const yzwy = typed_data.Float32x4.yzwy;
  static const yzwz = typed_data.Float32x4.yzwz;
  static const yzww = typed_data.Float32x4.yzww;
  static const ywxx = typed_data.Float32x4.ywxx;
  static const ywxy = typed_data.Float32x4.ywxy;
  static const ywxz = typed_data.Float32x4.ywxz;
  static const ywxw = typed_data.Float32x4.ywxw;
  static const ywyx = typed_data.Float32x4.ywyx;
  static const ywyy = typed_data.Float32x4.ywyy;
  static const ywyz = typed_data.Float32x4.ywyz;
  static const ywyw = typed_data.Float32x4.ywyw;
  static const ywzx = typed_data.Float32x4.ywzx;
  static const ywzy = typed_data.Float32x4.ywzy;
  static const ywzz = typed_data.Float32x4.ywzz;
  static const ywzw = typed_data.Float32x4.ywzw;
  static const ywwx = typed_data.Float32x4.ywwx;
  static const ywwy = typed_data.Float32x4.ywwy;
  static const ywwz = typed_data.Float32x4.ywwz;
  static const ywww = typed_data.Float32x4.ywww;
  static const zxxx = typed_data.Float32x4.zxxx;
  static const zxxy = typed_data.Float32x4.zxxy;
  static const zxxz = typed_data.Float32x4.zxxz;
  static const zxxw = typed_data.Float32x4.zxxw;
  static const zxyx = typed_data.Float32x4.zxyx;
  static const zxyy = typed_data.Float32x4.zxyy;
  static const zxyz = typed_data.Float32x4.zxyz;
  static const zxyw = typed_data.Float32x4.zxyw;
  static const zxzx = typed_data.Float32x4.zxzx;
  static const zxzy = typed_data.Float32x4.zxzy;
  static const zxzz = typed_data.Float32x4.zxzz;
  static const zxzw = typed_data.Float32x4.zxzw;
  static const zxwx = typed_data.Float32x4.zxwx;
  static const zxwy = typed_data.Float32x4.zxwy;
  static const zxwz = typed_data.Float32x4.zxwz;
  static const zxww = typed_data.Float32x4.zxww;
  static const zyxx = typed_data.Float32x4.zyxx;
  static const zyxy = typed_data.Float32x4.zyxy;
  static const zyxz = typed_data.Float32x4.zyxz;
  static const zyxw = typed_data.Float32x4.zyxw;
  static const zyyx = typed_data.Float32x4.zyyx;
  static const zyyy = typed_data.Float32x4.zyyy;
  static const zyyz = typed_data.Float32x4.zyyz;
  static const zyyw = typed_data.Float32x4.zyyw;
  static const zyzx = typed_data.Float32x4.zyzx;
  static const zyzy = typed_data.Float32x4.zyzy;
  static const zyzz = typed_data.Float32x4.zyzz;
  static const zyzw = typed_data.Float32x4.zyzw;
  static const zywx = typed_data.Float32x4.zywx;
  static const zywy = typed_data.Float32x4.zywy;
  static const zywz = typed_data.Float32x4.zywz;
  static const zyww = typed_data.Float32x4.zyww;
  static const zzxx = typed_data.Float32x4.zzxx;
  static const zzxy = typed_data.Float32x4.zzxy;
  static const zzxz = typed_data.Float32x4.zzxz;
  static const zzxw = typed_data.Float32x4.zzxw;
  static const zzyx = typed_data.Float32x4.zzyx;
  static const zzyy = typed_data.Float32x4.zzyy;
  static const zzyz = typed_data.Float32x4.zzyz;
  static const zzyw = typed_data.Float32x4.zzyw;
  static const zzzx = typed_data.Float32x4.zzzx;
  static const zzzy = typed_data.Float32x4.zzzy;
  static const zzzz = typed_data.Float32x4.zzzz;
  static const zzzw = typed_data.Float32x4.zzzw;
  static const zzwx = typed_data.Float32x4.zzwx;
  static const zzwy = typed_data.Float32x4.zzwy;
  static const zzwz = typed_data.Float32x4.zzwz;
  static const zzww = typed_data.Float32x4.zzww;
  static const zwxx = typed_data.Float32x4.zwxx;
  static const zwxy = typed_data.Float32x4.zwxy;
  static const zwxz = typed_data.Float32x4.zwxz;
  static const zwxw = typed_data.Float32x4.zwxw;
  static const zwyx = typed_data.Float32x4.zwyx;
  static const zwyy = typed_data.Float32x4.zwyy;
  static const zwyz = typed_data.Float32x4.zwyz;
  static const zwyw = typed_data.Float32x4.zwyw;
  static const zwzx = typed_data.Float32x4.zwzx;
  static const zwzy = typed_data.Float32x4.zwzy;
  static const zwzz = typed_data.Float32x4.zwzz;
  static const zwzw = typed_data.Float32x4.zwzw;
  static const zwwx = typed_data.Float32x4.zwwx;
  static const zwwy = typed_data.Float32x4.zwwy;
  static const zwwz = typed_data.Float32x4.zwwz;
  static const zwww = typed_data.Float32x4.zwww;
  static const wxxx = typed_data.Float32x4.wxxx;
  static const wxxy = typed_data.Float32x4.wxxy;
  static const wxxz = typed_data.Float32x4.wxxz;
  static const wxxw = typed_data.Float32x4.wxxw;
  static const wxyx = typed_data.Float32x4.wxyx;
  static const wxyy = typed_data.Float32x4.wxyy;
  static const wxyz = typed_data.Float32x4.wxyz;
  static const wxyw = typed_data.Float32x4.wxyw;
  static const wxzx = typed_data.Float32x4.wxzx;
  static const wxzy = typed_data.Float32x4.wxzy;
  static const wxzz = typed_data.Float32x4.wxzz;
  static const wxzw = typed_data.Float32x4.wxzw;
  static const wxwx = typed_data.Float32x4.wxwx;
  static const wxwy = typed_data.Float32x4.wxwy;
  static const wxwz = typed_data.Float32x4.wxwz;
  static const wxww = typed_data.Float32x4.wxww;
  static const wyxx = typed_data.Float32x4.wyxx;
  static const wyxy = typed_data.Float32x4.wyxy;
  static const wyxz = typed_data.Float32x4.wyxz;
  static const wyxw = typed_data.Float32x4.wyxw;
  static const wyyx = typed_data.Float32x4.wyyx;
  static const wyyy = typed_data.Float32x4.wyyy;
  static const wyyz = typed_data.Float32x4.wyyz;
  static const wyyw = typed_data.Float32x4.wyyw;
  static const wyzx = typed_data.Float32x4.wyzx;
  static const wyzy = typed_data.Float32x4.wyzy;
  static const wyzz = typed_data.Float32x4.wyzz;
  static const wyzw = typed_data.Float32x4.wyzw;
  static const wywx = typed_data.Float32x4.wywx;
  static const wywy = typed_data.Float32x4.wywy;
  static const wywz = typed_data.Float32x4.wywz;
  static const wyww = typed_data.Float32x4.wyww;
  static const wzxx = typed_data.Float32x4.wzxx;
  static const wzxy = typed_data.Float32x4.wzxy;
  static const wzxz = typed_data.Float32x4.wzxz;
  static const wzxw = typed_data.Float32x4.wzxw;
  static const wzyx = typed_data.Float32x4.wzyx;
  static const wzyy = typed_data.Float32x4.wzyy;
  static const wzyz = typed_data.Float32x4.wzyz;
  static const wzyw = typed_data.Float32x4.wzyw;
  static const wzzx = typed_data.Float32x4.wzzx;
  static const wzzy = typed_data.Float32x4.wzzy;
  static const wzzz = typed_data.Float32x4.wzzz;
  static const wzzw = typed_data.Float32x4.wzzw;
  static const wzwx = typed_data.Float32x4.wzwx;
  static const wzwy = typed_data.Float32x4.wzwy;
  static const wzwz = typed_data.Float32x4.wzwz;
  static const wzww = typed_data.Float32x4.wzww;
  static const wwxx = typed_data.Float32x4.wwxx;
  static const wwxy = typed_data.Float32x4.wwxy;
  static const wwxz = typed_data.Float32x4.wwxz;
  static const wwxw = typed_data.Float32x4.wwxw;
  static const wwyx = typed_data.Float32x4.wwyx;
  static const wwyy = typed_data.Float32x4.wwyy;
  static const wwyz = typed_data.Float32x4.wwyz;
  static const wwyw = typed_data.Float32x4.wwyw;
  static const wwzx = typed_data.Float32x4.wwzx;
  static const wwzy = typed_data.Float32x4.wwzy;
  static const wwzz = typed_data.Float32x4.wwzz;
  static const wwzw = typed_data.Float32x4.wwzw;
  static const wwwx = typed_data.Float32x4.wwwx;
  static const wwwy = typed_data.Float32x4.wwwy;
  static const wwwz = typed_data.Float32x4.wwwz;
  static const wwww = typed_data.Float32x4.wwww;
}

abstract class Int32x4 {
  static const xxxx = typed_data.Int32x4.xxxx;
  static const xxxy = typed_data.Int32x4.xxxy;
  static const xxxz = typed_data.Int32x4.xxxz;
  static const xxxw = typed_data.Int32x4.xxxw;
  static const xxyx = typed_data.Int32x4.xxyx;
  static const xxyy = typed_data.Int32x4.xxyy;
  static const xxyz = typed_data.Int32x4.xxyz;
  static const xxyw = typed_data.Int32x4.xxyw;
  static const xxzx = typed_data.Int32x4.xxzx;
  static const xxzy = typed_data.Int32x4.xxzy;
  static const xxzz = typed_data.Int32x4.xxzz;
  static const xxzw = typed_data.Int32x4.xxzw;
  static const xxwx = typed_data.Int32x4.xxwx;
  static const xxwy = typed_data.Int32x4.xxwy;
  static const xxwz = typed_data.Int32x4.xxwz;
  static const xxww = typed_data.Int32x4.xxww;
  static const xyxx = typed_data.Int32x4.xyxx;
  static const xyxy = typed_data.Int32x4.xyxy;
  static const xyxz = typed_data.Int32x4.xyxz;
  static const xyxw = typed_data.Int32x4.xyxw;
  static const xyyx = typed_data.Int32x4.xyyx;
  static const xyyy = typed_data.Int32x4.xyyy;
  static const xyyz = typed_data.Int32x4.xyyz;
  static const xyyw = typed_data.Int32x4.xyyw;
  static const xyzx = typed_data.Int32x4.xyzx;
  static const xyzy = typed_data.Int32x4.xyzy;
  static const xyzz = typed_data.Int32x4.xyzz;
  static const xyzw = typed_data.Int32x4.xyzw;
  static const xywx = typed_data.Int32x4.xywx;
  static const xywy = typed_data.Int32x4.xywy;
  static const xywz = typed_data.Int32x4.xywz;
  static const xyww = typed_data.Int32x4.xyww;
  static const xzxx = typed_data.Int32x4.xzxx;
  static const xzxy = typed_data.Int32x4.xzxy;
  static const xzxz = typed_data.Int32x4.xzxz;
  static const xzxw = typed_data.Int32x4.xzxw;
  static const xzyx = typed_data.Int32x4.xzyx;
  static const xzyy = typed_data.Int32x4.xzyy;
  static const xzyz = typed_data.Int32x4.xzyz;
  static const xzyw = typed_data.Int32x4.xzyw;
  static const xzzx = typed_data.Int32x4.xzzx;
  static const xzzy = typed_data.Int32x4.xzzy;
  static const xzzz = typed_data.Int32x4.xzzz;
  static const xzzw = typed_data.Int32x4.xzzw;
  static const xzwx = typed_data.Int32x4.xzwx;
  static const xzwy = typed_data.Int32x4.xzwy;
  static const xzwz = typed_data.Int32x4.xzwz;
  static const xzww = typed_data.Int32x4.xzww;
  static const xwxx = typed_data.Int32x4.xwxx;
  static const xwxy = typed_data.Int32x4.xwxy;
  static const xwxz = typed_data.Int32x4.xwxz;
  static const xwxw = typed_data.Int32x4.xwxw;
  static const xwyx = typed_data.Int32x4.xwyx;
  static const xwyy = typed_data.Int32x4.xwyy;
  static const xwyz = typed_data.Int32x4.xwyz;
  static const xwyw = typed_data.Int32x4.xwyw;
  static const xwzx = typed_data.Int32x4.xwzx;
  static const xwzy = typed_data.Int32x4.xwzy;
  static const xwzz = typed_data.Int32x4.xwzz;
  static const xwzw = typed_data.Int32x4.xwzw;
  static const xwwx = typed_data.Int32x4.xwwx;
  static const xwwy = typed_data.Int32x4.xwwy;
  static const xwwz = typed_data.Int32x4.xwwz;
  static const xwww = typed_data.Int32x4.xwww;
  static const yxxx = typed_data.Int32x4.yxxx;
  static const yxxy = typed_data.Int32x4.yxxy;
  static const yxxz = typed_data.Int32x4.yxxz;
  static const yxxw = typed_data.Int32x4.yxxw;
  static const yxyx = typed_data.Int32x4.yxyx;
  static const yxyy = typed_data.Int32x4.yxyy;
  static const yxyz = typed_data.Int32x4.yxyz;
  static const yxyw = typed_data.Int32x4.yxyw;
  static const yxzx = typed_data.Int32x4.yxzx;
  static const yxzy = typed_data.Int32x4.yxzy;
  static const yxzz = typed_data.Int32x4.yxzz;
  static const yxzw = typed_data.Int32x4.yxzw;
  static const yxwx = typed_data.Int32x4.yxwx;
  static const yxwy = typed_data.Int32x4.yxwy;
  static const yxwz = typed_data.Int32x4.yxwz;
  static const yxww = typed_data.Int32x4.yxww;
  static const yyxx = typed_data.Int32x4.yyxx;
  static const yyxy = typed_data.Int32x4.yyxy;
  static const yyxz = typed_data.Int32x4.yyxz;
  static const yyxw = typed_data.Int32x4.yyxw;
  static const yyyx = typed_data.Int32x4.yyyx;
  static const yyyy = typed_data.Int32x4.yyyy;
  static const yyyz = typed_data.Int32x4.yyyz;
  static const yyyw = typed_data.Int32x4.yyyw;
  static const yyzx = typed_data.Int32x4.yyzx;
  static const yyzy = typed_data.Int32x4.yyzy;
  static const yyzz = typed_data.Int32x4.yyzz;
  static const yyzw = typed_data.Int32x4.yyzw;
  static const yywx = typed_data.Int32x4.yywx;
  static const yywy = typed_data.Int32x4.yywy;
  static const yywz = typed_data.Int32x4.yywz;
  static const yyww = typed_data.Int32x4.yyww;
  static const yzxx = typed_data.Int32x4.yzxx;
  static const yzxy = typed_data.Int32x4.yzxy;
  static const yzxz = typed_data.Int32x4.yzxz;
  static const yzxw = typed_data.Int32x4.yzxw;
  static const yzyx = typed_data.Int32x4.yzyx;
  static const yzyy = typed_data.Int32x4.yzyy;
  static const yzyz = typed_data.Int32x4.yzyz;
  static const yzyw = typed_data.Int32x4.yzyw;
  static const yzzx = typed_data.Int32x4.yzzx;
  static const yzzy = typed_data.Int32x4.yzzy;
  static const yzzz = typed_data.Int32x4.yzzz;
  static const yzzw = typed_data.Int32x4.yzzw;
  static const yzwx = typed_data.Int32x4.yzwx;
  static const yzwy = typed_data.Int32x4.yzwy;
  static const yzwz = typed_data.Int32x4.yzwz;
  static const yzww = typed_data.Int32x4.yzww;
  static const ywxx = typed_data.Int32x4.ywxx;
  static const ywxy = typed_data.Int32x4.ywxy;
  static const ywxz = typed_data.Int32x4.ywxz;
  static const ywxw = typed_data.Int32x4.ywxw;
  static const ywyx = typed_data.Int32x4.ywyx;
  static const ywyy = typed_data.Int32x4.ywyy;
  static const ywyz = typed_data.Int32x4.ywyz;
  static const ywyw = typed_data.Int32x4.ywyw;
  static const ywzx = typed_data.Int32x4.ywzx;
  static const ywzy = typed_data.Int32x4.ywzy;
  static const ywzz = typed_data.Int32x4.ywzz;
  static const ywzw = typed_data.Int32x4.ywzw;
  static const ywwx = typed_data.Int32x4.ywwx;
  static const ywwy = typed_data.Int32x4.ywwy;
  static const ywwz = typed_data.Int32x4.ywwz;
  static const ywww = typed_data.Int32x4.ywww;
  static const zxxx = typed_data.Int32x4.zxxx;
  static const zxxy = typed_data.Int32x4.zxxy;
  static const zxxz = typed_data.Int32x4.zxxz;
  static const zxxw = typed_data.Int32x4.zxxw;
  static const zxyx = typed_data.Int32x4.zxyx;
  static const zxyy = typed_data.Int32x4.zxyy;
  static const zxyz = typed_data.Int32x4.zxyz;
  static const zxyw = typed_data.Int32x4.zxyw;
  static const zxzx = typed_data.Int32x4.zxzx;
  static const zxzy = typed_data.Int32x4.zxzy;
  static const zxzz = typed_data.Int32x4.zxzz;
  static const zxzw = typed_data.Int32x4.zxzw;
  static const zxwx = typed_data.Int32x4.zxwx;
  static const zxwy = typed_data.Int32x4.zxwy;
  static const zxwz = typed_data.Int32x4.zxwz;
  static const zxww = typed_data.Int32x4.zxww;
  static const zyxx = typed_data.Int32x4.zyxx;
  static const zyxy = typed_data.Int32x4.zyxy;
  static const zyxz = typed_data.Int32x4.zyxz;
  static const zyxw = typed_data.Int32x4.zyxw;
  static const zyyx = typed_data.Int32x4.zyyx;
  static const zyyy = typed_data.Int32x4.zyyy;
  static const zyyz = typed_data.Int32x4.zyyz;
  static const zyyw = typed_data.Int32x4.zyyw;
  static const zyzx = typed_data.Int32x4.zyzx;
  static const zyzy = typed_data.Int32x4.zyzy;
  static const zyzz = typed_data.Int32x4.zyzz;
  static const zyzw = typed_data.Int32x4.zyzw;
  static const zywx = typed_data.Int32x4.zywx;
  static const zywy = typed_data.Int32x4.zywy;
  static const zywz = typed_data.Int32x4.zywz;
  static const zyww = typed_data.Int32x4.zyww;
  static const zzxx = typed_data.Int32x4.zzxx;
  static const zzxy = typed_data.Int32x4.zzxy;
  static const zzxz = typed_data.Int32x4.zzxz;
  static const zzxw = typed_data.Int32x4.zzxw;
  static const zzyx = typed_data.Int32x4.zzyx;
  static const zzyy = typed_data.Int32x4.zzyy;
  static const zzyz = typed_data.Int32x4.zzyz;
  static const zzyw = typed_data.Int32x4.zzyw;
  static const zzzx = typed_data.Int32x4.zzzx;
  static const zzzy = typed_data.Int32x4.zzzy;
  static const zzzz = typed_data.Int32x4.zzzz;
  static const zzzw = typed_data.Int32x4.zzzw;
  static const zzwx = typed_data.Int32x4.zzwx;
  static const zzwy = typed_data.Int32x4.zzwy;
  static const zzwz = typed_data.Int32x4.zzwz;
  static const zzww = typed_data.Int32x4.zzww;
  static const zwxx = typed_data.Int32x4.zwxx;
  static const zwxy = typed_data.Int32x4.zwxy;
  static const zwxz = typed_data.Int32x4.zwxz;
  static const zwxw = typed_data.Int32x4.zwxw;
  static const zwyx = typed_data.Int32x4.zwyx;
  static const zwyy = typed_data.Int32x4.zwyy;
  static const zwyz = typed_data.Int32x4.zwyz;
  static const zwyw = typed_data.Int32x4.zwyw;
  static const zwzx = typed_data.Int32x4.zwzx;
  static const zwzy = typed_data.Int32x4.zwzy;
  static const zwzz = typed_data.Int32x4.zwzz;
  static const zwzw = typed_data.Int32x4.zwzw;
  static const zwwx = typed_data.Int32x4.zwwx;
  static const zwwy = typed_data.Int32x4.zwwy;
  static const zwwz = typed_data.Int32x4.zwwz;
  static const zwww = typed_data.Int32x4.zwww;
  static const wxxx = typed_data.Int32x4.wxxx;
  static const wxxy = typed_data.Int32x4.wxxy;
  static const wxxz = typed_data.Int32x4.wxxz;
  static const wxxw = typed_data.Int32x4.wxxw;
  static const wxyx = typed_data.Int32x4.wxyx;
  static const wxyy = typed_data.Int32x4.wxyy;
  static const wxyz = typed_data.Int32x4.wxyz;
  static const wxyw = typed_data.Int32x4.wxyw;
  static const wxzx = typed_data.Int32x4.wxzx;
  static const wxzy = typed_data.Int32x4.wxzy;
  static const wxzz = typed_data.Int32x4.wxzz;
  static const wxzw = typed_data.Int32x4.wxzw;
  static const wxwx = typed_data.Int32x4.wxwx;
  static const wxwy = typed_data.Int32x4.wxwy;
  static const wxwz = typed_data.Int32x4.wxwz;
  static const wxww = typed_data.Int32x4.wxww;
  static const wyxx = typed_data.Int32x4.wyxx;
  static const wyxy = typed_data.Int32x4.wyxy;
  static const wyxz = typed_data.Int32x4.wyxz;
  static const wyxw = typed_data.Int32x4.wyxw;
  static const wyyx = typed_data.Int32x4.wyyx;
  static const wyyy = typed_data.Int32x4.wyyy;
  static const wyyz = typed_data.Int32x4.wyyz;
  static const wyyw = typed_data.Int32x4.wyyw;
  static const wyzx = typed_data.Int32x4.wyzx;
  static const wyzy = typed_data.Int32x4.wyzy;
  static const wyzz = typed_data.Int32x4.wyzz;
  static const wyzw = typed_data.Int32x4.wyzw;
  static const wywx = typed_data.Int32x4.wywx;
  static const wywy = typed_data.Int32x4.wywy;
  static const wywz = typed_data.Int32x4.wywz;
  static const wyww = typed_data.Int32x4.wyww;
  static const wzxx = typed_data.Int32x4.wzxx;
  static const wzxy = typed_data.Int32x4.wzxy;
  static const wzxz = typed_data.Int32x4.wzxz;
  static const wzxw = typed_data.Int32x4.wzxw;
  static const wzyx = typed_data.Int32x4.wzyx;
  static const wzyy = typed_data.Int32x4.wzyy;
  static const wzyz = typed_data.Int32x4.wzyz;
  static const wzyw = typed_data.Int32x4.wzyw;
  static const wzzx = typed_data.Int32x4.wzzx;
  static const wzzy = typed_data.Int32x4.wzzy;
  static const wzzz = typed_data.Int32x4.wzzz;
  static const wzzw = typed_data.Int32x4.wzzw;
  static const wzwx = typed_data.Int32x4.wzwx;
  static const wzwy = typed_data.Int32x4.wzwy;
  static const wzwz = typed_data.Int32x4.wzwz;
  static const wzww = typed_data.Int32x4.wzww;
  static const wwxx = typed_data.Int32x4.wwxx;
  static const wwxy = typed_data.Int32x4.wwxy;
  static const wwxz = typed_data.Int32x4.wwxz;
  static const wwxw = typed_data.Int32x4.wwxw;
  static const wwyx = typed_data.Int32x4.wwyx;
  static const wwyy = typed_data.Int32x4.wwyy;
  static const wwyz = typed_data.Int32x4.wwyz;
  static const wwyw = typed_data.Int32x4.wwyw;
  static const wwzx = typed_data.Int32x4.wwzx;
  static const wwzy = typed_data.Int32x4.wwzy;
  static const wwzz = typed_data.Int32x4.wwzz;
  static const wwzw = typed_data.Int32x4.wwzw;
  static const wwwx = typed_data.Int32x4.wwwx;
  static const wwwy = typed_data.Int32x4.wwwy;
  static const wwwz = typed_data.Int32x4.wwwz;
  static const wwww = typed_data.Int32x4.wwww;
}
