/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import io.flutter.app.FlutterPluginRegistry;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.view.FlutterRunArguments;
import io.flutter.view.FlutterView;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FlutterNativeView
implements BinaryMessenger {
    private static final String TAG = "FlutterNativeView";
    private final Map<String, BinaryMessenger.BinaryMessageHandler> mMessageHandlers;
    private int mNextReplyId = 1;
    private final Map<Integer, BinaryMessenger.BinaryReply> mPendingReplies = new HashMap<Integer, BinaryMessenger.BinaryReply>();
    private final FlutterPluginRegistry mPluginRegistry;
    private long mNativePlatformView;
    private FlutterView mFlutterView;
    private final Context mContext;
    private boolean applicationIsRunning;

    public FlutterNativeView(Context context) {
        this(context, false);
    }

    public FlutterNativeView(Context context, boolean isBackgroundView) {
        this.mContext = context;
        this.mPluginRegistry = new FlutterPluginRegistry(this, context);
        this.attach(this, isBackgroundView);
        this.assertAttached();
        this.mMessageHandlers = new HashMap<String, BinaryMessenger.BinaryMessageHandler>();
    }

    public void detach() {
        this.mPluginRegistry.detach();
        this.mFlutterView = null;
        FlutterNativeView.nativeDetach(this.mNativePlatformView);
    }

    public void destroy() {
        this.mPluginRegistry.destroy();
        this.mFlutterView = null;
        FlutterNativeView.nativeDestroy(this.mNativePlatformView);
        this.mNativePlatformView = 0L;
        this.applicationIsRunning = false;
    }

    public FlutterPluginRegistry getPluginRegistry() {
        return this.mPluginRegistry;
    }

    public void attachViewAndActivity(FlutterView flutterView, Activity activity) {
        this.mFlutterView = flutterView;
        this.mPluginRegistry.attach(flutterView, activity);
    }

    public boolean isAttached() {
        return this.mNativePlatformView != 0L;
    }

    public long get() {
        return this.mNativePlatformView;
    }

    public void assertAttached() {
        if (!this.isAttached()) {
            throw new AssertionError((Object)"Platform view is not attached");
        }
    }

    public void runFromBundle(FlutterRunArguments args) {
        if (args.bundlePath == null) {
            throw new AssertionError((Object)"A bundlePath must be specified");
        }
        if (args.entrypoint == null) {
            throw new AssertionError((Object)"An entrypoint must be specified");
        }
        this.runFromBundleInternal(args.bundlePath, args.entrypoint, args.libraryPath, args.defaultPath);
    }

    @Deprecated
    public void runFromBundle(String bundlePath, String defaultPath, String entrypoint, boolean reuseRuntimeController) {
        this.runFromBundleInternal(bundlePath, entrypoint, null, defaultPath);
    }

    private void runFromBundleInternal(String bundlePath, String entrypoint, String libraryPath, String defaultPath) {
        this.assertAttached();
        if (this.applicationIsRunning) {
            throw new AssertionError((Object)"This Flutter engine instance is already running an application");
        }
        FlutterNativeView.nativeRunBundleAndSnapshotFromLibrary(this.mNativePlatformView, bundlePath, defaultPath, entrypoint, libraryPath, this.mContext.getResources().getAssets());
        this.applicationIsRunning = true;
    }

    public boolean isApplicationRunning() {
        return this.applicationIsRunning;
    }

    public static String getObservatoryUri() {
        return FlutterNativeView.nativeGetObservatoryUri();
    }

    @Override
    public void send(String channel, ByteBuffer message) {
        this.send(channel, message, null);
    }

    @Override
    public void send(String channel, ByteBuffer message, BinaryMessenger.BinaryReply callback) {
        if (!this.isAttached()) {
            Log.d((String)TAG, (String)("FlutterView.send called on a detached view, channel=" + channel));
            return;
        }
        int replyId = 0;
        if (callback != null) {
            replyId = this.mNextReplyId++;
            this.mPendingReplies.put(replyId, callback);
        }
        if (message == null) {
            FlutterNativeView.nativeDispatchEmptyPlatformMessage(this.mNativePlatformView, channel, replyId);
        } else {
            FlutterNativeView.nativeDispatchPlatformMessage(this.mNativePlatformView, channel, message, message.position(), replyId);
        }
    }

    @Override
    public void setMessageHandler(String channel, BinaryMessenger.BinaryMessageHandler handler) {
        if (handler == null) {
            this.mMessageHandlers.remove(channel);
        } else {
            this.mMessageHandlers.put(channel, handler);
        }
    }

    private void attach(FlutterNativeView view, boolean isBackgroundView) {
        this.mNativePlatformView = FlutterNativeView.nativeAttach(view, isBackgroundView);
    }

    private void handlePlatformMessage(final String channel, byte[] message, final int replyId) {
        this.assertAttached();
        BinaryMessenger.BinaryMessageHandler handler = this.mMessageHandlers.get(channel);
        if (handler != null) {
            try {
                ByteBuffer buffer = message == null ? null : ByteBuffer.wrap(message);
                handler.onMessage(buffer, new BinaryMessenger.BinaryReply(){
                    private final AtomicBoolean done = new AtomicBoolean(false);

                    @Override
                    public void reply(ByteBuffer reply) {
                        if (!FlutterNativeView.this.isAttached()) {
                            Log.d((String)FlutterNativeView.TAG, (String)("handlePlatformMessage replying to a detached view, channel=" + channel));
                            return;
                        }
                        if (this.done.getAndSet(true)) {
                            throw new IllegalStateException("Reply already submitted");
                        }
                        if (reply == null) {
                            FlutterNativeView.nativeInvokePlatformMessageEmptyResponseCallback(FlutterNativeView.this.mNativePlatformView, replyId);
                        } else {
                            FlutterNativeView.nativeInvokePlatformMessageResponseCallback(FlutterNativeView.this.mNativePlatformView, replyId, reply, reply.position());
                        }
                    }
                });
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Uncaught exception in binary message listener", (Throwable)ex);
                FlutterNativeView.nativeInvokePlatformMessageEmptyResponseCallback(this.mNativePlatformView, replyId);
            }
            return;
        }
        FlutterNativeView.nativeInvokePlatformMessageEmptyResponseCallback(this.mNativePlatformView, replyId);
    }

    private void handlePlatformMessageResponse(int replyId, byte[] reply) {
        BinaryMessenger.BinaryReply callback = this.mPendingReplies.remove(replyId);
        if (callback != null) {
            try {
                callback.reply(reply == null ? null : ByteBuffer.wrap(reply));
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Uncaught exception in binary message reply handler", (Throwable)ex);
            }
        }
    }

    private void updateSemantics(ByteBuffer buffer, String[] strings) {
        if (this.mFlutterView == null) {
            return;
        }
        this.mFlutterView.updateSemantics(buffer, strings);
    }

    private void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
        if (this.mFlutterView == null) {
            return;
        }
        this.mFlutterView.updateCustomAccessibilityActions(buffer, strings);
    }

    private void onFirstFrame() {
        if (this.mFlutterView == null) {
            return;
        }
        this.mFlutterView.onFirstFrame();
    }

    private void onPreEngineRestart() {
        if (this.mFlutterView != null) {
            this.mFlutterView.resetAccessibilityTree();
        }
        if (this.mPluginRegistry == null) {
            return;
        }
        this.mPluginRegistry.onPreEngineRestart();
    }

    private static native long nativeAttach(FlutterNativeView var0, boolean var1);

    private static native void nativeDestroy(long var0);

    private static native void nativeDetach(long var0);

    private static native void nativeRunBundleAndSnapshotFromLibrary(long var0, String var2, String var3, String var4, String var5, AssetManager var6);

    private static native String nativeGetObservatoryUri();

    private static native void nativeDispatchEmptyPlatformMessage(long var0, String var2, int var3);

    private static native void nativeDispatchPlatformMessage(long var0, String var2, ByteBuffer var3, int var4, int var5);

    private static native void nativeInvokePlatformMessageEmptyResponseCallback(long var0, int var2);

    private static native void nativeInvokePlatformMessageResponseCallback(long var0, int var2, ByteBuffer var3, int var4);
}

