/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.graphics.Rect;
import android.opengl.Matrix;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.view.FlutterView;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AccessibilityBridge
extends AccessibilityNodeProvider
implements BasicMessageChannel.MessageHandler<Object> {
    private static final String TAG = "FlutterView";
    private static final int ACTION_SHOW_ON_SCREEN = 16908342;
    private static final float SCROLL_EXTENT_FOR_INFINITY = 100000.0f;
    private static final float SCROLL_POSITION_CAP_FOR_INFINITY = 70000.0f;
    private Map<Integer, SemanticsObject> mObjects;
    private final FlutterView mOwner;
    private boolean mAccessibilityEnabled = false;
    private SemanticsObject mA11yFocusedObject;
    private SemanticsObject mInputFocusedObject;
    private SemanticsObject mHoveredObject;
    private final BasicMessageChannel<Object> mFlutterAccessibilityChannel;

    AccessibilityBridge(FlutterView owner) {
        assert (owner != null);
        this.mOwner = owner;
        this.mObjects = new HashMap<Integer, SemanticsObject>();
        this.mFlutterAccessibilityChannel = new BasicMessageChannel<Object>(owner, "flutter/accessibility", StandardMessageCodec.INSTANCE);
    }

    void setAccessibilityEnabled(boolean accessibilityEnabled) {
        this.mAccessibilityEnabled = accessibilityEnabled;
        if (accessibilityEnabled) {
            this.mFlutterAccessibilityChannel.setMessageHandler(this);
        } else {
            this.mFlutterAccessibilityChannel.setMessageHandler(null);
        }
    }

    public AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
        if (virtualViewId == -1) {
            AccessibilityNodeInfo result = AccessibilityNodeInfo.obtain((View)this.mOwner);
            this.mOwner.onInitializeAccessibilityNodeInfo(result);
            if (this.mObjects.containsKey(0)) {
                result.addChild((View)this.mOwner, 0);
            }
            return result;
        }
        SemanticsObject object = this.mObjects.get(virtualViewId);
        if (object == null) {
            return null;
        }
        AccessibilityNodeInfo result = AccessibilityNodeInfo.obtain((View)this.mOwner, (int)virtualViewId);
        result.setPackageName((CharSequence)this.mOwner.getContext().getPackageName());
        result.setClassName((CharSequence)"android.view.View");
        result.setSource((View)this.mOwner, virtualViewId);
        result.setFocusable(object.isFocusable());
        if (this.mInputFocusedObject != null) {
            result.setFocused(this.mInputFocusedObject.id == virtualViewId);
        }
        if (this.mA11yFocusedObject != null) {
            result.setAccessibilityFocused(this.mA11yFocusedObject.id == virtualViewId);
        }
        if (object.hasFlag(Flag.IS_TEXT_FIELD)) {
            result.setClassName((CharSequence)"android.widget.EditText");
            if (Build.VERSION.SDK_INT >= 18) {
                result.setEditable(true);
                if (object.textSelectionBase != -1 && object.textSelectionExtent != -1) {
                    result.setTextSelection(object.textSelectionBase, object.textSelectionExtent);
                }
            }
            int granularities = 0;
            if (object.hasAction(Action.MOVE_CURSOR_FORWARD_BY_CHARACTER)) {
                result.addAction(256);
                granularities |= 1;
            }
            if (object.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER)) {
                result.addAction(512);
                granularities |= 1;
            }
            result.setMovementGranularities(granularities);
        }
        if (object.hasAction(Action.SET_SELECTION)) {
            result.addAction(131072);
        }
        if (object.hasAction(Action.COPY)) {
            result.addAction(16384);
        }
        if (object.hasAction(Action.CUT)) {
            result.addAction(65536);
        }
        if (object.hasAction(Action.PASTE)) {
            result.addAction(32768);
        }
        if (object.hasFlag(Flag.IS_BUTTON)) {
            result.setClassName((CharSequence)"android.widget.Button");
        }
        if (object.parent != null) {
            assert (object.id > 0);
            result.setParent((View)this.mOwner, object.parent.id);
        } else {
            assert (object.id == 0);
            result.setParent((View)this.mOwner);
        }
        Rect bounds = object.getGlobalRect();
        if (object.parent != null) {
            Rect parentBounds = object.parent.getGlobalRect();
            Rect boundsInParent = new Rect(bounds);
            boundsInParent.offset(-parentBounds.left, -parentBounds.top);
            result.setBoundsInParent(boundsInParent);
        } else {
            result.setBoundsInParent(bounds);
        }
        result.setBoundsInScreen(bounds);
        result.setVisibleToUser(true);
        result.setEnabled(!object.hasFlag(Flag.HAS_ENABLED_STATE) || object.hasFlag(Flag.IS_ENABLED));
        if (object.hasAction(Action.TAP)) {
            result.addAction(16);
            result.setClickable(true);
        }
        if (object.hasAction(Action.LONG_PRESS)) {
            result.addAction(32);
            result.setLongClickable(true);
        }
        if (object.hasAction(Action.SCROLL_LEFT) || object.hasAction(Action.SCROLL_UP) || object.hasAction(Action.SCROLL_RIGHT) || object.hasAction(Action.SCROLL_DOWN)) {
            result.setScrollable(true);
            result.setClassName((CharSequence)"android.widget.ScrollView");
            if (object.hasAction(Action.SCROLL_LEFT) || object.hasAction(Action.SCROLL_UP)) {
                result.addAction(4096);
            }
            if (object.hasAction(Action.SCROLL_RIGHT) || object.hasAction(Action.SCROLL_DOWN)) {
                result.addAction(8192);
            }
        }
        if (object.hasAction(Action.INCREASE) || object.hasAction(Action.DECREASE)) {
            result.setClassName((CharSequence)"android.widget.SeekBar");
            if (object.hasAction(Action.INCREASE)) {
                result.addAction(4096);
            }
            if (object.hasAction(Action.DECREASE)) {
                result.addAction(8192);
            }
        }
        boolean hasCheckedState = object.hasFlag(Flag.HAS_CHECKED_STATE);
        result.setCheckable(hasCheckedState);
        if (hasCheckedState) {
            result.setChecked(object.hasFlag(Flag.IS_CHECKED));
            if (object.hasFlag(Flag.IS_IN_MUTUALLY_EXCLUSIVE_GROUP)) {
                result.setClassName((CharSequence)"android.widget.RadioButton");
            } else {
                result.setClassName((CharSequence)"android.widget.CheckBox");
            }
        }
        result.setSelected(object.hasFlag(Flag.IS_SELECTED));
        result.setText((CharSequence)object.getValueLabelHint());
        if (object.previousNodeId != -1) {
            result.setTraversalAfter((View)this.mOwner, object.previousNodeId);
        }
        if (this.mA11yFocusedObject != null && this.mA11yFocusedObject.id == virtualViewId) {
            result.addAction(128);
        } else {
            result.addAction(64);
        }
        if (object.children != null) {
            for (SemanticsObject child : object.children) {
                result.addChild((View)this.mOwner, child.id);
            }
        }
        return result;
    }

    public boolean performAction(int virtualViewId, int action, Bundle arguments) {
        SemanticsObject object = this.mObjects.get(virtualViewId);
        if (object == null) {
            return false;
        }
        switch (action) {
            case 16: {
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.TAP);
                return true;
            }
            case 32: {
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.LONG_PRESS);
                return true;
            }
            case 4096: {
                if (object.hasAction(Action.SCROLL_UP)) {
                    this.mOwner.dispatchSemanticsAction(virtualViewId, Action.SCROLL_UP);
                } else if (object.hasAction(Action.SCROLL_LEFT)) {
                    this.mOwner.dispatchSemanticsAction(virtualViewId, Action.SCROLL_LEFT);
                } else if (object.hasAction(Action.INCREASE)) {
                    object.value = object.increasedValue;
                    this.sendAccessibilityEvent(virtualViewId, 4);
                    this.mOwner.dispatchSemanticsAction(virtualViewId, Action.INCREASE);
                } else {
                    return false;
                }
                return true;
            }
            case 8192: {
                if (object.hasAction(Action.SCROLL_DOWN)) {
                    this.mOwner.dispatchSemanticsAction(virtualViewId, Action.SCROLL_DOWN);
                } else if (object.hasAction(Action.SCROLL_RIGHT)) {
                    this.mOwner.dispatchSemanticsAction(virtualViewId, Action.SCROLL_RIGHT);
                } else if (object.hasAction(Action.DECREASE)) {
                    object.value = object.decreasedValue;
                    this.sendAccessibilityEvent(virtualViewId, 4);
                    this.mOwner.dispatchSemanticsAction(virtualViewId, Action.DECREASE);
                } else {
                    return false;
                }
                return true;
            }
            case 512: {
                return this.performCursorMoveAction(object, virtualViewId, arguments, false);
            }
            case 256: {
                return this.performCursorMoveAction(object, virtualViewId, arguments, true);
            }
            case 128: {
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.DID_LOSE_ACCESSIBILITY_FOCUS);
                this.sendAccessibilityEvent(virtualViewId, 65536);
                this.mA11yFocusedObject = null;
                return true;
            }
            case 64: {
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.DID_GAIN_ACCESSIBILITY_FOCUS);
                this.sendAccessibilityEvent(virtualViewId, 32768);
                if (this.mA11yFocusedObject == null) {
                    this.mOwner.invalidate();
                }
                this.mA11yFocusedObject = object;
                if (object.hasAction(Action.INCREASE) || object.hasAction(Action.DECREASE)) {
                    this.sendAccessibilityEvent(virtualViewId, 4);
                }
                return true;
            }
            case 16908342: {
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.SHOW_ON_SCREEN);
                return true;
            }
            case 131072: {
                boolean hasSelection;
                HashMap<String, Integer> selection = new HashMap<String, Integer>();
                boolean bl = hasSelection = arguments != null && arguments.containsKey("ACTION_ARGUMENT_SELECTION_START_INT") && arguments.containsKey("ACTION_ARGUMENT_SELECTION_END_INT");
                if (hasSelection) {
                    selection.put("base", arguments.getInt("ACTION_ARGUMENT_SELECTION_START_INT"));
                    selection.put("extent", arguments.getInt("ACTION_ARGUMENT_SELECTION_END_INT"));
                } else {
                    selection.put("base", object.textSelectionExtent);
                    selection.put("extent", object.textSelectionExtent);
                }
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.SET_SELECTION, selection);
                return true;
            }
            case 16384: {
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.COPY);
                return true;
            }
            case 65536: {
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.CUT);
                return true;
            }
            case 32768: {
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.PASTE);
                return true;
            }
        }
        return false;
    }

    boolean performCursorMoveAction(SemanticsObject object, int virtualViewId, Bundle arguments, boolean forward) {
        int granularity = arguments.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
        boolean extendSelection = arguments.getBoolean("ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN");
        switch (granularity) {
            case 1: {
                if (forward && object.hasAction(Action.MOVE_CURSOR_FORWARD_BY_CHARACTER)) {
                    this.mOwner.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_FORWARD_BY_CHARACTER, extendSelection);
                    return true;
                }
                if (forward || !object.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER)) break;
                this.mOwner.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER, extendSelection);
                return true;
            }
        }
        return false;
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        switch (focus) {
            case 1: {
                if (this.mInputFocusedObject != null) {
                    return this.createAccessibilityNodeInfo(this.mInputFocusedObject.id);
                }
            }
            case 2: {
                if (this.mA11yFocusedObject == null) break;
                return this.createAccessibilityNodeInfo(this.mA11yFocusedObject.id);
            }
        }
        return null;
    }

    private SemanticsObject getRootObject() {
        assert (this.mObjects.containsKey(0));
        return this.mObjects.get(0);
    }

    private SemanticsObject getOrCreateObject(int id) {
        SemanticsObject object = this.mObjects.get(id);
        if (object == null) {
            object = new SemanticsObject();
            object.id = id;
            this.mObjects.put(id, object);
        }
        return object;
    }

    void handleTouchExplorationExit() {
        if (this.mHoveredObject != null) {
            this.sendAccessibilityEvent(this.mHoveredObject.id, 256);
            this.mHoveredObject = null;
        }
    }

    void handleTouchExploration(float x, float y) {
        if (this.mObjects.isEmpty()) {
            return;
        }
        SemanticsObject newObject = this.getRootObject().hitTest(new float[]{x, y, 0.0f, 1.0f});
        if (newObject != this.mHoveredObject) {
            if (newObject != null) {
                this.sendAccessibilityEvent(newObject.id, 128);
            }
            if (this.mHoveredObject != null) {
                this.sendAccessibilityEvent(this.mHoveredObject.id, 256);
            }
            this.mHoveredObject = newObject;
        }
    }

    void updateSemantics(ByteBuffer buffer, String[] strings) {
        ArrayList<SemanticsObject> updated = new ArrayList<SemanticsObject>();
        while (buffer.hasRemaining()) {
            int id = buffer.getInt();
            SemanticsObject object = this.getOrCreateObject(id);
            boolean hadCheckedState = object.hasFlag(Flag.HAS_CHECKED_STATE);
            boolean wasChecked = object.hasFlag(Flag.IS_CHECKED);
            object.updateWith(buffer, strings);
            if (object.hasFlag(Flag.IS_FOCUSED)) {
                this.mInputFocusedObject = object;
            }
            if (!object.hadPreviousConfig) continue;
            updated.add(object);
        }
        HashSet<SemanticsObject> visitedObjects = new HashSet<SemanticsObject>();
        SemanticsObject rootObject = this.getRootObject();
        if (rootObject != null) {
            float[] identity = new float[16];
            Matrix.setIdentityM((float[])identity, (int)0);
            rootObject.updateRecursively(identity, visitedObjects, false);
        }
        Iterator<Map.Entry<Integer, SemanticsObject>> it = this.mObjects.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, SemanticsObject> entry = it.next();
            SemanticsObject object = entry.getValue();
            if (visitedObjects.contains(object)) continue;
            this.willRemoveSemanticsObject(object);
            it.remove();
        }
        this.sendAccessibilityEvent(0, 2048);
        for (SemanticsObject object : updated) {
            String newValue;
            if (object.didScroll()) {
                AccessibilityEvent event = this.obtainAccessibilityEvent(object.id, 4096);
                float position = object.scrollPosition;
                float max = object.scrollExtentMax;
                if (Float.isInfinite(object.scrollExtentMax)) {
                    max = 100000.0f;
                    if (position > 70000.0f) {
                        position = 70000.0f;
                    }
                }
                if (Float.isInfinite(object.scrollExtentMin)) {
                    max += 100000.0f;
                    if (position < -70000.0f) {
                        position = -70000.0f;
                    }
                    position += 100000.0f;
                } else {
                    max -= object.scrollExtentMin;
                    position -= object.scrollExtentMin;
                }
                if (object.hadAction(Action.SCROLL_UP) || object.hadAction(Action.SCROLL_DOWN)) {
                    event.setScrollY((int)position);
                    event.setMaxScrollY((int)max);
                } else if (object.hadAction(Action.SCROLL_LEFT) || object.hadAction(Action.SCROLL_RIGHT)) {
                    event.setScrollX((int)position);
                    event.setMaxScrollX((int)max);
                }
                this.sendAccessibilityEvent(event);
            }
            if (this.mA11yFocusedObject != null && this.mA11yFocusedObject.id == object.id && object.hadFlag(Flag.HAS_CHECKED_STATE) && object.hasFlag(Flag.HAS_CHECKED_STATE) && object.hadFlag(Flag.IS_CHECKED) != object.hasFlag(Flag.IS_CHECKED)) {
                this.sendAccessibilityEvent(object.id, 1);
            }
            if (this.mInputFocusedObject == null || this.mInputFocusedObject.id != object.id || !object.hadFlag(Flag.IS_TEXT_FIELD) || !object.hasFlag(Flag.IS_TEXT_FIELD)) continue;
            String oldValue = object.previousValue != null ? object.previousValue : "";
            AccessibilityEvent event = this.createTextChangedEvent(object.id, oldValue, newValue = object.value != null ? object.value : "");
            if (event != null) {
                this.sendAccessibilityEvent(event);
            }
            if (object.previousTextSelectionBase == object.textSelectionBase && object.previousTextSelectionExtent == object.textSelectionExtent) continue;
            AccessibilityEvent selectionEvent = this.obtainAccessibilityEvent(object.id, 8192);
            selectionEvent.getText().add(newValue);
            selectionEvent.setFromIndex(object.textSelectionBase);
            selectionEvent.setToIndex(object.textSelectionExtent);
            selectionEvent.setItemCount(newValue.length());
            this.sendAccessibilityEvent(selectionEvent);
        }
    }

    private AccessibilityEvent createTextChangedEvent(int id, String oldValue, String newValue) {
        int newIndex;
        int i;
        AccessibilityEvent e = this.obtainAccessibilityEvent(id, 16);
        e.setBeforeText((CharSequence)oldValue);
        e.getText().add(newValue);
        for (i = 0; i < oldValue.length() && i < newValue.length() && oldValue.charAt(i) == newValue.charAt(i); ++i) {
        }
        if (i >= oldValue.length() && i >= newValue.length()) {
            return null;
        }
        int firstDifference = i;
        e.setFromIndex(firstDifference);
        int oldIndex = oldValue.length() - 1;
        for (newIndex = newValue.length() - 1; oldIndex >= firstDifference && newIndex >= firstDifference && oldValue.charAt(oldIndex) == newValue.charAt(newIndex); --oldIndex, --newIndex) {
        }
        e.setRemovedCount(oldIndex - firstDifference + 1);
        e.setAddedCount(newIndex - firstDifference + 1);
        return e;
    }

    private AccessibilityEvent obtainAccessibilityEvent(int virtualViewId, int eventType) {
        assert (virtualViewId != 0);
        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
        event.setPackageName((CharSequence)this.mOwner.getContext().getPackageName());
        event.setSource((View)this.mOwner, virtualViewId);
        return event;
    }

    private void sendAccessibilityEvent(int virtualViewId, int eventType) {
        if (!this.mAccessibilityEnabled) {
            return;
        }
        if (virtualViewId == 0) {
            this.mOwner.sendAccessibilityEvent(eventType);
        } else {
            this.sendAccessibilityEvent(this.obtainAccessibilityEvent(virtualViewId, eventType));
        }
    }

    private void sendAccessibilityEvent(AccessibilityEvent event) {
        if (!this.mAccessibilityEnabled) {
            return;
        }
        this.mOwner.getParent().requestSendAccessibilityEvent((View)this.mOwner, event);
    }

    @Override
    public void onMessage(Object message, BasicMessageChannel.Reply<Object> reply) {
        HashMap annotatedEvent = (HashMap)message;
        String type = (String)annotatedEvent.get("type");
        HashMap data = (HashMap)annotatedEvent.get("data");
        switch (type) {
            case "announce": {
                this.mOwner.announceForAccessibility((String)data.get("message"));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void willRemoveSemanticsObject(SemanticsObject object) {
        assert (this.mObjects.containsKey(object.id));
        assert (this.mObjects.get(object.id) == object);
        object.parent = null;
        if (this.mA11yFocusedObject == object) {
            this.sendAccessibilityEvent(this.mA11yFocusedObject.id, 65536);
            this.mA11yFocusedObject = null;
        }
        if (this.mInputFocusedObject == object) {
            this.mInputFocusedObject = null;
        }
        if (this.mHoveredObject == object) {
            this.mHoveredObject = null;
        }
    }

    void reset() {
        this.mObjects.clear();
        if (this.mA11yFocusedObject != null) {
            this.sendAccessibilityEvent(this.mA11yFocusedObject.id, 65536);
        }
        this.mA11yFocusedObject = null;
        this.mHoveredObject = null;
        this.sendAccessibilityEvent(0, 2048);
    }

    private class SemanticsObject {
        int id = -1;
        int flags;
        int actions;
        int textSelectionBase;
        int textSelectionExtent;
        float scrollPosition;
        float scrollExtentMax;
        float scrollExtentMin;
        String label;
        String value;
        String increasedValue;
        String decreasedValue;
        String hint;
        TextDirection textDirection;
        int previousNodeId;
        boolean hadPreviousConfig = false;
        int previousFlags;
        int previousActions;
        int previousTextSelectionBase;
        int previousTextSelectionExtent;
        float previousScrollPosition;
        float previousScrollExtentMax;
        float previousScrollExtentMin;
        String previousValue;
        private float left;
        private float top;
        private float right;
        private float bottom;
        private float[] transform;
        SemanticsObject parent;
        List<SemanticsObject> children;
        private boolean inverseTransformDirty = true;
        private float[] inverseTransform;
        private boolean globalGeometryDirty = true;
        private float[] globalTransform;
        private Rect globalRect;

        SemanticsObject() {
        }

        boolean hasAction(Action action) {
            return (this.actions & action.value) != 0;
        }

        boolean hadAction(Action action) {
            return (this.previousActions & action.value) != 0;
        }

        boolean hasFlag(Flag flag) {
            return (this.flags & flag.value) != 0;
        }

        boolean hadFlag(Flag flag) {
            assert (this.hadPreviousConfig);
            return (this.previousFlags & flag.value) != 0;
        }

        boolean didScroll() {
            return !Float.isNaN(this.scrollPosition) && !Float.isNaN(this.previousScrollPosition) && this.previousScrollPosition != this.scrollPosition;
        }

        void log(String indent, boolean recursive) {
            Log.i((String)AccessibilityBridge.TAG, (String)(indent + "SemanticsObject id=" + this.id + " label=" + this.label + " actions=" + this.actions + " flags=" + this.flags + "\n" + indent + "  +-- textDirection=" + (Object)((Object)this.textDirection) + "\n" + indent + "  +-- previousNodeId=" + this.previousNodeId + "\n" + indent + "  +-- rect.ltrb=(" + this.left + ", " + this.top + ", " + this.right + ", " + this.bottom + ")\n" + indent + "  +-- transform=" + Arrays.toString(this.transform) + "\n"));
            if (this.children != null && recursive) {
                String childIndent = indent + "  ";
                for (SemanticsObject child : this.children) {
                    child.log(childIndent, recursive);
                }
            }
        }

        void updateWith(ByteBuffer buffer, String[] strings) {
            this.hadPreviousConfig = true;
            this.previousValue = this.value;
            this.previousFlags = this.flags;
            this.previousActions = this.actions;
            this.previousTextSelectionBase = this.textSelectionBase;
            this.previousTextSelectionExtent = this.textSelectionExtent;
            this.previousScrollPosition = this.scrollPosition;
            this.previousScrollExtentMax = this.scrollExtentMax;
            this.previousScrollExtentMin = this.scrollExtentMin;
            this.flags = buffer.getInt();
            this.actions = buffer.getInt();
            this.textSelectionBase = buffer.getInt();
            this.textSelectionExtent = buffer.getInt();
            this.scrollPosition = buffer.getFloat();
            this.scrollExtentMax = buffer.getFloat();
            this.scrollExtentMin = buffer.getFloat();
            int stringIndex = buffer.getInt();
            this.label = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            this.value = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            this.increasedValue = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            this.decreasedValue = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            this.hint = stringIndex == -1 ? null : strings[stringIndex];
            this.textDirection = TextDirection.fromInt(buffer.getInt());
            this.previousNodeId = buffer.getInt();
            this.left = buffer.getFloat();
            this.top = buffer.getFloat();
            this.right = buffer.getFloat();
            this.bottom = buffer.getFloat();
            if (this.transform == null) {
                this.transform = new float[16];
            }
            for (int i = 0; i < 16; ++i) {
                this.transform[i] = buffer.getFloat();
            }
            this.inverseTransformDirty = true;
            this.globalGeometryDirty = true;
            int childCount = buffer.getInt();
            if (childCount == 0) {
                this.children = null;
            } else {
                if (this.children == null) {
                    this.children = new ArrayList<SemanticsObject>(childCount);
                } else {
                    this.children.clear();
                }
                for (int i = 0; i < childCount; ++i) {
                    SemanticsObject child = AccessibilityBridge.this.getOrCreateObject(buffer.getInt());
                    child.parent = this;
                    this.children.add(child);
                }
            }
        }

        private void ensureInverseTransform() {
            if (!this.inverseTransformDirty) {
                return;
            }
            this.inverseTransformDirty = false;
            if (this.inverseTransform == null) {
                this.inverseTransform = new float[16];
            }
            if (!Matrix.invertM((float[])this.inverseTransform, (int)0, (float[])this.transform, (int)0)) {
                Arrays.fill(this.inverseTransform, 0.0f);
            }
        }

        Rect getGlobalRect() {
            assert (!this.globalGeometryDirty);
            return this.globalRect;
        }

        SemanticsObject hitTest(float[] point) {
            float w = point[3];
            float x = point[0] / w;
            float y = point[1] / w;
            if (x < this.left || x >= this.right || y < this.top || y >= this.bottom) {
                return null;
            }
            if (this.children != null) {
                float[] transformedPoint = new float[4];
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    SemanticsObject child = this.children.get(i);
                    child.ensureInverseTransform();
                    Matrix.multiplyMV((float[])transformedPoint, (int)0, (float[])child.inverseTransform, (int)0, (float[])point, (int)0);
                    SemanticsObject result = child.hitTest(transformedPoint);
                    if (result == null) continue;
                    return result;
                }
            }
            return this;
        }

        boolean isFocusable() {
            int scrollableActions = Action.SCROLL_RIGHT.value | Action.SCROLL_LEFT.value | Action.SCROLL_UP.value | Action.SCROLL_DOWN.value;
            return (this.actions & ~scrollableActions) != 0 || this.flags != 0 || this.label != null && !this.label.isEmpty() || this.value != null && !this.value.isEmpty() || this.hint != null && !this.hint.isEmpty();
        }

        void updateRecursively(float[] ancestorTransform, Set<SemanticsObject> visitedObjects, boolean forceUpdate) {
            visitedObjects.add(this);
            if (this.globalGeometryDirty) {
                forceUpdate = true;
            }
            if (forceUpdate) {
                if (this.globalTransform == null) {
                    this.globalTransform = new float[16];
                }
                Matrix.multiplyMM((float[])this.globalTransform, (int)0, (float[])ancestorTransform, (int)0, (float[])this.transform, (int)0);
                float[] sample = new float[4];
                sample[2] = 0.0f;
                sample[3] = 1.0f;
                float[] point1 = new float[4];
                float[] point2 = new float[4];
                float[] point3 = new float[4];
                float[] point4 = new float[4];
                sample[0] = this.left;
                sample[1] = this.top;
                this.transformPoint(point1, this.globalTransform, sample);
                sample[0] = this.right;
                sample[1] = this.top;
                this.transformPoint(point2, this.globalTransform, sample);
                sample[0] = this.right;
                sample[1] = this.bottom;
                this.transformPoint(point3, this.globalTransform, sample);
                sample[0] = this.left;
                sample[1] = this.bottom;
                this.transformPoint(point4, this.globalTransform, sample);
                if (this.globalRect == null) {
                    this.globalRect = new Rect();
                }
                this.globalRect.set(Math.round(this.min(point1[0], point2[0], point3[0], point4[0])), Math.round(this.min(point1[1], point2[1], point3[1], point4[1])), Math.round(this.max(point1[0], point2[0], point3[0], point4[0])), Math.round(this.max(point1[1], point2[1], point3[1], point4[1])));
                this.globalGeometryDirty = false;
            }
            assert (this.globalTransform != null);
            assert (this.globalRect != null);
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    this.children.get(i).updateRecursively(this.globalTransform, visitedObjects, forceUpdate);
                }
            }
        }

        private void transformPoint(float[] result, float[] transform, float[] point) {
            Matrix.multiplyMV((float[])result, (int)0, (float[])transform, (int)0, (float[])point, (int)0);
            float w = result[3];
            result[0] = result[0] / w;
            result[1] = result[1] / w;
            result[2] = result[2] / w;
            result[3] = 0.0f;
        }

        private float min(float a, float b, float c, float d) {
            return Math.min(a, Math.min(b, Math.min(c, d)));
        }

        private float max(float a, float b, float c, float d) {
            return Math.max(a, Math.max(b, Math.max(c, d)));
        }

        private String getValueLabelHint() {
            String[] array;
            StringBuilder sb = new StringBuilder();
            for (String word : array = new String[]{this.value, this.label, this.hint}) {
                if (word == null || word.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(word);
            }
            return sb.length() > 0 ? sb.toString() : null;
        }
    }

    private static enum TextDirection {
        UNKNOWN,
        LTR,
        RTL;


        public static TextDirection fromInt(int value) {
            switch (value) {
                case 1: {
                    return RTL;
                }
                case 2: {
                    return LTR;
                }
            }
            return UNKNOWN;
        }
    }

    static enum Flag {
        HAS_CHECKED_STATE(1),
        IS_CHECKED(2),
        IS_SELECTED(4),
        IS_BUTTON(8),
        IS_TEXT_FIELD(16),
        IS_FOCUSED(32),
        HAS_ENABLED_STATE(64),
        IS_ENABLED(128),
        IS_IN_MUTUALLY_EXCLUSIVE_GROUP(256),
        IS_HEADER(512);

        final int value;

        private Flag(int value) {
            this.value = value;
        }
    }

    static enum Action {
        TAP(1),
        LONG_PRESS(2),
        SCROLL_LEFT(4),
        SCROLL_RIGHT(8),
        SCROLL_UP(16),
        SCROLL_DOWN(32),
        INCREASE(64),
        DECREASE(128),
        SHOW_ON_SCREEN(256),
        MOVE_CURSOR_FORWARD_BY_CHARACTER(512),
        MOVE_CURSOR_BACKWARD_BY_CHARACTER(1024),
        SET_SELECTION(2048),
        COPY(4096),
        CUT(8192),
        PASTE(16384),
        DID_GAIN_ACCESSIBILITY_FOCUS(32768),
        DID_LOSE_ACCESSIBILITY_FOCUS(65536);

        final int value;

        private Action(int value) {
            this.value = value;
        }
    }
}

