// Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Date/time formatting symbols for a large subset of locales.
///
/// DO NOT EDIT. This file is autogenerated from ICU data. See
/// 'http://go/generate_datetime_pattern_dart.cc' (Google internal)
/// File generated from CLDR ver. 31.0.1

library date_time_patterns;

/// Returns a Map from locale names to another Map that goes from skeletons
/// to the locale-specific formatting patterns.
/// Internal use only. Call initializeDateFormatting instead.
Map dateTimePatternMap() => const {
      /// Extended set of localized date/time patterns for locale af.
      'af': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd-MM', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM-y', // YEAR_NUM_MONTH
        'yMd': 'y-MM-dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE y-MM-dd', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale am.
      'am': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'EEE፣ M/d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE፣ MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE፣ MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE፣ d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE፣ MMM d y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE ፣d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ar.
      'ar': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/‏M', // NUM_MONTH_DAY
        'MEd': 'EEE، d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE، d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE، d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M‏/y', // YEAR_NUM_MONTH
        'yMd': 'd‏/M‏/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE، d/‏M/‏y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM، y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE، d MMM، y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM، y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE، d MMMM، y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ar_DZ.
      'ar_DZ': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/‏M', // NUM_MONTH_DAY
        'MEd': 'EEE، d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE، d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE، d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M‏/y', // YEAR_NUM_MONTH
        'yMd': 'd‏/M‏/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE، d/‏M/‏y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM، y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE، d MMM، y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM، y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE، d MMMM، y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale az.
      'az': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd.MM', // NUM_MONTH_DAY
        'MEd': 'dd.MM, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'd MMM, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'd MMMM, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'dd.MM.y, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'd MMM y, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'd MMMM y, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale be.
      'be': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLL y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y \'г\'.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y \'г\'.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm.ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale bg.
      'bg': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.MM', // NUM_MONTH_DAY
        'MEd': 'EEE, d.MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'MM', // ABBR_MONTH
        'MMMd': 'd.MM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d.MM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y \'г\'.', // YEAR
        'yM': 'MM.y \'г\'.', // YEAR_NUM_MONTH
        'yMd': 'd.MM.y \'г\'.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.MM.y \'г\'.', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MM.y \'г\'.', // YEAR_ABBR_MONTH
        'yMMMd': 'd.MM.y \'г\'.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d.MM.y \'г\'.', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y \'г\'.', // YEAR_MONTH
        'yMMMMd': 'd MMMM y \'г\'.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y \'г\'.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y \'г\'.', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y \'г\'.', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale bn.
      'bn': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d-M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale br.
      'br': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'MM', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y MMMM', // YEAR_MONTH
        'yMMMMd': 'y MMMM d', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y MMMM d, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale bs.
      'bs': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y.', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y.', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y.', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y.', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y.', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm (v)', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm (z)', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ca.
      'ca': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLL \'de\' y', // YEAR_ABBR_MONTH
        'yMMMd': 'd LLL y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale chr.
      'chr': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'EEE, M/d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'M/d/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, M/d/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale cs.
      'cs': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd. M.', // NUM_MONTH_DAY
        'MEd': 'EEE d. M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. M.', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. M.', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd. M. y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d. M. y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLLL y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. M. y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d. M. y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'H:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale cy.
      'cy': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale da.
      'da': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'MMM', // ABBR_STANDALONE_MONTH
        'LLLL': 'MMMM', // STANDALONE_MONTH
        'M': 'M', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'MMM', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'MMMM', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE \'den\' d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH.mm', // HOUR24_MINUTE
        'Hms': 'HH.mm.ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH.mm', // HOUR_MINUTE
        'jms': 'HH.mm.ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH.mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH.mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm.ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale de.
      'de': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH \'Uhr\'', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH \'Uhr\'', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH \'Uhr\' z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale de_AT.
      'de_AT': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH \'Uhr\'', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH \'Uhr\'', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH \'Uhr\' z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale de_CH.
      'de_CH': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH \'Uhr\'', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH \'Uhr\'', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH \'Uhr\' z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale el.
      'el': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'MMM', // ABBR_STANDALONE_MONTH
        'LLLL': 'MMMM', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'MMM', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'MMMM', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en.
      'en': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'EEE, M/d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'M/d/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, M/d/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_AU.
      'en_AU': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_CA.
      'en_CA': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'MM-dd', // NUM_MONTH_DAY
        'MEd': 'EEE, MM-dd', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'y-MM-dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, y-MM-dd', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_GB.
      'en_GB': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_IE.
      'en_IE': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_IN.
      'en_IN': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_SG.
      'en_SG': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_US.
      'en_US': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'EEE, M/d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'M/d/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, M/d/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_ZA.
      'en_ZA': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'MM/dd', // NUM_MONTH_DAY
        'MEd': 'EEE, MM/dd', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'dd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, dd MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, dd MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'y/MM/dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, y/MM/dd', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'dd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, dd MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale es.
      'es': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'H:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale es_419.
      'es_419': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMMM \'de\' y', // YEAR_ABBR_MONTH
        'yMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d \'de\' MMM \'de\' y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ \'de\' y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'H:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale es_ES.
      'es_ES': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'H:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale es_MX.
      'es_MX': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d \'de\' MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMMM \'de\' y', // YEAR_ABBR_MONTH
        'yMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d \'de\' MMMM \'de\' y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'H:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale es_US.
      'es_US': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMMM \'de\' y', // YEAR_ABBR_MONTH
        'yMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d \'de\' MMM \'de\' y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ \'de\' y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale et.
      'et': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'MMMM', // ABBR_STANDALONE_MONTH
        'LLLL': 'MMMM', // STANDALONE_MONTH
        'M': 'M', // NUM_MONTH
        'Md': 'd.M', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'MMMM', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'MMMM', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale eu.
      'eu': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'M/d, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y/M', // YEAR_NUM_MONTH
        'yMd': 'y/M/d', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y/M/d, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y MMM d', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y MMM d, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y(\'e\')\'ko\' MMMM', // YEAR_MONTH
        'yMMMMd': 'y(\'e\')\'ko\' MMMM d', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y(\'e\')\'ko\' MMMM d, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y(\'e\')\'ko\' QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y(\'e\')\'ko\' QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH (z)', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale fa.
      'fa': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'EEE M/d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd LLL', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d LLL', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd LLLL', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d LLLL', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y/M', // YEAR_NUM_MONTH
        'yMd': 'y/M/d', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE y/M/d', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm (z)', // HOUR_MINUTETZ
        'jz': 'H (z)', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale fi.
      'fi': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'ccc d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'cccc d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'L.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLL y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H.mm', // HOUR24_MINUTE
        'Hms': 'H.mm.ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H.mm', // HOUR_MINUTE
        'jms': 'H.mm.ss', // HOUR_MINUTE_SECOND
        'jmv': 'H.mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H.mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'm.ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale fil.
      'fil': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'EEE, M/d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'M/d/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, M/d/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale fr.
      'fr': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH \'h\'', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH \'h\'', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH \'h\' z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale fr_CA.
      'fr_CA': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M-d', // NUM_MONTH_DAY
        'MEd': 'EEE M-d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'y-MM-dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE y-MM-dd', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH \'h\'', // HOUR24
        'Hm': 'HH \'h\' mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH \'h\'', // HOUR
        'jm': 'HH \'h\' mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH \'h\' mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH \'h\' mm z', // HOUR_MINUTETZ
        'jz': 'HH \'h\' z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ga.
      'ga': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'LL', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale gl.
      'gl': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd \'de\' MMM', // ABBR_MONTH_DAY
        'MMMEd': 'ccc, d \'de\' MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'cccc, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'ccc, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLL \'de\' y', // YEAR_ABBR_MONTH
        'yMMMd': 'd \'de\' MMM \'de\' y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'ccc, d \'de\' MMM \'de\' y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm (v)', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm (z)', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale gsw.
      'gsw': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-M', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, y-M-d', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'y MMM d', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale gu.
      'gu': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale haw.
      'haw': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y MMMM', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale he.
      'he': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd בMMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d בMMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd בMMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d בMMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd בMMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d בMMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd בMMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d בMMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale hi.
      'hi': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale hr.
      'hr': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L.', // NUM_MONTH
        'Md': 'dd. MM.', // NUM_MONTH_DAY
        'MEd': 'EEE, dd. MM.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y.', // YEAR
        'yM': 'MM. y.', // YEAR_NUM_MONTH
        'yMd': 'dd. MM. y.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd. MM. y.', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLL y.', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y.', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y.', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y.', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y.', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH (z)', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale hu.
      'hu': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M. d.', // NUM_MONTH_DAY
        'MEd': 'M. d., EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d.', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d., EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d.', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d., EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y.', // YEAR
        'yM': 'y. M.', // YEAR_NUM_MONTH
        'yMd': 'y. MM. dd.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y. MM. dd., EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y. MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y. MMM d.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y. MMM d., EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y. MMMM', // YEAR_MONTH
        'yMMMMd': 'y. MMMM d.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y. MMMM d., EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y. QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y. QQQQ', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale hy.
      'hy': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd.MM', // NUM_MONTH_DAY
        'MEd': 'dd.MM, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'd MMM, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'd MMMM, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'd.MM.y թ., EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y թ. LLL', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM, y թ.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y թ. MMM d, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'yթ․ MMMM', // YEAR_MONTH
        'yMMMMd': 'd MMMM, y թ.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y թ. MMMM d, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y թ, QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y թ, QQQQ', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale id.
      'id': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH.mm', // HOUR24_MINUTE
        'Hms': 'HH.mm.ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH.mm', // HOUR_MINUTE
        'jms': 'HH.mm.ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH.mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH.mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm.ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale in.
      'in': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH.mm', // HOUR24_MINUTE
        'Hms': 'HH.mm.ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH.mm', // HOUR_MINUTE
        'jms': 'HH.mm.ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH.mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH.mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm.ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale is.
      'is': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M. y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale it.
      'it': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale iw.
      'iw': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd בMMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d בMMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd בMMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d בMMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd בMMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d בMMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd בMMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d בMMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ja.
      'ja': const {
        'd': 'd日', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'M月', // ABBR_STANDALONE_MONTH
        'LLLL': 'M月', // STANDALONE_MONTH
        'M': 'M月', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'M/d(EEE)', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'M月', // ABBR_MONTH
        'MMMd': 'M月d日', // ABBR_MONTH_DAY
        'MMMEd': 'M月d日(EEE)', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'M月', // MONTH
        'MMMMd': 'M月d日', // MONTH_DAY
        'MMMMEEEEd': 'M月d日EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y年', // YEAR
        'yM': 'y/M', // YEAR_NUM_MONTH
        'yMd': 'y/M/d', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y/M/d(EEE)', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y年M月', // YEAR_ABBR_MONTH
        'yMMMd': 'y年M月d日', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y年M月d日(EEE)', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y年M月', // YEAR_MONTH
        'yMMMMd': 'y年M月d日', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y年M月d日EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y/QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y年QQQQ', // YEAR_QUARTER
        'H': 'H時', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H時', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'H:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H:mm z', // HOUR_MINUTETZ
        'jz': 'H時 z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ka.
      'ka': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM. y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM. y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM. y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM, y', // YEAR_MONTH
        'yMMMMd': 'd MMMM, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ, y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ, y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale kk.
      'kk': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd.MM', // NUM_MONTH_DAY
        'MEd': 'dd.MM, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'd MMM, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'd MMMM, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'dd.MM.y, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y \'ж\'. MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y \'ж\'. d MMM', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y \'ж\'. d MMM, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y \'ж\'. MMMM', // YEAR_MONTH
        'yMMMMd': 'y \'ж\'. d MMMM', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y \'ж\'. d MMMM, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y \'ж\'. QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y \'ж\'. QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale km.
      'km': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale kn.
      'kn': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'd/M, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, M/d/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d,y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ko.
      'ko': const {
        'd': 'd일', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'M월', // NUM_MONTH
        'Md': 'M. d.', // NUM_MONTH_DAY
        'MEd': 'M. d. (EEE)', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d일', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d일 (EEE)', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d일', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d일 EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y년', // YEAR
        'yM': 'y. M.', // YEAR_NUM_MONTH
        'yMd': 'y. M. d.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y. M. d. (EEE)', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y년 MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y년 MMM d일', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y년 MMM d일 (EEE)', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y년 MMMM', // YEAR_MONTH
        'yMMMMd': 'y년 MMMM d일', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y년 MMMM d일 EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y년 QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y년 QQQQ', // YEAR_QUARTER
        'H': 'H시', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'H시 m분 s초', // HOUR24_MINUTE_SECOND
        'j': 'a h시', // HOUR
        'jm': 'a h:mm', // HOUR_MINUTE
        'jms': 'a h:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'a h:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'a h:mm z', // HOUR_MINUTETZ
        'jz': 'a h시 z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ky.
      'ky': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd-MM', // NUM_MONTH_DAY
        'MEd': 'dd-MM, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd-MMM', // ABBR_MONTH_DAY
        'MMMEd': 'd-MMM, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd-MMMM', // MONTH_DAY
        'MMMMEEEEd': 'd-MMMM, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'y-dd-MM', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y-dd-MM, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y-\'ж\'. MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y-\'ж\'. d-MMM', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y-\'ж\'. d-MMM, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y-\'ж\'., MMMM', // YEAR_MONTH
        'yMMMMd': 'y-\'ж\'., d-MMMM', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y-\'ж\'., d-MMMM, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y-\'ж\'., QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y-\'ж\'., QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ln.
      'ln': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y MMMM', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale lo.
      'lo': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale lt.
      'lt': const {
        'd': 'dd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'MM', // NUM_MONTH
        'Md': 'MM-d', // NUM_MONTH_DAY
        'MEd': 'MM-dd, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'MM', // ABBR_MONTH
        'MMMd': 'MM-dd', // ABBR_MONTH_DAY
        'MMMEd': 'MM-dd, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d \'d\'.', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d \'d\'., EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'y-MM-dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y-MM-dd, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y-MM', // YEAR_ABBR_MONTH
        'yMMMd': 'y-MM-dd', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y-MM-dd, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y \'m\'. LLLL', // YEAR_MONTH
        'yMMMMd': 'y \'m\'. MMMM d \'d\'.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y \'m\'. MMMM d \'d\'., EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm; v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm; z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale lv.
      'lv': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd.MM.', // NUM_MONTH_DAY
        'MEd': 'EEE, dd.MM.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y. \'g\'.', // YEAR
        'yM': 'MM.y.', // YEAR_NUM_MONTH
        'yMd': 'y.MM.d.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y.', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y. \'g\'. MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y. \'g\'. d. MMM', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, y. \'g\'. d. MMM', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y. \'g\'. MMMM', // YEAR_MONTH
        'yMMMMd': 'y. \'gada\' d. MMMM', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, y. \'gada\' d. MMMM', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y. \'g\'. QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y. \'g\'. QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale mk.
      'mk': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y \'г\'.', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y \'г\'.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y \'г\'.', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y \'г\'.', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y \'г\'.', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y \'г\'.', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ml.
      'ml': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'd/M, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'd-M-y, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y MMM d', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y MMM d, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y MMMM', // YEAR_MONTH
        'yMMMMd': 'y, MMMM d', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y, MMMM d, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale mn.
      'mn': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M-d', // NUM_MONTH_DAY
        'MEd': 'EEE, M-d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-M', // YEAR_NUM_MONTH
        'yMd': 'y-M-d', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, y-M-d', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y MMM d', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, y MMM d', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y MMMM', // YEAR_MONTH
        'yMMMMd': 'y\'оны\' MMMM\'сарын\' d\'өдөр\'', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, y MMMM d', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y \'оны\' QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale mo.
      'mo': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd.MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd.MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd.MM.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale mr.
      'mr': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d, MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ms.
      'ms': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd-M', // NUM_MONTH_DAY
        'MEd': 'EEE, d-M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M-y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y MMMM', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale mt.
      'mt': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'MM-dd', // NUM_MONTH_DAY
        'MEd': 'EEE, M-d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d \'ta\'’ MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'ta\'’ MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d \'ta\'’ MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd \'ta\'’ MMM, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d \'ta\'’ MMM, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd \'ta\'’ MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'ta\'’ MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ - y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ - y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale my.
      'my': const {
        'd': 'd', // DAY
        'E': 'cccနေ့', // ABBR_WEEKDAY
        'EEEE': 'ccccနေ့', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'd/M EEEနေ့', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d ရက် EEEနေ့', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d ရက် EEEEနေ့', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'dd-MM-y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'd-M-y EEEနေ့', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'd MMM y EEEနေ့', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'v HH:mm', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'z HH:mm', // HOUR_MINUTETZ
        'jz': 'z HH', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale nb.
      'nb': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L.', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d.MM.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ne.
      'ne': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'MM-dd', // NUM_MONTH_DAY
        'MEd': 'MM-dd, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'y-MM-dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y-MM-dd, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y MMM d', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y MMM d, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y MMMM', // YEAR_MONTH
        'yMMMMd': 'y MMMM d', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y MMMM d, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale nl.
      'nl': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd-M', // NUM_MONTH_DAY
        'MEd': 'EEE d-M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M-y', // YEAR_NUM_MONTH
        'yMd': 'd-M-y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d-M-y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale no.
      'no': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L.', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d.MM.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale no_NO.
      'no_NO': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L.', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d.MM.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale or.
      'or': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'M', // NUM_MONTH
        'Md': 'd-M', // NUM_MONTH_DAY
        'MEd': 'MM-dd, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M-y', // YEAR_NUM_MONTH
        'yMd': 'd-M-y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y-MM-dd, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y MMM d, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale pa.
      'pa': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, dd-MM.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale pl.
      'pl': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.MM', // NUM_MONTH_DAY
        'MEd': 'EEE, d.MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.MM.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLL y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale pt.
      'pt': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd \'de\' MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d \'de\' MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM \'de\' y', // YEAR_ABBR_MONTH
        'yMMMd': 'd \'de\' MMM \'de\' y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d \'de\' MMM \'de\' y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ \'de\' y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale pt_BR.
      'pt_BR': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd \'de\' MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d \'de\' MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM \'de\' y', // YEAR_ABBR_MONTH
        'yMMMd': 'd \'de\' MMM \'de\' y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d \'de\' MMM \'de\' y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ \'de\' y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale pt_PT.
      'pt_PT': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd/MM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d/MM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd \'de\' MMMM', // MONTH_DAY
        'MMMMEEEEd': 'cccc, d \'de\' MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MM/y', // YEAR_ABBR_MONTH
        'yMMMd': 'd/MM/y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d/MM/y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'de\' y', // YEAR_MONTH
        'yMMMMd': 'd \'de\' MMMM \'de\' y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQQ \'de\' y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'de\' y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ro.
      'ro': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd.MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd.MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd.MM.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ru.
      'ru': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd.MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd.MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'ccc, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'cccc, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'ccc, d.MM.y \'г\'.', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLL y \'г\'.', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y \'г\'.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y \'г\'.', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y \'г\'.', // YEAR_MONTH
        'yMMMMd': 'd MMMM y \'г\'.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y \'г\'.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y \'г\'.', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y \'г\'.', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'H:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale sh.
      'sh': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y.', // YEAR
        'yM': 'M.y.', // YEAR_NUM_MONTH
        'yMd': 'd.M.y.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y.', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y.', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y.', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y.', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y.', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y.', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale si.
      'si': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M-d', // NUM_MONTH_DAY
        'MEd': 'M-d, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-M', // YEAR_NUM_MONTH
        'yMd': 'y-M-d', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y-M-d, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y MMM d', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y MMM d, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y MMMM', // YEAR_MONTH
        'yMMMMd': 'y MMMM d', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y MMMM d, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH.mm', // HOUR24_MINUTE
        'Hms': 'HH.mm.ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH.mm', // HOUR_MINUTE
        'jms': 'HH.mm.ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH.mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH.mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm.ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale sk.
      'sk': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L.', // NUM_MONTH
        'Md': 'd. M.', // NUM_MONTH_DAY
        'MEd': 'EEE d. M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. M.', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. M.', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd. M. y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d. M. y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'M/y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. M. y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d. M. y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'H:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'H:mm z', // HOUR_MINUTETZ
        'jz': 'H z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale sl.
      'sl': const {
        'd': 'd.', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd. M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d. M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd. M. y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d. M. y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH\'h\'', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH\'h\'', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH\'h\' z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale sq.
      'sq': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M.y', // YEAR_NUM_MONTH
        'yMd': 'd.M.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ, y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ, y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a, v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a, z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale sr.
      'sr': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y.', // YEAR
        'yM': 'M.y.', // YEAR_NUM_MONTH
        'yMd': 'd.M.y.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y.', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y.', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y.', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y.', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y.', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y.', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale sr_Latn.
      'sr_Latn': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd.M.', // NUM_MONTH_DAY
        'MEd': 'EEE, d.M.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd. MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d. MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd. MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d. MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y.', // YEAR
        'yM': 'M.y.', // YEAR_NUM_MONTH
        'yMd': 'd.M.y.', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d.M.y.', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y.', // YEAR_ABBR_MONTH
        'yMMMd': 'd. MMM y.', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d. MMM y.', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y.', // YEAR_MONTH
        'yMMMMd': 'd. MMMM y.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d. MMMM y.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y.', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y.', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale sv.
      'sv': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'y-MM-dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, y-MM-dd', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale sw.
      'sw': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ta.
      'ta': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'dd-MM, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'a h', // HOUR
        'jm': 'a h:mm', // HOUR_MINUTE
        'jms': 'a h:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'a h:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'a h:mm z', // HOUR_MINUTETZ
        'jz': 'a h z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale te.
      'te': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd, MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d, MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'd, MMMM y, EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale th.
      'th': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEEที่ d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM G y', // YEAR_MONTH
        'yMMMMd': 'd MMMM G y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEEที่ d MMMM G y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ G y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm น.', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm น.', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale tl.
      'tl': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'EEE, M/d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'M/d/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, M/d/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale tr.
      'tr': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'd/MM EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'd MMMM EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'd MMMM EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'd.M.y EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'd MMM y EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'd MMMM y EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale uk.
      'uk': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'LL', // NUM_MONTH
        'Md': 'dd.MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd.MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd.MM.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'LLL y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'LLLL y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y \'р\'.', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y \'р\'.', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y \'р\'.', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ur.
      'ur': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE، d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE، d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE، d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE، d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM، y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE، d MMM، y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM، y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE، d MMMM، y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale uz.
      'uz': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'LL', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd-MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d-MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd-MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d-MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM, y', // YEAR_ABBR_MONTH
        'yMMMd': 'd-MMM, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d-MMM, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM, y', // YEAR_MONTH
        'yMMMMd': 'd-MMMM, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d-MMMM, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y, QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y, QQQQ', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm (v)', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm (z)', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale vi.
      'vi': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd/M', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM \'năm\' y', // YEAR_MONTH
        'yMMMMd': 'd MMMM, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ \'năm\' y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale zh.
      'zh': const {
        'd': 'd日', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'M月', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'M/dEEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'M月d日', // ABBR_MONTH_DAY
        'MMMEd': 'M月d日EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'M月d日', // MONTH_DAY
        'MMMMEEEEd': 'M月d日EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y年', // YEAR
        'yM': 'y年M月', // YEAR_NUM_MONTH
        'yMd': 'y/M/d', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y/M/dEEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y年M月', // YEAR_ABBR_MONTH
        'yMMMd': 'y年M月d日', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y年M月d日EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y年M月', // YEAR_MONTH
        'yMMMMd': 'y年M月d日', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y年M月d日EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y年第Q季度', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y年第Q季度', // YEAR_QUARTER
        'H': 'H时', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'ah时', // HOUR
        'jm': 'ah:mm', // HOUR_MINUTE
        'jms': 'ah:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'v ah:mm', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'z ah:mm', // HOUR_MINUTETZ
        'jz': 'zah时', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale zh_CN.
      'zh_CN': const {
        'd': 'd日', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'M月', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'M/dEEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'M月d日', // ABBR_MONTH_DAY
        'MMMEd': 'M月d日EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'M月d日', // MONTH_DAY
        'MMMMEEEEd': 'M月d日EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y年', // YEAR
        'yM': 'y年M月', // YEAR_NUM_MONTH
        'yMd': 'y/M/d', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y/M/dEEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y年M月', // YEAR_ABBR_MONTH
        'yMMMd': 'y年M月d日', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y年M月d日EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y年M月', // YEAR_MONTH
        'yMMMMd': 'y年M月d日', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y年M月d日EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y年第Q季度', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y年第Q季度', // YEAR_QUARTER
        'H': 'H时', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'ah时', // HOUR
        'jm': 'ah:mm', // HOUR_MINUTE
        'jms': 'ah:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'v ah:mm', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'z ah:mm', // HOUR_MINUTETZ
        'jz': 'zah时', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale zh_HK.
      'zh_HK': const {
        'd': 'd日', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'M月', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'd/M（EEE）', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'M月d日', // ABBR_MONTH_DAY
        'MMMEd': 'M月d日EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'M月d日', // MONTH_DAY
        'MMMMEEEEd': 'M月d日EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y年', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'd/M/y（EEE）', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y年M月', // YEAR_ABBR_MONTH
        'yMMMd': 'y年M月d日', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y年M月d日EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y年M月', // YEAR_MONTH
        'yMMMMd': 'y年M月d日', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y年M月d日EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y年QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y年QQQQ', // YEAR_QUARTER
        'H': 'H時', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'ah時', // HOUR
        'jm': 'ah:mm', // HOUR_MINUTE
        'jms': 'ah:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'ah:mm [v]', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'ah:mm [z]', // HOUR_MINUTETZ
        'jz': 'ah時 z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale zh_TW.
      'zh_TW': const {
        'd': 'd日', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'M月', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'M/d（EEE）', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'M月d日', // ABBR_MONTH_DAY
        'MMMEd': 'M月d日 EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'M月d日', // MONTH_DAY
        'MMMMEEEEd': 'M月d日 EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y年', // YEAR
        'yM': 'y/M', // YEAR_NUM_MONTH
        'yMd': 'y/M/d', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y/M/d（EEE）', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y年M月', // YEAR_ABBR_MONTH
        'yMMMd': 'y年M月d日', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y年M月d日 EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'y年M月', // YEAR_MONTH
        'yMMMMd': 'y年M月d日', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'y年M月d日 EEEE', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y年QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y年QQQQ', // YEAR_QUARTER
        'H': 'H時', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'ah時', // HOUR
        'jm': 'ah:mm', // HOUR_MINUTE
        'jms': 'ah:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'ah:mm [v]', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'ah:mm [z]', // HOUR_MINUTETZ
        'jz': 'ah時 z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale zu.
      'zu': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'MM-dd', // NUM_MONTH_DAY
        'MEd': 'MM-dd, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y-MM', // YEAR_NUM_MONTH
        'yMd': 'y-MM-dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y-MM-dd, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_ISO.
      'en_ISO': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'EEE, M/d', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, MMM d', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'MMMM d', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, MMMM d', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'M/d/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, M/d/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'MMM d, y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, MMM d, y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'MMMM d, y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, MMMM d, y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale en_MY.
      'en_MY': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd/MM', // NUM_MONTH_DAY
        'MEd': 'EEE, dd/MM', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE, d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE, d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM/y', // YEAR_NUM_MONTH
        'yMd': 'dd/MM/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd/MM/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE, d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'h a', // HOUR
        'jm': 'h:mm a', // HOUR_MINUTE
        'jms': 'h:mm:ss a', // HOUR_MINUTE_SECOND
        'jmv': 'h:mm a v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'h:mm a z', // HOUR_MINUTETZ
        'jz': 'h a z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale fr_CH.
      'fr_CH': const {
        'd': 'd', // DAY
        'E': 'EEE', // ABBR_WEEKDAY
        'EEEE': 'EEEE', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'dd.MM.', // NUM_MONTH_DAY
        'MEd': 'EEE, dd.MM.', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'MM.y', // YEAR_NUM_MONTH
        'yMd': 'dd.MM.y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE, dd.MM.y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH \'h\'', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH \'h\'', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH \'h\' z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale it_CH.
      'it_CH': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'd/M', // NUM_MONTH_DAY
        'MEd': 'EEE d/M', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'd MMM', // ABBR_MONTH_DAY
        'MMMEd': 'EEE d MMM', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'EEEE d MMMM', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'M/y', // YEAR_NUM_MONTH
        'yMd': 'd/M/y', // YEAR_NUM_MONTH_DAY
        'yMEd': 'EEE d/M/y', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'MMM y', // YEAR_ABBR_MONTH
        'yMMMd': 'd MMM y', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'EEE d MMM y', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'MMMM y', // YEAR_MONTH
        'yMMMMd': 'd MMMM y', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE, d MMMM y', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'QQQ y', // YEAR_ABBR_QUARTER
        'yQQQQ': 'QQQQ y', // YEAR_QUARTER
        'H': 'HH', // HOUR24
        'Hm': 'HH:mm', // HOUR24_MINUTE
        'Hms': 'HH:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'HH', // HOUR
        'jm': 'HH:mm', // HOUR_MINUTE
        'jms': 'HH:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'HH z', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      },

      /// Extended set of localized date/time patterns for locale ps.
      'ps': const {
        'd': 'd', // DAY
        'E': 'ccc', // ABBR_WEEKDAY
        'EEEE': 'cccc', // WEEKDAY
        'LLL': 'LLL', // ABBR_STANDALONE_MONTH
        'LLLL': 'LLLL', // STANDALONE_MONTH
        'M': 'L', // NUM_MONTH
        'Md': 'M/d', // NUM_MONTH_DAY
        'MEd': 'MM-dd, EEE', // NUM_MONTH_WEEKDAY_DAY
        'MMM': 'LLL', // ABBR_MONTH
        'MMMd': 'MMM d', // ABBR_MONTH_DAY
        'MMMEd': 'MMM d, EEE', // ABBR_MONTH_WEEKDAY_DAY
        'MMMM': 'LLLL', // MONTH
        'MMMMd': 'd MMMM', // MONTH_DAY
        'MMMMEEEEd': 'MMMM d, EEEE', // MONTH_WEEKDAY_DAY
        'QQQ': 'QQQ', // ABBR_QUARTER
        'QQQQ': 'QQQQ', // QUARTER
        'y': 'y', // YEAR
        'yM': 'y/M', // YEAR_NUM_MONTH
        'yMd': 'y-MM-dd', // YEAR_NUM_MONTH_DAY
        'yMEd': 'y-MM-dd, EEE', // YEAR_NUM_MONTH_WEEKDAY_DAY
        'yMMM': 'y MMM', // YEAR_ABBR_MONTH
        'yMMMd': 'y MMM d', // YEAR_ABBR_MONTH_DAY
        'yMMMEd': 'y MMM d, EEE', // YEAR_ABBR_MONTH_WEEKDAY_DAY
        'yMMMM': 'د y د MMMM', // YEAR_MONTH
        'yMMMMd': 'د y د MMMM d', // YEAR_MONTH_DAY
        'yMMMMEEEEd': 'EEEE د y د MMMM d', // YEAR_MONTH_WEEKDAY_DAY
        'yQQQ': 'y QQQ', // YEAR_ABBR_QUARTER
        'yQQQQ': 'y QQQQ', // YEAR_QUARTER
        'H': 'H', // HOUR24
        'Hm': 'H:mm', // HOUR24_MINUTE
        'Hms': 'H:mm:ss', // HOUR24_MINUTE_SECOND
        'j': 'H', // HOUR
        'jm': 'H:mm', // HOUR_MINUTE
        'jms': 'H:mm:ss', // HOUR_MINUTE_SECOND
        'jmv': 'HH:mm v', // HOUR_MINUTE_GENERIC_TZ
        'jmz': 'HH:mm z', // HOUR_MINUTETZ
        'jz': 'H (z)', // HOURGENERIC_TZ
        'm': 'm', // MINUTE
        'ms': 'mm:ss', // MINUTE_SECOND
        's': 's', // SECOND
        'v': 'v', // ABBR_GENERIC_TZ
        'z': 'z', // ABBR_SPECIFIC_TZ
        'zzzz': 'zzzz', // SPECIFIC_TZ
        'ZZZZ': 'ZZZZ' // ABBR_UTC_TZ
      }
    };
