// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated.  Please do not edit it manually.
// To regenerate the file, use:
// dart dev/tools/gen_localizations.dart --overwrite

// The TranslationBundle subclasses defined here encode all of the translations
// found in the flutter_localizations/lib/src/l10n/*.arb files.
//
// The [MaterialLocalizations] class uses the (generated)
// translationBundleForLocale() function to look up a const TranslationBundle
// instance for a locale.

// ignore_for_file: public_member_api_docs

import 'dart:ui' show Locale;

class TranslationBundle {
  const TranslationBundle(this.parent);
  final TranslationBundle parent;
  String get selectedRowCountTitleOne => parent?.selectedRowCountTitleOne;
  String get selectedRowCountTitleZero => parent?.selectedRowCountTitleZero;
  String get selectedRowCountTitleTwo => parent?.selectedRowCountTitleTwo;
  String get selectedRowCountTitleFew => parent?.selectedRowCountTitleFew;
  String get selectedRowCountTitleMany => parent?.selectedRowCountTitleMany;
  String get scriptCategory => parent?.scriptCategory;
  String get timeOfDayFormat => parent?.timeOfDayFormat;
  String get openAppDrawerTooltip => parent?.openAppDrawerTooltip;
  String get backButtonTooltip => parent?.backButtonTooltip;
  String get closeButtonTooltip => parent?.closeButtonTooltip;
  String get deleteButtonTooltip => parent?.deleteButtonTooltip;
  String get nextMonthTooltip => parent?.nextMonthTooltip;
  String get previousMonthTooltip => parent?.previousMonthTooltip;
  String get nextPageTooltip => parent?.nextPageTooltip;
  String get previousPageTooltip => parent?.previousPageTooltip;
  String get showMenuTooltip => parent?.showMenuTooltip;
  String get aboutListTileTitle => parent?.aboutListTileTitle;
  String get licensesPageTitle => parent?.licensesPageTitle;
  String get pageRowsInfoTitle => parent?.pageRowsInfoTitle;
  String get pageRowsInfoTitleApproximate => parent?.pageRowsInfoTitleApproximate;
  String get rowsPerPageTitle => parent?.rowsPerPageTitle;
  String get tabLabel => parent?.tabLabel;
  String get selectedRowCountTitleOther => parent?.selectedRowCountTitleOther;
  String get cancelButtonLabel => parent?.cancelButtonLabel;
  String get closeButtonLabel => parent?.closeButtonLabel;
  String get continueButtonLabel => parent?.continueButtonLabel;
  String get copyButtonLabel => parent?.copyButtonLabel;
  String get cutButtonLabel => parent?.cutButtonLabel;
  String get okButtonLabel => parent?.okButtonLabel;
  String get pasteButtonLabel => parent?.pasteButtonLabel;
  String get selectAllButtonLabel => parent?.selectAllButtonLabel;
  String get viewLicensesButtonLabel => parent?.viewLicensesButtonLabel;
  String get anteMeridiemAbbreviation => parent?.anteMeridiemAbbreviation;
  String get postMeridiemAbbreviation => parent?.postMeridiemAbbreviation;
  String get timePickerHourModeAnnouncement => parent?.timePickerHourModeAnnouncement;
  String get timePickerMinuteModeAnnouncement => parent?.timePickerMinuteModeAnnouncement;
  String get signedInLabel => parent?.signedInLabel;
  String get hideAccountsLabel => parent?.hideAccountsLabel;
  String get showAccountsLabel => parent?.showAccountsLabel;
  String get modalBarrierDismissLabel => parent?.modalBarrierDismissLabel;
}

// ignore: camel_case_types
class _Bundle_ar extends TranslationBundle {
  const _Bundle_ar() : super(null);
  @override String get selectedRowCountTitleOne => r'تم اختيار عنصر واحد';
  @override String get selectedRowCountTitleZero => r'لم يتم اختيار أي عنصر';
  @override String get selectedRowCountTitleTwo => r'تم اختيار عنصرين ($selectedRowCount)';
  @override String get selectedRowCountTitleFew => r'تم اختيار $selectedRowCount عنصر';
  @override String get selectedRowCountTitleMany => r'تم اختيار $selectedRowCount عنصرًا';
  @override String get scriptCategory => r'tall';
  @override String get timeOfDayFormat => r'h:mm a';
  @override String get openAppDrawerTooltip => r'فتح قائمة التنقل';
  @override String get backButtonTooltip => r'رجوع';
  @override String get closeButtonTooltip => r'إغلاق';
  @override String get deleteButtonTooltip => r'حذف';
  @override String get nextMonthTooltip => r'الشهر التالي';
  @override String get previousMonthTooltip => r'الشهر السابق';
  @override String get nextPageTooltip => r'الصفحة التالية';
  @override String get previousPageTooltip => r'الصفحة السابقة';
  @override String get showMenuTooltip => r'عرض القائمة';
  @override String get aboutListTileTitle => r'حول "$applicationName"';
  @override String get licensesPageTitle => r'التراخيص';
  @override String get pageRowsInfoTitle => r'من $firstRow إلى $lastRow من إجمالي $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'من $firstRow إلى $lastRow من إجمالي $rowCount تقريبًا';
  @override String get rowsPerPageTitle => r'عدد الصفوف في الصفحة:';
  @override String get tabLabel => r'علامة التبويب $tabIndex من $tabCount';
  @override String get selectedRowCountTitleOther => r'تم اختيار $selectedRowCount عنصر';
  @override String get cancelButtonLabel => r'إلغاء';
  @override String get closeButtonLabel => r'إغلاق';
  @override String get continueButtonLabel => r'متابعة';
  @override String get copyButtonLabel => r'نسخ';
  @override String get cutButtonLabel => r'قص';
  @override String get okButtonLabel => r'حسنًا';
  @override String get pasteButtonLabel => r'لصق';
  @override String get selectAllButtonLabel => r'اختيار الكل';
  @override String get viewLicensesButtonLabel => r'الاطّلاع على التراخيص';
  @override String get anteMeridiemAbbreviation => r'ص';
  @override String get postMeridiemAbbreviation => r'م';
  @override String get timePickerHourModeAnnouncement => r'اختيار الساعات';
  @override String get timePickerMinuteModeAnnouncement => r'اختيار الدقائق';
  @override String get signedInLabel => r'تم تسجيل الدخول';
  @override String get hideAccountsLabel => r'إخفاء الحسابات';
  @override String get showAccountsLabel => r'إظهار الحسابات';
  @override String get modalBarrierDismissLabel => r'رفض';
}

// ignore: camel_case_types
class _Bundle_de extends TranslationBundle {
  const _Bundle_de() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get openAppDrawerTooltip => r'Navigationsmenü öffnen';
  @override String get backButtonTooltip => r'Zurück';
  @override String get closeButtonTooltip => r'Schließen';
  @override String get deleteButtonTooltip => r'Löschen';
  @override String get nextMonthTooltip => r'Nächster Monat';
  @override String get previousMonthTooltip => r'Vorheriger Monat';
  @override String get nextPageTooltip => r'Nächste Seite';
  @override String get previousPageTooltip => r'Vorherige Seite';
  @override String get showMenuTooltip => r'Menü anzeigen';
  @override String get aboutListTileTitle => r'Über $applicationName';
  @override String get licensesPageTitle => r'Lizenzen';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow von $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow von etwa $rowCount';
  @override String get rowsPerPageTitle => r'Zeilen pro Seite:';
  @override String get tabLabel => r'Tab $tabIndex von $tabCount';
  @override String get selectedRowCountTitleZero => r'Keine Objekte ausgewählt';
  @override String get selectedRowCountTitleOne => r'1 Element ausgewählt';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount Elemente ausgewählt';
  @override String get cancelButtonLabel => r'ABBRECHEN';
  @override String get closeButtonLabel => r'SCHLIEẞEN';
  @override String get continueButtonLabel => r'WEITER';
  @override String get copyButtonLabel => r'KOPIEREN';
  @override String get cutButtonLabel => r'AUSSCHNEIDEN';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'EINFÜGEN';
  @override String get selectAllButtonLabel => r'ALLE AUSWÄHLEN';
  @override String get viewLicensesButtonLabel => r'LIZENZEN ANZEIGEN';
  @override String get anteMeridiemAbbreviation => r'VORM.';
  @override String get postMeridiemAbbreviation => r'NACHM.';
  @override String get timePickerHourModeAnnouncement => r'Stunden auswählen';
  @override String get timePickerMinuteModeAnnouncement => r'Minuten auswählen';
  @override String get signedInLabel => r'Angemeldet';
  @override String get hideAccountsLabel => r'Konten ausblenden';
  @override String get showAccountsLabel => r'Konten anzeigen';
  @override String get modalBarrierDismissLabel => r'Schließen';
}

// ignore: camel_case_types
class _Bundle_en extends TranslationBundle {
  const _Bundle_en() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'h:mm a';
  @override String get openAppDrawerTooltip => r'Open navigation menu';
  @override String get backButtonTooltip => r'Back';
  @override String get closeButtonTooltip => r'Close';
  @override String get deleteButtonTooltip => r'Delete';
  @override String get nextMonthTooltip => r'Next month';
  @override String get previousMonthTooltip => r'Previous month';
  @override String get nextPageTooltip => r'Next page';
  @override String get previousPageTooltip => r'Previous page';
  @override String get showMenuTooltip => r'Show menu';
  @override String get aboutListTileTitle => r'About $applicationName';
  @override String get licensesPageTitle => r'Licenses';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow of $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow of about $rowCount';
  @override String get rowsPerPageTitle => r'Rows per page:';
  @override String get tabLabel => r'Tab $tabIndex of $tabCount';
  @override String get selectedRowCountTitleZero => r'No items selected';
  @override String get selectedRowCountTitleOne => r'1 item selected';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount items selected';
  @override String get cancelButtonLabel => r'CANCEL';
  @override String get closeButtonLabel => r'CLOSE';
  @override String get continueButtonLabel => r'CONTINUE';
  @override String get copyButtonLabel => r'COPY';
  @override String get cutButtonLabel => r'CUT';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'PASTE';
  @override String get selectAllButtonLabel => r'SELECT ALL';
  @override String get viewLicensesButtonLabel => r'VIEW LICENSES';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'Select hours';
  @override String get timePickerMinuteModeAnnouncement => r'Select minutes';
  @override String get modalBarrierDismissLabel => r'Dismiss';
  @override String get signedInLabel => r'Signed in';
  @override String get hideAccountsLabel => r'Hide accounts';
  @override String get showAccountsLabel => r'Show accounts';
}

// ignore: camel_case_types
class _Bundle_es extends TranslationBundle {
  const _Bundle_es() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'H:mm';
  @override String get openAppDrawerTooltip => r'Abrir el menú de navegación';
  @override String get backButtonTooltip => r'Atrás';
  @override String get closeButtonTooltip => r'Cerrar';
  @override String get deleteButtonTooltip => r'Eliminar';
  @override String get nextMonthTooltip => r'Mes siguiente';
  @override String get previousMonthTooltip => r'Mes anterior';
  @override String get nextPageTooltip => r'Página siguiente';
  @override String get previousPageTooltip => r'Página anterior';
  @override String get showMenuTooltip => r'Mostrar menú';
  @override String get aboutListTileTitle => r'Sobre $applicationName';
  @override String get licensesPageTitle => r'Licencias';
  @override String get pageRowsInfoTitle => r'$firstRow‑$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow‑$lastRow de aproximadamente $rowCount';
  @override String get rowsPerPageTitle => r'Filas por página:';
  @override String get tabLabel => r'Pestaña $tabIndex de $tabCount';
  @override String get selectedRowCountTitleZero => r'No se han seleccionado elementos';
  @override String get selectedRowCountTitleOne => r'1 elemento seleccionado';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount elementos seleccionados';
  @override String get cancelButtonLabel => r'CANCELAR';
  @override String get closeButtonLabel => r'CERRAR';
  @override String get continueButtonLabel => r'CONTINUAR';
  @override String get copyButtonLabel => r'COPIAR';
  @override String get cutButtonLabel => r'CORTAR';
  @override String get okButtonLabel => r'ACEPTAR';
  @override String get pasteButtonLabel => r'PEGAR';
  @override String get selectAllButtonLabel => r'SELECCIONAR TODO';
  @override String get viewLicensesButtonLabel => r'VER LICENCIAS';
  @override String get anteMeridiemAbbreviation => r'A.M.';
  @override String get postMeridiemAbbreviation => r'P.M.';
  @override String get timePickerHourModeAnnouncement => r'Seleccionar horas';
  @override String get timePickerMinuteModeAnnouncement => r'Seleccionar minutos';
  @override String get signedInLabel => r'Sesión iniciada';
  @override String get hideAccountsLabel => r'Ocultar cuentas';
  @override String get showAccountsLabel => r'Mostrar cuentas';
  @override String get modalBarrierDismissLabel => r'Ignorar';
}

// ignore: camel_case_types
class _Bundle_fa extends TranslationBundle {
  const _Bundle_fa() : super(null);
  @override String get scriptCategory => r'tall';
  @override String get timeOfDayFormat => r'H:mm';
  @override String get selectedRowCountTitleOne => r'۱ مورد انتخاب شد';
  @override String get openAppDrawerTooltip => r'باز کردن منوی پیمایش';
  @override String get backButtonTooltip => r'برگشت';
  @override String get closeButtonTooltip => r'بستن';
  @override String get deleteButtonTooltip => r'حذف';
  @override String get nextMonthTooltip => r'ماه بعد';
  @override String get previousMonthTooltip => r'ماه قبل';
  @override String get nextPageTooltip => r'صفحه بعد';
  @override String get previousPageTooltip => r'صفحه قبل';
  @override String get showMenuTooltip => r'نمایش منو';
  @override String get aboutListTileTitle => r'درباره $applicationName';
  @override String get licensesPageTitle => r'مجوزها';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow از $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow از حدود $rowCount';
  @override String get rowsPerPageTitle => r'ردیف در هر صفحه:';
  @override String get tabLabel => r'برگه $tabIndex از $tabCount';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount مورد انتخاب شدند';
  @override String get cancelButtonLabel => r'لغو';
  @override String get closeButtonLabel => r'بستن';
  @override String get continueButtonLabel => r'ادامه';
  @override String get copyButtonLabel => r'کپی';
  @override String get cutButtonLabel => r'برش';
  @override String get okButtonLabel => r'تأیید';
  @override String get pasteButtonLabel => r'جای‌گذاری';
  @override String get selectAllButtonLabel => r'انتخاب همه';
  @override String get viewLicensesButtonLabel => r'مشاهده مجوزها';
  @override String get anteMeridiemAbbreviation => r'ق.ظ.';
  @override String get postMeridiemAbbreviation => r'ب.ظ.';
  @override String get timePickerHourModeAnnouncement => r'انتخاب ساعت';
  @override String get timePickerMinuteModeAnnouncement => r'انتخاب دقیقه';
  @override String get signedInLabel => r'واردشده به سیستم';
  @override String get hideAccountsLabel => r'پنهان کردن حساب‌ها';
  @override String get showAccountsLabel => r'نشان دادن حساب‌ها';
  @override String get modalBarrierDismissLabel => r'نپذیرفتن';
}

// ignore: camel_case_types
class _Bundle_fr extends TranslationBundle {
  const _Bundle_fr() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get openAppDrawerTooltip => r'Ouvrir le menu de navigation';
  @override String get backButtonTooltip => r'Retour';
  @override String get closeButtonTooltip => r'Fermer';
  @override String get deleteButtonTooltip => r'Supprimer';
  @override String get nextMonthTooltip => r'Mois suivant';
  @override String get previousMonthTooltip => r'Mois précédent';
  @override String get nextPageTooltip => r'Page suivante';
  @override String get previousPageTooltip => r'Page précédente';
  @override String get showMenuTooltip => r'Afficher le menu';
  @override String get aboutListTileTitle => r'À propos de $applicationName';
  @override String get licensesPageTitle => r'Licences';
  @override String get pageRowsInfoTitle => r'$firstRow – $lastRow sur $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow – $lastRow sur environ $rowCount';
  @override String get rowsPerPageTitle => r'Lignes par page :';
  @override String get tabLabel => r'Onglet $tabIndex sur $tabCount';
  @override String get selectedRowCountTitleZero => r'Aucun élément sélectionné';
  @override String get selectedRowCountTitleOne => r'1 élément sélectionné';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount éléments sélectionnés';
  @override String get cancelButtonLabel => r'ANNULER';
  @override String get closeButtonLabel => r'FERMER';
  @override String get continueButtonLabel => r'CONTINUER';
  @override String get copyButtonLabel => r'COPIER';
  @override String get cutButtonLabel => r'COUPER';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'COLLER';
  @override String get selectAllButtonLabel => r'TOUT SÉLECTIONNER';
  @override String get viewLicensesButtonLabel => r'AFFICHER LES LICENCES';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'Sélectionner une heure';
  @override String get timePickerMinuteModeAnnouncement => r'Sélectionner des minutes';
  @override String get signedInLabel => r'Connecté';
  @override String get hideAccountsLabel => r'Masquer les comptes';
  @override String get showAccountsLabel => r'Afficher les comptes';
  @override String get modalBarrierDismissLabel => r'Ignorer';
}

// ignore: camel_case_types
class _Bundle_gsw extends TranslationBundle {
  const _Bundle_gsw() : super(null);
  @override String get tabLabel => r'Tab $tabIndex von $tabCount';
  @override String get showAccountsLabel => r'Konten anzeigen';
  @override String get hideAccountsLabel => r'Konten ausblenden';
  @override String get signedInLabel => r'Angemeldet';
  @override String get timePickerMinuteModeAnnouncement => r'Minuten auswählen';
  @override String get timePickerHourModeAnnouncement => r'Stunden auswählen';
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get openAppDrawerTooltip => r'Navigationsmenü öffnen';
  @override String get backButtonTooltip => r'Zurück';
  @override String get closeButtonTooltip => r'Schließen';
  @override String get deleteButtonTooltip => r'Löschen';
  @override String get nextMonthTooltip => r'Nächster Monat';
  @override String get previousMonthTooltip => r'Vorheriger Monat';
  @override String get nextPageTooltip => r'Nächste Seite';
  @override String get previousPageTooltip => r'Vorherige Seite';
  @override String get showMenuTooltip => r'Menü anzeigen';
  @override String get aboutListTileTitle => r'Über $applicationName';
  @override String get licensesPageTitle => r'Lizenzen';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow von $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow von etwa $rowCount';
  @override String get rowsPerPageTitle => r'Zeilen pro Seite:';
  @override String get selectedRowCountTitleOne => r'1 Element ausgewählt';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount Elemente ausgewählt';
  @override String get cancelButtonLabel => r'ABBRECHEN';
  @override String get closeButtonLabel => r'SCHLIEẞEN';
  @override String get continueButtonLabel => r'WEITER';
  @override String get copyButtonLabel => r'KOPIEREN';
  @override String get cutButtonLabel => r'AUSSCHNEIDEN';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'EINFÜGEN';
  @override String get selectAllButtonLabel => r'ALLE AUSWÄHLEN';
  @override String get viewLicensesButtonLabel => r'LIZENZEN ANZEIGEN';
  @override String get anteMeridiemAbbreviation => r'VORM.';
  @override String get postMeridiemAbbreviation => r'NACHM.';
  @override String get modalBarrierDismissLabel => r'Schließen';
}

// ignore: camel_case_types
class _Bundle_he extends TranslationBundle {
  const _Bundle_he() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'H:mm';
  @override String get selectedRowCountTitleOne => r'פריט אחד נבחר';
  @override String get selectedRowCountTitleTwo => r'$selectedRowCount פריטים נבחרו';
  @override String get selectedRowCountTitleMany => r'$selectedRowCount פריטים נבחרו';
  @override String get openAppDrawerTooltip => r'פתיחה של תפריט הניווט';
  @override String get backButtonTooltip => r'הקודם';
  @override String get closeButtonTooltip => r'סגירה';
  @override String get deleteButtonTooltip => r'מחיקה';
  @override String get nextMonthTooltip => r'החודש הבא';
  @override String get previousMonthTooltip => r'החודש הקודם';
  @override String get nextPageTooltip => r'הדף הבא';
  @override String get previousPageTooltip => r'הדף הקודם';
  @override String get showMenuTooltip => r'הצגת התפריט';
  @override String get aboutListTileTitle => r'מידע על $applicationName';
  @override String get licensesPageTitle => r'רישיונות';
  @override String get pageRowsInfoTitle => r'$lastRow–$firstRow מתוך $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$lastRow–$firstRow מתוך כ-$rowCount';
  @override String get rowsPerPageTitle => r'שורות בכל דף:';
  @override String get tabLabel => r'כרטיסייה $tabIndex מתוך $tabCount';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount פריטים נבחרו';
  @override String get cancelButtonLabel => r'ביטול';
  @override String get closeButtonLabel => r'סגירה';
  @override String get continueButtonLabel => r'המשך';
  @override String get copyButtonLabel => r'העתקה';
  @override String get cutButtonLabel => r'גזירה';
  @override String get okButtonLabel => r'אישור';
  @override String get pasteButtonLabel => r'הדבקה';
  @override String get selectAllButtonLabel => r'בחירת הכול';
  @override String get viewLicensesButtonLabel => r'הצגת הרישיונות';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'בחירת שעות';
  @override String get timePickerMinuteModeAnnouncement => r'בחירת דקות';
  @override String get signedInLabel => r'מחובר';
  @override String get hideAccountsLabel => r'הסתרת החשבונות';
  @override String get showAccountsLabel => r'הצגת החשבונות';
  @override String get modalBarrierDismissLabel => r'סגירה';
}

// ignore: camel_case_types
class _Bundle_it extends TranslationBundle {
  const _Bundle_it() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get selectedRowCountTitleOne => r'1 elemento selezionato';
  @override String get openAppDrawerTooltip => r'Apri il menu di navigazione';
  @override String get backButtonTooltip => r'Indietro';
  @override String get closeButtonTooltip => r'Chiudi';
  @override String get deleteButtonTooltip => r'Elimina';
  @override String get nextMonthTooltip => r'Mese successivo';
  @override String get previousMonthTooltip => r'Mese precedente';
  @override String get nextPageTooltip => r'Pagina successiva';
  @override String get previousPageTooltip => r'Pagina precedente';
  @override String get showMenuTooltip => r'Mostra il menu';
  @override String get aboutListTileTitle => r'Informazioni su $applicationName';
  @override String get licensesPageTitle => r'Licenze';
  @override String get pageRowsInfoTitle => r'$firstRow-$lastRow di $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow-$lastRow di circa $rowCount';
  @override String get rowsPerPageTitle => r'Righe per pagina:';
  @override String get tabLabel => r'Scheda $tabIndex di $tabCount';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount elementi selezionati';
  @override String get cancelButtonLabel => r'ANNULLA';
  @override String get closeButtonLabel => r'CHIUDI';
  @override String get continueButtonLabel => r'CONTINUA';
  @override String get copyButtonLabel => r'COPIA';
  @override String get cutButtonLabel => r'TAGLIA';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'INCOLLA';
  @override String get selectAllButtonLabel => r'SELEZIONA TUTTO';
  @override String get viewLicensesButtonLabel => r'VISUALIZZA LICENZE';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'Seleziona le ore';
  @override String get timePickerMinuteModeAnnouncement => r'Seleziona i minuti';
  @override String get signedInLabel => r'Connesso';
  @override String get hideAccountsLabel => r'Nascondi account';
  @override String get showAccountsLabel => r'Mostra account';
  @override String get modalBarrierDismissLabel => r'Ignora';
}

// ignore: camel_case_types
class _Bundle_ja extends TranslationBundle {
  const _Bundle_ja() : super(null);
  @override String get scriptCategory => r'dense';
  @override String get timeOfDayFormat => r'H:mm';
  @override String get selectedRowCountTitleOne => r'1 件のアイテムを選択中';
  @override String get openAppDrawerTooltip => r'ナビゲーション メニューを開く';
  @override String get backButtonTooltip => r'戻る';
  @override String get closeButtonTooltip => r'閉じる';
  @override String get deleteButtonTooltip => r'削除';
  @override String get nextMonthTooltip => r'来月';
  @override String get previousMonthTooltip => r'前月';
  @override String get nextPageTooltip => r'次のページ';
  @override String get previousPageTooltip => r'前のページ';
  @override String get showMenuTooltip => r'メニューを表示';
  @override String get aboutListTileTitle => r'$applicationName について';
  @override String get licensesPageTitle => r'ライセンス';
  @override String get pageRowsInfoTitle => r'$firstRow - $lastRow 行（合計 $rowCount 行）';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow – $lastRow 行（合計約 $rowCount 行）';
  @override String get rowsPerPageTitle => r'ページあたりの行数:';
  @override String get tabLabel => r'タブ: $tabIndex/$tabCount';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount 件のアイテムを選択中';
  @override String get cancelButtonLabel => r'キャンセル';
  @override String get closeButtonLabel => r'閉じる';
  @override String get continueButtonLabel => r'続行';
  @override String get copyButtonLabel => r'コピー';
  @override String get cutButtonLabel => r'切り取り';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'貼り付け';
  @override String get selectAllButtonLabel => r'すべて選択';
  @override String get viewLicensesButtonLabel => r'ライセンスを表示';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'時間を選択';
  @override String get timePickerMinuteModeAnnouncement => r'分を選択';
  @override String get signedInLabel => r'ログイン中';
  @override String get hideAccountsLabel => r'アカウントを非表示';
  @override String get showAccountsLabel => r'アカウントを表示';
  @override String get modalBarrierDismissLabel => r'閉じる';
}

// ignore: camel_case_types
class _Bundle_ko extends TranslationBundle {
  const _Bundle_ko() : super(null);
  @override String get scriptCategory => r'dense';
  @override String get timeOfDayFormat => r'a h:mm';
  @override String get openAppDrawerTooltip => r'탐색 메뉴 열기';
  @override String get backButtonTooltip => r'뒤로';
  @override String get closeButtonTooltip => r'닫기';
  @override String get deleteButtonTooltip => r'삭제';
  @override String get nextMonthTooltip => r'다음 달';
  @override String get previousMonthTooltip => r'지난달';
  @override String get nextPageTooltip => r'다음 페이지';
  @override String get previousPageTooltip => r'이전 페이지';
  @override String get showMenuTooltip => r'메뉴 표시';
  @override String get aboutListTileTitle => r'$applicationName 정보';
  @override String get licensesPageTitle => r'라이선스';
  @override String get pageRowsInfoTitle => r'$rowCount행 중 $firstRow~$lastRow행';
  @override String get pageRowsInfoTitleApproximate => r'약 $rowCount행 중 $firstRow~$lastRow행';
  @override String get rowsPerPageTitle => r'페이지당 행 수:';
  @override String get tabLabel => r'탭 $tabCount개 중 $tabIndex번째';
  @override String get selectedRowCountTitleOne => r'항목 1개 선택됨';
  @override String get selectedRowCountTitleOther => r'항목 $selectedRowCount개 선택됨';
  @override String get cancelButtonLabel => r'취소';
  @override String get closeButtonLabel => r'닫기';
  @override String get continueButtonLabel => r'계속';
  @override String get copyButtonLabel => r'복사';
  @override String get cutButtonLabel => r'잘라내기';
  @override String get okButtonLabel => r'확인';
  @override String get pasteButtonLabel => r'붙여넣기';
  @override String get selectAllButtonLabel => r'전체 선택';
  @override String get viewLicensesButtonLabel => r'라이선스 보기';
  @override String get anteMeridiemAbbreviation => r'오전';
  @override String get postMeridiemAbbreviation => r'오후';
  @override String get timePickerHourModeAnnouncement => r'시간 선택';
  @override String get timePickerMinuteModeAnnouncement => r'분 선택';
  @override String get signedInLabel => r'로그인됨';
  @override String get hideAccountsLabel => r'계정 숨기기';
  @override String get showAccountsLabel => r'계정 표시';
  @override String get modalBarrierDismissLabel => r'닫기';
}

// ignore: camel_case_types
class _Bundle_nl extends TranslationBundle {
  const _Bundle_nl() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get openAppDrawerTooltip => r'Navigatiemenu openen';
  @override String get backButtonTooltip => r'Terug';
  @override String get closeButtonTooltip => r'Sluiten';
  @override String get deleteButtonTooltip => r'Verwijderen';
  @override String get nextMonthTooltip => r'Volgende maand';
  @override String get previousMonthTooltip => r'Vorige maand';
  @override String get nextPageTooltip => r'Volgende pagina';
  @override String get previousPageTooltip => r'Vorige pagina';
  @override String get showMenuTooltip => r'Menu weergeven';
  @override String get aboutListTileTitle => r'Over $applicationName';
  @override String get licensesPageTitle => r'Licenties';
  @override String get pageRowsInfoTitle => r'$firstRow-$lastRow van $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow-$lastRow van ongeveer $rowCount';
  @override String get rowsPerPageTitle => r'Rijen per pagina:';
  @override String get tabLabel => r'Tabblad $tabIndex van $tabCount';
  @override String get selectedRowCountTitleOne => r'1 item geselecteerd';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount items geselecteerd';
  @override String get cancelButtonLabel => r'ANNULEREN';
  @override String get closeButtonLabel => r'SLUITEN';
  @override String get continueButtonLabel => r'DOORGAAN';
  @override String get copyButtonLabel => r'KOPIËREN';
  @override String get cutButtonLabel => r'KNIPPEN';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'PLAKKEN';
  @override String get selectAllButtonLabel => r'ALLES SELECTEREN';
  @override String get viewLicensesButtonLabel => r'LICENTIES BEKIJKEN';
  @override String get anteMeridiemAbbreviation => r'am';
  @override String get postMeridiemAbbreviation => r'pm';
  @override String get timePickerHourModeAnnouncement => r'Uren selecteren';
  @override String get timePickerMinuteModeAnnouncement => r'Minuten selecteren';
  @override String get signedInLabel => r'Ingelogd';
  @override String get hideAccountsLabel => r'Accounts verbergen';
  @override String get showAccountsLabel => r'Accounts weergeven';
  @override String get modalBarrierDismissLabel => r'Sluiten';
}

// ignore: camel_case_types
class _Bundle_pl extends TranslationBundle {
  const _Bundle_pl() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get selectedRowCountTitleFew => r'$selectedRowCount wybrane elementy';
  @override String get selectedRowCountTitleMany => r'$selectedRowCount wybranych elementów';
  @override String get openAppDrawerTooltip => r'Otwórz menu nawigacyjne';
  @override String get backButtonTooltip => r'Wstecz';
  @override String get closeButtonTooltip => r'Zamknij';
  @override String get deleteButtonTooltip => r'Usuń';
  @override String get nextMonthTooltip => r'Następny miesiąc';
  @override String get previousMonthTooltip => r'Poprzedni miesiąc';
  @override String get nextPageTooltip => r'Następna strona';
  @override String get previousPageTooltip => r'Poprzednia strona';
  @override String get showMenuTooltip => r'Pokaż menu';
  @override String get aboutListTileTitle => r'$applicationName – informacje';
  @override String get licensesPageTitle => r'Licencje';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow z $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow z około $rowCount';
  @override String get rowsPerPageTitle => r'Wiersze na stronie:';
  @override String get tabLabel => r'Karta $tabIndex z $tabCount';
  @override String get selectedRowCountTitleOne => r'1 wybrany element';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount wybranego elementu';
  @override String get cancelButtonLabel => r'ANULUJ';
  @override String get closeButtonLabel => r'ZAMKNIJ';
  @override String get continueButtonLabel => r'DALEJ';
  @override String get copyButtonLabel => r'KOPIUJ';
  @override String get cutButtonLabel => r'WYTNIJ';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'WKLEJ';
  @override String get selectAllButtonLabel => r'ZAZNACZ WSZYSTKO';
  @override String get viewLicensesButtonLabel => r'WYŚWIETL LICENCJE';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'Wybierz godziny';
  @override String get timePickerMinuteModeAnnouncement => r'Wybierz minuty';
  @override String get signedInLabel => r'Zalogowani użytkownicy';
  @override String get hideAccountsLabel => r'Ukryj konta';
  @override String get showAccountsLabel => r'Pokaż konta';
  @override String get modalBarrierDismissLabel => r'Zamknij';
}

// ignore: camel_case_types
class _Bundle_ps extends TranslationBundle {
  const _Bundle_ps() : super(null);
  @override String get scriptCategory => r'tall';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get openAppDrawerTooltip => r'د پرانیستی نیینګ مینو';
  @override String get backButtonTooltip => r'شاته';
  @override String get closeButtonTooltip => r'بنده';
  @override String get deleteButtonTooltip => r'';
  @override String get nextMonthTooltip => r'بله میاشت';
  @override String get previousMonthTooltip => r'تیره میاشت';
  @override String get nextPageTooltip => r'بله پاڼه';
  @override String get previousPageTooltip => r'مخکینی مخ';
  @override String get showMenuTooltip => r'غورنۍ ښودل';
  @override String get aboutListTileTitle => r'د $applicationName په اړه';
  @override String get licensesPageTitle => r'جوازونه';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow د $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow څخه $rowCount د';
  @override String get rowsPerPageTitle => r'د هرې پاڼې پاڼې:';
  @override String get tabLabel => r'$tabIndex د $tabCount';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount توکي غوره شوي';
  @override String get cancelButtonLabel => r'لغوه کول';
  @override String get closeButtonLabel => r'تړل';
  @override String get continueButtonLabel => r'منځپانګې';
  @override String get copyButtonLabel => r'کاپی';
  @override String get cutButtonLabel => r'کم کړئ';
  @override String get okButtonLabel => r'سمه ده';
  @override String get pasteButtonLabel => r'پیټ کړئ';
  @override String get selectAllButtonLabel => r'غوره کړئ';
  @override String get viewLicensesButtonLabel => r'لیدلس وګورئ';
  @override String get timePickerHourModeAnnouncement => r'وختونه وټاکئ';
  @override String get timePickerMinuteModeAnnouncement => r'منې غوره کړئ';
  @override String get signedInLabel => r'ننوتل';
  @override String get hideAccountsLabel => r'حسابونه پټ کړئ';
  @override String get showAccountsLabel => r'حسابونه ښکاره کړئ';
  @override String get modalBarrierDismissLabel => r'رد کړه';
}

// ignore: camel_case_types
class _Bundle_pt extends TranslationBundle {
  const _Bundle_pt() : super(null);
  @override String get anteMeridiemAbbreviation => r'Manhã';
  @override String get selectedRowCountTitleOne => r'1 item selecionado';
  @override String get postMeridiemAbbreviation => r'Tarde/noite';
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get openAppDrawerTooltip => r'Abrir menu de navegação';
  @override String get backButtonTooltip => r'Voltar';
  @override String get closeButtonTooltip => r'Fechar';
  @override String get deleteButtonTooltip => r'Excluir';
  @override String get nextMonthTooltip => r'Próximo mês';
  @override String get previousMonthTooltip => r'Mês anterior';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get previousPageTooltip => r'Página anterior';
  @override String get showMenuTooltip => r'Mostrar menu';
  @override String get aboutListTileTitle => r'Sobre o app $applicationName';
  @override String get licensesPageTitle => r'Licenças';
  @override String get pageRowsInfoTitle => r'$firstRow – $lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow – $lastRow de aproximadamente $rowCount';
  @override String get rowsPerPageTitle => r'Linhas por página:';
  @override String get tabLabel => r'Guia $tabIndex de $tabCount';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount itens selecionados';
  @override String get cancelButtonLabel => r'CANCELAR';
  @override String get closeButtonLabel => r'FECHAR';
  @override String get continueButtonLabel => r'CONTINUAR';
  @override String get copyButtonLabel => r'COPIAR';
  @override String get cutButtonLabel => r'RECORTAR';
  @override String get okButtonLabel => r'Ok';
  @override String get pasteButtonLabel => r'COLAR';
  @override String get selectAllButtonLabel => r'SELECIONAR TUDO';
  @override String get viewLicensesButtonLabel => r'VER LICENÇAS';
  @override String get timePickerHourModeAnnouncement => r'Selecione as horas';
  @override String get timePickerMinuteModeAnnouncement => r'Selecione os minutos';
  @override String get signedInLabel => r'Conectado a';
  @override String get hideAccountsLabel => r'Ocultar contas';
  @override String get showAccountsLabel => r'Mostrar contas';
  @override String get modalBarrierDismissLabel => r'Dispensar';
}

// ignore: camel_case_types
class _Bundle_ro extends TranslationBundle {
  const _Bundle_ro() : super(null);
  @override String get selectedRowCountTitleFew => r'$selectedRowCount articole selectate';
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get openAppDrawerTooltip => r'Deschideți meniul de navigare';
  @override String get backButtonTooltip => r'Înapoi';
  @override String get closeButtonTooltip => r'Închideți';
  @override String get deleteButtonTooltip => r'Ștergeți';
  @override String get nextMonthTooltip => r'Luna viitoare';
  @override String get previousMonthTooltip => r'Luna trecută';
  @override String get nextPageTooltip => r'Pagina următoare';
  @override String get previousPageTooltip => r'Pagina anterioară';
  @override String get showMenuTooltip => r'Afișați meniul';
  @override String get aboutListTileTitle => r'Despre $applicationName';
  @override String get licensesPageTitle => r'Licențe';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow din $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow din aproximativ $rowCount';
  @override String get rowsPerPageTitle => r'Rânduri pe pagină:';
  @override String get tabLabel => r'Fila $tabIndex din $tabCount';
  @override String get selectedRowCountTitleZero => r'Nu există elemente selectate';
  @override String get selectedRowCountTitleOne => r'Un articol selectat';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount de articole selectate';
  @override String get cancelButtonLabel => r'ANULAȚI';
  @override String get closeButtonLabel => r'ÎNCHIDEȚI';
  @override String get continueButtonLabel => r'CONTINUAȚI';
  @override String get copyButtonLabel => r'COPIAȚI';
  @override String get cutButtonLabel => r'DECUPAȚI';
  @override String get okButtonLabel => r'OK';
  @override String get pasteButtonLabel => r'INSERAȚI';
  @override String get selectAllButtonLabel => r'SELECTAȚI TOATE';
  @override String get viewLicensesButtonLabel => r'VEDEȚI LICENȚELE';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
  @override String get timePickerHourModeAnnouncement => r'Selectați orele';
  @override String get timePickerMinuteModeAnnouncement => r'Selectați minutele';
  @override String get signedInLabel => r'V-ați conectat';
  @override String get hideAccountsLabel => r'Ascundeți conturile';
  @override String get showAccountsLabel => r'Afișați conturile';
  @override String get modalBarrierDismissLabel => r'Închideți';
}

// ignore: camel_case_types
class _Bundle_ru extends TranslationBundle {
  const _Bundle_ru() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'H:mm';
  @override String get selectedRowCountTitleFew => r'Выбрано $selectedRowCount объекта';
  @override String get selectedRowCountTitleMany => r'Выбрано $selectedRowCount объектов';
  @override String get openAppDrawerTooltip => r'Открыть меню навигации';
  @override String get backButtonTooltip => r'Назад';
  @override String get closeButtonTooltip => r'Закрыть';
  @override String get deleteButtonTooltip => r'Удалить';
  @override String get nextMonthTooltip => r'Следующий месяц';
  @override String get previousMonthTooltip => r'Предыдущий месяц';
  @override String get nextPageTooltip => r'Следующая страница';
  @override String get previousPageTooltip => r'Предыдущая страница';
  @override String get showMenuTooltip => r'Показать меню';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow из $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow из примерно $rowCount';
  @override String get rowsPerPageTitle => r'Строк на странице:';
  @override String get tabLabel => r'Вкладка $tabIndex из $tabCount';
  @override String get aboutListTileTitle => r'$applicationName: сведения';
  @override String get licensesPageTitle => r'Лицензии';
  @override String get selectedRowCountTitleZero => r'Строки не выбраны';
  @override String get selectedRowCountTitleOne => r'Выбран 1 объект';
  @override String get selectedRowCountTitleOther => r'Выбрано $selectedRowCount объекта';
  @override String get cancelButtonLabel => r'ОТМЕНА';
  @override String get closeButtonLabel => r'ЗАКРЫТЬ';
  @override String get continueButtonLabel => r'ПРОДОЛЖИТЬ';
  @override String get copyButtonLabel => r'КОПИРОВАТЬ';
  @override String get cutButtonLabel => r'ВЫРЕЗАТЬ';
  @override String get okButtonLabel => r'ОК';
  @override String get pasteButtonLabel => r'ВСТАВИТЬ';
  @override String get selectAllButtonLabel => r'ВЫБРАТЬ ВСЕ';
  @override String get viewLicensesButtonLabel => r'ЛИЦЕНЗИИ';
  @override String get anteMeridiemAbbreviation => r'АМ';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'Выберите часы';
  @override String get timePickerMinuteModeAnnouncement => r'Выберите минуты';
  @override String get signedInLabel => r'Вход выполнен';
  @override String get hideAccountsLabel => r'Скрыть аккаунты';
  @override String get showAccountsLabel => r'Показать аккаунты';
  @override String get modalBarrierDismissLabel => r'Закрыть';
}

// ignore: camel_case_types
class _Bundle_th extends TranslationBundle {
  const _Bundle_th() : super(null);
  @override String get scriptCategory => r'tall';
  @override String get timeOfDayFormat => r'ah:mm';
  @override String get openAppDrawerTooltip => r'เปิดเมนูการนำทาง';
  @override String get backButtonTooltip => r'กลับ';
  @override String get closeButtonTooltip => r'ปิด';
  @override String get deleteButtonTooltip => r'ลบ';
  @override String get nextMonthTooltip => r'เดือนหน้า';
  @override String get previousMonthTooltip => r'เดือนที่แล้ว';
  @override String get nextPageTooltip => r'หน้าถัดไป';
  @override String get previousPageTooltip => r'หน้าก่อน';
  @override String get showMenuTooltip => r'แสดงเมนู';
  @override String get aboutListTileTitle => r'เกี่ยวกับ $applicationName';
  @override String get licensesPageTitle => r'ใบอนุญาต';
  @override String get pageRowsInfoTitle => r'$firstRow-$lastRow จาก $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow จากประมาณ $rowCount';
  @override String get rowsPerPageTitle => r'แถวต่อหน้า:';
  @override String get tabLabel => r'แท็บที่ $tabIndex จาก $tabCount';
  @override String get selectedRowCountTitleOne => r'เลือกแล้ว 1 รายการ';
  @override String get selectedRowCountTitleOther => r'เลือกแล้ว $selectedRowCount รายการ';
  @override String get cancelButtonLabel => r'ยกเลิก';
  @override String get closeButtonLabel => r'ปิด';
  @override String get continueButtonLabel => r'ต่อไป';
  @override String get copyButtonLabel => r'คัดลอก';
  @override String get cutButtonLabel => r'ตัด';
  @override String get okButtonLabel => r'ตกลง';
  @override String get pasteButtonLabel => r'วาง';
  @override String get selectAllButtonLabel => r'เลือกทั้งหมด';
  @override String get viewLicensesButtonLabel => r'ดูใบอนุญาต';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'เลือกชั่วโมง';
  @override String get timePickerMinuteModeAnnouncement => r'เลือกนาที';
  @override String get signedInLabel => r'ลงชื่อเข้าใช้';
  @override String get hideAccountsLabel => r'ซ่อนบัญชี';
  @override String get showAccountsLabel => r'แสดงบัญชี';
  @override String get modalBarrierDismissLabel => r'ปิด';
}

// ignore: camel_case_types
class _Bundle_tr extends TranslationBundle {
  const _Bundle_tr() : super(null);
  @override String get scriptCategory => r'English-like';
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get openAppDrawerTooltip => r'Gezinme menüsünü aç';
  @override String get backButtonTooltip => r'Geri';
  @override String get closeButtonTooltip => r'Kapat';
  @override String get deleteButtonTooltip => r'Sil';
  @override String get nextMonthTooltip => r'Gelecek ay';
  @override String get previousMonthTooltip => r'Önceki ay';
  @override String get nextPageTooltip => r'Sonraki sayfa';
  @override String get previousPageTooltip => r'Önceki sayfa';
  @override String get showMenuTooltip => r'Menüyü göster';
  @override String get aboutListTileTitle => r'$applicationName Hakkında';
  @override String get licensesPageTitle => r'Lisanslar';
  @override String get pageRowsInfoTitle => r'$firstRow-$lastRow / $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow-$lastRow / $rowCount';
  @override String get rowsPerPageTitle => r'Sayfa başına satır sayısı:';
  @override String get tabLabel => r'Sekme $tabIndex / $tabCount';
  @override String get selectedRowCountTitleOne => r'1 öğe seçildi';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount öğe seçildi';
  @override String get cancelButtonLabel => r'İPTAL';
  @override String get closeButtonLabel => r'KAPAT';
  @override String get continueButtonLabel => r'DEVAM';
  @override String get copyButtonLabel => r'KOPYALA';
  @override String get cutButtonLabel => r'KES';
  @override String get okButtonLabel => r'Tamam';
  @override String get pasteButtonLabel => r'YAPIŞTIR';
  @override String get selectAllButtonLabel => r'TÜMÜNÜ SEÇ';
  @override String get viewLicensesButtonLabel => r'LİSANLARI GÖSTER';
  @override String get anteMeridiemAbbreviation => r'ÖÖ';
  @override String get postMeridiemAbbreviation => r'ÖS';
  @override String get timePickerHourModeAnnouncement => r'Saati seçin';
  @override String get timePickerMinuteModeAnnouncement => r'Dakikayı seçin';
  @override String get signedInLabel => r'Oturum açıldı';
  @override String get hideAccountsLabel => r'Hesapları gizle';
  @override String get showAccountsLabel => r'Hesapları göster';
  @override String get modalBarrierDismissLabel => r'Kapat';
}

// ignore: camel_case_types
class _Bundle_ur extends TranslationBundle {
  const _Bundle_ur() : super(null);
  @override String get scriptCategory => r'tall';
  @override String get timeOfDayFormat => r'h:mm a';
  @override String get selectedRowCountTitleOne => r'1 آئٹم منتخب کیا گیا';
  @override String get openAppDrawerTooltip => r'نیویگیشن مینو کھولیں';
  @override String get backButtonTooltip => r'پیچھے';
  @override String get closeButtonTooltip => r'بند کریں';
  @override String get deleteButtonTooltip => r'حذف کریں';
  @override String get nextMonthTooltip => r'اگلا مہینہ';
  @override String get previousMonthTooltip => r'پچھلا مہینہ';
  @override String get nextPageTooltip => r'اگلا صفحہ';
  @override String get previousPageTooltip => r'گزشتہ صفحہ';
  @override String get showMenuTooltip => r'مینو دکھائیں';
  @override String get aboutListTileTitle => r'$applicationName کے بارے میں';
  @override String get licensesPageTitle => r'لائسنسز';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow از $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow $rowCount میں سے تقریباً';
  @override String get rowsPerPageTitle => r'قطاریں فی صفحہ:';
  @override String get tabLabel => r'$tabCount میں سے $tabIndex ٹیب';
  @override String get selectedRowCountTitleOther => r'$selectedRowCount آئٹمز منتخب کیے گئے';
  @override String get cancelButtonLabel => r'منسوخ کریں';
  @override String get closeButtonLabel => r'بند کریں';
  @override String get continueButtonLabel => r'جاری رکھیں';
  @override String get copyButtonLabel => r'کاپی کریں';
  @override String get cutButtonLabel => r'کٹ کریں';
  @override String get okButtonLabel => r'ٹھیک ہے';
  @override String get pasteButtonLabel => r'پیسٹ کریں';
  @override String get selectAllButtonLabel => r'سبھی منتخب کریں';
  @override String get viewLicensesButtonLabel => r'لائسنسز دیکھیں';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get timePickerHourModeAnnouncement => r'گھنٹے منتخب کریں';
  @override String get timePickerMinuteModeAnnouncement => r'منٹ منتخب کریں';
  @override String get signedInLabel => r'سائن ان کردہ ہے';
  @override String get hideAccountsLabel => r'اکاؤنٹس چھپائیں';
  @override String get showAccountsLabel => r'اکاؤنٹس دکھائیں';
  @override String get modalBarrierDismissLabel => r'برخاست کریں';
}

// ignore: camel_case_types
class _Bundle_zh extends TranslationBundle {
  const _Bundle_zh() : super(null);
  @override String get scriptCategory => r'dense';
  @override String get timeOfDayFormat => r'ah:mm';
  @override String get selectedRowCountTitleOne => r'已选择 1 项内容';
  @override String get openAppDrawerTooltip => r'打开导航菜单';
  @override String get backButtonTooltip => r'返回';
  @override String get nextPageTooltip => r'下一页';
  @override String get previousPageTooltip => r'上一页';
  @override String get showMenuTooltip => r'显示菜单';
  @override String get aboutListTileTitle => r'关于$applicationName';
  @override String get licensesPageTitle => r'许可';
  @override String get pageRowsInfoTitle => r'第 $firstRow-$lastRow 行（共 $rowCount 行）';
  @override String get pageRowsInfoTitleApproximate => r'第 $firstRow-$lastRow 行（共约 $rowCount 行）';
  @override String get rowsPerPageTitle => r'每页行数：';
  @override String get tabLabel => r'第 $tabIndex 个标签，共 $tabCount 个';
  @override String get selectedRowCountTitleOther => r'已选择 $selectedRowCount 项内容';
  @override String get cancelButtonLabel => r'取消';
  @override String get continueButtonLabel => r'继续';
  @override String get closeButtonLabel => r'关闭';
  @override String get copyButtonLabel => r'复制';
  @override String get cutButtonLabel => r'剪切';
  @override String get okButtonLabel => r'确定';
  @override String get pasteButtonLabel => r'粘贴';
  @override String get selectAllButtonLabel => r'全选';
  @override String get viewLicensesButtonLabel => r'查看许可';
  @override String get closeButtonTooltip => r'关闭';
  @override String get deleteButtonTooltip => r'删除';
  @override String get nextMonthTooltip => r'下个月';
  @override String get previousMonthTooltip => r'上个月';
  @override String get anteMeridiemAbbreviation => r'上午';
  @override String get postMeridiemAbbreviation => r'下午';
  @override String get timePickerHourModeAnnouncement => r'选择小时';
  @override String get timePickerMinuteModeAnnouncement => r'选择分钟';
  @override String get signedInLabel => r'已登录';
  @override String get hideAccountsLabel => r'隐藏帐号';
  @override String get showAccountsLabel => r'显示帐号';
  @override String get modalBarrierDismissLabel => r'关闭';
}

// ignore: camel_case_types
class _Bundle_de_CH extends TranslationBundle {
  const _Bundle_de_CH() : super(const _Bundle_de());
  @override String get closeButtonTooltip => r'Schliessen';
  @override String get modalBarrierDismissLabel => r'Schliessen';
}

// ignore: camel_case_types
class _Bundle_en_AU extends TranslationBundle {
  const _Bundle_en_AU() : super(const _Bundle_en());
  @override String get licensesPageTitle => r'Licences';
  @override String get viewLicensesButtonLabel => r'VIEW LICENCES';
}

// ignore: camel_case_types
class _Bundle_en_CA extends TranslationBundle {
  const _Bundle_en_CA() : super(const _Bundle_en());
  @override String get licensesPageTitle => r'Licences';
  @override String get viewLicensesButtonLabel => r'VIEW LICENCES';
}

// ignore: camel_case_types
class _Bundle_en_GB extends TranslationBundle {
  const _Bundle_en_GB() : super(const _Bundle_en());
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get viewLicensesButtonLabel => r'VIEW LICENCES';
  @override String get licensesPageTitle => r'Licences';
}

// ignore: camel_case_types
class _Bundle_en_IE extends TranslationBundle {
  const _Bundle_en_IE() : super(const _Bundle_en());
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get viewLicensesButtonLabel => r'VIEW LICENCES';
  @override String get licensesPageTitle => r'Licences';
}

// ignore: camel_case_types
class _Bundle_en_IN extends TranslationBundle {
  const _Bundle_en_IN() : super(const _Bundle_en());
  @override String get licensesPageTitle => r'Licences';
  @override String get viewLicensesButtonLabel => r'VIEW LICENCES';
}

// ignore: camel_case_types
class _Bundle_en_SG extends TranslationBundle {
  const _Bundle_en_SG() : super(const _Bundle_en());
  @override String get licensesPageTitle => r'Licences';
  @override String get viewLicensesButtonLabel => r'VIEW LICENCES';
}

// ignore: camel_case_types
class _Bundle_en_ZA extends TranslationBundle {
  const _Bundle_en_ZA() : super(const _Bundle_en());
  @override String get timeOfDayFormat => r'HH:mm';
  @override String get viewLicensesButtonLabel => r'VIEW LICENCES';
  @override String get licensesPageTitle => r'Licences';
}

// ignore: camel_case_types
class _Bundle_es_419 extends TranslationBundle {
  const _Bundle_es_419() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_AR extends TranslationBundle {
  const _Bundle_es_AR() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_BO extends TranslationBundle {
  const _Bundle_es_BO() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_CL extends TranslationBundle {
  const _Bundle_es_CL() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_CO extends TranslationBundle {
  const _Bundle_es_CO() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_CR extends TranslationBundle {
  const _Bundle_es_CR() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_DO extends TranslationBundle {
  const _Bundle_es_DO() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_EC extends TranslationBundle {
  const _Bundle_es_EC() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_GT extends TranslationBundle {
  const _Bundle_es_GT() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_HN extends TranslationBundle {
  const _Bundle_es_HN() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_MX extends TranslationBundle {
  const _Bundle_es_MX() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_NI extends TranslationBundle {
  const _Bundle_es_NI() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_PA extends TranslationBundle {
  const _Bundle_es_PA() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_PE extends TranslationBundle {
  const _Bundle_es_PE() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_PR extends TranslationBundle {
  const _Bundle_es_PR() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_PY extends TranslationBundle {
  const _Bundle_es_PY() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_SV extends TranslationBundle {
  const _Bundle_es_SV() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_US extends TranslationBundle {
  const _Bundle_es_US() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get timeOfDayFormat => r'h:mm a';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_UY extends TranslationBundle {
  const _Bundle_es_UY() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_es_VE extends TranslationBundle {
  const _Bundle_es_VE() : super(const _Bundle_es());
  @override String get modalBarrierDismissLabel => r'Descartar';
  @override String get signedInLabel => r'Cuenta con la que accediste';
  @override String get openAppDrawerTooltip => r'Abrir menú de navegación';
  @override String get deleteButtonTooltip => r'Borrar';
  @override String get nextMonthTooltip => r'Próximo mes';
  @override String get nextPageTooltip => r'Próxima página';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow–$lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow–$lastRow de aproximadamente $rowCount';
  @override String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';
  @override String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';
  @override String get anteMeridiemAbbreviation => r'a.m.';
  @override String get postMeridiemAbbreviation => r'p.m.';
}

// ignore: camel_case_types
class _Bundle_fr_CA extends TranslationBundle {
  const _Bundle_fr_CA() : super(const _Bundle_fr());
  @override String get timeOfDayFormat => r'HH ' "'" r'h' "'" r' mm';
}

// ignore: camel_case_types
class _Bundle_pt_PT extends TranslationBundle {
  const _Bundle_pt_PT() : super(const _Bundle_pt());
  @override String get tabLabel => r'Separador $tabIndex de $tabCount';
  @override String get signedInLabel => r'Com sessão iniciada';
  @override String get timePickerMinuteModeAnnouncement => r'Selecionar minutos';
  @override String get timePickerHourModeAnnouncement => r'Selecionar horas';
  @override String get deleteButtonTooltip => r'Eliminar';
  @override String get nextMonthTooltip => r'Mês seguinte';
  @override String get nextPageTooltip => r'Página seguinte';
  @override String get aboutListTileTitle => r'Acerca de $applicationName';
  @override String get pageRowsInfoTitle => r'$firstRow a $lastRow de $rowCount';
  @override String get pageRowsInfoTitleApproximate => r'$firstRow a $lastRow de cerca de $rowCount';
  @override String get cutButtonLabel => r'CORTAR';
  @override String get okButtonLabel => r'OK';
  @override String get anteMeridiemAbbreviation => r'AM';
  @override String get postMeridiemAbbreviation => r'PM';
  @override String get modalBarrierDismissLabel => r'Ignorar';
}

// ignore: camel_case_types
class _Bundle_zh_HK extends TranslationBundle {
  const _Bundle_zh_HK() : super(const _Bundle_zh());
  @override String get tabLabel => r'第 $tabIndex 個分頁 (共 $tabCount 個)';
  @override String get showAccountsLabel => r'顯示帳戶';
  @override String get modalBarrierDismissLabel => r'關閉';
  @override String get hideAccountsLabel => r'隱藏帳戶';
  @override String get signedInLabel => r'已登入帳戶';
  @override String get openAppDrawerTooltip => r'開啟導覽選單';
  @override String get closeButtonTooltip => r'關閉';
  @override String get deleteButtonTooltip => r'刪除';
  @override String get nextMonthTooltip => r'下個月';
  @override String get previousMonthTooltip => r'上個月';
  @override String get nextPageTooltip => r'下一頁';
  @override String get previousPageTooltip => r'上一頁';
  @override String get showMenuTooltip => r'顯示選單';
  @override String get aboutListTileTitle => r'關於「$applicationName」';
  @override String get licensesPageTitle => r'授權';
  @override String get pageRowsInfoTitle => r'第 $firstRow - $lastRow 列 (總共 $rowCount 列)';
  @override String get pageRowsInfoTitleApproximate => r'第 $firstRow - $lastRow 列 (總共約 $rowCount 列)';
  @override String get rowsPerPageTitle => r'每頁列數：';
  @override String get selectedRowCountTitleOne => r'已選取 1 個項目';
  @override String get selectedRowCountTitleOther => r'已選取 $selectedRowCount 個項目';
  @override String get closeButtonLabel => r'關閉';
  @override String get continueButtonLabel => r'繼續';
  @override String get copyButtonLabel => r'複製';
  @override String get cutButtonLabel => r'剪下';
  @override String get okButtonLabel => r'確定';
  @override String get pasteButtonLabel => r'貼上';
  @override String get selectAllButtonLabel => r'全選';
  @override String get viewLicensesButtonLabel => r'查看授權';
  @override String get timePickerHourModeAnnouncement => r'選取小時數';
  @override String get timePickerMinuteModeAnnouncement => r'選取分鐘數';
}

// ignore: camel_case_types
class _Bundle_zh_TW extends TranslationBundle {
  const _Bundle_zh_TW() : super(const _Bundle_zh());
  @override String get tabLabel => r'第 $tabIndex 個分頁 (共 $tabCount 個)';
  @override String get showAccountsLabel => r'顯示帳戶';
  @override String get modalBarrierDismissLabel => r'關閉';
  @override String get hideAccountsLabel => r'隱藏帳戶';
  @override String get signedInLabel => r'已登入帳戶';
  @override String get openAppDrawerTooltip => r'開啟導覽選單';
  @override String get closeButtonTooltip => r'關閉';
  @override String get deleteButtonTooltip => r'刪除';
  @override String get nextMonthTooltip => r'下個月';
  @override String get previousMonthTooltip => r'上個月';
  @override String get nextPageTooltip => r'下一頁';
  @override String get previousPageTooltip => r'上一頁';
  @override String get showMenuTooltip => r'顯示選單';
  @override String get aboutListTileTitle => r'關於「$applicationName」';
  @override String get licensesPageTitle => r'授權';
  @override String get pageRowsInfoTitle => r'第 $firstRow - $lastRow 列 (總共 $rowCount 列)';
  @override String get pageRowsInfoTitleApproximate => r'第 $firstRow - $lastRow 列 (總共約 $rowCount 列)';
  @override String get rowsPerPageTitle => r'每頁列數：';
  @override String get selectedRowCountTitleOne => r'已選取 1 個項目';
  @override String get selectedRowCountTitleOther => r'已選取 $selectedRowCount 個項目';
  @override String get closeButtonLabel => r'關閉';
  @override String get continueButtonLabel => r'繼續';
  @override String get copyButtonLabel => r'複製';
  @override String get cutButtonLabel => r'剪下';
  @override String get okButtonLabel => r'確定';
  @override String get pasteButtonLabel => r'貼上';
  @override String get selectAllButtonLabel => r'全選';
  @override String get viewLicensesButtonLabel => r'查看授權';
  @override String get timePickerHourModeAnnouncement => r'選取小時數';
  @override String get timePickerMinuteModeAnnouncement => r'選取分鐘數';
}

TranslationBundle translationBundleForLocale(Locale locale) {
  switch (locale.languageCode) {
    case 'ar':
      return const _Bundle_ar();
    case 'de': {
      switch (locale.toString()) {
        case 'de_CH':
          return const _Bundle_de_CH();
      }
      return const _Bundle_de();
    }
    case 'en': {
      switch (locale.toString()) {
        case 'en_AU':
          return const _Bundle_en_AU();
        case 'en_CA':
          return const _Bundle_en_CA();
        case 'en_GB':
          return const _Bundle_en_GB();
        case 'en_IE':
          return const _Bundle_en_IE();
        case 'en_IN':
          return const _Bundle_en_IN();
        case 'en_SG':
          return const _Bundle_en_SG();
        case 'en_ZA':
          return const _Bundle_en_ZA();
      }
      return const _Bundle_en();
    }
    case 'es': {
      switch (locale.toString()) {
        case 'es_419':
          return const _Bundle_es_419();
        case 'es_AR':
          return const _Bundle_es_AR();
        case 'es_BO':
          return const _Bundle_es_BO();
        case 'es_CL':
          return const _Bundle_es_CL();
        case 'es_CO':
          return const _Bundle_es_CO();
        case 'es_CR':
          return const _Bundle_es_CR();
        case 'es_DO':
          return const _Bundle_es_DO();
        case 'es_EC':
          return const _Bundle_es_EC();
        case 'es_GT':
          return const _Bundle_es_GT();
        case 'es_HN':
          return const _Bundle_es_HN();
        case 'es_MX':
          return const _Bundle_es_MX();
        case 'es_NI':
          return const _Bundle_es_NI();
        case 'es_PA':
          return const _Bundle_es_PA();
        case 'es_PE':
          return const _Bundle_es_PE();
        case 'es_PR':
          return const _Bundle_es_PR();
        case 'es_PY':
          return const _Bundle_es_PY();
        case 'es_SV':
          return const _Bundle_es_SV();
        case 'es_US':
          return const _Bundle_es_US();
        case 'es_UY':
          return const _Bundle_es_UY();
        case 'es_VE':
          return const _Bundle_es_VE();
      }
      return const _Bundle_es();
    }
    case 'fa':
      return const _Bundle_fa();
    case 'fr': {
      switch (locale.toString()) {
        case 'fr_CA':
          return const _Bundle_fr_CA();
      }
      return const _Bundle_fr();
    }
    case 'gsw':
      return const _Bundle_gsw();
    case 'he':
      return const _Bundle_he();
    case 'it':
      return const _Bundle_it();
    case 'ja':
      return const _Bundle_ja();
    case 'ko':
      return const _Bundle_ko();
    case 'nl':
      return const _Bundle_nl();
    case 'pl':
      return const _Bundle_pl();
    case 'ps':
      return const _Bundle_ps();
    case 'pt': {
      switch (locale.toString()) {
        case 'pt_PT':
          return const _Bundle_pt_PT();
      }
      return const _Bundle_pt();
    }
    case 'ro':
      return const _Bundle_ro();
    case 'ru':
      return const _Bundle_ru();
    case 'th':
      return const _Bundle_th();
    case 'tr':
      return const _Bundle_tr();
    case 'ur':
      return const _Bundle_ur();
    case 'zh': {
      switch (locale.toString()) {
        case 'zh_HK':
          return const _Bundle_zh_HK();
        case 'zh_TW':
          return const _Bundle_zh_TW();
      }
      return const _Bundle_zh();
    }
  }
  return const TranslationBundle(null);
}
