/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.editing.InputConnectionAdaptor;
import io.flutter.view.FlutterView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextInputPlugin
implements MethodChannel.MethodCallHandler {
    private final FlutterView mView;
    private final InputMethodManager mImm;
    private final MethodChannel mFlutterChannel;
    private int mClient = 0;
    private JSONObject mConfiguration;
    private Editable mEditable;
    private boolean mRestartInputPending;

    public TextInputPlugin(FlutterView view) {
        this.mView = view;
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.mFlutterChannel = new MethodChannel(view, "flutter/textinput", JSONMethodCodec.INSTANCE);
        this.mFlutterChannel.setMethodCallHandler(this);
    }

    @Override
    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        String method = call.method;
        Object args = call.arguments;
        try {
            if (method.equals("TextInput.show")) {
                this.showTextInput(this.mView);
                result.success(null);
            } else if (method.equals("TextInput.hide")) {
                this.hideTextInput(this.mView);
                result.success(null);
            } else if (method.equals("TextInput.setClient")) {
                JSONArray argumentList = (JSONArray)args;
                this.setTextInputClient(this.mView, argumentList.getInt(0), argumentList.getJSONObject(1));
                result.success(null);
            } else if (method.equals("TextInput.setEditingState")) {
                this.setTextInputEditingState(this.mView, (JSONObject)args);
                result.success(null);
            } else if (method.equals("TextInput.clearClient")) {
                this.clearTextInputClient();
                result.success(null);
            } else {
                result.notImplemented();
            }
        }
        catch (JSONException e) {
            result.error("error", "JSON error: " + e.getMessage(), null);
        }
    }

    private static int inputTypeFromTextInputType(JSONObject type, boolean obscureText, boolean autocorrect) throws JSONException {
        String inputType = type.getString("name");
        if (inputType.equals("TextInputType.datetime")) {
            return 4;
        }
        if (inputType.equals("TextInputType.number")) {
            int textType = 2;
            if (type.optBoolean("signed")) {
                textType |= 0x1000;
            }
            if (type.optBoolean("decimal")) {
                textType |= 0x2000;
            }
            return textType;
        }
        if (inputType.equals("TextInputType.phone")) {
            return 3;
        }
        int textType = 1;
        if (inputType.equals("TextInputType.multiline")) {
            textType |= 0x20000;
        } else if (inputType.equals("TextInputType.emailAddress")) {
            textType |= 0x20;
        } else if (inputType.equals("TextInputType.url")) {
            textType |= 0x10;
        }
        if (obscureText) {
            textType |= 0x80000;
            textType |= 0x80;
        } else {
            if (autocorrect) {
                textType |= 0x8000;
            }
            if (inputType.equals("TextInputType.text") || inputType.equals("TextInputType.multiline")) {
                textType |= 0x4000;
            }
        }
        return textType;
    }

    private static int inputActionFromTextInputAction(String inputAction) {
        if (inputAction.equals("TextInputAction.newline")) {
            return 1;
        }
        return 6;
    }

    public InputConnection createInputConnection(FlutterView view, EditorInfo outAttrs) throws JSONException {
        if (this.mClient == 0) {
            return null;
        }
        outAttrs.inputType = TextInputPlugin.inputTypeFromTextInputType(this.mConfiguration.getJSONObject("inputType"), this.mConfiguration.optBoolean("obscureText"), this.mConfiguration.optBoolean("autocorrect", true));
        outAttrs.imeOptions = 0x2000000;
        int enterAction = this.mConfiguration.isNull("inputAction") ? ((0x20000 & outAttrs.inputType) != 0 ? 1 : 6) : TextInputPlugin.inputActionFromTextInputAction(this.mConfiguration.getString("inputAction"));
        if (!this.mConfiguration.isNull("actionLabel")) {
            outAttrs.actionLabel = this.mConfiguration.getString("actionLabel");
            outAttrs.actionId = enterAction;
        }
        outAttrs.imeOptions |= enterAction;
        InputConnectionAdaptor connection = new InputConnectionAdaptor(view, this.mClient, this.mFlutterChannel, this.mEditable);
        outAttrs.initialSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        outAttrs.initialSelEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        return connection;
    }

    private void showTextInput(FlutterView view) {
        this.mImm.showSoftInput((View)view, 0);
    }

    private void hideTextInput(FlutterView view) {
        this.mImm.hideSoftInputFromWindow(view.getApplicationWindowToken(), 0);
    }

    private void setTextInputClient(FlutterView view, int client, JSONObject configuration) {
        this.mClient = client;
        this.mConfiguration = configuration;
        this.mEditable = Editable.Factory.getInstance().newEditable((CharSequence)"");
        this.mRestartInputPending = true;
    }

    private void applyStateToSelection(JSONObject state) throws JSONException {
        int selStart = state.getInt("selectionBase");
        int selEnd = state.getInt("selectionExtent");
        if (selStart >= 0 && selStart <= this.mEditable.length() && selEnd >= 0 && selEnd <= this.mEditable.length()) {
            Selection.setSelection((Spannable)this.mEditable, (int)selStart, (int)selEnd);
        } else {
            Selection.removeSelection((Spannable)this.mEditable);
        }
    }

    private void setTextInputEditingState(FlutterView view, JSONObject state) throws JSONException {
        if (!this.mRestartInputPending && state.getString("text").equals(this.mEditable.toString())) {
            this.applyStateToSelection(state);
            this.mImm.updateSelection((View)this.mView, Math.max(Selection.getSelectionStart((CharSequence)this.mEditable), 0), Math.max(Selection.getSelectionEnd((CharSequence)this.mEditable), 0), BaseInputConnection.getComposingSpanStart((Spannable)this.mEditable), BaseInputConnection.getComposingSpanEnd((Spannable)this.mEditable));
        } else {
            this.mEditable.replace(0, this.mEditable.length(), (CharSequence)state.getString("text"));
            this.applyStateToSelection(state);
            this.mImm.restartInput((View)view);
            this.mRestartInputPending = false;
        }
    }

    private void clearTextInputClient() {
        this.mClient = 0;
    }
}

