/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import io.flutter.util.PathUtils;
import io.flutter.view.ResourceCleaner;
import io.flutter.view.ResourceExtractor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FlutterMain {
    private static final String TAG = "FlutterMain";
    private static final String AOT_SHARED_LIBRARY_PATH = "aot-shared-library-path";
    private static final String AOT_SNAPSHOT_PATH_KEY = "aot-snapshot-path";
    private static final String AOT_VM_SNAPSHOT_DATA_KEY = "vm-snapshot-data";
    private static final String AOT_VM_SNAPSHOT_INSTR_KEY = "vm-snapshot-instr";
    private static final String AOT_ISOLATE_SNAPSHOT_DATA_KEY = "isolate-snapshot-data";
    private static final String AOT_ISOLATE_SNAPSHOT_INSTR_KEY = "isolate-snapshot-instr";
    private static final String FLX_KEY = "flx";
    private static final String SNAPSHOT_BLOB_KEY = "snapshot-blob";
    private static final String FLUTTER_ASSETS_DIR_KEY = "flutter-assets-dir";
    public static final String PUBLIC_AOT_AOT_SHARED_LIBRARY_PATH = FlutterMain.class.getName() + '.' + "aot-shared-library-path";
    public static final String PUBLIC_AOT_VM_SNAPSHOT_DATA_KEY = FlutterMain.class.getName() + '.' + "vm-snapshot-data";
    public static final String PUBLIC_AOT_VM_SNAPSHOT_INSTR_KEY = FlutterMain.class.getName() + '.' + "vm-snapshot-instr";
    public static final String PUBLIC_AOT_ISOLATE_SNAPSHOT_DATA_KEY = FlutterMain.class.getName() + '.' + "isolate-snapshot-data";
    public static final String PUBLIC_AOT_ISOLATE_SNAPSHOT_INSTR_KEY = FlutterMain.class.getName() + '.' + "isolate-snapshot-instr";
    public static final String PUBLIC_FLX_KEY = FlutterMain.class.getName() + '.' + "flx";
    public static final String PUBLIC_SNAPSHOT_BLOB_KEY = FlutterMain.class.getName() + '.' + "snapshot-blob";
    public static final String PUBLIC_FLUTTER_ASSETS_DIR_KEY = FlutterMain.class.getName() + '.' + "flutter-assets-dir";
    private static final String DEFAULT_AOT_SHARED_LIBRARY_PATH = "app.so";
    private static final String DEFAULT_AOT_VM_SNAPSHOT_DATA = "vm_snapshot_data";
    private static final String DEFAULT_AOT_VM_SNAPSHOT_INSTR = "vm_snapshot_instr";
    private static final String DEFAULT_AOT_ISOLATE_SNAPSHOT_DATA = "isolate_snapshot_data";
    private static final String DEFAULT_AOT_ISOLATE_SNAPSHOT_INSTR = "isolate_snapshot_instr";
    private static final String DEFAULT_FLX = "app.flx";
    private static final String DEFAULT_SNAPSHOT_BLOB = "snapshot_blob.bin";
    private static final String DEFAULT_KERNEL_BLOB = "kernel_blob.bin";
    private static final String DEFAULT_PLATFORM_DILL = "platform_strong.dill";
    private static final String DEFAULT_FLUTTER_ASSETS_DIR = "flutter_assets";
    private static final String SHARED_ASSET_DIR = "flutter_shared";
    private static final String SHARED_ASSET_ICU_DATA = "icudtl.dat";
    private static String sAotSharedLibraryPath = "app.so";
    private static String sAotVmSnapshotData = "vm_snapshot_data";
    private static String sAotVmSnapshotInstr = "vm_snapshot_instr";
    private static String sAotIsolateSnapshotData = "isolate_snapshot_data";
    private static String sAotIsolateSnapshotInstr = "isolate_snapshot_instr";
    private static String sFlx = "app.flx";
    private static String sSnapshotBlob = "snapshot_blob.bin";
    private static String sFlutterAssetsDir = "flutter_assets";
    private static boolean sInitialized = false;
    private static ResourceExtractor sResourceExtractor;
    private static boolean sIsPrecompiledAsBlobs;
    private static boolean sIsPrecompiledAsSharedLibrary;
    private static Settings sSettings;
    private static String sIcuDataPath;

    private static String fromFlutterAssets(String filePath) {
        return sFlutterAssetsDir + File.separator + filePath;
    }

    public static void startInitialization(Context applicationContext) {
        FlutterMain.startInitialization(applicationContext, new Settings());
    }

    public static void startInitialization(Context applicationContext, Settings settings) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("startInitialization must be called on the main thread");
        }
        if (sSettings != null) {
            return;
        }
        sSettings = settings;
        long initStartTimestampMillis = SystemClock.uptimeMillis();
        FlutterMain.initConfig(applicationContext);
        FlutterMain.initAot(applicationContext);
        FlutterMain.initResources(applicationContext);
        System.loadLibrary("flutter");
        long initTimeMillis = SystemClock.uptimeMillis() - initStartTimestampMillis;
        FlutterMain.nativeRecordStartTimestamp(initTimeMillis);
    }

    public static void ensureInitializationComplete(Context applicationContext, String[] args) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (sSettings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (sInitialized) {
            return;
        }
        try {
            sResourceExtractor.waitForCompletion();
            ArrayList<String> shellArgs = new ArrayList<String>();
            shellArgs.add("--icu-data-file-path=" + sIcuDataPath);
            if (args != null) {
                Collections.addAll(shellArgs, args);
            }
            if (sIsPrecompiledAsSharedLibrary) {
                shellArgs.add("--aot-shared-library-path=" + new File(PathUtils.getDataDirectory(applicationContext), sAotSharedLibraryPath));
            } else {
                if (sIsPrecompiledAsBlobs) {
                    shellArgs.add("--aot-snapshot-path=" + PathUtils.getDataDirectory(applicationContext));
                } else {
                    shellArgs.add("--cache-dir-path=" + PathUtils.getCacheDirectory(applicationContext));
                    shellArgs.add("--aot-snapshot-path=" + PathUtils.getDataDirectory(applicationContext) + "/" + sFlutterAssetsDir);
                }
                shellArgs.add("--vm-snapshot-data=" + sAotVmSnapshotData);
                shellArgs.add("--vm-snapshot-instr=" + sAotVmSnapshotInstr);
                shellArgs.add("--isolate-snapshot-data=" + sAotIsolateSnapshotData);
                shellArgs.add("--isolate-snapshot-instr=" + sAotIsolateSnapshotInstr);
            }
            if (sSettings.getLogTag() != null) {
                shellArgs.add("--log-tag=" + sSettings.getLogTag());
            }
            String appBundlePath = FlutterMain.findAppBundlePath(applicationContext);
            String appStoragePath = PathUtils.getFilesDir(applicationContext);
            FlutterMain.nativeInit(applicationContext, shellArgs.toArray(new String[0]), appBundlePath, appStoragePath);
            sInitialized = true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Flutter initialization failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static native void nativeInit(Context var0, String[] var1, String var2, String var3);

    private static native void nativeRecordStartTimestamp(long var0);

    private static void initConfig(Context applicationContext) {
        try {
            Bundle metadata = applicationContext.getPackageManager().getApplicationInfo((String)applicationContext.getPackageName(), (int)128).metaData;
            if (metadata != null) {
                sAotSharedLibraryPath = metadata.getString(PUBLIC_AOT_AOT_SHARED_LIBRARY_PATH, DEFAULT_AOT_SHARED_LIBRARY_PATH);
                sAotVmSnapshotData = metadata.getString(PUBLIC_AOT_VM_SNAPSHOT_DATA_KEY, DEFAULT_AOT_VM_SNAPSHOT_DATA);
                sAotVmSnapshotInstr = metadata.getString(PUBLIC_AOT_VM_SNAPSHOT_INSTR_KEY, DEFAULT_AOT_VM_SNAPSHOT_INSTR);
                sAotIsolateSnapshotData = metadata.getString(PUBLIC_AOT_ISOLATE_SNAPSHOT_DATA_KEY, DEFAULT_AOT_ISOLATE_SNAPSHOT_DATA);
                sAotIsolateSnapshotInstr = metadata.getString(PUBLIC_AOT_ISOLATE_SNAPSHOT_INSTR_KEY, DEFAULT_AOT_ISOLATE_SNAPSHOT_INSTR);
                sFlx = metadata.getString(PUBLIC_FLX_KEY, DEFAULT_FLX);
                sSnapshotBlob = metadata.getString(PUBLIC_SNAPSHOT_BLOB_KEY, DEFAULT_SNAPSHOT_BLOB);
                sFlutterAssetsDir = metadata.getString(PUBLIC_FLUTTER_ASSETS_DIR_KEY, DEFAULT_FLUTTER_ASSETS_DIR);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initResources(Context applicationContext) {
        Context context = applicationContext;
        new ResourceCleaner(context).start();
        sResourceExtractor = new ResourceExtractor(context);
        Set<String> sharedAssets = FlutterMain.listAssets(applicationContext, SHARED_ASSET_DIR);
        String icuAssetPath = sharedAssets.contains(SHARED_ASSET_ICU_DATA) ? SHARED_ASSET_DIR + File.separator + SHARED_ASSET_ICU_DATA : SHARED_ASSET_ICU_DATA;
        sResourceExtractor.addResource(icuAssetPath);
        sIcuDataPath = PathUtils.getDataDirectory(applicationContext) + File.separator + icuAssetPath;
        sResourceExtractor.addResource(FlutterMain.fromFlutterAssets(sFlx)).addResource(FlutterMain.fromFlutterAssets(sSnapshotBlob)).addResource(FlutterMain.fromFlutterAssets(sAotVmSnapshotData)).addResource(FlutterMain.fromFlutterAssets(sAotVmSnapshotInstr)).addResource(FlutterMain.fromFlutterAssets(sAotIsolateSnapshotData)).addResource(FlutterMain.fromFlutterAssets(sAotIsolateSnapshotInstr)).addResource(FlutterMain.fromFlutterAssets(DEFAULT_KERNEL_BLOB)).addResource(FlutterMain.fromFlutterAssets(DEFAULT_PLATFORM_DILL));
        if (sIsPrecompiledAsSharedLibrary) {
            sResourceExtractor.addResource(sAotSharedLibraryPath);
        } else {
            sResourceExtractor.addResource(sAotVmSnapshotData).addResource(sAotVmSnapshotInstr).addResource(sAotIsolateSnapshotData).addResource(sAotIsolateSnapshotInstr).addResource(sSnapshotBlob);
        }
        sResourceExtractor.start();
    }

    private static Set<String> listAssets(Context applicationContext, String path) {
        AssetManager manager = applicationContext.getResources().getAssets();
        try {
            return ImmutableSetBuilder.newInstance().add(manager.list(path)).build();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Unable to list assets", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void initAot(Context applicationContext) {
        Set<String> assets = FlutterMain.listAssets(applicationContext, "");
        sIsPrecompiledAsBlobs = assets.containsAll(Arrays.asList(sAotVmSnapshotData, sAotVmSnapshotInstr, sAotIsolateSnapshotData, sAotIsolateSnapshotInstr));
        sIsPrecompiledAsSharedLibrary = assets.contains(sAotSharedLibraryPath);
        if (sIsPrecompiledAsBlobs && sIsPrecompiledAsSharedLibrary) {
            throw new RuntimeException("Found precompiled app as shared library and as Dart VM snapshots.");
        }
    }

    public static boolean isRunningPrecompiledCode() {
        return sIsPrecompiledAsBlobs || sIsPrecompiledAsSharedLibrary;
    }

    public static String findAppBundlePath(Context applicationContext) {
        String dataDirectory = PathUtils.getDataDirectory(applicationContext);
        File appBundle = new File(dataDirectory, sFlutterAssetsDir);
        return appBundle.exists() ? appBundle.getPath() : null;
    }

    public static String getLookupKeyForAsset(String asset) {
        return FlutterMain.fromFlutterAssets(asset);
    }

    public static String getLookupKeyForAsset(String asset, String packageName) {
        return FlutterMain.getLookupKeyForAsset("packages" + File.separator + packageName + File.separator + asset);
    }

    public static class Settings {
        private String logTag;

        public String getLogTag() {
            return this.logTag;
        }

        public void setLogTag(String tag) {
            this.logTag = tag;
        }
    }

    private static final class ImmutableSetBuilder<T> {
        HashSet<T> set = new HashSet();

        static <T> ImmutableSetBuilder<T> newInstance() {
            return new ImmutableSetBuilder<T>();
        }

        private ImmutableSetBuilder() {
        }

        ImmutableSetBuilder<T> add(T element) {
            this.set.add(element);
            return this;
        }

        @SafeVarargs
        final ImmutableSetBuilder<T> add(T ... elements) {
            for (T element : elements) {
                this.set.add(element);
            }
            return this;
        }

        Set<T> build() {
            return Collections.unmodifiableSet(this.set);
        }
    }
}

