/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.plugin.platform.PlatformViewRegistryImpl;
import io.flutter.plugin.platform.VirtualDisplayController;
import io.flutter.view.TextureRegistry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlatformViewsController
implements MethodChannel.MethodCallHandler {
    private static final String TAG = "PlatformViewsController";
    private static final String CHANNEL_NAME = "flutter/platform_views";
    private static final int MINIMAL_SDK = 20;
    private final PlatformViewRegistryImpl mRegistry = new PlatformViewRegistryImpl();
    private Context mContext;
    private TextureRegistry mTextureRegistry;
    private BinaryMessenger mMessenger;
    private final HashMap<Integer, VirtualDisplayController> vdControllers = new HashMap();

    public void attach(Context context, TextureRegistry textureRegistry, BinaryMessenger messenger) {
        if (this.mContext != null) {
            throw new AssertionError((Object)"A PlatformViewsController can only be attached to a single output target.\nattach was called while the PlatformViewsController was already attached.");
        }
        this.mContext = context;
        this.mTextureRegistry = textureRegistry;
        this.mMessenger = messenger;
        MethodChannel channel = new MethodChannel(messenger, CHANNEL_NAME, StandardMethodCodec.INSTANCE);
        channel.setMethodCallHandler(this);
    }

    public void detach() {
        this.mMessenger.setMessageHandler(CHANNEL_NAME, null);
        this.mMessenger = null;
        this.mContext = null;
        this.mTextureRegistry = null;
    }

    public PlatformViewRegistry getRegistry() {
        return this.mRegistry;
    }

    public void onFlutterViewDestroyed() {
        this.flushAllViews();
    }

    public void onPreEngineRestart() {
        this.flushAllViews();
    }

    @Override
    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 20) {
            Log.e((String)TAG, (String)("Trying to use platform views with API " + Build.VERSION.SDK_INT + ", required API level is: " + 20));
            return;
        }
        switch (call.method) {
            case "create": {
                this.createPlatformView(call, result);
                return;
            }
            case "dispose": {
                this.disposePlatformView(call, result);
                return;
            }
            case "resize": {
                this.resizePlatformView(call, result);
                return;
            }
            case "touch": {
                this.onTouch(call, result);
                return;
            }
            case "setDirection": {
                this.setDirection(call, result);
                return;
            }
        }
        result.notImplemented();
    }

    @TargetApi(value=17)
    private void createPlatformView(MethodCall call, MethodChannel.Result result) {
        TextureRegistry.SurfaceTextureEntry textureEntry;
        VirtualDisplayController vdController;
        Map args = (Map)call.arguments();
        int id = (Integer)args.get("id");
        String viewType = (String)args.get("viewType");
        double logicalWidth = (Double)args.get("width");
        double logicalHeight = (Double)args.get("height");
        int direction = (Integer)args.get("direction");
        if (!PlatformViewsController.validateDirection(direction)) {
            result.error("error", "Trying to create a view with unknown direction value: " + direction + "(view id: " + id + ")", null);
            return;
        }
        if (this.vdControllers.containsKey(id)) {
            result.error("error", "Trying to create an already created platform view, view id: " + id, null);
            return;
        }
        PlatformViewFactory viewFactory = this.mRegistry.getFactory(viewType);
        if (viewFactory == null) {
            result.error("error", "Trying to create a platform view of unregistered type: " + viewType, null);
            return;
        }
        Object createParams = null;
        if (args.containsKey("params")) {
            createParams = viewFactory.getCreateArgsCodec().decodeMessage(ByteBuffer.wrap((byte[])args.get("params")));
        }
        if ((vdController = VirtualDisplayController.create(this.mContext, viewFactory, (textureEntry = this.mTextureRegistry.createSurfaceTexture()).surfaceTexture(), this.toPhysicalPixels(logicalWidth), this.toPhysicalPixels(logicalHeight), id, createParams)) == null) {
            result.error("error", "Failed creating virtual display for a " + viewType + " with id: " + id, null);
            return;
        }
        this.vdControllers.put(id, vdController);
        vdController.getView().setLayoutDirection(direction);
        result.success(textureEntry.id());
    }

    private void disposePlatformView(MethodCall call, MethodChannel.Result result) {
        int id = (Integer)call.arguments();
        VirtualDisplayController vdController = this.vdControllers.get(id);
        if (vdController == null) {
            result.error("error", "Trying to dispose a platform view with unknown id: " + id, null);
            return;
        }
        vdController.dispose();
        this.vdControllers.remove(id);
        result.success(null);
    }

    private void resizePlatformView(MethodCall call, final MethodChannel.Result result) {
        Map args = (Map)call.arguments();
        int id = (Integer)args.get("id");
        double width = (Double)args.get("width");
        double height = (Double)args.get("height");
        VirtualDisplayController vdController = this.vdControllers.get(id);
        if (vdController == null) {
            result.error("error", "Trying to resize a platform view with unknown id: " + id, null);
            return;
        }
        vdController.resize(this.toPhysicalPixels(width), this.toPhysicalPixels(height), new Runnable(){

            @Override
            public void run() {
                result.success(null);
            }
        });
    }

    private void onTouch(MethodCall call, MethodChannel.Result result) {
        List args = (List)call.arguments();
        float density = this.mContext.getResources().getDisplayMetrics().density;
        int id = (Integer)args.get(0);
        Number downTime = (Number)args.get(1);
        Number eventTime = (Number)args.get(2);
        int action = (Integer)args.get(3);
        int pointerCount = (Integer)args.get(4);
        MotionEvent.PointerProperties[] pointerProperties = PlatformViewsController.parsePointerPropertiesList(args.get(5)).toArray(new MotionEvent.PointerProperties[pointerCount]);
        MotionEvent.PointerCoords[] pointerCoords = PlatformViewsController.parsePointerCoordsList(args.get(6), density).toArray(new MotionEvent.PointerCoords[pointerCount]);
        int metaState = (Integer)args.get(7);
        int buttonState = (Integer)args.get(8);
        float xPrecision = (float)((Double)args.get(9)).doubleValue();
        float yPrecision = (float)((Double)args.get(10)).doubleValue();
        int deviceId = (Integer)args.get(11);
        int edgeFlags = (Integer)args.get(12);
        int source = (Integer)args.get(13);
        int flags = (Integer)args.get(14);
        View view = this.vdControllers.get(id).getView();
        if (view == null) {
            result.error("error", "Sending touch to an unknown view with id: " + id, null);
            return;
        }
        MotionEvent event = MotionEvent.obtain((long)downTime.longValue(), (long)eventTime.longValue(), (int)action, (int)pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)metaState, (int)buttonState, (float)xPrecision, (float)yPrecision, (int)deviceId, (int)edgeFlags, (int)source, (int)flags);
        view.dispatchTouchEvent(event);
        result.success(null);
    }

    @TargetApi(value=17)
    private void setDirection(MethodCall call, MethodChannel.Result result) {
        Map args = (Map)call.arguments();
        int id = (Integer)args.get("id");
        int direction = (Integer)args.get("direction");
        if (!PlatformViewsController.validateDirection(direction)) {
            result.error("error", "Trying to set unknown direction value: " + direction + "(view id: " + id + ")", null);
            return;
        }
        View view = this.vdControllers.get(id).getView();
        if (view == null) {
            result.error("error", "Sending touch to an unknown view with id: " + id, null);
            return;
        }
        view.setLayoutDirection(direction);
        result.success(null);
    }

    private static boolean validateDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    private static List<MotionEvent.PointerProperties> parsePointerPropertiesList(Object rawPropertiesList) {
        List rawProperties = (List)rawPropertiesList;
        ArrayList<MotionEvent.PointerProperties> pointerProperties = new ArrayList<MotionEvent.PointerProperties>();
        for (Object o : rawProperties) {
            pointerProperties.add(PlatformViewsController.parsePointerProperties(o));
        }
        return pointerProperties;
    }

    private static MotionEvent.PointerProperties parsePointerProperties(Object rawProperties) {
        List propertiesList = (List)rawProperties;
        MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
        properties.id = (Integer)propertiesList.get(0);
        properties.toolType = (Integer)propertiesList.get(1);
        return properties;
    }

    private static List<MotionEvent.PointerCoords> parsePointerCoordsList(Object rawCoordsList, float density) {
        List rawCoords = (List)rawCoordsList;
        ArrayList<MotionEvent.PointerCoords> pointerCoords = new ArrayList<MotionEvent.PointerCoords>();
        for (Object o : rawCoords) {
            pointerCoords.add(PlatformViewsController.parsePointerCoords(o, density));
        }
        return pointerCoords;
    }

    private static MotionEvent.PointerCoords parsePointerCoords(Object rawCoords, float density) {
        List coordsList = (List)rawCoords;
        MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
        coords.orientation = (float)((Double)coordsList.get(0)).doubleValue();
        coords.pressure = (float)((Double)coordsList.get(1)).doubleValue();
        coords.size = (float)((Double)coordsList.get(2)).doubleValue();
        coords.toolMajor = (float)((Double)coordsList.get(3)).doubleValue() * density;
        coords.toolMinor = (float)((Double)coordsList.get(4)).doubleValue() * density;
        coords.touchMajor = (float)((Double)coordsList.get(5)).doubleValue() * density;
        coords.touchMinor = (float)((Double)coordsList.get(6)).doubleValue() * density;
        coords.x = (float)((Double)coordsList.get(7)).doubleValue() * density;
        coords.y = (float)((Double)coordsList.get(8)).doubleValue() * density;
        return coords;
    }

    private int toPhysicalPixels(double logicalPixels) {
        float density = this.mContext.getResources().getDisplayMetrics().density;
        return (int)Math.round(logicalPixels * (double)density);
    }

    private void flushAllViews() {
        for (VirtualDisplayController controller : this.vdControllers.values()) {
            controller.dispose();
        }
        this.vdControllers.clear();
    }
}

