// Copyright (c) 2017, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:io';

import 'package:csv/csv.dart';

void main() {
  var csv = new CsvCodec(eol: "\n");
  var data = csv.decoder.convert(new File("data.csv").readAsStringSync());

  // Remove comments and empty lines.
  data.removeWhere((row) => row.length < 3);

  var file = new File("lib/src/generated.dart").openSync(mode: FileMode.write);
  file.writeStringSync("""
    // Copyright (c) 2017, the Dart project authors.  Please see the AUTHORS file
    // for details. All rights reserved. Use of this source code is governed by a
    // BSD-style license that can be found in the LICENSE file.

    // Don't modify this file by hand! It's generated by tool/generate.dart.

    /// Whether the glyph getters return plain ASCII, as opposed to Unicode
    /// characters or sequences.
    ///
    /// Defaults to `false`.
    bool get ascii => _ascii;
    var _ascii = false;
    set ascii(bool value) {
      _ascii = value;
      if (value) {
  """);

  for (var glyph in data) {
    file.writeStringSync("_${glyph[0]} = ${_quote(glyph[2])};");
  }

  file.writeStringSync("} else {");

  for (var glyph in data) {
    file.writeStringSync("_${glyph[0]} = ${_quote(glyph[1])};");
  }

  file.writeStringSync("}}");

  for (var glyph in data) {
    for (var line in glyph[3].split("\n")) {
      file.writeStringSync("/// $line\n");
    }

    file.writeStringSync("""
      ///
      /// If [ascii] is `false`, this is "${glyph[1]}". If it's `true`, this is
      /// "${glyph[2]}" instead.
      String get ${glyph[0]} => _${glyph[0]};
      var _${glyph[0]} = ${_quote(glyph[1])};
    """);
  }

  var result = Process.runSync(
      "pub", ["run", "dart_style:format", "-w", "lib/src/generated.dart"]);
  print(result.stderr);
  exit(result.exitCode);
}

String _quote(String input) => input.contains('"') ? "'$input'" : '"$input"';
