/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.flutter.Log;
import io.flutter.embedding.android.FlutterEngineConfigurator;
import io.flutter.embedding.android.FlutterEngineProvider;
import io.flutter.embedding.android.FlutterSplashView;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.SplashScreen;
import io.flutter.embedding.android.SplashScreenProvider;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterEngineCache;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.view.FlutterMain;
import java.util.Arrays;

final class FlutterActivityAndFragmentDelegate {
    private static final String TAG = "FlutterActivityAndFragmentDelegate";
    @NonNull
    private Host host;
    @Nullable
    private FlutterEngine flutterEngine;
    @Nullable
    private FlutterSplashView flutterSplashView;
    @Nullable
    private FlutterView flutterView;
    @Nullable
    private PlatformPlugin platformPlugin;
    private boolean isFlutterEngineFromHost;
    @NonNull
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            FlutterActivityAndFragmentDelegate.this.host.onFlutterUiDisplayed();
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
            FlutterActivityAndFragmentDelegate.this.host.onFlutterUiNoLongerDisplayed();
        }
    };

    FlutterActivityAndFragmentDelegate(@NonNull Host host) {
        this.host = host;
    }

    void release() {
        this.host = null;
        this.flutterEngine = null;
        this.flutterView = null;
        this.platformPlugin = null;
    }

    @Nullable
    FlutterEngine getFlutterEngine() {
        return this.flutterEngine;
    }

    void onAttach(@NonNull Context context) {
        this.ensureAlive();
        this.initializeFlutter(context);
        if (this.flutterEngine == null) {
            this.setupFlutterEngine();
        }
        this.platformPlugin = this.host.providePlatformPlugin(this.host.getActivity(), this.flutterEngine);
        if (this.host.shouldAttachEngineToActivity()) {
            Log.d(TAG, "Attaching FlutterEngine to the Activity that owns this Fragment.");
            this.flutterEngine.getActivityControlSurface().attachToActivity(this.host.getActivity(), this.host.getLifecycle());
        }
        this.host.configureFlutterEngine(this.flutterEngine);
    }

    private void initializeFlutter(@NonNull Context context) {
        FlutterMain.ensureInitializationComplete(context.getApplicationContext(), this.host.getFlutterShellArgs().toArray());
    }

    private void setupFlutterEngine() {
        Log.d(TAG, "Setting up FlutterEngine.");
        String cachedEngineId = this.host.getCachedEngineId();
        if (cachedEngineId != null) {
            this.flutterEngine = FlutterEngineCache.getInstance().get(cachedEngineId);
            this.isFlutterEngineFromHost = true;
            if (this.flutterEngine == null) {
                throw new IllegalStateException("The requested cached FlutterEngine did not exist in the FlutterEngineCache: '" + cachedEngineId + "'");
            }
            return;
        }
        this.flutterEngine = this.host.provideFlutterEngine(this.host.getContext());
        if (this.flutterEngine != null) {
            this.isFlutterEngineFromHost = true;
            return;
        }
        Log.d(TAG, "No preferred FlutterEngine was provided. Creating a new FlutterEngine for this FlutterFragment.");
        this.flutterEngine = new FlutterEngine(this.host.getContext());
        this.isFlutterEngineFromHost = false;
    }

    @NonNull
    View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Log.v(TAG, "Creating FlutterView.");
        this.ensureAlive();
        this.flutterView = new FlutterView((Context)this.host.getActivity(), this.host.getRenderMode(), this.host.getTransparencyMode());
        this.flutterView.addOnFirstFrameRenderedListener(this.flutterUiDisplayListener);
        this.flutterSplashView = new FlutterSplashView(this.host.getContext());
        if (Build.VERSION.SDK_INT >= 17) {
            this.flutterSplashView.setId(View.generateViewId());
        } else {
            this.flutterSplashView.setId(486947586);
        }
        this.flutterSplashView.displayFlutterViewWithSplash(this.flutterView, this.host.provideSplashScreen());
        return this.flutterSplashView;
    }

    void onStart() {
        Log.v(TAG, "onStart()");
        this.ensureAlive();
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                Log.v(FlutterActivityAndFragmentDelegate.TAG, "Attaching FlutterEngine to FlutterView.");
                FlutterActivityAndFragmentDelegate.this.flutterView.attachToFlutterEngine(FlutterActivityAndFragmentDelegate.this.flutterEngine);
                FlutterActivityAndFragmentDelegate.this.doInitialFlutterViewRun();
            }
        });
    }

    private void doInitialFlutterViewRun() {
        if (this.host.getCachedEngineId() != null) {
            return;
        }
        if (this.flutterEngine.getDartExecutor().isExecutingDart()) {
            return;
        }
        Log.d(TAG, "Executing Dart entrypoint: " + this.host.getDartEntrypointFunctionName() + ", and sending initial route: " + this.host.getInitialRoute());
        if (this.host.getInitialRoute() != null) {
            this.flutterEngine.getNavigationChannel().setInitialRoute(this.host.getInitialRoute());
        }
        DartExecutor.DartEntrypoint entrypoint = new DartExecutor.DartEntrypoint(this.host.getAppBundlePath(), this.host.getDartEntrypointFunctionName());
        this.flutterEngine.getDartExecutor().executeDartEntrypoint(entrypoint);
    }

    void onResume() {
        Log.v(TAG, "onResume()");
        this.ensureAlive();
        this.flutterEngine.getLifecycleChannel().appIsResumed();
    }

    void onPostResume() {
        Log.v(TAG, "onPostResume()");
        this.ensureAlive();
        if (this.flutterEngine != null) {
            if (this.platformPlugin != null) {
                this.platformPlugin.updateSystemUiOverlays();
            }
        } else {
            Log.w(TAG, "onPostResume() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onPause() {
        Log.v(TAG, "onPause()");
        this.ensureAlive();
        this.flutterEngine.getLifecycleChannel().appIsInactive();
    }

    void onStop() {
        Log.v(TAG, "onStop()");
        this.ensureAlive();
        this.flutterEngine.getLifecycleChannel().appIsPaused();
        this.flutterView.detachFromFlutterEngine();
    }

    void onDestroyView() {
        Log.v(TAG, "onDestroyView()");
        this.ensureAlive();
        this.flutterView.removeOnFirstFrameRenderedListener(this.flutterUiDisplayListener);
    }

    void onDetach() {
        Log.v(TAG, "onDetach()");
        this.ensureAlive();
        if (this.host.shouldAttachEngineToActivity()) {
            Log.d(TAG, "Detaching FlutterEngine from the Activity that owns this Fragment.");
            if (this.host.getActivity().isChangingConfigurations()) {
                this.flutterEngine.getActivityControlSurface().detachFromActivityForConfigChanges();
            } else {
                this.flutterEngine.getActivityControlSurface().detachFromActivity();
            }
        }
        if (this.platformPlugin != null) {
            this.platformPlugin.destroy();
            this.platformPlugin = null;
        }
        if (this.host.shouldDestroyEngineWithHost()) {
            this.flutterEngine.destroy();
            if (this.host.getCachedEngineId() != null) {
                FlutterEngineCache.getInstance().remove(this.host.getCachedEngineId());
            }
            this.flutterEngine = null;
        }
    }

    void onBackPressed() {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onBackPressed() to FlutterEngine.");
            this.flutterEngine.getNavigationChannel().popRoute();
        } else {
            Log.w(TAG, "Invoked onBackPressed() before FlutterFragment was attached to an Activity.");
        }
    }

    void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onRequestPermissionsResult() to FlutterEngine:\nrequestCode: " + requestCode + "\npermissions: " + Arrays.toString(permissions) + "\ngrantResults: " + Arrays.toString(grantResults));
            this.flutterEngine.getActivityControlSurface().onRequestPermissionsResult(requestCode, permissions, grantResults);
        } else {
            Log.w(TAG, "onRequestPermissionResult() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onNewIntent(@NonNull Intent intent) {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onNewIntent() to FlutterEngine.");
            this.flutterEngine.getActivityControlSurface().onNewIntent(intent);
        } else {
            Log.w(TAG, "onNewIntent() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onActivityResult() to FlutterEngine:\nrequestCode: " + requestCode + "\nresultCode: " + resultCode + "\ndata: " + data);
            this.flutterEngine.getActivityControlSurface().onActivityResult(requestCode, resultCode, data);
        } else {
            Log.w(TAG, "onActivityResult() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onUserLeaveHint() {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            Log.v(TAG, "Forwarding onUserLeaveHint() to FlutterEngine.");
            this.flutterEngine.getActivityControlSurface().onUserLeaveHint();
        } else {
            Log.w(TAG, "onUserLeaveHint() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onTrimMemory(int level) {
        this.ensureAlive();
        if (this.flutterEngine != null) {
            if (level == 10) {
                Log.v(TAG, "Forwarding onTrimMemory() to FlutterEngine. Level: " + level);
                this.flutterEngine.getSystemChannel().sendMemoryPressureWarning();
            }
        } else {
            Log.w(TAG, "onTrimMemory() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    void onLowMemory() {
        Log.v(TAG, "Forwarding onLowMemory() to FlutterEngine.");
        this.ensureAlive();
        this.flutterEngine.getSystemChannel().sendMemoryPressureWarning();
    }

    private void ensureAlive() {
        if (this.host == null) {
            throw new IllegalStateException("Cannot execute method on a destroyed FlutterActivityAndFragmentDelegate.");
        }
    }

    static interface Host
    extends SplashScreenProvider,
    FlutterEngineProvider,
    FlutterEngineConfigurator {
        @NonNull
        public Context getContext();

        @Nullable
        public Activity getActivity();

        @NonNull
        public Lifecycle getLifecycle();

        @NonNull
        public FlutterShellArgs getFlutterShellArgs();

        @Nullable
        public String getCachedEngineId();

        public boolean shouldDestroyEngineWithHost();

        @NonNull
        public String getDartEntrypointFunctionName();

        @NonNull
        public String getAppBundlePath();

        @Nullable
        public String getInitialRoute();

        @NonNull
        public FlutterView.RenderMode getRenderMode();

        @NonNull
        public FlutterView.TransparencyMode getTransparencyMode();

        @Override
        @Nullable
        public SplashScreen provideSplashScreen();

        @Override
        @Nullable
        public FlutterEngine provideFlutterEngine(@NonNull Context var1);

        @Nullable
        public PlatformPlugin providePlatformPlugin(@Nullable Activity var1, @NonNull FlutterEngine var2);

        @Override
        public void configureFlutterEngine(@NonNull FlutterEngine var1);

        public boolean shouldAttachEngineToActivity();

        public void onFlutterUiDisplayed();

        public void onFlutterUiNoLongerDisplayed();
    }
}

