/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Build;
import android.os.LocaleList;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidKeyProcessor;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterSurfaceView;
import io.flutter.embedding.android.FlutterTextureView;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.RenderSurface;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.view.AccessibilityBridge;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class FlutterView
extends FrameLayout {
    private static final String TAG = "FlutterView";
    @NonNull
    private RenderMode renderMode;
    @Nullable
    private TransparencyMode transparencyMode;
    @Nullable
    private RenderSurface renderSurface;
    private final Set<FlutterUiDisplayListener> flutterUiDisplayListeners = new HashSet<FlutterUiDisplayListener>();
    private boolean isFlutterUiDisplayed;
    @Nullable
    private FlutterEngine flutterEngine;
    @NonNull
    private final Set<FlutterEngineAttachmentListener> flutterEngineAttachmentListeners = new HashSet<FlutterEngineAttachmentListener>();
    @Nullable
    private TextInputPlugin textInputPlugin;
    @Nullable
    private AndroidKeyProcessor androidKeyProcessor;
    @Nullable
    private AndroidTouchProcessor androidTouchProcessor;
    @Nullable
    private AccessibilityBridge accessibilityBridge;
    private final FlutterRenderer.ViewportMetrics viewportMetrics = new FlutterRenderer.ViewportMetrics();
    private final AccessibilityBridge.OnAccessibilityChangeListener onAccessibilityChangeListener = new AccessibilityBridge.OnAccessibilityChangeListener(){

        @Override
        public void onAccessibilityChanged(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
            FlutterView.this.resetWillNotDraw(isAccessibilityEnabled, isTouchExplorationEnabled);
        }
    };
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            FlutterView.this.isFlutterUiDisplayed = true;
            for (FlutterUiDisplayListener listener : FlutterView.this.flutterUiDisplayListeners) {
                listener.onFlutterUiDisplayed();
            }
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
            FlutterView.this.isFlutterUiDisplayed = false;
            for (FlutterUiDisplayListener listener : FlutterView.this.flutterUiDisplayListeners) {
                listener.onFlutterUiNoLongerDisplayed();
            }
        }
    };

    public FlutterView(@NonNull Context context) {
        this(context, null, null, null);
    }

    public FlutterView(@NonNull Context context, @NonNull RenderMode renderMode) {
        this(context, null, renderMode, null);
    }

    public FlutterView(@NonNull Context context, @NonNull TransparencyMode transparencyMode) {
        this(context, null, RenderMode.surface, transparencyMode);
    }

    public FlutterView(@NonNull Context context, @NonNull RenderMode renderMode, @NonNull TransparencyMode transparencyMode) {
        this(context, null, renderMode, transparencyMode);
    }

    public FlutterView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, null, null);
    }

    private FlutterView(@NonNull Context context, @Nullable AttributeSet attrs, @Nullable RenderMode renderMode, @Nullable TransparencyMode transparencyMode) {
        super(context, attrs);
        this.renderMode = renderMode == null ? RenderMode.surface : renderMode;
        this.transparencyMode = transparencyMode != null ? transparencyMode : TransparencyMode.opaque;
        this.init();
    }

    private void init() {
        Log.v(TAG, "Initializing FlutterView");
        switch (this.renderMode) {
            case surface: {
                Log.v(TAG, "Internally using a FlutterSurfaceView.");
                FlutterSurfaceView flutterSurfaceView = new FlutterSurfaceView(this.getContext(), this.transparencyMode == TransparencyMode.transparent);
                this.renderSurface = flutterSurfaceView;
                this.addView((View)flutterSurfaceView);
                break;
            }
            case texture: {
                Log.v(TAG, "Internally using a FlutterTextureView.");
                FlutterTextureView flutterTextureView = new FlutterTextureView(this.getContext());
                this.renderSurface = flutterTextureView;
                this.addView((View)flutterTextureView);
            }
        }
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
    }

    public boolean hasRenderedFirstFrame() {
        return this.isFlutterUiDisplayed;
    }

    public void addOnFirstFrameRenderedListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterUiDisplayListeners.add(listener);
    }

    public void removeOnFirstFrameRenderedListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterUiDisplayListeners.remove(listener);
    }

    protected void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.v(TAG, "Configuration changed. Sending locales and user settings to Flutter.");
        this.sendLocalesToFlutter(newConfig);
        this.sendUserSettingsToFlutter();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        Log.v(TAG, "Size changed. Sending Flutter new viewport metrics. FlutterView was " + oldWidth + " x " + oldHeight + ", it is now " + width + " x " + height);
        this.viewportMetrics.width = width;
        this.viewportMetrics.height = height;
        this.sendViewportMetricsToFlutter();
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    @SuppressLint(value={"InlinedApi", "NewApi"})
    @NonNull
    public final WindowInsets onApplyWindowInsets(@NonNull WindowInsets insets) {
        WindowInsets newInsets = super.onApplyWindowInsets(insets);
        this.viewportMetrics.paddingTop = insets.getSystemWindowInsetTop();
        this.viewportMetrics.paddingRight = insets.getSystemWindowInsetRight();
        this.viewportMetrics.paddingBottom = 0;
        this.viewportMetrics.paddingLeft = insets.getSystemWindowInsetLeft();
        this.viewportMetrics.viewInsetTop = 0;
        this.viewportMetrics.viewInsetRight = 0;
        this.viewportMetrics.viewInsetBottom = insets.getSystemWindowInsetBottom();
        this.viewportMetrics.viewInsetLeft = 0;
        if (Build.VERSION.SDK_INT >= 29) {
            Insets systemGestureInsets = insets.getSystemGestureInsets();
            this.viewportMetrics.systemGestureInsetTop = systemGestureInsets.top;
            this.viewportMetrics.systemGestureInsetRight = systemGestureInsets.right;
            this.viewportMetrics.systemGestureInsetBottom = systemGestureInsets.bottom;
            this.viewportMetrics.systemGestureInsetLeft = systemGestureInsets.left;
        }
        Log.v(TAG, "Updating window insets (onApplyWindowInsets()):\nStatus bar insets: Top: " + this.viewportMetrics.paddingTop + ", Left: " + this.viewportMetrics.paddingLeft + ", Right: " + this.viewportMetrics.paddingRight + "\nKeyboard insets: Bottom: " + this.viewportMetrics.viewInsetBottom + ", Left: " + this.viewportMetrics.viewInsetLeft + ", Right: " + this.viewportMetrics.viewInsetRight + "System Gesture Insets - Left: " + this.viewportMetrics.systemGestureInsetLeft + ", Top: " + this.viewportMetrics.systemGestureInsetTop + ", Right: " + this.viewportMetrics.systemGestureInsetRight + ", Bottom: " + this.viewportMetrics.viewInsetBottom);
        this.sendViewportMetricsToFlutter();
        return newInsets;
    }

    protected boolean fitSystemWindows(@NonNull Rect insets) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.viewportMetrics.paddingTop = insets.top;
            this.viewportMetrics.paddingRight = insets.right;
            this.viewportMetrics.paddingBottom = 0;
            this.viewportMetrics.paddingLeft = insets.left;
            this.viewportMetrics.viewInsetTop = 0;
            this.viewportMetrics.viewInsetRight = 0;
            this.viewportMetrics.viewInsetBottom = insets.bottom;
            this.viewportMetrics.viewInsetLeft = 0;
            Log.v(TAG, "Updating window insets (fitSystemWindows()):\nStatus bar insets: Top: " + this.viewportMetrics.paddingTop + ", Left: " + this.viewportMetrics.paddingLeft + ", Right: " + this.viewportMetrics.paddingRight + "\nKeyboard insets: Bottom: " + this.viewportMetrics.viewInsetBottom + ", Left: " + this.viewportMetrics.viewInsetLeft + ", Right: " + this.viewportMetrics.viewInsetRight);
            this.sendViewportMetricsToFlutter();
            return true;
        }
        return super.fitSystemWindows(insets);
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NonNull EditorInfo outAttrs) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onCreateInputConnection(outAttrs);
        }
        return this.textInputPlugin.createInputConnection((View)this, outAttrs);
    }

    public boolean checkInputConnectionProxy(View view) {
        return this.flutterEngine != null ? this.flutterEngine.getPlatformViewsController().checkInputConnectionProxy(view) : super.checkInputConnectionProxy(view);
    }

    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onKeyUp(keyCode, event);
        }
        this.androidKeyProcessor.onKeyUp(event);
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onKeyDown(keyCode, event);
        }
        this.androidKeyProcessor.onKeyDown(event);
        return super.onKeyDown(keyCode, event);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onTouchEvent(event);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.requestUnbufferedDispatch(event);
        }
        return this.androidTouchProcessor.onTouchEvent(event);
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        boolean handled = this.isAttachedToFlutterEngine() && this.androidTouchProcessor.onGenericMotionEvent(event);
        return handled ? true : super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onHoverEvent(event);
        }
        boolean handled = this.accessibilityBridge.onAccessibilityHoverEvent(event);
        if (!handled) {
            // empty if block
        }
        return handled;
    }

    @Nullable
    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.accessibilityBridge != null && this.accessibilityBridge.isAccessibilityEnabled()) {
            return this.accessibilityBridge;
        }
        return null;
    }

    private void resetWillNotDraw(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
        if (!this.flutterEngine.getRenderer().isSoftwareRenderingEnabled()) {
            this.setWillNotDraw(!isAccessibilityEnabled && !isTouchExplorationEnabled);
        } else {
            this.setWillNotDraw(false);
        }
    }

    public void attachToFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        Log.d(TAG, "Attaching to a FlutterEngine: " + flutterEngine);
        if (this.isAttachedToFlutterEngine()) {
            if (flutterEngine == this.flutterEngine) {
                Log.d(TAG, "Already attached to this engine. Doing nothing.");
                return;
            }
            Log.d(TAG, "Currently attached to a different engine. Detaching and then attaching to new engine.");
            this.detachFromFlutterEngine();
        }
        this.flutterEngine = flutterEngine;
        FlutterRenderer flutterRenderer = this.flutterEngine.getRenderer();
        this.isFlutterUiDisplayed = flutterRenderer.isDisplayingFlutterUi();
        this.renderSurface.attachToRenderer(flutterRenderer);
        flutterRenderer.addIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
        this.textInputPlugin = new TextInputPlugin((View)this, this.flutterEngine.getDartExecutor(), this.flutterEngine.getPlatformViewsController());
        this.androidKeyProcessor = new AndroidKeyProcessor(this.flutterEngine.getKeyEventChannel(), this.textInputPlugin);
        this.androidTouchProcessor = new AndroidTouchProcessor(this.flutterEngine.getRenderer());
        this.accessibilityBridge = new AccessibilityBridge((View)this, flutterEngine.getAccessibilityChannel(), (AccessibilityManager)this.getContext().getSystemService("accessibility"), this.getContext().getContentResolver(), this.flutterEngine.getPlatformViewsController());
        this.accessibilityBridge.setOnAccessibilityChangeListener(this.onAccessibilityChangeListener);
        this.resetWillNotDraw(this.accessibilityBridge.isAccessibilityEnabled(), this.accessibilityBridge.isTouchExplorationEnabled());
        this.flutterEngine.getPlatformViewsController().attachAccessibilityBridge(this.accessibilityBridge);
        this.textInputPlugin.getInputMethodManager().restartInput((View)this);
        this.sendUserSettingsToFlutter();
        this.sendLocalesToFlutter(this.getResources().getConfiguration());
        this.sendViewportMetricsToFlutter();
        for (FlutterEngineAttachmentListener listener : this.flutterEngineAttachmentListeners) {
            listener.onFlutterEngineAttachedToFlutterView(flutterEngine);
        }
        if (this.isFlutterUiDisplayed) {
            this.flutterUiDisplayListener.onFlutterUiDisplayed();
        }
    }

    public void detachFromFlutterEngine() {
        Log.d(TAG, "Detaching from a FlutterEngine: " + this.flutterEngine);
        if (!this.isAttachedToFlutterEngine()) {
            Log.d(TAG, "Not attached to an engine. Doing nothing.");
            return;
        }
        for (FlutterEngineAttachmentListener listener : this.flutterEngineAttachmentListeners) {
            listener.onFlutterEngineDetachedFromFlutterView();
        }
        this.flutterEngine.getPlatformViewsController().detachAccessibiltyBridge();
        this.accessibilityBridge.release();
        this.accessibilityBridge = null;
        this.textInputPlugin.getInputMethodManager().restartInput((View)this);
        this.textInputPlugin.destroy();
        FlutterRenderer flutterRenderer = this.flutterEngine.getRenderer();
        this.isFlutterUiDisplayed = false;
        flutterRenderer.removeIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
        flutterRenderer.stopRenderingToSurface();
        this.renderSurface.detachFromRenderer();
        this.flutterEngine = null;
    }

    @VisibleForTesting
    public boolean isAttachedToFlutterEngine() {
        return this.flutterEngine != null && this.flutterEngine.getRenderer() == this.renderSurface.getAttachedRenderer();
    }

    @VisibleForTesting
    @Nullable
    public FlutterEngine getAttachedFlutterEngine() {
        return this.flutterEngine;
    }

    @VisibleForTesting
    public void addFlutterEngineAttachmentListener(@NonNull FlutterEngineAttachmentListener listener) {
        this.flutterEngineAttachmentListeners.add(listener);
    }

    @VisibleForTesting
    public void removeFlutterEngineAttachmentListener(@NonNull FlutterEngineAttachmentListener listener) {
        this.flutterEngineAttachmentListeners.remove(listener);
    }

    private void sendLocalesToFlutter(@NonNull Configuration config) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = config.getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                locales.add(locale);
            }
        } else {
            locales.add(config.locale);
        }
        this.flutterEngine.getLocalizationChannel().sendLocales(locales);
    }

    private void sendUserSettingsToFlutter() {
        this.flutterEngine.getSettingsChannel().startMessage().setTextScaleFactor(this.getResources().getConfiguration().fontScale).setUse24HourFormat(DateFormat.is24HourFormat((Context)this.getContext())).send();
    }

    private void sendViewportMetricsToFlutter() {
        if (!this.isAttachedToFlutterEngine()) {
            Log.w(TAG, "Tried to send viewport metrics from Android to Flutter but this FlutterView was not attached to a FlutterEngine.");
            return;
        }
        this.viewportMetrics.devicePixelRatio = this.getResources().getDisplayMetrics().density;
        this.flutterEngine.getRenderer().setViewportMetrics(this.viewportMetrics);
    }

    @VisibleForTesting
    public static interface FlutterEngineAttachmentListener {
        public void onFlutterEngineAttachedToFlutterView(@NonNull FlutterEngine var1);

        public void onFlutterEngineDetachedFromFlutterView();
    }

    public static enum TransparencyMode {
        opaque,
        transparent;

    }

    public static enum RenderMode {
        surface,
        texture;

    }
}

