/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

class ResourceExtractor {
    private static final String TAG = "ResourceExtractor";
    private static final String TIMESTAMP_PREFIX = "res_timestamp-";
    private static final String[] SUPPORTED_ABIS = ResourceExtractor.getSupportedAbis();
    @NonNull
    private final String mDataDirPath;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final PackageManager mPackageManager;
    @NonNull
    private final AssetManager mAssetManager;
    @NonNull
    private final HashSet<String> mResources;
    private ExtractTask mExtractTask;

    static long getVersionCode(@NonNull PackageInfo packageInfo) {
        if (Build.VERSION.SDK_INT >= 28) {
            return packageInfo.getLongVersionCode();
        }
        return packageInfo.versionCode;
    }

    ResourceExtractor(@NonNull String dataDirPath, @NonNull String packageName, @NonNull PackageManager packageManager, @NonNull AssetManager assetManager) {
        this.mDataDirPath = dataDirPath;
        this.mPackageName = packageName;
        this.mPackageManager = packageManager;
        this.mAssetManager = assetManager;
        this.mResources = new HashSet();
    }

    ResourceExtractor addResource(@NonNull String resource) {
        this.mResources.add(resource);
        return this;
    }

    ResourceExtractor addResources(@NonNull Collection<String> resources) {
        this.mResources.addAll(resources);
        return this;
    }

    ResourceExtractor start() {
        if (this.mExtractTask != null) {
            Log.e((String)TAG, (String)"Attempted to start resource extraction while another extraction was in progress.");
        }
        this.mExtractTask = new ExtractTask(this.mDataDirPath, this.mResources, this.mPackageName, this.mPackageManager, this.mAssetManager);
        this.mExtractTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return this;
    }

    void waitForCompletion() {
        if (this.mExtractTask == null) {
            return;
        }
        try {
            this.mExtractTask.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            ResourceExtractor.deleteFiles(this.mDataDirPath, this.mResources);
        }
    }

    private static String[] getExistingTimestamps(File dataDir) {
        return dataDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(ResourceExtractor.TIMESTAMP_PREFIX);
            }
        });
    }

    private static void deleteFiles(@NonNull String dataDirPath, @NonNull HashSet<String> resources) {
        File dataDir = new File(dataDirPath);
        for (String resource : resources) {
            File file = new File(dataDir, resource);
            if (!file.exists()) continue;
            file.delete();
        }
        String[] existingTimestamps = ResourceExtractor.getExistingTimestamps(dataDir);
        if (existingTimestamps == null) {
            return;
        }
        for (String timestamp : existingTimestamps) {
            new File(dataDir, timestamp).delete();
        }
    }

    private static String checkTimestamp(@NonNull File dataDir, @NonNull PackageManager packageManager, @NonNull String packageName) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return TIMESTAMP_PREFIX;
        }
        if (packageInfo == null) {
            return TIMESTAMP_PREFIX;
        }
        String expectedTimestamp = TIMESTAMP_PREFIX + ResourceExtractor.getVersionCode(packageInfo) + "-" + packageInfo.lastUpdateTime;
        String[] existingTimestamps = ResourceExtractor.getExistingTimestamps(dataDir);
        if (existingTimestamps == null) {
            Log.i((String)TAG, (String)"No extracted resources found");
            return expectedTimestamp;
        }
        if (existingTimestamps.length == 1) {
            Log.i((String)TAG, (String)("Found extracted resources " + existingTimestamps[0]));
        }
        if (existingTimestamps.length != 1 || !expectedTimestamp.equals(existingTimestamps[0])) {
            Log.i((String)TAG, (String)("Resource version mismatch " + expectedTimestamp));
            return expectedTimestamp;
        }
        return null;
    }

    private static void copy(@NonNull InputStream in, @NonNull OutputStream out) throws IOException {
        int i;
        byte[] buf = new byte[16384];
        while ((i = in.read(buf)) >= 0) {
            out.write(buf, 0, i);
        }
    }

    private static String[] getSupportedAbis() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        ArrayList<String> cpuAbis = new ArrayList<String>(Arrays.asList(Build.CPU_ABI, Build.CPU_ABI2));
        cpuAbis.removeAll(Arrays.asList(null, ""));
        return cpuAbis.toArray(new String[0]);
    }

    private static class ExtractTask
    extends AsyncTask<Void, Void, Void> {
        @NonNull
        private final String mDataDirPath;
        @NonNull
        private final HashSet<String> mResources;
        @NonNull
        private final AssetManager mAssetManager;
        @NonNull
        private final String mPackageName;
        @NonNull
        private final PackageManager mPackageManager;

        ExtractTask(@NonNull String dataDirPath, @NonNull HashSet<String> resources, @NonNull String packageName, @NonNull PackageManager packageManager, @NonNull AssetManager assetManager) {
            this.mDataDirPath = dataDirPath;
            this.mResources = resources;
            this.mAssetManager = assetManager;
            this.mPackageName = packageName;
            this.mPackageManager = packageManager;
        }

        protected Void doInBackground(Void ... unused) {
            File dataDir = new File(this.mDataDirPath);
            String timestamp = ResourceExtractor.checkTimestamp(dataDir, this.mPackageManager, this.mPackageName);
            if (timestamp == null) {
                return null;
            }
            ResourceExtractor.deleteFiles(this.mDataDirPath, this.mResources);
            if (!this.extractAPK(dataDir)) {
                return null;
            }
            if (timestamp != null) {
                try {
                    new File(dataDir, timestamp).createNewFile();
                }
                catch (IOException e) {
                    Log.w((String)ResourceExtractor.TAG, (String)"Failed to write resource timestamp");
                }
            }
            return null;
        }

        @WorkerThread
        private boolean extractAPK(@NonNull File dataDir) {
            for (String asset : this.mResources) {
                try {
                    String resource = "assets/" + asset;
                    File output = new File(dataDir, asset);
                    if (output.exists()) continue;
                    if (output.getParentFile() != null) {
                        output.getParentFile().mkdirs();
                    }
                    try (InputStream is = this.mAssetManager.open(asset);
                         FileOutputStream os = new FileOutputStream(output);){
                        ResourceExtractor.copy(is, os);
                    }
                    Log.i((String)ResourceExtractor.TAG, (String)("Extracted baseline resource " + resource));
                }
                catch (FileNotFoundException fnfe) {
                }
                catch (IOException ioe) {
                    Log.w((String)ResourceExtractor.TAG, (String)("Exception unpacking resources: " + ioe.getMessage()));
                    ResourceExtractor.deleteFiles(this.mDataDirPath, this.mResources);
                    return false;
                }
            }
            return true;
        }
    }
}

