/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.flutter.Log;
import io.flutter.embedding.android.FlutterActivityAndFragmentDelegate;
import io.flutter.embedding.android.FlutterEngineConfigurator;
import io.flutter.embedding.android.FlutterEngineProvider;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.SplashScreen;
import io.flutter.embedding.android.SplashScreenProvider;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.view.FlutterMain;

public class FlutterFragment
extends Fragment
implements FlutterActivityAndFragmentDelegate.Host {
    private static final String TAG = "FlutterFragment";
    protected static final String ARG_DART_ENTRYPOINT = "dart_entrypoint";
    protected static final String ARG_INITIAL_ROUTE = "initial_route";
    protected static final String ARG_APP_BUNDLE_PATH = "app_bundle_path";
    protected static final String ARG_FLUTTER_INITIALIZATION_ARGS = "initialization_args";
    protected static final String ARG_FLUTTERVIEW_RENDER_MODE = "flutterview_render_mode";
    protected static final String ARG_FLUTTERVIEW_TRANSPARENCY_MODE = "flutterview_transparency_mode";
    protected static final String ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY = "should_attach_engine_to_activity";
    protected static final String ARG_CACHED_ENGINE_ID = "cached_engine_id";
    protected static final String ARG_DESTROY_ENGINE_WITH_FRAGMENT = "destroy_engine_with_fragment";
    private FlutterActivityAndFragmentDelegate delegate;

    @NonNull
    public static FlutterFragment createDefault() {
        return new NewEngineFragmentBuilder().build();
    }

    @NonNull
    public static NewEngineFragmentBuilder withNewEngine() {
        return new NewEngineFragmentBuilder();
    }

    @NonNull
    public static CachedEngineFragmentBuilder withCachedEngine(@NonNull String engineId) {
        return new CachedEngineFragmentBuilder(engineId);
    }

    public FlutterFragment() {
        this.setArguments(new Bundle());
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.delegate = new FlutterActivityAndFragmentDelegate(this);
        this.delegate.onAttach(context);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return this.delegate.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.delegate.onStart();
    }

    public void onResume() {
        super.onResume();
        this.delegate.onResume();
    }

    @ActivityCallThrough
    public void onPostResume() {
        this.delegate.onPostResume();
    }

    public void onPause() {
        super.onPause();
        this.delegate.onPause();
    }

    public void onStop() {
        super.onStop();
        this.delegate.onStop();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.delegate.onDestroyView();
    }

    public void onDetach() {
        super.onDetach();
        this.delegate.onDetach();
        this.delegate.release();
        this.delegate = null;
    }

    @ActivityCallThrough
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.delegate.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @ActivityCallThrough
    public void onNewIntent(@NonNull Intent intent) {
        this.delegate.onNewIntent(intent);
    }

    @ActivityCallThrough
    public void onBackPressed() {
        this.delegate.onBackPressed();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.delegate.onActivityResult(requestCode, resultCode, data);
    }

    @ActivityCallThrough
    public void onUserLeaveHint() {
        this.delegate.onUserLeaveHint();
    }

    @ActivityCallThrough
    public void onTrimMemory(int level) {
        this.delegate.onTrimMemory(level);
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.delegate.onLowMemory();
    }

    @NonNull
    private Context getContextCompat() {
        return Build.VERSION.SDK_INT >= 23 ? this.getContext() : this.getActivity();
    }

    @Override
    @NonNull
    public FlutterShellArgs getFlutterShellArgs() {
        String[] flutterShellArgsArray = this.getArguments().getStringArray(ARG_FLUTTER_INITIALIZATION_ARGS);
        return new FlutterShellArgs(flutterShellArgsArray != null ? flutterShellArgsArray : new String[]{});
    }

    @Override
    @Nullable
    public String getCachedEngineId() {
        return this.getArguments().getString(ARG_CACHED_ENGINE_ID, null);
    }

    @Override
    public boolean shouldDestroyEngineWithHost() {
        return this.getArguments().getBoolean(ARG_DESTROY_ENGINE_WITH_FRAGMENT, false);
    }

    @Override
    @NonNull
    public String getDartEntrypointFunctionName() {
        return this.getArguments().getString(ARG_DART_ENTRYPOINT, "main");
    }

    @Override
    @NonNull
    public String getAppBundlePath() {
        return this.getArguments().getString(ARG_APP_BUNDLE_PATH, FlutterMain.findAppBundlePath());
    }

    @Override
    @Nullable
    public String getInitialRoute() {
        return this.getArguments().getString(ARG_INITIAL_ROUTE);
    }

    @Override
    @NonNull
    public FlutterView.RenderMode getRenderMode() {
        String renderModeName = this.getArguments().getString(ARG_FLUTTERVIEW_RENDER_MODE, FlutterView.RenderMode.surface.name());
        return FlutterView.RenderMode.valueOf(renderModeName);
    }

    @Override
    @NonNull
    public FlutterView.TransparencyMode getTransparencyMode() {
        String transparencyModeName = this.getArguments().getString(ARG_FLUTTERVIEW_TRANSPARENCY_MODE, FlutterView.TransparencyMode.transparent.name());
        return FlutterView.TransparencyMode.valueOf(transparencyModeName);
    }

    @Override
    @Nullable
    public SplashScreen provideSplashScreen() {
        FragmentActivity parentActivity = this.getActivity();
        if (parentActivity instanceof SplashScreenProvider) {
            SplashScreenProvider splashScreenProvider = (SplashScreenProvider)parentActivity;
            return splashScreenProvider.provideSplashScreen();
        }
        return null;
    }

    @Override
    @Nullable
    public FlutterEngine provideFlutterEngine(@NonNull Context context) {
        FlutterEngine flutterEngine = null;
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterEngineProvider) {
            Log.d(TAG, "Deferring to attached Activity to provide a FlutterEngine.");
            FlutterEngineProvider flutterEngineProvider = (FlutterEngineProvider)attachedActivity;
            flutterEngine = flutterEngineProvider.provideFlutterEngine(this.getContext());
        }
        return flutterEngine;
    }

    @Nullable
    public FlutterEngine getFlutterEngine() {
        return this.delegate.getFlutterEngine();
    }

    @Override
    @Nullable
    public PlatformPlugin providePlatformPlugin(@Nullable Activity activity, @NonNull FlutterEngine flutterEngine) {
        if (activity != null) {
            return new PlatformPlugin((Activity)this.getActivity(), flutterEngine.getPlatformChannel());
        }
        return null;
    }

    @Override
    public void configureFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterEngineConfigurator) {
            ((FlutterEngineConfigurator)attachedActivity).configureFlutterEngine(flutterEngine);
        }
    }

    @Override
    public boolean shouldAttachEngineToActivity() {
        return this.getArguments().getBoolean(ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY);
    }

    @Override
    public void onFlutterUiDisplayed() {
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterUiDisplayListener) {
            ((FlutterUiDisplayListener)attachedActivity).onFlutterUiDisplayed();
        }
    }

    @Override
    public void onFlutterUiNoLongerDisplayed() {
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterUiDisplayListener) {
            ((FlutterUiDisplayListener)attachedActivity).onFlutterUiNoLongerDisplayed();
        }
    }

    static @interface ActivityCallThrough {
    }

    public static class CachedEngineFragmentBuilder {
        private final Class<? extends FlutterFragment> fragmentClass;
        private final String engineId;
        private boolean destroyEngineWithFragment = false;
        private FlutterView.RenderMode renderMode = FlutterView.RenderMode.surface;
        private FlutterView.TransparencyMode transparencyMode = FlutterView.TransparencyMode.transparent;
        private boolean shouldAttachEngineToActivity = true;

        private CachedEngineFragmentBuilder(@NonNull String engineId) {
            this(FlutterFragment.class, engineId);
        }

        protected CachedEngineFragmentBuilder(@NonNull Class<? extends FlutterFragment> subclass, @NonNull String engineId) {
            this.fragmentClass = subclass;
            this.engineId = engineId;
        }

        @NonNull
        public CachedEngineFragmentBuilder destroyEngineWithFragment(boolean destroyEngineWithFragment) {
            this.destroyEngineWithFragment = destroyEngineWithFragment;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder renderMode(@NonNull FlutterView.RenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder transparencyMode(@NonNull FlutterView.TransparencyMode transparencyMode) {
            this.transparencyMode = transparencyMode;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder shouldAttachEngineToActivity(boolean shouldAttachEngineToActivity) {
            this.shouldAttachEngineToActivity = shouldAttachEngineToActivity;
            return this;
        }

        @NonNull
        protected Bundle createArgs() {
            Bundle args = new Bundle();
            args.putString(FlutterFragment.ARG_CACHED_ENGINE_ID, this.engineId);
            args.putBoolean(FlutterFragment.ARG_DESTROY_ENGINE_WITH_FRAGMENT, this.destroyEngineWithFragment);
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_RENDER_MODE, this.renderMode != null ? this.renderMode.name() : FlutterView.RenderMode.surface.name());
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_TRANSPARENCY_MODE, this.transparencyMode != null ? this.transparencyMode.name() : FlutterView.TransparencyMode.transparent.name());
            args.putBoolean(FlutterFragment.ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY, this.shouldAttachEngineToActivity);
            return args;
        }

        @NonNull
        public <T extends FlutterFragment> T build() {
            try {
                FlutterFragment frag = this.fragmentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (frag == null) {
                    throw new RuntimeException("The FlutterFragment subclass sent in the constructor (" + this.fragmentClass.getCanonicalName() + ") does not match the expected return type.");
                }
                Bundle args = this.createArgs();
                frag.setArguments(args);
                return (T)frag;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate FlutterFragment subclass (" + this.fragmentClass.getName() + ")", e);
            }
        }
    }

    public static class NewEngineFragmentBuilder {
        private final Class<? extends FlutterFragment> fragmentClass;
        private String dartEntrypoint = "main";
        private String initialRoute = "/";
        private String appBundlePath = null;
        private FlutterShellArgs shellArgs = null;
        private FlutterView.RenderMode renderMode = FlutterView.RenderMode.surface;
        private FlutterView.TransparencyMode transparencyMode = FlutterView.TransparencyMode.transparent;
        private boolean shouldAttachEngineToActivity = true;

        public NewEngineFragmentBuilder() {
            this.fragmentClass = FlutterFragment.class;
        }

        public NewEngineFragmentBuilder(@NonNull Class<? extends FlutterFragment> subclass) {
            this.fragmentClass = subclass;
        }

        @NonNull
        public NewEngineFragmentBuilder dartEntrypoint(@NonNull String dartEntrypoint) {
            this.dartEntrypoint = dartEntrypoint;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder appBundlePath(@NonNull String appBundlePath) {
            this.appBundlePath = appBundlePath;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder flutterShellArgs(@NonNull FlutterShellArgs shellArgs) {
            this.shellArgs = shellArgs;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder renderMode(@NonNull FlutterView.RenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder transparencyMode(@NonNull FlutterView.TransparencyMode transparencyMode) {
            this.transparencyMode = transparencyMode;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder shouldAttachEngineToActivity(boolean shouldAttachEngineToActivity) {
            this.shouldAttachEngineToActivity = shouldAttachEngineToActivity;
            return this;
        }

        @NonNull
        protected Bundle createArgs() {
            Bundle args = new Bundle();
            args.putString(FlutterFragment.ARG_INITIAL_ROUTE, this.initialRoute);
            args.putString(FlutterFragment.ARG_APP_BUNDLE_PATH, this.appBundlePath);
            args.putString(FlutterFragment.ARG_DART_ENTRYPOINT, this.dartEntrypoint);
            if (null != this.shellArgs) {
                args.putStringArray(FlutterFragment.ARG_FLUTTER_INITIALIZATION_ARGS, this.shellArgs.toArray());
            }
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_RENDER_MODE, this.renderMode != null ? this.renderMode.name() : FlutterView.RenderMode.surface.name());
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_TRANSPARENCY_MODE, this.transparencyMode != null ? this.transparencyMode.name() : FlutterView.TransparencyMode.transparent.name());
            args.putBoolean(FlutterFragment.ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY, this.shouldAttachEngineToActivity);
            args.putBoolean(FlutterFragment.ARG_DESTROY_ENGINE_WITH_FRAGMENT, true);
            return args;
        }

        @NonNull
        public <T extends FlutterFragment> T build() {
            try {
                FlutterFragment frag = this.fragmentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (frag == null) {
                    throw new RuntimeException("The FlutterFragment subclass sent in the constructor (" + this.fragmentClass.getCanonicalName() + ") does not match the expected return type.");
                }
                Bundle args = this.createArgs();
                frag.setArguments(args);
                return (T)frag;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate FlutterFragment subclass (" + this.fragmentClass.getName() + ")", e);
            }
        }
    }
}

