/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.Log;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;

public final class BasicMessageChannel<T> {
    private static final String TAG = "BasicMessageChannel#";
    public static final String CHANNEL_BUFFERS_CHANNEL = "dev.flutter/channel-buffers";
    @NonNull
    private final BinaryMessenger messenger;
    @NonNull
    private final String name;
    @NonNull
    private final MessageCodec<T> codec;

    public BasicMessageChannel(@NonNull BinaryMessenger messenger, @NonNull String name, @NonNull MessageCodec<T> codec) {
        if (messenger == null) {
            Log.e((String)TAG, (String)"Parameter messenger must not be null.");
        }
        if (name == null) {
            Log.e((String)TAG, (String)"Parameter name must not be null.");
        }
        if (codec == null) {
            Log.e((String)TAG, (String)"Parameter codec must not be null.");
        }
        this.messenger = messenger;
        this.name = name;
        this.codec = codec;
    }

    public void send(@Nullable T message) {
        this.send(message, null);
    }

    @UiThread
    public void send(@Nullable T message, @Nullable Reply<T> callback) {
        this.messenger.send(this.name, this.codec.encodeMessage(message), callback == null ? null : new IncomingReplyHandler(callback));
    }

    @UiThread
    public void setMessageHandler(@Nullable MessageHandler<T> handler) {
        this.messenger.setMessageHandler(this.name, handler == null ? null : new IncomingMessageHandler(handler));
    }

    public void resizeChannelBuffer(int newSize) {
        Charset charset = Charset.forName("UTF-8");
        String messageString = String.format(Locale.US, "resize\r%s\r%d", this.name, newSize);
        ByteBuffer message = ByteBuffer.wrap(messageString.getBytes(charset));
        this.messenger.send(CHANNEL_BUFFERS_CHANNEL, message);
    }

    private final class IncomingMessageHandler
    implements BinaryMessenger.BinaryMessageHandler {
        private final MessageHandler<T> handler;

        private IncomingMessageHandler(MessageHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void onMessage(@Nullable ByteBuffer message, final @NonNull BinaryMessenger.BinaryReply callback) {
            try {
                this.handler.onMessage(BasicMessageChannel.this.codec.decodeMessage(message), new Reply<T>(){

                    @Override
                    public void reply(T reply) {
                        callback.reply(BasicMessageChannel.this.codec.encodeMessage(reply));
                    }
                });
            }
            catch (RuntimeException e) {
                Log.e((String)(BasicMessageChannel.TAG + BasicMessageChannel.this.name), (String)"Failed to handle message", (Throwable)e);
                callback.reply(null);
            }
        }
    }

    private final class IncomingReplyHandler
    implements BinaryMessenger.BinaryReply {
        private final Reply<T> callback;

        private IncomingReplyHandler(Reply<T> callback) {
            this.callback = callback;
        }

        @Override
        public void reply(@Nullable ByteBuffer reply) {
            try {
                this.callback.reply(BasicMessageChannel.this.codec.decodeMessage(reply));
            }
            catch (RuntimeException e) {
                Log.e((String)(BasicMessageChannel.TAG + BasicMessageChannel.this.name), (String)"Failed to handle message reply", (Throwable)e);
            }
        }
    }

    public static interface Reply<T> {
        public void reply(@Nullable T var1);
    }

    public static interface MessageHandler<T> {
        public void onMessage(@Nullable T var1, @NonNull Reply<T> var2);
    }
}

