/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LifecycleRegistry;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.view.Window;
import io.flutter.Log;
import io.flutter.embedding.android.DrawableSplashScreen;
import io.flutter.embedding.android.FlutterActivityAndFragmentDelegate;
import io.flutter.embedding.android.FlutterActivityLaunchConfigs;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.SplashScreen;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.view.FlutterMain;

public class FlutterActivity
extends Activity
implements FlutterActivityAndFragmentDelegate.Host,
LifecycleOwner {
    private static final String TAG = "FlutterActivity";
    @VisibleForTesting
    protected FlutterActivityAndFragmentDelegate delegate;
    @NonNull
    private LifecycleRegistry lifecycle = new LifecycleRegistry((LifecycleOwner)this);

    @NonNull
    public static Intent createDefaultIntent(@NonNull Context launchContext) {
        return FlutterActivity.withNewEngine().build(launchContext);
    }

    @NonNull
    public static NewEngineIntentBuilder withNewEngine() {
        return new NewEngineIntentBuilder(FlutterActivity.class);
    }

    public static CachedEngineIntentBuilder withCachedEngine(@NonNull String cachedEngineId) {
        return new CachedEngineIntentBuilder(FlutterActivity.class, cachedEngineId);
    }

    @VisibleForTesting
    void setDelegate(@NonNull FlutterActivityAndFragmentDelegate delegate) {
        this.delegate = delegate;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.switchLaunchThemeForNormalTheme();
        super.onCreate(savedInstanceState);
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        this.delegate = new FlutterActivityAndFragmentDelegate(this);
        this.delegate.onAttach((Context)this);
        this.delegate.onActivityCreated(savedInstanceState);
        this.configureWindowForTransparency();
        this.setContentView(this.createFlutterView());
        this.configureStatusBarForFullscreenFlutterExperience();
    }

    private void switchLaunchThemeForNormalTheme() {
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
            if (activityInfo.metaData != null) {
                int normalThemeRID = activityInfo.metaData.getInt("io.flutter.embedding.android.NormalTheme", -1);
                if (normalThemeRID != -1) {
                    this.setTheme(normalThemeRID);
                }
            } else {
                Log.d(TAG, "Using the launch theme as normal theme.");
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Log.e(TAG, "Could not read meta-data for FlutterActivity. Using the launch theme as normal theme.");
        }
    }

    @Override
    @Nullable
    public SplashScreen provideSplashScreen() {
        Drawable manifestSplashDrawable = this.getSplashScreenFromManifest();
        if (manifestSplashDrawable != null) {
            return new DrawableSplashScreen(manifestSplashDrawable);
        }
        return null;
    }

    @Nullable
    private Drawable getSplashScreenFromManifest() {
        try {
            int splashScreenId;
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
            Bundle metadata = activityInfo.metaData;
            int n = splashScreenId = metadata != null ? metadata.getInt("io.flutter.embedding.android.SplashScreenDrawable") : 0;
            return splashScreenId != 0 ? (Build.VERSION.SDK_INT > 21 ? this.getResources().getDrawable(splashScreenId, this.getTheme()) : this.getResources().getDrawable(splashScreenId)) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private void configureWindowForTransparency() {
        FlutterActivityLaunchConfigs.BackgroundMode backgroundMode = this.getBackgroundMode();
        if (backgroundMode == FlutterActivityLaunchConfigs.BackgroundMode.transparent) {
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.getWindow().setFlags(512, 512);
        }
    }

    @NonNull
    private View createFlutterView() {
        return this.delegate.onCreateView(null, null, null);
    }

    private void configureStatusBarForFullscreenFlutterExperience() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0x40000000);
            window.getDecorView().setSystemUiVisibility(1280);
        }
    }

    protected void onStart() {
        super.onStart();
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_START);
        this.delegate.onStart();
    }

    protected void onResume() {
        super.onResume();
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
        this.delegate.onResume();
    }

    public void onPostResume() {
        super.onPostResume();
        this.delegate.onPostResume();
    }

    protected void onPause() {
        super.onPause();
        this.delegate.onPause();
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
    }

    protected void onStop() {
        super.onStop();
        this.delegate.onStop();
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.delegate.onSaveInstanceState(outState);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.delegate.onDestroyView();
        this.delegate.onDetach();
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.delegate.onActivityResult(requestCode, resultCode, data);
    }

    protected void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        this.delegate.onNewIntent(intent);
    }

    public void onBackPressed() {
        this.delegate.onBackPressed();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.delegate.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onUserLeaveHint() {
        this.delegate.onUserLeaveHint();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.delegate.onTrimMemory(level);
    }

    @Override
    @NonNull
    public Context getContext() {
        return this;
    }

    @Override
    @NonNull
    public Activity getActivity() {
        return this;
    }

    @Override
    @NonNull
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @NonNull
    public FlutterShellArgs getFlutterShellArgs() {
        return FlutterShellArgs.fromIntent(this.getIntent());
    }

    @Override
    @Nullable
    public String getCachedEngineId() {
        return this.getIntent().getStringExtra("cached_engine_id");
    }

    @Override
    public boolean shouldDestroyEngineWithHost() {
        boolean explicitDestructionRequested = this.getIntent().getBooleanExtra("destroy_engine_with_activity", false);
        if (this.getCachedEngineId() != null || this.delegate.isFlutterEngineFromHost()) {
            return explicitDestructionRequested;
        }
        return this.getIntent().getBooleanExtra("destroy_engine_with_activity", true);
    }

    @Override
    @NonNull
    public String getDartEntrypointFunctionName() {
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
            Bundle metadata = activityInfo.metaData;
            String desiredDartEntrypoint = metadata != null ? metadata.getString("io.flutter.Entrypoint") : null;
            return desiredDartEntrypoint != null ? desiredDartEntrypoint : "main";
        }
        catch (PackageManager.NameNotFoundException e) {
            return "main";
        }
    }

    @Override
    @NonNull
    public String getInitialRoute() {
        if (this.getIntent().hasExtra("initial_route")) {
            return this.getIntent().getStringExtra("initial_route");
        }
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
            Bundle metadata = activityInfo.metaData;
            String desiredInitialRoute = metadata != null ? metadata.getString("io.flutter.InitialRoute") : null;
            return desiredInitialRoute != null ? desiredInitialRoute : "/";
        }
        catch (PackageManager.NameNotFoundException e) {
            return "/";
        }
    }

    @Override
    @NonNull
    public String getAppBundlePath() {
        String appBundlePath;
        if (this.isDebuggable() && "android.intent.action.RUN".equals(this.getIntent().getAction()) && (appBundlePath = this.getIntent().getDataString()) != null) {
            return appBundlePath;
        }
        return FlutterMain.findAppBundlePath();
    }

    private boolean isDebuggable() {
        return (this.getApplicationInfo().flags & 2) != 0;
    }

    @Override
    @NonNull
    public FlutterView.RenderMode getRenderMode() {
        return this.getBackgroundMode() == FlutterActivityLaunchConfigs.BackgroundMode.opaque ? FlutterView.RenderMode.surface : FlutterView.RenderMode.texture;
    }

    @Override
    @NonNull
    public FlutterView.TransparencyMode getTransparencyMode() {
        return this.getBackgroundMode() == FlutterActivityLaunchConfigs.BackgroundMode.opaque ? FlutterView.TransparencyMode.opaque : FlutterView.TransparencyMode.transparent;
    }

    @NonNull
    protected FlutterActivityLaunchConfigs.BackgroundMode getBackgroundMode() {
        if (this.getIntent().hasExtra("background_mode")) {
            return FlutterActivityLaunchConfigs.BackgroundMode.valueOf(this.getIntent().getStringExtra("background_mode"));
        }
        return FlutterActivityLaunchConfigs.BackgroundMode.opaque;
    }

    @Override
    @Nullable
    public FlutterEngine provideFlutterEngine(@NonNull Context context) {
        return null;
    }

    @Nullable
    protected FlutterEngine getFlutterEngine() {
        return this.delegate.getFlutterEngine();
    }

    @Override
    @Nullable
    public PlatformPlugin providePlatformPlugin(@Nullable Activity activity, @NonNull FlutterEngine flutterEngine) {
        if (activity != null) {
            return new PlatformPlugin(this.getActivity(), flutterEngine.getPlatformChannel());
        }
        return null;
    }

    @Override
    public void configureFlutterEngine(@NonNull FlutterEngine flutterEngine) {
    }

    @Override
    public void cleanUpFlutterEngine(@NonNull FlutterEngine flutterEngine) {
    }

    @Override
    public boolean shouldAttachEngineToActivity() {
        return true;
    }

    @Override
    public void onFlutterUiDisplayed() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.reportFullyDrawn();
        }
    }

    @Override
    public void onFlutterUiNoLongerDisplayed() {
    }

    public static class CachedEngineIntentBuilder {
        private final Class<? extends FlutterActivity> activityClass;
        private final String cachedEngineId;
        private boolean destroyEngineWithActivity = false;
        private String backgroundMode = FlutterActivityLaunchConfigs.DEFAULT_BACKGROUND_MODE;

        protected CachedEngineIntentBuilder(@NonNull Class<? extends FlutterActivity> activityClass, @NonNull String engineId) {
            this.activityClass = activityClass;
            this.cachedEngineId = engineId;
        }

        public CachedEngineIntentBuilder destroyEngineWithActivity(boolean destroyEngineWithActivity) {
            this.destroyEngineWithActivity = destroyEngineWithActivity;
            return this;
        }

        @NonNull
        public CachedEngineIntentBuilder backgroundMode(@NonNull FlutterActivityLaunchConfigs.BackgroundMode backgroundMode) {
            this.backgroundMode = backgroundMode.name();
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            return new Intent(context, this.activityClass).putExtra("cached_engine_id", this.cachedEngineId).putExtra("destroy_engine_with_activity", this.destroyEngineWithActivity).putExtra("background_mode", this.backgroundMode);
        }
    }

    public static class NewEngineIntentBuilder {
        private final Class<? extends FlutterActivity> activityClass;
        private String initialRoute = "/";
        private String backgroundMode = FlutterActivityLaunchConfigs.DEFAULT_BACKGROUND_MODE;

        protected NewEngineIntentBuilder(@NonNull Class<? extends FlutterActivity> activityClass) {
            this.activityClass = activityClass;
        }

        @NonNull
        public NewEngineIntentBuilder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public NewEngineIntentBuilder backgroundMode(@NonNull FlutterActivityLaunchConfigs.BackgroundMode backgroundMode) {
            this.backgroundMode = backgroundMode.name();
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            return new Intent(context, this.activityClass).putExtra("initial_route", this.initialRoute).putExtra("background_mode", this.backgroundMode).putExtra("destroy_engine_with_activity", true);
        }
    }
}

