/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.loader;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import java.io.File;
import java.io.FilenameFilter;

class ResourceCleaner {
    private static final String TAG = "ResourceCleaner";
    private static final long DELAY_MS = 5000L;
    private final Context mContext;

    ResourceCleaner(Context context) {
        this.mContext = context;
    }

    void start() {
        File cacheDir = this.mContext.getCacheDir();
        if (cacheDir == null) {
            return;
        }
        final CleanTask task = new CleanTask(cacheDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean result = name.startsWith(".org.chromium.Chromium.");
                return result;
            }
        }));
        if (!task.hasFilesToDelete()) {
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
            }
        }, 5000L);
    }

    private static class CleanTask
    extends AsyncTask<Void, Void, Void> {
        private final File[] mFilesToDelete;

        CleanTask(File[] filesToDelete) {
            this.mFilesToDelete = filesToDelete;
        }

        boolean hasFilesToDelete() {
            return this.mFilesToDelete != null && this.mFilesToDelete.length > 0;
        }

        protected Void doInBackground(Void ... unused) {
            for (File file : this.mFilesToDelete) {
                if (!file.exists()) continue;
                this.deleteRecursively(file);
            }
            return null;
        }

        private void deleteRecursively(File parent) {
            if (parent.isDirectory()) {
                for (File child : parent.listFiles()) {
                    this.deleteRecursively(child);
                }
            }
            parent.delete();
        }
    }
}

