/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.view.Surface;
import android.view.View;
import android.view.ViewTreeObserver;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugin.platform.SingleViewPresentation;
import io.flutter.view.TextureRegistry;

@TargetApi(value=20)
class VirtualDisplayController {
    private final Context mContext;
    private final int mDensityDpi;
    private final TextureRegistry.SurfaceTextureEntry mTextureEntry;
    private VirtualDisplay mVirtualDisplay;
    private SingleViewPresentation mPresentation;
    private Surface mSurface;

    public static VirtualDisplayController create(Context context, PlatformViewFactory viewFactory, TextureRegistry.SurfaceTextureEntry textureEntry, int width, int height, int viewId, Object createParams) {
        textureEntry.surfaceTexture().setDefaultBufferSize(width, height);
        Surface surface = new Surface(textureEntry.surfaceTexture());
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        int densityDpi = context.getResources().getDisplayMetrics().densityDpi;
        VirtualDisplay virtualDisplay = displayManager.createVirtualDisplay("flutter-vd", width, height, densityDpi, surface, 0);
        if (virtualDisplay == null) {
            return null;
        }
        return new VirtualDisplayController(context, virtualDisplay, viewFactory, surface, textureEntry, viewId, createParams);
    }

    private VirtualDisplayController(Context context, VirtualDisplay virtualDisplay, PlatformViewFactory viewFactory, Surface surface, TextureRegistry.SurfaceTextureEntry textureEntry, int viewId, Object createParams) {
        this.mTextureEntry = textureEntry;
        this.mSurface = surface;
        this.mContext = context;
        this.mVirtualDisplay = virtualDisplay;
        this.mDensityDpi = context.getResources().getDisplayMetrics().densityDpi;
        this.mPresentation = new SingleViewPresentation(context, this.mVirtualDisplay.getDisplay(), viewFactory, viewId, createParams);
        this.mPresentation.show();
    }

    public void resize(int width, int height, final Runnable onNewSizeFrameAvailable) {
        SingleViewPresentation.PresentationState presentationState = this.mPresentation.detachState();
        this.mVirtualDisplay.setSurface(null);
        this.mVirtualDisplay.release();
        this.mTextureEntry.surfaceTexture().setDefaultBufferSize(width, height);
        DisplayManager displayManager = (DisplayManager)this.mContext.getSystemService("display");
        this.mVirtualDisplay = displayManager.createVirtualDisplay("flutter-vd", width, height, this.mDensityDpi, this.mSurface, 0);
        final View embeddedView = this.getView();
        embeddedView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                OneTimeOnDrawListener.schedule(embeddedView, new Runnable(){

                    @Override
                    public void run() {
                        embeddedView.postDelayed(onNewSizeFrameAvailable, 128L);
                    }
                });
                embeddedView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
        this.mPresentation = new SingleViewPresentation(this.mContext, this.mVirtualDisplay.getDisplay(), presentationState);
        this.mPresentation.show();
    }

    public void dispose() {
        PlatformView view = this.mPresentation.getView();
        this.mPresentation.detachState();
        view.dispose();
        this.mVirtualDisplay.release();
        this.mTextureEntry.release();
    }

    public View getView() {
        if (this.mPresentation == null) {
            return null;
        }
        PlatformView platformView = this.mPresentation.getView();
        return platformView.getView();
    }

    @TargetApi(value=16)
    static class OneTimeOnDrawListener
    implements ViewTreeObserver.OnDrawListener {
        final View mView;
        Runnable mOnDrawRunnable;

        static void schedule(View view, Runnable runnable) {
            OneTimeOnDrawListener listener = new OneTimeOnDrawListener(view, runnable);
            view.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)listener);
        }

        OneTimeOnDrawListener(View view, Runnable onDrawRunnable) {
            this.mView = view;
            this.mOnDrawRunnable = onDrawRunnable;
        }

        public void onDraw() {
            if (this.mOnDrawRunnable == null) {
                return;
            }
            this.mOnDrawRunnable.run();
            this.mOnDrawRunnable = null;
            this.mView.post(new Runnable(){

                @Override
                public void run() {
                    mView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this);
                }
            });
        }
    }
}

