/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.view.Surface;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.renderer.OnFirstFrameRenderedListener;
import io.flutter.view.TextureRegistry;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

@TargetApi(value=16)
public class FlutterRenderer
implements TextureRegistry {
    private final FlutterJNI flutterJNI;
    private final AtomicLong nextTextureId = new AtomicLong(0L);
    private RenderSurface renderSurface;

    public FlutterRenderer(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
    }

    public void attachToRenderSurface(@NonNull RenderSurface renderSurface) {
        if (this.renderSurface != null) {
            this.detachFromRenderSurface();
        }
        this.renderSurface = renderSurface;
        this.renderSurface.attachToRenderer(this);
        this.flutterJNI.setRenderSurface(renderSurface);
    }

    public void detachFromRenderSurface() {
        if (this.renderSurface != null) {
            this.renderSurface.detachFromRenderer();
            this.renderSurface = null;
            this.surfaceDestroyed();
            this.flutterJNI.setRenderSurface(null);
        }
    }

    public void addOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.flutterJNI.addOnFirstFrameRenderedListener(listener);
    }

    public void removeOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.flutterJNI.removeOnFirstFrameRenderedListener(listener);
    }

    @Override
    @TargetApi(value=16)
    public TextureRegistry.SurfaceTextureEntry createSurfaceTexture() {
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.detachFromGLContext();
        SurfaceTextureRegistryEntry entry = new SurfaceTextureRegistryEntry(this.nextTextureId.getAndIncrement(), surfaceTexture);
        this.registerTexture(entry.id(), surfaceTexture);
        return entry;
    }

    public void surfaceCreated(Surface surface) {
        this.flutterJNI.onSurfaceCreated(surface);
    }

    public void surfaceChanged(int width, int height) {
        this.flutterJNI.onSurfaceChanged(width, height);
    }

    public void surfaceDestroyed() {
        this.flutterJNI.onSurfaceDestroyed();
    }

    public void setViewportMetrics(@NonNull ViewportMetrics viewportMetrics) {
        this.flutterJNI.setViewportMetrics(viewportMetrics.devicePixelRatio, viewportMetrics.width, viewportMetrics.height, viewportMetrics.paddingTop, viewportMetrics.paddingRight, viewportMetrics.paddingBottom, viewportMetrics.paddingLeft, viewportMetrics.viewInsetTop, viewportMetrics.viewInsetRight, viewportMetrics.viewInsetBottom, viewportMetrics.viewInsetLeft);
    }

    public Bitmap getBitmap() {
        return this.flutterJNI.getBitmap();
    }

    public void dispatchPointerDataPacket(ByteBuffer buffer, int position) {
        this.flutterJNI.dispatchPointerDataPacket(buffer, position);
    }

    private void registerTexture(long textureId, SurfaceTexture surfaceTexture) {
        this.flutterJNI.registerTexture(textureId, surfaceTexture);
    }

    private void markTextureFrameAvailable(long textureId) {
        this.flutterJNI.markTextureFrameAvailable(textureId);
    }

    private void unregisterTexture(long textureId) {
        this.flutterJNI.unregisterTexture(textureId);
    }

    public boolean isSoftwareRenderingEnabled() {
        return FlutterJNI.nativeGetIsSoftwareRenderingEnabled();
    }

    public void setAccessibilityFeatures(int flags) {
        this.flutterJNI.setAccessibilityFeatures(flags);
    }

    public void setSemanticsEnabled(boolean enabled) {
        this.flutterJNI.setSemanticsEnabled(enabled);
    }

    public void dispatchSemanticsAction(int id, int action, ByteBuffer args, int argsPosition) {
        this.flutterJNI.dispatchSemanticsAction(id, action, args, argsPosition);
    }

    public static final class ViewportMetrics {
        public float devicePixelRatio = 1.0f;
        public int width = 0;
        public int height = 0;
        public int paddingTop = 0;
        public int paddingRight = 0;
        public int paddingBottom = 0;
        public int paddingLeft = 0;
        public int viewInsetTop = 0;
        public int viewInsetRight = 0;
        public int viewInsetBottom = 0;
        public int viewInsetLeft = 0;
    }

    public static interface RenderSurface {
        public void attachToRenderer(@NonNull FlutterRenderer var1);

        public void detachFromRenderer();

        public void updateCustomAccessibilityActions(ByteBuffer var1, String[] var2);

        public void updateSemantics(ByteBuffer var1, String[] var2);

        public void onFirstFrameRendered();
    }

    final class SurfaceTextureRegistryEntry
    implements TextureRegistry.SurfaceTextureEntry {
        private final long id;
        private final SurfaceTexture surfaceTexture;
        private boolean released;
        private SurfaceTexture.OnFrameAvailableListener onFrameListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture texture) {
                if (SurfaceTextureRegistryEntry.this.released) {
                    return;
                }
                FlutterRenderer.this.markTextureFrameAvailable(SurfaceTextureRegistryEntry.this.id);
            }
        };

        SurfaceTextureRegistryEntry(long id, SurfaceTexture surfaceTexture) {
            this.id = id;
            this.surfaceTexture = surfaceTexture;
            if (Build.VERSION.SDK_INT >= 21) {
                this.surfaceTexture.setOnFrameAvailableListener(this.onFrameListener, new Handler());
            } else {
                this.surfaceTexture.setOnFrameAvailableListener(this.onFrameListener);
            }
        }

        @Override
        public SurfaceTexture surfaceTexture() {
            return this.surfaceTexture;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            this.surfaceTexture.release();
            FlutterRenderer.this.unregisterTexture(this.id);
            this.released = true;
        }
    }
}

