/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.os.Build;
import android.support.annotation.NonNull;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocalizationChannel {
    @NonNull
    public final MethodChannel channel;

    public LocalizationChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/localization", JSONMethodCodec.INSTANCE);
    }

    public void sendLocales(List<Locale> locales) {
        ArrayList<String> data = new ArrayList<String>();
        for (Locale locale : locales) {
            data.add(locale.getLanguage());
            data.add(locale.getCountry());
            data.add(Build.VERSION.SDK_INT >= 21 ? locale.getScript() : "");
            data.add(locale.getVariant());
        }
        this.channel.invokeMethod("setLocale", data);
    }
}

