/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.android;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.android.FlutterFragment;
import io.flutter.view.FlutterMain;

public class FlutterActivity
extends FragmentActivity {
    private static final String TAG = "FlutterActivity";
    private static final String DART_ENTRYPOINT_META_DATA_KEY = "io.flutter.Entrypoint";
    private static final String INITIAL_ROUTE_META_DATA_KEY = "io.flutter.InitialRoute";
    public static final String EXTRA_DART_ENTRYPOINT = "dart_entrypoint";
    public static final String EXTRA_INITIAL_ROUTE = "initial_route";
    private static final String TAG_FLUTTER_FRAGMENT = "flutter_fragment";
    private static final int FRAGMENT_CONTAINER_ID = 609893468;
    private FlutterFragment flutterFragment;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.createFragmentContainer());
        this.ensureFlutterFragmentCreated();
    }

    @NonNull
    private View createFragmentContainer() {
        FrameLayout container = new FrameLayout((Context)this);
        container.setId(609893468);
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return container;
    }

    private void ensureFlutterFragmentCreated() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        this.flutterFragment = (FlutterFragment)fragmentManager.findFragmentByTag(TAG_FLUTTER_FRAGMENT);
        if (this.flutterFragment == null) {
            this.flutterFragment = this.createFlutterFragment();
            fragmentManager.beginTransaction().add(609893468, (Fragment)this.flutterFragment, TAG_FLUTTER_FRAGMENT).commit();
        }
    }

    @NonNull
    protected FlutterFragment createFlutterFragment() {
        return FlutterFragment.newInstance(this.getDartEntrypoint(), this.getInitialRoute(), this.getAppBundlePath(), FlutterShellArgs.fromIntent(this.getIntent()));
    }

    public void onPostResume() {
        super.onPostResume();
        this.flutterFragment.onPostResume();
    }

    protected void onNewIntent(Intent intent) {
        this.flutterFragment.onNewIntent(intent);
    }

    public void onBackPressed() {
        this.flutterFragment.onBackPressed();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.flutterFragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onUserLeaveHint() {
        this.flutterFragment.onUserLeaveHint();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.flutterFragment.onTrimMemory(level);
    }

    @Nullable
    protected FlutterEngine getFlutterEngine() {
        return this.flutterFragment.getFlutterEngine();
    }

    @NonNull
    protected String getAppBundlePath() {
        String appBundlePath;
        if (this.isDebuggable() && "android.intent.action.RUN".equals(this.getIntent().getAction()) && (appBundlePath = this.getIntent().getDataString()) != null) {
            return appBundlePath;
        }
        return FlutterMain.findAppBundlePath(this.getApplicationContext());
    }

    @Nullable
    protected String getDartEntrypoint() {
        if (this.getIntent().hasExtra(EXTRA_DART_ENTRYPOINT)) {
            return this.getIntent().getStringExtra(EXTRA_DART_ENTRYPOINT);
        }
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            Bundle metadata = activityInfo.metaData;
            return metadata != null ? metadata.getString(DART_ENTRYPOINT_META_DATA_KEY) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    @Nullable
    protected String getInitialRoute() {
        if (this.getIntent().hasExtra(EXTRA_INITIAL_ROUTE)) {
            return this.getIntent().getStringExtra(EXTRA_INITIAL_ROUTE);
        }
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            Bundle metadata = activityInfo.metaData;
            return metadata != null ? metadata.getString(INITIAL_ROUTE_META_DATA_KEY) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private boolean isDebuggable() {
        return (this.getApplicationInfo().flags & 2) != 0;
    }
}

