/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.android;

import android.support.annotation.NonNull;
import android.view.MotionEvent;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AndroidTouchProcessor {
    private static final int POINTER_CHANGE_CANCEL = 0;
    private static final int POINTER_CHANGE_ADD = 1;
    private static final int POINTER_CHANGE_REMOVE = 2;
    private static final int POINTER_CHANGE_HOVER = 3;
    private static final int POINTER_CHANGE_DOWN = 4;
    private static final int POINTER_CHANGE_MOVE = 5;
    private static final int POINTER_CHANGE_UP = 6;
    private static final int POINTER_DEVICE_KIND_TOUCH = 0;
    private static final int POINTER_DEVICE_KIND_MOUSE = 1;
    private static final int POINTER_DEVICE_KIND_STYLUS = 2;
    private static final int POINTER_DEVICE_KIND_INVERTED_STYLUS = 3;
    private static final int POINTER_DEVICE_KIND_UNKNOWN = 4;
    private static final int POINTER_DATA_FIELD_COUNT = 19;
    private static final int BYTE_PER_FIELD = 8;
    @NonNull
    private final FlutterRenderer renderer;

    public AndroidTouchProcessor(@NonNull FlutterRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int pointerCount = event.getPointerCount();
        ByteBuffer packet = ByteBuffer.allocateDirect(pointerCount * 19 * 8);
        packet.order(ByteOrder.LITTLE_ENDIAN);
        int maskedAction = event.getActionMasked();
        if (maskedAction == 1 || maskedAction == 6 || maskedAction == 0 || maskedAction == 5) {
            this.addPointerForIndex(event, event.getActionIndex(), packet);
        } else {
            for (int p = 0; p < pointerCount; ++p) {
                this.addPointerForIndex(event, p, packet);
            }
        }
        assert (packet.position() % 152 == 0);
        this.renderer.dispatchPointerDataPacket(packet, packet.position());
        return true;
    }

    private void addPointerForIndex(MotionEvent event, int pointerIndex, ByteBuffer packet) {
        int pointerChange = this.getPointerChangeForAction(event.getActionMasked());
        if (pointerChange == -1) {
            return;
        }
        int pointerKind = this.getPointerDeviceTypeForToolType(event.getToolType(pointerIndex));
        long timeStamp = event.getEventTime() * 1000L;
        packet.putLong(timeStamp);
        packet.putLong(pointerChange);
        packet.putLong(pointerKind);
        packet.putLong(event.getPointerId(pointerIndex));
        packet.putDouble(event.getX(pointerIndex));
        packet.putDouble(event.getY(pointerIndex));
        if (pointerKind == 1) {
            packet.putLong(event.getButtonState() & 0x1F);
        } else if (pointerKind == 2) {
            packet.putLong(event.getButtonState() >> 4 & 0xF);
        } else {
            packet.putLong(0L);
        }
        packet.putLong(0L);
        packet.putDouble(event.getPressure(pointerIndex));
        packet.putDouble(0.0);
        packet.putDouble(1.0);
        if (pointerKind == 2) {
            packet.putDouble(event.getAxisValue(24, pointerIndex));
            packet.putDouble(0.0);
        } else {
            packet.putDouble(0.0);
            packet.putDouble(0.0);
        }
        packet.putDouble(event.getToolMajor(pointerIndex));
        packet.putDouble(event.getToolMinor(pointerIndex));
        packet.putDouble(0.0);
        packet.putDouble(0.0);
        packet.putDouble(event.getAxisValue(8, pointerIndex));
        if (pointerKind == 2) {
            packet.putDouble(event.getAxisValue(25, pointerIndex));
        } else {
            packet.putDouble(0.0);
        }
    }

    private int getPointerChangeForAction(int maskedAction) {
        if (maskedAction == 0) {
            return 4;
        }
        if (maskedAction == 1) {
            return 6;
        }
        if (maskedAction == 5) {
            return 4;
        }
        if (maskedAction == 6) {
            return 6;
        }
        if (maskedAction == 2) {
            return 5;
        }
        if (maskedAction == 3) {
            return 0;
        }
        return -1;
    }

    private int getPointerDeviceTypeForToolType(int toolType) {
        switch (toolType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }
}

