/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import java.nio.ByteBuffer;

public class FlutterSurfaceView
extends SurfaceView
implements FlutterRenderer.RenderSurface {
    private static final String TAG = "FlutterSurfaceView";
    private boolean isSurfaceAvailableForRendering = false;
    private boolean isAttachedToFlutterRenderer = false;
    @Nullable
    private FlutterRenderer flutterRenderer;
    private final SurfaceHolder.Callback surfaceCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(SurfaceHolder holder) {
            Log.d((String)FlutterSurfaceView.TAG, (String)"SurfaceHolder.Callback.surfaceCreated()");
            FlutterSurfaceView.this.isSurfaceAvailableForRendering = true;
            if (FlutterSurfaceView.this.isAttachedToFlutterRenderer) {
                Log.d((String)FlutterSurfaceView.TAG, (String)"Already attached to renderer. Notifying of surface creation.");
                FlutterSurfaceView.this.connectSurfaceToRenderer();
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            Log.d((String)FlutterSurfaceView.TAG, (String)"SurfaceHolder.Callback.surfaceChanged()");
            if (FlutterSurfaceView.this.isAttachedToFlutterRenderer) {
                FlutterSurfaceView.this.changeSurfaceSize(width, height);
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            Log.d((String)FlutterSurfaceView.TAG, (String)"SurfaceHolder.Callback.surfaceDestroyed()");
            FlutterSurfaceView.this.isSurfaceAvailableForRendering = false;
            if (FlutterSurfaceView.this.isAttachedToFlutterRenderer) {
                FlutterSurfaceView.this.disconnectSurfaceFromRenderer();
            }
        }
    };

    public FlutterSurfaceView(Context context) {
        this(context, null);
    }

    public FlutterSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.getHolder().addCallback(this.surfaceCallback);
    }

    @Override
    public void attachToRenderer(@NonNull FlutterRenderer flutterRenderer) {
        Log.d((String)TAG, (String)"attachToRenderer");
        if (this.flutterRenderer != null) {
            this.flutterRenderer.detachFromRenderSurface();
        }
        this.flutterRenderer = flutterRenderer;
        this.isAttachedToFlutterRenderer = true;
        if (this.isSurfaceAvailableForRendering) {
            Log.d((String)TAG, (String)"Surface is available for rendering. Connecting.");
            this.connectSurfaceToRenderer();
        }
    }

    @Override
    public void detachFromRenderer() {
        if (this.flutterRenderer != null) {
            if (this.isAttachedToWindow()) {
                this.disconnectSurfaceFromRenderer();
            }
            this.flutterRenderer = null;
            this.isAttachedToFlutterRenderer = false;
        } else {
            Log.w((String)TAG, (String)"detachFromRenderer() invoked when no FlutterRenderer was attached.");
        }
    }

    private void connectSurfaceToRenderer() {
        if (this.flutterRenderer == null || this.getHolder() == null) {
            throw new IllegalStateException("connectSurfaceToRenderer() should only be called when flutterRenderer and getHolder() are non-null.");
        }
        this.flutterRenderer.surfaceCreated(this.getHolder().getSurface());
    }

    private void changeSurfaceSize(int width, int height) {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("changeSurfaceSize() should only be called when flutterRenderer is non-null.");
        }
        this.flutterRenderer.surfaceChanged(width, height);
    }

    private void disconnectSurfaceFromRenderer() {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("disconnectSurfaceFromRenderer() should only be called when flutterRenderer is non-null.");
        }
        this.flutterRenderer.surfaceDestroyed();
    }

    @Override
    public void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
    }

    @Override
    public void updateSemantics(ByteBuffer buffer, String[] strings) {
    }

    @Override
    public void onFirstFrameRendered() {
        Log.d((String)TAG, (String)"onFirstFrameRendered()");
    }
}

