/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.android;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import java.nio.ByteBuffer;

public class FlutterTextureView
extends TextureView
implements FlutterRenderer.RenderSurface {
    private static final String TAG = "FlutterTextureView";
    private boolean isSurfaceAvailableForRendering = false;
    private boolean isAttachedToFlutterRenderer = false;
    @Nullable
    private FlutterRenderer flutterRenderer;
    private final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            Log.d((String)FlutterTextureView.TAG, (String)"SurfaceTextureListener.onSurfaceTextureAvailable()");
            FlutterTextureView.this.isSurfaceAvailableForRendering = true;
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                Log.d((String)FlutterTextureView.TAG, (String)"Already attached to renderer. Notifying of surface creation.");
                FlutterTextureView.this.connectSurfaceToRenderer();
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                FlutterTextureView.this.changeSurfaceSize(width, height);
            }
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            Log.d((String)FlutterTextureView.TAG, (String)"SurfaceTextureListener.onSurfaceTextureDestroyed()");
            FlutterTextureView.this.isSurfaceAvailableForRendering = false;
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                FlutterTextureView.this.disconnectSurfaceFromRenderer();
            }
            return true;
        }
    };

    public FlutterTextureView(Context context) {
        this(context, null);
    }

    public FlutterTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setSurfaceTextureListener(this.surfaceTextureListener);
    }

    @Override
    public void attachToRenderer(@NonNull FlutterRenderer flutterRenderer) {
        if (this.flutterRenderer != null) {
            this.flutterRenderer.detachFromRenderSurface();
        }
        this.flutterRenderer = flutterRenderer;
        this.isAttachedToFlutterRenderer = true;
        if (this.isSurfaceAvailableForRendering) {
            this.connectSurfaceToRenderer();
        }
    }

    @Override
    public void detachFromRenderer() {
        if (this.flutterRenderer != null) {
            if (this.isAttachedToWindow()) {
                this.disconnectSurfaceFromRenderer();
            }
            this.flutterRenderer = null;
            this.isAttachedToFlutterRenderer = false;
        } else {
            Log.w((String)TAG, (String)"detachFromRenderer() invoked when no FlutterRenderer was attached.");
        }
    }

    private void connectSurfaceToRenderer() {
        if (this.flutterRenderer == null || this.getSurfaceTexture() == null) {
            throw new IllegalStateException("connectSurfaceToRenderer() should only be called when flutterRenderer and getSurfaceTexture() are non-null.");
        }
        this.flutterRenderer.surfaceCreated(new Surface(this.getSurfaceTexture()));
    }

    private void changeSurfaceSize(int width, int height) {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("changeSurfaceSize() should only be called when flutterRenderer is non-null.");
        }
        this.flutterRenderer.surfaceChanged(width, height);
    }

    private void disconnectSurfaceFromRenderer() {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("disconnectSurfaceFromRenderer() should only be called when flutterRenderer is non-null.");
        }
        this.flutterRenderer.surfaceDestroyed();
    }

    @Override
    public void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
    }

    @Override
    public void updateSemantics(ByteBuffer buffer, String[] strings) {
    }

    @Override
    public void onFirstFrameRendered() {
        Log.d((String)TAG, (String)"onFirstFrameRendered()");
    }
}

