/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.dart;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.PlatformMessageHandler;
import io.flutter.plugin.common.BinaryMessenger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

class DartMessenger
implements BinaryMessenger,
PlatformMessageHandler {
    private static final String TAG = "DartMessenger";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final Map<String, BinaryMessenger.BinaryMessageHandler> messageHandlers;
    @NonNull
    private final Map<Integer, BinaryMessenger.BinaryReply> pendingReplies;
    private int nextReplyId = 1;

    DartMessenger(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
        this.messageHandlers = new HashMap<String, BinaryMessenger.BinaryMessageHandler>();
        this.pendingReplies = new HashMap<Integer, BinaryMessenger.BinaryReply>();
    }

    @Override
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler) {
        if (handler == null) {
            this.messageHandlers.remove(channel);
        } else {
            this.messageHandlers.put(channel, handler);
        }
    }

    @Override
    public void send(@NonNull String channel, @NonNull ByteBuffer message) {
        this.send(channel, message, null);
    }

    @Override
    public void send(@NonNull String channel, @Nullable ByteBuffer message, @Nullable BinaryMessenger.BinaryReply callback) {
        int replyId = 0;
        if (callback != null) {
            replyId = this.nextReplyId++;
            this.pendingReplies.put(replyId, callback);
        }
        if (message == null) {
            this.flutterJNI.dispatchEmptyPlatformMessage(channel, replyId);
        } else {
            this.flutterJNI.dispatchPlatformMessage(channel, message, message.position(), replyId);
        }
    }

    @Override
    public void handleMessageFromDart(@NonNull String channel, @Nullable byte[] message, int replyId) {
        BinaryMessenger.BinaryMessageHandler handler = this.messageHandlers.get(channel);
        if (handler != null) {
            try {
                ByteBuffer buffer = message == null ? null : ByteBuffer.wrap(message);
                handler.onMessage(buffer, new Reply(this.flutterJNI, replyId));
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Uncaught exception in binary message listener", (Throwable)ex);
                this.flutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
            }
        } else {
            this.flutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
        }
    }

    @Override
    public void handlePlatformMessageResponse(int replyId, @Nullable byte[] reply) {
        BinaryMessenger.BinaryReply callback = this.pendingReplies.remove(replyId);
        if (callback != null) {
            try {
                callback.reply(reply == null ? null : ByteBuffer.wrap(reply));
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Uncaught exception in binary message reply handler", (Throwable)ex);
            }
        }
    }

    private static class Reply
    implements BinaryMessenger.BinaryReply {
        @NonNull
        private final FlutterJNI flutterJNI;
        private final int replyId;
        private final AtomicBoolean done = new AtomicBoolean(false);

        Reply(@NonNull FlutterJNI flutterJNI, int replyId) {
            this.flutterJNI = flutterJNI;
            this.replyId = replyId;
        }

        @Override
        public void reply(ByteBuffer reply) {
            if (this.done.getAndSet(true)) {
                throw new IllegalStateException("Reply already submitted");
            }
            if (reply == null) {
                this.flutterJNI.invokePlatformMessageEmptyResponseCallback(this.replyId);
            } else {
                this.flutterJNI.invokePlatformMessageResponseCallback(this.replyId, reply, reply.position());
            }
        }
    }
}

