/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.StandardMessageCodec;
import java.util.HashMap;

public class AccessibilityChannel {
    @NonNull
    public BasicMessageChannel<Object> channel;
    @Nullable
    private AccessibilityMessageHandler handler;
    private final BasicMessageChannel.MessageHandler<Object> parsingMessageHandler = new BasicMessageChannel.MessageHandler<Object>(){

        @Override
        public void onMessage(Object message, BasicMessageChannel.Reply<Object> reply) {
            if (AccessibilityChannel.this.handler == null) {
                return;
            }
            HashMap annotatedEvent = (HashMap)message;
            String type = (String)annotatedEvent.get("type");
            HashMap data = (HashMap)annotatedEvent.get("data");
            switch (type) {
                case "announce": {
                    String announceMessage = (String)data.get("message");
                    if (announceMessage == null) break;
                    AccessibilityChannel.this.handler.announce(announceMessage);
                    break;
                }
                case "tap": {
                    Integer nodeId = (Integer)annotatedEvent.get("nodeId");
                    if (nodeId == null) break;
                    AccessibilityChannel.this.handler.onTap(nodeId);
                    break;
                }
                case "longPress": {
                    Integer nodeId = (Integer)annotatedEvent.get("nodeId");
                    if (nodeId == null) break;
                    AccessibilityChannel.this.handler.onLongPress(nodeId);
                    break;
                }
                case "tooltip": {
                    String tooltipMessage = (String)data.get("message");
                    if (tooltipMessage == null) break;
                    AccessibilityChannel.this.handler.onTooltip(tooltipMessage);
                    break;
                }
            }
        }
    };

    public AccessibilityChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new BasicMessageChannel<Object>(dartExecutor, "flutter/accessibility", StandardMessageCodec.INSTANCE);
        this.channel.setMessageHandler(this.parsingMessageHandler);
    }

    public void setAccessibilityMessageHandler(@Nullable AccessibilityMessageHandler handler) {
        this.handler = handler;
    }

    public static interface AccessibilityMessageHandler {
        public void announce(@NonNull String var1);

        public void onTap(int var1);

        public void onLongPress(int var1);

        public void onTooltip(@NonNull String var1);
    }
}

