/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.app.Activity;
import android.graphics.Rect;
import android.opengl.Matrix;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import io.flutter.embedding.engine.systemchannels.AccessibilityChannel;
import io.flutter.util.Predicate;
import io.flutter.view.FlutterView;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AccessibilityBridge
extends AccessibilityNodeProvider {
    private static final String TAG = "FlutterView";
    private static final int ACTION_SHOW_ON_SCREEN = 16908342;
    private static final float SCROLL_EXTENT_FOR_INFINITY = 100000.0f;
    private static final float SCROLL_POSITION_CAP_FOR_INFINITY = 70000.0f;
    private static final int ROOT_NODE_ID = 0;
    private final FlutterView owner;
    private final AccessibilityChannel accessibilityChannel;
    private final View decorView;
    private Map<Integer, SemanticsObject> objects;
    private Map<Integer, CustomAccessibilityAction> customAccessibilityActions;
    private boolean accessibilityEnabled = false;
    private SemanticsObject a11yFocusedObject;
    private SemanticsObject inputFocusedObject;
    private SemanticsObject hoveredObject;
    private int previousRouteId = 0;
    private List<Integer> previousRoutes;
    private Integer lastLeftFrameInset = 0;
    private final AccessibilityChannel.AccessibilityMessageHandler accessibilityMessageHandler = new AccessibilityChannel.AccessibilityMessageHandler(){

        @Override
        public void announce(@NonNull String message) {
            AccessibilityBridge.this.owner.announceForAccessibility(message);
        }

        @Override
        public void onTap(int nodeId) {
            AccessibilityBridge.this.sendAccessibilityEvent(nodeId, 1);
        }

        @Override
        public void onLongPress(int nodeId) {
            AccessibilityBridge.this.sendAccessibilityEvent(nodeId, 2);
        }

        @Override
        public void onTooltip(@NonNull String message) {
            AccessibilityEvent e = AccessibilityBridge.this.obtainAccessibilityEvent(0, 32);
            e.getText().add(message);
            AccessibilityBridge.this.sendAccessibilityEvent(e);
        }
    };
    static int firstResourceId = 0xFF00001;

    AccessibilityBridge(@NonNull FlutterView owner, @NonNull AccessibilityChannel accessibilityChannel) {
        this.owner = owner;
        this.accessibilityChannel = accessibilityChannel;
        this.decorView = ((Activity)owner.getContext()).getWindow().getDecorView();
        this.objects = new HashMap<Integer, SemanticsObject>();
        this.customAccessibilityActions = new HashMap<Integer, CustomAccessibilityAction>();
        this.previousRoutes = new ArrayList<Integer>();
    }

    void setAccessibilityEnabled(boolean accessibilityEnabled) {
        this.accessibilityEnabled = accessibilityEnabled;
        if (accessibilityEnabled) {
            this.accessibilityChannel.setAccessibilityMessageHandler(this.accessibilityMessageHandler);
        } else {
            this.accessibilityChannel.setAccessibilityMessageHandler(null);
        }
    }

    private boolean shouldSetCollectionInfo(SemanticsObject object) {
        return object.scrollChildren > 0 && (AccessibilityBridge.hasSemanticsObjectAncestor(this.a11yFocusedObject, o -> o == object) || !AccessibilityBridge.hasSemanticsObjectAncestor(this.a11yFocusedObject, o -> o.hasFlag(Flag.HAS_IMPLICIT_SCROLLING)));
    }

    public AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
        if (virtualViewId == -1) {
            AccessibilityNodeInfo result = AccessibilityNodeInfo.obtain((View)this.owner);
            this.owner.onInitializeAccessibilityNodeInfo(result);
            if (this.objects.containsKey(0)) {
                result.addChild((View)this.owner, 0);
            }
            return result;
        }
        SemanticsObject object = this.objects.get(virtualViewId);
        if (object == null) {
            return null;
        }
        AccessibilityNodeInfo result = AccessibilityNodeInfo.obtain((View)this.owner, (int)virtualViewId);
        if (Build.VERSION.SDK_INT >= 18) {
            result.setViewIdResourceName("");
        }
        result.setPackageName((CharSequence)this.owner.getContext().getPackageName());
        result.setClassName((CharSequence)"android.view.View");
        result.setSource((View)this.owner, virtualViewId);
        result.setFocusable(object.isFocusable());
        if (this.inputFocusedObject != null) {
            result.setFocused(this.inputFocusedObject.id == virtualViewId);
        }
        if (this.a11yFocusedObject != null) {
            result.setAccessibilityFocused(this.a11yFocusedObject.id == virtualViewId);
        }
        if (object.hasFlag(Flag.IS_TEXT_FIELD)) {
            result.setPassword(object.hasFlag(Flag.IS_OBSCURED));
            result.setClassName((CharSequence)"android.widget.EditText");
            if (Build.VERSION.SDK_INT >= 18) {
                result.setEditable(true);
                if (object.textSelectionBase != -1 && object.textSelectionExtent != -1) {
                    result.setTextSelection(object.textSelectionBase, object.textSelectionExtent);
                }
                if (Build.VERSION.SDK_INT > 18 && this.a11yFocusedObject != null && this.a11yFocusedObject.id == virtualViewId) {
                    result.setLiveRegion(1);
                }
            }
            int granularities = 0;
            if (object.hasAction(Action.MOVE_CURSOR_FORWARD_BY_CHARACTER)) {
                result.addAction(256);
                granularities |= 1;
            }
            if (object.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER)) {
                result.addAction(512);
                granularities |= 1;
            }
            if (object.hasAction(Action.MOVE_CURSOR_FORWARD_BY_WORD)) {
                result.addAction(256);
                granularities |= 2;
            }
            if (object.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_WORD)) {
                result.addAction(512);
                granularities |= 2;
            }
            result.setMovementGranularities(granularities);
        }
        if (object.hasAction(Action.SET_SELECTION)) {
            result.addAction(131072);
        }
        if (object.hasAction(Action.COPY)) {
            result.addAction(16384);
        }
        if (object.hasAction(Action.CUT)) {
            result.addAction(65536);
        }
        if (object.hasAction(Action.PASTE)) {
            result.addAction(32768);
        }
        if (object.hasFlag(Flag.IS_BUTTON)) {
            result.setClassName((CharSequence)"android.widget.Button");
        }
        if (object.hasFlag(Flag.IS_IMAGE)) {
            result.setClassName((CharSequence)"android.widget.ImageView");
        }
        if (Build.VERSION.SDK_INT > 18 && object.hasAction(Action.DISMISS)) {
            result.setDismissable(true);
            result.addAction(0x100000);
        }
        if (object.parent != null) {
            assert (object.id > 0);
            result.setParent((View)this.owner, object.parent.id);
        } else {
            assert (object.id == 0);
            result.setParent((View)this.owner);
        }
        Rect bounds = object.getGlobalRect();
        if (object.parent != null) {
            Rect parentBounds = object.parent.getGlobalRect();
            Rect boundsInParent = new Rect(bounds);
            boundsInParent.offset(-parentBounds.left, -parentBounds.top);
            result.setBoundsInParent(boundsInParent);
        } else {
            result.setBoundsInParent(bounds);
        }
        result.setBoundsInScreen(bounds);
        result.setVisibleToUser(true);
        result.setEnabled(!object.hasFlag(Flag.HAS_ENABLED_STATE) || object.hasFlag(Flag.IS_ENABLED));
        if (object.hasAction(Action.TAP)) {
            if (Build.VERSION.SDK_INT >= 21 && object.onTapOverride != null) {
                result.addAction(new AccessibilityNodeInfo.AccessibilityAction(16, (CharSequence)object.onTapOverride.hint));
                result.setClickable(true);
            } else {
                result.addAction(16);
                result.setClickable(true);
            }
        }
        if (object.hasAction(Action.LONG_PRESS)) {
            if (Build.VERSION.SDK_INT >= 21 && object.onLongPressOverride != null) {
                result.addAction(new AccessibilityNodeInfo.AccessibilityAction(32, (CharSequence)object.onLongPressOverride.hint));
                result.setLongClickable(true);
            } else {
                result.addAction(32);
                result.setLongClickable(true);
            }
        }
        if (object.hasAction(Action.SCROLL_LEFT) || object.hasAction(Action.SCROLL_UP) || object.hasAction(Action.SCROLL_RIGHT) || object.hasAction(Action.SCROLL_DOWN)) {
            result.setScrollable(true);
            if (object.hasFlag(Flag.HAS_IMPLICIT_SCROLLING)) {
                if (object.hasAction(Action.SCROLL_LEFT) || object.hasAction(Action.SCROLL_RIGHT)) {
                    if (this.shouldSetCollectionInfo(object)) {
                        result.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain((int)0, (int)object.scrollChildren, (boolean)false));
                    } else {
                        result.setClassName((CharSequence)"android.widget.HorizontalScrollView");
                    }
                } else if (this.shouldSetCollectionInfo(object)) {
                    result.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain((int)object.scrollChildren, (int)0, (boolean)false));
                } else {
                    result.setClassName((CharSequence)"android.widget.ScrollView");
                }
            }
            if (object.hasAction(Action.SCROLL_LEFT) || object.hasAction(Action.SCROLL_UP)) {
                result.addAction(4096);
            }
            if (object.hasAction(Action.SCROLL_RIGHT) || object.hasAction(Action.SCROLL_DOWN)) {
                result.addAction(8192);
            }
        }
        if (object.hasAction(Action.INCREASE) || object.hasAction(Action.DECREASE)) {
            result.setClassName((CharSequence)"android.widget.SeekBar");
            if (object.hasAction(Action.INCREASE)) {
                result.addAction(4096);
            }
            if (object.hasAction(Action.DECREASE)) {
                result.addAction(8192);
            }
        }
        if (object.hasFlag(Flag.IS_LIVE_REGION) && Build.VERSION.SDK_INT > 18) {
            result.setLiveRegion(1);
        }
        boolean hasCheckedState = object.hasFlag(Flag.HAS_CHECKED_STATE);
        boolean hasToggledState = object.hasFlag(Flag.HAS_TOGGLED_STATE);
        assert (!hasCheckedState || !hasToggledState);
        result.setCheckable(hasCheckedState || hasToggledState);
        if (hasCheckedState) {
            result.setChecked(object.hasFlag(Flag.IS_CHECKED));
            result.setContentDescription((CharSequence)object.getValueLabelHint());
            if (object.hasFlag(Flag.IS_IN_MUTUALLY_EXCLUSIVE_GROUP)) {
                result.setClassName((CharSequence)"android.widget.RadioButton");
            } else {
                result.setClassName((CharSequence)"android.widget.CheckBox");
            }
        } else if (hasToggledState) {
            result.setChecked(object.hasFlag(Flag.IS_TOGGLED));
            result.setClassName((CharSequence)"android.widget.Switch");
            result.setContentDescription((CharSequence)object.getValueLabelHint());
        } else {
            result.setText((CharSequence)object.getValueLabelHint());
        }
        result.setSelected(object.hasFlag(Flag.IS_SELECTED));
        if (this.a11yFocusedObject != null && this.a11yFocusedObject.id == virtualViewId) {
            result.addAction(128);
        } else {
            result.addAction(64);
        }
        if (Build.VERSION.SDK_INT >= 21 && object.customAccessibilityActions != null) {
            for (CustomAccessibilityAction action : object.customAccessibilityActions) {
                result.addAction(new AccessibilityNodeInfo.AccessibilityAction(action.resourceId, (CharSequence)action.label));
            }
        }
        if (object.childrenInTraversalOrder != null) {
            for (SemanticsObject child : object.childrenInTraversalOrder) {
                if (child.hasFlag(Flag.IS_HIDDEN)) continue;
                result.addChild((View)this.owner, child.id);
            }
        }
        return result;
    }

    public boolean performAction(int virtualViewId, int action, Bundle arguments) {
        SemanticsObject object = this.objects.get(virtualViewId);
        if (object == null) {
            return false;
        }
        switch (action) {
            case 16: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.TAP);
                return true;
            }
            case 32: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.LONG_PRESS);
                return true;
            }
            case 4096: {
                if (object.hasAction(Action.SCROLL_UP)) {
                    this.owner.dispatchSemanticsAction(virtualViewId, Action.SCROLL_UP);
                } else if (object.hasAction(Action.SCROLL_LEFT)) {
                    this.owner.dispatchSemanticsAction(virtualViewId, Action.SCROLL_LEFT);
                } else if (object.hasAction(Action.INCREASE)) {
                    object.value = object.increasedValue;
                    this.sendAccessibilityEvent(virtualViewId, 4);
                    this.owner.dispatchSemanticsAction(virtualViewId, Action.INCREASE);
                } else {
                    return false;
                }
                return true;
            }
            case 8192: {
                if (object.hasAction(Action.SCROLL_DOWN)) {
                    this.owner.dispatchSemanticsAction(virtualViewId, Action.SCROLL_DOWN);
                } else if (object.hasAction(Action.SCROLL_RIGHT)) {
                    this.owner.dispatchSemanticsAction(virtualViewId, Action.SCROLL_RIGHT);
                } else if (object.hasAction(Action.DECREASE)) {
                    object.value = object.decreasedValue;
                    this.sendAccessibilityEvent(virtualViewId, 4);
                    this.owner.dispatchSemanticsAction(virtualViewId, Action.DECREASE);
                } else {
                    return false;
                }
                return true;
            }
            case 512: {
                return this.performCursorMoveAction(object, virtualViewId, arguments, false);
            }
            case 256: {
                return this.performCursorMoveAction(object, virtualViewId, arguments, true);
            }
            case 128: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.DID_LOSE_ACCESSIBILITY_FOCUS);
                this.sendAccessibilityEvent(virtualViewId, 65536);
                this.a11yFocusedObject = null;
                return true;
            }
            case 64: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.DID_GAIN_ACCESSIBILITY_FOCUS);
                this.sendAccessibilityEvent(virtualViewId, 32768);
                if (this.a11yFocusedObject == null) {
                    this.owner.invalidate();
                }
                this.a11yFocusedObject = object;
                if (object.hasAction(Action.INCREASE) || object.hasAction(Action.DECREASE)) {
                    this.sendAccessibilityEvent(virtualViewId, 4);
                }
                return true;
            }
            case 16908342: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.SHOW_ON_SCREEN);
                return true;
            }
            case 131072: {
                boolean hasSelection;
                HashMap<String, Integer> selection = new HashMap<String, Integer>();
                boolean bl = hasSelection = arguments != null && arguments.containsKey("ACTION_ARGUMENT_SELECTION_START_INT") && arguments.containsKey("ACTION_ARGUMENT_SELECTION_END_INT");
                if (hasSelection) {
                    selection.put("base", arguments.getInt("ACTION_ARGUMENT_SELECTION_START_INT"));
                    selection.put("extent", arguments.getInt("ACTION_ARGUMENT_SELECTION_END_INT"));
                } else {
                    selection.put("base", object.textSelectionExtent);
                    selection.put("extent", object.textSelectionExtent);
                }
                this.owner.dispatchSemanticsAction(virtualViewId, Action.SET_SELECTION, selection);
                return true;
            }
            case 16384: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.COPY);
                return true;
            }
            case 65536: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.CUT);
                return true;
            }
            case 32768: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.PASTE);
                return true;
            }
            case 0x100000: {
                this.owner.dispatchSemanticsAction(virtualViewId, Action.DISMISS);
                return true;
            }
        }
        int flutterId = action - firstResourceId;
        CustomAccessibilityAction contextAction = this.customAccessibilityActions.get(flutterId);
        if (contextAction != null) {
            this.owner.dispatchSemanticsAction(virtualViewId, Action.CUSTOM_ACTION, contextAction.id);
            return true;
        }
        return false;
    }

    boolean performCursorMoveAction(SemanticsObject object, int virtualViewId, Bundle arguments, boolean forward) {
        int granularity = arguments.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
        boolean extendSelection = arguments.getBoolean("ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN");
        switch (granularity) {
            case 1: {
                if (forward && object.hasAction(Action.MOVE_CURSOR_FORWARD_BY_CHARACTER)) {
                    this.owner.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_FORWARD_BY_CHARACTER, extendSelection);
                    return true;
                }
                if (forward || !object.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER)) break;
                this.owner.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_BACKWARD_BY_CHARACTER, extendSelection);
                return true;
            }
            case 2: {
                if (forward && object.hasAction(Action.MOVE_CURSOR_FORWARD_BY_WORD)) {
                    this.owner.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_FORWARD_BY_WORD, extendSelection);
                    return true;
                }
                if (forward || !object.hasAction(Action.MOVE_CURSOR_BACKWARD_BY_WORD)) break;
                this.owner.dispatchSemanticsAction(virtualViewId, Action.MOVE_CURSOR_BACKWARD_BY_WORD, extendSelection);
                return true;
            }
        }
        return false;
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        switch (focus) {
            case 1: {
                if (this.inputFocusedObject != null) {
                    return this.createAccessibilityNodeInfo(this.inputFocusedObject.id);
                }
            }
            case 2: {
                if (this.a11yFocusedObject == null) break;
                return this.createAccessibilityNodeInfo(this.a11yFocusedObject.id);
            }
        }
        return null;
    }

    private SemanticsObject getRootObject() {
        assert (this.objects.containsKey(0));
        return this.objects.get(0);
    }

    private SemanticsObject getOrCreateObject(int id) {
        SemanticsObject object = this.objects.get(id);
        if (object == null) {
            object = new SemanticsObject();
            object.id = id;
            this.objects.put(id, object);
        }
        return object;
    }

    private CustomAccessibilityAction getOrCreateAction(int id) {
        CustomAccessibilityAction action = this.customAccessibilityActions.get(id);
        if (action == null) {
            action = new CustomAccessibilityAction();
            action.id = id;
            action.resourceId = id + firstResourceId;
            this.customAccessibilityActions.put(id, action);
        }
        return action;
    }

    void handleTouchExplorationExit() {
        if (this.hoveredObject != null) {
            this.sendAccessibilityEvent(this.hoveredObject.id, 256);
            this.hoveredObject = null;
        }
    }

    void handleTouchExploration(float x, float y) {
        if (this.objects.isEmpty()) {
            return;
        }
        SemanticsObject newObject = this.getRootObject().hitTest(new float[]{x, y, 0.0f, 1.0f});
        if (newObject != this.hoveredObject) {
            if (newObject != null) {
                this.sendAccessibilityEvent(newObject.id, 128);
            }
            if (this.hoveredObject != null) {
                this.sendAccessibilityEvent(this.hoveredObject.id, 256);
            }
            this.hoveredObject = newObject;
        }
    }

    void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
        while (buffer.hasRemaining()) {
            int id = buffer.getInt();
            CustomAccessibilityAction action = this.getOrCreateAction(id);
            action.overrideId = buffer.getInt();
            int stringIndex = buffer.getInt();
            action.label = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            action.hint = stringIndex == -1 ? null : strings[stringIndex];
        }
    }

    void updateSemantics(ByteBuffer buffer, String[] strings) {
        ArrayList<SemanticsObject> updated = new ArrayList<SemanticsObject>();
        while (buffer.hasRemaining()) {
            int id = buffer.getInt();
            SemanticsObject object = this.getOrCreateObject(id);
            object.updateWith(buffer, strings);
            if (object.hasFlag(Flag.IS_HIDDEN)) continue;
            if (object.hasFlag(Flag.IS_FOCUSED)) {
                this.inputFocusedObject = object;
            }
            if (!object.hadPreviousConfig) continue;
            updated.add(object);
        }
        HashSet<SemanticsObject> visitedObjects = new HashSet<SemanticsObject>();
        SemanticsObject rootObject = this.getRootObject();
        ArrayList<SemanticsObject> newRoutes = new ArrayList<SemanticsObject>();
        if (rootObject != null) {
            float[] identity = new float[16];
            Matrix.setIdentityM((float[])identity, (int)0);
            if (Build.VERSION.SDK_INT >= 23) {
                Rect visibleFrame = new Rect();
                this.decorView.getWindowVisibleDisplayFrame(visibleFrame);
                if (!this.lastLeftFrameInset.equals(visibleFrame.left)) {
                    rootObject.globalGeometryDirty = true;
                    rootObject.inverseTransformDirty = true;
                }
                this.lastLeftFrameInset = visibleFrame.left;
                Matrix.translateM((float[])identity, (int)0, (float)visibleFrame.left, (float)0.0f, (float)0.0f);
            }
            rootObject.updateRecursively(identity, visitedObjects, false);
            rootObject.collectRoutes(newRoutes);
        }
        SemanticsObject lastAdded = null;
        for (SemanticsObject semanticsObject : newRoutes) {
            if (this.previousRoutes.contains(semanticsObject.id)) continue;
            lastAdded = semanticsObject;
        }
        if (lastAdded == null && newRoutes.size() > 0) {
            lastAdded = (SemanticsObject)newRoutes.get(newRoutes.size() - 1);
        }
        if (lastAdded != null && lastAdded.id != this.previousRouteId) {
            this.previousRouteId = lastAdded.id;
            this.createWindowChangeEvent(lastAdded);
        }
        this.previousRoutes.clear();
        for (SemanticsObject semanticsObject : newRoutes) {
            this.previousRoutes.add(semanticsObject.id);
        }
        Iterator<Map.Entry<Integer, SemanticsObject>> it = this.objects.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, SemanticsObject> entry = it.next();
            SemanticsObject object = entry.getValue();
            if (visitedObjects.contains(object)) continue;
            this.willRemoveSemanticsObject(object);
            it.remove();
        }
        this.sendAccessibilityEvent(0, 2048);
        for (SemanticsObject object : updated) {
            String newValue;
            AccessibilityEvent event;
            if (object.didScroll()) {
                event = this.obtainAccessibilityEvent(object.id, 4096);
                float position = object.scrollPosition;
                float max = object.scrollExtentMax;
                if (Float.isInfinite(object.scrollExtentMax)) {
                    max = 100000.0f;
                    if (position > 70000.0f) {
                        position = 70000.0f;
                    }
                }
                if (Float.isInfinite(object.scrollExtentMin)) {
                    max += 100000.0f;
                    if (position < -70000.0f) {
                        position = -70000.0f;
                    }
                    position += 100000.0f;
                } else {
                    max -= object.scrollExtentMin;
                    position -= object.scrollExtentMin;
                }
                if (object.hadAction(Action.SCROLL_UP) || object.hadAction(Action.SCROLL_DOWN)) {
                    event.setScrollY((int)position);
                    event.setMaxScrollY((int)max);
                } else if (object.hadAction(Action.SCROLL_LEFT) || object.hadAction(Action.SCROLL_RIGHT)) {
                    event.setScrollX((int)position);
                    event.setMaxScrollX((int)max);
                }
                if (object.scrollChildren > 0) {
                    event.setItemCount(object.scrollChildren);
                    event.setFromIndex(object.scrollIndex);
                    int visibleChildren = 0;
                    for (SemanticsObject child : object.childrenInHitTestOrder) {
                        if (child.hasFlag(Flag.IS_HIDDEN)) continue;
                        ++visibleChildren;
                    }
                    assert (object.scrollIndex + visibleChildren <= object.scrollChildren);
                    assert (!object.childrenInHitTestOrder.get(object.scrollIndex).hasFlag(Flag.IS_HIDDEN));
                    event.setToIndex(object.scrollIndex + visibleChildren - 1);
                }
                this.sendAccessibilityEvent(event);
            }
            if (object.hasFlag(Flag.IS_LIVE_REGION)) {
                String previousLabel;
                String label = object.label == null ? "" : object.label;
                String string = previousLabel = object.previousLabel == null ? "" : object.label;
                if (!label.equals(previousLabel) || !object.hadFlag(Flag.IS_LIVE_REGION)) {
                    this.sendAccessibilityEvent(object.id, 2048);
                }
            } else if (object.hasFlag(Flag.IS_TEXT_FIELD) && object.didChangeLabel() && this.inputFocusedObject != null && this.inputFocusedObject.id == object.id) {
                this.sendAccessibilityEvent(object.id, 2048);
            }
            if (this.a11yFocusedObject != null && this.a11yFocusedObject.id == object.id && !object.hadFlag(Flag.IS_SELECTED) && object.hasFlag(Flag.IS_SELECTED)) {
                event = this.obtainAccessibilityEvent(object.id, 4);
                event.getText().add(object.label);
                this.sendAccessibilityEvent(event);
            }
            if (this.inputFocusedObject == null || this.inputFocusedObject.id != object.id || !object.hadFlag(Flag.IS_TEXT_FIELD) || !object.hasFlag(Flag.IS_TEXT_FIELD) || this.a11yFocusedObject != null && this.a11yFocusedObject.id != this.inputFocusedObject.id) continue;
            String oldValue = object.previousValue != null ? object.previousValue : "";
            AccessibilityEvent event2 = this.createTextChangedEvent(object.id, oldValue, newValue = object.value != null ? object.value : "");
            if (event2 != null) {
                this.sendAccessibilityEvent(event2);
            }
            if (object.previousTextSelectionBase == object.textSelectionBase && object.previousTextSelectionExtent == object.textSelectionExtent) continue;
            AccessibilityEvent selectionEvent = this.obtainAccessibilityEvent(object.id, 8192);
            selectionEvent.getText().add(newValue);
            selectionEvent.setFromIndex(object.textSelectionBase);
            selectionEvent.setToIndex(object.textSelectionExtent);
            selectionEvent.setItemCount(newValue.length());
            this.sendAccessibilityEvent(selectionEvent);
        }
    }

    private AccessibilityEvent createTextChangedEvent(int id, String oldValue, String newValue) {
        int newIndex;
        int i;
        AccessibilityEvent e = this.obtainAccessibilityEvent(id, 16);
        e.setBeforeText((CharSequence)oldValue);
        e.getText().add(newValue);
        for (i = 0; i < oldValue.length() && i < newValue.length() && oldValue.charAt(i) == newValue.charAt(i); ++i) {
        }
        if (i >= oldValue.length() && i >= newValue.length()) {
            return null;
        }
        int firstDifference = i;
        e.setFromIndex(firstDifference);
        int oldIndex = oldValue.length() - 1;
        for (newIndex = newValue.length() - 1; oldIndex >= firstDifference && newIndex >= firstDifference && oldValue.charAt(oldIndex) == newValue.charAt(newIndex); --oldIndex, --newIndex) {
        }
        e.setRemovedCount(oldIndex - firstDifference + 1);
        e.setAddedCount(newIndex - firstDifference + 1);
        return e;
    }

    private AccessibilityEvent obtainAccessibilityEvent(int virtualViewId, int eventType) {
        assert (virtualViewId != 0);
        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
        event.setPackageName((CharSequence)this.owner.getContext().getPackageName());
        event.setSource((View)this.owner, virtualViewId);
        return event;
    }

    private void sendAccessibilityEvent(int virtualViewId, int eventType) {
        if (!this.accessibilityEnabled) {
            return;
        }
        if (virtualViewId == 0) {
            this.owner.sendAccessibilityEvent(eventType);
        } else {
            this.sendAccessibilityEvent(this.obtainAccessibilityEvent(virtualViewId, eventType));
        }
    }

    private void sendAccessibilityEvent(AccessibilityEvent event) {
        if (!this.accessibilityEnabled) {
            return;
        }
        this.owner.getParent().requestSendAccessibilityEvent((View)this.owner, event);
    }

    private void createWindowChangeEvent(SemanticsObject route) {
        AccessibilityEvent e = this.obtainAccessibilityEvent(route.id, 32);
        String routeName = route.getRouteName();
        e.getText().add(routeName);
        this.sendAccessibilityEvent(e);
    }

    private void willRemoveSemanticsObject(SemanticsObject object) {
        assert (this.objects.containsKey(object.id));
        assert (this.objects.get(object.id) == object);
        object.parent = null;
        if (this.a11yFocusedObject == object) {
            this.sendAccessibilityEvent(this.a11yFocusedObject.id, 65536);
            this.a11yFocusedObject = null;
        }
        if (this.inputFocusedObject == object) {
            this.inputFocusedObject = null;
        }
        if (this.hoveredObject == object) {
            this.hoveredObject = null;
        }
    }

    void reset() {
        this.objects.clear();
        if (this.a11yFocusedObject != null) {
            this.sendAccessibilityEvent(this.a11yFocusedObject.id, 65536);
        }
        this.a11yFocusedObject = null;
        this.hoveredObject = null;
        this.sendAccessibilityEvent(0, 2048);
    }

    static boolean hasSemanticsObjectAncestor(SemanticsObject target, Predicate<SemanticsObject> tester) {
        return target != null && target.getAncestor(tester) != null;
    }

    private class SemanticsObject {
        int id = -1;
        int flags;
        int actions;
        int textSelectionBase;
        int textSelectionExtent;
        int scrollChildren;
        int scrollIndex;
        float scrollPosition;
        float scrollExtentMax;
        float scrollExtentMin;
        String label;
        String value;
        String increasedValue;
        String decreasedValue;
        String hint;
        TextDirection textDirection;
        boolean hadPreviousConfig = false;
        int previousFlags;
        int previousActions;
        int previousTextSelectionBase;
        int previousTextSelectionExtent;
        float previousScrollPosition;
        float previousScrollExtentMax;
        float previousScrollExtentMin;
        String previousValue;
        String previousLabel;
        private float left;
        private float top;
        private float right;
        private float bottom;
        private float[] transform;
        SemanticsObject parent;
        List<SemanticsObject> childrenInTraversalOrder;
        List<SemanticsObject> childrenInHitTestOrder;
        List<CustomAccessibilityAction> customAccessibilityActions;
        CustomAccessibilityAction onTapOverride;
        CustomAccessibilityAction onLongPressOverride;
        private boolean inverseTransformDirty = true;
        private float[] inverseTransform;
        private boolean globalGeometryDirty = true;
        private float[] globalTransform;
        private Rect globalRect;

        SemanticsObject() {
        }

        SemanticsObject getAncestor(Predicate<SemanticsObject> tester) {
            SemanticsObject nextAncestor = this.parent;
            while (nextAncestor != null) {
                if (tester.test(nextAncestor)) {
                    return nextAncestor;
                }
                nextAncestor = nextAncestor.parent;
            }
            return null;
        }

        boolean hasAction(Action action) {
            return (this.actions & action.value) != 0;
        }

        boolean hadAction(Action action) {
            return (this.previousActions & action.value) != 0;
        }

        boolean hasFlag(Flag flag) {
            return (this.flags & flag.value) != 0;
        }

        boolean hadFlag(Flag flag) {
            assert (this.hadPreviousConfig);
            return (this.previousFlags & flag.value) != 0;
        }

        boolean didScroll() {
            return !Float.isNaN(this.scrollPosition) && !Float.isNaN(this.previousScrollPosition) && this.previousScrollPosition != this.scrollPosition;
        }

        boolean didChangeLabel() {
            if (this.label == null && this.previousLabel == null) {
                return false;
            }
            return this.label == null || this.previousLabel == null || !this.label.equals(this.previousLabel);
        }

        void log(String indent, boolean recursive) {
            Log.i((String)AccessibilityBridge.TAG, (String)(indent + "SemanticsObject id=" + this.id + " label=" + this.label + " actions=" + this.actions + " flags=" + this.flags + "\n" + indent + "  +-- textDirection=" + (Object)((Object)this.textDirection) + "\n" + indent + "  +-- rect.ltrb=(" + this.left + ", " + this.top + ", " + this.right + ", " + this.bottom + ")\n" + indent + "  +-- transform=" + Arrays.toString(this.transform) + "\n"));
            if (this.childrenInTraversalOrder != null && recursive) {
                String childIndent = indent + "  ";
                for (SemanticsObject child : this.childrenInTraversalOrder) {
                    child.log(childIndent, recursive);
                }
            }
        }

        void updateWith(ByteBuffer buffer, String[] strings) {
            this.hadPreviousConfig = true;
            this.previousValue = this.value;
            this.previousLabel = this.label;
            this.previousFlags = this.flags;
            this.previousActions = this.actions;
            this.previousTextSelectionBase = this.textSelectionBase;
            this.previousTextSelectionExtent = this.textSelectionExtent;
            this.previousScrollPosition = this.scrollPosition;
            this.previousScrollExtentMax = this.scrollExtentMax;
            this.previousScrollExtentMin = this.scrollExtentMin;
            this.flags = buffer.getInt();
            this.actions = buffer.getInt();
            this.textSelectionBase = buffer.getInt();
            this.textSelectionExtent = buffer.getInt();
            this.scrollChildren = buffer.getInt();
            this.scrollIndex = buffer.getInt();
            this.scrollPosition = buffer.getFloat();
            this.scrollExtentMax = buffer.getFloat();
            this.scrollExtentMin = buffer.getFloat();
            int stringIndex = buffer.getInt();
            this.label = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            this.value = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            this.increasedValue = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            this.decreasedValue = stringIndex == -1 ? null : strings[stringIndex];
            stringIndex = buffer.getInt();
            this.hint = stringIndex == -1 ? null : strings[stringIndex];
            this.textDirection = TextDirection.fromInt(buffer.getInt());
            this.left = buffer.getFloat();
            this.top = buffer.getFloat();
            this.right = buffer.getFloat();
            this.bottom = buffer.getFloat();
            if (this.transform == null) {
                this.transform = new float[16];
            }
            for (int i = 0; i < 16; ++i) {
                this.transform[i] = buffer.getFloat();
            }
            this.inverseTransformDirty = true;
            this.globalGeometryDirty = true;
            int childCount = buffer.getInt();
            if (childCount == 0) {
                this.childrenInTraversalOrder = null;
                this.childrenInHitTestOrder = null;
            } else {
                SemanticsObject child;
                int i;
                if (this.childrenInTraversalOrder == null) {
                    this.childrenInTraversalOrder = new ArrayList<SemanticsObject>(childCount);
                } else {
                    this.childrenInTraversalOrder.clear();
                }
                for (i = 0; i < childCount; ++i) {
                    child = AccessibilityBridge.this.getOrCreateObject(buffer.getInt());
                    child.parent = this;
                    this.childrenInTraversalOrder.add(child);
                }
                if (this.childrenInHitTestOrder == null) {
                    this.childrenInHitTestOrder = new ArrayList<SemanticsObject>(childCount);
                } else {
                    this.childrenInHitTestOrder.clear();
                }
                for (i = 0; i < childCount; ++i) {
                    child = AccessibilityBridge.this.getOrCreateObject(buffer.getInt());
                    child.parent = this;
                    this.childrenInHitTestOrder.add(child);
                }
            }
            int actionCount = buffer.getInt();
            if (actionCount == 0) {
                this.customAccessibilityActions = null;
            } else {
                if (this.customAccessibilityActions == null) {
                    this.customAccessibilityActions = new ArrayList<CustomAccessibilityAction>(actionCount);
                } else {
                    this.customAccessibilityActions.clear();
                }
                for (int i = 0; i < actionCount; ++i) {
                    CustomAccessibilityAction action = AccessibilityBridge.this.getOrCreateAction(buffer.getInt());
                    if (action.overrideId == Action.TAP.value) {
                        this.onTapOverride = action;
                    } else if (action.overrideId == Action.LONG_PRESS.value) {
                        this.onLongPressOverride = action;
                    } else {
                        assert (action.overrideId == -1);
                        this.customAccessibilityActions.add(action);
                    }
                    this.customAccessibilityActions.add(action);
                }
            }
        }

        private void ensureInverseTransform() {
            if (!this.inverseTransformDirty) {
                return;
            }
            this.inverseTransformDirty = false;
            if (this.inverseTransform == null) {
                this.inverseTransform = new float[16];
            }
            if (!Matrix.invertM((float[])this.inverseTransform, (int)0, (float[])this.transform, (int)0)) {
                Arrays.fill(this.inverseTransform, 0.0f);
            }
        }

        Rect getGlobalRect() {
            assert (!this.globalGeometryDirty);
            return this.globalRect;
        }

        SemanticsObject hitTest(float[] point) {
            float w = point[3];
            float x = point[0] / w;
            float y = point[1] / w;
            if (x < this.left || x >= this.right || y < this.top || y >= this.bottom) {
                return null;
            }
            if (this.childrenInHitTestOrder != null) {
                float[] transformedPoint = new float[4];
                for (int i = 0; i < this.childrenInHitTestOrder.size(); ++i) {
                    SemanticsObject child = this.childrenInHitTestOrder.get(i);
                    if (child.hasFlag(Flag.IS_HIDDEN)) continue;
                    child.ensureInverseTransform();
                    Matrix.multiplyMV((float[])transformedPoint, (int)0, (float[])child.inverseTransform, (int)0, (float[])point, (int)0);
                    SemanticsObject result = child.hitTest(transformedPoint);
                    if (result == null) continue;
                    return result;
                }
            }
            return this;
        }

        boolean isFocusable() {
            if (this.hasFlag(Flag.SCOPES_ROUTE)) {
                return false;
            }
            int scrollableActions = Action.SCROLL_RIGHT.value | Action.SCROLL_LEFT.value | Action.SCROLL_UP.value | Action.SCROLL_DOWN.value;
            return (this.actions & ~scrollableActions) != 0 || this.flags != 0 || this.label != null && !this.label.isEmpty() || this.value != null && !this.value.isEmpty() || this.hint != null && !this.hint.isEmpty();
        }

        void collectRoutes(List<SemanticsObject> edges) {
            if (this.hasFlag(Flag.SCOPES_ROUTE)) {
                edges.add(this);
            }
            if (this.childrenInTraversalOrder != null) {
                for (int i = 0; i < this.childrenInTraversalOrder.size(); ++i) {
                    this.childrenInTraversalOrder.get(i).collectRoutes(edges);
                }
            }
        }

        String getRouteName() {
            if (this.hasFlag(Flag.NAMES_ROUTE) && this.label != null && !this.label.isEmpty()) {
                return this.label;
            }
            if (this.childrenInTraversalOrder != null) {
                for (int i = 0; i < this.childrenInTraversalOrder.size(); ++i) {
                    String newName = this.childrenInTraversalOrder.get(i).getRouteName();
                    if (newName == null || newName.isEmpty()) continue;
                    return newName;
                }
            }
            return null;
        }

        void updateRecursively(float[] ancestorTransform, Set<SemanticsObject> visitedObjects, boolean forceUpdate) {
            visitedObjects.add(this);
            if (this.globalGeometryDirty) {
                forceUpdate = true;
            }
            if (forceUpdate) {
                if (this.globalTransform == null) {
                    this.globalTransform = new float[16];
                }
                Matrix.multiplyMM((float[])this.globalTransform, (int)0, (float[])ancestorTransform, (int)0, (float[])this.transform, (int)0);
                float[] sample = new float[4];
                sample[2] = 0.0f;
                sample[3] = 1.0f;
                float[] point1 = new float[4];
                float[] point2 = new float[4];
                float[] point3 = new float[4];
                float[] point4 = new float[4];
                sample[0] = this.left;
                sample[1] = this.top;
                this.transformPoint(point1, this.globalTransform, sample);
                sample[0] = this.right;
                sample[1] = this.top;
                this.transformPoint(point2, this.globalTransform, sample);
                sample[0] = this.right;
                sample[1] = this.bottom;
                this.transformPoint(point3, this.globalTransform, sample);
                sample[0] = this.left;
                sample[1] = this.bottom;
                this.transformPoint(point4, this.globalTransform, sample);
                if (this.globalRect == null) {
                    this.globalRect = new Rect();
                }
                this.globalRect.set(Math.round(this.min(point1[0], point2[0], point3[0], point4[0])), Math.round(this.min(point1[1], point2[1], point3[1], point4[1])), Math.round(this.max(point1[0], point2[0], point3[0], point4[0])), Math.round(this.max(point1[1], point2[1], point3[1], point4[1])));
                this.globalGeometryDirty = false;
            }
            assert (this.globalTransform != null);
            assert (this.globalRect != null);
            if (this.childrenInTraversalOrder != null) {
                for (int i = 0; i < this.childrenInTraversalOrder.size(); ++i) {
                    this.childrenInTraversalOrder.get(i).updateRecursively(this.globalTransform, visitedObjects, forceUpdate);
                }
            }
        }

        private void transformPoint(float[] result, float[] transform, float[] point) {
            Matrix.multiplyMV((float[])result, (int)0, (float[])transform, (int)0, (float[])point, (int)0);
            float w = result[3];
            result[0] = result[0] / w;
            result[1] = result[1] / w;
            result[2] = result[2] / w;
            result[3] = 0.0f;
        }

        private float min(float a, float b, float c, float d) {
            return Math.min(a, Math.min(b, Math.min(c, d)));
        }

        private float max(float a, float b, float c, float d) {
            return Math.max(a, Math.max(b, Math.max(c, d)));
        }

        private String getValueLabelHint() {
            String[] array;
            StringBuilder sb = new StringBuilder();
            for (String word : array = new String[]{this.value, this.label, this.hint}) {
                if (word == null || word.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(word);
            }
            return sb.length() > 0 ? sb.toString() : null;
        }
    }

    private class CustomAccessibilityAction {
        int resourceId = -1;
        int id = -1;
        int overrideId = -1;
        String label;
        String hint;

        CustomAccessibilityAction() {
        }

        boolean isStandardAction() {
            return this.overrideId != -1;
        }
    }

    private static enum TextDirection {
        UNKNOWN,
        LTR,
        RTL;


        public static TextDirection fromInt(int value) {
            switch (value) {
                case 1: {
                    return RTL;
                }
                case 2: {
                    return LTR;
                }
            }
            return UNKNOWN;
        }
    }

    static enum Flag {
        HAS_CHECKED_STATE(1),
        IS_CHECKED(2),
        IS_SELECTED(4),
        IS_BUTTON(8),
        IS_TEXT_FIELD(16),
        IS_FOCUSED(32),
        HAS_ENABLED_STATE(64),
        IS_ENABLED(128),
        IS_IN_MUTUALLY_EXCLUSIVE_GROUP(256),
        IS_HEADER(512),
        IS_OBSCURED(1024),
        SCOPES_ROUTE(2048),
        NAMES_ROUTE(4096),
        IS_HIDDEN(8192),
        IS_IMAGE(16384),
        IS_LIVE_REGION(32768),
        HAS_TOGGLED_STATE(65536),
        IS_TOGGLED(131072),
        HAS_IMPLICIT_SCROLLING(262144);

        final int value;

        private Flag(int value) {
            this.value = value;
        }
    }

    static enum Action {
        TAP(1),
        LONG_PRESS(2),
        SCROLL_LEFT(4),
        SCROLL_RIGHT(8),
        SCROLL_UP(16),
        SCROLL_DOWN(32),
        INCREASE(64),
        DECREASE(128),
        SHOW_ON_SCREEN(256),
        MOVE_CURSOR_FORWARD_BY_CHARACTER(512),
        MOVE_CURSOR_BACKWARD_BY_CHARACTER(1024),
        SET_SELECTION(2048),
        COPY(4096),
        CUT(8192),
        PASTE(16384),
        DID_GAIN_ACCESSIBILITY_FOCUS(32768),
        DID_LOSE_ACCESSIBILITY_FOCUS(65536),
        CUSTOM_ACTION(131072),
        DISMISS(262144),
        MOVE_CURSOR_FORWARD_BY_WORD(524288),
        MOVE_CURSOR_BACKWARD_BY_WORD(0x100000);

        final int value;

        private Action(int value) {
            this.value = value;
        }
    }
}

