/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import io.flutter.app.FlutterPluginRegistry;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.view.FlutterRunArguments;
import io.flutter.view.FlutterView;
import java.nio.ByteBuffer;

public class FlutterNativeView
implements BinaryMessenger {
    private static final String TAG = "FlutterNativeView";
    private final FlutterPluginRegistry mPluginRegistry;
    private final DartExecutor dartExecutor;
    private FlutterView mFlutterView;
    private final FlutterJNI mFlutterJNI;
    private final Context mContext;
    private boolean applicationIsRunning;

    public FlutterNativeView(@NonNull Context context) {
        this(context, false);
    }

    public FlutterNativeView(@NonNull Context context, boolean isBackgroundView) {
        this.mContext = context;
        this.mPluginRegistry = new FlutterPluginRegistry(this, context);
        this.mFlutterJNI = new FlutterJNI();
        this.mFlutterJNI.setRenderSurface(new RenderSurfaceImpl());
        this.dartExecutor = new DartExecutor(this.mFlutterJNI);
        this.mFlutterJNI.addEngineLifecycleListener(new EngineLifecycleListenerImpl());
        this.attach(this, isBackgroundView);
        this.assertAttached();
    }

    public void detach() {
        this.mPluginRegistry.detach();
        this.dartExecutor.onDetachedFromJNI();
        this.mFlutterView = null;
    }

    public void destroy() {
        this.mPluginRegistry.destroy();
        this.dartExecutor.onDetachedFromJNI();
        this.mFlutterView = null;
        this.mFlutterJNI.detachFromNativeAndReleaseResources();
        this.applicationIsRunning = false;
    }

    @NonNull
    public DartExecutor getDartExecutor() {
        return this.dartExecutor;
    }

    @NonNull
    public FlutterPluginRegistry getPluginRegistry() {
        return this.mPluginRegistry;
    }

    public void attachViewAndActivity(FlutterView flutterView, Activity activity) {
        this.mFlutterView = flutterView;
        this.mPluginRegistry.attach(flutterView, activity);
    }

    public boolean isAttached() {
        return this.mFlutterJNI.isAttached();
    }

    public void assertAttached() {
        if (!this.isAttached()) {
            throw new AssertionError((Object)"Platform view is not attached");
        }
    }

    public void runFromBundle(FlutterRunArguments args) {
        boolean hasBundlePaths;
        boolean bl = hasBundlePaths = args.bundlePaths != null && args.bundlePaths.length != 0;
        if (args.bundlePath == null && !hasBundlePaths) {
            throw new AssertionError((Object)"Either bundlePath or bundlePaths must be specified");
        }
        if ((args.bundlePath != null || args.defaultPath != null) && hasBundlePaths) {
            throw new AssertionError((Object)"Can't specify both bundlePath and bundlePaths");
        }
        if (args.entrypoint == null) {
            throw new AssertionError((Object)"An entrypoint must be specified");
        }
        if (hasBundlePaths) {
            this.runFromBundleInternal(args.bundlePaths, args.entrypoint, args.libraryPath);
        } else {
            this.runFromBundleInternal(new String[]{args.bundlePath, args.defaultPath}, args.entrypoint, args.libraryPath);
        }
    }

    @Deprecated
    public void runFromBundle(String bundlePath, String defaultPath, String entrypoint, boolean reuseRuntimeController) {
        this.runFromBundleInternal(new String[]{bundlePath, defaultPath}, entrypoint, null);
    }

    private void runFromBundleInternal(String[] bundlePaths, String entrypoint, String libraryPath) {
        this.assertAttached();
        if (this.applicationIsRunning) {
            throw new AssertionError((Object)"This Flutter engine instance is already running an application");
        }
        this.mFlutterJNI.runBundleAndSnapshotFromLibrary(bundlePaths, entrypoint, libraryPath, this.mContext.getResources().getAssets());
        this.applicationIsRunning = true;
    }

    public boolean isApplicationRunning() {
        return this.applicationIsRunning;
    }

    public static String getObservatoryUri() {
        return FlutterJNI.nativeGetObservatoryUri();
    }

    @Override
    public void send(String channel, ByteBuffer message) {
        this.dartExecutor.send(channel, message);
    }

    @Override
    public void send(String channel, ByteBuffer message, BinaryMessenger.BinaryReply callback) {
        if (!this.isAttached()) {
            Log.d((String)TAG, (String)("FlutterView.send called on a detached view, channel=" + channel));
            return;
        }
        this.dartExecutor.send(channel, message, callback);
    }

    @Override
    public void setMessageHandler(String channel, BinaryMessenger.BinaryMessageHandler handler) {
        this.dartExecutor.setMessageHandler(channel, handler);
    }

    FlutterJNI getFlutterJNI() {
        return this.mFlutterJNI;
    }

    private void attach(FlutterNativeView view, boolean isBackgroundView) {
        this.mFlutterJNI.attachToNative(isBackgroundView);
        this.dartExecutor.onAttachedToJNI();
    }

    private final class EngineLifecycleListenerImpl
    implements FlutterEngine.EngineLifecycleListener {
        private EngineLifecycleListenerImpl() {
        }

        @Override
        public void onPreEngineRestart() {
            if (FlutterNativeView.this.mFlutterView != null) {
                FlutterNativeView.this.mFlutterView.resetAccessibilityTree();
            }
            if (FlutterNativeView.this.mPluginRegistry == null) {
                return;
            }
            FlutterNativeView.this.mPluginRegistry.onPreEngineRestart();
        }
    }

    private final class RenderSurfaceImpl
    implements FlutterRenderer.RenderSurface {
        private RenderSurfaceImpl() {
        }

        @Override
        public void attachToRenderer(@NonNull FlutterRenderer renderer) {
        }

        @Override
        public void detachFromRenderer() {
        }

        @Override
        public void updateSemantics(ByteBuffer buffer, String[] strings) {
            if (FlutterNativeView.this.mFlutterView == null) {
                return;
            }
            FlutterNativeView.this.mFlutterView.updateSemantics(buffer, strings);
        }

        @Override
        public void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
            if (FlutterNativeView.this.mFlutterView == null) {
                return;
            }
            FlutterNativeView.this.mFlutterView.updateCustomAccessibilityActions(buffer, strings);
        }

        @Override
        public void onFirstFrameRendered() {
            if (FlutterNativeView.this.mFlutterView == null) {
                return;
            }
            FlutterNativeView.this.mFlutterView.onFirstFrame();
        }
    }
}

