/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.view.FlutterMain;

public class FlutterFragment
extends Fragment {
    private static final String TAG = "FlutterFragment";
    private static final String ARG_DART_ENTRYPOINT = "dart_entrypoint";
    private static final String ARG_INITIAL_ROUTE = "initial_route";
    private static final String ARG_APP_BUNDLE_PATH = "app_bundle_path";
    private static final String ARG_FLUTTER_INITIALIZATION_ARGS = "initialization_args";
    private static final String ARG_FLUTTERVIEW_RENDER_MODE = "flutterview_render_mode";
    @Nullable
    private FlutterEngine flutterEngine;
    @Nullable
    private FlutterView flutterView;
    @Nullable
    private PlatformPlugin platformPlugin;

    protected static Bundle createArgsBundle(@Nullable String dartEntrypoint, @Nullable String initialRoute, @Nullable String appBundlePath, @Nullable FlutterShellArgs flutterShellArgs, @Nullable FlutterView.RenderMode renderMode) {
        Bundle args = new Bundle();
        args.putString(ARG_INITIAL_ROUTE, initialRoute);
        args.putString(ARG_APP_BUNDLE_PATH, appBundlePath);
        args.putString(ARG_DART_ENTRYPOINT, dartEntrypoint);
        if (null != flutterShellArgs) {
            args.putStringArray(ARG_FLUTTER_INITIALIZATION_ARGS, flutterShellArgs.toArray());
        }
        args.putString(ARG_FLUTTERVIEW_RENDER_MODE, renderMode != null ? renderMode.name() : FlutterView.RenderMode.surface.name());
        return args;
    }

    public FlutterFragment() {
        this.setArguments(new Bundle());
    }

    @Nullable
    public FlutterEngine getFlutterEngine() {
        return this.flutterEngine;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.initializeFlutter(this.getContextCompat());
        if (this.flutterEngine == null) {
            this.createFlutterEngine();
        }
        this.platformPlugin = new PlatformPlugin((Activity)this.getActivity(), this.flutterEngine.getPlatformChannel());
    }

    private void initializeFlutter(@NonNull Context context) {
        String[] flutterShellArgsArray = this.getArguments().getStringArray(ARG_FLUTTER_INITIALIZATION_ARGS);
        FlutterShellArgs flutterShellArgs = new FlutterShellArgs(flutterShellArgsArray != null ? flutterShellArgsArray : new String[]{});
        FlutterMain.ensureInitializationComplete(context.getApplicationContext(), flutterShellArgs.toArray());
    }

    private void createFlutterEngine() {
        this.flutterEngine = this.onCreateFlutterEngine((Context)this.getActivity());
        this.onFlutterEngineCreated(this.flutterEngine);
    }

    @NonNull
    protected FlutterEngine onCreateFlutterEngine(@NonNull Context context) {
        Log.d((String)TAG, (String)"onCreateFlutterEngine()");
        return new FlutterEngine(context);
    }

    protected void onFlutterEngineCreated(@NonNull FlutterEngine flutterEngine) {
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.flutterView = new FlutterView(this.getContext(), this.getRenderMode());
        this.flutterView.attachToFlutterEngine(this.flutterEngine);
        this.doInitialFlutterViewRun();
        return this.flutterView;
    }

    private void doInitialFlutterViewRun() {
        if (this.flutterEngine.getDartExecutor().isExecutingDart()) {
            return;
        }
        if (this.getInitialRoute() != null) {
            this.flutterEngine.getNavigationChannel().setInitialRoute(this.getInitialRoute());
        }
        DartExecutor.DartEntrypoint entrypoint = new DartExecutor.DartEntrypoint(this.getResources().getAssets(), this.getAppBundlePath(), this.getDartEntrypointFunctionName());
        this.flutterEngine.getDartExecutor().executeDartEntrypoint(entrypoint);
    }

    @Nullable
    protected String getInitialRoute() {
        return this.getArguments().getString(ARG_INITIAL_ROUTE);
    }

    @NonNull
    protected String getAppBundlePath() {
        return this.getArguments().getString(ARG_APP_BUNDLE_PATH, FlutterMain.findAppBundlePath(this.getContextCompat()));
    }

    @NonNull
    protected String getDartEntrypointFunctionName() {
        return this.getArguments().getString(ARG_DART_ENTRYPOINT, "main");
    }

    @NonNull
    protected FlutterView.RenderMode getRenderMode() {
        String renderModeName = this.getArguments().getString(ARG_FLUTTERVIEW_RENDER_MODE, FlutterView.RenderMode.surface.name());
        return FlutterView.RenderMode.valueOf(renderModeName);
    }

    public void onPostResume() {
        Log.d((String)TAG, (String)"onPostResume()");
        if (this.flutterEngine != null) {
            this.flutterEngine.getLifecycleChannel().appIsResumed();
            this.platformPlugin.onPostResume();
        } else {
            Log.w((String)TAG, (String)"onPostResume() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onPause() {
        super.onPause();
        Log.d((String)TAG, (String)"onPause()");
        this.flutterEngine.getLifecycleChannel().appIsInactive();
    }

    public void onStop() {
        super.onStop();
        Log.d((String)TAG, (String)"onStop()");
        this.flutterEngine.getLifecycleChannel().appIsPaused();
    }

    public void onDestroyView() {
        super.onDestroyView();
        Log.d((String)TAG, (String)"onDestroyView()");
        this.flutterView.detachFromFlutterEngine();
    }

    public void onDetach() {
        super.onDetach();
        Log.d((String)TAG, (String)"onDetach()");
        this.platformPlugin = null;
        if (!this.retainFlutterIsolateAfterFragmentDestruction()) {
            this.flutterEngine.destroy();
            this.flutterEngine = null;
        }
    }

    protected boolean retainFlutterIsolateAfterFragmentDestruction() {
        return false;
    }

    public void onBackPressed() {
        Log.d((String)TAG, (String)"onBackPressed()");
        if (this.flutterEngine != null) {
            this.flutterEngine.getNavigationChannel().popRoute();
        } else {
            Log.w((String)TAG, (String)"Invoked onBackPressed() before FlutterFragment was attached to an Activity.");
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (this.flutterEngine != null) {
            this.flutterEngine.getPluginRegistry().onRequestPermissionsResult(requestCode, permissions, grantResults);
        } else {
            Log.w((String)TAG, (String)"onRequestPermissionResult() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onNewIntent(@NonNull Intent intent) {
        if (this.flutterEngine != null) {
            this.flutterEngine.getPluginRegistry().onNewIntent(intent);
        } else {
            Log.w((String)TAG, (String)"onNewIntent() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.flutterEngine != null) {
            this.flutterEngine.getPluginRegistry().onActivityResult(requestCode, resultCode, data);
        } else {
            Log.w((String)TAG, (String)"onActivityResult() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onUserLeaveHint() {
        if (this.flutterEngine != null) {
            this.flutterEngine.getPluginRegistry().onUserLeaveHint();
        } else {
            Log.w((String)TAG, (String)"onUserLeaveHint() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onTrimMemory(int level) {
        if (this.flutterEngine != null) {
            if (level == 10) {
                this.flutterEngine.getSystemChannel().sendMemoryPressureWarning();
            }
        } else {
            Log.w((String)TAG, (String)"onTrimMemory() invoked before FlutterFragment was attached to an Activity.");
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.flutterEngine.getSystemChannel().sendMemoryPressureWarning();
    }

    @NonNull
    private Context getContextCompat() {
        return Build.VERSION.SDK_INT >= 23 ? this.getContext() : this.getActivity();
    }

    public static class Builder {
        private String dartEntrypoint = "main";
        private String initialRoute = "/";
        private String appBundlePath = null;
        private FlutterShellArgs shellArgs = null;
        private FlutterView.RenderMode renderMode = FlutterView.RenderMode.surface;

        @NonNull
        public Builder dartEntrypoint(@NonNull String dartEntrypoint) {
            this.dartEntrypoint = dartEntrypoint;
            return this;
        }

        @NonNull
        public Builder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public Builder appBundlePath(@NonNull String appBundlePath) {
            this.appBundlePath = appBundlePath;
            return this;
        }

        @NonNull
        public Builder flutterShellArgs(@NonNull FlutterShellArgs shellArgs) {
            this.shellArgs = shellArgs;
            return this;
        }

        @NonNull
        public Builder renderMode(@NonNull FlutterView.RenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        @NonNull
        public FlutterFragment build() {
            FlutterFragment frag = new FlutterFragment();
            Bundle args = FlutterFragment.createArgsBundle(this.dartEntrypoint, this.initialRoute, this.appBundlePath, this.shellArgs, this.renderMode);
            frag.setArguments(args);
            return frag;
        }
    }
}

