/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import io.flutter.util.BSDiff;
import io.flutter.util.PathUtils;
import io.flutter.view.FlutterMain;
import io.flutter.view.ResourceUpdater;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONObject;

class ResourceExtractor {
    private static final String TAG = "ResourceExtractor";
    private static final String TIMESTAMP_PREFIX = "res_timestamp-";
    private static final String[] SUPPORTED_ABIS = ResourceExtractor.getSupportedAbis();
    private final Context mContext;
    private final HashSet<String> mResources;
    private ExtractTask mExtractTask;

    static long getVersionCode(PackageInfo packageInfo) {
        if (Build.VERSION.SDK_INT >= 28) {
            return packageInfo.getLongVersionCode();
        }
        return packageInfo.versionCode;
    }

    ResourceExtractor(Context context) {
        this.mContext = context;
        this.mResources = new HashSet();
    }

    ResourceExtractor addResource(String resource) {
        this.mResources.add(resource);
        return this;
    }

    ResourceExtractor addResources(Collection<String> resources) {
        this.mResources.addAll(resources);
        return this;
    }

    ResourceExtractor start() {
        assert (this.mExtractTask == null);
        this.mExtractTask = new ExtractTask();
        this.mExtractTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return this;
    }

    void waitForCompletion() {
        if (this.mExtractTask == null) {
            return;
        }
        try {
            this.mExtractTask.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            this.deleteFiles();
        }
    }

    private String[] getExistingTimestamps(File dataDir) {
        return dataDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(ResourceExtractor.TIMESTAMP_PREFIX);
            }
        });
    }

    private void deleteFiles() {
        File dataDir = new File(PathUtils.getDataDirectory(this.mContext));
        for (String resource : this.mResources) {
            File file = new File(dataDir, resource);
            if (!file.exists()) continue;
            file.delete();
        }
        String[] existingTimestamps = this.getExistingTimestamps(dataDir);
        if (existingTimestamps == null) {
            return;
        }
        for (String timestamp : existingTimestamps) {
            new File(dataDir, timestamp).delete();
        }
    }

    private boolean extractAPK(File dataDir) {
        AssetManager manager = this.mContext.getResources().getAssets();
        for (String asset : this.mResources) {
            try {
                String resource = "assets/" + asset;
                File output = new File(dataDir, asset);
                if (output.exists()) continue;
                if (output.getParentFile() != null) {
                    output.getParentFile().mkdirs();
                }
                try (InputStream is = manager.open(asset);
                     FileOutputStream os = new FileOutputStream(output);){
                    ResourceExtractor.copy(is, os);
                }
                Log.i((String)TAG, (String)("Extracted baseline resource " + resource));
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (IOException ioe) {
                Log.w((String)TAG, (String)("Exception unpacking resources: " + ioe.getMessage()));
                this.deleteFiles();
                return false;
            }
        }
        return true;
    }

    private boolean extractUpdate(File dataDir) {
        ZipFile zipFile;
        AssetManager manager = this.mContext.getResources().getAssets();
        ResourceUpdater resourceUpdater = FlutterMain.getResourceUpdater();
        if (resourceUpdater == null) {
            return true;
        }
        File updateFile = resourceUpdater.getInstalledPatch();
        if (!updateFile.exists()) {
            return true;
        }
        JSONObject manifest = resourceUpdater.readManifest(updateFile);
        if (!resourceUpdater.validateManifest(manifest)) {
            return true;
        }
        try {
            zipFile = new ZipFile(updateFile);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Exception unpacking resources: " + e.getMessage()));
            this.deleteFiles();
            return false;
        }
        for (String asset : this.mResources) {
            File output;
            String resource = null;
            ZipEntry entry = null;
            if (asset.endsWith(".so")) {
                for (String string : SUPPORTED_ABIS) {
                    resource = "lib/" + string + "/" + asset;
                    entry = zipFile.getEntry(resource);
                    if (entry != null || (entry = zipFile.getEntry(resource + ".bzdiff40")) != null) break;
                }
            }
            if (entry == null && (entry = zipFile.getEntry(resource = "assets/" + asset)) == null && (entry = zipFile.getEntry(resource + ".bzdiff40")) == null || (output = new File(dataDir, asset)).exists()) continue;
            if (output.getParentFile() != null) {
                output.getParentFile().mkdirs();
            }
            try {
                Throwable throwable;
                if (entry.getName().endsWith(".bzdiff40")) {
                    ByteArrayOutputStream diff = new ByteArrayOutputStream();
                    Throwable throwable2 = null;
                    try (InputStream is = zipFile.getInputStream(entry);){
                        ResourceExtractor.copy(is, diff);
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        throw throwable3;
                    }
                    ByteArrayOutputStream orig = new ByteArrayOutputStream();
                    if (asset.endsWith(".so")) {
                        ZipFile zipFile2 = new ZipFile(this.getAPKPath());
                        if (zipFile2 == null) {
                            throw new IOException("Could not find APK");
                        }
                        ZipEntry origEntry = zipFile2.getEntry(resource);
                        if (origEntry == null) {
                            throw new IOException("Could not find APK resource " + resource);
                        }
                        try (InputStream is2 = zipFile2.getInputStream(origEntry);){
                            ResourceExtractor.copy(is2, orig);
                        }
                    }
                    try {
                        throwable = null;
                        try (InputStream inputStream = manager.open(asset);){
                            ResourceExtractor.copy(inputStream, orig);
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new IOException("Could not find APK resource " + resource);
                    }
                    throwable = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(output);){
                        ((OutputStream)fileOutputStream).write(BSDiff.bspatch(orig.toByteArray(), diff.toByteArray()));
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
                try (InputStream is = zipFile.getInputStream(entry);){
                    throwable = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(output);){
                        ResourceExtractor.copy(is, fileOutputStream);
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                }
                Log.i((String)TAG, (String)("Extracted override resource " + entry.getName()));
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (IOException ioe) {
                Log.w((String)TAG, (String)("Exception unpacking resources: " + ioe.getMessage()));
                this.deleteFiles();
                return false;
            }
        }
        return true;
    }

    private String checkTimestamp(File dataDir) {
        String[] existingTimestamps;
        File patchFile;
        JSONObject manifest;
        PackageManager packageManager = this.mContext.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return TIMESTAMP_PREFIX;
        }
        if (packageInfo == null) {
            return TIMESTAMP_PREFIX;
        }
        String expectedTimestamp = TIMESTAMP_PREFIX + ResourceExtractor.getVersionCode(packageInfo) + "-" + packageInfo.lastUpdateTime;
        ResourceUpdater resourceUpdater = FlutterMain.getResourceUpdater();
        if (resourceUpdater != null && resourceUpdater.validateManifest(manifest = resourceUpdater.readManifest(patchFile = resourceUpdater.getInstalledPatch()))) {
            String patchNumber = manifest.optString("patchNumber", null);
            expectedTimestamp = patchNumber != null ? expectedTimestamp + "-" + patchNumber + "-" + patchFile.lastModified() : expectedTimestamp + "-" + patchFile.lastModified();
        }
        if ((existingTimestamps = this.getExistingTimestamps(dataDir)) == null) {
            Log.i((String)TAG, (String)"No extracted resources found");
            return expectedTimestamp;
        }
        if (existingTimestamps.length == 1) {
            Log.i((String)TAG, (String)("Found extracted resources " + existingTimestamps[0]));
        }
        if (existingTimestamps.length != 1 || !expectedTimestamp.equals(existingTimestamps[0])) {
            Log.i((String)TAG, (String)("Resource version mismatch " + expectedTimestamp));
            return expectedTimestamp;
        }
        return null;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int i;
        byte[] buf = new byte[16384];
        while ((i = in.read(buf)) >= 0) {
            out.write(buf, 0, i);
        }
    }

    private String getAPKPath() {
        try {
            return this.mContext.getPackageManager().getApplicationInfo((String)this.mContext.getPackageName(), (int)0).publicSourceDir;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String[] getSupportedAbis() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        ArrayList<String> cpuAbis = new ArrayList<String>(Arrays.asList(Build.CPU_ABI, Build.CPU_ABI2));
        cpuAbis.removeAll(Arrays.asList(null, ""));
        return cpuAbis.toArray(new String[0]);
    }

    private class ExtractTask
    extends AsyncTask<Void, Void, Void> {
        ExtractTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... unused) {
            File dataDir = new File(PathUtils.getDataDirectory(ResourceExtractor.this.mContext));
            ResourceUpdater resourceUpdater = FlutterMain.getResourceUpdater();
            if (resourceUpdater != null) {
                resourceUpdater.getInstallationLock().lock();
            }
            try {
                String timestamp;
                File activeFile;
                if (resourceUpdater != null) {
                    JSONObject manifest;
                    File updateFile = resourceUpdater.getDownloadedPatch();
                    activeFile = resourceUpdater.getInstalledPatch();
                    if (updateFile.exists() && resourceUpdater.validateManifest(manifest = resourceUpdater.readManifest(updateFile))) {
                        if (activeFile.exists() && !activeFile.delete()) {
                            Log.w((String)ResourceExtractor.TAG, (String)("Could not delete file " + activeFile));
                            Void void_ = null;
                            return void_;
                        }
                        if (!updateFile.renameTo(activeFile)) {
                            Log.w((String)ResourceExtractor.TAG, (String)("Could not create file " + activeFile));
                            Void void_ = null;
                            return void_;
                        }
                    }
                }
                if ((timestamp = ResourceExtractor.this.checkTimestamp(dataDir)) == null) {
                    activeFile = null;
                    return activeFile;
                }
                ResourceExtractor.this.deleteFiles();
                if (!ResourceExtractor.this.extractUpdate(dataDir)) {
                    activeFile = null;
                    return activeFile;
                }
                if (!ResourceExtractor.this.extractAPK(dataDir)) {
                    activeFile = null;
                    return activeFile;
                }
                if (timestamp != null) {
                    try {
                        new File(dataDir, timestamp).createNewFile();
                    }
                    catch (IOException e) {
                        Log.w((String)ResourceExtractor.TAG, (String)"Failed to write resource timestamp");
                    }
                }
                Void void_ = null;
                return void_;
            }
            finally {
                if (resourceUpdater != null) {
                    resourceUpdater.getInstallationLock().unlock();
                }
            }
        }
    }
}

