/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.support.annotation.NonNull;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.JSONMessageCodec;
import java.util.HashMap;
import java.util.Map;

public class SettingsChannel {
    public static final String CHANNEL_NAME = "flutter/settings";
    public final BasicMessageChannel<Object> channel;

    public SettingsChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new BasicMessageChannel<Object>(dartExecutor, CHANNEL_NAME, JSONMessageCodec.INSTANCE);
    }

    public MessageBuilder startMessage() {
        return new MessageBuilder(this.channel);
    }

    public static enum PlatformBrightness {
        light("light"),
        dark("dark");

        public String name;

        private PlatformBrightness(String name) {
            this.name = name;
        }
    }

    public static class MessageBuilder {
        private final BasicMessageChannel<Object> channel;
        private Map<String, Object> message = new HashMap<String, Object>();

        MessageBuilder(@NonNull BasicMessageChannel<Object> channel) {
            this.channel = channel;
        }

        public MessageBuilder setTextScaleFactor(float textScaleFactor) {
            this.message.put("textScaleFactor", Float.valueOf(textScaleFactor));
            return this;
        }

        public MessageBuilder setUse24HourFormat(boolean use24HourFormat) {
            this.message.put("alwaysUse24HourFormat", use24HourFormat);
            return this;
        }

        public MessageBuilder setPlatformBrightness(@NonNull PlatformBrightness brightness) {
            this.message.put("platformBrightness", brightness.name);
            return this;
        }

        public void send() {
            this.channel.send(this.message);
        }
    }
}

