/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.InputMethodManager;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.common.ErrorLogResult;
import io.flutter.plugin.common.MethodChannel;

class InputConnectionAdaptor
extends BaseInputConnection {
    private final View mFlutterView;
    private final int mClient;
    private final TextInputChannel textInputChannel;
    private final Editable mEditable;
    private int mBatchCount;
    private InputMethodManager mImm;
    private static final MethodChannel.Result logger = new ErrorLogResult("FlutterTextInput");

    public InputConnectionAdaptor(View view, int client, TextInputChannel textInputChannel, Editable editable) {
        super(view, true);
        this.mFlutterView = view;
        this.mClient = client;
        this.textInputChannel = textInputChannel;
        this.mEditable = editable;
        this.mBatchCount = 0;
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
    }

    private void updateEditingState() {
        if (this.mBatchCount > 0) {
            return;
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int composingStart = BaseInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int composingEnd = BaseInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        this.mImm.updateSelection(this.mFlutterView, selectionStart, selectionEnd, composingStart, composingEnd);
        this.textInputChannel.updateEditingState(this.mClient, this.mEditable.toString(), selectionStart, selectionEnd, composingStart, composingEnd);
    }

    public Editable getEditable() {
        return this.mEditable;
    }

    public boolean beginBatchEdit() {
        ++this.mBatchCount;
        return super.beginBatchEdit();
    }

    public boolean endBatchEdit() {
        boolean result = super.endBatchEdit();
        --this.mBatchCount;
        this.updateEditingState();
        return result;
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        boolean result = super.commitText(text, newCursorPosition);
        this.updateEditingState();
        return result;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        if (Selection.getSelectionStart((CharSequence)this.mEditable) == -1) {
            return true;
        }
        boolean result = super.deleteSurroundingText(beforeLength, afterLength);
        this.updateEditingState();
        return result;
    }

    public boolean setComposingRegion(int start, int end) {
        boolean result = super.setComposingRegion(start, end);
        this.updateEditingState();
        return result;
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        boolean result = text.length() == 0 ? super.commitText(text, newCursorPosition) : super.setComposingText(text, newCursorPosition);
        this.updateEditingState();
        return result;
    }

    public boolean setSelection(int start, int end) {
        boolean result = super.setSelection(start, end);
        this.updateEditingState();
        return result;
    }

    public boolean sendKeyEvent(KeyEvent event) {
        if (event.getAction() == 0) {
            if (event.getKeyCode() == 67) {
                int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                int selEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
                if (selEnd > selStart) {
                    Selection.setSelection((Spannable)this.mEditable, (int)selStart);
                    this.mEditable.delete(selStart, selEnd);
                    this.updateEditingState();
                    return true;
                }
                if (selStart > 0) {
                    int newSel = Math.max(selStart - 1, 0);
                    Selection.setSelection((Spannable)this.mEditable, (int)newSel);
                    this.mEditable.delete(newSel, selStart);
                    this.updateEditingState();
                    return true;
                }
            } else {
                if (event.getKeyCode() == 21) {
                    int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                    int newSel = Math.max(selStart - 1, 0);
                    this.setSelection(newSel, newSel);
                    return true;
                }
                if (event.getKeyCode() == 22) {
                    int selStart = Selection.getSelectionStart((CharSequence)this.mEditable);
                    int newSel = Math.min(selStart + 1, this.mEditable.length());
                    this.setSelection(newSel, newSel);
                    return true;
                }
                int character = event.getUnicodeChar();
                if (character != 0) {
                    int selStart = Math.max(0, Selection.getSelectionStart((CharSequence)this.mEditable));
                    int selEnd = Math.max(0, Selection.getSelectionEnd((CharSequence)this.mEditable));
                    if (selEnd != selStart) {
                        this.mEditable.delete(selStart, selEnd);
                    }
                    this.mEditable.insert(selStart, (CharSequence)String.valueOf((char)character));
                    this.setSelection(selStart + 1, selStart + 1);
                    this.updateEditingState();
                }
                return true;
            }
        }
        return false;
    }

    public boolean performEditorAction(int actionCode) {
        switch (actionCode) {
            case 1: {
                this.textInputChannel.newline(this.mClient);
                break;
            }
            case 0: {
                this.textInputChannel.unspecifiedAction(this.mClient);
                break;
            }
            case 2: {
                this.textInputChannel.go(this.mClient);
                break;
            }
            case 3: {
                this.textInputChannel.search(this.mClient);
                break;
            }
            case 4: {
                this.textInputChannel.send(this.mClient);
                break;
            }
            case 5: {
                this.textInputChannel.next(this.mClient);
                break;
            }
            case 7: {
                this.textInputChannel.previous(this.mClient);
                break;
            }
            default: {
                this.textInputChannel.done(this.mClient);
            }
        }
        return true;
    }
}

