/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.editing.InputConnectionAdaptor;

public class TextInputPlugin {
    @NonNull
    private final View mView;
    @NonNull
    private final InputMethodManager mImm;
    @NonNull
    private final TextInputChannel textInputChannel;
    private int mClient = 0;
    @Nullable
    private TextInputChannel.Configuration configuration;
    @Nullable
    private Editable mEditable;
    private boolean mRestartInputPending;
    @Nullable
    private InputConnection lastInputConnection;

    public TextInputPlugin(View view, @NonNull DartExecutor dartExecutor) {
        this.mView = view;
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.textInputChannel = new TextInputChannel(dartExecutor);
        this.textInputChannel.setTextInputMethodHandler(new TextInputChannel.TextInputMethodHandler(){

            @Override
            public void show() {
                TextInputPlugin.this.showTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void hide() {
                TextInputPlugin.this.hideTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void setClient(int textInputClientId, TextInputChannel.Configuration configuration) {
                TextInputPlugin.this.setTextInputClient(textInputClientId, configuration);
            }

            @Override
            public void setEditingState(TextInputChannel.TextEditState editingState) {
                TextInputPlugin.this.setTextInputEditingState(TextInputPlugin.this.mView, editingState);
            }

            @Override
            public void clearClient() {
                TextInputPlugin.this.clearTextInputClient();
            }
        });
    }

    @NonNull
    public InputMethodManager getInputMethodManager() {
        return this.mImm;
    }

    private static int inputTypeFromTextInputType(TextInputChannel.InputType type, boolean obscureText, boolean autocorrect, TextInputChannel.TextCapitalization textCapitalization) {
        if (type.type == TextInputChannel.TextInputType.DATETIME) {
            return 4;
        }
        if (type.type == TextInputChannel.TextInputType.NUMBER) {
            int textType = 2;
            if (type.isSigned) {
                textType |= 0x1000;
            }
            if (type.isDecimal) {
                textType |= 0x2000;
            }
            return textType;
        }
        if (type.type == TextInputChannel.TextInputType.PHONE) {
            return 3;
        }
        int textType = 1;
        if (type.type == TextInputChannel.TextInputType.MULTILINE) {
            textType |= 0x20000;
        } else if (type.type == TextInputChannel.TextInputType.EMAIL_ADDRESS) {
            textType |= 0x20;
        } else if (type.type == TextInputChannel.TextInputType.URL) {
            textType |= 0x10;
        }
        if (obscureText) {
            textType |= 0x80000;
            textType |= 0x80;
        } else if (autocorrect) {
            textType |= 0x8000;
        }
        if (textCapitalization == TextInputChannel.TextCapitalization.CHARACTERS) {
            textType |= 0x1000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.WORDS) {
            textType |= 0x2000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.SENTENCES) {
            textType |= 0x4000;
        }
        return textType;
    }

    public InputConnection createInputConnection(View view, EditorInfo outAttrs) {
        if (this.mClient == 0) {
            this.lastInputConnection = null;
            return this.lastInputConnection;
        }
        outAttrs.inputType = TextInputPlugin.inputTypeFromTextInputType(this.configuration.inputType, this.configuration.obscureText, this.configuration.autocorrect, this.configuration.textCapitalization);
        outAttrs.imeOptions = 0x2000000;
        int enterAction = this.configuration.inputAction == null ? ((0x20000 & outAttrs.inputType) != 0 ? 1 : 6) : this.configuration.inputAction;
        if (this.configuration.actionLabel != null) {
            outAttrs.actionLabel = this.configuration.actionLabel;
            outAttrs.actionId = enterAction;
        }
        outAttrs.imeOptions |= enterAction;
        InputConnectionAdaptor connection = new InputConnectionAdaptor(view, this.mClient, this.textInputChannel, this.mEditable);
        outAttrs.initialSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        outAttrs.initialSelEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        this.lastInputConnection = connection;
        return this.lastInputConnection;
    }

    @Nullable
    public InputConnection getLastInputConnection() {
        return this.lastInputConnection;
    }

    private void showTextInput(View view) {
        view.requestFocus();
        this.mImm.showSoftInput(view, 0);
    }

    private void hideTextInput(View view) {
        this.mImm.hideSoftInputFromWindow(view.getApplicationWindowToken(), 0);
    }

    private void setTextInputClient(int client, TextInputChannel.Configuration configuration) {
        this.mClient = client;
        this.configuration = configuration;
        this.mEditable = Editable.Factory.getInstance().newEditable((CharSequence)"");
        this.mRestartInputPending = true;
    }

    private void applyStateToSelection(TextInputChannel.TextEditState state) {
        int selStart = state.selectionStart;
        int selEnd = state.selectionEnd;
        if (selStart >= 0 && selStart <= this.mEditable.length() && selEnd >= 0 && selEnd <= this.mEditable.length()) {
            Selection.setSelection((Spannable)this.mEditable, (int)selStart, (int)selEnd);
        } else {
            Selection.removeSelection((Spannable)this.mEditable);
        }
    }

    private void setTextInputEditingState(View view, TextInputChannel.TextEditState state) {
        if (!this.mRestartInputPending && state.text.equals(this.mEditable.toString())) {
            this.applyStateToSelection(state);
            this.mImm.updateSelection(this.mView, Math.max(Selection.getSelectionStart((CharSequence)this.mEditable), 0), Math.max(Selection.getSelectionEnd((CharSequence)this.mEditable), 0), BaseInputConnection.getComposingSpanStart((Spannable)this.mEditable), BaseInputConnection.getComposingSpanEnd((Spannable)this.mEditable));
        } else {
            this.mEditable.replace(0, this.mEditable.length(), (CharSequence)state.text);
            this.applyStateToSelection(state);
            this.mImm.restartInput(view);
            this.mRestartInputPending = false;
        }
    }

    private void clearTextInputClient() {
        this.mClient = 0;
    }
}

